                  @   s   e Zd ZdZdZdd Zedd Zedd Zed	d
 Z	edd Z
ed
d Zedd Zedd Z
edd Zedd Zedd Zedd Zedd ZdS )rE   z/Represent and manipulate single IPv6 Addresses.r  c                 C   sx   t |tr| | || _dS t |trL| |d t|}t|d| _dS t|}d|krht	d| | 
|| _dS )a  Instantiate a new IPv6 address object.

        Args:
            address: A string or integer representing the IP

              Additionally, an integer can be passed, so
              IPv6Address('2001:db8::') ==
                IPv6Address(42540766411282592856903984951653826560)
              or, more generally
              IPv6Address(int(IPv6Address('2001:db8::'))) ==
                IPv6Address('2001:db8::')

        Raises:
            AddressValueError: If address isn't a valid IPv6 address.

        Nr   r   rV   r  r  r  r   r   r   r     s    


zIPv6Address.__init__c                 C   s
   t | jS r  )rU   r^   r   r   r   r   r    s    zIPv6Address.packedc                 C   s   | | j jkS r   r  r   r   r   r   r     s    	zIPv6Address.is_multicastc                    s   t  fdd jjD S )r   c                 3   s   | ]} |kV  qd S r   r   r	  r   r   r   r    s     z*IPv6Address.is_reserved.<locals>.<genexpr>)r  r  _reserved_networksr   r   r   r   r     s    	zIPv6Address.is_reservedc                 C   s   | | j jkS r   r"  r   r   r   r   r     s    zIPv6Address.is_link_localc                 C   s   | | j jkS a`  Test if the address is reserved for site-local.

        Note that the site-local address space has been deprecated by RFC 3879.
        Use is_private to test if this address is in the space of unique local
        addresses as defined by RFC 4193.

        Returns:
            A boolean, True if the address is reserved per RFC 3513 2.5.6.

        )r  _sitelocal_networkr   r   r   r   
is_site_local  s    zIPv6Address.is_site_localc                    s   t  fdd jjD S )zTest if this address is allocated for private networks.

        Returns:
            A boolean, True if the address is reserved per
            iana-ipv6-special-registry.

        c                 3   s   | ]} |kV  qd S r   r   r  r   r   r   r  3  s     z)IPv6Address.is_private.<locals>.<genexpr>r  r   r   r   r   r   *  s    	zIPv6Address.is_privatec                 C   s   | j  S )zTest if this address is allocated for public networks.

        Returns:
            A boolean, true if the address is not reserved per
            iana-ipv6-special-registry.

        r   r   r   r   r   r   5  s    	zIPv6Address.is_globalc                 C   s
   | j dkS )r   r   r   r   r   r   r   r   @  s    	zIPv6Address.is_unspecifiedc                 C   s
   | j dkS )r   r&   r   r   r   r   r   r   K  s    	zIPv6Address.is_loopbackc                 C   s    | j d? dkrdS t| j d@ S )zReturn the IPv4 mapped address.

        Returns:
            If the IPv6 address is a v4 mapped address, return the
            IPv4 mapped address. Return None otherwise.

        r?   r5  N    r^   rD   r   r   r   r   ipv4_mappedV  s    	zIPv6Address.ipv4_mappedc                 C   s4   | j d? dkrdS t| j d? d@ t| j  d@ fS )zTuple of embedded teredo IPs.

        Returns:
            Tuple of the (server, client) IPs or None if the address
            doesn't appear to be a teredo address (doesn't start with
            2001::/32)

        `   i   Nr   rG  rH  r   r   r   r   teredoc  s
    
zIPv6Address.teredoc                 C   s$   | j d? dkrdS t| j d? d@ S )zReturn the IPv4 6to4 embedded address.

        Returns:
            The IPv4 6to4-embedded address if present or None if the
            address doesn't appear to contain a 6to4 embedded address.

        p   i   NP   rG  rH  r   r   r   r   	sixtofourr  s    	zIPv6Address.sixtofourN)r;   r<   r=   rB   r>   r   r   r  r   r   r   rF  r   r   r   r   rI  rK  rN  r   r   r   r   rE     s6   %





	











rE   c                   @   s   e Zd Zdd Zdd Zdd Zdd Zd	d
 Zej	Z	e
dd Ze
d
d Ze
dd Z
e
dd Ze
dd Ze
dd ZdS )rP   c                 C   s   t |ttfr2t| | t| j| _| j| _	d S t |t
rt| |d  t|dkrht|d | _	n| j| _	t|dd| _| jj
| _
| jj| _d S t|}t| |d  t|dd| _| jj
| _
| jj	| _	| jj| _d S r$  )r   rF   r   rE   r   rL   r^   r   rm   r}   r%  rY   r   r   r   r[   r&  r   r   r   r     s(    




zIPv6Interface.__init__c                 C   s   d|  | j| jjf S r   r'  r   r   r   r   r     s    zIPv6Interface.__str__c                 C   sF   t | |}|r|tkr|S z| j|jkW S  tk
r@   Y dS X d S r   )rE   r0   r1   r   r~   r(  r   r   r   r0     s    zIPv6Interface.__eq__c                 C   sR   t | |}|tkrtS z| j|jk p4| j|jko4|W S  tk
rL   Y dS X d S r   )rE   r4   r1   r   r~   r)  r   r   r   r4     s    zIPv6Interface.__lt__c                 C   s   | j | jA t| jjA S r   r*  r   r   r   r   r     s    zIPv6Interface.__hash__c                 C   s
   t | jS r   )rE   r^   r   r   r   r   rc     s    zIPv6Interface.ipc                 C   s   d|  | j| jf S r   r+  r   r   r   r   r     s    zIPv6Interface.with_prefixlenc                 C   s   d|  | j| jf S r   r,  r   r   r   r   r     s    zIPv6Interface.with_netmaskc                 C   s   d|  | j| jf S r   r-  r   r   r   r   r     s    zIPv6Interface.with_hostmaskc                 C   s   | j dko| jjS r#   )r^   r   r   r   r   r   r   r     s    zIPv6Interface.is_unspecifiedc                 C   s   | j dko| jjS r   )r^   r   r   r   r   r   r   r     s    zIPv6Interface.is_loopbackN)r;   r<   r=   r   r   r0   r4   r   r   r   r   rc   r   r   r   r   r   r   r   r   r   rP     s$   




rP   c                   @   s2   e Zd ZdZeZd
ddZdd Zedd Z	d	S )rL   av  This class represents and manipulates 128-bit IPv6 networks.

    Attributes: [examples for IPv6('2001:db8::1000/124')]
        .network_address: IPv6Address('2001:db8::1000')
        .hostmask: IPv6Address('::f')
        .broadcast_address: IPv6Address('2001:db8::100f')
        .netmask: IPv6Address('ffff:ffff:ffff:ffff:ffff:ffff:ffff:fff0')
        .prefixlen: 124

    Tc                 C   s|  t | | t|ttfr<t|| _| | j\| _	| _
dS t|trt|dkr\|d }n| j}| |\| _	| _
t|d | _t
| j}|t
| j	@ |kr|rtd|  nt|t
| j	@ | _dS t|}t| |d | _t|dkr|d }n| j}| |\| _	| _
|rDtt
| jt
| j	@ | jkrDtd|  tt
| jt
| j	@ | _| j
| jd krx| j| _dS )a  Instantiate a new IPv6 Network object.

        Args:
            address: A string or integer representing the IPv6 network or the
              IP and prefix/netmask.
              '2001:db8::/128'
              '2001:db8:0000:0000:0000:0000:0000:0000/128'
              '2001:db8::'
              are all functionally the same in IPv6.  That is to say,
              failing to provide a subnetmask will create an object with
              a mask of /128.

              Additionally, an integer can be passed, so
              IPv6Network('2001:db8::') ==
                IPv6Network(42540766411282592856903984951653826560)
              or, more generally
              IPv6Network(int(IPv6Network('2001:db8::'))) ==
                IPv6Network('2001:db8::')

            strict: A boolean. If true, ensure that we have been passed
              A true network address, eg, 2001:db8::1000/124 and not an
              IP address on a network, eg, 2001:db8::1/124.

        Raises:
            AddressValueError: If address isn't a valid IPv6 address.
            NetmaskValueError: If the netmask isn't valid for
              an IPv6 address.
            ValueError: If strict was True and a network address was not
              supplied.

        Nr&   r   r.  r   )r   r   r   rF   r   rE   r   r   rm   r   r}   r%  rY   r   rG   r[   r   r   r   r/  r   r   r   r     sJ     





zIPv6Network.__init__c                 c   s<   t | j}t | j}t|d |d D ]}| |V  q&dS )zGenerate Iterator over usable hosts in a network.

          This is like __iter__ except it doesn't return the
          Subnet-Router anycast address.

        r&   Nr   r   r   r   r   r   6	  s    

zIPv6Network.hostsc                 C   s   | j jo| jjS rD  )r   rF  rx   r   r   r   r   rF  B	  s    zIPv6Network.is_site_localN)T)
r;   r<   r=   rB   rE   r   r   r   r   rF  r   r   r   r   rL     s   
OrL   c                   @   s   e Zd ZedZedZededededededed	ed
ededg
Zeded
edededededededededededededgZedZdS )_IPv6Constantsz	fe80::/10zff00::/8z::1/128z::/128z
::ffff:0:0/96z100::/64z	2001::/23z2001:2::/48z
2001:db8::/32z2001:10::/28zfc00::/7z::/8z100::/8z200::/7z400::/6z800::/5z1000::/4z4000::/3z6000::/3z8000::/3zA000::/3zC000::/3zE000::/4zF000::/5zF800::/6zFE00::/9z	fec0::/10N)	r;   r<   r=   rL   r#  r  r  rC  rE  r   r   r   r   rO  R	  s<          rO  )r&   )T)8rB   Z
__future__r   r$   r	   __version__r   r   Zlong	NameErrorZunicoderW   strrF   r   r   
from_bytesr   r~   r   hasattrr"   r*   objectr+   r  rB  rG   r@   rC   rJ   rN   rQ   rT   rU   r[   rd   rg   rp   rz   r   r   r   rj   r   r   rD   rO   rK   r1  r  r2  rE   rP   rL   rO  r   r   r   r   <module>   s   

	


)$
$#716 =   X *vSr    5W{!PK       ! 3<  <  ,  __pycache__/contextlib2.cpython-38.opt-1.pycnu [        U

    .eB                  	   @   s  d Z ddlZddlZddlZddlmZ ddlmZ ddddd	d
ddd
g	Zedg7 Zej	dd dkrnej
Znede
fddiZdd Zdd ZG dd deZG dd	 d	e
ZG dd deZdd ZG dd de
ZG dd de
ZG d d deZG d!d deZG d"d
 d
e
Zej	d d#kZer@d$d% Zd&d' Znd(d% Zd)d' Zzdd*lmZ W n ek
rz   eZ Y n
X d+d, Z G d-d
 d
e
Z!G d.d de!Z"G d/d deZ#dS )0zAcontextlib2 - backports and enhancements to the contextlib module    N)dequewrapscontextmanagerclosingnullcontextAbstractContextManagerContextDecorator	ExitStackredirect_stdoutredirect_stderrsuppressContextStack   )      ABC	__slots__ c                 C   s0   | |krd S | |  | jD ]}t|| q|S N)append	__bases___classic_mro)CresultBr   r   ;/usr/lib/python3.8/site-packages/pip/_vendor/contextlib2.pyr      s    

r   c                 G   sv   z
| j }W n" tk
r,   tt| g }Y nX |D ]>}|D ],}||jkr:|j| d krbt    S  q2q:t  S q2dS )NT)__mro__AttributeErrortupler   __dict__NotImplemented)r   methodsmromethodr   r   r   r   _check_methods$   s    


r%   c                   @   s2   e Zd ZdZdd Zejdd Zedd Z	dS )	r   z,An abstract base class for context managers.c                 C   s   | S )z0Return `self` upon entering the runtime context.r   selfr   r   r   	__enter__8   s    z AbstractContextManager.__enter__c                 C   s   dS )z9Raise any exception triggered within the runtime context.Nr   )r'   exc_type	exc_value	tracebackr   r   r   __exit__<   s    zAbstractContextManager.__exit__c                 C   s   | t krt|ddS tS )z<Check whether subclass is considered a subclass of this ABC.r(   r,   )r   r%   r!   )clsr   r   r   r   __subclasshook__A   s    z'AbstractContextManager.__subclasshook__N)
__name__
__module____qualname____doc__r(   abcabstractmethodr,   classmethodr.   r   r   r   r   r   5   s   
c                   @   s(   e Zd ZdZdd Zdd Zdd ZdS )	r	   zJA base class or mixin that enables context managers to work as decorators.c                 C   s   t dt |  S )a  Returns the context manager used to actually wrap the call to the
        decorated function.

        The default implementation just returns *self*.

        Overriding this method allows otherwise one-shot context managers
        like _GeneratorContextManager to support use as decorators via
        implicit recreation.

        DEPRECATED: refresh_cm was never added to the standard library's
                    ContextDecorator API
        z2refresh_cm was never added to the standard library)warningswarnDeprecationWarning_recreate_cmr&   r   r   r   
refresh_cmL   s    
zContextDecorator.refresh_cmc                 C   s   | S )a6  Return a recreated instance of self.

        Allows an otherwise one-shot context manager like
        _GeneratorContextManager to support use as
        a decorator via implicit recreation.

        This is a private interface just for _GeneratorContextManager.
        See issue #11647 for details.
        r   r&   r   r   r   r9   ]   s    
zContextDecorator._recreate_cmc                    s   t   fdd}|S )Nc               
      s*       | |W  5 Q R  S Q R X d S r   )r9   argskwdsfuncr'   r   r   innerj   s    
z(ContextDecorator.__call__.<locals>.innerr   )r'   r?   r@   r   r>   r   __call__i   s    zContextDecorator.__call__N)r/   r0   r1   r2   r:   r9   rA   r   r   r   r   r	   I   s   c                   @   s0   e Zd ZdZdd Zdd Zdd Zdd	 Zd
S )_GeneratorContextManagerz%Helper for @contextmanager decorator.c                 C   sJ   |||| _ |||  | _| _| _t|dd }|d kr@t| j}|| _d S )Nr2   )genr?   r<   r=   getattrtyper2   )r'   r?   r<   r=   docr   r   r   __init__t   s    
z!_GeneratorContextManager.__init__c                 C   s   |  | j| j| jS r   )	__class__r?   r<   r=   r&   r   r   r   r9      s    z%_GeneratorContextManager._recreate_cmc                 C   s.   zt | jW S  tk
r(   tdY nX d S )Nzgenerator didn't yield)nextrC   
StopIterationRuntimeErrorr&   r   r   r   r(      s    z"_GeneratorContextManager.__enter__c              
   C   s   |d kr8zt | j W n tk
r,   Y d S X tdn|d krF| }z| j||| tdW n tk
r } z||k	 W Y S d }~X Y nj tk
r } z0||krW Y "dS tr|j|krW Y 
dS  W 5 d }~X Y n   t d |k	r Y nX d S )Nzgenerator didn't stopz#generator didn't stop after throw()F   )	rI   rC   rJ   rK   throw_HAVE_EXCEPTION_CHAINING	__cause__sysexc_info)r'   rE   valuer+   excr   r   r   r,      s,    


z!_GeneratorContextManager.__exit__N)r/   r0   r1   r2   rG   r9   r(   r,   r   r   r   r   rB   q   s
   rB   c                    s   t   fdd}|S )a  @contextmanager decorator.

    Typical usage:

        @contextmanager
        def some_generator(<arguments>):
            <setup>
            try:
                yield <value>
            finally:
                <cleanup>

    This makes this:

        with some_generator(<arguments>) as <variable>:
            <body>

    equivalent to this:

        <setup>
        try:
            <variable> = <value>
            <body>
        finally:
            <cleanup>

    c                     s   t  | |S r   )rB   r;   r?   r   r   helper   s    zcontextmanager.<locals>.helperr   )r?   rU   r   rT   r   r      s    c                   @   s(   e Zd ZdZdd Zdd Zdd ZdS )	r   a2  Context to automatically close something at the end of a block.

    Code like this:

        with closing(<module>.open(<arguments>)) as f:
            <block>

    is equivalent to this:

        f = <module>.open(<arguments>)
        try:
            <block>
        finally:
            f.close()

    c                 C   s
   || _ d S r   thing)r'   rW   r   r   r   rG      s    zclosing.__init__c                 C   s   | j S r   rV   r&   r   r   r   r(      s    zclosing.__enter__c                 G   s   | j   d S r   )rW   close)r'   rQ   r   r   r   r,      s    zclosing.__exit__Nr/   r0   r1   r2   rG   r(   r,   r   r   r   r   r      s   c                   @   s(   e Zd ZdZdd Zdd Zdd ZdS )_RedirectStreamNc                 C   s   || _ g | _d S r   )_new_target_old_targets)r'   
new_targetr   r   r   rG      s    z_RedirectStream.__init__c                 C   s*   | j tt| j tt| j| j | jS r   )r\   r   rD   rP   _streamsetattrr[   r&   r   r   r   r(      s    z_RedirectStream.__enter__c                 C   s   t t| j| j  d S r   )r_   rP   r^   r\   popr'   exctypeexcinstexctbr   r   r   r,     s    z_RedirectStream.__exit__)r/   r0   r1   r^   rG   r(   r,   r   r   r   r   rZ      s   rZ   c                   @   s   e Zd ZdZdZdS )r   aA  Context manager for temporarily redirecting stdout to another file.

        # How to send help() to stderr
        with redirect_stdout(sys.stderr):
            help(dir)

        # How to write help() to a file
        with open('help.txt', 'w') as f:
            with redirect_stdout(f):
                help(pow)
    stdoutNr/   r0   r1   r2   r^   r   r   r   r   r     s   c                   @   s   e Zd ZdZdZdS )r   zCContext manager for temporarily redirecting stderr to another file.stderrNrf   r   r   r   r   r     s   c                   @   s(   e Zd ZdZdd Zdd Zdd ZdS )	r
   a?  Context manager to suppress specified exceptions

    After the exception is suppressed, execution proceeds with the next
    statement following the with statement.

         with suppress(FileNotFoundError):
             os.remove(somefile)
         # Execution still resumes here if the file was already removed
    c                 G   s
   || _ d S r   )_exceptions)r'   
exceptionsr   r   r   rG   )  s    zsuppress.__init__c                 C   s   d S r   r   r&   r   r   r   r(   ,  s    zsuppress.__enter__c                 C   s   |d k	ot || jS r   )
issubclassrh   ra   r   r   r   r,   /  s    
zsuppress.__exit__NrY   r   r   r   r   r
     s   
r   c                    s    fdd}|S )Nc                    s4   | j }||krd S |d ks*| kr$q*|} q || _ d S r   )__context__)new_excold_excexc_context	frame_excr   r   _fix_exception_context@  s    z3_make_context_fixer.<locals>._fix_exception_contextr   )rp   rq   r   ro   r   _make_context_fixer?  s    
rr   c                 C   s<   z| d j }| d W n  tk
r6   || d _  Y nX d S )NrL   )rk   
BaseException)exc_details	fixed_ctxr   r   r   _reraise_with_existing_contextO  s    

rv   c                 C   s   dd S )Nc                 S   s   d S r   r   )rl   rm   r   r   r   <lambda>[      z%_make_context_fixer.<locals>.<lambda>r   ro   r   r   r   rr   Z  s    c                 C   s   | \}}}t d d S )Nz!raise exc_type, exc_value, exc_tb)exec)rt   r)   r*   Zexc_tbr   r   r   rv   _  s    
)InstanceTypec                 C   s   t | }|tkr| jS |S r   )rE   rz   rH   )objZobj_typer   r   r   	_get_typek  s    r|   c                   @   sX   e Zd ZdZdd Zdd Zdd Zdd	 Zd
d Zdd
 Z	dd Z
dd Zdd ZdS )r
   a  Context manager for dynamic management of a stack of exit callbacks

    For example:

        with ExitStack() as stack:
            files = [stack.enter_context(open(fname)) for fname in filenames]
            # All opened files will automatically be closed at the end of
            # the with statement, even if attempts to open files later
            # in the list raise an exception

    c                 C   s   t  | _d S r   )r   _exit_callbacksr&   r   r   r   rG     s    zExitStack.__init__c                 C   s   t |  }| j|_t | _|S )z?Preserve the context stack by transferring it to a new instance)rE   r}   r   )r'   	new_stackr   r   r   pop_all  s    
zExitStack.pop_allc                    s"    fdd} |_ | | dS )z:Helper to correctly register callbacks to __exit__ methodsc                     s    f|  S r   r   )rt   cmcm_exitr   r   
_exit_wrapper  s    z.ExitStack._push_cm_exit.<locals>._exit_wrapperN)__self__push)r'   r   r   r   r   r   r   
_push_cm_exit  s    zExitStack._push_cm_exitc                 C   sD   t |}z
|j}W n  tk
r2   | j| Y nX | || |S )a  Registers a callback with the standard __exit__ method signature

        Can suppress exceptions the same way __exit__ methods can.

        Also accepts any object with an __exit__ method (registering a call
        to the method instead of the object itself)
        )r|   r,   r   r}   r   r   )r'   exit_cb_typeexit_methodr   r   r   r     s    

zExitStack.pushc                    s$    fdd}|_ | | S )z\Registers an arbitrary callback and arguments.

        Cannot suppress exceptions.
        c                    s     d S r   r   )r)   rS   tbr<   callbackr=   r   r   r     s    z)ExitStack.callback.<locals>._exit_wrapper)__wrapped__r   )r'   r   r<   r=   r   r   r   r   r     s    
zExitStack.callbackc                 C   s(   t |}|j}||}| || |S )zEnters the supplied context manager

        If successful, also pushes its __exit__ method as a callback and
        returns the result of the __enter__ method.
        )r|   r,   r(   r   )r'   r   _cm_type_exitr   r   r   r   
enter_context  s
    
zExitStack.enter_contextc                 C   s   |  ddd dS )z$Immediately unwind the context stackN)r,   r&   r   r   r   rX     s    zExitStack.closec                 C   s   | S r   r   r&   r   r   r   r(     s    zExitStack.__enter__c           	      G   s   |d d k	}t  d }t|}d}d}| jr| j }z|| rNd}d}d}W q(   t  }||d |d  d}|}Y q(X q(|rt| |o|S )Nr   rL   FT)NNN)rP   rQ   rr   r}   r`   rv   )	r'   rt   received_excrp   rq   suppressed_exc
pending_raisecbnew_exc_detailsr   r   r   r,     s(    
zExitStack.__exit__N)
r/   r0   r1   r2   rG   r   r   r   r   r   rX   r(   r,   r   r   r   r   r
   s  s   

c                       s8   e Zd ZdZ fddZdd Zdd Zdd	 Z  ZS )
r   z+Backwards compatibility alias for ExitStackc                    s   t dt tt|   d S )Nz*ContextStack has been renamed to ExitStack)r6   r7   r8   superr   rG   r&   rH   r   r   rG     s    zContextStack.__init__c                 C   s
   |  |S r   )r   )r'   r   r   r   r   
register_exit  s    zContextStack.register_exitc                 O   s   | j |f||S r   )r   )r'   r   r<   r=   r   r   r   register  s    zContextStack.registerc                 C   s   |   S r   )r   r&   r   r   r   preserve  s    zContextStack.preserve)	r/   r0   r1   r2   rG   r   r   r   
__classcell__r   r   r   r   r     s
   c                   @   s*   e Zd ZdZd	ddZdd Zdd ZdS )
r   aM  Context manager that does no additional processing.
    Used as a stand-in for a normal context manager, when a particular
    block of code is only sometimes used with a normal context manager:
    cm = optional_cm if condition else nullcontext()
    with cm:
        # Perform operation, using optional_cm if condition is True
    Nc                 C   s
   || _ d S r   enter_result)r'   r   r   r   r   rG     s    znullcontext.__init__c                 C   s   | j S r   r   r&   r   r   r   r(     s    znullcontext.__enter__c                 G   s   d S r   r   )r'   excinfor   r   r   r,     s    znullcontext.__exit__)NrY   r   r   r   r   r     s   
)$r2   r3   rP   r6   collectionsr   	functoolsr   __all__version_infor   Z_abc_ABCABCMetaobjectr   r%   r   r	   rB   r   r   rZ   r   r   r
   rN   rr   rv   typesrz   ImportErrorrE   r|   r
   r   r   r   r   r   r   <module>   sT      

(H"

qPK       ! F  F  #  __pycache__/retrying.cpython-38.pycnu [        U

    .e&                     @   sl   d dl Z d dlmZ d dlZd dlZd dlZdZdd ZG dd deZ	G dd	 d	eZ
G d
d deZdS )    N)sixi?c                     sB   t  dkr,t d r,dd }| d S  fdd}|S dS )z
    Decorator function that instantiates the Retrying object
    @param *dargs: positional arguments passed to Retrying object
    @param **dkw: keyword arguments passed to the Retrying object
       r   c                    s   t   fdd}|S )Nc                     s   t  j f| |S NRetryingcallargskwf 8/usr/lib/python3.8/site-packages/pip/_vendor/retrying.py	wrapped_f$   s    z-retry.<locals>.wrap_simple.<locals>.wrapped_fr   wrapsr   r   r
   r   r   wrap_simple"   s    zretry.<locals>.wrap_simplec                    s   t   fdd}|S )Nc                     s   t  jf| |S r   r   r   )dargsdkwr   r
   r   r   /   s    z&retry.<locals>.wrap.<locals>.wrapped_fr   r   r   r   r   r   wrap-   s    zretry.<locals>.wrapN)lencallable)r   r   r   r   r
   r   r   retry   s
    r   c                   @   sn   e Zd ZdddZdd Zdd Zd	d
 Zdd Zd
d Zdd Z	dd Z
dd Zdd Zdd Z
dd ZdS )r   NFc                    s  |d krdn|| _ |d krdn|| _|d kr0dn|| _|d krBdn|| _|d krTdn|| _|d krfdn|| _|	d krxdn|	| _|
d krdn|
| _|d krtn|| _	|d krdn|| _
g  |d k	r̈ | j |d k	r | j
 |d k	r|| _n&|d kr
 fdd| _nt| || _dd g|d k	r6| j |d k	sJ|d k	rV| j |d k	sj|	d k	rv| j |
d k	s|d k	r| j |d k	r|| _n&|d krfd	d| _nt| || _|d kr| j| _n|| _|
d kr| j| _n|
| _|| _d S )
N   d     r   r   c                    s   t  fddD S )Nc                 3   s   | ]}| V  qd S r   r
   .0r   ZattemptsZdelayr
   r   	<genexpr>a   s     6Retrying.__init__.<locals>.<lambda>.<locals>.<genexpr>)anyr    )
stop_funcsr    r   <lambda>a       z#Retrying.__init__.<locals>.<lambda>c                  _   s   dS )Nr   r
   )r	   kwargsr
   r
   r   r%   h   r&   c                    s   t  fddD S )Nc                 3   s   | ]}| V  qd S r   r
   r   r    r
   r   r!   y   s     r"   )maxr    )
wait_funcsr    r   r%   y   r&   )_stop_max_attempt_number_stop_max_delay_wait_fixed_wait_random_min_wait_random_max_wait_incrementing_start_wait_incrementing_increment_wait_exponential_multiplierMAX_WAIT_wait_exponential_max_wait_jitter_maxappendstop_after_attemptstop_after_delaystopgetattrfixed_sleeprandom_sleepincrementing_sleepexponential_sleepwait
always_reject_retry_on_exceptionnever_reject_retry_on_result_wrap_exception)selfr8   r>   Zstop_max_attempt_numberZstop_max_delayZ
wait_fixedZwait_random_minZwait_random_maxZwait_incrementing_startZwait_incrementing_incrementZwait_exponential_multiplierZwait_exponential_maxZretry_on_exceptionZretry_on_resultwrap_exceptionZ	stop_funcZ	wait_funcZwait_jitter_maxr
   )r$   r)   r   __init__:   sR    








zRetrying.__init__c                 C   s
   || j kS )z;Stop after the previous attempt >= stop_max_attempt_number.)r*   rD   previous_attempt_numberdelay_since_first_attempt_msr
   r
   r   r6      s    zRetrying.stop_after_attemptc                 C   s
   || j kS )z=Stop after the time from the first attempt >= stop_max_delay.)r+   rG   r
   r
   r   r7      s    zRetrying.stop_after_delayc                 C   s   dS )z#Don't sleep at all before retrying.r   r
   rG   r
   r
   r   no_sleep   s    zRetrying.no_sleepc                 C   s   | j S )z0Sleep a fixed amount of time between each retry.)r,   rG   r
   r
   r   r:      s    zRetrying.fixed_sleepc                 C   s   t | j| jS )zISleep a random amount of time between wait_random_min and wait_random_max)randomZrandintr-   r.   rG   r
   r
   r   r;      s    zRetrying.random_sleepc                 C   s$   | j | j|d   }|dk r d}|S )z
        Sleep an incremental amount of time after each attempt, starting at
        wait_incrementing_start and incrementing by wait_incrementing_increment
        r   r   )r/   r0   )rD   rH   rI   resultr
   r
   r   r<      s    zRetrying.incrementing_sleepc           