k.compare_networksc                 C   s   | j | j| jfS )zNetwork-only key function.

        Returns an object that identifies this address' network and
        netmask. This function is a suitable "key" argument for sorted()
        and list.sort().

        )rz   r}   r   r   r   r   r   r     s    z_BaseNetwork._get_networks_keyr"   Nc           	      c   s   | j | jkr| V  dS |dk	rJ|| j k r0td|dkr@td|| j  }|dk rZtd| j | }|| jkr~td|| f t| j}t| jd }t| jd |? }t|||D ]}| ||f}|V  qdS )a  The subnets which join to make the current subnet.

        In the case that self contains only one IP
        (self._prefixlen == 32 for IPv4 or self._prefixlen == 128
        for IPv6), yield an iterator with just ourself.

        Args:
            prefixlen_diff: An integer, the amount the prefix length
              should be increased by. This should not be set if
              new_prefix is also set.
            new_prefix: The desired new prefix length. This must be a
              larger number (smaller prefix) than the existing prefix.
              This should not be set if prefixlen_diff is also set.

        Returns:
            An iterator of IPv(4|6) objects.

        Raises:
            ValueError: The prefixlen_diff is too small or too large.
                OR
            prefixlen_diff and new_prefix are both set or new_prefix
              is a smaller number than the current prefix (smaller
              number means a larger network)

        Nznew prefix must be longerr"   (cannot set prefixlen_diff and new_prefixr   zprefix length diff must be > 0z0prefix length diff %d is invalid for netblock %s)	r{   rk   rD   r   r}   rv   r   r&   r   )	r*   prefixlen_diff
new_prefix
new_prefixlenr#   r$ 