r0   r-   r   r|   r*   r+   Zaddress_lessr   r   r   r0     s    zIPv4Interface.__lt__c                 C   s   | j | jA t| jjA S r   r\   r{   r   r   r}   r   r   r   r   r     s    zIPv4Interface.__hash__c                 C   s
   t | jS r   )r@   r\   r   r   r   r   ra     s    zIPv4Interface.ipc                 C   s   d|  | j| jf S r   r   r\   r{   r   r   r   r   r   
  s    zIPv4Interface.with_prefixlenc                 C   s   d|  | j| jf S r   r   r\   r   r   r   r   r   r     s    zIPv4Interface.with_netmaskc                 C   s   d|  | j| jf S r   r   r\   r   r   r   r   r   r     s    zIPv4Interface.with_hostmaskN)r7   r8   r9   r   r   r,   r0   r   r   r   r   ra   r   r   r   r   r   r   r   rL     s   


rL   c                   @   s*   e Zd ZdZeZdddZedd ZdS )	rH   ae  This class represents and manipulates 32-bit IPv4 network + addresses..

    Attributes: [examples for IPv4Network('192.0.2.0/27')]
        .network_address: IPv4Address('192.0.2.0')
        .hostmask: IPv4Address('0.0.0.31')
        .broadcast_address: IPv4Address('192.0.2.32')
        .netmask: IPv4Address('255.255.255.224')
        .prefixlen: 27

    Tc                 C   s|  t | | t|ttfr<t|| _| | j\| _	| _
dS t|trt|dkr\|d }n| j}t|d | _| |\| _	| _
t
| j}|t
| j	@ |kr|rtd|  nt|t
| j	@ | _dS t|}t| |d | _t|dkr|d }n| j}| |\| _	| _
|rDtt
| jt
| j	@ | jkrDtd|  tt
| jt
| j	@ | _| j
| jd krx| j| _dS )a  Instantiate a new IPv4 network object.

        Args:
            address: A string or integer representing the IP [& network].
              '192.0.2.0/24'
              '192.0.2.0/255.255.255.0'
              '192.0.0.2/0.0.0.255'
              are all functionally the same in IPv4. Similarly,
              '192.0.2.1'
              '192.0.2.1/255.255.255.255'
              '192.0.2.1/32'
              are also functionally equivalent. That is to say, failing to
              provide a subnetmask will create an object with a mask of /32.

              If the mask (portion after the / in the argument) is given in
              dotted quad form, it is treated as a netmask if it starts with a
              non-zero field (e.g. /255.0.0.0 == /8) and as a hostmask if it
              starts with a zero field (e.g. 0.255.255.255 == /8), with the
              single exception of an all-zero mask which is treated as a
              netmask == /0. If no mask is given, a default of /32 is used.

              Additionally, an integer can be passed, so
              IPv4Network('192.0.2.1') == IPv4Network(3221225985)
              or, more generally
              IPv4Interface(int(IPv4Interface('192.0.2.1'))) ==
                IPv4Interface('192.0.2.1')

        Raises:
            AddressValueError: If ipaddress isn't a valid IPv4 address.
            NetmaskValueError: If the netmask isn't valid for
              an IPv4 address.
            ValueError: If strict is True and a network address is not
              supplied.

        Nr"   r   %s has host bits setr   )r   r   rB   r   rC   r@   r}   r   rk   r   r{   r%  rW   r   rD   rY   r   r   r   r*   rF   rJ   r   r  rX   r   r   r   r   )  sJ    %





zIPv4Network.__init__c                 C   s&   | j tdko| jtdk o$| j S )zTest if this address is allocated for public networks.

        Returns:
            A boolean, True if the address is not reserved per
            iana-ipv4-special-registry.

        
100.64.0.0/10)r}   rH   rv   r   r   r   r   r   r   ~  s
    	zIPv4Network.is_globalN)T)	r7   r8   r9   r>   r@   r   r   r   r   r   r   r   r   rH     s
   
UrH   c                   @   s   e Zd ZedZedZedZedZededededededed	ed
ededed
edededgZedZ	e
dZdS )_IPv4Constantsz169.254.0.0/16z127.0.0.0/8z224.0.0.0/4r0  z	0.0.0.0/8z
10.0.0.0/8z
172.16.0.0/12z192.0.0.0/29z192.0.0.170/31z192.0.2.0/24z192.168.0.0/16z
198.18.0.0/15z198.51.100.0/24z203.0.113.0/24z240.0.0.0/4z255.255.255.255/32z0.0.0.0N)r7   r8   r9   rH   r#  r!  r  r  r  r  r@   r   r   r   r   r   r1    s*   r1  c                   @   s   e Zd ZdZdZdZde d ZdZe	dZ
eZi Ze
dd	 Ze
d
d Ze
dd
 Ze
dd Ze
dddZdd Zdd Zedd Zedd ZdS )_BaseV6zyBase IPv6 object.

    The following methods are used by IPv6 objects in both single IP
    addresses and networks.

    r   rg   r   r"   r   Z0123456789ABCDEFabcdefc                 C   sJ   || j kr@t|tr|}n
| |}t| |}||f| j |< | j | S r   )r   rB   r   r   rA   r   r   r   r   r   r     s    	


z_BaseV6._make_netmaskc              
   C   s  |st d|d}d}t||k r:d||f }t |d|d krzt| j}W n2 t k
r } zt d||f W 5 d}~X Y nX |d	|d
? d@   |d	|d@   | jd }t||krd
|d |f }t |d}tdt|d D ]*}	||	 s|dk	rd| }t ||	}q|dk	r|}
t|| d }|d sj|
d8 }
|
rjd}t || |d s|d8 }|rd}t || | j|
|  }|dk r0d}t || jd |f njt|| jkrd}t || j|f |d sd}t || |d s d}t || t|}
d}d}znd}
t	|
D ] }	|
d
K }
|
| 
||	 O }
q>|
d
| K }
t	| dD ] }	|
d
K }
|
| 
||	 O }
qx|
W S  tk
r } zt d||f W 5 d}~X Y nX dS )zTurn an IPv6 ip_str into an integer.

        Args:
            ip_str: A string, the IPv6 ip_str.

        Returns:
            An int, the IPv6 address

        Raises:
            AddressValueError: if ip_str isn't a valid IPv6 Address.

        r   :r  z At least %d parts expected in %rr   ry   r   N%xr     r"   z!At most %d colons permitted in %rz At most one '::' permitted in %rr   z0Leading ':' only permitted as part of '::' in %rz1Trailing ':' only permitted as part of '::' in %rz/Expected at most %d other parts with '::' in %rz,Exactly %d parts expected without '::' in %r)r<   rV   rW   r@   rp   r\   rs   
_HEXTET_COUNTr&   range
_parse_hextetrD   )r   r   r
  Z
_min_partsr   Zipv4_intr  Z
_max_partsZ
skip_indexr   Zparts_hiZparts_loZ
parts_skippedr   r   r   r   r     s    
"
 






z_BaseV6._ip_int_from_stringc                 C   s>   | j |std| t|dkr4d}t|| t|dS )a&  Convert an IPv6 hextet string into an integer.

        Args:
            hextet_str: A string, the number to parse.

        Returns:
            The hextet as an integer.

        Raises:
            ValueError: if the input isn't strictly a hex number from
              [0..FFFF].

        zOnly hex digits permitted in %rr   z$At most 4 characters permitted in %rr   )_HEX_DIGITSr   rD   rW   r   )r   Z
hextet_strr   r   r   r   r8  >  s    z_BaseV6._parse_hextetc           	      C   s   d}d}d}d}t |D ]>\}}|dkrN|d7 }|dkr<|}||krV|}|}qd}d}q|dkr|| }|t|kr~|dg7 }dg|||< |dkrdg| }|S )a  Compresses a list of hextets.

        Compresses a list of strings, replacing the longest continuous
        sequence of "0" in the list with "" and adding empty strings at
        the beginning or at the end of the string such that subsequently
        calling ":".join(hextets) will produce the compressed version of
        the IPv6 address.

        Args:
            hextets: A list of strings, the hextets to compress.

        Returns:
            A list of strings.

        ry   r   r  r"    )	enumeraterW   )	r   hextetsZbest_doublecolon_startZbest_doublecolon_lenZdoublecolon_startZdoublecolon_lenindexZhextetZbest_doublecolon_endr   r   r   _compress_hextetsX  s0    

z_BaseV6._compress_hextetsNc                    sZ   |dkrt | j}|| jkr$tdd|   fddtdddD }| |}d	|S )
a,  Turns a 128-bit integer into hexadecimal notation.

        Args:
            ip_int: An integer, the IP address.

        Returns:
            A string, the hexadecimal representation of the address.

        Raises:
            ValueError: The address is bigger than 128 bits of all ones.

        NzIPv6 address is too large%032xc                    s&   g | ]}d t  ||d  d qS )r4  r   r   )r   r	  Zhex_strr   r   r     s     z/_BaseV6._string_from_ip_int.<locals>.<listcomp>r   r;   r   r3  )r   r\   rl   rD   r7  r>  r  )r   r   r<  r   r@  r   r     s    


z_BaseV6._string_from_ip_intc                    s   t | trt| j}nt | tr,t| j}nt| }| |}d|   fddtdddD }t | ttfrdd	|| j
f S d	|S )	zExpand a shortened IPv6 address.

        Args:
            ip_str: A string, the IPv6 address.

        Returns:
            A string, the expanded IPv6 address.

        r?  c                    s   g | ]} ||d   qS )r   r   r	  r@  r   r   r     s     z8_BaseV6._explode_shorthand_ip_string.<locals>.<listcomp>r   r;   r   r   r3  )rB   rI   rU   r}   rM   ra   r   r7  r   r  r{   )r*   r   r   r
  r   r@  r   r     s    



z$_BaseV6._explode_shorthand_ip_stringc                 C   s&   | j ddd dd}d|d S )zReturn the reverse DNS pointer name for the IPv6 address.

        This implements the method described in RFC3596 2.5.

        Nry   r3  r:  r   z	.ip6.arpa)r   replacer  )r*   Z
reverse_charsr   r   r   r     s    z_BaseV6._reverse_pointerc                 C   s   | j S r   r  r   r   r   r   r
    s    z_BaseV6.max_prefixlenc                 C   s   | j S r   r   r   r   r   r   rj     s    z_BaseV6.version)N)r7   r8   r9   r>   r:   rz   
IPV6LENGTHrl   r6  r  r9  rk   r   r   r   r   r8  r>  r   r   r   r   r
  rj   r   r   r   r   r2    s0   

h

/	
r2  c                   @   s   e Zd ZdZdZdd Zedd Zedd Zed	d
 Z	edd Z
ed
d Zedd Zedd Z
edd Zedd Zedd Zedd Zedd ZdS )rA   z/Represent and manipulate single IPv6 Addresses.r  c                 C   sx   t |tr| | || _dS t |trL| |d t|}t|d| _dS t|}d|krht	d| | 
|| _dS )a  Instantiate a new IPv6 address object.

        Args:
            address: A string or integer representing the IP

              Additionally, an integer can be passed, so
              IPv6Address('2001:db8::') ==
                IPv6Address(42540766411282592856903984951653826560)
              or, more generally
              IPv6Address(int(IPv6Address('2001:db8::'))) ==
                IPv6Address('2001:db8::')

        Raises:
            AddressValueError: If address isn't a valid IPv6 address.

        Nr   rO   rT   r  r  r  r   r   r   r     s    


zIPv6Address.__init__c                 C   s
   t | jS r  )rS   r\   r   r   r   r   r    s    zIPv6Address.packedc                 C   s   | | j jkS r   r  r   r   r   r   r     s    	zIPv6Address.is_multicastc                    s   t  fdd jjD S )r   c                 3   s   | ]} |kV  qd S r   r   r	  r   r   r   r    s     z*IPv6Address.is_reserved.<locals>.<genexpr>)r  r  _reserved_networksr   r   r   r   r     s    	zIPv6Address.is_reservedc                 C   s   | | j jkS r   r"  r   r   r   r   r     s    zIPv6Address.is_link_localc                 C   s   | | j jkS a`  Test if the address is reserved for site-local.

        Note that the site-local address space has been deprecated by RFC 3879.
        Use is_private to test if this address is in the space of unique local
        addresses as defined by RFC 4193.

        Returns:
            A boolean, True if the address is reserved per RFC 3513 2.5.6.

        )r  _sitelocal_networkr   r   r   r   
is_site_local  s    zIPv6Address.is_site_localc                    s   t  fdd jjD S )zTest if this address is allocated for private networks.

        Returns:
            A boolean, True if the address is reserved per
            iana-ipv6-special-registry.

        c                 3   s   | ]} |kV  qd S r   r   r  r   r   r   r  3  s     z)IPv6Address.is_private.<locals>.<genexpr>r  r   r   r   r   r   *  s    	zIPv6Address.is_privatec                 C   s   | j  S )zTest if this address is allocated for public networks.

        Returns:
            A boolean, true if the address is not reserved per
            iana-ipv6-special-registry.

        r   r   r   r   r   r   5  s    	zIPv6Address.is_globalc                 C   s
   | j dkS )r   r   r   r   r   r   r   r   @  s    	zIPv6Address.is_unspecifiedc                 C   s
   | j dkS )r   r"   r   r   r   r   r   r   K  s    	zIPv6Address.is_loopbackc                 C   s    | j d? dkrdS t| j d@ S )zReturn the IPv4 mapped address.

        Returns:
            If the IPv6 address is a v4 mapped address, return the
            IPv4 mapped address. Return None otherwise.

        r;   r5  N    r\   r@   r   r   r   r   ipv4_mappedV  s    	zIPv6Address.ipv4_mappedc                 C   s4   | j d? dkrdS t| j d? d@ t| j  d@ fS )zTuple of embedded teredo IPs.

        Returns:
            Tuple of the (server, client) IPs or None if the address
            doesn't appear to be a teredo address (doesn't start with
            2001::/32)

        `   i   Nr   rG  rH  r   r   r   r   teredoc  s
    
zIPv6Address.teredoc                 C   s$   | j d? dkrdS t| j d? d@ S )zReturn the IPv4 6to4 embedded address.

        Returns:
            The IPv4 6to4-embedded address if present or None if the
            address doesn't appear to contain a 6to4 embedded address.

        p   i   NP   rG  rH  r   r   r   r   	sixtofourr  s    	zIPv6Address.sixtofourN)r7   r8   r9   r>   r:   r   r   r  r   r   r   rF  r   r   r   r   rI  rK  rN  r   r   r   r   rA     s6   %





	











rA   c                   @   s   e Zd Zdd Zdd Zdd Zdd Zd	d
 Zej	Z	e
dd Ze
d
d Ze
dd Z
e
dd Ze
dd Ze
dd ZdS )rM   c                 C   s   t |ttfr2t| | t| j| _| j| _	d S t |t
rt| |d  t|dkrht|d | _	n| j| _	t|dd| _| jj
| _
| jj| _d S t|}t| |d  t|dd| _| jj
| _
| jj	| _	| jj| _d S r$  )rB   rC   r   rA   r   rI   r\   r   rk   r{   r%  rW   r   r   r   rY   r&  r   r   r   r     s(    




zIPv6Interface.__init__c                 C   s   d|  | j| jjf S r   r'  r   r   r   r   r     s    zIPv6Interface.__str__c                 C   sF   t | |}|r|tkr|S z| j|jkW S  tk
r@   Y dS X d S r   )rA   r,   r-   r   r|   r(  r   r   r   r,     s    zIPv6Interface.__eq__c                 C   sR   t | |}|tkrtS z| j|jk p4| j|jko4|W S  tk
rL   Y dS X d S r   )rA   r0   r-   r   r|   r)  r   r   r   r0     s    zIPv6Interface.__lt__c                 C   s   | j | jA t| jjA S r   r*  r   r   r   r   r     s    zIPv6Interface.__hash__c                 C   s
   t | jS r   )rA   r\   r   r   r   r   ra     s    zIPv6Interface.ipc                 C   s   d|  | j| jf S r   r+  r   r   r   r   r     s    zIPv6Interface.with_prefixlenc                 C   s   d|  | j| jf S r   r,  r   r   r   r   r     s    zIPv6Interface.with_netmaskc                 C   s   d|  | j| jf S r   r-  r   r   r   r   r     s    zIPv6Interface.with_hostmaskc                 C   s   | j dko| jjS r   )r\   r   r   r   r   r   r   r     s    zIPv6Interface.is_unspecifiedc                 C   s   | j dko| jjS r   )r\   r   r   r   r   r   r   r     s    zIPv6Interface.is_loopbackN)r7   r8   r9   r   r   r,   r0   r   r   r   r   ra   r   r   r   r   r   r   r   r   r   rM     s$   




rM   c                   @   s2   e Zd ZdZeZd
ddZdd Zedd Z	d	S )rI   av  This class represents and manipulates 128-bit IPv6 networks.

    Attributes: [examples for IPv6('2001:db8::1000/124')]
        .network_address: IPv6Address('2001:db8::1000')
        .hostmask: IPv6Address('::f')
        .broadcast_address: IPv6Address('2001:db8::100f')
        .netmask: IPv6Address('ffff:ffff:ffff:ffff:ffff:ffff:ffff:fff0')
        .prefixlen: 124

    Tc                 C   s|  t | | t|ttfr<t|| _| | j\| _	| _
dS t|trt|dkr\|d }n| j}| |\| _	| _
t|d | _t
| j}|t
| j	@ |kr|rtd|  nt|t
| j	@ | _dS t|}t| |d | _t|dkr|d }n| j}| |\| _	| _
|rDtt
| jt
| j	@ | jkrDtd|  tt
| jt
| j	@ | _| j
| jd krx| j| _dS )a  Instantiate a new IPv6 Network object.

        Args:
            address: A string or integer representing the IPv6 network or the
              IP and prefix/netmask.
              '2001:db8::/128'
              '2001:db8:0000:0000:0000:0000:0000:0000/128'
              '2001:db8::'
              are all functionally the same in IPv6.  That is to say,
              failing to provide a subnetmask will create an object with
              a mask of /128.

              Additionally, an integer can be passed, so
              IPv6Network('2001:db8::') ==
                IPv6Network(42540766411282592856903984951653826560)
              or, more generally
              IPv6Network(int(IPv6Network('2001:db8::'))) ==
                IPv6Network('2001:db8::')

            strict: A boolean. If true, ensure that we have been passed
              A true network address, eg, 2001:db8::1000/124 and not an
              IP address on a network, eg, 2001:db8::1/124.

        Raises:
            AddressValueError: If address isn't a valid IPv6 address.
            NetmaskValueError: If the netmask isn't valid for
              an IPv6 address.
            ValueError: If strict was True and a network address was not
              supplied.

        Nr"   r   r.  r   )r   r   rB   rC   r   rA   r}   r   rk   r   r{   r%  rW   r   rD   rY   r   r   r   r/  r   r   r   r     sJ     





zIPv6Network.__init__c                 c   s<   t | j}t | j}t|d |d D ]}| |V  q&dS )zGenerate Iterator over usable hosts in a network.

          This is like __iter__ except it doesn't return the
          Subnet-Router anycast address.

        r"   Nr   r   r   r   r   r   6	  s    

zIPv6Network.hostsc                 C   s   | j jo| jjS rD  )r}   rF  rv   r   r   r   r   rF  B	  s    zIPv6Network.is_site_localN)T)
r7   r8   r9   r>   rA   r   r   r   r   rF  r   r   r   r   rI     s   
OrI   c                   @   s   e Zd ZedZedZededededededed	ed
ededg
Zeded
edededededededededededededgZedZdS )_IPv6Constantsz	fe80::/10zff00::/8z::1/128z::/128z
::ffff:0:0/96z100::/64z	2001::/23z2001:2::/48z
2001:db8::/32z2001:10::/28zfc00::/7z::/8z100::/8z200::/7z400::/6z800::/5z1000::/4z4000::/3z6000::/3z8000::/3zA000::/3zC000::/3zE000::/4zF000::/5zF800::/6zFE00::/9z	fec0::/10N)	r7   r8   r9   rI   r#  r  r  rC  rE  r   r   r   r   rO  R	  s<          rO  )r"   )T)6r>   Z
__future__r   r    r	   __version__r   r   Zlong	NameErrorZunicoderU   strr   
from_bytesr   r|   r   hasattrr   r&   objectr'   r  rB  rD   r<   r?   rG   rK   rN   rR   rS   rY   rb   re   rn   rx   r   r   r   rh   r   r   r@   rL   rH   r1  r  r2  rA   rM   rI   rO  r   r   r   r   <module>   s   

	


)$
$#716 =   X *vSr    5W{!PK       ! 3<  <  &  __pycache__/contextlib2.cpython-38.pycnu [        U

    .eB                  	   @   s  d Z ddlZddlZddlZddlmZ ddlmZ ddddd	d
ddd
g	Zedg7 Zej	dd dkrnej
Znede
fddiZdd Zdd ZG dd deZG dd	 d	e
ZG dd deZdd ZG dd de
ZG dd de
ZG d d deZG d!d deZG d"d
 d
e
Zej	d d#kZer@d$d% Zd&d' Znd(d% Zd)d' Zzdd*lmZ W n ek
rz   eZ Y n
X d+d, Z G d-d
 d
e
Z!G d.d de!Z"G d/d deZ#dS )0zAcontextlib2 - backports and enhancements to the contextlib module    N)dequewrapscontextmanagerclosingnullcontextAbstractContextManagerContextDecorator	ExitStackredirect_stdoutredirect_stderrsuppressContextStack   )      ABC	__slots__ c                 C   s0   | |krd S | |  | jD ]}t|| q|S N)append	__bases___classic_mro)CresultBr   r   ;/usr/lib/python3.8/site-packages/pip/_vendor/contextlib2.pyr      s    

r   c                 G   sv   z
| j }W n" tk
r,   tt| g }Y nX |D ]>}|D ],}||jkr:|j| d krbt    S  q2q:t  S q2dS )NT)__mro__AttributeErrortupler   __dict__NotImplemented)r   methodsmromethodr   r   r   r   _check_methods$   s    


r%   c                   @   s2   e Zd ZdZdd Zejdd Zedd Z	dS )	r   z,An abstract base class for context managers.c                 C   s   | S )z0Return `self` upon entering the runtime context.r   selfr   r   r   	__enter__8   s    z AbstractContextManager.__enter__c                 C   s   dS )z9Raise any exception triggered within the runtime context.Nr   )r'   exc_type	exc_value	tracebackr   r   r   __exit__<   s    zAbstractContextManager.__exit__c                 C   s   | t krt|ddS tS )z<Check whether subclass is considered a subclass of this ABC.r(   r,   )r   r%   r!   )clsr   r   r   r   __subclasshook__A   s    z'AbstractContextManager.__subclasshook__N)
__name__
__module____qualname____doc__r(   abcabstractmethodr,   classmethodr.   r   r   r   r   r   5   s   
c                   @   s(   e Zd ZdZdd Zdd Zdd ZdS )	r	   zJA base class or mixin that enables context managers to work as decorators.c                 C   s   t dt |  S )a  Returns the context manager used to actually wrap the call to the
        decorated function.

        The default implementation just returns *self*.

        Overriding this method allows otherwise one-shot context managers
        like _GeneratorContextManager to support use as decorators via
        implicit recreation.

        DEPRECATED: refresh_cm was never added to the standard library's
                    ContextDecorator API
        z2refresh_cm was never added to the standard library)warningswarnDeprecationWarning_recreate_cmr&   r   r   r   
refresh_cmL   s    
zContextDecorator.refresh_cmc                 C   s   | S )a6  Return a recreated instance of self.

        Allows an otherwise one-shot context manager like
        _GeneratorContextManager to support use as
        a decorator via implicit recreation.

        This is a private interface just for _GeneratorContextManager.
        See issue #11647 for details.
        r   r&   r   r   r   r9   ]   s    
zContextDecorator._recreate_cmc                    s   t   fdd}|S )Nc               
      s*       | |W  5 Q R  S Q R X d S r   )r9   argskwdsfuncr'   r   r   innerj   s    
z(ContextDecorator.__call__.<locals>.innerr   )r'   r?   r@   r   r>   r   __call__i   s    zContextDecorator.__call__N)r/   r0   r1   r2   r:   r9   rA   r   r   r   r   r	   I   s   c                   @   s0   e Zd ZdZdd Zdd Zdd Zdd	 Zd
S )_GeneratorContextManagerz%Helper for 