type: requests.Response
        ZstatusNheadersutf-8)r   rQ   Zstatus_coder   rs   r   encodingrawreasonro   rq   bytesdecoder   cookiesr8   
connection)r3   ZreqrespZresponser+   r+   r,   build_response   s    

zHTTPAdapter.build_responseNc                 C   sd   t ||}|rDt|d}t|}|js.td| |}||}nt|}| }| j	|}|S )a  Returns a urllib3 connection for the given URL. This should not be
        called from user code, and is only exposed for use when subclassing the
        :class:`HTTPAdapter <requests.adapters.HTTPAdapter>`.

        :param url: The URL to connect to.
        :param proxies: (optional) A Requests-style dictionary of proxies used on this request.
        :rtype: urllib3.ConnectionPool
        ZhttpzFPlease check proxy URL. It is malformed and could be missing the host.)
r   r   r   Zhostr%   rg   Zconnection_from_urlr   Zgeturlr_   )r3   rq   r=   rf   Z	proxy_urlrO   rp   Zparsedr+   r+   r,   get_connection$  s    	


zHTTPAdapter.get_connectionc                 C   s&   | j   | j D ]}|  qdS )zDisposes of any internal state.

        Currently, this closes the PoolManager and any active ProxyManager,
        which closes any pooled connections.
        N)r_   clearrO   values)r3   rf   r+   r+   r,   r?   ?  s    
zHTTPAdapter.closec           	      C   s`   t |j|}t|jj}|o"|dk}d}|rDt|j }|d}|j}|r\|s\t|j}|S )a?  Obtain the url to use when making the final request.

        If the message is being sent through a HTTP proxy, the full URL has to
        be used. Otherwise, we should only use the path portion of the URL.

        This should not be called from user code, and is only exposed for use
        when subclassing the
        :class:`HTTPAdapter <requests.adapters.HTTPAdapter>`.

        :param request: The :class:`PreparedRequest <PreparedRequest>` being sent.
        :param proxies: A dictionary of schemes or schemes and hosts to proxy URLs.
        :rtype: str
        rh   Fr`   )r   rq   r   schemerd   re   Zpath_urlr   )	r3   r8   r=   rf   r   Zis_proxied_http_requestZusing_socks_proxyZproxy_schemerq   r+   r+   r,   request_urlI  s    

zHTTPAdapter.request_urlc                 K   s   dS )a"  Add any headers needed by the connection. As of v2.0 this does
        nothing by default, but is left for overriding by users that subclass
        the :class:`HTTPAdapter <requests.adapters.HTTPAdapter>`.

        This should not be called from user code, and is only exposed for use
        when subclassing the
        :class:`HTTPAdapter <requests.adapters.HTTPAdapter>`.

        :param request: The :class:`PreparedRequest <PreparedRequest>` to add headers to.
        :param kwargs: The keyword arguments from the call to send().
        Nr+   )r3   r8   r*   r+   r+   r,   add_headersf  s    zHTTPAdapter.add_headersc                 C   s&   i }t |\}}|r"t|||d< |S )a  Returns a dictionary of the headers to add to any request sent
        through a proxy. This works with urllib3 magic to ensure that they are
        correctly sent to the proxy, rather than in a tunnelled request if
        CONNECT is being used.

        This should not be called from user code, and is only exposed for use
        when subclassing the
        :class:`HTTPAdapter <requests.adapters.HTTPAdapter>`.

        :param proxy: The url of the proxy being used for this request.
        :rtype: dict
        zProxy-Authorization)r   r'   )r3   rf   rs   ra   rb   r+   r+   r,   rc   t  s    
zHTTPAdapter.proxy_headersFTc                 C   s  z|  |j|}W n. tk
r@ } zt||dW 5 d}~X Y nX | ||j|| | ||}	| j||||||d |jdkpd|jk }
t	|t
rz|\}}t||d}W q tk
r } zd
|}
t|
W 5 d}~X Y qX nt	|trnt||d}zF|
s2|j|j|	|j|jdddd| j|d
}nt|d	rD|j}|jtd
}z|j|j|	dd |j D ]\}}||| qn|  |jD ]D}|tt|d
d d |d || |d q|d z|jdd}W n tk
r   | }Y nX tj |||ddd}W n   |!   Y nX W n t"t#j$fk
r~ }
 zt%|
|dW 5 d}
~
X Y nZ t&k
r" } zt	|j't(rt	|j't)st*||dt	|j't+rt,||dt	|j't-rt.||dt	|j't/rt0||dt%||dW 5 d}~X Y n t1k
rP } zt%||dW 5 d}~X Y n t-k
rz } zt.|W 5 d}~X Y n^ t/t2fk
r } z:t	|t/rt0||dnt	|t3rt4||dn W 5 d}~X Y nX | 5||S )a  Sends PreparedRequest object. Returns Response object.

        :param request: The :class:`PreparedRequest <PreparedRequest>` being sent.
        :param stream: (optional) Whether to stream the request content.
        :param timeout: (optional) How long to wait for the server to send
            data before giving up, as a float, or a :ref:`(connect timeout,
            read timeout) <timeouts>` tuple.
        :type timeout: float or tuple or urllib3 Timeout object
        :param verify: (optional) Either a boolean, in which case it controls whether
            we verify the server's TLS certificate, or a string, in which case it
            must be a path to a CA bundle to use
        :param cert: (optional) Any user-provided SSL certificate to be trusted.
        :param proxies: (optional) The proxies dictionary to apply to the request.
        :rtype: requests.Response
        )r8   N)r9   r:   r;   r<   r=   zContent-Length)connectrK   zrInvalid timeout {}. Pass a (connect, read) timeout tuple, or a single float to set both timeouts to the same valueF)
methodrq   bodyrs   ZredirectZassert_same_hostpreload_contentdecode_contentZretriesr:   
proxy_pool)r:   T)Zskip_accept_encoding   rt   s   
s   0

)	buffering)Zpoolr{   r   r   )6r~   rq   r   r&   rr   r   r   r   rs   ro   tupleTimeoutSauce
ValueErrorrm   Zurlopenr   rF   hasattrr   Z	_get_connDEFAULT_POOL_TIMEOUTZ
putrequestrW   Z	putheaderZ
endheadersr>   hexlenencodeZgetresponse	TypeErrorr   Zfrom_httplibr?   r   socketerrorr    r   rw   r	   r   r!   r   r#   _ProxyErrorr
   	_SSLErrorr   r   
_HTTPErrorr   r"   r}   )r3   r8   r9   r:   r;   r<   r=   rp   erq   Zchunkedr   rK   errr|   Zlow_connheaderrZ   irr+   r+   r,   r>     s    



 



zHTTPAdapter.send)N)FNTNN)r@   rA   rB   rC   rU   DEFAULT_POOLSIZErN   DEFAULT_POOLBLOCKr1   rV   r[   rP   rg   rr   r}   r~   r?   r   r   rc   r>   rD   r+   r+   r4   r,   rE   T   s*    %4%

rE   )CrC   Zos.pathri   r   Zpip._vendor.urllib3.poolmanagerr   r   Zpip._vendor.urllib3.responser   Zpip._vendor.urllib3.utilr   r   r   Zpip._vendor.urllib3.util.retryr   Zpip._vendor.urllib3.exceptionsr   r	   r
   r   r   r   r
   r   r   r   r   r   r   r   Zmodelsr   compatr   r   Zutilsr   r   r   r   r   r   r   Z
structuresr   rz   r   
exceptionsr    r!   r"   r#   r$   r%   r&   Zauthr'   Z!pip._vendor.urllib3.contrib.socksr(   ImportErrorr   r   rN   r   objectr.   rE   r+   r+   r+   r,   <module>   sF   $,PK       ! n8*  *  .  requests/__pycache__/structures.cpython-38.pycnu [        U

    .e                     @   s<   d Z ddlmZmZmZ G dd deZG dd deZdS )zO
requests.structures
~~~~~~~~~~~~~~~~~~~

Data structures that power Requests.
   )OrderedDictMappingMutableMappingc                   @   sb   e Zd ZdZdddZdd Zdd Zd	d
 Zdd Zd
d Z	dd Z
dd Zdd Zdd Z
dS )CaseInsensitiveDicta  A case-insensitive ``dict``-like object.

    Implements all methods and operations of
    ``MutableMapping`` as well as dict's ``copy``. Also
    provides ``lower_items``.

    All keys are expected to be strings. The structure remembers the
    case of the last key to be set, and ``iter(instance)``,
    ``keys()``, ``items()``, ``iterkeys()``, and ``iteritems()``
    will contain case-sensitive keys. However, querying and contains
    testing is case insensitive::

        cid = CaseInsensitiveDict()
        cid['Accept'] = 'application/json'
        cid['aCCEPT'] == 'application/json'  # True
        list(cid) == ['Accept']  # True

    For example, ``headers['content-encoding']`` will return the
    value of a ``'Content-Encoding'`` response header, regardless
    of how the header name was originally stored.

    If the constructor, ``.update``, or equality comparison
    operations are given keys that have equal ``.lower()``s, the
    behavior is undefined.
    Nc                 K   s&   t  | _|d kri }| j|f| d S N)r   _storeupdate)selfdatakwargs r   C/usr/lib/python3.8/site-packages/pip/_vendor/requests/structures.py__init__(   s    zCaseInsensitiveDict.__init__c                 C   s   ||f| j | < d S r   r   lower)r	   keyvaluer   r   r
   __setitem__.   s    zCaseInsensitiveDict.__setitem__c                 C   s   | j |  d S )Nr   r   r	   r   r   r   r
   __getitem__3   s    zCaseInsensitiveDict.__getitem__c                 C   s   | j | = d S r   r   r   r   r   r
   __delitem__6   s    zCaseInsensitiveDict.__delitem__c                 C   s   dd | j  D S )Nc                 s   s   | ]\}}|V  qd S r   r   ).0ZcasedkeyZmappedvaluer   r   r
   	<genexpr>:   s     z/CaseInsensitiveDict.__iter__.<locals>.<genexpr>)r   valuesr	   r   r   r
   __iter__9   s    zCaseInsensitiveDict.__iter__c                 C   s
   t | jS r   )lenr   r   r   r   r
   __len__<   s    zCaseInsensitiveDict.__len__c                 C   s   dd | j  D S )z.Like iteritems(), but with all lowercase keys.c                 s   s   | ]\}}||d  fV  qdS )r   Nr   )r   ZlowerkeyZkeyvalr   r   r
   r   A   s   z2CaseInsensitiveDict.lower_items.<locals>.<genexpr>)r   itemsr   r   r   r
   lower_items?   s    zCaseInsensitiveDict.lower_itemsc                 C   s0   t |trt|}ntS t|  t| kS r   )
isinstancer   r   NotImplementeddictr   )r	   otherr   r   r
   __eq__G   s    

zCaseInsensitiveDict.__eq__c                 C   s   t | j S r   )r   r   r   r   r   r   r
   copyP   s    zCaseInsensitiveDict.copyc                 C   s   t t|  S r   )strr"   r   r   r   r   r
   __repr__S   s    zCaseInsensitiveDict.__repr__)N)__name__
__module____qualname____doc__r   r   r   r   r   r   r   r$   r%   r'   r   r   r   r
   r   
   s   
	r   c                       s<   e Zd ZdZd fdd	Zdd Zdd Zdd	d
Z  ZS )
LookupDictzDictionary lookup object.Nc                    s   || _ tt|   d S r   )namesuperr,   r   )r	   r-   	__class__r   r
   r   Z   s    zLookupDict.__init__c                 C   s
   d| j  S )Nz
<lookup '%s'>)r-   r   r   r   r
   r'   ^   s    zLookupDict.__repr__c                 C   s   | j |d S r   __dict__getr   r   r   r
   r   a   s    zLookupDict.__getitem__c                 C   s   | j ||S r   r1   )r	   r   defaultr   r   r
   r3   f   s    zLookupDict.get)N)N)	r(   r)   r*   r+   r   r'   r   r3   
__classcell__r   r   r/   r
   r,   W   s
   r,   N)r+   compatr   r   r   r   r"   r,   r   r   r   r
   <module>   s   JPK       ! =G
  
    requests/help.pynu [        """Module containing bug report helper(s)."""
from __future__ import print_function

import json
import platform
import sys
import ssl

from pip._vendor import idna
from pip._vendor import urllib3
from pip._vendor import chardet

from . import __version__ as requests_version

try:
    from pip._vendor.urllib3.contrib import pyopenssl
except ImportError:
    pyopenssl = None
    OpenSSL = None
    cryptography = None
e