  | _| _| _t|dd }|d kr@t| j}|| _d S )Nr2   )genr?   r<   r=   getattrtyper2   )r'   r?   r<   r=   docr   r   r   __init__t   s    
z!_GeneratorContextManager.__init__c                 C   s   |  | j| j| jS r   )	__class__r?   r<   r=   r&   r   r   r   r9      s    z%_GeneratorContextManager._recreate_cmc                 C   s.   zt | jW S  tk
r(   tdY nX d S )Nzgenerator didn't yield)nextrC   
StopIterationRuntimeErrorr&   r   r   r   r(      s    z"_GeneratorContextManager.__enter__c              
   C   s   |d kr8zt | j W n tk
r,   Y d S X tdn|d krF| }z| j||| tdW n tk
r } z||k	 W Y S d }~X Y nj tk
r } z0||krW Y "dS tr|j|krW Y 
dS  W 5 d }~X Y n   t d |k	r Y nX d S )Nzgenerator didn't stopz#generator didn't stop after throw()F   )	rI   rC   rJ   rK   throw_HAVE_EXCEPTION_CHAINING	__cause__sysexc_info)r'   rE   valuer+   excr   r   r   r,      s,    


z!_GeneratorContextManager.__exit__N)r/   r0   r1   r2   rG   r9   r(   r,   r   r   r   r   rB   q   s
   rB   c                    s   t   fdd}|S )a  @contextmanager decorator.

    Typical usage:

        @contextmanager
        def some_generator(<arguments>):
            <setup>
            try:
                yield <value>
            finally:
                <cleanup>

    This makes this:

        with some_generator(<arguments>) as <variable>:
            <body>

    equivalent to this:

        <setup>
        try:
            <variable> = <value>
            <body>
        finally:
            <cleanup>

    c                     s   t  | |S r   )rB   r;   r?   r   r   helper   s    zcontextmanager.<locals>.helperr   )r?   rU   r   rT   r   r      s    c                   @   s(   e Zd ZdZdd Zdd Zdd ZdS )	r   a2  Context to automatically close something at the end of a block.

    Code like this:

        with closing(<module>.open(<arguments>)) as f:
            <block>

    is equivalent to this:

        f = <module>.open(<arguments>)
        try:
            <block>
        finally:
            f.close()

    c                 C   s
   || _ d S r   thing)r'   rW   r   r   r   rG      s    zclosing.__init__c                 C   s   | j S r   rV   r&   r   r   r   r(      s    zclosing.__enter__c                 G   s   | j   d S r   )rW   close)r'   rQ   r   r   r   r,      s    zclosing.__exit__Nr/   r0   r1   r2   rG   r(   r,   r   r   r   r   r      s   c                   @   s(   e Zd ZdZdd Zdd Zdd ZdS )_RedirectStreamNc                 C   s   || _ g | _d S r   )_new_target_old_targets)r'   
new_targetr   r   r   rG      s    z_RedirectStream.__init__c                 C   s*   | j tt| j tt| j| j | jS r   )r\   r   rD   rP   _streamsetattrr[   r&   r   r   r   r(      s    z_RedirectStream.__enter__c                 C   s   t t| j| j  d S r   )r_   rP   r^   r\   popr'   exctypeexcinstexctbr   r   r   r,     s    z_RedirectStream.__exit__)r/   r0   r1   r^