odename)


if __name__ == '__main__':
    main()
PK       ! ;ϸFi  i    pep517/dirtools.pynu [        import os
import io
import contextlib
import tempfile
import shutil
import errno
import zipfile


@contextlib.contextmanager
def tempdir():
    """Create a temporary directory in a context manager."""
    td = tempfile.mkdtemp()
    try:
        yield td
    finally:
        shutil.rmtree(td)


def mkdir_p(*args, **kwargs):
    """Like `mkdir`, but does not raise an exception if the
    directory already exists.
    """
    try:
        return os.mkdir(*args, **kwargs)
    except OSError as exc:
        if exc.errno != errno.EEXIST:
            raise


def dir_to_zipfile(root):
    """Construct an in-memory zip file for a directory."""
    buffer = io.BytesIO()
    zip_file = zipfile.ZipFile(buffer, 'w')
    for root, dirs, files in os.walk(root):
        for path in dirs:
            fs_path = os.path.join(root, path)
            rel_path = os.path.relpath(fs_path, root)
            zip_file.writestr(rel_path + '/', '')
        for path in files:
            fs_path = os.path.join(root, path)
            rel_path = os.path.relpath(fs_path, root)
            zip_file.write(fs_path, rel_path)
    return zip_file
PK       ! ]      pep517/compat.pynu [        """Python 2/3 compatibility"""
import json
import sys


# Handle reading and writing JSON in UTF-8, on Python 3 and 2.

if sys.version_info[0] >= 3:
    # Python 3
    def write_json(obj, path, **kwargs):
        with open(path, 'w', encoding='utf-8') as f:
            json.dump(obj, f, **kwargs)

    def read_json(path):
        with open(path, 'r', encoding='utf-8') as f:
            return json.load(f)

else:
    # Python 2
    def write_json(obj, path, **kwargs):
        with open(path, 'wb') as f:
            json.dump(obj, f, encoding='utf-8', **kwargs)

    def read_json(path):
        with open(path, 'rb') as f:
            return json.load(f)


# FileNotFoundError

try:
    FileNotFoundError = FileNotFoundError
except NameError:
    FileNotFoundError = IOError
PK       ! W9p  p    pep517/_in_process.pynu [        """This is invoked in a subprocess to call the build backend hooks.

It expects:
- Command line args: hook_name, control_dir
- Environment variables:
      PEP517_BUILD_BACKEND=entry.point:spec
      PEP517_BACKEND_PATH=paths (separated with os.pathsep)
- control_dir/input.json:
  - {"kwargs": {...}}

Results:
- control_dir/output.json
  - {"return_val": ...}
"""
from glob import glob
from importlib import import_module
import os
import os.path
from os.path import join as pjoin
import re
import shutil
import sys
import traceback

# This is run as a script, not a module, so it can't do a relative import
import compat


class BackendUnavailable(Exception):
    """Raised if we cannot import the backend"""
    def __init__(self, traceback):
        self.traceback = traceback


class BackendInvalid(Exception):
    """Raised if the backend is invalid"""
    def __init__(self, message):
        self.message = message


class HookMissing(Exception):
    """Raised if a hook is missing and we are not executing the fallback"""


def contained_in(filename, directory):
    """Test if a file is located within the given directory."""
    filename = os.path.normcase(os.path.abspath(filename))
    directory = os.path.normcase(os.path.abspath(directory))
    return os.path.commonprefix([filename, directory]) == directory


def _build_backend():
    """Find and load the build backend"""
    # Add in-tree backend directories to the front of sys.path.
    backend_path = os.environ.get('PEP517_BACKEND_PATH')
    if backend_path:
        extra_pathitems = backend_path.split(os.pathsep)
        sys.path[:0] = extra_pathitems

    ep = os.environ['PEP517_BUILD_BACKEND']
    mod_path, _, obj_path = ep.partition(':')
    try:
        obj = import_module(mod_path)
    except ImportError:
        raise BackendUnavailable(traceback.format_exc())

    if backend_path:
        if not any(
            contained_in(obj.__file__, path)
            for path in extra_pathitems
        ):
            raise BackendInvalid("Backend was not loaded from backend-path")

    if obj_path:
        for path_part in obj_path.split('.'):
            obj = getattr(obj, path_part)
    return obj


def get_requires_for_build_wheel(config_settings):
    """Invoke the optional get_requires_for_build_wheel hook

    Returns [] if the hook is not defined.
    """
    backend = _build_backend()
    try:
        hook = backend.get_requires_for_build_wheel
    except AttributeError:
        return []
    else:
        return hook(config_settings)


def prepare_metadata_for_build_wheel(
        metadata_directory, config_settings, _allow_fallback):
    """Invoke optional prepare_metadata_for_build_wheel

    Implements a fallback by building a wheel if the hook isn't defined,
    unless _allow_fallback is False in which case HookMissing is raised.
    """
    backend = _build_backend()
    try:
        hook = backend.prepare_metadata_for_build_wheel
    except AttributeError:
        if not _allow_fallback:
            raise HookMissing()
        return _get_wheel_metadata_from_wheel(backend, metadata_directory,
                                              config_settings)
    else:
        return hook(metadata_directory, config_settings)


WHEEL_BUILT_MARKER = 'PEP517_ALREADY_BUILT_WHEEL'


def _dist_info_files(whl_zip):
    """Identify the .dist-info folder inside a wheel ZipFile."""
    res = []
    for path in whl_zip.namelist():
        m = re.match(r'[^/\\]+-[^/\\]+\.dist-info/', path)
        if m:
            res.append(path)
    if res:
        return res
    raise Exception("No .dist-info folder found in wheel")


def _get_wheel_metadata_from_wheel(
        backend, metadata_directory, config_settings):
    """Build a wheel and extract the metadata from it.

    Fallback for when the build backend does not
    define the 'get_wheel_metadata' hook.
    """
    from zipfile import ZipFile
    whl_basename = backend.build_wheel(metadata_directory, config_settings)
    with open(os.path.join(metadata_directory, WHEEL_BUILT_MARKER), 'wb'):
        pass  # Touch marker file

    whl_file = os.path.join(metadata_directory, whl_basename)
    with ZipFile(whl_file) as zipf:
        dist_info = _dist_info_files(zipf)
        zipf.extractall(path=metadata_directory, members=dist_info)
    return dist_info[0].split('/')[0]


def _find_already_built_wheel(metadata_directory):
    """Check for a wheel already built during the get_wheel_metadata hook.
    """
    if not metadata_directory:
        return None
    metadata_parent = os.path.dirname(metadata_directory)
    if not os.path.isfile(pjoin(metadata_parent, WHEEL_BUILT_MARKER)):
        return None

    whl_files = glob(os.path.join(metadata_parent, '*.whl'))
    if not whl_files:
        print('Found wheel built marker, but no .whl files')
        return None
    if len(whl_files) > 1:
        print('Found multiple .whl files; unspecified behaviour. '
              'Will call build_wheel.')
        return None

    # Exactly one .whl file
    return whl_files[0]


def build_wheel(wheel_directory, config_settings, metadata_directory=None):
    """Invoke the mandatory build_wheel hook.

    If a wheel was already built in the
    prepare_metadata_for_build_wheel fallback, this
    will copy it rather than rebuilding the wheel.
    """
    prebuilt_whl = _find_already_built_wheel(metadata_directory)
    if prebuilt_whl:
        shutil.copy2(prebuilt_whl, wheel_directory)
        return os.path.basename(prebuilt_whl)

    return _build_backend().build_wheel(wheel_directory, config_settings,
                                        metadata_directory)


def get_requires_for_build_sdist(config_settings):
    """Invoke the optional get_requires_for_build_wheel hook

    Returns [] if the hook is not defined.
    """
    backend = _build_backend()
    try:
        hook = backend.get_requires_for_build_sdist
    except AttributeError:
        return []
    else:
        return hook(config_settings)


class _DummyException(Exception):
    """Nothing should ever raise this exception"""


class GotUnsupportedOperation(Exception):
    """For internal use when backend raises UnsupportedOperation"""
    def __init__(self, traceback):
        self.traceback = traceback


def build_sdist(sdist_directory, config_settings):
    """Invoke the mandatory build_sdist hook."""
    backend = _build_backend()
    try:
        return backend.build_sdist(sdist_directory, config_settings)
    except getattr(backend, 'UnsupportedOperation', _DummyException):
        raise GotUnsupportedOperation(traceback.format_exc())


HOOK_NAMES = {
    'get_requires_for_build_wheel',
    'prepare_metadata_for_build_wheel',
    'build_wheel',
    'get_requires_for_build_sdist',
    'build_sdist',
}


def main():
    if len(sys.argv) < 3:
        sys.exit("Needs args: hook_name, control_dir")
    hook_name = sys.argv[1]
    control_dir = sys.argv[2]
    if hook_name not in HOOK_NAMES:
        sys.exit("Unknown hook: %s" % hook_name)
    hook = globals()[hook_name]

    hook_input = compat.read_json(pjoin(control_dir, 'input.json'))

    json_out = {'unsupported': False, 'return_val': None}
    try:
        json_out['return_val'] = hook(**hook_input['kwargs'])
    except BackendUnavailable as e:
        json_out['no_backend'] = True
        json_out['traceback'] = e.traceback
    except BackendInvalid as e:
        json_out['backend_invalid'] = True
        json_out['backend_error'] = e.message
    except GotUnsupportedOperation as e:
        json_out['unsupported'] = True
        json_out['traceback'] = e.traceback
    except HookMissing:
        json_out['hook_missing'] = True

    compat.write_json(json_out, pjoin(control_dir, 'output.json'), indent=2)


if __name__ == '__main__':
    main()
PK       ! ޟ	  	    pep517/meta.pynu [        """Build metadata for a project using PEP 517 hooks.
"""
import argparse
import logging
import os
import shutil
import functools

try:
    import importlib.metadata as imp_meta
except ImportError:
    import importlib_metadata as imp_meta

try:
    from zipfile import Path
except ImportError:
    from zipp import Path

from .envbuild import BuildEnvironment
from .wrappers import Pep517HookCaller, quiet_subprocess_runner
from .dirtools import tempdir, mkdir_p, dir_to_zipfile
from .build import validate_system, load_system, compat_system

log = logging.getLogger(__name__)


def _prep_meta(hooks, env, dest):
    reqs = hooks.get_requires_for_build_wheel({})
    log.info('Got build requires: %s', reqs)

    env.pip_install(reqs)
    log.info('Installed dynamic build dependencies')

    with tempdir() as td:
        log.info('Trying to build metadata in %s', td)
        filename = hooks.prepare_metadata_for_build_wheel(td, {})
        source = os.path.join(td, filename)
        shutil.move(source, os.path.join(dest, os.path.basename(filename)))


def build(source_dir='.', dest=None, system=None):
    system = system or load_system(source_dir)
    dest = os.path.join(source_dir, dest or 'dist')
    mkdir_p(dest)
    validate_system(system)
    hooks = Pep517HookCaller(
        source_dir, system['build-backend'], system.get('backend-path')
    )

    with hooks.subprocess_runner(quiet_subprocess_runner):
        with BuildEnvironment() as env:
            env.pip_install(system['requires'])
            _prep_meta(hooks, env, dest)


def build_as_zip(builder=build):
    with tempdir() as out_dir:
        builder(dest=out_dir)
        return dir_to_zipfile(out_dir)


def load(root):
    """
    Given a source directory (root) of a package,
    return an importlib.metadata.Distribution object
    with metadata build from that package.
    """
    root = os.path.expanduser(root)
    system = compat_system(root)
    builder = functools.partial(build, source_dir=root, system=system)
    path = Path(build_as_zip(builder))
    return imp_meta.PathDistribution(path)


parser = argparse.ArgumentParser()
parser.add_argument(
    'source_dir',
    help="A directory containing pyproject.toml",
)
parser.add_argument(
    '--out-dir', '-o',
    help="Destination in which to save the builds relative to source dir",
)


def main():
    args = parser.parse_args()
    build(args.source_dir, args.out_dir)


if __name__ == '__main__':
    main()
PK       ! Afrd  d  *  pep517/__pycache__/colorlog.cpython-38.pycnu [        U

    .e                     @   sf   d Z ddlZddlZzddlZW n ek
r8   dZY nX dd ZG dd dejZejfddZ	dS )	zONicer log formatting with colours.

Code copied from Tornado, Apache licensed.
    Nc                  C   sV   d} t rRttjdrRtj rRzt   t ddkr:d} W n tk
rP   Y nX | S )NFisattyZcolorsr   T)curseshasattrsysstderrr   Z	setuptermZtigetnum	Exception)color r	   ?/usr/lib/python3.8/site-packages/pip/_vendor/pep517/colorlog.py_stderr_supports_color   s    r   c                   @   s>   e Zd ZdZejdejdejdejdiZ	dddZ
d	d
 ZdS )LogFormatterz&Log formatter with colour support
             TNc                 C   s   t jj| |d i | _|rt rtdp6tdp6d}dtj  k rNdk r\n n
t	|d}| j
 D ] \}}t	t||d| j|< qft	tdd| _
t }| d	 | _t  nd| _
d
| _dS )aO  
        :arg bool color: Enables color support.
        :arg string fmt: Log message format.
        It will be applied to the attributes dict of log records. The
        text between ``%(color)s`` and ``%(end_color)s`` will be colored
        depending on the level if color support is on.
        :arg dict colors: color mappings from logging level to terminal color
        code
        :arg string datefmt: Datetime format.
        Used for formatting ``(asctime)`` placeholder in ``prefix_fmt``.
        .. versionchanged:: 3.2
        Added ``fmt`` and ``datefmt`` arguments.
        )datefmtZsetafZsetf )r   r   )r   r
   r   asciiZsgr0r   F   N)logging	Formatter__init___colorsr   r   Ztigetstrr   version_infostrDEFAULT_COLORSitemsZtparm_normalZinitscrZgetmaxyx	termwidthZendwin)selfr   r   Zfg_colorlevelnocodeZscrr	   r	   r
   r   2   s*    



 
zLogFormatter.__init__c                 C   s   t |j}dj|jd |jd}|t | | jk rJd| j|t |   }nd}|j| jkrn| j|j }| j}nd }}|j| | | | S )Nz{initial}-{name}r   )initialname z  r   )	lenmessageformatZ	levelnamer"   r   r   r   r   )r   recordZmlenZ
right_textZspaceZstart_colorZ	end_colorr	   r	   r
   
formatMessage]   s    
zLogFormatter.formatMessage)TN)__name__
__module____qualname____doc__r   INFOZWARNINGZERRORZCRITICALr   r   r(   r	   r	   r	   r
   r   (   s       
+r   c                 C   s0   t  }|t  t j| t j|  d S )N)r   Z
StreamHandlerZsetFormatterr   rootZ
addHandlerZsetLevel)levelZhandlerr	   r	   r
   enable_colourful_outputo   s    r0   )
r,   r   r   r   ImportErrorr   r   r   r-   r0   r	   r	   r	   r
   <module>   s   
GPK       ! p      *  pep517/__pycache__/__init__.cpython-38.pycnu [        U

    .eT                      @   s   d Z dZdS )z6Wrappers to build Python packages using PEP 517 hooks
z0.7.0N)__doc____version__ r   r   ?/usr/lib/python3.8/site-packages/pip/_vendor/pep517/__init__.py<module>   s   PK       ! +1     *  pep517/__pycache__/dirtools.cpython-38.pycnu [        U

    .ei                     @   sZ   d dl Z d dlZd dlZd dlZd dlZd dlZd dlZejdd Zdd Z	dd Z
dS )    Nc               	   c   s$   t  } z
| V  W 5 t|  X dS )z2Create a temporary directory in a context manager.N)tempfileZmkdtempshutilZrmtree)Ztd r   ?/usr/lib/python3.8/site-packages/pip/_vendor/pep517/dirtools.pytempdir
   s    
r   c               
   O   sD   zt j| |W S  tk
r> } z|jtjkr. W 5 d}~X Y nX dS )zWLike `mkdir`, but does not raise an exception if the
    directory already exists.
    N)osmkdirOSErrorerrnoZEEXIST)argskwargsexcr   r   r   mkdir_p   s
    r   c                 C   s   t  }t|d}t| D ]r\} }}|D ]0}tj| |}tj|| }|	|d d q,|D ],}tj| |}tj|| }|
|| qbq|S )z0Construct an in-memory zip file for a directory.w/ )ioBytesIOzipfileZZipFiler   walkpathjoinrelpathZwritestrwrite)rootbufferZzip_filedirsfilesr   Zfs_pathZrel_pathr   r   r   dir_to_zipfile   s    r   )r   r   
contextlibr   r   r
   r   contextmanagerr   r   r   r   r   r   r   <module>   s   
	PK       !     3  pep517/__pycache__/_in_process.cpython-38.opt-1.pycnu [        U

    .ep                     @   s0  d Z ddlmZ ddlmZ ddlZddlZddlmZ ddlZddl	Z	ddl
Z
ddlZddlZG dd de
ZG dd	 d	e
ZG d
d de
Zdd
 Zdd Zdd Zdd ZdZdd Zdd Zdd Zd(ddZdd ZG dd  d e
ZG d!d" d"e
Zd#d$ Zddddd$hZd%d& Ze d'kr,e  dS ))ag  This is invoked in a subprocess to call the build backend hooks.

It expects:
- Command line args: hook_name, control_dir
- Environment variables:
      PEP517_BUILD_BACKEND=entry.point:spec
      PEP517_BACKEND_PATH=paths (separated with os.pathsep)
- control_dir/input.json:
  - {"kwargs": {...}}

Results:
- control_dir/output.json
  - {"return_val": ...}
    )glob)
import_moduleN)joinc                   @   s   e Zd ZdZdd ZdS )BackendUnavailablez&Raised if we cannot import the backendc                 C   s
   || _ d S N	tracebackselfr    r   B/usr/lib/python3.8/site-packages/pip/_vendor/pep517/_in_process.py__init__   s    zBackendUnavailable.__init__N__name__
__module____qualname____doc__r
   r   r   r   r   r      s   r   c                   @   s   e Zd ZdZdd ZdS )BackendInvalidz Raised if the backend is invalidc                 C   s
   || _ d S r   )message)r
   r   r   r   r   r
   %   s    zBackendInvalid.__init__Nr   r   r   r   r   r   #   s   r   c                   @   s   e Zd ZdZdS )HookMissingzARaised if a hook is missing and we are not executing the fallbackNr   r   r   r   r   r   r   r   r   )   s   r   c                 C   s<   t jt j| } t jt j|}t j| |g|kS )z5Test if a file is located within the given directory.)ospathnormcaseabspathcommonprefix)filenameZ	directoryr   r   r   contained_in-   s    r   c                     s   t jd} | r*| t j}|tjdd< t jd }|d\}}}zt| W n  t	k
rp   t
t Y nX | rt
 fdd|D std|r|d	D ]}t | q S )
zFind and load the build backendZPEP517_BACKEND_PATHNr   ZPEP517_BUILD_BACKEND:c                 3   s   | ]}t  j|V  qd S r   )r   __file__).0r   objr   r   	<genexpr>D   s   z!_build_backend.<locals>.<genexpr>z(Backend was not loaded from backend-path.)r   environgetsplitpathsepsysr   	partitionr   ImportErrorr   r   
format_excanyr   getattr)Zbackend_pathZextra_pathitemsZepZmod_path_Zobj_pathZ	path_partr   r!   r   _build_backend4   s&    
r0   c                 C   s6   t  }z
|j}W n tk
r(   g  Y S X || S dS zfInvoke the optional get_requires_for_build_wheel hook

    Returns [] if the hook is not defined.
    N)r0   get_requires_for_build_wheelAttributeErrorconfig_settingsbackendhookr   r   r   r2   P   s    

r2   c                 C   sJ   t  }z
|j}W n* tk
r:   |s*t t|| | Y S X || |S dS )zInvoke optional prepare_metadata_for_build_wheel

    Implements a fallback by building a wheel if the hook isn't defined,
    unless _allow_fallback is False in which case HookMissing is raised.
    N)r0    prepare_metadata_for_build_wheelr3   r   _get_wheel_metadata_from_wheel)metadata_directoryr5   Z_allow_fallbackr6   r7   r   r   r   r8   ^   s    

r8   ZPEP517_ALREADY_BUILT_WHEELc                 C   s@   g }|   D ]}td|}|r|| q|r4|S tddS )z6Identify the .dist-info folder inside a wheel ZipFile.z[^/\\]+-[^/\\]+\.dist-info/z#No .dist-info folder found in wheelN)Znamelistrematchappend	Exception)Zwhl_zipresr   mr   r   r   _dist_info_filest   s    rA   c              	   C   s   ddl m} | ||}ttj|td W 5 Q R X tj||}||}t|}|j	||d W 5 Q R X |d 
dd S )zBuild a wheel and extract the metadata from it.

    Fallback for when the build backend does not
    define the 'get_wheel_metadata' hook.
    r   )ZipFilewb)r   members/)ZzipfilerB   build_wheelopenr   r   r   WHEEL_BUILT_MARKERrA   Z
extractallr'   )r6   r:   r5   rB   Zwhl_basenameZwhl_fileZzipfZ	dist_infor   r   r   r9      s    

r9   c                 C   sl   | sdS t j| }t jt|ts*dS tt j|d}|sLtd dS t	|dkrdtd dS |d S )zHCheck for a wheel already built during the get_wheel_metadata hook.
    Nz*.whlz+Found wheel built marker, but no .whl files   zHFound multiple .whl files; unspecified behaviour. Will call build_wheel.r   )
r   r   dirnameisfilepjoinrH   r   r   printlen)r:   Zmetadata_parentZ	whl_filesr   r   r   _find_already_built_wheel   s    rO   c                 C   s4   t |}|r$t||  tj|S t | ||S )zInvoke the mandatory build_wheel hook.

    If a wheel was already built in the
    prepare_metadata_for_build_wheel fallback, this
    will copy it rather than rebuilding the wheel.
    )rO   shutilZcopy2r   r   basenamer0   rF   )Zwheel_directoryr5   r:   Zprebuilt_whlr   r   r   rF      s    
rF   c                 C   s6   t  }z
|j}W n tk
r(   g  Y S X || S dS r1   )r0   get_requires_for_build_sdistr3   r4   r   r   r   rR      s    

rR   c                   @   s   e Zd ZdZdS )_DummyExceptionz(Nothing should ever raise this exceptionNr   r   r   r   r   rS      s   rS   c                   @   s   e Zd ZdZdd ZdS )GotUnsupportedOperationz9For internal use when backend raises UnsupportedOperationc                 C   s
   || _ d S r   r   r	   r   r   r   r
      s    z GotUnsupportedOperation.__init__Nr   r   r   r   r   rT      s   rT   c                 C   sB   t  }z|| |W S  t|dtk
r<   tt Y nX dS )z&Invoke the mandatory build_sdist hook.UnsupportedOperationN)r0   build_sdistr.   rS   rT   r   r,   )Zsdist_directoryr5   r6   r   r   r   rV      s
    rV   c               
   C   sN  t tjdk rtd tjd } tjd }| tkrBtd|   t |  }tt|d}dd d}z|f |d	 |d
< W n t	k
r } zd|d< |j
|d
< W 5 d }~X Y n tk
r } zd|d< |j|d< W 5 d }~X Y nR t
k
r } zd|d< |j
|d
< W 5 d }~X Y n tk
r2   d|d< Y nX tj|t|ddd d S )N   z"Needs args: hook_name, control_dirrI      zUnknown hook: %sz
input.jsonF)unsupported
return_valkwargsrZ   TZ
no_backendr   Zbackend_invalidZ
backend_errorrY   Zhook_missingzoutput.json)indent)rN   r)   argvexit
HOOK_NAMESglobalscompatZ	read_jsonrL   r   r   r   r   rT   r   Z
write_json)Z	hook_nameZcontrol_dirr7   Z
hook_inputZjson_outer   r   r   main   s.    




rc   __main__)N)!r   r   	importlibr   r   Zos.pathr   rL   r;   rP   r)   r   ra   r>   r   r   r   r   r0   r2   r8   rH   rA   r9   rO   rF   rR   rS   rT   rV   r_   rc   r   r   r   r   r   <module>   sF   

	
PK       ! C    .  pep517/__pycache__/compat.cpython-38.opt-1.pycnu [        U

    .e                     @   sj   d Z ddlZddlZejd dkr4dd Zdd Zndd Zd	d ZzeZW n ek
rd   eZY nX dS )
zPython 2/3 compatibility    N   c              	   K   s.   t |ddd}tj| |f| W 5 Q R X d S )Nwutf-8encodingopenjsondumpobjpathkwargsf r   =/usr/lib/python3.8/site-packages/pip/_vendor/pep517/compat.py
write_json
   s    r   c              
   C   s0   t | ddd}t|W  5 Q R  S Q R X d S )Nrr   r   r   r	   loadr
   r   r   r   r   	read_json   s    r   c              	   K   s2   t |d}tj| |fddi| W 5 Q R X d S )Nwbr   r   r   r   r   r   r   r      s    c              
   C   s,   t | d}t|W  5 Q R  S Q R X d S )Nrbr   r   r   r   r   r      s    )	__doc__r	   sysversion_infor   r   FileNotFoundError	NameErrorIOErrorr   r   r   r   <module>   s   
PK       ! C    (  pep517/__pycache__/compat.cpython-38.pycnu [        U

    .e                     @   sj   d Z ddlZddlZejd dkr4dd Zdd Zndd Zd	d ZzeZW n ek
rd   eZY nX dS )
zPython 2/3 compatibility    N   c              	   K   s.   t |ddd}tj| |f| W 5 Q R X d S )Nwutf-8encodingopenjsondumpobjpathkwargsf r   =/usr/lib/python3.8/site-packages/pip/_vendor/pep517/compat.py
write_json
   s    r   c              
   C   s0   t | ddd}t|W  5 Q R  S Q R X d S )Nrr   r   r   r	   loadr
   r   r   r   r   	read_json   s    r   c              	   K   s2   t |d}tj| |fddi| W 5 Q R X d S )Nwbr   r   r   r   r   r   r   r      s    c              
   C   s,   t | d}t|W  5 Q R  S Q R X d S )Nrbr   r   r   r   r   r      s    )	__doc__r	   sysversion_infor   r   FileNotFoundError	NameErrorIOErrorr   r   r   r   <module>   s   
PK       ! M-'  '  0  pep517/__pycache__/wrappers.cpython-38.opt-1.pycnu [        U

    .eg)                     @   s  d dl Z d dlmZ d dlZd dlmZmZmZ d dl	Z	d dl
mZmZm
Z
 d dlZd dlmZ ddlmZ eeeedZed	d
 ZG dd deZG d
d deZG dd deZG dd deZdddZdddZdd ZG dd deZG dd de j Z!dS )    N)contextmanager)dirnameabspathjoin)
check_callcheck_outputSTDOUT)mkdtemp   )compatz_in_process.pyc               	   c   s"   t  } z
| V  W 5 t|  X d S N)r	   shutilZrmtree)td r   ?/usr/lib/python3.8/site-packages/pip/_vendor/pep517/wrappers.pytempdir   s    
r   c                   @   s   e Zd ZdZdd ZdS )BackendUnavailablezEWill be raised if the backend cannot be imported in the hook process.c                 C   s
   || _ d S r   	tracebackselfr   r   r   r   __init__   s    zBackendUnavailable.__init__N__name__
__module____qualname____doc__r   r   r   r   r   r      s   r   c                   @   s   e Zd ZdZdd ZdS )BackendInvalidz)Will be raised if the backend is invalid.c                 C   s   || _ || _|| _d S r   backend_namebackend_pathmessage)r   r   r    r!   r   r   r   r       s    zBackendInvalid.__init__Nr   r   r   r   r   r      s   r   c                       s    e Zd ZdZ fddZ  ZS )HookMissingz Will be raised on missing hooks.c                    s   t t| | || _d S r   )superr"   r   	hook_name)r   r$   	__class__r   r   r   (   s    zHookMissing.__init__)r   r   r   r   r   
__classcell__r   r   r%   r   r"   &   s   r"   c                   @   s   e Zd ZdZdd ZdS )UnsupportedOperationzDMay be raised by build_sdist if the backend indicates that it can't.c                 C   s
   || _ d S r   r   r   r   r   r   r   /   s    zUnsupportedOperation.__init__Nr   r   r   r   r   r(   -   s   r(   c                 C   s*   t j }|r|| t| ||d dS )z5The default method of calling the wrapper subprocess.)cwdenvN)osenvironcopyupdater   cmdr)   
extra_environr*   r   r   r   default_subprocess_runner3   s    

r2   c                 C   s,   t j }|r|| t| ||td dS )zDA method of calling the wrapper subprocess while suppressing output.)r)   r*   stderrN)r+   r,   r-   r.   r   r   r/   r   r   r   quiet_subprocess_runner<   s    

r4   c                 C   sn   t j|rtdt j| }t jt j||}t j|}t j|}t j||g|krjtd|S )zNormalise and check a backend path.

    Ensure that the requested backend path is specified as a relative path,
    and resolves to a location under the given source tree.

    Return an absolute version of the requested path.
    zpaths must be relativez paths must be inside source tree)	r+   pathisabs
ValueErrorr   normpathr   normcasecommonprefix)Zsource_treeZ	requestedZ
abs_sourceZ
abs_requestedZnorm_sourceZnorm_requestedr   r   r   norm_and_checkE   s    r;   c                   @   s`   e Zd ZdZdddZedd ZdddZdd
dZddd
Z	dddZ
dddZdd ZdS )Pep517HookCallerae  A wrapper around a source directory to be built with a PEP 517 backend.

    source_dir : The path to the source directory, containing pyproject.toml.
    build_backend : The build backend spec, as per PEP 517, from
        pyproject.toml.
    backend_path : The backend path, as per PEP 517, from pyproject.toml.
    runner : A callable that invokes the wrapper subprocess.

    The 'runner', if provided, must expect the following:
        cmd : a list of strings representing the command and arguments to
            execute, as would be passed to e.g. 'subprocess.check_call'.
        cwd : a string representing the working directory that must be
            used for the subprocess. Corresponds to the provided source_dir.
        extra_environ : a dict mapping environment variable names to values
            which must be set for the subprocess execution.
    Nc                    sB   |d krt }t| _| _|r2 fdd|D }| _| _d S )Nc                    s   g | ]}t  j|qS r   )r;   
source_dir).0pr   r   r   
<listcomp>{   s    z-Pep517HookCaller.__init__.<locals>.<listcomp>)r2   r   r=   
build_backendr    _subprocess_runner)r   r=   rB   r    runnerr   r@   r   r   n   s    

zPep517HookCaller.__init__c                 c   s   | j }|| _ dV  || _ dS )z\A context manager for temporarily overriding the default subprocess
        runner.
        N)rC   )r   rD   prevr   r   r   subprocess_runner   s    z"Pep517HookCaller.subprocess_runnerc                 C   s   |  dd|iS )aG  Identify packages required for building a wheel

        Returns a list of dependency specifications, e.g.:
            ["wheel >= 0.25", "setuptools"]

        This does not include requirements specified in pyproject.toml.
        It returns the result of calling the equivalently named hook in a
        subprocess.
        get_requires_for_build_wheelconfig_settings
_call_hookr   rH   r   r   r   rG      s    
 z-Pep517HookCaller.get_requires_for_build_wheelTc                 C   s   |  dt|||dS )aq  Prepare a *.dist-info folder with metadata for this project.

        Returns the name of the newly created folder.

        If the build backend defines a hook with this name, it will be called
        in a subprocess. If not, the backend will be asked to build a wheel,
        and the dist-info extracted from that (unless _allow_fallback is
        False).
         prepare_metadata_for_build_wheel)metadata_directoryrH   _allow_fallbackrJ   r   )r   rM   rH   rN   r   r   r   rL      s
    z1Pep517HookCaller.prepare_metadata_for_build_wheelc                 C   s(   |dk	rt |}| dt |||dS )av  Build a wheel from this project.

        Returns the name of the newly created file.

        In general, this will call the 'build_wheel' hook in the backend.
        However, if that was previously called by
        'prepare_metadata_for_build_wheel', and the same metadata_directory is
        used, the previously built wheel will be copied to wheel_directory.
        Nbuild_wheel)wheel_directoryrH   rM   )r   rJ   )r   rQ   rH   rM   r   r   r   rP      s    zPep517HookCaller.build_wheelc                 C   s   |  dd|iS )a<  Identify packages required for building a wheel

        Returns a list of dependency specifications, e.g.:
            ["setuptools >= 26"]

        This does not include requirements specified in pyproject.toml.
        It returns the result of calling the equivalently named hook in a
        subprocess.
        get_requires_for_build_sdistrH   rI   rK   r   r   r   rR      s    
 z-Pep517HookCaller.get_requires_for_build_sdistc                 C   s   |  dt||dS )zBuild an sdist from this project.

        Returns the name of the newly created file.

        This calls the 'build_sdist' backend hook in a subprocess.
        build_sdist)sdist_directoryrH   rO   )r   rT   rH   r   r   r   rS      s    zPep517HookCaller.build_sdistc           	   
   C   s@  t jd dkr| jd}n| j}d|i}| jrbtj| j}t jd dkrZ|t  }||d< t	 }d|i}t
j|t|ddd | j
t jt||g| j|d	 t
t|d
}|drt|dd
|drt|dd
|drt| j| j|dd
d|dr"t||d W  5 Q R  S Q R X d S )Nr      ASCIIZPEP517_BUILD_BACKENDZPEP517_BACKEND_PATHkwargsz
input.json)indent)r)   r1   zoutput.jsonZunsupportedr    Z
no_backendZbackend_invalidZ
backend_errorr   Zhook_missingZ
return_val)sysversion_inforB   encoder    r+   pathsepr   getfilesystemencodingr   r   Z
write_jsonpjoinrC   
executable_in_proc_scriptr=   Z	read_jsongetr(   r   r   r"   )	r   r$   rW   rB   r1   r    r   Z
hook_inputdatar   r   r   rJ      sB    


zPep517HookCaller._call_hook)NN)N)NT)NN)N)N)
r   r   r   r   r   r   rF   rG   rL   rP   rR   rS   rJ   r   r   r   r   r<   ]   s      

	
  
  


r<   c                   @   s<   e Zd ZdZdd Zdd Zedd Zdd	 Zd
d Z	dS )

LoggerWrapperzd
    Read messages from a pipe and redirect them
    to a logger (see python's logging module).
    c                 C   sH   t j|  d| _|| _|| _t \| _| _	t
| j| _|   d S )NT)
	threadingThreadr   Zdaemonloggerlevelr+   pipeZfd_readfd_writefdopenreaderstart)r   rg   rh   r   r   r   r     s    zLoggerWrapper.__init__c                 C   s   | j S r   )rj   r@   r   r   r   fileno  s    zLoggerWrapper.filenoc                 C   s   |  tjr| d d S | S )N)endswithr+   linesep)msgr   r   r   remove_newline!  s    zLoggerWrapper.remove_newlinec                 C   s    | j D ]}| | | qd S r   )rl   _writers   )r   liner   r   r   run%  s    
zLoggerWrapper.runc                 C   s   | j | j| d S r   )rg   logrh   )r   r!   r   r   r   rt   )  s    zLoggerWrapper._writeN)
r   r   r   r   r   rn   staticmethodrs   rv   rt   r   r   r   r   rd     s   

rd   )NN)NN)"re   
contextlibr   r+   Zos.pathr   r   r   r_   r
   
subprocessr   r   r   rZ   Ztempfiler	   rY   r   __file__ra   r   	Exceptionr   r   r"   r(   r2   r4   r;   objectr<   rf   rd   r   r   r   r   <module>   s*   

	
	 /PK       ! cB    '  pep517/__pycache__/check.cpython-38.pycnu [        U

    .e=                     @   s   d Z ddlZddlZddlZddlmZmZ ddlm	Z	m
Z ddlZddl
mZ ddlZddlZddlmZ ddlZddlmZ dd	lmZ dd
lmZ eeZdd Zd
d Zdd ZdddZ dddddZ!dd Z"edkre   dS )zHCheck a project and backend by attempting to build using PEP 517 hooks.
    N)isfilejoin)TomlDecodeErrorload)CalledProcessError)mkdtemp   )enable_colourful_output)BuildEnvironment)Pep517HookCallerc              
   C   s  t  }z|| td W n* tk
rL   td Y W 5 Q R  dS X z| i }td| W n. tk
r   tjddd Y W 5 Q R  dS X z|| td W n* tk
r   td	 Y W 5 Q R  dS X t }td
| zz| |i }td| W n4 tk
r@   tjddd Y W W 5 Q R  dS X |d
sltd| W W 5 Q R  dS t
||}t|rtd| ntd| W FW 5 Q R  dS t|rtd ntd W W 5 Q R  dS W 5 t	
| X W 5 Q R  dS Q R X d S )N#Installed static build dependencies+Failed to install static build dependenciesFGot build requires: %s'Failure in get_requires_for_build_sdistTexc_info$Installed dynamic build dependencies,Failed to install dynamic build dependencieszTrying to build sdist in %szbuild_sdist returned %rzFailure in build_sdistz.tar.gzz*Filename %s doesn't have .tar.gz extensionOutput file %s existsOutput file %s does not existzOutput file is a tar filezOutput file is not a tar file)r
   pip_installloginfor   errorZget_requires_for_build_sdist	Exceptionr   shutilrmtreeZbuild_sdistendswithpjoinr   tarfileZ
is_tarfilehooksZbuild_sys_requiresenvZreqsZtdfilenamepath r%   </usr/lib/python3.8/site-packages/pip/_vendor/pep517/check.pycheck_build_sdist   sZ    





 


r'   c              
   C   s  t  }z|| td W n* tk
rL   td Y W 5 Q R  dS X z| i }td| W n. tk
r   tjddd Y W 5 Q R  dS X z|| td W n* tk
r   td	 Y W 5 Q R  dS X t }td
| zz| |i }td| W n4 tk
r@   tjddd Y W W 5 Q R  dS X |d
sltd| W W 5 Q R  dS t
||}t|rtd| ntd| W FW 5 Q R  dS t|rtd ntd W W 5 Q R  dS W 5 t	
| X W 5 Q R  dS Q R X d S )Nr   r
   Fr   r   Tr   r   r   zTrying to build wheel in %szbuild_wheel returned %rzFailure in build_wheelz.whlz'Filename %s doesn't have .whl extensionr   r   zOutput file is a zip filezOutput file is not a zip file)r
   r   r   r   r   r   Zget_requires_for_build_wheelr   r   r   r   Zbuild_wheelr   r   r   zipfileZ
is_zipfiler    r%   r%   r&   check_build_wheelO   sT    








r)   c              	   C   s   t | d}t|rtd ntd dS zLt|}t|}W 5 Q R X |d }|d }|d }|d}td	 W n( tt	fk
r   tjd
dd Y dS X t
| ||}t||}	t||}
|	st
d
 |
st
d |	S )Nzpyproject.tomlzFound pyproject.tomlzMissing pyproject.tomlFzbuild-systemrequiresz
build-backendzbackend-pathzLoaded pyproject.tomlzInvalid pyproject.tomlTr   z%Sdist checks failed; scroll up to seezWheel checks failed)r   r   r   r   r   open	t