	NP   Z64Z32z%s%s.exerV   r   r   )structcalcsize__name__rsplitr   findbytes)r)   Zkindbitsr"   Zdistlib_packagerJ   r   r   r   rh   i  s    zScriptMaker._get_launcherc                 C   s6   g }t |}|dkr"| || n| j|||d |S )a  
        Make a script.

        :param specification: The specification, which is either a valid export
                              entry specification (to make a script from a
                              callable) or a filename (to make a script by
                              copying from a source location).
        :param options: A dictionary of options controlling script generation.
        :return: A list of all absolute pathnames written to.
        Nrz   )r	   r   r   )r)   
specificationr2   rs   r]   r   r   r   makew  s    zScriptMaker.makec                 C   s$   g }|D ]}| | || q|S )z
        Take a list of specifications and make scripts from them,
        :param specifications: A list of specifications.
        :return: A list of all absolute pathnames written to,
        )extendr   )r)   Zspecificationsr2   rs   r   r   r   r   
make_multiple  s    zScriptMaker.make_multiple)TFN)rL   N)N)N)N) r   
__module____qualname____doc__SCRIPT_TEMPLATErY   r   r+   r4   rG   rH   r   r=   r@   rK   rU   r^   _DEFAULT_MANIFESTra   rc   ry   r   r   propertyr*   setterr!   r"   r#   rh   r   r   r   r   r   r   r   C   s6       

84
4


r   )ior   Zloggingr!   rer   rG   compatr   r   r   Z	resourcesr   utilr   r	   r
   r   r   Z	getLoggerr   r:   stripr   compiler   r   r   objectr   r   r   r   r   <module>   s   


PK       ! +Zg  g  1  distlib/__pycache__/metadata.cpython-38.opt-1.pycnu [        U

    .e*                     @   s  d Z ddlmZ ddlZddlmZ ddlZddlZddlZddl	m
Z
mZ ddlm
Z
mZmZ ddlmZ dd	lmZmZ dd
lmZmZ eeZG dd de
ZG d
d de
ZG dd de
ZG dd de
ZdddgZdZ dZ!e"dZ#e"dZ$dZ%dZ&dZ'dZ(dZ)dZ*d Z+e*d! Z,d"Z-e. Z/e/0e% e/0e& e/0e( e/0e* e/0e, e"d#Z1d$d% Z2d&d' Z3d(d)d*d+d,d-d.d/d0d1d2d3d4d5d6d7d8d9d:d;d<d=d>d?d@dAdBdCdDdEdFZ4dGZ5dHZ6dIZ7dJZ8dKZ9dLZ:dMZ;e< Z=e"dNZ>dXdPdQZ?G dRdS dSe<Z@dTZAdUZBdVZCG dWd de<ZDdS )YzImplementation of the Metadata for Python packages PEPs.

Supports all metadata formats (1.0, 1.1, 1.2, and 2.0 experimental).
    )unicode_literalsN)message_from_file   )DistlibException__version__)StringIOstring_types	text_type)	interpret)extract_by_key
get_extras)
get_schemePEP440_VERSION_REc                   @   s   e Zd ZdZdS )MetadataMissingErrorzA required metadata is missingN__name__
__module____qualname____doc__ r   r   @/usr/lib/python3.8/site-packages/pip/_vendor/distlib/metadata.pyr      s   r   c                   @   s   e Zd ZdZdS )MetadataConflictErrorz>Attempt to read or write metadata fields that are conflictual.Nr   r   r   r   r   r       s   r   c                   @   s   e Zd ZdZdS ) MetadataUnrecognizedVersionErrorz Unknown metadata version number.Nr   r   r   r   r   r   $   s   r   c                   @   s   e Zd ZdZdS )MetadataInvalidErrorzA metadata value is invalidNr   r   r   r   r   r   (   s   r   MetadataPKG_INFO_ENCODINGPKG_INFO_PREFERRED_VERSIONutf-81.1z

       \|	
        )Metadata-VersionNameVersionPlatformSummaryDescriptionKeywords	Home-pageAuthorAuthor-emailLicense)r    r!   r"   r#   Supported-Platformr$   r%   r&   r'   r(   r)   r*   
ClassifierDownload-URL	ObsoletesProvidesRequires)r.   r/   r0   r,   r-   )r    r!   r"   r#   r+   r$   r%   r&   r'   r(   r)   
MaintainerMaintainer-emailr*   r,   r-   Obsoletes-DistProject-URL
Provides-Dist
Requires-DistRequires-PythonRequires-External)r5   r6   r7   r3   r8   r1   r2   r4   )r    r!   r"   r#   r+   r$   r%   r&   r'   r(   r)   r1   r2   r*   r,   r-   r3   r4   r5   r6   r7   r8   Private-VersionObsoleted-BySetup-Requires-Dist	ExtensionProvides-Extra)r9   r=   r:   r;   r<   )Description-Content-Typer0   r/   )r>   z"extra\s*==\s*("([^"]+)"|'([^']+)')c                 C   sL   | dkrt S | dkrtS | dkr$tS | dkr4tt S | dkr@tS t| d S )N1.0r   1.2)1.32.12.0)_241_FIELDS_314_FIELDS_345_FIELDS_566_FIELDS_426_FIELDSr   )versionr   r   r   _version2fieldlistp   s    rJ   c           
      C   sB  dd }g }|   D ]"\}}|g ddfkr,q|| qddddd	d
g}|D ]}|tkrvd|krv|d td| |tkrd|kr|d td| |tkrd|kr|d td
| |tkrd|kr|d td| |tkrd
|kr|dkr|d
 td| |t	krLd	|krL|d	 td| qLt
|dkrZ|d S t
|dkr|td|  tdd|ko||t}d|ko||t
}d
|ko||t}d	|ko||t}	t|t| t| t|	 dkrtd|s |s |s |	s t|kr tS |r*dS |r4dS |r>d
S d	S )z5Detect the best version depending on the fields used.c                 S   s   |D ]}|| kr dS qdS )NTFr   )keysmarkersmarkerr   r   r   _has_marker   s    z"_best_version.<locals>._has_markerUNKNOWNNr?   r   r@   rA   rC   rB   zRemoved 1.0 due to %szRemoved 1.1 due to %szRemoved 1.2 due to %szRemoved 1.3 due to %sr%   zRemoved 2.1 due to %szRemoved 2.0 due to %sr   r   z)Out of options - unknown metadata set: %szUnknown metadata setz,You used incompatible 1.1/1.2/2.0/2.1 fields)itemsappendrD   removeloggerdebugrE   rF   rG   rH   lenr   _314_MARKERS_345_MARKERS_566_MARKERS_426_MARKERSintr   )
fieldsrN   rK   keyvalueZpossible_versionsZis_1_1Zis_1_2Zis_2_1Zis_2_0r   r   r   
_best_version~   s`    






&
r^   r    r!   r"   r#   r+   r$   r%   r&   r'   r(   r)   r1   r2   r*   r,   r-   r3   r5   r6   r;   r7   r8   r0   r/   r.   r4   r9   r:   r<   r=   )metadata_versionnamerI   platformZsupported_platformsummarydescriptionkeywords	home_pageauthorauthor_email
maintainermaintainer_emaillicense
classifierdownload_urlobsoletes_dist
provides_dist
requires_distsetup_requires_distrequires_pythonrequires_externalrequiresprovides	obsoletesproject_urlZprivate_versionZobsoleted_by	extensionZprovides_extra)r6   r3   r5   )r7   )r"   )r#   r,   r.   r0   r/   r3   r5   r6   r8   r4   r+   r;   r=   r<   )r4   )r&   )r(   r1   r$   r%   z[^A-Za-z0-9.]+Fc                 C   s0   |r$t d| } t d|dd}d| |f S )zhReturn the distribution name with version.

    If for_filename is true, return a filename-escaped form.- .z%s-%s)	_FILESAFEsubreplace)r`   rI   Zfor_filenamer   r   r   _get_name_and_version   s    r~   c                   @   s
  e Zd ZdZd?ddZdd Zdd	 Zd
d Zdd
 Zdd Z	dd Z
dd Zdd Zdd Z
dd Zd@ddZdd Zdd  Zd!d" Zd#d$ ZdAd%d&ZdBd'd(ZdCd)d*Zd+d, Zefd-d.ZdDd/d0ZdEd1d2Zd3d4 Zd5d6 Zd7d8 Zd9d: Zd;d< Z d=d> Z!dS )FLegacyMetadataaa  The legacy metadata of a release.

    Supports versions 1.0, 1.1 and 1.2 (auto-detected). You can
    instantiate the class with one of these arguments (or none):
    - *path*, the path to a metadata file
    - *fileobj* give a file-like object with metadata as content
    - *mapping* is a dict-like object
    - *scheme* is a version scheme name
    Ndefaultc                 C   sz   |||g d dk rtdi | _g | _d | _|| _|d k	rH| | n.|d k	r\| | n|d k	rv| | | 	  d S )N   'path, fileobj and mapping are exclusive)
count	TypeError_fieldsZrequires_filesZ
_dependenciesschemeread	read_fileupdateset_metadata_version)selfpathfileobjmappingr   r   r   r   __init__  s    
zLegacyMetadata.__init__c                 C   s   t | j| jd< d S Nr    )r^   r   r   r   r   r   r   "  s    z#LegacyMetadata.set_metadata_versionc                 C   s   | d||f  d S )Nz%s: %s
)write)r   r   r`   r]   r   r   r   _write_field%  s    zLegacyMetadata._write_fieldc                 C   s
   |  |S N)getr   r`   r   r   r   __getitem__(  s    zLegacyMetadata.__getitem__c                 C   s   |  ||S r   )set)r   r`   r]   r   r   r   __setitem__+  s    zLegacyMetadata.__setitem__c                 C   s8   |  |}z| j|= W n tk
r2   t|Y nX d S r   )
_convert_namer   KeyError)r   r`   
field_namer   r   r   __delitem__.  s
    
zLegacyMetadata.__delitem__c                 C   s   || j kp| || j kS r   )r   r   r   r   r   r   __contains__5  s    
zLegacyMetadata.__contains__c                 C   s(   |t kr|S |dd }t||S )Nrx   _)_ALL_FIELDSr}   lower_ATTR2FIELDr   r   r   r   r   r   9  s    zLegacyMetadata._convert_namec                 C   s   |t ks|tkrg S dS )NrO   )_LISTFIELDS_ELEMENTSFIELDr   r   r   r   _default_value?  s    zLegacyMetadata._default_valuec                 C   s&   | j dkrtd|S td|S d S )Nr?   r   
)r_   _LINE_PREFIX_PRE_1_2r|   _LINE_PREFIX_1_2r   r]   r   r   r   _remove_line_prefixD  s    
z"LegacyMetadata._remove_line_prefixc                 C   s   |t kr| | S t|d S r   )r   AttributeErrorr   r   r   r   __getattr__J  s    zLegacyMetadata.__getattr__Fc                 C   s   t | d | d |S )zhReturn the distribution name with version.

        If filesafe is true, return a filename-escaped form.r!   r"   )r~   )r   Zfilesafer   r   r   get_fullnameU  s    zLegacyMetadata.get_fullnamec                 C   s   |  |}|tkS )z+return True if name is a valid metadata key)r   r   r   r   r   r   is_field[  s    
zLegacyMetadata.is_fieldc                 C   s   |  |}|tkS r   )r   r   r   r   r   r   is_multi_field`  s    
zLegacyMetadata.is_multi_fieldc                 C   s.   t j|ddd}z| | W 5 |  X dS )z*Read the metadata values from a file path.rr   encodingN)codecsopencloser   )r   filepathfpr   r   r   r   d  s    zLegacyMetadata.readc                 C   s   t |}|d | jd< tD ]p}||kr(q|tkrf||}|tkrX|dk	rXdd |D }| || q|| }|dk	r|dkr| || qdS )z,Read the metadata values from a file object.zmetadata-versionr    Nc                 S   s   g | ]}t |d qS ,)tuplesplit.0r]   r   r   r   
<listcomp>y  s     z,LegacyMetadata.read_file.<locals>.<listcomp>rO   )r   r   r   r   Zget_all_LISTTUPLEFIELDSr   )r   Zfileobmsgfieldvaluesr]   r   r   r   r   l  s    
zLegacyMetadata.read_filec                 C   s0   t j|ddd}z| || W 5 |  X dS )z&Write the metadata fields to filepath.wr   r   N)r   r   r   
write_file)r   r   skip_unknownr   r   r   r   r     s    zLegacyMetadata.writec                 C   s   |    t| d D ]}| |}|r8|dg dgfkr8q|tkrV| ||d| q|tkr|dkr| jdkr~|dd}n|dd}|g}|t	krd	d
 |D }|D ]}| ||| qqdS )z0Write the PKG-INFO format data to a file object.r    rO   r   r%   r   r   r   z	
       |c                 S   s   g | ]}d  |qS r   joinr   r   r   r   r     s     z-LegacyMetadata.write_file.<locals>.<listcomp>N)
r   rJ   r   r   r   r   r   r_   r}   r   )r   Z
fileobjectr   r   r   r]   r   r   r   r     s$    

zLegacyMetadata.write_filec                    sv    fdd}|sn@t |dr:| D ]}||||  q$n|D ]\}}||| q>|rr| D ]\}}||| q^dS )a  Set metadata values from the given iterable `other` and kwargs.

        Behavior is like `dict.update`: If `other` has a ``keys`` method,
        they are looped over and ``self[key]`` is assigned ``other[key]``.
        Else, ``other`` is an iterable of ``(key, value)`` iterables.

        Keys that don't match a metadata field or that have an empty value are
        dropped.
        c                    s"   | t kr|r  | | d S r   )r   r   r   )r\   r]   r   r   r   _set  s    z#LegacyMetadata.update.<locals>._setrK   N)hasattrrK   rP   )r   otherkwargsr   kvr   r   r   r     s    

zLegacyMetadata.updatec                 C   sh  |  |}|tks|dkrNt|ttfsNt|trHdd |dD }qzg }n,|tkrzt|ttfszt|trv|g}ng }t	t
jr<| d }t| j
}|tkr|dk	r|D ](}||dd std	||| qnb|tkr|dk	r||s<td
||| n0|tkr<|dk	r<||s<td
||| |tkrZ|dkrZ| |}|| j|< dS )z"Control then set a metadata field.r#   c                 S   s   g | ]}|  qS r   )strip)r   r   r   r   r   r     s     z&LegacyMetadata.set.<locals>.<listcomp>r   r!   N;r   z$'%s': '%s' is not valid (field '%s')z.'%s': '%s' is not a valid version (field '%s')r%   )r   r   
isinstancelistr   r   r   r   rS   ZisEnabledForloggingZWARNINGr
   r   _PREDICATE_FIELDSis_valid_matcherwarning_VERSIONS_FIELDSis_valid_constraint_list_VERSION_FIELDSis_valid_version_UNICODEFIELDSr   r   )r   r`   r]   Zproject_namer   r   r   r   r   r     sV    



      


zLegacyMetadata.setc                 C   s   |  |}|| jkr*|tkr&| |}|S |tkr@| j| }|S |tkr| j| }|dkr^g S g }|D ].}|tkr~|| qf||d |d f qf|S |tkr| j| }t	|t
r|dS | j| S )zGet a metadata field.Nr   r   r   )r   r   _MISSINGr   r   r   r   rQ   r   r   r   r   )r   r`   r   r]   resvalr   r   r   r     s.    







zLegacyMetadata.getc                    s   |    g g  }}dD ]}|| kr|| q|rP|g krPdd| }t|dD ]}|| krT|| qT| d dkr||fS t| j  fdd}t|ft jft	 j
ffD ]@\}}|D ]2}	| |	d	}
|
d	k	r||
s|d
|	|
f  qq||fS )zkCheck if the metadata is compliant. If strict is True then raise if
        no Name or Version are provided)r!   r"   zmissing required metadata: %s, )r'   r(   r    r@   c                    s(   | D ]}  |dd s dS qdS )Nr   r   FT)r   r   )r]   r   r   r   r   are_valid_constraints#  s    z3LegacyMetadata.check.<locals>.are_valid_constraintsNzWrong value for '%s': %s)r   rQ   r   r   r
   r   r   r   r   r   r   r   )r   strictmissingwarningsattrr   r   r[   Z
controllerr   r]   r   r   r   check	  s8    

zLegacyMetadata.checkc                 C   s   |    d}i }|D ]"\}}|r*|| jkr| | ||< q| d dkrd}|D ]B\}}|rb|| jkrL|dkrx| | ||< qLdd | | D ||< qLn8| d dkrd	}|D ]"\}}|r|| jkr| | ||< q|S )
zReturn fields as a dict.

        Field names will be converted to use the underscore-lowercase style
        instead of hyphen-mixed case (i.e. home_page instead of Home-page).
        )
)r_   r    )r`   r!   )rI   r"   )rb   r$   )re   r'   )rf   r(   )rg   r)   )rj   r*   )rc   r%   )rd   r&   )ra   r#   )classifiersr,   )rl   r-   r    r@   ))ro   r6   )rq   r7   )rr   r8   )rn   r5   )rm   r3   )rv   r4   )rh   r1   )ri   r2   rv   c                 S   s   g | ]}d  |qS r   r   )r   ur   r   r   r   b  s     z)LegacyMetadata.todict.<locals>.<listcomp>r   ))rt   r/   )rs   r0   )ru   r.   )r   r   )r   Zskip_missingZmapping_1_0datar\   r   Zmapping_1_2Zmapping_1_1r   r   r   todict5  s&    
zLegacyMetadata.todictc                 C   s8   | d dkr$dD ]}|| kr| |= q| d  |7  < d S )Nr    r   )r.   r0   r/   r6   r   )r   requirementsr   r   r   r   add_requirementsp  s
    zLegacyMetadata.add_requirementsc                 C   s   t t| d S r   )r   rJ   r   r   r   r   rK   {  s    zLegacyMetadata.keysc                 c   s   |   D ]
}|V  qd S r   rK   )r   r\   r   r   r   __iter__~  s    zLegacyMetadata.__iter__c                    s    fdd   D S )Nc                    s   g | ]} | qS r   r   r   r\   r   r   r   r     s     z)LegacyMetadata.values.<locals>.<listcomp>r   r   r   r   r   r     s    zLegacyMetadata.valuesc                    s    fdd   D S )Nc                    s   g | ]}| | fqS r   r   r   r   r   r   r     s     z(LegacyMetadata.items.<locals>.<listcomp>r   r   r   r   r   rP     s    zLegacyMetadata.itemsc                 C   s   d| j j| j| jf S )Nz
<%s %s %s>)	__class__r   r`   rI   r   r   r   r   __repr__  s    zLegacyMetadata.__repr__)NNNr   )F)F)F)N)F)F)"r   r   r   r   r   r   r   r   r   r   r   r   r   r   r   r   r   r   r   r   r   r   r   r   r   r   r   r   r   rK   r   r   rP   r   r   r   r   r   r     s@     




,
,
;r   zpydist.jsonz
metadata.jsonZMETADATAc                   @   s  e Zd ZdZedZedejZe	Z
edZdZde
 Zdddd	Zd
ZdZedfedfe
dfedfdZd
ZdDddZedZdefZdefZdefdefeeedefeeeedefddd
Z[[dd ZdEddZdd Zed d! Z ed"d# Z!e!j"d$d# Z!dFd%d&Z#ed'd( Z$ed)d* Z%e%j"d+d* Z%d,d- Z&d.d/ Z'd0d1 Z(d2d3 Z)d4d5d6d7d8dd9Z*d:d; Z+dGd>d?Z,d@dA Z-dBdC Z.dS )Hr   z
    The metadata of a release. This implementation uses 2.0 (JSON)
    metadata where possible. If not possible, it wraps a LegacyMetadata
    instance which handles the key-value metadata format.
    z
^\d+(\.\d+)*$z!^[0-9A-Z]([0-9A-Z_.-]*[0-9A-Z])?$z	.{1,2047}rC   zdistlib (%s)r   )legacy)r`   rI   rb   zqname version license summary description author author_email keywords platform home_page classifiers download_urlzwextras run_requires test_requires build_requires dev_requires provides meta_requires obsoleted_by supports_environments)r_   r`   rI   rb   )_legacy_datar   Nr   c              	   C   s0  |||g d dk rtdd | _d | _|| _|d k	rzz| || || _W n* tk
rv   t||d| _|   Y nX nd }|rt	|d}|
 }W 5 Q R X n|r|
 }|d kr| j| jd| _ndt
|ts|d}zt|| _| | j| W n0 tk
r*   tt||d| _|   Y nX d S )Nr   r   )r   r   rbr_   	generatorr   )r   r   )r   r   r   r   r   _validate_mappingr   r   validater   r   METADATA_VERSION	GENERATORr   r	   decodejsonloads
ValueErrorr   )r   r   r   r   r   r   fr   r   r   r     s@    



zMetadata.__init__)r`   rI   rj   rd   rb   r6   r;   r=   r,   )r-   N)r    N)
run_requiresbuild_requiresdev_requiresZ
test_requires
meta_requiresextrasmodules
namespacesexportscommandsr   Z
source_urlr_   c           
      C   sX  t | d}t | d}||kr|| \}}| jr^|d krP|d krHd n| }n| j|}n|d krjd n| }|dkr| j||}nt  }|}| jd}	|	r
|dkr|	d|}nP|dkr|	d}	|	r|	||}n,|	d	}	|	s| jd	}	|	r
|	||}||krT|}n:||kr2t | |}n"| jrH| j|}n| j|}|S )
Ncommon_keysmapped_keysr	  r  r  r  r   
extensionsr	  python.commandsr   python.detailspython.exports)object__getattribute__r   r   r   )
r   r\   commonmappedlkZmakerresultr]   sentineldr   r   r   r     sD    




zMetadata.__getattribute__c                 C   sH   || j krD| j | \}}|p | j|krD||}|sDtd||f d S )Nz.'%s' is an invalid value for the '%s' property)SYNTAX_VALIDATORSr   matchr   )r   r\   r]   r   pattern
exclusionsmr   r   r   _validate_value+  s    

zMetadata._validate_valuec                 C   s*  |  || t| d}t| d}||kr|| \}}| jrV|d krJt|| j|< nf|dkrj|| j|< nR| jdi }|dkr||d< n2|dkr|di }|||< n|d	i }|||< nh||krt| || nP|d
krt|t	r|
 }|r| }ng }| jr|| j|< n
|| j|< d S )Nr
  r  r  r
  r	  r  r   r  r  rd   )r  r  r  r   NotImplementedErrorr   
setdefault__setattr__r   r   r   r   )r   r\   r]   r  r  r  r   r  r   r   r   r!  5  s<    




zMetadata.__setattr__c                 C   s   t | j| jdS NT)r~   r`   rI   r   r   r   r   name_and_version\  s    zMetadata.name_and_versionc                 C   sF   | j r| j d }n| jdg }d| j| jf }||krB|| |S )Nr5   rt   z%s (%s))r   r   r   r`   rI   rQ   )r   r  sr   r   r   rt   `  s    
zMetadata.providesc                 C   s    | j r|| j d< n
|| jd< d S )Nr5   rt   )r   r   r   r   r   r   rt   k  s    c           
      C   s   | j r|}ng }t|pg | j}|D ]d}d|kr>d|kr>d}n8d|krLd}n|d|k}|rv|d}|rvt||}|r$||d  q$dD ]F}d| }	|	|kr||	 | jd| g }|| j|||d q|S )	a  
        Base method to get dependencies, given a set of extras
        to satisfy and an optional environment context.
        :param reqts: A list of sometimes-wanted dependencies,
                      perhaps dependent on extras and environment.
        :param extras: A list of optional components being requested.
        :param env: An optional environment for marker evaluation.
        extraenvironmentTrs   )ZbuildZdevZtestz:%s:z%s_requires)r  env)	r   r   r  r   r
   extendrR   r   get_requirements)
r   reqtsr  r'  r  r  ZincluderM   r\   er   r   r   r)  r  s2    	



zMetadata.get_requirementsc                 C   s   | j r|  S | jS r   )r   _from_legacyr   r   r   r   r   
dictionary  s    zMetadata.dictionaryc                 C   s   | j rtnt| j| jS d S r   )r   r  r   r   DEPENDENCY_KEYSr   r   r   r   dependencies  s    zMetadata.dependenciesc                 C   s   | j rtn| j| d S r   )r   r  r   r   r   r   r   r   r/    s    c           	      C   s   | d| jkrt g }| j D ]"\}}||kr$||kr$|| q$|rbdd| }t|| D ]\}}| ||| qjd S )Nr_   zMissing metadata items: %sr   )	r   r   r   MANDATORY_KEYSrP   rQ   r   r   r  )	r   r   r   r   r\   r  r   r   r   r   r   r   r     s    zMetadata._validate_mappingc                 C   sB   | j r.| j d\}}|s|r>td|| n| | j| j d S )NTz#Metadata: missing: %s, warnings: %s)r   r   rS   r   r   r   r   )r   r   r   r   r   r   r     s     zMetadata.validatec                 C   s(   | j r| j dS t| j| j}|S d S r"  )r   r   r   r   
INDEX_KEYS)r   r  r   r   r   r     s    zMetadata.todictc           
      C   s   | j | jd}| jd}dD ]*}||kr|dkr8d}n|}|| ||< q|dg }|dgkrdg }||d< d	}|D ]*\}}||krt|| rtd
|| ig||< qt| j|d< i }i }	|S )Nr   T)r`   rI   rj   rb   rc   rk   rk   r   r&    rd   ))ro   r  )rp   r  rs   rt   )r   r   r   r   r   rt   )
r   r  Zlmdr   nkkwrK   okrf   rh   r   r   r   r,    s,    

zMetadata._from_legacyr!   r"   r*   r$   r%   )r`   rI   rj   rb   rc   r   c                 C   s   dd }t  }| j}| j D ]\}}||kr|| ||< q|| j| j }|| j| j }| jrpt	| j|d< t	||d< t	||d< |S )Nc                 S   s   t  }| D ]|}|d}|d}|d }|D ]V}|sF|sF|| q.d}|rVd| }|rp|rld||f }n|}|d||f q.q
|S )Nr%  r&  rs   r2  z
extra == "%s"z(%s) and %sr   )r   r   addr   )entriesr*  r+  r%  r'  Zrlistr   rM   r   r   r   process_entries  s"    

z,Metadata._to_legacy.<locals>.process_entriesr=   r6   r;   )
r   r   LEGACY_MAPPINGrP   r  r  r  r  r  sorted)r   r8  r  Znmdr3  r5  Zr1Zr2r   r   r   
_to_legacy  s    zMetadata._to_legacyFTc              	   C   s   ||g d dkrtd|   |r`| jr4| j}n|  }|rP|j||d q|j||d n^| jrp|  }n| j}|rt	j
||dddd n.t|dd}t	j
||dddd W 5 Q R X d S )	Nr   z)Exactly one of path and fileobj is needed)r   Tr   )Zensure_asciiindentZ	sort_keysr   r   )
r   r   r   r   r;  r   r   r,  r   r   dumpr   r   )r   r   r   r   r   Z	legacy_mdr  r   r   r   r   r     s*    
zMetadata.writec                 C   s   | j r| j | nr| jdg }d }|D ]}d|kr*d|kr*|} qHq*|d krfd|i}|d| n t|d t|B }t||d< d S )Nr  r&  r%  rs   r   )r   r   r   r   insertr   r:  )r   r   r  alwaysentryZrsetr   r   r   r   3  s    zMetadata.add_requirementsc                 C   s*   | j pd}| jpd}d| jj| j||f S )Nz	(no name)z
no versionz<%s %s %s (%s)>)r`   rI   r   r   r_   )r   r`   rI   r   r   r   r   D  s    

  zMetadata.__repr__)NNNr   )N)NN)NNFT)/r   r   r   r   recompileZMETADATA_VERSION_MATCHERIZNAME_MATCHERr   ZVERSION_MATCHERZSUMMARY_MATCHERr   r   r   r0  r1  r.  r  	__slots__r   r   r
  r   Z	none_listdictZ	none_dictr  r  r  r!  propertyr#  rt   setterr)  r-  r/  r   r   r   r,  r9  r;  r   r   r   r   r   r   r   r     s   

  
-+

'




*


		%
)F)Er   Z
__future__r   r   Zemailr   r   r   rA  r2  r   r   compatr   r   r	   rL   r
   utilr   r   rI   r
   r   Z	getLoggerr   rS   r   r   r   r   __all__r   r   rB  r   r   rD   rE   rV   rF   rW   rH   rY   rG   rX   r   r   r   ZEXTRA_RErJ   r^   r   r   r   r   r   r   r   r   r  r   r{   r~   r   ZMETADATA_FILENAMEZWHEEL_METADATA_FILENAMEZLEGACY_METADATA_FILENAMEr   r   r   r   r   <module>   s   










H!


   
PK       ! *  *  ,  distlib/__pycache__/resources.cpython-38.pycnu [        U

    .e*                  	   @   s  d dl mZ d dlZd dlZd dlZd dlZd dlZd dlZd dlZd dl	Z	d dl
Z
ddlmZ ddl
mZmZmZmZ eeZdaG dd deZG dd	 d	eZG d
d deZG dd
 d
eZG dd deZG dd deZedee
jeiZzFzd dl Z!W n e"k
r$   d dl#Z!Y nX eee!j$< eee!j%< [!W n e"e&fk
rX   Y nX dd Z'i Z(dd Z)e	*e+dZ,dd Z-dS )    )unicode_literalsN   )DistlibException)cached_propertyget_cache_basepath_to_cache_dirCachec                       s.   e Zd Zd fdd	Zdd Zdd Z  ZS )	
ResourceCacheNc                    s0   |d krt jt td}tt| | d S )Nzresource-cache)ospathjoinr   strsuperr	   __init__)selfbase	__class__ A/usr/lib/python3.8/site-packages/pip/_vendor/distlib/resources.pyr      s    zResourceCache.__init__c                 C   s   dS )z
        Is the cache stale for the given resource?

        :param resource: The :class:`Resource` being cached.
        :param path: The path of the resource in the cache.
        :return: True if the cache is stale.
        Tr   r   resourcer   r   r   r   is_stale#   s    	zResourceCache.is_stalec              	   C   s   |j |\}}|dkr|}n~tj| j| ||}tj|}tj|sXt	| tj
|sjd}n| ||}|rt|d}|
|j W 5 Q R X |S )z
        Get a resource into the cache,

        :param resource: A :class:`Resource` instance.
        :return: The pathname of the resource in the cache.
        NTwb)finderget_cache_infor
   r   r   r   Z
prefix_to_dirdirnameisdirmakedirsexistsr   openwritebytes)r   r   prefixr   resultr   Zstalefr   r   r   get.   s    
zResourceCache.get)N)__name__
__module____qualname__r   r   r&   
__classcell__r   r   r   r   r	      s   r	   c                   @   s   e Zd Zdd ZdS )ResourceBasec                 C   s   || _ || _d S N)r   name)r   r   r-   r   r   r   r   I   s    zResourceBase.__init__N)r'   r(   r)   r   r   r   r   r   r+   H   s   r+   c                   @   s@   e Zd ZdZdZdd Zedd Zedd Zed	d
 Z	dS )Resourcez
    A class representing an in-package resource, such as a data file. This is
    not normally instantiated by user code, but rather by a
    :class:`ResourceFinder` which manages the resource.
    Fc                 C   s   | j | S )z
        Get the resource as a stream.

        This is not a property to make it obvious that it returns a new stream
        each time.
        )r   
get_streamr   r   r   r   	as_streamV   s    zResource.as_streamc                 C   s   t d krt a t | S r,   )cacher	   r&   r0   r   r   r   	file_path_   s    zResource.file_pathc                 C   s   | j | S r,   )r   	get_bytesr0   r   r   r   r"   f   s    zResource.bytesc                 C   s   | j | S r,   )r   get_sizer0   r   r   r   sizej   s    z
Resource.sizeN)
r'   r(   r)   __doc__is_containerr1   r   r3   r"   r6   r   r   r   r   r.   N   s   	

r.   c                   @   s   e Zd ZdZedd ZdS )ResourceContainerTc                 C   s   | j | S r,   )r   
get_resourcesr0   r   r   r   	resourcesr   s    zResourceContainer.resourcesN)r'   r(   r)   r8   r   r;   r   r   r   r   r9   o   s   r9   c                   @   s   e Zd ZdZejdrdZndZdd Zdd Z	d	d
 Z
dd Zd
d Zdd Z
dd Zdd Zdd Zdd Zdd ZeejjZdd ZdS )ResourceFinderz4
    Resource finder for file system resources.
    java).pyc.pyoz.class)r>   r?   c                 C   s.   || _ t|dd | _tjt|dd| _d S )N
__loader____file__ )modulegetattrloaderr
   r   r   r   )r   rC   r   r   r   r      s    zResourceFinder.__init__c                 C   s   t j|S r,   )r
   r   realpathr   r   r   r   r   _adjust_path   s    zResourceFinder._adjust_pathc                 C   sB   t |trd}nd}||}|d| j tjj| }| |S )N   //r   )	
isinstancer"   splitinsertr   r
   r   r   rH   )r   
resource_nameseppartsr$   r   r   r   
_make_path   s    

zResourceFinder._make_pathc                 C   s   t j|S r,   )r
   r   r   rG   r   r   r   _find   s    zResourceFinder._findc                 C   s
   d |j fS r,   )r   r   r   r   r   r   r      s    zResourceFinder.get_cache_infoc                 C   sD   |  |}| |sd }n&| |r0t| |}n
t| |}||_|S r,   )rQ   rR   
_is_directoryr9   r.   r   )r   rN   r   r$   r   r   r   find   s    



zResourceFinder.findc                 C   s   t |jdS Nrb)r    r   rS   r   r   r   r/      s    zResourceFinder.get_streamc              
   C   s,   t |jd}| W  5 Q R  S Q R X d S rV   )r    r   read)r   r   r%   r   r   r   r4      s    zResourceFinder.get_bytesc                 C   s   t j|jS r,   )r
   r   getsizerS   r   r   r   r5      s    zResourceFinder.get_sizec                    s*   fdd t  fddt|jD S )Nc                    s   | dko|   j S )N__pycache__)endswithskipped_extensions)r%   r0   r   r   allowed   s    
z-ResourceFinder.get_resources.<locals>.allowedc                    s   g | ]} |r|qS r   r   ).0r%   )r]   r   r   
<listcomp>   s      z0ResourceFinder.get_resources.<locals>.<listcomp>)setr
   listdirr   rS   r   )r]   r   r   r:      s    zResourceFinder.get_resourcesc                 C   s   |  |jS r,   )rT   r   rS   r   r   r   r8      s    zResourceFinder.is_containerc                 c   s   |  |}|d k	r|g}|r|d}|V  |jr|j}|jD ]>}|sL|}nd||g}|  |}|jrv|| q>|V  q>qd S )Nr   rJ   )rU   popr8   r-   r;   r   append)r   rN   r   ZtodoZrnamer-   new_nameZchildr   r   r   iterator   s     



zResourceFinder.iteratorN)r'   r(   r)   r7   sysplatform
startswithr\   r   rH   rQ   rR   r   rU   r/   r4   r5   r:   r8   staticmethodr
   r   r   rT   re   r   r   r   r   r<   w   s"   r<   c                       s`   e Zd ZdZ fddZdd Zdd Zdd	 Zd
d Zdd
 Z	dd Z
dd Zdd Z  Z
S )ZipResourceFinderz6
    Resource finder for resources in .zip files.
    c                    sZ   t t| | | jj}dt| | _t| jdr>| jj| _nt	j
| | _t| j| _d S )Nr   _files)
r   rj   r   rE   archivelen
prefix_lenhasattrrk   	zipimport_zip_directory_cachesortedindex)r   rC   rl   r   r   r   r      s    zZipResourceFinder.__init__c                 C   s   |S r,   r   rG   r   r   r   rH      s    zZipResourceFinder._adjust_pathc                 C   s   || j d  }|| jkrd}nX|r:|d tjkr:|tj }t| j|}z| j| |}W n tk
rt   d}Y nX |st	d|| j
j nt	d|| j
j |S )NTFz_find failed: %r %rz_find worked: %r %r)rn   rk   r
   rO   bisectrs   rh   
IndexErrorloggerdebugrE   r#   )r   r   r$   ir   r   r   rR      s    


zZipResourceFinder._findc                 C   s&   | j j}|jdt| d  }||fS )Nr   )rE   rl   r   rm   )r   r   r#   r   r   r   r   r      s    z ZipResourceFinder.get_cache_infoc                 C   s   | j |jS r,   )rE   get_datar   rS   r   r   r   r4      s    zZipResourceFinder.get_bytesc                 C   s   t | |S r,   )ioBytesIOr4   rS   r   r   r   r/      s    zZipResourceFinder.get_streamc                 C   s   |j | jd  }| j| d S )N   )r   rn   rk   r   r   r   r   r5      s    zZipResourceFinder.get_sizec                 C   s   |j | jd  }|r,|d tjkr,|tj7 }t|}t }t| j|}|t| jk r| j| |shq| j| |d  }|	|
tjdd  |d7 }qH|S )Nrt   r   r   )r   rn   r
   rO   rm   r`   ru   rs   rh   addrL   )r   r   r   Zplenr$   ry   sr   r   r   r:     s    

zZipResourceFinder.get_resourcesc                 C   sj   || j d  }|r*|d tjkr*|tj7 }t| j|}z| j| |}W n tk
rd   d}Y nX |S )Nrt   F)rn   r
   rO   ru   rs   rh   rv   )r   r   ry   r$   r   r   r   rT     s    

zZipResourceFinder._is_directory)r'   r(   r)   r7   r   rH   rR   r   r4   r/   r5   r:   rT   r*   r   r   r   r   rj      s   rj   c                 C   s   |t t| < d S r,   )_finder_registrytype)rE   finder_makerr   r   r   register_finder0  s    r   c                 C   s   | t krt |  }nv| tjkr$t|  tj|  }t|dd}|dkrJtdt|dd}tt|}|dkrxtd|  ||}|t | < |S )z
    Return a resource finder for a package.
    :param package: The name of the package.
    :return: A :class:`ResourceFinder` instance for the package.
    __path__Nz8You cannot get a finder for a module, only for a packager@   zUnable to locate finder for %r)	
_finder_cacherf   modules
__import__rD   r   r   r&   r   )packager$   rC   r   rE   r   r   r   r   r   6  s    


r   Z	__dummy__c                 C   sR   d}t |  tj| }tt|}|rNt}tj	
| d|_||_||}|S )z
    Return a resource finder for a path, which should represent a container.

    :param path: The path.
    :return: A :class:`ResourceFinder` instance for the path.
    NrB   )
pkgutilZget_importerrf   path_importer_cacher&   r   r   
_dummy_moduler
   r   r   rA   r@   )r   r$   rE   r   rC   r   r   r   finder_for_pathR  s    
r   ).Z
__future__r   ru   r{   Zloggingr
   r   Zshutilrf   typesrp   rB   r   utilr   r   r   r   Z	getLoggerr'   rw   r2   r	   objectr+   r.   r9   r<   rj   r   zipimporterr   _frozen_importlib_externalZ_fiImportError_frozen_importlibSourceFileLoader
FileFinderAttributeErrorr   r   r   
ModuleTyper
   r   r   r   r   r   r   <module>   sN   
,!ZN  

PK       ! q~~e'  e'  1  distlib/__pycache__/manifest.cpython-38.opt-1.pycnu [        U

    .e9                     @   s   d Z ddlZddlZddlZddlZddlZddlmZ ddlm	Z	 ddl
mZ dgZe
eZedejZed	ejejB Zejdd
 ZG dd deZdS )zu
Class representing the list of files in a distribution.

Equivalent to distutils.filelist, but fixes some problems.
    N   )DistlibException)fsdecodeconvert_pathManifestz\\w*
z#.*?(?=
)|
(?=$)   c                   @   sz   e Zd ZdZdddZdd Zdd Zd	d
 Zddd
Zdd Z	dd Z
dd ZdddZd ddZ
d!ddZdd ZdS )"r   z~A list of files built by on exploring the filesystem and filtered by
    applying various patterns to what we find there.
    Nc                 C   s>   t jt j|pt  | _| jt j | _d| _t	 | _
dS )zd
        Initialise an instance.

        :param base: The base directory to explore under.
        N)ospathabspathnormpathgetcwdbasesepprefixallfilessetfiles)selfr    r   @/usr/lib/python3.8/site-packages/pip/_vendor/distlib/manifest.py__init__*   s    zManifest.__init__c                 C   s   ddl m}m}m} g  | _}| j}|g}|j}|j}|r| }t	|}	|	D ]R}
tj
||
}t |}|j}
||
r|t
| qN||
rN||
sN|| qNq6dS )zmFind all files under the base and set ``allfiles`` to the absolute
        pathnames of files found.
        r   )S_ISREGS_ISDIRS_ISLNKN)statr   r   r   r   r   popappendr	   listdirr
   joinst_moder   )r   r   r   r   r   rootstackr   pushnamesnamefullnamer   moder   r   r   findall9   s"    


zManifest.findallc                 C   s4   | | jstj| j|}| jtj| dS )zz
        Add a file to the manifest.

        :param item: The pathname to add. This can be relative to the base.
        N)	
startswithr   r	   r
   r   r   r   addr   )r   itemr   r   r   r*   T   s    zManifest.addc                 C   s   |D ]}|  | qdS )z
        Add a list of files to the manifest.

        :param items: The pathnames to add. These can be relative to the base.
        N)r*   )r   itemsr+   r   r   r   add_many^   s    zManifest.add_manyFc                    sb    fdd t j}|rFt  }|D ]} |tj| q&||O }dd tdd |D D S )z8
        Return sorted files in directory order
        c                    s>   |  | td| |jkr:tj|\}} | | d S )Nzadd_dir added %s)r*   loggerdebugr   r	   r
   split)dirsdparent_add_dirr   r   r   r6   l   s
    

z Manifest.sorted.<locals>.add_dirc                 S   s   g | ]}t jj| qS r   )r	   r
   r   ).0Z
path_tupler   r   r   
<listcomp>z   s     z#Manifest.sorted.<locals>.<listcomp>c                 s   s   | ]}t j|V  qd S )N)r	   r
   r0   )r7   r
   r   r   r   	<genexpr>{   s     z"Manifest.sorted.<locals>.<genexpr>)r   r   r	   r
   dirnamesorted)r   Zwantdirsresultr1   fr   r5   r   r;   g   s    
zManifest.sortedc                 C   s   t  | _g | _dS )zClear all collected files.N)r   r   r   )r   r   r   r   clear}   s    zManifest.clearc                 C   sj  |  |\}}}}|dkrB|D ]}| j|ddstd| qn$|dkrf|D ]}| j|dd}qNn |dkr|D ]}| j|ddsrtd| qrn|d	kr|D ]}| j|dd}qn|d
kr|D ] }| j||dstd|| qn|d
kr
|D ]}| j||d}qn\|dkr2| jd|dsftd| n4|dkrZ| jd|dsftd| ntd| dS )av  
        Process a directive which either adds some files from ``allfiles`` to
        ``files``, or removes some files from ``files``.

        :param directive: The directive to process. This should be in a format
                     compatible with distutils ``MANIFEST.in`` files:

                     http://docs.python.org/distutils/sourcedist.html#commands
        includeT)anchorzno files found matching %rexcludeglobal-includeFz3no files found matching %r anywhere in distributionglobal-excluderecursive-include)r   z-no files found matching %r under directory %rrecursive-excludegraftNz no directories found matching %rprunez4no previously-included directories found matching %rzinvalid action %r)_parse_directive_include_patternr.   Zwarning_exclude_patternr   )r   	directiveactionpatternsthedirZ
dirpatternpatternfoundr   r   r   process_directive   sP     


zManifest.process_directivec                 C   s  |  }t|dkr,|d dkr,|dd |d }d } }}|dkrxt|dk r`td| d	d
 |dd D }n~|dkrt|dk rtd
| t|d }dd
 |dd D }n:|dkrt|dkrtd| t|d }ntd| ||||fS )z
        Validate a directive.
        :param directive: The directive to validate.
        :return: A tuple of action, patterns, thedir, dir_patterns
        r   r   )r?   rA   rB   rC   rD   rE   rF   rG   r?   N)r?   rA   rB   rC   r   z$%r expects <pattern1> <pattern2> ...c                 S   s   g | ]}t |qS r   r   r7   Zwordr   r   r   r8      s     z-Manifest._parse_directive.<locals>.<listcomp>)rD   rE      z*%r expects <dir> <pattern1> <pattern2> ...c                 S   s   g | ]}t |qS r   r   rR   r   r   r   r8      s     )rF   rG   z!%r expects a single <dir_pattern>zunknown action %r)r0   leninsertr   r   )r   rK   ZwordsrL   rM   rN   Zdir_patternr   r   r   rH      s4    zManifest._parse_directiveTc                 C   sP   d}|  ||||}| jdkr&|   | jD ]}||r,| j| d}q,|S )a  Select strings (presumably filenames) from 'self.files' that
        match 'pattern', a Unix-style wildcard (glob) pattern.

        Patterns are not quite the same as implemented by the 'fnmatch'
        module: '*' and '?'  match non-special characters, where "special"
        is platform-dependent: slash on Unix; colon, slash, and backslash on
        DOS/Windows; and colon on Mac OS.

        If 'anchor' is true (the default), then the pattern match is more
        stringent: "*.py" will match "foo.py" but not "foo/bar.py".  If
        'anchor' is false, both of these will match.

        If 'prefix' is supplied, then only filenames starting with 'prefix'
        (itself a pattern) and ending with 'pattern', with anything in between
        them, will match.  'anchor' is ignored in this case.

        If 'is_regex' is true, 'anchor' and 'prefix' are ignored, and
        'pattern' is assumed to be either a string containing a regex or a
        regex object -- no translation is done, the regex is just compiled
        and used as-is.

        Selected strings will be added to self.files.

        Return True if files are found.
        FNT)_translate_patternr   r(   searchr   r*   )r   rO   r@   r   is_regexrP   
pattern_rer%   r   r   r   rI      s    


zManifest._include_patternc                 C   sB   d}|  ||||}t| jD ]}||r| j| d}q|S )at  Remove strings (presumably filenames) from 'files' that match
        'pattern'.

        Other parameters are the same as for 'include_pattern()', above.
        The list 'self.files' is modified in place. Return True if files are
        found.

        This API is public to allow e.g. exclusion of SCM subdirs, e.g. when
        packaging source distributions
        FT)rV   listr   rW   remove)r   rO   r@   r   rX   rP   rY   r=   r   r   r   rJ   )  s    
zManifest._exclude_patternc           
      C   sv  |rt |trt|S |S tdkr:| dd\}}}|rR| |}tdkrVnd}ttj	
| jd}	|dk	r4tdkr| d}
| |dt|
  }n&| |}|t|t|t|  }tj
}tj
dkrd}tdkrd|	 |
|d| f }n0|t|t|t|  }d	||	||||f }n8|rltdkrRd|	 | }nd
||	|t|d f }t|S )a  Translate a shell-like wildcard pattern to a compiled regular
        expression.

        Return the compiled regex.  If 'is_regex' true,
        then 'pattern' is directly compiled to a regex (if it's a string)
        or just returned as-is (assumes it's a regex object).
        )rS   r   r4    N\z\\^z.*z%s%s%s%s.*%s%sz%s%s%s)
isinstancestrrecompile_PYTHON_VERSION_glob_to_re	partitionescaper	   r
   r   r   rT   r   )
r   rO   r@   r   rX   startr4   endrY   r   Z
empty_patternZ	prefix_rer   r   r   r   rV   =  sF    	









 
zManifest._translate_patternc                 C   s8   t |}tj}tjdkrd}d| }td||}|S )zTranslate a shell-like glob pattern to a regular expression.

        Return a string containing the regex.  Differs from
        'fnmatch.translate()' in that '*' does not match "special characters"
        (which are platform-specific).
        r]   z\\\\z\1[^%s]z((?<!\\)(\\\\)*)\.)fnmatch	translater	   r   ra   sub)r   rO   rY   r   Zescapedr   r   r   rd   t  s    

zManifest._glob_to_re)N)F)TNF)TNF)TNF)__name__
__module____qualname____doc__r   r(   r*   r-   r;   r>   rQ   rH   rI   rJ   rV   rd   r   r   r   r   r   %   s&   

	
O/  
)  
  
7)ro   ri   Zloggingr	   ra   sysr\   r   compatr   utilr   __all__Z	getLoggerrl   r.   rb   MZ_COLLAPSE_PATTERNSZ_COMMENTED_LINEversion_inforc   objec