PK       ! *  *  2  distlib/__pycache__/resources.cpython-38.opt-1.pycnu [        U

    .e*                  	   @   s  d dl mZ d dlZd dlZd dlZd dlZd dlZd dlZd dlZd dl	Z	d dl
Z
ddlmZ ddl
mZmZmZmZ eeZdaG dd deZG dd	 d	eZG d
d deZG dd
 d
eZG dd deZG dd deZedee
jeiZzFzd dl Z!W n e"k
r$   d dl#Z!Y nX eee!j$< eee!j%< [!W n e"e&fk
rX   Y nX dd Z'i Z(dd Z)e	*e+dZ,dd Z-dS )    )unicode_literalsN   )DistlibException)cached_propertyget_cache_basepath_to_cache_dirCachec                       s.   e Zd Zd fdd	Zdd Zdd Z  ZS )	
ResourceCacheNc                    s0   |d krt jt td}tt| | d S )Nzresource-cache)ospathjoinr   strsuperr	   __init__)selfbase	__class__ A/usr/lib/python3.8/site-packages/pip/_vendor/distlib/resources.pyr      s    zResourceCache.__init__c                 C   s   dS )z
        Is the cache stale for the given resource?

        :param resource: The :class:`Resource` being cached.
        :param path: The path of the resource in the cache.
        :return: True if the cache is stale.
        Tr   r   resourcer   r   r   r   is_stale#   s    	zResourceCache.is_stalec              	   C   s   |j |\}}|dkr|}n~tj| j| ||}tj|}tj|sXt	| tj
|sjd}n| ||}|rt|d}|
|j W 5 Q R X |S )z
        Get a resource into the cache,

        :param resource: A :class:`Resource` instance.
        :return: The pathname of the resource in the cache.
        NTwb)finderget_cache_infor
   r   r   r   Z
prefix_to_dirdirnameisdirmakedirsexistsr   openwritebytes)r   r   prefixr   resultr   Zstalefr   r   r   get.   s    
zResourceCache.get)N)__name__
__module____qualname__r   r   r&   
__classcell__r   r   r   r   r	      s   r	   c                   @   s   e Zd Zdd ZdS )ResourceBasec                 C   s   || _ || _d S N)r   name)r   r   r-   r   r   r   r   I   s    zResourceBase.__init__N)r'   r(   r)   r   r   r   r   r   r+   H   s   r+   c                   @   s@   e Zd ZdZdZdd Zedd Zedd Zed	d
 Z	dS )Resourcez
    A class representing an in-package resource, such as a data file. This is
    not normally instantiated by user code, but rather by a
    :class:`ResourceFinder` which manages the resource.
    Fc                 C   s   | j | S )z
        Get the resource as a stream.

        This is not a property to make it obvious that it returns a new stream
        each time.
        )r   
get_streamr   r   r   r   	as_streamV   s    zResource.as_streamc                 C   s   t d krt a t | S r,   )cacher	   r&   r0   r   r   r   	file_path_   s    zResource.file_pathc                 C   s   | j | S r,   )r   	get_bytesr0   r   r   r   r"   f   s    zResource.bytesc                 C   s   | j | S r,   )r   get_sizer0   r   r   r   sizej   s    z
Resource.sizeN)
r'   r(   r)   __doc__is_containerr1   r   r3   r"   r6   r   r   r   r   r.   N   s   	

r.   c                   @   s   e Zd ZdZedd ZdS )ResourceContainerTc                 C   s   | j | S r,   )r   
get_resourcesr0   r   r   r   	resourcesr   s    zResourceContainer.resourcesN)r'   r(   r)   r8   r   r;   r   r   r   r   r9   o   s   r9   c                   @   s   e Zd ZdZejdrdZndZdd Zdd Z	d	d
 Z
dd Zd
d Zdd Z
dd Zdd Zdd Zdd Zdd ZeejjZdd ZdS )ResourceFinderz4
    Resource finder for file system resources.
    java).pyc.pyoz.class)r>   r?   c                 C   s.   || _ t|dd | _tjt|dd| _d S )N
__loader____file__ )modulegetattrloaderr
   r   r   r   )r   rC   r   r   r   r      s    zResourceFinder.__init__c                 C   s   t j|S r,   )r
   r   realpathr   r   r   r   r   _adjust_path   s    zResourceFinder._adjust_pathc                 C   sB   t |trd}nd}||}|d| j tjj| }| |S )N   //r   )	
isinstancer"   splitinsertr   r
   r   r   rH   )r   
resource_nameseppartsr$   r   r   r   
_make_path   s    

zResourceFinder._make_pathc                 C   s   t j|S r,   )r
   r   r   rG   r   r   r   _find   s    zResourceFinder._findc                 C   s
   d |j fS r,   )r   r   r   r   r   r   r      s    zResourceFinder.get_cache_infoc                 C   sD   |  |}| |sd }n&| |r0t| |}n
t| |}||_|S r,   )rQ   rR   
_is_directoryr9   r.   r   )r   rN   r   r$   r   r   r   find   s    



zResourceFinder.findc                 C   s   t |jdS Nrb)r    r   rS   r   r   r   r/      s    zResourceFinder.get_streamc              
   C   s,   t |jd}| W  5 Q R  S Q R X d S rV   )r    r   read)r   r   r%   r   r   r   r4      s    zResourceFinder.get_bytesc                 C   s   t j|jS r,   )r
   r   getsizerS   r   r   r   r5      s    zResourceFinder.get_sizec                    s*   fdd t  fddt|jD S )Nc                    s   | dko|   j S )N__pycache__)endswithskipped_extensions)r%   r0   r   r   allowed   s    
z-ResourceFinder.get_resources.<locals>.allowedc                    s   g | ]} |r|qS r   r   ).0r%   )r]   r   r   
<listcomp>   s      z0ResourceFinder.get_resources.<locals>.<listcomp>)setr
   listdirr   rS   r   )r]   r   r   r:      s    zResourceFinder.get_resourcesc                 C   s   |  |jS r,   )rT   r   rS   r   r   r   r8      s    zResourceFinder.is_containerc                 c   s   |  |}|d k	r|g}|r|d}|V  |jr|j}|jD ]>}|sL|}nd||g}|  |}|jrv|| q>|V  q>qd S )Nr   rJ   )rU   popr8   r-   r;   r   append)r   rN   r   ZtodoZrnamer-   new_nameZchildr   r   r   iterator   s     



zResourceFinder.iteratorN)r'   r(   r)   r7   sysplatform
startswithr\   r   rH   rQ   rR   r   rU   r/   r4   r5   r:   r8   staticmethodr
   r   r   rT   re   r   r   r   r   r<   w   s"   r<   c                       s`   e Zd ZdZ fddZdd Zdd Zdd	 Zd
d Zdd
 Z	dd Z
dd Zdd Z  Z
S )ZipResourceFinderz6
    Resource finder for resources in .zip files.
    c                    sZ   t t| | | jj}dt| | _t| jdr>| jj| _nt	j
| | _t| j| _d S )Nr   _files)
r   rj   r   rE   archivelen
prefix_lenhasattrrk   	zipimport_zip_directory_cachesortedindex)r   rC   rl   r   r   r   r      s    zZipResourceFinder.__init__c                 C   s   |S r,   r   rG   r   r   r   rH      s    zZipResourceFinder._adjust_pathc                 C   s   || j d  }|| jkrd}nX|r:|d tjkr:|tj }t| j|}z| j| |}W n tk
rt   d}Y nX |st	d|| j
j nt	d|| j
j |S )NTFz_find failed: %r %rz_find worked: %r %r)rn   rk   r
   rO   bisectrs   rh   
IndexErrorloggerdebugrE   r#   )r   r   r$   ir   r   r   rR      s    


zZipResourceFinder._findc                 C   s&   | j j}|jdt| d  }||fS )Nr   )rE   rl   r   rm   )r   r   r#   r   r   r   r   r      s    z ZipResourceFinder.get_cache_infoc                 C   s   | j |jS r,   )rE   get_datar   rS   r   r   r   r4      s    zZipResourceFinder.get_bytesc                 C   s   t | |S r,   )ioBytesIOr4   rS   r   r   r   r/      s    zZipResourceFinder.get_streamc                 C   s   |j | jd  }| j| d S )N   )r   rn   rk   r   r   r   r   r5      s    zZipResourceFinder.get_sizec                 C   s   |j | jd  }|r,|d tjkr,|tj7 }t|}t }t| j|}|t| jk r| j| |shq| j| |d  }|	|
tjdd  |d7 }qH|S )Nrt   r   r   )r   rn   r
   rO   rm   r`   ru   rs   rh   addrL   )r   r   r   Zplenr$   ry   sr   r   r   r:     s    

zZipResourceFinder.get_resourcesc                 C   sj   || j d  }|r*|d tjkr*|tj7 }t| j|}z| j| |}W n tk
rd   d}Y nX |S )Nrt   F)rn   r
   rO   ru   rs   rh   rv   )r   r   ry   r$   r   r   r   rT     s    

zZipResourceFinder._is_directory)r'   r(   r)   r7   r   rH   rR   r   r4   r/   r5   r:   rT   r*   r   r   r   r   rj      s   rj   c                 C   s   |t t| < d S r,   )_finder_registrytype)rE   finder_makerr   r   r   register_finder0  s    r   c                 C   s   | t krt |  }nv| tjkr$t|  tj|  }t|dd}|dkrJtdt|dd}tt|}|dkrxtd|  ||}|t | < |S )z
    Return a resource finder for a package.
    :param package: The name of the package.
    :return: A :class:`ResourceFinder` instance for the package.
    __path__Nz8You cannot get a finder for a module, only for a packager@   zUnable to locate finder for %r)	
_finder_cacherf   modules
__import__rD   r   r   r&   r   )packager$   rC   r   rE   r   r   r   r   r   6  s    


r   Z	__dummy__c                 C   sR   d}t |  tj| }tt|}|rNt}tj	
| d|_||_||}|S )z
    Return a resource finder for a path, which should represent a container.

    :param path: The path.
    :return: A :class:`ResourceFinder` instance for the path.
    NrB   )
pkgutilZget_importerrf   path_importer_cacher&   r   r   
_dummy_moduler
   r   r   rA   r@   )r   r$   rE   r   rC   r   r   r   finder_for_pathR  s    
r   ).Z
__future__r   ru   r{   Zloggingr
   r   Zshutilrf   typesrp   rB   r   utilr   r   r   r   Z	getLoggerr'   rw   r2   r	   objectr+   r.   r9   r<   rj   r   zipimporterr   _frozen_importlib_externalZ_fiImportError_frozen_importlibSourceFileLoader
FileFinderAttributeErrorr   r   r   
ModuleTyper
   r   r   r   r   r   r   <module>   sN   
,!ZN  

PK       ! #    1  distlib/__pycache__/__init__.cpython-38.opt-1.pycnu [        U

    .eK                     @   sn   d dl Z dZG dd deZzd dl mZ W n& ek
rR   G dd de jZY nX e eZ	e	
e  dS )    Nz0.2.9.post0c                   @   s   e Zd ZdS )DistlibExceptionN)__name__
__module____qualname__ r   r   @/usr/lib/python3.8/site-packages/pip/_vendor/distlib/__init__.pyr      s   r   )NullHandlerc                   @   s$   e Zd Zdd Zdd Zdd ZdS )r   c                 C   s   d S Nr   selfrecordr   r   r   handle       zNullHandler.handlec                 C   s   d S r	   r   r
   r   r   r   emit   r   zNullHandler.emitc                 C   s
   d | _ d S r	   )lock)r   r   r   r   
createLock   r   zNullHandler.createLockN)r   r   r   r
   r   r   r   r   r   r   r      s   r   )Zlogging__version__	Exceptionr   r   ImportErrorZHandlerZ	getLoggerr   ZloggerZ
addHandlerr   r   r   r   <module>   s   
PK       ! D̎dc  dc  .  distlib/__pycache__/wheel.cpython-38.opt-1.pycnu [        U

    .e                     @   s  d dl mZ d dlZd dlZd dlZd dlZd dlmZ d dl	Z	d dl
Z
d dlZd dlZd dl
Z
d dlZd dlZd dlZd dlZd dlZd dlZddlmZmZ ddlmZmZmZmZmZ ddlmZ ddlm Z m!Z!m"Z" dd	l#m$Z$m%Z%m&Z&m'Z'm(Z(m)Z)m*Z*m+Z+m,Z, dd
l-m.Z.m/Z/ e0e1Z2da3e4edr8dZ5n*ej67d
rLdZ5nej6dkr^dZ5ndZ5e8dZ9e9sdej:dd  Z9de9 Z;e5e9 Z<ej#= >dd>ddZ?e8dZ@e@re@7dre@>ddZ@ndd ZAeA Z@[AeBdejCejDB ZEeBdejCejDB ZFeBdZGeBd ZHd!ZId"ZJe
jKd#krBd$d% ZLnd&d% ZLG d'd( d(eMZNeN ZOG d)d* d*eMZPd+d, ZQeQ ZR[Qd/d-d.ZSdS )0    )unicode_literalsN)message_from_file   )__version__DistlibException)	sysconfigZipFilefsdecode	text_typefilter)InstalledDistribution)MetadataMETADATA_FILENAMEWHEEL_METADATA_FILENAME)	FileOperatorconvert_path	CSVReader	CSVWriterCachecached_propertyget_cache_baseread_exportstempdir)NormalizedVersionUnsupportedVersionErrorZpypy_version_infoZppjavaZjyZcliZipcpZpy_version_nodotz%s%s   py-_.ZSOABIzcpython-c                  C   sR   dt g} tdr| d tdr0| d tddkrH| d d	| S )
Nr   ZPy_DEBUGdZ
WITH_PYMALLOCmZPy_UNICODE_SIZE   u )
VER_SUFFIXr   get_config_varappendjoin)parts r,   =/usr/lib/python3.8/site-packages/pip/_vendor/distlib/wheel.py_derive_abi;   s    




r.   zz
(?P<nm>[^-]+)
-(?P<vn>\d+[^-]*)
(-(?P<bn>\d+[^-]*))?
-(?P<py>\w+\d+(\.\w+\d+)*)
-(?P<bi>\w+)
-(?P<ar>\w+(\.\w+)*)
\.whl$
z7
(?P<nm>[^-]+)
-(?P<vn>\d+[^-]*)
(-(?P<bn>\d+[^-]*))?$
s
   \s*#![^\r\n]*s   ^(\s*#!("[^"]+"|\S+))\s+(.*)$s   #!pythons	   #!pythonw/c                 C   s   | S Nr,   or,   r,   r-   <lambda>]       r3   c                 C   s   |  tjdS )Nr/   )replaceossepr1   r,   r,   r-   r3   _   r4   c                   @   s6   e Zd Zdd Zdd Zdd Zddd	Zd
d ZdS )
Mounterc                 C   s   i | _ i | _d S r0   )
impure_wheelslibsselfr,   r,   r-   __init__c   s    zMounter.__init__c                 C   s   || j |< | j| d S r0   )r9   r:   update)r<   pathname
extensionsr,   r,   r-   addg   s    
zMounter.addc                 C   s0   | j |}|D ]\}}|| jkr| j|= qd S r0   )r9   popr:   )r<   r?   r@   kvr,   r,   r-   removek   s    
zMounter.removeNc                 C   s   || j kr| }nd }|S r0   )r:   )r<   fullnamepathresultr,   r,   r-   find_moduleq   s    
zMounter.find_modulec                 C   sj   |t jkrt j| }nP|| jkr,td| t|| j| }| |_|dd}t|dkrf|d |_	|S )Nzunable to find extension for %sr!   r   r   )
sysmodulesr:   ImportErrorimpZload_dynamic
__loader__rsplitlen__package__)r<   rF   rH   r+   r,   r,   r-   load_modulex   s    


zMounter.load_module)N)__name__
__module____qualname__r=   rA   rE   rI   rR   r,   r,   r,   r-   r8   b   s
   
r8   c                   @   s   e Zd ZdZdZdZd4ddZedd	 Zed
d Z	edd
 Z
edd Zdd Z
edd Zdd Zd5ddZdd Zdd Zdd Zd6ddZd d! Zd"d# Zd$d% Zd&d' Zd(d) Zd*d+ Zd7d,d-Zd.d/ Zd0d1 Zd8d2d3ZdS )9Wheelz@
    Class to build and install from Wheel files (PEP 427).
    r   r   Zsha256NFc                 C   s8  || _ || _d| _tg| _dg| _dg| _t | _	|dkrRd| _
d| _| j| _
nt|}|r|d}|d | _
|d d	d
| _|d | _| j| _
ntj|\}}t|}|std| |rtj|| _	|| _
|d}|d | _
|d | _|d | _|d
 d| _|d d| _|d d| _dS )zB
        Initialise an instance using a (valid) filename.
        r&   noneanyNZdummyz0.1ZnmZvnr    r   ZbnzInvalid name or filename: %rr   r!   ZbiZar)signZ
should_verifybuildverPYVERpyverabiarchr6   getcwddirnamenameversionfilenameZ	_filenameNAME_VERSION_REmatch	groupdictr5   rG   splitFILENAME_REr   abspath)r<   rd   rZ   verifyr#   infora   r,   r,   r-   r=      sD    











zWheel.__init__c                 C   s^   | j rd| j  }nd}d| j}d| j}d| j}| jdd}d| j|||||f S )zJ
        Build and return a filename from the various components.
        r   r&   r!   r    z%s-%s%s-%s-%s-%s.whl)r[   r*   r]   r^   r_   rc   r5   rb   )r<   r[   r]   r^   r_   rc   r,   r,   r-   rd      s    
  zWheel.filenamec                 C   s   t j| j| j}t j|S r0   )r6   rG   r*   ra   rd   isfile)r<   rG   r,   r,   r-   exists   s    zWheel.existsc                 c   s4   | j D ](}| jD ]}| jD ]}|||fV  qqqd S r0   )r]   r^   r_   )r<   r]   r^   r_   r,   r,   r-   tags   s    


z
Wheel.tagsc                 C   s  t j| j| j}d| j| jf }d| }td}t	|d}| 
|}|d dd}tdd	 |D }|d
k rt
tdg}	nt
tg}	d }
|	D ]f}zLt||}||,}
||
}t|d}
|
rW 5 Q R  W  qW 5 Q R X W q tk
r   Y qX q|
std
d|	 W 5 Q R X |
S )N%s-%s%s.dist-infoutf-8r
Wheel-Versionr!   r   c                 S   s   g | ]}t |qS r,   int.0ir,   r,   r-   
<listcomp>   s     z"Wheel.metadata.<locals>.<listcomp>rW   ZMETADATA)Zfileobjz8Invalid wheel, because metadata is missing: looked in %sz, )r6   rG   r*   ra   rd   rb   rc   codecs	getreaderr   get_wheel_metadatarh   tupler   r   	posixpathopenr
   KeyError
ValueError)r<   r?   name_verinfo_dirwrapperzfwheel_metadatawvfile_versionZfnsrH   fnmetadata_filenamebfwfr,   r,   r-   metadata   s6    


zWheel.metadatac              	   C   sX   d| j | jf }d| }t|d}||}td|}t|}W 5 Q R X t|S )Nrp   rq   WHEELrr   )	rb   rc   r   r*   r   r{   r|   r   dict)r<   r   r   r   r   r   r   messager,   r,   r-   r}      s    zWheel.get_wheel_metadatac              	   C   s6   t j| j| j}t|d}| |}W 5 Q R X |S )Nrs   )r6   rG   r*   ra   rd   r   r}   )r<   r?   r   rH   r,   r,   r-   rl      s    z
Wheel.infoc                 C   s   t |}|r|| }|d | ||d   }}d| krBt}nt}t|}|rfd| d  }nd}|| }|| }nT|d}|d}	|dk s||	krd}
n|||d  d	krd	}
nd}
t|
 | }|S )
Ns   pythonw    r4      
   
r   r   s   
)	
SHEBANG_RErf   endlowerSHEBANG_PYTHONWSHEBANG_PYTHONSHEBANG_DETAIL_REgroupsfind)r<   datar#   r   ZshebangZdata_after_shebangZshebang_pythonargsZcrZlfZtermr,   r,   r-   process_shebang  s,    




zWheel.process_shebangc                 C   sh   |d kr| j }ztt|}W n  tk
r<   td| Y nX || }t|d	d}||fS )NzUnsupported hash algorithm: %r   =ascii)
	hash_kindgetattrhashlibAttributeErrorr   digestbase64Zurlsafe_b64encoderstripdecode)r<   r   r   hasherrH   r,   r,   r-   get_hash"  s    zWheel.get_hashc              	   C   s^   t |}ttj||}||ddf |  t|}|D ]}|| q@W 5 Q R X d S )Nr&   )	listto_posixr6   rG   relpathr)   sortr   Zwriterow)r<   recordsZrecord_pathbasepwriterrowr,   r,   r-   write_record-  s    
zWheel.write_recordc              
   C   s   g }|\}}t t| j}|D ]P\}}	t|	d}
|
 }W 5 Q R X d| | }tj|	}
|	|||
f qtj
|d}	| ||	| ttj
|d}|	||	f d S )Nrbz%s=%sRECORD)
r   r   r   r   readr   r6   rG   getsizer)   r*   r   r   )r<   rl   libdir
archive_pathsr   distinfor   r   apr   fr   r   sizer,   r,   r-   
write_records6  s    zWheel.write_recordsc              	   C   sF   t |dtj.}|D ]"\}}td|| ||| qW 5 Q R X d S )NwzWrote %s to %s in wheel)r   zipfileZZIP_DEFLATEDloggerdebugwrite)r<   r?   r   r   r   r   r,   r,   r-   	build_zipF  s    zWheel.build_zipc           !         sp  |dkri }t t fdddd }|dkrFd}tg}tg}tg}nd}tg}d	g}d
g}|d|| _|d|| _|d
|| _	 | }	d| j
| jf }
d|
 }d|
 }g }
dD ]}| krq | }tj
|rt|D ]\}}}|D ]}ttj
||}tj
||}ttj
|||}|
||f |dkr|dst|d}| }W 5 Q R X | |}t|d}|| W 5 Q R X qqq|	}d}t|D ]\}}}||krt|D ]8\}}t|}|drtj
||}||=  qq|D ]H}t|drqtj
||}ttj
||}|
||f qqt|}|D ]B}|dkr^ttj
||}ttj
||}|
||f q^d|p| j dt d| g}| jD ] \}}}|d|||f  qtj
|d}t|d}|d| W 5 Q R X ttj
|d}|
||f | ||f|	|
 tj
| j | j!} | "| |
 | S ) z
        Build a wheel from files in specified paths, and use any specified tags
        when determining the name of the wheel.
        Nc                    s   |  kS r0   r,   r1   pathsr,   r-   r3   T  r4   zWheel.build.<locals>.<lambda>)purelibplatlibr   r   ZfalsetruerX   rY   r]   r^   r_   rp   %s.datarq   )r   Zheadersscriptsr   .exer   wbz
.dist-info)z.pycz.pyo)r   Z	INSTALLERZSHAREDr   zWheel-Version: %d.%dzGenerator: distlib %szRoot-Is-Purelib: %sz
Tag: %s-%s-%sr   r   
)#r   r   IMPVERABIARCHr\   getr]   r^   r_   rb   rc   r6   rG   isdirwalkr	   r*   r   r   r)   endswithr   r   r   r   	enumeratelistdir
wheel_versionr   ro   r   ra   rd   r   )!r<   r   ro   r   ZlibkeyZis_pureZ
default_pyverZdefault_abiZdefault_archr   r   data_dirr   r   keyrG   rootdirsfilesr   r   rpr   r   r   r   ry   dnr   r]   r^   r_   r?   r,   r   r-   buildL  s    




zWheel.buildc                 C   s
   | dS )zl
        Determine whether an archive entry should be skipped when verifying
        or installing.
        )r/   z/RECORD.jws)r   )r<   arcnamer,   r,   r-   
skip_entry  s    zWheel.skip_entryc           C      K   sf  |j }|d}|dd}|dd}tj| j| j}d| j| jf }	d|	 }
d|	 }t	|t
}t	|d}
t	|d	}td
}t
|d}||
}||}t|}W 5 Q R X |d d
d}tdd |D }|| jkr|r|| j| |d dkr|d }n|d }i }||8}t|d"}|D ]}|d }|||< q8W 5 Q R X W 5 Q R X t	|
d}t	|d}t	|
dd}t|d}d|_tj } g }!t }"|"|_d|_zz\| D ]}#|#j}$t|$t r|$}%n
|$!d
}%| "|%rq||% }|d r4t#|#j$|d kr4t%d|% |d r|d dd\}&}'||$}|& }(W 5 Q R X | '|(|&\})}*|*|'krt%d|$ |r|%(||frt)*d |% q|%(|o|%+d! }+|%(|r
|%d"d\})},}-tj||, t,|-}.n$|%|
|fkrqtj|t,|%}.|+s
||$}|-||. W 5 Q R X |!.|. |s|d rt|.d#4}|& }(| '|(|&\})}/|/|*krt%d$|. W 5 Q R X | r~|.+d%r~z|j/|.|d&}0|!.|0 W n$ t0k
r   t)j1d'dd( Y nX nttj2t,|$}1tj|"|1}2||$}|-||2 W 5 Q R X tj|.\}3}1|3|_|3|1}4|4|4 |!5|4 q|rt)*d) d}5nnd}6| j6d }|d*krzt	|d+}7z||7}t7|}8W 5 Q R X i }6d,D ]l}9d-|9 }:|:|8kri  |6d.|9 < };|8|: 8 D ]6}<d/|<j9|<j:f }=|<j;rB|=d0|<j; 7 }=|=|;|<j< qqW n  t0k
rv   t)1d1 Y nX ndzB||.}||}t<=|d2}6|6r|6d3}6W 5 Q R X W n  t0k
r   t)1d4 Y nX |6r|6d5i }>|6d6i }?|>s|?r|dd}@tj>|@s*t?d7|@|_|>@ D ]*\}:}<d8|:|<f }A|3|A}4|4|4 q8|?rd9di}B|?@ D ],\}:}<d8|:|<f }A|3|A|B}4|4|4 qztj||}tA|}5tB|}|d= |d= ||d:< |5C||}|r|!.| |5D|!|d; | |5W W <W  5 Q R  S  t0k
rF   t)Ed< |F   Y nX W 5 t|" X W 5 Q R X dS )=a~  
        Install a wheel to the specified paths. If kwarg ``warner`` is
        specified, it should be a callable, which will be called with two
        tuples indicating the wheel version of this software and the wheel
        version in the file, if there is a discrepancy in the versions.
        This can be used to issue any warnings to raise any exceptions.
        If kwarg ``lib_only`` is True, only the purelib/platlib files are
        installed, and the headers, scripts, data and dist-info metadata are
        not written. If kwarg ``bytecode_hashed_invalidation`` is True, written
        bytecode will try to use file-hash based invalidation (PEP-552) on
        supported interpreter versions (CPython 2.7+).

        The return value is a :class:`InstalledDistribution` instance unless
        ``options.lib_only`` is True, in which case the return value is ``None``.
        warnerlib_onlyFZbytecode_hashed_invalidationrp   r   rq   r   r   rr   rs   rt   r!   r   c                 S   s   g | ]}t |qS r,   ru   rw   r,   r,   r-   rz     s     z!Wheel.install.<locals>.<listcomp>zRoot-Is-Purelibr   r   r   streamr   r&   r   )dry_runTNr   size mismatch for %s=digest mismatch for %szlib_only: skipping %sr   r/   r   zdigest mismatch on write for %sz.py)Zhashed_invalidationzByte-compilation failed)exc_infozlib_only: returning Nonez1.0zentry_points.txt)Zconsoleguiz
%s_scriptszwrap_%sz%s:%sz %szAUnable to read legacy script metadata, so cannot generate scriptsr@   zpython.commandsz8Unable to read JSON metadata, so cannot generate scriptsZwrap_consoleZwrap_guizValid script path not specifiedz%s = %sr   libprefixzinstallation failed.)Gr   r   r6   rG   r*   ra   rd   rb   rc   r   r   r{   r|   r   r   r   rh   r~   r   r   r   recordrJ   dont_write_bytecodetempfileZmkdtempZ
source_dirZ
target_dirshutilZrmtreeinfolist
isinstancer
   r   r   str	file_sizer   r   r   
startswithr   r   r   r   Zcopy_streamr)   Zbyte_compile	ExceptionZwarningbasenameZmakeZset_executable_modeextendrl   r   valuesr   suffixflagsjsonloadr   r   itemsr   r   Zwrite_shared_locationsZwrite_installed_filesZ	exceptionZrollback)Cr<   r   Zmakerkwargsr   r   r   Zbc_hashed_invalidationr?   r   r   r   
metadata_namewheel_metadata_namerecord_namer   r   bwfr   r   r   r   r   r   r   readerr   r   Zdata_pfxZinfo_pfxZ
script_pfxZfileopZbcZoutfilesworkdirzinfor   	u_arcnamekindvaluer   r    r   Z	is_scriptwherer   ZoutfileZ	newdigestZpycr   Zworknamer   	filenamesZdistZcommandsZepZepdatar   rC   r"   rD   sZconsole_scriptsZgui_scriptsZ
script_dirZscriptZoptionsr,   r,   r-   install  sT   


 















z
Wheel.installc                 C   s4   t d kr0tjt tdtjd d }t|a t S )Nzdylib-cache   )	cacher6   rG   r*   r   r   rJ   rc   r   )r<   r   r,   r,   r-   _get_dylib_cache  s    zWheel._get_dylib_cachec              
   C   sh  t j| j| j}d| j| jf }d| }t|d}t	d}g }t
|d}z||}||}	t
|	}
|  }||}t j|j|}
t j|
st |
 |
 D ]\}}t j|
t|}t j|sd}n6t |j}tj|}||}tj|j }||k}|r&|||
 |||f qW 5 Q R X W n tk
rX   Y nX W 5 Q R X |S )Nrp   rq   Z
EXTENSIONSrr   rs   T)r6   rG   r*   ra   rd   rb   rc   r   r{   r|   r   r   r  r  r  Z
prefix_to_dirr   r   makedirsr  r   rn   statst_mtimedatetimeZ
fromtimestampZgetinfoZ	date_timeextractr)   r   )r<   r?   r   r   r   r   rH   r   r   r   r@   r  r   Z
cache_baserb   r   destr  Z	file_timerl   Z
wheel_timer,   r,   r-   _get_extensions  s>    




zWheel._get_extensionsc                 C   s   t | S )zM
        Determine if a wheel is compatible with the running system.
        )
is_compatibler;   r,   r,   r-   r    s    zWheel.is_compatiblec                 C   s   dS )zP
        Determine if a wheel is asserted as mountable by its metadata.
        Tr,   r;   r,   r,   r-   is_mountable  s    zWheel.is_mountablec                 C   s   t jt j| j| j}|  s2d| }t||  sJd| }t||t	jkrbt
d| nN|rtt	j| nt	j
d| |  }|rtt	jkrt	jt t|| d S )Nz)Wheel %s not compatible with this Python.z$Wheel %s is marked as not mountable.z%s already in pathr   )r6   rG   rj   r*   ra   rd   r  r   r  rJ   r   r   r)   insertr  _hook	meta_pathrA   )r<   r)   r?   msgr@   r,   r,   r-   mount  s"    

zWheel.mountc                 C   sr   t jt j| j| j}|tjkr2td| n<tj	| |t
jkrRt
	| t
jsnt
tjkrntj	t
 d S )Nz%s not in path)
r6   rG   rj   r*   ra   rd   rJ   r   r   rE   r   r9   r!  )r<   r?   r,   r,   r-   unmount  s    



z
Wheel.unmountc                 C   s  t j| j| j}d| j| jf }d| }d| }t|t}t|d}t|d}t	
d}t|d}	|	|}
||
}t
|}W 5 Q R X |d d	d
}
tdd |
D }i }|	|6}t|d
 }|D ]}|d }|||< qW 5 Q R X W 5 Q R X |	 D ]}|j}t|tr$|}n
|d}|d}d|krNtd| | |r^q|| }|d rt|j|d krtd| |d
 r|d
 dd
\}}|	|}| }W 5 Q R X | ||\}}||krtd| qW 5 Q R X d S )Nrp   r   rq   r   r   rr   rs   rt   r!   r   c                 S   s   g | ]}t |qS r,   ru   rw   r,   r,   r-   rz     s     z Wheel.verify.<locals>.<listcomp>r   r   r/   ..invalid entry in wheel: %rr   r   r   r   )r6   rG   r*   ra   rd   rb   rc   r   r   r{   r|   r   r   r   rh   r~   r   r   r   r
   r   r   r   r   r   r   r   )r<   r?   r   r   r   r  r  r  r   r   r  r   r   r   r   r   r   r	  r   r   r  r   r  r
  r  r   r    r   r,   r,   r-   rk     s\    





zWheel.verifyc              
   K   s  dd }dd }t j| j| j}d| j| jf }d| }t|d}	t }
t	|d|}i }|
 D ]h}
|
j}t|tr|}n
|
d	}||	krqhd
|krtd| ||
|
 t j|
t|}|||< qhW 5 Q R X |||\}}||f|}|r|||\}}|r$||kr$||| |dkrNtjd
d|
d\}}t | n*t j|shtd| t j|| j}t| }t j|
|}||f}| ||
| | || |dkrt|| W 5 Q R X |S )a  
        Update the contents of a wheel in a generic way. The modifier should
        be a callable which expects a dictionary argument: its keys are
        archive-entry paths, and its values are absolute filesystem paths
        where the contents the corresponding archive entries can be found. The
        modifier is free to change the contents of the files pointed to, add
        new entries and remove entries, before returning. This method will
        extract the entire contents of the wheel to a temporary location, call
        the modifier, and then use the passed (and possibly updated)
        dictionary to write a new wheel. If ``dest_dir`` is specified, the new
        wheel is written there -- otherwise, the original wheel is overwritten.

        The modifier should return True if it updated the wheel, else False.
        This method returns the same value the modifier returns.
        c                 S   sH   d  }}d|t f }|| kr$d| }|| kr@| | }t|dj}||fS )Nz%s/%sz%s/PKG-INFOrG   )r   r
   rc   )path_mapr   rc   rG   r   r,   r,   r-   get_versionK  s    z!Wheel.update.<locals>.get_versionc                 S   s   d }z|t | }| d}|dk r*d|  }nTdd | |d d  dD }|d  d7  < d	| d | dd
d |D f }W n  tk
r   td|  Y nX |rt|d
}||_|	t
 }|j||d td| | d S )Nr   r   z%s+1c                 S   s   g | ]}t |qS r,   ru   )rx   r  r,   r,   r-   rz   ]  s     z8Wheel.update.<locals>.update_version.<locals>.<listcomp>r   r!   r   z%s+%sc                 s   s   | ]}t |V  qd S r0   )r   rw   r,   r,   r-   	<genexpr>`  s     z7Wheel.update.<locals>.update_version.<locals>.<genexpr>z0Cannot update non-compliant (PEP-440) version %rr'  )rG   legacyzVersion updated from %r to %r)r   r   rh   r*   r   r   r   r
   rc   r   r   r   )rc   rG   updatedrD   ry   r+   Zmdr+  r,   r,   r-   update_versionU  s.    

 


z$Wheel.update.<locals>.update_versionrp   rq   r   rs   rr   r%  r&  Nz.whlz
wheel-update-)r   r   dirzNot a directory: %r)r6   rG   r*   ra   rd   rb   rc   r   r   r   r   r   r
   r   r   r  r   r   Zmkstempcloser   r   r  r   r   r   Zcopyfile)r<   ZmodifierZdest_dirr  r)  r-  r?   r   r   r  r
  r   r(  r  r   r  rG   Zoriginal_versionr    ZmodifiedZcurrent_versionfdnewpathr   r   rl   r,   r,   r-   r>   :  s\    







zWheel.update)NFF)N)NN)F)N)rS   rT   rU   __doc__r   r   r=   propertyrd   rn   ro   r   r   r}   rl   r   r   r   r   r   r   r   r  r  r  r  r  r#  r$  rk   r>   r,   r,   r,   r-   rV      s@   
)



	

	
h g	"
8rV   c               	   C   sx  t g} t d }ttjd d ddD ]}| d|t|g q$g }t D ]*\}}}|	drN||
ddd  qN|  tdkr|
dt |d g }tg}tjd	krtd
t}|r| \}	}}}
t|}|
g}|
dkr|d |
d
kr|d |
dkr |d |
dkr4|d |
dkrH|d |dkr|D ]*}d|	|||f }
|
tkrV||
 qV|d8 }qH|D ]0}|D ]$}
|dt| d f||
f qqt| D ]L\}}|dt|fddf |dkr|dt|d fddf qt| D ]L\}}|dd|fddf |dkr"|dd|d fddf q"t|S )zG
    Return (pyver, abi, arch) tuples compatible with this Python.
    r   r   r   r&   z.abir!   r   rX   darwinz(\w+)_(\d+)_(\d+)_(\w+)$)i386ppcZfat)r5  r6  x86_64Zfat3)ppc64r7  Zfat64)r5  r7  intel)r5  r7  r9  r6  r8  Z	universalz%s_%s_%s_%srY   r   )r'   rangerJ   version_infor)   r*   r   rM   Zget_suffixesr   rh   r   r   r  r   platformrerf   r   rv   
IMP_PREFIXr   set)ZversionsmajorminorZabisr   r    rH   Zarchesr#   rb   r_   Zmatchesrf   r  r^   ry   rc   r,   r,   r-   compatible_tags  s`    












&
"
"rB  c                 C   s\   t | tst| } d}|d kr"t}|D ]0\}}}|| jkr&|| jkr&|| jkr&d} qXq&|S )NFT)r   rV   COMPATIBLE_TAGSr]   r^   r_   )Zwheelro   rH   Zverr^   r_   r,   r,   r-   r    s    
r  )N)TZ
__future__r   r   r{   r  Zdistutils.utilZ	distutilsZemailr   r   rM   r  Zloggingr6   r   r=  r   rJ   r   r   r&   r   r   compatr   r   r	   r
   r   Zdatabaser   r   r
   r   r   utilr   r   r   r   r   r   r   r   r   rc   r   r   Z	getLoggerrS   r   r  hasattrr>  r<  r   r(   r'   r;  r\   r   Zget_platformr5   r   r   r.   compile
IGNORECASEVERBOSEri   re   r   r   r   r   r7   r   objectr8   r   rV   rB  rC  r  r,   r,   r,   r-   <module>   s   ,


	





#      >PK       ! JE*  *  0  distlib/__pycache__/scripts.cpython-38.opt-1.pycnu [        U

    .e?                     @   s   d dl mZ d dlZd dlZd dlZd dlZd dlZddlmZm	Z	m
Z
 ddlmZ ddl
mZmZmZmZmZ eeZd ZedZd	Zd
d ZG dd
 d
eZdS )    )BytesION   )	sysconfigdetect_encodingZipFile)finder)FileOperatorget_export_entryconvert_pathget_executablein_venva  
<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<assembly xmlns="urn:schemas-microsoft-com:asm.v1" manifestVersion="1.0">
 <assemblyIdentity version="1.0.0.0"
 processorArchitecture="X86"
 name="%s"
 type="win32"/>

 <!-- Identify the application security requirements. -->
 <trustInfo xmlns="urn:schemas-microsoft-com:asm.v3">
 <security>
 <requestedPrivileges>
 <requestedExecutionLevel level="asInvoker" uiAccess="false"/>
 </requestedPrivileges>
 </security>
 </trustInfo>
</assembly>s   ^#!.*pythonw?[0-9.]*([ 	].*)?$z# -*- coding: utf-8 -*-
import re
import sys
from %(module)s import %(import_name)s
if __name__ == '__main__':
    sys.argv[0] = re.sub(r'(-script\.pyw|\.exe)?$', '', sys.argv[0])
    sys.exit(%(func)s())
c                 C   sX   d| krT|  drB| dd\}}d|krT| dsTd||f } n|  dsTd|  } | S )N z
/usr/bin/env r   "z%s "%s"z"%s")
startswithsplit)
executableenvZ_executable r   ?/usr/lib/python3.8/site-packages/pip/_vendor/distlib/scripts.py_enquote_executable3   s    

r   c                   @   s   e Zd ZdZeZdZd'ddZdd Ze	j
d	rBd
d Zdd
 Z
dd Zd(ddZdd ZeZdd Zdd Zd)ddZdd Zedd Zejdd Zejd ksejd	krejd krd!d" Zd*d#d$Zd+d%d&ZdS ),ScriptMakerz_
    A class to copy or create scripts from source scripts or callable
    specifications.
    NTFc                 C   sz   || _ || _|| _d| _d| _tjdkp:tjdko:tjdk| _t	d| _
|pRt|| _tjdkprtjdkortjdk| _
d S )NFposixjava) X.Ynt)
source_dir
target_dir
add_launchersforceclobberosname_nameset_modesetvariantsr   _fileop_is_nt)selfr   r   r   dry_runZfileopr   r   r   __init__L   s    

zScriptMaker.__init__c                 C   s@   | ddr<| jr<tj|\}}|dd}tj||}|S )NguiFpythonZpythonw)getr(   r!   pathr   replacejoin)r)   r   optionsZdnfnr   r   r   _get_alternate_executable\   s
    z%ScriptMaker._get_alternate_executabler   c              
   C   s\   z0t |}|ddkW  5 Q R  W S Q R X W n& ttfk
rV   td| Y dS X dS )zl
            Determine if the specified executable is a script
            (contains a #! line)
               z#!zFailed to open %sFN)openreadOSErrorIOErrorloggerwarning)r)   r   fpr   r   r   	_is_shelld   s    
&zScriptMaker._is_shellc                 C   sD   |  |r*dd l}|jjddkr<|S n| dr<|S d| S )Nr   zos.nameZLinuxz
jython.exez/usr/bin/env %s)r=   r   ZlangZSystemZgetPropertylowerendswith)r)   r   r   r   r   r   _fix_jython_executablep   s    
z"ScriptMaker._fix_jython_executablec                 C   s   t jdkrd}n8t|t| d }tjdkr4d}nd}d|koF||k}|r^d| | d	 }n d
}|d| | d 7 }|d
7 }|S )a  
        Build a shebang line. In the simple case (on Windows, or a shebang line
        which is not too long or contains spaces) use a simple formulation for
        the shebang. Otherwise, use /bin/sh as the executable, with a contrived
        shebang which allows the script to run either under Python or sh, using
        suitable quoting. Thanks to Harald Nordgren for his input.

        See also: http://www.in-ulm.de/~mascheck/various/shebang/#length
                  https://hg.mozilla.org/mozilla-central/file/tip/mach
        r   T   darwini          s   #!   
s
   #!/bin/sh
s	   '''exec' s    "$0" "$@"
s   ' ''')r!   r"   lensysplatform)r)   r   post_interpZsimple_shebangZshebang_lengthZmax_shebang_lengthresultr   r   r   _build_shebang|   s    

zScriptMaker._build_shebang    c                 C   s`  d}| j r| j }d}n^t s&t }nNt rLtjtddt	d }n(tjt	ddt	dt	df }|r| 
||}tj
d	r| |}tj|}|rt|}|d
}tjdkrd|krd
|kr|d7 }| ||}z|d
 W n" tk
r   td| Y nX |d
kr\z|| W n& tk
rZ   td||f Y nX |S )NTFZscriptszpython%sZEXEZBINDIRz
python%s%sZVERSIONr   utf-8Zcliz	-X:Framesz
-X:FullFramess
    -X:Framesz,The shebang (%r) is not decodable from utf-8z?The shebang (%r) is not decodable from the script encoding (%r))r   r   Zis_python_buildr   r   r!   r/   r1   Zget_pathZget_config_varr4   rG   rH   r   r@   normcaser   encoderK   decodeUnicodeDecodeError
ValueError)r)   encodingrI   r2   Zenquoter   shebangr   r   r   _get_shebang   sZ    





zScriptMaker._get_shebangc                 C   s$   | j t|j|jdd |jd S )N.r   )moduleZimport_namefunc)script_templatedictprefixsuffixr   )r)   entryr   r   r   _get_script_text   s    
zScriptMaker._get_script_textc                 C   s   t j|}| j| S N)r!   r/   basenamemanifest)r)   Zexenamebaser   r   r   get_manifest   s    zScriptMaker.get_manifestc                 C   s  | j o
| j}tjd}||s*||7 }|s8|| }nZ|dkrL| d}n
| d}t }	t|	d}
|
	d| W 5 Q R X |	
 }|| | }|D ]V}tj| j
|}
|rxtj|
\}}|dr|}
d|
 }
z| j|
| W n tk
rt   td d	|
 }tj|r&t| t|
| | j|
| td
 zt| W n tk
rn   Y nX Y nX nl| jr|
d| sd|
|f }
tj|
r| jstd
|
 q| j|
| | jr| j|
g ||
 qd S )NrM   pytwz__main__.pyz.pyz%s.exez:Failed to write executable - trying to use .deleteme logicz%s.deletemez0Able to replace executable using .deleteme logicrV   z%s.%szSkipping existing file %s)r   r(   r!   lineseprO   r?   
_get_launcherr   r   Zwritestrgetvaluer/   r1   r   splitextr   r'   Zwrite_binary_file	Exceptionr:   r;   existsremoverenamedebugr    r$   set_executable_modeappend)r)   namesrT   Zscript_bytes	filenamesextZuse_launcherrg   ZlauncherstreamZzfZzip_datar"   outnameneZdfnamer   r   r   
_write_script   sX    







zScriptMaker._write_scriptc                 C   s   d}|r0| dg }|r0dd| }|d}| jd||d}| |d}|j}t }	d| jkrp|	| d| jkr|	d	|t	j
d
 f  d| jkr|	d|t	j
d d
 f  |r| ddrd}
nd}
| |	||||
 d S )NrL   Zinterpreter_argsz %sr
   rM   r2   r   Xz%s%sr   r   z%s-%srA   r,   Fpywrd   )r.   r1   rO   rU   r^   r"   r%   r&   addrG   versionry   )r)   r]   rs   r2   rI   argsrT   scriptr"   Zscriptnamesrt   r   r   r   _make_script  s(    




zScriptMaker._make_scriptc                 C   s  d}t j| jt|}t j| jt j|}| jsT| j	||sTt
d| d S zt|d}W n  t
k
r   | jsz d }Y nLX | }|st
d|  | d S t|dd}|rd}|dpd	}|s|r|  | j|| | jr| j|g || nt
d
|| j | jjst|j\}	}
|d | |	|}d|kr^d
}nd}t j|}
| |
g||  || |r|  d S )NFznot copying %s (up-to-date)rbz"%s: %s is an empty file (skipping)s   
rE   Tr   rL   zcopying and adjusting %s -> %sr   s   pythonwr|   rd   )!r!   r/   r1   r   r
   r   r`   r   r'   Znewerr:   ro   r6   r9   r*   readliner;   Zget_command_name
FIRST_LINE_REmatchr0   groupcloseZ	copy_filer$   rp   rq   infor   seekrU   ry   r7   )r)   r   rs   Zadjustrv   fZ
first_liner   rI   rS   linesrT   rt   rw   r   r   r   _copy_script)  sX    
 


zScriptMaker._copy_scriptc                 C   s   | j jS r_   r'   r*   )r)   r   r   r   r*   ]  s    zScriptMaker.dry_runc                 C   s   || j _d S r_   r   )r)   valuer   r   r   r*   a  s    r   c                 C   sH   t ddkrd}nd}d||f }tddd }t||j}|S )	NP   Z64Z32z%s%s.exerV   r   r   )structcalcsize__name__rsplitr   findbytes)r)   Zkindbitsr"   Zdistlib_packagerJ   r   r   r   rh   i  s    zScriptMaker._get_launcherc                 C   s6   g }t |}|dkr"| || n| j|||d |S )a  
        Make a script.

        :param specification: The specification, which is either a valid export
                              entry specification (to make a script from a
                              callable) or a filename (to make a script by
                              copying from a source location).
        :param options: A dictionary of options controlling script generation.
        :return: A list of all absolute pathnames written to.
        Nrz   )r	   r   r   )r)   
specificationr2   rs   r]   r   r   r   makew  s    zScriptMaker.makec                 C   s$   g }|D ]}| | || q|S )z
        Take a list of specifications and make scripts from them,
        :param specifications: A list of specifications.
        :return: A list of all absolute pathnames written to,
        )extendr   )r)   Zspecificationsr2   rs   r   r   r   r   
make_multiple  s    zScriptMaker.make_multiple)TFN)rL   N)N)N)N) r   
__module____qualname____doc__SCRIPT_TEMPLATErY   r   r+   r4   rG   rH   r   r=   r@   rK   rU   r^   _DEFAULT_MANIFESTra   rc   ry   r   r   propertyr*   setterr!   r"   r#   rh   r   r   r   r   r   r   r   C   s6       

84
4


r   )ior   Zloggingr!   rer   rG   compatr   r   r   Z	resourcesr   utilr   r	   r
   r   r   Z	getLoggerr   r:   stripr   compiler   r   r   objectr   r   r   r   r   <module>   s   


PK       ! ~Rǻ  ǻ  -  distlib/__pycache__/util.cpython-38.opt-1.pycnu [        U

    .e                     @   s  d dl Z d dlmZ d dlZd dlZd dlmZ d dlZd dl	Z	d dl
Z
d dlZd dlZd dl
Z
d dlZzd dlZW n ek
r   dZY nX d dlZd dlZd dlZd dlZd dlZzd dlZW n ek
r   d dlZY nX d dlZddlmZ ddlmZmZmZmZm Z m!Z!m"Z"m#Z#m$Z$m%Z%m&Z&m'Z'm(Z(m)Z)m*Z*m+Z+m,Z,m-Z-m.Z.m/Z/m0Z0 e
1e2Z3e
4dZ5e
4dZ6e
4d	Z7e
4d
Z8e
4dZ9e
4dZ:e
4d
Z;e
4dZ<dd Z=dd Z>dd Z?dd Z@dd ZAdddZBdd ZCdd ZDdd  ZEejFd!d" ZGejFd#d$ ZHejFdd&d'ZIG d(d) d)eJZKd*d+ ZLG d,d- d-eJZMd.d/ ZNG d0d1 d1eJZOe
4d2e
jPZQd3d4 ZRdd5d6ZSd7d8 ZTd9d: ZUd;d< ZVd=d> ZWd?d@ ZXe
4dAe
jYZZe
4dBZ[ddCdDZ\e
4dEZ]dFdG Z^dHdI Z_dJdK Z`dLZadMdN ZbdOdP ZcG dQdR dReJZdG dSdT dTeJZeG dUdV dVeJZfdWZgddYdZZhd[d\ Zid]ZjG d^d_ d_eJZke
4d`Zle
4daZme
4dbZndcdd Zdedf ZoerddglmpZqmrZrmsZs G dhdi die$jtZtG djdk dkeqZpG dldm dmepe'Zuejvddn ZwewdokrG dpdq dqe$jxZxerG drds dse$jyZyG dtdu due%jzZzerBG dvdw dwe%j{Z{G dxdy dye%j|Z|dzd{ Z}G d|d} d}eJZ~G d~d de~ZG dd de~ZG dd de(ZG dd deJZdd ZdS )    N)deque)iglob   )DistlibException)string_types	text_typeshutil	raw_inputStringIOcache_from_sourceurlopenurljoinhttplib	xmlrpclib	splittypeHTTPHandlerBaseConfiguratorvalid_ident	ContainerconfigparserURLErrorZipFilefsdecodeunquoteurlparsez^([\w\.-]+)\s*z^([\w\.*+-]+)\s*z^(<=?|>=?|={2,3}|[~!]=)\s*z*^((<=?)|(>=?)|={2,3}|[~!]=|in|not\s+in)\s*z^or\b\s*z	^and\b\s*z(\S+)\s*z(([\s\w\.{}()*+#:;,/?!~`@$%^&=|<>\[\]-]+)c                    s6   dd  fddfddfdd  | S )	ae  
    Parse a marker string and return a dictionary containing a marker expression.

    The dictionary will contain keys "op", "lhs" and "rhs" for non-terminals in
    the expression grammar, or strings. A string contained in quotes is to be
    interpreted as a literal string, and a string not contained in quotes is a
    variable (such as os_name).
    c                 S   s.  t | }|r,| d }| | d  } n| s:tdn| d }|dkrVtd|  d|d}| dd  } |g}| r| d |