uilder.__init__.<locals>.Elementc                    s*    |}jj| ||d  | | _d S )N)	namespace)
coerceElementElementr   _attributes)r   r   r^   r]   builderrD   r   r   r      s    
z.TreeBuilder.__init__.<locals>.Element.__init__c                    s$     || _| | j| j| j_d S r
   )r_   _nameZ_getETreeTagZ
_namespacer   r$   )r   r   r[   r   r   _setName   s
     z.TreeBuilder.__init__.<locals>.Element._setNamec                    s     | jS r
   )r8   rd   r   r[   r   r   _getName   s    z.TreeBuilder.__init__.<locals>.Element._getNamec                 S   s   | j S r
   ra   r   r   r   r   _getAttributes   s    z4TreeBuilder.__init__.<locals>.Element._getAttributesc                    s    | || _ d S r
   rg   )r   r@   )r]   r   r   _setAttributes   s    z4TreeBuilder.__init__.<locals>.Element._setAttributesNc                    s    |} j| || d S r
   )ZcoerceCharactersr`   
insertText)r   dataZinsertBeforerc   rD   r   r   rj      s    
z0TreeBuilder.__init__.<locals>.Element.insertTextc                    s    j | | d S r
   )r`   r    )r   rB   )rc   r   r   r       s    z1TreeBuilder.__init__.<locals>.Element.appendChild)N)
r   r   r   r   re   rf   r"   r   rh   ri   r@   rj   r    r   rb   r   r   r`      s   

r`   c                       s8   e Zd Z fddZfddZdd ZeeeZdS )z%TreeBuilder.__init__.<locals>.Commentc                    s    |} j| | d S r
   )
coerceCommentCommentr   r   rk   rl   r   r   r      s    
z.TreeBuilder.__init__.<locals>.Comment.__init__c                    s     |}|| j_d S r
   )rm   r   r2   ro   r[   r   r   _setData   s    
z.TreeBuilder.__init__.<locals>.Comment._setDatac                 S   s   | j jS r
   )r   r2   r   r   r   r   _getData   s    z.TreeBuilder.__init__.<locals>.Comment._getDataN)r   r   r   r   rp   rq   r"   rk   r   rl   r   r   rn      s   rn   )r3   ZgetETreeModuler
   r   rH   rD   namespaceHTMLElementsrW   r`   rn   elementClasscommentClassr   rS   r   )r   rr   rT   r`   rn   r   rb   r   r      s    zTreeBuilder.__init__c                 C   s$   t j|  | j| _g | _d | _d S r
   )r   rS   resetinsertCommentInitial
insertCommentinitial_commentsrN   r   r   r   r   ru     s    zTreeBuilder.resetc                 C   s   t |S r
   )rK   r   r   r   r   rK   	  s    zTreeBuilder.testSerializerc                 C   s   t r| jjS | jj S d S r
   )rT   documentr   r   r   r   r   r   getDocument  s    zTreeBuilder.getDocumentc                 C   sF   g }| j d j}|jr"||j |t| |jrB||j |S )Nr   )openElementsr   r2   r*   extendlistr'   )r   Zfragmentr   r   r   r   getFragment  s    zTreeBuilder.getFragmentc                 C   sh   |d }|d }|d }|s0t dt d | _n4| j|}||krPt dt | |||}|| _d S )Nr   r   r   z#lxml cannot represent empty doctypez%lxml cannot represent non-xml doctype)warningswarnr   rN   rD   r_   doctypeClass)r   tokenr   r   r   ZcoercedNamerN   r   r   r   
insertDoctype  s    zTreeBuilder.insertDoctypec                 C   s   | j | d S r
   )rx   r*   r   rk   parentr   r   r   rv   ,  s    z TreeBuilder.insertCommentInitialc                    sB   || j kr,| j j d jtkr,tdt tt	| 
|| d S )Nz@lxml cannot represent adjacent comments beyond the root elements)ry   r   r   r$   r1   r   r   r   superrS   rw   r   	__class__r   r   insertCommentMain1  s
    
zTreeBuilder.insertCommentMainc                 C   s  d}| j r|d| j j 7 }| j jd k	s2| j jd k	r|d| j| j jpFd 7 }| j jr| j j}|ddkr|ddkrtdt	 |
dd}|ddkr|d	| 7 }q|d
| 7 }n|d7 }|d7 }| j j|d
 krtdt	 |d7 }t|}| j
D ] }| |d }||j q |  | _| | j_|d
 }|d| j}|d kr^|}	nd||f }	|	|_| ||}
||
_| jj|
 | j|
 | j| _d S )NrQ   z<!DOCTYPE %sz
 PUBLIC "%s" 'r   "z6DOCTYPE system cannot contain single and double quotesZU00027z"%s"z'%s'z''>r   zGlxml cannot represent doctype with a different name to the root elementz$<THIS_SHOULD_NEVER_APPEAR_PUBLICLY/>rk   r^   rV   )rN   r   r   r   rD   ZcoercePubidfindr   r   r   replacer
   Z
fromstringrx   rt   Zaddpreviousr   
documentClassry   Zgetroottreer   getZdefaultNamespacer$   rs   r   r*   r{   r   rw   )r   r   ZdocStrZsysidroot
comment_tokenZcommentr   r^   Z	etree_tagZroot_elementr   r   r   
insertRoot7  sN    




zTreeBuilder.insertRoot)F)N)N)r   r   r   r   r   r   r   rs   rt   Z
fragmentClassr
   implementationr   ru   rK   rz   r~   r   rv   r   r   
__classcell__r   r   r   r   rS      s   
L

rS   )__doc__Z
__future__r   r   r   r   resysrQ   r   r	   r   r
   r3   r   Z
lxml.etreerT   compiler4   rn   r$   r1   objectr   r   rK   rR   rS   r   r   r   r   <module>   s$   
O)PK       !     ?  html5lib/treebuilders/__pycache__/__init__.cpython-38.opt-1.pycnu [        U

    .e                     @   s6   d Z ddlmZmZmZ ddlmZ i ZdddZdS )	a)  A collection of modules for building different kinds of trees from HTML
documents.

To create a treebuilder for a new type of tree, you need to do
implement several things:

1. A set of classes for various types of elements: Document, Doctype, Comment,
   Element. These must implement the interface of ``base.treebuilders.Node``
   (although comment nodes have a different signature for their constructor,
   see ``treebuilders.etree.Comment``) Textual content may also be implemented
   as another node type, or not, as your tree implementation requires.

2. A treebuilder object (called ``TreeBuilder`` by convention) that inherits
   from ``treebuilders.base.TreeBuilder``. This has 4 required attributes:

   * ``documentClass`` - the class to use for the bottommost node of a document
   * ``elementClass`` - the class to use for HTML Elements
   * ``commentClass`` - the class to use for comments
   * ``doctypeClass`` - the class to use for doctypes

   It also has one required method:

   * ``getDocument`` - Returns the root node of the complete document tree

3. If you wish to run the unit tests, you must also create a ``testSerializer``
   method on your treebuilder which accepts a node and returns a string
   containing Node and its children serialized according to the format used in
   the unittests

    )absolute_importdivisionunicode_literals   )
default_etreeNc                 K   s   |   } | tkr| dkrLddlm} |dkr<ddlm} |}|j|f|jS | dkrlddlm} |jt| < n<| d	krdd
lm	} |dkrt
}|j|f|jS td|  t
| S )a  Get a TreeBuilder class for various types of trees with built-in support

    :arg treeType: the name of the tree type required (case-insensitive). Supported
        values are:

        * "dom" - A generic builder for DOM implementations, defaulting to a
          xml.dom.minidom based implementation.
        * "etree" - A generic builder for tree implementations exposing an
          ElementTree-like interface, defaulting to xml.etree.cElementTree if
          available and xml.etree.ElementTree if not.
        * "lxml" - A etree-based builder for lxml.etree, handling limitations
          of lxml's implementation.

    :arg implementation: (Currently applies to the "etree" and "dom" tree
        types). A module implementing the tree type e.g. xml.etree.ElementTree
        or xml.etree.cElementTree.

    :arg kwargs: Any additional options to pass to the TreeBuilder when
        creating it.

    Example:

    >>> from html5lib.treebuilders import getTreeBuilder
    >>> builder = getTreeBuilder('etree')

    dom   )r   Nr   )minidomZlxml)
etree_lxmletree)r   zUnrecognised treebuilder "%s" )lowertreeBuilderCache r   Zxml.domr	   ZgetDomModuleZTreeBuilderr
   r   r   ZgetETreeModule
ValueErrorget)ZtreeTypeimplementationkwargsr   r	   r
   r    r   N/usr/lib/python3.8/site-packages/pip/_vendor/html5lib/treebuilders/__init__.pygetTreeBuilder'   s$    r   )N)	__doc__Z
__future__r   r   r   Z_utilsr   r
   r   r   r   r   r   <module>   s   PK       !  .   .  ;  html5lib/treebuilders/__pycache__/etree_lxml.cpython-38.pycnu [        U

    .e*7                     @   s   d Z ddlmZmZmZ ddlZddlZddlZddlm	Z	 ddl
mZ ddlm
Z
 dd	lmZ
 dd
lmZ ddlmZ dZedZed
jZG dd deZG dd deZdd Zdd ZG dd de	jZdS )a  Module for supporting the lxml.etree library. The idea here is to use as much
of the native library as possible, without using fragile hacks like custom element
names that break between releases. The downside of this is that we cannot represent
all possible trees; specifically the following are known to cause problems:

Text or comments as siblings of the root element
Docypes with no name

When any of these things occur, we emit a DataLossWarning
    )absolute_importdivisionunicode_literalsN   )base   )DataLossWarning)	constants)etree)	_ihatexmlTz
{([^}]*)}(.*)Zasdc                   @   s   e Zd Zdd ZdS )DocumentTypec                 C   s   || _ || _|| _d S N)namepublicIdsystemId)selfr   r   r    r   P/usr/lib/python3.8/site-packages/pip/_vendor/html5lib/treebuilders/etree_lxml.py__init__#   s    zDocumentType.__init__N)__name__
__module____qualname__r   r   r   r   r   r   "   s   r   c                   @   s,   e Zd Zdd Zdd Zdd ZeeZdS )Documentc                 C   s   d | _ g | _d S r
   )_elementTree_childNodesr   r   r   r   r   *   s    zDocument.__init__c                 C   s   | j  |j d S r
   )r   getrootZaddnext_elementr   elementr   r   r   appendChild.   s    zDocument.appendChildc                 C   s   | j S r
   )r   r   r   r   r   _getChildNodes1   s    zDocument._getChildNodesN)r   r   r   r   r    r!   propertyZ
childNodesr   r   r   r   r   )   s   r   c                    s6   g t jdd d fdd	| d dS )NTZpreventDoubleDashCommentsr   c           
         s,  t | ds,t | drd | jjrz| jjsF| jjsFd| jj }nd| jj| jj| jjf }dd|d  |f  |  }| d k	r| }q|d k	r||d  |	 }qnnt
| tst
| trt
| tst
jd	 dkstd
d| | f  n$d | D ]}||d  qn| jtkrdd| | jf  t | d
r(| jr(d
d| | jf  nt
| tjsttj| j}|d k	r|d}|d}tj| }dd| | |f  ndd|  | jf  t | drg }| j D ]d\}	}
t|	}|d k	rj| \}}	 |	}	tj| }d||	f }n
 |	}|||
f q t |D ]&\}	}
dd|d  |	|
f  q| jrڈd
d|d  | jf  |d7 }| D ]}|| qt | d
r(| jr(d
d|d  | jf  d S )Ntagr   z	#document
<!DOCTYPE %s>z<!DOCTYPE %s "%s" "%s">z|%s%s r   r   z|%s"%s"z#document-fragmentz|%s<!-- %s -->tailr   z
|%s<%s %s>z|%s<%s>attribz%s %sz
|%s%s="%s")!hasattrappenddocinfointernalDTDZ	public_idZ
system_url	root_namer   ZgetpreviousZgetnext
isinstancestrbytessysversion_infoAssertionErrorr$   comment_typetextr'   r
   Z_Elementetree_builders
tag_regexpmatchgroupr	   prefixesfromXmlNamer(   itemsgroupssorted)
r   indentdtd_strZnext_elementZnsmatchnsr$   prefix
attributesr   valueZattr_stringchild
infosetFilterrvserializeElementr   r   rI   ;   s|    














 z(testSerializer.<locals>.serializeElement
)r   )r   
InfosetFilterjoinr   r   rF   r   testSerializer7   s
    F
rN   c                    s$   g   fdd|  d  S )z4Serialize an element and its child nodes to a stringc                    s  t | dsH| jjr:| jjr$| jj}nd| jj } | |   n| jtkrf d| j	f  n~| j
s d| jf  n.ddd | j
 D } d| j|f  | j	r | j	 | D ]}| qĈ d	| jf  t | d
r| j
r | j
 d S )Nr$   r%   z	<!--%s-->z<%s>r&   c                 S   s   g | ]\}}d ||f qS )z%s="%s"r   ).0r   rD   r   r   r   
<listcomp>   s   z6tostring.<locals>.serializeElement.<locals>.<listcomp>z<%s %s>z</%s>r'   )r)   r+   r,   doctyper-   r*   r   r$   r4   r5   r(   rL   r<   r'   )r   r@   attrrE   rH   rI   r   r   rI      s,    





z"tostring.<locals>.serializeElement )rL   rM   r   rS   r   tostring   s     rU   c                       sz   e Zd ZeZeZdZdZeZ	e
ZdddZdd Z
dd Zd	d
 Zdd Zd
d ZdddZd fdd	Zdd Z  ZS )TreeBuilderNFc                    s   t jt|dtjdd | _|| _G fdddt G  fdddj}G fdd	d	j	}|| _
|| _tj
| | d S )
N)fullTreeTr#   c                       s&   e Zd Zd fdd	Z fddZdS )z(TreeBuilder.__init__.<locals>.AttributesNc                    sr   |d kri }|| _ t| | |  D ]F\}}t|trTd|d  |d f }n
 |}|| j j j|< q&d S N{%s}%sr   r   )r   dictr   r<   r.   tuplecoerceAttributer(   )r   r   rD   keyr   rG   r   r   r      s    

z1TreeBuilder.__init__.<locals>.Attributes.__init__c                    sP   t | || t|tr4d|d  |d f }n
 |}|| jjj|< d S rX   )rZ   __setitem__r.   r[   r\   r   r(   )r   r]   rD   r   r^   r   r   r_      s
    

z4TreeBuilder.__init__.<locals>.Attributes.__setitem__)N)r   r   r   r   r_   r   r^   r   r   
Attributes   s   r`   c                       sx   e Zd Z fddZfddZfddZeeeZdd Z fd	d
Z	eee	Z
dfdd
	ZfddZdS )z%TreeBuilder.__init__.<locals>.Elementc                    s*    |}jj| ||d  | | _d S )N)	namespace)
coerceElementElementr   _attributes)r   r   ra   r`   builderrG   r   r   r      s    
z.TreeBuilder.__init__.<locals>.Element.__init__c                    s$     || _| | j| j| j_d S r
   )rb   _nameZ_getETreeTagZ
_namespacer   r$   )r   r   r^   r   r   _setName   s
     z.TreeBuilder.__init__.<locals>.Element._setNamec                    s     | jS r
   )r;   rg   r   r^   r   r   _getName   s    z.TreeBuilder.__init__.<locals>.Element._getNamec                 S   s   | j S r
   rd   r   r   r   r   _getAttributes   s    z4TreeBuilder.__init__.<locals>.Element._getAttributesc                    s    | || _ d S r
   rj   )r   rC   )r`   r   r   _setAttributes   s    z4TreeBuilder.__init__.<locals>.Element._setAttributesNc                    s    |} j| || d S r
   )ZcoerceCharactersrc   
insertText)r   dataZinsertBeforerf   rG   r   r   rm      s    
z0TreeBuilder.__init__.<locals>.Element.insertTextc                    s    j | | d S r
   )rc   r    )r   rE   )rf   r   r   r       s    z1TreeBuilder.__init__.<locals>.Element.appendChild)N)
r   r   r   r   rh   ri   r"   r   rk   rl   rC   rm   r    r   re   r   r   rc      s   

rc   c                       s8   e Zd Z fddZfddZdd ZeeeZdS )z%TreeBuilder.__init__.<locals>.Commentc                    s    |} j| | d S r
   )
coerceCommentCommentr   r   rn   ro   r   r   r      s    
z.TreeBuilder.__init__.<locals>.Comment.__init__c                    s     |}|| j_d S r
   )rp   r   r5   rr   r^   r   r   _setData   s    
z.TreeBuilder.__init__.<locals>.Comment._setDatac                 S   s   | j jS r
   )r   r5   r   r   r   r   _getData   s    z.TreeBuilder.__init__.<locals>.Comment._getDataN)r   r   r   r   rs   rt   r"   rn   r   ro   r   r   rq      s   rq   )r6   ZgetETreeModuler
   r   rK   rG   namespaceHTMLElementsrZ   rc   rq   elementClasscommentClassr   rV   r   )r   ru   rW   rc   rq   r   re   r   r      s    zTreeBuilder.__init__c                 C   s$   t j|  | j| _g | _d | _d S r
   )r   rV   resetinsertCommentInitial
insertCommentinitial_commentsrQ   r   r   r   r   rx     s    zTreeBuilder.resetc                 C   s   t |S r
   )rN   r   r   r   r   rN   	  s    zTreeBuilder.testSerializerc                 C   s   t r| jjS | jj S d S r
   )rW   documentr   r   r   r   r   r   getDocument  s    zTreeBuilder.getDocumentc                 C   sF   g }| j d j}|jr"||j |t| |jrB||j |S )Nr   )openElementsr   r5   r*   extendlistr'   )r   Zfragmentr   r   r   r   getFragment  s    zTreeBuilder.getFragmentc                 C   sh   |d }|d }|d }|s0t dt d | _n4| j|}||krPt dt | |||}|| _d S )Nr   r   r   z#lxml cannot represent empty doctypez%lxml cannot represent non-xml doctype)warningswarnr   rQ   rG   rb   doctypeClass)r   tokenr   r   r   ZcoercedNamerQ   r   r   r   
insertDoctype  s    zTreeBuilder.insertDoctypec                 C   s6   |d ks|| j kst| j jd ks&t| j| d S r
   )r|   r3   r   r{   r*   r   rn   parentr   r   r   ry   ,  s    z TreeBuilder.insertCommentInitialc                    sB   || j kr,| j j d jtkr,tdt tt	| 
|| d S )Nz@lxml cannot represent adjacent comments beyond the root elements)r|   r   r   r$   r4   r   r   r   superrV   rz   r   	__class__r   r   insertCommentMain1  s
    
zTreeBuilder.insertCommentMainc                 C   s  d}| j r| j jst|d| j j 7 }| j jd k	s>| j jd k	r|d| j| j jpRd 7 }| j jr| j j}|ddkr|ddkrt	dt
 |dd}|ddkr|d	| 7 }q|d
| 7 }n|d7 }|d7 }| j j|d
 krt	dt
 |d7 }t
|}| jD ] }| |d }||j q|  | _| | j_|d
 }|d| j}|d krj|}	nd||f }	|	|_| ||}
||
_| jj|
 | j|
 | j| _d S )NrT   z<!DOCTYPE %sz
 PUBLIC "%s" 'r   "z6DOCTYPE system cannot contain single and double quotesZU00027z"%s"z'%s'z''>r   zGlxml cannot represent doctype with a different name to the root elementz$<THIS_SHOULD_NEVER_APPEAR_PUBLICLY/>rn   ra   rY   )rQ   r   r3   r   r   rG   ZcoercePubidfindr   r   r   replacer
   Z
fromstringr{   rw   Zaddpreviousr   
documentClassr|   Zgetroottreer   getZdefaultNamespacer$   rv   r   r*   r~   r   rz   )r   r   ZdocStrZsysidroot
comment_tokenZcommentr   ra   Z	etree_tagZroot_elementr   r   r   
insertRoot7  sP    




zTreeBuilder.insertRoot)F)N)N)r   r   r   r   r   r   r   rv   rw   Z
fragmentClassr
   implementationr   rx   rN   r}   r   r   ry   r   r   
__classcell__r   r   r   r   rV      s   
L

rV   )__doc__Z
__future__r   r   r   r   rer1   rT   r   r	   r   r
   r6   r   Z
lxml.etreerW   compiler7   rq   r$   r4   objectr   r   rN   rU   rV   r   r   r   r   <module>   s$   
O)PK       ! '$  $  :  html5lib/treebuilders/__pycache__/dom.cpython-38.opt-1.pycnu [        U

    .e"                     @   s   d dl mZmZmZ zd dlmZ W n  ek
rD   d dlmZ Y nX d dlm	Z	m
Z
 d dlZddlm
Z
 ddlmZ dd	lmZ dd
lmZ dd ZeeZdS )
    )absolute_importdivisionunicode_literals)MutableMapping)minidomNodeN   )base   )	constants)
namespaces)moduleFactoryFactoryc                    sV   G dd dt  G  fdddtjG fdddtj}dd t S )	Nc                   @   sL   e Zd Zdd Zdd Zdd Zdd Zd	d
 Zdd Zd
d Z	dd Z
dS )zgetDomBuilder.<locals>.AttrListc                 S   s
   || _ d S Nelementselfr    r   I/usr/lib/python3.8/site-packages/pip/_vendor/html5lib/treebuilders/dom.py__init__   s    z(getDomBuilder.<locals>.AttrList.__init__c                 S   s   t | jj S r   )iterr   
attributeskeysr   r   r   r   __iter__   s    z(getDomBuilder.<locals>.AttrList.__iter__c                 S   s4   t |trtn | jj|}||_|| jj|< d S r   )
isinstancetupleNotImplementedErrorr   
ownerDocumentZcreateAttributevaluer   )r   namer   attrr   r   r   __setitem__   s
    
z+getDomBuilder.<locals>.AttrList.__setitem__c                 S   s   t | jjS r   )lenr   r   r   r   r   r   __len__#   s    z'getDomBuilder.<locals>.AttrList.__len__c                 S   s   t | jj S r   )listr   r   itemsr   r   r   r   r&   &   s    z%getDomBuilder.<locals>.AttrList.itemsc                 S   s   t | jj S r   )r%   r   r   valuesr   r   r   r   r'   )   s    z&getDomBuilder.<locals>.AttrList.valuesc                 S   s"   t |trtn| jj| jS d S r   )r   r   r   r   r   r   r   r    r   r   r   __getitem__,   s    
z+getDomBuilder.<locals>.AttrList.__getitem__c                 S   s   t |trtn
| jj|= d S r   )r   r   r   r   r   r(   r   r   r   __delitem__2   s    
z+getDomBuilder.<locals>.AttrList.__delitem__N)__name__
__module____qualname__r   r   r"   r$   r&   r'   r)   r*   r   r   r   r   AttrList   s   r.   c                       s   e Zd Zdd Zedd Zdd Zddd	Zd
d Zdd
 Z	dd Z
 fddZdd ZeeeZ
fddZdd Zdd ZeeZdS )z"getDomBuilder.<locals>.NodeBuilderc                 S   s   t j| |j || _d S r   )r	   r   r   nodeNamer   r   r   r   r   r   9   s    z+getDomBuilder.<locals>.NodeBuilder.__init__c                 S   s   t | jdr| jjpd S )NnamespaceURI)hasattrr   r0   r   r   r   r   <lambda>=   s   z+getDomBuilder.<locals>.NodeBuilder.<lambda>c                 S   s   | |_ | j|j d S r   )parentr   appendChildr   noder   r   r   r4   @   s    z.getDomBuilder.<locals>.NodeBuilder.appendChildNc                 S   s4   | j j|}|r$| j ||j  n| j | d S r   )r   r   createTextNodeinsertBeforer4   )r   datar8   textr   r   r   
insertTextD   s    z-getDomBuilder.<locals>.NodeBuilder.insertTextc                 S   s   | j |j |j  | |_d S r   )r   r8   r3   )r   r6   ZrefNoder   r   r   r8   K   s    z/getDomBuilder.<locals>.NodeBuilder.insertBeforec                 S   s&   |j j| j kr| j |j  d |_d S r   )r   Z
parentNoderemoveChildr3   r5   r   r   r   r<   O   s    z.getDomBuilder.<locals>.NodeBuilder.removeChildc                 S   s6   | j  r,| j j}| j | |j | q g | _d S r   )r   
hasChildNodesZ
firstChildr<   r4   
childNodes)r   Z	newParentchildr   r   r   reparentChildrenT   s
    
z3getDomBuilder.<locals>.NodeBuilder.reparentChildrenc                    s
    | j S r   r   r   )r.   r   r   
getAttributes[   s    z0getDomBuilder.<locals>.NodeBuilder.getAttributesc                 S   sv   |rrt | D ]`\}}t|trb|d d k	rD|d d |d  }n|d }| j|d || q| j|| qd S )Nr   :r   r
   )r%   r&   r   r   r   ZsetAttributeNSZsetAttribute)r   r   r    r   Z
qualifiedNamer   r   r   
setAttributes^   s    
 z0getDomBuilder.<locals>.NodeBuilder.setAttributesc                    s    | j dS )NF)r   	cloneNoder   NodeBuilderr   r   rD   m   s    z,getDomBuilder.<locals>.NodeBuilder.cloneNodec                 S   s
   | j  S r   )r   r=   r   r   r   r   
hasContentp   s    z-getDomBuilder.<locals>.NodeBuilder.hasContentc                 S   s(   | j d krtd | jfS | j | jfS d S )NZhtml)	namespacer   r    r   r   r   r   getNameTuples   s    
z/getDomBuilder.<locals>.NodeBuilder.getNameTuple)N)r+   r,   r-   r   propertyrH   r4   r;   r8   r<   r@   rA   rC   r   rD   rG   rI   Z	nameTupler   )r.   rF   r   r   rF   8   s   

rF   c                       s   e Zd Z fddZ fddZdfdd	Zfdd	Zfd
dZdd
 ZfddZ	dd Z
dd ZdddZZ
dZdS )z"getDomBuilder.<locals>.TreeBuilderc                    s      d d d | _t| S r   )getDOMImplementationZcreateDocumentdomweakrefproxyr   )Domr   r   
documentClass|   s    z0getDomBuilder.<locals>.TreeBuilder.documentClassc                    sR   |d }|d }|d }   }||||}| j|  tkrN| j|_d S )Nr    publicIdsystemId)rK   ZcreateDocumentTypeZdocumentr4   r   rL   r   )r   tokenr    rQ   rR   ZdomimplZdoctype)rO   rF   r   r   
insertDoctype   s    z0getDomBuilder.<locals>.TreeBuilder.insertDoctypeNc                    s6   |d kr | j d kr | j|}n| j||} |S r   )ZdefaultNamespacerL   Z
createElementZcreateElementNS)r   r    rH   r6   rE   r   r   elementClass   s    z/getDomBuilder.<locals>.TreeBuilder.elementClassc                    s    | j |S r   )rL   Z
createComment)r   r9   rE   r   r   commentClass   s    z/getDomBuilder.<locals>.TreeBuilder.commentClassc                    s    | j  S r   )rL   ZcreateDocumentFragmentr   rE   r   r   
fragmentClass   s    z0getDomBuilder.<locals>.TreeBuilder.fragmentClassc                 S   s   | j |j d S r   )rL   r4   r   r5   r   r   r   r4      s    z.getDomBuilder.<locals>.TreeBuilder.appendChildc                    s    |S r   r   r   )testSerializerr   r   rX      s    z1getDomBuilder.<locals>.TreeBuilder.testSerializerc                 S   s   | j S r   )rL   r   r   r   r   getDocument   s    z.getDomBuilder.<locals>.TreeBuilder.getDocumentc                 S   s   t j| jS r   )r	   TreeBuildergetFragmentr   r   r   r   r   r[      s    z.getDomBuilder.<locals>.TreeBuilder.getFragmentc                 S   sp   |}|| krt j| || nNt| jdrXtj| jjkrXt| jj| j_| jj	tj | j
| j| d S )N_child_node_types)r	   rZ   r;   r1   rL   r   	TEXT_NODEr\   r%   appendr4   r7   )r   r9   r3   r   r   r   r;      s    z-getDomBuilder.<locals>.TreeBuilder.insertText)N)N)r+   r,   r-   rP   rT   rU   rV   rW   r4   rX   rY   r[   r;   implementationr    r   )rO   DomImplementationrF   rX   r   r   rZ   {   s   

rZ   c                    s0   |    g  d fdd	| d d S )Nr   c                    s  | j tjkr| jrj| js| jrP| jp&d}| jp0d} dd| | j||f  q~ dd| | jf  n dd| f  nr| j tjkr d nX| j tjkr d n>| j tj	krވ dd| | j
f  n| j tjkr d	d| | j
f  nt| d
r6| j
d k	r6dtj| j
 | jf }n| j} dd| |f  |  rg }tt| jD ]T}| j|}|j}|j}|j
}	|	rdtj|	 |jf }n|j}|||f qnt|D ]&\}} d
d|d  ||f  q|d7 }| jD ]}
|
| qd S )N z|%s<!DOCTYPE %s "%s" "%s"> z|%s<!DOCTYPE %s>z|%s<!DOCTYPE >z	#documentz#document-fragmentz|%s<!-- %s -->z|%s"%s"r0   z%s %sz|%s<%s>z
|%s%s="%s"r
   )ZnodeTyper   ZDOCUMENT_TYPE_NODEr    rQ   rR   r^   Z
DOCUMENT_NODEZDOCUMENT_FRAGMENT_NODEZCOMMENT_NODEZ	nodeValuer]   r1   r0   r   prefixesr/   Z
hasAttributesranger#   r   itemr   Z	localNamesortedr>   )r   indentrQ   rR   r    r   ir!   r   nsr?   rvserializeElementr   r   rl      sT    


 
z?getDomBuilder.<locals>.testSerializer.<locals>.serializeElement
)r   )Z	normalizejoinr   r   rj   r   rX      s
    .
z%getDomBuilder.<locals>.testSerializer)r   r	   r   rZ   locals)r`   rZ   r   )r.   rO   r`   rF   rX   r   
getDomBuilder   s    $C:6rp   )Z
__future__r   r   r   Zcollections.abcr   ImportErrorcollectionsZxml.domr   r   rM   ra   r	   r   r   Z_utilsr
   rp   ZgetDomModuler   r   r   r   <module>   s    _PK       ! O*7  *7  #  html5lib/treebuilders/etree_lxml.pynu [        """Module for supporting the lxml.etree library. The idea here is to use as much
of the native library as possible, without using fragile hacks like custom element
names that break between releases. The downside of this is that we cannot represent
all possible trees; specifically the following are known to cause problems:

Text or comments as siblings of the root element
Docypes with no name

When any of these things occur, we emit a DataLossWarning
"""

from __future__ import absolute_import, division, unicode_literals
# pylint:disable=protected-access

import warnings
import re
import sys

from . import base
from ..constants import DataLossWarning
from .. import constants
from . import etree as etree_builders
from .. import _ihatexml

import lxml.etree as etree


fullTree = True
tag_regexp = re.compile("{([^}]*)}(.*)")

comment_type = etree.Comment("asd").tag


class DocumentType(object):
    def __init__(self, name, publicId, systemId):
        self.name = name
        self.publicId = publicId
        self.systemId = systemId


class Document(object):
    def __init__(self):
        self._elementTree = None
        self._childNodes = []

    def appendChild(self, element):
        self._elementTree.getroot().addnext(element._element)

    def _getChildNodes(self):
        return self._childNodes

    childNodes = property(_getChildNodes)


def testSerializer(element):
    rv = []
    infosetFilter = _ihatexml.InfosetFilter(preventDoubleDashComments=True)

    def serializeElement(element, indent=0):
        if not hasattr(element, "tag"):
            if hasattr(element, "getroot"):
                # Full tree case
                rv.append("#document")
                if element.docinfo.internalDTD:
                    if not (element.docinfo.public_id or
                            element.docinfo.system_url):
                        dtd_str = "<!DOCTYPE %s>" % element.docinfo.root_name
                    else:
                        dtd_str = """<!DOCTYPE %s "%s" "%s">""" % (
                            element.docinfo.root_name,
                            element.docinfo.public_id,
                            element.docinfo.system_url)
                    rv.append("|%s%s" % (' ' * (indent + 2), dtd_str))
                next_element = element.getroot()
                while next_element.getprevious() is not None:
                    next_element = next_element.getprevious()
                while next_element is not None:
                    serializeElement(next_element, indent + 2)
                    next_element = next_element.getnext()
            elif isinstance(element, str) or isinstance(element, bytes):
                # Text in a fragment
                assert isinstance(element, str) or sys.version_info[0] == 2
                rv.append("|%s\"%s\"" % (' ' * indent, element))
            else:
                # Fragment case
                rv.append("#document-fragment")
                for next_element in element:
                    serializeElement(next_element, indent + 2)
        elif element.tag == comment_type:
            rv.append("|%s<!-- %s -->" % (' ' * indent, element.text))
            if hasattr(element, "tail") and element.tail:
                rv.append("|%s\"%s\"" % (' ' * indent, element.tail))
        else:
            assert isinstance(element, etree._Element)
            nsmatch = etree_builders.tag_regexp.match(element.tag)
            if nsmatch is not None:
                ns = nsmatch.group(1)
                tag = nsmatch.group(2)
                prefix = constants.prefixes[ns]
                rv.append("|%s<%s %s>" % (' ' * indent, prefix,
                                          infosetFilter.fromXmlName(tag)))
            else:
                rv.append("|%s<%s>" % (' ' * indent,
                                       infosetFilter.fromXmlName(element.tag)))

            if hasattr(element, "attrib"):
                attributes = []
                for name, value in element.attrib.items():
                    nsmatch = tag_regexp.match(name)
                    if nsmatch is not None:
                        ns, name = nsmatch.groups()
                        name = infosetFilter.fromXmlName(name)
                        prefix = constants.prefixes[ns]
                        attr_string = "%s %s" % (prefix, name)
                    else:
                        attr_string = infosetFilter.fromXmlName(name)
                    attributes.append((attr_string, value))

                for name, value in sorted(attributes):
                    rv.append('|%s%s="%s"' % (' ' * (indent + 2), name, value))

            if element.text:
                rv.append("|%s\"%s\"" % (' ' * (indent + 2), element.text))
            indent += 2
            for child in element:
                serializeElement(child, indent)
            if hasattr(element, "tail") and element.tail:
                rv.append("|%s\"%s\"" % (' ' * (indent - 2), element.tail))
    serializeElement(element, 0)

    return "\n".join(rv)


def tostring(element):
    """Serialize an element and its child nodes to a string"""
    rv = []

    def serializeElement(element):
        if not hasattr(element, "tag"):
            if element.docinfo.internalDTD:
                if element.docinfo.doctype:
                    dtd_str = element.docinfo.doctype
                else:
                    dtd_str = "<!DOCTYPE %s>" % element.docinfo.root_name
                rv.append(dtd_str)
            serializeElement(element.getroot())

        elif element.tag == comment_type:
            rv.append("<!--%s-->" % (element.text,))

        else:
            # This is assumed to be an ordinary element
            if not element.attrib:
                rv.append("<%s>" % (element.tag,))
            else:
                attr = " ".join(["%s=\"%s\"" % (name, value)
                                 for name, value in element.attrib.items()])
                rv.append("<%s %s>" % (element.tag, attr))
            if element.text:
                rv.append(element.text)

            for child in element:
                serializeElement(child)

            rv.append("</%s>" % (element.tag,))

        if hasattr(element, "tail") and element.tail:
            rv.append(element.tail)

    serializeElement(element)

    return "".join(rv)


class TreeBuilder(base.TreeBuilder):
    documentClass = Document
    doctypeClass = DocumentType
    elementClass = None
    commentClass = None
    fragmentClass = Document
    implementation = etree

    def __init__(self, namespaceHTMLElements, fullTree=False):
        builder = etree_builders.getETreeModule(etree, fullTree=fullTree)
        infosetFilter = self.infosetFilter = _ihatexml.InfosetFilter(preventDoubleDashComments=True)
        self.namespaceHTMLElements = namespaceHTMLElements

        class Attributes(dict):
            def __init__(self, element, value=None):
                if value is None:
                    value = {}
                self._element = element
                dict.__init__(self, value)  # pylint:disable=non-parent-init-called
                for key, value in self.items():
                    if isinstance(key, tuple):
                        name = "{%s}%s" % (key[2], infosetFilter.coerceAttribute(key[1]))
                    else:
                        name = infosetFilter.coerceAttribute(key)
                    self._element._element.attrib[name] = value

            def __setitem__(self, key, value):
                dict.__setitem__(self, key, value)
                if isinstance(key, tuple):
                    name = "{%s}%s" % (key[2], infosetFilter.coerceAttribute(key[1]))
                else:
                    name = infosetFilter.coerceAttribute(key)
                self._element._element.attrib[name] = value

        class Element(builder.Element):
            def __init__(self, name, namespace):
                name = infosetFilter.coerceElement(name)
                builder.Element.__init__(self, name, namespace=namespace)
                self._attributes = Attributes(self)

            def _setName(self, name):
                self._name = infosetFilter.coerceElement(name)
                self._element.tag = self._getETreeTag(
                    self._name, self._namespace)

            def _getName(self):
                return infosetFilter.fromXmlName(self._name)

            name = property(_getName, _setName)

            def _getAttributes(self):
                return self._attributes

            def _se