z1
        Prepare the master working set.
        r   )__requires__)__main__r   ImportErrorrP   rl   _build_from_requirements)clswsr   r   r   r   
_build_master9  s    
zWorkingSet._build_masterc                 C   sf   | g }t |}||t }|D ]}|| q"tjD ]}||jkr8|| q8|jtjdd< |S )zQ
        Build a working set from a requirement spec. Rewrites sys.path.
        N)rp   resolvere   addrG   r   r   r   )r   Zreq_specr   reqsdistsr   r   r   r   r   r   M  s    

z#WorkingSet._build_from_requirementsc                 C   s<   | j |g  | j| t|dD ]}| ||d q$dS )a  Add a path item to ``.entries``, finding any distributions on it

        ``find_distributions(entry, True)`` is used to find distributions
        corresponding to the path entry, and they are added.  `entry` is
        always appended to ``.entries``, even if it is already present.
        (This is because ``sys.path`` can contain the same value more than
        once, and the ``.entries`` of the ``sys.path`` WorkingSet should always
        equal ``sys.path``.)
        TFN)r   
setdefaultr   r   ra   r   )r   r   r   r   r   r   r   c  s    
zWorkingSet.add_entryc                 C   s   | j |j|kS )z9True if `dist` is the active distribution for its project)r   r   r8   r   r   r   r   r   __contains__r  s    zWorkingSet.__contains__c                 C   s,   | j |j}|dk	r(||kr(t|||S )a  Find a distribution matching requirement `req`

        If there is an active distribution for the requested project, this
        returns it as long as it meets the version requirement specified by
        `req`.  But, if there is an active distribution for the project and it
        does *not* meet the `req` requirement, ``VersionConflict`` is raised.
        If there is no active distribution for the requested project, ``None``
        is returned.
        N)r   r   r8   rl   )r   r   r   r   r   r   r   v  s    

zWorkingSet.findc                    s    fdd| D S )a  Yield entry point objects from `group` matching `name`

        If `name` is None, yields all entry points in `group` from all
        distributions in the working set, otherwise only ones matching
        both `group` and `name` are yielded (in distribution order).
        c                 3   s8   | ]0}|   D ]}d ks*|jkr|V  qqd S r   )rU   valuesr   ).0r   r   rK   r   r   r   	<genexpr>  s     
z/WorkingSet.iter_entry_points.<locals>.<genexpr>r   r   rK   r   r   r   r   rW     s    zWorkingSet.iter_entry_pointsc                 C   s>   t dj}|d }|  ||d< | |d || dS )z?Locate distribution for `requires` and run `script_name` scriptr   r   r   Nr   )r   requiresr   r   r   r   r   r   rQ     s
    zWorkingSet.run_scriptc                 c   sL   i }| j D ]<}|| jkrq
| j| D ] }||kr$d||< | j| V  q$q
dS )zYield distributions for non-duplicate projects in the working set

        The yield order is the order in which the items' path entries were
        added to the working set.
        r   N)r   r   r   )r   seenitemr8   r   r   r   __iter__  s    

zWorkingSet.__iter__TFc                 C   s   |r|j | j||d |dkr$|j}| j|g }| j|jg }|sV|j| jkrVdS || j|j< |j|krx||j |j|kr||j | | dS )a  Add `dist` to working set, associated with `entry`

        If `entry` is unspecified, it defaults to the ``.location`` of `dist`.
        On exit from this routine, `entry` is added to the end of the working
        set's ``.entries`` (if it wasn't already present).

        `dist` is only added to the working set if it's for a project that
        doesn't already have a distribution in the set, unless `replace=True`.
        If it's added, any callbacks registered with the ``subscribe()`` method
        will be called.
        r   N)		insert_onr   locationr   r   r8   r   r   
_added_new)r   r   r   insertr   keysZkeys2r   r   r   r     s    

zWorkingSet.addc                 C   sx  t |ddd }i }i }g }t }	tt}
|rt|d}||krHq.|	||sVq.||j}|dkr| j	|j}|dks||kr|r| }
|dkr|dkrt
| j}nt
g }tg }
|j
||
||d }||j< |dkr|
|d}t|||| ||kr$|
| }t|||||jddd }|| |D ] }|
| |j |j|	|< qHd||< q.|S )a  List all distributions needed to (recursively) meet `requirements`

        `requirements` must be a sequence of ``Requirement`` objects.  `env`,
        if supplied, should be an ``Environment`` instance.  If
        not supplied, it defaults to all distributions available within any
        entry or distribution in the working set.  `installer`, if supplied,
        will be invoked with each requirement that cannot be met by an
        already-installed distribution; it should return a ``Distribution`` or
        ``None``.

        Unless `replace_conflicting=True`, raises a VersionConflict exception
        if
        any requirements are found on the path that have the correct name but
        the wrong version.  Otherwise, if an `installer` is supplied it will be
        invoked to obtain the correct version of the requirement and activate
        it.

        `extras` is a list of the extras to be used with these requirements.
        This is important because extra requirements may look like `my_req;
        extra = "my_extra"`, which would otherwise be interpreted as a purely
        optional requirement.  Instead, we want to be able to assert that these
        requirements are truly required.
        Nr   r   )replace_conflictingT)list
_ReqExtrascollectionsdefaultdictsetpopmarkers_passr   r8   r   re   r   rf   
best_matchrm   r   rl   r   r  