c                 C   s8   dt | jt | j| jptf }| jr4|d| j 7 }|S )z@Return what this distribution's standard .egg filename should bez
%s-%s-py%srb  )rx   r  r   r+  r=  rH   )r   r\  r   r   r   r  
  s     zDistribution.egg_namec                 C   s    | j rd| | j f S t| S d S )Nz%s (%s))r  r   r   r   r   r   r   
  s    zDistribution.__repr__c                 C   s@   zt | dd }W n tk
r(   d }Y nX |p0d}d| j|f S )Nr   z[unknown version]z%s %s)r   rL   r  )r   r   r   r   r   r   
  s    
zDistribution.__str__c                 C   s   | drt|t| j|S )zADelegate all unrecognized public attributes to .metadata providerr   )r   r  r   rq  )r   r]  r   r   r   __getattr__
  s    
zDistribution.__getattr__c                    s.   t ttt|  tdd | j D B S )Nc                 s   s   | ]}| d s|V  qdS r   N)r   )r   r]  r   r   r   r     s   
z'Distribution.__dir__.<locals>.<genexpr>)r  r  superrh   __dir__rq  r   r:  r   r   r    s    zDistribution.__dir__r  c                 K   s   | j t|tj||f|S r   )r  r  r   r   r  )r   r\  r  r)   r   r   r   r    s     
 zDistribution.from_filenamec                 C   s<   t | jtjjr"d| j| jf }nd| j| jf }t|S )z?Return a ``Requirement`` that matches this distribution exactlyz%s==%sz%s===%s)r   ru  r   r   r   r  ri   r   )r   specr   r   r   r    s    zDistribution.as_requirementc                 C   s.   |  ||}|dkr&td||ff | S )z=Return the `name` entry point of `group` or raise ImportErrorNzEntry point %r not found)rV   r   r  )r   rK   r   rg  r   r   r   rT     s    zDistribution.load_entry_pointc                 C   sP   z
| j }W n, tk
r6   t| d|  }| _ Y nX |dk	rL||i S |S )r   zentry_points.txtN)Z_ep_mapr  rj   rk  r  r   )r   rK   Zep_mapr   r   r   rU   &  s    
 zDistribution.get_entry_mapc                 C   s   |  ||S r   )rU   r   r   r   r   r   rV   2  s    zDistribution.get_entry_infoc           
      C   s4  |p| j }|sdS t|}tj|}dd |D }t|D ]|\}}||kr^|rV qq dS q<||kr<| jtkr<|s|||d kr dS |tjkr| 	  |
|| |
||  qq<|tjkr| 	  |r|
d| n
|| dS z|||d }	W n t
k
r   Y q0Y qX ||	= ||	= |	}qdS )a  Ensure self.location is on path

        If replace=False (default):
            - If location is already in path anywhere, do nothing.
            - Else:
              - If it's an egg and its parent directory is on path,
                insert just ahead of the parent.
              - Else: add to the end of path.
        If replace=True:
            - If location is already on path anywhere (not eggs)
              or higher priority than its parent (eggs)
              do nothing.
            - Else:
              - If it's an egg and its parent directory is on path,
                insert just ahead of the parent,
                removing any lower-priority entries.
              - Else: add it to the front of path.
        Nc                 S   s   g | ]}|rt |p|qS r   r/  r0  r   r   r   r  P  s     z*Distribution.insert_on.<locals>.<listcomp>r   r   )r  r  r   r   rj  	enumerater  r}   rG   check_version_conflictr	  r   r3  rL   )
r   r   locr   ZnlocZbdirZnpathr1  r  Znpr   r   r   r  6  s@    



zDistribution.insert_onc                 C   s   | j dkrd S t| d}t| j}| dD ]p}|tjks2||ks2|tkrRq2|dkr\q2t	tj| dd }|rt|
|s2|
| jrq2td||| jf  q2d S )N
setuptoolsr  z
top_level.txt)Z
pkg_resourcesr  Zsiteri  zIModule %s was already imported from %s, but %s is being added to sys.path)r8   r'   r(   r  r|   r  rG   r   r!  r   r   
issue_warning)r   Znspr  modnamefnr   r   r   r  z  s*    



z#Distribution.check_version_conflictc                 C   s6   z
| j  W n& tk
r0   tdt|   Y dS X dS )NzUnbuilt egg for FT)r   rL   r  r   r   r   r   r   r3    s    
zDistribution.has_versionc                 K   s@   d}|  D ]}||t| |d q|d| j | jf |S )z@Copy this distribution, substituting in any changed keyword argsz<project_name version py_version platform location precedenceNr  )r   r   r   rq  r   )r   r)   rM  r]  r   r   r   clone  s
    zDistribution.clonec                 C   s   dd | j D S )Nc                 S   s   g | ]}|r|qS r   r   )r   Zdepr   r   r   r    s      z'Distribution.extras.<locals>.<listcomp>)r  r   r   r   r   r    s    zDistribution.extras)N)r   )NF)N)N)NF)3r   r   r   r   r  r=  r}   r   r   r  rt  r   r0  rw  rz  r{  r|  r}  r~  r  r8   ru  r  r   r  r`  r  r  r  r  r  r  r  r  r   r   r  r  r   objectr  r  rT   rU   rV   r  r  r3  r  r  
__classcell__r   r   r:  r   rh   
  st       










		

Dc                   @   s   e Zd Zdd ZdS )EggInfoDistributionc                 C   s   |   }|r|| _| S )a  
        Packages installed by distutils (e.g. numpy or scipy),
        which uses an old safe_version, and so
        their version numbers can get mangled when
        converted to filenames (e.g., 1.11.0.dev0+2329eae to
        1.11.0.dev0_2329eae). These distributions will not be
        parsed properly
        downstream by Distribution and safe_version, so
        take an extra step and try to get the version number from
        the metadata file itself instead of the filename.
        )r  rp  )r   Z
md_versionr   r   r   rt    s    z#EggInfoDistribution._reload_versionN)r   r   r   rt  r   r   r   r   r    s   r  c                   @   s>   e Zd ZdZdZedZedd Z	edd Z
dd	 Zd
S )DistInfoDistributionzV
    Wrap an actual or potential sys.path entry
    w/metadata, .dist-info style.
    ZMETADATAz([\(,])\s*(\d.*?)\s*([,\)])c                 C   sF   z| j W S  tk
r@   | | j}tj || _ | j  Y S X dS )zParse and cache metadataN)Z	_pkg_infor  r   r  emailparserZParserZparsestr)r   r  r   r   r   _parsed_pkg_info  s    z%DistInfoDistribution._parsed_pkg_infoc                 C   s2   z| j W S  tk
r,   |  | _ | j  Y S X d S r   )_DistInfoDistribution__dep_mapr  _compute_dependenciesr   r   r   r   r    s
    
zDistInfoDistribution._dep_mapc                    s   dg i }| _ g  | jdp g D ]} t| q" fdd}t|d}|d | | jdpjg D ](}t| }tt||| ||< ql|S )z+Recompute this distribution's dependencies.Nz
Requires-Distc                 3   s*    D ] }|j r|j d| ir|V  qd S )Nr!  r"  )r!  r   r   r   r   reqs_for_extra  s    zBDistInfoDistribution._compute_dependencies.<locals>.reqs_for_extrazProvides-Extra)	r  r  Zget_allr  rp   	frozensetrw   r  r  )r   r  r   r  commonr!  Zs_extrar   r  r   r    s    z*DistInfoDistribution._compute_dependenciesN)r   r   r   r   r  rc  r  ZEQEQr   r  r  r  r   r   r   r   r    s   

	
r  )rK  r  r  c                  O   sZ   d}t  }zt|j|kr&|d7 }qW n tk
r<   Y nX tj| d|d i| d S )Nr   r  )r$   rG   r   r   rL   rU  rV  )r>   r)   rZ  r.   r   r   r   r    s    r  c                   @   s   e Zd Zdd ZdS )RequirementParseErrorc                 C   s   d | jS )Nr   )rI   r>   r   r   r   r   r     s    zRequirementParseError.__str__N)r   r   r   r   r   r   r   r   r    s   r  c              	   c   s   t t| }|D ]l}d|kr.|d|d }|drr|dd  }z|t|7 }W n tk
rp   Y  dS X t|V  qdS )zYield ``Requirement`` objects for each specification in `strs`

    `strs` must be a string, or a (possibly-nested) iterable thereof.
    z #N\)r  ru   r   r  r  r  
StopIterationri   )rO  re  r  r   r   r   rp     s    

c                       sP   e Zd Z fddZdd Zdd Zdd Zd	d
 Zdd Ze	d
d Z
  ZS )ri   c              
      s   zt t| | W n2 tjjk
rF } ztt|W 5 d}~X Y nX | j| _	t
| j}||  | _| _
dd | jD | _ttt| j| _| j
| jt| j| jrt| jndf| _t| j| _dS )z>DO NOT CALL THIS UNDOCUMENTED METHOD; use Requirement.parse()!Nc                 S   s   g | ]}|j |jfqS r   )r4  r   )r   r  r   r   r   r  #  s    z(Requirement.__init__.<locals>.<listcomp>)r  ri   r   r   r  ZInvalidRequirementr  r   r   Zunsafe_namerq   r.  r  r8   	specifierrd  rS  r   rw   r  r  r#  hashCmprv  _Requirement__hash)r   Zrequirement_stringrh  r  r:  r   r   r     s"    
zRequirement.__init__c                 C   s   t |to| j|jkS r   )r   ri   r  ry  r   r   r   r~  .  s    

zRequirement.__eq__c                 C   s
   | |k S r   r   ry  r   r   r   r  4  s    zRequirement.__ne__c                 C   s0   t |tr |j| jkrdS |j}| jj|ddS )NFT)Zprereleases)r   rh   r8   r   r  contains)r   r  r   r   r   r   7  s
    
zRequirement.__contains__c                 C   s   | j S r   )r  r   r   r   r   rw  C  s    zRequirement.__hash__c                 C   s   dt |  S )NzRequirement.parse(%r)rW  r   r   r   r   r   F  s    zRequirement.__repr__c                 C   s   t | \}|S r   )rp   )rP  r   r   r   r   r   I  s    
zRequirement.parse)r   r   r   r   r~  r  r   rw  r   r`  r   r  r   r   r:  r   ri     s   c                 C   s   t | kr| t f S | S )zJ
    Ensure object appears in the mro even
    for old-style classes.
    )r  )classesr   r   r   _always_objectO  s    
r  c                 C   s<   t tt|dt|}|D ]}|| kr| |   S qdS )z2Return an adapter factory for `ob` from `registry`r   N)r  inspectZgetmror   r  )registryr9   r(  tr   r   r   r   Y  s    r   c                 C   s   t j| }tj|dd dS )z1Ensure that the parent directory of `path` existsT)exist_okN)r   r   rj  r   makedirs)r   rj  r   r   r   r{   a  s    c                 C   sX   t stdt| \}}|rT|rTt|sTt| zt|d W n tk
rR   Y nX dS )z/Sandbox-bypassing version of ensure_directory()z*"os.mkdir" not supported on this platform.i  N)r  r  r   r
   rJ  r	   FileExistsError)r   rj  r\  r   r   r   rJ  g  s    rJ  c                 c   sv   d}g }t | D ]V}|dr\|drP|s0|r:||fV  |dd  }g }qftd|q|| q||fV  dS )as  Split a string or iterable thereof into (section, content) pairs

    Each ``section`` is a stripped version of the section header ("[section]")
    and each ``content`` is a list of stripped lines excluding blank lines and
    comment-only lines.  If there are any such lines before the first section
    header, they're returned in a first ``section`` of ``None``.
    N[]r   r   zInvalid section heading)ru   r   r  r  rL   r   )rP  ZsectionZcontentr  r   r   r   rv   t  s    


c                  O   s*   t j}ztt _tj| |W S |t _X d S r   )r   r   os_opentempfileZmkstemp)r>   r)   Zold_openr   r   r   r    s
    r  r"  )categoryr   c                 O   s   | || | S r   r   )r  r>   rX  r   r   r   _call_aside  s    
r  c                    s.   t    | d< |  fddt D  dS )z=Set up global resource manager (deliberately not state-saved)Z_managerc                 3   s&   | ]}| d s|t |fV  qdS r  )r   r   r  r   r   r   r     s   
z_initialize.<locals>.<genexpr>N)rg   r%   r  )r.   r   r  r   _initialize  s
    r  c                  C   s|   t  } td| d | j}| j}| j}| j}|}tdd | D  |dd dd g | _t	t
| jtj
 t t  d	S )
aE  
    Prepare the master working set and make the ``require()``
    API available.

    This function has explicit effects on the global state
    of pkg_resources. It is intended to be invoked once at
    the initialization of this module.

    Invocation by other packages is unsupported and done
    at their own risk.
    r  )r_   c                 s   s   | ]}|j d dV  qdS )Fr  Nr  )r   r   r   r   r   r     s   z1_initialize_master_working_set.<locals>.<genexpr>c                 S   s   | j ddS )NTr  r  r   r   r   r   r?     r@   z0_initialize_master_working_set.<locals>.<lambda>F)r  N)rf   r   r*   rP   rW   r  rQ   rS  r   r  r   r   rG   r   r$   r%   r   )r_   rP   rW   r`   rQ   r   r   r   r   _initialize_master_working_set  s"    
r  c                   @   s   e Zd ZdZdS )r   z
    Base class for warning about deprecations in ``pkg_resources``

    This class is not derived from ``DeprecationWarning``, and as such is
    visible by default.
    Nr   r   r   r   r   r     s   )N)N)F)F)F)F)N)r   Z
__future__r   rG   r   ro  r  rc  r(  r  r  rU  rQ  r[  Zpkgutilr4  rH   r  r   Zemail.parserr  r  r  rB  r  r  r  r  r   r=  r   Zimpr  	NameErrorr  Zpip._vendorr   Zpip._vendor.six.movesr   r   r   r   r	   r
   r   r  r   r  Zos.pathr
   r   Zimportlib.machinery	machineryr  r   r   r   r   r   r   r  Z
__metaclass__version_infoRuntimeErrorry  r  r  rP   r_   r`   Zresources_streamrc   Zresource_dirrY   rb   r]   rX   rW   r[   rZ   r\   r  r   r!  RuntimeWarningr   r#   r&   r*   r0   r1   r5   r:   r;   r<   Z
_sget_noneZ
_sset_nonerO   __all__rK  rk   rl   r   rm   rn   r   r   r=  r}   r~   r   r   r   r   rR   rJ   r   rD   r  rE   r   rs   rt   rQ   r   rS   rT   rU   rV   r   r   rf   r'   r
  re   r   ro   rg   rd   rq   rr   rw   rx   ry   rz   r   r  r   r   r  r   r   r  r  r   r  r   r   r   r   ra   r  r  r  r  r  r  r  r
  r  r  ZImpImporterr   r  r   r.  r,  r^   r   rB  rC  r|   rF  r  r  r  r*  ru   rF   rQ  VERBOSE
IGNORECASErs  rj   rl  ro  rh   r  r  rr  r  rL   r  rp   r  ri   r  r   r{   rJ  rv   r  filterwarningsr  r$   r  r  Warningr   r   r   r   r   <module>   sZ  



                                              2 




.

     5	 A
 -*

 ""


	
 	
   '3
6


&PK       ! 1ȇ ȇ 7  pkg_resources/__pycache__/__init__.cpython-38.opt-1.pycnu [        U

    .eͦ                 G   @   s  d Z ddlmZ ddlZddlZddlZddlZddlZddlZddl	Z	ddl
Z
ddlZddlZddl
Z
ddlZddlZddlZddlZddlZddlZddlZddlZddlZddlZddlZddlZddlZddlmZ zddlZW n ek
r   ddlZY nX ze  W n e!k
r*   e"Z Y nX ddl#m$Z$ ddl%m&Z&m'Z'm(Z( ddlm)Z) zddlm*Z*m+Z+m,Z, d	Z-W n ek
r   d
Z-Y nX ddlm.Z/ ddl0m1Z1m2Z2 zddl3m4Z5 e5j6 W n ek
r   dZ5Y nX d
dl7m8Z8 ddl#m9Z9 ddl#m:Z: e;d e;d e;d e;d e<Z=dej>  k r@dk rLn ne?de$j@r\dZAdZBdZCdZDdZEdZFdZGdZHdZIdZJdZKdZLdZMdZNdZOdZPdZQdZRdZSG dd deTZUdd ZVi ZWdd ZXdd ZYd d! ZZd"d# Z[d$d% Z\d&d' Z]d(d) Z^d*d+  Z_Z`d,d- Zad.d/d0d1d2d3d4d5d6d7d8d9d:d;d<d=d>d?d@dAdBdCdDdEdFdGdHdIdJdKdLdMddNddOdPdQdRdSdTdUdVdWdXdYdZd[d\d]d^d_d`dadbdcdddedfdgdhdidjdkdldmdndodpdqdrgGZbG dsdI dIecZdG dtdJ dJedZeG dudv dveeZfG dwdK dKedZgG dxdL dLedZhi Ziejjddy ZkdyZldzZmd
ZndZod{Zpd|dm Zqd}d0 Zrg fd~dZsdd Ztdd ZuevdZwevdZxeuZyddR Zzdd/ Z{e{Z|dd1 Z}dd2 Z~ddd3Zdd4 ZG dd` d`ZG dda daeZG ddD dDZG dd deZG ddC dCZeZG ddM dMe?ZG ddE dEZddB ZddO ZddP ZddU ZddV ZddW Zd ddXZG ddg dgZeqee G ddh dheZG ddi dieZe  G dde deeZe ZG dd deZG dd deZG ddj djeZeqe
je G ddb dbeZG ddc dceZG ddd ddeZeXdi d ddk Zddd?ZdddZee
je dddZeee dd ZdddZdd ZG dd dZdd Zdd Zdd Zdd Zeeje ee5dree5je eXdi d eXdi d ddl ZddĄ ZddƄ Zdd< ZdddnZddʄ Zeeje ee
je ee5dr,ee5je dd̄ Zeee ddZ Zddτ Zi fddфZddӄ ZddՄ Zddׄ ZddS Zevd١jZevdejejB jZG ddH dHZdd݄ Zdd߄ ZG ddF dFZG dd deăZG dd deăZeeedZdd ZG dd deɃZddN ZG ddG dGe:jj̓Zdd Zdd ZddY Zdd ZddT Zdd ZejdeUd	d dd Zeeփ fddZedd ZG ddp dpeكZdS (  aZ  
Package resource API
--------------------

A resource is a logical file contained within a package, or a logical
subdirectory thereof.  The package resource API expects resource names
to have their path parts separated with ``/``, *not* whatever the local
path separator is.  Do not use os.path operations to manipulate resource
names being passed into the API.

The package resource API is designed to work with normal filesystem packages,
.egg files, and unpacked .egg files.  It can also work in a limited way with
.zip files and with custom PEP 302 loaders that support the ``get_data()``
method.
    )absolute_importN)get_importer)six)urllibmapfilter)utime)mkdirrenameunlinkTF)open)isdirsplit   )
py31compat)appdirs)	packagingzpip._vendor.packaging.versionz pip._vendor.packaging.specifiersz"pip._vendor.packaging.requirementszpip._vendor.packaging.markers)   r   )r      zPython 3.4 or later is requiredc                   @   s   e Zd ZdZdS )
PEP440Warningza
    Used when there is an issue with a version or specifier not complying with
    PEP 440.
    N__name__
__module____qualname____doc__ r   r   F/usr/lib/python3.8/site-packages/pip/_vendor/pkg_resources/__init__.pyr   x   s   r   c                 C   s8   zt j| W S  t jjk
r2   t j|  Y S X d S N)r   versionVersionInvalidVersion
LegacyVersion)vr   r   r   
parse_version   s    r#   c                 K   s"   t  | tt||  d S r   )globalsupdate_state_varsdictfromkeys)Zvartypekwr   r   r   _declare_state   s    r*   c                  C   s8   i } t  }t D ] \}}|d|  || | |< q| S )NZ_sget_)r$   r&   itemsstategkr"   r   r   r   __getstate__   s
    r0   c                 C   s8   t  }|  D ]$\}}|dt|   ||| | q| S )NZ_sset_)r$   r+   r&   r,   r   r   r   __setstate__   s    r1   c                 C   s   |   S r   )copyvalr   r   r   
_sget_dict   s    r5   c                 C   s   |   || d S r   )clearr%   keyobr-   r   r   r   
_sset_dict   s    r:   c                 C   s   |   S r   )r0   r3   r   r   r   _sget_object   s    r;   c                 C   s   | | d S r   )r1   r7   r   r   r   _sset_object   s    r<   c                  G   s   d S r   r   argsr   r   r   <lambda>       r?   c                  C   sb   t  } t| }|dk	r^tjdkr^z&ddt dd |df } W n tk
r\   Y nX | S )aZ  Return this platform's maximum compatible version.

    distutils.util.get_platform() normally reports the minimum version
    of Mac OS X that would be required to *use* extensions produced by
    distutils.  But what we want when checking compatibility is to know the
    version of Mac OS X that we are *running*.  To allow usage of packages that
    explicitly require a newer version of Mac OS X, we must also know the
    current version of the OS.

    If this condition occurs for any other platform with a version in its
    platform strings, this function should be extended accordingly.
    Ndarwinzmacosx-%s-%s.   r   )	get_build_platformmacosVersionStringmatchsysplatformjoin_macosx_versgroup
ValueError)platmr   r   r   get_supported_platform   s    

&rO   require
run_scriptget_providerget_distributionload_entry_point
get_entry_mapget_entry_infoiter_entry_pointsresource_stringresource_streamresource_filenameresource_listdirresource_existsresource_isdirdeclare_namespaceworking_setadd_activation_listenerfind_distributionsset_extraction_pathcleanup_resourcesget_default_cacheEnvironment
WorkingSetResourceManagerDistributionRequirement
EntryPointResolutionErrorVersionConflictDistributionNotFoundUnknownExtraExtractionErrorparse_requirements	safe_namesafe_versionget_platformcompatible_platformsyield_linessplit_sections
safe_extrato_filenameinvalid_markerevaluate_markerensure_directorynormalize_pathEGG_DISTBINARY_DISTSOURCE_DIST
CHECKOUT_DISTDEVELOP_DISTIMetadataProviderIResourceProviderFileMetadataPathMetadataEggMetadata
EmptyProviderempty_providerNullProviderEggProviderDefaultProviderZipProviderregister_finderregister_namespace_handlerregister_loader_typefixup_namespace_packagesr   PkgResourcesDeprecationWarningrun_mainAvailableDistributionsc                   @   s   e Zd ZdZdd ZdS )rk   z.Abstract base for dependency resolution errorsc                 C   s   | j jt| j S r   )	__class__r   reprr>   selfr   r   r   __repr__   s    zResolutionError.__repr__N)r   r   r   r   r   r   r   r   r   rk      s   c                   @   s<   e Zd ZdZdZedd Zedd Zdd Zd	d
 Z	dS )rl   z
    An already-installed version conflicts with the requested version.

    Should be initialized with the installed Distribution and the requested
    Requirement.
    z3{self.dist} is installed but {self.req} is requiredc                 C   s
   | j d S Nr   r=   r   r   r   r   dist  s    zVersionConflict.distc                 C   s
   | j d S Nr   r=   r   r   r   r   req  s    zVersionConflict.reqc                 C   s   | j jf t S r   	_templateformatlocalsr   r   r   r   report  s    zVersionConflict.reportc                 C   s   |s| S | j |f }t| S )zt
        If required_by is non-empty, return a version of self that is a
        ContextualVersionConflict.
        )r>   ContextualVersionConflict)r   required_byr>   r   r   r   with_context  s    zVersionConflict.with_contextN)
r   r   r   r   r   propertyr   r   r   r   r   r   r   r   rl     s   

c                   @   s&   e Zd ZdZejd Zedd ZdS )r   z
    A VersionConflict that accepts a third parameter, the set of the
    requirements that required the installed Distribution.
    z by {self.required_by}c                 C   s
   | j d S )NrC   r=   r   r   r   r   r   *  s    z%ContextualVersionConflict.required_byN)r   r   r   r   rl   r   r   r   r   r   r   r   r   "  s   
r   c                   @   sH   e Zd ZdZdZedd Zedd Zedd Zd	d
 Z	dd Z
d
S )rm   z&A requested distribution was not foundzSThe '{self.req}' distribution was not found and is required by {self.requirers_str}c                 C   s
   | j d S r   r=   r   r   r   r   r   5  s    zDistributionNotFound.reqc                 C   s
   | j d S r   r=   r   r   r   r   	requirers9  s    zDistributionNotFound.requirersc                 C   s   | j s
dS d| j S )Nzthe applicationz, )r   rI   r   r   r   r   
requirers_str=  s    z"DistributionNotFound.requirers_strc                 C   s   | j jf t S r   r   r   r   r   r   r   C  s    zDistributionNotFound.reportc                 C   s   |   S r   )r   r   r   r   r   __str__F  s    zDistributionNotFound.__str__N)r   r   r   r   r   r   r   r   r   r   r   r   r   r   r   rm   /  s   


c                   @   s   e Zd ZdZdS )rn   z>Distribution doesn't have an "extra feature" of the given nameNr   r   r   r   r   rn   J  s   r   rC   c                 C   s   |t | < dS )a  Register `provider_factory` to make providers for `loader_type`

    `loader_type` is the type or class of a PEP 302 ``module.__loader__``,
    and `provider_factory` is a function that, passed a *module* object,
    returns an ``IResourceProvider`` for that module.
    N)_provider_factories)Zloader_typeZprovider_factoryr   r   r   r   X  s    c                 C   st   t | tr$t| p"tt| d S ztj|  }W n& tk
rX   t	|  tj|  }Y nX t
|dd}tt||S )z?Return an IResourceProvider for the named module or requirementr   
__loader__N)
isinstanceri   r_   findrP   strrG   modulesKeyError
__import__getattr
_find_adapterr   )ZmoduleOrReqmoduleloaderr   r   r   rR   b  s    
c                 C   sd   | s\t  d }|dkrLd}tj|rLttdrLt|}d|krL|d }| |	d | d S )Nr    z0/System/Library/CoreServices/SystemVersion.plist	readPlistZProductVersionrB   )
rH   Zmac_verospathexistshasattrplistlibr   appendr   )_cacher   ZplistZ
plist_contentr   r   r   rJ   o  s    

