<?php
/*
 * Copyright (C) 2017 Manuela v.d.Decken <manuela@isteam.de>
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT OR THIS HEADER
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License 2 for more details.
 *
 * You should have received a copy of the GNU General Public License 2
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * Description of admin/media/upload.php
 *
 * @package      Core
 * @copyright    Manuela v.d.Decken <manuela@isteam.de>
 * @author       $Author: Uwe $
 * @license      GNU General Public License 2.0
 * @version      2.0.1
 * @revision     $Revision: 19 $
 * @since        $Date: 2025-08-09 15:00:42 +0200 (Sa, 09 Aug 2025) $
 * @lastmodified    $Date: 2025-08-09 15:00:42 +0200 (Sa, 09 Aug 2025) $
 * @deprecated   no
 * @description  Uploader for old media administration
 * @svn-id     $Header: file:///G:/SVN_Projekte/WB_Entwicklung/branches/WB_Neuentwicklung/admin/media/upload.php 19 2025-08-09 13:00:42Z Uwe $
 */
declare(strict_types = 1);
//declare(encoding = 'UTF-8');

//namespace ;

use bin\{WbAdaptor,SecureTokens,Sanitize};
use bin\helpers\{PreCheck,PNGType};
use bin\requester\HttpRequester;
use bin\media\WbGif;
use vendor\pclzip\PclZip;
//use bin\media\inc\PhpThumbFactory;
use App\Utils\ImageSizeCalc;
use Intervention\Image\ImageManager;
use Intervention\Image\Drivers\Imagick\Driver;

//use Verot\Upload\Upload;
//use Zebra_Image\ZebraImage; //

    $sAddonPath   = str_replace('\\','/',__DIR__).'/';
    $sModulesPath = \dirname($sAddonPath).'/';
    $sModuleName  = basename($sModulesPath);
    $sAddonName   = basename($sAddonPath);
    $ModuleRel    = ''.$sModuleName.'/';
    $sAddonRel    = ''.$sModuleName.'/'.$sAddonName.'/';
    $sPattern     = "/^(.*?\/)".$sModuleName."\/.*$/";
    $sAppPath     = preg_replace ($sPattern, "$1", $sModulesPath, 1 );
    if (!defined('SYSTEM_RUN')) {require($sAppPath.'config.php');}

        // suppress to print the header
    $admin = new \admin('Media', 'media_upload', false);

    $oReg    = WbAdaptor::getInstance();
    $oApp    = $oReg->getApplication();
    $oTrans  = $oReg->getTranslate();
    $sDomain = $oApp->getDirNamespace(__DIR__);
    $oTrans->enableAddon($sDomain);

    ini_set('upload_max_filesize', '400M');
    ini_set('post_max_size', '440M');
    ini_set('memory_limit', '512M');
    ini_set('zlib.output_compression','1');
    ini_set('zlib.output_compression_level','9');
/* */
    PreCheck::increaseMemory('512M');
    $iMaxSize = PRECHECK::convertToByte('upload_max_filesize');
    $sMaxSize = PreCheck::convertByteToUnit($iMaxSize);
    $UploadOldMaxFilesize= ini_set('upload_max_filesize','512M');
    $UploadMaxFilesize = ini_get('upload_max_filesize');

    $iPostMaxSize = PRECHECK::convertToByte('post_max_size');
    $sPostMaxSize = PRECHECK::convertByteToUnit($iPostMaxSize);
    //$sPostMaxSize = PRECHECK::getPostMaxSize();
// Include the PclZip constant file
    if (!\defined('PCLZIP_ERR_NO_ERROR')) { require($sAppPath.'include/pclzip/Constants.php'); }

try {

    $aOptions = ['options' => [ 'flags' => FILTER_NULL_ON_FAILURE]];
    $sTemp = ($oReg->Request->getParam('upload_target',FILTER_SANITIZE_FULL_SPECIAL_CHARS,$aOptions));
    $bOverwrite  = ($oReg->Request->getParam('overwrite',FILTER_VALIDATE_BOOL,$aOptions));
    $bDeleteZip  = ($oReg->Request->issetParam('delzip'));
    $MaxFileSize = ($oReg->Request->getParam('max_file_size',FILTER_SANITIZE_NUMBER_INT) ?? $UploadMaxFilesize);
    $MaxPostSize = ($oReg->Request->getParam('max_post_size',FILTER_SANITIZE_NUMBER_INT) ?? $iPostMaxSize);
//echo \nl2br(\sprintf("---- [%04d] %s \n",__LINE__,$sTemp));
    if (empty($sTemp)) {
        $sBacklinkUrl  = $oReg->AcpUrl.''.'media/index.php?dir=';
        $sMessage = \sprintf($oTrans->MESSAGE_UPLOAD_ERR_POST_MAX_SIZE."\n",get_cfg_var('post_max_size'));
        throw new \Exception ($sMessage);
    }
    else
    {
        $sTarget       = \str_replace($oReg->MediaDir,'', $sTemp);
        $sBacklinkUrl  =  $oReg->AcpUrl.''.'media/index.php?dir='.$sTemp;
        $sAddonBackUrl =  $oReg->AcpUrl.''.'media/index.php?dir='.$sTemp;
        // Create relative path of the target location for the file
        $aTmpFiles = ($_FILES['file'] ?? []);
        if (empty($aTmpFiles)) {
            $sMessage = \sprintf($oTrans->MESSAGE_UPLOAD_ERR_POST_MAX_SIZE."\n",get_cfg_var('post_max_size'));
            throw new \Exception ($sMessage);
        }
    }
/* */
    if (!\bin\SecureTokens::checkFTAN ()) {
        throw new \Exception ($oTrans->MESSAGE_GENERIC_SECURITY_ACCESS);
    }

    if (!\function_exists('__unserialize')){require(__DIR__.'/parameters.php');}

    $aMessage     = [];
    $aFiles       = [];
    $aFilesFailed = [];
    $pathsettings = [];

    $count           = 0;
    $sum_dirs        = 0;
    $sum_files       = 0;
    $iFolder         = 0;
    $iFiles          = 0;
    $good_uploads    = 0;
    $iTotaluploads   = 0;
    $iUploadedsFiles = 0;

    $sAllowedFileTypes  = 'bmp|gif|jpg|ico|jpeg|png|webp';
    // get from settings and add to forbidden list
    $forbidden_file_types  = \preg_replace( '/\s*[,;\|#]\s*/','|',RENAME_FILES_ON_UPLOAD);

    // Get the current dir   .str_replace(MEDIA_DIRECTORY,'',$directory)
    $directory = (($sTarget === '/') ?  '' : $sTarget);

    $resizepath    = trim(\str_replace(['/',' '],'_', $sTarget),'_');
    $sParentPath   = $resizepath;

    $sMediaDir  = ($oReg->MediaDir);
    $sMedia     = \basename($sMediaDir); //
    $resizepath = (($resizepath=='/')||empty($resizepath) ? $sMedia : $resizepath);

    $relative      = ''.trim($sTarget,'/').''; //$sMediaAbsPath.
    $bIncludeMedia = \stristr($sMedia,$relative) >0;
    $sMediaAbsPath = str_replace('\\','/',$oReg->AppPath.($bIncludeMedia ? '' : $oReg->MediaDir)).''; //

/* ------------------------------  ------------------------------------------ */
    $jpegQuality    = (int)$database->get_one('SELECT `value` FROM `'.$database->TablePrefix.'settings` WHERE `name` = \'media_compress\' ');
    //$aOptions = ['options' => ['filter' => FILTER_VALIDATE_BOOL, 'flags' => FILTER_NULL_ON_FAILURE]];
    $aOptions = ['options' => [ 'flags' => FILTER_NULL_ON_FAILURE]];
    //$bDoResize   = $oReg->Request->getParam('resize_up',\FILTER_VALIDATE_BOOL,\FILTER_NULL_ON_FAILURE);
    $sMediaSettings = $database->get_one('SELECT `value` FROM `'.$database->TablePrefix.'settings` WHERE `name` = \'mediasettings\' ');
    $pathsettings   = getCustomPathsettings($sMediaSettings, $oReg);

    if (!isset($pathsettings['global'])){
        $pathsettings['global'] =
          ['show_thumbs' => 0,
          'admin_only' => 1,
          'resize_up' => 1,
          ];
    }
    $bDoResize   = (bool)\filter_var($pathsettings['global']['resize_up'],\FILTER_VALIDATE_BOOL,\FILTER_NULL_ON_FAILURE);

    $width  = 0;
$height = 0;
$iTargetWidth  = 0;
$iTargetHeight = 0;

if ($bDoResize === true) {
    // Grundwerte aus DB
    $width  = (int)($database->get_one('SELECT `value` FROM `'.$database->TablePrefix.'settings` WHERE `name` = \'media_width\'') ?? 0);
    $height = (int)($database->get_one('SELECT `value` FROM `'.$database->TablePrefix.'settings` WHERE `name` = \'media_height\'') ?? 0);

    if ($width > 0)  { $iTargetWidth  = $width; }
    if ($height > 0) { $iTargetHeight = $height; }

    // Ordner-Key ermitteln
    $relative_directory = ltrim($directory, '/');
    if (empty($relative_directory)) {
        $sKeyToFind = trim($oReg->MediaDir, '/');
    } else {
        $sKeyToFind = trim(str_replace(['/', ' ', '.'], '_', $relative_directory), '_');
    }

    // Debug-Log
//    error_log("sKeyToFind: " . var_export($sKeyToFind, true));
//    error_log("pathsettings keys: " . implode(', ', array_keys($pathsettings)));

    // Ordnerspezifische Einstellungen laden
    if (isset($pathsettings[$sKeyToFind])) {
        $settings = $pathsettings[$sKeyToFind];
    } elseif (is_numeric($sKeyToFind) && isset($pathsettings[(int)$sKeyToFind])) {
        $settings = $pathsettings[(int)$sKeyToFind];
    } else {
        $settings = [];
    }

    // Ordnerwerte übernehmen, wenn vorhanden
    if (!empty($settings)) {
        if (isset($settings['width']) && (int)$settings['width'] > 0) {
            $iTargetWidth = (int)$settings['width'];
        }
        if (isset($settings['height']) && (int)$settings['height'] > 0) {
            $iTargetHeight = (int)$settings['height'];
        }
    }
}



    $aUploadOptions = [
        'resizeUp'              => $bDoResize,
        'jpegQuality'           => $jpegQuality ?? 85,
        'correctPermissions'    => false,
        'preserveAlpha'         => true,
        'alphaMaskColor'        => [255, 255, 255],
        'preserveTransparency'  => true,
        'transparencyMaskColor' => [0, 0, 0],
        'interlace'             => null
    ];

        $aDebugArray = [
          //'global' => $pathsettings['global'],
          //'getimagesize' => $aImg,
          //'ImageInfo' => $aImageInfo,
          //'bIsAlphaPng' => ($bIsAlphaPng ? 'true' :'false'),
          'resizeUp' => ($aUploadOptions['resizeUp'] ? 'true' : 'false'),
          'global width' => ($width ?? 'not set'),
          'global height' => ($height ?? 'not set'),
          'media' => $sMediaDir,
          'media width'  => ($pathsettings[$sMediaDir]['width']  ?? 'not set'),
          'media height' => ($pathsettings[$sMediaDir]['height'] ?? 'not set'),
          'dir' => $directory,
//          'aDir' => $aDir,
          'folder' => $resizepath,
          'folder width' => $iTargetWidth,//$pathsettings[$resizepath]['width'],
          'folder height' => $iTargetHeight,//$pathsettings[$resizepath]['height'],
        ];



$processAndSanitizeImage = (function (string $sSourceFile) use ($iTargetWidth, $iTargetHeight, $aUploadOptions) {
    try {
        // 1. Erstelle den Manager
        $manager = new ImageManager(new Driver());

        // 2. Öffne das Bild. Löst eine Exception aus, wenn es kein gültiges Bild ist (Sicherheits-Check).
        $img = $manager->read($sSourceFile);

        // 3. PRÜFEN OB RESIZE NOTWENDIG IST
        // Wir führen die Größenänderung nur durch, wenn eine maximale Breite oder Höhe in den
        // Einstellungen angegeben wurde ($iTargetWidth oder $iTargetHeight ist größer als 0).
        if ($iTargetWidth > 0 || $iTargetHeight > 0) {

            // 4. DIE KORREKTE RESIZE-LOGIK
            // Intervention/Image ist hier sehr intelligent. Wenn man für einen Parameter
            // null übergibt, wird diese Dimension automatisch unter Beibehaltung
            // des Seitenverhältnisses berechnet. Das deckt alle Ihre Fälle ab!
            // Wir verwenden `?: null`, um aus einer 0 ein null zu machen.
            $img->scaleDown($iTargetWidth ?: null, $iTargetHeight ?: null);
        }

        // 5. IMMER SPEICHERN (KRITISCH FÜR SICHERHEIT/SANITIZATION)
        // Dieser Schritt schreibt die Datei neu und entfernt alle potenziell bösartigen
        // Inhalte, selbst wenn keine Größenänderung stattgefunden hat.
        $img->save($sSourceFile, quality: $aUploadOptions['jpegQuality'] ?? 85);

    } catch (\Exception $e) {
        // Fehler protokollieren und weiterwerfen, damit der Hauptprozess ihn fangen kann.
        error_log('Intervention/Image v3 processing in upload.php failed for file ' . $sSourceFile . ': ' . $e->getMessage());
        throw $e;
    }
});

/* ---------------------------------------------------------------------------------- */
    // Loop through the files
    $aTmpFiles = ($_FILES['file'] ?? []);
    if (empty($aTmpFiles)) {
        $sMessage = \sprintf($oTrans->MESSAGE_UPLOAD_ERR_POST_MAX_SIZE."\n",$sPostMaxSize);
        throw new \Exception ($sMessage);
    }

    //  prepare file array for upload handling
    $aTmpLoop  = $aTmpFiles['error'];
    $aFiles['file'] = [];
    $aErrorFiles = [];
    $key=0;
    foreach ($aTmpLoop as $index=>$item)
    {
        if (($item===\UPLOAD_ERR_OK)) {
            $aFiles['file'][$key]['name'] = media_filename($aTmpFiles['name'][$index]);
            $aFiles['file'][$key]['type'] = $aTmpFiles['type'][$index];
            $aFiles['file'][$key]['size'] = $aTmpFiles['size'][$index];
            $aFiles['file'][$key]['tmp_name'] = $aTmpFiles['tmp_name'][$index];
            $aFiles['file'][$key]['error'] = $item;

            $sNewFilename = ($sMediaAbsPath).$relative.'/'.$aFiles['file'][$key]['name'];  //
            $bFileExists = \is_readable($sNewFilename) && !$bOverwrite;

            if ($bFileExists){
//echo nl2br(sprintf("<div class='w3-border w3-padding w3-margin-left'>[%04d] sNewFilename =  %s</div>\n",__LINE__,$sNewFilename));
                $sUploadedFile = $aTmpFiles['name'][$index];
                $sMessage = \sprintf(($oTrans->MESSAGE_UPLOAD_ERR_FILE_EXISTS),__LINE__,$aTmpFiles['name'][$index]);
                $aMessage[$sUploadedFile] = $sMessage;
                $aFilesFailed[] = $relative.'/'.$sUploadedFile;
//                \trigger_error($sMessage, E_USER_NOTICE);
            }
            //$aFiles['file'][$key]['name'] = media_filename($aTmpFiles['name'][$index]);
            $iUploadedsFiles++;
        } elseif (in_array($item,[1,2,3,6,7,8])){
//            $aErrorFiles[] = $aTmpFiles['error'][$key].' File '.$aTmpFiles['name'][$key];
              switch ($item) {
                  case \UPLOAD_ERR_INI_SIZE:
                      $aErrorFiles[] = sprintf($errorTypes[$item], $aTmpFiles['name'][$key], $UploadMaxFilesize);
                      break;
                  case \UPLOAD_ERR_FORM_SIZE:
                      $aErrorFiles[] = sprintf($errorTypes[$item], $aTmpFiles['name'][$key], $MaxFileSize);
                      break;
                  case \UPLOAD_ERR_PARTIAL:
                  case \UPLOAD_ERR_CANT_WRITE:
                  case \UPLOAD_ERR_EXTENSION:
                      $aErrorFiles[] = sprintf($errorTypes[$item], $aTmpFiles['name'][$key], '');
                      break;
                  case \UPLOAD_ERR_NO_TMP_DIR:
                      $aErrorFiles[] = sprintf($errorTypes[$item], '', '');
                      break;
              }// end switch
        }
        $key++;
    } 

    foreach ($aFiles['file'] as $index=>$item)
    {
        if (($item['error']==0)) {
            $relative = trim($relative,'/');
            $sOrgFilename = $sMediaAbsPath.$relative.'/'.media_filename($aTmpFiles['name'][$index]);
            if (!empty($item['name']))
            {
                $sNewFilename = str_replace('//','/',$sMediaAbsPath.$relative.'/'.$item['name']); //

                $info      = \pathinfo($sNewFilename);
                $ext       = $info['extension'] ?? '';
                //$pathsettings = getPathsettings($sMediaSettings, $oReg);
                if (($sNewFilename) && (\substr($sNewFilename, 0, 1) !== '.') && !\preg_match("/".$forbidden_file_types."$/i", $ext) )
                {
                    $iTotaluploads++;

                    if (\is_readable($sNewFilename) && ($bOverwrite === true)) {
                        //$sTmpName = $item['tmp_name'];
                        if (\move_uploaded_file($item['tmp_name'], $sNewFilename)) {
                            $good_uploads++;
                            $iFiles++;
                            // Chmod the uploaded file
                            change_mode($sNewFilename);
                            $processAndSanitizeImage($sNewFilename, $ext);
                        }
                    } elseif (!\is_readable($sNewFilename)) {
                        if (\move_uploaded_file($item['tmp_name'], $sNewFilename)) {
                            $good_uploads++;
                            $iFiles++;
                            // Chmod the uploaded file
                            change_mode($sNewFilename);
                            $processAndSanitizeImage($sNewFilename, $ext);
                        } else {
                          $sMessage = \sprintf($oTrans->MESSAGE_MEDIA_NO_FILE_UPLOADED,$sNewFilename, $iUploadedsFiles );
                          throw new \Exception ($sMessage);
                        }
                    } 
                    if (($count == 0)) {
                        $sZipFile = ($sOrgFilename);
                        $sParentPath = ($sMediaDir );
                        $aDebugArray = [
                          'count' => $count,
                          'sOrgFilename' => $sOrgFilename,
                          'sNewFilename' => $sNewFilename,
                          'sZipFile' => $sZipFile,
                          'bDoNotResize' => $bDoResize,
                          'ext' => $ext,
                          'sParentPath' => $sParentPath,
                          //'resizepath' => $resizepath,
                          //'pathsettings' => $pathsettings[$resizepath],
                          'unzip' => $oReg->Request->issetParam('unzip')&& (isset($sZipFile) && is_readable($sZipFile))
                        ];
                    }
                    $count++;
                } else {
                    $sMessage = \sprintf($oTrans->MESSAGE_MEDIA_NAME_FILETYPE,'',$sNewFilename, $index);
                    throw new \Exception ($sMessage);
                }
            $count++;
            } // not empty
        } // error == 0

    } //  end foreach $aFiles['file']

    if (((int)$iFiles === 0) && ((int)$iUploadedsFiles===0)) {
        $sErrMsg  = PreCheck::xnl2br($aErrorFiles);
        $sMessage = \sprintf($oTrans->MESSAGE_MEDIA_NO_FILE_UPLOADED."\n".$sErrMsg,$iUploadedsFiles);
        throw new \Exception ($sMessage);
    } elseif (((int)$iFiles !== (int)$iUploadedsFiles) && (count($aFilesFailed) > 0)) {
        $sErrMsg = PreCheck::xnl2br($aErrorFiles);
        $sTmp = '<br><ol><li>'.\implode('<li>', $aFilesFailed).'</li></ol>';
        $sMessage = \sprintf(($oTrans->MESSAGE_UPLOAD_ERR_FILE_EXISTS)."\n".$sErrMsg."\n",$sTmp);
        throw new \Exception ($sMessage);
    }
/* ------------------------------------------------------------------------------------------- */
// BEGIN Zip calls
/* ------------------------------------------------------------------------------------------- */
    // If the user chose to unzip the first file, unzip into the current folder
    if ($oReg->Request->issetParam('unzip') && (isset($sZipFile) && is_readable($sZipFile)) )
    {

    function pclzipCheckValidFile($p_event, &$p_header)
    {
        global $forbidden_file_types;
// ---- all files are skiped
        $bRetVal = false;
        $aMatches= [];
// Check for potentially malicious files
        $info = \pathinfo($p_header['filename']);
        $ext = isset($info['extension']) ? $info['extension'] : '';
        $sBasename = ($info['basename']);
        $dots = (\substr($sBasename, 0, 1) == '.');
        if (($dots !== '.')) {
            $bRetVal = !\preg_match('#^.*?\.('.$forbidden_file_types.')?$#is', $p_header['filename'], $aMatches);
        }
        return (int)$bRetVal;
    }
/* -------------------------------------------------------------------------- */
    function callbackPostExtract($p_event, &$p_header)
    {
         return 1;
    }
/* -------------------------------------------------------------------------- */

    $forbidden_file_types  = \preg_replace( '/\s*[,;\|#]\s*/','|',RENAME_FILES_ON_UPLOAD);
    // Required to unzip file.
    $archive = new PclZip($sZipFile);
    if (($list = $archive->extract(
        PCLZIP_OPT_PATH, $sMediaAbsPath.$relative
        ,PCLZIP_OPT_EXTRACT_DIR_RESTRICTION, str_replace('//','/',$sMediaAbsPath)
        ,PCLZIP_CB_PRE_EXTRACT, 'pclzipCheckValidFile'
        ,PCLZIP_CB_POST_EXTRACT, 'callbackPostExtract'
        ,PCLZIP_OPT_REPLACE_NEWER
    )) === 0) {
       throw new RuntimeException('Could not extract zip file [PclZip].');
    }
     $iFiles = 0;
        $iFolder = 0;
        $good_uploads = (\is_array($list) ? \sizeof($list) : 0);
        if( $archive->errorCode() !== 0 ) {
            // error while trying to extract the archive (most likely wrong format)
            $admin->print_error('UNABLE TO UNZIP FILE' . $archive->errorInfo(true));
        } else {
            // resize files
            $sArchivFile = '';
            for( $x = 0; $x < $good_uploads; $x++)
            {
                if ($list[$x]['status'] == 'skipped'){continue;}
                $sArchivFile = ($list[$x]['filename']);
                $info = \pathinfo($sArchivFile);
                $ext = isset($info['extension']) ? $info['extension'] : '';
                $sTmp =  \str_replace(\str_replace('\\','/',$oReg->AppPath.$oReg->MediaDir),'',$sArchivFile);
                $bValidFile = ((!empty($sArchivFile)) && \preg_match('/' . $sAllowedFileTypes . '$/i', $ext) && !(WbGif::isAnimatet($sArchivFile)));

// count folder and files
                if (($list[$x]['folder']==1)) {$iFolder++;} else {}
                if (($list[$x]['status'] == 'newer_exist') && $bOverwrite && $bValidFile){
                    $iFiles++;
                    $processAndSanitizeImage($sArchivFile,$ext);
                } elseif (($list[$x]['status'] == 'ok') && $bValidFile){
                    $iFiles++;
                    $processAndSanitizeImage($sArchivFile,$ext);
                }
           }  // end for $list[$x]
        }
        if ($oReg->Request->issetParam('delzip') && is_readable($sZipFile)) { unlink($sZipFile); }
        unset($list);
    }    // end extract archiv
/* ------------------------------------------------------------------------------------------- */
// END Zip calls
/* ------------------------------------------------------------------------------------------- */
// single upload success

        if (($iFiles == 1)) {
            $sErrMsg = PreCheck::xnl2br($aErrorFiles);
            $sMessage = (!($oReg->Request->issetParam('unzip'))
            ? \sprintf($oTrans->MESSAGE_MEDIA_SINGLE_UPLOADED."\n".$sErrMsg,$iFiles)
            : \sprintf($oTrans->MESSAGE_MEDIA_ZIP_UPLOADED."\n".$sErrMsg,$iFolder,$iFiles));
        } elseif(($iFiles > 1)) {
            $sErrMsg = PreCheck::xnl2br($aErrorFiles);
            $sMessage = (!($oReg->Request->issetParam('unzip'))
            ? \sprintf($oTrans->MESSAGE_MEDIA_MULTI_UPLOADED."\n".$sErrMsg,$iFiles)
            : \sprintf($oTrans->MESSAGE_MEDIA_ZIP_UPLOADED."\n".$sErrMsg,$iFolder,$iFiles));
        } elseif (($iFiles !== $iUploadedsFiles) && (count($aFilesFailed) > 0)) {
            $sErrMsg = PreCheck::xnl2br($aErrorFiles);
            $sTmp = '<br><ol><li>'.\implode('<li>', $aFilesFailed).'</li></ol>';
            $sMessage = \sprintf(($oTrans->MESSAGE_UPLOAD_ERR_FILE_EXISTS)."\n".$sErrMsg."\n",__LINE__,$sTmp);
            throw new \Exception ($sMessage);
        } else {
            $sErrMsg = PreCheck::xnl2br($aErrorFiles);
            $sMessage = \sprintf($oTrans->MESSAGE_MEDIA_NO_FILE_UPLOADED."\n".$sErrMsg,$iFiles, $iTotaluploads );
            throw new \Exception ($sMessage);
        }
        $admin->print_header();
        $admin->print_success($sMessage,$sAddonBackUrl);

    } catch (\Exception $ex) {
        $admin->print_header();
        $sAddonBackUrl = ($sAddonBackUrl ?? $oReg->AcpUrl.''.'media/index.php?dir=');
        $sErrMsg = PreCheck::xnl2br(\sprintf('[%d] %s', $ex->getLine(), $ex->getMessage()));
        $admin->print_error ($sErrMsg, $sAddonBackUrl);
        exit;
}

// Print admin
$admin->print_footer();

