<?php
/**
 *
 * @category        admin
 * @package         start
 * @author          WebsiteBaker Project
 * @copyright       Ryan Djurovich
 * @copyright       WebsiteBaker Org. e.V.
 * @link            http://websitebaker.org/
 * @license         http://www.gnu.org/licenses/gpl.html
 * @platform        WebsiteBaker 2.12.2
 * @requirements    PHP 7.2.6 and higher
 * @version         $Id: index.php 4 2025-08-08 07:53:04Z Uwe $
 * @filesource      $HeadURL: file:///G:/SVN_Projekte/WB_Entwicklung/branches/WB_Neuentwicklung/admin/start/index.php $
 * @lastmodified    $Date: 2025-08-08 09:53:04 +0200 (Fr, 08 Aug 2025) $
 *
*/
use bin\{WbAdaptor,SecureTokens,Sanitize};
use bin\helpers\{PreCheck,SysInfo};

use vendor\phplib\Template;

    $ds           = "/";
    $sAddonFile   = str_replace('\\','/',__FILE__).'';
    $sAddonPath   = \dirname($sAddonFile).'/';
    $sModulesPath = \dirname($sAddonPath).'/';
    $sModuleName  = basename($sModulesPath);
    $sAddonName   = basename($sAddonPath);
    $ModuleRel    = ''.$sModuleName.'/';
    $sAddonRel    = ''.$sModuleName.'/'.$sAddonName.'/';
    $sPattern     = "/^(.*?\/)".$sModuleName."\/.*$/";
    $sAppPath     = preg_replace ($sPattern, "$1", $sModulesPath, 1 );
    if (!defined('SYSTEM_RUN') && is_readable($sAppPath.'config.php')) {require($sAppPath.'config.php');}

    if (!defined('TABLE_PREFIX')){
        if (!function_exists('callInstaller')){
            $sRequestFromInitialize = true;
            require $sAppPath.'framework/functions.php';
        }
        callInstaller();
    }

//$admin = new \admin('##skip##');
    $admin = new admin('Start','start');
/* -------------------------------------------------------- */
    $oReg     = WbAdaptor::getInstance();
    $oRequest = $oReg->getRequester();
    $aVarnames = $oRequest->getParamNames();
    foreach ($aVarnames as $sName) {
        $aRequestVars[$sName] = $oReg->Request->getParam($sName);
    }
/* -------------------------------------------------------- */
    $sCallingScript = $oReg->Request->getServerVar('SCRIPT_NAME');
    $ModuleUrl      = $oReg->AppUrl.$ModuleRel;
    $sAddonUrl      = $oReg->AppUrl.$sAddonRel;
/* -------------------------------------------------------- */
    $oApp     = $oReg->getApplication();
    $oDb      = $oReg->getDatabase();
    $oTrans   = $oReg->getTranslate();
    $sDomain  = $oApp->getDirNamespace($oReg->ThemePath.'');
    $oTrans->enableAddon($sDomain);
//print '<pre  class="mod-pre" style="margin-left:30px;">function <span>'.__FUNCTION__.'( '.''.' );</span>  filename: <span>'.basename(__FILE__).'</span>  line: '.__LINE__.' -> '."\n";
//print_r( $oTrans->getAddonStack() ); print '</pre>'; \flush (); //  sleep(10); die();

// ---------------------------------------
    if (\defined('FINALIZE_SETUP')) {
        $sql = 'DELETE FROM `'.TABLE_PREFIX.'settings` WHERE `name`=\'finalize_setup\'';
        if ($database->query($sql)) {unset($sql);}
    }
// ---------------------------------------
    $msg  = '<br />';
    callUpgrade(WbAdaptor::getInstance());
/**
 * delete stored ip adresses default after 30 days
 */
    $iSecsPerDay = 86400;
    $iTotalDays  = 30;
    $sql = 'UPDATE `'.TABLE_PREFIX.'users` SET `login_ip` = \'\' WHERE `login_when` < '.(time()-($iSecsPerDay*$iTotalDays));
    if ($database->query($sql)) { /* do nothing */}
/*
// Setup template object, parse vars to it, then parse it
    $oTrans = Translate::getInstance();
    $oTrans->enableAddon('templates/'.DEFAULT_THEME);
    $oTrans->enableAddon($sDomain);
*/
    //$oTrans->getAddonStack();

// Create new template object
    $tpl = new Template(dirname($admin->correct_theme_source('start.htt')));
    $tpl->set_file('page', 'start.htt');
    $tpl->set_block('page', 'main_block', 'main');
    $tpl->set_block('main_block','show_date_block','show_date');
// Insert values into the template object
    $iNow = time()+$oReg->Timezone;
    $aDefaultData = [
              'WELCOME_MESSAGE' => $oTrans->MESSAGE_START_WELCOME_MESSAGE,
              'CURRENT_USER' => $oTrans->MESSAGE_START_CURRENT_USER,
              'DISPLAY_NAME' => $admin->get_display_name(),
              'ADMIN_URL' => ADMIN_URL,
              'WB_URL' => WB_URL,
              'THEME_URL' => THEME_URL,
              'WB_VERSION' => WB_VERSION,
              'START_LIST' => ' ',
          ];

    $tpl->set_var($aDefaultData);

    $iNow   = time()+$oReg->Timezone;
    $ShowDate = sprintf('%s',\bin\helpers\PreCheck::getStrftime($oReg->DateFormat,$iNow,$oReg->Language)); //
    $ShowTime = sprintf('%s',\bin\helpers\PreCheck::getStrftime($oReg->TimeFormat,$iNow,$oReg->Language)); //
    $aMatches = [];
    $bPeriod  = preg_match('/[^0-9:\-\/_].*(am|pm|AM|PM)/i',$ShowTime,$aMatches);
    $sPeriod  = ($bPeriod ? trim($aMatches[0]) : "");
    $aDatesData = [
            'SHOW_DATE' => $ShowDate, //
            'SHOW_TIME' => $ShowTime, //
            'TIMEZONE'  => $oReg->Timezone,
            'PERIOD'    => $sPeriod,
            'LANGUAGE'  => strtolower($oReg->Language),
    ];

    $sDateBlock = ($oReg->ShowStartDatetime ?? false);
    if ((($sDateBlock===false)))
    {
        $tpl->set_block('show_date_block','');
    }
    else
    {
        $tpl->set_var($aDatesData);
        $tpl->parse( 'show_date', 'show_date_block', true);
    }



// Insert permission values into the template object
    $get_permission = (function($type='preferences', $ParentBlock='main_block') use ($admin, $tpl){
        $bRetVal = false;
        $sBlock  = '';
        $tpl->set_block($ParentBlock, 'show_'.$type.'_block', 'show_'.$type);
        if (($admin->get_permission($type) != true) && ($type!='preferences')) {
            $sBlock = 'show_'.$type;
            $tpl->set_block($sBlock, '');
        } else {
            $sBlock = "show_$type"."_block";
            $tpl->parse('show_'.$type, 'show_'.$type.'_block', true);
            $bRetVal = true;
        }
        return $bRetVal;
    });
/**/
    $get_permission ('pages');
    $get_permission ('media');
    $get_permission ('addons');
    $get_permission ('preferences');
    $get_permission ('settings');
    $get_permission ('admintools');
    $get_permission ('access');

//$msg .= (file_exists(WB_PATH.'/install/')) ?  $MESSAGE['START_INSTALL_DIR_EXISTS'] : $msg;
    $tpl->set_var('DISPLAY_WARNING', 'display:none;');
// Check if installation directory still exists
    if (\is_readable(WB_PATH.'/install/upgrade-script.php') ) {
// Check if user is part of Adminstrators group / better be a Systemadministrator
//      if ($admin->ami_group_member(1)){
        if ($admin->getUserId() == 1) {
            $tpl->set_var('WARNING', $msg );
        } else {
            $tpl->set_var('DISPLAY_WARNING', 'display:none;');
        }
    } else {
        $tpl->set_var('DISPLAY_WARNING', 'display:none;');
    }

// Insert "Add-ons" section overview (pretty complex compared to normal)
    $addons_overview = $oTrans->TEXT_MANAGE.' ';
    $addons_count = 0;
    if($admin->get_permission('modules') == true)
    {
        $addons_overview .= '<a class="wb-bold" href="'.ADMIN_URL.'/modules/index.php">'.$oTrans->MENU_MODULES.'</a>';
        $addons_count = 1;
    }
    if($admin->get_permission('templates') == true)
    {
        if($addons_count == 1) { $addons_overview .= ', '; }
        $addons_overview .= '<a class="wb-bold" href="'.ADMIN_URL.'/templates/index.php">'.$oTrans->MENU_TEMPLATES.'</a>';
        $addons_count = 1;
    }
    if($admin->get_permission('languages') == true)
    {
        if($addons_count == 1) { $addons_overview .= ', '; }
        $addons_overview .= '<a class="wb-bold" href="'.ADMIN_URL.'/languages/index.php">'.$oTrans->MENU_LANGUAGES.'</a>';
    }

// Insert "Access" section overview (pretty complex compared to normal)
    $access_overview = $oTrans->TEXT_MANAGE.' ';
    $access_count = 0;
    if($admin->get_permission('users') == true) {
        $access_overview .= '<a class="wb-bold" href="'.ADMIN_URL.'/users/index.php">'.$oTrans->MENU_USERS.'</a>';
        $access_count = 1;
    }
    if($admin->get_permission('groups') == true) {
        if($access_count == 1) { $access_overview .= ', '; }
        $access_overview .= '<a class="wb-bold" href="'.ADMIN_URL.'/groups/index.php">'.$oTrans->MENU_GROUPS.'</a>';
        $access_count = 1;
    }

// Insert section names and descriptions
    $aLangData = [

          'PAGES' => $oTrans->MENU_PAGES,
          'MEDIA' => $oTrans->MENU_MEDIA,
          'ADDONS' => $oTrans->MENU_ADDONS,
          'ACCESS' => $oTrans->MENU_ACCESS,
          'PREFERENCES' => $oTrans->MENU_PREFERENCES,
          'SETTINGS' => $oTrans->MENU_SETTINGS,
          'ADMINTOOLS' => $oTrans->MENU_ADMINTOOLS,
          'HOME_OVERVIEW' => $oTrans->OVERVIEW_START,
          'PAGES_OVERVIEW' => $oTrans->OVERVIEW_PAGES,
          'MEDIA_OVERVIEW' => $oTrans->OVERVIEW_MEDIA,
          'ADDONS_OVERVIEW' => $addons_overview,
          'ACCESS_OVERVIEW' => $access_overview,
          'ADMIN_FLAG' => ($admin->ami_group_member('1') ? '1' : '0'),
          'PREFERENCES_OVERVIEW' => $oTrans->OVERVIEW_PREFERENCES,
          'SETTINGS_OVERVIEW' => $oTrans->OVERVIEW_SETTINGS,
          'ADMINTOOLS_OVERVIEW' => $oTrans->OVERVIEW_ADMINTOOLS,
    ];
    $tpl->set_var($aLangData);

// Parse template object
    $tpl->parse('main', 'main_block', false);
    $tpl->pparse('output', 'page');

// Print admin footer
$admin->print_footer();
