<?php

declare(strict_types=1);

use bin\{WbAdaptor,SecureTokens,Sanitize,Requester};
use bin\helpers\{PreCheck,msgQueue};

    $sAddonFile   = \str_replace('\\','/',__FILE__);
    $sFolder      = \basename(\dirname($sAddonFile));
    switch ($sFolder):
        case 'filerobot':
          $sAddonPath   = \dirname($sAddonFile,2).'/';
          break;
        default :
          $sAddonPath   = (\dirname($sAddonFile)).'/';
    endswitch;

    $sModulesPath = \dirname($sAddonPath).'/';
    $sModuleName  = \basename($sModulesPath);
    $sAddonName   = \basename($sAddonPath);
    $ModuleRel    = ''.$sModuleName.'/';
    $sAddonRel    = ''.$sModuleName.'/'.$sAddonName.'/';
    $sPattern     = "/^(.*?\/)".$sModuleName."\/.*$/";
    $sAppPath     = \preg_replace ($sPattern, "$1", $sModulesPath, 1 );
    if (! \defined('SYSTEM_RUN') && \is_readable($sAppPath.'config.php')) {
        require($sAppPath.'config.php');
    }
/* ------------------------------------------------------------------ */
    $section_name = 'Media';
    $section_permission = 'media_view';
// print with or without header
    $admin_header = false;
    $admin_auth   = ($admin_auth ?? true);
// Include WB admin wrapper script
    $admin = new \admin($section_name, $section_permission,(bool)$admin_header);

/* -------------------------------------------------------- */

// settings needs a admin object
    $oReg       = WbAdaptor::getInstance();
    $oDb        = $oReg->getDatabase();
    $oTrans     = $oReg->getTranslate();
    $oRequest   = $oReg->getRequester();
    $oApp       = $oReg->getApplication();
    $sDir       = $oRequest->getParam('dir');
    $sImageFile = $oRequest->getParam('image');
    $sBacklink  = $oReg->AcpUrl.'media/browse.php?dir='.$sDir;
    $sAcpPath   = $oReg->AcpPath;
    $sDomain    = $oApp->getDirNamespace($sAcpPath.'media');
    $oTrans->enableAddon($sDomain);

/* -------------------------------------------------------- */
    $sImageDir  = ltrim($sDir,'/').'/';
    $sImageFolderUrl = $oReg->AppUrl.$oReg->MediaDir.($sImageDir).$sImageFile;
    $sImageFolderDir = $oReg->AppPath.$oReg->MediaDir.($sImageDir).$sImageFile;
    $sRotateLeft  = 'edit.php?dir='.$sDir.'&amp;image='.$sImageFile.'&amp;degrees=90';
    $sRotateRight = 'edit.php?dir='.$sDir.'&amp;image='.$sImageFile.'&amp;degrees=-90';

    //$aImg = (@getimagesize($sImageFolderDir) ?? []);
    if (false !==($aImg = @\getimagesize($sImageFolderDir) ?? [])) {
        $iImgRatio = (int)(($aImg['0'] > 200) ? 2 : 1);
        $iImgRatio = (int)(($aImg['0']/$iImgRatio > 200) ? 4 :$iImgRatio);
        $aExif0     = (@exif_read_data($sImageFolderDir) ?? []);
        $fDegrees  = ($oRequest->getParam('degrees') ?? null);
        $sLine = str_repeat('-- ',20);
        if ($fDegrees) {
            require 'rotate.php';
            $aExif     = (@exif_read_data($sImageFolderDir) ?? []);
        } else {
            $aExif     = (@exif_read_data($sImageFolderDir) ?? []);
        }
        $iRatio = $aImg[0]/$iImgRatio;
    }

?>
<!DOCTYPE html>
<html>
  <head>
    <title>Filerobot Image Editor</title>
    <meta charset="UTF-8" />
    <title>Filerobot image editor</title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>

    <link href="<?php echo $oReg->ThemeUrl;?>css/3/w3.css" rel="stylesheet" type="text/css" />
    <link href="./style.css" rel="stylesheet" type="text/css" />
  </head>

  <body style="height: 100vh; padding: 0; margin: 0; background-color: #89bbe0;">
    <div id="image-editor" >
    <h2 class="w3-center">Image Workspace</h2>
        <p class="w3-center">Your image <?php echo $sImageFile;?> for later processing</p>
        <div id="w3-container" style="width: 100%; margin: auto;" class="w3-center">
            <div class="w3-bar w3-padding">
                <a class="refresh w3-btn w3-blue w3-hover-green w3-btn-min-width" href="<?php echo $sRotateLeft;?>"><?php echo $oTrans->TEXT_ROTATE_LEFT;?></a>
                <a class="refresh w3-btn w3-blue w3-hover-green w3-btn-min-width" href="<?php echo $sRotateRight;?>"><?php echo $oTrans->TEXT_ROTATE_RIGHT;?></a>
                <a class="w3-btn w3-blue w3-hover-green w3-btn-min-width" href="<?php echo $sBacklink;?>"><?php echo $oTrans->TEXT_BACK;?></a>
            </div>
<?php
//print '<pre  class="mod-pre"  style="margin-left:50px;">function <span>'.__FUNCTION__.'( '.''.' );</span>  filename: <span>'.basename(__FILE__).'</span>  line: '.__LINE__.' -> '."\n";
//print_r( [$sDir,$sImageFolderDir,$sImageFile,...$aImg,$iImgRatio] ); print '</pre>'; \flush (); //  sleep(10); die();

//print '<pre  class="mod-pre" style="margin-left:30px;">function <span>'.__FUNCTION__.'( '.''.' );</span>  filename: <span>'.basename(__FILE__).'</span>  line: '.__LINE__.' -> '."\n";
//print_r( [$aImg,$iImgRatio] ); print '</pre>'; \flush (); //  sleep(10); die();

//print '<pre  class="mod-pre" style="">function <span>'.__FUNCTION__.'( '.''.' );</span>  filename: <span>'.basename(__FILE__).'</span>  line: '.__LINE__.' -> '."\n";
//print_r( [...$aExif0,$sLine,$sImageDir,$sImageFile,$sImageFolderDir,$sImageFolderUrl,...$aImg,$sBacklink,...$aExif] ); print '</pre>'; \flush (); //  sleep(10); die();
?>
            <br>
            <img class="preferably-square" src="<?php echo $sImageFolderUrl ?>" alt="<?php echo $sImageFile;?>" style="width:<?=$aImg[0]/$iImgRatio;?>px !important;">
        </div>
    </div>

<?php

?>

<script>
    let btn = document.getElementsByClassName("refresh");
    let imageurl = '<?= $sImageFolderUrl;?> ';
//console.log(btn);
// attach event listener on btn
    if (btn){
      for (let i = 0; i < btn.length; i++) {
        btn[i].addEventListener('click', function(event) {
              // reload the page
                  window.location.replace(imageurl);
                  //window.location.reload(true);
                  //event.preventDefault();
        })
      }
    }
</script>
  </body>
</html>
