<?php

class User_Controller extends Base_Controller {

	/**
	 * Edit the user's settings
	 * /user/settings
	 *
	 * @return View
	 */
	public function get_settings() {
		return $this->layout->with('active', 'settings')->nest('content', 'user.settings', array(
			'user' => Auth::user()
		));
	}

	public function get_agenda() {
		return $this->layout->with('active', 'user')->nest('content', 'user.agenda', array(
			'users' => Auth::user()
		));
	}

	public function post_settings() {
		if ($_POST["Quoi"] == "Preferences") {
			$settings = User\Setting::update_user_prerefences(Input::all(), Auth::user()->id);
		} else if($_POST["Quoi"] == "account") {
			$settings = User\Setting::update_user_settings(Input::all(), Auth::user()->id);
	
			if(!$settings['success']) {
				return Redirect::to('user/settings')
					->with_input()
					->with_errors($settings['errors'])
					->with('notice-error', __('tinyissue.we_have_some_errors'));
			}
		} else if($_POST["Quoi"] == "Disponibilites") {
			if ($_POST["DispEtat"] == "Absent") {
				$Deb = new DateTime($_POST["DebDate"]);
				$Fin = new DateTime($_POST["FinDate"]);
				while ($Deb < $Fin) {
					$CetteDate = $Deb->format('Y-m-d');
					foreach($_POST["Dispo"] as $ind => $PartJour) {
						try { \DB::query("INSERT INTO users_dispo  (id_dispo, id_project, id_issue, id_user, LaDate, PartJour, Par, Ajour) VALUES (NULL, 0, 0, ".\Auth::user()->id.", '".$CetteDate."', ".$ind.", ".\Auth::user()->id.", '".date("Y-m-d")."')"); } catch (\Exception $e)  { $retour = 0; }
					}
					$Deb = date_add($Deb, date_interval_create_from_date_string("1 day"));
				}
			} elseif ($_POST["DispEtat"] == "Disponible") {
				try { \DB::query("DELETE FROM users_dispo WHERE 
					LaDate >= '".$_POST["DebDate"]."' AND 
					LaDate <= '".$_POST["FinDate"]."'  AND 
					id_user = ".\Auth::user()->id." AND 
					PartJour IN (".implode(",", $_POST["MesDispo"]).") "); 
					} catch (\Exception $e)  { $retour = 0; }
			} 
		}
		return Redirect::to('user/settings')
			->with('notice', __('tinyissue.settings_updated'));
	}

	/**
	 * Shows the user's assigned issues
	 * /user/issues
	 *
	 * @return View
	 */
	public function get_issues() {
		return $this->layout->with('active', 'issues')->nest('content', 'user.issues', array(
			'projects' => Project\User::users_issues(),
		));
	}

	/**
	 * Log the user out
	 * /user/logout
	 *
	 * @return Redirect
	 */
	public function get_logout() {
		Auth::logout();

		return Redirect::to('/');
	}

}