<?php
\Schema::create('activity', function ($table) {
  $table->increments('id');
  $table->string('description', 255)->nullable()->default('');
  $table->string('DE'255)->default('');
  $table->string('EN'255)->default('');
  $table->string('ES'255)->default('');
  $table->string('FR'255)->default('');
  $table->string('IT'255)->default('');
  $table->string('RU'255)->default('');
  $table->string('ZH_CN'255)->default('');
  $table->string('ZH_TW'255)->default('');
  $table->string('activity'255)->default('');
  $table->timestamps();
});

\Schema::create('following', function ($table) {
  $table->increments('id');
  $table->integer('user_id')->default(1);
  $table->integer('project_id')->default(1);
  $table->integer('issue_id')->default(1);
  $table->integer('project')->default(0);
  $table->integer('attached')->default(1);
  $table->integer('tags')->default(1);
});

\Schema::create('permissions', function ($table) {
  $table->increments('id');
  $table->string('permission'255)->default('');
  $table->text('description');
  $table->string('auto_has'255)->default('');
});

\Schema::create('projects', function ($table) {
  $table->increments('id');
  $table->string('name'255)->default('');
  $table->tinyint('status')->default(1);
  $table->timestamps();
  $table->bigint('default_assignee')->default(1);
});

\Schema::create('projects_issues', function ($table) {
  $table->increments('id');
  $table->integer('created_by')->nullable()->default(1);
  $table->integer('closed_by')->nullable()->default(NULL);
  $table->integer('updated_by')->nullable()->default(NULL);
  $table->integer('assigned_to')->nullable()->default(1);
  $table->integer('project_id')->nullable()->default(NULL);
  $table->integer('status')->nullable()->default(1);
  $table->integer('weight')->nullable()->default(1);
  $table->string('title'255)->default('');
  $table->text('body')->nullable()->default(NULL);
  $table->timestamps();
  $table->date('start_at')->nullable()->default(NULL);
  $table->integer('duration')->nullable()->default(30);
  $table->integer('temps_plan')->nullable()->default(30);
  $table->integer('temps_fact')->nullable()->default(0);
  $table->integer('temps_paye')->nullable()->default(0);
  $table->date('closed_at');
});

\Schema::create('projects_issues_attachments', function ($table) {
  $table->increments('id');
  $table->integer('issue_id')->nullable()->default(NULL);
  $table->integer('comment_id')->nullable()->default(0);
  $table->integer('uploaded_by')->nullable()->default(NULL);
  $table->integer('filesize')->nullable()->default(NULL);
  $table->string('filename'255)->default('');
  $table->string('fileextension'255)->default('');
  $table->string('upload_token', 100)->nullable()->default(NULL);
  $table->timestamps();
});

\Schema::create('projects_issues_comments', function ($table) {
  $table->increments('id');
  $table->integer('created_by')->nullable()->default(0);
  $table->integer('project_id')->nullable()->default(NULL);
  $table->integer('issue_id')->nullable()->default(0);
  $table->text('comment')->nullable()->default(NULL);
  $table->integer('temps_fait')->nullable()->default(1);
  $table->date('temps_fait_deb')->nullable()->default(NULL);
  $table->date('temps_fait_fin')->nullable()->default(NULL);
  $table->timestamps();
});

\Schema::create('projects_issues_tags', function ($table) {
  $table->increments('id');
  $table->integer('issue_id')->nullable()->default(NULL);
  $table->integer('tag_id')->nullable()->default(NULL);
  $table->timestamps();
  $table->unique('issue_id','tag_id');
});

\Schema::create('projects_links', function ($table) {
  $table->increments('id_link');
  $table->integer('id_project')->default(1);
  $table->string('category')->default('dev');
  $table->string('link', 100)->default(NULL);
  $table->timestamps();
  $table->date('desactivated')->default(NULL);
  $table->primary('id_link');
});

\Schema::create('projects_users', function ($table) {
  $table->increments('id');
  $table->integer('user_id')->default(0);
  $table->integer('project_id')->default(0);
  $table->timestamps();
});

\Schema::create('roles', function ($table) {
  $table->increments('id');
  $table->string('name', 255)->default('');
  $table->string('role', 255)->default('');
  $table->string('description', 255)->default('');
});

\Schema::create('roles_permissions', function ($table) {
  $table->increments('id');
  $table->integer('role_id')->default(NULL);
  $table->integer('permission_id')->default(NULL);
});

\Schema::create('sessions', function ($table) {
  $table->increments('id');
  $table->integer('last_activity');
  $table->text('data');
});

\Schema::create('settings', function ($table) {
  $table->increments('id');
  $table->string('key', 255)->default('');
  $table->text('value')->default(NULL);
  $table->string('name', 255)->default('');
});

\Schema::create('tags', function ($table) {
  $table->increments('id');
  $table->string('tag', 255);
  $table->string('DE', 255)->default('');
  $table->string('EN', 255)->default('');
  $table->string('ES', 255)->default('');
  $table->string('FR', 255)->default('');
  $table->string('IT', 255)->default('');
  $table->string('RU', 255)->default('');
  $table->string('ZH_CN', 255)->default('');
  $table->string('ZH_TW', 255)->default('');
  $table->string('bgcolor', 50)->default('#330033');
  $table->string('ftcolor', 50)->default('#FFFFFF');
  $table->timestamps();
  $table->unique('tag');
});

\Schema::create('update_history', function ($table) {
  $table->increments('id');
  $table->string('Footprint', 25)->default(NULL);
  $table->string('Description', 100)->default(NULL);
  $table->date('DteRelease')->default(NULL);
  $table->date('DteInstall')->default(NULL);
});

\Schema::create('users', function ($table) {
  $table->increments('id');
  $table->integer('role_id')->default(1);
  $table->string('email', 255)->default('');
  $table->string('password', 255)->default('');
  $table->string('firstname', 255)->default('');
  $table->string('lastname', 255)->default('');
  $table->string('language', 55)->default('en');
  $table->text('preferences')->default(NULL);
  $table->timestamps();
  $table->integer('deleted')->default(0);
});

\Schema::create('users_dispo', function ($table) {
  $table->increments('id_dispo');
  $table->integer('id_project')->default(1);
  $table->integer('id_issue')->default(1);
  $table->integer('id_user')->default(1);
  $table->date('LaDate');
  $table->integer('PartJour')->default(0);
  $table->integer('Par')->default(0);
  $table->string('Accepte')->default(NULL);
  $table->timestamp('AccepteDte');
  $table->timestamp('Ajour');
});

\Schema::create('users_todos', function ($table) {
  $table->increments('id');
  $table->integer('issue_id')->default(NULL);
  $table->integer('user_id')->default(NULL);
  $table->integer('status')->default(1);
  $table->integer('weight')->default(1);
  $table->timestamps();
});

\Schema::create('users_activity', function ($table) {
  $table->increments('id');
  $table->integer('user_id')->default(NULL);
  $table->integer('parent_id')->default(NULL);
  $table->integer('item_id')->default(NULL);
  $table->integer('action_id')->default(NULL);
  $table->integer('type_id')->default(NULL);
  $table->text('data');
  $table->timestamps();
});



\DB::table('permissions')->insert(array(
	array('id'=>1, 'permission'=>'issue-view', 	  'description'=>'View issues in project assigned to', 'auto_has'=>NULL),
	array('id'=>2, 'permission'=>'issue-create',   'description'=>'Create issues in projects assigned to', 'auto_has'=>NULL),
	array('id'=>3, 'permission'=>'issue-comment',  'description'=> 'Comment in issues in projects assigned to', 'auto_has'=>'1'),
	array('id'=>4, 'permission'=>'issue-modify',   'description'=>'Modify issues in projects assigned to', 'auto_has'=>'1'),
	array('id'=>6, 'permission'=>'administration', 'description'=> 'Administration tools, such as user management and application settings.', 'auto_has'=>NULL),
	array('id'=>9, 'permission'=>'project-create', 'description'=> 'Create a new project', 'auto_has'=>NULL),
	array('id'=>10,'permission'=>'project-modify', 'description'=> 'Modify a project assigned to', 'auto_has'=>NULL),
	array('id'=>11,'permission'=>'project-all', 	  'description'=>'View, modify all projects and issues', 'auto_has'=>'1,2,3,4')
));

\DB::table('roles')->insert(array(
	array('id'=>1,'name'=>'User',		'role'=>'user',				'description'=>'Only can read the issues in the projects they are assigned to'),
	array('id'=>2,'name'=>'Developer',	'role'=>'developer',		'description'=>'Can update issues in the projects they are assigned to'),
	array('id'=>3,'name'=>'Manager',	'role'=>'manager',			'description'=>'Can update issues in all projects, even if they aren\'t assigned'),
	array('id'=>4,'name'=>'Administrator','role'=>'administrator',	'description'=>'Can update all issues in all projects, create users and view administration')
));

\DB::table('roles_permissions')->insert(array(
	array('id'=>1,  'role_id'=>1, 'permission_id'=>1),
	array('id'=>2,  'role_id'=>1, 'permission_id'=>2),
	array('id'=>3,  'role_id'=>1, 'permission_id'=>3),
	array('id'=>4,  'role_id'=>2, 'permission_id'=>1),
	array('id'=>5,  'role_id'=>2, 'permission_id'=>2),
	array('id'=>6,  'role_id'=>2, 'permission_id'=>3),
	array('id'=>7,  'role_id'=>2, 'permission_id'=>4),
	array('id'=>8,  'role_id'=>3, 'permission_id'=>11),
	array('id'=>9,  'role_id'=>3, 'permission_id'=>1),
	array('id'=>10, 'role_id'=>3, 'permission_id'=>2),
	array('id'=>11, 'role_id'=>3, 'permission_id'=>3),
	array('id'=>12, 'role_id'=>3, 'permission_id'=>4),
	array('id'=>13, 'role_id'=>4, 'permission_id'=>1),
	array('id'=>14, 'role_id'=>4, 'permission_id'=>2),
	array('id'=>15, 'role_id'=>4, 'permission_id'=>3),
	array('id'=>16, 'role_id'=>4, 'permission_id'=>6),
	array('id'=>17, 'role_id'=>4, 'permission_id'=>9),
	array('id'=>18, 'role_id'=>4, 'permission_id'=>10),
	array('id'=>19, 'role_id'=>4, 'permission_id'=>11),
	array('id'=>20, 'role_id'=>4, 'permission_id'=>4)
));

\DB::table('activity')->insert(array(
	array('id'=>1, 'description'=>'Opened a new issue',		'EN'=>'Opened a new issue',		'FR'=>'Nouveau billet créé',				'activity'=>'create-issue', 'created_at'=>'2022-08-01', 'updated_at'=>'2022-08-01'),
	array('id'=>2, 'description'=>'Commented on a issue',	'EN'=>'Commented on a issue',	'FR'=>'Nouveau commentaire sur un billet',	'activity'=>'comment', 'created_at'=>'2022-08-01', 'updated_at'=>'2022-08-01'),
	array('id'=>3, 'description'=>'Closed an issue',		'EN'=>'Closed an issue',		'FR'=>'Billet fermé',						'activity'=>'close-issue', 'created_at'=>'2022-08-01', 'updated_at'=>'2022-08-01'),
	array('id'=>4, 'description'=>'Reopened an issue',		'EN'=>'Reopened an issue',		'FR'=>'Billet rouvert',						'activity'=>'reopen-issue', 'created_at'=>'2022-08-01', 'updated_at'=>'2022-08-01'),
	array('id'=>5, 'description'=>'Reassigned an issue',	'EN'=>'Reassigned an issue',	'FR'=>'Changement de responsable du billet','activity'=>'reassign-issue', 'created_at'=>'2022-08-01', 'updated_at'=>'2022-08-01'),
	array('id'=>6, 'description'=>'Updated issue tags',		'EN'=>'Updated issue tags',		'FR'=>'Mise à jour des étiquettes',			'activity'=>'update-issue-tags', 'created_at'=>'2022-08-01', 'updated_at'=>'2022-08-01'),
	array('id'=>7, 'description'=>'Attached a file to issue',						'EN'=>'Attached a file to issue',					'FR'=>'Fichier joint au billet',	'activity'=>'attached-file', 'created_at'=>'2022-08-01', 'updated_at'=>'2022-08-01'),
	array('id'=>8, 'description'=>'Move an issue from project A to project B',		'EN'=>'Move an issue from project A to project B',	'FR'=>'Déplacement d`un billet du projet A vers le projet B',	'activity'=>'ChangeIssue-project', 'created_at'=>'2022-08-01', 'updated_at'=>'2022-08-01'),
	array('id'=>9, 'description'=>'User starts or stop following issue or project',	'EN'=>'User starts or stop following issue or project','FR'=>'Un usager a commencé ou cessé de suivre le billet',	'activity'=>'Follow', 'created_at'=>'2022-08-01', 'updated_at'=>'2022-08-01'),
	array('id'=>10,'description'=>'Updated an issue',		'EN'=>'Updated an issue',		'FR'=>'Mise à jour d`un billet', 			'activity'=>'IssueEdit', 'created_at'=>'2022-08-01', 'updated_at'=>'2022-08-01'),
	array('id'=>11,'description'=>'Deleted a comment',		'EN'=>'Deleted a comment',		'FR'=>'Commentaire supprimé', 				'activity'=>'delete_comment', 'created_at'=>'2022-08-01', 'updated_at'=>'2022-08-01'),
	array('id'=>12,'description'=>'Edited a comment',		'EN'=>'Edited a comment',		'FR'=>'Commentaire modifié',				'activity'=>'edit_comment' , 'created_at'=>'2022-08-01', 'updated_at'=>'2022-08-01'),
	array('id'=>13,'description'=>'Elapsed time worked on an issue',				'EN'=>'Elapsed time worked on an issue',			'FR'=>'Temps de travail d`un ouvrier', 							'activity'=>'issue_chrono', 'created_at'=>'2022-08-01', 'updated_at'=>'2022-08-01')
));

\DB::table('tags')->insert(array(
	array('id'=>1,	'tag'=>'status:open',			'bgcolor'=>'#c43c35','ftcolor'=>'#FFFFFF','created_at'=>'2013-11-30 11:23:01','updated_at'=>'2013-11-30 11:23:01','EN'=>'status:open',			'FR'=>'État:ouvert',			'ES'=>'Estado: Aberto'),
	array('id'=>2,	'tag'=>'status:closed',			'bgcolor'=>'#46A546','ftcolor'=>'#FFFFFF','created_at'=>'2013-11-30 11:23:01','updated_at'=>'2013-11-30 11:23:01','EN'=>'status:closed',		'FR'=>'État:fermé',				'ES'=>'Estado: Cerrado'),
	array('id'=>3,	'tag'=>'type:feature',			'bgcolor'=>'#62cffc','ftcolor'=>'#FFFFFF','created_at'=>'2013-11-30 11:23:01','updated_at'=>'2013-11-30 11:23:01','EN'=>'type:feature',			'FR'=>'Type: développement',	'ES'=>'Tipo: desarollo'),
	array('id'=>4,	'tag'=>'type:bug',				'bgcolor'=>'#f89406','ftcolor'=>'#FFFFFF','created_at'=>'2013-11-30 11:23:01','updated_at'=>'2013-11-30 11:23:01','EN'=>'type:bug',				'FR'=>'Type: débogage',			'ES'=>'Tipo: debug'),
	array('id'=>6,	'tag'=>'resolution:won`t fix',	'bgcolor'=>'#812323','ftcolor'=>'#FFFFFF','created_at'=>'2013-11-30 11:23:01','updated_at'=>'2013-11-30 11:23:01','EN'=>'resolution:won`t fix',	'FR'=>'Verdict: impossible :(',	'ES'=>'Deicsion: impossible'),
	array('id'=>7,	'tag'=>'resolution:fixed',		'bgcolor'=>'#048383','ftcolor'=>'#FFFFFF','created_at'=>'2013-11-30 11:23:01','updated_at'=>'2013-11-30 11:23:01','EN'=>'resolution:fixed',		'FR'=>'Verdict: Résolu ! :)',	'ES'=>'Decision: Solucionado'),
	array('id'=>8,	'tag'=>'status:testing',		'bgcolor'=>'#FCC307','ftcolor'=>'#FFFFFF','created_at'=>'2013-11-30 11:23:01','updated_at'=>'2016-11-30 23:11:01','EN'=>'status:testing',		'FR'=>'État: nous testons',		'ES'=>'Estado: haciendo tests'),
	array('id'=>9,	'tag'=>'status:inProgress',		'bgcolor'=>'#FF6600','ftcolor'=>'#FFFFFF','created_at'=>'2016-11-10 23:12:01','updated_at'=>'2016-11-10 23:12:01','EN'=>'status:inProgress',	'FR'=>'État: Progressons',		'ES'=>'Estado: progressamos')
));

\DB::query("INSERT INTO projects_issues_tags (issue_id, tag_id, created_at, updated_at)
	(SELECT id as issue_id, IF(status = 1, 1, 2) as tag_id, NOW(), NOW() FROM projects_issues )"
	);

\DB::table('update_history')->insert(array(
	array('id'=>1, 'Footprint'=>'-------------------------','Description'=>'Version 1.6.0',		 'DteRelease'=>'2017-05-01','DteInstall'=>'2021-12-31'),
	array('id'=>2, 'Footprint'=>'Database update via admin','Description'=>'update_v1-1_1.sql',	 'DteRelease'=>'2017-05-10','DteInstall'=>'2021-12-31'),
	array('id'=>3, 'Footprint'=>'Database update via admin','Description'=>'update_v1-2_9.sql',	 'DteRelease'=>'2018-06-01','DteInstall'=>'2021-12-31'),
	array('id'=>4, 'Footprint'=>'Database update via admin','Description'=>'update_v1-3_1.sql',	 'DteRelease'=>'2018-07-04','DteInstall'=>'2021-12-31'),
	array('id'=>5, 'Footprint'=>'Database update via admin','Description'=>'update_v1-3_2.sql',	 'DteRelease'=>'2018-07-05','DteInstall'=>'2021-12-31'),
	array('id'=>6, 'Footprint'=>'Database update via login','Description'=>'update_v1-3_3.sql',	 'DteRelease'=>'2018-09-18','DteInstall'=>'2021-12-31'),
	array('id'=>7, 'Footprint'=>'Database update via admin','Description'=>'update_v1-8_3a.sql', 'DteRelease'=>'2018-10-10','DteInstall'=>'2021-12-31'),
	array('id'=>8, 'Footprint'=>'Database update via admin','Description'=>'update_v1-8_4a.sql', 'DteRelease'=>'2019-02-14','DteInstall'=>'2021-12-31'),
	array('id'=>9, 'Footprint'=>'Database update via admin','Description'=>'update_v1-8_4b.sql', 'DteRelease'=>'2019-05-08','DteInstall'=>'2021-12-31'),
	array('id'=>10,'Footprint'=>'Database update via admin','Description'=>'update_v1-8_4d.sql', 'DteRelease'=>'2019-07-08','DteInstall'=>'2021-12-31'),
	array('id'=>11,'Footprint'=>'Database update via admin','Description'=>'update_v1-8_5af.sql','DteRelease'=>'2020-04-01','DteInstall'=>'2021-12-31'),
	array('id'=>12,'Footprint'=>'Database update via admin','Description'=>'update_v1-8_5t.sql', 'DteRelease'=>'2020-05-30','DteInstall'=>'2021-12-31'),
	array('id'=>13,'Footprint'=>'Database update via admin','Description'=>'update_v1-8_6e.sql', 'DteRelease'=>'2020-08-11','DteInstall'=>'2021-12-31'),
	array('id'=>14,'Footprint'=>'Database update via admin','Description'=>'update_v1-8_7a.sql', 'DteRelease'=>'2020-10-12','DteInstall'=>'2021-12-31'),
	array('id'=>15,'Footprint'=>'Database update via admin','Description'=>'update_v1-8_7ag.sql','DteRelease'=>'2021-04-03','DteInstall'=>'2021-12-31'),
	array('id'=>16,'Footprint'=>'Database update via admin','Description'=>'update_v1-8_7b.sql', 'DteRelease'=>'2021-05-04','DteInstall'=>'2021-12-31'),
	array('id'=>17,'Footprint'=>'Database update via admin','Description'=>'update_v1-8_7c.sql', 'DteRelease'=>'2021-06-24','DteInstall'=>'2021-12-31'),
	array('id'=>18,'Footprint'=>'Database update via admin','Description'=>'update_v1-8_7m.sql', 'DteRelease'=>'2021-07-17','DteInstall'=>'2021-12-31'),
	array('id'=>19,'Footprint'=>'Database update via admin','Description'=>'update_v1-8_7p.sql', 'DteRelease'=>'2021-07-20','DteInstall'=>'2021-12-31'),
	array('id'=>20,'Footprint'=>'Database update via admin','Description'=>'update_v1-8_7r.sql', 'DteRelease'=>'2021-09-01','DteInstall'=>'2021-12-31'),
	array('id'=>21,'Footprint'=>'Database update via admin','Description'=>'update_v1-8_7s.sql', 'DteRelease'=>'2021-10-01','DteInstall'=>'2021-12-31'),
	array('id'=>22,'Footprint'=>'Database update via admin','Description'=>'update_v1-8_7u.sql', 'DteRelease'=>'2021-12-31','DteInstall'=>'2021-12-31')
));

