
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `clientexec681`
--
-- --------------------------------------------------------

--
-- Table structure for table `active_orders`
--

CREATE TABLE `active_orders` (
  `id` varchar(13) NOT NULL DEFAULT '',
  `product_id` int(11) NOT NULL DEFAULT '0',
  `expires` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `prod` (`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `affiliates`
--

CREATE TABLE `affiliates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `pay_type` tinyint(4) NOT NULL,
  `pay_amount` float NOT NULL,
  `balance` float NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_Id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `affiliate_accounts`
--

CREATE TABLE `affiliate_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `affiliate_id` int(11) NOT NULL,
  `userpackage_id` int(11) NOT NULL,
  `lastpaid` datetime NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `affiliate_id` (`affiliate_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `affiliate_commission`
--

CREATE TABLE `affiliate_commission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `affiliate_id` int(11) NOT NULL,
  `affiliate_accounts_id` int(11) NOT NULL,
  `amount` float NOT NULL,
  `order_value` float NOT NULL,
  `date` datetime NOT NULL,
  `clearing_date` date NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `clearing_date` (`clearing_date`),
  KEY `affiliate_id` (`affiliate_id`),
  KEY `status` (`status`),
  KEY `affiliate_accounts_id` (`affiliate_accounts_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `affiliate_history`
--

CREATE TABLE `affiliate_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `affiliate_id` int(11) NOT NULL,
  `date` datetime NOT NULL,
  `description` text CHARACTER SET latin1 NOT NULL,
  `amount` float NOT NULL,
  PRIMARY KEY (`id`),
  KEY `affiliate_id` (`affiliate_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `affiliate_hits`
--

CREATE TABLE `affiliate_hits` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `affiliate_id` int(11) NOT NULL,
  `referrer_id` int(11) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `affiliate_id` (`affiliate_id`),
  KEY `referrer_id` (`referrer_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `affiliate_referrers`
--

CREATE TABLE `affiliate_referrers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `affiliate_id` int(11) NOT NULL,
  `referrer` text CHARACTER SET latin1 NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `affiliate_id` (`affiliate_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `altuseremail`
--

CREATE TABLE `altuseremail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) NOT NULL DEFAULT '0',
  `email` varchar(254) NOT NULL DEFAULT '',
  `sendnotifications` tinyint(4) NOT NULL DEFAULT '1',
  `sendinvoice` tinyint(4) NOT NULL DEFAULT '1',
  `sendsupport` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `announcement`
--

CREATE TABLE `announcement` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(125) NOT NULL DEFAULT '',
  `excerpt` text NOT NULL,
  `post` longtext NOT NULL,
  `postdate` datetime DEFAULT '0000-00-00 00:00:00',
  `publish` tinyint(4) NOT NULL DEFAULT '0',
  `authorid` int(11) NOT NULL DEFAULT '0',
  `recipient` tinyint(4) NOT NULL DEFAULT '0',
  `pinned` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `pinned` (`pinned`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `announcement`
--

INSERT INTO `announcement` VALUES
(1, 0, 'Welcome', 'Welcome to our new billing and support application, Clientexec!  From within, you can easily view and pay your invoices, request assistance with any problems you may encounter, maintain your billing information, resend your welcome E-mail and so much more!', 'Welcome to our new billing and support application, Clientexec!&nbsp; From within, you can easily view and pay your invoices, request assistance with any problems you may encounter, maintain your billing information, resend your welcome E-mail and so much more!', '[[regtime]]', 1, 100, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `announcement_recipient`
--

CREATE TABLE `announcement_recipient` (
  `ann_id` int(11) NOT NULL,
  `recipient_id` int(11) NOT NULL,
  PRIMARY KEY (`ann_id`,`recipient_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `autoresponders`
--

CREATE TABLE `autoresponders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL DEFAULT '0',
  `type` tinyint(4) NOT NULL DEFAULT '1',
  `name` varchar(75) NOT NULL,
  `subject` varchar(100) NOT NULL,
  `contents` text NOT NULL,
  `helpid` int(3) NOT NULL DEFAULT '0',
  `description` text,
  `override_from` varchar(320) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `i_company_id` (`company_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=49 ;

--
-- Dumping data for table `autoresponders`
--

INSERT INTO `autoresponders` VALUES
(1, 0, 1, 'Default', 'Ticket Creation Confirmation', '<p><span></span></p><p><span>Dear [CLIENTNAME],<br></span><span style="background-color: initial;"><br>Thank you for contacting us. A support ticket has been created for your request and you will be notified through this email when a response has been made.<br></span><span style="background-color: initial;"><br>For your reference, your ticket ID is: [TICKETNUMBER].<br></span><span style="background-color: initial;"><br>Thank you and you can expect to hear from us shortly.<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span></p><p></p>', 0, NULL, ''),
(2, 0, 1, 'Bounce back', 'Error Creating Ticket', '<p><span>Hi there,<br></span><span style="background-color: initial;"><br>Regretfully, we were unable to create a ticket for your request as our support system did not recognize your email address as belonging to one of our customers.<br></span><span style="background-color: initial;"><br>Please try submitting your request again using the email address associated with your client area account.<br></span><span style="background-color: initial;"><br>Thank you for your understanding.<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span></p>', 0, NULL, ''),
(3, 0, 3, 'Invoice Template', 'Invoice Created (#[INVOICENUMBER])', '<p><span>Dear [CLIENTNAME],<br></span><span style="background-color: initial;"><br>An invoice (#[INVOICENUMBER]) has been generated on your account for the amount of [AMOUNT] which is due on [DATE].<br></span><span style="background-color: initial;"><br><b>Invoice Details:</b></span><span style="background-color: initial;"><br></span></p><ul><li><span style="background-color: initial;">Invoiced Amount: [AMOUNT]</span></li><li><span style="background-color: initial;">Amount Paid: [PAID]</span></li><li><span style="background-color: initial;">Due Date: [DATE]</span></li><li><span style="background-color: initial;">Amount Due: [BALANCEDUE]<br></span></li></ul><span style="background-color: initial;"><b>Invoiced Services:<br></b></span><span style="background-color: initial;">[INVOICEDESCRIPTION]<br></span><span style="background-color: initial;"><br>To make a payment, log in to the client area from the link below and navigate to: <b>Billing </b>-&gt; <b>My Invoices</b> and select the invoice you would like to pay, following the instructions detailed in the invoice.<br></span><span style="background-color: initial;"><br>If you experience any issues submitting a payment, please don’t hesitate to reach out and we’ll be happy to assist.<br></span><span style="background-color: initial;"><br>Thank you for your continued business.<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span><p></p><p></p>', 50, 'Template for invoices sent through E-mail.', ''),
(4, 0, 3, 'Draft Invoice Template', 'Draft Invoice Created (#[INVOICENUMBER])', '<p><span>Dear [CLIENTNAME],<br></span><span style="background-color: initial;"><br>A draft invoice has been created on your account which you can review within the client area.<br></span><span style="background-color: initial;"><br><b>Please note, this is a draft invoice only and is not a bill.</b><br></span><span style="background-color: initial;"><br><b>Draft Invoice Details:</b><br><ul style=""><li style=""><span style="background-color: initial;">Invoice Number: #[INVOICENUMBER]</span></li><li style=""><span style="background-color: initial;">Invoice Amount: [BALANCEDUE]</span></li></ul></span></p><p></p><p><span style="background-color: initial;"><b>Draft Invoice Details:</b><br></span><span style="background-color: initial;">[INVOICEDESCRIPTION]<br></span><span style="background-color: initial;"><br>If you have any questions, please don’t hesitate to contact us and we’ll be happy to help.<br></span><span style="background-color: initial;"><br>Thank you for your continued business.<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span></p>', 50, 'Template for draft invoices sent through E-mail.', ''),
(5, 0, 3, 'Void Invoice Template', 'Invoice Voided Confirmation', '<p><span>Dear [CLIENTNAME],<br></span><span style="background-color: initial;"><br>This is a notification to let you know an invoice on your account has been voided.<br></span><span style="background-color: initial;"><br><b>Invoice Details:</b><br></span></p><ul style=""><li style=""><span style="background-color: initial;">Invoice ID: [INVOICENUMBER]</span></li><li style=""><span style="background-color: initial;">Invoiced Amount: [AMOUNT]</span></li><li style=""><span style="background-color: initial;">Outstanding Amount: [BALANCEDUE]</span></li></ul><span style="background-color: initial;"><b>Invoiced Services:<br></b></span><span style="background-color: initial;">[INVOICEDESCRIPTION]<br></span><span style="background-color: initial;"><br>If you have any questions, please don’t hesitate to contact us at [BILLINGEMAIL].<br></span><span style="background-color: initial;"><br>Thank you.<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span><p></p>', 50, 'Template for void invoices sent through E-mail.', ''),
(6, 0, 3, 'Credit Invoice Template', 'Billing Department (Credit Invoice)', '<HTML><head></head><body>Invoice #[INVOICENUMBER]<br /><br />ATTN: [CLIENTNAME],<br /><br />You currently have a credit invoice in the amount of [BALANCEDUE] on your account with [COMPANYNAME].  <br /><br />Invoice Description:<br />[INVOICEDESCRIPTION]<br /><br />Total Amount: [AMOUNT]<br /><br />If you have any questions regarding your account,<br />please feel free to contact us.<br /><br />[COMPANYNAME]<br />[BILLINGEMAIL]</body></HTML>', 50, 'Template for credit invoices sent through E-mail.', ''),
(7, 0, 3, 'Refund Invoice Template', 'Refund Processed Confirmation', '<p><span>Dear [CLIENTNAME],<br></span><span style="background-color: initial;"><br>This is a notification to inform you of a processed refund for invoice ID [INVOICENUMBER], for [BALANCEDUE].<br></span><span style="background-color: initial;"><br>Depending on your payment method, it may take up to 5 - 7 days for the payment to be processed into your available balance.<br></span><span style="background-color: initial;"><br>If you have any questions, please don’t hesitate to contact us at [BILLINGEMAIL].<br></span><span style="background-color: initial;"><br>Thank you.<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span></p>', 50, 'Template for refund invoices sent through E-mail.', ''),
(8, 0, 3, 'Credit Card Invoice Template', 'Upcoming Card Charge', '<p>Dear [CLIENTNAME],<br><span style="background-color: initial;"><br>An invoice has been created on your account for [BALANCEDUE] which is due on [DATE]. <b>If you have a card on file, it will be automatically charged on the due date.<br></b></span><span style="background-color: initial;"><br><b>Invoice Details:</b><br></span></p><ul style=""><li style=""><span style="background-color: initial;">Invoice ID: [INVOICENUMBER]</span></li><li style=""><span style="background-color: initial;">Invoice Amount: [AMOUNT]</span></li><li style=""><span style="background-color: initial;">Paid: [PAID]</span></li><li style=""><span style="background-color: initial;">Amount Due: [BALANCEDUE]</span></li></ul><span style="background-color: initial;">If you have any questions, please don’t hesitate to contact us at [BILLINGEMAIL].<br></span><span style="background-color: initial;"><br>Thank you for your continued business.<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span><p></p>', 50, 'Template for credit card invoices sent through E-mail.', ''),
(9, 0, 3, 'Subscription Invoice Template', 'Upcoming Subscription Charge ', '<p><span>Dear [CLIENTNAME],<br></span><span style="background-color: initial;"><br>An invoice has been created on your account for [BALANCEDUE] which is due on [DATE]. As you have an active subscription, there is no need to make a manual payment.<br></span><span style="background-color: initial;"><br><b>Invoice Details:</b><br></span></p><ul style=""><li style=""><span style="background-color: initial;">Invoice ID: [INVOICENUMBER]</span></li><li style=""><span style="background-color: initial;">Invoice Amount: [AMOUNT]</span></li><li style=""><span style="background-color: initial;">Paid: [PAID]</span></li><li style=""><span style="background-color: initial;">Amount Due: [BALANCEDUE]</span></li></ul><span style="background-color: initial;">Thank you for your continued business.<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span><p></p>', 50, 'Template for subscription invoices sent through E-mail.', ''),
(10, 0, 3, 'Payment Receipt Template', 'Payment Confirmation', '<p><span>Dear [CLIENTNAME],<br></span><span style="background-color: initial;"><br>Thank you for your payment for invoice #[INVOICENUMBER].<br></span><span style="background-color: initial;"><br><b>Invoice Details:</b><br></span></p><ul><li><span style="background-color: initial;">Invoice ID: [INVOICENUMBER]</span></li><li><span style="background-color: initial;">Invoiced Amount: [AMOUNT]</span></li><li><span style="background-color: initial;">Paid Amount: [PAID]<br></span></li></ul><span style="background-color: initial;"><b>Invoiced Services:</b><br></span><span style="background-color: initial;">[INVOICEDESCRIPTION]<br></span><span style="background-color: initial;"><br>Thank you for your continued business.<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span><p></p>', 50, 'Template for the E-mail sent to clients after invoice is paid.', ''),
(11, 0, 3, 'Payment Rejected Template', 'Your Payment was Declined ([COMPANYNAME])', '<p><span>Dear [CLIENTNAME],<br></span><span style="background-color: initial;"><br>This is a notification that a recent attempt to charge the registered card we have on file failed.<br></span><span style="background-color: initial;"><br>As your card was declined, you would need to log in to the client area to pay your invoice manually (which you can do so using your existing card, or by adding another card).<br></span><span style="background-color: initial;"><br><b>Invoice Details:</b><br></span></p><ul><li><span style="background-color: initial;">Invoice ID: [INVOICENUMBER]</span></li><li><span style="background-color: initial;">Due Date: [DATE]</span></li><li><span style="background-color: initial;">Invoiced Amount [AMOUNT]</span></li><li><span style="background-color: initial;">Amount Paid: [PAID]</span></li><li><span style="background-color: initial;">Outstanding Amount: [BALANCEDUE]</span></li></ul><span style="background-color: initial;"><b>Invoiced Services:</b><br></span><span style="background-color: initial;">[INVOICEDESCRIPTION]<br></span><span style="background-color: initial;"><br>If you experience any issues submitting a payment, please don’t hesitate to contact us at [BILLINGEMAIL].<br></span><span style="background-color: initial;"><br>Thank you for your continued business.<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span><p></p>', 50, 'Template for the E-mail sent to clients after invoice payment is rejected.', ''),
(12, 0, 3, 'Overdue Invoice Template', 'Overdue Invoice ([COMPANYNAME])', '<p><span>Dear [CLIENTNAME],<br></span><span style="background-color: initial;"><br>Your invoice ([INVOICENUMBER]) which was generated on [SENTDATE] is currently overdue. To avoid service disruption, please log in to the client area and submit a payment bringing your account into good standing.<br></span><span style="background-color: initial;"><br>If you experience any issues while submitting a payment, please don’t hesitate to let us know by contacting our billing team at [BILLINGEMAIL].<br></span><span style="background-color: initial;"><br><b>Invoice Details:</b><br></span></p><ul style=""><li style=""><span style="background-color: initial;">Invoice ID: [INVOICENUMBER]</span></li><li style=""><span style="background-color: initial;">Date Created: [SENTDATE]</span></li><li style=""><span style="background-color: initial;">Due Date: [DATE]</span></li><li style=""><span style="background-color: initial;">Amount Invoiced: [AMOUNT]</span></li><li style=""><span style="background-color: initial;">Paid: [PAID]</span></li><li style=""><span style="background-color: initial;">Outstanding Amount: [BALANCEDUE]</span></li></ul><span style="background-color: initial;"><b>Invoiced Services:<br></b></span><span style="background-color: initial;">[INVOICEDESCRIPTION]<br></span><span style="background-color: initial;"><br>Thank you in advance.<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span><p></p><p></p>', 50, 'E-mail template used when notifying customer of outstanding invoices using the Invoice Reminder service.', ''),
(13, 0, 3, 'Expiring CC Template', 'Your Card is Expiring Soon ([COMPANYNAME])', '<p><span>Dear [CLIENTNAME],<br></span><span style="background-color: initial;"><br>The registered card we have on file (ending with [CCLASTFOUR]) will expire on [CCEXPDATE]. To avoid your payments failing due to an expired card, please update the registered card within the client area ([CLIENTAPPLICATIONURL]).<br></span><span style="background-color: initial;"><br>If you have any questions, please don’t hesitate to contact us at [BILLINGEMAIL].<br></span><span style="background-color: initial;"><br>Thank you for your continued business.<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span></p>', 51, 'Template for the E-mail sent to clients by the expiring credit card notifier service.', ''),
(14, 0, 3, 'Notify Package Suspension', 'Package Suspension Notification', '<p><span>Dear [CLIENTNAME],<br></span><span style="background-color: initial;"><br>This is a notification to let you know your service with us has been suspended due to a lack of payment. To resume your service, please submit payment as soon as possible bringing your account back into good standing.<br></span><span style="background-color: initial;"><br>If you have any questions, please feel free to contact our billing team at [BILLINGEMAIL].<br></span><span style="background-color: initial;"><br>Thank you, and we hope to hear from you soon.<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span></p>', 68, 'Template sent to clients whose package are suspended through the Autosuspend automation service.', ''),
(15, 0, 4, 'Domain Reminder Template', 'Your Domain Expires Soon', '<p><span>Dear [CLIENTNAME],<br></span><span style="background-color: initial;"><br>This is a notification to let you know the domain name [DOMAINNAME] is set to expire soon, on [EXPDATE].&nbsp;<br></span><span style="background-color: initial;"><br>Your domain can be renewed within the client area. Please note, if your domain expires, your website and emails will go down until the domain has been renewed successfully.<br></span><span style="background-color: initial;"><br>If you have any questions, please don’t hesitate to let us know.<br></span><span style="background-color: initial;"><br>Thank you for your continued business.<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span></p>', 52, 'E-mail sent to a customer regarding an expiring domain.', ''),
(16, 0, 5, 'Forgot Password Template', 'Password Reset Verification', '<p><span></span><p>Dear [CLIENTNAME],</p><p>We have received a request to reset the password of your client area account at [COMPANYNAME].</p><p>If you made this request, click on the confirmation link below to confirm your password reset request.</p><p><a href="[CONFIRMATION URL]" target="_blank">Reset My Password</a></p><p>Thank you,</p><p>[COMPANYNAME]</p><span style="background-color: initial;"></span></p>', 53, 'Initial E-mail customer receives to confirm a password change to their account.', ''),
(17, 0, 5, 'Activate Account Template', 'Account Activation at [COMPANYNAME]', '<p><span style="background-color: initial;">Dear [CLIENTNAME],</span><br></p><p><span style="background-color: initial;"><br>Thank you for registering at [COMPANYNAME]. To get started, click on the activation link below.&nbsp;<br></span><span style="background-color: initial;"><br>Confirmation URL:&nbsp;<a href="[CONFIRMATION URL]" target="_blank">[CONFIRMATION URL]</a><br></span><span style="background-color: initial;"><br>Thank you,<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span></p>', 53, 'Initial E-mail customer receives to confirm an account activation.', ''),
(18, 0, 5, 'Get New Password Template', 'Your New [COMPANYNAME] Password', '<p>Dear [CLIENTNAME],<br><span style="background-color: initial;"><br>This email confirms your password has been successfully reset. You can now log in to the client area using the new password.</span><br>If you experience any issues logging into your account, please don’t hesitate to contact us.<br></span><span style="background-color: initial;"><br>Thank you,<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span></p>', 54, 'Initial E-mail the customer receives to know the new password to their account.', ''),
(19, 0, 5, 'Get New Account Password Template', 'Account Activation Confirmation', '<p></p><p>Dear [CLIENTNAME],</p><p>This email confirms your account has been activated successfully and a new password has been generated for your account. You can now log in to the client area using the password below:</p><p>Log in URL: [CLIENTEXEC URL]/index.php?fuse=home&amp;view=login</p><p>Username: [CLIENTEMAIL]</p><p>New Password: [NEWPASSWORD]</p><p>If you experience any issues logging into your account, please don''t hesitate to contact us.</p><p>Thank you,</p><p>[COMPANYNAME]</p><p></p>', 54, 'Initial E-mail the customer receives to know the password to their activated account.', ''),
(20, 0, 5, 'Account Rejected Template', 'Unable To Process Your Order', '<p><span>Dear [CLIENTNAME],<br></span><span style="background-color: initial;"><br>Thank you for your interest in becoming a [COMPANYNAME] customer. Unfortunately, we were unable to accept your order at this time.<br></span><span style="background-color: initial;"><br>If you have any questions, please feel free to contact us at [SUPPORTEMAIL].<br></span><span style="background-color: initial;"><br>Thank you for your understanding.<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span></p>', 55, 'E-mail send to a customer when you reject their account, from the client list screen when viewing pending accounts.', ''),
(21, 0, 6, 'Team Status Reply Template', 'Team Status Reply', '<HTML><head></head><body>[TEAMSTATUS]<br /><br />In reply to [REPLIEDTEAMSTATUSUSERNAME] ([REPLIEDTEAMSTATUSDATE]):<br /><br />> [REPLIEDTEAMSTATUS]</body></HTML>', 56, 'E-mail send to a user when someone replies to one of his Team Status.', ''),
(22, 0, 6, 'Team Status Activity Template', 'Your Team Status activity', '<HTML><head></head><body>Here are the latest updates:<br /><br /><br />[TEAMSTATUSDYNAMICBLOCK]</body></HTML>', 57, 'E-mail send to the Team Status users, to notify them the activity on Team Status.', ''),
(23, 0, 6, 'Team Status Activity Dynamic Block Template', 'na', '[TEAMSTATUSUSERNAME][TEAMSTATUSREPLYINFO]: [TEAMSTATUS]<br />[TEAMSTATUSDATE]<br /><br />', 58, 'Dynamic block used to show the Team Status.', ''),
(24, 0, 6, 'Team Status Activity Reply Template', 'na', ' in reply to [REPLIEDTEAMSTATUSUSERNAME]', 59, 'Text to add when a Team Status is a  reply of another Team Status.', ''),
(25, 0, 7, 'Support Ticket Template', 'New Response to Ticket #[TICKETNUMBER]', '<p><span>Dear [CLIENTNAME],<br></span><span style="background-color: initial;"><br>An update has been made to your ticket, which you can view below:<br></span><span style="background-color: initial;"><br>Ticket Response:<br></span><span style="background-color: initial;">[DESCRIPTION]<br></span><span style="background-color: initial;"><br>If you would like to view this ticket’s full history, click here: [TICKETURL]. You may need to log in to the client area with your email address (username) and password to access the ticket.<br></span><span style="background-color: initial;"><br>If you would like to respond to the ticket, you can do so by replying to this email or through the client area detailed above.<br></span><span style="background-color: initial;"><br>Thank you,<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span></p>', 60, 'Template for E-mails that get sent out to clients after their tickets have been commented on or closed.', ''),
(26, 0, 7, 'Support Ticket Assigned Template', 'New Ticket Assignment (#[TICKETNUMBER])', '<p><span>Hello,<br></span><span style="background-color: initial;"><br>This email is an automated notification to inform you a ticket #[TICKETNUMBER] has just been assigned to you.<br></span><span style="background-color: initial;"><br><b>Ticket Details:</b></span></p><ul>   <span style="background-color: initial;">      <li>Ticket ID: #[TICKETNUMBER]</li>   </span>   <span style="background-color: initial;">      <li>Client Name: [CLIENTNAME]</li>   </span>   <span style="background-color: initial;">      <li>Client Area: [CLIENTAPPLICATIONURL]</li>   </span></ul><span style="background-color: initial;"><b>Ticket Description:<br></b></span><span style="background-color: initial;"><b><br></b>[DESCRIPTION]<br></span><span style="background-color: initial;"><br>Thank you,<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span><p></p>', 60, 'Template for the E-mail sent to support staff after a ticket is assigned.', ''),
(27, 0, 7, 'Feedback Request for Closed Tickets Template', 'How did we do (Ticket #[TICKETNUMBER])?', '<p>  <span>Dear [CLIENTNAME], <br>  </span>  <span style="background-color: initial;">    <br> A ticket was recently marked as closed on your account (Ticket #[TICKETNUMBER] - [TICKETSUBJECT]). As part of our ongoing commitment to constant improvement, we would appreciate it if you could tell us how you felt your support experience was. <br>  </span>  <span style="background-color: initial;">    <br> From the options below, select how you feel your overall recent interaction with us went</span></p><center>  <a href="[RATEEXCELLENTSERVICEURL]" style="font-family: inherit; font-size: inherit; font-weight: bold;">Excellent</a>  <span style="font-family: inherit; font-size: inherit;"></span>  <b style="font-family: inherit; font-size: inherit;"> - </b>  <span style="font-family: inherit; font-size: inherit;"></span>  <a href="[RATEGOODSERVICEURL]" style="font-family: inherit; font-size: inherit; font-weight: bold;">Good</a>  <span style="font-family: inherit; font-size: inherit;"></span>  <b style="font-family: inherit; font-size: inherit;"> - </b>  <span style="font-family: inherit; font-size: inherit;"></span>  <a href="[RATENOTGREATSERVICEURL]" style="font-family: inherit; font-size: inherit; font-weight: bold;">Not Great</a>  <span style="font-family: inherit; font-size: inherit;"></span>  <b style="font-family: inherit; font-size: inherit;"> - </b>  <span style="font-family: inherit; font-size: inherit;"></span>  <a href="[RATEPOORSERVICEURL]" style="font-family: inherit; font-size: inherit; font-weight: bold;">Unsatisfactory</a>  </center>  <br><span style="background-color: initial; font-family: inherit; font-size: inherit;">We appreciate your time and your honest feedback. </span><p></p><p></p><span style="background-color: initial;"> Thank you, <br></span><span style="background-color: initial;">  <br> [COMPANYNAME] </span><p></p>', 61, 'Template for the E-mail sent to ask for customer feedback after a ticket is closed. You need to enable the appropriate setting under the support section of settings to have this E-mail be automatically sent.', ''),
(28, 0, 7, 'AutoClose Ticket Service Template', 'Pending Ticket Closure (Ticket #[TICKETNUMBER])', '<p><span>Dear [CLIENTNAME],<br></span><span style="background-color: initial;"><br>We wanted to check in regarding ticket #[TICKETNUMBER] as we have not received a response from you in a while.<br></span><span style="background-color: initial;"><br>Please note, unless we hear from you the ticket will automatically close after 24 hours. If you feel this ticket has not been resolved, please update the ticket, preventing it from closing.<br></span><span style="background-color: initial;"><br>Thank you for your understanding and for your time.<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span></p>', 62, 'Template for the E-mail sent asking for response before auto-close a Ticket. You need to enable the appropriate setting under the support section of settings to have this E-mail be automatically sent.', ''),
(29, 0, 7, 'Notify Support For New High Priority Tickets Template', 'New High Priority Ticket (#[TICKETNUMBER])', '<p></p><p><span><span>Hello,<br></span></span><span style="background-color: initial;"><br>This is an automated notification to inform you a new high priority ticket has been created.<br><br></span><span style="background-color: initial;"><b>Ticket Details:</b></span><span style="background-color: initial;"><br></span></p><ul style=""><li style=""><span style="background-color: initial;">Ticket ID: #[TICKETNUMBER]</span></li><li style=""><span style="background-color: initial;">Subject: [TICKETSUBJECT]</span></li><li style=""><span style="background-color: initial;">Client Name: [CLIENTNAME]</span></li><li style=""><span style="background-color: initial;">Ticket Type: [TICKETTYPE]</span></li><li style=""><span style="background-color: initial;">Ticket Link: [TICKETURL]</span></li></ul><span style="background-color: initial;"><b>Ticket Message:<br></b></span><span style="background-color: initial;">[DESCRIPTION]<br></span><span style="background-color: initial;"><br>Thank you,<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span><br><p></p>', 63, 'Template for the E-mail sent to notify support for new high priority tickets. You may use tags.', ''),
(30, 0, 7, 'Notify Department Lead For New Ticket Template', 'New [DEPARTMENT] Ticket (#[TICKETNUMBER])', '<p><span>Hello,<br></span><span style="background-color: initial;"><br>This is an automated notification to inform you of a new support ticket that has been created in the [DEPARTMENT] department.<br><br></span><span style="background-color: initial;"><b>Ticket Details:</b></span><span style="background-color: initial;"><br></span></p><ul style=""><li style=""><span style="background-color: initial;">Ticket ID: #[TICKETNUMBER]</span></li><li style=""><span style="background-color: initial;">Subject: [TICKETSUBJECT]</span></li><li style=""><span style="background-color: initial;">Client Name: [CLIENTNAME]</span></li><li style=""><span style="background-color: initial;">Ticket Type: [TICKETTYPE]</span></li><li style=""><span style="background-color: initial;">Ticket Link: [TICKETURL]</span></li></ul><span style="background-color: initial;"><b>Ticket Message:<br></b></span><span style="background-color: initial;">[DESCRIPTION]<br></span><span style="background-color: initial;"><br>Thank you,<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span><p></p>', 63, 'Template for the E-mail sent to notify department lead for new ticket. You may use tags.', ''),
(31, 0, 7, 'Notify Department List For New Ticket Template', 'New [DEPARTMENT] Ticket (#[TICKETNUMBER])', '<p><span>Hello,<br></span><span style="background-color: initial;"><br>A new support ticket has been assigned to the department [DEPARTMENT].<br></span><span style="background-color: initial;"><br><b>Ticket Details:</b></span><span style="background-color: initial;"><br></span></p><ul style=""><li style=""><span style="background-color: initial;">Ticket ID: #[TICKETNUMBER]</span></li><li style=""><span style="background-color: initial;">Subject: [TICKETSUBJECT]</span></li><li style=""><span style="background-color: initial;">Client Name: [CLIENTNAME]</span></li><li style=""><span style="background-color: initial;">Ticket Type: [TICKETTYPE]</span></li><li style=""><span style="background-color: initial;">Ticket Link: [TICKETURL]</span></li></ul><span style="background-color: initial;"><b>Ticket Message:<br></b></span><span style="background-color: initial;">[DESCRIPTION]<br></span><span style="background-color: initial;"><br>Thank you,<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span><p></p>', 63, 'Template for the E-mail sent to notify department list for new ticket. You may use tags.', ''),
(32, 0, 7, 'Notify Customer For New Ticket Template', 'Ticket Created (#[TICKETNUMBER]) - [COMPANYNAME]', '<p><span>Dear [CLIENTNAME],<br></span><span style="background-color: initial;"><br>This is an automated notification to inform you we have created a ticket on your account. You can find the details of the ticket below:<br></span><span style="background-color: initial;"><br><b>Ticket Details:</b></span><span style="background-color: initial;"><br></span></p><ul style=""><li style=""><span style="background-color: initial;">Ticket ID: #[TICKETNUMBER]</span></li><li style=""><span style="background-color: initial;">Subject: [TICKETSUBJECT]</span></li><li style=""><span style="background-color: initial;">Status: [TICKETSTATUS]</span></li></ul><span style="background-color: initial;"><b>Ticket Message:<br></b></span><span style="background-color: initial;">[DESCRIPTION]<br></span><span style="background-color: initial;"><br>You can respond to this ticket by replying to this email or logging into the client area at [CLIENTAPPLICATIONURL].<br></span><span style="background-color: initial;"><br>Thank you,<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span><p></p>', 64, 'Template for the E-mail sent to notify customer for new ticket. You may use tags.', ''),
(33, 0, 7, 'Notify Anonymous For New Ticket Template', 'Ticket Created (#[TICKETNUMBER]) - [COMPANYNAME]', '<p><span>Dear                            [CLIENTNAME],<br></span><span style="background-color: initial;"><br>A new ticket has been created on your account. You can find the details of the ticket below:<br></span><span style="background-color: initial;"><br><b>Ticket Details:&nbsp;<br></b></span><span style="background-color: initial;"></span></p><ul style=""><li style=""><span style="background-color: initial;">Ticket ID: #[TICKETNUMBER]</span></li><li style=""><span style="background-color: initial;">Subject: [TICKETSUBJECT]</span></li><li style=""><span style="background-color: initial;">Status: [TICKETSTATUS]</span></li></ul><span style="background-color: initial;"><b>Ticket Message:<br></b></span><span style="background-color: initial;">[DESCRIPTION]<br></span><span style="background-color: initial;"><br>You can respond to this ticket by replying to this email or logging into the client area at [CLIENTAPPLICATIONURL].<br></span><span style="background-color: initial;"><br>Thank you,<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span><p></p>', 64, 'Template for the E-mail sent to notify anonymous for new ticket. You may use tags.', ''),
(34, 0, 7, 'Notify Assignee For Ticket Reply Template', 'Client Updated Ticket #[TICKETNUMBER]', '<p><span>Hello,<br></span><span style="background-color: initial;"><br>An update has been made to Ticket #[TICKETNUMBER] by [CLIENTNAME].<br></span><span style="background-color: initial;"><br><b>Ticket Details:</b><br><ul style=""><li style=""><span style="background-color: initial;">Ticket ID: #[TICKETNUMBER]</span></li><li style=""><span style="background-color: initial;">Ticket Status: [TICKETSTATUS]</span></li><li style=""><span style="background-color: initial;">Ticket Link: [TICKETURL]</span></li></ul></span></p><span style="background-color: initial;"><b>Ticket Message:<br></b></span><span style="background-color: initial;">[DESCRIPTION]<br></span><span style="background-color: initial;"><br>Thank you,<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span><p></p>', 65, 'Template for the E-mail sent to notify assignee for ticket reply. You may use tags.', ''),
(35, 0, 7, 'Notify For New FeedBack Template', 'Feedback Received for Ticket #[TICKETNUMBER]', '<p>Hello,<br><span style="background-color: initial;"><br>This is an automated notification to let you know [CLIENTNAME] has rated their support experience for ticket #[TICKETNUMBER].<br></span><span style="background-color: initial;"><br>The client rated the overall support experience for this ticket as <b>[DESCRIPTION]</b></span></p><p><b>Ticket Details:</b><span style="background-color: initial;"><br></span></p><ul style=""><li style=""><span style="background-color: initial;">Ticket ID: #[TICKETNUMBER]</span></li><li style=""><span style="background-color: initial;">Subject: [TICKETSUBJECT]</span></li><li style=""><span style="background-color: initial;">Status: [TICKETSTATUS]</span></li><li style=""><span style="background-color: initial;">Ticket Link: [TICKETURL]</span></li></ul><span style="background-color: initial;">Thank you,<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span><p></p>', 66, 'Template for the E-mail sent to notify for new feedback. You may use tags.', ''),
(36, 0, 8, 'Shared Web Hosting', 'Your Web Hosting Account Details', '<p></p><p>Dear [CLIENTNAME],</p><p>Thank you for choosing [COMPANYNAME] to be your web hosting provider. This email contains the details and credentials you need to make use of your hosting account.</p><p>Note: If you have purchased a domain name during the signup process, it may not be visible for up to 48 hours while the DNS propagation completes.</p><p><b>New Account Information:</b></p><p>Domain Name: [DOMAINNAME]<br><span style="background-color: initial;">Control Panel Login: https://[SERVERHOSTNAME]:2083<br></span><span style="background-color: initial;">Control Panel Username: [DOMAINUSERNAME]<br></span><span style="background-color: initial;">Control Panel Password: [DOMAINPASSWORD]</span></p><p><b>DNS / Nameserver Information:</b></p><p>For your website to resolve to our servers, you will need to update your domain name''s DNS / nameservers to those listed below:</p><p>[NAMESERVERS]</p><p><b>FTP Access:</b></p><p>FTP Hostname: [SERVERHOSTNAME]<br><span style="background-color: initial;">FTP Username: [DOMAINUSERNAME]<br></span><span style="background-color: initial;">FTP Password: [DOMAINPASSWORD]&nbsp;</span></p><p>If you have any questions, please don''t hesitate to let us know by emailing [SUPPORTEMAIL].</p><p>Thank you,</p><p>[COMPANYNAME]</p><p></p>', 1, 'Shared Web Hosting Welcome Email', ''),
(37, 0, 8, 'Account Creation', 'Your [COMPANYNAME] Account Details', '<p><font face="''Lucida Grande'', ''Lucida Sans Unicode'', Verdana, Arial, sans-serif"><span style="font-size: 12px;"></span></font></p><p></p><p>Dear [CLIENTNAME],<br><br>Thank you for registering with [COMPANYNAME]. This email confirms your newly created account within our client area, where you can manage your products, billing, and request support when needed.<br><span><br>If you have ordered another product/service while registering, a separate email will contain relevant product details and credentials.<br><span><br><b>Log in Credentials:</b></span></span></p><p></p><ul><li>Client Area Link: [CLIENTAPPLICATIONURL]</li><li><span>Username: [CLIENTEMAIL]</span></li><span><li>Password: The password you used when creating your account.</li></span></ul><p></p><br><p>Thank you,<br><br>[COMPANYNAME]</p><p></p>', 1, 'This email is sent to customers when they create an account in the system, generally during signup.', ''),
(38, 0, 8, 'Domain Registration', 'Domain Registration Successful', '<p><span>Dear [CLIENTNAME],<br></span><span style="background-color: initial;"><br>Thank you for your recent domain purchase with [COMPANYNAME]. This email confirms the registration has been successful, and you can now manage the domain name within the client area.<br></span><span style="background-color: initial;"><br>Note: It can take up to 48 hours after registration or updating the domain’s nameservers to resolve fully. This is due to a process called DNS propagation.<br></span><span style="background-color: initial;"><br>Please don''t hesitate to contact us at [SUPPORTEMAIL] if you have any questions or issues.<br></span><span style="background-color: initial;"><br>Thank you,<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span></p><br>', 1, '', ''),
(39, 0, 5, 'New Order Notification', 'New Order Notification', '<p><span>Hi there!<br></span><span style="background-color: initial;"><br>Great news! A new order has been registered at [COMPANYNAME].&nbsp;<br></span><span style="background-color: initial;"><br>Details of the order can be found below:<br></span><span style="background-color: initial;"><br>[ORDERINFO]<br></span><span style="background-color: initial;"><br>Thank you,<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span></p>', 67, 'E-Mail received by those staff members identified of being notified of new orders.', ''),
(40, 0, 4, 'Domain Expiration Reminder Template', 'Your Domain Has Expired', '<p><span>Dear [CLIENTNAME],<br></span><span style="background-color: initial;"><br>This is a reminder notification to let you know your domain name ([DOMAINNAME]) has expired on [EXPDATE].<br></span><span style="background-color: initial;"><br>As your domain has expired, any website and email services running on this domain will no longer work, until the domain has been renewed successfully.<br></span><span style="background-color: initial;"><br>You still have the opportunity to renew your domain name before it is deleted by logging into the client area at [CLIENTAPPLICATIONURL].<br></span><span style="background-color: initial;"><br>If you have any questions, please don’t hesitate to contact our billing team at [BILLINGEMAIL].<br></span><span style="background-color: initial;"><br>Thank you and we hope to hear from you soon.<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span></p>', 0, '', ''),
(41, 0, 4, 'Package Cancellation Requested Template', 'Cancellation Request Confirmation', '<p><span>Dear [CLIENTNAME],<br></span><span style="background-color: initial;"><br>This is a notification to confirm we have successfully received your cancellation request for the package: [PACKAGEREFERENCE].<br></span><span style="background-color: initial;"><br>A follow-up notification will be sent to your email address once your cancellation request has been processed.<br></span><span style="background-color: initial;"><br>Thank you,<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span></p>', 69, 'E-mail sent to a customer regarding a cancellation request for a package.', ''),
(42, 0, 4, 'Package Remove Cancellation Requested Template', 'Cancellation Request Removed', '<p><span>Dear [CLIENTNAME],<br></span><span style="background-color: initial;"><br>This email confirms we have received your request to remove your cancellation request for package: [PACKAGEREFERENCE].<br></span><span style="background-color: initial;"><br>Your original cancellation request will no longer be processed, and your package will remain active.<br></span><span style="background-color: initial;"><br>If you have any questions, please don’t hesitate to contact us at [BILLINGEMAIL].<br></span><span style="background-color: initial;"><br>Thank you for your continued business.<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span></p>', 69, 'E-mail sent to a customer regarding a remove cancellation request for a package.', ''),
(43, 0, 4, 'Package Cancelled Template', 'Package Cancellation Processed', '<p><span>Dear [CLIENTNAME],<br></span><span style="background-color: initial;"><br>This email confirms your cancellation request for package [PACKAGEREFERENCE] has been processed successfully.<br></span><span style="background-color: initial;"><br>No further invoices or charges will be made for this package.<br></span><span style="background-color: initial;"><br>If you have any questions, please don’t hesitate to contact our billing team at [BILLINGEMAIL].<br></span><span style="background-color: initial;"><br>Thank you,<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span></p>', 69, 'E-mail sent to a customer regarding a cancelled package.', ''),
(44, 0, 8, 'VPS Welcome Email', 'Your VPS Server Details', '<p></p><p><span>Dear [CLIENTNAME],<br></span><span style="background-color: initial;"><br>Thank you for choosing [COMPANYNAME] as your VPS hosting provider. This email contains the details and credentials you need to make use of your server.<br></span><span style="background-color: initial;"><br>Note: If you have ordered a control panel as part of your VPS server, it may take additional time to fully provision and install.<br></span><span style="background-color: initial;"><br><b>Your Server Details:</b><br><ul style=""><li style=""><span style="background-color: initial;">Hostname: [CUSTOMPACKAGE_VM Hostname]</span></li><li style=""><span style="background-color: initial;">Primary IP: [DOMAINIP]</span></li><li style=""><span style="background-color: initial;">Root Password: [CUSTOMPACKAGE_VM Password]</span></li><li style=""><span style="background-color: initial;">Operating System: [CUSTOMPACKAGE_VM Operating System]</span></li></ul></span></p><p><b>SSH Access Details:</b><br><ul style=""><li style=""><span style="background-color: initial;">Hostname: [CUSTOMPACKAGE_VM Hostname]</span></li><li style=""><span style="background-color: initial;">Primary IP: [DOMAINIP]</span></li><li style=""><span style="background-color: initial;">Username: [CUSTOMPACKAGE_VM Username]</span></li><li style=""><span style="background-color: initial;">Password: [CUSTOMPACKAGE_VM Password]</span></li></ul><span style="background-color: initial;"><br>If you have any questions or experience any issues, please don''t hesitate to contact us at [SUPPORTEMAIL].<br></span><span style="background-color: initial;"><br>Thank you,<br></span><span style="background-color: initial;"><br>[COMPANYNAME]</span></p><p><span style="background-color: initial;"></span></p><p></p><p></p>', 1, 'Sample VPS Welcome Email', ''),
(45, 0, 10, 'New Pending Commission', 'New Pending Commission', '<p>Hi [CLIENTNAME],</p><p>Congratulations! A new pending commission for [AMOUNT] has been generated on your [COMPANYNAME] affiliate account<br></p><p>Commissions are held in a pending state for [PAYOUTDAYS] at which point they will be reviewed and become eligible to be paid out.</p><p>You can view all of your commissions by logging into the client portal and navigating to the Affiliate page in the top-right drop-down menu.</p><p>Kind Regards,</p><p>[COMPANYNAME]</p>', 0, '', ''),
(46, 0, 10, 'New Approved Commission', 'New Approved Commission', '<p>Hi [CLIENTNAME],</p><p>Congratulations! A commission for [AMOUNT] has been approved on your [COMPANYNAME] affiliate account.</p><p>If you meet the minimum balance of [MINPAYOUTAMOUNT] you can request a payout within the client portal.</p><p>You can view all of your commissions by logging into the client portal and navigating to the Affiliate page in the top-right drop-down menu.</p><p>Kind Regards,</p><p>[COMPANYNAME]</p>', 0, '', ''),
(47, 0, 10, 'Affiliate Account Approved', 'Affiliate Account Approved', '<p>Hi [CLIENTNAME],</p><p>Thank you for signing up for [COMPANYNAME]’s affiliate program! We are pleased to announce your affiliate application has been approved.</p><p>Your unique affiliate link is: [AFFLINK].</p><p>A commission of [DEFAULTCOMMISSIONAMOUNT] will be generated whenever someone clicks on your affiliate link and signs up for one of our eligible packages.</p><p>To view your affiliate account metrics &amp; commissions, log into our client portal and click on the Affiliate link located in the top right drop down menu.</p><p>Thank you again for your interest in promoting [COMPANYNAME], and if you have any questions, please don’t hesitate to reach out.</p>', 0, '', ''),
(48, 0, 10, 'New Affiliate Signup', 'New Affiliate Signup', '<p>Hi there,&nbsp;</p><p><span style="background-color: initial;">This is a notification to inform you a new affiliate has signed up and requires your approval.&nbsp;</span></p><p><span style="background-color: initial;">To approve/decline the affiliate application, click <a href="[PENDINGAFFILIATESLINK]">here</a>.&nbsp;</span></p><p><span style="background-color: initial;">Affiliate Details:&nbsp;<br></span></p><ul><li><span style="background-color: initial;">Affiliate Name:&nbsp;[CLIENTNAME]</span></li><li><span style="background-color: initial;">Affiliate Email Address: [CLIENTEMAIL]</span></li><li><span style="background-color: initial;">Client ID: [CLIENTNUMBER]</span></li></ul><p></p>', 0, '', '');

-- --------------------------------------------------------

--
-- Table structure for table `billingtype`
--

CREATE TABLE `billingtype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(25) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `detail` text NOT NULL,
  `price` varchar(10) NOT NULL DEFAULT '0.00',
  `archived` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `billingtype`
--

INSERT INTO `billingtype` VALUES
(-3, 'Discount', 'Discount', 'Discount generated by a discount coupon entered at signup', '0.00', 0),
(-4, 'Package add-on', 'Package add-on', 'Package add-on fee', '0.00', 0),
(-5, 'Late Fee', 'Late Fee', 'Late Fee', '0.00', 0),
(-6, 'Package upgrade', 'Package upgrade', 'Package upgrade fee', '0.00', 0),
(-7, 'Discount upgrade', 'Discount upgrade', 'Discount generated by a package upgrade', '0.00', 0),
(-8, 'Package add-on upgrade', 'Package add-on upgrade', 'Package add-on upgrade fee', '0.00', 0),
(1, 'Miscellaneous', 'Miscellaneous', 'Miscellaneous', '0.00', 0);

-- --------------------------------------------------------

--
-- Table structure for table `billing_cycle`
--

CREATE TABLE `billing_cycle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `time_unit` char(1) NOT NULL DEFAULT 'm',
  `amount_of_units` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `billing_cycle` (`time_unit`,`amount_of_units`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=121 ;

--
-- Dumping data for table `billing_cycle`
--

INSERT INTO `billing_cycle` VALUES
(0, 'One Time', 'm', 0),
(1, '1 Month', 'm', 1),
(3, '3 Months', 'm', 3),
(6, '6 Months', 'm', 6),
(12, '1 Year', 'y', 1),
(24, '2 Years', 'y', 2),
(36, '3 Years', 'y', 3),
(48, '4 Years', 'y', 4),
(60, '5 Years', 'y', 5),
(72, '6 Years', 'y', 6),
(84, '7 Years', 'y', 7),
(96, '8 Years', 'y', 8),
(108, '9 Years', 'y', 9),
(120, '10 Years', 'y', 10);

-- --------------------------------------------------------

--
-- Table structure for table `cache`
--

CREATE TABLE `cache` (
  `cachekey` varchar(50) NOT NULL DEFAULT '',
  `lastupdated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `content` mediumblob NOT NULL,
  PRIMARY KEY (`cachekey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `calendar`
--

CREATE TABLE `calendar` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(256) NOT NULL,
  `allday` tinyint(1) NOT NULL DEFAULT '0',
  `start` datetime DEFAULT NULL,
  `end` datetime DEFAULT NULL,
  `url` text,
  `className` varchar(56) DEFAULT NULL,
  `appliesto` int(11) DEFAULT '0',
  `description` text,
  `userid` int(11) NOT NULL DEFAULT '0',
  `isprivate` tinyint(1) NOT NULL DEFAULT '0',
  `isrepeating` tinyint(1) NOT NULL DEFAULT '0',
  `company_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `canned_response`
--

CREATE TABLE `canned_response` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(45) NOT NULL,
  `response` mediumtext NOT NULL,
  `userid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `i_company_id` (`company_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `chatlog`
--

CREATE TABLE `chatlog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `roomid` varchar(20) NOT NULL,
  `chatterid` varchar(20) NOT NULL,
  `msg` text NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IRoomTime` (`roomid`,`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `chatroom`
--

CREATE TABLE `chatroom` (
  `id` varchar(20) NOT NULL,
  `chatterid` varchar(20) NOT NULL,
  `title` varchar(45) NOT NULL,
  `time` int(11) NOT NULL,
  `ip` varchar(20) NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  `description` varchar(200) NOT NULL DEFAULT '',
  `ispublic` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `room_chatter` (`id`,`chatterid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `chattyping`
--

CREATE TABLE `chattyping` (
  `roomid` varchar(20) NOT NULL,
  `chatterid` varchar(20) NOT NULL,
  `time` int(11) NOT NULL,
  `subtype` int(11) NOT NULL,
  UNIQUE KEY `typing_index` (`roomid`,`chatterid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `chatuser`
--

CREATE TABLE `chatuser` (
  `chatterid` varchar(20) NOT NULL,
  `fullname` varchar(45) NOT NULL,
  `email` varchar(254) NOT NULL,
  `usertype` tinyint(4) NOT NULL,
  PRIMARY KEY (`chatterid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `chatuser`
--

INSERT INTO `chatuser` VALUES
('0', 'System Notification', 'noemail@noemail.com', -1);

-- --------------------------------------------------------

--
-- Table structure for table `chatvisitor`
--

CREATE TABLE `chatvisitor` (
  `ip` varchar(40) NOT NULL,
  `lastvisit` int(11) NOT NULL,
  `chatterid` varchar(20) NOT NULL,
  `country` text NOT NULL,
  `lang` varchar(10) NOT NULL,
  `browser_name` varchar(10) NOT NULL,
  `browser_ver` varchar(10) NOT NULL,
  `device` varchar(7) NOT NULL,
  `os` varchar(17) NOT NULL,
  `search_engine` varchar(10) NOT NULL,
  `search_terms` varchar(56) NOT NULL,
  `ref_url` varchar(1024) NOT NULL,
  `ref_host` varchar(150) NOT NULL,
  `ref_path` varchar(25) NOT NULL,
  `url` varchar(1024) NOT NULL,
  `path` varchar(256) NOT NULL,
  `title` varchar(255) NOT NULL,
  `session` text NOT NULL,
  PRIMARY KEY (`ip`),
  KEY `lastvisit` (`lastvisit`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `clients_notes`
--

CREATE TABLE `clients_notes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL,
  `target_id` int(11) NOT NULL,
  `is_target_group` tinyint(4) NOT NULL DEFAULT '0',
  `admin_id` int(11) NOT NULL,
  `note` text NOT NULL,
  `visible_client` tinyint(4) NOT NULL,
  `archived` tinyint(4) NOT NULL DEFAULT '0',
  `subject` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `clients_notes_tickettypes`
--

CREATE TABLE `clients_notes_tickettypes` (
  `note_id` int(11) NOT NULL,
  `tickettype_id` int(11) NOT NULL,
  PRIMARY KEY (`note_id`,`tickettype_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `companies`
--

CREATE TABLE `companies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hashed_id` varchar(32) NOT NULL,
  `subdomain` varchar(20) NOT NULL,
  `status` tinyint(4) NOT NULL,
  `type` varchar(50) DEFAULT NULL,
  `limit_staff` tinyint(4) NOT NULL DEFAULT '-1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `country`
--

CREATE TABLE `country` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL DEFAULT '',
  `iso` char(2) NOT NULL DEFAULT '',
  `division` varchar(50) NOT NULL DEFAULT 'Division',
  `division_plural` varchar(50) NOT NULL DEFAULT 'Divisions',
  `phone_code` varchar(10) NOT NULL DEFAULT '',
  `exists` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `by_name` (`name`,`iso`),
  KEY `by_iso` (`iso`,`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=252 ;

--
-- Dumping data for table `country`
--

INSERT INTO `country` VALUES
(1, 'Afghanistan', 'AF', 'Division', 'Divisions', '93', 1),
(2, 'Albania', 'AL', 'Division', 'Divisions', '355', 1),
(3, 'Algeria', 'DZ', 'Province', 'Provinces', '213', 1),
(4, 'American Samoa', 'AS', 'Division', 'Divisions', '684', 1),
(5, 'Andorra', 'AD', 'Parish', 'Parishes', '376', 1),
(6, 'Angola', 'AO', 'Province', 'Provinces', '244', 1),
(7, 'Antigua and Barbuda', 'AG', 'Parish', 'Parishes', '1', 1),
(8, 'Argentina', 'AR', 'Province', 'Provinces', '54', 1),
(9, 'Armenia', 'AM', 'Division', 'Divisions', '374', 1),
(10, 'Aruba', 'AW', 'Division', 'Divisions', '297', 1),
(11, 'Australia', 'AU', 'State / Territory', 'States / Territories', '61', 1),
(12, 'Austria', 'AT', 'State', 'States', '43', 1),
(13, 'Azerbaijan', 'AZ', 'Division', 'Divisions', '994', 1),
(14, 'Bahamas', 'BS', 'Division', 'Divisions', '1', 1),
(15, 'Bahrain', 'BH', 'Division', 'Divisions', '973', 1),
(16, 'Bangladesh', 'BD', 'Division', 'Divisions', '880', 1),
(17, 'Barbados', 'BB', 'Parish', 'Parishes', '1', 1),
(18, 'Belarus', 'BY', 'Division', 'Divisions', '375', 1),
(19, 'Belgium', 'BE', 'Division', 'Divisions', '32', 1),
(20, 'Belize', 'BZ', 'District', 'Districts', '501', 1),
(21, 'Benin', 'BJ', 'Department', 'Departments', '229', 1),
(22, 'Bermuda', 'BM', 'Division', 'Divisions', '1', 1),
(23, 'Bhutan', 'BT', 'Division', 'Divisions', '975', 1),
(24, 'Bolivia', 'BO', 'Department', 'Departments', '591', 1),
(25, 'Bosnia and Herzegovina', 'BA', 'Division', 'Divisions', '387', 1),
(26, 'Botswana', 'BW', 'Division', 'Divisions', '267', 1),
(27, 'Brazil', 'BR', 'Division', 'Divisions', '55', 1),
(28, 'Brunei Darussalam', 'BN', 'Division', 'Divisions', '673', 1),
(29, 'Bulgaria', 'BG', 'Division', 'Divisions', '359', 1),
(30, 'Burkina Faso', 'BF', 'Province', 'Provinces', '226', 1),
(31, 'Burundi', 'BI', 'Division', 'Divisions', '257', 1),
(32, 'Cambodia', 'KH', 'Division', 'Divisions', '855', 1),
(33, 'Cameroon', 'CM', 'Division', 'Divisions', '237', 1),
(34, 'Canada', 'CA', 'Territory / Province', 'Territories / Provinces', '1', 1),
(35, 'Cape Verde', 'CV', 'Division', 'Divisions', '238', 1),
(36, 'Cayman Islands', 'KY', 'Division', 'Divisions', '1', 1),
(37, 'Central African Republic', 'CF', 'Prefecture', 'Prefectures', '236', 1),
(38, 'Chad', 'TD', 'Prefecture', 'Prefectures', '235', 1),
(39, 'Chile', 'CL', 'Region', 'Regions', '56', 1),
(40, 'China', 'CN', 'Province', 'Provinces', '86', 1),
(41, 'Cocos (Keeling) Islands', 'CC', 'Division', 'Divisions', '61', 1),
(42, 'Colombia', 'CO', 'Department', 'Departments', '57', 1),
(43, 'Comoros', 'KM', 'Division', 'Divisions', '269', 1),
(44, 'Congo', 'CG', 'Division', 'Divisions', '242', 1),
(45, 'Congo (Dem. Rep.)', 'CD', 'Division', 'Divisions', '243', 1),
(46, 'Cook Islands', 'CK', 'Division', 'Divisions', '682', 1),
(47, 'Costa Rica', 'CR', 'Province', 'Provinces', '506', 1),
(48, 'Cote D''ivoire', 'CI', 'Department', 'Departments', '225', 1),
(49, 'Croatia', 'HR', 'County', 'Counties', '385', 1),
(50, 'Cuba', 'CU', 'Division', 'Divisions', '53', 1),
(51, 'Cyprus', 'CY', 'Division', 'Divisions', '357', 1),
(52, 'Czech Republic', 'CZ', 'Division', 'Divisions', '420', 1),
(53, 'Denmark', 'DK', 'Region', 'Regions', '45', 1),
(54, 'Djibouti', 'DJ', 'Division', 'Divisions', '253', 1),
(55, 'Dominica', 'DM', 'Parish', 'Parishes', '1', 1),
(56, 'Dominican Republic', 'DO', 'Province', 'Provinces', '1', 1),
(57, 'Ecuador', 'EC', 'Province', 'Provinces', '593', 1),
(58, 'Egypt', 'EG', 'Governorate', 'Governorates', '20', 1),
(59, 'El Salvador', 'SV', 'Department', 'Departments', '503', 1),
(60, 'Equatorial Guinea', 'GQ', 'Division', 'Divisions', '240', 1),
(61, 'Eritrea', 'ER', 'Division', 'Divisions', '291', 1),
(62, 'Estonia', 'EE', 'County', 'Counties', '372', 1),
(63, 'Ethiopia', 'ET', 'Region', 'Regions', '251', 1),
(64, 'Faroe Islands', 'FO', 'Division', 'Divisions', '298', 1),
(65, 'Fiji', 'FJ', 'Division', 'Divisions', '679', 1),
(66, 'Finland', 'FI', 'Division', 'Divisions', '358', 1),
(67, 'France', 'FR', 'Region', 'Regions', '33', 1),
(68, 'French Polynesia', 'PF', 'Division', 'Divisions', '689', 1),
(69, 'Gabon', 'GA', 'Province', 'Provinces', '241', 1),
(70, 'Gambia', 'GM', 'Division', 'Divisions', '220', 1),
(71, 'Georgia', 'GE', 'Division', 'Divisions', '995', 1),
(72, 'Germany', 'DE', 'State', 'States', '49', 1),
(73, 'Ghana', 'GH', 'Division', 'Divisions', '233', 1),
(74, 'Greece', 'GR', 'Division', 'Divisions', '30', 1),
(75, 'Greenland', 'GL', 'Division', 'Divisions', '299', 1),
(76, 'Grenada', 'GD', 'Parish', 'Parishes', '1', 1),
(77, 'Guam', 'GU', 'Division', 'Divisions', '1', 1),
(78, 'Guatemala', 'GT', 'Department', 'Departments', '502', 1),
(79, 'Guinea', 'GN', 'Division', 'Divisions', '224', 1),
(80, 'Guinea-bissau', 'GW', 'Division', 'Divisions', '245', 1),
(81, 'Guyana', 'GY', 'Division', 'Divisions', '592', 1),
(82, 'Haiti', 'HT', 'Department', 'Departments', '509', 1),
(83, 'Honduras', 'HN', 'Department', 'Departments', '504', 1),
(84, 'Hong Kong, China', 'HK', 'Division', 'Divisions', '852', 1),
(85, 'Hungary', 'HU', 'County', 'Counties', '36', 1),
(86, 'Iceland', 'IS', 'Division', 'Divisions', '354', 1),
(87, 'India', 'IN', 'State / Territory', 'States / Territories', '91', 1),
(88, 'Indonesia', 'ID', 'Province', 'Provinces', '62', 1),
(89, 'Iran (Islamic Rep.)', 'IR', 'Province', 'Provinces', '98', 1),
(90, 'Iraq', 'IQ', 'Governorate', 'Governorates', '964', 1),
(91, 'Ireland', 'IE', 'Division', 'Divisions', '353', 1),
(92, 'Israel', 'IL', 'Division', 'Divisions', '972', 1),
(93, 'Italy', 'IT', 'Region', 'Regions', '39', 1),
(94, 'Jamaica', 'JM', 'Division', 'Divisions', '1', 1),
(95, 'Japan', 'JP', 'Prefecture', 'Prefectures', '81', 1),
(96, 'Jordan', 'JO', 'Division', 'Divisions', '962', 1),
(97, 'Kazakhstan', 'KZ', 'Division', 'Divisions', '7', 1),
(98, 'Kenya', 'KE', 'Province', 'Provinces', '254', 1),
(99, 'Kiribati', 'KI', 'Division', 'Divisions', '686', 1),
(100, 'Korea', 'KR', 'Division', 'Divisions', '82', 1),
(101, 'Korea (North)', 'KP', 'Division', 'Divisions', '850', 1),
(102, 'Kuwait', 'KW', 'Governorate', 'Governorates', '965', 1),
(103, 'Kyrgyzstan', 'KG', 'Province', 'Provinces', '996', 1),
(104, 'Laos', 'LA', 'Division', 'Divisions', '856', 1),
(105, 'Latvia', 'LV', 'Municipality', 'Municipalities', '371', 1),
(106, 'Lebanon', 'LB', 'Governorate', 'Governorates', '961', 1),
(107, 'Lesotho', 'LS', 'Division', 'Divisions', '266', 1),
(108, 'Liberia', 'LR', 'Division', 'Divisions', '231', 1),
(109, 'Libya', 'LY', 'Municipality', 'Municipalities', '218', 1),
(110, 'Liechtenstein', 'LI', 'Division', 'Divisions', '423', 1),
(111, 'Lithuania', 'LT', 'Division', 'Divisions', '370', 1),
(112, 'Luxembourg', 'LU', 'District', 'Districts', '352', 1),
(113, 'Macau, China', 'MO', 'Division', 'Divisions', '853', 1),
(114, 'North Macedonia', 'MK', 'Division', 'Divisions', '389', 1),
(115, 'Madagascar', 'MG', 'Division', 'Divisions', '261', 1),
(116, 'Malawi', 'MW', 'Division', 'Divisions', '265', 1),
(117, 'Malaysia', 'MY', 'State', 'States', '60', 1),
(118, 'Maldives', 'MV', 'Division', 'Divisions', '960', 1),
(119, 'Mali', 'ML', 'Division', 'Divisions', '223', 1),
(120, 'Malta', 'MT', 'Division', 'Divisions', '356', 1),
(121, 'Marshall Islands', 'MH', 'Division', 'Divisions', '692', 1),
(122, 'Mauritania', 'MR', 'Division', 'Divisions', '222', 1),
(123, 'Mauritius', 'MU', 'Division', 'Divisions', '230', 1),
(124, 'Mayotte', 'YT', 'Division', 'Divisions', '269', 1),
(125, 'Mexico', 'MX', 'State', 'States', '52', 1),
(126, 'Micronesia (Fed. States)', 'FM', 'Division', 'Divisions', '691', 1),
(127, 'Moldova (Republic of)', 'MD', 'Division', 'Divisions', '373', 1),
(128, 'Monaco', 'MC', 'Division', 'Divisions', '377', 1),
(129, 'Mongolia', 'MN', 'Province / Municipality', 'Provinces / Municipalities', '976', 1),
(130, 'Montenegro', 'ME', 'Division', 'Divisions', '382', 1),
(131, 'Morocco', 'MA', 'Division', 'Divisions', '212', 1),
(132, 'Mozambique', 'MZ', 'Division', 'Divisions', '258', 1),
(133, 'Myanmar', 'MM', 'State', 'States', '95', 1),
(134, 'Namibia', 'NA', 'Division', 'Divisions', '264', 1),
(135, 'Nauru', 'NR', 'Division', 'Divisions', '674', 1),
(136, 'Nepal', 'NP', 'Division', 'Divisions', '977', 1),
(137, 'Netherlands', 'NL', 'Province', 'Provinces', '31', 1),
(138, 'Netherlands Antilles', 'AN', 'Division', 'Divisions', '599', 0),
(139, 'New Caledonia', 'NC', 'Division', 'Divisions', '687', 1),
(140, 'New Zealand', 'NZ', 'Division', 'Divisions', '64', 1),
(141, 'Nicaragua', 'NI', 'Division', 'Divisions', '505', 1),
(142, 'Niger', 'NE', 'Division', 'Divisions', '227', 1),
(143, 'Nigeria', 'NG', 'State', 'States', '234', 1),
(144, 'Niue', 'NU', 'Division', 'Divisions', '683', 1),
(145, 'Northern Mariana Islands', 'MP', 'Division', 'Divisions', '1', 1),
(146, 'Norway', 'NO', 'County', 'Counties', '47', 1),
(147, 'Oman', 'OM', 'Region / Governorate', 'Regions / Governorates', '968', 1),
(148, 'Pakistan', 'PK', 'Division', 'Divisions', '92', 1),
(149, 'Palau', 'PW', 'State', 'States', '680', 1),
(150, 'Panama', 'PA', 'Province', 'Provinces', '507', 1),
(151, 'Papua New Guinea', 'PG', 'Division', 'Divisions', '675', 1),
(152, 'Paraguay', 'PY', 'Department', 'Departments', '595', 1),
(153, 'Peru', 'PE', 'Region', 'Regions', '51', 1),
(154, 'Philippines', 'PH', 'Division', 'Divisions', '63', 1),
(155, 'Poland', 'PL', 'Division', 'Divisions', '48', 1),
(156, 'Portugal', 'PT', 'Division', 'Divisions', '351', 1),
(157, 'Puerto Rico', 'PR', 'Division', 'Divisions', '1', 1),
(158, 'Qatar', 'QA', 'Division', 'Divisions', '974', 1),
(159, 'Romania', 'RO', 'County', 'Counties', '40', 1),
(160, 'Russian Federation', 'RU', 'Division', 'Divisions', '7', 1),
(161, 'Rwanda', 'RW', 'Division', 'Divisions', '250', 1),
(162, 'Saint Kitts and Nevis', 'KN', 'Parish', 'Parishes', '1', 1),
(163, 'Saint Lucia', 'LC', 'Division', 'Divisions', '1', 1),
(164, 'Saint Vincent and The Grenadines', 'VC', 'Parish', 'Parishes', '1 784', 1),
(165, 'Samoa', 'WS', 'Division', 'Divisions', '', 1),
(166, 'San Marino', 'SM', 'Division', 'Divisions', '378', 1),
(167, 'Sao Tome and Principe', 'ST', 'Division', 'Divisions', '239', 1),
(168, 'Saudi Arabia', 'SA', 'Division', 'Divisions', '966', 1),
(169, 'Senegal', 'SN', 'Division', 'Divisions', '221', 1),
(170, 'Serbia', 'RS', 'Division', 'Divisions', '381', 1),
(171, 'Seychelles', 'SC', 'Division', 'Divisions', '248', 1),
(172, 'Sierra Leone', 'SL', 'Division', 'Divisions', '232', 1),
(173, 'Singapore', 'SG', 'Division', 'Divisions', '65', 1),
(174, 'Slovakia (Slovak Republic)', 'SK', 'Division', 'Divisions', '421', 1),
(175, 'Slovenia', 'SI', 'Division', 'Divisions', '386', 1),
(176, 'Solomon Islands', 'SB', 'Division', 'Divisions', '677', 1),
(177, 'Somalia', 'SO', 'Division', 'Divisions', '252', 1),
(178, 'South Africa', 'ZA', 'Province', 'Provinces', '27', 1),
(179, 'Spain', 'ES', 'Division', 'Divisions', '34', 1),
(180, 'Sri Lanka', 'LK', 'Division', 'Divisions', '94', 1),
(181, 'Sudan', 'SD', 'State', 'States', '249', 1),
(182, 'Suriname', 'SR', 'Division', 'Divisions', '597', 1),
(183, 'Swaziland', 'SZ', 'Division', 'Divisions', '268', 1),
(184, 'Sweden', 'SE', 'County', 'Counties', '46', 1),
(185, 'Switzerland', 'CH', 'Canton', 'Cantons', '41', 1),
(186, 'Syrian Arab Republic', 'SY', 'Governorate', 'Governorates', '963', 1),
(187, 'Taiwan', 'TW', 'Province', 'Provinces', '886', 1),
(188, 'Tajikistan', 'TJ', 'Division', 'Divisions', '992', 1),
(189, 'Tanzania (United Rep.)', 'TZ', 'Division', 'Divisions', '255', 1),
(190, 'Thailand', 'TH', 'Division', 'Divisions', '66', 1),
(191, 'Timor-Leste', 'TL', 'Division', 'Divisions', '670', 1),
(192, 'Togo', 'TG', 'Division', 'Divisions', '228', 1),
(193, 'Tokelau', 'TK', 'Division', 'Divisions', '690', 1),
(194, 'Tonga', 'TO', 'Division', 'Divisions', '676', 1),
(195, 'Trinidad and Tobago', 'TT', 'Division', 'Divisions', '1', 1),
(196, 'Tunisia', 'TN', 'Governorate', 'Governorates', '216', 1),
(197, 'Turkey', 'TR', 'Division', 'Divisions', '90', 1),
(198, 'Turkmenistan', 'TM', 'Division', 'Divisions', '993', 1),
(199, 'Tuvalu', 'TV', 'Division', 'Divisions', '688', 1),
(200, 'Uganda', 'UG', 'Division', 'Divisions', '256', 1),
(201, 'Ukraine', 'UA', 'Division', 'Divisions', '380', 1),
(202, 'United Arab Emirates', 'AE', 'Division', 'Divisions', '971', 1),
(203, 'United Kingdom', 'GB', 'Division', 'Divisions', '44', 1),
(204, 'United States', 'US', 'State', 'States', '1', 1),
(205, 'Uruguay', 'UY', 'Division', 'Divisions', '598', 1),
(206, 'Uzbekistan', 'UZ', 'Division', 'Divisions', '998', 1),
(207, 'Vanuatu', 'VU', 'Division', 'Divisions', '678', 1),
(208, 'Venezuela', 'VE', 'State', 'States', '58', 1),
(209, 'Viet Nam', 'VN', 'Division', 'Divisions', '84', 1),
(210, 'Western Sahara', 'EH', 'Division', 'Divisions', '', 1),
(211, 'Yemen', 'YE', 'Division', 'Divisions', '967', 1),
(212, 'Zambia', 'ZM', 'Division', 'Divisions', '260', 1),
(213, 'Zimbabwe', 'ZW', 'Division', 'Divisions', '263', 1),
(214, 'Turks and Caicos Islands', 'TC', 'Division', 'Divisions', '1', 1),
(215, 'South Sudan', 'SS', 'Division', 'Divisions', '211', 1),
(216, 'Aland Islands', 'AX', 'Division', 'Divisions', '+358-18', 1),
(217, 'Anguilla', 'AI', 'Division', 'Divisions', '+1-264', 1),
(218, 'Antarctica', 'AQ', 'Division', 'Divisions', '672', 1),
(219, 'Bouvet Island', 'BV', 'Division', 'Divisions', '0055', 1),
(220, 'British Indian Ocean Territory', 'IO', 'Division', 'Divisions', '246', 1),
(221, 'Christmas Island', 'CX', 'Division', 'Divisions', '61', 1),
(222, 'Falkland Islands', 'FK', 'Division', 'Divisions', '500', 1),
(223, 'French Guiana', 'GF', 'Division', 'Divisions', '594', 1),
(224, 'French Southern Territories', 'TF', 'Division', 'Divisions', '262', 1),
(225, 'Gibraltar', 'GI', 'Division', 'Divisions', '350', 1),
(226, 'Guadeloupe', 'GP', 'Division', 'Divisions', '590', 1),
(227, 'Guernsey and Alderney', 'GG', 'Division', 'Divisions', '+44-1481', 1),
(228, 'Heard Island and McDonald Islands', 'HM', 'Division', 'Divisions', '672', 1),
(229, 'Jersey', 'JE', 'Division', 'Divisions', '+44-1534', 1),
(230, 'Man (Isle of)', 'IM', 'Division', 'Divisions', '+44-1624', 1),
(231, 'Martinique', 'MQ', 'Division', 'Divisions', '596', 1),
(232, 'Montserrat', 'MS', 'Division', 'Divisions', '+1-664', 1),
(233, 'Bonaire, Sint Eustatius and Saba', 'BQ', 'Division', 'Divisions', '599', 1),
(234, 'Norfolk Island', 'NF', 'Division', 'Divisions', '672', 1),
(235, 'Palestinian Territory Occupied', 'PS', 'Division', 'Divisions', '970', 1),
(236, 'Pitcairn Island', 'PN', 'Division', 'Divisions', '870', 1),
(237, 'Reunion', 'RE', 'Division', 'Divisions', '262', 1),
(238, 'Saint Helena', 'SH', 'Division', 'Divisions', '290', 1),
(239, 'Saint Pierre and Miquelon', 'PM', 'Division', 'Divisions', '508', 1),
(240, 'Saint-Barthelemy', 'BL', 'Division', 'Divisions', '590', 1),
(241, 'Saint-Martin (French part)', 'MF', 'Division', 'Divisions', '590', 1),
(242, 'South Georgia', 'GS', 'Division', 'Divisions', '500', 1),
(243, 'Svalbard And Jan Mayen Islands', 'SJ', 'Division', 'Divisions', '47', 1),
(244, 'United States Minor Outlying Islands', 'UM', 'Division', 'Divisions', '1', 1),
(245, 'Vatican City State (Holy See)', 'VA', 'Division', 'Divisions', '379', 1),
(246, 'Virgin Islands (British)', 'VG', 'Division', 'Divisions', '+1-284', 1),
(247, 'Virgin Islands (US)', 'VI', 'Division', 'Divisions', '+1-340', 1),
(248, 'Wallis And Futuna Islands', 'WF', 'Division', 'Divisions', '681', 1),
(249, 'Kosovo', 'XK', 'Division', 'Divisions', '383', 1),
(250, 'Curaçao', 'CW', 'Division', 'Divisions', '599', 1),
(251, 'Sint Maarten (Dutch part)', 'SX', 'Division', 'Divisions', '1721', 1);

-- --------------------------------------------------------

--
-- Table structure for table `coupons`
--

CREATE TABLE `coupons` (
  `coupons_id` int(11) NOT NULL AUTO_INCREMENT,
  `coupons_name` varchar(50) NOT NULL DEFAULT '',
  `coupons_description` text NOT NULL,
  `coupons_code` varchar(50) NOT NULL DEFAULT '',
  `coupons_quantity` int(11) NOT NULL DEFAULT '0',
  `coupons_type` tinyint(4) NOT NULL DEFAULT '0',
  `coupons_applicable_to` tinyint(4) NOT NULL DEFAULT '127',
  `coupons_discount` decimal(25,3) NOT NULL DEFAULT '0.000',
  `coupons_start` date NOT NULL DEFAULT '0000-00-00',
  `coupons_expires` date NOT NULL DEFAULT '0000-00-00',
  `coupons_recurring` tinyint(4) NOT NULL DEFAULT '0',
  `coupons_recurringmonths` int(11) NOT NULL DEFAULT '0',
  `coupons_billingcycles` text NOT NULL,
  `coupons_archive` tinyint(1) NOT NULL DEFAULT '0',
  `coupons_taxable` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`coupons_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `coupons_packages`
--

CREATE TABLE `coupons_packages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `coupons_id` int(11) NOT NULL DEFAULT '0',
  `promotion_id` int(11) NOT NULL DEFAULT '0',
  `package_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `coupons_usage`
--

CREATE TABLE `coupons_usage` (
  `invoiceentryid` int(11) NOT NULL,
  `couponid` int(11) NOT NULL,
  `isrecurring` tinyint(1) NOT NULL,
  PRIMARY KEY (`invoiceentryid`,`couponid`,`isrecurring`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `currency`
--

CREATE TABLE `currency` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL DEFAULT '',
  `symbol` char(10) NOT NULL DEFAULT '',
  `decimalssep` char(10) NOT NULL DEFAULT '.',
  `thousandssep` char(10) NOT NULL DEFAULT ',',
  `abrv` varchar(4) NOT NULL DEFAULT '',
  `alignment` varchar(10) NOT NULL DEFAULT 'left',
  `precision` int(1) NOT NULL DEFAULT '2',
  `rate` decimal(25,10) NOT NULL DEFAULT '1.0000000000',
  `enabled` tinyint(4) NOT NULL DEFAULT '1',
  UNIQUE KEY `abrv` (`abrv`),
  KEY `id` (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=181 ;

--
-- Dumping data for table `currency`
--

INSERT INTO `currency` VALUES
(18, 'United Arab Emirates dirham', 'د.إ', '.', ',', 'AED', 'right', 2, '1.0000000000', 0),
(19, 'Afghan afghani', '؋', '.', ',', 'AFN', 'left', 2, '1.0000000000', 0),
(20, 'Albanian lek', 'L', '.', ',', 'ALL', 'left', 2, '1.0000000000', 0),
(21, 'Armenian dram', '֏', '.', ',', 'AMD', 'left', 2, '1.0000000000', 0),
(22, 'Netherlands Antillean guilder', 'ƒ', '.', ',', 'ANG', 'left', 2, '1.0000000000', 0),
(23, 'Angolan kwanza', 'Kz', '.', ',', 'AOA', 'right', 2, '1.0000000000', 0),
(24, 'Argentine peso', '$', '.', ',', 'ARS', 'left', 2, '1.0000000000', 0),
(25, 'Australian dollar', '$', '.', ',', 'AUD', 'left', 2, '1.0000000000', 0),
(26, 'Aruban florin', 'ƒ', '.', ',', 'AWG', 'left', 2, '1.0000000000', 0),
(27, 'Azerbaijani manat', '₼', '.', ',', 'AZN', 'left', 2, '1.0000000000', 0),
(28, 'Bosnia and Herzegovina convertible mark', 'КМ', '.', ',', 'BAM', 'left', 2, '1.0000000000', 0),
(29, 'Barbadian dollar', '$', '.', ',', 'BBD', 'left', 2, '1.0000000000', 0),
(30, 'Bangladeshi taka', '৳', '.', ',', 'BDT', 'left', 2, '1.0000000000', 0),
(31, 'Bulgarian lev', 'лв', '.', ',', 'BGN', 'left', 2, '1.0000000000', 0),
(32, 'Bahraini dinar', '.د.ب', '.', ',', 'BHD', 'left', 3, '1.0000000000', 0),
(33, 'Burundian franc', 'Fr', '.', ',', 'BIF', 'right', 2, '1.0000000000', 0),
(34, 'Bermudian dollar', '$', '.', ',', 'BMD', 'left', 2, '1.0000000000', 0),
(35, 'Brunei dollar', '$', '.', ',', 'BND', 'left', 2, '1.0000000000', 0),
(36, 'Bolivian boliviano', 'Bs.', '.', ',', 'BOB', 'left', 2, '1.0000000000', 0),
(37, 'Brazilian real', 'R$', '.', ',', 'BRL', 'left', 2, '1.0000000000', 0),
(38, 'Bahamian dollar', '$', '.', ',', 'BSD', 'left', 2, '1.0000000000', 0),
(39, 'Bhutanese ngultrum', 'Nu.', '.', ',', 'BTN', 'left', 2, '1.0000000000', 0),
(40, 'Botswana pula', 'P', '.', ',', 'BWP', 'left', 2, '1.0000000000', 0),
(41, 'Belarusian ruble', 'Br', '.', ',', 'BYN', 'left', 2, '1.0000000000', 0),
(42, 'Belize dollar', '$', '.', ',', 'BZD', 'left', 2, '1.0000000000', 0),
(43, 'Canadian dollar', '$', '.', ',', 'CAD', 'left', 2, '1.0000000000', 1),
(44, 'Congolese franc', 'Fr', '.', ',', 'CDF', 'right', 2, '1.0000000000', 0),
(45, 'Swiss franc', 'Fr', '.', ',', 'CHF', 'left', 2, '1.0000000000', 0),
(46, 'Chilean peso', '$', '.', ',', 'CLP', 'left', 2, '1.0000000000', 0),
(47, 'Chinese yuan', '¥', '.', ',', 'CNY', 'left', 2, '1.0000000000', 0),
(48, 'Colombian peso', '$', '.', ',', 'COP', 'left', 2, '1.0000000000', 0),
(49, 'Costa Rican colón', '₡', '.', ',', 'CRC', 'left', 2, '1.0000000000', 0),
(50, 'Cuban convertible peso', '$', '.', ',', 'CUC', 'left', 2, '1.0000000000', 0),
(51, 'Cuban peso', '$', '.', ',', 'CUP', 'left', 2, '1.0000000000', 0),
(52, 'Cape Verdean escudo', '$', '.', ',', 'CVE', 'left', 2, '1.0000000000', 0),
(53, 'Czech koruna', 'Kč', '.', ',', 'CZK', 'left', 2, '1.0000000000', 0),
(54, 'Djiboutian franc', 'Fr', '.', ',', 'DJF', 'right', 2, '1.0000000000', 0),
(55, 'Danish krone', 'kr', ',', 'space', 'DKK', 'left', 2, '1.0000000000', 0),
(56, 'Dominican peso', '$', '.', ',', 'DOP', 'left', 2, '1.0000000000', 0),
(57, 'Algerian dinar', 'د.ج', '.', ',', 'DZD', 'right', 2, '1.0000000000', 0),
(58, 'Egyptian pound', 'ج.م', '.', ',', 'EGP', 'left', 3, '1.0000000000', 0),
(59, 'Eritrean nakfa', 'Nfk', '.', ',', 'ERN', 'right', 2, '1.0000000000', 0),
(60, 'Ethiopian birr', 'Br', '.', ',', 'ETB', 'left', 2, '1.0000000000', 0),
(61, 'Euro', '€', '.', ',', 'EUR', 'left', 2, '1.0000000000', 1),
(62, 'Fijian dollar', '$', '.', ',', 'FJD', 'left', 2, '1.0000000000', 0),
(63, 'Falkland Islands pound', '£', '.', ',', 'FKP', 'left', 2, '1.0000000000', 0),
(64, 'British pound', '£', '.', ',', 'GBP', 'left', 2, '1.0000000000', 1),
(65, 'Georgian lari', '₾', '.', ',', 'GEL', 'left', 2, '1.0000000000', 0),
(66, 'Guernsey pound', '£', '.', ',', 'GGP', 'left', 2, '1.0000000000', 0),
(67, 'Ghanaian cedi', '₵', '.', ',', 'GHS', 'left', 2, '1.0000000000', 0),
(68, 'Gibraltar pound', '£', '.', ',', 'GIP', 'left', 2, '1.0000000000', 0),
(69, 'Gambian dalasi', 'D', '.', ',', 'GMD', 'left', 2, '1.0000000000', 0),
(70, 'Guinean franc', 'Fr', '.', ',', 'GNF', 'left', 2, '1.0000000000', 0),
(71, 'Guatemalan quetzal', 'Q', '.', ',', 'GTQ', 'left', 2, '1.0000000000', 0),
(72, 'Guyanese dollar', '$', '.', ',', 'GYD', 'left', 2, '1.0000000000', 0),
(73, 'Hong Kong dollar', '$', '.', ',', 'HKD', 'left', 2, '1.0000000000', 0),
(74, 'Honduran lempira', 'L', '.', ',', 'HNL', 'left', 2, '1.0000000000', 0),
(75, 'Croatian kuna', 'kn', '.', ',', 'HRK', 'left', 2, '1.0000000000', 0),
(76, 'Haitian gourde', 'G', '.', ',', 'HTG', 'left', 2, '1.0000000000', 0),
(77, 'Hungarian forint', 'Ft', '.', ',', 'HUF', 'right', 2, '1.0000000000', 0),
(78, 'Indonesian rupiah', 'Rp', ',', '.', 'IDR', 'left', 0, '1.0000000000', 0),
(79, 'Israeli new shekel', '₪', '.', ',', 'ILS', 'left', 2, '1.0000000000', 0),
(80, 'Manx pound', '£', '.', ',', 'IMP', 'left', 2, '1.0000000000', 0),
(81, 'Indian rupee', '₹', '.', ',', 'INR', 'left', 2, '1.0000000000', 0),
(82, 'Iraqi dinar', 'ع.د', '.', ',', 'IQD', 'left', 3, '1.0000000000', 0),
(83, 'Iranian rial', '﷼', '.', ',', 'IRR', 'left', 2, '1.0000000000', 0),
(84, 'Icelandic króna', 'kr', ',', 'space', 'ISK', 'left', 2, '1.0000000000', 0),
(85, 'Jersey pound', '£', '.', ',', 'JEP', 'left', 2, '1.0000000000', 0),
(86, 'Jamaican dollar', '$', '.', ',', 'JMD', 'left', 2, '1.0000000000', 0),
(87, 'Jordanian dinar', 'د.ا', '.', ',', 'JOD', 'left', 2, '1.0000000000', 0),
(88, 'Japanese yen', '¥', '.', ',', 'JPY', 'left', 2, '1.0000000000', 0),
(89, 'Kenyan shilling', 'Sh', '.', ',', 'KES', 'left', 2, '1.0000000000', 0),
(90, 'Kyrgyzstani som', 'с', '.', ',', 'KGS', 'left', 2, '1.0000000000', 0),
(91, 'Cambodian riel', '៛', '.', ',', 'KHR', 'left', 2, '1.0000000000', 0),
(92, 'Kiribati dollar', '$', '.', ',', 'KID', 'left', 2, '1.0000000000', 0),
(93, 'Comorian franc', 'Fr', '.', ',', 'KMF', 'right', 2, '1.0000000000', 0),
(94, 'North Korean won', '₩', '.', ',', 'KPW', 'left', 2, '1.0000000000', 0),
(95, 'South Korean won', '₩', '.', ',', 'KRW', 'left', 2, '1.0000000000', 0),
(96, 'Kuwaiti dinar', 'د.ك', '.', ',', 'KWD', 'left', 3, '1.0000000000', 0),
(97, 'Cayman Islands dollar', '$', '.', ',', 'KYD', 'left', 2, '1.0000000000', 0),
(98, 'Kazakhstani tenge', '₸', '.', ',', 'KZT', 'left', 2, '1.0000000000', 0),
(99, 'Lao kip', '₭', '.', ',', 'LAK', 'left', 2, '1.0000000000', 0),
(100, 'Lebanese pound', 'ل.ل', '.', ',', 'LBP', 'left', 2, '1.0000000000', 0),
(101, 'Sri Lankan rupee', 'රු', '.', ',', 'LKR', 'left', 2, '1.0000000000', 0),
(102, 'Liberian dollar', '$', '.', ',', 'LRD', 'left', 2, '1.0000000000', 0),
(103, 'Lesotho loti', 'L', '.', ',', 'LSL', 'left', 2, '1.0000000000', 0),
(104, 'Libyan dinar', 'ل.د', '.', ',', 'LYD', 'left', 3, '1.0000000000', 0),
(105, 'Moroccan dirham', 'د.م.', '.', ',', 'MAD', 'right', 2, '1.0000000000', 0),
(106, 'Moldovan leu', 'L', '.', ',', 'MDL', 'left', 2, '1.0000000000', 0),
(107, 'Malagasy ariary', 'Ar', '.', ',', 'MGA', 'left', 1, '1.0000000000', 0),
(108, 'Macedonian denar', 'ден', '.', ',', 'MKD', 'left', 2, '1.0000000000', 0),
(109, 'Burmese kyat', 'Ks', '.', ',', 'MMK', 'left', 2, '1.0000000000', 0),
(110, 'Mongolian tögrög', '₮', '.', ',', 'MNT', 'left', 2, '1.0000000000', 0),
(111, 'Macanese pataca', 'P', '.', ',', 'MOP', 'left', 2, '1.0000000000', 0),
(112, 'Mauritanian ouguiya', 'UM', '.', ',', 'MRU', 'left', 1, '1.0000000000', 0),
(113, 'Mauritian rupee', '₨', '.', ',', 'MUR', 'left', 2, '1.0000000000', 0),
(114, 'Maldivian rufiyaa', '.ރ', '.', ',', 'MVR', 'left', 2, '1.0000000000', 0),
(115, 'Malawian kwacha', 'MK', '.', ',', 'MWK', 'left', 2, '1.0000000000', 0),
(116, 'Mexican peso', '$', '.', ',', 'MXN', 'left', 2, '1.0000000000', 0),
(117, 'Malaysian ringgit', 'RM', '.', ',', 'MYR', 'left', 2, '1.0000000000', 0),
(118, 'Mozambican metical', 'MT', '.', ',', 'MZN', 'left', 2, '1.0000000000', 0),
(119, 'Namibian dollar', '$', '.', ',', 'NAD', 'left', 2, '1.0000000000', 0),
(120, 'Nigerian naira', '₦', '.', ',', 'NGN', 'left', 2, '1.0000000000', 0),
(121, 'Nicaraguan córdoba', 'C$', '.', ',', 'NIO', 'left', 2, '1.0000000000', 0),
(122, 'Norwegian krone', 'kr', ',', 'space', 'NOK', 'left', 2, '1.0000000000', 0),
(123, 'Nepalese rupee', '₨', '.', ',', 'NPR', 'left', 2, '1.0000000000', 0),
(124, 'New Zealand dollar', '$', '.', ',', 'NZD', 'left', 2, '1.0000000000', 0),
(125, 'Omani rial', 'ر.ع.', '.', ',', 'OMR', 'left', 3, '1.0000000000', 0),
(126, 'Panamanian balboa', 'B/.', '.', ',', 'PAB', 'left', 2, '1.0000000000', 0),
(127, 'Peruvian sol', 'S/.', '.', ',', 'PEN', 'left', 2, '1.0000000000', 0),
(128, 'Papua New Guinean kina', 'K', '.', ',', 'PGK', 'left', 2, '1.0000000000', 0),
(129, 'Philippine peso', '₱', '.', ',', 'PHP', 'left', 2, '1.0000000000', 0),
(130, 'Pakistani rupee', '₨', '.', ',', 'PKR', 'left', 2, '1.0000000000', 0),
(131, 'Polish złoty', 'zł', '.', ',', 'PLN', 'left', 2, '1.0000000000', 0),
(132, 'Transnistrian ruble', 'р.', '.', ',', 'PRB', 'left', 2, '1.0000000000', 0),
(133, 'Paraguayan guaraní', '₲', '.', ',', 'PYG', 'left', 2, '1.0000000000', 0),
(134, 'Qatari riyal', 'ر.ق', '.', ',', 'QAR', 'left', 2, '1.0000000000', 0),
(135, 'Romanian leu', 'L', '.', ',', 'RON', 'right', 2, '1.0000000000', 0),
(136, 'Serbian dinar', 'дин.', '.', ',', 'RSD', 'right', 2, '1.0000000000', 0),
(137, 'Russian ruble', '₽', '.', ',', 'RUB', 'left', 2, '1.0000000000', 0),
(138, 'Rwandan franc', 'Fr', '.', ',', 'RWF', 'left', 2, '1.0000000000', 0),
(139, 'Saudi riyal', 'ر.س', '.', ',', 'SAR', 'left', 2, '1.0000000000', 0),
(140, 'Solomon Islands dollar', '$', '.', ',', 'SBD', 'left', 2, '1.0000000000', 0),
(141, 'Seychellois rupee', '₨', '.', ',', 'SCR', 'left', 2, '1.0000000000', 0),
(142, 'Sudanese pound', 'ج.س.', '.', ',', 'SDG', 'left', 2, '1.0000000000', 0),
(143, 'Swedish krona', 'kr', ',', 'space', 'SEK', 'left', 2, '1.0000000000', 0),
(144, 'Singapore dollar', '$', '.', ',', 'SGD', 'left', 2, '1.0000000000', 0),
(145, 'Saint Helena pound', '£', '.', ',', 'SHP', 'left', 2, '1.0000000000', 0),
(146, 'Sierra Leonean leone', 'Le', '.', ',', 'SLL', 'left', 2, '1.0000000000', 0),
(147, 'Somaliland shilling', 'Sl', '.', ',', 'SLS', 'left', 2, '1.0000000000', 0),
(148, 'Somali shilling', 'Sh', '.', ',', 'SOS', 'left', 2, '1.0000000000', 0),
(149, 'Surinamese dollar', '$', '.', ',', 'SRD', 'left', 2, '1.0000000000', 0),
(150, 'South Sudanese pound', '£', '.', ',', 'SSP', 'left', 2, '1.0000000000', 0),
(151, 'São Tomé and Príncipe dobra', 'Db', '.', ',', 'STN', 'left', 2, '1.0000000000', 0),
(152, 'Syrian pound', '£S', '.', ',', 'SYP', 'left', 2, '1.0000000000', 0),
(153, 'Swazi lilangeni', 'L', '.', ',', 'SZL', 'left', 2, '1.0000000000', 0),
(154, 'Thai baht', '฿', '.', ',', 'THB', 'left', 2, '1.0000000000', 0),
(155, 'Tajikistani somoni', 'ЅМ', '.', ',', 'TJS', 'left', 2, '1.0000000000', 0),
(156, 'Turkmenistan manat', 'm', '.', ',', 'TMT', 'left', 2, '1.0000000000', 0),
(157, 'Tunisian dinar', 'د.ت', '.', ',', 'TND', 'left', 3, '1.0000000000', 0),
(158, 'Tongan paʻanga', 'T$', '.', ',', 'TOP', 'left', 2, '1.0000000000', 0),
(159, 'Turkish lira', '₺', '.', ',', 'TRY', 'right', 2, '1.0000000000', 0),
(160, 'Trinidad and Tobago dollar', '$', '.', ',', 'TTD', 'left', 2, '1.0000000000', 0),
(161, 'Tuvaluan dollar', '$', '.', ',', 'TVD', 'left', 2, '1.0000000000', 0),
(162, 'New Taiwan dollar', '$', '.', ',', 'TWD', 'left', 2, '1.0000000000', 0),
(163, 'Tanzanian shilling', 'Sh', '.', ',', 'TZS', 'left', 2, '1.0000000000', 0),
(164, 'Ukrainian hryvnia', '₴', '.', ',', 'UAH', 'left', 2, '1.0000000000', 0),
(165, 'Ugandan shilling', 'Sh', '.', ',', 'UGX', 'left', 2, '1.0000000000', 0),
(166, 'United States dollar', '$', '.', ',', 'USD', 'left', 2, '1.0000000000', 1),
(167, 'Uruguayan peso', '$', '.', ',', 'UYU', 'left', 2, '1.0000000000', 0),
(168, 'Uzbekistani soʻm', 'сўм', '.', ',', 'UZS', 'left', 2, '1.0000000000', 0),
(169, 'Venezuelan bolívar soberano', 'Bs.S.', '.', ',', 'VES', 'left', 2, '1.0000000000', 0),
(170, 'Vietnamese đồng', '₫', '.', ',', 'VND', 'left', 1, '1.0000000000', 0),
(171, 'Vanuatu vatu', 'Vt', '.', ',', 'VUV', 'left', 0, '1.0000000000', 0),
(172, 'Samoan tālā', 'T', '.', ',', 'WST', 'left', 2, '1.0000000000', 0),
(173, 'Central African CFA franc', 'Fr', '.', ',', 'XAF', 'right', 2, '1.0000000000', 0),
(174, 'Eastern Caribbean dollar', '$', '.', ',', 'XCD', 'left', 2, '1.0000000000', 0),
(175, 'West African CFA franc', 'Fr', '.', ',', 'XOF', 'right', 2, '1.0000000000', 0),
(176, 'CFP franc', '₣', '.', ',', 'XPF', 'left', 2, '1.0000000000', 0),
(177, 'Yemeni rial', '﷼', '.', ',', 'YER', 'left', 2, '1.0000000000', 0),
(178, 'South African rand', 'R', '.', ',', 'ZAR', 'left', 2, '1.0000000000', 0),
(179, 'Zambian kwacha', 'ZK', '.', ',', 'ZMW', 'left', 2, '1.0000000000', 0),
(180, 'Zimbabwean bonds', '$', '.', ',', 'ZWB', 'left', 2, '1.0000000000', 0);

-- --------------------------------------------------------

--
-- Table structure for table `customField`
--

CREATE TABLE `customField` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL DEFAULT '0',
  `groupId` tinyint(4) NOT NULL DEFAULT '0',
  `subGroupId` tinyint(4) NOT NULL DEFAULT '0',
  `fieldType` tinyint(4) NOT NULL DEFAULT '0',
  `name` varchar(50) NOT NULL DEFAULT '',
  `isRequired` tinyint(4) NOT NULL DEFAULT '0',
  `isChangeable` tinyint(4) NOT NULL DEFAULT '1',
  `isAdminOnly` tinyint(4) NOT NULL DEFAULT '0',
  `fieldOrder` int(11) NOT NULL DEFAULT '0',
  `showCustomer` tinyint(4) NOT NULL DEFAULT '1',
  `showAdmin` tinyint(4) NOT NULL DEFAULT '1',
  `dropDownOptions` longtext NOT NULL,
  `inSettings` smallint(6) NOT NULL DEFAULT '1',
  `InSignup` tinyint(1) NOT NULL DEFAULT '0',
  `showingridadmin` tinyint(1) NOT NULL DEFAULT '0',
  `showingridportal` tinyint(1) NOT NULL DEFAULT '0',
  `partofproductidentifier` tinyint(1) NOT NULL DEFAULT '0',
  `desc` varchar(250) NOT NULL DEFAULT '',
  `isEncrypted` tinyint(1) NOT NULL DEFAULT '0',
  `usedbyplugin` varchar(60) NOT NULL DEFAULT '',
  `isClientChangeable` tinyint(4) NOT NULL DEFAULT '0',
  `regex` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `groupId_subGroupId_name` (`groupId`,`subGroupId`,`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=40 ;

--
-- Dumping data for table `customField`
--

INSERT INTO `customField` VALUES
(1, 0, 2, 1, 0, 'IP Address', 1, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '', 0, '', 0, NULL),
(2, 0, 2, 3, 0, 'Domain Name', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '', 0, '', 0, NULL),
(3, 0, 2, 3, 0, 'Domain Next Pricing', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '', 0, '', 0, NULL),
(4, 0, 2, 3, 0, 'Registrar Order Id', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '', 0, '', 0, NULL),
(5, 0, 2, 3, 0, 'Domain Extra Attr', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '', 0, '', 0, NULL),
(6, 0, 2, 3, 0, 'Auto Renew', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '', 0, '', 0, NULL),
(7, 0, 2, 3, 0, 'Registration Option', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '', 0, '', 0, NULL),
(8, 0, 2, 3, 0, 'Registrar', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '', 0, '', 0, NULL),
(9, 0, 2, 1, 0, 'Server Id', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '', 0, '', 0, NULL),
(10, 0, 2, 1, 0, 'User Name', 1, 0, 0, 2, 0, 0, '', 1, 1, 0, 0, 0, '', 0, '', 0, NULL),
(11, 0, 2, 1, 0, 'Control Panel', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '', 0, '', 0, NULL),
(12, 0, 2, 1, 0, 'Domain Name', 1, 0, 0, 1, 0, 0, '', 1, 1, 0, 0, 0, '', 0, '', 0, NULL),
(13, 0, 2, 1, 65, 'Password', 1, 0, 0, 3, 0, 0, '', 1, 1, 0, 0, 0, '', 0, '', 0, NULL),
(14, 0, 2, 1, 0, 'Server Acct Properties', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '', 0, '', 0, NULL),
(15, 0, 2, 1, 0, 'Shared', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '', 0, '', 0, NULL),
(16, 0, 2, 0, 0, 'Plugin Status', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '', 0, '', 0, NULL),
(17, 0, 2, 0, 0, 'Plugin Properties', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '', 0, '', 0, NULL),
(18, 0, 2, 0, 15, 'Last Status Date', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '', 0, '', 0, NULL),
(19, 0, 2, 0, 0, 'Previous Status', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '', 0, '', 0, NULL),
(20, 0, 2, 0, 0, 'Upgrading to product id', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '', 0, '', 0, NULL),
(21, 0, 2, 3, 15, 'Expiration Date', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '', 0, '', 0, NULL),
(22, 0, 2, 3, 0, 'Transfer Status', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '', 0, '', 0, NULL),
(23, 0, 2, 3, 0, 'Transfer Update Date', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '', 0, '', 0, NULL),
(24, 0, 2, 2, 0, 'Certificate Id', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '', 0, '', 0, NULL),
(25, 0, 2, 2, 0, 'Certificate Type', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '', 0, '', 0, NULL),
(26, 0, 2, 2, 0, 'Certificate Status', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '', 0, '', 0, NULL),
(27, 0, 2, 2, 15, 'Certificate Expiration Date', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '', 0, '', 0, NULL),
(28, 0, 2, 2, 0, 'Certificate Domain', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '', 0, '', 0, NULL),
(29, 0, 2, 2, 10, 'Certificate CSR', 0, 0, 0, 0, 1, 0, '', 1, 1, 0, 0, 0, '', 0, '', 0, NULL),
(30, 0, 2, 2, 0, 'Certificate Admin Email', 0, 0, 0, 0, 1, 0, '', 1, 1, 0, 0, 0, '', 0, '', 0, NULL),
(31, 0, 2, 2, 0, 'Registrar', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '', 0, '', 0, NULL),
(32, 0, 2, 2, 0, 'Certificate Server Type', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '', 0, '', 0, NULL),
(33, 0, 2, 2, 0, 'SSL Certificate', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '', 0, '', 0, NULL),
(34, 0, 2, 0, 0, 'Cancellation Reason', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '', 0, '', 0, NULL),
(35, 0, 2, 0, 0, 'Cancellation Type', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '', 0, '', 0, NULL),
(36, 0, 2, 0, 15, 'Cancellation Request Date', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '', 0, '', 0, NULL),
(37, 0, 2, 0, 0, 'Override AutoSuspend', 0, 0, 0, 0, 0, 0, '', 0, 0, 0, 0, 0, '', 0, '', 0, NULL),
(38, 0, 3, 0, 0, 'CC', 0, 0, 1, 1, 0, 0, '', 0, 0, 0, 0, 0, 'Enter a comma separated list of email addresses to be CC''ed on this ticket.', 0, '', 0, NULL),
(39, 0, 3, 0, 0, 'BCC', 0, 0, 1, 2, 0, 0, '', 0, 0, 0, 0, 0, 'Enter a comma separated list of email addresses to be BCC''ed on this ticket.', 0, '', 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `customuserfields`
--

CREATE TABLE `customuserfields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(50) NOT NULL DEFAULT '',
  `type` tinyint(4) NOT NULL DEFAULT '0',
  `isrequired` tinyint(4) NOT NULL DEFAULT '0',
  `isChangable` tinyint(4) NOT NULL DEFAULT '1',
  `isAdminOnly` tinyint(4) NOT NULL DEFAULT '0',
  `width` mediumint(9) NOT NULL DEFAULT '20',
  `myOrder` int(11) NOT NULL DEFAULT '0',
  `showcustomer` tinyint(4) NOT NULL DEFAULT '1',
  `showadmin` tinyint(4) NOT NULL DEFAULT '1',
  `InSignup` tinyint(1) NOT NULL DEFAULT '0',
  `showingridadmin` tinyint(1) NOT NULL DEFAULT '0',
  `inSettings` smallint(6) NOT NULL DEFAULT '1',
  `dropdownoptions` longtext NOT NULL,
  `desc` varchar(250) NOT NULL DEFAULT '',
  `usedbyplugin` varchar(60) NOT NULL DEFAULT '',
  `regex` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=62 ;

--
-- Dumping data for table `customuserfields`
--

INSERT INTO `customuserfields` VALUES
(1, 0, 'First Name', 11, 1, 2, 0, 20, 2, 1, 1, 1, 0, 1, '', '', '', NULL),
(2, 0, 'Last Name', 12, 1, 2, 0, 20, 3, 1, 1, 1, 0, 1, '', '', '', NULL),
(3, 0, 'Address', 2, 1, 2, 0, 40, 7, 1, 0, 1, 0, 1, '', '', '', NULL),
(5, 0, 'City', 3, 1, 2, 0, 20, 8, 1, 0, 1, 0, 1, '', '', '', NULL),
(6, 0, 'State', 4, 1, 2, 0, 3, 9, 1, 0, 1, 0, 1, '', '', '', NULL),
(7, 0, 'Zipcode', 5, 1, 2, 0, 10, 10, 1, 0, 1, 0, 1, '', '', '', NULL),
(15, 0, 'Country', 6, 1, 2, 0, 20, 11, 1, 0, 1, 0, 1, '', '', '', NULL),
(4, 0, 'Email', 13, 1, 2, 0, 35, 4, 1, 1, 1, 0, 1, '', '', '', NULL),
(8, 0, 'Phone', 7, 1, 2, 0, 20, 6, 1, 1, 1, 0, 1, '', 'When entering a phone number be sure to include the leading "+" sign followed by the country code.', '', NULL),
(10, 0, 'Organization', 14, 0, 2, 0, 30, 1, 1, 0, 1, 0, 1, '', 'Select the box and enter a name to create this account as an organization instead of an individual.', '', NULL),
(18, 0, 'Language', 8, 1, 2, 0, 20, 18, 1, 1, 0, 0, 0, '', '', '', NULL),
(25, 0, 'Use Paypal Subscriptions', 24, 0, 0, 0, 20, 19, 0, 0, 0, 0, 0, '', '', '', NULL),
(26, 0, 'Records per page', 20, 0, 1, 0, 55, 0, 0, 0, 0, 0, 0, '', '', '', NULL),
(27, 0, 'Dashboard graph totals', 22, 0, 1, 0, 20, 0, 0, 0, 0, 0, 0, '', '', '', NULL),
(28, 0, 'Dashboard graph legend', 23, 0, 1, 0, 20, 0, 0, 0, 0, 0, 0, '', '', '', NULL),
(30, 0, 'selectedDashboardTab', 37, 0, 1, 1, 20, 0, 0, 0, 0, 0, 0, '', '', '', NULL),
(31, 0, 'Receive Email Announcements', 16, 1, 2, 0, 55, 18, 1, 0, 1, 0, 1, '', 'We urge you to subscribe to our email announcements however you may opt-out by selecting NO.', '', NULL),
(34, 0, 'QUICK_REPORTS', 40, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, '', '', '', NULL),
(35, 0, 'DASHBOARD_LASTUSEDGRAPH', 41, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, '', '', '', NULL),
(36, 0, 'ViewMenu', 42, 0, 1, 0, 20, 0, 0, 0, 0, 0, 0, '', '', '', NULL),
(37, 0, 'LastSentFeedbackEmail', 43, 0, 1, 0, 20, 0, 0, 0, 0, 0, 0, '', '', '', NULL),
(38, 0, 'DASHBOARD_TICKETFILTER', 45, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, '', '', '', NULL),
(39, 0, 'DASHBOARD_DOMAINFILTER', 45, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, '', '', '', NULL),
(40, 0, 'TABLESORT_snapshot_domains', 46, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, '', '', '', NULL),
(41, 0, 'VAT Number', 47, 0, 2, 0, 20, 11, 1, 0, 1, 0, 1, '', '', '', NULL),
(42, 0, 'DashboardState', 48, 0, 1, 1, 20, 0, 0, 0, 0, 0, 0, '', '', '', NULL),
(43, 0, 'Ticket_ShowHeader', 50, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, '', '', '', NULL),
(44, 0, 'Ticket_Sidebar_RecentList', 60, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, '', '', '', NULL),
(45, 0, 'Sidebar_Position', 60, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, '', '', '', NULL),
(46, 0, 'VAT Validation', 51, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, '', '', '', NULL),
(47, 0, 'Last Status Date', 52, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, '', '', '', NULL),
(48, 0, 'Nickname', 61, 0, 2, 1, 20, 0, 0, 1, 0, 0, 1, '', '', '', NULL),
(49, 0, 'ChatStatus', 62, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, '', '', '', NULL),
(50, 0, 'Password', 70, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, '', '', '', NULL),
(54, 0, 'Dashboard_At_A_Glance', 0, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, '', '', '', NULL),
(55, 0, 'Sitewide-ShowActiveUserPanel', 101, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, '', 'Active customer will appear by default', '', NULL),
(56, 0, 'Support-TicketReplyOnTop', 100, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, '', 'Most recent replies will also appear on top', '', NULL),
(57, 0, 'Support-AutoRefresh', 100, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, '', '', '', NULL),
(58, 0, 'Billing-Profile-ID', 0, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, '', '', '', NULL),
(59, 0, 'Confirmation-Activate-Expires', 0, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, '', '', '', NULL),
(60, 0, 'Confirmation-Reset-Expires', 0, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, '', '', '', NULL),
(61, 0, 'Sitewide-ExpandedSettingsMenu', 0, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, '', '', '', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `departments`
--

CREATE TABLE `departments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(50) NOT NULL,
  `is_generaldep` tinyint(4) NOT NULL DEFAULT '0',
  `lead_id` int(11) NOT NULL,
  `emails_to_notify` text,
  PRIMARY KEY (`id`),
  KEY `i_company_id` (`company_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `departments`
--

INSERT INTO `departments` VALUES
(1, 0, 'General', 1, 100, NULL),
(2, 0, 'Billing', 0, 100, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `departments_members`
--

CREATE TABLE `departments_members` (
  `department_id` int(11) NOT NULL,
  `member_id` int(11) NOT NULL,
  `is_group` tinyint(4) NOT NULL,
  `assign_to` tinyint(4) NOT NULL DEFAULT '0',
  `notify_to` tinyint(4) NOT NULL DEFAULT '0',
  `sendclosed` int(2) NOT NULL DEFAULT '0',
  `sendfeedback` int(2) NOT NULL DEFAULT '0',
  `sendresolution` int(2) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `departments_members`
--

INSERT INTO `departments_members` VALUES
(1, 100, 0, 0, 1, 1, 1, 1),
(1, 2, 1, 0, 0, 0, 0, 0),
(1, 3, 1, 0, 0, 0, 0, 0),
(1, 4, 1, 0, 0, 0, 0, 0),
(1, 5, 1, 0, 0, 0, 0, 0),
(2, 100, 0, 0, 1, 1, 1, 1),
(2, 4, 1, 0, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `domains`
--

CREATE TABLE `domains` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `DomainName` text,
  `CustomerID` int(11) DEFAULT NULL,
  `current` tinyint(4) NOT NULL DEFAULT '1',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `Plan` int(11) NOT NULL DEFAULT '0',
  `dateActivated` datetime DEFAULT NULL,
  `signup` tinyint(4) NOT NULL DEFAULT '0',
  `custom_price` float(23,2) NOT NULL DEFAULT '0.00',
  `use_custom_price` tinyint(4) NOT NULL DEFAULT '0',
  `parentPackageId` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `CustomerID` (`CustomerID`),
  KEY `PARENTID` (`parentPackageId`),
  KEY `status` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `domain_packageaddon_prices`
--

CREATE TABLE `domain_packageaddon_prices` (
  `domain_id` int(11) NOT NULL DEFAULT '0',
  `packageaddon_prices_id` int(11) NOT NULL DEFAULT '0',
  `billing_cycle` int(11) NOT NULL DEFAULT '0',
  `quantity` decimal(25,3) NOT NULL DEFAULT '1.000',
  `nextbilldate` date DEFAULT NULL,
  `openticket` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`domain_id`,`packageaddon_prices_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `email`
--

CREATE TABLE `email` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) NOT NULL,
  `subject` text NOT NULL,
  `content` text NOT NULL,
  `date` datetime NOT NULL,
  `to` text NOT NULL,
  `sender` text NOT NULL,
  `fromName` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `userid` (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `email_queue`
--

CREATE TABLE `email_queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `subject` varchar(255) NOT NULL DEFAULT '',
  `from` varchar(50) NOT NULL DEFAULT '',
  `from_name` varchar(50) NOT NULL DEFAULT '',
  `bcc` text NOT NULL,
  `priority` tinyint(4) NOT NULL DEFAULT '0',
  `confirmreceipt` tinyint(4) NOT NULL DEFAULT '0',
  `emailtype` varchar(50) NOT NULL DEFAULT '',
  `body` text NOT NULL,
  `contenttype` tinyint(4) NOT NULL DEFAULT '0',
  `dfilename` varchar(50) NOT NULL DEFAULT '',
  `attachment` longtext NOT NULL,
  `cc` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `email_queue_addressees`
--

CREATE TABLE `email_queue_addressees` (
  `email_queue_id` int(11) NOT NULL,
  `userid` int(11) NOT NULL,
  PRIMARY KEY (`email_queue_id`,`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `events_log`
--

CREATE TABLE `events_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL,
  `company_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL,
  `entity_type` varchar(50) NOT NULL,
  `entity_id` int(11) NOT NULL,
  `action` varchar(100) NOT NULL,
  `subject` int(11) NOT NULL,
  `ip` varchar(40) NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `subject` (`subject`),
  KEY `iDate` (`date`),
  KEY `i_userid` (`user_id`),
  KEY `i_event_type` (`entity_type`),
  KEY `ip` (`ip`),
  KEY `entity_id` (`entity_id`),
  KEY `action` (`action`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `files`
--

CREATE TABLE `files` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_parent` int(11) unsigned DEFAULT NULL,
  `name` varchar(256) NOT NULL,
  `description` varchar(256) DEFAULT NULL,
  `hash` varchar(32) DEFAULT NULL,
  `visible` int(11) DEFAULT '0',
  `public` int(11) DEFAULT '0',
  `size` int(11) unsigned NOT NULL DEFAULT '0',
  `added` date NOT NULL DEFAULT '0000-00-00',
  `downloads` int(11) unsigned NOT NULL DEFAULT '0',
  `lastip` varchar(15) DEFAULT NULL,
  `notes` text,
  `user_status` set('-3','-2','-1','0','1') DEFAULT NULL,
  `traverse_left` int(11) unsigned DEFAULT '0',
  `traverse_right` int(11) unsigned DEFAULT '0',
  `roomid` varchar(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `files_clienttypes`
--

CREATE TABLE `files_clienttypes` (
  `id_file` int(11) NOT NULL DEFAULT '0',
  `id_clienttype` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_file`,`id_clienttype`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `files_loggedin`
--

CREATE TABLE `files_loggedin` (
  `id_file` int(10) unsigned NOT NULL,
  `setting` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_file`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `files_public`
--

CREATE TABLE `files_public` (
  `id_file` int(10) unsigned NOT NULL,
  `setting` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_file`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `files_servers`
--

CREATE TABLE `files_servers` (
  `id_file` int(11) NOT NULL DEFAULT '0',
  `id_server` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_file`,`id_server`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `files_status`
--

CREATE TABLE `files_status` (
  `id_file` int(10) unsigned NOT NULL,
  `id_status` int(11) NOT NULL,
  PRIMARY KEY (`id_file`,`id_status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `files_users`
--

CREATE TABLE `files_users` (
  `id_file` int(11) NOT NULL DEFAULT '0',
  `id_user` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_file`,`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `groups`
--

CREATE TABLE `groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `company_id` int(11) NOT NULL DEFAULT '0',
  `isadmin` tinyint(4) NOT NULL DEFAULT '1',
  `issuperadmin` tinyint(4) NOT NULL DEFAULT '0',
  `iscompanysuperadmin` tinyint(4) NOT NULL DEFAULT '0',
  `iscustomersmaingroup` tinyint(4) NOT NULL DEFAULT '0',
  `description` text NOT NULL,
  `usedefaultcolor` tinyint(4) NOT NULL DEFAULT '1',
  `groupcolor` varchar(7) DEFAULT NULL,
  `livesupportid` varchar(25) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `i_company_id` (`company_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `groups`
--

INSERT INTO `groups` VALUES
(1, 'Client', 0, 0, 0, 0, 1, 'All clients belong to this group. You can''t erase this group.', 1, NULL, '0'),
(2, 'Super Admin', 0, 1, 1, 0, 0, 'Main administrator. He has all permissions in the system and is the only one with permissions to modify staff groups and permissions.', 1, NULL, '0'),
(3, 'Support Staff', 0, 1, 0, 0, 0, 'Has limited permissions on the support module.', 1, NULL, '0'),
(4, 'Billing', 0, 1, 0, 0, 0, 'By default, he has all the permissions in the billing module.', 1, NULL, '0'),
(5, 'Support Manager', 0, 1, 0, 0, 0, 'By default, he has all the permissions in the Support module.', 1, NULL, '0'),
(6, 'Priority Clients', 0, 0, 0, 0, 0, '', 1, NULL, '0');

-- --------------------------------------------------------

--
-- Table structure for table `help`
--

CREATE TABLE `help` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL DEFAULT '',
  `detail` text NOT NULL,
  `linkwords` varchar(40) NOT NULL DEFAULT 'Click to view available tags',
  `width` int(3) NOT NULL DEFAULT '240',
  `height` int(3) NOT NULL DEFAULT '320',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `id_2` (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=70 ;

--
-- Dumping data for table `help`
--

INSERT INTO `help` VALUES
(1, 'Welcome Email Tags', '[    {        "name": "COMPANYNAME",        "description": "Company name",        "hostingonly": false    },    {        "name": "COMPANYADDRESS",        "description": "Company address",        "hostingonly": false    },    {        "name": "ACCOUNTINFORMATION",        "description": "Account Information<br/><i style=''font-size:smaller;''>Includes Domain Name, Username, Password, IP</i>",        "hostingonly": true    },    {        "name": "DOMAINNAME",        "description": "Domain name without http://www.",        "hostingonly": false    },    {        "name": "DOMAINUSERNAME",        "description": "Domain User Name",        "hostingonly": true    },    {        "name": "DOMAINPASSWORD",        "description": "Domain Password",        "hostingonly": true    },    {        "name": "DOMAINIP",        "description": "IP Address to Domain",        "hostingonly": true    },    {        "name": "COMPANYURL",        "description": "URL to your web site",        "hostingonly": false    },    {        "name": "SUPPORTEMAIL",        "description": "E-mail to support staff",        "hostingonly": false    },    {        "name": "CLIENTAPPLICATIONURL",        "description": "URL to Clientexec.",        "hostingonly": false    },    {        "name": "FORGOTPASSWORDURL",        "description": "URL to retrieve forgotten password.",        "hostingonly": false    },    {        "name": "CLIENTNAME",        "description": "Client''s first and last name",        "hostingonly": false    },    {        "name": "FIRSTNAME",        "description": "Client''s First name",        "hostingonly": false    },    {        "name": "CLIENTEMAIL",        "description": "Client''s Email",        "hostingonly": false    },    {        "name": "ORGANIZATION",        "description": "Client''s Organization",        "hostingonly": false    },    {        "name": "PLANNAME",        "description": "Client''s Plan",        "hostingonly": false    },    {        "name": "PACKAGEID",        "description": "Client''s Package ID",        "hostingonly": false    },    {        "name": "NAMESERVERS",        "description": "Name Servers<br/><i style=''font-size:smaller;''>lists only hostnames</i>",        "hostingonly": false    },    {        "name": "NAMESERVERSANDIPS",        "description": "Name Servers and Ips<br/><i style=''font-size:smaller;''>lists both IPs and hostnames</i>",        "hostingonly": false    },    {        "name": "NAMESERVERIPS",        "description": "Name Server Ips<br/><i style=''font-size:smaller;''>lists only IPs</i>",        "hostingonly": false    },    {        "name": "SERVERHOSTNAME",        "description": "Server Host Name<br/><i style=''font-size:smaller;''>i.e. server1.yourdomain.com</i>",        "hostingonly": true    },    {        "name": "SERVERSHAREDIP",        "description": "Server''s Shared IP",        "hostingonly": true    },    {        "name": "CUSTOMPROFILE_xxxx",        "description": "Custom Profile<br/><i style=''font-size:smaller;''>where xxx is a profile custom field name (i.e. [CUSTOMPROFILE_somename])</i>",        "hostingonly": false    },    {        "name": "CUSTOMPACKAGE_xxxx",        "description": "Custom Package Field<br/><i style=''font-size:smaller;''>Where xxx is custom package field name (i.e. [CUSTOMPACKAGE_somename])</i>",        "hostingonly": true    }]', 'Click to view available tags', 240, 320),
(2, 'Notification Email Tags', '[{"name":"BILLINGEMAIL","description":"Email address for billing inquiries","hostingonly":false},{"name":"SUPPORTEMAIL","description":"E-mail to support staff","hostingonly":false},{"name":"COMPANYNAME","description":"Company name","hostingonly":false},{"name":"COMPANYADDRESS","description":"Company address","hostingonly":false},{"name":"COMPANYURL","description":"URL to your web site","hostingonly":false},{"name":"CLIENTAPPLICATIONURL","description":"Url to your Clientexec installation","hostingonly":false},{"name":"CLIENTNAME","description":"Client''s First and Last Name","hostingonly":false},{"name":"FIRSTNAME","description":"Client''s First name","hostingonly":false},{"name":"CLIENTEMAIL","description":"Email Address","hostingonly":false},{"name":"ORGANIZATION","description":"Client''s Organization","hostingonly":false},{"name":"PACKAGEGROUPNAME","description":"Client''s Plan group","hostingonly":false},{"name":"PLANNAME","description":"Client''s Plan","hostingonly":false},{"name":"PACKAGEID","description":"Client''s Plan ID","hostingonly":false},{"name":"NEXTDUEDATE","description":"Client''s Plan next billing date","hostingonly":false},{"name":"USERPACKAGEID","description":"Client''s Package ID","hostingonly":false},{"name":"DATE","description":"Date payment is due."},{"name":"SENTDATE","description":"Date invoice was last sent."},{"name":"INVOICENUMBER","description":"Invoice Number"},{"name":"SUBSCRIPTION_ID","description":"Subscription Id"},{"name":"INVOICEDESCRIPTION","description":"Invoice Description"},{"name":"TAX","description":"Invoice Tax"},{"name":"AMOUNT_EX_TAX","description":"The total price excluding taxes."},{"name":"AMOUNT","description":"The total price due."},{"name":"PAID","description":"The amount already paid of the invoice."},{"name":"BALANCEDUE","description":"The balance due of the invoice."},{"name":"RAW_AMOUNT","description":"The total price excluding currency symbol."},{"name":"DIRECTPAYMENTLINK","description":"Direct Payment Link<br/><i style=''font-size:smaller;''>Add direct link for invoice payment. Only visible when applicable billing plugin that support this method of payment is used</i>"},{"name":"FORGOTPASSWORDURL","description":"URL to retrieve forgotten password.","hostingonly":false}]', 'Click to view available tags', 240, 320),
(51, 'Expiring CC Template Tags', '[{"name":"CLIENTNAME","description":"Client''s First and Last Name"},{"name":"FIRSTNAME","description":"Client''s First name"},{"name":"CLIENTEMAIL","description":"Email Address"},{"name":"CCLASTFOUR","description":"The last four digits of the customer''s credit card."},{"name":"CCEXPDATE","description":"The expiration date of the customer''s credit card."},{"name":"CLIENTAPPLICATIONURL","description":"Url to your Clientexec installation"},{"name":"FORGOTPASSWORDURL","description":"URL to retrieve forgotten password."},{"name":"COMPANYNAME","description":"Company name"},{"name":"COMPANYADDRESS","description":"Company address"},{"name":"BILLINGEMAIL","description":"Email address for billing inquiries"},{"name":"CUSTOMPROFILE_xxxx","description":"Custom Profile<br/><i style=''font-size:smaller;''>where xxx is a profile custom field name (i.e. [CUSTOMPROFILE_somename])</i>"}]', 'Click to view available tags', 240, 320),
(52, 'Domain Reminder Tags', '[{"name":"CLIENTNAME","description":"Client''s First and Last Name"},{"name":"FIRSTNAME","description":"Client''s First name"},{"name":"CLIENTEMAIL","description":"Email Address"},{"name":"DOMAIN","description":"The client domain name."},{"name":"EXPDATE","description":"The expiry date of the domain."},{"name":"COMPANYNAME","description":"Company name"},{"name":"COMPANYADDRESS","description":"Company address"},{"name":"FORGOTPASSWORDURL","description":"URL to retrieve forgotten password."},{"name":"BILLINGEMAIL","description":"Email address for billing inquiries"},{"name":"CLIENTAPPLICATIONURL","description":"Url to your Clientexec installation"},{"name":"CUSTOMPROFILE_xxxx","description":"where xxx is a profile custom field name."}]', 'Click to view available tags', 240, 320),
(53, 'Reset Password Tags', '[{"name":"CLIENTNAME","description":"Client''s First and Last Name"},{"name":"FIRSTNAME","description":"Client''s First name"},{"name":"CLIENTEMAIL","description":"Email Address"},{"name":"COMPANYNAME","description":"Company name"},{"name":"COMPANYADDRESS","description":"Company address"},{"name":"REQUESTIP","description":"IP of the machine which requested the password change."},{"name":"CONFIRMATION URL","description":"URL that user must press to confirm the password change"},{"name":"CUSTOMPROFILE_xxxx","description":"Custom Profile<br/><i style=''font-size:smaller;''>where xxx is a profile custom field name (i.e. [CUSTOMPROFILE_somename])</i>"}]', 'Click to view available tags', 240, 320),
(54, 'Get New Password Tags', '[{"name":"CLIENTNAME","description":"Client''s First and Last Name"},{"name":"FIRSTNAME","description":"Client''s First name"},{"name":"CLIENTEMAIL","description":"Email Address"},{"name":"NEWPASSWORD","description":"New Temporary Password"},{"name":"CLIENTEXEC URL","description":"Url to Clientexec"},{"name":"COMPANYNAME","description":"Company name"},{"name":"COMPANYADDRESS","description":"Company address"},{"name":"COMPANYEMAIL","description":"Company Email address"}]', 'Click to view available tags', 240, 320),
(55, 'Rejection E-Mail Tags', '[{"name":"CLIENTNAME","description":"Client''s First and Last Name"},{"name":"FIRSTNAME","description":"Client''s First name"},{"name":"COMPANYNAME","description":"Company name"},{"name":"COMPANYADDRESS","description":"Company address"},{"name":"COMPANYURL","description":"URL to your web site"},{"name":"SUPPORTEMAIL","description":"E-mail to support staff"},{"name":"CLIENTAPPLICATIONURL","description":"URL to Clientexec."}]', 'Click to view available tags', 240, 320),
(56, 'Team Status Reply E-Mail Tags', '[{"name":"TEAMSTATUS","description":"Team status used to reply"},{"name":"REPLIEDTEAMSTATUSUSERNAME","description":"Name of the user who''s team status was replied"},{"name":"REPLIEDTEAMSTATUSDATE","description":"Date of the team status replied"},{"name":"REPLIEDTEAMSTATUS","description":"Team status replied"}]', 'Click to view available tags', 240, 320),
(57, 'Team Status Activity E-Mail Tags', '[{"name":"TEAMSTATUSDYNAMICBLOCK","description":"Team status activity"}]', 'Click to view available tags', 240, 320),
(58, 'Team Status Dynamic Block Tags', '[{"name":"TEAMSTATUSUSERNAME","description":"Name of the user who post the team status"},{"name":"TEAMSTATUS","description":"Team status text"},{"name":"TEAMSTATUSDATE","description":"Date of status"},{"name":"TEAMSTATUSREPLYINFO","description":"Reply Info<br/><i style=''font-size:smaller;''>Replied Message"}]', 'Click to view available tags', 240, 320),
(59, 'Team Status Activity Reply Tags', '[{"name":"REPLIEDTEAMSTATUSUSERNAME","description":"Name of the user who''s team status was replied"}]', 'Click to view available tags', 240, 320),
(60, 'Ticket Template Tags', '[{"name":"CLIENTNAME","description":"Client''s First and Last Name"},{"name":"FIRSTNAME","description":"Client''s First name"},{"name":"CLIENTEMAIL","description":"Email Address"},{"name":"TICKETURL","description":"Direct URL to Ticket"},{"name":"TICKETNUMBER","description":"Ticket Number"},{"name":"TICKETSUBJECT","description":"Ticket Subject"},{"name":"DESCRIPTION","description":"Ticket Description"},{"name":"CLIENTAPPLICATIONURL","description":"Url to your Clientexec installation"},{"name":"COMPANYNAME","description":"Company name"},{"name":"COMPANYADDRESS","description":"Company address"},{"name":"CUSTOMPROFILE_xxxx","description":"Custom Profile<br/><i style=''font-size:smaller;''>where xxx is a profile custom field name (i.e. [CUSTOMPROFILE_somename])</i>"}]', 'Click to view available tags', 240, 320),
(61, 'Feedback Template Tags', '[{"name":"TICKETNUMBER","description":"Ticket Number"},{"name":"TICKETSUBJECT","description":"Ticket Subject"},{"name":"CLIENTNAME","description":"Client''s First and Last Name"},{"name":"FIRSTNAME","description":"Client''s First name"},{"name":"CLIENTEMAIL","description":"Email Address"},{"name":"COMPANYNAME","description":"Company name"},{"name":"COMPANYADDRESS","description":"Company address"},{"name":"RATEEXCELLENTSERVICEURL","description":"URL to rate <b>Excellent</b> feedback"},{"name":"RATEGOODSERVICEURL","description":"URL to rate <b>Good</b> feedback"},{"name":"RATENOTGREATSERVICEURL","description":"URL to rate <b>Average</b> feedback"},{"name":"RATEPOORSERVICEURL","description":"URL to rate <b>Poor</b> feedback"},{"name":"CUSTOMPROFILE_xxxx","description":"Custom Profile<br/><i style=''font-size:smaller;''>where xxx is a profile custom field name (i.e. [CUSTOMPROFILE_somename])</i>"}]', 'Click to view available tags', 240, 320),
(62, 'AutoClose Service Template Tags', '[{"name":"CLIENTNAME","description":"Client''s First and Last Name"},{"name":"FIRSTNAME","description":"Client''s First name"},{"name":"CLIENTEMAIL","description":"Email Address"},{"name":"COMPANYNAME","description":"Company name"},{"name":"COMPANYADDRESS","description":"Company address"},{"name":"TICKETNUMBER","description":"Ticket Number"},{"name":"CUSTOMPROFILE_xxxx","description":"Custom Profile<br/><i style=''font-size:smaller;''>where xxx is a profile custom field name (i.e. [CUSTOMPROFILE_somename])</i>"}]', 'Click to view available tags', 240, 320),
(63, 'Notify Support For New High Priority Ticket Template Tags', '[{"name":"CLIENTNAME","description":"Client''s First and Last Name"},{"name":"CLIENTEMAIL","description":"Email Address"},{"name":"COMPANYNAME","description":"Company name"},{"name":"COMPANYADDRESS","description":"Company address"},{"name":"TICKETNUMBER","description":"Ticket Number"},{"name":"TICKETSUBJECT","description":"Ticket Subject"},{"name":"TICKETTYPE","description":"Ticket Type"},{"name":"DESCRIPTION","description":"Ticket Description"},{"name":"CLIENTAPPLICATIONURL","description":"Url to your Clientexec installation"}]', 'Click to view available tags', 240, 320),
(64, 'Notify Customer For New Ticket Template Tags', '[{"name":"CLIENTNAME","description":"Client''s First and Last Name"},{"name":"TICKETNUMBER","description":"Ticket Number"},{"name":"TICKETSUBJECT","description":"Ticket Subject"},{"name":"TICKETTYPE","description":"Ticket Type"},{"name":"DESCRIPTION","description":"Ticket Description"},{"name":"COMPANYNAME","description":"Company name"},{"name":"COMPANYADDRESS","description":"Company address"}]', 'Click to view available tags', 240, 320),
(65, 'Notify Assignee For Ticket Reply Template Tags', '[{"name":"CLIENTNAME","description":"Client''s First and Last Name"},{"name":"TICKETNUMBER","description":"Ticket Number"},{"name":"TICKETURL","description":"Direct URL to Ticket"},{"name":"DESCRIPTION","description":"Ticket Description"}]', 'Click to view available tags', 240, 320),
(66, 'Notify For New FeedBack Template Tags', '[{"name":"CLIENTNAME","description":"Client''s First and Last Name"},{"name":"FIRSTNAME","description":"Client''s First name"},{"name":"TICKETNUMBER","description":"Ticket Number"},{"name":"DESCRIPTION","description":"Ticket Description"}]', 'Click to view available tags', 240, 320),
(50, 'Invoice Template Tags', '[{"name":"DATE","description":"Date payment is due."},{"name":"SENTDATE","description":"Date invoice was last sent."},{"name":"CLIENTNAME","description":"Client''s First and Last Name"},{"name":"FIRSTNAME","description":"Client''s First name"},{"name":"CLIENTEMAIL","description":"Email Address"},{"name":"CLIENTNUMBER","description":"User Id"},{"name":"INVOICENUMBER","description":"Invoice Number"},{"name":"SUBSCRIPTION_ID","description":"Subscription Id"},{"name":"DIRECTPAYMENTLINK","description":"Direct Payment Link<br/><i style=''font-size:smaller;''>Add direct link for invoice payment. Only visible when applicable billing plugin that support this method of payment is used</i>"},{"name":"INVOICEHASH","description":"Invoice Hash<br/><i style=''font-size:smaller;''>A hash for the invoice in case you need to send one</i>"},{"name":"INVOICEDESCRIPTION","description":"Invoice Description"},{"name":"TAX","description":"Invoice Tax"},{"name":"AMOUNT_EX_TAX","description":"The total price excluding taxes."},{"name":"AMOUNT","description":"The total price due."},{"name":"PAID","description":"The amount already paid of the invoice."},{"name":"BALANCEDUE","description":"The balance due of the invoice."},{"name":"RAW_AMOUNT","description":"The total price excluding currency symbol."},{"name":"PMTREFERENCE","description":"Payment Reference<br/><i style=''font-size:smaller;''>The value used in the payment reference field of the invoice</i>"},{"name":"PMTTRANSACTIONS","description":"Payment Transactions<br/><i style=''font-size:smaller;''>The transactions applied to the invoice.</i>"},{"name":"PMTLASTTRANSACTION","description":"Last Payment Transaction<br/><i style=''font-size:smaller;''>The last transaction applied to the invoice.</i>"},{"name":"CLIENTAPPLICATIONURL","description":"URL to Clientexec."},{"name":"FORGOTPASSWORDURL","description":"URL to retrieve forgotten password."},{"name":"COMPANYNAME","description":"Company name"},{"name":"COMPANYADDRESS","description":"Company address"},{"name":"BILLINGEMAIL","description":"E-mail address for billing inquiries"},{"name":"CUSTOMPROFILE_xxxx","description":"Custom Profile<br/><i style=''font-size:smaller;''>where xxx is a profile custom field name (i.e. [CUSTOMPROFILE_somename])</i>"}]', 'Click to view available tags', 240, 320),
(67, 'Notify For New Order Tags', '[{"name":"ORDERINFO","description":"Complete Order Information"}]', 'Click to view available tags', 240, 320),
(68, 'Notify Package Suspension Tags', '[{"name":"CLIENTNAME","description":"Client''s first and last name","hostingonly":false},{"name":"FIRSTNAME","description":"Client''s First name","hostingonly":false},{"name":"LASTNAME","description":"Client''s Last name","hostingonly":false},{"name":"CLIENTEMAIL","description":"Client''s Email","hostingonly":false},{"name":"ORGANIZATION","description":"Client''s Organization","hostingonly":false},{"name":"CCLASTFOUR","description":"The last four digits of the customer''s credit card."},{"name":"CCEXPDATE","description":"The expiration date of the customer''s credit card."},{"name":"CLIENTAPPLICATIONURL","description":"Url to your Clientexec installation"},{"name":"FORGOTPASSWORDURL","description":"URL to retrieve forgotten password."},{"name":"BILLINGEMAIL","description":"Email address for billing inquiries"},{"name":"SUPPORTEMAIL","description":"E-mail to support staff"},{"name":"COMPANYNAME","description":"Company name"},{"name":"COMPANYADDRESS","description":"Company address"},{"name":"PACKAGEID","description":"Client''s Plan ID","hostingonly":false},{"name":"TICKETNUMBER","description":"Ticket Number"},{"name":"DATE","description":"Date payment is due."},{"name":"CUSTOMPROFILE_xxxx","description":"Custom Profile<br/><i style=''font-size:smaller;''>where xxx is a profile custom field name (i.e. [CUSTOMPROFILE_somename])</i>","hostingonly":false},{"name":"CUSTOMPACKAGE_xxxx","description":"Custom Package Field<br/><i style=''font-size:smaller;''>Where xxx is custom package field name (i.e. [CUSTOMPACKAGE_somename])</i>","hostingonly":false}]', 'Click to view available tags', 240, 320),
(69, 'Package Cancellation Tags', '[{"name":"CLIENTNAME","description":"Client''s First and Last Name"},{"name":"PACKAGEREFERENCE","description":"Full reference of the customer package."},{"name":"COMPANYNAME","description":"Company name"},{"name":"COMPANYADDRESS","description":"Company address"},{"name":"CLIENTAPPLICATIONURL","description":"Url to your Clientexec installation"}]', 'Click to view available tags', 240, 320);

-- --------------------------------------------------------

--
-- Table structure for table `invoice`
--

CREATE TABLE `invoice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customerid` int(11) NOT NULL DEFAULT '0',
  `billdate` date NOT NULL DEFAULT '0000-00-00',
  `description` varchar(200) NOT NULL DEFAULT '',
  `currency` varchar(5) DEFAULT '0',
  `amount` decimal(25,3) NOT NULL DEFAULT '0.000',
  `subtotal` decimal(25,3) NOT NULL DEFAULT '0.000',
  `balance_due` decimal(25,3) NOT NULL DEFAULT '0.000',
  `sent` tinyint(4) NOT NULL DEFAULT '0',
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `archive` tinyint(4) NOT NULL DEFAULT '0',
  `datecreated` date DEFAULT NULL,
  `sentdate` date DEFAULT NULL,
  `datepaid` date DEFAULT NULL,
  `tax` decimal(25,3) NOT NULL DEFAULT '0.000',
  `taxname` varchar(20) NOT NULL DEFAULT '',
  `tax2` decimal(25,3) NOT NULL DEFAULT '0.000',
  `tax2name` varchar(20) NOT NULL DEFAULT '',
  `tax2compound` tinyint(4) NOT NULL DEFAULT '0',
  `processorid` varchar(255) NOT NULL DEFAULT '',
  `pluginused` varchar(30) NOT NULL DEFAULT 'none',
  `checknum` varchar(50) NOT NULL,
  `note` text NOT NULL,
  `subscription_id` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customerid` (`customerid`),
  KEY `status` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `invoiceentry`
--

CREATE TABLE `invoiceentry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customerid` int(11) NOT NULL DEFAULT '0',
  `description` varchar(200) NOT NULL DEFAULT '',
  `detail` text NOT NULL,
  `invoiceid` int(11) NOT NULL DEFAULT '0',
  `date` date NOT NULL DEFAULT '0000-00-00',
  `period_start` date DEFAULT NULL,
  `period_end` date DEFAULT NULL,
  `billingtypeid` int(11) NOT NULL DEFAULT '0',
  `is_prorating` tinyint(4) NOT NULL DEFAULT '0',
  `price` decimal(25,3) NOT NULL DEFAULT '0.000',
  `price_percent` decimal(25,3) NOT NULL DEFAULT '0.000',
  `quantity` decimal(25,3) NOT NULL DEFAULT '1.000',
  `recurring` int(11) NOT NULL DEFAULT '0',
  `recurringappliesto` int(11) DEFAULT '0',
  `appliestoid` int(11) NOT NULL DEFAULT '0',
  `coupon_applicable_to` tinyint(4) NOT NULL DEFAULT '0',
  `includenextpayment` tinyint(4) NOT NULL DEFAULT '0',
  `paymentterm` int(11) NOT NULL DEFAULT '0',
  `setup` tinyint(4) NOT NULL DEFAULT '0',
  `addon_setup` tinyint(4) NOT NULL DEFAULT '0',
  `taxable` tinyint(4) NOT NULL DEFAULT '0',
  `taxamount` decimal(25,3) NOT NULL DEFAULT '0.000',
  PRIMARY KEY (`id`),
  KEY `invoiceid-appliestoid` (`invoiceid`,`appliestoid`),
  KEY `appliestoid` (`appliestoid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Maintain information of work completed for customer' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `invoicetransaction`
--

CREATE TABLE `invoicetransaction` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoiceid` int(11) NOT NULL DEFAULT '0',
  `accepted` tinyint(4) NOT NULL DEFAULT '0',
  `response` text NOT NULL,
  `transactiondate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `transactionid` varchar(100) NOT NULL DEFAULT 'NA',
  `action` varchar(10) NOT NULL DEFAULT 'none',
  `last4` varchar(5) NOT NULL DEFAULT '0000',
  `amount` decimal(25,3) DEFAULT '0.000',
  PRIMARY KEY (`id`),
  KEY `invoiceid` (`invoiceid`),
  KEY `transactionid` (`transactionid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `kb_articles`
--

CREATE TABLE `kb_articles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `tags` text COLLATE utf8mb4_unicode_ci,
  `author` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `publisher` int(11) NOT NULL,
  `is_draft` tinyint(4) NOT NULL DEFAULT '0',
  `access` tinyint(4) NOT NULL DEFAULT '0',
  `is_ticket_summary` tinyint(4) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `modified` datetime NOT NULL,
  `modified_user_id` int(11) NOT NULL,
  `rating` float(7,2) NOT NULL DEFAULT '0.00',
  `ratingvisitors` int(11) NOT NULL DEFAULT '0',
  `totalvisitors` int(11) NOT NULL DEFAULT '0',
  `categoryid` int(11) NOT NULL DEFAULT '0',
  `includefaq` tinyint(2) NOT NULL DEFAULT '0',
  `myorder` int(11) NOT NULL DEFAULT '10',
  `seo_desc` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `seo_keywords` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `i_company_id` (`company_id`),
  FULLTEXT KEY `title` (`title`,`excerpt`,`content`,`tags`),
  FULLTEXT KEY `tags` (`tags`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `kb_articlesrelated`
--

CREATE TABLE `kb_articlesrelated` (
  `articleid` int(11) NOT NULL,
  `relatedid` int(11) NOT NULL,
  PRIMARY KEY (`articleid`,`relatedid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `kb_articles_comments`
--

CREATE TABLE `kb_articles_comments` (
  `commentid` int(11) NOT NULL AUTO_INCREMENT,
  `articleid` int(11) NOT NULL,
  `username` varchar(100) NOT NULL,
  `added` datetime NOT NULL,
  `email` varchar(250) NOT NULL,
  `comment` text NOT NULL,
  `is_approved` tinyint(4) NOT NULL DEFAULT '0',
  `is_internal` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`commentid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `kb_articles_files`
--

CREATE TABLE `kb_articles_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `articleid` int(11) NOT NULL,
  `filename` varchar(50) NOT NULL,
  `dateadded` datetime NOT NULL,
  `filekey` varchar(16) NOT NULL,
  `userid` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `filekey` (`filekey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `kb_articles_rate`
--

CREATE TABLE `kb_articles_rate` (
  `articleid` int(11) NOT NULL,
  `used_ips` varchar(32) NOT NULL,
  PRIMARY KEY (`articleid`,`used_ips`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `kb_articles_tickettypes`
--

CREATE TABLE `kb_articles_tickettypes` (
  `article_id` int(11) NOT NULL,
  `tickettype_id` int(11) NOT NULL,
  PRIMARY KEY (`article_id`,`tickettype_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `kb_articles_views`
--

CREATE TABLE `kb_articles_views` (
  `articleid` int(11) NOT NULL,
  `userid` varchar(11) NOT NULL,
  `ip` varchar(100) NOT NULL,
  PRIMARY KEY (`articleid`,`userid`,`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `kb_categories`
--

CREATE TABLE `kb_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL,
  `description` varchar(100) DEFAULT NULL,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `counter` int(11) NOT NULL DEFAULT '0',
  `staffonly` tinyint(4) NOT NULL DEFAULT '0',
  `is_series` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'articles are meant to be followed as a series',
  `is_global_series` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'view all global series together in sidebar',
  `my_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `i_company_id` (`company_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `kb_categories`
--

INSERT INTO `kb_categories` VALUES
(1, 0, 'Tips and Tricks', NULL, -1, 0, 0, 0, 0, 0),
(2, 0, 'Common Issues', NULL, -1, 0, 0, 0, 0, 0),
(3, 0, 'Maintenance', NULL, -1, 0, 0, 0, 0, 0),
(4, 0, 'Configuration', NULL, -1, 0, 0, 0, 0, 0),
(5, 0, 'Installation', NULL, -1, 0, 0, 0, 0, 0),
(6, 0, 'Billing', NULL, -1, 0, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `nameserver`
--

CREATE TABLE `nameserver` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `serverid` int(11) NOT NULL DEFAULT '0',
  `ip` varchar(50) NOT NULL DEFAULT '',
  `hostname` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `notifications_events`
--

CREATE TABLE `notifications_events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `templateid` int(11) NOT NULL,
  `rules` text NOT NULL,
  `enabled` tinyint(4) NOT NULL DEFAULT '1',
  `fromName` varchar(255) DEFAULT NULL,
  `fromEmail` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `object_customField`
--

CREATE TABLE `object_customField` (
  `objectid` int(11) NOT NULL DEFAULT '0',
  `customFieldId` int(11) NOT NULL DEFAULT '0',
  `value` text,
  PRIMARY KEY (`objectid`,`customFieldId`),
  KEY `customFieldId` (`customFieldId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `package`
--

CREATE TABLE `package` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `planname` varchar(45) NOT NULL,
  `description` text NOT NULL,
  `asset_html` text NOT NULL,
  `highlight` tinyint(1) NOT NULL DEFAULT '0',
  `planid` int(11) NOT NULL DEFAULT '0',
  `showpackage` smallint(6) NOT NULL DEFAULT '1',
  `pricing` text NOT NULL,
  `automaticactivation` tinyint(4) DEFAULT '1',
  `allowdirectlink` tinyint(4) NOT NULL DEFAULT '1',
  `sendwelcome` tinyint(4) NOT NULL DEFAULT '1',
  `stockInfo` text NOT NULL,
  `emailTemplate` smallint(5) NOT NULL DEFAULT '0',
  `bundledProducts` text NOT NULL,
  `advanced` text NOT NULL,
  `signup_order` int(11) NOT NULL DEFAULT '1',
  `openticket` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `packageaddon`
--

CREATE TABLE `packageaddon` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `package_id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `description` text NOT NULL,
  `plugin_var` varchar(50) NOT NULL,
  `order` int(11) NOT NULL DEFAULT '0',
  `taxable` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `packageaddon_prices`
--

CREATE TABLE `packageaddon_prices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `packageaddon_id` int(11) NOT NULL DEFAULT '0',
  `sortkey` int(11) NOT NULL DEFAULT '0',
  `detail` varchar(50) NOT NULL DEFAULT '',
  `plugin_var_value` varchar(50) NOT NULL DEFAULT '',
  `price` text NOT NULL,
  `openticket` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `package_server`
--

CREATE TABLE `package_server` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `package_id` int(11) NOT NULL DEFAULT '0',
  `server_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `package_upgrades`
--

CREATE TABLE `package_upgrades` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `origin_package_id` int(11) NOT NULL DEFAULT '0',
  `promotion_id` int(11) NOT NULL DEFAULT '0',
  `package_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `package_variable`
--

CREATE TABLE `package_variable` (
  `packageid` int(11) NOT NULL DEFAULT '0',
  `varname` varchar(250) NOT NULL DEFAULT '',
  `value` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`packageid`,`varname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `password_resets`
--

CREATE TABLE `password_resets` (
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  KEY `password_resets_email_index` (`email`),
  KEY `password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `permissions`
--

CREATE TABLE `permissions` (
  `subject_id` int(11) NOT NULL DEFAULT '0',
  `is_group` tinyint(4) NOT NULL DEFAULT '0',
  `permission` varchar(100) NOT NULL DEFAULT '',
  `target_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`subject_id`,`is_group`,`permission`,`target_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `permissions`
--

INSERT INTO `permissions` VALUES
(-1, 1, 'knowledgebase_postComments', 0),
(-1, 1, 'support_submit_ticket', 0),
(-1, 1, 'support_view', 0),
(1, 1, 'billing_apply_account_credit', 0),
(1, 1, 'billing_automatic_cc_charge', 0),
(1, 1, 'billing_masspay', 0),
(1, 1, 'billing_recurring_overview', 0),
(1, 1, 'billing_renew_package', 0),
(1, 1, 'billing_send_invoices', 0),
(1, 1, 'billing_view', 0),
(1, 1, 'clients_cancel_packages', 0),
(1, 1, 'clients_change_package_password', 0),
(1, 1, 'clients_edit_credit_card', 0),
(1, 1, 'clients_edit_customers', 0),
(1, 1, 'clients_edit_payment_type', 0),
(1, 1, 'clients_send_welcome_email', 0),
(1, 1, 'clients_trigger_package_actions', 0),
(1, 1, 'clients_upgrade_customer_packages', 0),
(1, 1, 'clients_view', 0),
(1, 1, 'clients_view_announcements', 0),
(1, 1, 'clients_view_domains', 0),
(1, 1, 'clients_view_emails', 0),
(1, 1, 'domains_deletens', 0),
(1, 1, 'domains_dnssettings', 0),
(1, 1, 'domains_editns', 0),
(1, 1, 'domains_lock', 0),
(1, 1, 'domains_manage_domains', 0),
(1, 1, 'domains_nameservers', 0),
(1, 1, 'domains_registerns', 0),
(1, 1, 'domains_transfer', 0),
(1, 1, 'domains_transfer_key', 0),
(1, 1, 'domains_updatecontactinfo', 0),
(1, 1, 'domains_updatedns', 0),
(1, 1, 'domains_updatens', 0),
(1, 1, 'domains_view', 0),
(1, 1, 'domains_viewcontactinfo', 0),
(1, 1, 'files_view', 0),
(1, 1, 'home_view', 0),
(1, 1, 'knowledgebase_postComments', 0),
(1, 1, 'knowledgebase_view', 0),
(1, 1, 'knowledgebase_viewArticle', 0),
(1, 1, 'knowledgebase_viewCategory', 0),
(1, 1, 'support_close_tickets', 0),
(1, 1, 'support_reopen_ticket', 0),
(1, 1, 'support_submit_ticket', 0),
(1, 1, 'support_view', 0),
(1, 1, 'support_view_closed_tickets', 0),
(1, 1, 'support_view_eventlog', 0),
(1, 1, 'support_view_live_chat', 0),
(2, 1, 'knowledgebase_add_article', 0),
(2, 1, 'knowledgebase_add_category', 0),
(2, 1, 'knowledgebase_manageArticles', 0),
(2, 1, 'knowledgebase_manageCategories', 0),
(2, 1, 'knowledgebase_manageComments', 0),
(2, 1, 'knowledgebase_postComments', 0),
(2, 1, 'knowledgebase_setStatus', 0),
(2, 1, 'knowledgebase_view', 0),
(2, 1, 'knowledgebase_viewArticle', 0),
(2, 1, 'knowledgebase_viewCategory', 0),
(3, 1, 'admin_view', 0),
(3, 1, 'clients_add_notes', 0),
(3, 1, 'clients_delete_notes', 0),
(3, 1, 'clients_edit_payment_type', 0),
(3, 1, 'clients_email_customers', 0),
(3, 1, 'clients_upgrade_customer_packages', 0),
(3, 1, 'clients_view', 0),
(3, 1, 'clients_view_customers', 0),
(3, 1, 'clients_view_domains', 0),
(3, 1, 'clients_view_eventlog', 0),
(3, 1, 'domains_autorenew', 0),
(3, 1, 'domains_delete', 0),
(3, 1, 'domains_deletens', 0),
(3, 1, 'domains_dnssettings', 0),
(3, 1, 'domains_editns', 0),
(3, 1, 'domains_lock', 0),
(3, 1, 'domains_manage_domains', 0),
(3, 1, 'domains_nameservers', 0),
(3, 1, 'domains_registerns', 0),
(3, 1, 'domains_transfer', 0),
(3, 1, 'domains_transfer_key', 0),
(3, 1, 'domains_updatecontactinfo', 0),
(3, 1, 'domains_updatens', 0),
(3, 1, 'domains_view', 0),
(3, 1, 'domains_viewcontactinfo', 0),
(3, 1, 'files_view', 0),
(3, 1, 'home_view', 0),
(3, 1, 'knowledgebase_add_article', 0),
(3, 1, 'knowledgebase_postComments', 0),
(3, 1, 'knowledgebase_setStatus', 0),
(3, 1, 'knowledgebase_view', 0),
(3, 1, 'knowledgebase_viewArticle', 0),
(3, 1, 'knowledgebase_viewCategory', 0),
(3, 1, 'reports_view', 0),
(3, 1, 'support_close_tickets', 0),
(3, 1, 'support_delete_trouble_ticket', 0),
(3, 1, 'support_edit_ticket', 0),
(3, 1, 'support_reopen_ticket', 0),
(3, 1, 'support_submit_ticket', 0),
(3, 1, 'support_view', 0),
(3, 1, 'support_view_assigned_department_tickets', 0),
(3, 1, 'support_view_closed_tickets', 0),
(3, 1, 'support_view_eventlog', 0),
(4, 1, 'admin_view', 0),
(4, 1, 'billing_add_variable_payment', 0),
(4, 1, 'billing_apply_account_credit', 0),
(4, 1, 'billing_create', 0),
(4, 1, 'billing_credit_invoices', 0),
(4, 1, 'billing_delete_recurring', 0),
(4, 1, 'billing_edit_billing_types', 0),
(4, 1, 'billing_edit_recurring', 0),
(4, 1, 'billing_mark_invoice_paid', 0),
(4, 1, 'billing_process_invoices', 0),
(4, 1, 'billing_recurring_overview', 0),
(4, 1, 'billing_refund_invoices', 0),
(4, 1, 'billing_send_invoices', 0),
(4, 1, 'billing_show_billing_cycles', 0),
(4, 1, 'billing_show_billing_types', 0),
(4, 1, 'billing_uninvoiced_work', 0),
(4, 1, 'billing_view', 0),
(4, 1, 'billing_void_invoices', 0),
(4, 1, 'clients_add_notes', 0),
(4, 1, 'clients_create_customers', 0),
(4, 1, 'clients_create_customer_packages', 0),
(4, 1, 'clients_delete_customers', 0),
(4, 1, 'clients_delete_notes', 0),
(4, 1, 'clients_edit_account_credit', 0),
(4, 1, 'clients_edit_credit_card', 0),
(4, 1, 'clients_edit_customers', 0),
(4, 1, 'clients_edit_customer_packages', 0),
(4, 1, 'clients_edit_payment_type', 0),
(4, 1, 'clients_email_customers', 0),
(4, 1, 'clients_passphrase_cc', 0),
(4, 1, 'clients_upgrade_customer_packages', 0),
(4, 1, 'clients_view', 0),
(4, 1, 'clients_view_customers', 0),
(4, 1, 'clients_view_domains', 0),
(4, 1, 'clients_view_eventlog', 0),
(4, 1, 'domains_autorenew', 0),
(4, 1, 'domains_delete', 0),
(4, 1, 'domains_deletens', 0),
(4, 1, 'domains_dnssettings', 0),
(4, 1, 'domains_editns', 0),
(4, 1, 'domains_lock', 0),
(4, 1, 'domains_manage_domains', 0),
(4, 1, 'domains_nameservers', 0),
(4, 1, 'domains_registerns', 0),
(4, 1, 'domains_transfer', 0),
(4, 1, 'domains_transfer_key', 0),
(4, 1, 'domains_updatecontactinfo', 0),
(4, 1, 'domains_updatens', 0),
(4, 1, 'domains_view', 0),
(4, 1, 'domains_viewcontactinfo', 0),
(4, 1, 'files_view', 0),
(4, 1, 'home_view', 0),
(4, 1, 'reports_view', 0),
(4, 1, 'support_close_tickets', 0),
(4, 1, 'support_delete_trouble_ticket', 0),
(4, 1, 'support_edit_ticket', 0),
(4, 1, 'support_reopen_ticket', 0),
(4, 1, 'support_view', 0),
(4, 1, 'support_view_assigned_department_tickets', 0),
(4, 1, 'support_view_closed_tickets', 0),
(5, 1, 'admin_view', 0),
(5, 1, 'clients_add_notes', 0),
(5, 1, 'clients_cancel_packages', 0),
(5, 1, 'clients_change_package_password', 0),
(5, 1, 'clients_create_customers', 0),
(5, 1, 'clients_create_customer_packages', 0),
(5, 1, 'clients_delete_customers', 0),
(5, 1, 'clients_delete_notes', 0),
(5, 1, 'clients_edit_credit_card', 0),
(5, 1, 'clients_edit_customers', 0),
(5, 1, 'clients_edit_customer_packages', 0),
(5, 1, 'clients_edit_payment_type', 0),
(5, 1, 'clients_email_customers', 0),
(5, 1, 'clients_send_welcome_email', 0),
(5, 1, 'clients_trigger_package_actions', 0),
(5, 1, 'clients_upgrade_customer_packages', 0),
(5, 1, 'clients_view', 0),
(5, 1, 'clients_view_announcements', 0),
(5, 1, 'clients_view_customers', 0),
(5, 1, 'clients_view_domains', 0),
(5, 1, 'clients_view_eventlog', 0),
(5, 1, 'domains_autorenew', 0),
(5, 1, 'domains_delete', 0),
(5, 1, 'domains_deletens', 0),
(5, 1, 'domains_dnssettings', 0),
(5, 1, 'domains_editns', 0),
(5, 1, 'domains_lock', 0),
(5, 1, 'domains_manage_domains', 0),
(5, 1, 'domains_nameservers', 0),
(5, 1, 'domains_registerns', 0),
(5, 1, 'domains_transfer', 0),
(5, 1, 'domains_transfer_key', 0),
(5, 1, 'domains_updatecontactinfo', 0),
(5, 1, 'domains_updatedns', 0),
(5, 1, 'domains_updatens', 0),
(5, 1, 'domains_view', 0),
(5, 1, 'domains_viewcontactinfo', 0),
(5, 1, 'files_view', 0),
(5, 1, 'home_view', 0),
(5, 1, 'knowledgebase_add_article', 0),
(5, 1, 'knowledgebase_add_category', 0),
(5, 1, 'knowledgebase_postComments', 0),
(5, 1, 'knowledgebase_setStatus', 0),
(5, 1, 'knowledgebase_view', 0),
(5, 1, 'knowledgebase_viewArticle', 0),
(5, 1, 'knowledgebase_viewCategory', 0),
(5, 1, 'reports_view', 0),
(5, 1, 'support_assign_tickets', 0),
(5, 1, 'support_close_tickets', 0),
(5, 1, 'support_delete_trouble_ticket', 0),
(5, 1, 'support_edit_ticket', 0),
(5, 1, 'support_reopen_ticket', 0),
(5, 1, 'support_reply_any_open_ticket', 0),
(5, 1, 'support_submit_ticket', 0),
(5, 1, 'support_view', 0),
(5, 1, 'support_view_assigned_department_tickets', 0),
(5, 1, 'support_view_assigned_otherdepartment_tickets', 0),
(5, 1, 'support_view_closed_tickets', 0),
(5, 1, 'support_view_eventlog', 0),
(5, 1, 'support_view_feedback', 0),
(5, 1, 'support_view_rates', 0),
(6, 1, 'billing_apply_account_credit', 0),
(6, 1, 'billing_automatic_cc_charge', 0),
(6, 1, 'billing_masspay', 0),
(6, 1, 'billing_recurring_overview', 0),
(6, 1, 'billing_renew_package', 0),
(6, 1, 'billing_send_invoices', 0),
(6, 1, 'billing_view', 0),
(6, 1, 'clients_cancel_packages', 0),
(6, 1, 'clients_change_package_password', 0),
(6, 1, 'clients_edit_credit_card', 0),
(6, 1, 'clients_edit_customers', 0),
(6, 1, 'clients_edit_payment_type', 0),
(6, 1, 'clients_send_welcome_email', 0),
(6, 1, 'clients_trigger_package_actions', 0),
(6, 1, 'clients_upgrade_customer_packages', 0),
(6, 1, 'clients_view', 0),
(6, 1, 'clients_view_announcements', 0),
(6, 1, 'clients_view_domains', 0),
(6, 1, 'clients_view_emails', 0),
(6, 1, 'domains_deletens', 0),
(6, 1, 'domains_dnssettings', 0),
(6, 1, 'domains_editns', 0),
(6, 1, 'domains_lock', 0),
(6, 1, 'domains_manage_domains', 0),
(6, 1, 'domains_nameservers', 0),
(6, 1, 'domains_registerns', 0),
(6, 1, 'domains_transfer', 0),
(6, 1, 'domains_transfer_key', 0),
(6, 1, 'domains_updatecontactinfo', 0),
(6, 1, 'domains_updatedns', 0),
(6, 1, 'domains_updatens', 0),
(6, 1, 'domains_view', 0),
(6, 1, 'domains_viewcontactinfo', 0),
(6, 1, 'files_view', 0),
(6, 1, 'home_view', 0),
(6, 1, 'knowledgebase_postComments', 0),
(6, 1, 'knowledgebase_view', 0),
(6, 1, 'knowledgebase_viewArticle', 0),
(6, 1, 'knowledgebase_viewCategory', 0),
(6, 1, 'support_close_tickets', 0),
(6, 1, 'support_reopen_ticket', 0),
(6, 1, 'support_submit_ticket', 0),
(6, 1, 'support_view', 0),
(6, 1, 'support_view_closed_tickets', 0),
(6, 1, 'support_view_eventlog', 0),
(6, 1, 'support_view_live_chat', 0);

-- --------------------------------------------------------

--
-- Table structure for table `plugin_custom_data`
--

CREATE TABLE `plugin_custom_data` (
  `name` varchar(50) NOT NULL,
  `value` text,
  `plugin_name` varchar(25) NOT NULL,
  `plugin_type` varchar(25) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`name`,`plugin_name`,`plugin_type`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `prices`
--

CREATE TABLE `prices` (
  `type` int(11) NOT NULL,
  `itemid` int(11) NOT NULL,
  `currency_abrv` varchar(4) NOT NULL,
  `pricing` text NOT NULL,
  PRIMARY KEY (`type`,`itemid`,`currency_abrv`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `productgroup_addon`
--

CREATE TABLE `productgroup_addon` (
  `productgroup_id` int(11) NOT NULL,
  `addon_id` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `product_addon`
--

CREATE TABLE `product_addon` (
  `product_id` int(11) NOT NULL,
  `addon_id` int(11) NOT NULL,
  `order` int(11) NOT NULL,
  `type` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `promotion`
--

CREATE TABLE `promotion` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` text NOT NULL,
  `insignup` smallint(1) NOT NULL DEFAULT '0',
  `name` varchar(50) NOT NULL DEFAULT '',
  `type` smallint(1) NOT NULL DEFAULT '0',
  `canDelete` tinyint(1) NOT NULL DEFAULT '1',
  `groupOrder` tinyint(3) NOT NULL DEFAULT '1',
  `style` varchar(56) NOT NULL DEFAULT 'default',
  `advanced` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `promotion`
--

INSERT INTO `promotion` VALUES
(1, 'This product group is used for all standard webhosting packages sold through our website.', 1, 'Shared Web Hosting', 1, 1, 1, 'compare', ''),
(2, 'This product group is used for all domain related services sold through our website.', 1, 'Domain Services', 3, 0, 99, 'default_domains', 'a:3:{s:13:"allowTransfer";i:1;s:15:"allowSelfManage";i:1;s:16:"disallowRegister";i:0;}'),
(3, 'This product group is used for all SSL related services sold through our website.', 0, 'SSL Certificates', 2, 0, 98, 'default', '');

-- --------------------------------------------------------

--
-- Table structure for table `promotion_customdomainfields`
--

CREATE TABLE `promotion_customdomainfields` (
  `promotionid` int(11) NOT NULL,
  `customid` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `recurringfee`
--

CREATE TABLE `recurringfee` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customerid` int(11) NOT NULL DEFAULT '0',
  `billingtypeid` int(11) NOT NULL DEFAULT '0',
  `packageaddon_prices_id` int(11) NOT NULL DEFAULT '0',
  `description` text,
  `detail` text,
  `amount` decimal(25,3) NOT NULL DEFAULT '0.000',
  `amount_percent` decimal(25,3) NOT NULL DEFAULT '0.000',
  `quantity` decimal(25,3) NOT NULL DEFAULT '1.000',
  `appliestoid` int(11) NOT NULL DEFAULT '0',
  `coupon_applicable_to` tinyint(4) NOT NULL DEFAULT '0',
  `nextbilldate` date DEFAULT NULL,
  `paymentterm` int(11) NOT NULL DEFAULT '0',
  `disablegenerate` tinyint(4) NOT NULL DEFAULT '0',
  `taxable` tinyint(4) NOT NULL DEFAULT '0',
  `monthlyusage` text,
  `recurring` tinyint(4) NOT NULL DEFAULT '1',
  `auto_charge_cc` tinyint(4) NOT NULL DEFAULT '1',
  `subscription_id` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `applies_recurring` (`appliestoid`,`recurring`),
  KEY `appliestoid` (`appliestoid`),
  KEY `paymentterm` (`paymentterm`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `report`
--

CREATE TABLE `report` (
  `name` varchar(80) NOT NULL,
  `public` tinyint(4) NOT NULL DEFAULT '0',
  `quickgraph` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `report`
--

INSERT INTO `report` VALUES
('CPanel_Accounts-Accounts.php', 0, 1),
('Account_Review-Accounts.php', 0, 1),
('Client_Monthly_Retention-Accounts.php', 0, 1),
('Customer_Countries-Accounts.php', 0, 1),
('Customer_Languages-Accounts.php', 0, 1),
('New_Customers-Accounts.php', 0, 1),
('Subscriber_Lifetime-Accounts.php', 0, 1),
('Import_Currency_Prices-Diagnostics.php', 0, 1),
('Migrate_Payment_Method-Diagnostics.php', 0, 1),
('Repair_Billing_Items-Diagnostics.php', 0, 1),
('Repair_Ticket_Dates-Diagnostics.php', 0, 1),
('Billing_Cycle_Income-Income.php', 0, 1),
('Client_Group_Income-Income.php', 0, 1),
('Country_Yearly_Income-Income.php', 0, 1),
('Coupon_Summary-Income.php', 0, 1),
('Income_By_Gateway-Income.php', 0, 1),
('Income_Growth-Income.php', 0, 1),
('Monthly_Income-Income.php', 0, 1),
('Monthly_Income_By_Type-Income.php', 0, 1),
('Overdue_Invoices-Income.php', 0, 1),
('Predicted_Income-Income.php', 0, 1),
('State_Total_Income-Income.php', 0, 1),
('Transactions_By_Month-Income.php', 0, 1),
('Upcoming_Charges-Income.php', 0, 1),
('Latest_Articles_Added-Knowledgebase.php', 0, 1),
('Most_Popular_Articles-Knowledgebase.php', 0, 1),
('Most_Viewed_Articles-Knowledgebase.php', 0, 1),
('Service_Rating-Support.php', 0, 1),
('Tickets_Review-Support.php', 0, 1),
('Ticket_Totals-Support.php', 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `routingrules`
--

CREATE TABLE `routingrules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL,
  `order` int(11) NOT NULL DEFAULT '0',
  `emails` text NOT NULL,
  `user_type` tinyint(4) NOT NULL,
  `autoresponder_template` int(11) NOT NULL,
  `openticket` tinyint(4) NOT NULL DEFAULT '0',
  `target_type` int(11) NOT NULL,
  `target_priority` int(11) NOT NULL,
  `target_dept` int(11) NOT NULL,
  `target_staff` int(11) NOT NULL,
  `copy_destinataries` text NOT NULL,
  `routing_type` tinyint(4) NOT NULL,
  `pop3_hostname` varchar(50) NOT NULL,
  `pop3_port` varchar(4) NOT NULL,
  `pop3_username` varchar(50) NOT NULL,
  `pop3_password` varchar(50) NOT NULL,
  `pop3_delete_emails` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `i_company_id` (`company_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `routingrules`
--

INSERT INTO `routingrules` VALUES
(1, 0, 'Default Routing Rule for emails from registered users', 0, '*', 1, 1, 1, 3, 2, -1, -1, '', 1, '', '110', '', '', 0),
(2, 0, 'Default Routing Rule for emails from unregistered users', 1, '*', 2, 2, 0, 0, 0, 0, 0, '', 1, '', '110', '', '', 0),
(3, 0, 'Default Routing Rule for Public Section', 0, '', 3, 1, 1, 0, 3, -1, -1, '', 3, '', '110', '', '', 0);

-- --------------------------------------------------------

--
-- Table structure for table `routingrules_groups`
--

CREATE TABLE `routingrules_groups` (
  `routingrule_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  PRIMARY KEY (`routingrule_id`,`group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `server`
--

CREATE TABLE `server` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `hostname` varchar(50) NOT NULL DEFAULT '',
  `sharedip` varchar(50) NOT NULL DEFAULT '',
  `isdefault` tinyint(1) NOT NULL DEFAULT '0',
  `plugin` varchar(25) NOT NULL DEFAULT '',
  `last_utilization` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `domains_quota` int(11) NOT NULL DEFAULT '0',
  `statsurl` varchar(225) NOT NULL,
  `statsviewable` tinyint(4) NOT NULL DEFAULT '0',
  `status_message` text NOT NULL,
  `cost` decimal(25,3) NOT NULL DEFAULT '0.000',
  `provider` varchar(250) NOT NULL,
  `prepend_username` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `server`
--

INSERT INTO `server` VALUES
(1, 'server1', 'server1.yourserver.com', '00.00.00.00', 1, '', '0000-00-00 00:00:00', 0, '', 0, '', '0.000', '', 0);

-- --------------------------------------------------------

--
-- Table structure for table `serverip`
--

CREATE TABLE `serverip` (
  `serverid` int(11) NOT NULL DEFAULT '0',
  `ip` varchar(50) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `serverplugin_options`
--

CREATE TABLE `serverplugin_options` (
  `serverid` int(11) NOT NULL DEFAULT '0',
  `optionname` varchar(125) NOT NULL DEFAULT '',
  `value` longblob NOT NULL,
  PRIMARY KEY (`serverid`,`optionname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `setting`
--

CREATE TABLE `setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(100) DEFAULT NULL,
  `value` text,
  `value_alternate` text,
  `description` text,
  `type` tinyint(4) NOT NULL DEFAULT '0',
  `isrequired` tinyint(4) NOT NULL DEFAULT '1',
  `istruefalse` tinyint(4) NOT NULL DEFAULT '0',
  `istextarea` tinyint(4) NOT NULL DEFAULT '0',
  `issmalltextarea` tinyint(4) NOT NULL DEFAULT '0',
  `isfromoptions` tinyint(4) NOT NULL DEFAULT '0',
  `myorder` int(11) NOT NULL DEFAULT '0',
  `helpid` int(3) DEFAULT '0',
  `plugin` tinyint(4) NOT NULL DEFAULT '0',
  `ispassword` tinyint(4) NOT NULL DEFAULT '0',
  `ishidden` tinyint(4) NOT NULL DEFAULT '0',
  `issession` tinyint(4) NOT NULL DEFAULT '1',
  UNIQUE KEY `id` (`id`),
  KEY `plugin` (`plugin`),
  KEY `i_name` (`name`),
  KEY `session` (`issession`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1500 ;

--
-- Dumping data for table `setting`
--

INSERT INTO `setting` VALUES
(133, 0, 'snapinsList', '', '', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1),
(134, 0, 'Domain Passwords are Encrypted', '1', '', 'This setting allows to encrypt Domain Passwords. When the encryption is done, this setting is set to true.', 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0),
(135, 0, 'ClientExec Version', '6.8.1', '', 'Version of Clientexec', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1),
(136, 0, 'Default Country Currency2', '', '', 'Default Currency Used In Clientexec.', -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1),
(137, 0, 'Default Country Name', '0', '', '', -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1),
(138, 0, 'Default Payment Type', 'MjAyNS0wOC0xM3wyMDI1LTA4LTEzfDA=', '', '', -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1),
(139, 0, 'Default Gateway', 'paypal', '', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(140, 0, 'Selected Currency Plugin', 'europeancentralbank', '', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(141, 0, 'Default Currency', 'USD', '', 'Select the default currency you would like Clientexec to use for your customers. This will also be the currency used during customer signup', -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1),
(142, 0, 'Integrate Control Panel', '1', '', 'Select YES if you want to integrate with a specific hosting control panel. NOTE: You must provide the required information for the control panel you select.', 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(143, 0, 'Cpanel Port', '2082', '', 'List the port number used in your installation of the Cpanel Control Panel. NOTE: This is usually set to 2082 as the default setting', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(144, 0, 'Show All Settings', '0', '', 'This setting allows you to view all settings for a given type at once.', 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(145, 0, 'Default Country Currency', '', '', 'Default Currency Used In Clientexec.', -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(146, 0, 'LastDateGenerateInvoices', '', '', '', -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(147, 0, 'LastDateRunBatch', '', '', '', -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(148, 0, 'license', '', '', '', -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(149, 0, 'Email Piping In Use', '0', '', 'If E-mail piping is in use set this to true so the reply above this line can be added to support ticket E-mails.', 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0),
(150, 0, 'E-mail Piping Last Five', '', '', 'Stores a serialized array of the last five E-mails addresses that have piped a reply into the system and the time that they were processed.', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0),
(151, 0, 'Domains Taxable', '0', NULL, 'Charge tax for domain fees', -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0),
(152, 0, 'Default TLD', 'com', NULL, 'Select the TLD that should be preselected in the sign up form.', -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0),
(153, 0, 'TeamStatusAPIInfo', '', '', 'API information for team status to send to CampFire or HipChat', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(154, 0, 'plugin_teamstatusnotifier_lastrun', '', '', 'Last runtime for teamstatus notifier service.', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(155, 0, 'sharedpluginsstate', '', NULL, NULL, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1),
(156, 0, 'CE-APIKEY', '', NULL, 'System Generated API-Key', -1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0),
(157, 0, 'Billing E-mail', '[[admin_email]]', '', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(158, 0, 'Billing Name', 'Billing', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(159, 0, 'Process Invoices Summary Notification', '', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(160, 0, 'Invoice BCC', '', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(161, 0, 'Invoice Start Number', '1000', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(162, 0, 'Invoice Entry Date Range Format', 'a:2:{i:0;s:5:"m/d/Y";i:1;s:5:"m/d/Y";}', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(163, 0, 'Recurring Invoice Setting', '2', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(164, 0, 'Also Send Autopayments And Subscriptions', '1', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(165, 0, 'Generate Invoices Per Package', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(166, 0, 'Send Invoice Offset', '15', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(167, 0, 'Charge Domain Invoice Offset', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(168, 0, 'Exclude Free Domains From Charge Domain Invoice Offset', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(169, 0, 'Recalculate Next Due Dates Related To Packages', '1', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(170, 0, 'Attach PDF When Mailing Invoice', '1', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(171, 0, 'Billing Menu Count', 'a:3:{i:0;s:1:"0";i:1;s:1:"1";i:2;s:1:"2";}', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(172, 0, 'Show Currency Code', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(173, 0, 'Void Unpaid Invoices', 'a:0:{}', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(174, 0, 'Apply Credit Balance Automatically', '1', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(175, 0, 'Invoice Template', 'default', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(176, 0, 'Display Successful Invoice Payment Transactions', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(177, 0, 'Additional Notes For Invoices', '', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(178, 0, 'Invoice Footer', 'Thank you for your order!  This transaction will appear on your billing statement as our company name.  If you have any questions, please feel free to contact us at billing@domain.com.', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(179, 0, 'Invoice Disclaimer', 'This communication is for the exclusive use of the addressee and may contain proprietary, confidential or privileged information. If you are not the intended recipient any use, copying, disclosure, dissemination or distribution is strictly prohibited.', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(180, 0, 'Support E-mail', '[[admin_email]]', '', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(181, 0, 'Support Ticket Start Number', '1000', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(182, 0, 'Response Time Goal', '60', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(183, 0, 'Ticket Number Prefix', 'CE', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(184, 0, 'Allow Admins To Reply From Any E-mail', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(185, 0, 'Allow Customers To Reply From Any E-mail', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(186, 0, 'Allow Customer File Uploads', '1', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(187, 0, 'Allowed File Extensions', 'png,jpg,jpeg,gif,zip,txt,log', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(188, 0, 'Days To Allow Tickets To Be Reopened', '', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(189, 0, 'Frequency to send feedback request E-mails', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(190, 0, 'Assign ticket to replier', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(191, 0, 'Number of Knowledgebase Articles to Show as Top Questions', '5', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(192, 0, 'Number of Latest Articles', '5', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(193, 0, 'Publish Comments Automatically', '1', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(194, 0, 'Show Global Series Separately', '1', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(195, 0, 'Global Series Name', 'Documentation', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(196, 0, 'Global Series Subtitle', 'Learn how to use our software', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(197, 0, 'Enable SEO Links', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(198, 0, 'Login Disabled', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(199, 0, 'Enable Auto Login', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(200, 0, 'Login disabled system message', 'Login for users is currently disabled due to server maintenance', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(201, 0, 'Company URL', '[[softurl]]', '', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(202, 0, 'Company Name', '[[comp_name]]', '', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(203, 0, 'Company Address', '', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(204, 0, 'Application Error Notification', '[[admin_email]]', '', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(205, 0, 'Custom Logout URL', '', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(206, 0, 'Show Execution Time', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(207, 0, 'Send application statistics', '1', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(208, 0, 'Number of Announcements To Show On Main Page', '1', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(209, 0, 'Language', 'English', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(210, 0, 'Enabled Languages', 'a:1:{i:0;s:7:"English";}', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(211, 0, 'Date Format', 'm/d/Y', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(212, 0, 'System Timezone', 'America/New_York', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(213, 0, 'Default Country', 'US', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(214, 0, 'Enabled Captcha Plugin', '', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(215, 0, 'Show Captcha on Login Page', '1', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(216, 0, 'Show Captcha on Register Page', '1', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(217, 0, 'Show Captcha on Forgot Password Page', '1', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(218, 0, 'Show Captcha on Signup Page', '1', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(219, 0, 'Show Captcha on Submit Ticket Page', '1', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(220, 0, 'Show Captcha on KB Article Comments', '1', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(221, 0, 'Mail Type', '2', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(222, 0, 'SMTP Host', '', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(223, 0, 'SMTP Username', '', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(224, 0, 'SMTP Password', '', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(225, 0, 'SMTP Port', '', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(226, 0, 'Override From', '', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(227, 0, 'Ignore Invalid Mail Server SSL', '', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(228, 0, 'Include Saved Percentage', '1', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(229, 0, 'Forward To Gateway', '1', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(230, 0, 'Send Account Welcome E-mail', '-1', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(231, 0, 'Show Terms and Conditions', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(232, 0, 'Terms and Conditions URL', '', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(233, 0, 'Terms and Conditions', '<span style="color:red">Your terms and conditions go here...</span>', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(234, 0, 'E-mail For New Signups', '', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(235, 0, 'Send Invoice Immediately', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(236, 0, 'Prompt for domain username and password', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(237, 0, 'Accept Coupons', '1', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(238, 0, 'Signup Completion URL', '', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(239, 0, 'Cancel Order URL', '', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(240, 0, 'Allow Registration', '1', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(241, 0, 'Confirmation Link Availability', '24', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(242, 0, 'Monthly Price Breakdown', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(243, 0, 'Show Discounted Pricing in Billing Cycle Selector', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(244, 0, 'Hide Setup Fees', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(245, 0, 'Hide Payment Methods', '1', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(246, 0, 'Show Currency Selector', '1', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(247, 0, 'No Invoice', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(248, 0, 'Order Complete Message', 'Your order has been received. Thank you for choosing . A confirmation email will arrive shortly.', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(249, 0, 'Stock Timer', '5', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(250, 0, 'Charge Setup Prices', '1', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(251, 0, 'Provide Prorated Credit', '1', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(252, 0, 'Add Credit Balance', '1', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(253, 0, 'Show Twitter Button', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(254, 0, 'Default Tweet', 'I''ve just made a purchase here!', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(255, 0, 'Show Twitter Button on Excellent Feedback', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(256, 0, 'Default Feedback Tweet', 'Thank you so much for an excellent support experience', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(257, 0, 'Show Facebook Button', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(258, 0, 'Facebook App ID', '', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(259, 0, 'Enforce Password Strength', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(260, 0, 'Allow Admins Override Enforce Password Strength', '1', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(261, 0, 'Minimum Password Length', '6', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(262, 0, 'Forbid dictionary words', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(263, 0, 'Require Both Lowercase And Uppercase Characters', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(264, 0, 'Require Numbers', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(265, 0, 'Require Symbols', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(266, 0, 'Force Transfer Checklist', '', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(267, 0, 'Auto-Renew Domain', '', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(268, 0, 'Auto-Renew Ticket Assign To', 'dep_1', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(269, 0, 'Auto-Renew Offset', '60', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(270, 0, 'Hide Registrar Information', '', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(271, 0, 'Allow Duplicated Subdomains', '1', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(272, 0, 'Forbidden Subdomains', 'www,webmail,client,support,billing,cpanel,whm', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(273, 0, 'Forbidden Domains Phrases', '', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(274, 0, 'Template', 'default', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(275, 0, 'JavaScript Sources', 'cdn', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(276, 0, 'Ban IPs generating security warnings', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(277, 0, 'Number of security warnings triggering a ban', '4', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(278, 0, 'Ban if matches fraud', 'None', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(279, 0, 'Lapse of time for counting security warnings (in minutes)', '10', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(280, 0, 'IPs never to be banned', '127.0.0.1\n::1', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(281, 0, 'IPs currently banned', '', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(282, 0, 'Affiliate System Enabled', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(283, 0, 'Length of Cookie', '90', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(284, 0, 'Payout Days', '30', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(285, 0, 'Minimum Withdrawal', '25', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(286, 0, 'Bonus Deposit', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(287, 0, 'Default Commission Structure', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(288, 0, 'Default Commission', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(289, 0, 'Default Commission Type', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(290, 0, 'Automatically Activate Affiliate Account?', '0', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(291, 0, 'Payout Request Department', '1', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(292, 0, 'Email For Affiliates', '', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(293, 0, 'ClientExec URL', '[[softurl]]', NULL, '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1),
(294, 0, 'plugin_fraudlabspro_Plugin Name', 'FraudLabs Pro', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(295, 0, 'plugin_fraudlabspro_Enabled', '0', '', 'Setting allows FraudLabs Pro slients to check orders for fraud.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(296, 0, 'plugin_fraudlabspro_API Key', '', '', 'Enter your API Key here.<br>You can obtain a license at <a href=&quot;http://www.fraudlabspro.com/?ref=1614&quot; target=&quot;_blank&quot;>https://www.fraudlabspro.com/</a>', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(297, 0, 'plugin_maxmind_Plugin Name', 'Maxmind', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(298, 0, 'plugin_maxmind_Enabled', '0', '', 'Setting allows MaxMind clients to check orders for fraud.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(299, 0, 'plugin_maxmind_MaxMind Account ID', '', '', 'Enter your MaxMind Account ID. <br>You can obtain a license at <a href=https://maxmind.pxf.io/75okD5 target=_blank>https://maxmind.pxf.io/75okD5</a>', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(300, 0, 'plugin_maxmind_MaxMind License Key', '', '', 'Enter your MaxMind License Key here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(301, 0, 'plugin_maxmind_Enable Device Tracking Addon', '1', '', 'The device tracking add-on identifies devices as they move across networks and enhances the ability of the minFraud services to detect fraud.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(302, 0, 'plugin_maxmind_Service', 'Score', '', 'Select the MaxMind Service you would like to use.  More information on service types is available <a href=&quot;https://www.maxmind.com/en/solutions/minfraud-services&quot; target=&quot;_blank&quot;>here</a>.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(303, 0, 'plugin_maxmind_Reject Free E-mail Service', '0', '', 'Enabling this setting will reject any order using a free email service, such as gmail, hotmail, or yahoo.<br><b>NOTE:</b> Requires Insights or Factors Service', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(304, 0, 'plugin_maxmind_Reject Country Mismatch', '1', '', 'Enabling this setting will reject any order where the billing address country does not match the country the IP address is registered to.<br><b>NOTE:</b> Requires Insights or Factors Service.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(305, 0, 'plugin_maxmind_Reject Anonymous Proxy', '1', '', 'Enabling this setting will reject any order where the IP address is an Anonymous Proxy.<br><b>NOTE:</b> Requires Insights or Factors Service', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(306, 0, 'plugin_maxmind_MaxMind Fraud Risk Score', 'none', '', 'The minFraud service evaluates your transactions against billions of scored transactions from the minFraud network, drawing on machine learning as well as years of expert review to provide a numerical indicator of risk.  Any Risk Score higher then this number will be rejected.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(307, 0, 'plugin_maxmind_MaxMind Warning E-mail', '', '', 'The email address where a notification will be sent when the number of remaining queries reaches your MaxMind Low Query Threshold', 6, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0),
(308, 0, 'plugin_maxmind_MaxMind Low Query Threshold', '10', '', 'A notification email will be sent when the number of remaining queries reaches this value.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(309, 0, 'plugin_stopforumspam_Plugin Name', 'StopForumSpam', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(310, 0, 'plugin_stopforumspam_Enabled', '0', '', 'Enable if you wish CE to use the StopForumSpam API to prevent users from IPs listed in their database from having access.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(311, 0, 'plugin_stopforumspam_Reject Signup', '0', '', 'Determine if you want to block orders based on data from StopForumSpam.com.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(312, 0, 'plugin_stopforumspam_Can Block Ip', '1', '', 'This plugin can determine if an ip is blockable.  Can be used in conjuction with other plugins to safely make judgements on results from method shouldblockip', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(313, 0, 'plugin_2checkout_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(314, 0, 'plugin_2checkout_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(315, 0, 'plugin_2checkout_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(316, 0, 'plugin_2checkout_Plugin Name', '2Checkout', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(317, 0, 'plugin_2checkout_Seller ID', '', '', 'ID used to identify you to 2checkout.com.<br>NOTE: This ID is required if you have selected 2checkout as a payment gateway for any of your clients.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(318, 0, 'plugin_2checkout_Secret Word', '', '', '&#039;Secret Word&#039; used to calculate the MD5 hash. <br>NOTE: Please take in count, you will also need to set the &#039;Secret Word&#039; on the 2Checkout Site Management page, and it is to avoid frauds.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(319, 0, 'plugin_2checkout_Purchase Routine', '0', '', 'This setting allows you to determine which purchase routine will be better suited for your site.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(320, 0, 'plugin_2checkout_API Username', '', '', '<b>Required for refunds</b>.<br>As 2Checkout users cannot access both the API and Seller Area, you need to go to your 2Checkout dashboard, then click <b>Account</b> > <b>User Management</b> > <b>Create Username</b> and create another account, making sure to provide <b>API Access</b> and <b>API Updating</b> permissions. Use that username here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(321, 0, 'plugin_2checkout_API Password', '', '', '<b>Required for refunds</b>.<br>As 2Checkout users cannot access both the API and Seller Area, you need to go to your 2Checkout dashboard, then click <b>Account</b> > <b>User Management</b> > <b>Create Username</b> and create another account, making sure to provide <b>API Access</b> and <b>API Updating</b> permissions. Use that password here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(322, 0, 'plugin_2checkout_Demo Mode', '0', '', 'Select YES if you want to set 2checkout into Demo Mode for testing. (<b>NOTE:</b> You must set to NO before accepting actual payments through this processor.)', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(323, 0, 'plugin_2checkout_Accept CC Number', '0', '', 'Selecting YES allows the entering of CC numbers when using this plugin type. No will prevent entering of cc information', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(324, 0, 'plugin_2checkout_Visa', '0', '', 'Select YES to allow Visa card acceptance with this plugin.  No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(325, 0, 'plugin_2checkout_MasterCard', '0', '', 'Select YES to allow MasterCard acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(326, 0, 'plugin_2checkout_AmericanExpress', '0', '', 'Select YES to allow American Express card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(327, 0, 'plugin_2checkout_Discover', '0', '', 'Select YES to allow Discover card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(328, 0, 'plugin_2checkout_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(329, 0, 'plugin_2checkout_Signup Name', 'Credit Card', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(330, 0, 'plugin_2checkout_Dummy Plugin', '0', '', '1 = Only used to specify a billing type for a client. 0 = full fledged plugin requiring complete functions', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(331, 0, 'plugin_2checkout_Auto Payment', '0', '', 'No description', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(332, 0, 'plugin_2checkout_Check CVV2', '0', '', 'Select YES if you want to accept CVV2 for this plugin.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(333, 0, 'plugin_alipay_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(334, 0, 'plugin_alipay_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(335, 0, 'plugin_alipay_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(336, 0, 'plugin_alipay_Plugin Name', 'Alipay', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(337, 0, 'plugin_alipay_Signup Name', '支付宝（AliPay）', '', '用户支付时看到的付款方式.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(338, 0, 'plugin_alipay_Alipay Sandbox', '0', '', '沙箱模式', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(339, 0, 'plugin_alipay_Sign Type', 'RSA2', '', '签名类型 - RSA|RSA2', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(340, 0, 'plugin_alipay_App ID', '', '', '应用 ID', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(341, 0, 'plugin_alipay_App Public', '', '', '应用公钥', 6, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0),
(342, 0, 'plugin_alipay_App Private', '', '', '应用私钥', 6, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0),
(343, 0, 'plugin_alipay_Public Key', '', '', '支付宝私钥', 6, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0),
(344, 0, 'plugin_authnet_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(345, 0, 'plugin_authnet_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(346, 0, 'plugin_authnet_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(347, 0, 'plugin_authnet_Plugin Name', 'Authorize.Net', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(348, 0, 'plugin_authnet_Authorize.Net API Login ID', '', '', 'Please enter your Authorize.Net API Login ID Here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(349, 0, 'plugin_authnet_Authorize.Net Transaction Key', '', '', 'Please enter your Authorize.Net Transaction Key Here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(350, 0, 'plugin_authnet_MD5 Hash Value', '', '', 'Used to verify valid transactions from Authorize.Net.<br>NOTE: This value has to match the value set in the Authorize.Net Merchant Interface - <i>Optional</i>', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(351, 0, 'plugin_authnet_Demo Mode', '1', '', 'Select YES if you want to set this plugin in Demo mode for testing purposes.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(352, 0, 'plugin_authnet_Accept CC Number', '1', '', 'Selecting YES allows the entering of CC numbers when using this plugin type. No will prevent entering of cc information', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(353, 0, 'plugin_authnet_Visa', '1', '', 'Select YES to allow Visa card acceptance with this plugin.  No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(354, 0, 'plugin_authnet_MasterCard', '1', '', 'Select YES to allow MasterCard acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(355, 0, 'plugin_authnet_AmericanExpress', '1', '', 'Select YES to allow American Express card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(356, 0, 'plugin_authnet_Discover', '0', '', 'Select YES to allow Discover card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(357, 0, 'plugin_authnet_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(358, 0, 'plugin_authnet_Signup Name', 'Credit Card', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(359, 0, 'plugin_authnet_Dummy Plugin', '0', '', '1 = Only used to specify a billing type for a client. 0 = full fledged plugin requiring complete functions', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(360, 0, 'plugin_authnet_Auto Payment', '1', '', 'No description', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(361, 0, 'plugin_authnet_Check CVV2', '1', '', 'Select YES if you want to accept CVV2 for this plugin.  Please set your Authorize.net account to reject transactions with CVV2 mismatches.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(362, 0, 'plugin_authnetcim_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(363, 0, 'plugin_authnetcim_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(364, 0, 'plugin_authnetcim_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(365, 0, 'plugin_authnetcim_Plugin Name', 'Authorize.Net CIM', '', 'How CE sees this plugin ( not to be confused with the Signup Name )', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(366, 0, 'plugin_authnetcim_Authorize.Net CIM API Login ID', '', '', 'Please enter your Authorize.Net CIM API Login ID here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(367, 0, 'plugin_authnetcim_Authorize.Net CIM Transaction Key', '', '', 'Please enter your Authorize.Net CIM Transaction Key here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(368, 0, 'plugin_authnetcim_Authorize.Net CIM Test Mode', '0', '', 'Select YES if you want to use Authorize.Net CIM testing server, so no actual monetary transactions are made.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(369, 0, 'plugin_authnetcim_Disable validate client Authnet CIM payment profile', '0', '', 'Select YES if you want to avoid Authorize.Net CIM to validate the client Authnet CIM payment profile on every transaction. This will also stop Authorize.Net CIM sending some emails about validation transactions.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(370, 0, 'plugin_authnetcim_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(371, 0, 'plugin_authnetcim_Signup Name', 'Authorize.Net CIM', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(372, 0, 'plugin_authnetcim_Auto Payment', '1', '', 'No description', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(373, 0, 'plugin_authnetcim_CC Stored Outside', '1', '', 'If this plugin is Auto Payment, is Credit Card stored outside of Clientexec? 1 = YES, 0 = NO', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(374, 0, 'plugin_authnetcim_Billing Profile ID', '1', '', 'Is this plugin storing a Billing-Profile-ID? 1 = YES, 0 = NO', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(375, 0, 'plugin_authnetcim_Iframe Configuration', 'width=&quot;100%&quot; height=&quot;600&quot; scrolling=&quot;auto&quot; frameborder=&quot;0&quot;', '', 'Parameters to be used in the iframe when loaded, like: width, height, scrolling, frameborder', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(376, 0, 'plugin_authnetcim_Dummy Plugin', '0', '', '1 = Only used to specify a billing type for a client. 0 = full fledged plugin requiring complete functions', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(377, 0, 'plugin_authnetcim_Update Gateway', '1', '', '1 = Create, update or remove Gateway client information through the function UpdateGateway when client choose to use this gateway, client profile is updated, client is deleted or client status is changed. 0 = Do nothing.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(378, 0, 'plugin_bitpay_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(379, 0, 'plugin_bitpay_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(380, 0, 'plugin_bitpay_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(381, 0, 'plugin_bitpay_Plugin Name', 'BitPay', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(382, 0, 'plugin_bitpay_Legacy API Key', '', '', 'Enter your Legacy API Key from your bitpay.com merchant account', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(383, 0, 'plugin_bitpay_Transaction Speed', '', '', 'Select the transaction speed to confirm payment', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(384, 0, 'plugin_bitpay_Use Testing Environment?', '0', '', 'Select YES if you wish to use the testing environment instead of the live environment', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(385, 0, 'plugin_bitpay_Signup Name', 'Bitcoin (BTC)', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(386, 0, 'plugin_bluepay_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(387, 0, 'plugin_bluepay_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(388, 0, 'plugin_bluepay_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(389, 0, 'plugin_bluepay_Plugin Name', 'BluePay', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(390, 0, 'plugin_bluepay_BluePay Account ID', '', '', 'Please enter your BluePay Account ID Here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(391, 0, 'plugin_bluepay_BluePay Secret Key', '', '', 'Please enter your BluePay Secret Key Here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(392, 0, 'plugin_bluepay_Demo Mode', '1', '', 'Select YES if you want to set this plugin in Demo mode for testing purposes.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(393, 0, 'plugin_bluepay_Accept CC Number', '1', '', 'Selecting YES allows the entering of CC numbers when using this plugin type. No will prevent entering of cc information', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(394, 0, 'plugin_bluepay_Visa', '1', '', 'Select YES to allow Visa card acceptance with this plugin.  No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(395, 0, 'plugin_bluepay_MasterCard', '1', '', 'Select YES to allow MasterCard acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(396, 0, 'plugin_bluepay_AmericanExpress', '1', '', 'Select YES to allow American Express card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(397, 0, 'plugin_bluepay_Discover', '0', '', 'Select YES to allow Discover card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(398, 0, 'plugin_bluepay_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(399, 0, 'plugin_bluepay_Signup Name', 'Credit Card', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(400, 0, 'plugin_bluepay_Dummy Plugin', '0', '', '1 = Only used to specify a billing type for a client. 0 = full fledged plugin requiring complete functions', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(401, 0, 'plugin_bluepay_Auto Payment', '1', '', 'No description', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(402, 0, 'plugin_bluepay_Check CVV2', '1', '', 'Select YES if you want to accept CVV2 for this plugin.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(403, 0, 'plugin_braintree_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(404, 0, 'plugin_braintree_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(405, 0, 'plugin_braintree_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(406, 0, 'plugin_braintree_Plugin Name', 'Braintree', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(407, 0, 'plugin_braintree_Public Key', '', '', 'Braintree Public Key (user-specific public identifier).<br><b>NOTE:</b> This Public Key is required if you have selected Braintree as a payment gateway for any of your clients.<br>In order to get it, follow these steps in your Braintree account:<ol><li>Log into either the production Control Panel or the sandbox Control Panel, depending on which environment you are working in</li><li>Navigate to <b>Account</b> > <b>My User</b></li><li>Under <b>API Keys, Tokenization Keys, Encryption Keys</b>, click <b>View Authorizations</b>. If no API keys appear, click <b>Generate New API Key</b></li><li>Click <b>View</b> under the <b>Private Key</b> column to see your public and private keys, merchant ID, and environment</li></ol>', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(408, 0, 'plugin_braintree_Private Key', '', '', 'Braintree Private Key (user-specific secure identifier that should not be shared – even with Braintree).<br><b>NOTE:</b> This Private Key is required if you have selected Braintree as a payment gateway for any of your clients.<br>In order to get it, follow these steps in your Braintree account:<ol><li>Log into either the production Control Panel or the sandbox Control Panel, depending on which environment you are working in</li><li>Navigate to <b>Account</b> > <b>My User</b></li><li>Under <b>API Keys, Tokenization Keys, Encryption Keys</b>, click <b>View Authorizations</b>. If no API keys appear, click <b>Generate New API Key</b></li><li>Click <b>View</b> under the <b>Private Key</b> column to see your public and private keys, merchant ID, and environment</li></ol>', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(409, 0, 'plugin_braintree_Merchant ID', '', '', 'Braintree Merchant ID (a unique identifier for your gateway account, which is different than your merchant account ID).<br><b>NOTE:</b> This Merchant ID is required if you have selected Braintree as a payment gateway for any of your clients.<br>In order to get it, follow these steps in your Braintree account:<ol><li>Log into either the production Control Panel or the sandbox Control Panel, depending on which environment you are working in</li><li>Navigate to <b>Account</b> > <b>My User</b></li><li>Under <b>API Keys, Tokenization Keys, Encryption Keys</b>, click <b>View Authorizations</b>. If no API keys appear, click <b>Generate New API Key</b></li><li>Click <b>View</b> under the <b>Private Key</b> column to see your public and private keys, merchant ID, and environment</li></ol>', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(410, 0, 'plugin_braintree_Environment', 'sandbox', '', 'Braintree Environment (value that specifies where requests should be directed – sandbox or production).<br><b>NOTE:</b> This Environment is required if you have selected Braintree as a payment gateway for any of your clients.<br>In order to get it, follow these steps in your Braintree account:<ol><li>Log into either the production Control Panel or the sandbox Control Panel, depending on which environment you are working in</li><li>Navigate to <b>Account</b> > <b>My User</b></li><li>Under <b>API Keys, Tokenization Keys, Encryption Keys</b>, click <b>View Authorizations</b>. If no API keys appear, click <b>Generate New API Key</b></li><li>Click <b>View</b> under the <b>Private Key</b> column to see your public and private keys, merchant ID, and environment</li></ol>', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(411, 0, 'plugin_braintree_Allow Paypal', '0', '', 'Select YES if you want to allow your clients to link a paypal account.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(412, 0, 'plugin_braintree_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(413, 0, 'plugin_braintree_Signup Name', 'Braintree', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(414, 0, 'plugin_braintree_Dummy Plugin', '0', '', '1 = Only used to specify a billing type for a client. 0 = full fledged plugin requiring complete functions', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(415, 0, 'plugin_braintree_Auto Payment', '1', '', 'No description', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(416, 0, 'plugin_braintree_CC Stored Outside', '1', '', 'If this plugin is Auto Payment, is Credit Card stored outside of Clientexec? 1 = YES, 0 = NO', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(417, 0, 'plugin_braintree_Billing Profile ID', '1', '', 'Is this plugin storing a Billing-Profile-ID? 1 = YES, 0 = NO', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(418, 0, 'plugin_braintree_Iframe Configuration', 'width=&quot;100%&quot; height=&quot;450&quot; scrolling=&quot;auto&quot; frameborder=&quot;0&quot;', '', 'Parameters to be used in the iframe when loaded, like: width, height, scrolling, frameborder', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(419, 0, 'plugin_braintree_Check CVV2', '0', '', 'Select YES if you want to accept CVV2 for this plugin.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(420, 0, 'plugin_braintree_Update Gateway', '1', '', '1 = Create, update or remove Gateway client information through the function UpdateGateway when client choose to use this gateway, client profile is updated, client is deleted or client status is changed. 0 = Do nothing.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(421, 0, 'plugin_buypass_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(422, 0, 'plugin_buypass_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(423, 0, 'plugin_buypass_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(424, 0, 'plugin_buypass_Plugin Name', 'Buypass', '', 'How CE sees this plugin ( not to be confused with the Signup Name )', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(425, 0, 'plugin_buypass_Buypass User ID', '', '', 'Please enter your Buypass User ID here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(426, 0, 'plugin_buypass_Buypass Gateway ID', '', '', 'Please enter your Buypass Gateway ID here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(427, 0, 'plugin_buypass_Buypass Terminal ID', '', '', 'Please enter your Buypass Terminal ID here.</br>Max Size: 11', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(428, 0, 'plugin_buypass_Buypass Platform', '', '', 'Please enter your Buypass Platform here.</br>Identifies the platform to perform transaction processing.</br>Max Size: 11', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(429, 0, 'plugin_buypass_Buypass Application ID', '', '', 'Please enter your Buypass Application ID here.</br>Application identifier for the application used in sending/receiving transaction request.</br>The value of this field is assigned/authorized by the gateway and must be used in all transactions used by the certified application.</br>Max Size: 20', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(430, 0, 'plugin_buypass_Buypass Live URL', '', '', 'Please enter your Buypass Live URL here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(431, 0, 'plugin_buypass_Buypass Test URL', '', '', 'Please enter your Buypass Test URL here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(432, 0, 'plugin_buypass_Buypass Test Mode', '0', '', 'Select YES if you want to use Buypass testing server, so no actual monetary transactions are made.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(433, 0, 'plugin_buypass_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(434, 0, 'plugin_buypass_Signup Name', 'Buypass', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(435, 0, 'plugin_buypass_Auto Payment', '1', '', 'No description', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(436, 0, 'plugin_buypass_Dummy Plugin', '0', '', '1 = Only used to specify a billing type for a client. 0 = full fledged plugin requiring complete functions', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(437, 0, 'plugin_buypass_Accept CC Number', '1', '', 'Selecting YES allows the entering of CC numbers when using this plugin type. No will prevent entering of cc information', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(438, 0, 'plugin_buypass_Visa', '1', '', 'Select YES to allow Visa card acceptance with this plugin.  No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(439, 0, 'plugin_buypass_MasterCard', '1', '', 'Select YES to allow MasterCard acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(440, 0, 'plugin_buypass_AmericanExpress', '1', '', 'Select YES to allow American Express card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(441, 0, 'plugin_buypass_Discover', '1', '', 'Select YES to allow Discover card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(442, 0, 'plugin_buypass_Billing Profile ID', '1', '', 'Is this plugin storing a Billing-Profile-ID? 1 = YES, 0 = NO', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(443, 0, 'plugin_buypass_Update Gateway', '1', '', '1 = Create, update or remove Gateway client information through the function UpdateGateway when client choose to use this gateway, client profile is updated, client is deleted or client status is changed. 0 = Do nothing.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(444, 0, 'plugin_ccavenue_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(445, 0, 'plugin_ccavenue_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(446, 0, 'plugin_ccavenue_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(447, 0, 'plugin_ccavenue_Plugin Name', 'CCAvenue', '', 'How ClientExec sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(448, 0, 'plugin_ccavenue_Merchant ID', '', '', 'This is the identifier for your CCAvenue merchant Account.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(449, 0, 'plugin_ccavenue_Access Code', '', '', 'This is the access code for your application.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(450, 0, 'plugin_ccavenue_Encryption Key', '', '', 'The secret key used for encrypting each request originating from your application.<br>Ensure you are using the correct key while encrypting requests from different URLs registered with CCAvenue.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(451, 0, 'plugin_ccavenue_Test Mode', '0', '', 'Select YES if you want to use Testing server, so no actual monetary transactions are made.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(452, 0, 'plugin_ccavenue_Visa', '1', '', 'Select YES to allow Visa card acceptance with this plugin.  No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(453, 0, 'plugin_ccavenue_MasterCard', '1', '', 'Select YES to allow MasterCard acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(454, 0, 'plugin_ccavenue_AmericanExpress', '0', '', 'Select YES to allow American Express card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0);
INSERT INTO `setting` VALUES
(455, 0, 'plugin_ccavenue_Discover', '0', '', 'Select YES to allow Discover card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(456, 0, 'plugin_ccavenue_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(457, 0, 'plugin_ccavenue_Signup Name', 'Credit Card', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(458, 0, 'plugin_ccavenue_Dummy Plugin', '0', '', '1 = Only used to specify a billing type for a client. 0 = full fledged plugin requiring complete functions', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(459, 0, 'plugin_ccavenue_Accept CC Number', '0', '', 'Selecting YES allows the entering of CC numbers when using this plugin type. No will prevent entering of cc information', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(460, 0, 'plugin_ccavenue_Auto Payment', '0', '', 'No description', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(461, 0, 'plugin_ccavenue_Check CVV2', '0', '', 'Select YES if you want to accept CVV2 for this plugin.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(462, 0, 'plugin_ccavenueold_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(463, 0, 'plugin_ccavenueold_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(464, 0, 'plugin_ccavenueold_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(465, 0, 'plugin_ccavenueold_Plugin Name', 'CCAvenue (old version)', '', 'How ClientExec sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(466, 0, 'plugin_ccavenueold_Merchant ID', '', '', 'ID used to identify you to CCAvenue.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(467, 0, 'plugin_ccavenueold_Working Key', '', '', '32 bit alphanumber CCAvenue key.<br>Note: This key is available at &#039;Generate Working Key&#039; of the &#039;Settings & Options&#039; section.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(468, 0, 'plugin_ccavenueold_Visa', '1', '', 'Select YES to allow Visa card acceptance with this plugin.  No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(469, 0, 'plugin_ccavenueold_MasterCard', '1', '', 'Select YES to allow MasterCard acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(470, 0, 'plugin_ccavenueold_AmericanExpress', '0', '', 'Select YES to allow American Express card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(471, 0, 'plugin_ccavenueold_Discover', '0', '', 'Select YES to allow Discover card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(472, 0, 'plugin_ccavenueold_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(473, 0, 'plugin_ccavenueold_Signup Name', 'Credit Card', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(474, 0, 'plugin_ccavenueold_Dummy Plugin', '0', '', '1 = Only used to specify a billing type for a client. 0 = full fledged plugin requiring complete functions', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(475, 0, 'plugin_ccavenueold_Accept CC Number', '0', '', 'Selecting YES allows the entering of CC numbers when using this plugin type. No will prevent entering of cc information', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(476, 0, 'plugin_ccavenueold_Auto Payment', '0', '', 'No description', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(477, 0, 'plugin_ccavenueold_Check CVV2', '0', '', 'Select YES if you want to accept CVV2 for this plugin.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(478, 0, 'plugin_chronopay_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(479, 0, 'plugin_chronopay_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(480, 0, 'plugin_chronopay_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(481, 0, 'plugin_chronopay_Plugin Name', 'ChronoPay', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(482, 0, 'plugin_chronopay_Product ID', '', '', 'Product ID configured in your ChronoPay Account.<br>NOTE: This ID is required if you have selected ChronoPay as a payment gateway for any of your clients.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(483, 0, 'plugin_chronopay_Product Name', '', '', 'Product Name to be displayed on the ChronoPay hosted payment page.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(484, 0, 'plugin_chronopay_ChronoPay Language', 'EN', '', 'Language in which the ChronoPay page will be displayed in. <br/>NL = Dutch, ES = Spanish, <br/>RU = Russian, EN = English (Default)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(485, 0, 'plugin_chronopay_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(486, 0, 'plugin_chronopay_Signup Name', 'Credit Card', '', 'Select the name to display in the signup process for this payment type. Example: ChronoPay or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(487, 0, 'plugin_chronopay_Dummy Plugin', '0', '', '1 = Only used to specify a billing type for a client. 0 = full fledged plugin requiring complete functions', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(488, 0, 'plugin_chronopay_Check CVV2', '0', '', 'Select YES if you want to accept CVV2 for this plugin.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(489, 0, 'plugin_coinbasecommerce_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(490, 0, 'plugin_coinbasecommerce_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(491, 0, 'plugin_coinbasecommerce_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(492, 0, 'plugin_coinbasecommerce_Plugin Name', 'Coinbase Commerce', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(493, 0, 'plugin_coinbasecommerce_API Key', '', '', 'Generate an API key from here: https://commerce.coinbase.com/dashboard/settings', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(494, 0, 'plugin_coinbasecommerce_Webhook Shared Secret', '', '', 'Get your Webhook shared secret from the Webhook subscriptions here: https://commerce.coinbase.com/dashboard/settings <br>Make sure you add the endpoint for your website into your webook subscriptions.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(495, 0, 'plugin_coinbasecommerce_Signup Name', 'Coinbase Commerce', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(496, 0, 'plugin_coinpayments_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(497, 0, 'plugin_coinpayments_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(498, 0, 'plugin_coinpayments_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(499, 0, 'plugin_coinpayments_Plugin Name', 'CoinPayments', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(500, 0, 'plugin_coinpayments_Merchant ID', '', '', 'Enter your Merchant ID from your <a target=&#039;_blank&#039; href=&#039;https://www.coinpayments.net/index.php?ref=219a5b5f2eacd21f82e48d267f5bd7dc&#039;>coinpayments.net</a> account', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(501, 0, 'plugin_coinpayments_IPN Secert', '', '', 'Enter your IPN Secret from your <a target=&#039;_blank&#039; href=&#039;https://www.coinpayments.net/index.php?ref=219a5b5f2eacd21f82e48d267f5bd7dc&#039;>coinpayments.net</a> account', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(502, 0, 'plugin_coinpayments_Signup Name', 'CoinPayments', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(503, 0, 'plugin_eprocessingnetwork_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(504, 0, 'plugin_eprocessingnetwork_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(505, 0, 'plugin_eprocessingnetwork_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(506, 0, 'plugin_eprocessingnetwork_Plugin Name', 'eProcessingNetwork', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(507, 0, 'plugin_eprocessingnetwork_eProcessingNetwork Username', '', '', 'Please enter your eProcessingNetwork Username Here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(508, 0, 'plugin_eprocessingnetwork_eProcessingNetwork Transaction Key', '', '', 'Please enter your eProcessingNetwork Transaction Key Here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(509, 0, 'plugin_eprocessingnetwork_Demo Mode', '1', '', 'Select YES if you want to set this plugin in Demo mode for testing purposes.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(510, 0, 'plugin_eprocessingnetwork_Accept CC Number', '1', '', 'Selecting YES allows the entering of CC numbers when using this plugin type. No will prevent entering of cc information', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(511, 0, 'plugin_eprocessingnetwork_Visa', '1', '', 'Select YES to allow Visa card acceptance with this plugin.  No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(512, 0, 'plugin_eprocessingnetwork_MasterCard', '1', '', 'Select YES to allow MasterCard acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(513, 0, 'plugin_eprocessingnetwork_AmericanExpress', '1', '', 'Select YES to allow American Express card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(514, 0, 'plugin_eprocessingnetwork_Discover', '0', '', 'Select YES to allow Discover card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(515, 0, 'plugin_eprocessingnetwork_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(516, 0, 'plugin_eprocessingnetwork_Signup Name', 'Credit Card', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(517, 0, 'plugin_eprocessingnetwork_Dummy Plugin', '0', '', '1 = Only used to specify a billing type for a client. 0 = full fledged plugin requiring complete functions', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(518, 0, 'plugin_eprocessingnetwork_Auto Payment', '1', '', 'No description', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(519, 0, 'plugin_eprocessingnetwork_Check CVV2', '1', '', 'Select YES if you want to accept CVV2 for this plugin.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(520, 0, 'plugin_eway_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(521, 0, 'plugin_eway_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(522, 0, 'plugin_eway_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(523, 0, 'plugin_eway_Plugin Name', 'eWay', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(524, 0, 'plugin_eway_eWay Sandbox', '0', '', 'Select YES if you want to set eWay into Test mode for testing. Even for testing you will need an eWay ID, that you can find at eWay&#039;s website.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(525, 0, 'plugin_eway_eWay ID', '', '', 'Please enter your eWay Customer ID here', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(526, 0, 'plugin_eway_Refund Password', '', '', 'Password required for refunds.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(527, 0, 'plugin_eway_Accept CC Number', '1', '', 'Selecting YES allows the entering of CC numbers when using this plugin type. No will prevent entering of cc information', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(528, 0, 'plugin_eway_Visa', '1', '', 'Select YES to allow Visa card acceptance with this plugin.  No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(529, 0, 'plugin_eway_MasterCard', '1', '', 'Select YES to allow MasterCard acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(530, 0, 'plugin_eway_AmericanExpress', '1', '', 'Select YES to allow American Express card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(531, 0, 'plugin_eway_Discover', '0', '', 'Select YES to allow Discover card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(532, 0, 'plugin_eway_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(533, 0, 'plugin_eway_Signup Name', 'Credit Card', '', 'Select the name to display in the signup process for this payment type. Example: eWay or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(534, 0, 'plugin_eway_Dummy Plugin', '0', '', '1 = Only used to specify a billing type for a client. 0 = full fledged plugin requiring complete functions', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(535, 0, 'plugin_eway_Auto Payment', '1', '', 'No description', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(536, 0, 'plugin_eway_Check CVV2', '1', '', 'Select YES if you want to accept CVV2 for this plugin.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(537, 0, 'plugin_globalpay_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(538, 0, 'plugin_globalpay_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(539, 0, 'plugin_globalpay_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(540, 0, 'plugin_globalpay_Plugin Name', 'Global Payments', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(541, 0, 'plugin_globalpay_Global User Name', '', '', 'User name used to identify you to globalpay.com.<br>NOTE: This user name is required if you have selected Global Payments as a payment gateway for any of your clients.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(542, 0, 'plugin_globalpay_Global Password', '', '', 'Password used to identify you to globalpay.com.<br>NOTE: This password is required if you have selected Global Payments as a payment gateway for any of your clients.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(543, 0, 'plugin_globalpay_Global Environment Name', 'certapia', '', 'The Global Transport Certification environment&#039;s domain name is currently <b>https://certapia.globalpay.com</b></br>After certifying and when processing live transactions, the domain name must be changed in the integrated application to reflect the production environment&#039;s domain name.</br>After your certification is complete, contact Global Payments to receive the production domain name.</br>The value required in this field is to replace the <b><font color=blue>&lt;environment&gt;</font></b> tag on <b>https://<font color=blue>&lt;environment&gt;</font>.globalpay.com</b></br>Your certification system firewall must allow connection to both <b>172.31.31.59</b> and <b>172.31.12.81</b>', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(544, 0, 'plugin_globalpay_Global Term Type', '', '', 'The Term Type value (3 alphanumeric characters) identifies the application submitting the transaction.</br>The Global Payments Integration team will assign each integrated application a unique TermType during the certification process.</b>', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(545, 0, 'plugin_globalpay_Demo Mode', '0', '', 'Select YES if you want to set Global Payments into Demo Mode for testing. (<b>NOTE:</b> You must set to NO before accepting actual payments through this processor.)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(546, 0, 'plugin_globalpay_Accept CC Number', '1', '', 'Selecting YES allows the entering of CC numbers when using this plugin type. No will prevent entering of cc information', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(547, 0, 'plugin_globalpay_Visa', '0', '', 'Select YES to allow Visa card acceptance with this plugin.  No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(548, 0, 'plugin_globalpay_MasterCard', '0', '', 'Select YES to allow MasterCard acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(549, 0, 'plugin_globalpay_AmericanExpress', '0', '', 'Select YES to allow American Express card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(550, 0, 'plugin_globalpay_Discover', '0', '', 'Select YES to allow Discover card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(551, 0, 'plugin_globalpay_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(552, 0, 'plugin_globalpay_Signup Name', 'Credit Card', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(553, 0, 'plugin_globalpay_Dummy Plugin', '0', '', '1 = Only used to specify a billing type for a client. 0 = full fledged plugin requiring complete functions', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(554, 0, 'plugin_globalpay_Auto Payment', '1', '', 'No description', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(555, 0, 'plugin_globalpay_Check CVV2', '1', '', 'Select YES if you want to accept CVV2 for this plugin.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(556, 0, 'plugin_linkpoint_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(557, 0, 'plugin_linkpoint_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(558, 0, 'plugin_linkpoint_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(559, 0, 'plugin_linkpoint_Plugin Name', 'LinkPoint', '', 'How CE sees this plugin ( not to be confused with the Signup Name )', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(560, 0, 'plugin_linkpoint_Store', '', '', 'Please enter your LinkPoint store Name.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(561, 0, 'plugin_linkpoint_Host', 'secure.linkpt.net', '', 'Please enter your linkpoint host.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(562, 0, 'plugin_linkpoint_Port', '1129', '', 'Please enter your linkpoint port.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(563, 0, 'plugin_linkpoint_Cert', '/path/to/linkpoint.pem', '', 'Please enter the path to your Linkpoint Digital Certificate.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(564, 0, 'plugin_linkpoint_RiskThreshold', '', '', 'The LinkShield Risk Score at which you decline transactions.<br>(only used if LinkShield is available with your merchant account)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(565, 0, 'plugin_linkpoint_Live', '', '', 'Select Yes to run live transactions, No to run Demo Transactions', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(566, 0, 'plugin_linkpoint_Demo Approve', '', '', 'Select yes to approve transactions in Demo Mode and no to decline transactions in DemoMode', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(567, 0, 'plugin_linkpoint_Accept CC Number', '1', '', 'Selecting YES allows the entering of CC numbers when using this plugin type. No will prevent entering of cc information', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(568, 0, 'plugin_linkpoint_Visa', '1', '', 'Select YES to allow Visa card acceptance with this plugin.  No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(569, 0, 'plugin_linkpoint_MasterCard', '1', '', 'Select YES to allow MasterCard acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(570, 0, 'plugin_linkpoint_AmericanExpress', '1', '', 'Select YES to allow American Express card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(571, 0, 'plugin_linkpoint_Discover', '0', '', 'Select YES to allow Discover card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(572, 0, 'plugin_linkpoint_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to client after signup is complete.  Only used for offline plugins', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(573, 0, 'plugin_linkpoint_Signup Name', 'Credit Card', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(574, 0, 'plugin_linkpoint_Dummy Plugin', '0', '', '1 = Only used to specify a billing type for a client. 0 = full fledged plugin requiring complete functions', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(575, 0, 'plugin_linkpoint_Auto Payment', '1', '', 'No description', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(576, 0, 'plugin_linkpoint_Check CVV2', '1', '', 'Select YES if you want to accept CVV2 for this plugin.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(577, 0, 'plugin_mollie_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(578, 0, 'plugin_mollie_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(579, 0, 'plugin_mollie_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(580, 0, 'plugin_mollie_Plugin Name', 'Mollie', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(581, 0, 'plugin_mollie_API Key', '', '', 'Mollie API Key. For test mode, use the test API key from your Mollie account.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(582, 0, 'plugin_mollie_Signup Name', 'Mollie', '', 'Select the name to display in the signup process for this payment type. Example: Mollie iDeal.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(583, 0, 'plugin_moneybookers_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(584, 0, 'plugin_moneybookers_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(585, 0, 'plugin_moneybookers_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(586, 0, 'plugin_moneybookers_Plugin Name', 'Money Bookers', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(587, 0, 'plugin_moneybookers_Merchant E-mail', '', '', 'E-mail address used to identify you to Moneybookers.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(588, 0, 'plugin_moneybookers_Secret Word', '', '', 'Secret word set in your Money Bookers account.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(589, 0, 'plugin_moneybookers_Status E-mail', '', '', 'E-mail address to where you want Moneybookers to send a copy of the transaction details after the payment process is complete. (Optional)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(590, 0, 'plugin_moneybookers_Visa', '0', '', 'Select YES to allow Visa card acceptance with this plugin.  No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(591, 0, 'plugin_moneybookers_MasterCard', '0', '', 'Select YES to allow MasterCard acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(592, 0, 'plugin_moneybookers_AmericanExpress', '0', '', 'Select YES to allow American Express card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(593, 0, 'plugin_moneybookers_Discover', '0', '', 'Select YES to allow Discover card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(594, 0, 'plugin_moneybookers_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(595, 0, 'plugin_moneybookers_Signup Name', 'Money Bookers', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(596, 0, 'plugin_moneybookers_Dummy Plugin', '0', '', '1 = Only used to specify a billing type for a client. 0 = full fledged plugin requiring complete functions', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(597, 0, 'plugin_moneybookers_Accept CC Number', '0', '', 'Selecting YES allows the entering of CC numbers when using this plugin type. No will prevent entering of cc information', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(598, 0, 'plugin_moneybookers_Auto Payment', '0', '', 'No description', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(599, 0, 'plugin_moneybookers_Check CVV2', '0', '', 'Select YES if you want to accept CVV2 for this plugin.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(600, 0, 'plugin_offlinebanktransfer_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(601, 0, 'plugin_offlinebanktransfer_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(602, 0, 'plugin_offlinebanktransfer_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(603, 0, 'plugin_offlinebanktransfer_Plugin Name', 'Bank Transfer', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(604, 0, 'plugin_offlinebanktransfer_Visa', '0', '', 'Select YES to allow Visa card acceptance with this plugin.  No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(605, 0, 'plugin_offlinebanktransfer_MasterCard', '0', '', 'Select YES to allow MasterCard acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(606, 0, 'plugin_offlinebanktransfer_AmericanExpress', '0', '', 'Select YES to allow American Express card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(607, 0, 'plugin_offlinebanktransfer_Discover', '0', '', 'Select YES to allow Discover card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(608, 0, 'plugin_offlinebanktransfer_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(609, 0, 'plugin_offlinebanktransfer_Signup Name', 'Bank Transfer', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(610, 0, 'plugin_offlinebanktransfer_Dummy Plugin', '1', '', '1 = Only used to specify a billing type for a client. 0 = full fledged plugin requiring complete functions', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(611, 0, 'plugin_offlinebanktransfer_Accept CC Number', '0', '', 'Selecting YES allows the entering of CC numbers when using this plugin type. No will prevent entering of cc information', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(612, 0, 'plugin_offlinebanktransfer_Auto Payment', '0', '', 'No description', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(613, 0, 'plugin_offlinebanktransfer_Check CVV2', '0', '', 'Select YES if you want to accept CVV2 for this plugin.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(614, 0, 'plugin_offlinecheck_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(615, 0, 'plugin_offlinecheck_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(616, 0, 'plugin_offlinecheck_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(617, 0, 'plugin_offlinecheck_Plugin Name', 'Check', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(618, 0, 'plugin_offlinecheck_Visa', '0', '', 'Select YES to allow Visa card acceptance with this plugin.  No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(619, 0, 'plugin_offlinecheck_MasterCard', '0', '', 'Select YES to allow MasterCard acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(620, 0, 'plugin_offlinecheck_AmericanExpress', '0', '', 'Select YES to allow American Express card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(621, 0, 'plugin_offlinecheck_Discover', '0', '', 'Select YES to allow Discover card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(622, 0, 'plugin_offlinecheck_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(623, 0, 'plugin_offlinecheck_Signup Name', 'Check', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(624, 0, 'plugin_offlinecheck_Dummy Plugin', '1', '', '1 = Only used to specify a billing type for a client. 0 = full fledged plugin requiring complete functions', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(625, 0, 'plugin_offlinecheck_Accept CC Number', '0', '', 'Selecting YES allows the entering of CC numbers when using this plugin type. No will prevent entering of cc information', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(626, 0, 'plugin_offlinecheck_Auto Payment', '0', '', 'No description', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(627, 0, 'plugin_offlinecheck_Check CVV2', '0', '', 'Select YES if you want to accept CVV2 for this plugin.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(628, 0, 'plugin_offlinecreditcard_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(629, 0, 'plugin_offlinecreditcard_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(630, 0, 'plugin_offlinecreditcard_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(631, 0, 'plugin_offlinecreditcard_Plugin Name', 'Generic Credit Card', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(632, 0, 'plugin_offlinecreditcard_Visa', '1', '', 'Select YES to allow Visa card acceptance with this plugin.  No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(633, 0, 'plugin_offlinecreditcard_MasterCard', '1', '', 'Select YES to allow MasterCard acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(634, 0, 'plugin_offlinecreditcard_AmericanExpress', '0', '', 'Select YES to allow American Express card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(635, 0, 'plugin_offlinecreditcard_Discover', '0', '', 'Select YES to allow Discover card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(636, 0, 'plugin_offlinecreditcard_LaserCard', '1', '', 'Select YES to allow LaserCard card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(637, 0, 'plugin_offlinecreditcard_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(638, 0, 'plugin_offlinecreditcard_Signup Name', 'Credit Card', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(639, 0, 'plugin_offlinecreditcard_Accept CC Number', '1', '', 'Selecting YES allows the entering of CC numbers when using this plugin type. No will prevent entering of cc information', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(640, 0, 'plugin_offlinecreditcard_Dummy Plugin', '1', '', '1 = Only used to specify a billing type for a client. 0 = full fledged plugin requiring complete functions', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(641, 0, 'plugin_offlinecreditcard_Auto Payment', '0', '', 'No description', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(642, 0, 'plugin_offlinecreditcard_Check CVV2', '0', '', 'Select YES if you want to accept CVV2 for this plugin.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(643, 0, 'plugin_offlinemoneyorder_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(644, 0, 'plugin_offlinemoneyorder_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(645, 0, 'plugin_offlinemoneyorder_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(646, 0, 'plugin_offlinemoneyorder_Plugin Name', 'Money Order', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(647, 0, 'plugin_offlinemoneyorder_Visa', '0', '', 'Select YES to allow Visa card acceptance with this plugin.  No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(648, 0, 'plugin_offlinemoneyorder_MasterCard', '0', '', 'Select YES to allow MasterCard acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(649, 0, 'plugin_offlinemoneyorder_AmericanExpress', '0', '', 'Select YES to allow American Express card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(650, 0, 'plugin_offlinemoneyorder_Discover', '0', '', 'Select YES to allow Discover card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(651, 0, 'plugin_offlinemoneyorder_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(652, 0, 'plugin_offlinemoneyorder_Signup Name', 'Money Order', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(653, 0, 'plugin_offlinemoneyorder_Accept CC Number', '0', '', 'Selecting YES allows the entering of CC numbers when using this plugin type. No will prevent entering of cc information', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(654, 0, 'plugin_offlinemoneyorder_Dummy Plugin', '1', '', '1 = Only used to specify a billing type for a client. 0 = full fledged plugin requiring complete functions', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(655, 0, 'plugin_offlinemoneyorder_Auto Payment', '0', '', 'No description', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(656, 0, 'plugin_offlinemoneyorder_Check CVV2', '0', '', 'Select YES if you want to accept CVV2 for this plugin.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(657, 0, 'plugin_onebip_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(658, 0, 'plugin_onebip_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(659, 0, 'plugin_onebip_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(660, 0, 'plugin_onebip_Plugin Name', 'Onebip', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(661, 0, 'plugin_onebip_User ID', '', '', 'The email address associated to your Onebip account.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(662, 0, 'plugin_onebip_API Key', '', '', 'Please enter your API Key for your Onebip here. The API Key can be set under the &quot;My Account&quot; section of your Onebip account.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(663, 0, 'plugin_onebip_Onebip Payment Fee', '0', '', 'A percentage to increase the amount to charge, due to the high Onebip payment fees. For example, a value of 20 (20%) will charge an amount of $120 for an invoice of $100', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(664, 0, 'plugin_onebip_Signup Name', 'Onebip', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(665, 0, 'plugin_onebip_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(666, 0, 'plugin_payfast_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(667, 0, 'plugin_payfast_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(668, 0, 'plugin_payfast_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(669, 0, 'plugin_payfast_Plugin Name', 'Payfast', '', 'How CE sees this plugin ( not to be confused with the Signup Name )', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(670, 0, 'plugin_payfast_Merchant ID', '', '', 'Your PayFast Merchant ID', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(671, 0, 'plugin_payfast_Merchant Key', '', '', 'Your PayFast Merchant Key', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(672, 0, 'plugin_payfast_Passphrase', '', '', 'Your PayFast Passphrase', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(673, 0, 'plugin_payfast_Source IP Security Check?', '1', '', 'Select to ensure the callback comes from a PayFast IP.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(674, 0, 'plugin_payfast_Test Mode?', '0', '', 'Select to enable test/sandbox mode', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(675, 0, 'plugin_payfast_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(676, 0, 'plugin_payfast_Signup Name', 'PayFast', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(677, 0, 'plugin_paypal_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(678, 0, 'plugin_paypal_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(679, 0, 'plugin_paypal_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(680, 0, 'plugin_paypal_Plugin Name', 'Paypal', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(681, 0, 'plugin_paypal_User ID', '', '', 'The email used to identify you to PayPal.<br>NOTE: The email is required if you have selected PayPal as a payment gateway for any of your clients.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(682, 0, 'plugin_paypal_Signup Name', 'Credit Card, eCheck, or Paypal', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(683, 0, 'plugin_paypal_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(684, 0, 'plugin_paypal_Use PayPal Sandbox', '0', '', 'Select YES if you want to use Paypal&#039;s testing server, so no actual monetary transactions are made. You need to have a developer account with Paypal, and be logged-in in the developer panel in another browser window for the transaction to be successful.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(685, 0, 'plugin_paypal_Paypal Subscriptions Option', '', '', 'Determine if you are going to use subscriptions for recurring charges.<ul><li>Please avoid using <b>&quot;Duration in months&quot;</b> in your recurring fees if you are planning to use Paypal Subscriptions. The subscription will be unlimited until manually canceled either by you, your client or Paypal if lack of funds, etc.</li><li>Subscriptions will be created after a payment is completed by the client, as long as the invoice was paid before becoming overdue.</li><li>Subscriptions will not be created if the invoice has prorated items, or with billing cycles greater than 5 years (Old API), or with billing cycles greater than 1 year (New API).</li></ul>', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(686, 0, 'plugin_paypal_Image URL', '', '', 'Please enter the URL of the image you would like displayed. The recommended dimensions are 150 x 50 px. PayPal now consider the image as a logo to display in the upper left corner.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(687, 0, 'plugin_paypal_Separate Taxes', '0', '', 'Select YES if you want to pass amount and taxes separated to this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(688, 0, 'plugin_paypal_Check CVV2', '0', '', 'Select YES if you want to accept CVV2 for this plugin.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(689, 0, 'plugin_paypal_API Username', '', '', 'Please enter your API Username.<br><b>Required to do refunds or cancel subscriptions.</b>', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(690, 0, 'plugin_paypal_API Password', '', '', 'Please enter your API Password.<br><b>Required to do refunds or cancel subscriptions.</b>', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(691, 0, 'plugin_paypal_API Signature', '', '', 'Please enter your API Signature.<br><b>Required to do refunds or cancel subscriptions.</b>', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(692, 0, 'plugin_paypal_API Client ID', '', '', 'Please enter your API Client ID.<br><b>Required to use the new API.</b><br>To get this value, you need to login to <a href=&quot;https://developer.paypal.com&quot; target=&quot;_blank&quot;>https://developer.paypal.com</a> using your live PayPal account credentials and then follow the instructions below:<ul><li>Go to Dashboard > My Apps & Credentials</li><li>Go to REST API Apps > Create App</li><li>Enter a name for the app and generate an app</li><li>Once the App is generated, click on the App > Select &quot;Live&quot; mode and then you will see the live &quot;Client ID&quot; and &quot;Secret&quot;</li></ul><b>NOTE:</b> Make sure to create one app per each Clientexec installation you use, or it could lead to issues.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(693, 0, 'plugin_paypal_Form', '1', '', 'Has a form to be loaded?  1 = YES, 0 = NO<br><b>Required to use the new API.</b>', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(694, 0, 'plugin_paypal_API Secret', '', '', 'Please enter your API Secret.<br><b>Required to do subscriptions using the new API.</b><br>To get this value, you need to login to <a href=&quot;https://developer.paypal.com&quot; target=&quot;_blank&quot;>https://developer.paypal.com</a> using your live PayPal account credentials and then follow the instructions below:<ul><li>Go to Dashboard > My Apps & Credentials</li><li>Go to REST API Apps > Create App</li><li>Enter a name for the app and generate an app</li><li>Once the App is generated, click on the App > Select &quot;Live&quot; mode and then you will see the live &quot;Client ID&quot; and &quot;Secret&quot;</li></ul><b>NOTE:</b> Make sure to create one app per each Clientexec installation you use, or it could lead to issues.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(695, 0, 'plugin_paypalpro_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(696, 0, 'plugin_paypalpro_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(697, 0, 'plugin_paypalpro_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(698, 0, 'plugin_paypalpro_Plugin Name', 'Paypal Pro', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(699, 0, 'plugin_paypalpro_Use PayPal Sandbox', '0', '', 'Select YES if you want to use the PayPal testing server, so no actual monetary transactions are made. You need to have a developer account with Paypal. Enter the API credentials from your Sandbox account below.  To test it, you must be logged into the developer panel (developer.paypal.com) in another browser window for the transaction to be successful.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(700, 0, 'plugin_paypalpro_API Username', '', '', 'Enter your PayPal API Username Here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(701, 0, 'plugin_paypalpro_API Password', '', '', 'Enter your PayPal API Password Here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(702, 0, 'plugin_paypalpro_API Signature', '', '', 'Enter your PayPal API Signature Here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(703, 0, 'plugin_paypalpro_Accept CC Number', '1', '', 'Selecting YES allows the entering of CC numbers when using this plugin type. No will prevent entering of cc information.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0);
INSERT INTO `setting` VALUES
(704, 0, 'plugin_paypalpro_Visa', '1', '', 'Select YES to allow Visa card acceptance with this plugin.  No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(705, 0, 'plugin_paypalpro_MasterCard', '1', '', 'Select YES to allow MasterCard acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(706, 0, 'plugin_paypalpro_AmericanExpress', '1', '', 'Select YES to allow American Express card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(707, 0, 'plugin_paypalpro_Discover', '1', '', 'Select YES to allow Discover card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(708, 0, 'plugin_paypalpro_Invoice After Signup', '0', '', 'Select YES if you want an invoice sent to the client after signup is complete.  NOTE: PayPal Website Payments Pro does not send a receipt for this payment type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(709, 0, 'plugin_paypalpro_Signup Name', 'Credit Card', '', 'Select the name to display in the signup process for this payment type. Example: Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(710, 0, 'plugin_paypalpro_Dummy Plugin', '0', '', '1 = Only used to specify a billing type for a client. 0 = full fledged plugin requiring complete functions', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(711, 0, 'plugin_paypalpro_Auto Payment', '1', '', 'No description', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(712, 0, 'plugin_paypalpro_Check CVV2', '1', '', 'PayPal Pro requires CVV2 checking.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(713, 0, 'plugin_paystack_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(714, 0, 'plugin_paystack_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(715, 0, 'plugin_paystack_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(716, 0, 'plugin_paystack_Plugin Name', 'Paystack (Debit/Credit Cards)', '', 'How CE sees this plugin ( not to be confused with the Signup Name )', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(717, 0, 'plugin_paystack_Test Mode', '', '', 'Enable this option to enable Test Mode', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(718, 0, 'plugin_paystack_Live Secret Key', '', '', 'Enter your Live Secret Key here', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(719, 0, 'plugin_paystack_Live Public Key', '', '', 'Enter your Live Public Key here', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(720, 0, 'plugin_paystack_Test Secret Key', '', '', 'Enter your Test Secret Key here', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(721, 0, 'plugin_paystack_Test Public Key', '', '', 'Enter your Test Public Key here', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(722, 0, 'plugin_paystack_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(723, 0, 'plugin_paystack_Signup Name', 'Paystack (Debit/Credit Cards)', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(724, 0, 'plugin_paystack_Dummy Plugin', '0', '', '1 = Only used to specify a billing type for a client. 0 = full fledged plugin requiring complete functions', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(725, 0, 'plugin_paystack_Auto Payment', '0', '', 'No description', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(726, 0, 'plugin_paystack_Form', '1', '', 'Has a form to be loaded?  1 = YES, 0 = NO', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(727, 0, 'plugin_paytr_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(728, 0, 'plugin_paytr_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(729, 0, 'plugin_paytr_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(730, 0, 'plugin_paytr_Plugin Name', 'PayTR', '', 'How CE sees this plugin ( not to be confused with the Signup Name )', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(731, 0, 'plugin_paytr_Merchant ID', '', '', 'Enter your Merchant ID.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(732, 0, 'plugin_paytr_Merchant Key', '', '', 'Enter your Merchant Key.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(733, 0, 'plugin_paytr_Merchant Salt', '', '', 'Enter your Merchant Salt.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(734, 0, 'plugin_paytr_Test Mode?', '0', '', 'Select YES if you want to use PayTR&#039;s test mode.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(735, 0, 'plugin_paytr_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(736, 0, 'plugin_paytr_Signup Name', 'PayTR', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(737, 0, 'plugin_paytr_Dummy Plugin', '0', '', '1 = Only used to specify a billing type for a client. 0 = full fledged plugin requiring complete functions', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(738, 0, 'plugin_paytr_Auto Payment', '0', '', 'No description', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(739, 0, 'plugin_paytr_Form', '0', '', 'Has a form to be loaded?  1 = YES, 0 = NO', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(740, 0, 'plugin_payza_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(741, 0, 'plugin_payza_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(742, 0, 'plugin_payza_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(743, 0, 'plugin_payza_Plugin Name', 'Payza', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(744, 0, 'plugin_payza_User ID', '', '', 'ID used to identify you to Payza.<br>NOTE: This ID is required if you have selected Payza as a payment gateway for any of your clients.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(745, 0, 'plugin_payza_Security Code', '', '', 'Security Code in your Payza IPN setup.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(746, 0, 'plugin_payza_Signup Name', 'Payza', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(747, 0, 'plugin_payza_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(748, 0, 'plugin_payza_Use Test Mode', '0', '', 'Select YES if you want to use Payza in test mode. You need to make sure in your IPN settings of Payza you have enabled Test mode', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(749, 0, 'plugin_payza_Check CVV2', '0', '', 'Select YES if you want to accept CVV2 for this plugin.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(750, 0, 'plugin_pesapal_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(751, 0, 'plugin_pesapal_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(752, 0, 'plugin_pesapal_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(753, 0, 'plugin_pesapal_Plugin Name', 'Pesapal', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(754, 0, 'plugin_pesapal_Consumer Key', '', '', 'Please enter your pesapal consumer key.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(755, 0, 'plugin_pesapal_Consumer Secret', '', '', 'Please enter your pesapal consumer secret.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(756, 0, 'plugin_pesapal_Test Mode', '0', '', 'Enable this to use the test API.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(757, 0, 'plugin_pesapal_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(758, 0, 'plugin_pesapal_Signup Name', 'Pay with Pesapal', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(759, 0, 'plugin_pesapal_Dummy Plugin', '0', '', '1 = Only used to specify a billing type for a client. 0 = full fledged plugin requiring complete functions', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(760, 0, 'plugin_pesapal_Auto Payment', '0', '', 'No description', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(761, 0, 'plugin_pesapal_Check CVV2', '0', '', 'Select YES if you want to accept CVV2 for this plugin.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(762, 0, 'plugin_pesapal_Update Gateway', '0', '', '1 = Create, update or remove Gateway client information through the function UpdateGateway when client choose to use this gateway, client profile is updated, client is deleted or client status is changed. 0 = Do nothing.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(763, 0, 'plugin_protxform_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(764, 0, 'plugin_protxform_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(765, 0, 'plugin_protxform_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(766, 0, 'plugin_protxform_Plugin Name', 'Protx', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(767, 0, 'plugin_protxform_Vendor ID', '', '', 'Vendor ID used to identify you to protx.<br>NOTE: This ID is required if you have selected protx as a payment gateway for any of your clients.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(768, 0, 'plugin_protxform_Crypt Password', '', '', 'Password used to crypt payment information.<br>NOTE: This password has to match the value set by protx.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(769, 0, 'plugin_protxform_Vendor E-mail', '', '', 'This E-mail is sent from protx to inform the client of the transaction.  You need to set this to your E-mail address that you want bills to come from.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(770, 0, 'plugin_protxform_Visa', '1', '', 'Select YES to allow Visa card acceptance with this plugin.  No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(771, 0, 'plugin_protxform_MasterCard', '1', '', 'Select YES to allow MasterCard acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(772, 0, 'plugin_protxform_AmericanExpress', '0', '', 'Select YES to allow American Express card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(773, 0, 'plugin_protxform_Discover', '0', '', 'Select YES to allow Discover card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(774, 0, 'plugin_protxform_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(775, 0, 'plugin_protxform_Signup Name', 'Credit Card', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(776, 0, 'plugin_protxform_Accept CC Number', '0', '', 'Selecting YES allows the entering of CC numbers when using this plugin type. No will prevent entering of cc information', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(777, 0, 'plugin_protxform_Dummy Plugin', '0', '', '1 = Only used to specify a billing type for a client. 0 = full fledged plugin requiring complete functions', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(778, 0, 'plugin_protxform_Auto Payment', '0', '', 'No description', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(779, 0, 'plugin_protxform_Demo Mode', '0', '', 'Select YES to send all transactions to the demo form processor', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(780, 0, 'plugin_protxform_Check CVV2', '0', '', 'Select YES if you want to accept CVV2 for this plugin.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(781, 0, 'plugin_psigate_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(782, 0, 'plugin_psigate_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(783, 0, 'plugin_psigate_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(784, 0, 'plugin_psigate_Plugin Name', 'PSiGate', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(785, 0, 'plugin_psigate_Store Name', '', '', 'ID used to identify you to PSiGate.<br>NOTE: This ID is required if you have selected PSiGate as a payment gateway for any of your clients.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(786, 0, 'plugin_psigate_Passphrase', '', '', 'Your PSiGate passphrase used to authenticate a valid transaction.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(787, 0, 'plugin_psigate_Demo Mode', '1', '', 'Select YES if you want to set this plugin in Demo mode for testing purposes.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(788, 0, 'plugin_psigate_Visa', '1', '', 'Select YES to allow Visa card acceptance with this plugin.  No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(789, 0, 'plugin_psigate_MasterCard', '1', '', 'Select YES to allow MasterCard acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(790, 0, 'plugin_psigate_AmericanExpress', '0', '', 'Select YES to allow American Express card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(791, 0, 'plugin_psigate_Discover', '0', '', 'Select YES to allow Discover card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(792, 0, 'plugin_psigate_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(793, 0, 'plugin_psigate_Signup Name', 'Credit Card', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(794, 0, 'plugin_psigate_Accept CC Number', '1', '', 'Selecting YES allows the entering of CC numbers when using this plugin type. No will prevent entering of cc information', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(795, 0, 'plugin_psigate_Dummy Plugin', '0', '', '1 = Only used to specify a billing type for a client. 0 = full fledged plugin requiring complete functions', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(796, 0, 'plugin_psigate_Auto Payment', '1', '', 'No description', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(797, 0, 'plugin_psigate_Check CVV2', '1', '', 'Select YES if you want to accept CVV2 for this plugin.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(798, 0, 'plugin_quantum_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(799, 0, 'plugin_quantum_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(800, 0, 'plugin_quantum_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(801, 0, 'plugin_quantum_Plugin Name', 'Quantum Gateway', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(802, 0, 'plugin_quantum_Use Verify By Visa and MasterCard SecureCode', '0', '', 'Be sure to have these services enabled in your gateway before attempting to use them.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(803, 0, 'plugin_quantum_Use DialVerify Service', '0', '', 'Be sure to have this service enabled in your gateway before attempting to use it.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(804, 0, 'plugin_quantum_Use Maxmind', '0', '', 'Use Quantum Gateway&#039;s Maxmind fraud screening services.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(805, 0, 'plugin_quantum_Quantum Gateway Username', '', '', 'Please enter your Quantum Gateway Username Here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(806, 0, 'plugin_quantum_Quantum Gateway RestrictKey', '', '', 'Please enter your Quantum Gateway RestrictKey Here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(807, 0, 'plugin_quantum_Accept CC Number', '1', '', 'Selecting YES allows the entering of CC numbers when using this plugin type. No will prevent entering of cc information', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(808, 0, 'plugin_quantum_Visa', '1', '', 'Select YES to allow Visa card acceptance with this plugin.  No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(809, 0, 'plugin_quantum_MasterCard', '1', '', 'Select YES to allow MasterCard acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(810, 0, 'plugin_quantum_AmericanExpress', '1', '', 'Select YES to allow American Express card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(811, 0, 'plugin_quantum_Discover', '0', '', 'Select YES to allow Discover card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(812, 0, 'plugin_quantum_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(813, 0, 'plugin_quantum_Signup Name', 'Credit Card', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(814, 0, 'plugin_quantum_Payment Form Title', '', '', 'The Payment Form will only be displayed when extra user input is required, i.e. when using Verified By Visa, MaterCard SecureCode or DialVerify.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(815, 0, 'plugin_quantum_Payment Form Header', '', '', 'The Payment Form will only be displayed when extra user input is required, i.e. when using Verified By Visa, MaterCard SecureCode or DialVerify. HTML is accepted.', 6, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0),
(816, 0, 'plugin_quantum_Receipt Page Header', '', '', 'The Receipt Page will only be displayed when extra user input is required, i.e. when using Verified By Visa, MaterCard SecureCode or DialVerify. HTML is accepted.', 6, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0),
(817, 0, 'plugin_quantum_Receipt Page Footer', '', '', 'The Receipt Footer will only be displayed when extra user input is required, i.e. when using Verified By Visa, MaterCard SecureCode or DialVerify. HTML is accepted.', 6, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0),
(818, 0, 'plugin_quantum_Dummy Plugin', '0', '', '1 = Only used to specify a billing type for a client. 0 = full fledged plugin requiring complete functions', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(819, 0, 'plugin_quantum_Auto Payment', '1', '', 'No description', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(820, 0, 'plugin_quantum_Check CVV2', '1', '', 'Select YES if you want to accept CVV2 for this plugin.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(821, 0, 'plugin_quantumvault_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(822, 0, 'plugin_quantumvault_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(823, 0, 'plugin_quantumvault_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(824, 0, 'plugin_quantumvault_Plugin Name', 'Quantum Vault Gateway', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(825, 0, 'plugin_quantumvault_Use Maxmind', '0', '', 'Use Quantum Vault Gateway&#039;s Maxmind fraud screening services.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(826, 0, 'plugin_quantumvault_Quantum Vault Gateway Username', '', '', 'Please enter your Quantum Vault Gateway Username Here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(827, 0, 'plugin_quantumvault_Quantum Vault Gateway VaultKey', '', '', 'Please enter your Quantum Vault Gateway VaultKey Here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(828, 0, 'plugin_quantumvault_Quantum Vault Gateway RestrictKey', '', '', 'Please enter your Quantum Vault Gateway RestrictKey Here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(829, 0, 'plugin_quantumvault_Quantum Vault Gateway Inline Frame API Username', '', '', 'Please enter your Quantum Vault Gateway Inline Frame API Username Here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(830, 0, 'plugin_quantumvault_Quantum Vault Gateway Inline Frame API Key', '', '', 'Please enter your Quantum Vault Gateway Inline Frame API Key Here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(831, 0, 'plugin_quantumvault_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(832, 0, 'plugin_quantumvault_Signup Name', 'Credit Card', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(833, 0, 'plugin_quantumvault_Payment Form Title', '', '', 'The Payment Form will only be displayed when extra user input is required, i.e. when using Verified By Visa, MaterCard SecureCode or DialVerify.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(834, 0, 'plugin_quantumvault_Payment Form Header', '', '', 'The Payment Form will only be displayed when extra user input is required, i.e. when using Verified By Visa, MaterCard SecureCode or DialVerify. HTML is accepted.', 6, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0),
(835, 0, 'plugin_quantumvault_Receipt Page Header', '', '', 'The Receipt Page will only be displayed when extra user input is required, i.e. when using Verified By Visa, MaterCard SecureCode or DialVerify. HTML is accepted.', 6, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0),
(836, 0, 'plugin_quantumvault_Receipt Page Footer', '', '', 'The Receipt Footer will only be displayed when extra user input is required, i.e. when using Verified By Visa, MaterCard SecureCode or DialVerify. HTML is accepted.', 6, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0),
(837, 0, 'plugin_quantumvault_Dummy Plugin', '0', '', '1 = Only used to specify a billing type for a client. 0 = full fledged plugin requiring complete functions', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(838, 0, 'plugin_quantumvault_Auto Payment', '1', '', 'No description', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(839, 0, 'plugin_quantumvault_CC Stored Outside', '1', '', 'If this plugin is Auto Payment, is Credit Card stored outside of Clientexec? 1 = YES, 0 = NO', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(840, 0, 'plugin_quantumvault_Iframe Configuration', 'width=&quot;100%&quot; height=&quot;300&quot; scrolling=&quot;auto&quot; frameborder=&quot;0&quot;', '', 'Parameters to be used in the iframe when loaded, like: width, height, scrolling, frameborder', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(841, 0, 'plugin_quantumvault_Check CVV2', '0', '', 'Select YES if you want to accept CVV2 for this plugin.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(842, 0, 'plugin_quantumvault_Update Gateway', '1', '', '1 = Create, update or remove Gateway client information through the function UpdateGateway when client choose to use this gateway, client profile is updated, client is deleted or client status is changed. 0 = Do nothing.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(843, 0, 'plugin_razorpay_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(844, 0, 'plugin_razorpay_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(845, 0, 'plugin_razorpay_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(846, 0, 'plugin_razorpay_Plugin Name', 'Razorpay', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(847, 0, 'plugin_razorpay_Key Id', '', '', 'Razorpay Key Id.<br><b>NOTE:</b> This Key Id is required if you have selected Razorpay as a payment gateway for any of your clients.<br>You can get it from <a href=&#039;https://dashboard.razorpay.com/#/app/keys&#039; target=&#039;_blank&#039;>here</a>', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(848, 0, 'plugin_razorpay_Key Secret', '', '', 'Razorpay Key Secret shared during activation API Key.<br><b>NOTE:</b> This Key Secret is required if you have selected Razorpay as a payment gateway for any of your clients.<br>You can get it from <a href=&#039;https://dashboard.razorpay.com/#/app/keys&#039; target=&#039;_blank&#039;>here</a>', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(849, 0, 'plugin_razorpay_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(850, 0, 'plugin_razorpay_Signup Name', 'Razorpay', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(851, 0, 'plugin_razorpay_Razorpay Logo Image URL', '', '', 'A relative or absolute URL pointing to a square image of your brand or product.</br>The recommended minimum size is 128x128px.</br>The recommended image types are .gif, .jpeg, and .png.</br>Leave this field empty to use the default image.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(852, 0, 'plugin_razorpay_Dummy Plugin', '0', '', '1 = Only used to specify a billing type for a client. 0 = full fledged plugin requiring complete functions', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(853, 0, 'plugin_razorpay_Auto Payment', '0', '', 'No description', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(854, 0, 'plugin_razorpay_Form', '1', '', 'Has a form to be loaded?  1 = YES, 0 = NO', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(855, 0, 'plugin_razorpay_Check CVV2', '0', '', 'Select YES if you want to accept CVV2 for this plugin.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(856, 0, 'plugin_realauth_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(857, 0, 'plugin_realauth_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(858, 0, 'plugin_realauth_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(859, 0, 'plugin_realauth_Plugin Name', 'RealAuth Gateway', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(860, 0, 'plugin_realauth_RealAuth Merchant ID', '', '', 'Please enter your Realex Payments Assigned Merchant ID Here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(861, 0, 'plugin_realauth_RealAuth Shared Secret', '', '', 'Please enter your Realex Payments Shared Secret Here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(862, 0, 'plugin_realauth_RealAuth Subaccount', '', '', 'Please enter your Realex Payments Subaccount to use Here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(863, 0, 'plugin_realauth_Accept CC Number', '1', '', 'Selecting YES allows the entering of CC numbers when using this plugin type. No will prevent entering of cc information', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(864, 0, 'plugin_realauth_Visa', '1', '', 'Select YES to allow Visa card acceptance with this plugin.  No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(865, 0, 'plugin_realauth_MasterCard', '1', '', 'Select YES to allow MasterCard acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(866, 0, 'plugin_realauth_AmericanExpress', '1', '', 'Select YES to allow American Express card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(867, 0, 'plugin_realauth_LaserCard', '1', '', 'Select YES to allow LaserCard card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(868, 0, 'plugin_realauth_DinersClub', '1', '', 'Select YES to allow Diners Club card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(869, 0, 'plugin_realauth_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(870, 0, 'plugin_realauth_Signup Name', 'Credit Card', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(871, 0, 'plugin_realauth_Payment Form Title', '', '', 'The Payment Form will only be displayed when extra user input is required, i.e. when using Verified By Visa, MaterCard SecureCode or DialVerify.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(872, 0, 'plugin_realauth_Payment Form Header', '', '', 'The Payment Form will only be displayed when extra user input is required, i.e. when using Verified By Visa, MaterCard SecureCode or DialVerify. HTML is accepted.', 6, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0),
(873, 0, 'plugin_realauth_Receipt Page Header', '', '', 'The Receipt Page will only be displayed when extra user input is required, i.e. when using Verified By Visa, MaterCard SecureCode or DialVerify. HTML is accepted.', 6, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0),
(874, 0, 'plugin_realauth_Receipt Page Footer', '', '', 'The Receipt Footer will only be displayed when extra user input is required, i.e. when using Verified By Visa, MaterCard SecureCode or DialVerify. HTML is accepted.', 6, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0),
(875, 0, 'plugin_realauth_Dummy Plugin', '0', '', '1 = Only used to specify a billing type for a client. 0 = full fledged plugin requiring complete functions', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(876, 0, 'plugin_realauth_Auto Payment', '1', '', 'No description', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(877, 0, 'plugin_realauth_Check CVV2', '0', '', 'Select YES if you want to accept CVV2 for this plugin.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(878, 0, 'plugin_shurjopay_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(879, 0, 'plugin_shurjopay_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(880, 0, 'plugin_shurjopay_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(881, 0, 'plugin_shurjopay_Plugin Name', 'ShurjoPay', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(882, 0, 'plugin_shurjopay_Signup Name', 'Shurjopay', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(883, 0, 'plugin_shurjopay_API Username', '', '', 'Enter you API Username Here', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(884, 0, 'plugin_shurjopay_API Password', '', '', 'Enter you API Password Here', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(885, 0, 'plugin_shurjopay_Transaction Prefix', '', '', 'Enter you Transaction Prefix Here', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(886, 0, 'plugin_shurjopay_Test Mode', '', '', 'Enable Test Mode', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(887, 0, 'plugin_squarepayment_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(888, 0, 'plugin_squarepayment_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(889, 0, 'plugin_squarepayment_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(890, 0, 'plugin_squarepayment_Plugin Name', 'Square Payment', '', 'How CE sees this plugin ( not to be confused with the Signup Name )', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(891, 0, 'plugin_squarepayment_Square Payment Application ID', '', '', 'Please enter your Square Payment Application ID here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(892, 0, 'plugin_squarepayment_Square Payment Location ID', '', '', 'Please enter your Square Payment Location ID here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(893, 0, 'plugin_squarepayment_Square Payment Access Token', '', '', 'Please enter your Square Payment Access Token here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(894, 0, 'plugin_squarepayment_Use Sandbox', '0', '', 'Select YES if you want to use Square Payment&#039;s testing server, so no actual monetary transactions are made..', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(895, 0, 'plugin_squarepayment_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(896, 0, 'plugin_squarepayment_Signup Name', 'Square Payment', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(897, 0, 'plugin_squarepayment_Dummy Plugin', '0', '', '1 = Only used to specify a billing type for a client. 0 = full fledged plugin requiring complete functions', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(898, 0, 'plugin_squarepayment_Auto Payment', '1', '', 'No description', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(899, 0, 'plugin_squarepayment_CC Stored Outside', '1', '', 'If this plugin is Auto Payment, is Credit Card stored outside of Clientexec? 1 = YES, 0 = NO', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(900, 0, 'plugin_squarepayment_Billing Profile ID', '1', '', 'Is this plugin storing a Billing-Profile-ID? 1 = YES, 0 = NO', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(901, 0, 'plugin_squarepayment_Form', '1', '', 'Has a form to be loaded?  1 = YES, 0 = NO', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(902, 0, 'plugin_squarepayment_Call on updateGatewayInformation', 'a:2:{s:8:&quot;function&quot;;s:25:&quot;createFullCustomerProfile&quot;;s:29:&quot;plugincustomfields conditions&quot;;a:1:{i:0;a:3:{s:10:&quot;field name&quot;;s:22:&quot;squarepaymentCardNonce&quot;;s:8:&quot;operator&quot;;s:2:&quot;!=&quot;;s:5:&quot;value&quot;;s:0:&quot;&quot;;}}}', '', 'Function name to be called in this plugin when given conditions are meet while updateGatewayInformation is invoked', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(903, 0, 'plugin_squarepayment_Update Gateway', '1', '', '1 = Create, update or remove Gateway client information through the function UpdateGateway when client choose to use this gateway, client profile is updated, client is deleted or client status is changed. 0 = Do nothing.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(904, 0, 'plugin_stripe_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(905, 0, 'plugin_stripe_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(906, 0, 'plugin_stripe_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(907, 0, 'plugin_stripe_Plugin Name', 'Stripe', '', 'How CE sees this plugin ( not to be confused with the Signup Name )', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(908, 0, 'plugin_stripe_Stripe Gateway Publishable Key', '', '', 'Please enter your Stripe Gateway Publishable Key here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(909, 0, 'plugin_stripe_Stripe Gateway Secret Key', '', '', 'Please enter your Stripe Gateway Secret Key here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(910, 0, 'plugin_stripe_Test Mode?', '0', '', 'Enable test mode, and use the test keys instead of the live keys.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(911, 0, 'plugin_stripe_Stripe Test Publishable Key', '', '', 'Please enter your Stripe Test Publishable Key here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(912, 0, 'plugin_stripe_Stripe Test Secret Key', '', '', 'Please enter your Stripe Test Secret Key here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(913, 0, 'plugin_stripe_Delete Client From Gateway', '0', '', 'Select YES if you want to delete the client from the gateway when the client changes the payment method or is deleted.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(914, 0, 'plugin_stripe_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(915, 0, 'plugin_stripe_Signup Name', 'Stripe', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(916, 0, 'plugin_stripe_Dummy Plugin', '0', '', '1 = Only used to specify a billing type for a client. 0 = full fledged plugin requiring complete functions', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(917, 0, 'plugin_stripe_Auto Payment', '1', '', 'No description', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(918, 0, 'plugin_stripe_CC Stored Outside', '1', '', 'If this plugin is Auto Payment, is Credit Card stored outside of Clientexec? 1 = YES, 0 = NO', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(919, 0, 'plugin_stripe_Billing Profile ID', '1', '', 'Is this plugin storing a Billing-Profile-ID? 1 = YES, 0 = NO', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(920, 0, 'plugin_stripe_Form', '1', '', 'Has a form to be loaded?  1 = YES, 0 = NO', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(921, 0, 'plugin_stripe_openHandler', '1', '', 'Call openHandler() in &quot;Edit Your Payment Method&quot; section if missing Billing-Profile-ID?  1 = YES, 0 = NO', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(922, 0, 'plugin_stripe_Call on updateGatewayInformation', 'a:2:{s:8:&quot;function&quot;;s:19:&quot;updatePaymentMethod&quot;;s:29:&quot;plugincustomfields conditions&quot;;a:1:{i:0;a:3:{s:10:&quot;field name&quot;;s:25:&quot;stripeUpdatePaymentMethod&quot;;s:8:&quot;operator&quot;;s:2:&quot;==&quot;;s:5:&quot;value&quot;;s:1:&quot;1&quot;;}}}', '', 'Function name to be called in this plugin when given conditions are meet while updateGatewayInformation is invoked', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(923, 0, 'plugin_stripe_Update Gateway', '1', '', '1 = Create, update or remove Gateway client information through the function UpdateGateway when client choose to use this gateway, client profile is updated, client is deleted or client status is changed. 0 = Do nothing.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(924, 0, 'plugin_stripecheckout_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(925, 0, 'plugin_stripecheckout_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(926, 0, 'plugin_stripecheckout_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(927, 0, 'plugin_stripecheckout_Plugin Name', 'Stripe Checkout', '', 'How CE sees this plugin ( not to be confused with the Signup Name )', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(928, 0, 'plugin_stripecheckout_Stripe Checkout Gateway Publishable Key', '', '', 'Please enter your Stripe Checkout Gateway Publishable Key here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(929, 0, 'plugin_stripecheckout_Stripe Checkout Gateway Secret Key', '', '', 'Please enter your Stripe Checkout Gateway Secret Key here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(930, 0, 'plugin_stripecheckout_Test Mode?', '0', '', 'Enable test mode, and use the test keys instead of the live keys.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(931, 0, 'plugin_stripecheckout_Stripe Checkout Test Publishable Key', '', '', 'Please enter your Stripe Checkout Test Publishable Key here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(932, 0, 'plugin_stripecheckout_Stripe Checkout Test Secret Key', '', '', 'Please enter your Stripe Checkout Test Secret Key here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(933, 0, 'plugin_stripecheckout_Delete Client From Gateway', '0', '', 'Select YES if you want to delete the client from the gateway when the client changes the payment method or is deleted.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(934, 0, 'plugin_stripecheckout_Stripe Checkout Logo Image URL', '', '', 'A relative or absolute URL pointing to a square image of your brand or product.</br>The recommended minimum size is 128x128px.</br>The recommended image types are .gif, .jpeg, and .png.</br>Leave this field empty to use the default image.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(935, 0, 'plugin_stripecheckout_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(936, 0, 'plugin_stripecheckout_Signup Name', 'Stripe Checkout', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(937, 0, 'plugin_stripecheckout_Dummy Plugin', '0', '', '1 = Only used to specify a billing type for a client. 0 = full fledged plugin requiring complete functions', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(938, 0, 'plugin_stripecheckout_Auto Payment', '1', '', 'No description', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(939, 0, 'plugin_stripecheckout_CC Stored Outside', '1', '', 'If this plugin is Auto Payment, is Credit Card stored outside of Clientexec? 1 = YES, 0 = NO', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(940, 0, 'plugin_stripecheckout_Billing Profile ID', '1', '', 'Is this plugin storing a Billing-Profile-ID? 1 = YES, 0 = NO', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(941, 0, 'plugin_stripecheckout_Form', '1', '', 'Has a form to be loaded?  1 = YES, 0 = NO', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(942, 0, 'plugin_stripecheckout_openHandler', '1', '', 'Call openHandler() in &quot;Edit Your Payment Method&quot; section if missing Billing-Profile-ID?  1 = YES, 0 = NO', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(943, 0, 'plugin_stripecheckout_Call on updateGatewayInformation', 'a:2:{s:8:&quot;function&quot;;s:25:&quot;createFullCustomerProfile&quot;;s:29:&quot;plugincustomfields conditions&quot;;a:1:{i:0;a:3:{s:10:&quot;field name&quot;;s:13:&quot;stripeTokenId&quot;;s:8:&quot;operator&quot;;s:2:&quot;!=&quot;;s:5:&quot;value&quot;;s:0:&quot;&quot;;}}}', '', 'Function name to be called in this plugin when given conditions are meet while updateGatewayInformation is invoked', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(944, 0, 'plugin_stripecheckout_Update Gateway', '1', '', '1 = Create, update or remove Gateway client information through the function UpdateGateway when client choose to use this gateway, client profile is updated, client is deleted or client status is changed. 0 = Do nothing.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(945, 0, 'plugin_worldpay_In Signup', '0', '', 'Select YES if you want to include this payment processor in the signup script.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(946, 0, 'plugin_worldpay_One-Time Payments', '0', '', 'Select YES if you want to allow customers to make one-time payments through this payment processor.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(947, 0, 'plugin_worldpay_Available in Profile Billing Tab', '0', '', 'This plugin is available to admins in the user&#039;s profile billing tab.  <br/>Note: If this is set to false but the plugin is available in signup or one-time payment it will also appear.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(948, 0, 'plugin_worldpay_Plugin Name', 'World Pay', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(949, 0, 'plugin_worldpay_Installation ID', '', '', 'ID used to identify you to WorldPay.<br>NOTE: This ID is required if you have selected WorldPay as a payment gateway for any of your clients.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(950, 0, 'plugin_worldpay_Callback Password', '', '', 'Password used to verify valid transactions FROM WorldPay Callbacks.<br>NOTE: This password has to match the value set in the WorldPay Customer Management System.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(951, 0, 'plugin_worldpay_MD5 Secret', '', '', 'MD5 Secret used to verify valid transactions FROM WorldPay.<br>NOTE: This secret has to match the value set in the WorldPay Customer Management System.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(952, 0, 'plugin_worldpay_Visa', '1', '', 'Select YES to allow Visa card acceptance with this plugin.  No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(953, 0, 'plugin_worldpay_MasterCard', '1', '', 'Select YES to allow MasterCard acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(954, 0, 'plugin_worldpay_AmericanExpress', '0', '', 'Select YES to allow American Express card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(955, 0, 'plugin_worldpay_Discover', '0', '', 'Select YES to allow Discover card acceptance with this plugin. No will prevent this card type.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(956, 0, 'plugin_worldpay_Invoice After Signup', '1', '', 'Select YES if you want an invoice sent to the client after signup is complete.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(957, 0, 'plugin_worldpay_Signup Name', 'Credit Card', '', 'Select the name to display in the signup process for this payment type. Example: eCheck or Credit Card.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(958, 0, 'plugin_worldpay_Accept CC Number', '0', '', 'Selecting YES allows the entering of CC numbers when using this plugin type. No will prevent entering of cc information', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(959, 0, 'plugin_worldpay_Dummy Plugin', '0', '', '1 = Only used to specify a billing type for a client. 0 = full fledged plugin requiring complete functions', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(960, 0, 'plugin_worldpay_Auto Payment', '0', '', 'No description', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(961, 0, 'plugin_worldpay_Check CVV2', '0', '', 'Select YES if you want to accept CVV2 for this plugin.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(962, 0, 'plugin_connectreseller_Plugin Name', 'Connect Reseller', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(963, 0, 'plugin_connectreseller_API Key', '', '', 'Enter the API Key for your Connect Reseller account.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(964, 0, 'plugin_connectreseller_Coupon Code', '', '', 'Enter your CouponCode for your Connect Reseller account.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(965, 0, 'plugin_connectreseller_Supported Features', '', '', '* TLD Lookup<br>* Domain Registration <br>* Get / Set DNS Records <br>* Get / Set Nameserver Records <br>* Get / Set Contact Information <br>* Get / Set Registrar Lock <br>* Initiate Domain Transfer', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0);
INSERT INTO `setting` VALUES
(966, 0, 'plugin_connectreseller_Actions', 'Register', '', 'Current actions that are active for this plugin (when a domain isn&#039;t registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(967, 0, 'plugin_connectreseller_Registered Actions', 'Renew (Renew Domain),DomainTransferWithPopup (Initiate Transfer),Cancel', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(968, 0, 'plugin_connectreseller_Registered Actions For Customer', '', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(969, 0, 'plugin_domainnameapi_Plugin Name', 'Domain Name Api', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(970, 0, 'plugin_domainnameapi_Use testing server', '0', '', 'Select Yes if you wish to use the testing environment, so that transactions are not actually made.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(971, 0, 'plugin_domainnameapi_Username', '', '', 'Enter your username for your Domain Name Api reseller account.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(972, 0, 'plugin_domainnameapi_Password', '', '', 'Enter the password for your Domain Name API reseller account.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(973, 0, 'plugin_domainnameapi_NameServer 1', '', '', 'Enter Name Server #1, used in stand alone domains.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(974, 0, 'plugin_domainnameapi_NameServer 2', '', '', 'Enter Name Server #1, used in stand alone domains.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(975, 0, 'plugin_domainnameapi_Supported Features', '', '', '* TLD Lookup<br>* Domain Registration <br>* Domain Registration with ID Protect <br>* Existing Domain Importing <br>* Get / Set Nameserver Records <br>* Get / Set Contact Information <br>* Get / Set Registrar Lock <br>* Initiate Domain Transfer <br>* Automatically Renew Domain <br>* View EPP Code', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(976, 0, 'plugin_domainnameapi_Actions', 'Register', '', 'Current actions that are active for this plugin (when a domain isn&#039;t registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(977, 0, 'plugin_domainnameapi_Registered Actions', 'SetPrivacyWhois (Toggle Privacy Whois),Renew (Renew Domain),DomainTransferWithPopup (Initiate Transfer)', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(978, 0, 'plugin_domainnameapi_Registered Actions For Customer', 'SetPrivacyWhois (Toggle Privacy Whois)', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(979, 0, 'plugin_dreamscape_Plugin Name', 'Dreamscape', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(980, 0, 'plugin_dreamscape_Reseller ID', '', '', 'Your Dreamscape Reseller ID', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(981, 0, 'plugin_dreamscape_API Key', '', '', 'Your Dreamscape API Key', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(982, 0, 'plugin_dreamscape_Use Testing Server', '0', '', 'Select Yes if you wish to use the Dreamscape testing environment.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(983, 0, 'plugin_dreamscape_Supported Features', '', '', '* TLD Lookup<br>* Domain Registration <br>* Domain Registration with ID Protect <br>* Existing Domain Importing <br>* Get / Set Auto Renew Status <br>* Get / Set DNS Records <br>* Get / Set Nameserver Records <br>* Get / Set Contact Information <br>* Get / Set Registrar Lock <br>* Initiate Domain Transfer', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(984, 0, 'plugin_dreamscape_Actions', 'Register', '', 'Current actions that are active for this plugin (when a domain isn&#039;t registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(985, 0, 'plugin_dreamscape_Registered Actions', 'Renew (Renew Domain),DomainTransferWithPopup (Initiate Transfer)', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(986, 0, 'plugin_dreamscape_Registered Actions For Customer', '', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(987, 0, 'plugin_enom_Plugin Name', 'eNom', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(988, 0, 'plugin_enom_Use testing server', '0', '', 'Select Yes if you wish to use Enom&#039;s testing environment, so that transactions are not actually made. For this to work, you must first register you server&#039;s ip in Enom&#039;s testing environment, and your server&#039;s name servers must be registered there as well.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(989, 0, 'plugin_enom_Login', '', '', 'Enter your username for your Enom reseller account.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(990, 0, 'plugin_enom_Password', '', '', 'Enter the password for your Enom reseller account.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(991, 0, 'plugin_enom_Supported Features', '', '', '* TLD Lookup<br>* Domain Registration <br>* Domain Registration with ID Protect <br>* Existing Domain Importing <br>* Get / Set Auto Renew Status <br>* Get / Set DNS Records <br>* Get / Set Nameserver Records <br>* Get / Set Contact Information <br>* Get / Set Registrar Lock <br>* Initiate Domain Transfer <br>* Automatically Renew Domain <br>* Send Transfer Key<br>* NameSpinner', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(992, 0, 'plugin_enom_Actions', 'Register', '', 'Current actions that are active for this plugin (when a domain isn&#039;t registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(993, 0, 'plugin_enom_Registered Actions', 'Renew (Renew Domain),DomainTransferWithPopup (Initiate Transfer),SendTransferKey (Send Auth Info),Cancel', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(994, 0, 'plugin_enom_Registered Actions For Customer', 'SendTransferKey (Send Auth Info)', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(995, 0, 'plugin_internetbs_Plugin Name', 'Internet.bs Corp.', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(996, 0, 'plugin_internetbs_Use testing server', '0', '', 'Select Yes if you wish to use Internet.bs testing environment, so that transactions are not actually made.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(997, 0, 'plugin_internetbs_Hide whois data', '0', '', 'Select Yes if you want to hide the information in the public whois for Admin/Billing/Technical contacts (.it)', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(998, 0, 'plugin_internetbs_API Key', '', '', 'Enter API key for your Internet.bs reseller account.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(999, 0, 'plugin_internetbs_Password', '', '', 'Enter the password for your Internet.bs reseller account.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(1000, 0, 'plugin_internetbs_Supported Features', '', '', '* TLD Lookup<br>* Domain Registration <br>* Existing Domain Importing <br>* Get / Set Auto Renew Status <br>* Get / Set DNS Records <br>* Get / Set Nameserver Records <br>* Get / Set Contact Information <br>\\* Get Registrar Lock', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1001, 0, 'plugin_internetbs_Actions', 'Register', '', 'Current actions that are active for this plugin (when a domain isn&#039;t registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1002, 0, 'plugin_internetbs_Registered Actions', 'Cancel', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1003, 0, 'plugin_joker_Plugin Name', 'Joker.com', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1004, 0, 'plugin_joker_Test Mode', '0', '', 'Select Yes if you wish to use Joker&#039;s OT&E system', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1005, 0, 'plugin_joker_Api Key', '', '', 'Enter the API Key for your Joker.com account.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1006, 0, 'plugin_joker_Supported Features', '', '', '* TLD Lookup <br>* Domain Registration <br>* Existing Domain Importing <br>* Get / Set Auto Renew Status <br>* Get / Set DNS Records <br>* Get / Set Nameserver Records <br>* Get / Set Contact Information <br>* Get / Set Registrar Lock <br>* Initiate Domain Transfer <br>* Automatically Renew Domain <br>* Send Transfer Key', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1007, 0, 'plugin_joker_Actions', 'Register', '', 'Current actions that are active for this plugin (when a domain isn&#039;t registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1008, 0, 'plugin_joker_Registered Actions', 'Renew (Renew Domain),DomainTransferWithPopup (Initiate Transfer),SendTransferKey (Send Auth Info),Cancel', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1009, 0, 'plugin_joker_Registered Actions For Customer', 'SendTransferKey (Send Auth Info)', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1010, 0, 'plugin_name_Plugin Name', 'Name.com', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1011, 0, 'plugin_name_Use testing server', '0', '', 'Select yes to use the testing envrionment.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1012, 0, 'plugin_name_Username', '', '', 'Enter your name.com username.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1013, 0, 'plugin_name_API Token', '', '', 'Enter your name.com API token.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(1014, 0, 'plugin_name_Supported Features', '', '', '* TLD Lookup<br>* Domain Registration <br>* Existing Domain Importing <br>* Get / Set Auto Renew Status <br>* Get / Set Nameserver Records <br>* Get / Set Contact Information <br>* Get / Set Registrar Lock <br>* Initiate Domain Transfer <br>* Automatically Renew Domain <br>* Retrieve EPP Code', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1015, 0, 'plugin_name_Actions', 'Register', '', 'Current actions that are active for this plugin (when a domain isn&#039;t registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1016, 0, 'plugin_name_Registered Actions', 'Renew (Renew Domain),DomainTransferWithPopup (Initiate Transfer),Cancel', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1017, 0, 'plugin_name_Registered Actions For Customer', '', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1018, 0, 'plugin_namecheap_Plugin Name', 'NameCheap', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1019, 0, 'plugin_namecheap_Use Sandbox?', '0', '', 'Select Yes if you wish to use NameCheap&#039;s sandbox environment.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1020, 0, 'plugin_namecheap_Username', '', '', 'Enter your username for your NameCheap account.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1021, 0, 'plugin_namecheap_API Key', '', '', 'Enter the API Key for your NameCheap account.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1022, 0, 'plugin_namecheap_Supported Features', '', '', '* TLD Lookup<br>* Domain Registration <br>* Existing Domain Importing <br>* Get / Set DNS Records <br>* Get / Set Nameserver Records <br>* Get / Set Contact Information <br>* Get / Set Registrar Lock <br>* Initiate Domain Transfer <br>* Automatically Renew Domain', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1023, 0, 'plugin_namecheap_Actions', 'Register', '', 'Current actions that are active for this plugin (when a domain isn&#039;t registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1024, 0, 'plugin_namecheap_Registered Actions', 'Renew (Renew Domain),DomainTransferWithPopup (Initiate Transfer),Cancel', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1025, 0, 'plugin_namecheap_Registered Actions For Customer', '', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1026, 0, 'plugin_namesilo_Plugin Name', 'NameSilo', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1027, 0, 'plugin_namesilo_Use testing server', '0', '', 'Select Yes if you wish to use NameSilo&#039;s testing environment, so that transactions are not actually made.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1028, 0, 'plugin_namesilo_API Key', '', '', 'Enter your API Key', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1029, 0, 'plugin_namesilo_Payment ID', '', '', 'Enter the Payment ID you wish to have orders charged to (this is optional and will default to account balance if not set)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1030, 0, 'plugin_namesilo_Default Privacy?', '0', '', 'Select Yes if you wish to have WHOIS privacy turned on by default for registrations and transfers', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1031, 0, 'plugin_namesilo_Auto Renew Domains?', '0', '', 'Select Yes if you wish to have auto renew enabled for new registrations and transfers.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1032, 0, 'plugin_namesilo_Supported Features', '', '', '* TLD Lookup<br>* Domain Registration <br>* Existing Domain Importing <br>* Get / Set Auto Renew Status <br>* Get / Set DNS Records <br>* Get / Set Nameserver Records <br>* Get / Set Contact Information <br>* Get / Set Registrar Lock <br>* Initiate Domain Transfer <br>* Automatically Renew Domain <br>* Send Transfer Key <br>* Name Suggest', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1033, 0, 'plugin_namesilo_Actions', 'Register', '', 'Current actions that are active for this plugin (when a domain isn&#039;t registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1034, 0, 'plugin_namesilo_Registered Actions', 'Renew (Renew Domain),togglePrivacy (Toggle Privacy),DomainTransferWithPopup (Initiate Transfer),SendTransferKey (Send Auth Info),Cancel', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1035, 0, 'plugin_namesilo_Registered Actions For Customer', 'togglePrivacy (Toggle Privacy),SendTransferKey (Send Auth Info)', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1036, 0, 'plugin_netearthone_Plugin Name', 'NetEarth One', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1037, 0, 'plugin_netearthone_Use testing server', '0', '', 'Select Yes if you wish to use the NetEarth One testing environment, so that transactions are not actually made.<br><br><b>Note: </b>You will first need to register for a demo account at<br>http://cp.onlyfordemo.net/servlet/ResellerSignupServlet?&validatenow=false.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1038, 0, 'plugin_netearthone_Reseller ID', '', '', 'Enter your NetEarth One Reseller ID.  This can be found in your NetEarth One    account by going to your profile link, in the top right corner.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1039, 0, 'plugin_netearthone_Password', '', '', 'Enter the password for your NetEarth One reseller account.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(1040, 0, 'plugin_netearthone_API Key', '', '', 'Enter your API Key for your NetEarth One reseller account.  You should use this instead of your password, however you still may use your password instead.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1041, 0, 'plugin_netearthone_Supported Features', '', '', '* TLD Lookup<br>* Domain Registration <br>* Domain Registration with ID Protect <br>* Existing Domain Importing <br>* Get / Set Nameserver Records <br>* Get / Set Contact Information <br>* Get / Set Registrar Lock <br>* Initiate Domain Transfer <br>* Automatically Renew Domain', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1042, 0, 'plugin_netearthone_Actions', 'Register', '', 'Current actions that are active for this plugin (when a domain isn&#039;t registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1043, 0, 'plugin_netearthone_Registered Actions', 'Renew (Renew Domain),DomainTransferWithPopup (Initiate Transfer),Cancel', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1044, 0, 'plugin_netearthone_Registered Actions For Customer', '', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1045, 0, 'plugin_netim_Plugin Name', 'NETIM', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1046, 0, 'plugin_netim_Description', '', '', 'NETIM is an ICANN-accredited domain name registrar, which provides domain name registration for more than 1000 worldwide extensions. This module allows to register and manage most of all ccTlds and gTlds with management of additional domain fields, trustee and local contact service.<br>\n                     <a href=&#039;https://www.netim.com/reseller/&#039; target=&#039;_blank&#039;>Signup for a reseller account</a>', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1047, 0, 'plugin_netim_Use testing plateform', '0', '', 'Select Yes if you wish to use NETIM testing environment.<BR><strong>Note:</strong> You will first need to <a href=&#039;https://oteweb.netim.com/direct/create-reseller-account&#039; target=&#039;_blank&#039;>signup for a reseller test account</a>', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1048, 0, 'plugin_netim_Login', '', '', 'Enter the username of your NETIM reseller account.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1049, 0, 'plugin_netim_Password', '', '', 'Enter the password of your NETIM reseller account.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(1050, 0, 'plugin_netim_DNS 1', '', '', 'Default nameserver #1', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1051, 0, 'plugin_netim_DNS 2', '', '', 'Default nameserver #2', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1052, 0, 'plugin_netim_DNS 3', '', '', 'Default nameserver #3', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1053, 0, 'plugin_netim_DNS 4', '', '', 'Default nameserver #4', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1054, 0, 'plugin_netim_DNS 5', '', '', 'Default nameserver #5', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1055, 0, 'plugin_netim_Supported Features', '', '', '* Domain Registration / Transfer / Renewal / Deletion <br>* Get / Set Nameservers <br>* Get / Set Contact Information <br>* Get / Set Whois privacy <br>* Get / Set Registrar lock <br>* Support of DNSsec <br>* Get / Set DNS Records <br>* Support of asynchronous results <br>* Support of additional domain data <br>* Support of addons for trustee service / local contact service <br>', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1056, 0, 'plugin_netim_Actions', 'Register (Initiate Registration),DomainTransferWithPopup (Initiate Transfer)', '', 'Current actions that are active for this plugin (when a domain isn&#039;t registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1057, 0, 'plugin_netim_Registered Actions', 'SetPrivacyWhois (Toggle Privacy whois),SetRegistrarLock(Toggle Registrar lock),SetDnsSec (Toggle DNSsec),SendTransferKey (Get Transfer Key),Delete (Delete Domain),Renew (Renew Domain),DomainTransferWithPopup (Initiate Transfer)', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1058, 0, 'plugin_netim_Registered Actions For Customer', 'SendTransferKey (Get Transfer Key),SetPrivacyWhois (Toggle Privacy whois),SetRegistrarLock(Toggle Registrar lock),SetDnsSec (Toggle DNSsec)', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1059, 0, 'plugin_nominet_Plugin Name', 'Nominet', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1060, 0, 'plugin_nominet_Use Testbed?', '0', '', 'Select Yes if you wish to use Nominet&#039;s testbed environment.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1061, 0, 'plugin_nominet_Username', '', '', 'Enter your username for your Nominet account.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1062, 0, 'plugin_nominet_Password', '', '', 'Enter the password for your Nominet account.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1063, 0, 'plugin_nominet_Default NS1', '', '', 'Enter the default name server for the domain if no hosting package.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1064, 0, 'plugin_nominet_Default NS2', '', '', 'Enter the default name server for the domain if no hosting package.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1065, 0, 'plugin_nominet_Supported Features', '', '', '* TLD Lookup<br>* Domain Registration <br>* Get / Set Nameserver Records <br>* Get / Set Contact Information <br>* Automatically Renew Domain', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1066, 0, 'plugin_nominet_Actions', 'Register', '', 'Current actions that are active for this plugin (when a domain isn&#039;t registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1067, 0, 'plugin_nominet_Registered Actions', 'Renew (Renew Domain),Cancel', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1068, 0, 'plugin_nominet_Registered Actions For Customer', '', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1069, 0, 'plugin_onlinenic_Plugin Name', 'OnlineNIC', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1070, 0, 'plugin_onlinenic_Use testing server', '0', '', 'Select Yes if you wish to use OnlineNIC&#039;s testing environment, so that transactions are not actually made.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1071, 0, 'plugin_onlinenic_Username', '', '', 'Enter your username for your OnlineNIC reseller account.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1072, 0, 'plugin_onlinenic_Private Key', '', '', 'Enter your OnlineNIC reseller password.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(1073, 0, 'plugin_onlinenic_Supported Features', '', '', '* TLD Lookup<br>* Domain Registration <br>', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1074, 0, 'plugin_onlinenic_Actions', 'Register', '', 'Current actions that are active for this plugin (when a domain isn&#039;t registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1075, 0, 'plugin_onlinenic_Registered Actions', 'Renew (Renew Domain),Cancel', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1076, 0, 'plugin_openprovider_Plugin Name', 'Openprovider', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1077, 0, 'plugin_openprovider_Use testing server', '', '', 'Select Yes if you wish to use Openprovider&#039;s testing environment, so that transactions are not actually made. For this to work, you must first register you server&#039;s ip in Openprovider&#039;s testing environment (https://cp.sandbox.openprovider.nl), Below in username and password file you need to enter test environment credentials, whereas for live you need to untick this and provide actual user details below.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1078, 0, 'plugin_openprovider_Username', '', '', 'Enter your email address for your Openprovider account.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1079, 0, 'plugin_openprovider_Password', '', '', 'Enter your password for your Openprovider account.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1080, 0, 'plugin_openprovider_Supported Features', '', '', '* TLD Lookup<br>* Domain Registration <br>* Get / Set DNS Records <br>* Get / Set Nameserver Records <br>* Get / Set Contact Information <br>* Get / Set Registrar Lock <br>* Initiate Domain Transfer', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1081, 0, 'plugin_openprovider_Actions', 'Register', '', 'Current actions that are active for this plugin (when a domain isn&#039;t registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1082, 0, 'plugin_openprovider_Registered Actions', 'Renew (Renew Domain),DomainTransferWithPopup (Initiate Transfer),Cancel', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1083, 0, 'plugin_openprovider_Registered Actions For Customer', '', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1084, 0, 'plugin_opensrs_Plugin Name', 'OpenSRS', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1085, 0, 'plugin_opensrs_Use testing server', '0', '', 'Select Yes if you wish to use OpenSRS&#039;s testing environment, so that transactions are not actually made.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1086, 0, 'plugin_opensrs_Username', '', '', 'Enter your username for your OpenSRS reseller account.<br/>', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1087, 0, 'plugin_opensrs_Private Key', '', '', 'Enter your OpenSRS reseller private key.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1088, 0, 'plugin_opensrs_Supported Features', '', '', '* TLD Lookup, with Name Suggestions<br>* Domain Registration <br>* Domain Registration with ID Protect <br>* Existing Domain Importing <br>* Get / Set Auto Renew Status <br>* Get / Set Nameserver Records <br>* Get / Set Contact Information <br>* Get / Set Registrar Lock <br>* Initiate Domain Transfer <br>* Automatically Renew Domain <br>', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1089, 0, 'plugin_opensrs_Actions', 'Register', '', 'Current actions that are active for this plugin (when a domain isn&#039;t registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1090, 0, 'plugin_opensrs_Registered Actions', 'Renew (Renew Domain),DomainTransfer (Initiate Transfer),SendTransferKey (Send Auth Info),Cancel', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1091, 0, 'plugin_opensrs_Registered Actions For Customer', 'SendTransferKey (Send Auth Info)', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1092, 0, 'plugin_planetdomain_Plugin Name', 'PlanetDomain', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1093, 0, 'plugin_planetdomain_Account No', '', '', 'Enter your Account No found in API Login Credentials.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1094, 0, 'plugin_planetdomain_Login', '', '', 'Enter your Login found in API Login Credentials..', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1095, 0, 'plugin_planetdomain_Password', '', '', 'Enter your Password found in API Login Credentials.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(1096, 0, 'plugin_planetdomain_Default Account', '', '', 'Enter the Account Reference all domain names should be registered under.  Leaving this blank will create a different account for each client at the registrar.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1097, 0, 'plugin_planetdomain_Supported Features', '', '', '* TLD Lookup<br>* Domain Registration<br>* Automatically Renew Domain<br>* Get / Set Nameserver Records <br>* Get / Set Registrar Lock <br>* Get / Set Contact Information <br>', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1098, 0, 'plugin_planetdomain_Actions', 'Register', '', 'Current actions that are active for this plugin (when a domain isn&#039;t registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1099, 0, 'plugin_planetdomain_Registered Actions', 'Renew (Renew Domain),Cancel', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1100, 0, 'plugin_realtimeregister_Plugin Name', 'Realtime Register', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1101, 0, 'plugin_realtimeregister_Dealer', '', '', 'Enter your username for your Realtime Register dealer account.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1102, 0, 'plugin_realtimeregister_Password', '', '', 'Enter your Realtime Register dealer password.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(1103, 0, 'plugin_realtimeregister_Handle', '', '', 'Enter your default contact handle name for Admin, Billing, Tech Contact.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1104, 0, 'plugin_realtimeregister_NS 1', '', '', 'Enter Name Server #1, used in stand alone domains.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1105, 0, 'plugin_realtimeregister_NS 2', '', '', 'Enter Name Server #1, used in stand alone domains.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1106, 0, 'plugin_realtimeregister_PhoneFormat', '', '', 'The format of stored phone numbers.<br /><br />\n%c = country code (eg. 31 for NL)<br />\n%a = area code (eg. 38 for Zwolle)<br />\n%s = subscriber number (eg. 4530759)<br /><br />\nExample<br />\n+31 (0) 38 4530759 --> +%c (0) %a %s<br />', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1107, 0, 'plugin_realtimeregister_TestMode', '', '', 'Enable this to use the testing environment of Realtime Register.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1108, 0, 'plugin_realtimeregister_DebugMode', '', '', 'Debug mode provides extensive information when an error occurs. You should only enable this for debugging purposes!', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1109, 0, 'plugin_realtimeregister_DebugMail', '', '', 'E-mail debug messages to this address.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1110, 0, 'plugin_realtimeregister_Supported Features', '', '', '* TLD Lookup<br>* Domain Registration <br>* Get / Set Auto Renew Status <br>* Get / Set Contact Information <br>* Get Registrar Lock <br>* Send Transfer Key', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1111, 0, 'plugin_realtimeregister_Actions', 'Register', '', 'Current actions that are active for this plugin (when a domain isn&#039;t registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1112, 0, 'plugin_realtimeregister_Registered Actions', 'SendTransferKey (Send Auth Info),Cancel', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1113, 0, 'plugin_resellbiz_Plugin Name', 'ResellBiz', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1114, 0, 'plugin_resellbiz_Use testing server', '0', '', 'Select Yes if you wish to use the Resell.biz testing environment, so that transactions are not actually made.<br><br><b>Note: </b>You will first need to register for a demo account at<br>http://cp.onlyfordemo.net/servlet/ResellerSignupServlet?&validatenow=false.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1115, 0, 'plugin_resellbiz_Reseller ID', '', '', 'Enter your Resell.biz Reseller ID.  This can be found in your Resell.biz    account by going to your profile link, in the top right corner.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1116, 0, 'plugin_resellbiz_Password', '', '', 'Enter the password for your Resell.biz reseller account.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(1117, 0, 'plugin_resellbiz_API Key', '', '', 'Enter your API Key for your Resell.biz reseller account.  You should use this instead of your password, however you still may use your password instead.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1118, 0, 'plugin_resellbiz_Supported Features', '', '', '* TLD Lookup<br>* Domain Registration <br>* Domain Registration with ID Protect <br>* Existing Domain Importing <br>* Get / Set Nameserver Records <br>* Get / Set Contact Information <br>* Get / Set Registrar Lock <br>* Initiate Domain Transfer <br>* Automatically Renew Domain', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1119, 0, 'plugin_resellbiz_Actions', 'Register', '', 'Current actions that are active for this plugin (when a domain isn&#039;t registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1120, 0, 'plugin_resellbiz_Registered Actions', 'Renew (Renew Domain),DomainTransferWithPopup (Initiate Transfer),Cancel', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1121, 0, 'plugin_resellbiz_Registered Actions For Customer', '', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1122, 0, 'plugin_resellerclub_Plugin Name', 'ResellerClub', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1123, 0, 'plugin_resellerclub_Use testing server', '0', '', 'Select Yes if you wish to use the ResellerClub testing environment, so that transactions are not actually made.<br><br><b>Note: </b>You will first need to register for a demo account at<br>http://cp.onlyfordemo.net/servlet/ResellerSignupServlet?&validatenow=false.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1124, 0, 'plugin_resellerclub_Reseller ID', '', '', 'Enter your ResellerClub Reseller ID.  This can be found in your ResellerClub    account by going to your profile link, in the top right corner.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1125, 0, 'plugin_resellerclub_Password', '', '', 'Enter the password for your ResellerClub reseller account.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(1126, 0, 'plugin_resellerclub_API Key', '', '', 'Enter your API Key for your ResellerClub reseller account.  You should use this instead of your password, however you still may use your password instead.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1127, 0, 'plugin_resellerclub_Supported Features', '', '', '* TLD Lookup<br>* Domain Registration <br>* Domain Registration with ID Protect <br>* Existing Domain Importing <br>* Get / Set Nameserver Records <br>* Get / Set Contact Information <br>* Get / Set Registrar Lock <br>* Initiate Domain Transfer <br>* Automatically Renew Domain', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1128, 0, 'plugin_resellerclub_Actions', 'Register', '', 'Current actions that are active for this plugin (when a domain isn&#039;t registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1129, 0, 'plugin_resellerclub_Registered Actions', 'Renew (Renew Domain),DomainTransferWithPopup (Initiate Transfer),Cancel', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1130, 0, 'plugin_resellerclub_Registered Actions For Customer', '', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1131, 0, 'plugin_resellone_Plugin Name', 'ResellOne', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1132, 0, 'plugin_resellone_Username', '', '', 'Enter your username for your ResellOne reseller account.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1133, 0, 'plugin_resellone_Private Key', '', '', 'Enter your ResellOne reseller private key.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(1134, 0, 'plugin_resellone_Supported Features', '', '', '* TLD Lookup<br>* Domain Registration <br>', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1135, 0, 'plugin_resellone_Actions', 'Register', '', 'Current actions that are active for this plugin (when a domain isn&#039;t registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1136, 0, 'plugin_resellone_Registered Actions', 'Cancel', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1137, 0, 'plugin_synergywholesale_Plugin Name', 'Synergy Wholesale', '', 'How CE sees this plugin (not to be confused with the Signup Name)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1138, 0, 'plugin_synergywholesale_Reseller ID', '', '', 'Enter your Reseller ID.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1139, 0, 'plugin_synergywholesale_API Key', '', '', 'Enter your API Key.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(1140, 0, 'plugin_synergywholesale_Supported Features', '', '', '* TLD Lookup<br>* Domain Registration <br>* Existing Domain Importing <br>* Get / Set Auto Renew Status <br>* Get / Set DNS Records <br>* Get / Set Nameserver Records <br>* Get / Set Contact Information <br>* Get / Set Registrar Lock <br>* Initiate Domain Transfer <br>* Automatically Renew Domain <br>* Retrieve EPP Code', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1141, 0, 'plugin_synergywholesale_Actions', 'Register', '', 'Current actions that are active for this plugin (when a domain isn&#039;t registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1142, 0, 'plugin_synergywholesale_Registered Actions', 'Renew (Renew Domain),DomainTransferWithPopup (Initiate Transfer),Cancel', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1143, 0, 'plugin_synergywholesale_Registered Actions For Customer', '', '', 'Current actions that are active for this plugin (when a domain is registered)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1144, 0, 'plugin_archivelogs_Plugin Name', 'Archive Logs', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1145, 0, 'plugin_archivelogs_Enabled', '0', '', 'Generates a file with an SQL dump of the selected log tables on a periodic basis, and delivers it to any of the locations set below. Then the log tables are erased.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1146, 0, 'plugin_archivelogs_Archive events_log Table', '0', '', 'Select YES to archive the events_log table, which contains the events logged acording to the setting &quot;general settings->global->Enable Events Logging&quot;.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1147, 0, 'plugin_archivelogs_Compress files with gzip', '0', '', 'Only possible if you have the zlib extension in your PHP installation.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1148, 0, 'plugin_archivelogs_Deliver to remote FTP or SFTP account', '', '', 'To send the files to a remote FTP or SFTP account enter the host and your credentials in the format <b>ftp://username:password@host.com/subdirectory</b> for FTP<br>or<br><b>sftp://username:password@host.com/subdirectory</b> for SFTP<br>SFTP is only possible if you have the ssh2 extension in your PHP installation', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1149, 0, 'plugin_archivelogs_Deliver to local directory', '', '', 'To save the files in a local directory accessible and writable by the web server, enter it&#039;s full path here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1150, 0, 'plugin_archivelogs_Deliver to E-mail address', '', '', 'To send the files as an E-mail attachment, enter the address here.', 6, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0),
(1151, 0, 'plugin_archivelogs_Run schedule - Minute', '30', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1152, 0, 'plugin_archivelogs_Run schedule - Hour', '01', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1153, 0, 'plugin_archivelogs_Run schedule - Day', '15', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1154, 0, 'plugin_archivelogs_Run schedule - Month', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1155, 0, 'plugin_archivelogs_Run schedule - Day of the week', '*', '', 'Enter number in range 0-6 (0 is Sunday) or a 3 letter shortcut (e.g. sun)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1156, 0, 'plugin_autoclose_Plugin Name', 'Ticket Auto Close', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1157, 0, 'plugin_autoclose_Enabled', '0', '', 'When enabled, tickets remaining unresponded to by customers for x amount of days will automatically be closed.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1158, 0, 'plugin_autoclose_Days to trigger autoclose', '3', '', 'Enter number of days to wait before autoclosing a ticket that is in the waiting on customer status.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1159, 0, 'plugin_autoclose_Ticket Message', 'ATTN: [CLIENTNAME],\r\n\r\nYour Support Ticket #[TICKETNUMBER] with subject &quot;[TICKETSUBJECT]&quot; has been closed due to inactivity.\r\nIf this issue has not been resolved please reopen this ticket.\r\n\r\nThank you,\r\n[COMPANYNAME]', '', 'Enter the message you would like entered into the ticket when it is closed.<br>Template Tags: [CLIENTNAME], [TICKETNUMBER], [TICKETSUBJECT], [TICKETFIRSTLOG], [COMPANYNAME]', 6, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0),
(1160, 0, 'plugin_autoclose_Pre-Notify Customer', '1', '', 'When enabled the customer will be notified before the ticket is closed. Use the AutoClose Ticket Service Template', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1161, 0, 'plugin_autoclose_Days to trigger Pre-Notify autoclose', '1', '', 'Enter number of days to notify before autoclosing a ticket that is in the waiting on customer status.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1162, 0, 'plugin_autoclose_Notify Customer', '1', '', 'When enabled the customer will be notified when a ticket is closed.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1163, 0, 'plugin_autoclose_Run schedule - Minute', '0', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 8, 1, 0, 0, 0),
(1164, 0, 'plugin_autoclose_Run schedule - Hour', '0', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1165, 0, 'plugin_autoclose_Run schedule - Day', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1166, 0, 'plugin_autoclose_Run schedule - Month', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1167, 0, 'plugin_autoclose_Run schedule - Day of the week', '*', '', 'Enter number in range 0-6 (0 is Sunday) or a 3 letter shortcut (e.g. sun)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1168, 0, 'plugin_automailer_Plugin Name', 'Auto Mailer', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1169, 0, 'plugin_automailer_Enabled', '0', '', 'When enabled, email customers and/or create support tickets a set number of days before/after a given event, defined on <a href=&quot;index.php?fuse=admin&controller=notifications&view=adminviewnotifications&quot;><b><u>Accounts&nbsp;>&nbsp;Notifications</u></b></a>.<br><b>NOTE:</b> Only run once per day to avoid duplicate E-mails or Tickets.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1170, 0, 'plugin_automailer_Summary E-mail', '', '', 'E-mail addresses to which a summary of each service run will be sent.  (Leave blank if you do not wish to receive a summary)', 6, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0),
(1171, 0, 'plugin_automailer_Summary E-mail Subject', 'Auto Mailer / Ticket Creator Summary', '', 'E-mail subject for the summary notification.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1172, 0, 'plugin_automailer_Run schedule - Minute', '0', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 8, 1, 0, 0, 0),
(1173, 0, 'plugin_automailer_Run schedule - Hour', '0', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1174, 0, 'plugin_automailer_Run schedule - Day', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1175, 0, 'plugin_automailer_Run schedule - Month', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1176, 0, 'plugin_automailer_Run schedule - Day of the week', '*', '', 'Enter number in range 0-6 (0 is Sunday) or a 3 letter shortcut (e.g. sun)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1177, 0, 'plugin_autosuspend_Plugin Name', 'Auto Suspend / Unsuspend', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1178, 0, 'plugin_autosuspend_Enabled', '0', '', 'When enabled, overdue packages will be suspended when this service is run.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1179, 0, 'plugin_autosuspend_E-mail Notifications', '', '', 'When a package requires manual suspension you will be notified at this E-mail address. If packages are suspended when this service is run, a summary E-mail will be sent to this address.', 6, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0),
(1180, 0, 'plugin_autosuspend_Suspend Customer', '1', '', 'When enabled, all customers packages will be suspended if a recurring fee not associated with a package is overdue.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1181, 0, 'plugin_autosuspend_Enable Unsuspension', '1', '', 'When enabled, suspended and paid packages will be unsuspended when this service is run.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1182, 0, 'plugin_autosuspend_Days Overdue Before Suspending', '7', '', 'Only suspend packages that are this many days overdue. Enter 0 here to disable package suspension', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1183, 0, 'plugin_autosuspend_Create Ticket', '0', '', 'When a package is suspended, automatically create a ticket under the user&#039;s account and notify him.<br>The ticket contents is defined in the <b>Notify Package Suspension</b> email template at <b><a href=&#039;index.php?fuse=admin&controller=settings&view=emailtemplates&settings=mail&#039;>Settings&nbsp;>&nbsp;Email Templates</a></b>', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1184, 0, 'plugin_autosuspend_Ticket Assign To', 'dep_0_staff_0', '', 'If <b>Create Ticket</b> is set to YES, select here to whom you want the ticket to be assigned.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1185, 0, 'plugin_autosuspend_Run schedule - Minute', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 8, 1, 0, 0, 0),
(1186, 0, 'plugin_autosuspend_Run schedule - Hour', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1187, 0, 'plugin_autosuspend_Run schedule - Day', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1188, 0, 'plugin_autosuspend_Run schedule - Month', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1189, 0, 'plugin_autosuspend_Run schedule - Day of the week', '*', '', 'Enter number in range 0-6 (0 is Sunday) or a 3 letter shortcut (e.g. sun)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1190, 0, 'plugin_autosuspend_Notified Package List', '', '', 'Used to store package IDs of manually suspended packages whose E-mail has already been sent.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1191, 0, 'plugin_autoterminate_Plugin Name', 'Auto Terminate', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1192, 0, 'plugin_autoterminate_Enabled', '0', '', 'When enabled, overdue packages will be terminated and removed from the server.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1193, 0, 'plugin_autoterminate_Auto Terminate Pending Cancelations?', '0', '', 'Do you want pending package cancelations to be automatically terminated and removed from the server?', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1194, 0, 'plugin_autoterminate_Email Notifications', '', '', 'When a package requires manual termination you will be notified at this email address. If packages are terminated when this service is run, a summary email will be sent to this address.', 6, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0),
(1195, 0, 'plugin_autoterminate_Days Overdue Before Terminating', '7', '', 'Only terminate packages that are this many days overdue.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1196, 0, 'plugin_autoterminate_Run schedule - Minute', '0', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 8, 1, 0, 0, 0),
(1197, 0, 'plugin_autoterminate_Run schedule - Hour', '0', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1198, 0, 'plugin_autoterminate_Run schedule - Day', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1199, 0, 'plugin_autoterminate_Run schedule - Month', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1200, 0, 'plugin_autoterminate_Run schedule - Day of the week', '*', '', 'Enter number in range 0-6 (0 is Sunday) or a 3 letter shortcut (e.g. sun)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1201, 0, 'plugin_autoterminate_Notified Package List', '', '', 'Used to store package IDs of manually terminated packages whose email has already been sent.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1202, 0, 'plugin_backup_Plugin Name', 'CE Database Backup', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1203, 0, 'plugin_backup_Enabled', '0', '', 'Generates a file with an SQL dump of your ClientExec database on a periodic basis, and delivers it to any of the locations set below.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1204, 0, 'plugin_backup_Compress file with gzip', '0', '', 'Only possible if you have the zlib extension in your PHP installation.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1205, 0, 'plugin_backup_Encryption password', '', '', 'Enter a password if you wish to encrypt the file, or else leave empty.  The password MUST be exactly 24 characters long.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1206, 0, 'plugin_backup_Deliver to remote FTP or SFTP account', '', '', 'To send the file to a remote FTP or SFTP account enter the host and your credentials in the format <b>ftp://username:password@host.com/subdirectory</b> for FTP<br>or<br><b>sftp://username:password@host.com/subdirectory</b> for SFTP<br>SFTP is only possible if you have the ssh2 extension in your PHP installation', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1207, 0, 'plugin_backup_Deliver to local directory', '', '', 'To save the file in a local directory accessible and writable by the web server, enter it&#039;s full path here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1208, 0, 'plugin_backup_Deliver to E-mail address', '', '', 'To send the file as an E-mail attachment, enter the address here.', 6, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0),
(1209, 0, 'plugin_backup_Run schedule - Minute', '30', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 8, 1, 0, 0, 0),
(1210, 0, 'plugin_backup_Run schedule - Hour', '01', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1211, 0, 'plugin_backup_Run schedule - Day', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1212, 0, 'plugin_backup_Run schedule - Month', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1213, 0, 'plugin_backup_Run schedule - Day of the week', '*', '', 'Enter number in range 0-6 (0 is Sunday) or a 3 letter shortcut (e.g. sun)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0);
INSERT INTO `setting` VALUES
(1214, 0, 'plugin_creditcardpaymentsprocessor_Plugin Name', 'Credit Card Payments Processor', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1215, 0, 'plugin_creditcardpaymentsprocessor_Enabled', '0', '', 'When enabled, will process your clients credit cards for invoices that are due or past-due. This will only process your clients whose credit card is stored outside of Clientexec.</br></br><b>Supported plugins:</b> <ul><li></li><li></li><li></li><li></li><li></li><li></li></ul>', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1216, 0, 'plugin_creditcardpaymentsprocessor_Include invoices previously declined', '0', '', 'When enabled, will also process your clients credit cards for invoices that are due or past-due and have declined transactions.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1217, 0, 'plugin_creditcardpaymentsprocessor_Run schedule - Minute', '0', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 8, 1, 0, 0, 0),
(1218, 0, 'plugin_creditcardpaymentsprocessor_Run schedule - Hour', '0', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1219, 0, 'plugin_creditcardpaymentsprocessor_Run schedule - Day', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1220, 0, 'plugin_creditcardpaymentsprocessor_Run schedule - Month', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1221, 0, 'plugin_creditcardpaymentsprocessor_Run schedule - Day of the week', '*', '', 'Enter number in range 0-6 (0 is Sunday) or a 3 letter shortcut (e.g. sun)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1222, 0, 'plugin_currencyconverter_Plugin Name', 'Automatic Currency Rate Converter', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1223, 0, 'plugin_currencyconverter_Enabled', '0', '', 'When enabled, this service will automatically update the conversion rate of currencies .', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1224, 0, 'plugin_currencyconverter_Run schedule - Minute', '0', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 8, 1, 0, 0, 0),
(1225, 0, 'plugin_currencyconverter_Run schedule - Hour', '0', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1226, 0, 'plugin_currencyconverter_Run schedule - Day', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1227, 0, 'plugin_currencyconverter_Run schedule - Month', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1228, 0, 'plugin_currencyconverter_Run schedule - Day of the week', '*', '', 'Enter number in range 0-6 (0 is Sunday) or a 3 letter shortcut (e.g. sun)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1229, 0, 'plugin_deletependingusers_Plugin Name', 'Delete Pending Users', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1230, 0, 'plugin_deletependingusers_Enabled', '0', '', 'Erases pending users after the amount of days selected without being approved.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1231, 0, 'plugin_deletependingusers_Also delete users with these statuses', 'a:0:{}', '', 'Erases inactive, cancelled and/or fraud users after the amount of days selected with that status.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1232, 0, 'plugin_deletependingusers_Amount of days', '30', '', 'Set the amount of days before deleting a pending user from the system', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1233, 0, 'plugin_deletependingusers_Run schedule - Minute', '30', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 8, 1, 0, 0, 0),
(1234, 0, 'plugin_deletependingusers_Run schedule - Hour', '01', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1235, 0, 'plugin_deletependingusers_Run schedule - Day', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1236, 0, 'plugin_deletependingusers_Run schedule - Month', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1237, 0, 'plugin_deletependingusers_Run schedule - Day of the week', '*', '', 'Enter number in range 0-6 (0 is Sunday) or a 3 letter shortcut (e.g. sun)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1238, 0, 'plugin_domainupdater_Plugin Name', 'Domain Updater', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1239, 0, 'plugin_domainupdater_Enabled', '0', '', 'When enabled, this service will check all active domains and update the internal expiration date of the domains.  This date is used to send expiration notices among other things.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1240, 0, 'plugin_domainupdater_Sync Due Date?', '0', '', 'When enabled, a domain will have its next due date updated to the expiration date at the registrar.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1241, 0, 'plugin_domainupdater_Cancel Domains?', '0', '', 'When enabled, a domain in Clientexec that does not exist at the registrar will be marked as cancelled.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1242, 0, 'plugin_domainupdater_Force Recurring?', '1', '', 'When enabled, a domain will always have the recurring fee turned on and enabled.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1243, 0, 'plugin_domainupdater_Update Transfer Status?', '1', '', 'When enabled, Clientexec will check if a domain has been transfered and update internal values as needed.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1244, 0, 'plugin_domainupdater_Enable Renewal Notifications?', '0', '', 'When enabled, Clientexec will send out renewal notifications for domains that are expiring.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1245, 0, 'plugin_domainupdater_Days To Send Renewal Notice', '30,7', '', 'Enter the number of days before a domain expires that Clientexec should send a renewal notification.  Separate numbers with a comma.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1246, 0, 'plugin_domainupdater_Days To Send Expiration Notice', '5', '', 'Enter the number of days after a domain expires that Clientexec should send an expiration notification.  Separate numbers with a comma.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1247, 0, 'plugin_domainupdater_E-mail Notifications', '', '', 'If domains are updated when this service is run, a summary E-mail will be sent to this address.', 6, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0),
(1248, 0, 'plugin_domainupdater_Run schedule - Minute', '0', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 8, 1, 0, 0, 0),
(1249, 0, 'plugin_domainupdater_Run schedule - Hour', '0', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1250, 0, 'plugin_domainupdater_Run schedule - Day', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1251, 0, 'plugin_domainupdater_Run schedule - Month', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1252, 0, 'plugin_domainupdater_Run schedule - Day of the week', '*', '', 'Enter number in range 0-6 (0 is Sunday) or a 3 letter shortcut (e.g. sun)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1253, 0, 'plugin_expiringcc_Plugin Name', 'Expiring CC Notifier', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1254, 0, 'plugin_expiringcc_Enabled', '0', '', 'When enabled, notify customers with expiring cards at the end of the month.  When run it will E-mail customers with a credit card expiring that month and generate a ticket for credit cards expired in the previous month.<br><b>NOTE:</b> This service is intended to run only once per month.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1255, 0, 'plugin_expiringcc_Delete Expired CC', '0', '', 'Delete expired credit card if there are no recurring charges and no unpaid invoices.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1256, 0, 'plugin_expiringcc_Generate Ticket Upon Expiration', '1', '', 'Generates a ticket in the customers account when their credit card expires.  Useful for allowing administrators to follow up on the expired credit card.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1257, 0, 'plugin_expiringcc_Run schedule - Minute', '0', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 8, 1, 0, 0, 0),
(1258, 0, 'plugin_expiringcc_Run schedule - Hour', '0', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1259, 0, 'plugin_expiringcc_Run schedule - Day', '1', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1260, 0, 'plugin_expiringcc_Run schedule - Month', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1261, 0, 'plugin_expiringcc_Run schedule - Day of the week', '*', '', 'Enter number in range 0-6 (0 is Sunday) or a 3 letter shortcut (e.g. sun)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1262, 0, 'plugin_fetchticket_Plugin Name', 'Tickets Generator', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1263, 0, 'plugin_fetchticket_Enabled', '0', '', 'This is the service that actually does the fetching of E-mails for all E-mail Routing Rules that use the &quot;POP3 fetching&quot; routing type. Only USER authentication mechanism. Be aware that messages on the account will get erased after being imported, or bounced if invalid.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1264, 0, 'plugin_fetchticket_Debug Mode?', '0', '', 'Enabling this setting will cause extensive pop3 logging.  Passwords may be logged so use with caution.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1265, 0, 'plugin_fetchticket_Run schedule - Minute', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 8, 1, 0, 0, 0),
(1266, 0, 'plugin_fetchticket_Run schedule - Hour', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1267, 0, 'plugin_fetchticket_Run schedule - Day', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1268, 0, 'plugin_fetchticket_Run schedule - Month', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1269, 0, 'plugin_fetchticket_Run schedule - Day of the week', '*', '', 'Enter number in range 0-6 (0 is Sunday) or a 3 letter shortcut (e.g. sun)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1270, 0, 'plugin_invoicegenerator_Plugin Name', 'Invoice Generator', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1271, 0, 'plugin_invoicegenerator_Enabled', '0', '', 'When enabled, invoices will automatically be created.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1272, 0, 'plugin_invoicegenerator_Run schedule - Minute', '0', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 8, 1, 0, 0, 0),
(1273, 0, 'plugin_invoicegenerator_Run schedule - Hour', '0', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1274, 0, 'plugin_invoicegenerator_Run schedule - Day', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1275, 0, 'plugin_invoicegenerator_Run schedule - Month', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1276, 0, 'plugin_invoicegenerator_Run schedule - Day of the week', '*', '', 'Enter number in range 0-6 (0 is Sunday) or a 3 letter shortcut (e.g. sun)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1277, 0, 'plugin_invoicestoprocess_Plugin Name', 'Invoices To Process Today', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1278, 0, 'plugin_invoicestoprocess_Enabled', '0', '', 'When enabled, an email will be sent to the provided email addresses, notifying about how many invoices need to be processed today. If there are no invoices needing to be processed today, no email will be sent. <br><b>NOTE:</b> Only run once per day to avoid duplicate E-mails.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1279, 0, 'plugin_invoicestoprocess_Include invoices previously declined', '0', '', 'When enabled, will also take in count your customer&#039;s invoices that are due or past-due and have declined transactions.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1280, 0, 'plugin_invoicestoprocess_E-mails', '', '', 'E-mail addresses to be notified.', 6, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0),
(1281, 0, 'plugin_invoicestoprocess_E-mail Subject', 'Invoices To Process Today', '', 'E-mail subject for the notification.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1282, 0, 'plugin_invoicestoprocess_Run schedule - Minute', '0', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 8, 1, 0, 0, 0),
(1283, 0, 'plugin_invoicestoprocess_Run schedule - Hour', '0', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1284, 0, 'plugin_invoicestoprocess_Run schedule - Day', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1285, 0, 'plugin_invoicestoprocess_Run schedule - Month', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1286, 0, 'plugin_invoicestoprocess_Run schedule - Day of the week', '*', '', 'Enter number in range 0-6 (0 is Sunday) or a 3 letter shortcut (e.g. sun)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1287, 0, 'plugin_latefee_Plugin Name', 'Late Fee', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1288, 0, 'plugin_latefee_Enabled', '0', '', 'When enabled, late invoices will be charged with additional late fees. This service should only run once per day, and preferable if run before <b>Invoice Reminder</b> service, to avoid sending reminders without the late fee.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1289, 0, 'plugin_latefee_Default late fee charge', '', '', 'Enter a default amount to be charged as a late fee on invoices, if the product has not defined its own late fee. <br><strong><i>Note: Leave this field empty if you want to avoid default late fee.</i></strong>', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1290, 0, 'plugin_latefee_Default late fee charge (GBP)', '', '', '<strong>British pound</strong><br>Enter a default amount to be charged as a late fee on invoices, if the product has not defined its own late fee. <br><strong><i>Note: Leave this field empty if you want to avoid default late fee.</i></strong>', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1291, 0, 'plugin_latefee_Default late fee charge (CAD)', '', '', '<strong>Canadian dollar</strong><br>Enter a default amount to be charged as a late fee on invoices, if the product has not defined its own late fee. <br><strong><i>Note: Leave this field empty if you want to avoid default late fee.</i></strong>', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1292, 0, 'plugin_latefee_Default late fee charge (EUR)', '', '', '<strong>Euro</strong><br>Enter a default amount to be charged as a late fee on invoices, if the product has not defined its own late fee. <br><strong><i>Note: Leave this field empty if you want to avoid default late fee.</i></strong>', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1293, 0, 'plugin_latefee_Default late fee charge (USD)', '', '', '<strong>United States dollar</strong><br>Enter a default amount to be charged as a late fee on invoices, if the product has not defined its own late fee. <br><strong><i>Note: Leave this field empty if you want to avoid default late fee.</i></strong>', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1294, 0, 'plugin_latefee_Day to charge late fee', '10', '', 'Enter the number of days after the due date to charge a late fee on invoices. <br><strong><i>Note: Please enter one number only.</i></strong><br><br><b>Example</b>: 10 would charge late fee when ten or more days late.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1295, 0, 'plugin_latefee_Run schedule - Minute', '0', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 8, 1, 0, 0, 0),
(1296, 0, 'plugin_latefee_Run schedule - Hour', '0', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1297, 0, 'plugin_latefee_Run schedule - Day', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1298, 0, 'plugin_latefee_Run schedule - Month', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1299, 0, 'plugin_latefee_Run schedule - Day of the week', '*', '', 'Enter number in range 0-6 (0 is Sunday) or a 3 letter shortcut (e.g. sun)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1300, 0, 'plugin_mailer_Plugin Name', 'Bulk Mailer', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1301, 0, 'plugin_mailer_Enabled', '0', '', 'When enabled, emails won&#039;t be sent immediately, but be queued instead and sent when this service is triggered. Use it to improve performance if you have to send lots of emails at once.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1302, 0, 'plugin_mailer_Limit', '', '', 'Sets the number of emails that will be sent each time this service is triggered.  Leave this blank to not have a limit.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1303, 0, 'plugin_mailer_Run schedule - Minute', '30', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 8, 1, 0, 0, 0),
(1304, 0, 'plugin_mailer_Run schedule - Hour', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1305, 0, 'plugin_mailer_Run schedule - Day', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1306, 0, 'plugin_mailer_Run schedule - Month', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1307, 0, 'plugin_mailer_Run schedule - Day of the week', '*', '', 'Enter number in range 0-6 (0 is Sunday) or a 3 letter shortcut (e.g. sun)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1308, 0, 'plugin_optimizedb_Plugin Name', 'Optimize DataBase', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1309, 0, 'plugin_optimizedb_Enabled', '0', '', 'When enabled, this service will optimize all tables in your ClientExec database.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1310, 0, 'plugin_optimizedb_Run schedule - Minute', '30', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 8, 1, 0, 0, 0),
(1311, 0, 'plugin_optimizedb_Run schedule - Hour', '01', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1312, 0, 'plugin_optimizedb_Run schedule - Day', '15', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1313, 0, 'plugin_optimizedb_Run schedule - Month', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1314, 0, 'plugin_optimizedb_Run schedule - Day of the week', '*', '', 'Enter number in range 0-6 (0 is Sunday) or a 3 letter shortcut (e.g. sun)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1315, 0, 'plugin_order_Plugin Name', 'Order Processor', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1316, 0, 'plugin_order_Enabled', '0', '', 'When enabled, new orders will be activated and processed when this service is run.  Please note that manually added packages will not be processed.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1317, 0, 'plugin_order_E-mail Notifications', '', '', 'When a domain requires manual registration or transfer, or an account requires manual setup you will be notified at this E-mail address.', 6, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0),
(1318, 0, 'plugin_order_Activate Cancelled Users', '0', '', 'When enabled, new orders from cancelled customers will also be activated.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1319, 0, 'plugin_order_Activate Manually Added Packages', '0', '', 'When enabled, new packages added by a staff member will also be activated when they have been paid.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1320, 0, 'plugin_order_Run schedule - Minute', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 8, 1, 0, 0, 0),
(1321, 0, 'plugin_order_Run schedule - Hour', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1322, 0, 'plugin_order_Run schedule - Day', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1323, 0, 'plugin_order_Run schedule - Month', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1324, 0, 'plugin_order_Run schedule - Day of the week', '*', '', 'Enter number in range 0-6 (0 is Sunday) or a 3 letter shortcut (e.g. sun)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1325, 0, 'plugin_processaffiliates_Plugin Name', 'Process Affiliates', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1326, 0, 'plugin_processaffiliates_Enabled', '0', '', 'When enabled, this will process pending commissions and pending affiliates', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1327, 0, 'plugin_processaffiliates_Run schedule - Minute', '0', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 8, 1, 0, 0, 0),
(1328, 0, 'plugin_processaffiliates_Run schedule - Hour', '0', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1329, 0, 'plugin_processaffiliates_Run schedule - Day', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1330, 0, 'plugin_processaffiliates_Run schedule - Month', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1331, 0, 'plugin_processaffiliates_Run schedule - Day of the week', '*', '', 'Enter number in range 0-6 (0 is Sunday) or a 3 letter shortcut (e.g. sun)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1332, 0, 'plugin_prowl_Plugin Name', 'Prowl Push Notifications', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1333, 0, 'plugin_prowl_Enabled', '0', '', 'When enabled, this service plugin pushes certain notifications from ClientExec to the Prowl application on your iPhone. Please note, Curl with SSL is required to use the Prowl service. <b>This service requires the Paid iPhone application Prowl to work</b>', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1334, 0, 'plugin_prowl_Prowl API Keys', '', '', 'Enter the API key for your Prowl account (separate multiple keys with a comma)', 6, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0),
(1335, 0, 'plugin_prowl_Notify of New Orders', '1', '', 'Select Yes to be notified when a new order is placed.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1336, 0, 'plugin_prowl_Notify of New High Priority Tickets', '1', '', 'Select Yes to be notified when a new High Priority Ticket is received.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1337, 0, 'plugin_prowl_Run schedule - Minute', '*/5', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 8, 1, 0, 0, 0),
(1338, 0, 'plugin_prowl_Run schedule - Hour', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1339, 0, 'plugin_prowl_Run schedule - Day', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1340, 0, 'plugin_prowl_Run schedule - Month', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1341, 0, 'plugin_prowl_Run schedule - Day of the week', '*', '', 'Enter number in range 0-6 (0 is Sunday) or a 3 letter shortcut (e.g. sun)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1342, 0, 'plugin_prowl_LastRun', '', '', 'Timestamp of last run. Used to determine new items to push', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1343, 0, 'plugin_rebiller_Plugin Name', 'Invoice Reminder', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1344, 0, 'plugin_rebiller_Enabled', '0', '', 'When enabled, late invoice reminders will be sent out to customers. This service should only run once per day to avoid sending reminders twice in the same day.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1345, 0, 'plugin_rebiller_Summary E-mail', '', '', 'E-mail addresses to which a summary of the notified invoices will be sent.  (Leave blank if you do not wish to receive a summary)', 6, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0),
(1346, 0, 'plugin_rebiller_Summary E-mail Subject', 'Invoice Reminder Summary', '', 'E-mail subject for the summary notification.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1347, 0, 'plugin_rebiller_Days to trigger reminder', '-10,-5,-1,1,5,10+', '', '<b>For late invoice remainder</b>: Enter the number of days after the due date to send a late invoice reminder.  You may enter more than one day by seperating the numbers with a comma.  <strong><i>Note: A number followed by a + sign indicates to send for all days greater than the previous number or use * to send reminders each day.</i></strong><br><br><b>For upcoming invoice reminder</b>: Enter the number of days before the due date to send an upcoming invoice reminder. You may enter more than one day by seperating the numbers by commas: these numbers must start with a - sign (negative numbers). <strong><i>Note: this only works if the invoice is already generated</i></strong>.<br><br><b>Example</b>: -10,-5,-1,1,5,10+ would send on the tenth days before the due date, five days before, one day before, one day late, five days late and ten or more days late', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1348, 0, 'plugin_rebiller_Run schedule - Minute', '0', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 8, 1, 0, 0, 0),
(1349, 0, 'plugin_rebiller_Run schedule - Hour', '0', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1350, 0, 'plugin_rebiller_Run schedule - Day', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1351, 0, 'plugin_rebiller_Run schedule - Month', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1352, 0, 'plugin_rebiller_Run schedule - Day of the week', '*', '', 'Enter number in range 0-6 (0 is Sunday) or a 3 letter shortcut (e.g. sun)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1353, 0, 'plugin_serverstatus_Plugin Name', 'Server Status', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1354, 0, 'plugin_serverstatus_Enabled', '0', '', 'When enabled and server plugin has server stats script URL, ClientExec will notify you if the server is not responding or when certain thresholds are met.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1355, 0, 'plugin_serverstatus_Admin E-mail', '', '', 'E-mails that will be E-mailed when thresholds are passed. Enter each E-mail in a separate line.', 6, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0),
(1356, 0, 'plugin_serverstatus_1 Min. Load Average', '', '', 'Add 1 Minute server load average threshold you want this service to E-mail if passed.<br/>Ex: 1.5, will E-mail when load goes over 1.5', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1357, 0, 'plugin_serverstatus_5 Min. Load Average', '', '', 'Add 5 Minute server load average threshold you want this service to E-mail if passed.<br/>Ex: 1.5, will E-mail when load goes over 1.5', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1358, 0, 'plugin_serverstatus_Used Physical Memory', '', '', 'Add used physical memory threshold in megabytes (MB) you want this service to E-mail if passed. Current cache use will be subtracted from the Used Physical Memory on the server.<br/>Ex: 512, will E-mail when memory goes over 512 MB', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1359, 0, 'plugin_serverstatus_Server Restarted', '0', '', 'Notify if the server was restarted since the last check.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1360, 0, 'plugin_serverstatus_Mount Space Available', '', '', 'Add mount and percentage threshold that you want this service to E-mail you on. Use ; as separator if you want to monitor more than one mount.<br/>Ex: /home,75;/tmp,50', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1361, 0, 'plugin_serverstatus_Ignore Mount Point Errors', '0', '', 'Enabling this option will cause Clientexec not to error if it can not find a mount point', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1362, 0, 'plugin_serverstatus_Run schedule - Minute', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 8, 1, 0, 0, 0),
(1363, 0, 'plugin_serverstatus_Run schedule - Hour', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1364, 0, 'plugin_serverstatus_Run schedule - Day', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1365, 0, 'plugin_serverstatus_Run schedule - Month', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1366, 0, 'plugin_serverstatus_Run schedule - Day of the week', '*', '', 'Enter number in range 0-6 (0 is Sunday) or a 3 letter shortcut (e.g. sun)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1367, 0, 'plugin_teamstatusnotifier_Plugin Name', 'Team Status Notifier', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1368, 0, 'plugin_teamstatusnotifier_Enabled', '0', '', 'When enabled, Team Status Notifications are sent by e-mail when this service is triggered.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1369, 0, 'plugin_teamstatusnotifier_Run schedule - Minute', '0', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 8, 1, 0, 0, 0),
(1370, 0, 'plugin_teamstatusnotifier_Run schedule - Hour', '0', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1371, 0, 'plugin_teamstatusnotifier_Run schedule - Day', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1372, 0, 'plugin_teamstatusnotifier_Run schedule - Month', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1373, 0, 'plugin_teamstatusnotifier_Run schedule - Day of the week', '*', '', 'Enter number in range 0-6 (0 is Sunday) or a 3 letter shortcut (e.g. sun)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1374, 0, 'plugin_upgradedowngrade_Plugin Name', 'Upgrade/Downgrade Packages', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1375, 0, 'plugin_upgradedowngrade_Enabled', '0', '', 'When enabled, packages will be upgraded/downgraded when this service is run if the respective invoice was paid.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1376, 0, 'plugin_upgradedowngrade_Hours Overdue Before Voiding Invoice', '24', '', 'Only void invoices that are this many hours overdue.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1377, 0, 'plugin_upgradedowngrade_E-mail Notifications', '', '', 'When an upgrade/downgrade requires manual setup you will be notified at this E-mail address.', 6, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0),
(1378, 0, 'plugin_upgradedowngrade_Create Ticket', '1', '', 'When an upgrade/downgrade requires manual setup, automatically create a ticket under the user&#039;s account.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1379, 0, 'plugin_upgradedowngrade_Ticket Assign To', 'dep_0_staff_0', '', 'If <b>Create Ticket</b> is set to YES, select here to whom you want the ticket to be assigned.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1380, 0, 'plugin_upgradedowngrade_Run schedule - Minute', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 8, 1, 0, 0, 0),
(1381, 0, 'plugin_upgradedowngrade_Run schedule - Hour', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1382, 0, 'plugin_upgradedowngrade_Run schedule - Day', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1383, 0, 'plugin_upgradedowngrade_Run schedule - Month', '*', '', 'Enter number, range, list or steps', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1384, 0, 'plugin_upgradedowngrade_Run schedule - Day of the week', '*', '', 'Enter number in range 0-6 (0 is Sunday) or a 3 letter shortcut (e.g. sun)', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1385, 0, 'plugin_ceinvoices_Enabled', '', '', 'Select Yes if you want this functionality enabled in your installation', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1386, 0, 'plugin_ceinvoices_Viewable by all staff', '1', '', '<strong>Note: Selecting no will allow you to specify permissions per <a href=&#039;index.php?fuse=admin&controller=staff&view=adminlist&#039;>staff group</a></strong><br/>Enable admin panel functionality, listed below, to all staff members<br><strong><font color=&#039;#f90&#039;>Admin Panel Features</font></strong><br/><ul><li>Adds an invoice grid to each users package</ul>', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1387, 0, 'plugin_ceinvoices_Plugin Name', 'Invoices', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1388, 0, 'plugin_cetransactions_Enabled', '1', '', 'Select Yes if you want this functionality enabled in your installation', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1389, 0, 'plugin_cetransactions_Viewable by all staff', '1', '', '<strong>Note: Selecting no will allow you to specify permissions per <a href=&#039;index.php?fuse=admin&controller=staff&view=adminlist&#039;>staff group</a></strong><br/>Enable admin panel functionality, listed below, to all staff members<br><strong><font color=&#039;#f90&#039;>Admin Panel Features</font></strong><br/><ul><li>Show all billing transactions off of main menu</ul>', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1390, 0, 'plugin_cetransactions_Viewable by all customers', '1', '', '<strong>Note: Selecting no will allow you to specify permissions per <a href=&#039;index.php?fuse=admin&controller=groups&view=viewgroups&#039;>customer group</a></strong><br/>Determine if you wish all customers to have this functionality<br><strong><font color=&#039;#f90&#039;>Public Panel Features</font></strong><br/><ul><li>Transactions</ul>', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1391, 0, 'plugin_cetransactions_Plugin Name', 'Transactions', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1392, 0, 'plugin_clicksend_Enabled', '', '', 'Select Yes if you want this functionality enabled in your installation', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1393, 0, 'plugin_clicksend_Viewable by all staff', '1', '', '<strong>Note: Selecting no will allow you to specify permissions per <a href=&#039;index.php?fuse=admin&controller=staff&view=adminlist&#039;>staff group</a></strong><br/>Enable admin panel functionality, listed below, to all staff members<br><strong><font color=&#039;#f90&#039;>Admin Panel Features</font></strong><br/><ul><li>Adds a button to the top of an admin invoice to manually send the invoice.</ul>', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1394, 0, 'plugin_clicksend_Plugin Name', 'ClickSend Invoice Sending Integration', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1395, 0, 'plugin_clicksend_Username', '', '', 'ClickSend Username.  Sign up for an account <a href=&quot;http://clicksend.com/?u=12366&quot;>here</a>.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1396, 0, 'plugin_clicksend_API Key', '', '', 'ClickSend API Key', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1397, 0, 'plugin_clicksend_Use Color?', '', '', 'Use color when sending the invoice', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1398, 0, 'plugin_crisp_Enabled', '', '', 'Select Yes if you want this functionality enabled in your installation', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1399, 0, 'plugin_crisp_Viewable by all customers', '1', '', '<strong>Note: Selecting no will allow you to specify permissions per <a href=&#039;index.php?fuse=admin&controller=groups&view=viewgroups&#039;>customer group</a></strong><br/>Determine if you wish all customers to have this functionality<br><strong><font color=&#039;#f90&#039;>Public Panel Features</font></strong><br/><ul><li>Adds the required javascript to the client area footer.</ul>', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1400, 0, 'plugin_crisp_Plugin Name', 'Crisp Livechat', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1401, 0, 'plugin_crisp_Website ID', '', '', 'Enter your Crisp Website ID', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1402, 0, 'plugin_crisp_Secret Key', '', '', 'Enter your secret key for email verification', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1403, 0, 'plugin_csfunblock_Enabled', '', '', 'Select Yes if you want this functionality enabled in your installation', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1404, 0, 'plugin_csfunblock_Viewable by all customers', '1', '', '<strong>Note: Selecting no will allow you to specify permissions per <a href=&#039;index.php?fuse=admin&controller=groups&view=viewgroups&#039;>customer group</a></strong><br/>Determine if you wish all customers to have this functionality<br><strong><font color=&#039;#f90&#039;>Public Panel Features</font></strong><br/><ul><li>Unblock IP<li>Unblock IP<li>Unblock IP</ul>', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1405, 0, 'plugin_csfunblock_Plugin Name', 'CSF Unblock', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1406, 0, 'plugin_csfunblock_Public Description', 'Unblock your IP', '', 'Description to be seen by public', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1407, 0, 'plugin_csfunblock_Use Image', '1', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1408, 0, 'plugin_domainrenewallogs_Enabled', '1', '', 'Select Yes if you want this functionality enabled in your installation', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1409, 0, 'plugin_domainrenewallogs_Viewable by all staff', '1', '', '<strong>Note: Selecting no will allow you to specify permissions per <a href=&#039;index.php?fuse=admin&controller=staff&view=adminlist&#039;>staff group</a></strong><br/>Enable admin panel functionality, listed below, to all staff members<br><strong><font color=&#039;#f90&#039;>Admin Panel Features</font></strong><br/><ul><li>Adds a grid to display domain renewal logs to all domain packages</ul>', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1410, 0, 'plugin_domainrenewallogs_Plugin Name', 'Domain Renewal Logs', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1411, 0, 'plugin_enomform_Enabled', '', '', 'Select Yes if you want this functionality enabled in your installation', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1412, 0, 'plugin_enomform_Viewable by all customers', '1', '', '<strong>Note: Selecting no will allow you to specify permissions per <a href=&#039;index.php?fuse=admin&controller=groups&view=viewgroups&#039;>customer group</a></strong><br/>Determine if you wish all customers to have this functionality<br><strong><font color=&#039;#f90&#039;>Public Panel Features</font></strong><br/><ul><li>Integrate eNom Signup Form in Public Home<li>Integrate eNom Signup Form in Public Top Menu<li>eNom Reseller</ul>', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1413, 0, 'plugin_enomform_Plugin Name', 'eNom Form', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1414, 0, 'plugin_enomform_Snap-in header seen by customers', 'Don&#039;t have a domain reseller account? Get your <strong>FREE</strong> eNom domain reseller account today! When you are ready to make your first domain purchase, top up your account with $25 credit which will be used for your purchases. <br><br>eNom is fully compatible with Clientexec and is our recommended domain reselling platform.', '', 'Enter the header that will be shown on top of the snap-in, explaining rates and such.', 6, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0),
(1415, 0, 'plugin_enomform_Success message', 'Congratulations! Your eNom account has been created successfully.  You will receive an email notification with your login information shortly.<br><br><b>Note:</b> If a reseller account was requested it has been created as a retail account and will be upgraded to a reseller account within the next 24-48 hours.<br><br>Thank you,<br>-ClientExec Team', '', 'This is the message the customer will see after a successful eNom account creation.', 6, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0),
(1416, 0, 'plugin_enomform_Use ClientExec Account', '1', '', 'Select YES if you don&#039;t have an eNom reseller account and wish to provide accounts to your customers through ClientExec&#039;s account. Select NO if you have obtained your reseller account, for which you&#039;ll have to enter the Login and Password below. You can obtain an eNom reseller account by login into your Clientexec member account.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1417, 0, 'plugin_enomform_Use testing server', '0', '', 'Select Yes if you wish to use eNom&#039;s testing environment, so that transactions are not actually made. For this to work, you must first register you server&#039;s ip in eNom&#039;s testing environment, and your server&#039;s name servers must be registered there as well.', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1418, 0, 'plugin_enomform_Login', '', '', 'Enter your username for your eNom reseller account. If you are using Clientexec&#039;s account, you can leave this field empty.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1419, 0, 'plugin_enomform_Password', '', '', 'Enter the password for your eNom reseller account. If you are using Clientexec&#039;s account, you can leave this field empty.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(1420, 0, 'plugin_enomform_Notification Email', '', '', 'If not using Clientexec&#039;s eNom account, enter the email address to which sign up details should be emailed to.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1421, 0, 'plugin_enomform_Public Description', 'Sign up for your eNom reseller account today.', '', 'Description to be seen by public', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1422, 0, 'plugin_enomform_Type of Account to Create', '0', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1423, 0, 'plugin_enomform_Use Image', '1', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1424, 0, 'plugin_hetznercloudhelper_Enabled', '', '', 'Select Yes if you want this functionality enabled in your installation', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1425, 0, 'plugin_hetznercloudhelper_Viewable by all staff', '1', '', '<strong>Note: Selecting no will allow you to specify permissions per <a href=&#039;index.php?fuse=admin&controller=staff&view=adminlist&#039;>staff group</a></strong><br/>Enable admin panel functionality, listed below, to all staff members<br><strong><font color=&#039;#f90&#039;>Admin Panel Features</font></strong><br/><ul><li>Hetznercloud Helper</ul>', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1426, 0, 'plugin_hetznercloudhelper_Viewable by all customers', '1', '', '<strong>Note: Selecting no will allow you to specify permissions per <a href=&#039;index.php?fuse=admin&controller=groups&view=viewgroups&#039;>customer group</a></strong><br/>Determine if you wish all customers to have this functionality<br><strong><font color=&#039;#f90&#039;>Public Panel Features</font></strong><br/><ul><li>Hetznercloud Helper</ul>', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1427, 0, 'plugin_hetznercloudhelper_Plugin Name', 'Hetznercloud Helper', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1428, 0, 'plugin_licensedefender_Enabled', '', '', 'Select Yes if you want this functionality enabled in your installation', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1429, 0, 'plugin_licensedefender_Viewable by all staff', '1', '', '<strong>Note: Selecting no will allow you to specify permissions per <a href=&#039;index.php?fuse=admin&controller=staff&view=adminlist&#039;>staff group</a></strong><br/>Enable admin panel functionality, listed below, to all staff members<br><strong><font color=&#039;#f90&#039;>Admin Panel Features</font></strong><br/><ul><li>Manage Clientexec Licenses<li>Manage Clientexec Resellers</ul>', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1430, 0, 'plugin_licensedefender_Viewable by all customers', '1', '', '<strong>Note: Selecting no will allow you to specify permissions per <a href=&#039;index.php?fuse=admin&controller=groups&view=viewgroups&#039;>customer group</a></strong><br/>Determine if you wish all customers to have this functionality<br><strong><font color=&#039;#f90&#039;>Public Panel Features</font></strong><br/><ul><li>Licenses<li>Resellers</ul>', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1431, 0, 'plugin_licensedefender_Plugin Name', 'Reseller Panel', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1432, 0, 'plugin_licensedefender_API Username', '', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1433, 0, 'plugin_licensedefender_API Password', '', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1434, 0, 'plugin_linodehelper_Enabled', '', '', 'Select Yes if you want this functionality enabled in your installation', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1435, 0, 'plugin_linodehelper_Viewable by all staff', '1', '', '<strong>Note: Selecting no will allow you to specify permissions per <a href=&#039;index.php?fuse=admin&controller=staff&view=adminlist&#039;>staff group</a></strong><br/>Enable admin panel functionality, listed below, to all staff members<br><strong><font color=&#039;#f90&#039;>Admin Panel Features</font></strong><br/><ul><li>Linode Helper</ul>', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1436, 0, 'plugin_linodehelper_Viewable by all customers', '1', '', '<strong>Note: Selecting no will allow you to specify permissions per <a href=&#039;index.php?fuse=admin&controller=groups&view=viewgroups&#039;>customer group</a></strong><br/>Determine if you wish all customers to have this functionality<br><strong><font color=&#039;#f90&#039;>Public Panel Features</font></strong><br/><ul><li>Linode Helper</ul>', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1437, 0, 'plugin_linodehelper_Plugin Name', 'Linode Helper', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1438, 0, 'plugin_locationselector_Enabled', '', '', 'Select Yes if you want this functionality enabled in your installation', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1439, 0, 'plugin_locationselector_Plugin Name', 'Server Location Selector', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1440, 0, 'plugin_locationselector_Location Custom Field Name', '', '', 'Enter the name of the location custom field', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1441, 0, 'plugin_maxmindchargeback_Enabled', '', '', 'Select Yes if you want this functionality enabled in your installation', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1442, 0, 'plugin_maxmindchargeback_Viewable by all staff', '1', '', '<strong>Note: Selecting no will allow you to specify permissions per <a href=&#039;index.php?fuse=admin&controller=staff&view=adminlist&#039;>staff group</a></strong><br/>Enable admin panel functionality, listed below, to all staff members<br><strong><font color=&#039;#f90&#039;>Admin Panel Features</font></strong><br/><ul><li>Adds a button to the top of an admin invoice to report a chargeback.</ul>', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1443, 0, 'plugin_maxmindchargeback_Plugin Name', 'Report Chargebacks to MaxMind', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1444, 0, 'plugin_maxmindchargeback_MaxMind Account ID', '', '', 'Enter your MaxMind Account ID. <br>You can obtain a license at <a href=https://www.maxmind.com/en/solutions/minfraud-services?rId=clientexec target=_blank>https://www.maxmind.com/en/solutions/minfraud-services</a>', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1445, 0, 'plugin_maxmindchargeback_MaxMind License Key', '', '', 'Enter your MaxMind License Key here.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1446, 0, 'plugin_phpsysinfo_Enabled', '', '', 'Select Yes if you want this functionality enabled in your installation', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1447, 0, 'plugin_phpsysinfo_Viewable by all customers', '1', '', '<strong>Note: Selecting no will allow you to specify permissions per <a href=&#039;index.php?fuse=admin&controller=groups&view=viewgroups&#039;>customer group</a></strong><br/>Determine if you wish all customers to have this functionality<br><strong><font color=&#039;#f90&#039;>Public Panel Features</font></strong><br/><ul><li>Integrate PHPSysInfo in Public Home<li>Integrate PHPSysInfo in Public Top Menu<li>Server Info</ul>', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1448, 0, 'plugin_phpsysinfo_Plugin Name', 'Server Info', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1449, 0, 'plugin_phpsysinfo_Public Description', 'View Server Details', '', 'Description to be seen by public', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1450, 0, 'plugin_phpsysinfo_Use Image', '1', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1451, 0, 'plugin_proxmoxvehelper_Enabled', '', '', 'Select Yes if you want this functionality enabled in your installation', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1452, 0, 'plugin_proxmoxvehelper_Viewable by all staff', '1', '', '<strong>Note: Selecting no will allow you to specify permissions per <a href=&#039;index.php?fuse=admin&controller=staff&view=adminlist&#039;>staff group</a></strong><br/>Enable admin panel functionality, listed below, to all staff members<br><strong><font color=&#039;#f90&#039;>Admin Panel Features</font></strong><br/><ul><li>ProxmoxVE Helper</ul>', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1453, 0, 'plugin_proxmoxvehelper_Viewable by all customers', '1', '', '<strong>Note: Selecting no will allow you to specify permissions per <a href=&#039;index.php?fuse=admin&controller=groups&view=viewgroups&#039;>customer group</a></strong><br/>Determine if you wish all customers to have this functionality<br><strong><font color=&#039;#f90&#039;>Public Panel Features</font></strong><br/><ul><li>ProxmoxVE Helper</ul>', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1454, 0, 'plugin_proxmoxvehelper_Plugin Name', 'ProxmoxVE Helper', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1455, 0, 'plugin_softaculousautoinstall_Enabled', '', '', 'Select Yes if you want this functionality enabled in your installation', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1456, 0, 'plugin_softaculousautoinstall_Plugin Name', 'Softaculous Auto Installer', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1457, 0, 'plugin_softaculousautoinstall_Script Custom Field Name', '', '', 'Enter the custom field name for the script to auto-install', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1458, 0, 'plugin_softaculousautoinstall_Username Custom Field Name', '', '', 'Enter the custom field name for the admin username', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1459, 0, 'plugin_softaculousautoinstall_Password Custom Field Name', '', '', 'Enter the custom field name for the admin password', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1460, 0, 'plugin_softaculousautoinstall_Auto Upgrade?', '', '', 'Enable Auto Upgrade (Auto upgrade will be enabled only if the script supports auto upgrade)', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1461, 0, 'plugin_softaculousautoinstall_Auto Backup?', 'No', '', 'Enable Auto Backups?', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1462, 0, 'plugin_systemcheck_Enabled', '1', '', 'Select Yes if you want this functionality enabled in your installation', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1463, 0, 'plugin_systemcheck_Viewable by all staff', '1', '', '<strong>Note: Selecting no will allow you to specify permissions per <a href=&#039;index.php?fuse=admin&controller=staff&view=adminlist&#039;>staff group</a></strong><br/>Enable admin panel functionality, listed below, to all staff members<br><strong><font color=&#039;#f90&#039;>Admin Panel Features</font></strong><br/><ul><li>Show missing settings from Clientexec installation</ul>', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0);
INSERT INTO `setting` VALUES
(1464, 0, 'plugin_systemcheck_Viewable by all customers', '1', '', '<strong>Note: Selecting no will allow you to specify permissions per <a href=&#039;index.php?fuse=admin&controller=groups&view=viewgroups&#039;>customer group</a></strong><br/>Determine if you wish all customers to have this functionality<br><strong><font color=&#039;#f90&#039;>Public Panel Features</font></strong><br/><ul><li></ul>', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1465, 0, 'plugin_systemcheck_Plugin Name', 'System Check', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1466, 0, 'plugin_tldportal_Enabled', '', '', 'Select Yes if you want this functionality enabled in your installation', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1467, 0, 'plugin_tldportal_Viewable by all customers', '1', '', '<strong>Note: Selecting no will allow you to specify permissions per <a href=&#039;index.php?fuse=admin&controller=groups&view=viewgroups&#039;>customer group</a></strong><br/>Determine if you wish all customers to have this functionality<br><strong><font color=&#039;#f90&#039;>Public Panel Features</font></strong><br/><ul><li>When enabled this snapin allows your customers the use of the eNom TLD Watchlist</ul>', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1468, 0, 'plugin_tldportal_Plugin Name', 'New TLD Portal', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1469, 0, 'plugin_tldportal_Login', '', '', 'Enter your username for your eNom reseller account.  Don&#039;t have an eNom account?  Get a FREE account <a target=&quot;_blank&quot; href=&quot;https://www.clientexec.com/members/index.php?fuse=admin&view=snapin&controller=snapins&plugin=enomform&quot;>here</a>.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1470, 0, 'plugin_tldportal_Password', '', '', 'Enter the password for your eNom reseller account.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0),
(1471, 0, 'plugin_tldportal_Company Name', '', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1472, 0, 'plugin_tldportal_Support Email Address', '', '', 'Will appear as the Reply To field for email sent on your behalf.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1473, 0, 'plugin_tldportal_Default Portal URL', '[[softurl]]/index.php?fuse=admin&view=snapin&controller=snapins&plugin=tldportal', '', 'Where we should send your users when communicating to them about their new TLD lists.<br/><br/> By clicking update you agreee to the <a href=&quot;http://www.enom.com/terms/agreement.aspx?page=tldportalreseller&quot; target=&quot;_blank&quot;>terms & conditions</a><br/><br/><a target=&quot;_blank&quot; href=&quot;http://www.enom.com/tld-portal/manage.aspx&quot;>Click Here For Additional Configuration</a>', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1474, 0, 'plugin_tldportal_Portal ID', '', '', 'Internal value for Portal ID', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1475, 0, 'plugin_tldportal_Public Description', 'Pre-order and track Domains and TLDs', '', 'Description to be seen by public', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1476, 0, 'plugin_uservoice_Enabled', '', '', 'Select Yes if you want this functionality enabled in your installation', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1477, 0, 'plugin_uservoice_Viewable by all customers', '1', '', '<strong>Note: Selecting no will allow you to specify permissions per <a href=&#039;index.php?fuse=admin&controller=groups&view=viewgroups&#039;>customer group</a></strong><br/>Determine if you wish all customers to have this functionality<br><strong><font color=&#039;#f90&#039;>Public Panel Features</font></strong><br/><ul><li>Integrate Clientexec with Uservoice in Public Home<li>Integrate Clientexec with UserVoice In Top Menu<li>UserVoice</ul>', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1478, 0, 'plugin_uservoice_Plugin Name', 'UserVoice SSO Integration', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1479, 0, 'plugin_uservoice_Public Description', 'Help us improve ClientExec by giving us your suggestions', '', 'Description to be seen by public', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1480, 0, 'plugin_uservoice_Subdomain', '', '', 'Your UserVoice subdomain. For example if your UserVoice URL is http://foobar.uservoice.com, then your subdomain is foobar.', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1481, 0, 'plugin_uservoice_SSO key', '', '', 'Your UserVoice account SSO key. You can get it from the User Authentication portion in the UserVoice General Settings', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1482, 0, 'plugin_vultrhelper_Enabled', '', '', 'Select Yes if you want this functionality enabled in your installation', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1483, 0, 'plugin_vultrhelper_Viewable by all staff', '1', '', '<strong>Note: Selecting no will allow you to specify permissions per <a href=&#039;index.php?fuse=admin&controller=staff&view=adminlist&#039;>staff group</a></strong><br/>Enable admin panel functionality, listed below, to all staff members<br><strong><font color=&#039;#f90&#039;>Admin Panel Features</font></strong><br/><ul><li>Vultr Helper</ul>', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1484, 0, 'plugin_vultrhelper_Viewable by all customers', '1', '', '<strong>Note: Selecting no will allow you to specify permissions per <a href=&#039;index.php?fuse=admin&controller=groups&view=viewgroups&#039;>customer group</a></strong><br/>Determine if you wish all customers to have this functionality<br><strong><font color=&#039;#f90&#039;>Public Panel Features</font></strong><br/><ul><li>Vultr Helper</ul>', 6, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0),
(1485, 0, 'plugin_vultrhelper_Plugin Name', 'Vultr Helper', '', '', 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0),
(1497, 0, 'plugin_cetransactions_CEMappings', '1', '', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(1498, 0, 'plugin_domainrenewallogs_CEMappings', '1', '', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(1499, 0, 'plugin_systemcheck_CEMappings', '1', '', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(1492, 0, 'Default Payment Type Attributes', 'fDIwMjUtMDgtMTM=', '', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(1493, 0, 'templateVariables', 'a:0:{}', '', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(1494, 0, 'default_HeaderHTML', '', '', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(1495, 0, 'default_BodyHTML', '', '', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(1496, 0, 'default_FooterHTML', '', '', '', 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `setting_options`
--

CREATE TABLE `setting_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `settingid` int(11) NOT NULL DEFAULT '0',
  `name` varchar(50) NOT NULL DEFAULT '',
  `value` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Contains all the available options for a giving setting' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `spam_filters`
--

CREATE TABLE `spam_filters` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `value` text NOT NULL,
  `enabled` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `enabled` (`enabled`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `spam_filters`
--

INSERT INTO `spam_filters` VALUES
(1, 'Subject: ***SPAM***', 1),
(2, 'X-Spam-Status: Yes', 1);

-- --------------------------------------------------------

--
-- Table structure for table `state`
--

CREATE TABLE `state` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country_code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `iso2` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `exists` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `country_region_final` (`country_code`,`iso2`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=5117 ;

--
-- Dumping data for table `state`
--

INSERT INTO `state` VALUES
(1, 'Southern Nations, Nationalities, and Peoples'' Region', 'ET', 'SN', 1),
(2, 'Somali Region', 'ET', 'SO', 1),
(3, 'Amhara Region', 'ET', 'AM', 1),
(4, 'Tigray Region', 'ET', 'TI', 1),
(5, 'Oromia Region', 'ET', 'OR', 1),
(6, 'Afar Region', 'ET', 'AF', 1),
(7, 'Harari Region', 'ET', 'HA', 1),
(8, 'Dire Dawa', 'ET', 'DD', 1),
(9, 'Benishangul-Gumuz Region', 'ET', 'BE', 1),
(10, 'Gambela Region', 'ET', 'GA', 1),
(11, 'Addis Ababa', 'ET', 'AA', 1),
(12, 'Petnjica Municipality', 'ME', '23', 1),
(13, 'Bar Municipality', 'ME', '02', 1),
(14, 'Danilovgrad Municipality', 'ME', '07', 1),
(15, 'Rožaje Municipality', 'ME', '17', 1),
(16, 'Plužine Municipality', 'ME', '15', 1),
(17, 'Nikšić Municipality', 'ME', '12', 1),
(18, 'Šavnik Municipality', 'ME', '18', 1),
(19, 'Plav Municipality', 'ME', '13', 1),
(20, 'Pljevlja Municipality', 'ME', '14', 1),
(21, 'Berane Municipality', 'ME', '03', 1),
(22, 'Mojkovac Municipality', 'ME', '11', 1),
(23, 'Andrijevica Municipality', 'ME', '01', 1),
(24, 'Gusinje Municipality', 'ME', '22', 1),
(25, 'Bijelo Polje Municipality', 'ME', '04', 1),
(26, 'Kotor Municipality', 'ME', '10', 1),
(27, 'Podgorica Municipality', 'ME', '16', 1),
(28, 'Old Royal Capital Cetinje', 'ME', '06', 1),
(29, 'Tivat Municipality', 'ME', '19', 1),
(30, 'Budva Municipality', 'ME', '05', 1),
(31, 'Kolašin Municipality', 'ME', '09', 1),
(32, 'Žabljak Municipality', 'ME', '21', 1),
(33, 'Ulcinj Municipality', 'ME', '20', 1),
(34, 'Kunene Region', 'NA', 'KU', 1),
(35, 'Kavango West Region', 'NA', 'KW', 1),
(36, 'Kavango East Region', 'NA', 'KE', 1),
(37, 'Oshana Region', 'NA', 'ON', 1),
(38, 'Hardap Region', 'NA', 'HA', 1),
(39, 'Omusati Region', 'NA', 'OS', 1),
(40, 'Ohangwena Region', 'NA', 'OW', 1),
(41, 'Omaheke Region', 'NA', 'OH', 1),
(42, 'Oshikoto Region', 'NA', 'OT', 1),
(43, 'Erongo Region', 'NA', 'ER', 1),
(44, 'Khomas Region', 'NA', 'KH', 1),
(45, 'Karas Region', 'NA', 'KA', 1),
(46, 'Otjozondjupa Region', 'NA', 'OD', 1),
(47, 'Zambezi Region', 'NA', 'CA', 1),
(48, 'Ashanti', 'GH', 'AH', 1),
(49, 'Western', 'GH', 'WP', 1),
(50, 'Eastern', 'GH', 'EP', 1),
(51, 'Northern', 'GH', 'NP', 1),
(52, 'Central', 'GH', 'CP', 1),
(53, 'Ahafo', 'GH', 'AF', 1),
(54, 'Greater Accra', 'GH', 'AA', 1),
(55, 'Upper East', 'GH', 'UE', 1),
(56, 'Volta', 'GH', 'TV', 1),
(57, 'Upper West', 'GH', 'UW', 1),
(58, 'San Marino', 'SM', '07', 1),
(59, 'Acquaviva', 'SM', '01', 1),
(60, 'Chiesanuova', 'SM', '02', 1),
(61, 'Borgo Maggiore', 'SM', '06', 1),
(62, 'Faetano', 'SM', '04', 1),
(63, 'Montegiardino', 'SM', '08', 1),
(64, 'Domagnano', 'SM', '03', 1),
(65, 'Serravalle', 'SM', '09', 1),
(66, 'Fiorentino', 'SM', '05', 1),
(67, 'Tillabéri Region', 'NE', '6', 1),
(68, 'Dosso Region', 'NE', '3', 1),
(69, 'Zinder Region', 'NE', '7', 1),
(70, 'Maradi Region', 'NE', '4', 1),
(71, 'Agadez Region', 'NE', '1', 1),
(72, 'Diffa Region', 'NE', '2', 1),
(73, 'Tahoua Region', 'NE', '5', 1),
(74, 'Mqabba', 'MT', '33', 1),
(75, 'San Ġwann', 'MT', '49', 1),
(76, 'Żurrieq', 'MT', '68', 1),
(77, 'Luqa', 'MT', '25', 1),
(78, 'Marsaxlokk', 'MT', '28', 1),
(79, 'Qala', 'MT', '42', 1),
(80, 'Żebbuġ Malta', 'MT', '66', 1),
(81, 'Xgħajra', 'MT', '63', 1),
(82, 'Kirkop', 'MT', '23', 1),
(83, 'Rabat', 'MT', '46', 1),
(84, 'Floriana', 'MT', '09', 1),
(85, 'Żebbuġ Gozo', 'MT', '65', 1),
(86, 'Swieqi', 'MT', '57', 1),
(87, 'Saint Lawrence', 'MT', '50', 1),
(88, 'Birżebbuġa', 'MT', '05', 1),
(89, 'Mdina', 'MT', '29', 1),
(90, 'Santa Venera', 'MT', '54', 1),
(91, 'Kerċem', 'MT', '22', 1),
(92, 'Għarb', 'MT', '14', 1),
(93, 'Iklin', 'MT', '19', 1),
(94, 'Santa Luċija', 'MT', '53', 1),
(95, 'Valletta', 'MT', '60', 1),
(96, 'Msida', 'MT', '34', 1),
(97, 'Birkirkara', 'MT', '04', 1),
(98, 'Siġġiewi', 'MT', '55', 1),
(99, 'Kalkara', 'MT', '21', 1),
(100, 'St. Julian''s', 'MT', '48', 1),
(101, 'Victoria', 'MT', '45', 1),
(102, 'Mellieħa', 'MT', '30', 1),
(103, 'Tarxien', 'MT', '59', 1),
(104, 'Sliema', 'MT', '56', 1),
(105, 'Ħamrun', 'MT', '18', 1),
(106, 'Għasri', 'MT', '16', 1),
(107, 'Birgu', 'MT', '03', 1),
(108, 'Balzan', 'MT', '02', 1),
(109, 'Mġarr', 'MT', '31', 1),
(110, 'Attard', 'MT', '01', 1),
(111, 'Qrendi', 'MT', '44', 1),
(112, 'Naxxar', 'MT', '38', 1),
(113, 'Gżira', 'MT', '12', 1),
(114, 'Xagħra', 'MT', '61', 1),
(115, 'Paola', 'MT', '39', 1),
(116, 'Sannat', 'MT', '52', 1),
(117, 'Dingli', 'MT', '07', 1),
(118, 'Gudja', 'MT', '11', 1),
(119, 'Qormi', 'MT', '43', 1),
(120, 'Għargħur', 'MT', '15', 1),
(121, 'Xewkija', 'MT', '62', 1),
(122, 'Ta'' Xbiex', 'MT', '58', 1),
(123, 'Żabbar', 'MT', '64', 1),
(124, 'Għaxaq', 'MT', '17', 1),
(125, 'Pembroke', 'MT', '40', 1),
(126, 'Lija', 'MT', '24', 1),
(127, 'Pietà', 'MT', '41', 1),
(128, 'Marsa', 'MT', '26', 1),
(129, 'Fgura', 'MT', '08', 1),
(130, 'Għajnsielem', 'MT', '13', 1),
(131, 'Mtarfa', 'MT', '35', 1),
(132, 'Munxar', 'MT', '36', 1),
(133, 'Nadur', 'MT', '37', 1),
(134, 'Fontana', 'MT', '10', 1),
(135, 'Żejtun', 'MT', '67', 1),
(136, 'Senglea', 'MT', '20', 1),
(137, 'Marsaskala', 'MT', '27', 1),
(138, 'Cospicua', 'MT', '06', 1),
(139, 'St. Paul''s Bay', 'MT', '51', 1),
(140, 'Mosta', 'MT', '32', 1),
(141, 'Mangystau Region', 'KZ', 'MAN', 1),
(142, 'Kyzylorda Region', 'KZ', 'KZY', 1),
(143, 'Almaty Region', 'KZ', 'ALM', 1),
(144, 'North Kazakhstan Region', 'KZ', 'SEV', 1),
(145, 'Akmola Region', 'KZ', 'AKM', 1),
(146, 'Pavlodar Region', 'KZ', 'PAV', 1),
(147, 'Jambyl Region', 'KZ', 'ZHA', 1),
(148, 'West Kazakhstan Province', 'KZ', 'ZAP', 1),
(149, 'Turkestan Region', 'KZ', 'YUZ', 1),
(150, 'Karaganda Region', 'KZ', 'KAR', 1),
(151, 'Aktobe Region', 'KZ', 'AKT', 1),
(152, 'Almaty', 'KZ', 'ALA', 1),
(153, 'Atyrau Region', 'KZ', 'ATY', 1),
(154, 'East Kazakhstan Region', 'KZ', 'VOS', 1),
(155, 'Baikonur', 'KZ', 'BAY', 1),
(156, 'Nur-Sultan', 'KZ', 'AST', 1),
(157, 'Kostanay Region', 'KZ', 'KUS', 1),
(158, 'Kakamega', 'KE', '11', 1),
(159, 'Kisii', 'KE', '16', 1),
(161, 'Busia', 'KE', '04', 1),
(163, 'Embu', 'KE', '06', 1),
(164, 'Laikipia', 'KE', '20', 1),
(165, 'Nandi', 'KE', '32', 1),
(166, 'Lamu', 'KE', '21', 1),
(167, 'Kirinyaga', 'KE', '15', 1),
(168, 'Bungoma', 'KE', '03', 1),
(169, 'Uasin Gishu', 'KE', '44', 1),
(170, 'Isiolo', 'KE', '09', 1),
(171, 'Kisumu', 'KE', '17', 1),
(173, 'Kwale', 'KE', '19', 1),
(174, 'Kilifi', 'KE', '14', 1),
(175, 'Narok', 'KE', '33', 1),
(176, 'Taita–Taveta', 'KE', '39', 1),
(178, 'Murang''a', 'KE', '29', 1),
(180, 'Nyeri', 'KE', '36', 1),
(181, 'Baringo', 'KE', '01', 1),
(182, 'Wajir', 'KE', '46', 1),
(183, 'Trans Nzoia', 'KE', '42', 1),
(184, 'Machakos', 'KE', '22', 1),
(185, 'Tharaka-Nithi', 'KE', '41', 1),
(186, 'Siaya', 'KE', '38', 1),
(187, 'Mandera', 'KE', '24', 1),
(188, 'Makueni', 'KE', '23', 1),
(190, 'Migori', 'KE', '27', 1),
(191, 'Nairobi City', 'KE', '30', 1),
(192, 'Nyandarua', 'KE', '35', 1),
(193, 'Kericho', 'KE', '12', 1),
(194, 'Marsabit', 'KE', '25', 1),
(195, 'Homa Bay', 'KE', '08', 1),
(196, 'Garissa', 'KE', '07', 1),
(197, 'Kajiado', 'KE', '10', 1),
(198, 'Meru', 'KE', '26', 1),
(199, 'Kiambu', 'KE', '13', 1),
(200, 'Mombasa', 'KE', '28', 1),
(201, 'Elgeyo-Marakwet', 'KE', '05', 1),
(202, 'Vihiga', 'KE', '45', 1),
(203, 'Nakuru', 'KE', '31', 1),
(205, 'Tana River', 'KE', '40', 1),
(206, 'Turkana', 'KE', '43', 1),
(207, 'Samburu', 'KE', '37', 1),
(208, 'West Pokot', 'KE', '47', 1),
(209, 'Nyamira', 'KE', '34', 1),
(210, 'Bomet', 'KE', '02', 1),
(211, 'Kitui', 'KE', '18', 1),
(212, 'Bié Province', 'AO', 'BIE', 1),
(213, 'Huambo Province', 'AO', 'HUA', 1),
(214, 'Zaire Province', 'AO', 'ZAI', 1),
(215, 'Cunene Province', 'AO', 'CNN', 1),
(216, 'Cuanza Sul', 'AO', 'CUS', 1),
(217, 'Cuanza Norte Province', 'AO', 'CNO', 1),
(218, 'Benguela Province', 'AO', 'BGU', 1),
(219, 'Moxico Province', 'AO', 'MOX', 1),
(220, 'Lunda Sul Province', 'AO', 'LSU', 1),
(221, 'Bengo Province', 'AO', 'BGO', 1),
(222, 'Luanda Province', 'AO', 'LUA', 1),
(223, 'Lunda Norte Province', 'AO', 'LNO', 1),
(224, 'Uíge Province', 'AO', 'UIG', 1),
(225, 'Huíla Province', 'AO', 'HUI', 1),
(226, 'Cuando Cubango Province', 'AO', 'CCU', 1),
(227, 'Malanje Province', 'AO', 'MAL', 1),
(228, 'Cabinda Province', 'AO', 'CAB', 1),
(229, 'Gasa District', 'BT', 'GA', 1),
(230, 'Tsirang District', 'BT', '21', 1),
(231, 'Wangdue Phodrang District', 'BT', '24', 1),
(232, 'Haa District', 'BT', '13', 1),
(233, 'Zhemgang District', 'BT', '34', 1),
(234, 'Lhuntse District', 'BT', '44', 1),
(235, 'Punakha District', 'BT', '23', 1),
(236, 'Trashigang District', 'BT', '41', 1),
(237, 'Paro District', 'BT', '11', 1),
(238, 'Dagana District', 'BT', '22', 1),
(239, 'Chukha District', 'BT', '12', 1),
(240, 'Bumthang District', 'BT', '33', 1),
(241, 'Thimphu District', 'BT', '15', 1),
(242, 'Mongar District', 'BT', '42', 1),
(243, 'Samdrup Jongkhar District', 'BT', '45', 1),
(244, 'Pemagatshel District', 'BT', '43', 1),
(245, 'Trongsa District', 'BT', '32', 1),
(246, 'Samtse District', 'BT', '14', 1),
(247, 'Sarpang District', 'BT', '31', 1),
(248, 'Tombouctou Region', 'ML', '6', 1),
(249, 'Ségou Region', 'ML', '4', 1),
(250, 'Koulikoro Region', 'ML', '2', 1),
(251, 'Ménaka Region', 'ML', '9', 1),
(252, 'Kayes Region', 'ML', '1', 1),
(253, 'Bamako', 'ML', 'BKO', 1),
(254, 'Sikasso Region', 'ML', '3', 1),
(255, 'Mopti Region', 'ML', '5', 1),
(256, 'Taoudénit Region', 'ML', '10', 1),
(257, 'Kidal Region', 'ML', '8', 1),
(258, 'Gao Region', 'ML', '7', 1),
(259, 'Southern Province', 'RW', '05', 1),
(260, 'Western Province', 'RW', '04', 1),
(261, 'Eastern Province', 'RW', '02', 1),
(262, 'Kigali district', 'RW', '01', 1),
(263, 'Northern Province', 'RW', '03', 1),
(264, 'Belize District', 'BZ', 'BZ', 1),
(265, 'Stann Creek District', 'BZ', 'SC', 1),
(266, 'Corozal District', 'BZ', 'CZL', 1),
(267, 'Toledo District', 'BZ', 'TOL', 1),
(268, 'Orange Walk District', 'BZ', 'OW', 1),
(269, 'Cayo District', 'BZ', 'CY', 1),
(270, 'Príncipe Province', 'ST', 'P', 1),
(271, 'São Tomé Province', 'ST', 'S', 1),
(272, 'Havana Province', 'CU', '03', 1),
(273, 'Santiago de Cuba Province', 'CU', '13', 1),
(274, 'Sancti Spíritus Province', 'CU', '07', 1),
(275, 'Granma Province', 'CU', '12', 1),
(276, 'Mayabeque Province', 'CU', '16', 1),
(277, 'Pinar del Río Province', 'CU', '01', 1),
(278, 'Isla de la Juventud', 'CU', '99', 1),
(279, 'Holguín Province', 'CU', '11', 1),
(280, 'Villa Clara Province', 'CU', '05', 1),
(281, 'Las Tunas Province', 'CU', '10', 1),
(282, 'Ciego de Ávila Province', 'CU', '08', 1),
(283, 'Artemisa Province', 'CU', '15', 1),
(284, 'Matanzas Province', 'CU', '04', 1),
(285, 'Guantánamo Province', 'CU', '14', 1),
(286, 'Camagüey Province', 'CU', '09', 1),
(287, 'Cienfuegos Province', 'CU', '06', 1),
(288, 'Jigawa', 'NG', 'JI', 1),
(289, 'Enugu', 'NG', 'EN', 1),
(290, 'Kebbi', 'NG', 'KE', 1),
(291, 'Benue', 'NG', 'BE', 1),
(292, 'Sokoto', 'NG', 'SO', 1),
(293, 'Abuja Federal Capital Territory', 'NG', 'FC', 1),
(294, 'Kaduna', 'NG', 'KD', 1),
(295, 'Kwara', 'NG', 'KW', 1),
(296, 'Oyo', 'NG', 'OY', 1),
(297, 'Yobe', 'NG', 'YO', 1),
(298, 'Kogi', 'NG', 'KO', 1),
(299, 'Zamfara', 'NG', 'ZA', 1),
(300, 'Kano', 'NG', 'KN', 1),
(301, 'Nasarawa', 'NG', 'NA', 1),
(302, 'Plateau', 'NG', 'PL', 1),
(303, 'Abia', 'NG', 'AB', 1),
(304, 'Akwa Ibom', 'NG', 'AK', 1),
(305, 'Bayelsa', 'NG', 'BY', 1),
(306, 'Lagos', 'NG', 'LA', 1),
(307, 'Borno', 'NG', 'BO', 1),
(308, 'Imo', 'NG', 'IM', 1),
(309, 'Ekiti', 'NG', 'EK', 1),
(310, 'Gombe', 'NG', 'GO', 1),
(311, 'Ebonyi', 'NG', 'EB', 1),
(312, 'Bauchi', 'NG', 'BA', 1),
(313, 'Katsina', 'NG', 'KT', 1),
(314, 'Cross River', 'NG', 'CR', 1),
(315, 'Anambra', 'NG', 'AN', 1),
(316, 'Delta', 'NG', 'DE', 1),
(317, 'Niger', 'NG', 'NI', 1),
(318, 'Edo', 'NG', 'ED', 1),
(319, 'Taraba', 'NG', 'TA', 1),
(320, 'Adamawa', 'NG', 'AD', 1),
(321, 'Ondo', 'NG', 'ON', 1),
(322, 'Osun', 'NG', 'OS', 1),
(323, 'Ogun', 'NG', 'OG', 1),
(324, 'Rukungiri District', 'UG', '412', 1),
(325, 'Kyankwanzi District', 'UG', '123', 1),
(326, 'Kabarole District', 'UG', '405', 1),
(327, 'Mpigi District', 'UG', '106', 1),
(328, 'Apac District', 'UG', '302', 1),
(329, 'Abim District', 'UG', '314', 1),
(330, 'Yumbe District', 'UG', '313', 1),
(331, 'Rukiga District', 'UG', '431', 1),
(332, 'Northern Region', 'UG', 'N', 1),
(333, 'Serere District', 'UG', '232', 1),
(334, 'Kamuli District', 'UG', '205', 1),
(335, 'Amuru District', 'UG', '316', 1),
(336, 'Kaberamaido District', 'UG', '213', 1),
(337, 'Namutumba District', 'UG', '224', 1),
(338, 'Kibuku District', 'UG', '227', 1),
(339, 'Ibanda District', 'UG', '417', 1),
(340, 'Iganga District', 'UG', '203', 1),
(341, 'Dokolo District', 'UG', '317', 1),
(342, 'Lira District', 'UG', '307', 1),
(343, 'Bukedea District', 'UG', '219', 1),
(344, 'Alebtong District', 'UG', '323', 1),
(345, 'Koboko District', 'UG', '319', 1),
(346, 'Kiryandongo District', 'UG', '421', 1),
(347, 'Kiboga District', 'UG', '103', 1),
(348, 'Kitgum District', 'UG', '305', 1),
(349, 'Bududa District', 'UG', '218', 1),
(350, 'Mbale District', 'UG', '209', 1),
(351, 'Namayingo District', 'UG', '230', 1),
(352, 'Amuria District', 'UG', '216', 1),
(353, 'Amudat District', 'UG', '324', 1),
(354, 'Masindi District', 'UG', '409', 1),
(355, 'Kiruhura District', 'UG', '419', 1),
(356, 'Masaka District', 'UG', '105', 1),
(357, 'Pakwach District', 'UG', '332', 1),
(358, 'Rubanda District', 'UG', '429', 1),
(359, 'Tororo District', 'UG', '212', 1),
(360, 'Kamwenge District', 'UG', '413', 1),
(361, 'Adjumani District', 'UG', '301', 1),
(362, 'Wakiso District', 'UG', '113', 1),
(363, 'Moyo District', 'UG', '309', 1),
(364, 'Mityana District', 'UG', '115', 1),
(365, 'Butaleja District', 'UG', '221', 1),
(366, 'Gomba District', 'UG', '121', 1),
(367, 'Jinja District', 'UG', '204', 1),
(368, 'Kayunga District', 'UG', '112', 1),
(369, 'Kween District', 'UG', '228', 1),
(370, 'Western Region', 'UG', 'W', 1),
(371, 'Mubende District', 'UG', '107', 1),
(372, 'Eastern Region', 'UG', 'E', 1),
(373, 'Kanungu District', 'UG', '414', 1),
(374, 'Omoro District', 'UG', '331', 1),
(375, 'Bukomansimbi District', 'UG', '118', 1),
(376, 'Lyantonde District', 'UG', '114', 1),
(377, 'Buikwe District', 'UG', '117', 1),
(378, 'Nwoya District', 'UG', '328', 1),
(379, 'Zombo District', 'UG', '330', 1),
(380, 'Buyende District', 'UG', '226', 1),
(381, 'Bunyangabu District', 'UG', '430', 1),
(382, 'Kampala District', 'UG', '102', 1),
(383, 'Isingiro District', 'UG', '418', 1),
(384, 'Butambala District', 'UG', '119', 1),
(385, 'Bukwo District', 'UG', '220', 1),
(386, 'Bushenyi District', 'UG', '402', 1),
(387, 'Bugiri District', 'UG', '201', 1),
(388, 'Butebo District', 'UG', '233', 1),
(389, 'Buliisa District', 'UG', '416', 1),
(390, 'Otuke District', 'UG', '329', 1),
(391, 'Buhweju District', 'UG', '420', 1),
(392, 'Agago District', 'UG', '322', 1),
(393, 'Nakapiripirit District', 'UG', '311', 1),
(394, 'Kalungu District', 'UG', '122', 1),
(395, 'Moroto District', 'UG', '308', 1),
(396, 'Central Region', 'UG', 'C', 1),
(397, 'Oyam District', 'UG', '321', 1),
(398, 'Kaliro District', 'UG', '222', 1),
(399, 'Kakumiro District', 'UG', '428', 1),
(400, 'Namisindwa District', 'UG', '234', 1),
(401, 'Kole District', 'UG', '325', 1),
(402, 'Kyenjojo District', 'UG', '415', 1),
(403, 'Kagadi District', 'UG', '427', 1),
(404, 'Ntungamo District', 'UG', '411', 1),
(405, 'Kalangala District', 'UG', '101', 1),
(406, 'Nakasongola District', 'UG', '109', 1),
(407, 'Sheema District', 'UG', '426', 1),
(408, 'Pader District', 'UG', '312', 1),
(409, 'Kisoro District', 'UG', '408', 1),
(410, 'Mukono District', 'UG', '108', 1),
(411, 'Lamwo District', 'UG', '326', 1),
(412, 'Pallisa District', 'UG', '210', 1),
(413, 'Gulu District', 'UG', '304', 1),
(414, 'Buvuma District', 'UG', '120', 1),
(415, 'Mbarara District', 'UG', '410', 1),
(416, 'Amolatar District', 'UG', '315', 1),
(417, 'Lwengo District', 'UG', '124', 1),
(418, 'Mayuge District', 'UG', '214', 1),
(419, 'Bundibugyo District', 'UG', '401', 1),
(420, 'Katakwi District', 'UG', '207', 1),
(421, 'Maracha District', 'UG', '320', 1),
(422, 'Ntoroko District', 'UG', '424', 1),
(423, 'Nakaseke District', 'UG', '116', 1),
(424, 'Ngora District', 'UG', '231', 1),
(425, 'Kumi District', 'UG', '208', 1),
(426, 'Kabale District', 'UG', '404', 1),
(427, 'Sembabule District', 'UG', '111', 1),
(428, 'Bulambuli District', 'UG', '225', 1),
(429, 'Sironko District', 'UG', '215', 1),
(430, 'Napak District', 'UG', '327', 1),
(431, 'Busia District', 'UG', '202', 1),
(432, 'Kapchorwa District', 'UG', '206', 1),
(433, 'Luwero District', 'UG', '104', 1),
(434, 'Kaabong District', 'UG', '318', 1),
(435, 'Mitooma District', 'UG', '423', 1),
(436, 'Kibaale District', 'UG', '407', 1),
(437, 'Kyegegwa District', 'UG', '422', 1),
(438, 'Manafwa District', 'UG', '223', 1),
(439, 'Rakai District', 'UG', '110', 1),
(440, 'Kasese District', 'UG', '406', 1),
(441, 'Budaka District', 'UG', '217', 1),
(442, 'Rubirizi District', 'UG', '425', 1),
(443, 'Kotido District', 'UG', '306', 1),
(444, 'Soroti District', 'UG', '211', 1),
(445, 'Luuka District', 'UG', '229', 1),
(446, 'Nebbi District', 'UG', '310', 1),
(447, 'Arua District', 'UG', '303', 1),
(448, 'Kyotera District', 'UG', '125', 1),
(449, 'Schellenberg', 'LI', '08', 1),
(450, 'Schaan', 'LI', '07', 1),
(451, 'Eschen', 'LI', '02', 1),
(452, 'Vaduz', 'LI', '11', 1),
(453, 'Ruggell', 'LI', '06', 1),
(454, 'Planken', 'LI', '05', 1),
(455, 'Mauren', 'LI', '04', 1),
(456, 'Triesenberg', 'LI', '10', 1),
(457, 'Gamprin', 'LI', '03', 1),
(458, 'Balzers', 'LI', '01', 1),
(459, 'Triesen', 'LI', '09', 1),
(460, 'Brčko District', 'BA', 'BRC', 1),
(461, 'Tuzla Canton', 'BA', '03', 1),
(462, 'Central Bosnia Canton', 'BA', '06', 1),
(463, 'Herzegovina-Neretva Canton', 'BA', '07', 1),
(464, 'Posavina Canton', 'BA', '02', 1),
(465, 'Una-Sana Canton', 'BA', '01', 1),
(466, 'Sarajevo Canton', 'BA', '09', 1),
(467, 'Federation of Bosnia and Herzegovina', 'BA', 'BIH', 1),
(468, 'Zenica-Doboj Canton', 'BA', '04', 1),
(469, 'West Herzegovina Canton', 'BA', '08', 1),
(470, 'Republika Srpska', 'BA', 'SRP', 1),
(471, 'Canton 10', 'BA', '10', 1),
(472, 'Bosnian Podrinje Canton', 'BA', '05', 1),
(473, 'Dakar', 'SN', 'DK', 1),
(474, 'Kolda', 'SN', 'KD', 1),
(475, 'Kaffrine', 'SN', 'KA', 1),
(476, 'Matam', 'SN', 'MT', 1),
(477, 'Saint-Louis', 'SN', 'SL', 1),
(478, 'Ziguinchor', 'SN', 'ZG', 1),
(479, 'Fatick', 'SN', 'FK', 1),
(480, 'Diourbel Region', 'SN', 'DB', 1),
(481, 'Kédougou', 'SN', 'KE', 1),
(482, 'Sédhiou', 'SN', 'SE', 1),
(483, 'Kaolack', 'SN', 'KL', 1),
(484, 'Thiès Region', 'SN', 'TH', 1),
(485, 'Louga', 'SN', 'LG', 1),
(486, 'Tambacounda Region', 'SN', 'TC', 1),
(487, 'Encamp', 'AD', '03', 1),
(488, 'Andorra la Vella', 'AD', '07', 1),
(489, 'Canillo', 'AD', '02', 1),
(490, 'Sant Julià de Lòria', 'AD', '06', 1),
(491, 'Ordino', 'AD', '05', 1),
(492, 'Escaldes-Engordany', 'AD', '08', 1),
(493, 'La Massana', 'AD', '04', 1),
(494, 'Mont Buxton', 'SC', '17', 1),
(495, 'La Digue', 'SC', '15', 1),
(496, 'Saint Louis', 'SC', '22', 1),
(497, 'Baie Lazare', 'SC', '06', 1),
(498, 'Mont Fleuri', 'SC', '18', 1),
(499, 'Les Mamelles', 'SC', '24', 1),
(500, 'Grand''Anse Mahé', 'SC', '13', 1),
(501, 'Roche Caiman', 'SC', '25', 1),
(502, 'Anse Royale', 'SC', '05', 1),
(503, 'Glacis', 'SC', '12', 1),
(504, 'Grand''Anse Praslin', 'SC', '14', 1),
(505, 'Bel Ombre', 'SC', '10', 1),
(506, 'Anse-aux-Pins', 'SC', '01', 1),
(507, 'Port Glaud', 'SC', '21', 1),
(508, 'Au Cap', 'SC', '04', 1),
(509, 'Takamaka', 'SC', '23', 1),
(510, 'Pointe La Rue', 'SC', '20', 1),
(511, 'Plaisance', 'SC', '19', 1),
(512, 'Beau Vallon', 'SC', '08', 1),
(513, 'Anse Boileau', 'SC', '02', 1),
(514, 'Baie Sainte Anne', 'SC', '07', 1),
(515, 'Bel Air', 'SC', '09', 1),
(516, 'La Rivière Anglaise', 'SC', '16', 1),
(517, 'Cascade', 'SC', '11', 1),
(518, 'Shaki', 'AZ', 'SA', 1),
(519, 'Tartar District', 'AZ', 'TAR', 1),
(520, 'Shirvan', 'AZ', 'SR', 1),
(521, 'Qazakh District', 'AZ', 'QAZ', 1),
(522, 'Sadarak District', 'AZ', 'SAD', 1),
(523, 'Yevlakh District', 'AZ', 'YEV', 1),
(524, 'Khojali District', 'AZ', 'XCI', 1),
(525, 'Kalbajar District', 'AZ', 'KAL', 1),
(526, 'Qakh District', 'AZ', 'QAX', 1),
(527, 'Fizuli District', 'AZ', 'FUZ', 1),
(528, 'Astara District', 'AZ', 'AST', 1),
(529, 'Shamakhi District', 'AZ', 'SMI', 1),
(530, 'Neftchala District', 'AZ', 'NEF', 1),
(531, 'Goychay', 'AZ', 'GOY', 1),
(532, 'Bilasuvar District', 'AZ', 'BIL', 1),
(533, 'Tovuz District', 'AZ', 'TOV', 1),
(534, 'Ordubad District', 'AZ', 'ORD', 1),
(535, 'Sharur District', 'AZ', 'SAR', 1),
(536, 'Samukh District', 'AZ', 'SMX', 1),
(537, 'Khizi District', 'AZ', 'XIZ', 1),
(538, 'Yevlakh', 'AZ', 'YE', 1),
(539, 'Ujar District', 'AZ', 'UCA', 1),
(540, 'Absheron District', 'AZ', 'ABS', 1),
(541, 'Lachin District', 'AZ', 'LAC', 1),
(542, 'Qabala District', 'AZ', 'QAB', 1),
(543, 'Agstafa District', 'AZ', 'AGA', 1),
(544, 'Imishli District', 'AZ', 'IMI', 1),
(545, 'Salyan District', 'AZ', 'SAL', 1),
(546, 'Lerik District', 'AZ', 'LER', 1),
(547, 'Agsu District', 'AZ', 'AGU', 1),
(548, 'Qubadli District', 'AZ', 'QBI', 1),
(549, 'Kurdamir District', 'AZ', 'KUR', 1),
(550, 'Yardymli District', 'AZ', 'YAR', 1),
(551, 'Goranboy District', 'AZ', 'GOR', 1),
(552, 'Baku', 'AZ', 'BA', 1),
(553, 'Agdash District', 'AZ', 'AGS', 1),
(554, 'Beylagan District', 'AZ', 'BEY', 1),
(555, 'Masally District', 'AZ', 'MAS', 1),
(556, 'Oghuz District', 'AZ', 'OGU', 1),
(557, 'Saatly District', 'AZ', 'SAT', 1),
(558, 'Lankaran District', 'AZ', 'LA', 1),
(559, 'Agdam District', 'AZ', 'AGM', 1),
(560, 'Balakan District', 'AZ', 'BAL', 1),
(561, 'Dashkasan District', 'AZ', 'DAS', 1),
(562, 'Nakhchivan Autonomous Republic', 'AZ', 'NX', 1),
(563, 'Quba District', 'AZ', 'QBA', 1),
(564, 'Ismailli District', 'AZ', 'ISM', 1),
(565, 'Sabirabad District', 'AZ', 'SAB', 1),
(566, 'Zaqatala District', 'AZ', 'ZAQ', 1),
(567, 'Kangarli District', 'AZ', 'KAN', 1),
(568, 'Martuni', 'AZ', 'XVD', 1),
(569, 'Barda District', 'AZ', 'BAR', 1),
(570, 'Jabrayil District', 'AZ', 'CAB', 1),
(571, 'Hajigabul District', 'AZ', 'HAC', 1),
(572, 'Julfa District', 'AZ', 'CUL', 1),
(573, 'Gobustan District', 'AZ', 'QOB', 1),
(574, 'Goygol District', 'AZ', 'GYG', 1),
(575, 'Babek District', 'AZ', 'BAB', 1),
(576, 'Zardab District', 'AZ', 'ZAR', 1),
(577, 'Aghjabadi District', 'AZ', 'AGC', 1),
(578, 'Jalilabad District', 'AZ', 'CAL', 1),
(579, 'Shahbuz District', 'AZ', 'SAH', 1),
(580, 'Mingachevir', 'AZ', 'MI', 1),
(581, 'Zangilan District', 'AZ', 'ZAN', 1),
(582, 'Sumqayit', 'AZ', 'SM', 1),
(583, 'Shamkir District', 'AZ', 'SKR', 1),
(584, 'Siazan District', 'AZ', 'SIY', 1),
(585, 'Ganja', 'AZ', 'GA', 1),
(586, 'Shaki District', 'AZ', 'SAK', 1),
(587, 'Lankaran', 'AZ', 'LAN', 1),
(588, 'Qusar District', 'AZ', 'QUS', 1),
(589, 'Gədəbəy', 'AZ', 'GAD', 1),
(590, 'Khachmaz District', 'AZ', 'XAC', 1),
(591, 'Shabran District', 'AZ', 'SBN', 1),
(592, 'Shusha District', 'AZ', 'SUS', 1),
(593, 'Skrapar District', 'AL', 'SK', 1),
(594, 'Kavajë District', 'AL', 'KA', 1),
(595, 'Lezhë District', 'AL', 'LE', 1),
(596, 'Librazhd District', 'AL', 'LB', 1),
(597, 'Korçë District', 'AL', 'KO', 1),
(598, 'Elbasan County', 'AL', '03', 1),
(599, 'Lushnjë District', 'AL', 'LU', 1),
(600, 'Has District', 'AL', 'HA', 1),
(601, 'Kukës County', 'AL', '07', 1),
(602, 'Malësi e Madhe District', 'AL', 'MM', 1),
(603, 'Berat County', 'AL', '01', 1),
(604, 'Gjirokastër County', 'AL', '05', 1),
(605, 'Dibër District', 'AL', 'DI', 1),
(606, 'Pogradec District', 'AL', 'PG', 1),
(607, 'Bulqizë District', 'AL', 'BU', 1),
(608, 'Devoll District', 'AL', 'DV', 1),
(609, 'Lezhë County', 'AL', '08', 1),
(610, 'Dibër County', 'AL', '09', 1),
(611, 'Shkodër County', 'AL', '10', 1),
(612, 'Kuçovë District', 'AL', 'KC', 1),
(613, 'Vlorë District', 'AL', 'VL', 1),
(614, 'Krujë District', 'AL', 'KR', 1),
(615, 'Tirana County', 'AL', '11', 1),
(616, 'Tepelenë District', 'AL', 'TE', 1),
(617, 'Gramsh District', 'AL', 'GR', 1),
(618, 'Delvinë District', 'AL', 'DL', 1),
(619, 'Peqin District', 'AL', 'PQ', 1),
(620, 'Pukë District', 'AL', 'PU', 1),
(621, 'Gjirokastër District', 'AL', 'GJ', 1),
(622, 'Kurbin District', 'AL', 'KB', 1),
(623, 'Kukës District', 'AL', 'KU', 1),
(624, 'Sarandë District', 'AL', 'SR', 1),
(625, 'Përmet District', 'AL', 'PR', 1),
(626, 'Shkodër District', 'AL', 'SH', 1),
(627, 'Fier District', 'AL', 'FR', 1),
(628, 'Kolonjë District', 'AL', 'ER', 1),
(629, 'Berat District', 'AL', 'BR', 1),
(630, 'Korçë County', 'AL', '06', 1),
(631, 'Fier County', 'AL', '04', 1),
(632, 'Durrës County', 'AL', '02', 1),
(633, 'Tirana District', 'AL', 'TR', 1),
(634, 'Vlorë County', 'AL', '12', 1),
(635, 'Mat District', 'AL', 'MT', 1),
(636, 'Tropojë District', 'AL', 'TP', 1),
(637, 'Mallakastër District', 'AL', 'MK', 1),
(638, 'Mirditë District', 'AL', 'MR', 1),
(639, 'Durrës District', 'AL', 'DR', 1),
(640, 'Sveti Nikole Municipality', 'MK', '69', 1),
(641, 'Kratovo Municipality', 'MK', '43', 1),
(642, 'Zajas Municipality', 'MK', '31', 1),
(643, 'Staro Nagoričane Municipality', 'MK', '71', 1),
(644, 'Češinovo-Obleševo Municipality', 'MK', '81', 1),
(645, 'Debarca Municipality', 'MK', '22', 1),
(646, 'Probištip Municipality', 'MK', '63', 1),
(647, 'Krivogaštani Municipality', 'MK', '45', 1),
(648, 'Gevgelija Municipality', 'MK', '18', 1),
(649, 'Bogdanci Municipality', 'MK', '05', 1),
(650, 'Vraneštica Municipality', 'MK', '15', 1),
(651, 'Veles Municipality', 'MK', '13', 1),
(652, 'Bosilovo Municipality', 'MK', '07', 1),
(653, 'Mogila Municipality', 'MK', '53', 1),
(654, 'Tearce Municipality', 'MK', '75', 1),
(655, 'Demir Kapija Municipality', 'MK', '24', 1),
(656, 'Aračinovo Municipality', 'MK', '02', 1),
(657, 'Drugovo Municipality', 'MK', '28', 1),
(658, 'Vasilevo Municipality', 'MK', '11', 1),
(659, 'Lipkovo Municipality', 'MK', '48', 1),
(660, 'Brvenica Municipality', 'MK', '08', 1),
(661, 'Štip Municipality', 'MK', '83', 1),
(662, 'Vevčani Municipality', 'MK', '12', 1),
(663, 'Tetovo Municipality', 'MK', '76', 1),
(664, 'Negotino Municipality', 'MK', '54', 1),
(665, 'Konče Municipality', 'MK', '41', 1),
(666, 'Prilep Municipality', 'MK', '62', 1),
(667, 'Saraj Municipality', 'MK', '68', 1),
(668, 'Želino Municipality', 'MK', '30', 1),
(669, 'Mavrovo and Rostuša Municipality', 'MK', '50', 1),
(670, 'Plasnica Municipality', 'MK', '61', 1),
(671, 'Valandovo Municipality', 'MK', '10', 1),
(672, 'Vinica Municipality', 'MK', '14', 1),
(673, 'Zrnovci Municipality', 'MK', '33', 1),
(674, 'Karbinci', 'MK', '37', 1),
(675, 'Dolneni Municipality', 'MK', '27', 1),
(676, 'Čaška Municipality', 'MK', '80', 1),
(677, 'Kriva Palanka Municipality', 'MK', '44', 1),
(678, 'Jegunovce Municipality', 'MK', '35', 1),
(679, 'Bitola Municipality', 'MK', '04', 1),
(680, 'Šuto Orizari Municipality', 'MK', '84', 1),
(681, 'Karpoš Municipality', 'MK', '38', 1),
(682, 'Oslomej Municipality', 'MK', '57', 1),
(683, 'Kumanovo Municipality', 'MK', '47', 1),
(684, 'Greater Skopje', 'MK', '85', 1),
(685, 'Pehčevo Municipality', 'MK', '60', 1),
(686, 'Kisela Voda Municipality', 'MK', '39', 1),
(687, 'Demir Hisar Municipality', 'MK', '25', 1),
(688, 'Kičevo Municipality', 'MK', '40', 1),
(689, 'Vrapčište Municipality', 'MK', '16', 1),
(690, 'Ilinden Municipality', 'MK', '34', 1),
(691, 'Rosoman Municipality', 'MK', '67', 1),
(692, 'Makedonski Brod Municipality', 'MK', '52', 1),
(693, 'Gostivar Municipality', 'MK', '19', 1),
(694, 'Butel Municipality', 'MK', '09', 1),
(695, 'Delčevo Municipality', 'MK', '23', 1),
(696, 'Novaci Municipality', 'MK', '55', 1),
(697, 'Dojran Municipality', 'MK', '26', 1),
(698, 'Petrovec Municipality', 'MK', '59', 1),
(699, 'Ohrid Municipality', 'MK', '58', 1),
(700, 'Struga Municipality', 'MK', '72', 1),
(701, 'Makedonska Kamenica Municipality', 'MK', '51', 1),
(702, 'Centar Municipality', 'MK', '77', 1),
(703, 'Aerodrom Municipality', 'MK', '01', 1),
(704, 'Čair Municipality', 'MK', '79', 1),
(705, 'Lozovo Municipality', 'MK', '49', 1),
(706, 'Zelenikovo Municipality', 'MK', '32', 1),
(707, 'Gazi Baba Municipality', 'MK', '17', 1),
(708, 'Gradsko Municipality', 'MK', '20', 1),
(709, 'Radoviš Municipality', 'MK', '64', 1),
(710, 'Strumica Municipality', 'MK', '73', 1),
(711, 'Studeničani Municipality', 'MK', '74', 1),
(712, 'Resen Municipality', 'MK', '66', 1),
(713, 'Kavadarci Municipality', 'MK', '36', 1),
(714, 'Kruševo Municipality', 'MK', '46', 1),
(715, 'Čučer-Sandevo Municipality', 'MK', '82', 1),
(716, 'Berovo Municipality', 'MK', '03', 1),
(717, 'Rankovce Municipality', 'MK', '65', 1),
(718, 'Novo Selo Municipality', 'MK', '56', 1),
(719, 'Sopište Municipality', 'MK', '70', 1),
(720, 'Centar Župa Municipality', 'MK', '78', 1),
(721, 'Bogovinje Municipality', 'MK', '06', 1),
(722, 'Gjorče Petrov Municipality', 'MK', '29', 1),
(723, 'Kočani Municipality', 'MK', '42', 1),
(724, 'Požega-Slavonia', 'HR', '11', 1),
(725, 'Split-Dalmatia', 'HR', '17', 1),
(726, 'Međimurje', 'HR', '20', 1),
(727, 'Zadar', 'HR', '13', 1),
(728, 'Dubrovnik-Neretva', 'HR', '19', 1),
(729, 'Krapina-Zagorje', 'HR', '02', 1),
(730, 'Šibenik-Knin', 'HR', '15', 1),
(731, 'Lika-Senj', 'HR', '09', 1),
(732, 'Virovitica-Podravina', 'HR', '10', 1),
(733, 'Sisak-Moslavina', 'HR', '03', 1),
(734, 'Bjelovar-Bilogora', 'HR', '07', 1),
(735, 'Primorje-Gorski Kotar', 'HR', '08', 1),
(736, 'Zagreb', 'HR', '01', 1),
(737, 'Brod-Posavina', 'HR', '12', 1),
(738, 'Zagreb', 'HR', '21', 1),
(739, 'Varaždin', 'HR', '05', 1),
(740, 'Osijek-Baranja', 'HR', '14', 1),
(741, 'Vukovar-Syrmia', 'HR', '16', 1),
(742, 'Koprivnica-Križevci', 'HR', '06', 1),
(743, 'Istria', 'HR', '18', 1),
(744, 'Kyrenia District (Keryneia)', 'CY', '06', 1),
(745, 'Nicosia District (Lefkoşa)', 'CY', '01', 1),
(746, 'Paphos District (Pafos)', 'CY', '05', 1),
(747, 'Larnaca District (Larnaka)', 'CY', '03', 1),
(748, 'Limassol District (Leymasun)', 'CY', '02', 1),
(749, 'Famagusta District (Mağusa)', 'CY', '04', 1),
(750, 'Rangpur Division', 'BD', 'F', 1),
(751, 'Cox''s Bazar District', 'BD', '11', 1),
(752, 'Bandarban District', 'BD', '01', 1),
(753, 'Rajshahi Division', 'BD', 'E', 1),
(754, 'Pabna District', 'BD', '49', 1),
(755, 'Sherpur District', 'BD', '57', 1),
(756, 'Bhola District', 'BD', '07', 1),
(757, 'Jessore District', 'BD', '22', 1),
(758, 'Mymensingh Division', 'BD', 'H', 1),
(759, 'Rangpur District', 'BD', '55', 1),
(760, 'Dhaka Division', 'BD', 'C', 1),
(761, 'Chapai Nawabganj District', 'BD', '45', 1),
(762, 'Faridpur District', 'BD', '15', 1),
(763, 'Comilla District', 'BD', '08', 1),
(764, 'Netrokona District', 'BD', '41', 1),
(765, 'Sylhet Division', 'BD', 'G', 1),
(766, 'Mymensingh District', 'BD', '34', 1),
(767, 'Sylhet District', 'BD', '60', 1),
(768, 'Chandpur District', 'BD', '09', 1),
(769, 'Narail District', 'BD', '43', 1),
(770, 'Narayanganj District', 'BD', '40', 1),
(771, 'Dhaka District', 'BD', '13', 1),
(772, 'Nilphamari District', 'BD', '46', 1),
(773, 'Rajbari District', 'BD', '53', 1),
(774, 'Kushtia District', 'BD', '30', 1),
(775, 'Khulna Division', 'BD', 'D', 1),
(776, 'Meherpur District', 'BD', '39', 1),
(777, 'Patuakhali District', 'BD', '51', 1),
(778, 'Jhalokati District', 'BD', '25', 1),
(779, 'Kishoreganj District', 'BD', '26', 1),
(780, 'Lalmonirhat District', 'BD', '32', 1),
(781, 'Sirajganj District', 'BD', '59', 1),
(782, 'Tangail District', 'BD', '63', 1),
(783, 'Dinajpur District', 'BD', '14', 1),
(784, 'Barguna District', 'BD', '02', 1),
(785, 'Chittagong District', 'BD', '10', 1),
(786, 'Khagrachari District', 'BD', '29', 1),
(787, 'Natore District', 'BD', '44', 1),
(788, 'Chuadanga District', 'BD', '12', 1),
(789, 'Jhenaidah District', 'BD', '23', 1),
(790, 'Munshiganj District', 'BD', '35', 1),
(791, 'Pirojpur District', 'BD', '50', 1),
(792, 'Gopalganj District', 'BD', '17', 1),
(793, 'Kurigram District', 'BD', '28', 1),
(794, 'Moulvibazar District', 'BD', '38', 1),
(795, 'Gaibandha District', 'BD', '19', 1),
(796, 'Bagerhat District', 'BD', '05', 1),
(797, 'Bogra District', 'BD', '03', 1),
(798, 'Gazipur District', 'BD', '18', 1),
(799, 'Satkhira District', 'BD', '58', 1),
(800, 'Panchagarh District', 'BD', '52', 1),
(801, 'Shariatpur District', 'BD', '62', 1),
(802, 'Bahadia', 'BD', '33', 1),
(803, 'Chittagong Division', 'BD', 'B', 1),
(804, 'Thakurgaon District', 'BD', '64', 1),
(805, 'Habiganj District', 'BD', '20', 1),
(806, 'Joypurhat District', 'BD', '24', 1),
(807, 'Barisal Division', 'BD', 'A', 1),
(808, 'Jamalpur District', 'BD', '21', 1),
(809, 'Rangamati Hill District', 'BD', '56', 1),
(810, 'Brahmanbaria District', 'BD', '04', 1),
(811, 'Khulna District', 'BD', '27', 1),
(812, 'Sunamganj District', 'BD', '61', 1),
(813, 'Rajshahi District', 'BD', '54', 1),
(814, 'Naogaon District', 'BD', '48', 1),
(815, 'Noakhali District', 'BD', '47', 1),
(816, 'Feni District', 'BD', '16', 1),
(817, 'Madaripur District', 'BD', '36', 1),
(818, 'Barisal District', 'BD', '06', 1),
(819, 'Lakshmipur District', 'BD', '31', 1),
(820, 'Okayama Prefecture', 'JP', '33', 1),
(821, 'Chiba Prefecture', 'JP', '12', 1),
(822, 'Ōita Prefecture', 'JP', '44', 1),
(823, 'Tokyo', 'JP', '13', 1),
(824, 'Nara Prefecture', 'JP', '29', 1),
(825, 'Shizuoka Prefecture', 'JP', '22', 1),
(826, 'Shimane Prefecture', 'JP', '32', 1),
(827, 'Aichi Prefecture', 'JP', '23', 1),
(828, 'Hiroshima Prefecture', 'JP', '34', 1),
(829, 'Akita Prefecture', 'JP', '05', 1),
(830, 'Ishikawa Prefecture', 'JP', '17', 1),
(831, 'Hyōgo Prefecture', 'JP', '28', 1),
(832, 'Hokkaidō Prefecture', 'JP', '01', 1),
(833, 'Mie Prefecture', 'JP', '24', 1),
(834, 'Kyōto Prefecture', 'JP', '26', 1),
(835, 'Yamaguchi Prefecture', 'JP', '35', 1),
(836, 'Tokushima Prefecture', 'JP', '36', 1),
(837, 'Yamagata Prefecture', 'JP', '06', 1),
(838, 'Toyama Prefecture', 'JP', '16', 1),
(839, 'Aomori Prefecture', 'JP', '02', 1),
(840, 'Kagoshima Prefecture', 'JP', '46', 1),
(841, 'Niigata Prefecture', 'JP', '15', 1),
(842, 'Kanagawa Prefecture', 'JP', '14', 1),
(843, 'Nagano Prefecture', 'JP', '20', 1),
(844, 'Wakayama Prefecture', 'JP', '30', 1),
(845, 'Shiga Prefecture', 'JP', '25', 1),
(846, 'Kumamoto Prefecture', 'JP', '43', 1),
(847, 'Fukushima Prefecture', 'JP', '07', 1),
(848, 'Fukui Prefecture', 'JP', '18', 1),
(849, 'Nagasaki Prefecture', 'JP', '42', 1),
(850, 'Tottori Prefecture', 'JP', '31', 1),
(851, 'Ibaraki Prefecture', 'JP', '08', 1),
(852, 'Yamanashi Prefecture', 'JP', '19', 1),
(853, 'Okinawa Prefecture', 'JP', '47', 1),
(854, 'Tochigi Prefecture', 'JP', '09', 1),
(855, 'Miyazaki Prefecture', 'JP', '45', 1),
(856, 'Iwate Prefecture', 'JP', '03', 1),
(857, 'Miyagi Prefecture', 'JP', '04', 1),
(858, 'Gifu Prefecture', 'JP', '21', 1),
(859, 'Ōsaka Prefecture', 'JP', '27', 1),
(860, 'Saitama Prefecture', 'JP', '11', 1),
(861, 'Fukuoka Prefecture', 'JP', '40', 1),
(862, 'Gunma Prefecture', 'JP', '10', 1),
(863, 'Saga Prefecture', 'JP', '41', 1),
(864, 'Kagawa Prefecture', 'JP', '37', 1),
(865, 'Ehime Prefecture', 'JP', '38', 1),
(866, 'Ontario', 'CA', 'ON', 1),
(867, 'Manitoba', 'CA', 'MB', 1),
(868, 'New Brunswick', 'CA', 'NB', 1),
(869, 'Yukon', 'CA', 'YT', 1),
(870, 'Saskatchewan', 'CA', 'SK', 1),
(871, 'Prince Edward Island', 'CA', 'PE', 1),
(872, 'Alberta', 'CA', 'AB', 1),
(873, 'Quebec', 'CA', 'QC', 1),
(874, 'Nova Scotia', 'CA', 'NS', 1),
(875, 'British Columbia', 'CA', 'BC', 1),
(876, 'Nunavut', 'CA', 'NU', 1),
(877, 'Newfoundland and Labrador', 'CA', 'NL', 1),
(878, 'Northwest Territories', 'CA', 'NT', 1),
(879, 'White Nile', 'SD', 'NW', 1),
(880, 'Red Sea', 'SD', 'RS', 1),
(881, 'Khartoum', 'SD', 'KH', 1),
(882, 'Sennar', 'SD', 'SI', 1),
(883, 'South Kordofan', 'SD', 'KS', 1),
(884, 'Kassala', 'SD', 'KA', 1),
(885, 'Al Jazirah', 'SD', 'GZ', 1),
(886, 'Al Qadarif', 'SD', 'GD', 1),
(887, 'Blue Nile', 'SD', 'NB', 1),
(888, 'West Darfur', 'SD', 'DW', 1),
(889, 'West Kordofan', 'SD', 'GK', 1),
(890, 'North Darfur', 'SD', 'DN', 1),
(891, 'River Nile', 'SD', 'NR', 1),
(892, 'East Darfur', 'SD', 'DE', 1),
(893, 'North Kordofan', 'SD', 'KN', 1),
(894, 'South Darfur', 'SD', 'DS', 1),
(895, 'Northern', 'SD', 'NO', 1),
(896, 'Central Darfur', 'SD', 'DC', 1),
(897, 'Khelvachauri Municipality', 'GE', '29', 1),
(898, 'Senaki Municipality', 'GE', '50', 1),
(899, 'Tbilisi', 'GE', 'TB', 1),
(900, 'Adjara', 'GE', 'AJ', 1),
(901, 'Autonomous Republic of Abkhazia', 'GE', 'AB', 1),
(902, 'Mtskheta-Mtianeti', 'GE', 'MM', 1),
(903, 'Shida Kartli', 'GE', 'SK', 1),
(904, 'Kvemo Kartli', 'GE', 'KK', 1),
(905, 'Imereti', 'GE', 'IM', 1),
(906, 'Samtskhe-Javakheti', 'GE', 'SJ', 1),
(907, 'Guria', 'GE', 'GU', 1),
(908, 'Samegrelo-Zemo Svaneti', 'GE', 'SZ', 1),
(909, 'Racha-Lechkhumi and Kvemo Svaneti', 'GE', 'RL', 1),
(910, 'Kakheti', 'GE', 'KA', 1),
(911, 'Northern Province', 'SL', 'N', 1),
(912, 'Southern Province', 'SL', 'S', 1),
(913, 'Western Area', 'SL', 'W', 1),
(914, 'Eastern Province', 'SL', 'E', 1),
(915, 'Hiran', 'SO', 'HI', 1),
(916, 'Mudug', 'SO', 'MU', 1),
(917, 'Bakool', 'SO', 'BK', 1),
(918, 'Galguduud', 'SO', 'GA', 1),
(919, 'Sanaag Region', 'SO', 'SA', 1),
(920, 'Nugal', 'SO', 'NU', 1),
(921, 'Lower Shebelle', 'SO', 'SH', 1),
(922, 'Middle Juba', 'SO', 'JD', 1),
(923, 'Middle Shebelle', 'SO', 'SD', 1),
(924, 'Lower Juba', 'SO', 'JH', 1),
(925, 'Awdal Region', 'SO', 'AW', 1),
(926, 'Bay', 'SO', 'BY', 1),
(927, 'Banaadir', 'SO', 'BN', 1),
(928, 'Gedo', 'SO', 'GE', 1),
(929, 'Togdheer Region', 'SO', 'TO', 1),
(930, 'Bari', 'SO', 'BR', 1),
(931, 'Northern Cape', 'ZA', 'NC', 1),
(932, 'Free State', 'ZA', 'FS', 1),
(933, 'Limpopo', 'ZA', 'LP', 1),
(934, 'North West', 'ZA', 'NW', 1),
(935, 'KwaZulu-Natal', 'ZA', 'KZN', 1),
(936, 'Gauteng', 'ZA', 'GP', 1),
(937, 'Mpumalanga', 'ZA', 'MP', 1),
(938, 'Eastern Cape', 'ZA', 'EC', 1),
(939, 'Western Cape', 'ZA', 'WC', 1),
(940, 'Chontales', 'NI', 'CO', 1),
(941, 'Managua', 'NI', 'MN', 1),
(942, 'Rivas', 'NI', 'RI', 1),
(943, 'Granada', 'NI', 'GR', 1),
(944, 'León', 'NI', 'LE', 1),
(945, 'Estelí', 'NI', 'ES', 1),
(946, 'Boaco', 'NI', 'BO', 1),
(947, 'Matagalpa', 'NI', 'MT', 1),
(948, 'Madriz', 'NI', 'MD', 1),
(949, 'Río San Juan', 'NI', 'SJ', 1),
(950, 'Carazo', 'NI', 'CA', 1),
(951, 'North Caribbean Coast', 'NI', 'AN', 1),
(952, 'South Caribbean Coast', 'NI', 'AS', 1),
(953, 'Masaya', 'NI', 'MS', 1),
(954, 'Chinandega', 'NI', 'CI', 1),
(955, 'Jinotega', 'NI', 'JI', 1),
(956, 'Karak', 'JO', 'KA', 1),
(957, 'Tafilah', 'JO', 'AT', 1),
(958, 'Madaba', 'JO', 'MD', 1),
(959, 'Aqaba', 'JO', 'AQ', 1),
(960, 'Irbid', 'JO', 'IR', 1),
(961, 'Balqa', 'JO', 'BA', 1),
(962, 'Mafraq', 'JO', 'MA', 1),
(963, 'Ajloun', 'JO', 'AJ', 1),
(964, 'Ma''an', 'JO', 'MN', 1),
(965, 'Amman', 'JO', 'AM', 1),
(966, 'Jerash', 'JO', 'JA', 1),
(967, 'Zarqa', 'JO', 'AZ', 1),
(968, 'Manzini District', 'SZ', 'MA', 1),
(969, 'Hhohho District', 'SZ', 'HH', 1),
(970, 'Lubombo District', 'SZ', 'LU', 1),
(971, 'Shiselweni District', 'SZ', 'SH', 1),
(972, 'Al Jahra', 'KW', 'JA', 1),
(973, 'Hawalli', 'KW', 'HA', 1),
(974, 'Mubarak Al-Kabeer', 'KW', 'MU', 1),
(975, 'Al Farwaniyah', 'KW', 'FA', 1),
(976, 'Capital', 'KW', 'KU', 1),
(977, 'Al Ahmadi', 'KW', 'AH', 1),
(978, 'Luang Prabang Province', 'LA', 'LP', 1),
(979, 'Vientiane Prefecture', 'LA', 'VT', 1),
(980, 'Vientiane Province', 'LA', 'VI', 1),
(981, 'Salavan Province', 'LA', 'SL', 1),
(982, 'Attapeu Province', 'LA', 'AT', 1),
(983, 'Xaisomboun Province', 'LA', 'XS', 1),
(984, 'Sekong Province', 'LA', 'XE', 1),
(985, 'Bolikhamsai Province', 'LA', 'BL', 1),
(986, 'Khammouane Province', 'LA', 'KH', 1),
(987, 'Phongsaly Province', 'LA', 'PH', 1),
(988, 'Oudomxay Province', 'LA', 'OU', 1),
(989, 'Houaphanh Province', 'LA', 'HO', 1),
(990, 'Savannakhet Province', 'LA', 'SV', 1),
(991, 'Bokeo Province', 'LA', 'BK', 1),
(992, 'Luang Namtha Province', 'LA', 'LM', 1),
(993, 'Sainyabuli Province', 'LA', 'XA', 1),
(994, 'Xaisomboun', 'LA', 'XN', 1),
(995, 'Xiangkhouang Province', 'LA', 'XI', 1),
(996, 'Champasak Province', 'LA', 'CH', 1),
(997, 'Talas Region', 'KG', 'T', 1),
(998, 'Batken Region', 'KG', 'B', 1),
(999, 'Naryn Region', 'KG', 'N', 1),
(1000, 'Jalal-Abad Region', 'KG', 'J', 1),
(1001, 'Bishkek', 'KG', 'GB', 1),
(1002, 'Issyk-Kul Region', 'KG', 'Y', 1),
(1003, 'Osh', 'KG', 'GO', 1),
(1004, 'Chuy Region', 'KG', 'C', 1),
(1005, 'Osh Region', 'KG', 'O', 1),
(1006, 'Trøndelag', 'NO', '50', 1),
(1007, 'Oslo', 'NO', '03', 1),
(1008, 'Vestfold', 'NO', '07', 1),
(1009, 'Oppland', 'NO', '05', 1),
(1010, 'Sør-Trøndelag', 'NO', '16', 1),
(1011, 'Buskerud', 'NO', '06', 1),
(1012, 'Nord-Trøndelag', 'NO', '17', 1),
(1013, 'Svalbard', 'NO', '21', 1),
(1014, 'Vest-Agder', 'NO', '10', 1),
(1015, 'Troms', 'NO', '19', 1),
(1016, 'Finnmark', 'NO', '20', 1),
(1017, 'Akershus', 'NO', '02', 1),
(1018, 'Sogn og Fjordane', 'NO', '14', 1),
(1019, 'Hedmark', 'NO', '04', 1),
(1020, 'Møre og Romsdal', 'NO', '15', 1),
(1021, 'Rogaland', 'NO', '11', 1),
(1022, 'Østfold', 'NO', '01', 1),
(1023, 'Hordaland', 'NO', '12', 1),
(1024, 'Telemark', 'NO', '08', 1),
(1025, 'Nordland', 'NO', '18', 1),
(1026, 'Jan Mayen', 'NO', '22', 1),
(1027, 'Hódmezővásárhely', 'HU', 'HV', 1),
(1028, 'Érd', 'HU', 'ER', 1),
(1029, 'Szeged', 'HU', 'SD', 1),
(1030, 'Nagykanizsa', 'HU', 'NK', 1),
(1031, 'Csongrád County', 'HU', 'CS', 1),
(1032, 'Debrecen', 'HU', 'DE', 1),
(1033, 'Székesfehérvár', 'HU', 'SF', 1),
(1034, 'Nyíregyháza', 'HU', 'NY', 1),
(1035, 'Somogy County', 'HU', 'SO', 1),
(1036, 'Békéscsaba', 'HU', 'BC', 1),
(1037, 'Eger', 'HU', 'EG', 1),
(1038, 'Tolna County', 'HU', 'TO', 1),
(1039, 'Vas County', 'HU', 'VA', 1),
(1040, 'Heves County', 'HU', 'HE', 1),
(1041, 'Győr', 'HU', 'GY', 1),
(1042, 'Győr-Moson-Sopron County', 'HU', 'GS', 1),
(1043, 'Jász-Nagykun-Szolnok County', 'HU', 'JN', 1),
(1044, 'Fejér County', 'HU', 'FE', 1),
(1045, 'Szabolcs-Szatmár-Bereg County', 'HU', 'SZ', 1),
(1046, 'Zala County', 'HU', 'ZA', 1),
(1047, 'Szolnok', 'HU', 'SK', 1),
(1048, 'Bács-Kiskun', 'HU', 'BK', 1),
(1049, 'Dunaújváros', 'HU', 'DU', 1),
(1050, 'Zalaegerszeg', 'HU', 'ZE', 1),
(1051, 'Nógrád County', 'HU', 'NO', 1),
(1052, 'Szombathely', 'HU', 'SH', 1),
(1053, 'Pécs', 'HU', 'PS', 1),
(1054, 'Veszprém County', 'HU', 'VE', 1),
(1055, 'Baranya', 'HU', 'BA', 1),
(1056, 'Kecskemét', 'HU', 'KM', 1),
(1057, 'Sopron', 'HU', 'SN', 1),
(1058, 'Borsod-Abaúj-Zemplén', 'HU', 'BZ', 1),
(1059, 'Pest County', 'HU', 'PE', 1),
(1060, 'Békés', 'HU', 'BE', 1),
(1061, 'Szekszárd', 'HU', 'SS', 1),
(1062, 'Veszprém', 'HU', 'VM', 1),
(1063, 'Hajdú-Bihar County', 'HU', 'HB', 1),
(1064, 'Budapest', 'HU', 'BU', 1),
(1065, 'Miskolc', 'HU', 'MI', 1),
(1066, 'Tatabánya', 'HU', 'TB', 1),
(1067, 'Kaposvár', 'HU', 'KV', 1),
(1068, 'Salgótarján', 'HU', 'ST', 1),
(1069, 'Tipperary', 'IE', 'TA', 1),
(1070, 'Sligo', 'IE', 'SO', 1),
(1071, 'Donegal', 'IE', 'DL', 1),
(1072, 'Dublin', 'IE', 'D', 1),
(1073, 'Leinster', 'IE', 'L', 1),
(1074, 'Cork', 'IE', 'CO', 1),
(1075, 'Monaghan', 'IE', 'MN', 1),
(1076, 'Longford', 'IE', 'LD', 1),
(1077, 'Kerry', 'IE', 'KY', 1),
(1078, 'Offaly', 'IE', 'OY', 1),
(1079, 'Galway', 'IE', 'G', 1),
(1080, 'Munster', 'IE', 'M', 1),
(1081, 'Roscommon', 'IE', 'RN', 1),
(1082, 'Kildare', 'IE', 'KE', 1),
(1083, 'Louth', 'IE', 'LH', 1),
(1084, 'Mayo', 'IE', 'MO', 1),
(1085, 'Wicklow', 'IE', 'WW', 1),
(1086, 'Ulster', 'IE', 'U', 1),
(1087, 'Connacht', 'IE', 'C', 1),
(1088, 'Cavan', 'IE', 'CN', 1),
(1089, 'Waterford', 'IE', 'WD', 1),
(1090, 'Kilkenny', 'IE', 'KK', 1),
(1091, 'Clare', 'IE', 'CE', 1),
(1092, 'Meath', 'IE', 'MH', 1),
(1093, 'Wexford', 'IE', 'WX', 1),
(1094, 'Limerick', 'IE', 'LK', 1),
(1095, 'Carlow', 'IE', 'CW', 1),
(1096, 'Laois', 'IE', 'LS', 1),
(1097, 'Westmeath', 'IE', 'WH', 1),
(1098, 'Djelfa', 'DZ', '17', 1),
(1099, 'El Oued', 'DZ', '39', 1),
(1100, 'El Tarf', 'DZ', '36', 1),
(1101, 'Oran', 'DZ', '31', 1),
(1102, 'Naama', 'DZ', '45', 1),
(1103, 'Annaba', 'DZ', '23', 1),
(1104, 'Bouïra', 'DZ', '10', 1),
(1105, 'Chlef', 'DZ', '02', 1),
(1106, 'Tiaret', 'DZ', '14', 1),
(1107, 'Tlemcen', 'DZ', '13', 1),
(1108, 'Béchar', 'DZ', '08', 1),
(1109, 'Médéa', 'DZ', '26', 1),
(1110, 'Skikda', 'DZ', '21', 1),
(1111, 'Blida', 'DZ', '09', 1),
(1112, 'Illizi', 'DZ', '33', 1),
(1113, 'Jijel', 'DZ', '18', 1),
(1114, 'Biskra', 'DZ', '07', 1),
(1115, 'Tipasa', 'DZ', '42', 1),
(1116, 'Bordj Bou Arréridj', 'DZ', '34', 1),
(1117, 'Tébessa', 'DZ', '12', 1),
(1118, 'Adrar', 'DZ', '01', 1),
(1119, 'Aïn Defla', 'DZ', '44', 1),
(1120, 'Tindouf', 'DZ', '37', 1),
(1121, 'Constantine', 'DZ', '25', 1),
(1122, 'Aïn Témouchent', 'DZ', '46', 1),
(1123, 'Saïda', 'DZ', '20', 1),
(1124, 'Mascara', 'DZ', '29', 1),
(1125, 'Boumerdès', 'DZ', '35', 1),
(1126, 'Khenchela', 'DZ', '40', 1),
(1127, 'Ghardaïa', 'DZ', '47', 1),
(1128, 'Béjaïa', 'DZ', '06', 1),
(1129, 'El Bayadh', 'DZ', '32', 1),
(1130, 'Relizane', 'DZ', '48', 1),
(1131, 'Tizi Ouzou', 'DZ', '15', 1),
(1132, 'Mila', 'DZ', '43', 1),
(1133, 'Tissemsilt', 'DZ', '38', 1),
(1134, 'M''Sila', 'DZ', '28', 1),
(1135, 'Tamanghasset', 'DZ', '11', 1),
(1136, 'Oum El Bouaghi', 'DZ', '04', 1),
(1137, 'Guelma', 'DZ', '24', 1),
(1138, 'Laghouat', 'DZ', '03', 1),
(1139, 'Ouargla', 'DZ', '30', 1),
(1140, 'Mostaganem', 'DZ', '27', 1),
(1141, 'Sétif', 'DZ', '19', 1),
(1142, 'Batna', 'DZ', '05', 1),
(1143, 'Souk Ahras', 'DZ', '41', 1),
(1144, 'Algiers', 'DZ', '16', 1),
(1146, 'Burgos', 'ES', 'BU', 1),
(1147, 'Salamanca', 'ES', 'SA', 1),
(1157, 'Palencia', 'ES', 'P', 1),
(1158, 'Madrid', 'ES', 'M', 1),
(1160, 'Asturias', 'ES', 'O', 1),
(1161, 'Zamora', 'ES', 'ZA', 1),
(1167, 'Pontevedra', 'ES', 'PO', 1),
(1170, 'Cantabria', 'ES', 'S', 1),
(1171, 'La Rioja', 'ES', 'LO', 1),
(1174, 'Balearic Islands', 'ES', 'PM', 1),
(1175, 'Valencia', 'ES', 'V', 1),
(1176, 'Murcia', 'ES', 'MU', 1),
(1177, 'Huesca', 'ES', 'HU', 1),
(1183, 'Valladolid', 'ES', 'VA', 1),
(1185, 'Las Palmas', 'ES', 'GC', 1),
(1189, 'Ávila', 'ES', 'AV', 1),
(1190, 'Caceres', 'ES', 'CC', 1),
(1191, 'Gipuzkoa', 'ES', 'SS', 1),
(1192, 'Segovia', 'ES', 'SG', 1),
(1193, 'Sevilla', 'ES', 'SE', 1),
(1200, 'Léon', 'ES', 'LE', 1),
(1203, 'Tarragona', 'ES', 'T', 1),
(1204, 'Navarra', 'ES', 'NA', 1),
(1205, 'Toledo', 'ES', 'TO', 1),
(1208, 'Soria', 'ES', 'SO', 1),
(1209, 'Guanacaste Province', 'CR', 'G', 1),
(1210, 'Puntarenas Province', 'CR', 'P', 1),
(1211, 'Provincia de Cartago', 'CR', 'C', 1),
(1212, 'Heredia Province', 'CR', 'H', 1),
(1213, 'Limón Province', 'CR', 'L', 1),
(1214, 'San José Province', 'CR', 'SJ', 1),
(1215, 'Alajuela Province', 'CR', 'A', 1),
(1216, 'Brunei-Muara District', 'BN', 'BM', 1),
(1217, 'Belait District', 'BN', 'BE', 1),
(1218, 'Temburong District', 'BN', 'TE', 1),
(1219, 'Tutong District', 'BN', 'TU', 1),
(1220, 'Saint Philip', 'BB', '10', 1),
(1221, 'Saint Lucy', 'BB', '07', 1),
(1222, 'Saint Peter', 'BB', '09', 1),
(1223, 'Saint Joseph', 'BB', '06', 1),
(1224, 'Saint James', 'BB', '04', 1),
(1225, 'Saint Thomas', 'BB', '11', 1),
(1226, 'Saint George', 'BB', '03', 1),
(1227, 'Saint John', 'BB', '05', 1),
(1228, 'Christ Church', 'BB', '01', 1),
(1229, 'Saint Andrew', 'BB', '02', 1),
(1230, 'Saint Michael', 'BB', '08', 1),
(1231, 'Ta''izz', 'YE', 'TA', 1),
(1232, 'Sana''a', 'YE', 'SA', 1),
(1233, 'Ibb', 'YE', 'IB', 1),
(1234, 'Ma''rib', 'YE', 'MA', 1),
(1235, 'Al Mahwit', 'YE', 'MW', 1),
(1236, 'Sana''a', 'YE', 'SN', 1),
(1237, 'Abyan', 'YE', 'AB', 1),
(1238, 'Hadhramaut', 'YE', 'HD', 1),
(1239, 'Socotra', 'YE', 'SU', 1),
(1240, 'Al Bayda''', 'YE', 'BA', 1),
(1241, 'Al Hudaydah', 'YE', 'HU', 1),
(1242, '''Adan', 'YE', 'AD', 1),
(1243, 'Al Jawf', 'YE', 'JA', 1),
(1244, 'Hajjah', 'YE', 'HJ', 1),
(1245, 'Lahij', 'YE', 'LA', 1),
(1246, 'Dhamar', 'YE', 'DH', 1),
(1247, 'Shabwah', 'YE', 'SH', 1),
(1248, 'Raymah', 'YE', 'RA', 1),
(1249, 'Saada', 'YE', 'SD', 1),
(1250, '''Amran', 'YE', 'AM', 1),
(1251, 'Al Mahrah', 'YE', 'MR', 1),
(1252, 'Sangha-Mbaéré', 'CF', 'SE', 1),
(1253, 'Nana-Grébizi Economic Prefecture', 'CF', 'KB', 1),
(1254, 'Ouham Prefecture', 'CF', 'AC', 1),
(1255, 'Ombella-M''Poko Prefecture', 'CF', 'MP', 1),
(1256, 'Lobaye Prefecture', 'CF', 'LB', 1),
(1257, 'Mambéré-Kadéï', 'CF', 'HS', 1),
(1258, 'Haut-Mbomou Prefecture', 'CF', 'HM', 1),
(1259, 'Bamingui-Bangoran Prefecture', 'CF', 'BB', 1),
(1260, 'Nana-Mambéré Prefecture', 'CF', 'NM', 1),
(1261, 'Vakaga Prefecture', 'CF', 'VK', 1),
(1262, 'Bangui', 'CF', 'BGF', 1),
(1263, 'Kémo Prefecture', 'CF', 'KG', 1),
(1264, 'Basse-Kotto Prefecture', 'CF', 'BK', 1),
(1265, 'Ouaka Prefecture', 'CF', 'UK', 1),
(1266, 'Mbomou Prefecture', 'CF', 'MB', 1),
(1267, 'Ouham-Pendé Prefecture', 'CF', 'OP', 1),
(1268, 'Haute-Kotto Prefecture', 'CF', 'HK', 1),
(1269, 'Romblon', 'PH', 'ROM', 1),
(1270, 'Bukidnon', 'PH', 'BUK', 1),
(1271, 'Rizal', 'PH', 'RIZ', 1),
(1272, 'Bohol', 'PH', 'BOH', 1),
(1273, 'Quirino', 'PH', 'QUI', 1),
(1274, 'Biliran', 'PH', 'BIL', 1),
(1275, 'Quezon', 'PH', 'QUE', 1),
(1276, 'Siquijor', 'PH', 'SIG', 1),
(1277, 'Sarangani', 'PH', 'SAR', 1),
(1278, 'Bulacan', 'PH', 'BUL', 1),
(1279, 'Cagayan', 'PH', 'CAG', 1),
(1280, 'South Cotabato', 'PH', 'SCO', 1),
(1281, 'Sorsogon', 'PH', 'SOR', 1),
(1282, 'Sultan Kudarat', 'PH', 'SUK', 1),
(1283, 'Camarines Norte', 'PH', 'CAN', 1),
(1284, 'Southern Leyte', 'PH', 'SLE', 1),
(1285, 'Camiguin', 'PH', 'CAM', 1),
(1286, 'Surigao del Norte', 'PH', 'SUN', 1),
(1287, 'Camarines Sur', 'PH', 'CAS', 1),
(1288, 'Sulu', 'PH', 'SLU', 1),
(1289, 'Davao Oriental', 'PH', 'DAO', 1),
(1290, 'Eastern Samar', 'PH', 'EAS', 1),
(1291, 'Dinagat Islands', 'PH', 'DIN', 1),
(1292, 'Capiz', 'PH', 'CAP', 1),
(1293, 'Tawi-Tawi', 'PH', 'TAW', 1),
(1294, 'Calabarzon', 'PH', '40', 1),
(1295, 'Tarlac', 'PH', 'TAR', 1),
(1296, 'Surigao del Sur', 'PH', 'SUR', 1),
(1297, 'Zambales', 'PH', 'ZMB', 1),
(1298, 'Ilocos Norte', 'PH', 'ILN', 1),
(1299, 'Mimaropa', 'PH', '41', 1),
(1300, 'Ifugao', 'PH', 'IFU', 1),
(1301, 'Catanduanes', 'PH', 'CAT', 1),
(1302, 'Zamboanga del Norte', 'PH', 'ZAN', 1),
(1303, 'Guimaras', 'PH', 'GUI', 1),
(1304, 'Bicol', 'PH', '05', 1),
(1305, 'Western Visayas', 'PH', '06', 1),
(1306, 'Cebu', 'PH', 'CEB', 1),
(1307, 'Cavite', 'PH', 'CAV', 1),
(1308, 'Central Visayas', 'PH', '07', 1),
(1309, 'Davao Occidental', 'PH', 'DVO', 1),
(1310, 'Soccsksargen', 'PH', '12', 1),
(1311, 'Compostela Valley', 'PH', 'COM', 1),
(1312, 'Kalinga', 'PH', 'KAL', 1),
(1313, 'Isabela', 'PH', 'ISA', 1),
(1314, 'Caraga', 'PH', '13', 1),
(1315, 'Iloilo', 'PH', 'ILI', 1),
(1316, 'Autonomous Region in Muslim Mindanao', 'PH', '14', 1),
(1317, 'La Union', 'PH', 'LUN', 1),
(1318, 'Davao del Sur', 'PH', 'DAS', 1),
(1319, 'Davao del Norte', 'PH', 'DAV', 1),
(1320, 'Cotabato', 'PH', 'NCO', 1),
(1321, 'Ilocos Sur', 'PH', 'ILS', 1),
(1322, 'Eastern Visayas', 'PH', '08', 1),
(1323, 'Agusan del Norte', 'PH', 'AGN', 1),
(1324, 'Abra', 'PH', 'ABR', 1),
(1325, 'Zamboanga Peninsula', 'PH', '09', 1),
(1326, 'Agusan del Sur', 'PH', 'AGS', 1),
(1327, 'Lanao del Norte', 'PH', 'LAN', 1),
(1328, 'Laguna', 'PH', 'LAG', 1),
(1329, 'Marinduque', 'PH', 'MAD', 1),
(1330, 'Maguindanao', 'PH', 'MAG', 1),
(1331, 'Aklan', 'PH', 'AKL', 1),
(1332, 'Leyte', 'PH', 'LEY', 1),
(1333, 'Lanao del Sur', 'PH', 'LAS', 1),
(1334, 'Apayao', 'PH', 'APA', 1),
(1335, 'Cordillera Administrative', 'PH', '15', 1),
(1336, 'Antique', 'PH', 'ANT', 1),
(1337, 'Albay', 'PH', 'ALB', 1),
(1338, 'Masbate', 'PH', 'MAS', 1),
(1339, 'Northern Mindanao', 'PH', '10', 1),
(1340, 'Davao', 'PH', '11', 1),
(1341, 'Aurora', 'PH', 'AUR', 1),
(1342, 'Cagayan Valley', 'PH', '02', 1),
(1343, 'Misamis Occidental', 'PH', 'MSC', 1),
(1344, 'Bataan', 'PH', 'BAN', 1),
(1345, 'Central Luzon', 'PH', '03', 1),
(1346, 'Basilan', 'PH', 'BAS', 1),
(1347, 'Metro Manila', 'PH', 'NCR', 1),
(1348, 'Misamis Oriental', 'PH', 'MSR', 1),
(1349, 'Northern Samar', 'PH', 'NSA', 1),
(1350, 'Negros Oriental', 'PH', 'NER', 1),
(1351, 'Negros Occidental', 'PH', 'NEC', 1),
(1352, 'Batanes', 'PH', 'BTN', 1),
(1353, 'Mountain Province', 'PH', 'MOU', 1),
(1354, 'Oriental Mindoro', 'PH', 'MDR', 1),
(1355, 'Ilocos', 'PH', '01', 1),
(1356, 'Occidental Mindoro', 'PH', 'MDC', 1),
(1357, 'Zamboanga del Sur', 'PH', 'ZAS', 1),
(1358, 'Nueva Vizcaya', 'PH', 'NUV', 1),
(1359, 'Batangas', 'PH', 'BTG', 1),
(1360, 'Nueva Ecija', 'PH', 'NUE', 1),
(1361, 'Palawan', 'PH', 'PLW', 1),
(1362, 'Zamboanga Sibugay', 'PH', 'ZSI', 1),
(1363, 'Benguet', 'PH', 'BEN', 1),
(1364, 'Pangasinan', 'PH', 'PAN', 1),
(1365, 'Pampanga', 'PH', 'PAM', 1),
(1366, 'Northern District', 'IL', 'Z', 1),
(1367, 'Central District', 'IL', 'M', 1),
(1368, 'Southern District', 'IL', 'D', 1),
(1369, 'Haifa District', 'IL', 'HA', 1),
(1370, 'Jerusalem District', 'IL', 'JM', 1),
(1371, 'Tel Aviv District', 'IL', 'TA', 1),
(1372, 'Limburg', 'BE', 'VLI', 1),
(1373, 'Flanders', 'BE', 'VLG', 1),
(1374, 'Flemish Brabant', 'BE', 'VBR', 1);
INSERT INTO `state` VALUES
(1375, 'Hainaut', 'BE', 'WHT', 1),
(1376, 'Brussels-Capital Region', 'BE', 'BRU', 1),
(1377, 'East Flanders', 'BE', 'VOV', 1),
(1378, 'Namur', 'BE', 'WNA', 1),
(1379, 'Luxembourg', 'BE', 'WLX', 1),
(1380, 'Wallonia', 'BE', 'WAL', 1),
(1381, 'Antwerp', 'BE', 'VAN', 1),
(1382, 'Walloon Brabant', 'BE', 'WBR', 1),
(1383, 'West Flanders', 'BE', 'VWV', 1),
(1384, 'Liège', 'BE', 'WLG', 1),
(1385, 'Darién Province', 'PA', '5', 1),
(1386, 'Colón Province', 'PA', '3', 1),
(1387, 'Coclé Province', 'PA', '2', 1),
(1388, 'Guna Yala', 'PA', 'KY', 1),
(1389, 'Herrera Province', 'PA', '6', 1),
(1390, 'Los Santos Province', 'PA', '7', 1),
(1391, 'Ngöbe-Buglé Comarca', 'PA', 'NB', 1),
(1392, 'Veraguas Province', 'PA', '9', 1),
(1393, 'Bocas del Toro Province', 'PA', '1', 1),
(1394, 'Panamá Oeste Province', 'PA', '10', 1),
(1395, 'Panamá Province', 'PA', '8', 1),
(1396, 'Emberá-Wounaan Comarca', 'PA', 'EM', 1),
(1397, 'Chiriquí Province', 'PA', '4', 1),
(1398, 'Howland Island', 'US', 'UM-84', 1),
(1399, 'Delaware', 'US', 'DE', 1),
(1400, 'Alaska', 'US', 'AK', 1),
(1401, 'Maryland', 'US', 'MD', 1),
(1402, 'Baker Island', 'US', 'UM-81', 1),
(1403, 'Kingman Reef', 'US', 'UM-89', 1),
(1404, 'New Hampshire', 'US', 'NH', 1),
(1405, 'Wake Island', 'US', 'UM-79', 1),
(1406, 'Kansas', 'US', 'KS', 1),
(1407, 'Texas', 'US', 'TX', 1),
(1408, 'Nebraska', 'US', 'NE', 1),
(1409, 'Vermont', 'US', 'VT', 1),
(1410, 'Jarvis Island', 'US', 'UM-86', 1),
(1411, 'Hawaii', 'US', 'HI', 1),
(1412, 'Guam', 'US', 'GU', 1),
(1413, 'United States Virgin Islands', 'US', 'VI', 1),
(1414, 'Utah', 'US', 'UT', 1),
(1415, 'Oregon', 'US', 'OR', 1),
(1416, 'California', 'US', 'CA', 1),
(1417, 'New Jersey', 'US', 'NJ', 1),
(1418, 'North Dakota', 'US', 'ND', 1),
(1419, 'Kentucky', 'US', 'KY', 1),
(1420, 'Minnesota', 'US', 'MN', 1),
(1421, 'Oklahoma', 'US', 'OK', 1),
(1422, 'Pennsylvania', 'US', 'PA', 1),
(1423, 'New Mexico', 'US', 'NM', 1),
(1424, 'American Samoa', 'US', 'AS', 1),
(1425, 'Illinois', 'US', 'IL', 1),
(1426, 'Michigan', 'US', 'MI', 1),
(1427, 'Virginia', 'US', 'VA', 1),
(1428, 'Johnston Atoll', 'US', 'UM-67', 1),
(1429, 'West Virginia', 'US', 'WV', 1),
(1430, 'Mississippi', 'US', 'MS', 1),
(1431, 'Northern Mariana Islands', 'US', 'MP', 1),
(1432, 'United States Minor Outlying Islands', 'US', 'UM', 1),
(1433, 'Massachusetts', 'US', 'MA', 1),
(1434, 'Arizona', 'US', 'AZ', 1),
(1435, 'Connecticut', 'US', 'CT', 1),
(1436, 'Florida', 'US', 'FL', 1),
(1437, 'District of Columbia', 'US', 'DC', 1),
(1438, 'Midway Atoll', 'US', 'UM-71', 1),
(1439, 'Navassa Island', 'US', 'UM-76', 1),
(1440, 'Indiana', 'US', 'IN', 1),
(1441, 'Wisconsin', 'US', 'WI', 1),
(1442, 'Wyoming', 'US', 'WY', 1),
(1443, 'South Carolina', 'US', 'SC', 1),
(1444, 'Arkansas', 'US', 'AR', 1),
(1445, 'South Dakota', 'US', 'SD', 1),
(1446, 'Montana', 'US', 'MT', 1),
(1447, 'North Carolina', 'US', 'NC', 1),
(1448, 'Palmyra Atoll', 'US', 'UM-95', 1),
(1449, 'Puerto Rico', 'US', 'PR', 1),
(1450, 'Colorado', 'US', 'CO', 1),
(1451, 'Missouri', 'US', 'MO', 1),
(1452, 'New York', 'US', 'NY', 1),
(1453, 'Maine', 'US', 'ME', 1),
(1454, 'Tennessee', 'US', 'TN', 1),
(1455, 'Georgia', 'US', 'GA', 1),
(1456, 'Alabama', 'US', 'AL', 1),
(1457, 'Louisiana', 'US', 'LA', 1),
(1458, 'Nevada', 'US', 'NV', 1),
(1459, 'Iowa', 'US', 'IA', 1),
(1460, 'Idaho', 'US', 'ID', 1),
(1461, 'Rhode Island', 'US', 'RI', 1),
(1462, 'Washington', 'US', 'WA', 1),
(1463, 'Shinyanga', 'TZ', '22', 1),
(1464, 'Simiyu', 'TZ', '30', 1),
(1465, 'Kagera', 'TZ', '05', 1),
(1466, 'Dodoma', 'TZ', '03', 1),
(1467, 'Kilimanjaro', 'TZ', '09', 1),
(1468, 'Mara', 'TZ', '13', 1),
(1469, 'Tabora', 'TZ', '24', 1),
(1470, 'Morogoro', 'TZ', '16', 1),
(1471, 'Zanzibar South', 'TZ', '11', 1),
(1472, 'Pemba South', 'TZ', '10', 1),
(1473, 'Zanzibar North', 'TZ', '07', 1),
(1474, 'Singida', 'TZ', '23', 1),
(1475, 'Zanzibar West', 'TZ', '15', 1),
(1476, 'Mtwara', 'TZ', '17', 1),
(1477, 'Rukwa', 'TZ', '20', 1),
(1478, 'Kigoma', 'TZ', '08', 1),
(1479, 'Mwanza', 'TZ', '18', 1),
(1480, 'Njombe', 'TZ', '29', 1),
(1481, 'Geita', 'TZ', '27', 1),
(1482, 'Katavi', 'TZ', '28', 1),
(1483, 'Lindi', 'TZ', '12', 1),
(1484, 'Manyara', 'TZ', '26', 1),
(1485, 'Pwani', 'TZ', '19', 1),
(1486, 'Ruvuma', 'TZ', '21', 1),
(1487, 'Tanga', 'TZ', '25', 1),
(1488, 'Pemba North', 'TZ', '06', 1),
(1489, 'Iringa', 'TZ', '04', 1),
(1490, 'Dar es Salaam', 'TZ', '02', 1),
(1491, 'Arusha', 'TZ', '01', 1),
(1493, 'Tavastia Proper', 'FI', '06', 1),
(1494, 'Central Ostrobothnia', 'FI', '07', 1),
(1495, 'Southern Savonia', 'FI', '04', 1),
(1496, 'Kainuu', 'FI', '05', 1),
(1497, 'South Karelia', 'FI', '02', 1),
(1498, 'Southern Ostrobothnia', 'FI', '03', 1),
(1500, 'Lapland', 'FI', '10', 1),
(1501, 'Satakunta', 'FI', '17', 1),
(1502, 'Päijänne Tavastia', 'FI', '16', 1),
(1503, 'Northern Savonia', 'FI', '15', 1),
(1504, 'North Karelia', 'FI', '13', 1),
(1505, 'Northern Ostrobothnia', 'FI', '14', 1),
(1506, 'Pirkanmaa', 'FI', '11', 1),
(1507, 'Finland Proper', 'FI', '19', 1),
(1508, 'Ostrobothnia', 'FI', '12', 1),
(1509, 'Åland Islands', 'FI', '01', 1),
(1510, 'Uusimaa', 'FI', '18', 1),
(1511, 'Central Finland', 'FI', '08', 1),
(1512, 'Kymenlaakso', 'FI', '09', 1),
(1513, 'Canton of Diekirch', 'LU', 'DI', 1),
(1514, 'Luxembourg District', 'LU', 'L', 1),
(1515, 'Canton of Echternach', 'LU', 'EC', 1),
(1516, 'Canton of Redange', 'LU', 'RD', 1),
(1517, 'Canton of Esch-sur-Alzette', 'LU', 'ES', 1),
(1518, 'Canton of Capellen', 'LU', 'CA', 1),
(1519, 'Canton of Remich', 'LU', 'RM', 1),
(1520, 'Grevenmacher District', 'LU', 'G', 1),
(1521, 'Canton of Clervaux', 'LU', 'CL', 1),
(1522, 'Canton of Mersch', 'LU', 'ME', 1),
(1523, 'Canton of Vianden', 'LU', 'VD', 1),
(1524, 'Diekirch District', 'LU', 'D', 1),
(1525, 'Canton of Grevenmacher', 'LU', 'GR', 1),
(1526, 'Canton of Wiltz', 'LU', 'WI', 1),
(1527, 'Canton of Luxembourg', 'LU', 'LU', 1),
(1528, 'Region Zealand', 'DK', '85', 1),
(1529, 'Region of Southern Denmark', 'DK', '83', 1),
(1530, 'Capital Region of Denmark', 'DK', '84', 1),
(1531, 'Central Denmark Region', 'DK', '82', 1),
(1532, 'North Denmark Region', 'DK', '81', 1),
(1533, 'Gävleborg County', 'SE', 'X', 1),
(1534, 'Dalarna County', 'SE', 'W', 1),
(1535, 'Värmland County', 'SE', 'S', 1),
(1536, 'Östergötland County', 'SE', 'E', 1),
(1537, 'Blekinge', 'SE', 'K', 1),
(1538, 'Norrbotten County', 'SE', 'BD', 1),
(1539, 'Örebro County', 'SE', 'T', 1),
(1540, 'Södermanland County', 'SE', 'D', 1),
(1541, 'Skåne County', 'SE', 'M', 1),
(1542, 'Kronoberg County', 'SE', 'G', 1),
(1543, 'Västerbotten County', 'SE', 'AC', 1),
(1544, 'Kalmar County', 'SE', 'H', 1),
(1545, 'Uppsala County', 'SE', 'C', 1),
(1546, 'Gotland County', 'SE', 'I', 1),
(1547, 'Västra Götaland County', 'SE', 'O', 1),
(1548, 'Halland County', 'SE', 'N', 1),
(1549, 'Västmanland County', 'SE', 'U', 1),
(1550, 'Jönköping County', 'SE', 'F', 1),
(1551, 'Stockholm County', 'SE', 'AB', 1),
(1552, 'Västernorrland County', 'SE', 'Y', 1),
(1553, 'Plungė District Municipality', 'LT', '35', 1),
(1554, 'Šiauliai District Municipality', 'LT', '44', 1),
(1555, 'Jurbarkas District Municipality', 'LT', '12', 1),
(1556, 'Kaunas County', 'LT', 'KU', 1),
(1557, 'Mažeikiai District Municipality', 'LT', '26', 1),
(1558, 'Panevėžys County', 'LT', 'PN', 1),
(1559, 'Elektrėnai municipality', 'LT', '08', 1),
(1560, 'Švenčionys District Municipality', 'LT', '49', 1),
(1561, 'Akmenė District Municipality', 'LT', '01', 1),
(1562, 'Ignalina District Municipality', 'LT', '09', 1),
(1563, 'Neringa Municipality', 'LT', '28', 1),
(1564, 'Visaginas Municipality', 'LT', '59', 1),
(1565, 'Kaunas District Municipality', 'LT', '16', 1),
(1566, 'Biržai District Municipality', 'LT', '06', 1),
(1567, 'Jonava District Municipality', 'LT', '10', 1),
(1568, 'Radviliškis District Municipality', 'LT', '37', 1),
(1569, 'Telšiai County', 'LT', 'TE', 1),
(1570, 'Marijampolė County', 'LT', 'MR', 1),
(1571, 'Kretinga District Municipality', 'LT', '22', 1),
(1572, 'Tauragė District Municipality', 'LT', '50', 1),
(1573, 'Tauragė County', 'LT', 'TA', 1),
(1574, 'Alytus County', 'LT', 'AL', 1),
(1575, 'Kazlų Rūda municipality', 'LT', '17', 1),
(1576, 'Šakiai District Municipality', 'LT', '41', 1),
(1577, 'Šalčininkai District Municipality', 'LT', '42', 1),
(1578, 'Prienai District Municipality', 'LT', '36', 1),
(1579, 'Druskininkai municipality', 'LT', '07', 1),
(1580, 'Kaunas City Municipality', 'LT', '15', 1),
(1581, 'Joniškis District Municipality', 'LT', '11', 1),
(1582, 'Molėtai District Municipality', 'LT', '27', 1),
(1583, 'Kaišiadorys District Municipality', 'LT', '13', 1),
(1584, 'Kėdainiai District Municipality', 'LT', '18', 1),
(1585, 'Kupiškis District Municipality', 'LT', '23', 1),
(1586, 'Šiauliai County', 'LT', 'SA', 1),
(1587, 'Raseiniai District Municipality', 'LT', '38', 1),
(1588, 'Palanga City Municipality', 'LT', '31', 1),
(1589, 'Panevėžys City Municipality', 'LT', '32', 1),
(1590, 'Rietavas municipality', 'LT', '39', 1),
(1591, 'Kalvarija municipality', 'LT', '14', 1),
(1592, 'Vilnius District Municipality', 'LT', '58', 1),
(1593, 'Trakai District Municipality', 'LT', '52', 1),
(1594, 'Širvintos District Municipality', 'LT', '47', 1),
(1595, 'Pakruojis District Municipality', 'LT', '30', 1),
(1596, 'Ukmergė District Municipality', 'LT', '53', 1),
(1597, 'Klaipeda City Municipality', 'LT', '20', 1),
(1598, 'Utena District Municipality', 'LT', '54', 1),
(1599, 'Alytus District Municipality', 'LT', '03', 1),
(1600, 'Klaipėda County', 'LT', 'KL', 1),
(1601, 'Vilnius County', 'LT', 'VL', 1),
(1602, 'Varėna District Municipality', 'LT', '55', 1),
(1603, 'Birštonas Municipality', 'LT', '05', 1),
(1604, 'Klaipėda District Municipality', 'LT', '21', 1),
(1605, 'Alytus City Municipality', 'LT', '02', 1),
(1606, 'Vilnius City Municipality', 'LT', '57', 1),
(1607, 'Šilutė District Municipality', 'LT', '46', 1),
(1608, 'Telšiai District Municipality', 'LT', '51', 1),
(1609, 'Šiauliai City Municipality', 'LT', '43', 1),
(1610, 'Marijampolė Municipality', 'LT', '25', 1),
(1611, 'Lazdijai District Municipality', 'LT', '24', 1),
(1612, 'Pagėgiai municipality', 'LT', '29', 1),
(1613, 'Šilalė District Municipality', 'LT', '45', 1),
(1614, 'Panevėžys District Municipality', 'LT', '33', 1),
(1615, 'Rokiškis District Municipality', 'LT', '40', 1),
(1616, 'Pasvalys District Municipality', 'LT', '34', 1),
(1617, 'Skuodas District Municipality', 'LT', '48', 1),
(1618, 'Kelmė District Municipality', 'LT', '19', 1),
(1619, 'Zarasai District Municipality', 'LT', '60', 1),
(1620, 'Vilkaviškis District Municipality', 'LT', '56', 1),
(1621, 'Utena County', 'LT', 'UT', 1),
(1622, 'Opole Voivodeship', 'PL', 'OP', 1),
(1623, 'Silesian Voivodeship', 'PL', 'SL', 1),
(1624, 'Pomeranian Voivodeship', 'PL', 'PM', 1),
(1625, 'Kuyavian-Pomeranian Voivodeship', 'PL', 'KP', 1),
(1626, 'Podkarpackie Voivodeship', 'PL', 'PK', 1),
(1628, 'Warmian-Masurian Voivodeship', 'PL', 'WN', 1),
(1629, 'Lower Silesian Voivodeship', 'PL', 'DS', 1),
(1630, 'Świętokrzyskie Voivodeship', 'PL', 'SK', 1),
(1631, 'Lubusz Voivodeship', 'PL', 'LB', 1),
(1632, 'Podlaskie Voivodeship', 'PL', 'PD', 1),
(1633, 'West Pomeranian Voivodeship', 'PL', 'ZP', 1),
(1634, 'Greater Poland Voivodeship', 'PL', 'WP', 1),
(1635, 'Lesser Poland Voivodeship', 'PL', 'MA', 1),
(1636, 'Łódź Voivodeship', 'PL', 'LD', 1),
(1637, 'Masovian Voivodeship', 'PL', 'MZ', 1),
(1638, 'Lublin Voivodeship', 'PL', 'LU', 1),
(1639, 'Aargau', 'CH', 'AG', 1),
(1640, 'Fribourg', 'CH', 'FR', 1),
(1641, 'Basel-Land', 'CH', 'BL', 1),
(1642, 'Uri', 'CH', 'UR', 1),
(1643, 'Ticino', 'CH', 'TI', 1),
(1644, 'St. Gallen', 'CH', 'SG', 1),
(1645, 'Bern', 'CH', 'BE', 1),
(1646, 'Zug', 'CH', 'ZG', 1),
(1647, 'Geneva', 'CH', 'GE', 1),
(1648, 'Valais', 'CH', 'VS', 1),
(1649, 'Appenzell Innerrhoden', 'CH', 'AI', 1),
(1650, 'Obwalden', 'CH', 'OW', 1),
(1651, 'Vaud', 'CH', 'VD', 1),
(1652, 'Nidwalden', 'CH', 'NW', 1),
(1653, 'Schwyz', 'CH', 'SZ', 1),
(1654, 'Schaffhausen', 'CH', 'SH', 1),
(1655, 'Appenzell Ausserrhoden', 'CH', 'AR', 1),
(1656, 'Zürich', 'CH', 'ZH', 1),
(1657, 'Thurgau', 'CH', 'TG', 1),
(1658, 'Jura', 'CH', 'JU', 1),
(1659, 'Neuchâtel', 'CH', 'NE', 1),
(1660, 'Graubünden', 'CH', 'GR', 1),
(1661, 'Glarus', 'CH', 'GL', 1),
(1662, 'Solothurn', 'CH', 'SO', 1),
(1663, 'Lucerne', 'CH', 'LU', 1),
(1664, 'Tuscany', 'IT', '52', 1),
(1665, 'Padua', 'IT', 'PD', 1),
(1666, 'Parma', 'IT', 'PR', 1),
(1667, 'Siracusa', 'IT', 'SR', 1),
(1668, 'Palermo', 'IT', 'PA', 1),
(1669, 'Campania', 'IT', '72', 1),
(1670, 'Marche', 'IT', '57', 1),
(1671, 'Reggio Calabria', 'IT', 'RC', 1),
(1672, 'Ancona', 'IT', 'AN', 1),
(1673, 'Venice', 'IT', 'VE', 1),
(1674, 'Latina', 'IT', 'LT', 1),
(1675, 'Lecce', 'IT', 'LE', 1),
(1676, 'Pavia', 'IT', 'PV', 1),
(1677, 'Lecco', 'IT', 'LC', 1),
(1678, 'Lazio', 'IT', '62', 1),
(1679, 'Abruzzo', 'IT', '65', 1),
(1680, 'Florence', 'IT', 'FI', 1),
(1681, 'Ascoli Piceno', 'IT', 'AP', 1),
(1682, 'Cagliari', 'IT', 'CA', 1),
(1683, 'Umbria', 'IT', '55', 1),
(1684, 'Bologna', 'IT', 'BO', 1),
(1685, 'Pisa', 'IT', 'PI', 1),
(1686, 'Barletta-Andria-Trani', 'IT', 'BT', 1),
(1687, 'Pistoia', 'IT', 'PT', 1),
(1688, 'Apulia', 'IT', '75', 1),
(1689, 'Belluno', 'IT', 'BL', 1),
(1690, 'Pordenone', 'IT', 'PN', 1),
(1691, 'Perugia', 'IT', 'PG', 1),
(1692, 'Avellino', 'IT', 'AV', 1),
(1693, 'Pesaro and Urbino', 'IT', 'PU', 1),
(1694, 'Pescara', 'IT', 'PE', 1),
(1695, 'Molise', 'IT', '67', 1),
(1696, 'Piacenza', 'IT', 'PC', 1),
(1697, 'Potenza', 'IT', 'PZ', 1),
(1698, 'Milan', 'IT', 'MI', 1),
(1699, 'Genoa', 'IT', 'GE', 1),
(1700, 'Prato', 'IT', 'PO', 1),
(1701, 'Benevento', 'IT', 'BN', 1),
(1702, 'Piedmont', 'IT', '21', 1),
(1703, 'Calabria', 'IT', '78', 1),
(1704, 'Bergamo', 'IT', 'BG', 1),
(1705, 'Lombardy', 'IT', '25', 1),
(1706, 'Basilicata', 'IT', '77', 1),
(1707, 'Ravenna', 'IT', 'RA', 1),
(1708, 'Reggio Emilia', 'IT', 'RE', 1),
(1709, 'Sicily', 'IT', '82', 1),
(1710, 'Turin', 'IT', 'TO', 1),
(1711, 'Rome', 'IT', 'RM', 1),
(1712, 'Rieti', 'IT', 'RI', 1),
(1713, 'Rimini', 'IT', 'RN', 1),
(1714, 'Brindisi', 'IT', 'BR', 1),
(1715, 'Sardinia', 'IT', '88', 1),
(1716, 'Aosta Valley', 'IT', '23', 1),
(1717, 'Brescia', 'IT', 'BS', 1),
(1718, 'Caltanissetta', 'IT', 'CL', 1),
(1719, 'Rovigo', 'IT', 'RO', 1),
(1720, 'Salerno', 'IT', 'SA', 1),
(1721, 'Campobasso', 'IT', 'CB', 1),
(1722, 'Sassari', 'IT', 'SS', 1),
(1723, 'Enna', 'IT', 'EN', 1),
(1724, 'Naples', 'IT', 'NA', 1),
(1725, 'Trentino-South Tyrol', 'IT', '32', 1),
(1726, 'Verbano-Cusio-Ossola', 'IT', 'VB', 1),
(1727, 'Agrigento', 'IT', 'AG', 1),
(1728, 'Catanzaro', 'IT', 'CZ', 1),
(1729, 'Ragusa', 'IT', 'RG', 1),
(1730, 'South Sardinia', 'IT', 'SU', 1),
(1731, 'Caserta', 'IT', 'CE', 1),
(1732, 'Savona', 'IT', 'SV', 1),
(1733, 'Trapani', 'IT', 'TP', 1),
(1734, 'Siena', 'IT', 'SI', 1),
(1735, 'Viterbo', 'IT', 'VT', 1),
(1736, 'Verona', 'IT', 'VR', 1),
(1737, 'Vibo Valentia', 'IT', 'VV', 1),
(1738, 'Vicenza', 'IT', 'VI', 1),
(1739, 'Chieti', 'IT', 'CH', 1),
(1740, 'Como', 'IT', 'CO', 1),
(1741, 'Sondrio', 'IT', 'SO', 1),
(1742, 'Cosenza', 'IT', 'CS', 1),
(1743, 'Taranto', 'IT', 'TA', 1),
(1744, 'Fermo', 'IT', 'FM', 1),
(1745, 'Livorno', 'IT', 'LI', 1),
(1746, 'Ferrara', 'IT', 'FE', 1),
(1747, 'Lodi', 'IT', 'LO', 1),
(1748, 'Trentino', 'IT', 'TN', 1),
(1749, 'Lucca', 'IT', 'LU', 1),
(1750, 'Macerata', 'IT', 'MC', 1),
(1751, 'Cremona', 'IT', 'CR', 1),
(1752, 'Teramo', 'IT', 'TE', 1),
(1753, 'Veneto', 'IT', '34', 1),
(1754, 'Crotone', 'IT', 'KR', 1),
(1755, 'Terni', 'IT', 'TR', 1),
(1756, 'Friuli–Venezia Giulia', 'IT', '36', 1),
(1757, 'Modena', 'IT', 'MO', 1),
(1758, 'Mantua', 'IT', 'MN', 1),
(1759, 'Massa and Carrara', 'IT', 'MS', 1),
(1760, 'Matera', 'IT', 'MT', 1),
(1761, 'Medio Campidano', 'IT', 'VS', 1),
(1762, 'Treviso', 'IT', 'TV', 1),
(1763, 'Trieste', 'IT', 'TS', 1),
(1764, 'Udine', 'IT', 'UD', 1),
(1765, 'Varese', 'IT', 'VA', 1),
(1766, 'Catania', 'IT', 'CT', 1),
(1767, 'South Tyrol', 'IT', 'BZ', 1),
(1768, 'Liguria', 'IT', '42', 1),
(1769, 'Monza and Brianza', 'IT', 'MB', 1),
(1770, 'Messina', 'IT', 'ME', 1),
(1771, 'Foggia', 'IT', 'FG', 1),
(1772, 'Bari', 'IT', 'BA', 1),
(1773, 'Emilia-Romagna', 'IT', '45', 1),
(1774, 'Novara', 'IT', 'NO', 1),
(1775, 'Cuneo', 'IT', 'CN', 1),
(1776, 'Frosinone', 'IT', 'FR', 1),
(1777, 'Gorizia', 'IT', 'GO', 1),
(1778, 'Biella', 'IT', 'BI', 1),
(1779, 'Forlì-Cesena', 'IT', 'FC', 1),
(1780, 'Asti', 'IT', 'AT', 1),
(1781, 'L''Aquila', 'IT', 'AQ', 1),
(1783, 'Alessandria', 'IT', 'AL', 1),
(1785, 'Vercelli', 'IT', 'VC', 1),
(1786, 'Oristano', 'IT', 'OR', 1),
(1787, 'Grosseto', 'IT', 'GR', 1),
(1788, 'Imperia', 'IT', 'IM', 1),
(1789, 'Isernia', 'IT', 'IS', 1),
(1790, 'Nuoro', 'IT', 'NU', 1),
(1791, 'La Spezia', 'IT', 'SP', 1),
(1792, 'Sumatera Utara', 'ID', 'SU', 1),
(1793, 'Bengkulu', 'ID', 'BE', 1),
(1794, 'Kalimantan Tengah', 'ID', 'KT', 1),
(1795, 'Sulawesi Selatan', 'ID', 'SN', 1),
(1796, 'Sulawesi Tenggara', 'ID', 'SG', 1),
(1798, 'Papua', 'ID', 'PA', 1),
(1799, 'Papua Barat', 'ID', 'PB', 1),
(1800, 'Maluku', 'ID', 'MA', 1),
(1801, 'Maluku Utara', 'ID', 'MU', 1),
(1802, 'Jawa Tengah', 'ID', 'JT', 1),
(1804, 'Kalimantan Timur', 'ID', 'KI', 1),
(1805, 'DKI Jakarta', 'ID', 'JK', 1),
(1806, 'Kalimantan Barat', 'ID', 'KB', 1),
(1807, 'Kepulauan Riau', 'ID', 'KR', 1),
(1808, 'Sulawesi Utara', 'ID', 'SA', 1),
(1809, 'Riau', 'ID', 'RI', 1),
(1810, 'Banten', 'ID', 'BT', 1),
(1811, 'Lampung', 'ID', 'LA', 1),
(1812, 'Gorontalo', 'ID', 'GO', 1),
(1813, 'Sulawesi Tengah', 'ID', 'ST', 1),
(1814, 'Nusa Tenggara Barat', 'ID', 'NB', 1),
(1815, 'Jambi', 'ID', 'JA', 1),
(1816, 'Sumatera Selatan', 'ID', 'SS', 1),
(1817, 'Sulawesi Barat', 'ID', 'SR', 1),
(1818, 'Nusa Tenggara Timur', 'ID', 'NT', 1),
(1819, 'Kalimantan Selatan', 'ID', 'KS', 1),
(1820, 'Kepulauan Bangka Belitung', 'ID', 'BB', 1),
(1822, 'Aceh', 'ID', 'AC', 1),
(1824, 'Kalimantan Utara', 'ID', 'KU', 1),
(1825, 'Jawa Barat', 'ID', 'JB', 1),
(1826, 'Bali', 'ID', 'BA', 1),
(1827, 'Jawa Timur', 'ID', 'JI', 1),
(1828, 'Sumatera Barat', 'ID', 'SB', 1),
(1829, 'DI Yogyakarta', 'ID', 'YO', 1),
(1830, 'Phoenix Islands', 'KI', 'P', 1),
(1831, 'Gilbert Islands', 'KI', 'G', 1),
(1832, 'Line Islands', 'KI', 'L', 1),
(1833, 'Primorsky Krai', 'RU', 'PRI', 1),
(1834, 'Novgorod Oblast', 'RU', 'NGR', 1),
(1835, 'Jewish Autonomous Oblast', 'RU', 'YEV', 1),
(1836, 'Nenets Autonomous Okrug', 'RU', 'NEN', 1),
(1837, 'Rostov Oblast', 'RU', 'ROS', 1),
(1838, 'Khanty-Mansi Autonomous Okrug', 'RU', 'KHM', 1),
(1839, 'Magadan Oblast', 'RU', 'MAG', 1),
(1840, 'Krasnoyarsk Krai', 'RU', 'KYA', 1),
(1841, 'Republic of Karelia', 'RU', 'KR', 1),
(1842, 'Republic of Buryatia', 'RU', 'BU', 1),
(1843, 'Murmansk Oblast', 'RU', 'MUR', 1),
(1844, 'Kaluga Oblast', 'RU', 'KLU', 1),
(1845, 'Chelyabinsk Oblast', 'RU', 'CHE', 1),
(1846, 'Omsk Oblast', 'RU', 'OMS', 1),
(1847, 'Yamalo-Nenets Autonomous Okrug', 'RU', 'YAN', 1),
(1848, 'Sakha Republic', 'RU', 'SA', 1),
(1849, 'Arkhangelsk', 'RU', 'ARK', 1),
(1850, 'Republic of Dagestan', 'RU', 'DA', 1),
(1851, 'Yaroslavl Oblast', 'RU', 'YAR', 1),
(1852, 'Republic of Adygea', 'RU', 'AD', 1),
(1853, 'Republic of North Ossetia-Alania', 'RU', 'SE', 1),
(1854, 'Republic of Bashkortostan', 'RU', 'BA', 1),
(1855, 'Kursk Oblast', 'RU', 'KRS', 1),
(1856, 'Ulyanovsk Oblast', 'RU', 'ULY', 1),
(1857, 'Nizhny Novgorod Oblast', 'RU', 'NIZ', 1),
(1858, 'Amur Oblast', 'RU', 'AMU', 1),
(1859, 'Chukotka Autonomous Okrug', 'RU', 'CHU', 1),
(1860, 'Tver Oblast', 'RU', 'TVE', 1),
(1861, 'Republic of Tatarstan', 'RU', 'TA', 1),
(1862, 'Samara Oblast', 'RU', 'SAM', 1),
(1863, 'Pskov Oblast', 'RU', 'PSK', 1),
(1864, 'Ivanovo Oblast', 'RU', 'IVA', 1),
(1865, 'Kamchatka Krai', 'RU', 'KAM', 1),
(1866, 'Astrakhan Oblast', 'RU', 'AST', 1),
(1867, 'Bryansk Oblast', 'RU', 'BRY', 1),
(1868, 'Stavropol Krai', 'RU', 'STA', 1),
(1869, 'Karachay-Cherkess Republic', 'RU', 'KC', 1),
(1870, 'Mari El Republic', 'RU', 'ME', 1),
(1871, 'Perm Krai', 'RU', 'PER', 1),
(1872, 'Tomsk Oblast', 'RU', 'TOM', 1),
(1873, 'Khabarovsk Krai', 'RU', 'KHA', 1),
(1874, 'Vologda Oblast', 'RU', 'VLG', 1),
(1875, 'Sakhalin', 'RU', 'SAK', 1),
(1876, 'Altai Republic', 'RU', 'AL', 1),
(1877, 'Republic of Khakassia', 'RU', 'KK', 1),
(1878, 'Tambov Oblast', 'RU', 'TAM', 1),
(1879, 'Saint Petersburg', 'RU', 'SPE', 1),
(1880, 'Irkutsk', 'RU', 'IRK', 1),
(1881, 'Vladimir Oblast', 'RU', 'VLA', 1),
(1882, 'Moscow Oblast', 'RU', 'MOS', 1),
(1883, 'Republic of Kalmykia', 'RU', 'KL', 1),
(1884, 'Republic of Ingushetia', 'RU', 'IN', 1),
(1885, 'Smolensk Oblast', 'RU', 'SMO', 1),
(1886, 'Orenburg Oblast', 'RU', 'ORE', 1),
(1887, 'Saratov Oblast', 'RU', 'SAR', 1),
(1888, 'Novosibirsk', 'RU', 'NVS', 1),
(1889, 'Lipetsk Oblast', 'RU', 'LIP', 1),
(1890, 'Kirov Oblast', 'RU', 'KIR', 1),
(1891, 'Krasnodar Krai', 'RU', 'KDA', 1),
(1892, 'Kabardino-Balkar Republic', 'RU', 'KB', 1),
(1893, 'Chechen Republic', 'RU', 'CE', 1),
(1894, 'Sverdlovsk', 'RU', 'SVE', 1),
(1895, 'Tula Oblast', 'RU', 'TUL', 1),
(1896, 'Leningrad Oblast', 'RU', 'LEN', 1),
(1897, 'Kemerovo Oblast', 'RU', 'KEM', 1),
(1898, 'Republic of Mordovia', 'RU', 'MO', 1),
(1899, 'Komi Republic', 'RU', 'KO', 1),
(1900, 'Tuva Republic', 'RU', 'TY', 1),
(1901, 'Moscow', 'RU', 'MOW', 1),
(1902, 'Kaliningrad', 'RU', 'KGD', 1),
(1903, 'Belgorod Oblast', 'RU', 'BEL', 1),
(1904, 'Zabaykalsky Krai', 'RU', 'ZAB', 1),
(1905, 'Ryazan Oblast', 'RU', 'RYA', 1),
(1906, 'Voronezh Oblast', 'RU', 'VOR', 1),
(1907, 'Tyumen Oblast', 'RU', 'TYU', 1),
(1908, 'Oryol Oblast', 'RU', 'ORL', 1),
(1909, 'Penza Oblast', 'RU', 'PNZ', 1),
(1910, 'Kostroma Oblast', 'RU', 'KOS', 1),
(1911, 'Altai Krai', 'RU', 'ALT', 1),
(1912, 'Sevastopol', 'RU', 'UA-40', 1),
(1913, 'Udmurt Republic', 'RU', 'UD', 1),
(1914, 'Chuvash Republic', 'RU', 'CU', 1),
(1915, 'Kurgan Oblast', 'RU', 'KGN', 1),
(1916, 'Lomaiviti', 'FJ', '06', 1),
(1917, 'Ba', 'FJ', '01', 1),
(1918, 'Tailevu', 'FJ', '14', 1),
(1919, 'Nadroga-Navosa', 'FJ', '08', 1),
(1920, 'Rewa', 'FJ', '12', 1),
(1921, 'Northern Division', 'FJ', 'N', 1),
(1922, 'Macuata', 'FJ', '07', 1),
(1923, 'Western Division', 'FJ', 'W', 1),
(1924, 'Cakaudrove', 'FJ', '03', 1),
(1925, 'Serua', 'FJ', '13', 1),
(1926, 'Ra', 'FJ', '11', 1),
(1927, 'Naitasiri', 'FJ', '09', 1),
(1928, 'Namosi', 'FJ', '10', 1),
(1929, 'Central Division', 'FJ', 'C', 1),
(1930, 'Bua', 'FJ', '02', 1),
(1931, 'Rotuma', 'FJ', 'R', 1),
(1932, 'Eastern Division', 'FJ', 'E', 1),
(1933, 'Lau', 'FJ', '05', 1),
(1934, 'Kadavu', 'FJ', '04', 1),
(1935, 'Labuan', 'MY', '15', 1),
(1936, 'Sabah', 'MY', '12', 1),
(1937, 'Sarawak', 'MY', '13', 1),
(1938, 'Perlis', 'MY', '09', 1),
(1939, 'Penang', 'MY', '07', 1),
(1940, 'Pahang', 'MY', '06', 1),
(1941, 'Malacca', 'MY', '04', 1),
(1942, 'Terengganu', 'MY', '11', 1),
(1943, 'Perak', 'MY', '08', 1),
(1944, 'Selangor', 'MY', '10', 1),
(1945, 'Putrajaya', 'MY', '16', 1),
(1946, 'Kelantan', 'MY', '03', 1),
(1947, 'Kedah', 'MY', '02', 1),
(1948, 'Negeri Sembilan', 'MY', '05', 1),
(1949, 'Kuala Lumpur', 'MY', '14', 1),
(1950, 'Johor', 'MY', '01', 1),
(1951, 'Mashonaland East Province', 'ZW', 'ME', 1),
(1952, 'Matabeleland South Province', 'ZW', 'MS', 1),
(1953, 'Mashonaland West Province', 'ZW', 'MW', 1),
(1954, 'Matabeleland North Province', 'ZW', 'MN', 1),
(1955, 'Mashonaland Central Province', 'ZW', 'MC', 1),
(1956, 'Bulawayo Province', 'ZW', 'BU', 1),
(1957, 'Midlands Province', 'ZW', 'MI', 1),
(1958, 'Harare Province', 'ZW', 'HA', 1),
(1959, 'Manicaland', 'ZW', 'MA', 1),
(1960, 'Masvingo Province', 'ZW', 'MV', 1),
(1961, 'Bulgan Province', 'MN', '067', 1),
(1962, 'Darkhan-Uul Province', 'MN', '037', 1),
(1963, 'Dornod Province', 'MN', '061', 1),
(1964, 'Khovd Province', 'MN', '043', 1),
(1965, 'Övörkhangai Province', 'MN', '055', 1),
(1966, 'Orkhon Province', 'MN', '035', 1),
(1967, 'Ömnögovi Province', 'MN', '053', 1),
(1968, 'Töv Province', 'MN', '047', 1),
(1969, 'Bayan-Ölgii Province', 'MN', '071', 1),
(1970, 'Dundgovi Province', 'MN', '059', 1),
(1971, 'Uvs Province', 'MN', '046', 1),
(1972, 'Govi-Altai Province', 'MN', '065', 1),
(1973, 'Arkhangai Province', 'MN', '073', 1),
(1974, 'Khentii Province', 'MN', '039', 1),
(1975, 'Khövsgöl Province', 'MN', '041', 1),
(1976, 'Bayankhongor Province', 'MN', '069', 1),
(1977, 'Sükhbaatar Province', 'MN', '051', 1),
(1978, 'Govisümber Province', 'MN', '064', 1),
(1979, 'Zavkhan Province', 'MN', '057', 1),
(1980, 'Selenge Province', 'MN', '049', 1),
(1981, 'Dornogovi Province', 'MN', '063', 1),
(1982, 'Northern Province', 'ZM', '05', 1),
(1983, 'Western Province', 'ZM', '01', 1),
(1984, 'Copperbelt Province', 'ZM', '08', 1),
(1985, 'Northwestern Province', 'ZM', '06', 1),
(1986, 'Central Province', 'ZM', '02', 1),
(1987, 'Luapula Province', 'ZM', '04', 1),
(1988, 'Lusaka Province', 'ZM', '09', 1),
(1989, 'Muchinga Province', 'ZM', '10', 1),
(1990, 'Southern Province', 'ZM', '07', 1),
(1991, 'Eastern Province', 'ZM', '03', 1),
(1992, 'Capital', 'BH', '13', 1),
(1993, 'Southern', 'BH', '14', 1),
(1994, 'Northern', 'BH', '17', 1),
(1995, 'Muharraq', 'BH', '15', 1),
(1996, 'Central', 'BH', '16', 1),
(1997, 'Rio de Janeiro', 'BR', 'RJ', 1),
(1998, 'Minas Gerais', 'BR', 'MG', 1),
(1999, 'Amapá', 'BR', 'AP', 1),
(2000, 'Goiás', 'BR', 'GO', 1),
(2001, 'Rio Grande do Sul', 'BR', 'RS', 1),
(2002, 'Bahia', 'BR', 'BA', 1),
(2003, 'Sergipe', 'BR', 'SE', 1),
(2004, 'Amazonas', 'BR', 'AM', 1),
(2005, 'Paraíba', 'BR', 'PB', 1),
(2006, 'Pernambuco', 'BR', 'PE', 1),
(2007, 'Alagoas', 'BR', 'AL', 1),
(2008, 'Piauí', 'BR', 'PI', 1),
(2009, 'Pará', 'BR', 'PA', 1),
(2010, 'Mato Grosso do Sul', 'BR', 'MS', 1),
(2011, 'Mato Grosso', 'BR', 'MT', 1),
(2012, 'Acre', 'BR', 'AC', 1),
(2013, 'Rondônia', 'BR', 'RO', 1),
(2014, 'Santa Catarina', 'BR', 'SC', 1),
(2015, 'Maranhão', 'BR', 'MA', 1),
(2016, 'Ceará', 'BR', 'CE', 1),
(2017, 'Distrito Federal', 'BR', 'DF', 1),
(2018, 'Espírito Santo', 'BR', 'ES', 1),
(2019, 'Rio Grande do Norte', 'BR', 'RN', 1),
(2020, 'Tocantins', 'BR', 'TO', 1),
(2021, 'São Paulo', 'BR', 'SP', 1),
(2022, 'Paraná', 'BR', 'PR', 1),
(2023, 'Aragatsotn Region', 'AM', 'AG', 1),
(2024, 'Ararat Province', 'AM', 'AR', 1),
(2025, 'Vayots Dzor Region', 'AM', 'VD', 1),
(2026, 'Armavir Region', 'AM', 'AV', 1),
(2027, 'Syunik Province', 'AM', 'SU', 1),
(2028, 'Gegharkunik Province', 'AM', 'GR', 1),
(2029, 'Lori Region', 'AM', 'LO', 1),
(2030, 'Yerevan', 'AM', 'ER', 1),
(2031, 'Shirak Region', 'AM', 'SH', 1),
(2032, 'Tavush Region', 'AM', 'TV', 1),
(2033, 'Kotayk Region', 'AM', 'KT', 1),
(2034, 'Cojedes', 'VE', 'H', 1),
(2035, 'Falcón', 'VE', 'I', 1),
(2036, 'Portuguesa', 'VE', 'P', 1),
(2037, 'Miranda', 'VE', 'M', 1),
(2038, 'Lara', 'VE', 'K', 1),
(2039, 'Bolívar', 'VE', 'F', 1),
(2040, 'Carabobo', 'VE', 'G', 1),
(2041, 'Yaracuy', 'VE', 'U', 1),
(2042, 'Zulia', 'VE', 'V', 1),
(2043, 'Trujillo', 'VE', 'T', 1),
(2044, 'Amazonas', 'VE', 'Z', 1),
(2045, 'Guárico', 'VE', 'J', 1),
(2046, 'Federal Dependencies of Venezuela', 'VE', 'W', 1),
(2047, 'Aragua', 'VE', 'D', 1),
(2048, 'Táchira', 'VE', 'S', 1),
(2049, 'Barinas', 'VE', 'E', 1),
(2050, 'Anzoátegui', 'VE', 'B', 1),
(2051, 'Delta Amacuro', 'VE', 'Y', 1),
(2052, 'Nueva Esparta', 'VE', 'O', 1),
(2053, 'Mérida', 'VE', 'L', 1),
(2054, 'Monagas', 'VE', 'N', 1),
(2055, 'La Guaira', 'VE', 'X', 1),
(2056, 'Sucre', 'VE', 'R', 1),
(2057, 'Carinthia', 'AT', '2', 1),
(2058, 'Upper Austria', 'AT', '4', 1),
(2059, 'Styria', 'AT', '6', 1),
(2060, 'Vienna', 'AT', '9', 1),
(2061, 'Salzburg', 'AT', '5', 1),
(2062, 'Burgenland', 'AT', '1', 1),
(2063, 'Vorarlberg', 'AT', '8', 1),
(2064, 'Tyrol', 'AT', '7', 1),
(2065, 'Lower Austria', 'AT', '3', 1),
(2066, 'Mid-Western Region', 'NP', '2', 1),
(2067, 'Western Region', 'NP', '3', 1),
(2068, 'Far-Western Development Region', 'NP', '5', 1),
(2069, 'Eastern Development Region', 'NP', '4', 1),
(2070, 'Mechi Zone', 'NP', 'ME', 1),
(2071, 'Bheri Zone', 'NP', 'BH', 1),
(2072, 'Kosi Zone', 'NP', 'KO', 1),
(2073, 'Central Region', 'NP', '1', 1),
(2074, 'Lumbini Zone', 'NP', 'LU', 1),
(2075, 'Narayani Zone', 'NP', 'NA', 1),
(2076, 'Janakpur Zone', 'NP', 'JA', 1),
(2077, 'Rapti Zone', 'NP', 'RA', 1),
(2078, 'Seti Zone', 'NP', 'SE', 1),
(2079, 'Karnali Zone', 'NP', 'KA', 1),
(2080, 'Dhaulagiri Zone', 'NP', 'DH', 1),
(2081, 'Gandaki Zone', 'NP', 'GA', 1),
(2082, 'Bagmati Zone', 'NP', 'BA', 1),
(2083, 'Mahakali Zone', 'NP', 'MA', 1),
(2084, 'Sagarmatha Zone', 'NP', 'SA', 1),
(2085, 'Unity', 'SS', 'UY', 1),
(2086, 'Upper Nile', 'SS', 'NU', 1),
(2087, 'Warrap', 'SS', 'WR', 1),
(2088, 'Northern Bahr el Ghazal', 'SS', 'BN', 1),
(2089, 'Western Equatoria', 'SS', 'EW', 1),
(2090, 'Lakes', 'SS', 'LK', 1),
(2091, 'Western Bahr el Ghazal', 'SS', 'BW', 1),
(2092, 'Central Equatoria', 'SS', 'EC', 1),
(2093, 'Eastern Equatoria', 'SS', 'EE', 1),
(2094, 'Jonglei State', 'SS', 'JG', 1),
(2095, 'Karditsa Regional Unit', 'GR', '41', 1),
(2096, 'West Greece Region', 'GR', 'G', 1),
(2097, 'Thessaloniki Regional Unit', 'GR', '54', 1),
(2098, 'Arcadia Prefecture', 'GR', '12', 1),
(2099, 'Imathia Regional Unit', 'GR', '53', 1),
(2100, 'Kastoria Regional Unit', 'GR', '56', 1),
(2101, 'Euboea', 'GR', '04', 1),
(2102, 'Grevena Prefecture', 'GR', '51', 1),
(2103, 'Preveza Prefecture', 'GR', '34', 1),
(2104, 'Lefkada Regional Unit', 'GR', '24', 1),
(2105, 'Argolis Regional Unit', 'GR', '11', 1),
(2106, 'Laconia', 'GR', '16', 1),
(2107, 'Pella Regional Unit', 'GR', '59', 1),
(2108, 'West Macedonia Region', 'GR', 'C', 1),
(2109, 'Crete Region', 'GR', 'M', 1),
(2110, 'Epirus Region', 'GR', 'D', 1),
(2111, 'Kilkis Regional Unit', 'GR', '57', 1),
(2112, 'Kozani Prefecture', 'GR', '58', 1),
(2113, 'Ioannina Regional Unit', 'GR', '33', 1),
(2114, 'Phthiotis Prefecture', 'GR', '06', 1),
(2115, 'Chania Regional Unit', 'GR', '94', 1),
(2116, 'Achaea Regional Unit', 'GR', '13', 1),
(2117, 'East Macedonia and Thrace', 'GR', 'A', 1),
(2118, 'South Aegean', 'GR', 'L', 1),
(2119, 'Peloponnese Region', 'GR', 'J', 1),
(2120, 'East Attica Regional Unit', 'GR', 'A2', 1),
(2121, 'Serres Prefecture', 'GR', '62', 1),
(2122, 'Attica Region', 'GR', 'I', 1),
(2123, 'Aetolia-Acarnania Regional Unit', 'GR', '01', 1),
(2124, 'Corfu Prefecture', 'GR', '22', 1),
(2125, 'Central Macedonia', 'GR', 'B', 1),
(2126, 'Boeotia Regional Unit', 'GR', '03', 1),
(2127, 'Kefalonia Prefecture', 'GR', '23', 1),
(2128, 'Central Greece Region', 'GR', 'H', 1),
(2129, 'Corinthia Regional Unit', 'GR', '15', 1),
(2130, 'Drama Regional Unit', 'GR', '52', 1),
(2131, 'Ionian Islands Region', 'GR', 'F', 1),
(2132, 'Larissa Prefecture', 'GR', '42', 1),
(2133, 'Kayin State', 'MM', '13', 1),
(2134, 'Mandalay Region', 'MM', '04', 1),
(2135, 'Yangon Region', 'MM', '06', 1),
(2136, 'Magway Region', 'MM', '03', 1),
(2137, 'Chin State', 'MM', '14', 1),
(2138, 'Rakhine State', 'MM', '16', 1),
(2139, 'Shan State', 'MM', '17', 1),
(2140, 'Tanintharyi Region', 'MM', '05', 1),
(2141, 'Bago', 'MM', '02', 1),
(2142, 'Ayeyarwady Region', 'MM', '07', 1),
(2143, 'Kachin State', 'MM', '11', 1),
(2144, 'Kayah State', 'MM', '12', 1),
(2145, 'Sagaing Region', 'MM', '01', 1),
(2146, 'Naypyidaw Union Territory', 'MM', '18', 1),
(2147, 'Mon State', 'MM', '15', 1),
(2148, 'Bartın', 'TR', '74', 1),
(2149, 'Kütahya', 'TR', '43', 1),
(2150, 'Sakarya', 'TR', '54', 1),
(2151, 'Edirne', 'TR', '22', 1),
(2152, 'Van', 'TR', '65', 1),
(2153, 'Bingöl', 'TR', '12', 1),
(2154, 'Kilis', 'TR', '79', 1),
(2155, 'Adıyaman', 'TR', '02', 1),
(2156, 'Mersin', 'TR', '33', 1),
(2157, 'Denizli', 'TR', '20', 1),
(2158, 'Malatya', 'TR', '44', 1),
(2159, 'Elazığ', 'TR', '23', 1),
(2160, 'Erzincan', 'TR', '24', 1),
(2161, 'Amasya', 'TR', '05', 1),
(2162, 'Muş', 'TR', '49', 1),
(2163, 'Bursa', 'TR', '16', 1),
(2164, 'Eskişehir', 'TR', '26', 1),
(2165, 'Erzurum', 'TR', '25', 1),
(2166, 'Iğdır', 'TR', '76', 1),
(2167, 'Tekirdağ', 'TR', '59', 1),
(2168, 'Çankırı', 'TR', '18', 1),
(2169, 'Antalya', 'TR', '07', 1),
(2170, 'Istanbul', 'TR', '34', 1),
(2171, 'Konya', 'TR', '42', 1),
(2172, 'Bolu', 'TR', '14', 1),
(2173, 'Çorum', 'TR', '19', 1),
(2174, 'Ordu', 'TR', '52', 1),
(2175, 'Balıkesir', 'TR', '10', 1),
(2176, 'Kırklareli', 'TR', '39', 1),
(2177, 'Bayburt', 'TR', '69', 1),
(2178, 'Kırıkkale', 'TR', '71', 1),
(2179, 'Afyonkarahisar', 'TR', '03', 1),
(2180, 'Kırşehir', 'TR', '40', 1),
(2181, 'Sivas', 'TR', '58', 1),
(2182, 'Muğla', 'TR', '48', 1),
(2183, 'Şanlıurfa', 'TR', '63', 1),
(2184, 'Karaman', 'TR', '70', 1),
(2185, 'Ardahan', 'TR', '75', 1),
(2186, 'Giresun', 'TR', '28', 1),
(2187, 'Aydın', 'TR', '09', 1),
(2188, 'Yozgat', 'TR', '66', 1),
(2189, 'Niğde', 'TR', '51', 1),
(2190, 'Hakkâri', 'TR', '30', 1),
(2191, 'Artvin', 'TR', '08', 1),
(2192, 'Tunceli', 'TR', '62', 1),
(2193, 'Ağrı', 'TR', '04', 1),
(2194, 'Batman', 'TR', '72', 1),
(2195, 'Kocaeli', 'TR', '41', 1),
(2196, 'Nevşehir', 'TR', '50', 1),
(2197, 'Kastamonu', 'TR', '37', 1),
(2198, 'Manisa', 'TR', '45', 1),
(2199, 'Tokat', 'TR', '60', 1),
(2200, 'Kayseri', 'TR', '38', 1),
(2201, 'Uşak', 'TR', '64', 1),
(2202, 'Düzce', 'TR', '81', 1),
(2203, 'Gaziantep', 'TR', '27', 1),
(2204, 'Gümüşhane', 'TR', '29', 1),
(2205, 'İzmir', 'TR', '35', 1),
(2206, 'Trabzon', 'TR', '61', 1),
(2207, 'Siirt', 'TR', '56', 1),
(2208, 'Kars', 'TR', '36', 1),
(2209, 'Burdur', 'TR', '15', 1),
(2210, 'Aksaray', 'TR', '68', 1),
(2211, 'Hatay', 'TR', '31', 1),
(2212, 'Adana', 'TR', '01', 1),
(2213, 'Zonguldak', 'TR', '67', 1),
(2214, 'Osmaniye', 'TR', '80', 1),
(2215, 'Bitlis', 'TR', '13', 1),
(2216, 'Çanakkale', 'TR', '17', 1),
(2217, 'Ankara', 'TR', '06', 1),
(2218, 'Yalova', 'TR', '77', 1),
(2219, 'Rize', 'TR', '53', 1),
(2220, 'Samsun', 'TR', '55', 1),
(2221, 'Bilecik', 'TR', '11', 1),
(2222, 'Isparta', 'TR', '32', 1),
(2223, 'Karabük', 'TR', '78', 1),
(2224, 'Mardin', 'TR', '47', 1),
(2225, 'Şırnak', 'TR', '73', 1),
(2226, 'Diyarbakır', 'TR', '21', 1),
(2227, 'Kahramanmaraş', 'TR', '46', 1),
(2228, 'Lisbon', 'PT', '11', 1),
(2229, 'Bragança', 'PT', '04', 1),
(2230, 'Beja', 'PT', '02', 1),
(2231, 'Madeira', 'PT', '30', 1),
(2232, 'Portalegre', 'PT', '12', 1),
(2233, 'Açores', 'PT', '20', 1),
(2234, 'Vila Real', 'PT', '17', 1),
(2235, 'Aveiro', 'PT', '01', 1),
(2236, 'Évora', 'PT', '07', 1),
(2237, 'Viseu', 'PT', '18', 1),
(2238, 'Santarém', 'PT', '14', 1),
(2239, 'Faro', 'PT', '08', 1),
(2240, 'Leiria', 'PT', '10', 1),
(2241, 'Castelo Branco', 'PT', '05', 1),
(2242, 'Setúbal', 'PT', '15', 1),
(2243, 'Porto', 'PT', '13', 1),
(2244, 'Braga', 'PT', '03', 1),
(2245, 'Viana do Castelo', 'PT', '16', 1),
(2246, 'Coimbra', 'PT', '06', 1),
(2247, 'Zhejiang', 'CN', 'ZJ', 1),
(2248, 'Fujian', 'CN', 'FJ', 1),
(2249, 'Shanghai', 'CN', 'SH', 1),
(2250, 'Jiangsu', 'CN', 'JS', 1),
(2251, 'Anhui', 'CN', 'AH', 1),
(2252, 'Shandong', 'CN', 'SD', 1),
(2253, 'Jilin', 'CN', 'JL', 1),
(2254, 'Shanxi', 'CN', 'SX', 1),
(2255, 'Taiwan', 'CN', 'TW', 1),
(2256, 'Jiangxi', 'CN', 'JX', 1),
(2257, 'Beijing', 'CN', 'BJ', 1),
(2258, 'Hunan', 'CN', 'HN', 1),
(2259, 'Henan', 'CN', 'HA', 1),
(2260, 'Yunnan', 'CN', 'YN', 1),
(2261, 'Guizhou', 'CN', 'GZ', 1),
(2262, 'Ningxia Huizu', 'CN', 'NX', 1),
(2263, 'Xinjiang', 'CN', 'XJ', 1),
(2264, 'Xizang', 'CN', 'XZ', 1),
(2265, 'Heilongjiang', 'CN', 'HL', 1),
(2266, 'Macau SAR', 'CN', 'MO', 1),
(2267, 'Hong Kong SAR', 'CN', 'HK', 1),
(2268, 'Liaoning', 'CN', 'LN', 1),
(2269, 'Inner Mongolia', 'CN', 'NM', 1),
(2270, 'Qinghai', 'CN', 'QH', 1),
(2271, 'Chongqing', 'CN', 'CQ', 1),
(2272, 'Shaanxi', 'CN', 'SN', 1),
(2273, 'Hainan', 'CN', 'HI', 1),
(2274, 'Hubei', 'CN', 'HB', 1),
(2275, 'Gansu', 'CN', 'GS', 1),
(2276, 'Tianjin', 'CN', 'TJ', 1),
(2277, 'Sichuan', 'CN', 'SC', 1),
(2278, 'Guangxi Zhuang', 'CN', 'GX', 1),
(2279, 'Guangdong', 'CN', 'GD', 1),
(2280, 'Hebei', 'CN', 'HE', 1),
(2281, 'South', 'LB', 'JA', 1),
(2282, 'Mount Lebanon', 'LB', 'JL', 1),
(2283, 'Baalbek-Hermel', 'LB', 'BH', 1),
(2284, 'North', 'LB', 'AS', 1),
(2285, 'Akkar', 'LB', 'AK', 1),
(2286, 'Beirut', 'LB', 'BA', 1),
(2287, 'Beqaa', 'LB', 'BI', 1),
(2288, 'Nabatieh', 'LB', 'NA', 1),
(2289, 'Isle of Wight', 'GB', 'IOW', 1),
(2290, 'St Helens', 'GB', 'SHN', 1),
(2291, 'London Borough of Brent', 'GB', 'BEN', 1),
(2292, 'Walsall', 'GB', 'WLL', 1),
(2293, 'Trafford', 'GB', 'TRF', 1),
(2294, 'City of Southampton', 'GB', 'STH', 1),
(2295, 'Sheffield', 'GB', 'SHF', 1),
(2296, 'West Sussex', 'GB', 'WSX', 1),
(2297, 'City of Peterborough', 'GB', 'PTE', 1),
(2298, 'Caerphilly County Borough', 'GB', 'CAY', 1),
(2299, 'Vale of Glamorgan', 'GB', 'VGL', 1),
(2300, 'Shetland Islands', 'GB', 'ZET', 1),
(2301, 'Rhondda Cynon Taf', 'GB', 'RCT', 1),
(2302, 'Poole', 'GB', 'POL', 1),
(2303, 'Central Bedfordshire', 'GB', 'CBF', 1),
(2304, 'Down District Council', 'GB', 'DOW', 1),
(2305, 'City of Portsmouth', 'GB', 'POR', 1),
(2306, 'London Borough of Haringey', 'GB', 'HRY', 1),
(2307, 'London Borough of Bexley', 'GB', 'BEX', 1),
(2308, 'Rotherham', 'GB', 'ROT', 1),
(2309, 'Hartlepool', 'GB', 'HPL', 1),
(2310, 'Telford and Wrekin', 'GB', 'TFW', 1),
(2311, 'Belfast district', 'GB', 'BFS', 1),
(2312, 'Cornwall', 'GB', 'CON', 1),
(2313, 'London Borough of Sutton', 'GB', 'STN', 1),
(2314, 'Omagh District Council', 'GB', 'OMH', 1),
(2315, 'Banbridge', 'GB', 'BNB', 1),
(2316, 'Causeway Coast and Glens', 'GB', 'CCG', 1),
(2317, 'Newtownabbey Borough Council', 'GB', 'NTA', 1),
(2318, 'City of Leicester', 'GB', 'LCE', 1),
(2319, 'London Borough of Islington', 'GB', 'ISL', 1),
(2320, 'Metropolitan Borough of Wigan', 'GB', 'WGN', 1),
(2321, 'Oxfordshire', 'GB', 'OXF', 1),
(2322, 'Magherafelt District Council', 'GB', 'MFT', 1),
(2323, 'Southend-on-Sea', 'GB', 'SOS', 1),
(2324, 'Armagh, Banbridge and Craigavon', 'GB', 'ABC', 1),
(2325, 'Perth and Kinross', 'GB', 'PKN', 1),
(2326, 'London Borough of Waltham Forest', 'GB', 'WFT', 1),
(2327, 'Rochdale', 'GB', 'RCH', 1),
(2328, 'Merthyr Tydfil County Borough', 'GB', 'MTY', 1),
(2329, 'Blackburn with Darwen', 'GB', 'BBD', 1),
(2330, 'Knowsley', 'GB', 'KWL', 1),
(2331, 'Armagh City and District Council', 'GB', 'ARM', 1),
(2332, 'Middlesbrough', 'GB', 'MDB', 1),
(2333, 'East Renfrewshire', 'GB', 'ERW', 1),
(2334, 'Cumbria', 'GB', 'CMA', 1),
(2335, 'Scotland', 'GB', 'SCT', 1),
(2336, 'England', 'GB', 'ENG', 1),
(2337, 'Northern Ireland', 'GB', 'NIR', 1),
(2338, 'Wales', 'GB', 'WLS', 1),
(2339, 'Bath and North East Somerset', 'GB', 'BAS', 1),
(2340, 'Liverpool', 'GB', 'LIV', 1),
(2341, 'Sandwell', 'GB', 'SAW', 1),
(2342, 'Bournemouth', 'GB', 'BMH', 1),
(2343, 'Isles of Scilly', 'GB', 'IOS', 1),
(2344, 'Falkirk', 'GB', 'FAL', 1),
(2345, 'Dorset', 'GB', 'DOR', 1),
(2346, 'Scottish Borders', 'GB', 'SCB', 1),
(2347, 'London Borough of Havering', 'GB', 'HAV', 1),
(2348, 'Moyle District Council', 'GB', 'MYL', 1),
(2349, 'London Borough of Camden', 'GB', 'CMD', 1),
(2350, 'Newry and Mourne District Council', 'GB', 'NYM', 1),
(2351, 'Neath Port Talbot County Borough', 'GB', 'NTL', 1),
(2352, 'Conwy County Borough', 'GB', 'CWY', 1),
(2353, 'Outer Hebrides', 'GB', 'ELS', 1),
(2354, 'West Lothian', 'GB', 'WLN', 1),
(2355, 'Lincolnshire', 'GB', 'LIN', 1),
(2356, 'London Borough of Barking and Dagenham', 'GB', 'BDG', 1),
(2357, 'City of Westminster', 'GB', 'WSM', 1),
(2358, 'London Borough of Lewisham', 'GB', 'LEW', 1),
(2359, 'City of Nottingham', 'GB', 'NGM', 1),
(2360, 'Moray', 'GB', 'MRY', 1),
(2361, 'Ballymoney', 'GB', 'BLY', 1),
(2362, 'South Lanarkshire', 'GB', 'SLK', 1),
(2363, 'Ballymena Borough', 'GB', 'BLA', 1),
(2364, 'Doncaster', 'GB', 'DNC', 1),
(2365, 'Northumberland', 'GB', 'NBL', 1),
(2366, 'Fermanagh and Omagh', 'GB', 'FMO', 1),
(2367, 'Tameside', 'GB', 'TAM', 1),
(2368, 'Royal Borough of Kensington and Chelsea', 'GB', 'KEC', 1),
(2369, 'Hertfordshire', 'GB', 'HRT', 1),
(2370, 'East Riding of Yorkshire', 'GB', 'ERY', 1),
(2371, 'Kirklees', 'GB', 'KIR', 1),
(2372, 'City of Sunderland', 'GB', 'SND', 1),
(2373, 'Gloucestershire', 'GB', 'GLS', 1),
(2374, 'East Ayrshire', 'GB', 'EAY', 1),
(2375, 'United Kingdom', 'GB', 'UKM', 1),
(2376, 'London Borough of Hillingdon', 'GB', 'HIL', 1),
(2377, 'South Ayrshire', 'GB', 'SAY', 1),
(2378, 'Ascension Island', 'GB', 'SH-AC', 1),
(2379, 'Gwynedd', 'GB', 'GWN', 1),
(2380, 'London Borough of Hounslow', 'GB', 'HNS', 1),
(2381, 'Medway', 'GB', 'MDW', 1),
(2382, 'Limavady Borough Council', 'GB', 'LMV', 1),
(2383, 'Highland', 'GB', 'HLD', 1),
(2384, 'North East Lincolnshire', 'GB', 'NEL', 1),
(2385, 'London Borough of Harrow', 'GB', 'HRW', 1),
(2386, 'Somerset', 'GB', 'SOM', 1),
(2387, 'Angus', 'GB', 'ANS', 1),
(2388, 'Inverclyde', 'GB', 'IVC', 1),
(2389, 'Darlington', 'GB', 'DAL', 1),
(2390, 'London Borough of Tower Hamlets', 'GB', 'TWH', 1),
(2391, 'Wiltshire', 'GB', 'WIL', 1),
(2392, 'Argyll and Bute', 'GB', 'AGB', 1),
(2393, 'Strabane District Council', 'GB', 'STB', 1),
(2394, 'Stockport', 'GB', 'SKP', 1),
(2395, 'Brighton and Hove', 'GB', 'BNH', 1),
(2396, 'London Borough of Lambeth', 'GB', 'LBH', 1),
(2397, 'London Borough of Redbridge', 'GB', 'RDB', 1),
(2398, 'Manchester', 'GB', 'MAN', 1),
(2399, 'Mid Ulster', 'GB', 'MUL', 1),
(2400, 'South Gloucestershire', 'GB', 'SGC', 1),
(2401, 'Aberdeenshire', 'GB', 'ABD', 1),
(2402, 'Monmouthshire', 'GB', 'MON', 1),
(2403, 'Derbyshire', 'GB', 'DBY', 1),
(2404, 'Glasgow', 'GB', 'GLG', 1),
(2405, 'Buckinghamshire', 'GB', 'BKM', 1),
(2406, 'County Durham', 'GB', 'DUR', 1),
(2407, 'Shropshire', 'GB', 'SHR', 1),
(2408, 'Wirral', 'GB', 'WRL', 1),
(2409, 'South Tyneside', 'GB', 'STY', 1),
(2410, 'Essex', 'GB', 'ESS', 1),
(2411, 'London Borough of Hackney', 'GB', 'HCK', 1),
(2412, 'Antrim and Newtownabbey', 'GB', 'ANN', 1),
(2413, 'City of Bristol', 'GB', 'BST', 1),
(2414, 'East Sussex', 'GB', 'ESX', 1),
(2415, 'Dumfries and Galloway', 'GB', 'DGY', 1),
(2416, 'Milton Keynes', 'GB', 'MIK', 1),
(2417, 'Derry City Council', 'GB', 'DRY', 1),
(2418, 'London Borough of Newham', 'GB', 'NWM', 1),
(2419, 'Wokingham', 'GB', 'WOK', 1),
(2420, 'Warrington', 'GB', 'WRT', 1),
(2421, 'Stockton-on-Tees', 'GB', 'STT', 1),
(2422, 'Swindon', 'GB', 'SWD', 1),
(2423, 'Cambridgeshire', 'GB', 'CAM', 1),
(2424, 'City of London', 'GB', 'LND', 1),
(2425, 'Birmingham', 'GB', 'BIR', 1),
(2426, 'City of York', 'GB', 'YOR', 1),
(2427, 'Slough', 'GB', 'SLG', 1),
(2428, 'Edinburgh', 'GB', 'EDH', 1),
(2429, 'Mid and East Antrim', 'GB', 'MEA', 1),
(2430, 'North Somerset', 'GB', 'NSM', 1),
(2431, 'Gateshead', 'GB', 'GAT', 1),
(2432, 'London Borough of Southwark', 'GB', 'SWK', 1),
(2433, 'City and County of Swansea', 'GB', 'SWA', 1),
(2434, 'London Borough of Wandsworth', 'GB', 'WND', 1),
(2435, 'Hampshire', 'GB', 'HAM', 1),
(2436, 'Wrexham County Borough', 'GB', 'WRX', 1),
(2437, 'Flintshire', 'GB', 'FLN', 1),
(2438, 'Coventry', 'GB', 'COV', 1),
(2439, 'Carrickfergus Borough Council', 'GB', 'CKF', 1),
(2440, 'West Dunbartonshire', 'GB', 'WDU', 1),
(2441, 'Powys', 'GB', 'POW', 1),
(2442, 'Cheshire West and Chester', 'GB', 'CHW', 1),
(2443, 'Renfrewshire', 'GB', 'RFW', 1),
(2444, 'Cheshire East', 'GB', 'CHE', 1),
(2445, 'Cookstown District Council', 'GB', 'CKT', 1),
(2446, 'Derry City and Strabane', 'GB', 'DRS', 1),
(2447, 'Staffordshire', 'GB', 'STS', 1),
(2448, 'London Borough of Hammersmith and Fulham', 'GB', 'HMF', 1),
(2449, 'Craigavon Borough Council', 'GB', 'CGV', 1),
(2450, 'Clackmannanshire', 'GB', 'CLK', 1),
(2451, 'Blackpool', 'GB', 'BPL', 1),
(2452, 'Bridgend County Borough', 'GB', 'BGE', 1),
(2453, 'North Lincolnshire', 'GB', 'NLN', 1),
(2454, 'East Dunbartonshire', 'GB', 'EDU', 1),
(2455, 'Reading', 'GB', 'RDG', 1),
(2456, 'Nottinghamshire', 'GB', 'NTT', 1),
(2457, 'Dudley', 'GB', 'DUD', 1),
(2458, 'Newcastle upon Tyne', 'GB', 'NET', 1),
(2459, 'Bury', 'GB', 'BUR', 1),
(2460, 'Lisburn and Castlereagh', 'GB', 'LBC', 1),
(2461, 'Coleraine Borough Council', 'GB', 'CLR', 1),
(2462, 'East Lothian', 'GB', 'ELN', 1),
(2463, 'Aberdeen', 'GB', 'ABE', 1),
(2464, 'Kent', 'GB', 'KEN', 1),
(2465, 'Wakefield', 'GB', 'WKF', 1),
(2466, 'Halton', 'GB', 'HAL', 1),
(2467, 'Suffolk', 'GB', 'SFK', 1),
(2468, 'Thurrock', 'GB', 'THR', 1),
(2469, 'Solihull', 'GB', 'SOL', 1),
(2470, 'Bracknell Forest', 'GB', 'BRC', 1),
(2471, 'West Berkshire', 'GB', 'WBK', 1),
(2472, 'Rutland', 'GB', 'RUT', 1),
(2473, 'Norfolk', 'GB', 'NFK', 1),
(2474, 'Orkney Islands', 'GB', 'ORK', 1),
(2475, 'City of Kingston upon Hull', 'GB', 'KHL', 1),
(2476, 'London Borough of Enfield', 'GB', 'ENF', 1),
(2477, 'Oldham', 'GB', 'OLD', 1),
(2478, 'Torbay', 'GB', 'TOB', 1),
(2479, 'Fife', 'GB', 'FIF', 1),
(2480, 'Northamptonshire', 'GB', 'NTH', 1),
(2481, 'Royal Borough of Kingston upon Thames', 'GB', 'KTT', 1),
(2482, 'Windsor and Maidenhead', 'GB', 'WNM', 1),
(2483, 'London Borough of Merton', 'GB', 'MRT', 1),
(2484, 'Carmarthenshire', 'GB', 'CMN', 1),
(2485, 'City of Derby', 'GB', 'DER', 1),
(2486, 'Pembrokeshire', 'GB', 'PEM', 1),
(2487, 'North Lanarkshire', 'GB', 'NLK', 1),
(2488, 'Stirling', 'GB', 'STG', 1),
(2489, 'City of Wolverhampton', 'GB', 'WLV', 1),
(2490, 'London Borough of Bromley', 'GB', 'BRY', 1),
(2491, 'Devon', 'GB', 'DEV', 1),
(2492, 'Royal Borough of Greenwich', 'GB', 'GRE', 1),
(2493, 'Salford', 'GB', 'SLF', 1),
(2494, 'Lisburn City Council', 'GB', 'LSB', 1),
(2495, 'Lancashire', 'GB', 'LAN', 1),
(2496, 'Torfaen', 'GB', 'TOF', 1),
(2497, 'Denbighshire', 'GB', 'DEN', 1),
(2498, 'Ards', 'GB', 'ARD', 1),
(2499, 'Barnsley', 'GB', 'BNS', 1),
(2500, 'Herefordshire', 'GB', 'HEF', 1),
(2501, 'London Borough of Richmond upon Thames', 'GB', 'RIC', 1),
(2502, 'Saint Helena', 'GB', 'SH-HL', 1),
(2503, 'Leeds', 'GB', 'LDS', 1),
(2504, 'Bolton', 'GB', 'BOL', 1),
(2505, 'Warwickshire', 'GB', 'WAR', 1),
(2506, 'City of Stoke-on-Trent', 'GB', 'STE', 1),
(2507, 'Bedford', 'GB', 'BDF', 1),
(2508, 'Dungannon and South Tyrone Borough Council', 'GB', 'DGN', 1),
(2509, 'Ceredigion', 'GB', 'CGN', 1),
(2510, 'Worcestershire', 'GB', 'WOR', 1),
(2511, 'Dundee', 'GB', 'DND', 1),
(2512, 'London Borough of Croydon', 'GB', 'CRY', 1),
(2513, 'North Down Borough Council', 'GB', 'NDN', 1),
(2514, 'City of Plymouth', 'GB', 'PLY', 1),
(2515, 'Larne Borough Council', 'GB', 'LRN', 1),
(2516, 'Leicestershire', 'GB', 'LEC', 1),
(2517, 'Calderdale', 'GB', 'CLD', 1),
(2518, 'Sefton', 'GB', 'SFT', 1),
(2519, 'Midlothian', 'GB', 'MLN', 1),
(2520, 'London Borough of Barnet', 'GB', 'BNE', 1),
(2521, 'North Tyneside', 'GB', 'NTY', 1),
(2522, 'North Yorkshire', 'GB', 'NYK', 1),
(2523, 'Ards and North Down', 'GB', 'AND', 1),
(2524, 'Newport', 'GB', 'NWP', 1),
(2525, 'Castlereagh', 'GB', 'CSR', 1),
(2526, 'Surrey', 'GB', 'SRY', 1),
(2527, 'Redcar and Cleveland', 'GB', 'RCC', 1),
(2528, 'City and County of Cardiff', 'GB', 'CRF', 1),
(2529, 'Bradford', 'GB', 'BRD', 1),
(2530, 'Blaenau Gwent County Borough', 'GB', 'BGW', 1),
(2531, 'Fermanagh District Council', 'GB', 'FER', 1),
(2532, 'London Borough of Ealing', 'GB', 'EAL', 1),
(2533, 'Antrim', 'GB', 'ANT', 1),
(2534, 'Newry, Mourne and Down', 'GB', 'NMD', 1),
(2535, 'North Ayrshire', 'GB', 'NAY', 1),
(2536, 'Tashkent', 'UZ', 'TK', 1),
(2537, 'Namangan Region', 'UZ', 'NG', 1),
(2538, 'Fergana Region', 'UZ', 'FA', 1),
(2539, 'Xorazm Region', 'UZ', 'XO', 1),
(2540, 'Andijan Region', 'UZ', 'AN', 1),
(2541, 'Bukhara Region', 'UZ', 'BU', 1),
(2542, 'Navoiy Region', 'UZ', 'NW', 1),
(2543, 'Qashqadaryo Region', 'UZ', 'QA', 1),
(2544, 'Samarqand Region', 'UZ', 'SA', 1),
(2545, 'Jizzakh Region', 'UZ', 'JI', 1),
(2546, 'Surxondaryo Region', 'UZ', 'SU', 1),
(2547, 'Sirdaryo Region', 'UZ', 'SI', 1),
(2548, 'Karakalpakstan', 'UZ', 'QR', 1),
(2549, 'Tashkent Region', 'UZ', 'TO', 1),
(2550, 'Ariana', 'TN', '12', 1),
(2551, 'Bizerte', 'TN', '23', 1),
(2552, 'Jendouba', 'TN', '32', 1),
(2553, 'Monastir', 'TN', '52', 1),
(2554, 'Tunis', 'TN', '11', 1),
(2555, 'Manouba', 'TN', '14', 1),
(2556, 'Gafsa', 'TN', '71', 1),
(2557, 'Sfax', 'TN', '61', 1),
(2558, 'Gabès', 'TN', '81', 1),
(2559, 'Tataouine', 'TN', '83', 1),
(2560, 'Medenine', 'TN', '82', 1),
(2561, 'Kef', 'TN', '33', 1),
(2562, 'Kebili', 'TN', '73', 1),
(2563, 'Siliana', 'TN', '34', 1),
(2564, 'Kairouan', 'TN', '41', 1),
(2565, 'Zaghouan', 'TN', '22', 1),
(2566, 'Ben Arous', 'TN', '13', 1),
(2567, 'Sidi Bouzid', 'TN', '43', 1),
(2568, 'Mahdia', 'TN', '53', 1),
(2569, 'Tozeur', 'TN', '72', 1),
(2570, 'Kasserine', 'TN', '42', 1),
(2571, 'Sousse', 'TN', '51', 1),
(2572, 'Kassrine', 'TN', '31', 1),
(2573, 'Ratak Chain', 'MH', 'T', 1),
(2574, 'Ralik Chain', 'MH', 'L', 1),
(2575, 'Centrale Region', 'TG', 'C', 1),
(2576, 'Maritime', 'TG', 'M', 1),
(2577, 'Plateaux Region', 'TG', 'P', 1),
(2578, 'Savanes Region', 'TG', 'S', 1),
(2579, 'Kara Region', 'TG', 'K', 1),
(2580, 'Chuuk State', 'FM', 'TRK', 1),
(2581, 'Pohnpei State', 'FM', 'PNI', 1),
(2582, 'Yap State', 'FM', 'YAP', 1),
(2583, 'Kosrae State', 'FM', 'KSA', 1),
(2584, 'Vaavu Atoll', 'MV', '04', 1),
(2585, 'Shaviyani Atoll', 'MV', '24', 1),
(2586, 'Haa Alif Atoll', 'MV', '07', 1),
(2587, 'Alif Alif Atoll', 'MV', '02', 1),
(2588, 'North Province', 'MV', 'NO', 1),
(2589, 'North Central Province', 'MV', 'NC', 1),
(2590, 'Dhaalu Atoll', 'MV', '17', 1),
(2591, 'Thaa Atoll', 'MV', '08', 1),
(2592, 'Noonu Atoll', 'MV', '25', 1),
(2593, 'Upper South Province', 'MV', 'US', 1),
(2594, 'Addu Atoll', 'MV', '01', 1),
(2595, 'Gnaviyani Atoll', 'MV', '29', 1),
(2596, 'Kaafu Atoll', 'MV', '26', 1),
(2597, 'Haa Dhaalu Atoll', 'MV', '23', 1),
(2598, 'Gaafu Alif Atoll', 'MV', '27', 1),
(2599, 'Faafu Atoll', 'MV', '14', 1),
(2600, 'Alif Dhaal Atoll', 'MV', '00', 1),
(2601, 'Laamu Atoll', 'MV', '05', 1),
(2602, 'Raa Atoll', 'MV', '13', 1),
(2603, 'Gaafu Dhaalu Atoll', 'MV', '28', 1),
(2604, 'Central Province', 'MV', 'CE', 1),
(2605, 'South Province', 'MV', 'SU', 1),
(2606, 'South Central Province', 'MV', 'SC', 1),
(2607, 'Lhaviyani Atoll', 'MV', '03', 1),
(2608, 'Meemu Atoll', 'MV', '12', 1),
(2609, 'Malé', 'MV', 'MLE', 1),
(2610, 'Utrecht', 'NL', 'UT', 1),
(2611, 'Gelderland', 'NL', 'GE', 1),
(2612, 'North Holland', 'NL', 'NH', 1),
(2613, 'Drenthe', 'NL', 'DR', 1),
(2614, 'South Holland', 'NL', 'ZH', 1),
(2615, 'Limburg', 'NL', 'LI', 1),
(2616, 'Sint Eustatius', 'NL', 'BQ3', 1),
(2617, 'Groningen', 'NL', 'GR', 1),
(2618, 'Overijssel', 'NL', 'OV', 1),
(2619, 'Flevoland', 'NL', 'FL', 1),
(2620, 'Zeeland', 'NL', 'ZE', 1),
(2621, 'Saba', 'NL', 'BQ2', 1),
(2622, 'Friesland', 'NL', 'FR', 1),
(2623, 'North Brabant', 'NL', 'NB', 1),
(2624, 'Bonaire', 'NL', 'BQ1', 1),
(2625, 'Savanes Region', 'CI', '03', 1),
(2626, 'Agnéby', 'CI', '16', 1),
(2627, 'Lagunes District', 'CI', 'LG', 1),
(2628, 'Sud-Bandama', 'CI', '15', 1),
(2629, 'Montagnes District', 'CI', 'MG', 1),
(2630, 'Moyen-Comoé', 'CI', '05', 1),
(2631, 'Marahoué Region', 'CI', '12', 1),
(2632, 'Lacs District', 'CI', 'LC', 1),
(2633, 'Fromager', 'CI', '18', 1),
(2634, 'Abidjan', 'CI', 'AB', 1),
(2635, 'Bas-Sassandra Region', 'CI', '09', 1),
(2636, 'Bafing Region', 'CI', '17', 1),
(2637, 'Vallée du Bandama District', 'CI', 'VB', 1),
(2638, 'Haut-Sassandra', 'CI', '02', 1),
(2639, 'Lagunes region', 'CI', '01', 1),
(2640, 'Lacs Region', 'CI', '07', 1),
(2641, 'Zanzan Region', 'CI', 'ZZ', 1),
(2642, 'Denguélé Region', 'CI', '10', 1),
(2643, 'Bas-Sassandra District', 'CI', 'BS', 1),
(2644, 'Denguélé District', 'CI', 'DN', 1),
(2645, 'Dix-Huit Montagnes', 'CI', '06', 1),
(2646, 'Moyen-Cavally', 'CI', '19', 1),
(2647, 'Vallée du Bandama Region', 'CI', '04', 1),
(2648, 'Sassandra-Marahoué District', 'CI', 'SM', 1),
(2649, 'Worodougou', 'CI', '14', 1),
(2650, 'Woroba District', 'CI', 'WR', 1),
(2651, 'Gôh-Djiboua District', 'CI', 'GD', 1),
(2652, 'Sud-Comoé', 'CI', '13', 1),
(2653, 'Yamoussoukro', 'CI', 'YM', 1),
(2654, 'Comoé District', 'CI', 'CM', 1),
(2655, 'N''zi-Comoé', 'CI', '11', 1),
(2656, 'Far North', 'CM', 'EN', 1),
(2657, 'Northwest', 'CM', 'NW', 1),
(2658, 'Southwest', 'CM', 'SW', 1),
(2659, 'South', 'CM', 'SU', 1),
(2660, 'Centre', 'CM', 'CE', 1),
(2661, 'East', 'CM', 'ES', 1),
(2662, 'Littoral', 'CM', 'LT', 1),
(2663, 'Adamawa', 'CM', 'AD', 1),
(2664, 'West', 'CM', 'OU', 1),
(2665, 'North', 'CM', 'NO', 1),
(2666, 'Banjul', 'GM', 'B', 1),
(2667, 'West Coast Division', 'GM', 'W', 1),
(2668, 'Upper River Division', 'GM', 'U', 1),
(2669, 'Central River Division', 'GM', 'M', 1),
(2670, 'Lower River Division', 'GM', 'L', 1),
(2671, 'North Bank Division', 'GM', 'N', 1),
(2672, 'Beyla Prefecture', 'GN', 'BE', 1),
(2673, 'Mandiana Prefecture', 'GN', 'MD', 1),
(2674, 'Yomou Prefecture', 'GN', 'YO', 1),
(2675, 'Fria Prefecture', 'GN', 'FR', 1),
(2676, 'Boké Region', 'GN', 'B', 1),
(2677, 'Labé Region', 'GN', 'L', 1),
(2678, 'Nzérékoré Prefecture', 'GN', 'NZ', 1),
(2679, 'Dabola Prefecture', 'GN', 'DB', 1),
(2680, 'Labé Prefecture', 'GN', 'LA', 1),
(2681, 'Dubréka Prefecture', 'GN', 'DU', 1);
INSERT INTO `state` VALUES
(2682, 'Faranah Prefecture', 'GN', 'FA', 1),
(2683, 'Forécariah Prefecture', 'GN', 'FO', 1),
(2684, 'Nzérékoré Region', 'GN', 'N', 1),
(2685, 'Gaoual Prefecture', 'GN', 'GA', 1),
(2686, 'Conakry', 'GN', 'C', 1),
(2687, 'Télimélé Prefecture', 'GN', 'TE', 1),
(2688, 'Dinguiraye Prefecture', 'GN', 'DI', 1),
(2689, 'Mamou Prefecture', 'GN', 'MM', 1),
(2690, 'Lélouma Prefecture', 'GN', 'LE', 1),
(2691, 'Kissidougou Prefecture', 'GN', 'KS', 1),
(2692, 'Koubia Prefecture', 'GN', 'KB', 1),
(2693, 'Kindia Prefecture', 'GN', 'KD', 1),
(2694, 'Pita Prefecture', 'GN', 'PI', 1),
(2695, 'Kouroussa Prefecture', 'GN', 'KO', 1),
(2696, 'Tougué Prefecture', 'GN', 'TO', 1),
(2697, 'Kankan Region', 'GN', 'K', 1),
(2698, 'Mamou Region', 'GN', 'M', 1),
(2699, 'Boffa Prefecture', 'GN', 'BF', 1),
(2700, 'Mali Prefecture', 'GN', 'ML', 1),
(2701, 'Kindia Region', 'GN', 'D', 1),
(2702, 'Macenta Prefecture', 'GN', 'MC', 1),
(2703, 'Koundara Prefecture', 'GN', 'KN', 1),
(2704, 'Kankan Prefecture', 'GN', 'KA', 1),
(2705, 'Coyah Prefecture', 'GN', 'CO', 1),
(2706, 'Dalaba Prefecture', 'GN', 'DL', 1),
(2707, 'Siguiri Prefecture', 'GN', 'SI', 1),
(2708, 'Lola Prefecture', 'GN', 'LO', 1),
(2709, 'Boké Prefecture', 'GN', 'BK', 1),
(2710, 'Kérouané Prefecture', 'GN', 'KE', 1),
(2711, 'Guéckédou Prefecture', 'GN', 'GU', 1),
(2712, 'Tombali Region', 'GW', 'TO', 1),
(2713, 'Cacheu Region', 'GW', 'CA', 1),
(2714, 'Biombo Region', 'GW', 'BM', 1),
(2715, 'Quinara Region', 'GW', 'QU', 1),
(2716, 'Sul Province', 'GW', 'S', 1),
(2717, 'Norte Province', 'GW', 'N', 1),
(2718, 'Oio Region', 'GW', 'OI', 1),
(2719, 'Gabú Region', 'GW', 'GA', 1),
(2720, 'Bafatá', 'GW', 'BA', 1),
(2721, 'Leste Province', 'GW', 'L', 1),
(2722, 'Bolama Region', 'GW', 'BL', 1),
(2723, 'Woleu-Ntem Province', 'GA', '9', 1),
(2724, 'Ogooué-Ivindo Province', 'GA', '6', 1),
(2725, 'Nyanga Province', 'GA', '5', 1),
(2726, 'Haut-Ogooué Province', 'GA', '2', 1),
(2727, 'Estuaire Province', 'GA', '1', 1),
(2728, 'Ogooué-Maritime Province', 'GA', '8', 1),
(2729, 'Ogooué-Lolo Province', 'GA', '7', 1),
(2730, 'Moyen-Ogooué Province', 'GA', '3', 1),
(2731, 'Ngounié Province', 'GA', '4', 1),
(2732, 'Tshuapa', 'CD', 'TU', 1),
(2733, 'Tanganyika', 'CD', 'TA', 1),
(2734, 'Haut-Uélé', 'CD', 'HU', 1),
(2735, 'Kasaï Oriental', 'CD', 'KE', 1),
(2738, 'Sud-Kivu', 'CD', 'SK', 1),
(2739, 'Nord-Ubangi', 'CD', 'NU', 1),
(2740, 'Kwango', 'CD', 'KG', 1),
(2741, 'Kinshasa', 'CD', 'KN', 1),
(2742, 'Kasaï Central', 'CD', 'KC', 1),
(2743, 'Sankuru', 'CD', 'SA', 1),
(2744, 'Équateur', 'CD', 'EQ', 1),
(2745, 'Maniema', 'CD', 'MA', 1),
(2746, 'Kongo Central', 'CD', 'BC', 1),
(2747, 'Lomami', 'CD', 'LO', 1),
(2748, 'Sud-Ubangi', 'CD', 'SU', 1),
(2749, 'Nord-Kivu', 'CD', 'NK', 1),
(2750, 'Haut-Katanga', 'CD', 'HK', 1),
(2751, 'Ituri', 'CD', 'IT', 1),
(2752, 'Mongala', 'CD', 'MO', 1),
(2753, 'Bas-Uélé', 'CD', 'BU', 1),
(2755, 'Mai-Ndombe', 'CD', 'MN', 1),
(2756, 'Tshopo', 'CD', 'TO', 1),
(2757, 'Kasaï', 'CD', 'KS', 1),
(2758, 'Haut-Lomami', 'CD', 'HL', 1),
(2759, 'Kwilu', 'CD', 'KL', 1),
(2760, 'Cuyuni-Mazaruni', 'GY', 'CU', 1),
(2761, 'Potaro-Siparuni', 'GY', 'PT', 1),
(2762, 'Mahaica-Berbice', 'GY', 'MA', 1),
(2763, 'Upper Demerara-Berbice', 'GY', 'UD', 1),
(2764, 'Barima-Waini', 'GY', 'BA', 1),
(2765, 'Pomeroon-Supenaam', 'GY', 'PM', 1),
(2766, 'East Berbice-Corentyne', 'GY', 'EB', 1),
(2767, 'Demerara-Mahaica', 'GY', 'DE', 1),
(2768, 'Essequibo Islands-West Demerara', 'GY', 'ES', 1),
(2769, 'Upper Takutu-Upper Essequibo', 'GY', 'UT', 1),
(2770, 'Presidente Hayes Department', 'PY', '15', 1),
(2771, 'Canindeyú', 'PY', '14', 1),
(2772, 'Guairá Department', 'PY', '4', 1),
(2773, 'Caaguazú', 'PY', '5', 1),
(2774, 'Paraguarí Department', 'PY', '9', 1),
(2775, 'Caazapá', 'PY', '6', 1),
(2776, 'San Pedro Department', 'PY', '2', 1),
(2777, 'Central Department', 'PY', '11', 1),
(2778, 'Itapúa', 'PY', '7', 1),
(2779, 'Concepción Department', 'PY', '1', 1),
(2780, 'Boquerón Department', 'PY', '19', 1),
(2781, 'Ñeembucú Department', 'PY', '12', 1),
(2782, 'Amambay Department', 'PY', '13', 1),
(2783, 'Cordillera Department', 'PY', '3', 1),
(2784, 'Alto Paraná Department', 'PY', '10', 1),
(2785, 'Alto Paraguay Department', 'PY', '16', 1),
(2786, 'Misiones Department', 'PY', '8', 1),
(2787, 'Jaffna District', 'LK', '41', 1),
(2788, 'Kandy District', 'LK', '21', 1),
(2789, 'Kalutara District', 'LK', '13', 1),
(2790, 'Badulla District', 'LK', '81', 1),
(2791, 'Hambantota District', 'LK', '33', 1),
(2792, 'Galle District', 'LK', '31', 1),
(2793, 'Kilinochchi District', 'LK', '42', 1),
(2794, 'Nuwara Eliya District', 'LK', '23', 1),
(2795, 'Trincomalee District', 'LK', '53', 1),
(2796, 'Puttalam District', 'LK', '62', 1),
(2797, 'Kegalle District', 'LK', '92', 1),
(2798, 'Central Province', 'LK', '2', 1),
(2799, 'Ampara District', 'LK', '52', 1),
(2800, 'North Central Province', 'LK', '7', 1),
(2801, 'Southern Province', 'LK', '3', 1),
(2802, 'Western Province', 'LK', '1', 1),
(2803, 'Sabaragamuwa Province', 'LK', '9', 1),
(2804, 'Gampaha District', 'LK', '12', 1),
(2805, 'Mannar District', 'LK', '43', 1),
(2806, 'Matara District', 'LK', '32', 1),
(2807, 'Ratnapura district', 'LK', '91', 1),
(2808, 'Eastern Province', 'LK', '5', 1),
(2809, 'Vavuniya District', 'LK', '44', 1),
(2810, 'Matale District', 'LK', '22', 1),
(2811, 'Uva Province', 'LK', '8', 1),
(2812, 'Polonnaruwa District', 'LK', '72', 1),
(2813, 'Northern Province', 'LK', '4', 1),
(2814, 'Mullaitivu District', 'LK', '45', 1),
(2815, 'Colombo District', 'LK', '11', 1),
(2816, 'Anuradhapura District', 'LK', '71', 1),
(2817, 'North Western Province', 'LK', '6', 1),
(2818, 'Batticaloa District', 'LK', '51', 1),
(2819, 'Monaragala District', 'LK', '82', 1),
(2820, 'Mohéli', 'KM', 'M', 1),
(2821, 'Anjouan', 'KM', 'A', 1),
(2822, 'Grande Comore', 'KM', 'G', 1),
(2823, 'Atacama', 'CL', 'AT', 1),
(2824, 'Región Metropolitana de Santiago', 'CL', 'RM', 1),
(2825, 'Coquimbo', 'CL', 'CO', 1),
(2826, 'La Araucanía', 'CL', 'AR', 1),
(2827, 'Biobío', 'CL', 'BI', 1),
(2828, 'Aisén del General Carlos Ibañez del Campo', 'CL', 'AI', 1),
(2829, 'Arica y Parinacota', 'CL', 'AP', 1),
(2830, 'Valparaíso', 'CL', 'VS', 1),
(2831, 'Ñuble', 'CL', 'NB', 1),
(2832, 'Antofagasta', 'CL', 'AN', 1),
(2833, 'Maule', 'CL', 'ML', 1),
(2834, 'Los Ríos', 'CL', 'LR', 1),
(2835, 'Los Lagos', 'CL', 'LL', 1),
(2836, 'Magallanes y de la Antártica Chilena', 'CL', 'MA', 1),
(2837, 'Tarapacá', 'CL', 'TA', 1),
(2838, 'Libertador General Bernardo O''Higgins', 'CL', 'LI', 1),
(2839, 'Commewijne District', 'SR', 'CM', 1),
(2840, 'Nickerie District', 'SR', 'NI', 1),
(2841, 'Para District', 'SR', 'PR', 1),
(2842, 'Coronie District', 'SR', 'CR', 1),
(2843, 'Paramaribo District', 'SR', 'PM', 1),
(2844, 'Wanica District', 'SR', 'WA', 1),
(2845, 'Marowijne District', 'SR', 'MA', 1),
(2846, 'Brokopondo District', 'SR', 'BR', 1),
(2847, 'Sipaliwini District', 'SR', 'SI', 1),
(2848, 'Saramacca District', 'SR', 'SA', 1),
(2849, 'Riyadh', 'SA', '01', 1),
(2850, 'Makkah', 'SA', '02', 1),
(2851, 'Al Madinah', 'SA', '03', 1),
(2852, 'Tabuk', 'SA', '07', 1),
(2853, '''Asir', 'SA', '14', 1),
(2854, 'Northern Borders', 'SA', '08', 1),
(2855, 'Ha''il', 'SA', '06', 1),
(2856, 'Eastern Province', 'SA', '04', 1),
(2857, 'Al Jawf', 'SA', '12', 1),
(2858, 'Jizan', 'SA', '09', 1),
(2859, 'Al Bahah', 'SA', '11', 1),
(2860, 'Najran', 'SA', '10', 1),
(2861, 'Al-Qassim', 'SA', '05', 1),
(2862, 'Plateaux Department', 'CG', '14', 1),
(2863, 'Pointe-Noire', 'CG', '16', 1),
(2864, 'Cuvette Department', 'CG', '8', 1),
(2865, 'Likouala Department', 'CG', '7', 1),
(2866, 'Bouenza Department', 'CG', '11', 1),
(2867, 'Kouilou Department', 'CG', '5', 1),
(2868, 'Lékoumou Department', 'CG', '2', 1),
(2869, 'Cuvette-Ouest Department', 'CG', '15', 1),
(2870, 'Brazzaville', 'CG', 'BZV', 1),
(2871, 'Sangha Department', 'CG', '13', 1),
(2872, 'Niari Department', 'CG', '9', 1),
(2873, 'Pool Department', 'CG', '12', 1),
(2874, 'Quindío', 'CO', 'QUI', 1),
(2875, 'Cundinamarca', 'CO', 'CUN', 1),
(2876, 'Chocó', 'CO', 'CHO', 1),
(2877, 'Norte de Santander', 'CO', 'NSA', 1),
(2878, 'Meta', 'CO', 'MET', 1),
(2879, 'Risaralda', 'CO', 'RIS', 1),
(2880, 'Atlántico', 'CO', 'ATL', 1),
(2881, 'Arauca', 'CO', 'ARA', 1),
(2882, 'Guainía', 'CO', 'GUA', 1),
(2883, 'Tolima', 'CO', 'TOL', 1),
(2884, 'Cauca', 'CO', 'CAU', 1),
(2885, 'Vaupés', 'CO', 'VAU', 1),
(2886, 'Magdalena', 'CO', 'MAG', 1),
(2887, 'Caldas', 'CO', 'CAL', 1),
(2888, 'Guaviare', 'CO', 'GUV', 1),
(2889, 'La Guajira', 'CO', 'LAG', 1),
(2890, 'Antioquia', 'CO', 'ANT', 1),
(2891, 'Caquetá', 'CO', 'CAQ', 1),
(2892, 'Casanare', 'CO', 'CAS', 1),
(2893, 'Bolívar', 'CO', 'BOL', 1),
(2894, 'Vichada', 'CO', 'VID', 1),
(2895, 'Amazonas', 'CO', 'AMA', 1),
(2896, 'Putumayo', 'CO', 'PUT', 1),
(2897, 'Nariño', 'CO', 'NAR', 1),
(2898, 'Córdoba', 'CO', 'COR', 1),
(2899, 'Cesar', 'CO', 'CES', 1),
(2900, 'Archipiélago de San Andrés, Providencia y Santa Catalina', 'CO', 'SAP', 1),
(2901, 'Santander', 'CO', 'SAN', 1),
(2902, 'Sucre', 'CO', 'SUC', 1),
(2903, 'Boyacá', 'CO', 'BOY', 1),
(2904, 'Valle del Cauca', 'CO', 'VAC', 1),
(2905, 'Galápagos', 'EC', 'W', 1),
(2906, 'Sucumbíos', 'EC', 'U', 1),
(2907, 'Pastaza', 'EC', 'Y', 1),
(2908, 'Tungurahua', 'EC', 'T', 1),
(2909, 'Zamora Chinchipe', 'EC', 'Z', 1),
(2910, 'Los Ríos', 'EC', 'R', 1),
(2911, 'Imbabura', 'EC', 'I', 1),
(2912, 'Santa Elena', 'EC', 'SE', 1),
(2913, 'Manabí', 'EC', 'M', 1),
(2914, 'Guayas', 'EC', 'G', 1),
(2915, 'Carchi', 'EC', 'C', 1),
(2916, 'Napo', 'EC', 'N', 1),
(2917, 'Cañar', 'EC', 'F', 1),
(2918, 'Morona-Santiago', 'EC', 'S', 1),
(2919, 'Santo Domingo de los Tsáchilas', 'EC', 'SD', 1),
(2920, 'Bolívar', 'EC', 'B', 1),
(2921, 'Cotopaxi', 'EC', 'X', 1),
(2922, 'Esmeraldas', 'EC', 'E', 1),
(2923, 'Azuay', 'EC', 'A', 1),
(2924, 'El Oro', 'EC', 'O', 1),
(2925, 'Chimborazo', 'EC', 'H', 1),
(2926, 'Orellana', 'EC', 'D', 1),
(2927, 'Pichincha', 'EC', 'P', 1),
(2928, 'Obock Region', 'DJ', 'OB', 1),
(2929, 'Djibouti', 'DJ', 'DJ', 1),
(2930, 'Dikhil Region', 'DJ', 'DI', 1),
(2931, 'Tadjourah Region', 'DJ', 'TA', 1),
(2932, 'Arta Region', 'DJ', 'AR', 1),
(2933, 'Ali Sabieh Region', 'DJ', 'AS', 1),
(2934, 'Hama', 'SY', 'HM', 1),
(2935, 'Rif Dimashq', 'SY', 'RD', 1),
(2936, 'As-Suwayda', 'SY', 'SU', 1),
(2937, 'Deir ez-Zor', 'SY', 'DY', 1),
(2938, 'Latakia', 'SY', 'LA', 1),
(2939, 'Damascus', 'SY', 'DI', 1),
(2940, 'Idlib', 'SY', 'ID', 1),
(2941, 'Al-Hasakah', 'SY', 'HA', 1),
(2942, 'Homs', 'SY', 'HI', 1),
(2943, 'Quneitra', 'SY', 'QU', 1),
(2944, 'Al-Raqqah', 'SY', 'RA', 1),
(2945, 'Daraa', 'SY', 'DR', 1),
(2946, 'Aleppo', 'SY', 'HL', 1),
(2947, 'Tartus', 'SY', 'TA', 1),
(2948, 'Fianarantsoa Province', 'MG', 'F', 1),
(2949, 'Toliara Province', 'MG', 'U', 1),
(2950, 'Antsiranana Province', 'MG', 'D', 1),
(2951, 'Antananarivo Province', 'MG', 'T', 1),
(2952, 'Toamasina Province', 'MG', 'A', 1),
(2953, 'Mahajanga Province', 'MG', 'M', 1),
(2954, 'Mogilev Region', 'BY', 'MA', 1),
(2955, 'Gomel Region', 'BY', 'HO', 1),
(2956, 'Grodno Region', 'BY', 'HR', 1),
(2957, 'Minsk Region', 'BY', 'MI', 1),
(2958, 'Minsk', 'BY', 'HM', 1),
(2959, 'Brest Region', 'BY', 'BR', 1),
(2960, 'Vitebsk Region', 'BY', 'VI', 1),
(2961, 'Murqub', 'LY', 'MB', 1),
(2962, 'Nuqat al Khams', 'LY', 'NQ', 1),
(2963, 'Zawiya District', 'LY', 'ZA', 1),
(2964, 'Al Wahat District', 'LY', 'WA', 1),
(2965, 'Sabha District', 'LY', 'SB', 1),
(2966, 'Derna District', 'LY', 'DR', 1),
(2967, 'Murzuq District', 'LY', 'MQ', 1),
(2968, 'Marj District', 'LY', 'MJ', 1),
(2969, 'Ghat District', 'LY', 'GT', 1),
(2970, 'Jufra', 'LY', 'JU', 1),
(2971, 'Tripoli District', 'LY', 'TB', 1),
(2972, 'Kufra District', 'LY', 'KF', 1),
(2973, 'Wadi al Hayaa District', 'LY', 'WD', 1),
(2974, 'Jabal al Gharbi District', 'LY', 'JG', 1),
(2975, 'Wadi al Shatii District', 'LY', 'WS', 1),
(2976, 'Nalut District', 'LY', 'NL', 1),
(2977, 'Sirte District', 'LY', 'SR', 1),
(2978, 'Misrata District', 'LY', 'MI', 1),
(2979, 'Jafara', 'LY', 'JI', 1),
(2980, 'Jabal al Akhdar', 'LY', 'JA', 1),
(2981, 'Benghazi', 'LY', 'BA', 1),
(2982, 'Ribeira Brava Municipality', 'CV', 'RB', 1),
(2983, 'Tarrafal', 'CV', 'TA', 1),
(2984, 'Ribeira Grande de Santiago', 'CV', 'RS', 1),
(2985, 'Santa Catarina', 'CV', 'CA', 1),
(2986, 'São Domingos', 'CV', 'SD', 1),
(2987, 'Mosteiros', 'CV', 'MO', 1),
(2988, 'Praia', 'CV', 'PR', 1),
(2989, 'Porto Novo', 'CV', 'PN', 1),
(2990, 'São Miguel', 'CV', 'SM', 1),
(2991, 'Maio Municipality', 'CV', 'MA', 1),
(2992, 'Sotavento Islands', 'CV', 'S', 1),
(2993, 'São Lourenço dos Órgãos', 'CV', 'SO', 1),
(2994, 'Barlavento Islands', 'CV', 'B', 1),
(2995, 'Santa Catarina do Fogo', 'CV', 'CF', 1),
(2996, 'Brava', 'CV', 'BR', 1),
(2997, 'Paul', 'CV', 'PA', 1),
(2998, 'Sal', 'CV', 'SL', 1),
(2999, 'Boa Vista', 'CV', 'BV', 1),
(3000, 'São Filipe', 'CV', 'SF', 1),
(3001, 'São Vicente', 'CV', 'SV', 1),
(3002, 'Ribeira Grande', 'CV', 'RG', 1),
(3003, 'Tarrafal de São Nicolau', 'CV', 'TS', 1),
(3004, 'Santa Cruz', 'CV', 'CR', 1),
(3005, 'Schleswig-Holstein', 'DE', 'SH', 1),
(3006, 'Baden-Württemberg', 'DE', 'BW', 1),
(3007, 'Mecklenburg-Vorpommern', 'DE', 'MV', 1),
(3008, 'Lower Saxony', 'DE', 'NI', 1),
(3009, 'Bavaria', 'DE', 'BY', 1),
(3010, 'Berlin', 'DE', 'BE', 1),
(3011, 'Saxony-Anhalt', 'DE', 'ST', 1),
(3013, 'Brandenburg', 'DE', 'BB', 1),
(3014, 'Bremen', 'DE', 'HB', 1),
(3015, 'Thuringia', 'DE', 'TH', 1),
(3016, 'Hamburg', 'DE', 'HH', 1),
(3017, 'North Rhine-Westphalia', 'DE', 'NW', 1),
(3018, 'Hesse', 'DE', 'HE', 1),
(3019, 'Rhineland-Palatinate', 'DE', 'RP', 1),
(3020, 'Saarland', 'DE', 'SL', 1),
(3021, 'Saxony', 'DE', 'SN', 1),
(3022, 'Mafeteng District', 'LS', 'E', 1),
(3023, 'Mohale''s Hoek District', 'LS', 'F', 1),
(3024, 'Mokhotlong District', 'LS', 'J', 1),
(3025, 'Qacha''s Nek District', 'LS', 'H', 1),
(3026, 'Leribe District', 'LS', 'C', 1),
(3027, 'Quthing District', 'LS', 'G', 1),
(3028, 'Maseru District', 'LS', 'A', 1),
(3029, 'Butha-Buthe District', 'LS', 'B', 1),
(3030, 'Berea District', 'LS', 'D', 1),
(3031, 'Thaba-Tseka District', 'LS', 'K', 1),
(3032, 'Montserrado County', 'LR', 'MO', 1),
(3033, 'River Cess County', 'LR', 'RI', 1),
(3034, 'Bong County', 'LR', 'BG', 1),
(3035, 'Sinoe County', 'LR', 'SI', 1),
(3036, 'Grand Cape Mount County', 'LR', 'CM', 1),
(3037, 'Lofa County', 'LR', 'LO', 1),
(3038, 'River Gee County', 'LR', 'RG', 1),
(3039, 'Grand Gedeh County', 'LR', 'GG', 1),
(3040, 'Grand Bassa County', 'LR', 'GB', 1),
(3041, 'Bomi County', 'LR', 'BM', 1),
(3042, 'Maryland County', 'LR', 'MY', 1),
(3043, 'Margibi County', 'LR', 'MG', 1),
(3044, 'Gbarpolu County', 'LR', 'GP', 1),
(3045, 'Grand Kru County', 'LR', 'GK', 1),
(3046, 'Nimba', 'LR', 'NI', 1),
(3047, 'Ad Dhahirah', 'OM', 'ZA', 1),
(3048, 'Al Batinah North', 'OM', 'BS', 1),
(3049, 'Al Batinah South', 'OM', 'BJ', 1),
(3050, 'Al Batinah Region', 'OM', 'BA', 1),
(3051, 'Ash Sharqiyah Region', 'OM', 'SH', 1),
(3052, 'Musandam', 'OM', 'MU', 1),
(3053, 'Ash Sharqiyah North', 'OM', 'SS', 1),
(3054, 'Ash Sharqiyah South', 'OM', 'SJ', 1),
(3055, 'Muscat', 'OM', 'MA', 1),
(3056, 'Al Wusta', 'OM', 'WU', 1),
(3057, 'Dhofar', 'OM', 'ZU', 1),
(3058, 'Ad Dakhiliyah', 'OM', 'DA', 1),
(3059, 'Al Buraimi', 'OM', 'BU', 1),
(3060, 'Ngamiland', 'BW', 'NG', 1),
(3061, 'Ghanzi District', 'BW', 'GH', 1),
(3062, 'Kgatleng District', 'BW', 'KL', 1),
(3063, 'Southern District', 'BW', 'SO', 1),
(3064, 'South-East District', 'BW', 'SE', 1),
(3065, 'North-West District', 'BW', 'NW', 1),
(3066, 'Kgalagadi District', 'BW', 'KG', 1),
(3067, 'Central District', 'BW', 'CE', 1),
(3068, 'North-East District', 'BW', 'NE', 1),
(3069, 'Kweneng District', 'BW', 'KW', 1),
(3070, 'Collines Department', 'BJ', 'CO', 1),
(3071, 'Kouffo Department', 'BJ', 'KO', 1),
(3072, 'Donga Department', 'BJ', 'DO', 1),
(3073, 'Zou Department', 'BJ', 'ZO', 1),
(3074, 'Plateau Department', 'BJ', 'PL', 1),
(3075, 'Mono Department', 'BJ', 'MO', 1),
(3076, 'Atakora Department', 'BJ', 'AK', 1),
(3077, 'Alibori Department', 'BJ', 'AL', 1),
(3078, 'Borgou Department', 'BJ', 'BO', 1),
(3079, 'Atlantique Department', 'BJ', 'AQ', 1),
(3080, 'Ouémé Department', 'BJ', 'OU', 1),
(3081, 'Littoral Department', 'BJ', 'LI', 1),
(3082, 'Machinga District', 'MW', 'MH', 1),
(3083, 'Zomba District', 'MW', 'ZO', 1),
(3084, 'Mwanza District', 'MW', 'MW', 1),
(3085, 'Nsanje District', 'MW', 'NS', 1),
(3086, 'Salima District', 'MW', 'SA', 1),
(3087, 'Chitipa district', 'MW', 'CT', 1),
(3088, 'Ntcheu District', 'MW', 'NU', 1),
(3089, 'Rumphi District', 'MW', 'RU', 1),
(3090, 'Dowa District', 'MW', 'DO', 1),
(3091, 'Karonga District', 'MW', 'KR', 1),
(3092, 'Central Region', 'MW', 'C', 1),
(3093, 'Likoma District', 'MW', 'LK', 1),
(3094, 'Kasungu District', 'MW', 'KS', 1),
(3095, 'Nkhata Bay District', 'MW', 'NB', 1),
(3096, 'Balaka District', 'MW', 'BA', 1),
(3097, 'Dedza District', 'MW', 'DE', 1),
(3098, 'Thyolo District', 'MW', 'TH', 1),
(3099, 'Mchinji District', 'MW', 'MC', 1),
(3100, 'Nkhotakota District', 'MW', 'NK', 1),
(3101, 'Lilongwe District', 'MW', 'LI', 1),
(3102, 'Blantyre District', 'MW', 'BL', 1),
(3103, 'Mulanje District', 'MW', 'MU', 1),
(3104, 'Mzimba District', 'MW', 'MZ', 1),
(3105, 'Northern Region', 'MW', 'N', 1),
(3106, 'Southern Region', 'MW', 'S', 1),
(3107, 'Chikwawa District', 'MW', 'CK', 1),
(3108, 'Phalombe District', 'MW', 'PH', 1),
(3109, 'Chiradzulu District', 'MW', 'CR', 1),
(3110, 'Mangochi District', 'MW', 'MG', 1),
(3111, 'Ntchisi District', 'MW', 'NI', 1),
(3112, 'Kénédougou Province', 'BF', 'KEN', 1),
(3113, 'Namentenga Province', 'BF', 'NAM', 1),
(3114, 'Sahel Region', 'BF', '12', 1),
(3115, 'Centre-Ouest Region', 'BF', '06', 1),
(3116, 'Nahouri Province', 'BF', 'NAO', 1),
(3117, 'Passoré Province', 'BF', 'PAS', 1),
(3118, 'Zoundwéogo Province', 'BF', 'ZOU', 1),
(3119, 'Sissili Province', 'BF', 'SIS', 1),
(3120, 'Banwa Province', 'BF', 'BAN', 1),
(3121, 'Bougouriba Province', 'BF', 'BGR', 1),
(3122, 'Gnagna Province', 'BF', 'GNA', 1),
(3123, 'Mouhoun', 'BF', 'MOU', 1),
(3124, 'Yagha Province', 'BF', 'YAG', 1),
(3125, 'Plateau-Central Region', 'BF', '11', 1),
(3126, 'Sanmatenga Province', 'BF', 'SMT', 1),
(3127, 'Centre-Nord Region', 'BF', '05', 1),
(3128, 'Tapoa Province', 'BF', 'TAP', 1),
(3129, 'Houet Province', 'BF', 'HOU', 1),
(3130, 'Zondoma Province', 'BF', 'ZON', 1),
(3131, 'Boulgou', 'BF', 'BLG', 1),
(3132, 'Komondjari Province', 'BF', 'KMD', 1),
(3133, 'Koulpélogo Province', 'BF', 'KOP', 1),
(3134, 'Tuy Province', 'BF', 'TUI', 1),
(3135, 'Ioba Province', 'BF', 'IOB', 1),
(3136, 'Centre', 'BF', '03', 1),
(3137, 'Sourou Province', 'BF', 'SOR', 1),
(3138, 'Boucle du Mouhoun Region', 'BF', '01', 1),
(3139, 'Séno Province', 'BF', 'SEN', 1),
(3140, 'Sud-Ouest Region', 'BF', '13', 1),
(3141, 'Oubritenga Province', 'BF', 'OUB', 1),
(3142, 'Nayala Province', 'BF', 'NAY', 1),
(3143, 'Gourma Province', 'BF', 'GOU', 1),
(3144, 'Oudalan Province', 'BF', 'OUD', 1),
(3145, 'Ziro Province', 'BF', 'ZIR', 1),
(3146, 'Kossi Province', 'BF', 'KOS', 1),
(3147, 'Kourwéogo Province', 'BF', 'KOW', 1),
(3148, 'Ganzourgou Province', 'BF', 'GAN', 1),
(3149, 'Centre-Sud Region', 'BF', '07', 1),
(3150, 'Yatenga Province', 'BF', 'YAT', 1),
(3151, 'Loroum Province', 'BF', 'LOR', 1),
(3152, 'Bazèga Province', 'BF', 'BAZ', 1),
(3153, 'Cascades Region', 'BF', '02', 1),
(3154, 'Sanguié Province', 'BF', 'SNG', 1),
(3155, 'Bam Province', 'BF', 'BAM', 1),
(3156, 'Noumbiel Province', 'BF', 'NOU', 1),
(3157, 'Kompienga Province', 'BF', 'KMP', 1),
(3158, 'Est Region', 'BF', '08', 1),
(3159, 'Léraba Province', 'BF', 'LER', 1),
(3160, 'Balé Province', 'BF', 'BAL', 1),
(3161, 'Kouritenga Province', 'BF', 'KOT', 1),
(3162, 'Centre-Est Region', 'BF', '04', 1),
(3163, 'Poni Province', 'BF', 'PON', 1),
(3164, 'Nord Region, Burkina Faso', 'BF', '10', 1),
(3165, 'Hauts-Bassins Region', 'BF', '09', 1),
(3166, 'Soum Province', 'BF', 'SOM', 1),
(3167, 'Comoé Province', 'BF', 'COM', 1),
(3168, 'Kadiogo Province', 'BF', 'KAD', 1),
(3169, 'Islamabad Capital Territory', 'PK', 'IS', 1),
(3170, 'Gilgit-Baltistan', 'PK', 'GB', 1),
(3171, 'Khyber Pakhtunkhwa', 'PK', 'KP', 1),
(3172, 'Azad Kashmir', 'PK', 'JK', 1),
(3173, 'Federally Administered Tribal Areas', 'PK', 'TA', 1),
(3174, 'Balochistan', 'PK', 'BA', 1),
(3175, 'Sindh', 'PK', 'SD', 1),
(3176, 'Punjab', 'PK', 'PB', 1),
(3177, 'Al Rayyan Municipality', 'QA', 'RA', 1),
(3178, 'Al-Shahaniya', 'QA', 'SH', 1),
(3179, 'Al Wakrah', 'QA', 'WA', 1),
(3180, 'Madinat ash Shamal', 'QA', 'MS', 1),
(3181, 'Doha', 'QA', 'DA', 1),
(3182, 'Al Daayen', 'QA', 'ZA', 1),
(3183, 'Al Khor', 'QA', 'KH', 1),
(3184, 'Umm Salal Municipality', 'QA', 'US', 1),
(3185, 'Rumonge Province', 'BI', 'RM', 1),
(3186, 'Muyinga Province', 'BI', 'MY', 1),
(3187, 'Mwaro Province', 'BI', 'MW', 1),
(3188, 'Makamba Province', 'BI', 'MA', 1),
(3189, 'Rutana Province', 'BI', 'RT', 1),
(3190, 'Cibitoke Province', 'BI', 'CI', 1),
(3191, 'Ruyigi Province', 'BI', 'RY', 1),
(3192, 'Kayanza Province', 'BI', 'KY', 1),
(3193, 'Muramvya Province', 'BI', 'MU', 1),
(3194, 'Karuzi Province', 'BI', 'KR', 1),
(3195, 'Kirundo Province', 'BI', 'KI', 1),
(3196, 'Bubanza Province', 'BI', 'BB', 1),
(3197, 'Gitega Province', 'BI', 'GI', 1),
(3198, 'Bujumbura Mairie Province', 'BI', 'BM', 1),
(3199, 'Ngozi Province', 'BI', 'NG', 1),
(3200, 'Bujumbura Rural Province', 'BI', 'BL', 1),
(3201, 'Cankuzo Province', 'BI', 'CA', 1),
(3202, 'Bururi Province', 'BI', 'BR', 1),
(3203, 'Flores Department', 'UY', 'FS', 1),
(3204, 'San José Department', 'UY', 'SJ', 1),
(3205, 'Artigas Department', 'UY', 'AR', 1),
(3206, 'Maldonado Department', 'UY', 'MA', 1),
(3207, 'Rivera Department', 'UY', 'RV', 1),
(3208, 'Colonia Department', 'UY', 'CO', 1),
(3209, 'Durazno Department', 'UY', 'DU', 1),
(3210, 'Río Negro Department', 'UY', 'RN', 1),
(3211, 'Cerro Largo Department', 'UY', 'CL', 1),
(3212, 'Paysandú Department', 'UY', 'PA', 1),
(3213, 'Canelones Department', 'UY', 'CA', 1),
(3214, 'Treinta y Tres Department', 'UY', 'TT', 1),
(3215, 'Lavalleja Department', 'UY', 'LA', 1),
(3216, 'Rocha Department', 'UY', 'RO', 1),
(3217, 'Florida Department', 'UY', 'FD', 1),
(3218, 'Montevideo Department', 'UY', 'MO', 1),
(3219, 'Soriano Department', 'UY', 'SO', 1),
(3220, 'Salto Department', 'UY', 'SA', 1),
(3221, 'Tacuarembó Department', 'UY', 'TA', 1),
(3222, 'Kafr el-Sheikh', 'EG', 'KFS', 1),
(3223, 'Cairo', 'EG', 'C', 1),
(3224, 'Damietta', 'EG', 'DT', 1),
(3225, 'Aswan', 'EG', 'ASN', 1),
(3226, 'Sohag', 'EG', 'SHG', 1),
(3227, 'North Sinai', 'EG', 'SIN', 1),
(3228, 'Monufia', 'EG', 'MNF', 1),
(3229, 'Port Said', 'EG', 'PTS', 1),
(3230, 'Beni Suef', 'EG', 'BNS', 1),
(3231, 'Matrouh', 'EG', 'MT', 1),
(3232, 'Qalyubia', 'EG', 'KB', 1),
(3233, 'Suez', 'EG', 'SUZ', 1),
(3234, 'Gharbia', 'EG', 'GH', 1),
(3235, 'Alexandria', 'EG', 'ALX', 1),
(3236, 'Asyut', 'EG', 'AST', 1),
(3237, 'South Sinai', 'EG', 'JS', 1),
(3238, 'Faiyum', 'EG', 'FYM', 1),
(3239, 'Giza', 'EG', 'GZ', 1),
(3240, 'Red Sea', 'EG', 'BA', 1),
(3241, 'Beheira', 'EG', 'BH', 1),
(3242, 'Luxor', 'EG', 'LX', 1),
(3243, 'Minya', 'EG', 'MN', 1),
(3244, 'Ismailia', 'EG', 'IS', 1),
(3245, 'Dakahlia', 'EG', 'DK', 1),
(3246, 'New Valley', 'EG', 'WAD', 1),
(3247, 'Qena', 'EG', 'KN', 1),
(3248, 'Agaléga', 'MU', 'AG', 1),
(3249, 'Rodrigues', 'MU', 'RO', 1),
(3250, 'Pamplemousses District', 'MU', 'PA', 1),
(3251, 'Cargados Carajos', 'MU', 'CC', 1),
(3252, 'Vacoas-Phoenix', 'MU', 'VP', 1),
(3253, 'Moka District', 'MU', 'MO', 1),
(3254, 'Flacq District', 'MU', 'FL', 1),
(3255, 'Curepipe', 'MU', 'CU', 1),
(3256, 'Port Louis', 'MU', 'PU', 1),
(3257, 'Savanne District', 'MU', 'SA', 1),
(3258, 'Quatre Bornes', 'MU', 'QB', 1),
(3259, 'Rivière Noire District', 'MU', 'BL', 1),
(3260, 'Port Louis District', 'MU', 'PL', 1),
(3261, 'Rivière du Rempart District', 'MU', 'RR', 1),
(3262, 'Beau Bassin-Rose Hill', 'MU', 'BR', 1),
(3263, 'Plaines Wilhems District', 'MU', 'PW', 1),
(3264, 'Grand Port District', 'MU', 'GP', 1),
(3265, 'Guelmim', 'MA', 'GUE', 1),
(3266, 'Aousserd (EH)', 'MA', 'AOU', 1),
(3267, 'Al Hoceïma', 'MA', 'HOC', 1),
(3268, 'Larache', 'MA', 'LAR', 1),
(3269, 'Ouarzazate', 'MA', 'OUA', 1),
(3270, 'Boulemane', 'MA', 'BOM', 1),
(3271, 'L''Oriental', 'MA', '02', 1),
(3272, 'Béni Mellal', 'MA', 'BEM', 1),
(3274, 'Chichaoua', 'MA', 'CHI', 1),
(3275, 'Boujdour (EH)', 'MA', 'BOD', 1),
(3276, 'Khémisset', 'MA', 'KHE', 1),
(3277, 'Tiznit', 'MA', 'TIZ', 1),
(3278, 'Béni Mellal-Khénifra', 'MA', '05', 1),
(3279, 'Sidi Kacem', 'MA', 'SIK', 1),
(3280, 'El Jadida', 'MA', 'JDI', 1),
(3281, 'Nador', 'MA', 'NAD', 1),
(3282, 'Settat', 'MA', 'SET', 1),
(3283, 'Zagora', 'MA', 'ZAG', 1),
(3284, 'Médiouna', 'MA', 'MED', 1),
(3285, 'Berkane', 'MA', 'BER', 1),
(3286, 'Tan-Tan (EH-partial)', 'MA', 'TNT', 1),
(3287, 'Nouaceur', 'MA', 'NOU', 1),
(3288, 'Marrakesh-Safi', 'MA', '07', 1),
(3289, 'Sefrou', 'MA', 'SEF', 1),
(3290, 'Drâa-Tafilalet', 'MA', '08', 1),
(3291, 'El Hajeb', 'MA', 'HAJ', 1),
(3292, 'Es-Semara (EH-partial)', 'MA', 'ESM', 1),
(3293, 'Laâyoune (EH)', 'MA', 'LAA', 1),
(3294, 'Inezgane-Ait Melloul', 'MA', 'INE', 1),
(3295, 'Souss-Massa', 'MA', '09', 1),
(3296, 'Taza', 'MA', 'TAZ', 1),
(3297, 'Assa-Zag (EH-partial)', 'MA', 'ASZ', 1),
(3298, 'Laâyoune-Sakia El Hamra (EH-partial)', 'MA', '11', 1),
(3299, 'Errachidia', 'MA', 'ERR', 1),
(3300, 'Fahs-Anjra', 'MA', 'FAH', 1),
(3301, 'Figuig', 'MA', 'FIG', 1),
(3302, 'Chtouka-Ait Baha', 'MA', 'CHT', 1),
(3303, 'Casablanca-Settat', 'MA', '06', 1),
(3304, 'Benslimane', 'MA', 'BES', 1),
(3305, 'Guelmim-Oued Noun (EH-partial)', 'MA', '10', 1),
(3306, 'Dakhla-Oued Ed-Dahab (EH)', 'MA', '12', 1),
(3307, 'Jerada', 'MA', 'JRA', 1),
(3308, 'Kénitra', 'MA', 'KEN', 1),
(3309, 'El Kelâa des Sraghna', 'MA', 'KES', 1),
(3310, 'Chefchaouen', 'MA', 'CHE', 1),
(3311, 'Safi', 'MA', 'SAF', 1),
(3312, 'Tata', 'MA', 'TAT', 1),
(3313, 'Fès-Meknès', 'MA', '03', 1),
(3314, 'Taroudannt', 'MA', 'TAR', 1),
(3315, 'Moulay Yacoub', 'MA', 'MOU', 1),
(3316, 'Essaouira', 'MA', 'ESI', 1),
(3317, 'Khénifra', 'MA', 'KHN', 1),
(3318, 'Tétouan', 'MA', 'TET', 1),
(3319, 'Oued Ed-Dahab (EH)', 'MA', 'OUD', 1),
(3320, 'Al Haouz', 'MA', 'HAO', 1),
(3321, 'Azilal', 'MA', 'AZI', 1),
(3322, 'Taourirt', 'MA', 'TAI', 1),
(3323, 'Taounate', 'MA', 'TAO', 1),
(3324, 'Tanger-Tétouan-Al Hoceïma', 'MA', '01', 1),
(3325, 'Ifrane', 'MA', 'IFR', 1),
(3326, 'Khouribga', 'MA', 'KHO', 1),
(3327, 'Cabo Delgado Province', 'MZ', 'P', 1),
(3328, 'Zambezia Province', 'MZ', 'Q', 1),
(3329, 'Gaza Province', 'MZ', 'G', 1),
(3330, 'Inhambane Province', 'MZ', 'I', 1),
(3331, 'Sofala Province', 'MZ', 'S', 1),
(3332, 'Maputo Province', 'MZ', 'L', 1),
(3333, 'Niassa Province', 'MZ', 'A', 1),
(3334, 'Tete Province', 'MZ', 'T', 1),
(3335, 'Maputo', 'MZ', 'MPM', 1),
(3336, 'Nampula Province', 'MZ', 'N', 1),
(3337, 'Manica Province', 'MZ', 'B', 1),
(3338, 'Hodh Ech Chargui', 'MR', '01', 1),
(3339, 'Brakna', 'MR', '05', 1),
(3340, 'Tiris Zemmour', 'MR', '11', 1),
(3341, 'Gorgol', 'MR', '04', 1),
(3342, 'Inchiri', 'MR', '12', 1),
(3343, 'Nouakchott-Nord', 'MR', '14', 1),
(3344, 'Adrar', 'MR', '07', 1),
(3345, 'Tagant', 'MR', '09', 1),
(3346, 'Dakhlet Nouadhibou', 'MR', '08', 1),
(3347, 'Nouakchott-Sud', 'MR', '15', 1),
(3348, 'Trarza', 'MR', '06', 1),
(3349, 'Assaba', 'MR', '03', 1),
(3350, 'Guidimaka', 'MR', '10', 1),
(3351, 'Hodh El Gharbi', 'MR', '02', 1),
(3352, 'Nouakchott-Ouest', 'MR', '13', 1),
(3353, 'Western Tobago', 'TT', 'WTO', 1),
(3354, 'Couva-Tabaquite-Talparo Regional Corporation', 'TT', 'CTT', 1),
(3355, 'Eastern Tobago', 'TT', 'ETO', 1),
(3356, 'Rio Claro-Mayaro Regional Corporation', 'TT', 'MRC', 1),
(3357, 'San Juan-Laventille Regional Corporation', 'TT', 'SJL', 1),
(3358, 'Tunapuna-Piarco Regional Corporation', 'TT', 'TUP', 1),
(3359, 'San Fernando', 'TT', 'SFO', 1),
(3360, 'Point Fortin', 'TT', 'PTF', 1),
(3361, 'Sangre Grande Regional Corporation', 'TT', 'SGE', 1),
(3362, 'Arima', 'TT', 'ARI', 1),
(3363, 'Port of Spain', 'TT', 'POS', 1),
(3364, 'Siparia Regional Corporation', 'TT', 'SIP', 1),
(3365, 'Penal-Debe Regional Corporation', 'TT', 'PED', 1),
(3366, 'Chaguanas', 'TT', 'CHA', 1),
(3367, 'Diego Martin Regional Corporation', 'TT', 'DMN', 1),
(3368, 'Princes Town Regional Corporation', 'TT', 'PRT', 1),
(3369, 'Mary Region', 'TM', 'M', 1),
(3370, 'Lebap Region', 'TM', 'L', 1),
(3371, 'Ashgabat', 'TM', 'S', 1),
(3372, 'Balkan Region', 'TM', 'B', 1),
(3373, 'Daşoguz Region', 'TM', 'D', 1),
(3374, 'Ahal Region', 'TM', 'A', 1),
(3375, 'Beni Department', 'BO', 'B', 1),
(3376, 'Oruro Department', 'BO', 'O', 1),
(3377, 'Santa Cruz Department', 'BO', 'S', 1),
(3378, 'Tarija Department', 'BO', 'T', 1),
(3379, 'Pando Department', 'BO', 'N', 1),
(3380, 'La Paz Department', 'BO', 'L', 1),
(3381, 'Cochabamba Department', 'BO', 'C', 1),
(3382, 'Chuquisaca Department', 'BO', 'H', 1),
(3383, 'Potosí Department', 'BO', 'P', 1),
(3384, 'Saint George Parish', 'VC', '04', 1),
(3385, 'Saint Patrick Parish', 'VC', '05', 1),
(3386, 'Saint Andrew Parish', 'VC', '02', 1),
(3387, 'Saint David Parish', 'VC', '03', 1),
(3388, 'Grenadines Parish', 'VC', '06', 1),
(3389, 'Charlotte Parish', 'VC', '01', 1),
(3390, 'Sharjah Emirate', 'AE', 'SH', 1),
(3391, 'Dubai', 'AE', 'DU', 1),
(3392, 'Umm al-Quwain', 'AE', 'UQ', 1),
(3393, 'Fujairah', 'AE', 'FU', 1),
(3394, 'Ras al-Khaimah', 'AE', 'RK', 1),
(3395, 'Ajman Emirate', 'AE', 'AJ', 1),
(3396, 'Abu Dhabi Emirate', 'AE', 'AZ', 1),
(3397, 'districts of Republican Subordination', 'TJ', 'RA', 1),
(3398, 'Khatlon Province', 'TJ', 'KT', 1),
(3399, 'Gorno-Badakhshan Autonomous Province', 'TJ', 'GB', 1),
(3400, 'Sughd Province', 'TJ', 'SU', 1),
(3402, 'Yilan', 'TW', 'ILA', 1),
(3403, 'Penghu', 'TW', 'PEN', 1),
(3404, 'Changhua', 'TW', 'CHA', 1),
(3405, 'Pingtung', 'TW', 'PIF', 1),
(3406, 'Taichung', 'TW', 'TXG', 1),
(3407, 'Nantou', 'TW', 'NAN', 1),
(3408, 'Chiayi', 'TW', 'CYI', 1),
(3410, 'Taitung', 'TW', 'TTT', 1),
(3411, 'Hualien', 'TW', 'HUA', 1),
(3412, 'Kaohsiung', 'TW', 'KHH', 1),
(3413, 'Miaoli', 'TW', 'MIA', 1),
(3415, 'Kinmen', 'TW', 'KIN', 1),
(3416, 'Yunlin', 'TW', 'YUN', 1),
(3417, 'Hsinchu', 'TW', 'HSZ', 1),
(3418, 'Chiayi', 'TW', 'CYQ', 1),
(3419, 'Taoyuan', 'TW', 'TAO', 1),
(3420, 'Lienchiang', 'TW', 'LIE', 1),
(3421, 'Tainan', 'TW', 'TNN', 1),
(3422, 'Taipei', 'TW', 'TPE', 1),
(3423, 'Hsinchu', 'TW', 'HSQ', 1),
(3424, 'Northern Red Sea Region', 'ER', 'SK', 1),
(3425, 'Anseba Region', 'ER', 'AN', 1),
(3426, 'Maekel Region', 'ER', 'MA', 1),
(3427, 'Debub Region', 'ER', 'DU', 1),
(3428, 'Gash-Barka Region', 'ER', 'GB', 1),
(3429, 'Southern Red Sea Region', 'ER', 'DK', 1),
(3430, 'Southern Peninsula Region', 'IS', '2', 1),
(3431, 'Capital Region', 'IS', '1', 1),
(3432, 'Westfjords', 'IS', '4', 1),
(3433, 'Eastern Region', 'IS', '7', 1),
(3434, 'Southern Region', 'IS', '8', 1),
(3435, 'Northwestern Region', 'IS', '5', 1),
(3436, 'Western Region', 'IS', '3', 1),
(3437, 'Northeastern Region', 'IS', '6', 1),
(3438, 'Río Muni', 'GQ', 'C', 1),
(3439, 'Kié-Ntem Province', 'GQ', 'KN', 1),
(3440, 'Wele-Nzas Province', 'GQ', 'WN', 1),
(3441, 'Litoral Province', 'GQ', 'LI', 1),
(3442, 'Insular Region', 'GQ', 'I', 1),
(3443, 'Bioko Sur Province', 'GQ', 'BS', 1),
(3444, 'Annobón Province', 'GQ', 'AN', 1),
(3445, 'Centro Sur Province', 'GQ', 'CS', 1),
(3446, 'Bioko Norte Province', 'GQ', 'BN', 1),
(3447, 'Chihuahua', 'MX', 'CHH', 1),
(3448, 'Oaxaca', 'MX', 'OAX', 1),
(3449, 'Sinaloa', 'MX', 'SIN', 1),
(3450, 'Estado de México', 'MX', 'MEX', 1),
(3451, 'Chiapas', 'MX', 'CHP', 1),
(3452, 'Nuevo León', 'MX', 'NLE', 1),
(3453, 'Durango', 'MX', 'DUR', 1),
(3454, 'Tabasco', 'MX', 'TAB', 1),
(3455, 'Querétaro', 'MX', 'QUE', 1),
(3456, 'Aguascalientes', 'MX', 'AGU', 1),
(3457, 'Baja California', 'MX', 'BCN', 1),
(3458, 'Tlaxcala', 'MX', 'TLA', 1),
(3459, 'Guerrero', 'MX', 'GRO', 1),
(3460, 'Baja California Sur', 'MX', 'BCS', 1),
(3461, 'San Luis Potosí', 'MX', 'SLP', 1),
(3462, 'Zacatecas', 'MX', 'ZAC', 1),
(3463, 'Tamaulipas', 'MX', 'TAM', 1),
(3464, 'Veracruz de Ignacio de la Llave', 'MX', 'VER', 1),
(3465, 'Morelos', 'MX', 'MOR', 1),
(3466, 'Yucatán', 'MX', 'YUC', 1),
(3467, 'Quintana Roo', 'MX', 'ROO', 1),
(3468, 'Sonora', 'MX', 'SON', 1),
(3469, 'Guanajuato', 'MX', 'GUA', 1),
(3470, 'Hidalgo', 'MX', 'HID', 1),
(3471, 'Coahuila de Zaragoza', 'MX', 'COA', 1),
(3472, 'Colima', 'MX', 'COL', 1),
(3473, 'Ciudad de México', 'MX', 'CDMX', 1),
(3474, 'Michoacán de Ocampo', 'MX', 'MIC', 1),
(3475, 'Campeche', 'MX', 'CAM', 1),
(3476, 'Puebla', 'MX', 'PUE', 1),
(3477, 'Nayarit', 'MX', 'NAY', 1),
(3478, 'Krabi', 'TH', '81', 1),
(3479, 'Ranong', 'TH', '85', 1),
(3480, 'Nong Bua Lam Phu', 'TH', '39', 1),
(3481, 'Samut Prakan', 'TH', '11', 1),
(3482, 'Surat Thani', 'TH', '84', 1),
(3483, 'Lamphun', 'TH', '51', 1),
(3484, 'Nong Khai', 'TH', '43', 1),
(3485, 'Khon Kaen', 'TH', '40', 1),
(3486, 'Chanthaburi', 'TH', '22', 1),
(3487, 'Saraburi', 'TH', '19', 1),
(3488, 'Phatthalung', 'TH', '93', 1),
(3489, 'Uttaradit', 'TH', '53', 1),
(3490, 'Sing Buri', 'TH', '17', 1),
(3491, 'Chiang Mai', 'TH', '50', 1),
(3492, 'Nakhon Sawan', 'TH', '60', 1),
(3493, 'Yala', 'TH', '95', 1),
(3494, 'Phra Nakhon Si Ayutthaya', 'TH', '14', 1),
(3495, 'Nonthaburi', 'TH', '12', 1),
(3496, 'Trat', 'TH', '23', 1),
(3497, 'Nakhon Ratchasima', 'TH', '30', 1),
(3498, 'Chiang Rai', 'TH', '57', 1),
(3499, 'Ratchaburi', 'TH', '70', 1),
(3500, 'Pathum Thani', 'TH', '13', 1),
(3501, 'Sakon Nakhon', 'TH', '47', 1),
(3502, 'Samut Songkhram', 'TH', '75', 1),
(3503, 'Nakhon Pathom', 'TH', '73', 1),
(3504, 'Samut Sakhon', 'TH', '74', 1),
(3505, 'Mae Hong Son', 'TH', '58', 1),
(3506, 'Phitsanulok', 'TH', '65', 1),
(3507, 'Pattaya', 'TH', 'S', 1),
(3508, 'Prachuap Khiri Khan', 'TH', '77', 1),
(3509, 'Loei', 'TH', '42', 1),
(3510, 'Roi Et', 'TH', '45', 1),
(3511, 'Kanchanaburi', 'TH', '71', 1),
(3512, 'Ubon Ratchathani', 'TH', '34', 1),
(3513, 'Chon Buri', 'TH', '20', 1),
(3514, 'Phichit', 'TH', '66', 1),
(3515, 'Phetchabun', 'TH', '67', 1),
(3516, 'Kamphaeng Phet', 'TH', '62', 1),
(3517, 'Maha Sarakham', 'TH', '44', 1),
(3518, 'Rayong', 'TH', '21', 1),
(3519, 'Ang Thong', 'TH', '15', 1),
(3520, 'Nakhon Si Thammarat', 'TH', '80', 1),
(3521, 'Yasothon', 'TH', '35', 1),
(3522, 'Chai Nat', 'TH', '18', 1),
(3523, 'Amnat Charoen', 'TH', '37', 1),
(3524, 'Suphan Buri', 'TH', '72', 1),
(3525, 'Tak', 'TH', '63', 1),
(3526, 'Chumphon', 'TH', '86', 1),
(3527, 'Udon Thani', 'TH', '41', 1),
(3528, 'Phrae', 'TH', '54', 1),
(3529, 'Sa Kaeo', 'TH', '27', 1),
(3530, 'Nan', 'TH', '55', 1),
(3531, 'Surin', 'TH', '32', 1),
(3532, 'Phetchaburi', 'TH', '76', 1),
(3533, 'Bueng Kan', 'TH', '38', 1),
(3534, 'Buri Ram', 'TH', '31', 1),
(3535, 'Nakhon Nayok', 'TH', '26', 1),
(3536, 'Phuket', 'TH', '83', 1),
(3537, 'Satun', 'TH', '91', 1),
(3538, 'Phayao', 'TH', '56', 1),
(3539, 'Songkhla', 'TH', '90', 1),
(3540, 'Pattani', 'TH', '94', 1),
(3541, 'Trang', 'TH', '92', 1),
(3542, 'Prachin Buri', 'TH', '25', 1),
(3543, 'Lop Buri', 'TH', '16', 1),
(3544, 'Lampang', 'TH', '52', 1),
(3545, 'Sukhothai', 'TH', '64', 1),
(3546, 'Mukdahan', 'TH', '49', 1),
(3547, 'Si Sa Ket', 'TH', '33', 1),
(3548, 'Nakhon Phanom', 'TH', '48', 1),
(3549, 'Phangnga', 'TH', '82', 1),
(3550, 'Kalasin', 'TH', '46', 1),
(3551, 'Uthai Thani', 'TH', '61', 1),
(3552, 'Chachoengsao', 'TH', '24', 1),
(3553, 'Narathiwat', 'TH', '96', 1),
(3554, 'Bangkok', 'TH', '10', 1),
(3555, 'Hiiu County', 'EE', '39', 1),
(3556, 'Viljandi County', 'EE', '84', 1),
(3557, 'Tartu County', 'EE', '78', 1),
(3558, 'Valga County', 'EE', '82', 1),
(3559, 'Rapla County', 'EE', '70', 1),
(3560, 'Võru County', 'EE', '86', 1),
(3561, 'Saare County', 'EE', '74', 1),
(3562, 'Pärnu County', 'EE', '67', 1),
(3563, 'Põlva County', 'EE', '65', 1),
(3564, 'Lääne-Viru County', 'EE', '59', 1),
(3565, 'Jõgeva County', 'EE', '49', 1),
(3566, 'Järva County', 'EE', '51', 1),
(3567, 'Harju County', 'EE', '37', 1),
(3568, 'Lääne County', 'EE', '57', 1),
(3569, 'Ida-Viru County', 'EE', '44', 1),
(3570, 'Moyen-Chari', 'TD', 'MC', 1),
(3571, 'Mayo-Kebbi Ouest', 'TD', 'MO', 1),
(3572, 'Sila', 'TD', 'SI', 1),
(3573, 'Hadjer-Lamis', 'TD', 'HL', 1),
(3574, 'Borkou', 'TD', 'BO', 1),
(3575, 'Ennedi-Est', 'TD', 'EE', 1),
(3576, 'Guéra', 'TD', 'GR', 1),
(3577, 'Lac', 'TD', 'LC', 1),
(3579, 'Tandjilé', 'TD', 'TA', 1),
(3580, 'Mayo-Kebbi Est', 'TD', 'ME', 1),
(3581, 'Wadi Fira', 'TD', 'WF', 1),
(3582, 'Ouaddaï', 'TD', 'OD', 1),
(3583, 'Bahr el Gazel', 'TD', 'BG', 1),
(3584, 'Ennedi-Ouest', 'TD', 'EO', 1),
(3585, 'Logone Occidental', 'TD', 'LO', 1),
(3586, 'N''Djamena', 'TD', 'ND', 1),
(3587, 'Tibesti', 'TD', 'TI', 1),
(3588, 'Kanem', 'TD', 'KA', 1),
(3589, 'Mandoul', 'TD', 'MA', 1),
(3590, 'Batha', 'TD', 'BA', 1),
(3591, 'Logone Oriental', 'TD', 'LR', 1),
(3592, 'Salamat', 'TD', 'SA', 1),
(3593, 'Berry Islands', 'BS', 'BY', 1),
(3594, 'Nichollstown and Berry Islands', 'BS', 'NB', 1),
(3595, 'Green Turtle Cay', 'BS', 'GT', 1),
(3596, 'Central Eleuthera', 'BS', 'CE', 1),
(3597, 'Governor''s Harbour', 'BS', 'GH', 1),
(3598, 'High Rock', 'BS', 'HR', 1),
(3599, 'West Grand Bahama', 'BS', 'WG', 1),
(3600, 'Rum Cay District', 'BS', 'RC', 1),
(3601, 'Acklins', 'BS', 'AK', 1),
(3602, 'North Eleuthera', 'BS', 'NE', 1),
(3603, 'Central Abaco', 'BS', 'CO', 1),
(3604, 'Marsh Harbour', 'BS', 'MH', 1),
(3605, 'Black Point', 'BS', 'BP', 1),
(3606, 'Sandy Point', 'BS', 'SP', 1),
(3607, 'South Eleuthera', 'BS', 'SE', 1),
(3608, 'South Abaco', 'BS', 'SO', 1),
(3609, 'Inagua', 'BS', 'IN', 1),
(3610, 'Long Island', 'BS', 'LI', 1),
(3611, 'Cat Island', 'BS', 'CI', 1),
(3612, 'Exuma', 'BS', 'EX', 1),
(3613, 'Harbour Island', 'BS', 'HI', 1),
(3614, 'East Grand Bahama', 'BS', 'EG', 1),
(3615, 'Ragged Island', 'BS', 'RI', 1),
(3616, 'North Abaco', 'BS', 'NO', 1),
(3617, 'North Andros', 'BS', 'NS', 1),
(3618, 'Kemps Bay', 'BS', 'KB', 1),
(3619, 'Fresh Creek', 'BS', 'FC', 1),
(3620, 'San Salvador and Rum Cay', 'BS', 'SR', 1),
(3621, 'Crooked Island', 'BS', 'CK', 1),
(3622, 'South Andros', 'BS', 'SA', 1),
(3623, 'Rock Sound', 'BS', 'RS', 1),
(3624, 'Hope Town', 'BS', 'HT', 1),
(3625, 'Mangrove Cay', 'BS', 'MC', 1),
(3626, 'Freeport', 'BS', 'FP', 1),
(3627, 'San Salvador Island', 'BS', 'SS', 1),
(3628, 'Acklins and Crooked Islands', 'BS', 'AC', 1),
(3629, 'Bimini', 'BS', 'BI', 1),
(3630, 'Spanish Wells', 'BS', 'SW', 1),
(3631, 'Central Andros', 'BS', 'CS', 1),
(3632, 'Grand Cay', 'BS', 'GC', 1),
(3633, 'Mayaguana District', 'BS', 'MG', 1),
(3634, 'San Juan', 'AR', 'J', 1),
(3635, 'Santiago del Estero', 'AR', 'G', 1),
(3636, 'San Luis', 'AR', 'D', 1),
(3637, 'Tucumán', 'AR', 'T', 1),
(3638, 'Corrientes', 'AR', 'W', 1),
(3639, 'Río Negro', 'AR', 'R', 1),
(3640, 'Chaco', 'AR', 'H', 1),
(3641, 'Santa Fe', 'AR', 'S', 1),
(3642, 'Córdoba', 'AR', 'X', 1),
(3643, 'Salta', 'AR', 'A', 1),
(3644, 'Misiones', 'AR', 'N', 1),
(3645, 'Jujuy', 'AR', 'Y', 1),
(3646, 'Mendoza', 'AR', 'M', 1),
(3647, 'Catamarca', 'AR', 'K', 1),
(3648, 'Neuquén', 'AR', 'Q', 1),
(3649, 'Santa Cruz', 'AR', 'Z', 1),
(3650, 'Tierra del Fuego', 'AR', 'V', 1),
(3651, 'Chubut', 'AR', 'U', 1),
(3652, 'Formosa', 'AR', 'P', 1),
(3653, 'La Rioja', 'AR', 'F', 1),
(3654, 'Entre Ríos', 'AR', 'E', 1),
(3655, 'La Pampa', 'AR', 'L', 1),
(3656, 'Buenos Aires', 'AR', 'B', 1),
(3657, 'Quiché Department', 'GT', 'QC', 1),
(3658, 'Jalapa Department', 'GT', 'JA', 1),
(3659, 'Izabal Department', 'GT', 'IZ', 1),
(3660, 'Suchitepéquez Department', 'GT', 'SU', 1),
(3661, 'Sololá Department', 'GT', 'SO', 1),
(3662, 'El Progreso Department', 'GT', 'PR', 1),
(3663, 'Totonicapán Department', 'GT', 'TO', 1),
(3664, 'Retalhuleu Department', 'GT', 'RE', 1),
(3665, 'Santa Rosa Department', 'GT', 'SR', 1),
(3666, 'Chiquimula Department', 'GT', 'CQ', 1),
(3667, 'San Marcos Department', 'GT', 'SM', 1),
(3668, 'Quetzaltenango Department', 'GT', 'QZ', 1),
(3669, 'Petén Department', 'GT', 'PE', 1),
(3670, 'Huehuetenango Department', 'GT', 'HU', 1),
(3671, 'Alta Verapaz Department', 'GT', 'AV', 1),
(3672, 'Guatemala Department', 'GT', 'GU', 1),
(3673, 'Jutiapa Department', 'GT', 'JU', 1),
(3674, 'Baja Verapaz Department', 'GT', 'BV', 1),
(3675, 'Chimaltenango Department', 'GT', 'CM', 1),
(3676, 'Sacatepéquez Department', 'GT', 'SA', 1),
(3677, 'Escuintla Department', 'GT', 'ES', 1),
(3678, 'Madre de Dios', 'PE', 'MDD', 1),
(3679, 'Huancavelica', 'PE', 'HUV', 1),
(3680, 'Áncash', 'PE', 'ANC', 1),
(3681, 'Arequipa', 'PE', 'ARE', 1),
(3682, 'Puno', 'PE', 'PUN', 1),
(3683, 'La Libertad', 'PE', 'LAL', 1),
(3684, 'Ucayali', 'PE', 'UCA', 1),
(3685, 'Amazonas', 'PE', 'AMA', 1),
(3686, 'Pasco', 'PE', 'PAS', 1),
(3687, 'Huanuco', 'PE', 'HUC', 1),
(3688, 'Cajamarca', 'PE', 'CAJ', 1),
(3689, 'Tumbes', 'PE', 'TUM', 1),
(3691, 'Cusco', 'PE', 'CUS', 1),
(3692, 'Ayacucho', 'PE', 'AYA', 1),
(3693, 'Junín', 'PE', 'JUN', 1),
(3694, 'San Martín', 'PE', 'SAM', 1),
(3695, 'Lima', 'PE', 'LIM', 1),
(3696, 'Tacna', 'PE', 'TAC', 1),
(3697, 'Piura', 'PE', 'PIU', 1),
(3698, 'Moquegua', 'PE', 'MOQ', 1),
(3699, 'Apurímac', 'PE', 'APU', 1),
(3700, 'Ica', 'PE', 'ICA', 1),
(3701, 'Callao', 'PE', 'CAL', 1),
(3702, 'Lambayeque', 'PE', 'LAM', 1),
(3703, 'Redonda', 'AG', '11', 1),
(3704, 'Saint Peter Parish', 'AG', '07', 1),
(3705, 'Saint Paul Parish', 'AG', '06', 1),
(3706, 'Saint John Parish', 'AG', '04', 1),
(3707, 'Saint Mary Parish', 'AG', '05', 1),
(3708, 'Barbuda', 'AG', '10', 1),
(3709, 'Saint George Parish', 'AG', '03', 1),
(3710, 'Saint Philip Parish', 'AG', '08', 1),
(3711, 'South Bačka District', 'RS', '06', 1),
(3712, 'Pirot District', 'RS', '22', 1),
(3713, 'South Banat District', 'RS', '04', 1),
(3714, 'North Bačka District', 'RS', '01', 1),
(3715, 'Jablanica District', 'RS', '23', 1),
(3716, 'Central Banat District', 'RS', '02', 1),
(3717, 'Bor District', 'RS', '14', 1),
(3718, 'Toplica District', 'RS', '21', 1),
(3719, 'Mačva District', 'RS', '08', 1),
(3720, 'Rasina District', 'RS', '19', 1),
(3721, 'Pčinja District', 'RS', '24', 1),
(3722, 'Nišava District', 'RS', '20', 1),
(3723, 'Prizren District', 'XK', 'XPR', 1),
(3724, 'Kolubara District', 'RS', '09', 1),
(3725, 'Raška District', 'RS', '18', 1),
(3726, 'West Bačka District', 'RS', '05', 1),
(3727, 'Moravica District', 'RS', '17', 1),
(3728, 'Belgrade', 'RS', '00', 1),
(3729, 'Zlatibor District', 'RS', '16', 1),
(3731, 'Zaječar District', 'RS', '15', 1),
(3732, 'Braničevo District', 'RS', '11', 1),
(3733, 'Vojvodina', 'RS', 'VO', 1),
(3734, 'Šumadija District', 'RS', '12', 1),
(3736, 'North Banat District', 'RS', '03', 1),
(3737, 'Pomoravlje District', 'RS', '13', 1),
(3738, 'Peć District', 'XK', 'XPE', 1),
(3740, 'Srem District', 'RS', '07', 1),
(3741, 'Podunavlje District', 'RS', '10', 1),
(3742, 'Westmoreland Parish', 'JM', '10', 1),
(3743, 'Saint Elizabeth Parish', 'JM', '11', 1),
(3744, 'Saint Ann Parish', 'JM', '06', 1),
(3745, 'Saint James Parish', 'JM', '08', 1),
(3746, 'Saint Catherine Parish', 'JM', '14', 1),
(3747, 'Saint Mary Parish', 'JM', '05', 1),
(3748, 'Kingston Parish', 'JM', '01', 1),
(3749, 'Hanover Parish', 'JM', '09', 1),
(3750, 'Saint Thomas Parish', 'JM', '03', 1),
(3751, 'Saint Andrew', 'JM', '02', 1),
(3752, 'Portland Parish', 'JM', '04', 1),
(3753, 'Clarendon Parish', 'JM', '13', 1),
(3754, 'Manchester Parish', 'JM', '12', 1),
(3755, 'Trelawny Parish', 'JM', '07', 1),
(3756, 'Dennery Quarter', 'LC', '05', 1),
(3757, 'Anse la Raye Quarter', 'LC', '01', 1),
(3758, 'Castries Quarter', 'LC', '02', 1),
(3759, 'Laborie Quarter', 'LC', '07', 1),
(3760, 'Choiseul Quarter', 'LC', '03', 1),
(3761, 'Canaries', 'LC', '12', 1),
(3762, 'Micoud Quarter', 'LC', '08', 1),
(3763, 'Vieux Fort Quarter', 'LC', '11', 1),
(3764, 'Soufrière Quarter', 'LC', '10', 1),
(3765, 'Praslin Quarter', 'LC', '09', 1),
(3766, 'Gros Islet Quarter', 'LC', '06', 1),
(3767, 'Dauphin Quarter', 'LC', '04', 1),
(3768, 'Hưng Yên', 'VN', '66', 1),
(3769, 'Đồng Tháp', 'VN', '45', 1),
(3770, 'Bà Rịa-Vũng Tàu', 'VN', '43', 1),
(3771, 'Thanh Hóa', 'VN', '21', 1),
(3772, 'Kon Tum', 'VN', '28', 1),
(3773, 'Điện Biên', 'VN', '71', 1),
(3774, 'Vĩnh Phúc', 'VN', '70', 1),
(3775, 'Thái Bình', 'VN', '20', 1),
(3776, 'Quảng Nam', 'VN', '27', 1),
(3777, 'Hậu Giang', 'VN', '73', 1),
(3778, 'Cà Mau', 'VN', '59', 1),
(3779, 'Hà Giang', 'VN', '03', 1),
(3780, 'Nghệ An', 'VN', '22', 1),
(3781, 'Tiền Giang', 'VN', '46', 1),
(3782, 'Cao Bằng', 'VN', '04', 1),
(3783, 'Hải Phòng', 'VN', 'HP', 1),
(3784, 'Yên Bái', 'VN', '06', 1),
(3785, 'Bình Dương', 'VN', '57', 1),
(3786, 'Ninh Bình', 'VN', '18', 1),
(3787, 'Bình Thuận', 'VN', '40', 1),
(3788, 'Ninh Thuận', 'VN', '36', 1),
(3789, 'Nam Định', 'VN', '67', 1),
(3790, 'Vĩnh Long', 'VN', '49', 1),
(3791, 'Bắc Ninh', 'VN', '56', 1),
(3792, 'Lạng Sơn', 'VN', '09', 1),
(3793, 'Khánh Hòa', 'VN', '34', 1),
(3794, 'An Giang', 'VN', '44', 1),
(3795, 'Tuyên Quang', 'VN', '07', 1),
(3796, 'Bến Tre', 'VN', '50', 1),
(3797, 'Bình Phước', 'VN', '58', 1),
(3798, 'Thừa Thiên-Huế', 'VN', '26', 1),
(3799, 'Hòa Bình', 'VN', '14', 1),
(3800, 'Kiên Giang', 'VN', '47', 1),
(3801, 'Phú Thọ', 'VN', '68', 1),
(3802, 'Hà Nam', 'VN', '63', 1),
(3803, 'Quảng Trị', 'VN', '25', 1),
(3804, 'Bạc Liêu', 'VN', '55', 1),
(3805, 'Trà Vinh', 'VN', '51', 1),
(3806, 'Đà Nẵng', 'VN', 'DN', 1),
(3807, 'Thái Nguyên', 'VN', '69', 1),
(3808, 'Long An', 'VN', '41', 1),
(3809, 'Quảng Bình', 'VN', '24', 1),
(3810, 'Hà Nội', 'VN', 'HN', 1),
(3811, 'Hồ Chí Minh', 'VN', 'SG', 1),
(3812, 'Sơn La', 'VN', '05', 1),
(3813, 'Gia Lai', 'VN', '30', 1),
(3814, 'Quảng Ninh', 'VN', '13', 1),
(3815, 'Bắc Giang', 'VN', '54', 1),
(3816, 'Hà Tĩnh', 'VN', '23', 1),
(3817, 'Lào Cai', 'VN', '02', 1),
(3818, 'Lâm Đồng', 'VN', '35', 1),
(3819, 'Sóc Trăng', 'VN', '52', 1),
(3821, 'Đồng Nai', 'VN', '39', 1),
(3822, 'Bắc Kạn', 'VN', '53', 1),
(3823, 'Đắk Nông', 'VN', '72', 1),
(3824, 'Phú Yên', 'VN', '32', 1),
(3825, 'Lai Châu', 'VN', '01', 1),
(3826, 'Tây Ninh', 'VN', '37', 1),
(3827, 'Hải Dương', 'VN', '61', 1),
(3828, 'Quảng Ngãi', 'VN', '29', 1),
(3829, 'Đắk Lắk', 'VN', '33', 1),
(3830, 'Bình Định', 'VN', '31', 1),
(3831, 'Saint Peter Basseterre Parish', 'KN', '11', 1),
(3832, 'Nevis', 'KN', 'N', 1),
(3833, 'Christ Church Nichola Town Parish', 'KN', '01', 1),
(3834, 'Saint Paul Capisterre Parish', 'KN', '09', 1),
(3835, 'Saint James Windward Parish', 'KN', '05', 1),
(3836, 'Saint Anne Sandy Point Parish', 'KN', '02', 1),
(3837, 'Saint George Gingerland Parish', 'KN', '04', 1),
(3838, 'Saint Paul Charlestown Parish', 'KN', '10', 1),
(3839, 'Saint Thomas Lowland Parish', 'KN', '12', 1),
(3840, 'Saint John Figtree Parish', 'KN', '07', 1),
(3841, 'Saint Kitts', 'KN', 'K', 1),
(3842, 'Saint Thomas Middle Island Parish', 'KN', '13', 1),
(3843, 'Trinity Palmetto Point Parish', 'KN', '15', 1),
(3844, 'Saint Mary Cayon Parish', 'KN', '08', 1),
(3845, 'Saint John Capisterre Parish', 'KN', '06', 1),
(3846, 'Daegu', 'KR', '27', 1),
(3847, 'Gyeonggi Province', 'KR', '41', 1),
(3848, 'Incheon', 'KR', '28', 1),
(3849, 'Seoul', 'KR', '11', 1),
(3850, 'Daejeon', 'KR', '30', 1),
(3851, 'North Jeolla Province', 'KR', '45', 1),
(3852, 'Ulsan', 'KR', '31', 1),
(3853, 'Jeju', 'KR', '49', 1),
(3854, 'North Chungcheong Province', 'KR', '43', 1),
(3855, 'North Gyeongsang Province', 'KR', '47', 1),
(3856, 'South Jeolla Province', 'KR', '46', 1),
(3857, 'South Gyeongsang Province', 'KR', '48', 1),
(3858, 'Gwangju', 'KR', '29', 1),
(3859, 'South Chungcheong Province', 'KR', '44', 1),
(3860, 'Busan', 'KR', '26', 1),
(3861, 'Sejong City', 'KR', '50', 1),
(3862, 'Gangwon Province', 'KR', '42', 1),
(3863, 'Saint Patrick Parish', 'GD', '06', 1),
(3864, 'Saint George Parish', 'GD', '03', 1),
(3865, 'Saint Andrew Parish', 'GD', '01', 1),
(3866, 'Saint Mark Parish', 'GD', '05', 1),
(3867, 'Carriacou and Petite Martinique', 'GD', '10', 1),
(3868, 'Saint John Parish', 'GD', '04', 1),
(3869, 'Saint David Parish', 'GD', '02', 1),
(3870, 'Ghazni', 'AF', 'GHA', 1),
(3871, 'Badghis', 'AF', 'BDG', 1),
(3872, 'Bamyan', 'AF', 'BAM', 1),
(3873, 'Helmand', 'AF', 'HEL', 1),
(3874, 'Zabul', 'AF', 'ZAB', 1),
(3875, 'Baghlan', 'AF', 'BGL', 1),
(3876, 'Kunar', 'AF', 'KNR', 1),
(3877, 'Paktika', 'AF', 'PKA', 1),
(3878, 'Khost', 'AF', 'KHO', 1),
(3879, 'Kapisa', 'AF', 'KAP', 1),
(3880, 'Nuristan', 'AF', 'NUR', 1),
(3881, 'Panjshir', 'AF', 'PAN', 1),
(3882, 'Nangarhar', 'AF', 'NAN', 1),
(3883, 'Samangan', 'AF', 'SAM', 1),
(3884, 'Balkh', 'AF', 'BAL', 1),
(3885, 'Sar-e Pol', 'AF', 'SAR', 1),
(3886, 'Jowzjan', 'AF', 'JOW', 1),
(3887, 'Herat', 'AF', 'HER', 1),
(3888, 'Ghōr', 'AF', 'GHO', 1),
(3889, 'Faryab', 'AF', 'FYB', 1),
(3890, 'Kandahar', 'AF', 'KAN', 1),
(3891, 'Laghman', 'AF', 'LAG', 1),
(3892, 'Daykundi', 'AF', 'DAY', 1),
(3893, 'Takhar', 'AF', 'TAK', 1),
(3894, 'Paktia', 'AF', 'PIA', 1),
(3895, 'Parwan', 'AF', 'PAR', 1),
(3896, 'Nimruz', 'AF', 'NIM', 1),
(3897, 'Logar', 'AF', 'LOG', 1),
(3898, 'Urozgan', 'AF', 'URU', 1),
(3899, 'Farah', 'AF', 'FRA', 1),
(3900, 'Kunduz Province', 'AF', 'KDZ', 1),
(3901, 'Badakhshan', 'AF', 'BDS', 1),
(3902, 'Kabul', 'AF', 'KAB', 1),
(3903, 'Victoria', 'AU', 'VIC', 1),
(3904, 'South Australia', 'AU', 'SA', 1),
(3905, 'Queensland', 'AU', 'QLD', 1),
(3906, 'Western Australia', 'AU', 'WA', 1),
(3907, 'Australian Capital Territory', 'AU', 'ACT', 1),
(3908, 'Tasmania', 'AU', 'TAS', 1),
(3909, 'New South Wales', 'AU', 'NSW', 1),
(3910, 'Northern Territory', 'AU', 'NT', 1),
(3911, 'Vavaʻu', 'TO', '05', 1),
(3912, 'Tongatapu', 'TO', '04', 1),
(3913, 'Haʻapai', 'TO', '02', 1),
(3914, 'Niuas', 'TO', '03', 1),
(3915, 'ʻEua', 'TO', '01', 1),
(3916, 'Markazi', 'IR', '00', 1),
(3917, 'Khuzestan', 'IR', '06', 1),
(3918, 'Ilam', 'IR', '16', 1),
(3919, 'Kermanshah', 'IR', '05', 1),
(3920, 'Gilan', 'IR', '01', 1),
(3921, 'Chaharmahal and Bakhtiari', 'IR', '14', 1),
(3922, 'Qom', 'IR', '25', 1),
(3923, 'Isfahan', 'IR', '10', 1),
(3924, 'West Azarbaijan', 'IR', '04', 1),
(3925, 'Zanjan', 'IR', '19', 1),
(3926, 'Kohgiluyeh and Boyer-Ahmad', 'IR', '17', 1),
(3927, 'Razavi Khorasan', 'IR', '09', 1),
(3928, 'Lorestan', 'IR', '15', 1),
(3929, 'Alborz', 'IR', '30', 1),
(3930, 'South Khorasan', 'IR', '29', 1),
(3931, 'Sistan and Baluchestan', 'IR', '11', 1),
(3932, 'Bushehr', 'IR', '18', 1),
(3933, 'Golestan', 'IR', '27', 1),
(3934, 'Ardabil', 'IR', '24', 1),
(3935, 'Kurdistan', 'IR', '12', 1),
(3936, 'Yazd', 'IR', '21', 1),
(3937, 'Hormozgan', 'IR', '22', 1),
(3938, 'Mazandaran', 'IR', '02', 1),
(3939, 'Fars', 'IR', '07', 1),
(3940, 'Semnan', 'IR', '20', 1),
(3941, 'Qazvin', 'IR', '26', 1),
(3942, 'North Khorasan', 'IR', '28', 1),
(3943, 'Kerman', 'IR', '08', 1),
(3944, 'East Azerbaijan', 'IR', '03', 1),
(3945, 'Tehran', 'IR', '23', 1),
(3946, 'Niutao Island Council', 'TV', 'NIT', 1),
(3947, 'Nanumanga', 'TV', 'NMG', 1),
(3948, 'Nui', 'TV', 'NUI', 1),
(3949, 'Nanumea', 'TV', 'NMA', 1),
(3950, 'Vaitupu', 'TV', 'VAI', 1),
(3951, 'Funafuti', 'TV', 'FUN', 1),
(3952, 'Nukufetau', 'TV', 'NKF', 1),
(3953, 'Nukulaelae', 'TV', 'NKL', 1),
(3954, 'Dhi Qar', 'IQ', 'DQ', 1),
(3955, 'Babylon', 'IQ', 'BB', 1),
(3956, 'Al-Qādisiyyah', 'IQ', 'QA', 1),
(3957, 'Karbala', 'IQ', 'KA', 1),
(3958, 'Al Muthanna', 'IQ', 'MU', 1),
(3959, 'Baghdad', 'IQ', 'BG', 1),
(3960, 'Basra', 'IQ', 'BA', 1),
(3961, 'Saladin', 'IQ', 'SD', 1),
(3962, 'Najaf', 'IQ', 'NA', 1),
(3963, 'Nineveh', 'IQ', 'NI', 1),
(3964, 'Al Anbar', 'IQ', 'AN', 1),
(3965, 'Diyala', 'IQ', 'DI', 1),
(3966, 'Maysan', 'IQ', 'MA', 1),
(3967, 'Dohuk', 'IQ', 'DA', 1),
(3968, 'Erbil', 'IQ', 'AR', 1),
(3969, 'Sulaymaniyah', 'IQ', 'SU', 1),
(3970, 'Wasit', 'IQ', 'WA', 1),
(3971, 'Kirkuk', 'IQ', 'KI', 1),
(3972, 'Svay Rieng', 'KH', '20', 1),
(3973, 'Preah Vihear', 'KH', '13', 1),
(3974, 'Prey Veng', 'KH', '14', 1),
(3975, 'Takeo', 'KH', '21', 1),
(3976, 'Battambang', 'KH', '2', 1),
(3977, 'Pursat', 'KH', '15', 1),
(3978, 'Kep', 'KH', '23', 1),
(3979, 'Kampong Chhnang', 'KH', '4', 1),
(3980, 'Pailin', 'KH', '24', 1),
(3981, 'Kampot', 'KH', '7', 1),
(3982, 'Koh Kong', 'KH', '9', 1),
(3983, 'Kandal', 'KH', '8', 1),
(3984, 'Banteay Meanchey', 'KH', '1', 1),
(3985, 'Mondulkiri', 'KH', '11', 1),
(3986, 'Kratie', 'KH', '10', 1),
(3987, 'Oddar Meanchey', 'KH', '22', 1),
(3988, 'Kampong Speu', 'KH', '5', 1),
(3989, 'Sihanoukville', 'KH', '18', 1),
(3990, 'Ratanakiri', 'KH', '16', 1),
(3991, 'Kampong Cham', 'KH', '3', 1),
(3992, 'Siem Reap', 'KH', '17', 1),
(3993, 'Stung Treng', 'KH', '19', 1),
(3994, 'Phnom Penh', 'KH', '12', 1),
(3995, 'North Hamgyong Province', 'KP', '09', 1),
(3996, 'Ryanggang Province', 'KP', '10', 1),
(3997, 'South Pyongan Province', 'KP', '02', 1),
(3998, 'Chagang Province', 'KP', '04', 1);
INSERT INTO `state` VALUES
(3999, 'Kangwon Province', 'KP', '07', 1),
(4000, 'South Hamgyong Province', 'KP', '08', 1),
(4001, 'Rason', 'KP', '13', 1),
(4002, 'North Pyongan Province', 'KP', '03', 1),
(4003, 'South Hwanghae Province', 'KP', '05', 1),
(4004, 'North Hwanghae Province', 'KP', '06', 1),
(4005, 'Pyongyang', 'KP', '01', 1),
(4006, 'Meghalaya', 'IN', 'ML', 1),
(4007, 'Haryana', 'IN', 'HR', 1),
(4008, 'Maharashtra', 'IN', 'MH', 1),
(4009, 'Goa', 'IN', 'GA', 1),
(4010, 'Manipur', 'IN', 'MN', 1),
(4011, 'Puducherry', 'IN', 'PY', 1),
(4012, 'Telangana', 'IN', 'TG', 1),
(4013, 'Odisha', 'IN', 'OR', 1),
(4014, 'Rajasthan', 'IN', 'RJ', 1),
(4015, 'Punjab', 'IN', 'PB', 1),
(4016, 'Uttarakhand', 'IN', 'UT', 1),
(4017, 'Andhra Pradesh', 'IN', 'AP', 1),
(4018, 'Nagaland', 'IN', 'NL', 1),
(4019, 'Lakshadweep', 'IN', 'LD', 1),
(4020, 'Himachal Pradesh', 'IN', 'HP', 1),
(4021, 'Delhi', 'IN', 'DL', 1),
(4022, 'Uttar Pradesh', 'IN', 'UP', 1),
(4023, 'Andaman and Nicobar Islands', 'IN', 'AN', 1),
(4024, 'Arunachal Pradesh', 'IN', 'AR', 1),
(4025, 'Jharkhand', 'IN', 'JH', 1),
(4026, 'Karnataka', 'IN', 'KA', 1),
(4027, 'Assam', 'IN', 'AS', 1),
(4028, 'Kerala', 'IN', 'KL', 1),
(4029, 'Jammu and Kashmir', 'IN', 'JK', 1),
(4030, 'Gujarat', 'IN', 'GJ', 1),
(4031, 'Chandigarh', 'IN', 'CH', 1),
(4033, 'Dadra and Nagar Haveli and Daman and Diu', 'IN', 'DH', 1),
(4034, 'Sikkim', 'IN', 'SK', 1),
(4035, 'Tamil Nadu', 'IN', 'TN', 1),
(4036, 'Mizoram', 'IN', 'MZ', 1),
(4037, 'Bihar', 'IN', 'BR', 1),
(4038, 'Tripura', 'IN', 'TR', 1),
(4039, 'Madhya Pradesh', 'IN', 'MP', 1),
(4040, 'Chhattisgarh', 'IN', 'CT', 1),
(4041, 'Choluteca Department', 'HN', 'CH', 1),
(4042, 'Comayagua Department', 'HN', 'CM', 1),
(4043, 'El Paraíso Department', 'HN', 'EP', 1),
(4044, 'Intibucá Department', 'HN', 'IN', 1),
(4045, 'Bay Islands Department', 'HN', 'IB', 1),
(4046, 'Cortés Department', 'HN', 'CR', 1),
(4047, 'Atlántida Department', 'HN', 'AT', 1),
(4048, 'Gracias a Dios Department', 'HN', 'GD', 1),
(4049, 'Copán Department', 'HN', 'CP', 1),
(4050, 'Olancho Department', 'HN', 'OL', 1),
(4051, 'Colón Department', 'HN', 'CL', 1),
(4052, 'Francisco Morazán Department', 'HN', 'FM', 1),
(4053, 'Santa Bárbara Department', 'HN', 'SB', 1),
(4054, 'Lempira Department', 'HN', 'LE', 1),
(4055, 'Valle Department', 'HN', 'VA', 1),
(4056, 'Ocotepeque Department', 'HN', 'OC', 1),
(4057, 'Yoro Department', 'HN', 'YO', 1),
(4058, 'La Paz Department', 'HN', 'LP', 1),
(4059, 'Northland Region', 'NZ', 'NTL', 1),
(4060, 'Manawatu-Wanganui Region', 'NZ', 'MWT', 1),
(4061, 'Waikato Region', 'NZ', 'WKO', 1),
(4062, 'Otago Region', 'NZ', 'OTA', 1),
(4063, 'Marlborough Region', 'NZ', 'MBH', 1),
(4064, 'West Coast Region', 'NZ', 'WTC', 1),
(4065, 'Wellington Region', 'NZ', 'WGN', 1),
(4066, 'Canterbury Region', 'NZ', 'CAN', 1),
(4067, 'Chatham Islands', 'NZ', 'CIT', 1),
(4068, 'Gisborne District', 'NZ', 'GIS', 1),
(4069, 'Taranaki Region', 'NZ', 'TKI', 1),
(4070, 'Nelson Region', 'NZ', 'NSN', 1),
(4071, 'Southland Region', 'NZ', 'STL', 1),
(4072, 'Auckland Region', 'NZ', 'AUK', 1),
(4073, 'Tasman District', 'NZ', 'TAS', 1),
(4074, 'Bay of Plenty Region', 'NZ', 'BOP', 1),
(4075, 'Hawke''s Bay Region', 'NZ', 'HKB', 1),
(4076, 'Saint John Parish', 'DM', '05', 1),
(4077, 'Saint Mark Parish', 'DM', '08', 1),
(4078, 'Saint David Parish', 'DM', '03', 1),
(4079, 'Saint George Parish', 'DM', '04', 1),
(4080, 'Saint Patrick Parish', 'DM', '09', 1),
(4081, 'Saint Peter Parish', 'DM', '11', 1),
(4082, 'Saint Andrew Parish', 'DM', '02', 1),
(4083, 'Saint Luke Parish', 'DM', '07', 1),
(4084, 'Saint Paul Parish', 'DM', '10', 1),
(4085, 'Saint Joseph Parish', 'DM', '06', 1),
(4086, 'El Seibo Province', 'DO', '08', 1),
(4087, 'La Romana Province', 'DO', '12', 1),
(4088, 'Sánchez Ramírez Province', 'DO', '24', 1),
(4089, 'Hermanas Mirabal Province', 'DO', '19', 1),
(4090, 'Barahona Province', 'DO', '04', 1),
(4091, 'San Cristóbal Province', 'DO', '21', 1),
(4092, 'Puerto Plata Province', 'DO', '18', 1),
(4093, 'Santo Domingo Province', 'DO', '32', 1),
(4094, 'María Trinidad Sánchez Province', 'DO', '14', 1),
(4095, 'Distrito Nacional', 'DO', '01', 1),
(4096, 'Peravia Province', 'DO', '17', 1),
(4097, 'Independencia', 'DO', '10', 1),
(4098, 'San Juan Province', 'DO', '22', 1),
(4099, 'Monseñor Nouel Province', 'DO', '28', 1),
(4100, 'Santiago Rodríguez Province', 'DO', '26', 1),
(4101, 'Pedernales Province', 'DO', '16', 1),
(4102, 'Espaillat Province', 'DO', '09', 1),
(4103, 'Samaná Province', 'DO', '20', 1),
(4104, 'Valverde Province', 'DO', '27', 1),
(4105, 'Baoruco Province', 'DO', '03', 1),
(4106, 'Hato Mayor Province', 'DO', '30', 1),
(4107, 'Dajabón Province', 'DO', '05', 1),
(4108, 'Santiago Province', 'DO', '25', 1),
(4109, 'La Altagracia Province', 'DO', '11', 1),
(4110, 'San Pedro de Macorís', 'DO', '23', 1),
(4111, 'Monte Plata Province', 'DO', '29', 1),
(4112, 'San José de Ocoa Province', 'DO', '31', 1),
(4113, 'Duarte Province', 'DO', '06', 1),
(4114, 'Azua Province', 'DO', '02', 1),
(4115, 'Monte Cristi Province', 'DO', '15', 1),
(4116, 'La Vega Province', 'DO', '13', 1),
(4117, 'Nord', 'HT', 'ND', 1),
(4118, 'Nippes', 'HT', 'NI', 1),
(4119, 'Grand''Anse', 'HT', 'GA', 1),
(4120, 'Ouest', 'HT', 'OU', 1),
(4121, 'Nord-Est', 'HT', 'NE', 1),
(4122, 'Sud', 'HT', 'SD', 1),
(4123, 'Artibonite', 'HT', 'AR', 1),
(4124, 'Sud-Est', 'HT', 'SE', 1),
(4125, 'Centre', 'HT', 'CE', 1),
(4126, 'Nord-Ouest', 'HT', 'NO', 1),
(4127, 'San Vicente Department', 'SV', 'SV', 1),
(4128, 'Santa Ana Department', 'SV', 'SA', 1),
(4129, 'Usulután Department', 'SV', 'US', 1),
(4130, 'Morazán Department', 'SV', 'MO', 1),
(4131, 'Chalatenango Department', 'SV', 'CH', 1),
(4132, 'Cabañas Department', 'SV', 'CA', 1),
(4133, 'San Salvador Department', 'SV', 'SS', 1),
(4134, 'La Libertad Department', 'SV', 'LI', 1),
(4135, 'San Miguel Department', 'SV', 'SM', 1),
(4136, 'La Paz Department', 'SV', 'PA', 1),
(4137, 'Cuscatlán Department', 'SV', 'CU', 1),
(4138, 'La Unión Department', 'SV', 'UN', 1),
(4139, 'Ahuachapán Department', 'SV', 'AH', 1),
(4140, 'Sonsonate Department', 'SV', 'SO', 1),
(4141, 'Braslovče Municipality', 'SI', '151', 1),
(4142, 'Lenart Municipality', 'SI', '058', 1),
(4143, 'Oplotnica', 'SI', '171', 1),
(4144, 'Velike Lašče Municipality', 'SI', '134', 1),
(4145, 'Hajdina Municipality', 'SI', '159', 1),
(4146, 'Podčetrtek Municipality', 'SI', '092', 1),
(4147, 'Cankova Municipality', 'SI', '152', 1),
(4148, 'Vitanje Municipality', 'SI', '137', 1),
(4149, 'Sežana Municipality', 'SI', '111', 1),
(4150, 'Kidričevo Municipality', 'SI', '045', 1),
(4151, 'Črenšovci Municipality', 'SI', '015', 1),
(4152, 'Idrija Municipality', 'SI', '036', 1),
(4153, 'Trnovska Vas Municipality', 'SI', '185', 1),
(4154, 'Vodice Municipality', 'SI', '138', 1),
(4155, 'Ravne na Koroškem Municipality', 'SI', '103', 1),
(4156, 'Lovrenc na Pohorju Municipality', 'SI', '167', 1),
(4157, 'Majšperk Municipality', 'SI', '069', 1),
(4158, 'Loški Potok Municipality', 'SI', '066', 1),
(4159, 'Domžale Municipality', 'SI', '023', 1),
(4160, 'Rečica ob Savinji Municipality', 'SI', '209', 1),
(4161, 'Podlehnik Municipality', 'SI', '172', 1),
(4162, 'Cerknica Municipality', 'SI', '013', 1),
(4163, 'Vransko Municipality', 'SI', '189', 1),
(4164, 'Sveta Ana Municipality', 'SI', '181', 1),
(4165, 'Brezovica Municipality', 'SI', '008', 1),
(4166, 'Benedikt Municipality', 'SI', '148', 1),
(4167, 'Divača Municipality', 'SI', '019', 1),
(4168, 'Moravče Municipality', 'SI', '077', 1),
(4169, 'Slovenj Gradec City Municipality', 'SI', '112', 1),
(4170, 'Škocjan Municipality', 'SI', '121', 1),
(4171, 'Šentjur Municipality', 'SI', '120', 1),
(4172, 'Pesnica Municipality', 'SI', '089', 1),
(4173, 'Dol pri Ljubljani Municipality', 'SI', '022', 1),
(4174, 'Loška Dolina Municipality', 'SI', '065', 1),
(4175, 'Hoče–Slivnica Municipality', 'SI', '160', 1),
(4176, 'Cerkvenjak Municipality', 'SI', '153', 1),
(4177, 'Naklo Municipality', 'SI', '082', 1),
(4178, 'Cerkno Municipality', 'SI', '014', 1),
(4179, 'Bistrica ob Sotli Municipality', 'SI', '149', 1),
(4180, 'Kamnik Municipality', 'SI', '043', 1),
(4181, 'Bovec Municipality', 'SI', '006', 1),
(4182, 'Zavrč Municipality', 'SI', '143', 1),
(4183, 'Ajdovščina Municipality', 'SI', '001', 1),
(4184, 'Pivka Municipality', 'SI', '091', 1),
(4185, 'Štore Municipality', 'SI', '127', 1),
(4186, 'Kozje Municipality', 'SI', '051', 1),
(4187, 'Municipality of Škofljica', 'SI', '123', 1),
(4188, 'Prebold Municipality', 'SI', '174', 1),
(4189, 'Dobrovnik Municipality', 'SI', '156', 1),
(4190, 'Mozirje Municipality', 'SI', '079', 1),
(4191, 'City Municipality of Celje', 'SI', '011', 1),
(4192, 'Žiri Municipality', 'SI', '147', 1),
(4193, 'Horjul Municipality', 'SI', '162', 1),
(4194, 'Tabor Municipality', 'SI', '184', 1),
(4195, 'Radeče Municipality', 'SI', '099', 1),
(4196, 'Vipava Municipality', 'SI', '136', 1),
(4197, 'Kungota', 'SI', '055', 1),
(4198, 'Slovenske Konjice Municipality', 'SI', '114', 1),
(4199, 'Osilnica Municipality', 'SI', '088', 1),
(4200, 'Borovnica Municipality', 'SI', '005', 1),
(4201, 'Piran Municipality', 'SI', '090', 1),
(4202, 'Bled Municipality', 'SI', '003', 1),
(4203, 'Jezersko Municipality', 'SI', '163', 1),
(4204, 'Rače–Fram Municipality', 'SI', '098', 1),
(4205, 'Nova Gorica City Municipality', 'SI', '084', 1),
(4206, 'Razkrižje Municipality', 'SI', '176', 1),
(4207, 'Ribnica na Pohorju Municipality', 'SI', '177', 1),
(4208, 'Muta Municipality', 'SI', '081', 1),
(4209, 'Rogatec Municipality', 'SI', '107', 1),
(4210, 'Gorišnica Municipality', 'SI', '028', 1),
(4211, 'Kuzma Municipality', 'SI', '056', 1),
(4212, 'Mislinja Municipality', 'SI', '076', 1),
(4213, 'Duplek Municipality', 'SI', '026', 1),
(4214, 'Trebnje Municipality', 'SI', '130', 1),
(4215, 'Brežice Municipality', 'SI', '009', 1),
(4216, 'Dobrepolje Municipality', 'SI', '020', 1),
(4217, 'Grad Municipality', 'SI', '158', 1),
(4218, 'Moravske Toplice Municipality', 'SI', '078', 1),
(4219, 'Luče Municipality', 'SI', '067', 1),
(4220, 'Miren–Kostanjevica Municipality', 'SI', '075', 1),
(4221, 'Ormož Municipality', 'SI', '087', 1),
(4222, 'Šalovci Municipality', 'SI', '033', 1),
(4223, 'Miklavž na Dravskem Polju Municipality', 'SI', '169', 1),
(4224, 'Makole Municipality', 'SI', '198', 1),
(4225, 'Lendava Municipality', 'SI', '059', 1),
(4226, 'Vuzenica Municipality', 'SI', '141', 1),
(4227, 'Kanal ob Soči Municipality', 'SI', '044', 1),
(4228, 'Ptuj City Municipality', 'SI', '096', 1),
(4229, 'Sveti Andraž v Slovenskih Goricah Municipality', 'SI', '182', 1),
(4230, 'Selnica ob Dravi Municipality', 'SI', '178', 1),
(4231, 'Radovljica Municipality', 'SI', '102', 1),
(4232, 'Črna na Koroškem Municipality', 'SI', '016', 1),
(4233, 'Rogaška Slatina Municipality', 'SI', '106', 1),
(4234, 'Podvelka Municipality', 'SI', '093', 1),
(4235, 'Ribnica Municipality', 'SI', '104', 1),
(4236, 'City Municipality of Novo Mesto', 'SI', '085', 1),
(4237, 'Mirna Peč Municipality', 'SI', '170', 1),
(4238, 'Križevci Municipality', 'SI', '166', 1),
(4239, 'Poljčane Municipality', 'SI', '200', 1),
(4240, 'Brda Municipality', 'SI', '007', 1),
(4241, 'Šentjernej Municipality', 'SI', '119', 1),
(4242, 'Maribor City Municipality', 'SI', '070', 1),
(4243, 'Kobarid Municipality', 'SI', '046', 1),
(4244, 'Markovci Municipality', 'SI', '168', 1),
(4245, 'Vojnik Municipality', 'SI', '139', 1),
(4246, 'Trbovlje Municipality', 'SI', '129', 1),
(4247, 'Tolmin Municipality', 'SI', '128', 1),
(4248, 'Šoštanj Municipality', 'SI', '126', 1),
(4249, 'Žetale Municipality', 'SI', '191', 1),
(4250, 'Tržič Municipality', 'SI', '131', 1),
(4251, 'Turnišče Municipality', 'SI', '132', 1),
(4252, 'Dobrna Municipality', 'SI', '155', 1),
(4253, 'Renče–Vogrsko Municipality', 'SI', '201', 1),
(4254, 'Kostanjevica na Krki Municipality', 'SI', '197', 1),
(4255, 'Sveti Jurij ob Ščavnici Municipality', 'SI', '116', 1),
(4256, 'Železniki Municipality', 'SI', '146', 1),
(4257, 'Veržej Municipality', 'SI', '188', 1),
(4258, 'Žalec Municipality', 'SI', '190', 1),
(4259, 'Starše Municipality', 'SI', '115', 1),
(4260, 'Sveta Trojica v Slovenskih Goricah Municipality', 'SI', '204', 1),
(4261, 'Solčava Municipality', 'SI', '180', 1),
(4262, 'Vrhnika Municipality', 'SI', '140', 1),
(4263, 'Središče ob Dravi', 'SI', '202', 1),
(4264, 'Rogašovci Municipality', 'SI', '105', 1),
(4265, 'Mežica Municipality', 'SI', '074', 1),
(4266, 'Juršinci Municipality', 'SI', '042', 1),
(4267, 'Velika Polana Municipality', 'SI', '187', 1),
(4268, 'Sevnica Municipality', 'SI', '110', 1),
(4269, 'Zagorje ob Savi Municipality', 'SI', '142', 1),
(4270, 'Ljubljana City Municipality', 'SI', '061', 1),
(4271, 'Gornji Petrovci Municipality', 'SI', '031', 1),
(4272, 'Polzela Municipality', 'SI', '173', 1),
(4273, 'Sveti Tomaž Municipality', 'SI', '205', 1),
(4274, 'Prevalje Municipality', 'SI', '175', 1),
(4275, 'Radlje ob Dravi Municipality', 'SI', '101', 1),
(4276, 'Žirovnica Municipality', 'SI', '192', 1),
(4277, 'Sodražica Municipality', 'SI', '179', 1),
(4278, 'Bloke Municipality', 'SI', '150', 1),
(4279, 'Šmartno pri Litiji Municipality', 'SI', '194', 1),
(4280, 'Ruše Municipality', 'SI', '108', 1),
(4281, 'Dolenjske Toplice Municipality', 'SI', '157', 1),
(4282, 'Bohinj Municipality', 'SI', '004', 1),
(4283, 'Komenda Municipality', 'SI', '164', 1),
(4284, 'Gorje Municipality', 'SI', '207', 1),
(4285, 'Šmarje pri Jelšah Municipality', 'SI', '124', 1),
(4286, 'Ig Municipality', 'SI', '037', 1),
(4287, 'Kranj City Municipality', 'SI', '052', 1),
(4288, 'Puconci Municipality', 'SI', '097', 1),
(4289, 'Šmarješke Toplice Municipality', 'SI', '206', 1),
(4290, 'Dornava Municipality', 'SI', '024', 1),
(4291, 'Črnomelj Municipality', 'SI', '017', 1),
(4292, 'Radenci Municipality', 'SI', '100', 1),
(4293, 'Gorenja Vas–Poljane Municipality', 'SI', '027', 1),
(4294, 'Ljubno Municipality', 'SI', '062', 1),
(4295, 'Dobje Municipality', 'SI', '154', 1),
(4296, 'Šmartno ob Paki Municipality', 'SI', '125', 1),
(4297, 'Mokronog–Trebelno Municipality', 'SI', '199', 1),
(4298, 'Mirna Municipality', 'SI', '212', 1),
(4299, 'Šenčur Municipality', 'SI', '117', 1),
(4300, 'Videm Municipality', 'SI', '135', 1),
(4301, 'Beltinci Municipality', 'SI', '002', 1),
(4302, 'Lukovica Municipality', 'SI', '068', 1),
(4303, 'Preddvor Municipality', 'SI', '095', 1),
(4304, 'Destrnik Municipality', 'SI', '018', 1),
(4305, 'Ivančna Gorica Municipality', 'SI', '039', 1),
(4306, 'Log–Dragomer Municipality', 'SI', '208', 1),
(4307, 'Žužemberk Municipality', 'SI', '193', 1),
(4308, 'Dobrova–Polhov Gradec Municipality', 'SI', '021', 1),
(4309, 'Municipality of Cirkulane', 'SI', '196', 1),
(4310, 'Cerklje na Gorenjskem Municipality', 'SI', '012', 1),
(4311, 'Šentrupert Municipality', 'SI', '211', 1),
(4312, 'Tišina Municipality', 'SI', '010', 1),
(4313, 'Murska Sobota City Municipality', 'SI', '080', 1),
(4314, 'Municipality of Krško', 'SI', '054', 1),
(4315, 'Komen Municipality', 'SI', '049', 1),
(4316, 'Škofja Loka Municipality', 'SI', '122', 1),
(4317, 'Šempeter–Vrtojba Municipality', 'SI', '183', 1),
(4318, 'Municipality of Apače', 'SI', '195', 1),
(4319, 'Koper City Municipality', 'SI', '050', 1),
(4320, 'Odranci Municipality', 'SI', '086', 1),
(4321, 'Hrpelje–Kozina Municipality', 'SI', '035', 1),
(4322, 'Izola Municipality', 'SI', '040', 1),
(4323, 'Metlika Municipality', 'SI', '073', 1),
(4324, 'Šentilj Municipality', 'SI', '118', 1),
(4325, 'Kobilje Municipality', 'SI', '047', 1),
(4326, 'Ankaran Municipality', 'SI', '213', 1),
(4327, 'Hodoš Municipality', 'SI', '161', 1),
(4328, 'Sveti Jurij v Slovenskih Goricah Municipality', 'SI', '210', 1),
(4329, 'Nazarje Municipality', 'SI', '083', 1),
(4330, 'Postojna Municipality', 'SI', '094', 1),
(4331, 'Kostel Municipality', 'SI', '165', 1),
(4332, 'Slovenska Bistrica Municipality', 'SI', '113', 1),
(4333, 'Straža Municipality', 'SI', '203', 1),
(4334, 'Trzin Municipality', 'SI', '186', 1),
(4335, 'Kočevje Municipality', 'SI', '048', 1),
(4336, 'Grosuplje Municipality', 'SI', '032', 1),
(4337, 'Jesenice Municipality', 'SI', '041', 1),
(4338, 'Laško Municipality', 'SI', '057', 1),
(4339, 'Gornji Grad Municipality', 'SI', '030', 1),
(4340, 'Kranjska Gora Municipality', 'SI', '053', 1),
(4341, 'Hrastnik Municipality', 'SI', '034', 1),
(4342, 'Zreče Municipality', 'SI', '144', 1),
(4343, 'Gornja Radgona Municipality', 'SI', '029', 1),
(4344, 'Municipality of Ilirska Bistrica', 'SI', '038', 1),
(4345, 'Dravograd Municipality', 'SI', '025', 1),
(4346, 'Semič Municipality', 'SI', '109', 1),
(4347, 'Litija Municipality', 'SI', '060', 1),
(4348, 'Mengeš Municipality', 'SI', '072', 1),
(4349, 'Medvode Municipality', 'SI', '071', 1),
(4350, 'Logatec Municipality', 'SI', '064', 1),
(4351, 'Ljutomer Municipality', 'SI', '063', 1),
(4352, 'Banská Bystrica Region', 'SK', 'BC', 1),
(4353, 'Košice Region', 'SK', 'KI', 1),
(4354, 'Prešov Region', 'SK', 'PV', 1),
(4355, 'Trnava Region', 'SK', 'TA', 1),
(4356, 'Bratislava Region', 'SK', 'BL', 1),
(4357, 'Nitra Region', 'SK', 'NI', 1),
(4358, 'Trenčín Region', 'SK', 'TC', 1),
(4359, 'Žilina Region', 'SK', 'ZI', 1),
(4360, 'Cimișlia District', 'MD', 'CM', 1),
(4361, 'Orhei District', 'MD', 'OR', 1),
(4362, 'Bender Municipality', 'MD', 'BD', 1),
(4363, 'Nisporeni District', 'MD', 'NI', 1),
(4364, 'Sîngerei District', 'MD', 'SI', 1),
(4365, 'Căușeni District', 'MD', 'CS', 1),
(4366, 'Călărași District', 'MD', 'CL', 1),
(4367, 'Glodeni District', 'MD', 'GL', 1),
(4368, 'Anenii Noi District', 'MD', 'AN', 1),
(4369, 'Ialoveni District', 'MD', 'IA', 1),
(4370, 'Florești District', 'MD', 'FL', 1),
(4371, 'Telenești District', 'MD', 'TE', 1),
(4372, 'Taraclia District', 'MD', 'TA', 1),
(4373, 'Chișinău Municipality', 'MD', 'CU', 1),
(4374, 'Soroca District', 'MD', 'SO', 1),
(4375, 'Briceni District', 'MD', 'BR', 1),
(4376, 'Rîșcani District', 'MD', 'RI', 1),
(4377, 'Strășeni District', 'MD', 'ST', 1),
(4378, 'Ștefan Vodă District', 'MD', 'SV', 1),
(4379, 'Basarabeasca District', 'MD', 'BS', 1),
(4380, 'Cantemir District', 'MD', 'CT', 1),
(4381, 'Fălești District', 'MD', 'FA', 1),
(4382, 'Hîncești District', 'MD', 'HI', 1),
(4383, 'Dubăsari District', 'MD', 'DU', 1),
(4384, 'Dondușeni District', 'MD', 'DO', 1),
(4385, 'Gagauzia', 'MD', 'GA', 1),
(4386, 'Ungheni District', 'MD', 'UN', 1),
(4387, 'Edineț District', 'MD', 'ED', 1),
(4388, 'Șoldănești District', 'MD', 'SD', 1),
(4389, 'Ocnița District', 'MD', 'OC', 1),
(4390, 'Criuleni District', 'MD', 'CR', 1),
(4391, 'Cahul District', 'MD', 'CA', 1),
(4392, 'Drochia District', 'MD', 'DR', 1),
(4393, 'Bălți Municipality', 'MD', 'BA', 1),
(4394, 'Rezina District', 'MD', 'RE', 1),
(4395, 'Transnistria autonomous territorial unit', 'MD', 'SN', 1),
(4396, 'Salacgrīva Municipality', 'LV', '086', 1),
(4397, 'Vecumnieki Municipality', 'LV', '105', 1),
(4398, 'Naukšēni Municipality', 'LV', '064', 1),
(4399, 'Ilūkste Municipality', 'LV', '036', 1),
(4400, 'Gulbene Municipality', 'LV', '033', 1),
(4401, 'Līvāni Municipality', 'LV', '056', 1),
(4402, 'Salaspils Municipality', 'LV', '087', 1),
(4403, 'Ventspils Municipality', 'LV', '106', 1),
(4404, 'Rundāle Municipality', 'LV', '083', 1),
(4405, 'Pļaviņas Municipality', 'LV', '072', 1),
(4406, 'Vārkava Municipality', 'LV', '103', 1),
(4407, 'Jaunpiebalga Municipality', 'LV', '039', 1),
(4408, 'Sēja Municipality', 'LV', '090', 1),
(4409, 'Tukums Municipality', 'LV', '099', 1),
(4410, 'Cibla Municipality', 'LV', '023', 1),
(4411, 'Burtnieki Municipality', 'LV', '019', 1),
(4412, 'Ķegums Municipality', 'LV', '051', 1),
(4413, 'Krustpils Municipality', 'LV', '049', 1),
(4414, 'Cesvaine Municipality', 'LV', '021', 1),
(4415, 'Skrīveri Municipality', 'LV', '092', 1),
(4416, 'Ogre Municipality', 'LV', '067', 1),
(4417, 'Olaine Municipality', 'LV', '068', 1),
(4418, 'Limbaži Municipality', 'LV', '054', 1),
(4419, 'Lubāna Municipality', 'LV', '057', 1),
(4420, 'Kandava Municipality', 'LV', '043', 1),
(4421, 'Ventspils', 'LV', 'VEN', 1),
(4422, 'Krimulda Municipality', 'LV', '048', 1),
(4423, 'Rugāji Municipality', 'LV', '082', 1),
(4424, 'Jelgava Municipality', 'LV', '041', 1),
(4425, 'Valka Municipality', 'LV', '101', 1),
(4426, 'Rūjiena Municipality', 'LV', '084', 1),
(4427, 'Babīte Municipality', 'LV', '012', 1),
(4428, 'Dundaga Municipality', 'LV', '027', 1),
(4429, 'Priekule Municipality', 'LV', '074', 1),
(4430, 'Zilupe Municipality', 'LV', '110', 1),
(4431, 'Varakļāni Municipality', 'LV', '102', 1),
(4432, 'Nereta Municipality', 'LV', '065', 1),
(4433, 'Madona Municipality', 'LV', '059', 1),
(4434, 'Sala Municipality', 'LV', '085', 1),
(4435, 'Ķekava Municipality', 'LV', '052', 1),
(4436, 'Nīca Municipality', 'LV', '066', 1),
(4437, 'Dobele Municipality', 'LV', '026', 1),
(4438, 'Jēkabpils Municipality', 'LV', '042', 1),
(4439, 'Saldus Municipality', 'LV', '088', 1),
(4440, 'Roja Municipality', 'LV', '079', 1),
(4441, 'Iecava Municipality', 'LV', '034', 1),
(4442, 'Ozolnieki Municipality', 'LV', '069', 1),
(4443, 'Saulkrasti Municipality', 'LV', '089', 1),
(4444, 'Ērgļi Municipality', 'LV', '030', 1),
(4445, 'Aglona Municipality', 'LV', '001', 1),
(4446, 'Jūrmala', 'LV', 'JUR', 1),
(4447, 'Skrunda Municipality', 'LV', '093', 1),
(4448, 'Engure Municipality', 'LV', '029', 1),
(4449, 'Inčukalns Municipality', 'LV', '037', 1),
(4450, 'Mārupe Municipality', 'LV', '062', 1),
(4451, 'Mērsrags Municipality', 'LV', '063', 1),
(4452, 'Koknese Municipality', 'LV', '046', 1),
(4453, 'Kārsava Municipality', 'LV', '044', 1),
(4454, 'Carnikava Municipality', 'LV', '020', 1),
(4455, 'Rēzekne Municipality', 'LV', '077', 1),
(4456, 'Viesīte Municipality', 'LV', '107', 1),
(4457, 'Ape Municipality', 'LV', '009', 1),
(4458, 'Durbe Municipality', 'LV', '028', 1),
(4459, 'Talsi Municipality', 'LV', '097', 1),
(4460, 'Liepāja', 'LV', 'LPX', 1),
(4461, 'Mālpils Municipality', 'LV', '061', 1),
(4462, 'Smiltene Municipality', 'LV', '094', 1),
(4463, 'Daugavpils', 'LV', 'DGV', 1),
(4464, 'Jēkabpils', 'LV', 'JKB', 1),
(4465, 'Bauska Municipality', 'LV', '016', 1),
(4466, 'Vecpiebalga Municipality', 'LV', '104', 1),
(4467, 'Pāvilosta Municipality', 'LV', '071', 1),
(4468, 'Brocēni Municipality', 'LV', '018', 1),
(4469, 'Cēsis Municipality', 'LV', '022', 1),
(4470, 'Grobiņa Municipality', 'LV', '032', 1),
(4471, 'Beverīna Municipality', 'LV', '017', 1),
(4472, 'Aizkraukle Municipality', 'LV', '002', 1),
(4473, 'Valmiera', 'LV', 'VMR', 1),
(4474, 'Krāslava Municipality', 'LV', '047', 1),
(4475, 'Jaunjelgava Municipality', 'LV', '038', 1),
(4476, 'Sigulda Municipality', 'LV', '091', 1),
(4477, 'Viļaka Municipality', 'LV', '108', 1),
(4478, 'Stopiņi Municipality', 'LV', '095', 1),
(4479, 'Rauna Municipality', 'LV', '076', 1),
(4480, 'Tērvete Municipality', 'LV', '098', 1),
(4481, 'Auce Municipality', 'LV', '010', 1),
(4482, 'Baldone Municipality', 'LV', '013', 1),
(4483, 'Preiļi Municipality', 'LV', '073', 1),
(4484, 'Aloja Municipality', 'LV', '005', 1),
(4485, 'Alsunga Municipality', 'LV', '006', 1),
(4486, 'Viļāni Municipality', 'LV', '109', 1),
(4487, 'Alūksne Municipality', 'LV', '007', 1),
(4488, 'Līgatne Municipality', 'LV', '055', 1),
(4489, 'Jaunpils Municipality', 'LV', '040', 1),
(4490, 'Kuldīga Municipality', 'LV', '050', 1),
(4491, 'Riga', 'LV', 'RIX', 1),
(4492, 'Daugavpils Municipality', 'LV', '025', 1),
(4493, 'Ropaži Municipality', 'LV', '080', 1),
(4494, 'Strenči Municipality', 'LV', '096', 1),
(4495, 'Kocēni Municipality', 'LV', '045', 1),
(4496, 'Aizpute Municipality', 'LV', '003', 1),
(4497, 'Amata Municipality', 'LV', '008', 1),
(4498, 'Baltinava Municipality', 'LV', '014', 1),
(4499, 'Aknīste Municipality', 'LV', '004', 1),
(4500, 'Jelgava', 'LV', 'JEL', 1),
(4501, 'Ludza Municipality', 'LV', '058', 1),
(4502, 'Riebiņi Municipality', 'LV', '078', 1),
(4503, 'Rucava Municipality', 'LV', '081', 1),
(4504, 'Dagda Municipality', 'LV', '024', 1),
(4505, 'Balvi Municipality', 'LV', '015', 1),
(4506, 'Priekuļi Municipality', 'LV', '075', 1),
(4507, 'Pārgauja Municipality', 'LV', '070', 1),
(4508, 'Vaiņode Municipality', 'LV', '100', 1),
(4509, 'Rēzekne', 'LV', 'REZ', 1),
(4510, 'Garkalne Municipality', 'LV', '031', 1),
(4511, 'Ikšķile Municipality', 'LV', '035', 1),
(4512, 'Lielvārde Municipality', 'LV', '053', 1),
(4513, 'Mazsalaca Municipality', 'LV', '060', 1),
(4514, 'Viqueque Municipality', 'TL', 'VI', 1),
(4515, 'Liquiçá Municipality', 'TL', 'LI', 1),
(4516, 'Ermera District', 'TL', 'ER', 1),
(4517, 'Manatuto District', 'TL', 'MT', 1),
(4518, 'Ainaro Municipality', 'TL', 'AN', 1),
(4519, 'Manufahi Municipality', 'TL', 'MF', 1),
(4520, 'Aileu municipality', 'TL', 'AL', 1),
(4521, 'Baucau Municipality', 'TL', 'BA', 1),
(4522, 'Cova Lima Municipality', 'TL', 'CO', 1),
(4523, 'Lautém Municipality', 'TL', 'LA', 1),
(4524, 'Dili municipality', 'TL', 'DI', 1),
(4525, 'Bobonaro Municipality', 'TL', 'BO', 1),
(4526, 'Peleliu', 'PW', '350', 1),
(4527, 'Ngardmau', 'PW', '222', 1),
(4528, 'Airai', 'PW', '004', 1),
(4529, 'Hatohobei', 'PW', '050', 1),
(4530, 'Melekeok', 'PW', '212', 1),
(4531, 'Ngatpang', 'PW', '224', 1),
(4532, 'Koror', 'PW', '150', 1),
(4533, 'Ngarchelong', 'PW', '218', 1),
(4534, 'Ngiwal', 'PW', '228', 1),
(4535, 'Sonsorol', 'PW', '370', 1),
(4536, 'Ngchesar', 'PW', '226', 1),
(4537, 'Ngaraard', 'PW', '214', 1),
(4538, 'Angaur', 'PW', '010', 1),
(4539, 'Kayangel', 'PW', '100', 1),
(4540, 'Aimeliik', 'PW', '002', 1),
(4541, 'Ngeremlengui', 'PW', '227', 1),
(4542, 'Břeclav', 'CZ', '644', 1),
(4543, 'Český Krumlov', 'CZ', '312', 1),
(4544, 'Plzeň-město', 'CZ', '323', 1),
(4545, 'Brno-venkov', 'CZ', '643', 1),
(4546, 'Příbram', 'CZ', '20B', 1),
(4547, 'Pardubice', 'CZ', '532', 1),
(4548, 'Nový Jičín', 'CZ', '804', 1),
(4550, 'Náchod', 'CZ', '523', 1),
(4551, 'Prostějov', 'CZ', '713', 1),
(4552, 'Zlínský kraj', 'CZ', '72', 1),
(4553, 'Chomutov', 'CZ', '422', 1),
(4554, 'Středočeský kraj', 'CZ', '20', 1),
(4556, 'České Budějovice', 'CZ', '311', 1),
(4558, 'Rakovník', 'CZ', '20C', 1),
(4559, 'Frýdek-Místek', 'CZ', '802', 1),
(4560, 'Písek', 'CZ', '314', 1),
(4561, 'Hodonín', 'CZ', '645', 1),
(4563, 'Zlín', 'CZ', '724', 1),
(4564, 'Plzeň-sever', 'CZ', '325', 1),
(4565, 'Tábor', 'CZ', '317', 1),
(4568, 'Brno-město', 'CZ', '642', 1),
(4571, 'Svitavy', 'CZ', '533', 1),
(4572, 'Vsetín', 'CZ', '723', 1),
(4573, 'Cheb', 'CZ', '411', 1),
(4574, 'Olomouc', 'CZ', '712', 1),
(4575, 'Kraj Vysočina', 'CZ', '63', 1),
(4576, 'Ústecký kraj', 'CZ', '42', 1),
(4578, 'Prachatice', 'CZ', '315', 1),
(4579, 'Trutnov', 'CZ', '525', 1),
(4580, 'Hradec Králové', 'CZ', '521', 1),
(4581, 'Karlovarský kraj', 'CZ', '41', 1),
(4582, 'Nymburk', 'CZ', '208', 1),
(4583, 'Rokycany', 'CZ', '326', 1),
(4584, 'Ostrava-město', 'CZ', '806', 1),
(4586, 'Karviná', 'CZ', '803', 1),
(4588, 'Pardubický kraj', 'CZ', '53', 1),
(4589, 'Olomoucký kraj', 'CZ', '71', 1),
(4590, 'Liberec', 'CZ', '513', 1),
(4591, 'Klatovy', 'CZ', '322', 1),
(4592, 'Uherské Hradiště', 'CZ', '722', 1),
(4593, 'Kroměříž', 'CZ', '721', 1),
(4595, 'Sokolov', 'CZ', '413', 1),
(4596, 'Semily', 'CZ', '514', 1),
(4597, 'Třebíč', 'CZ', '634', 1),
(4598, 'Praha, Hlavní město', 'CZ', '10', 1),
(4599, 'Ústí nad Labem', 'CZ', '427', 1),
(4600, 'Moravskoslezský kraj', 'CZ', '80', 1),
(4601, 'Liberecký kraj', 'CZ', '51', 1),
(4602, 'Jihomoravský kraj', 'CZ', '64', 1),
(4604, 'Karlovy Vary', 'CZ', '412', 1),
(4605, 'Litoměřice', 'CZ', '423', 1),
(4606, 'Praha-východ', 'CZ', '209', 1),
(4607, 'Plzeňský kraj', 'CZ', '32', 1),
(4608, 'Plzeň-jih', 'CZ', '324', 1),
(4609, 'Děčín', 'CZ', '421', 1),
(4611, 'Havlíčkův Brod', 'CZ', '631', 1),
(4612, 'Jablonec nad Nisou', 'CZ', '512', 1),
(4613, 'Jihlava', 'CZ', '632', 1),
(4614, 'Královéhradecký kraj', 'CZ', '52', 1),
(4615, 'Blansko', 'CZ', '641', 1),
(4617, 'Louny', 'CZ', '424', 1),
(4618, 'Kolín', 'CZ', '204', 1),
(4619, 'Praha-západ', 'CZ', '20A', 1),
(4620, 'Beroun', 'CZ', '202', 1),
(4621, 'Teplice', 'CZ', '426', 1),
(4622, 'Vyškov', 'CZ', '646', 1),
(4623, 'Opava', 'CZ', '805', 1),
(4624, 'Jindřichův Hradec', 'CZ', '313', 1),
(4625, 'Jeseník', 'CZ', '711', 1),
(4626, 'Přerov', 'CZ', '714', 1),
(4627, 'Benešov', 'CZ', '201', 1),
(4628, 'Strakonice', 'CZ', '316', 1),
(4629, 'Most', 'CZ', '425', 1),
(4630, 'Znojmo', 'CZ', '647', 1),
(4631, 'Kladno', 'CZ', '203', 1),
(4633, 'Česká Lípa', 'CZ', '511', 1),
(4634, 'Chrudim', 'CZ', '531', 1),
(4636, 'Rychnov nad Kněžnou', 'CZ', '524', 1),
(4638, 'Mělník', 'CZ', '206', 1),
(4639, 'Jihočeský kraj', 'CZ', '31', 1),
(4640, 'Jičín', 'CZ', '522', 1),
(4641, 'Domažlice', 'CZ', '321', 1),
(4642, 'Šumperk', 'CZ', '715', 1),
(4643, 'Mladá Boleslav', 'CZ', '207', 1),
(4644, 'Bruntál', 'CZ', '801', 1),
(4645, 'Pelhřimov', 'CZ', '633', 1),
(4646, 'Tachov', 'CZ', '327', 1),
(4647, 'Ústí nad Orlicí', 'CZ', '534', 1),
(4648, 'Žďár nad Sázavou', 'CZ', '635', 1),
(4649, 'North East Community Development Council', 'SG', '02', 1),
(4650, 'South East Community Development Council', 'SG', '04', 1),
(4651, 'Central Singapore Community Development Council', 'SG', '01', 1),
(4652, 'South West Community Development Council', 'SG', '05', 1),
(4653, 'North West Community Development Council', 'SG', '03', 1),
(4654, 'Ewa District', 'NR', '09', 1),
(4655, 'Uaboe District', 'NR', '13', 1),
(4656, 'Aiwo District', 'NR', '01', 1),
(4657, 'Meneng District', 'NR', '11', 1),
(4658, 'Anabar District', 'NR', '02', 1),
(4659, 'Nibok District', 'NR', '12', 1),
(4660, 'Baiti District', 'NR', '05', 1),
(4661, 'Ijuw District', 'NR', '10', 1),
(4662, 'Buada District', 'NR', '07', 1),
(4663, 'Anibare District', 'NR', '04', 1),
(4664, 'Yaren District', 'NR', '14', 1),
(4665, 'Boe District', 'NR', '06', 1),
(4666, 'Denigomodu District', 'NR', '08', 1),
(4667, 'Anetan District', 'NR', '03', 1),
(4668, 'Zhytomyrska oblast', 'UA', '18', 1),
(4669, 'Vinnytska oblast', 'UA', '05', 1),
(4670, 'Zakarpatska Oblast', 'UA', '21', 1),
(4671, 'Kyivska oblast', 'UA', '32', 1),
(4672, 'Lvivska oblast', 'UA', '46', 1),
(4673, 'Luhanska oblast', 'UA', '09', 1),
(4674, 'Ternopilska oblast', 'UA', '61', 1),
(4675, 'Dnipropetrovska oblast', 'UA', '12', 1),
(4676, 'Kyiv', 'UA', '30', 1),
(4677, 'Kirovohradska oblast', 'UA', '35', 1),
(4678, 'Chernivetska oblast', 'UA', '77', 1),
(4679, 'Mykolaivska oblast', 'UA', '48', 1),
(4680, 'Cherkaska oblast', 'UA', '71', 1),
(4681, 'Khmelnytska oblast', 'UA', '68', 1),
(4682, 'Ivano-Frankivska oblast', 'UA', '26', 1),
(4683, 'Rivnenska oblast', 'UA', '56', 1),
(4684, 'Khersonska oblast', 'UA', '65', 1),
(4685, 'Sumska oblast', 'UA', '59', 1),
(4686, 'Kharkivska oblast', 'UA', '63', 1),
(4687, 'Zaporizka oblast', 'UA', '23', 1),
(4688, 'Odeska oblast', 'UA', '51', 1),
(4689, 'Autonomous Republic of Crimea', 'UA', '43', 1),
(4690, 'Volynska oblast', 'UA', '07', 1),
(4691, 'Donetska oblast', 'UA', '14', 1),
(4692, 'Chernihivska oblast', 'UA', '74', 1),
(4693, 'Gabrovo Province', 'BG', '07', 1),
(4694, 'Smolyan Province', 'BG', '21', 1),
(4695, 'Pernik Province', 'BG', '14', 1),
(4696, 'Montana Province', 'BG', '12', 1),
(4697, 'Vidin Province', 'BG', '05', 1),
(4698, 'Razgrad Province', 'BG', '17', 1),
(4699, 'Blagoevgrad Province', 'BG', '01', 1),
(4700, 'Sliven Province', 'BG', '20', 1),
(4701, 'Plovdiv Province', 'BG', '16', 1),
(4702, 'Kardzhali Province', 'BG', '09', 1),
(4703, 'Kyustendil Province', 'BG', '10', 1),
(4704, 'Haskovo Province', 'BG', '26', 1),
(4705, 'Sofia City Province', 'BG', '22', 1),
(4706, 'Pleven Province', 'BG', '15', 1),
(4707, 'Stara Zagora Province', 'BG', '24', 1),
(4708, 'Silistra Province', 'BG', '19', 1),
(4709, 'Veliko Tarnovo Province', 'BG', '04', 1),
(4710, 'Lovech Province', 'BG', '11', 1),
(4711, 'Vratsa Province', 'BG', '06', 1),
(4712, 'Pazardzhik Province', 'BG', '13', 1),
(4713, 'Ruse Province', 'BG', '18', 1),
(4714, 'Targovishte Province', 'BG', '25', 1),
(4715, 'Burgas Province', 'BG', '02', 1),
(4716, 'Yambol Province', 'BG', '28', 1),
(4717, 'Varna Province', 'BG', '03', 1),
(4718, 'Dobrich Province', 'BG', '08', 1),
(4719, 'Sofia Province', 'BG', '23', 1),
(4720, 'Suceava County', 'RO', 'SV', 1),
(4721, 'Hunedoara County', 'RO', 'HD', 1),
(4722, 'Arges', 'RO', 'AG', 1),
(4723, 'Bihor County', 'RO', 'BH', 1),
(4724, 'Alba', 'RO', 'AB', 1),
(4725, 'Ilfov County', 'RO', 'IF', 1),
(4726, 'Giurgiu County', 'RO', 'GR', 1),
(4727, 'Tulcea County', 'RO', 'TL', 1),
(4728, 'Teleorman County', 'RO', 'TR', 1),
(4729, 'Prahova County', 'RO', 'PH', 1),
(4730, 'Bucharest', 'RO', 'B', 1),
(4731, 'Neamț County', 'RO', 'NT', 1),
(4732, 'Călărași County', 'RO', 'CL', 1),
(4733, 'Bistrița-Năsăud County', 'RO', 'BN', 1),
(4734, 'Cluj County', 'RO', 'CJ', 1),
(4735, 'Iași County', 'RO', 'IS', 1),
(4736, 'Braila', 'RO', 'BR', 1),
(4737, 'Constanța County', 'RO', 'CT', 1),
(4738, 'Olt County', 'RO', 'OT', 1),
(4739, 'Arad County', 'RO', 'AR', 1),
(4740, 'Botoșani County', 'RO', 'BT', 1),
(4741, 'Sălaj County', 'RO', 'SJ', 1),
(4742, 'Dolj County', 'RO', 'DJ', 1),
(4743, 'Ialomița County', 'RO', 'IL', 1),
(4744, 'Bacău County', 'RO', 'BC', 1),
(4745, 'Dâmbovița County', 'RO', 'DB', 1),
(4746, 'Satu Mare County', 'RO', 'SM', 1),
(4747, 'Galați County', 'RO', 'GL', 1),
(4748, 'Timiș County', 'RO', 'TM', 1),
(4749, 'Harghita County', 'RO', 'HR', 1),
(4750, 'Gorj County', 'RO', 'GJ', 1),
(4751, 'Mehedinți County', 'RO', 'MH', 1),
(4752, 'Vaslui County', 'RO', 'VS', 1),
(4753, 'Caraș-Severin County', 'RO', 'CS', 1),
(4754, 'Covasna County', 'RO', 'CV', 1),
(4755, 'Sibiu County', 'RO', 'SB', 1),
(4756, 'Buzău County', 'RO', 'BZ', 1),
(4757, 'Vâlcea County', 'RO', 'VL', 1),
(4758, 'Vrancea County', 'RO', 'VN', 1),
(4759, 'Brașov County', 'RO', 'BV', 1),
(4760, 'Maramureș County', 'RO', 'MM', 1),
(4761, 'Aiga-i-le-Tai', 'WS', 'AL', 1),
(4762, 'Satupa''itea', 'WS', 'SA', 1),
(4763, 'A''ana', 'WS', 'AA', 1),
(4764, 'Fa''asaleleaga', 'WS', 'FA', 1),
(4765, 'Atua', 'WS', 'AT', 1),
(4766, 'Vaisigano', 'WS', 'VS', 1),
(4767, 'Palauli', 'WS', 'PA', 1),
(4768, 'Va''a-o-Fonoti', 'WS', 'VF', 1),
(4769, 'Gaga''emauga', 'WS', 'GE', 1),
(4770, 'Tuamasaga', 'WS', 'TU', 1),
(4771, 'Gaga''ifomauga', 'WS', 'GI', 1),
(4772, 'Torba', 'VU', 'TOB', 1),
(4773, 'Penama', 'VU', 'PAM', 1),
(4774, 'Shefa', 'VU', 'SEE', 1),
(4775, 'Malampa', 'VU', 'MAP', 1),
(4776, 'Sanma', 'VU', 'SAM', 1),
(4777, 'Tafea', 'VU', 'TAE', 1),
(4778, 'Honiara', 'SB', 'CT', 1),
(4779, 'Temotu Province', 'SB', 'TE', 1),
(4780, 'Isabel Province', 'SB', 'IS', 1),
(4781, 'Choiseul Province', 'SB', 'CH', 1),
(4782, 'Makira-Ulawa Province', 'SB', 'MK', 1),
(4783, 'Malaita Province', 'SB', 'ML', 1),
(4784, 'Central Province', 'SB', 'CE', 1),
(4785, 'Guadalcanal Province', 'SB', 'GU', 1),
(4786, 'Western Province', 'SB', 'WE', 1),
(4787, 'Rennell and Bellona Province', 'SB', 'RB', 1),
(4794, 'Saint-Barthélemy', 'FR', 'BL', 1),
(4795, 'Nouvelle-Aquitaine', 'FR', 'NAQ', 1),
(4796, 'Île-de-France', 'FR', 'IDF', 1),
(4797, 'Mayotte', 'FR', '976', 1),
(4798, 'Auvergne-Rhône-Alpes', 'FR', 'ARA', 1),
(4799, 'Occitanie', 'FR', 'OCC', 1),
(4802, 'Pays-de-la-Loire', 'FR', 'PDL', 1),
(4804, 'Normandie', 'FR', 'NOR', 1),
(4806, 'Corse', 'FR', '20R', 1),
(4807, 'Bretagne', 'FR', 'BRE', 1),
(4809, 'Saint-Martin', 'FR', 'MF', 1),
(4810, 'Wallis and Futuna', 'FR', 'WF', 1),
(4811, 'Alsace', 'FR', '6AE', 1),
(4812, 'Provence-Alpes-Côte-d’Azur', 'FR', 'PAC', 1),
(4816, 'Paris', 'FR', '75C', 1),
(4818, 'Centre-Val de Loire', 'FR', 'CVL', 1),
(4820, 'Grand-Est', 'FR', 'GES', 1),
(4821, 'Saint Pierre and Miquelon', 'FR', 'PM', 1),
(4822, 'French Guiana', 'FR', '973', 1),
(4823, 'La Réunion', 'FR', '974', 1),
(4824, 'French Polynesia', 'FR', 'PF', 1),
(4825, 'Bourgogne-Franche-Comté', 'FR', 'BFC', 1),
(4827, 'Martinique', 'FR', '972', 1),
(4828, 'Hauts-de-France', 'FR', 'HDF', 1),
(4829, 'Guadeloupe', 'FR', '971', 1),
(4830, 'West New Britain Province', 'PG', 'WBK', 1),
(4831, 'Bougainville', 'PG', 'NSB', 1),
(4832, 'Jiwaka Province', 'PG', 'JWK', 1),
(4833, 'Hela', 'PG', 'HLA', 1),
(4834, 'East New Britain', 'PG', 'EBR', 1),
(4835, 'Morobe Province', 'PG', 'MPL', 1),
(4836, 'Sandaun Province', 'PG', 'SAN', 1),
(4837, 'Port Moresby', 'PG', 'NCD', 1),
(4838, 'Oro Province', 'PG', 'NPP', 1),
(4839, 'Gulf', 'PG', 'GPK', 1),
(4840, 'Western Highlands Province', 'PG', 'WHM', 1),
(4841, 'New Ireland Province', 'PG', 'NIK', 1),
(4842, 'Manus Province', 'PG', 'MRL', 1),
(4843, 'Madang Province', 'PG', 'MPM', 1),
(4844, 'Southern Highlands Province', 'PG', 'SHM', 1),
(4845, 'Eastern Highlands Province', 'PG', 'EHG', 1),
(4846, 'Chimbu Province', 'PG', 'CPK', 1),
(4847, 'Central Province', 'PG', 'CPM', 1),
(4848, 'Enga Province', 'PG', 'EPW', 1),
(4849, 'Milne Bay Province', 'PG', 'MBA', 1),
(4850, 'Western Province', 'PG', 'WPD', 1),
(4851, 'Ohio', 'US', 'OH', 1),
(4852, 'Ladakh', 'IN', 'LA', 1),
(4853, 'West Bengal', 'IN', 'WB', 1),
(4854, 'Sinop', 'TR', '57', 1),
(4855, 'Distrito Capital', 'VE', 'A', 1),
(4856, 'Apure', 'VE', 'C', 1),
(4857, 'Jalisco', 'MX', 'JAL', 1),
(4858, 'Roraima', 'BR', 'RR', 1),
(4859, 'Guarda', 'PT', '09', 1),
(4860, 'Devonshire Parish', 'BM', 'DEV', 1),
(4861, 'Hamilton Parish', 'BM', 'HA', 1),
(4863, 'Paget Parish', 'BM', 'PAG', 1),
(4864, 'Pembroke Parish', 'BM', 'PEM', 1),
(4866, 'Saint George''s Parish', 'BM', 'SGE', 1),
(4867, 'Sandys Parish', 'BM', 'SAN', 1),
(4868, 'Smith''s Parish,', 'BM', 'SMI', 1),
(4869, 'Southampton Parish', 'BM', 'SOU', 1),
(4870, 'Warwick Parish', 'BM', 'WAR', 1),
(4871, 'Huila', 'CO', 'HUI', 1),
(4874, 'Uroševac District (Ferizaj)', 'XK', 'XUF', 1),
(4876, 'Đakovica District (Gjakove)', 'XK', 'XDG', 1),
(4877, 'Gjilan District', 'XK', 'XGJ', 1),
(4878, 'Kosovska Mitrovica District', 'XK', 'XKM', 1),
(4879, 'Pristina (Priştine)', 'XK', 'XPI', 1),
(4880, 'Ciudad Autónoma de Buenos Aires', 'AR', 'C', 1),
(4881, 'New Providence', 'BS', 'NP', 1),
(4882, 'Shumen', 'BG', '27', 1),
(4883, 'Yuen Long District', 'HK', 'NYL', 1),
(4884, 'Tsuen Wan District', 'HK', 'NTW', 1),
(4885, 'Tai Po District', 'KH', 'NTP', 1),
(4887, 'Sai Kung District', 'HK', 'NSK', 1),
(4888, 'Islands District', 'HK', 'NIS', 1),
(4889, 'Central and Western District', 'HK', 'HCW', 1),
(4890, 'Wan Chai', 'HK', 'HWC', 1),
(4891, 'Eastern', 'HK', 'HEA', 1),
(4892, 'Southern', 'HK', 'HSO', 1),
(4893, 'Yau Tsim Mong', 'HK', 'KYT', 1),
(4894, 'Sham Shui Po', 'HK', 'KSS', 1),
(4895, 'Kowloon City', 'HK', 'KKC', 1),
(4896, 'Wong Tai Sin', 'HK', 'KWT', 1),
(4897, 'Kwun Tong', 'HK', 'KKT', 1),
(4898, 'Kwai Tsing', 'HK', 'NKT', 1),
(4899, 'Tuen Mun', 'HK', 'NTM', 1),
(4900, 'North', 'HK', 'NNO', 1),
(4901, 'Sha Tin', 'HK', 'NST', 1),
(4902, 'Sidi Bel Abbès', 'DZ', '22', 1),
(4905, 'El M''ghair', 'DZ', '49', 1),
(4906, 'El Menia', 'DZ', '50', 1),
(4907, 'Ouled Djellal', 'DZ', '51', 1),
(4908, 'Bordj Baji Mokhtar', 'DZ', '52', 1),
(4909, 'Béni Abbès', 'DZ', '53', 1),
(4910, 'Timimoun', 'DZ', '54', 1),
(4911, 'Touggourt', 'DZ', '55', 1),
(4912, 'Djanet', 'DZ', '56', 1),
(4913, 'In Salah', 'DZ', '57', 1),
(4914, 'In Guezzam', 'DZ', '58', 1),
(4915, 'Mureș County', 'RO', 'MS', 1),
(4916, 'Volgograd Oblast', 'RU', 'VGG', 1),
(4917, 'La Colle', 'MC', 'CL', 1),
(4918, 'La Condamine', 'MC', 'CO', 1),
(4919, 'Moneghetti', 'MC', 'MG', 1),
(4920, 'Hamadan', 'IR', '13', 1),
(4921, 'Bogotá D.C.', 'CO', 'DC', 1),
(4922, 'Loreto', 'PE', 'LOR', 1),
(4923, 'Kutná Hora', 'CZ', '205', 1),
(4924, 'Kōchi Prefecture', 'JP', '39', 1),
(4925, 'Cần Thơ', 'VN', 'CT', 1),
(4926, 'Rivers', 'NG', 'RI', 1),
(4927, 'Rabat-Salé-Kénitra', 'MA', '04', 1),
(4928, 'Agadir-Ida-Ou-Tanane', 'MA', 'AGD', 1),
(4929, 'Berrechid', 'MA', 'BRR', 1),
(4930, 'Casablanca', 'MA', 'CAS', 1),
(4931, 'Driouch', 'MA', 'DRI', 1),
(4932, 'Fès', 'MA', 'FES', 1),
(4933, 'Fquih Ben Salah', 'MA', 'FQH', 1),
(4934, 'Guercif', 'MA', 'GUF', 1),
(4935, 'Marrakech', 'MA', 'MAR', 1),
(4936, 'M’diq-Fnideq', 'MA', 'MDF', 1),
(4937, 'Meknès', 'MA', 'MEK', 1),
(4938, 'Midelt', 'MA', 'MID', 1),
(4939, 'Mohammadia', 'MA', 'MOH', 1),
(4940, 'Oujda-Angad', 'MA', 'OUJ', 1),
(4941, 'Ouezzane', 'MA', 'OUZ', 1),
(4942, 'Rabat', 'MA', 'RAB', 1),
(4943, 'Rehamna', 'MA', 'REH', 1),
(4944, 'Salé', 'MA', 'SAL', 1),
(4945, 'Sidi Bennour', 'MA', 'SIB', 1),
(4946, 'Sidi Ifni', 'MA', 'SIF', 1),
(4947, 'Skhirate-Témara', 'MA', 'SKH', 1),
(4948, 'Tarfaya (EH-partial)', 'MA', 'TAF', 1),
(4949, 'Tinghir', 'MA', 'TIN', 1),
(4950, 'Tanger-Assilah', 'MA', 'TNG', 1),
(4951, 'Youssoufia', 'MA', 'YUS', 1),
(4952, 'Sidi Slimane', 'MA', 'SIL', 1),
(4953, 'Lualaba', 'CD', 'LU', 1),
(4954, 'Chaiyaphum', 'TH', '36', 1),
(4955, 'Mbeya', 'TZ', '14', 1),
(4956, 'Songwe', 'TZ', '31', 1),
(4957, 'Basel-Stadt', 'CH', 'BS', 1),
(4958, 'Bono East', 'GH', 'BE', 1),
(4959, 'Bono', 'GH', 'BO', 1),
(4960, 'North East', 'GH', 'NE', 1),
(4961, 'Oti', 'GH', 'OT', 1),
(4962, 'Savannah', 'GH', 'SV', 1),
(4963, 'Western North', 'GH', 'WN', 1),
(4964, 'Nueva Segovia', 'NI', 'NS', 1),
(4965, 'Keelung', 'TW', 'KEE', 1),
(4966, 'New Taipei', 'TW', 'NWT', 1),
(4967, 'Ain', 'FR', '01', 1),
(4968, 'Aisne', 'FR', '02', 1),
(4969, 'Allier', 'FR', '03', 1),
(4970, 'Alpes-de-Haute-Provence', 'FR', '04', 1),
(4971, 'Hautes-Alpes', 'FR', '05', 1),
(4972, 'Alpes-Maritimes', 'FR', '06', 1),
(4973, 'Ardèche', 'FR', '07', 1),
(4974, 'Ardennes', 'FR', '08', 1),
(4975, 'Ariège', 'FR', '09', 1),
(4976, 'Aube', 'FR', '10', 1),
(4977, 'Aude', 'FR', '11', 1),
(4978, 'Aveyron', 'FR', '12', 1),
(4979, 'Bouches-du-Rhône', 'FR', '13', 1),
(4981, 'Calvados', 'FR', '14', 1),
(4982, 'Cantal', 'FR', '15', 1),
(4983, 'Charente', 'FR', '16', 1),
(4984, 'Charente-Maritime', 'FR', '17', 1),
(4985, 'Cher', 'FR', '18', 1),
(4986, 'Corrèze', 'FR', '19', 1),
(4987, 'Côte-d''Or', 'FR', '21', 1),
(4988, 'Côtes-d''Armor', 'FR', '22', 1),
(4989, 'Creuse', 'FR', '23', 1),
(4990, 'Dordogne', 'FR', '24', 1),
(4991, 'Doubs', 'FR', '25', 1),
(4992, 'Drôme', 'FR', '26', 1),
(4993, 'Eure', 'FR', '27', 1),
(4994, 'Eure-et-Loir', 'FR', '28', 1),
(4995, 'Finistère', 'FR', '29', 1),
(4996, 'Corse-du-Sud', 'FR', '2A', 1),
(4997, 'Haute-Corse', 'FR', '2B', 1),
(4998, 'Gard', 'FR', '30', 1),
(4999, 'Haute-Garonne', 'FR', '31', 1),
(5000, 'Gers', 'FR', '32', 1),
(5001, 'Gironde', 'FR', '33', 1),
(5002, 'Hérault', 'FR', '34', 1),
(5003, 'Ille-et-Vilaine', 'FR', '35', 1),
(5004, 'Indre', 'FR', '36', 1),
(5005, 'Indre-et-Loire', 'FR', '37', 1),
(5006, 'Isère', 'FR', '38', 1),
(5007, 'Jura', 'FR', '39', 1),
(5008, 'Landes', 'FR', '40', 1),
(5009, 'Loir-et-Cher', 'FR', '41', 1),
(5010, 'Loire', 'FR', '42', 1),
(5011, 'Haute-Loire', 'FR', '43', 1),
(5012, 'Loire-Atlantique', 'FR', '44', 1),
(5013, 'Loiret', 'FR', '45', 1),
(5014, 'Lot', 'FR', '46', 1),
(5015, 'Lot-et-Garonne', 'FR', '47', 1),
(5016, 'Lozère', 'FR', '48', 1),
(5017, 'Maine-et-Loire', 'FR', '49', 1),
(5018, 'Manche', 'FR', '50', 1),
(5019, 'Marne', 'FR', '51', 1),
(5020, 'Haute-Marne', 'FR', '52', 1),
(5021, 'Mayenne', 'FR', '53', 1),
(5022, 'Meurthe-et-Moselle', 'FR', '54', 1),
(5023, 'Meuse', 'FR', '55', 1),
(5024, 'Morbihan', 'FR', '56', 1),
(5025, 'Moselle', 'FR', '57', 1),
(5026, 'Nièvre', 'FR', '58', 1),
(5027, 'Nord', 'FR', '59', 1),
(5028, 'Oise', 'FR', '60', 1),
(5029, 'Orne', 'FR', '61', 1),
(5030, 'Pas-de-Calais', 'FR', '62', 1),
(5031, 'Puy-de-Dôme', 'FR', '63', 1),
(5032, 'Pyrénées-Atlantiques', 'FR', '64', 1),
(5033, 'Hautes-Pyrénées', 'FR', '65', 1),
(5034, 'Pyrénées-Orientales', 'FR', '66', 1),
(5035, 'Bas-Rhin', 'FR', '67', 1),
(5036, 'Haut-Rhin', 'FR', '68', 1),
(5037, 'Rhône', 'FR', '69', 1),
(5038, 'Métropole de Lyon', 'FR', '69M', 1),
(5039, 'Haute-Saône', 'FR', '70', 1),
(5040, 'Saône-et-Loire', 'FR', '71', 1),
(5041, 'Sarthe', 'FR', '72', 1),
(5042, 'Savoie', 'FR', '73', 1),
(5043, 'Haute-Savoie', 'FR', '74', 1),
(5044, 'Seine-Maritime', 'FR', '76', 1),
(5045, 'Seine-et-Marne', 'FR', '77', 1),
(5046, 'Yvelines', 'FR', '78', 1),
(5047, 'Deux-Sèvres', 'FR', '79', 1),
(5048, 'Somme', 'FR', '80', 1),
(5049, 'Tarn', 'FR', '81', 1),
(5050, 'Tarn-et-Garonne', 'FR', '82', 1),
(5051, 'Var', 'FR', '83', 1),
(5052, 'Vaucluse', 'FR', '84', 1),
(5053, 'Vendée', 'FR', '85', 1),
(5054, 'Vienne', 'FR', '86', 1),
(5055, 'Haute-Vienne', 'FR', '87', 1),
(5056, 'Vosges', 'FR', '88', 1),
(5057, 'Yonne', 'FR', '89', 1),
(5058, 'Territoire de Belfort', 'FR', '90', 1),
(5059, 'Essonne', 'FR', '91', 1),
(5060, 'Hauts-de-Seine', 'FR', '92', 1),
(5061, 'Seine-Saint-Denis', 'FR', '93', 1),
(5062, 'Val-de-Marne', 'FR', '94', 1),
(5063, 'Val-d''Oise', 'FR', '95', 1),
(5064, 'Clipperton', 'FR', 'CP', 1),
(5065, 'French Southern and Antarctic Lands', 'FR', 'TF', 1),
(5067, 'Sharqia', 'EG', 'SHR', 1),
(5068, 'Loja', 'EC', 'L', 1),
(5069, 'Karlovac', 'HR', '04', 1),
(5070, 'Kampong Thom', 'KH', '6', 1),
(5071, 'Poltavska oblast', 'UA', '53', 1),
(5072, 'Saint Thomas', 'VI', 'ST', 1),
(5073, 'Saint John', 'VI', 'SJ', 1),
(5074, 'Saint Croix', 'VI', 'SC', 1),
(5075, 'San Juan', 'PR', 'SJ', 1),
(5076, 'Bayamon', 'PR', 'BY', 1),
(5077, 'Carolina', 'PR', 'CL', 1),
(5078, 'Ponce', 'PR', 'PO', 1),
(5079, 'Caguas', 'PR', 'CG', 1),
(5080, 'Guaynabo', 'PR', 'GN', 1),
(5081, 'Arecibo', 'PR', 'AR', 1),
(5082, 'Toa Baja', 'PR', 'TB', 1),
(5083, 'Mayagüez', 'PR', 'MG', 1),
(5084, 'Trujillo Alto', 'PR', 'TA', 1),
(5085, 'Komárom-Esztergom', 'HU', 'KE', 1),
(5086, 'Bonaire', 'BQ', 'BQ1', 1),
(5087, 'Saba', 'BQ', 'BQ2', 1),
(5088, 'Sint Eustatius', 'BQ', 'BQ3', 1),
(5089, 'A Coruña', 'ES', 'C', 1),
(5090, 'Lugo', 'ES', 'LU', 1),
(5091, 'Ourense', 'ES', 'OR', 1),
(5092, 'Badajoz', 'ES', 'BA', 1),
(5093, 'Araba', 'ES', 'VI', 1),
(5094, 'Bizkaia', 'ES', 'BI', 1),
(5095, 'Almeria', 'ES', 'AL', 1),
(5096, 'Cádiz', 'ES', 'CA', 1),
(5097, 'Córdoba', 'ES', 'CO', 1),
(5098, 'Granada', 'ES', 'GR', 1),
(5099, 'Huelva', 'ES', 'H', 1),
(5100, 'Jaén', 'ES', 'J', 1),
(5101, 'Málaga', 'ES', 'MA', 1),
(5102, 'Barcelona', 'ES', 'B', 1),
(5103, 'Girona', 'ES', 'GI', 1),
(5104, 'Lleida', 'ES', 'L', 1),
(5105, 'Ciudad Real', 'ES', 'CR', 1),
(5106, 'Cuenca', 'ES', 'CU', 1),
(5107, 'Guadalajara', 'ES', 'GU', 1),
(5108, 'Alicante', 'ES', 'A', 1),
(5109, 'Albacete', 'ES', 'AB', 1),
(5110, 'Castellón', 'ES', 'CS', 1),
(5111, 'Teruel', 'ES', 'TE', 1),
(5112, 'Santa Cruz de Tenerife', 'ES', 'TF', 1),
(5113, 'Zaragoza', 'ES', 'Z', 1),
(5114, 'Chari-Baguirmi', 'TD', 'CB', 1),
(5115, 'Western Samar', 'PH', 'WSA', 1),
(5116, 'Nabeul', 'TN', '21', 1);

-- --------------------------------------------------------

--
-- Table structure for table `statusalias`
--

CREATE TABLE `statusalias` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `statusid` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `aliasto` int(11) DEFAULT NULL,
  `type` int(11) NOT NULL,
  `system` int(1) NOT NULL,
  `order` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=17 ;

--
-- Dumping data for table `statusalias`
--

INSERT INTO `statusalias` VALUES
(1, 0, 'Pending', NULL, 1, 1, 1),
(2, 1, 'Active', NULL, 1, 1, 2),
(3, 2, 'Suspended', NULL, 1, 1, 3),
(4, 3, 'Cancelled', NULL, 1, 1, 4),
(5, 4, 'Pending Cancelation', NULL, 1, 1, 5),
(6, 5, 'Expired', NULL, 1, 1, 6),
(7, 0, 'Unassigned', NULL, 2, 1, 1),
(8, 1, 'Open', NULL, 2, 1, 2),
(9, 2, 'In Progress', NULL, 2, 1, 3),
(10, 3, 'Waiting on Customer', NULL, 2, 1, 4),
(11, -1, 'Closed', NULL, 2, 1, 5),
(12, 0, 'Pending', NULL, 3, 1, 1),
(13, 1, 'Active', NULL, 3, 1, 2),
(14, -1, 'Inactive', NULL, 3, 1, 3),
(15, -2, 'Cancelled', NULL, 3, 1, 4),
(16, -3, 'Fraud', NULL, 3, 1, 5);

-- --------------------------------------------------------

--
-- Table structure for table `tags`
--

CREATE TABLE `tags` (
  `company_id` int(11) NOT NULL DEFAULT '0',
  `tag_type` smallint(3) NOT NULL DEFAULT '0',
  `tag_name` varchar(35) NOT NULL,
  `num_articles` smallint(5) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`company_id`,`tag_name`,`tag_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `taxrule`
--

CREATE TABLE `taxrule` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `countryiso` varchar(5) NOT NULL DEFAULT '',
  `state` varchar(20) NOT NULL DEFAULT '',
  `tax` decimal(25,3) NOT NULL DEFAULT '0.000',
  `vat` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(20) NOT NULL DEFAULT '',
  `level` tinyint(1) NOT NULL DEFAULT '1',
  `compound` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `country-state-level` (`countryiso`,`state`,`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `team_status`
--

CREATE TABLE `team_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) NOT NULL,
  `userstatus` text NOT NULL,
  `status_datetime` datetime NOT NULL,
  `replyid` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tld_extra_attributes`
--

CREATE TABLE `tld_extra_attributes` (
  `tld` varchar(10) NOT NULL,
  `extra_attributes` text NOT NULL,
  PRIMARY KEY (`tld`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `tld_extra_attributes`
--

INSERT INTO `tld_extra_attributes` VALUES
('us', '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'),
('uk', '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'),
('nu', 'YToxOntzOjk6Imlpc19vcmdubyI7YTo0OntzOjI6IklEIjtzOjM6IjIyNyI7czoxMToiZGVzY3JpcHRpb24iO3M6Mjc5OiJPcmdhbml6YXRpb24gTnVtYmVyOgoKU3RhcnRzIHdpdGggSVNPIDMxNjYgQWxwaGEtMiBjb3VudHJ5IGNvZGUgaW4gc3F1YXJlIGJyYWNrZXRzIChlLmcuIFtVU10gZm9yIFVuaXRlZCBTdGF0ZXMpLCBmb2xsb3dlZCBieSAxIHRvIDEyMyBjaGFyYWN0ZXJzLiBJZiB0aGUgY291bnRyeSBjb2RlIGZvciBTd2VkZW4gaXMgZ2l2ZW4sIGEgdmFsaWQgU3dlZGlzaCBwZXJzb25hbCBvciBvcmdhbmlzYXRpb25hbCBudW1iZXIgbXVzdCBiZSBnaXZlbiAoNiBkaWdpdHMsIGRhc2gsIDQgZGlnaXRzKS4iO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('nyc', 'YToxOntzOjE3OiJueWNfbmV4dXNjYXRlZ29yeSI7YTo0OntzOjI6IklEIjtzOjM6IjIzNiI7czoxMToiZGVzY3JpcHRpb24iO3M6NTg5OiJPbmx5IGluZGl2aWR1YWxzIGFuZCBvcmdhbml6YXRpb25zIHRoYXQgaGF2ZSBhIHBoeXNpY2FsIHByZXNlbmNlIGluIG9uZSBvZiBOZXcgWW9yayBDaXR54oCZcyA1IGJvcm91Z2hzIHdpbGwgYmUgYWxsb3dlZCB0byByZWdpc3RlciBhIC5ueWMgZG9tYWluLgotIFAuTyBCb3hlcyBub3QgcGVybWl0dGVkCi0gUmVnaXN0cmFudHMgbXVzdCBhZ3JlZSB0aGF0IHRoZXkgYXJlIGluIGNvbXBsaWFuY2Ugd2l0aCBhbGwgcmVsZXZhbnQgRmVkZXJhbCwgTmV3IFlvcmsgU3RhdGUgYW5kIE5ldyBZb3JrIENpdHkgbGF3cyBhbmQgdGF4IHJlcXVpcmVtZW50cwotIFJlZ2lzdHJhbnRzIG11c3QgcmVtYWluIGluIGNvbXBsaWFuY2Ugd2l0aCB0aGUgYXBwbGljYWJsZSBOZXh1cyBQb2xpY3kgZm9yIHRoZSBkdXJhdGlvbiBvZiBkb21haW7igJlzIHJlZ2lzdHJhdGlvbgotIE5vIHByb3h5IHJlZ2lzdHJhdGlvbnMgcGVybWl0dGVk4oCTIFJlZ2lzdHJhbnRzIG11c3QgYWdyZWUgbm90IHRvIGxpY2Vuc2UsIHN1Yi1kZWxlZ2F0ZSBvciB0cmFuc2ZlciAubnljIGRvbWFpbihzKSB0byB0aGlyZCBwYXJ0aWVzLgoKSSBkZWNsYXJlIHRoYXQgSSBhbSBhbjoKIjtzOjg6InJlcXVpcmVkIjtzOjE6IjEiO3M6Nzoib3B0aW9ucyI7YToyOntzOjEyOiJPcmdhbml6YXRpb24iO2E6Mjp7czoxMToiZGVzY3JpcHRpb24iO3M6Nzg6IkFuIGVudGl0eSBvciBvcmdhbml6YXRpb24gdGhhdCBoYXMgYSBwaHlzaWNhbCBzdHJlZXQgYWRkcmVzcyBpbiBOZXcgWW9yayBDaXR5LiI7czo1OiJ2YWx1ZSI7czozOiJPUkciO31zOjEwOiJJbmRpdmlkdWFsIjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjY1OiJJbmRpdmlkdWFscyB3aG9zZSBwcmltYXJ5IHBsYWNlIG9mIHJlc2lkZW5jZSBpcyBpbiBOZXcgWW9yayBDaXR5LiI7czo1OiJ2YWx1ZSI7czo1OiJJTkRJViI7fX19fQ=='),
('physio', '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'),
('scot', 'YToxOntzOjE2OiJjb3JlX2ludGVuZGVkdXNlIjthOjQ6e3M6MjoiSUQiO3M6MzoiMjU0IjtzOjExOiJkZXNjcmlwdGlvbiI7czo4OToiUGxlYXNlIHdyaXRlIGEgYnJpZWYgZGVzY3JpcHRpb24gb2YgeW91ciBpbnRlbmRlZCB1c2Ugb2YgdGhpcyBkb21haW4gKG1heCAyNTUgY2hhcmFjdGVycykiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('quebec', 'YToxOntzOjE2OiJjb3JlX2ludGVuZGVkdXNlIjthOjQ6e3M6MjoiSUQiO3M6MzoiMjU1IjtzOjExOiJkZXNjcmlwdGlvbiI7czo4OToiUGxlYXNlIHdyaXRlIGEgYnJpZWYgZGVzY3JpcHRpb24gb2YgeW91ciBpbnRlbmRlZCB1c2Ugb2YgdGhpcyBkb21haW4gKG1heCAyNTUgY2hhcmFjdGVycykiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('bio', 'YToxOntzOjk6ImJpb19hZ3JlZSI7YTo0OntzOjI6IklEIjtzOjM6IjI0MyI7czoxMToiZGVzY3JpcHRpb24iO3M6NDgzOiJCeSByZWdpc3RlcmluZyB0aGlzIGRvbWFpbiBuYW1lLCB0aGUgcmVnaXN0cmFudCBjb21taXRzIHRvIG5vdCB1bmRlcm1pbmUgdGhlIFByaW5jaXBsZXMgb2YgT3JnYW5pYyBBZ3JpY3VsdHVyZSBhcyBmb3JtdWxhdGVkIGJ5IHRoZSBJRk9BTSAoUE9BKS4gCgkJSWYgdGhlIHJlZ2lzdHJhbnQgaXMgYSBwcm9kdWNlciwgYSB0cmFuc2Zvcm1lciBvciByZXRhaWxlciBpbiB0aGUgZmllbGQgb2YgYWdyaWN1bHR1cmUsIGZvb2QgYW5kIGZhcm1pbmcsIHRoZSByZWdpc3RyYW50IGNvbW1pdHMgdG8gYWJpZGUgYnkgUE9BIGFuZCBieSBhbnkgCgkJcmVndWxhdGlvbnMgaW4gZm9yY2UgaW4gdGhlIHJlbGV2YW50IG1hcmtldHMgd2hlcmUgdGhlIHJlZ2lzdHJhbnQgaW50ZW5kcyB0byBwcmVzZW50IG9yIHByb21vdGUgaXRzIHByb2R1Y3RzIHdpdGhpbiB0aGUgb24tbGluZSBjb250ZW50IGFzc29jaWF0ZWQgd2l0aCB0aGlzIC5CSU8gZG9tYWluIG5hbWUocykiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjE6e3M6NzoiSSBhZ3JlZSI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czo0ODU6IkkgY2VydGlmeSB0aGF0IHRoZSByZWdpc3RyYW50IG9mIHRoaXMgZG9tYWluIHRoZSBjb21taXRzIHRvIG5vdCB1bmRlcm1pbmUgdGhlIFByaW5jaXBsZXMgb2YgT3JnYW5pYyBBZ3JpY3VsdHVyZSBhcyBmb3JtdWxhdGVkIGJ5IHRoZSBJRk9BTSAoUE9BKS4gCgkJSWYgdGhlIHJlZ2lzdHJhbnQgaXMgYSBwcm9kdWNlciwgYSB0cmFuc2Zvcm1lciBvciByZXRhaWxlciBpbiB0aGUgZmllbGQgb2YgYWdyaWN1bHR1cmUsIGZvb2QgYW5kIGZhcm1pbmcsIHRoZSByZWdpc3RyYW50IGNvbW1pdHMgdG8gYWJpZGUgYnkgUE9BIGFuZCBieSBhbnkgCgkJcmVndWxhdGlvbnMgaW4gZm9yY2UgaW4gdGhlIHJlbGV2YW50IG1hcmtldHMgd2hlcmUgdGhlIHJlZ2lzdHJhbnQgaW50ZW5kcyB0byBwcmVzZW50IG9yIHByb21vdGUgaXRzIHByb2R1Y3RzIHdpdGhpbiB0aGUgb24tbGluZSBjb250ZW50IGFzc29jaWF0ZWQgd2l0aCB0aGlzIC5CSU8gZG9tYWluIG5hbWUocykuIjtzOjU6InZhbHVlIjtzOjc6IkkgQWdyZWUiO319fX0='),
('archi', 'YToxOntzOjExOiJhcmNoaV9hZ3JlZSI7YTo0OntzOjI6IklEIjtzOjM6IjI0MCI7czoxMToiZGVzY3JpcHRpb24iO3M6MzI2OiJCeSByZWdpc3RlcmluZyB0aGlzIGRvbWFpbiBuYW1lLCB5b3UgY2VydGlmeSB0aGF0IHRoZSByZWdpc3RyYW50IG9mIHRoaXMgZG9tYWluIGlzIGFuIGluZGl2aWR1YWwgcHJvZmVzc2lvbmFsIGFyY2hpdGVjdCAob3IgYW4gYXJjaGl0ZWN0dXJlIGZpcm0pIHJlZ2lzdGVyZWQgYXMgYSBtZW1iZXIgb2YgYSBuYXRpb25hbCBhcmNoaXRlY3RzIGFzc29jaWF0aW9uIGF1dGhvcml6ZWQgYnkgdGhlIHJlZ2lzdHJ5IG9wZXJhdG9yLCBvciBhbiBhcmNoaXRlY3R1cmUtcmVsYXRlZCBvcmdhbml6YXRpb24gYXV0aG9yaXplZCBieSB0aGUgcmVnaXN0cnkgb3BlcmF0b3IuJnF1b3Q7CiI7czo4OiJyZXF1aXJlZCI7czoxOiIxIjtzOjc6Im9wdGlvbnMiO2E6MTp7czo3OiJJIGFncmVlIjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjExMToiSSBjZXJ0aWZ5IHRoYXQgdGhlIHJlZ2lzdHJhbnQgb2YgdGhpcyBkb21haW4gaXMgYW4gaW5kaXZpZHVhbCBwcm9mZXNzaW9uYWwgYXJjaGl0ZWN0IChvciBhbiBhcmNoaXRlY3R1cmUgZmlybSkuIjtzOjU6InZhbHVlIjtzOjc6IkkgQWdyZWUiO319fX0='),
('ca', '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'),
('co.uk', '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'),
('org.uk', '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'),
('law.pro', 'YToxOntzOjE0OiJwcm9fcHJvZmVzc2lvbiI7YTo0OntzOjI6IklEIjtzOjM6IjE4MiI7czoxMToiZGVzY3JpcHRpb24iO3M6NDg2OiJSZWdpc3RyeVBybyBtb25pdG9ycyBhbGwgbmV3IGFuZCByZW5ld2VkIC5QUk8gZG9tYWlucyB0byBlbnN1cmUgY29tcGxpYW5jZSB3aXRoIGFsbCB0ZXJtcyBhbmQgY29uZGl0aW9ucy4gCllvdSB3aWxsIGJlIHJlcXVpcmVkIHRvIHByb3ZpZGUgYWRkaXRpb25hbCBpbmZvcm1hdGlvbiB0byB0aGUgcmVnaXN0cnkgaW4gb3JkZXIgdG8gYWN0aXZhdGUgb3IgcmV0YWluIHlvdXIgZG9tYWluLiAgCgpGYWlsdXJlIHRvIHByb3ZpZGUgY3VycmVudCwgYWNjdXJhdGUgaWRlbnRpZmljYXRpb24sIGNvbnRhY3QsIHByb2Zlc3Npb24gc3BlY2lmaWMgYW5kIG90aGVyIGluZm9ybWF0aW9uIHJlcXVpcmVkIGFzIHBhcnQgb2YgdGhlIHJlZ2lzdHJhdGlvbiAKYW5kIHVzYWdlIHByb2Nlc3MgY2FuIHJlc3VsdCBpbiB0aGUgZG9tYWluIGJlaW5nIHBsYWNlZCBvbiBhIHBlcm1hbmVudCBTZXJ2ZXJIb2xkIHdpdGhvdXQgcmVmdW5kLgoKWW91ciBwcm9mZXNzaW9uIGlzOgoiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('med.pro', 'YToxOntzOjE0OiJwcm9fcHJvZmVzc2lvbiI7YTo0OntzOjI6IklEIjtzOjM6IjE4MyI7czoxMToiZGVzY3JpcHRpb24iO3M6NDg2OiJSZWdpc3RyeVBybyBtb25pdG9ycyBhbGwgbmV3IGFuZCByZW5ld2VkIC5QUk8gZG9tYWlucyB0byBlbnN1cmUgY29tcGxpYW5jZSB3aXRoIGFsbCB0ZXJtcyBhbmQgY29uZGl0aW9ucy4gCllvdSB3aWxsIGJlIHJlcXVpcmVkIHRvIHByb3ZpZGUgYWRkaXRpb25hbCBpbmZvcm1hdGlvbiB0byB0aGUgcmVnaXN0cnkgaW4gb3JkZXIgdG8gYWN0aXZhdGUgb3IgcmV0YWluIHlvdXIgZG9tYWluLiAgCgpGYWlsdXJlIHRvIHByb3ZpZGUgY3VycmVudCwgYWNjdXJhdGUgaWRlbnRpZmljYXRpb24sIGNvbnRhY3QsIHByb2Zlc3Npb24gc3BlY2lmaWMgYW5kIG90aGVyIGluZm9ybWF0aW9uIHJlcXVpcmVkIGFzIHBhcnQgb2YgdGhlIHJlZ2lzdHJhdGlvbiAKYW5kIHVzYWdlIHByb2Nlc3MgY2FuIHJlc3VsdCBpbiB0aGUgZG9tYWluIGJlaW5nIHBsYWNlZCBvbiBhIHBlcm1hbmVudCBTZXJ2ZXJIb2xkIHdpdGhvdXQgcmVmdW5kLgoKWW91ciBwcm9mZXNzaW9uIGlzOgoiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('cpa.pro', 'YToxOntzOjE0OiJwcm9fcHJvZmVzc2lvbiI7YTo0OntzOjI6IklEIjtzOjM6IjE4NCI7czoxMToiZGVzY3JpcHRpb24iO3M6NDg2OiJSZWdpc3RyeVBybyBtb25pdG9ycyBhbGwgbmV3IGFuZCByZW5ld2VkIC5QUk8gZG9tYWlucyB0byBlbnN1cmUgY29tcGxpYW5jZSB3aXRoIGFsbCB0ZXJtcyBhbmQgY29uZGl0aW9ucy4gCllvdSB3aWxsIGJlIHJlcXVpcmVkIHRvIHByb3ZpZGUgYWRkaXRpb25hbCBpbmZvcm1hdGlvbiB0byB0aGUgcmVnaXN0cnkgaW4gb3JkZXIgdG8gYWN0aXZhdGUgb3IgcmV0YWluIHlvdXIgZG9tYWluLiAgCgpGYWlsdXJlIHRvIHByb3ZpZGUgY3VycmVudCwgYWNjdXJhdGUgaWRlbnRpZmljYXRpb24sIGNvbnRhY3QsIHByb2Zlc3Npb24gc3BlY2lmaWMgYW5kIG90aGVyIGluZm9ybWF0aW9uIHJlcXVpcmVkIGFzIHBhcnQgb2YgdGhlIHJlZ2lzdHJhdGlvbiAKYW5kIHVzYWdlIHByb2Nlc3MgY2FuIHJlc3VsdCBpbiB0aGUgZG9tYWluIGJlaW5nIHBsYWNlZCBvbiBhIHBlcm1hbmVudCBTZXJ2ZXJIb2xkIHdpdGhvdXQgcmVmdW5kLgoKWW91ciBwcm9mZXNzaW9uIGlzOgoiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ==');
INSERT INTO `tld_extra_attributes` VALUES
('me.uk', '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'),
('eu', 'YToxOntzOjE0OiJldV93aG9pc3BvbGljeSI7YTo0OntzOjI6IklEIjtzOjI6IjQ1IjtzOjExOiJkZXNjcmlwdGlvbiI7czoyOToiUmVnaXN0cnkgRGF0YSBUcmFuc2ZlciBQb2xpY3kiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjE6e3M6NzoiSSBBR1JFRSI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czo0NTg6IkkgaGVyZWJ5IGFncmVlIHRoYXQgdGhlIFJlZ2lzdHJ5IGlzIGVudGl0bGVkIHRvIHRyYW5zZmVyIHRoZSBkYXRhIGNvbnRhaW5lZCBpbiB0aGlzIGFwcGxpY2F0aW9uIHRvIHRoaXJkIHBhcnRpZXMgKGkpIGlmIG9yZGVyZWQgdG8gZG8gc28gYnkgYSBwdWJsaWMgYXV0aG9yaXR5LCBjYXJyeWluZyBvdXQgaXRzIGxlZ2l0aW1hdGUgdGFza3M7IGFuZCAoaWkpIHVwb24gZGVtYW5kIG9mIGFuIEFEUiBQcm92aWRlciBhcyBtZW50aW9uZWQgaW4gc2VjdGlvbiAxNiBvZiB0aGUgVGVybXMgYW5kIENvbmRpdGlvbnMgd2hpY2ggYXJlIHB1Ymxpc2hlZCBhdCB3d3cuZXVyaWQuZXU7IGFuZCAoaWlpKSBhcyBwcm92aWRlZCBpbiBTZWN0aW9uIDIgKFdIT0lTIGxvb2stdXAgZmFjaWxpdHkpIG9mIHRoZSAuZXUgRG9tYWluIE5hbWUgV0hPSVMgUG9saWN5IHdoaWNoIGlzIHB1Ymxpc2hlZCBhdCB3d3cuZXVyaWQuZXUuIjtzOjU6InZhbHVlIjtzOjc6IkkgQUdSRUUiO319fX0='),
('it', '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'),
('pro', 'YToxOntzOjE0OiJwcm9fcHJvZmVzc2lvbiI7YTozOntzOjI6IklEIjtzOjM6IjE5MCI7czoxMToiZGVzY3JpcHRpb24iO3M6NjQ6IkluZGljYXRlZCBwcm9mZXNzaW9uYWwgYXNzb2NpYXRpb24gcmVjb2duaXplZCBieSBnb3Zlcm5tZW50IGJvZHkiO3M6Nzoib3B0aW9ucyI7YTowOnt9fX0='),
('aaa.pro', 'YToxOntzOjE0OiJwcm9fcHJvZmVzc2lvbiI7YTo0OntzOjI6IklEIjtzOjM6IjE4NSI7czoxMToiZGVzY3JpcHRpb24iO3M6NDg2OiJSZWdpc3RyeVBybyBtb25pdG9ycyBhbGwgbmV3IGFuZCByZW5ld2VkIC5QUk8gZG9tYWlucyB0byBlbnN1cmUgY29tcGxpYW5jZSB3aXRoIGFsbCB0ZXJtcyBhbmQgY29uZGl0aW9ucy4gCllvdSB3aWxsIGJlIHJlcXVpcmVkIHRvIHByb3ZpZGUgYWRkaXRpb25hbCBpbmZvcm1hdGlvbiB0byB0aGUgcmVnaXN0cnkgaW4gb3JkZXIgdG8gYWN0aXZhdGUgb3IgcmV0YWluIHlvdXIgZG9tYWluLiAgCgpGYWlsdXJlIHRvIHByb3ZpZGUgY3VycmVudCwgYWNjdXJhdGUgaWRlbnRpZmljYXRpb24sIGNvbnRhY3QsIHByb2Zlc3Npb24gc3BlY2lmaWMgYW5kIG90aGVyIGluZm9ybWF0aW9uIHJlcXVpcmVkIGFzIHBhcnQgb2YgdGhlIHJlZ2lzdHJhdGlvbiAKYW5kIHVzYWdlIHByb2Nlc3MgY2FuIHJlc3VsdCBpbiB0aGUgZG9tYWluIGJlaW5nIHBsYWNlZCBvbiBhIHBlcm1hbmVudCBTZXJ2ZXJIb2xkIHdpdGhvdXQgcmVmdW5kLgoKWW91ciBwcm9mZXNzaW9uIGlzOgoiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('aca.pro', 'YToxOntzOjE0OiJwcm9fcHJvZmVzc2lvbiI7YTo0OntzOjI6IklEIjtzOjM6IjE4NiI7czoxMToiZGVzY3JpcHRpb24iO3M6NDg2OiJSZWdpc3RyeVBybyBtb25pdG9ycyBhbGwgbmV3IGFuZCByZW5ld2VkIC5QUk8gZG9tYWlucyB0byBlbnN1cmUgY29tcGxpYW5jZSB3aXRoIGFsbCB0ZXJtcyBhbmQgY29uZGl0aW9ucy4gCllvdSB3aWxsIGJlIHJlcXVpcmVkIHRvIHByb3ZpZGUgYWRkaXRpb25hbCBpbmZvcm1hdGlvbiB0byB0aGUgcmVnaXN0cnkgaW4gb3JkZXIgdG8gYWN0aXZhdGUgb3IgcmV0YWluIHlvdXIgZG9tYWluLiAgCgpGYWlsdXJlIHRvIHByb3ZpZGUgY3VycmVudCwgYWNjdXJhdGUgaWRlbnRpZmljYXRpb24sIGNvbnRhY3QsIHByb2Zlc3Npb24gc3BlY2lmaWMgYW5kIG90aGVyIGluZm9ybWF0aW9uIHJlcXVpcmVkIGFzIHBhcnQgb2YgdGhlIHJlZ2lzdHJhdGlvbiAKYW5kIHVzYWdlIHByb2Nlc3MgY2FuIHJlc3VsdCBpbiB0aGUgZG9tYWluIGJlaW5nIHBsYWNlZCBvbiBhIHBlcm1hbmVudCBTZXJ2ZXJIb2xkIHdpdGhvdXQgcmVmdW5kLgoKWW91ciBwcm9mZXNzaW9uIGlzOgoiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('acct.pro', 'YToxOntzOjE0OiJwcm9fcHJvZmVzc2lvbiI7YTo0OntzOjI6IklEIjtzOjM6IjE4NyI7czoxMToiZGVzY3JpcHRpb24iO3M6NDg2OiJSZWdpc3RyeVBybyBtb25pdG9ycyBhbGwgbmV3IGFuZCByZW5ld2VkIC5QUk8gZG9tYWlucyB0byBlbnN1cmUgY29tcGxpYW5jZSB3aXRoIGFsbCB0ZXJtcyBhbmQgY29uZGl0aW9ucy4gCllvdSB3aWxsIGJlIHJlcXVpcmVkIHRvIHByb3ZpZGUgYWRkaXRpb25hbCBpbmZvcm1hdGlvbiB0byB0aGUgcmVnaXN0cnkgaW4gb3JkZXIgdG8gYWN0aXZhdGUgb3IgcmV0YWluIHlvdXIgZG9tYWluLiAgCgpGYWlsdXJlIHRvIHByb3ZpZGUgY3VycmVudCwgYWNjdXJhdGUgaWRlbnRpZmljYXRpb24sIGNvbnRhY3QsIHByb2Zlc3Npb24gc3BlY2lmaWMgYW5kIG90aGVyIGluZm9ybWF0aW9uIHJlcXVpcmVkIGFzIHBhcnQgb2YgdGhlIHJlZ2lzdHJhdGlvbiAKYW5kIHVzYWdlIHByb2Nlc3MgY2FuIHJlc3VsdCBpbiB0aGUgZG9tYWluIGJlaW5nIHBsYWNlZCBvbiBhIHBlcm1hbmVudCBTZXJ2ZXJIb2xkIHdpdGhvdXQgcmVmdW5kLgoKWW91ciBwcm9mZXNzaW9uIGlzOgoiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('eng.pro', 'YToxOntzOjE0OiJwcm9fcHJvZmVzc2lvbiI7YTo0OntzOjI6IklEIjtzOjM6IjE4OCI7czoxMToiZGVzY3JpcHRpb24iO3M6NDg2OiJSZWdpc3RyeVBybyBtb25pdG9ycyBhbGwgbmV3IGFuZCByZW5ld2VkIC5QUk8gZG9tYWlucyB0byBlbnN1cmUgY29tcGxpYW5jZSB3aXRoIGFsbCB0ZXJtcyBhbmQgY29uZGl0aW9ucy4gCllvdSB3aWxsIGJlIHJlcXVpcmVkIHRvIHByb3ZpZGUgYWRkaXRpb25hbCBpbmZvcm1hdGlvbiB0byB0aGUgcmVnaXN0cnkgaW4gb3JkZXIgdG8gYWN0aXZhdGUgb3IgcmV0YWluIHlvdXIgZG9tYWluLiAgCgpGYWlsdXJlIHRvIHByb3ZpZGUgY3VycmVudCwgYWNjdXJhdGUgaWRlbnRpZmljYXRpb24sIGNvbnRhY3QsIHByb2Zlc3Npb24gc3BlY2lmaWMgYW5kIG90aGVyIGluZm9ybWF0aW9uIHJlcXVpcmVkIGFzIHBhcnQgb2YgdGhlIHJlZ2lzdHJhdGlvbiAKYW5kIHVzYWdlIHByb2Nlc3MgY2FuIHJlc3VsdCBpbiB0aGUgZG9tYWluIGJlaW5nIHBsYWNlZCBvbiBhIHBlcm1hbmVudCBTZXJ2ZXJIb2xkIHdpdGhvdXQgcmVmdW5kLgoKWW91ciBwcm9mZXNzaW9uIGlzOgoiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('avocat.pro', 'YToxOntzOjE0OiJwcm9fcHJvZmVzc2lvbiI7YTo0OntzOjI6IklEIjtzOjM6IjE4OSI7czoxMToiZGVzY3JpcHRpb24iO3M6NDg2OiJSZWdpc3RyeVBybyBtb25pdG9ycyBhbGwgbmV3IGFuZCByZW5ld2VkIC5QUk8gZG9tYWlucyB0byBlbnN1cmUgY29tcGxpYW5jZSB3aXRoIGFsbCB0ZXJtcyBhbmQgY29uZGl0aW9ucy4gCllvdSB3aWxsIGJlIHJlcXVpcmVkIHRvIHByb3ZpZGUgYWRkaXRpb25hbCBpbmZvcm1hdGlvbiB0byB0aGUgcmVnaXN0cnkgaW4gb3JkZXIgdG8gYWN0aXZhdGUgb3IgcmV0YWluIHlvdXIgZG9tYWluLiAgCgpGYWlsdXJlIHRvIHByb3ZpZGUgY3VycmVudCwgYWNjdXJhdGUgaWRlbnRpZmljYXRpb24sIGNvbnRhY3QsIHByb2Zlc3Npb24gc3BlY2lmaWMgYW5kIG90aGVyIGluZm9ybWF0aW9uIHJlcXVpcmVkIGFzIHBhcnQgb2YgdGhlIHJlZ2lzdHJhdGlvbiAKYW5kIHVzYWdlIHByb2Nlc3MgY2FuIHJlc3VsdCBpbiB0aGUgZG9tYWluIGJlaW5nIHBsYWNlZCBvbiBhIHBlcm1hbmVudCBTZXJ2ZXJIb2xkIHdpdGhvdXQgcmVmdW5kLgoKWW91ciBwcm9mZXNzaW9uIGlzOgoiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('tel', 'YTo0OntzOjEzOiJ0ZWxfd2hvaXN0eXBlIjthOjM6e3M6MjoiSUQiO3M6MzoiMTQ0IjtzOjExOiJkZXNjcmlwdGlvbiI7czoyMzoiTmF0dXJhbCBvciBMZWdhbCBQZXJzb24iO3M6Nzoib3B0aW9ucyI7YToyOntzOjE0OiJOYXR1cmFsIFBlcnNvbiI7YTozOntzOjExOiJkZXNjcmlwdGlvbiI7czoxNDoiTmF0dXJhbCBQZXJzb24iO3M6NToidmFsdWUiO3M6MTQ6Im5hdHVyYWxfcGVyc29uIjtzOjg6InJlcXVpcmVzIjthOjE6e2k6MDtzOjM6IjE0NSI7fX1zOjEyOiJMZWdhbCBQZXJzb24iO2E6Mjp7czoxMToiZGVzY3JpcHRpb24iO3M6MTI6IkxlZ2FsIFBlcnNvbiI7czo1OiJ2YWx1ZSI7czoxMjoibGVnYWxfcGVyc29uIjt9fX1zOjEyOiJ0ZWxfdXNlcm5hbWUiO2E6Mzp7czoyOiJJRCI7czozOiIxNDciO3M6MTE6ImRlc2NyaXB0aW9uIjtzOjg6IlVzZXJuYW1lIjtzOjc6Im9wdGlvbnMiO2E6MDp7fX1zOjEyOiJ0ZWxfcGFzc3dvcmQiO2E6Mzp7czoyOiJJRCI7czozOiIxNDgiO3M6MTE6ImRlc2NyaXB0aW9uIjtzOjg6IlBhc3N3b3JkIjtzOjc6Im9wdGlvbnMiO2E6MDp7fX1zOjE2OiJ0ZWxfZW1haWxhZGRyZXNzIjthOjM6e3M6MjoiSUQiO3M6MzoiMTUwIjtzOjExOiJkZXNjcmlwdGlvbiI7czoxMzoiRW1haWwgQWRkcmVzcyI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('bar.pro', 'YToxOntzOjE0OiJwcm9fcHJvZmVzc2lvbiI7YTo0OntzOjI6IklEIjtzOjM6IjE5MCI7czoxMToiZGVzY3JpcHRpb24iO3M6NDg2OiJSZWdpc3RyeVBybyBtb25pdG9ycyBhbGwgbmV3IGFuZCByZW5ld2VkIC5QUk8gZG9tYWlucyB0byBlbnN1cmUgY29tcGxpYW5jZSB3aXRoIGFsbCB0ZXJtcyBhbmQgY29uZGl0aW9ucy4gCllvdSB3aWxsIGJlIHJlcXVpcmVkIHRvIHByb3ZpZGUgYWRkaXRpb25hbCBpbmZvcm1hdGlvbiB0byB0aGUgcmVnaXN0cnkgaW4gb3JkZXIgdG8gYWN0aXZhdGUgb3IgcmV0YWluIHlvdXIgZG9tYWluLiAgCgpGYWlsdXJlIHRvIHByb3ZpZGUgY3VycmVudCwgYWNjdXJhdGUgaWRlbnRpZmljYXRpb24sIGNvbnRhY3QsIHByb2Zlc3Npb24gc3BlY2lmaWMgYW5kIG90aGVyIGluZm9ybWF0aW9uIHJlcXVpcmVkIGFzIHBhcnQgb2YgdGhlIHJlZ2lzdHJhdGlvbiAKYW5kIHVzYWdlIHByb2Nlc3MgY2FuIHJlc3VsdCBpbiB0aGUgZG9tYWluIGJlaW5nIHBsYWNlZCBvbiBhIHBlcm1hbmVudCBTZXJ2ZXJIb2xkIHdpdGhvdXQgcmVmdW5kLgoKWW91ciBwcm9mZXNzaW9uIGlzOgoiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('jur.pro', 'YToxOntzOjE0OiJwcm9fcHJvZmVzc2lvbiI7YTo0OntzOjI6IklEIjtzOjM6IjE5MSI7czoxMToiZGVzY3JpcHRpb24iO3M6NDg2OiJSZWdpc3RyeVBybyBtb25pdG9ycyBhbGwgbmV3IGFuZCByZW5ld2VkIC5QUk8gZG9tYWlucyB0byBlbnN1cmUgY29tcGxpYW5jZSB3aXRoIGFsbCB0ZXJtcyBhbmQgY29uZGl0aW9ucy4gCllvdSB3aWxsIGJlIHJlcXVpcmVkIHRvIHByb3ZpZGUgYWRkaXRpb25hbCBpbmZvcm1hdGlvbiB0byB0aGUgcmVnaXN0cnkgaW4gb3JkZXIgdG8gYWN0aXZhdGUgb3IgcmV0YWluIHlvdXIgZG9tYWluLiAgCgpGYWlsdXJlIHRvIHByb3ZpZGUgY3VycmVudCwgYWNjdXJhdGUgaWRlbnRpZmljYXRpb24sIGNvbnRhY3QsIHByb2Zlc3Npb24gc3BlY2lmaWMgYW5kIG90aGVyIGluZm9ybWF0aW9uIHJlcXVpcmVkIGFzIHBhcnQgb2YgdGhlIHJlZ2lzdHJhdGlvbiAKYW5kIHVzYWdlIHByb2Nlc3MgY2FuIHJlc3VsdCBpbiB0aGUgZG9tYWluIGJlaW5nIHBsYWNlZCBvbiBhIHBlcm1hbmVudCBTZXJ2ZXJIb2xkIHdpdGhvdXQgcmVmdW5kLgoKWW91ciBwcm9mZXNzaW9uIGlzOgoiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('recht.pro', 'YToxOntzOjE0OiJwcm9fcHJvZmVzc2lvbiI7YTo0OntzOjI6IklEIjtzOjM6IjE5MiI7czoxMToiZGVzY3JpcHRpb24iO3M6NDg2OiJSZWdpc3RyeVBybyBtb25pdG9ycyBhbGwgbmV3IGFuZCByZW5ld2VkIC5QUk8gZG9tYWlucyB0byBlbnN1cmUgY29tcGxpYW5jZSB3aXRoIGFsbCB0ZXJtcyBhbmQgY29uZGl0aW9ucy4gCllvdSB3aWxsIGJlIHJlcXVpcmVkIHRvIHByb3ZpZGUgYWRkaXRpb25hbCBpbmZvcm1hdGlvbiB0byB0aGUgcmVnaXN0cnkgaW4gb3JkZXIgdG8gYWN0aXZhdGUgb3IgcmV0YWluIHlvdXIgZG9tYWluLiAgCgpGYWlsdXJlIHRvIHByb3ZpZGUgY3VycmVudCwgYWNjdXJhdGUgaWRlbnRpZmljYXRpb24sIGNvbnRhY3QsIHByb2Zlc3Npb24gc3BlY2lmaWMgYW5kIG90aGVyIGluZm9ybWF0aW9uIHJlcXVpcmVkIGFzIHBhcnQgb2YgdGhlIHJlZ2lzdHJhdGlvbiAKYW5kIHVzYWdlIHByb2Nlc3MgY2FuIHJlc3VsdCBpbiB0aGUgZG9tYWluIGJlaW5nIHBsYWNlZCBvbiBhIHBlcm1hbmVudCBTZXJ2ZXJIb2xkIHdpdGhvdXQgcmVmdW5kLgoKWW91ciBwcm9mZXNzaW9uIGlzOgoiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('es', 'YTo2OntzOjEyOiJlc19sZWdhbGZvcm0iO2E6NDp7czoyOiJJRCI7czozOiIyNDciO3M6MTE6ImRlc2NyaXB0aW9uIjtzOjE1MToiSSBkZWNsYXJlIHRoYXQgSSBhbSB3b3JraW5nIG9uIGJlaGFsZiBvZiB0aGUgZm9sbG93aW5nIHR5cGUgb2YgZW50aXR5LiBJZiBhIG5vbi1pbmRpdmlkdWFsIHR5cGUgaXMgY2hvc2VuLCBSZWdpc3RyYW50IE9yZ2FuaXphdGlvbiBpcyBhIHJlcXVpcmVkIGZpZWxkLiI7czo4OiJyZXF1aXJlZCI7czoxOiIxIjtzOjc6Im9wdGlvbnMiO2E6Mzc6e3M6MTA6IkluZGl2aWR1YWwiO2E6Mzp7czoxMToiZGVzY3JpcHRpb24iO3M6MTA6IkluZGl2aWR1YWwiO3M6NToidmFsdWUiO3M6MToiMSI7czo4OiJyZXF1aXJlcyI7YToxOntpOjA7czozOiIyNTkiO319czoyMzoiRWNvbm9taWMgSW50ZXJlc3QgR3JvdXAiO2E6Mjp7czoxMToiZGVzY3JpcHRpb24iO3M6MjM6IkVjb25vbWljIEludGVyZXN0IEdyb3VwIjtzOjU6InZhbHVlIjtzOjI6IjM5Ijt9czoxMToiQXNzb2NpYXRpb24iO2E6Mjp7czoxMToiZGVzY3JpcHRpb24iO3M6MTE6IkFzc29jaWF0aW9uIjtzOjU6InZhbHVlIjtzOjI6IjQ3Ijt9czoxODoiU3BvcnRzIEFzc29jaWF0aW9uIjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjE4OiJTcG9ydHMgQXNzb2NpYXRpb24iO3M6NToidmFsdWUiO3M6MzoiNTI1Ijt9czoyNDoiUHJvZmVzc2lvbmFsIEFzc29jaWF0aW9uIjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjI0OiJQcm9mZXNzaW9uYWwgQXNzb2NpYXRpb24iO3M6NToidmFsdWUiO3M6MjoiNjgiO31zOjEyOiJTYXZpbmdzIEJhbmsiO2E6Mjp7czoxMToiZGVzY3JpcHRpb24iO3M6MTI6IlNhdmluZ3MgQmFuayI7czo1OiJ2YWx1ZSI7czozOiIxMjQiO31zOjE4OiJDb21tdW5pdHkgUHJvcGVydHkiO2E6Mjp7czoxMToiZGVzY3JpcHRpb24iO3M6MTg6IkNvbW11bml0eSBQcm9wZXJ0eSI7czo1OiJ2YWx1ZSI7czozOiIxNTAiO31zOjE5OiJDb21tdW5pdHkgb2YgT3duZXJzIjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjE5OiJDb21tdW5pdHkgb2YgT3duZXJzIjtzOjU6InZhbHVlIjtzOjM6IjE1MiI7fXM6MzA6Ik9yZGVyIG9yIFJlbGlnaW91cyBJbnN0aXR1dGlvbiI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czozMDoiT3JkZXIgb3IgUmVsaWdpb3VzIEluc3RpdHV0aW9uIjtzOjU6InZhbHVlIjtzOjM6IjE2NCI7fXM6OToiQ29uc3VsYXRlIjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjk6IkNvbnN1bGF0ZSI7czo1OiJ2YWx1ZSI7czozOiIxODEiO31zOjIyOiJQdWJsaWMgTGF3IEFzc29jaWF0aW9uIjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjIyOiJQdWJsaWMgTGF3IEFzc29jaWF0aW9uIjtzOjU6InZhbHVlIjtzOjM6IjE5NyI7fXM6NzoiRW1iYXNzeSI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czo3OiJFbWJhc3N5IjtzOjU6InZhbHVlIjtzOjM6IjIwMyI7fXM6MTU6IkxvY2FsIEF1dGhvcml0eSI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czoxNToiTG9jYWwgQXV0aG9yaXR5IjtzOjU6InZhbHVlIjtzOjM6IjIyOSI7fXM6MTc6IlNwb3J0cyBGZWRlcmF0aW9uIjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjE3OiJTcG9ydHMgRmVkZXJhdGlvbiI7czo1OiJ2YWx1ZSI7czozOiIyNjkiO31zOjEwOiJGb3VuZGF0aW9uIjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjEwOiJGb3VuZGF0aW9uIjtzOjU6InZhbHVlIjtzOjM6IjI4NiI7fXM6MjQ6Ik11dHVhbCBJbnN1cmFuY2UgQ29tcGFueSI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czoyNDoiTXV0dWFsIEluc3VyYW5jZSBDb21wYW55IjtzOjU6InZhbHVlIjtzOjM6IjM2NSI7fXM6MjQ6IlJlZ2lvbmFsIEdvdmVybm1lbnQgQm9keSI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czoyNDoiUmVnaW9uYWwgR292ZXJubWVudCBCb2R5IjtzOjU6InZhbHVlIjtzOjM6IjQzNCI7fXM6MjM6IkNlbnRyYWwgR292ZXJubWVudCBCb2R5IjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjIzOiJDZW50cmFsIEdvdmVybm1lbnQgQm9keSI7czo1OiJ2YWx1ZSI7czozOiI0MzYiO31zOjE1OiJQb2xpdGljYWwgUGFydHkiO2E6Mjp7czoxMToiZGVzY3JpcHRpb24iO3M6MTU6IlBvbGl0aWNhbCBQYXJ0eSI7czo1OiJ2YWx1ZSI7czozOiI0MzkiO31zOjExOiJUcmFkZSBVbmlvbiI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czoxMToiVHJhZGUgVW5pb24iO3M6NToidmFsdWUiO3M6MzoiNDc2Ijt9czoxNjoiRmFybSBQYXJ0bmVyc2hpcCI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czoxNjoiRmFybSBQYXJ0bmVyc2hpcCI7czo1OiJ2YWx1ZSI7czozOiI1MTAiO31zOjIyOiJQdWJsaWMgTGltaXRlZCBDb21wYW55IjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjIyOiJQdWJsaWMgTGltaXRlZCBDb21wYW55IjtzOjU6InZhbHVlIjtzOjM6IjUyNCI7fXM6MTM6IkNpdmlsIFNvY2lldHkiO2E6Mjp7czoxMToiZGVzY3JpcHRpb24iO3M6MTM6IkNpdmlsIFNvY2lldHkiO3M6NToidmFsdWUiO3M6MzoiNTU0Ijt9czoxOToiR2VuZXJhbCBQYXJ0bmVyc2hpcCI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czoxOToiR2VuZXJhbCBQYXJ0bmVyc2hpcCI7czo1OiJ2YWx1ZSI7czozOiI1NjAiO31zOjMxOiJHZW5lcmFsIGFuZCBMaW1pdGVkIFBhcnRuZXJzaGlwIjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjMxOiJHZW5lcmFsIGFuZCBMaW1pdGVkIFBhcnRuZXJzaGlwIjtzOjU6InZhbHVlIjtzOjM6IjU2MiI7fXM6MTE6IkNvb3BlcmF0aXZlIjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjExOiJDb29wZXJhdGl2ZSI7czo1OiJ2YWx1ZSI7czozOiI1NjYiO31zOjIwOiJXb3JrZXItb3duZWQgQ29tcGFueSI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czoyMDoiV29ya2VyLW93bmVkIENvbXBhbnkiO3M6NToidmFsdWUiO3M6MzoiNjA4Ijt9czoxNToiTGltaXRlZCBDb21wYW55IjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjE1OiJMaW1pdGVkIENvbXBhbnkiO3M6NToidmFsdWUiO3M6MzoiNjEyIjt9czoxNDoiU3BhbmlzaCBPZmZpY2UiO2E6Mjp7czoxMToiZGVzY3JpcHRpb24iO3M6MTQ6IlNwYW5pc2ggT2ZmaWNlIjtzOjU6InZhbHVlIjtzOjM6IjcxMyI7fXM6MzM6IlRlbXBvcmFyeSBBbGxpYW5jZSBvZiBFbnRlcnByaXNlcyI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czozMzoiVGVtcG9yYXJ5IEFsbGlhbmNlIG9mIEVudGVycHJpc2VzIjtzOjU6InZhbHVlIjtzOjM6IjcxNyI7fXM6Mjg6Ildvcmtlci1vd25lZCBMaW1pdGVkIENvbXBhbnkiO2E6Mjp7czoxMToiZGVzY3JpcHRpb24iO3M6Mjg6Ildvcmtlci1vd25lZCBMaW1pdGVkIENvbXBhbnkiO3M6NToidmFsdWUiO3M6MzoiNzQ0Ijt9czoyMjoiUmVnaW9uYWwgUHVibGljIEVudGl0eSI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czoyMjoiUmVnaW9uYWwgUHVibGljIEVudGl0eSI7czo1OiJ2YWx1ZSI7czozOiI3NDUiO31zOjIyOiJOYXRpb25hbCBQdWJsaWMgRW50aXR5IjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjIyOiJOYXRpb25hbCBQdWJsaWMgRW50aXR5IjtzOjU6InZhbHVlIjtzOjM6Ijc0NiI7fXM6MTk6IkxvY2FsIFB1YmxpYyBFbnRpdHkiO2E6Mjp7czoxMToiZGVzY3JpcHRpb24iO3M6MTk6IkxvY2FsIFB1YmxpYyBFbnRpdHkiO3M6NToidmFsdWUiO3M6MzoiNzQ3Ijt9czo2OiJPdGhlcnMiO2E6Mjp7czoxMToiZGVzY3JpcHRpb24iO3M6NjoiT3RoZXJzIjtzOjU6InZhbHVlIjtzOjM6Ijg3NyI7fXM6NDE6IkRlc2lnbmF0aW9uIG9mIE9yaWdpbiBTdXBlcnZpc29yeSBDb3VuY2lsIjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjQxOiJEZXNpZ25hdGlvbiBvZiBPcmlnaW4gU3VwZXJ2aXNvcnkgQ291bmNpbCI7czo1OiJ2YWx1ZSI7czozOiI4NzgiO31zOjI5OiJFbnRpdHkgTWFuYWdpbmcgTmF0dXJhbCBBcmVhcyI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czoyOToiRW50aXR5IE1hbmFnaW5nIE5hdHVyYWwgQXJlYXMiO3M6NToidmFsdWUiO3M6MzoiODc5Ijt9fX1zOjE5OiJlc19yZWdpc3RyYW50aWR0eXBlIjthOjQ6e3M6MjoiSUQiO3M6MzoiMTk3IjtzOjExOiJkZXNjcmlwdGlvbiI7czo3OiJJRCB0eXBlIjtzOjg6InJlcXVpcmVkIjtzOjE6IjEiO3M6Nzoib3B0aW9ucyI7YTozOntzOjEwOiJHZW5lcmljIElEIjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjkwOiJHZW5lcmljIElEIGRvY3VtZW50IHVzZWQgZm9yIHBhc3Nwb3J0cywgY29tcGFueSByZWdpc3RyYXRpb24gbnVtYmVycyBhbmQgZm9yZWlnbiBkb2N1bWVudHMiO3M6NToidmFsdWUiO3M6MToiMCI7fXM6NjoiVkFUIElEIjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjQ2OiJTcGFuaXNoIHBlcnNvbmFsIGFuZCBjb21wYW55IFZBVCBJRCBjYXJkIChOSUYpIjtzOjU6InZhbHVlIjtzOjE6IjEiO31zOjE3OiJSZXNpZGVudCBhbGllbiBJRCI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czozNjoiU3BhbmlzaCByZXNpZGVudCBhbGllbiBJRCBjYXJkIChOSUUpIjtzOjU6InZhbHVlIjtzOjE6IjMiO319fXM6MTU6ImVzX3JlZ2lzdHJhbnRpZCI7YTo0OntzOjI6IklEIjtzOjM6IjE5MyI7czoxMToiZGVzY3JpcHRpb24iO3M6OToiSUQgbnVtYmVyIjtzOjg6InJlcXVpcmVkIjtzOjE6IjEiO3M6Nzoib3B0aW9ucyI7YTowOnt9fXM6MTI6ImVzX2FjY2VwdHRhYyI7YTo0OntzOjI6IklEIjtzOjM6IjI1OSI7czoxMToiZGVzY3JpcHRpb24iO3M6MTk3OiJJIGFjY2VwdCB0aGUgLkVTIHRlcm1zIGFuZCBjb25kaXRpb25zIGxpc3RlZCBhdDogaHR0cHM6Ly93d3cuZG9taW5pb3MuZXMvZG9taW5pb3Mvc2l0ZXMvZG9taW5pb3MvZmlsZXMvQWNlcHRhY2klQzMlQjNuJTIwdCVDMyVBOXJtaW5vcyUyMHklMjBjb25kaWNpb25lc19VRl8xN18wNV8yMDE4JTIwJTI4diUyMDMlMjklMjAlMkIlMjBsb2dvLnBkZiI7czo4OiJyZXF1aXJlZCI7czoxOiIyIjtzOjc6Im9wdGlvbnMiO2E6MTp7czozNToiSSBhZ3JlZSB0byB0aGUgdGVybXMgYW5kIGNvbmRpdGlvbnMiO2E6Mjp7czoxMToiZGVzY3JpcHRpb24iO3M6MzU6IkkgYWdyZWUgdG8gdGhlIHRlcm1zIGFuZCBjb25kaXRpb25zIjtzOjU6InZhbHVlIjtzOjE6IjEiO319fXM6MTA6ImVzX2FkbWluaWQiO2E6NDp7czoyOiJJRCI7czozOiIyNTYiO3M6MTE6ImRlc2NyaXB0aW9uIjtzOjM4MjoiSUQgY2FyZCBvciBwYXNzcG9ydCBudW1iZXIgb2YgdGhlIGFkbWluaXN0cmF0aXZlIGNvbnRhY3QuIFlvdSBtYXkgY3JlYXRlIGNvbnRhY3RzIGZvciBTcGFuaXNoIGNpdGl6ZW5zIHVzaW5nIHRoZWlyIHBhc3Nwb3J0LiAgICBJbiB0aGlzIGNhc2UgeW91IHNob3VsZCBpbmRpY2F0ZSDigJxPdGhlcnPigJ0gYXMgdHlwZSBvZiBJZGVudGlmaWNhdGlvbiBEb2N1bWVudCBhbmQgaW5jbHVkZSB0aGUgcGFzc3BvcnQgbnVtYmVyLiAgICBQbGVhc2UgcmVtZW1iZXIgdGhhdCwgaW4gdGhlIGV2ZW50IHRoYXQgdGhlIFVzZXIgbWF5IHJlcXVlc3QgYSBjaGFuZ2Ugb2YgcmVnaXN0cmFudCwgdGhleSBzaG91bGQgc2lnbiBpdCB3aXRoIHRoZSBjb3B5IG9mIHRoZWlyIHBhc3Nwb3J0LiI7czo4OiJyZXF1aXJlZCI7czoxOiIxIjtzOjc6Im9wdGlvbnMiO2E6MDp7fX1zOjE0OiJlc19hZG1pbmlkdHlwZSI7YTo0OntzOjI6IklEIjtzOjM6IjI1NyI7czoxMToiZGVzY3JpcHRpb24iO3M6MzQ6IklEIHR5cGUgZm9yIEFkbWluaXN0cmF0aXZlIENvbnRhY3QiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjM6e3M6MTA6IkdlbmVyaWMgSUQiO2E6Mjp7czoxMToiZGVzY3JpcHRpb24iO3M6MzQ6Im90aGVyIChmb3IgY29udGFjdHMgb3V0c2lkZSBTcGFpbikiO3M6NToidmFsdWUiO3M6MToiMCI7fXM6MTc6Ik5hdGlvbmFsIElkZW50aXR5IjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjMwOiJETkkvTklGIChmb3Igc3BhbmlzaCBjb250YWN0cykiO3M6NToidmFsdWUiO3M6MToiMSI7fXM6MTc6IlJlc2lkZW50IGFsaWVuIElEIjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjE0MToiTklFIChJRCBudW1iZXIgZm9yIGZvcmVpZ25lcnMgaW4gU3BhaW4sIGNvbXBvc2VkIG9mIGEgbGV0dGVyIGF0IHRoZSBiZWdpbm5pbmcgKHVzdWFsbHkgWCBvciBZKSwgNyBudW1iZXJzIGFuZCBhIGZpbmFsIGxldHRlciwgbm90IGh5cGhlbmF0ZWQpIjtzOjU6InZhbHVlIjtzOjE6IjMiO319fX0='),
('com.es', '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'),
('nom.es', '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');
INSERT INTO `tld_extra_attributes` VALUES
('org.es', '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'),
('au', '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'),
('com.au', 'YToyOntzOjE1OiJhdV9yZWdpc3RyYW50aWQiO2E6NDp7czoyOiJJRCI7czozOiIyMDEiO3M6MTE6ImRlc2NyaXB0aW9uIjtzOjk6IklEIG51bWJlciI7czo4OiJyZXF1aXJlZCI7czoxOiIxIjtzOjc6Im9wdGlvbnMiO2E6MDp7fX1zOjE5OiJhdV9yZWdpc3RyYW50aWR0eXBlIjthOjQ6e3M6MjoiSUQiO3M6MzoiMjA0IjtzOjExOiJkZXNjcmlwdGlvbiI7czo3OiJJRCB0eXBlIjtzOjg6InJlcXVpcmVkIjtzOjE6IjEiO3M6Nzoib3B0aW9ucyI7YTozOntzOjI2OiJBdXN0cmFsaWFuIEJ1c2luZXNzIE51bWJlciI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czoyNjoiQXVzdHJhbGlhbiBCdXNpbmVzcyBOdW1iZXIiO3M6NToidmFsdWUiO3M6MzoiQUJOIjt9czoyNToiQXVzdHJhbGlhbiBDb21wYW55IE51bWJlciI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czoyNToiQXVzdHJhbGlhbiBDb21wYW55IE51bWJlciI7czo1OiJ2YWx1ZSI7czozOiJBQ04iO31zOjE2OiJUcmFkZW1hcmsgTnVtYmVyIjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjE2OiJUcmFkZW1hcmsgTnVtYmVyIjtzOjU6InZhbHVlIjtzOjI6IlRNIjt9fX19'),
('org.au', 'YToyOntzOjE1OiJhdV9yZWdpc3RyYW50aWQiO2E6NDp7czoyOiJJRCI7czozOiIyMDMiO3M6MTE6ImRlc2NyaXB0aW9uIjtzOjk6IklEIG51bWJlciI7czo4OiJyZXF1aXJlZCI7czoxOiIxIjtzOjc6Im9wdGlvbnMiO2E6MDp7fX1zOjE5OiJhdV9yZWdpc3RyYW50aWR0eXBlIjthOjQ6e3M6MjoiSUQiO3M6MzoiMjA2IjtzOjExOiJkZXNjcmlwdGlvbiI7czo3OiJJRCB0eXBlIjtzOjg6InJlcXVpcmVkIjtzOjE6IjEiO3M6Nzoib3B0aW9ucyI7YTozOntzOjI2OiJBdXN0cmFsaWFuIEJ1c2luZXNzIE51bWJlciI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czoyNjoiQXVzdHJhbGlhbiBCdXNpbmVzcyBOdW1iZXIiO3M6NToidmFsdWUiO3M6MzoiQUJOIjt9czoyNToiQXVzdHJhbGlhbiBDb21wYW55IE51bWJlciI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czoyNToiQXVzdHJhbGlhbiBDb21wYW55IE51bWJlciI7czo1OiJ2YWx1ZSI7czozOiJBQ04iO31zOjE2OiJUcmFkZW1hcmsgTnVtYmVyIjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjE2OiJUcmFkZW1hcmsgTnVtYmVyIjtzOjU6InZhbHVlIjtzOjI6IlRNIjt9fX19'),
('net.au', 'YToyOntzOjE1OiJhdV9yZWdpc3RyYW50aWQiO2E6NDp7czoyOiJJRCI7czozOiIyMDIiO3M6MTE6ImRlc2NyaXB0aW9uIjtzOjk6IklEIG51bWJlciI7czo4OiJyZXF1aXJlZCI7czoxOiIxIjtzOjc6Im9wdGlvbnMiO2E6MDp7fX1zOjE5OiJhdV9yZWdpc3RyYW50aWR0eXBlIjthOjQ6e3M6MjoiSUQiO3M6MzoiMjA1IjtzOjExOiJkZXNjcmlwdGlvbiI7czo3OiJJRCB0eXBlIjtzOjg6InJlcXVpcmVkIjtzOjE6IjEiO3M6Nzoib3B0aW9ucyI7YTozOntzOjI2OiJBdXN0cmFsaWFuIEJ1c2luZXNzIE51bWJlciI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czoyNjoiQXVzdHJhbGlhbiBCdXNpbmVzcyBOdW1iZXIiO3M6NToidmFsdWUiO3M6MzoiQUJOIjt9czoyNToiQXVzdHJhbGlhbiBDb21wYW55IE51bWJlciI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czoyNToiQXVzdHJhbGlhbiBDb21wYW55IE51bWJlciI7czo1OiJ2YWx1ZSI7czozOiJBQ04iO31zOjE2OiJUcmFkZW1hcmsgTnVtYmVyIjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjE2OiJUcmFkZW1hcmsgTnVtYmVyIjtzOjU6InZhbHVlIjtzOjI6IlRNIjt9fX19'),
('sg', 'YTo0OntzOjEyOiJzZ19sZWdhbHR5cGUiO2E6NDp7czoyOiJJRCI7czozOiIzMTMiO3M6MTE6ImRlc2NyaXB0aW9uIjtzOjEwMDoiVHlwZSBvZiBSZWdpc3RyYW50IEVudGl0eSwgaWYgT3JnYW5pemF0aW9uIGlzIHNlbGVjdGVkLCBhIHJlZ2lzdHJhbnQgb3JnYW5pemF0aW9uIG11c3QgYmUgc3VwcGxpZWQgLiI7czo4OiJyZXF1aXJlZCI7czoxOiIxIjtzOjc6Im9wdGlvbnMiO2E6Mjp7czozNToiRW50aXR5IGlzIGEgcmVnaXN0ZXJlZCBvcmdhbml6YXRpb24iO2E6Mzp7czoxMToiZGVzY3JpcHRpb24iO3M6MzU6IkVudGl0eSBpcyBhIHJlZ2lzdGVyZWQgb3JnYW5pemF0aW9uIjtzOjU6InZhbHVlIjtzOjEyOiJvcmdhbml6YXRpb24iO3M6ODoicmVxdWlyZXMiO2E6MTp7aTowO3M6MzoiMjExIjt9fXM6MjM6IkVudGl0eSBpcyBhbiBpbmRpdmlkdWFsIjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjIzOiJFbnRpdHkgaXMgYW4gaW5kaXZpZHVhbCI7czo1OiJ2YWx1ZSI7czoxMDoiSW5kaXZpZHVhbCI7fX19czo4OiJzZ19yY2JpZCI7YTo0OntzOjI6IklEIjtzOjM6IjIxMSI7czoxMToiZGVzY3JpcHRpb24iO3M6MTIyOiJGb3IgaW5kaXZpZHVhbDogVGhlIGNvcnJlc3BvbmRpbmcgSUQtQ2FyZC9QYXNzcG9ydApGb3Igb3JnYW5pemF0aW9uOiBUaGUgY29ycmVzcG9uZGluZyBjb21wYW55IHJlZ2lzdHJhdGlvbiBvciBWQVQtbnVtYmVyICI7czo4OiJyZXF1aXJlZCI7czoxOiIyIjtzOjc6Im9wdGlvbnMiO2E6MDp7fX1zOjk6InNnX2xvY2FsZSI7YTo0OntzOjI6IklEIjtzOjM6IjMxNCI7czoxMToiZGVzY3JpcHRpb24iO3M6Mjk6IkxvY2F0aW9uIG9mIFJlZ2lzdHJhbnQgRW50aXR5IjtzOjg6InJlcXVpcmVkIjtzOjE6IjIiO3M6Nzoib3B0aW9ucyI7YToyOntzOjM4OiJSZWdpc3RyYW50IGlzIGxvY2F0ZWQgd2l0aGluIFNpbmdhcG9yZSI7YTozOntzOjExOiJkZXNjcmlwdGlvbiI7czozODoiUmVnaXN0cmFudCBpcyBsb2NhdGVkIHdpdGhpbiBTaW5nYXBvcmUiO3M6NToidmFsdWUiO3M6MjoiU0ciO3M6ODoicmVxdWlyZXMiO2E6MTp7aTowO3M6MzoiMjMxIjt9fXM6Mzk6IlJlZ2lzdHJhbnQgaXMgbG9jYXRlZCBPVVRTSURFIFNpbmdhcG9yZSI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czozOToiUmVnaXN0cmFudCBpcyBsb2NhdGVkIE9VVFNJREUgU2luZ2Fwb3JlIjtzOjU6InZhbHVlIjtzOjU6Ik5PTlNHIjt9fX1zOjEwOiJzZ19hZG1pbmlkIjthOjQ6e3M6MjoiSUQiO3M6MzoiMjMxIjtzOjExOiJkZXNjcmlwdGlvbiI7czoxMzI6IlRoZSBjb3JyZXNwb25kaW5nIElEIENhcmQgb3IgUGFzc3BvcnQgb2YgdGhlIEFkbWluaXN0cmF0aXZlIGNvbnRhY3QuIFJlcXVpcmVkIGlmIHRoZSBSZWdpc3RyYW50IG9yIFRlY2huaWNhbCBDb250YWN0IGlzIGluIFNpbmdhcG9yZSI7czo4OiJyZXF1aXJlZCI7czoxOiIyIjtzOjc6Im9wdGlvbnMiO2E6MDp7fX19'),
('com.sg', 'YTo0OntzOjEyOiJzZ19sZWdhbHR5cGUiO2E6NDp7czoyOiJJRCI7czozOiIzMTEiO3M6MTE6ImRlc2NyaXB0aW9uIjtzOjEwMDoiVHlwZSBvZiBSZWdpc3RyYW50IEVudGl0eSwgaWYgT3JnYW5pemF0aW9uIGlzIHNlbGVjdGVkLCBhIHJlZ2lzdHJhbnQgb3JnYW5pemF0aW9uIG11c3QgYmUgc3VwcGxpZWQgLiI7czo4OiJyZXF1aXJlZCI7czoxOiIxIjtzOjc6Im9wdGlvbnMiO2E6Mjp7czozNToiRW50aXR5IGlzIGEgcmVnaXN0ZXJlZCBvcmdhbml6YXRpb24iO2E6Mzp7czoxMToiZGVzY3JpcHRpb24iO3M6MzU6IkVudGl0eSBpcyBhIHJlZ2lzdGVyZWQgb3JnYW5pemF0aW9uIjtzOjU6InZhbHVlIjtzOjEyOiJvcmdhbml6YXRpb24iO3M6ODoicmVxdWlyZXMiO2E6MTp7aTowO3M6MzoiMjExIjt9fXM6MjM6IkVudGl0eSBpcyBhbiBpbmRpdmlkdWFsIjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjIzOiJFbnRpdHkgaXMgYW4gaW5kaXZpZHVhbCI7czo1OiJ2YWx1ZSI7czoxMDoiSW5kaXZpZHVhbCI7fX19czo4OiJzZ19yY2JpZCI7YTo0OntzOjI6IklEIjtzOjM6IjIxMiI7czoxMToiZGVzY3JpcHRpb24iO3M6MTIyOiJGb3IgaW5kaXZpZHVhbDogVGhlIGNvcnJlc3BvbmRpbmcgSUQtQ2FyZC9QYXNzcG9ydApGb3Igb3JnYW5pemF0aW9uOiBUaGUgY29ycmVzcG9uZGluZyBjb21wYW55IHJlZ2lzdHJhdGlvbiBvciBWQVQtbnVtYmVyICI7czo4OiJyZXF1aXJlZCI7czoxOiIyIjtzOjc6Im9wdGlvbnMiO2E6MDp7fX1zOjk6InNnX2xvY2FsZSI7YTo0OntzOjI6IklEIjtzOjM6IjMxMiI7czoxMToiZGVzY3JpcHRpb24iO3M6Mjk6IkxvY2F0aW9uIG9mIFJlZ2lzdHJhbnQgRW50aXR5IjtzOjg6InJlcXVpcmVkIjtzOjE6IjIiO3M6Nzoib3B0aW9ucyI7YToyOntzOjM4OiJSZWdpc3RyYW50IGlzIGxvY2F0ZWQgd2l0aGluIFNpbmdhcG9yZSI7YTozOntzOjExOiJkZXNjcmlwdGlvbiI7czozODoiUmVnaXN0cmFudCBpcyBsb2NhdGVkIHdpdGhpbiBTaW5nYXBvcmUiO3M6NToidmFsdWUiO3M6MjoiU0ciO3M6ODoicmVxdWlyZXMiO2E6MTp7aTowO3M6MzoiMjMxIjt9fXM6Mzk6IlJlZ2lzdHJhbnQgaXMgbG9jYXRlZCBPVVRTSURFIFNpbmdhcG9yZSI7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czozOToiUmVnaXN0cmFudCBpcyBsb2NhdGVkIE9VVFNJREUgU2luZ2Fwb3JlIjtzOjU6InZhbHVlIjtzOjU6Ik5PTlNHIjt9fX1zOjEwOiJzZ19hZG1pbmlkIjthOjQ6e3M6MjoiSUQiO3M6MzoiMjMwIjtzOjExOiJkZXNjcmlwdGlvbiI7czoxMzI6IlRoZSBjb3JyZXNwb25kaW5nIElEIENhcmQgb3IgUGFzc3BvcnQgb2YgdGhlIEFkbWluaXN0cmF0aXZlIGNvbnRhY3QuIFJlcXVpcmVkIGlmIHRoZSBSZWdpc3RyYW50IG9yIFRlY2huaWNhbCBDb250YWN0IGlzIGluIFNpbmdhcG9yZSI7czo4OiJyZXF1aXJlZCI7czoxOiIyIjtzOjc6Im9wdGlvbnMiO2E6MDp7fX19'),
('fr', 'YToxOntzOjEyOiJmcl9sZWdhbHR5cGUiO2E6NDp7czoyOiJJRCI7czozOiIyMTMiO3M6MTE6ImRlc2NyaXB0aW9uIjtzOjc2OiJEZXBlbmRpbmcgb24gdGhlIHR5cGUgb2YgcmVnaXN0cmFudCwgZGlmZmVyZW50IGV4dGVuc2lvbnMgbXVzdCBiZSBwcm92aWRlZC4gIjtzOjg6InJlcXVpcmVkIjtzOjE6IjEiO3M6Nzoib3B0aW9ucyI7YToyOntzOjc6IkNvbXBhbnkiO2E6Mjp7czoxMToiZGVzY3JpcHRpb24iO3M6NzM6IkNvbXBhbmllcyBoYXZpbmcgdGhlaXIgaGVhZCBvZmZpY2UgaW4gdGhlIHRlcnJpdG9yeSBvZiB0aGUgRXVyb3BlYW4gVW5pb24iO3M6NToidmFsdWUiO3M6NzoiQ29tcGFueSI7fXM6MTA6IkluZGl2aWR1YWwiO2E6Mjp7czoxMToiZGVzY3JpcHRpb24iO3M6NDU6IkluZGl2aWR1YWwgcGVyc29uIHJlc3BvbnNpYmxlIGZvciB0aGUgZG9tYWluLiI7czo1OiJ2YWx1ZSI7czoxMDoiSW5kaXZpZHVhbCI7fX19fQ=='),
('lannie', 'YToxOntzOjE3OiJsYW5uaWVfbGVnYWxfdHlwZSI7YTozOntzOjI6IklEIjtzOjM6IjMwMiI7czoxMToiZGVzY3JpcHRpb24iO3M6Mzc6IkJvZ3VzIGxlZ2FsIHR5cGUgdG8gc2VlIGlmIHRoaXMgd29ya3MiO3M6Nzoib3B0aW9ucyI7YToxOntzOjEyOiJDb3Jwb3JhdGlvbiAiO2E6Mjp7czoxMToiZGVzY3JpcHRpb24iO3M6NTcyOiJBIGNvcnBvcmF0aW9uIHVuZGVyIHRoZSBsYXdzIG9mIENhbmFkYSBvciBhbnkgcHJvdmluY2Ugb3IgdGVycml0b3J5IG9mIENhbmFkYSwgQ2hhcml0aWVzLCBDb29wZXJhdGl2ZSwgQ291bmNpbC4KUmVxdWlyZW1lbnRzOiBSZWdpc3RyYW50IG5hbWUgbXVzdCBiZSB0aGUgZnVsbCBsZWdhbCBuYW1lIG9mIHRoZSBjb3Jwb3JhdGlvbiBhbmQgbXVzdCBiZSBmb2xsb3dlZCBieSB0aGUganVyaXNkaWN0aW9uIG9mIGluY29ycG9yYXRpb24gKGVnLiBDYW5hZGEsIE9udGFyaW8sIE5XVC4uLiksIHVubGVzcyBpdCBpcyBvYnZpb3VzIGZyb20gdGhlIGNvcnBvcmF0aW9uJiMzOTtzIG5hbWUuIENhbmFkaWFuIEludGVybmV0IFJlZ2lzdHJhdGlvbiBBdXRob3JpdHkgKENhbmFkYSkuIEZvciBDaGFyaXRpZXMsIHRoZSBORlAgc2hvdWxkIGJlIGluY2x1ZGVkIGluIHRoZSBvcmdhbml6YXRpb24gbmFtZS4gSWYgdGhpcyBpcyBhIG5vdC1mb3ItcHJvZml0IG9yZ2FuaXphdGlvbiwgeW91IGFyZSBhbHNvIHJlcXVpcmVkIHRvIHN1Ym1pdCB0aGUgcmVnaXN0cmF0aW9uIG51bWJlciBpLmUuOiAxMjM0NTY3ODkgUlIwMDAxICI7czo1OiJ2YWx1ZSI7czozOiJDQ08iO319fX0='),
('ong', 'YToxOntzOjk6Im5nb19hZ3JlZSI7YTo0OntzOjI6IklEIjtzOjM6IjI5MiI7czoxMToiZGVzY3JpcHRpb24iO3M6MjM5MjoiVGhlIFB1YmxpYyBJbnRlcmVzdCBSZWdpc3RyeSAoUElSKSBoYXMgd29ya2VkIGNsb3NlbHkgd2l0aCB0aGUgZ2xvYmFsIE5HTyBjb21tdW5pdHkgdG8gZGV2ZWxvcCBhIHZhbGlkYXRpb24gcHJvY2VzcyBmb3IgLk5HTyBhbmQgLk9ORyByZWdpc3RyYXRpb24uIFRoZSBmb2xsb3dpbmcgc2V2ZW4gY3JpdGVyaWEgYXJlIHVzZWQgdG8gZGVmaW5lIGFuIE5HTyBmb3IgdGhlIHB1cnBvc2Ugb2YgdmFsaWRhdGlvbjoKCkZvY3VzZWQgb24gYWN0aW5nIGluIHRoZSBwdWJsaWMgaW50ZXJlc3Q6IFdoZXRoZXIgaW4gc3VwcG9ydCBvZiBlZHVjYXRpb24gb3IgaGVhbHRoLCB0aGUgZW52aXJvbm1lbnQgb3IgaHVtYW4gcmlnaHRzLCBtZW1iZXJzIG9mIHRoZSBjb21tdW5pdHkgd29yayBmb3IgdGhlIGdvb2Qgb2YgaHVtYW5raW5kIGFuZC9vciB0aGUgcHJlc2VydmF0aW9uIG9mIHRoZSBwbGFuZXQgYW5kIGRvIG5vdCBwcm9tb3RlIGRpc2NyaW1pbmF0aW9uIG9yIGJpZ290cnkuCk5vbi1wcm9maXQgbWFraW5nL25vbi1wcm9maXQtZm9jdXNlZCBlbnRpdGllczogV2hpbGUgbWFueSBOR09zIGFuZCBPTkdzIGVuZ2FnZSBpbiBjb21tZXJjaWFsIGFjdGl2aXRpZXMgb3IgZ2VuZXJhdGUgcmV2ZW51ZSBpbiBzdXBwb3J0IG9mIHRoZWlyIG1pc3Npb25zLCBtZW1iZXJzIG9mIHRoZSBjb21tdW5pdHkgZG8gbm90IHJlY29nbml6ZSBwcm9maXRzIG9yIHJldGFpbiBlYXJuaW5ncy4KTGltaXRlZCBnb3Zlcm5tZW50IGluZmx1ZW5jZTogUmVjb2duaXppbmcgdGhhdCBtYW55IE5HTyBhbmQgT05HIG9yZ2FuaXphdGlvbnMgaGF2ZSBpbXBvcnRhbnQgaW50ZXJhY3Rpb25zIHdpdGggZ292ZXJubWVudCwgbm90IGxlYXN0IGZvciByZWFzb25zIG9mIGZ1bmRpbmcgKHdoaWNoIG1heSBpbmNsdWRlIHJlY2VpcHQgb2Ygc29tZSBnb3Zlcm5tZW50IGZ1bmRpbmcgaW4gc3VwcG9ydCBvZiB0aGVpciBwcm9ncmFtcykgbWVtYmVycyBvZiB0aGUgY29tbXVuaXR5IGRlY2lkZSB0aGVpciBvd24gcG9saWNpZXMsIGRpcmVjdCB0aGVpciBvd24gYWN0aXZpdGllcyBhbmQgYXJlIGluZGVwZW5kZW50IG9mIGRpcmVjdCBnb3Zlcm5tZW50IG9yIHBvbGl0aWNhbCBjb250cm9sLgpJbmRlcGVuZGVudCBhY3RvcnM6IE1lbWJlcnMgb2YgdGhlIGNvbW11bml0eSBzaG91bGQgbm90IGJlIHBvbGl0aWNhbCBwYXJ0aWVzIG5vciBzaG91bGQgYmUgYSBwYXJ0IG9mIGFueSBnb3Zlcm5tZW50LiBQYXJ0aWNpcGF0aW9uIGluIHRoZSB3b3JrIG9mIGEgTkdPL09ORyBpcyB2b2x1bnRhcnkuCkFjdGl2ZSBPcmdhbml6YXRpb25zOiBNZW1iZXJzIG9mIHRoZSBjb21tdW5pdHkgYXJlIGFjdGl2ZWx5IHB1cnN1aW5nIHRoZWlyIG1pc3Npb25zIG9uIGEgcmVndWxhciBiYXNpcy4KU3RydWN0dXJlZDogTWVtYmVycyBvZiB0aGUgY29tbXVuaXR5LCB3aGV0aGVyIGxhcmdlIG9yIHNtYWxsLCBvcGVyYXRlIGluIGEgc3RydWN0dXJlZCBtYW5uZXIgKGUuZy4sIHVuZGVyIGJ5bGF3cywgY29kZXMgb2YgY29uZHVjdCwgb3JnYW5pemF0aW9uYWwgc3RhbmRhcmRzLCBvciBvdGhlciBnb3Zlcm5hbmNlIHN0cnVjdHVyZXMuKQpMYXdmdWw6IE1lbWJlcnMgb2YgdGhlIC5OR08gYW5kIC5PTkcgY29tbXVuaXR5IGFjdCB3aXRoIGludGVncml0eSB3aXRoaW4gdGhlIGJvdW5kcyBvZiBsYXcuClBsZWFzZSBub3RlIHRoYXQgJnF1b3Q7bWVtYmVycyBvZiB0aGUgY29tbXVuaXR5JnF1b3Q7IGFib3ZlIHJlZmVycyB0byBtZW1iZXJzIG9mIHRoZSAuTkdPIGFuZCAuT05HIGNvbW11bml0eS4gTkdPcyBhbmQgT05HcyBwYXJ0aWNpcGF0aW5nIGFzIG1lbWJlcnMgaW4gdGhpcyBjb21tdW5pdHkgbXVzdCBjZXJ0aWZ5IHRoYXQgdGhleSBhZGhlcmUgdG8gdGhlIGFib3ZlIEVsaWdpYmlsaXR5IENyaXRlcmlhLgoKVXBvbiBwdXJjaGFzaW5nIGFuZCBOR08vT05HIHRoZSByZWdpc3RyeSBvcGVyYXRvciB3aWxsIHJlYWNoIG91dCB0byB5b3UgZGlyZWN0bHkgdG8gY29uZmlybSB5b3VyIGVsaWdpYmlsaXR5LiBQbGVhc2Ugd29yayB3aXRoIHRoZSBSZWdpc3RyeSBPcGVyYXRvciB0byBjb21wbGV0ZSB0aGlzIHZhbGlkYXRpb24gcHJvY2Vzcy4gWW91ciBkb21haW4gd2lsbCBub3QgcmVzb2x2ZSB1bnRpbCB0aGlzIHZhbGlkYXRpb24gcHJvY2VzcyBpcyBjb21wbGV0ZS4KCkJ5IHNlbGVjdGluZyB0aGUgYm94IGJlbG93LCB5b3UgY2VydGlmeSB0aGF0IHlvdSBtZWV0IGFuZCB3aWxsIGFkaGVyZSB0byB0aGUgYWJvdmUgRWxpZ2liaWxpdHkgQ3JpdGVyaWEgYWJvdmUuIApQbGVhc2Ugbm90ZSB0aGF0IHJlZ2lzdHJhbnRzIHdobyBkbyBub3QgY29tcGxldGUgdGhlIHZhbGlkYXRpb24gcHJvY2VzcyBtYXkgaGF2ZSB0aGVpciBkb21haW5zIHN1c3BlbmRlZCBvciBkZWxldGVkIHdpdGhvdXQgcmVmdW5kLiI7czo4OiJyZXF1aXJlZCI7czoxOiIxIjtzOjc6Im9wdGlvbnMiO2E6MTp7czo3OiJJIGFncmVlIjthOjI6e3M6MTE6ImRlc2NyaXB0aW9uIjtzOjU4OiJJIGFncmVlIHRvIHRoZSB0ZXJtcyBmb3Igb3BlcmF0aW9ucyBvZiB0aGUgT05HL05HTyBwcm9ncmFtIjtzOjU6InZhbHVlIjtzOjc6IkkgQWdyZWUiO319fX0='),
('law', 'YTo0OntzOjIwOiJsYXctYWNjcmVkaXRhdGlvbi1pZCI7YTo0OntzOjI6IklEIjtzOjM6IjI4MSI7czoxMToiZGVzY3JpcHRpb24iO3M6MjI2OiJUaGUgcXVhbGlmaWVkIGxhd3llciYjMzk7cyBhY2NyZWRpdGF0aW9uIElEIGlzIGEgY2hhcmFjdGVyIHN0cmluZyBpc3N1ZWQgYnkgdGhlIGFjY3JlZGl0YXRpb24gYm9keSB0byB0aGUgcXVhbGlmaWVkIGxhd3llci4gQWNjcmVkaXRhdGlvbiBJRHMgdW5pcXVlbHkgaWRlbnRpZnkgdGhlIHF1YWxpZmllZCBsYXd5ZXIgd2l0aGluIHRoZSBjb250ZXh0IG9mIHRoZSBhY2NyZWRpdGF0aW9uIGJvZHkuIjtzOjg6InJlcXVpcmVkIjtzOjE6IjEiO3M6Nzoib3B0aW9ucyI7YTowOnt9fXM6MjI6Imxhdy1hY2NyZWRpdGF0aW9uLWJvZHkiO2E6NDp7czoyOiJJRCI7czozOiIyODIiO3M6MTE6ImRlc2NyaXB0aW9uIjtzOjE5NjoiVGhlIGFjY3JlZGl0YXRpb24gYm9keSBpcyB0aGUgZW50aXR5IHRoYXQgaXNzdWVkIHRoZSBhY2NyZWRpdGF0aW9uIElEIHRvIHRoZSBxdWFsaWZpZWQgbGF3eWVyLiBXaXRoaW4gdGhlIFF1YWxpZmllZCBMYXd5ZXIgZXh0ZW5zaW9uLCBhIGNoYXJhY3RlciBzdHJpbmcgaXMgdXNlZCB0byByZXByZXNlbnQgYW4gYWNjcmVkaXRhdGlvbiBib2R5LiI7czo4OiJyZXF1aXJlZCI7czoxOiIxIjtzOjc6Im9wdGlvbnMiO2E6MDp7fX1zOjIyOiJsYXctYWNjcmVkaXRhdGlvbi15ZWFyIjthOjQ6e3M6MjoiSUQiO3M6MzoiMjgzIjtzOjExOiJkZXNjcmlwdGlvbiI7czoxNTM6IkEgcXVhbGlmaWVkIGxhd3llciYjMzk7cyBhY2NyZWRpdGF0aW9uIHllYXIgaXMgdGhlIHllYXIgaGUvc2hlIHdhcyBpbml0aWFsbHkgY2VydGlmaWVkIGJ5IHRoZSBhY2NyZWRpdGF0aW9uIGJvZHkuIEl0IGlzIHJlcHJlc2VudGVkIGJ5IGEgZm91ci1kaWdpdCB5ZWFyLiI7czo4OiJyZXF1aXJlZCI7czoxOiIxIjtzOjc6Im9wdGlvbnMiO2E6MDp7fX1zOjI0OiJsYXctanVyaXNkaWN0aW9uLWNvdW50cnkiO2E6NDp7czoyOiJJRCI7czozOiIyODQiO3M6MTE6ImRlc2NyaXB0aW9uIjtzOjIwODoiVGhlIGFjY3JlZGl0YXRpb24ganVyaXNkaWN0aW9uIGNvdW50cnkgaXMgdGhlIGNvdW50cnkgaW4gd2hpY2ggdGhlIGFjY3JlZGl0YXRpb24gYm9keSBjZXJ0aWZpZXMgdGhlIHF1YWxpZmllZCBsYXd5ZXIuIElTTyB0d28tbGV0dGVyIGNvdW50cnkgY29kZXMgYXJlIHVzZWQgdG8gcmVwcmVzZW50IHRoZSBhY2NyZWRpdGF0aW9uIGp1cmlzZGljdGlvbiBjb3VudHJ5LiI7czo4OiJyZXF1aXJlZCI7czoxOiIxIjtzOjc6Im9wdGlvbnMiO2E6MDp7fX19'),
('ngo', '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'),
('eus', 'YToxOntzOjE2OiJjb3JlX2ludGVuZGVkdXNlIjthOjQ6e3M6MjoiSUQiO3M6MzoiMjk0IjtzOjExOiJkZXNjcmlwdGlvbiI7czo4OToiUGxlYXNlIHdyaXRlIGEgYnJpZWYgZGVzY3JpcHRpb24gb2YgeW91ciBpbnRlbmRlZCB1c2Ugb2YgdGhpcyBkb21haW4gKG1heCAyNTUgY2hhcmFjdGVycykiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('gal', 'YToxOntzOjE2OiJjb3JlX2ludGVuZGVkdXNlIjthOjQ6e3M6MjoiSUQiO3M6MzoiMjkzIjtzOjExOiJkZXNjcmlwdGlvbiI7czo4OToiUGxlYXNlIHdyaXRlIGEgYnJpZWYgZGVzY3JpcHRpb24gb2YgeW91ciBpbnRlbmRlZCB1c2Ugb2YgdGhpcyBkb21haW4gKG1heCAyNTUgY2hhcmFjdGVycykiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('dev', 'YToxOntzOjk6ImRldl9hZ3JlZSI7YTo0OntzOjI6IklEIjtzOjM6IjMxNSI7czoxMToiZGVzY3JpcHRpb24iO3M6NTI5OiIuREVWIEVsaWdpYmlsaXR5IFJlcXVpcmVtZW50czogCgouRGV2IGlzIGEgbW9yZSBzZWN1cmUgZG9tYWluLCBtZWFuaW5nIHRoYXQgSFRUUFMgaXMgcmVxdWlyZWQgZm9yIGFsbCAuZGV2IHdlYnNpdGVzLiBZb3UgY2FuIGJ1eSB5b3VyIC5EZXYgZG9tYWluIG5hbWUgbm93LCBidXQgaW4gb3JkZXIgZm9yIGl0IHRvIHdvcmsgcHJvcGVybHkgaW4gYnJvd3NlcnMgeW91IG11c3QgZmlyc3QgY29uZmlndXJlIEhUVFBTIHNlcnZpbmcuIEZvciBtb3JlIGluZm9ybWF0aW9uIGFib3V0IGNvbmZpZ3VyaW5nIEhUVFBTLCBwbGVhc2UgY2xpY2sgaGVyZS4gVG8gb2J0YWluIG1vcmUgaW5mb3JtYXRpb24gb24gU1NMIGNlcnRpZmljYXRlcywgcGxlYXNlIHZpc2l0IHlvdXIgaG9zdGluZyBzZXJ2aWNlIHByb3ZpZGVyIG9yIGdldCBhIGZyZWUgU1NMIGNlcnRpZmljYXRlIGZyb20gTGV0JiMzOTtzIEVuY3J5cHQuCgogSSwgdGhlIFJlZ2lzdHJhbnQsIHVuZGVyc3RhbmQgYW5kIGFncmVlIHRvIHRoZSAuZGV2IFJlZ2lzdHJhdGlvbiBQb2xpY3kuIjtzOjg6InJlcXVpcmVkIjtzOjE6IjEiO3M6Nzoib3B0aW9ucyI7YToxOntzOjc6IkkgQWdyZWUiO2E6Mjp7czoxMToiZGVzY3JpcHRpb24iO3M6MTA1OiJCeSBzZWxlY3RpbmcgJnF1b3Q7SSBBZ3JlZSZxdW90OyB5b3UgY29uZmlybSB0aGF0IHlvdSBoYXZlIHJlYWQsIGFuZCBhZ3JlZSB0byB0aGUgLmRldiBSZWdpc3RyYW50IFBvbGljeS4iO3M6NToidmFsdWUiO3M6NzoiSSBBZ3JlZSI7fX19fQ=='),
('barcelona', 'YToxOntzOjE2OiJjb3JlX2ludGVuZGVkdXNlIjthOjQ6e3M6MjoiSUQiO3M6MzoiMjk1IjtzOjExOiJkZXNjcmlwdGlvbiI7czo4OToiUGxlYXNlIHdyaXRlIGEgYnJpZWYgZGVzY3JpcHRpb24gb2YgeW91ciBpbnRlbmRlZCB1c2Ugb2YgdGhpcyBkb21haW4gKG1heCAyNTUgY2hhcmFjdGVycykiO3M6ODoicmVxdWlyZWQiO3M6MToiMSI7czo3OiJvcHRpb25zIjthOjA6e319fQ=='),
('abogado', 'YTo0OntzOjIwOiJsYXctYWNjcmVkaXRhdGlvbi1pZCI7YTo0OntzOjI6IklEIjtzOjM6IjI4NiI7czoxMToiZGVzY3JpcHRpb24iO3M6MjI2OiJUaGUgcXVhbGlmaWVkIGxhd3llciYjMzk7cyBhY2NyZWRpdGF0aW9uIElEIGlzIGEgY2hhcmFjdGVyIHN0cmluZyBpc3N1ZWQgYnkgdGhlIGFjY3JlZGl0YXRpb24gYm9keSB0byB0aGUgcXVhbGlmaWVkIGxhd3llci4gQWNjcmVkaXRhdGlvbiBJRHMgdW5pcXVlbHkgaWRlbnRpZnkgdGhlIHF1YWxpZmllZCBsYXd5ZXIgd2l0aGluIHRoZSBjb250ZXh0IG9mIHRoZSBhY2NyZWRpdGF0aW9uIGJvZHkuIjtzOjg6InJlcXVpcmVkIjtzOjE6IjEiO3M6Nzoib3B0aW9ucyI7YTowOnt9fXM6MjI6Imxhdy1hY2NyZWRpdGF0aW9uLWJvZHkiO2E6NDp7czoyOiJJRCI7czozOiIyODciO3M6MTE6ImRlc2NyaXB0aW9uIjtzOjE5NjoiVGhlIGFjY3JlZGl0YXRpb24gYm9keSBpcyB0aGUgZW50aXR5IHRoYXQgaXNzdWVkIHRoZSBhY2NyZWRpdGF0aW9uIElEIHRvIHRoZSBxdWFsaWZpZWQgbGF3eWVyLiBXaXRoaW4gdGhlIFF1YWxpZmllZCBMYXd5ZXIgZXh0ZW5zaW9uLCBhIGNoYXJhY3RlciBzdHJpbmcgaXMgdXNlZCB0byByZXByZXNlbnQgYW4gYWNjcmVkaXRhdGlvbiBib2R5LiI7czo4OiJyZXF1aXJlZCI7czoxOiIxIjtzOjc6Im9wdGlvbnMiO2E6MDp7fX1zOjIyOiJsYXctYWNjcmVkaXRhdGlvbi15ZWFyIjthOjQ6e3M6MjoiSUQiO3M6MzoiMjg4IjtzOjExOiJkZXNjcmlwdGlvbiI7czoxNTM6IkEgcXVhbGlmaWVkIGxhd3llciYjMzk7cyBhY2NyZWRpdGF0aW9uIHllYXIgaXMgdGhlIHllYXIgaGUvc2hlIHdhcyBpbml0aWFsbHkgY2VydGlmaWVkIGJ5IHRoZSBhY2NyZWRpdGF0aW9uIGJvZHkuIEl0IGlzIHJlcHJlc2VudGVkIGJ5IGEgZm91ci1kaWdpdCB5ZWFyLiI7czo4OiJyZXF1aXJlZCI7czoxOiIxIjtzOjc6Im9wdGlvbnMiO2E6MDp7fX1zOjI0OiJsYXctanVyaXNkaWN0aW9uLWNvdW50cnkiO2E6NDp7czoyOiJJRCI7czozOiIyODkiO3M6MTE6ImRlc2NyaXB0aW9uIjtzOjIwODoiVGhlIGFjY3JlZGl0YXRpb24ganVyaXNkaWN0aW9uIGNvdW50cnkgaXMgdGhlIGNvdW50cnkgaW4gd2hpY2ggdGhlIGFjY3JlZGl0YXRpb24gYm9keSBjZXJ0aWZpZXMgdGhlIHF1YWxpZmllZCBsYXd5ZXIuIElTTyB0d28tbGV0dGVyIGNvdW50cnkgY29kZXMgYXJlIHVzZWQgdG8gcmVwcmVzZW50IHRoZSBhY2NyZWRpdGF0aW9uIGp1cmlzZGljdGlvbiBjb3VudHJ5LiI7czo4OiJyZXF1aXJlZCI7czoxOiIxIjtzOjc6Im9wdGlvbnMiO2E6MDp7fX19'),
('app', 'YToxOntzOjk6ImFwcF9hZ3JlZSI7YTo0OntzOjI6IklEIjtzOjM6IjMxNyI7czoxMToiZGVzY3JpcHRpb24iO3M6NTI5OiIuQVBQIEVsaWdpYmlsaXR5IFJlcXVpcmVtZW50czogLkFQUCBpcyBhIG1vcmUgc2VjdXJlIGRvbWFpbiwgbWVhbmluZyB0aGF0IEhUVFBTIGlzIHJlcXVpcmVkIGZvciBhbGwgLkFQUCB3ZWJzaXRlcy4gWW91IGNhbiBidXkgeW91ciAuQVBQIGRvbWFpbiBuYW1lIG5vdywgYnV0IGluIG9yZGVyIGZvciBpdCB0byB3b3JrIHByb3Blcmx5IGluIGJyb3dzZXJzIHlvdSBtdXN0IGZpcnN0IGNvbmZpZ3VyZSBIVFRQUyBzZXJ2aW5nLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiBhYm91dCBjb25maWd1cmluZyBIVFRQUywgcGxlYXNlIGNsaWNrIGhlcmUuIFRvIG9idGFpbiBtb3JlIGluZm9ybWF0aW9uIG9uIFNTTCBjZXJ0aWZpY2F0ZXMsIHBsZWFzZSB2aXNpdCB5b3VyIGhvc3Rpbmcgc2VydmljZSBwcm92aWRlciBvciBnZXQgYSBmcmVlIFNTTCBjZXJ0aWZpY2F0ZSBmcm9tIExldCZhbXA7IzM5O3MgRW5jcnlwdC4gSSwgdGhlIFJlZ2lzdHJhbnQsIHVuZGVyc3RhbmQgYW5kIGFncmVlIHRvIHRoZSAuQVBQIFJlZ2lzdHJhdGlvbiBQb2xpY3kuIjtzOjg6InJlcXVpcmVkIjtzOjE6IjEiO3M6Nzoib3B0aW9ucyI7YToxOntpOjA7YToyOntzOjExOiJkZXNjcmlwdGlvbiI7czoxMDU6IkJ5IHNlbGVjdGluZyAmcXVvdDtJIEFncmVlJnF1b3Q7IHlvdSBjb25maXJtIHRoYXQgeW91IGhhdmUgcmVhZCwgYW5kIGFncmVlIHRvIHRoZSAuYXBwIFJlZ2lzdHJhbnQgUG9saWN5LiI7czo1OiJ2YWx1ZSI7czo3OiJJIEFncmVlIjt9fX19'),
('day', 'YToxOntzOjk6ImRheV9hZ3JlZSI7YTo0OntzOjI6IklEIjtzOjM6IjMxOCI7czoxMToiZGVzY3JpcHRpb24iO3M6NTI5OiIuREFZIEVsaWdpYmlsaXR5IFJlcXVpcmVtZW50czogLkRBWSBpcyBhIG1vcmUgc2VjdXJlIGRvbWFpbiwgbWVhbmluZyB0aGF0IEhUVFBTIGlzIHJlcXVpcmVkIGZvciBhbGwgLkRBWSB3ZWJzaXRlcy4gWW91IGNhbiBidXkgeW91ciAuREFZIGRvbWFpbiBuYW1lIG5vdywgYnV0IGluIG9yZGVyIGZvciBpdCB0byB3b3JrIHByb3Blcmx5IGluIGJyb3dzZXJzIHlvdSBtdXN0IGZpcnN0IGNvbmZpZ3VyZSBIVFRQUyBzZXJ2aW5nLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiBhYm91dCBjb25maWd1cmluZyBIVFRQUywgcGxlYXNlIGNsaWNrIGhlcmUuIFRvIG9idGFpbiBtb3JlIGluZm9ybWF0aW9uIG9uIFNTTCBjZXJ0aWZpY2F0ZXMsIHBsZWFzZSB2aXNpdCB5b3VyIGhvc3Rpbmcgc2VydmljZSBwcm92aWRlciBvciBnZXQgYSBmcmVlIFNTTCBjZXJ0aWZpY2F0ZSBmcm9tIExldCZhbXA7IzM5O3MgRW5jcnlwdC4gSSwgdGhlIFJlZ2lzdHJhbnQsIHVuZGVyc3RhbmQgYW5kIGFncmVlIHRvIHRoZSAuREFZIFJlZ2lzdHJhdGlvbiBQb2xpY3kuIjtzOjg6InJlcXVpcmVkIjtzOjE6IjEiO3M6Nzoib3B0aW9ucyI7YToxOntzOjc6IkkgQUdSRUUiO2E6Mjp7czoxMToiZGVzY3JpcHRpb24iO3M6MTA1OiJCeSBzZWxlY3RpbmcgJnF1b3Q7SSBBZ3JlZSZxdW90OyB5b3UgY29uZmlybSB0aGF0IHlvdSBoYXZlIHJlYWQsIGFuZCBhZ3JlZSB0byB0aGUgLmRheSBSZWdpc3RyYW50IFBvbGljeS4iO3M6NToidmFsdWUiO3M6NzoiSSBBZ3JlZSI7fX19fQ==');

-- --------------------------------------------------------

--
-- Table structure for table `translations`
--

CREATE TABLE `translations` (
  `type` int(11) NOT NULL,
  `itemid` int(11) NOT NULL,
  `language` varchar(200) NOT NULL,
  `value` longtext NOT NULL,
  PRIMARY KEY (`type`,`itemid`,`language`),
  FULLTEXT KEY `value` (`value`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `troubleticket`
--

CREATE TABLE `troubleticket` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hashed_id` varchar(32) NOT NULL DEFAULT '',
  `userid` int(11) NOT NULL DEFAULT '0',
  `company_id` int(11) NOT NULL DEFAULT '0',
  `domainid` int(11) DEFAULT '0',
  `subject` text NOT NULL,
  `priority` int(2) NOT NULL DEFAULT '3',
  `support_email` varchar(60) DEFAULT NULL,
  `datesubmitted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` int(2) NOT NULL DEFAULT '0',
  `messagetype` int(11) NOT NULL DEFAULT '0',
  `assignedtoid` int(11) NOT NULL DEFAULT '0',
  `assignedtodeptid` int(11) NOT NULL DEFAULT '0',
  `lastlog_datetime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `rate_hash` char(32) DEFAULT NULL,
  `rate` tinyint(4) NOT NULL DEFAULT '0',
  `feedback` text,
  `autoclose` int(2) NOT NULL DEFAULT '0',
  `tag` varchar(10) NOT NULL DEFAULT 'clear',
  `method` tinyint(4) NOT NULL DEFAULT '0',
  `externalid` varchar(45) NOT NULL DEFAULT '0',
  `response_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `i_userid_status` (`userid`,`status`),
  KEY `status` (`status`),
  FULLTEXT KEY `subject` (`subject`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `troubleticket_additionalnotification`
--

CREATE TABLE `troubleticket_additionalnotification` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ticketid` int(11) NOT NULL,
  `userid` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ticketid` (`ticketid`,`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `troubleticket_files`
--

CREATE TABLE `troubleticket_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ticketid` int(11) NOT NULL,
  `filename` varchar(50) NOT NULL,
  `dateadded` datetime NOT NULL,
  `filekey` varchar(16) NOT NULL,
  `userid` int(11) NOT NULL,
  `troubleticket_log_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `filekey` (`filekey`),
  KEY `i_ticketid` (`ticketid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `troubleticket_filters`
--

CREATE TABLE `troubleticket_filters` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(10) NOT NULL DEFAULT '0',
  `private` int(2) NOT NULL DEFAULT '0',
  `temp` tinyint(4) NOT NULL,
  `name` varchar(50) NOT NULL,
  `sql` text NOT NULL,
  `lastlog_datetime` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `troubleticket_log`
--

CREATE TABLE `troubleticket_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL DEFAULT '0',
  `troubleticketid` int(11) NOT NULL DEFAULT '0',
  `logtype` tinyint(4) NOT NULL,
  `newstate` text NOT NULL,
  `message` text NOT NULL,
  `userid` int(11) NOT NULL DEFAULT '0',
  `externalemail` tinyint(4) NOT NULL DEFAULT '0',
  `mydatetime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `logaction` tinyint(4) NOT NULL DEFAULT '0',
  `private` int(2) NOT NULL DEFAULT '0',
  `deletedname` varchar(35) NOT NULL DEFAULT '',
  `email` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `email` (`email`),
  KEY `troubleticketid` (`troubleticketid`),
  KEY `company_id` (`company_id`),
  FULLTEXT KEY `message` (`message`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `troubleticket_type`
--

CREATE TABLE `troubleticket_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(40) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `myorder` int(2) NOT NULL DEFAULT '0',
  `enabled` tinyint(4) NOT NULL DEFAULT '1',
  `enabled_public` tinyint(4) NOT NULL DEFAULT '1',
  `target_dept` int(11) NOT NULL,
  `target_staff` int(11) NOT NULL,
  `systemid` int(2) NOT NULL DEFAULT '0',
  `allowclose` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `i_company_id` (`company_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `troubleticket_type`
--

INSERT INTO `troubleticket_type` VALUES
(-1, 0, 'All ticket types', '', 0, 1, 1, 0, 0, 0, 1),
(1, 0, 'Internal Billing Issues', 'This ticket type is used when ClientExec creates system messages for billing related issue.  Such as subscription cancelation etc', -1, 1, 0, 0, 0, 1, 1),
(2, 0, 'Externally Created', 'This ticket type is used when ClientExec creates system messages for externally created ticket using 3rd party services.', -1, 1, 0, 0, 0, 2, 1),
(3, 0, 'General', '', 0, 1, 1, 0, 0, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `troubleticket_type_customfields`
--

CREATE TABLE `troubleticket_type_customfields` (
  `tickettype_id` int(11) NOT NULL,
  `custom_id` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL DEFAULT '0',
  `current` tinyint(1) DEFAULT '1',
  `paymenttype` varchar(30) NOT NULL DEFAULT '0',
  `clienttype` tinyint(4) NOT NULL DEFAULT '0',
  `groupid` int(10) DEFAULT '1',
  `password` varchar(60) DEFAULT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `dateActivated` date DEFAULT NULL,
  `signature_text` text,
  `signature_html` text,
  `loggedin` smallint(1) NOT NULL DEFAULT '0',
  `lastlogin` datetime DEFAULT NULL,
  `lastseen` datetime DEFAULT NULL,
  `lastview` text,
  `active` smallint(6) NOT NULL DEFAULT '1',
  `recurring` tinyint(4) DEFAULT '1',
  `currency` varchar(5) DEFAULT '0',
  `data1` text,
  `autopayment` smallint(1) NOT NULL DEFAULT '0',
  `ccmonth` varchar(4) NOT NULL DEFAULT '0',
  `ccyear` varchar(4) NOT NULL DEFAULT '0',
  `cclastfour` varchar(5) NOT NULL DEFAULT '',
  `data2` text,
  `data3` text,
  `passphrased` smallint(1) NOT NULL DEFAULT '0',
  `updating` tinyint(4) NOT NULL DEFAULT '0',
  `taxable` tinyint(4) NOT NULL DEFAULT '0',
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `firstname` varchar(25) NOT NULL DEFAULT '',
  `lastname` varchar(25) NOT NULL DEFAULT '',
  `email` varchar(254) NOT NULL DEFAULT '',
  `organization` varchar(60) NOT NULL DEFAULT '',
  `usernotes` longtext,
  `usernotespos` varchar(75) NOT NULL DEFAULT '',
  `warningmask` int(11) NOT NULL DEFAULT '0',
  `balance` decimal(25,3) NOT NULL DEFAULT '0.000',
  `chatstatus` tinyint(4) NOT NULL DEFAULT '0',
  `plus_score` int(11) NOT NULL DEFAULT '0',
  `plus_data` text NOT NULL,
  `plus_date` datetime DEFAULT NULL,
  `profile_updated` tinyint(1) NOT NULL DEFAULT '1',
  `invoice_template` varchar(45) NOT NULL DEFAULT '',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `loggedin` (`loggedin`),
  KEY `i_lastx` (`lastseen`,`loggedin`,`groupid`),
  KEY `groupid` (`groupid`),
  KEY `status` (`status`),
  KEY `autopayment` (`autopayment`),
  KEY `cclastfour` (`cclastfour`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=101 ;

--
-- Dumping data for table `users`
--

INSERT INTO `users` VALUES
(100, 0, 0, '2checkout', 0, 2, NULL, NULL, '0000-00-00', '', '', 0, '2003-02-14 22:29:45', '[[regtime]]', '', 1, 1, '0', '', 0, '0', '0', '', '', '', 0, 0, 0, 1, 'Admin', 'User', '[[admin_email]]', '', '', '', 0, '0.000', 0, 0, '', NULL, 1, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `users_domains`
--

CREATE TABLE `users_domains` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) NOT NULL,
  `domain` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(50) NOT NULL,
  `period` int(11) NOT NULL,
  `auto_renew` tinyint(4) NOT NULL DEFAULT '1',
  `nextbilldate` date NOT NULL,
  `domain_extra_attr` text,
  `registration_option` tinyint(4) NOT NULL,
  `registrar` varchar(20) NOT NULL,
  `registrar_orderid` varchar(50) NOT NULL,
  `status` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `userid` (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_customuserfields`
--

CREATE TABLE `user_customuserfields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(11) NOT NULL DEFAULT '0',
  `customid` int(11) NOT NULL DEFAULT '0',
  `value` text,
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `userid_customid` (`userid`,`customid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

--
-- Dumping data for table `user_customuserfields`
--

INSERT INTO `user_customuserfields` VALUES
(1, 100, 1, 'Admin', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(2, 100, 2, 'User', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(3, 100, 4, '[[admin_email]]', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(4, 100, 54, 'a:2:{s:9:"ataglance";a:3:{s:11:"newaccounts";b:1;s:7:"billing";b:1;s:7:"tickets";b:1;}s:8:"sections";a:5:{s:6:"counts";b:1;s:7:"reports";b:1;s:7:"tickets";b:1;s:10:"automation";b:1;s:8:"warnings";b:1;}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(5, 100, 50, '[[admin_pass]]', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(8, 100, 61, '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(7, 100, 55, '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
(9, 100, 46, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `user_groups`
--

CREATE TABLE `user_groups` (
  `user_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `user_notifications`
--

CREATE TABLE `user_notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_type` varchar(50) NOT NULL,
  `object_id` int(11) NOT NULL,
  `rule_id` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `versions`
--

CREATE TABLE `versions` (
  `module` varchar(50) NOT NULL,
  `version` varchar(50) NOT NULL,
  PRIMARY KEY (`module`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `versions`
--

INSERT INTO `versions` VALUES
('newedge', '6.8.1'),
('home', '6.8.1'),
('clients', '6.8.1'),
('domains', '6.8.1'),
('billing', '6.8.1'),
('support', '6.8.1'),
('knowledgebase', '6.8.1'),
('files', '6.8.1'),
('reports', '6.8.1'),
('admin', '6.8.1'),
('affiliates', '6.8.1');

-- --------------------------------------------------------

--
-- Table structure for table `webhooks`
--

CREATE TABLE `webhooks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url` varchar(400) NOT NULL,
  `eventtype` int(11) DEFAULT '1',
  `providertype` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
