<?php
/**
 * Branding
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * orchd
 *
 * orchd API docs
 *
 * The version of the OpenAPI document: 12.7.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.14.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Model;

use \ArrayAccess;
use \OpenAPI\Client\ObjectSerializer;

/**
 * Branding Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Branding implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Branding';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'org_name' => 'string',
        'parent' => 'string',
        'control_panel_domain' => 'string',
        'php_my_admin_domain' => 'string',
        'roundcube_domain' => 'string',
        'logo_path' => 'string',
        'inverse_logo_path' => 'string',
        'inverse_icon_path' => 'string',
        'login_image_path' => 'string',
        'favicon_path' => 'string',
        'name_servers' => 'string[]',
        'settings' => '\OpenAPI\Client\Model\Setting[]',
        'staging_domain' => 'string',
        'locale' => '\OpenAPI\Client\Model\CPLocale'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'org_name' => null,
        'parent' => null,
        'control_panel_domain' => 'hostname',
        'php_my_admin_domain' => 'hostname',
        'roundcube_domain' => 'hostname',
        'logo_path' => 'path',
        'inverse_logo_path' => 'path',
        'inverse_icon_path' => 'path',
        'login_image_path' => 'path',
        'favicon_path' => 'path',
        'name_servers' => null,
        'settings' => null,
        'staging_domain' => 'hostname',
        'locale' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'org_name' => false,
        'parent' => false,
        'control_panel_domain' => false,
        'php_my_admin_domain' => false,
        'roundcube_domain' => false,
        'logo_path' => false,
        'inverse_logo_path' => false,
        'inverse_icon_path' => false,
        'login_image_path' => false,
        'favicon_path' => false,
        'name_servers' => false,
        'settings' => false,
        'staging_domain' => false,
        'locale' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'org_name' => 'orgName',
        'parent' => 'parent',
        'control_panel_domain' => 'controlPanelDomain',
        'php_my_admin_domain' => 'phpMyAdminDomain',
        'roundcube_domain' => 'roundcubeDomain',
        'logo_path' => 'logoPath',
        'inverse_logo_path' => 'inverseLogoPath',
        'inverse_icon_path' => 'inverseIconPath',
        'login_image_path' => 'loginImagePath',
        'favicon_path' => 'faviconPath',
        'name_servers' => 'nameServers',
        'settings' => 'settings',
        'staging_domain' => 'stagingDomain',
        'locale' => 'locale'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'org_name' => 'setOrgName',
        'parent' => 'setParent',
        'control_panel_domain' => 'setControlPanelDomain',
        'php_my_admin_domain' => 'setPhpMyAdminDomain',
        'roundcube_domain' => 'setRoundcubeDomain',
        'logo_path' => 'setLogoPath',
        'inverse_logo_path' => 'setInverseLogoPath',
        'inverse_icon_path' => 'setInverseIconPath',
        'login_image_path' => 'setLoginImagePath',
        'favicon_path' => 'setFaviconPath',
        'name_servers' => 'setNameServers',
        'settings' => 'setSettings',
        'staging_domain' => 'setStagingDomain',
        'locale' => 'setLocale'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'org_name' => 'getOrgName',
        'parent' => 'getParent',
        'control_panel_domain' => 'getControlPanelDomain',
        'php_my_admin_domain' => 'getPhpMyAdminDomain',
        'roundcube_domain' => 'getRoundcubeDomain',
        'logo_path' => 'getLogoPath',
        'inverse_logo_path' => 'getInverseLogoPath',
        'inverse_icon_path' => 'getInverseIconPath',
        'login_image_path' => 'getLoginImagePath',
        'favicon_path' => 'getFaviconPath',
        'name_servers' => 'getNameServers',
        'settings' => 'getSettings',
        'staging_domain' => 'getStagingDomain',
        'locale' => 'getLocale'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('org_name', $data ?? [], null);
        $this->setIfExists('parent', $data ?? [], null);
        $this->setIfExists('control_panel_domain', $data ?? [], null);
        $this->setIfExists('php_my_admin_domain', $data ?? [], null);
        $this->setIfExists('roundcube_domain', $data ?? [], null);
        $this->setIfExists('logo_path', $data ?? [], null);
        $this->setIfExists('inverse_logo_path', $data ?? [], null);
        $this->setIfExists('inverse_icon_path', $data ?? [], null);
        $this->setIfExists('login_image_path', $data ?? [], null);
        $this->setIfExists('favicon_path', $data ?? [], null);
        $this->setIfExists('name_servers', $data ?? [], null);
        $this->setIfExists('settings', $data ?? [], null);
        $this->setIfExists('staging_domain', $data ?? [], null);
        $this->setIfExists('locale', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['org_name'] === null) {
            $invalidProperties[] = "'org_name' can't be null";
        }
        if ($this->container['settings'] === null) {
            $invalidProperties[] = "'settings' can't be null";
        }
        if ($this->container['locale'] === null) {
            $invalidProperties[] = "'locale' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets org_name
     *
     * @return string
     */
    public function getOrgName()
    {
        return $this->container['org_name'];
    }

    /**
     * Sets org_name
     *
     * @param string $org_name org_name
     *
     * @return self
     */
    public function setOrgName($org_name)
    {
        if (is_null($org_name)) {
            throw new \InvalidArgumentException('non-nullable org_name cannot be null');
        }
        $this->container['org_name'] = $org_name;

        return $this;
    }

    /**
     * Gets parent
     *
     * @return string|null
     */
    public function getParent()
    {
        return $this->container['parent'];
    }

    /**
     * Sets parent
     *
     * @param string|null $parent parent
     *
     * @return self
     */
    public function setParent($parent)
    {
        if (is_null($parent)) {
            throw new \InvalidArgumentException('non-nullable parent cannot be null');
        }
        $this->container['parent'] = $parent;

        return $this;
    }

    /**
     * Gets control_panel_domain
     *
     * @return string|null
     */
    public function getControlPanelDomain()
    {
        return $this->container['control_panel_domain'];
    }

    /**
     * Sets control_panel_domain
     *
     * @param string|null $control_panel_domain control_panel_domain
     *
     * @return self
     */
    public function setControlPanelDomain($control_panel_domain)
    {
        if (is_null($control_panel_domain)) {
            throw new \InvalidArgumentException('non-nullable control_panel_domain cannot be null');
        }
        $this->container['control_panel_domain'] = $control_panel_domain;

        return $this;
    }

    /**
     * Gets php_my_admin_domain
     *
     * @return string|null
     */
    public function getPhpMyAdminDomain()
    {
        return $this->container['php_my_admin_domain'];
    }

    /**
     * Sets php_my_admin_domain
     *
     * @param string|null $php_my_admin_domain php_my_admin_domain
     *
     * @return self
     */
    public function setPhpMyAdminDomain($php_my_admin_domain)
    {
        if (is_null($php_my_admin_domain)) {
            throw new \InvalidArgumentException('non-nullable php_my_admin_domain cannot be null');
        }
        $this->container['php_my_admin_domain'] = $php_my_admin_domain;

        return $this;
    }

    /**
     * Gets roundcube_domain
     *
     * @return string|null
     */
    public function getRoundcubeDomain()
    {
        return $this->container['roundcube_domain'];
    }

    /**
     * Sets roundcube_domain
     *
     * @param string|null $roundcube_domain roundcube_domain
     *
     * @return self
     */
    public function setRoundcubeDomain($roundcube_domain)
    {
        if (is_null($roundcube_domain)) {
            throw new \InvalidArgumentException('non-nullable roundcube_domain cannot be null');
        }
        $this->container['roundcube_domain'] = $roundcube_domain;

        return $this;
    }

    /**
     * Gets logo_path
     *
     * @return string|null
     */
    public function getLogoPath()
    {
        return $this->container['logo_path'];
    }

    /**
     * Sets logo_path
     *
     * @param string|null $logo_path logo_path
     *
     * @return self
     */
    public function setLogoPath($logo_path)
    {
        if (is_null($logo_path)) {
            throw new \InvalidArgumentException('non-nullable logo_path cannot be null');
        }
        $this->container['logo_path'] = $logo_path;

        return $this;
    }

    /**
     * Gets inverse_logo_path
     *
     * @return string|null
     */
    public function getInverseLogoPath()
    {
        return $this->container['inverse_logo_path'];
    }

    /**
     * Sets inverse_logo_path
     *
     * @param string|null $inverse_logo_path inverse_logo_path
     *
     * @return self
     */
    public function setInverseLogoPath($inverse_logo_path)
    {
        if (is_null($inverse_logo_path)) {
            throw new \InvalidArgumentException('non-nullable inverse_logo_path cannot be null');
        }
        $this->container['inverse_logo_path'] = $inverse_logo_path;

        return $this;
    }

    /**
     * Gets inverse_icon_path
     *
     * @return string|null
     */
    public function getInverseIconPath()
    {
        return $this->container['inverse_icon_path'];
    }

    /**
     * Sets inverse_icon_path
     *
     * @param string|null $inverse_icon_path inverse_icon_path
     *
     * @return self
     */
    public function setInverseIconPath($inverse_icon_path)
    {
        if (is_null($inverse_icon_path)) {
            throw new \InvalidArgumentException('non-nullable inverse_icon_path cannot be null');
        }
        $this->container['inverse_icon_path'] = $inverse_icon_path;

        return $this;
    }

    /**
     * Gets login_image_path
     *
     * @return string|null
     */
    public function getLoginImagePath()
    {
        return $this->container['login_image_path'];
    }

    /**
     * Sets login_image_path
     *
     * @param string|null $login_image_path login_image_path
     *
     * @return self
     */
    public function setLoginImagePath($login_image_path)
    {
        if (is_null($login_image_path)) {
            throw new \InvalidArgumentException('non-nullable login_image_path cannot be null');
        }
        $this->container['login_image_path'] = $login_image_path;

        return $this;
    }

    /**
     * Gets favicon_path
     *
     * @return string|null
     */
    public function getFaviconPath()
    {
        return $this->container['favicon_path'];
    }

    /**
     * Sets favicon_path
     *
     * @param string|null $favicon_path favicon_path
     *
     * @return self
     */
    public function setFaviconPath($favicon_path)
    {
        if (is_null($favicon_path)) {
            throw new \InvalidArgumentException('non-nullable favicon_path cannot be null');
        }
        $this->container['favicon_path'] = $favicon_path;

        return $this;
    }

    /**
     * Gets name_servers
     *
     * @return string[]|null
     */
    public function getNameServers()
    {
        return $this->container['name_servers'];
    }

    /**
     * Sets name_servers
     *
     * @param string[]|null $name_servers name_servers
     *
     * @return self
     */
    public function setNameServers($name_servers)
    {
        if (is_null($name_servers)) {
            throw new \InvalidArgumentException('non-nullable name_servers cannot be null');
        }
        $this->container['name_servers'] = $name_servers;

        return $this;
    }

    /**
     * Gets settings
     *
     * @return \OpenAPI\Client\Model\Setting[]
     */
    public function getSettings()
    {
        return $this->container['settings'];
    }

    /**
     * Sets settings
     *
     * @param \OpenAPI\Client\Model\Setting[] $settings settings
     *
     * @return self
     */
    public function setSettings($settings)
    {
        if (is_null($settings)) {
            throw new \InvalidArgumentException('non-nullable settings cannot be null');
        }
        $this->container['settings'] = $settings;

        return $this;
    }

    /**
     * Gets staging_domain
     *
     * @return string|null
     */
    public function getStagingDomain()
    {
        return $this->container['staging_domain'];
    }

    /**
     * Sets staging_domain
     *
     * @param string|null $staging_domain staging_domain
     *
     * @return self
     */
    public function setStagingDomain($staging_domain)
    {
        if (is_null($staging_domain)) {
            throw new \InvalidArgumentException('non-nullable staging_domain cannot be null');
        }
        $this->container['staging_domain'] = $staging_domain;

        return $this;
    }

    /**
     * Gets locale
     *
     * @return \OpenAPI\Client\Model\CPLocale
     */
    public function getLocale()
    {
        return $this->container['locale'];
    }

    /**
     * Sets locale
     *
     * @param \OpenAPI\Client\Model\CPLocale $locale locale
     *
     * @return self
     */
    public function setLocale($locale)
    {
        if (is_null($locale)) {
            throw new \InvalidArgumentException('non-nullable locale cannot be null');
        }
        $this->container['locale'] = $locale;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


