<?php

if (! defined('BASEPATH')) {
    exit('No direct script access allowed.');
}

/**
 * This source file is part of the open source project
 * ExpressionEngine (https://expressionengine.com)
 *
 * @link      https://expressionengine.com/
 * @copyright Copyright (c) 2003-2023, Packet Tide, LLC (https://www.packettide.com)
 * @license   https://expressionengine.com/license Licensed under Apache License, Version 2.0
 */

/**
 * Email Helpers
 */

/**
 * Validate email address
 *
 * @access	public
 * @return	bool
 */
if (! function_exists('valid_email')) {
    function valid_email($address)
    {
        return (bool) filter_var($address, FILTER_VALIDATE_EMAIL);
    }
}

/**
 * Send an email
 *
 * @access	public
 * @return	bool
 */
if (! function_exists('send_email')) {
    function send_email($recipient, $subject = 'Test email', $message = 'Hello World')
    {
        return mail($recipient, $subject, $message);
    }
}

// EOF
