
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `elgg3325`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]access_collections`
--

CREATE TABLE `[[dbprefix]]access_collections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `owner_guid` int(20) unsigned NOT NULL,
  `subtype` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `owner_guid` (`owner_guid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]access_collections`
--

INSERT INTO `[[dbprefix]]access_collections` VALUES
(3, 'friends', 49, 'friends');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]access_collection_membership`
--

CREATE TABLE `[[dbprefix]]access_collection_membership` (
  `user_guid` int(20) unsigned NOT NULL,
  `access_collection_id` int(11) NOT NULL,
  PRIMARY KEY (`user_guid`,`access_collection_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]annotations`
--

CREATE TABLE `[[dbprefix]]annotations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `entity_guid` int(20) unsigned NOT NULL,
  `name` text NOT NULL,
  `value` longtext NOT NULL,
  `value_type` enum('integer','text') NOT NULL,
  `owner_guid` int(20) unsigned NOT NULL,
  `access_id` int(11) NOT NULL,
  `time_created` int(11) NOT NULL,
  `enabled` enum('yes','no') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`id`),
  KEY `entity_guid` (`entity_guid`),
  KEY `name` (`name`(50)),
  KEY `value` (`value`(50)),
  KEY `owner_guid` (`owner_guid`),
  KEY `access_id` (`access_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]api_users`
--

CREATE TABLE `[[dbprefix]]api_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `api_key` varchar(40) DEFAULT NULL,
  `secret` varchar(40) NOT NULL,
  `active` int(11) DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `api_key` (`api_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config`
--

CREATE TABLE `[[dbprefix]]config` (
  `name` varchar(255) CHARACTER SET utf8 NOT NULL,
  `value` longtext NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `[[dbprefix]]config`
--

INSERT INTO `[[dbprefix]]config` VALUES
('admin_registered', 'i:1;'),
('allow_registration', 'b:0;'),
('allow_user_default_access', 's:0:"";'),
('default_access', 's:1:"2";'),
('default_limit', 'i:10;'),
('installed', 'i:[[timestamp]];'),
('language', 's:2:"en";'),
('lastcache', 'i:[[timestamp]];'),
('processed_upgrades', 'a:0:{}'),
('require_admin_validation', 'b:0;'),
('security_email_require_confirmation', 'b:1;'),
('security_email_require_password', 'b:1;'),
('security_notify_admins', 'b:1;'),
('security_notify_user_password', 'b:1;'),
('security_protect_upgrade', 'b:1;'),
('simplecache_enabled', 'i:1;'),
('simplecache_lastupdate', 'i:[[timestamp]];'),
('simplecache_minify_css', 'b:1;'),
('simplecache_minify_js', 'b:1;'),
('system_cache_enabled', 'i:1;'),
('version', 'i:2017041200;'),
('walled_garden', 'b:0;'),
('__site_secret__', 's:32:"[[site_secret]]";');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]entities`
--

CREATE TABLE `[[dbprefix]]entities` (
  `guid` int(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('object','user','group','site') NOT NULL,
  `subtype` varchar(252) CHARACTER SET utf8 NOT NULL,
  `owner_guid` int(20) unsigned NOT NULL,
  `container_guid` int(20) unsigned NOT NULL,
  `access_id` int(11) NOT NULL,
  `time_created` int(11) NOT NULL,
  `time_updated` int(11) NOT NULL,
  `last_action` int(11) NOT NULL DEFAULT '0',
  `enabled` enum('yes','no') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`guid`),
  KEY `type` (`type`),
  KEY `owner_guid` (`owner_guid`),
  KEY `container_guid` (`container_guid`),
  KEY `access_id` (`access_id`),
  KEY `time_created` (`time_created`),
  KEY `time_updated` (`time_updated`),
  KEY `subtype` (`subtype`),
  KEY `type_subtype` (`type`,`subtype`(50)),
  KEY `type_subtype_owner` (`type`,`subtype`(50),`owner_guid`),
  KEY `type_subtype_container` (`type`,`subtype`(50),`container_guid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=56 ;

--
-- Dumping data for table `[[dbprefix]]entities`
--

INSERT INTO `[[dbprefix]]entities` VALUES
(1, 'site', 'site', 0, 0, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(2, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(3, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(4, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(5, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(6, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(7, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(8, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(9, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(10, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(11, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(12, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(13, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(14, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(15, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(16, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(17, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(18, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(19, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(20, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(21, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(22, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(23, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(24, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(25, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(26, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(27, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(28, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(29, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(30, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(31, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(32, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(33, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(34, 'object', 'plugin', 1, 1, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(35, 'object', 'elgg_upgrade', 1, 1, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(36, 'object', 'elgg_upgrade', 1, 1, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(37, 'object', 'elgg_upgrade', 1, 1, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(38, 'object', 'elgg_upgrade', 1, 1, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(39, 'object', 'elgg_upgrade', 1, 1, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(40, 'object', 'elgg_upgrade', 1, 1, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(41, 'object', 'elgg_upgrade', 1, 1, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(42, 'object', 'elgg_upgrade', 1, 1, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(43, 'object', 'elgg_upgrade', 1, 1, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(44, 'object', 'elgg_upgrade', 1, 1, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(45, 'object', 'elgg_upgrade', 1, 1, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(46, 'object', 'elgg_upgrade', 1, 1, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(47, 'object', 'elgg_upgrade', 1, 1, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(48, 'object', 'elgg_upgrade', 1, 1, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(49, 'user', 'user', 0, 0, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(50, 'object', 'widget', 49, 49, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(51, 'object', 'widget', 49, 49, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(52, 'object', 'widget', 49, 49, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(53, 'object', 'widget', 49, 49, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(54, 'object', 'widget', 49, 49, 2, [[timestamp]], [[timestamp]], [[timestamp]], 'yes'),
(55, 'object', 'admin_notice', 0, 0, 0, [[timestamp]], [[timestamp]], [[timestamp]], 'yes');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]entity_relationships`
--

CREATE TABLE `[[dbprefix]]entity_relationships` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `guid_one` int(20) unsigned NOT NULL,
  `relationship` varchar(50) NOT NULL,
  `guid_two` int(20) unsigned NOT NULL,
  `time_created` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `guid_one` (`guid_one`,`relationship`,`guid_two`),
  KEY `relationship` (`relationship`),
  KEY `guid_two` (`guid_two`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=25 ;

--
-- Dumping data for table `[[dbprefix]]entity_relationships`
--

INSERT INTO `[[dbprefix]]entity_relationships` VALUES
(1, 2, 'active_plugin', 1, [[timestamp]]),
(2, 3, 'active_plugin', 1, [[timestamp]]),
(3, 4, 'active_plugin', 1, [[timestamp]]),
(4, 5, 'active_plugin', 1, [[timestamp]]),
(5, 10, 'active_plugin', 1, [[timestamp]]),
(6, 11, 'active_plugin', 1, [[timestamp]]),
(7, 13, 'active_plugin', 1, [[timestamp]]),
(8, 14, 'active_plugin', 1, [[timestamp]]),
(9, 15, 'active_plugin', 1, [[timestamp]]),
(10, 16, 'active_plugin', 1, [[timestamp]]),
(11, 17, 'active_plugin', 1, [[timestamp]]),
(12, 18, 'active_plugin', 1, [[timestamp]]),
(13, 19, 'active_plugin', 1, [[timestamp]]),
(14, 21, 'active_plugin', 1, [[timestamp]]),
(15, 22, 'active_plugin', 1, [[timestamp]]),
(16, 23, 'active_plugin', 1, [[timestamp]]),
(17, 24, 'active_plugin', 1, [[timestamp]]),
(18, 25, 'active_plugin', 1, [[timestamp]]),
(19, 26, 'active_plugin', 1, [[timestamp]]),
(20, 27, 'active_plugin', 1, [[timestamp]]),
(21, 28, 'active_plugin', 1, [[timestamp]]),
(22, 30, 'active_plugin', 1, [[timestamp]]),
(23, 32, 'active_plugin', 1, [[timestamp]]),
(24, 33, 'active_plugin', 1, [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]hmac_cache`
--

CREATE TABLE `[[dbprefix]]hmac_cache` (
  `hmac` varchar(255) CHARACTER SET utf8 NOT NULL,
  `ts` int(11) NOT NULL,
  PRIMARY KEY (`hmac`),
  KEY `ts` (`ts`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]metadata`
--

CREATE TABLE `[[dbprefix]]metadata` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `entity_guid` int(20) unsigned NOT NULL,
  `name` text NOT NULL,
  `value` longtext NOT NULL,
  `value_type` enum('integer','text') NOT NULL,
  `owner_guid` int(11) DEFAULT NULL,
  `access_id` int(11) DEFAULT NULL,
  `time_created` int(11) NOT NULL,
  `enabled` enum('yes','no') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`id`),
  KEY `entity_guid` (`entity_guid`),
  KEY `name` (`name`(50)),
  KEY `value` (`value`(50))
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=51 ;

--
-- Dumping data for table `[[dbprefix]]metadata`
--

INSERT INTO `[[dbprefix]]metadata` VALUES
(1, 1, 'name', '[[site_name]]', 'text', NULL, NULL, [[timestamp]], 'yes'),
(2, 1, 'email', '[[site_email]]', 'text', NULL, NULL, [[timestamp]], 'yes'),
(3, 2, 'title', 'activity', 'text', NULL, NULL, [[timestamp]], 'yes'),
(4, 3, 'title', 'blog', 'text', NULL, NULL, [[timestamp]], 'yes'),
(5, 4, 'title', 'bookmarks', 'text', NULL, NULL, [[timestamp]], 'yes'),
(6, 5, 'title', 'ckeditor', 'text', NULL, NULL, [[timestamp]], 'yes'),
(7, 6, 'title', 'custom_index', 'text', NULL, NULL, [[timestamp]], 'yes'),
(8, 7, 'title', 'dashboard', 'text', NULL, NULL, [[timestamp]], 'yes'),
(9, 8, 'title', 'developers', 'text', NULL, NULL, [[timestamp]], 'yes'),
(10, 9, 'title', 'diagnostics', 'text', NULL, NULL, [[timestamp]], 'yes'),
(11, 10, 'title', 'discussions', 'text', NULL, NULL, [[timestamp]], 'yes'),
(12, 11, 'title', 'embed', 'text', NULL, NULL, [[timestamp]], 'yes'),
(13, 12, 'title', 'externalpages', 'text', NULL, NULL, [[timestamp]], 'yes'),
(14, 13, 'title', 'file', 'text', NULL, NULL, [[timestamp]], 'yes'),
(15, 14, 'title', 'friends', 'text', NULL, NULL, [[timestamp]], 'yes'),
(16, 15, 'title', 'friends_collections', 'text', NULL, NULL, [[timestamp]], 'yes'),
(17, 16, 'title', 'garbagecollector', 'text', NULL, NULL, [[timestamp]], 'yes'),
(18, 17, 'title', 'groups', 'text', NULL, NULL, [[timestamp]], 'yes'),
(19, 18, 'title', 'invitefriends', 'text', NULL, NULL, [[timestamp]], 'yes'),
(20, 19, 'title', 'likes', 'text', NULL, NULL, [[timestamp]], 'yes'),
(21, 20, 'title', 'login_as', 'text', NULL, NULL, [[timestamp]], 'yes'),
(22, 21, 'title', 'members', 'text', NULL, NULL, [[timestamp]], 'yes'),
(23, 22, 'title', 'messageboard', 'text', NULL, NULL, [[timestamp]], 'yes'),
(24, 23, 'title', 'messages', 'text', NULL, NULL, [[timestamp]], 'yes'),
(25, 24, 'title', 'notifications', 'text', NULL, NULL, [[timestamp]], 'yes'),
(26, 25, 'title', 'pages', 'text', NULL, NULL, [[timestamp]], 'yes'),
(27, 26, 'title', 'profile', 'text', NULL, NULL, [[timestamp]], 'yes'),
(28, 27, 'title', 'reportedcontent', 'text', NULL, NULL, [[timestamp]], 'yes'),
(29, 28, 'title', 'search', 'text', NULL, NULL, [[timestamp]], 'yes'),
(30, 29, 'title', 'site_notifications', 'text', NULL, NULL, [[timestamp]], 'yes'),
(31, 30, 'title', 'system_log', 'text', NULL, NULL, [[timestamp]], 'yes'),
(32, 31, 'title', 'tagcloud', 'text', NULL, NULL, [[timestamp]], 'yes'),
(33, 32, 'title', 'thewire', 'text', NULL, NULL, [[timestamp]], 'yes'),
(34, 33, 'title', 'uservalidationbyemail', 'text', NULL, NULL, [[timestamp]], 'yes'),
(35, 34, 'title', 'web_services', 'text', NULL, NULL, [[timestamp]], 'yes'),
(36, 49, 'banned', 'no', 'text', NULL, NULL, [[timestamp]], 'yes'),
(37, 49, 'admin', 'yes', 'text', NULL, NULL, [[timestamp]], 'yes'),
(38, 49, 'language', '[[language]]', 'text', NULL, NULL, [[timestamp]], 'yes'),
(39, 49, 'prev_last_action', '0', 'integer', NULL, NULL, [[timestamp]], 'yes'),
(40, 49, 'last_login', '[[timestamp]]', 'integer', NULL, NULL, [[timestamp]], 'yes'),
(41, 49, 'prev_last_login', '0', 'integer', NULL, NULL, [[timestamp]], 'yes'),
(42, 49, 'username', '[[admin_username]]', 'text', NULL, NULL, [[timestamp]], 'yes'),
(43, 49, 'email', '[[admin_email]]', 'text', NULL, NULL, [[timestamp]], 'yes'),
(44, 49, 'name', '[[admin_realname]]', 'text', NULL, NULL, [[timestamp]], 'yes'),
(45, 49, 'password_hash', '[[admin_pass]]', 'text', NULL, NULL, [[timestamp]], 'yes'),
(46, 49, 'notification:method:email', '1', 'integer', NULL, NULL, [[timestamp]], 'yes'),
(47, 49, 'validated', '1', 'integer', NULL, NULL, [[timestamp]], 'yes'),
(48, 49, 'validated_method', 'admin_user', 'text', NULL, NULL, [[timestamp]], 'yes'),
(49, 55, 'admin_notice_id', 'fresh_install', 'text', NULL, NULL, [[timestamp]], 'yes'),
(50, 55, 'description', '[[site_desc]] For more options, see the <a href="[[softurl]]/admin/site_settings">settings pages</a>.', 'text', NULL, NULL, [[timestamp]], 'yes');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]migrations`
--

CREATE TABLE `[[dbprefix]]migrations` (
  `version` bigint(20) NOT NULL,
  `migration_name` varchar(100) DEFAULT NULL,
  `start_time` timestamp NULL DEFAULT NULL,
  `end_time` timestamp NULL DEFAULT NULL,
  `breakpoint` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`version`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]migrations`
--

INSERT INTO `[[dbprefix]]migrations` VALUES
(20170728010000, 'RemoveSiteGuid', '[[regtime]]', '[[regtime]]', 0),
(20170728020000, 'MigrateDatalistsToConfig', '[[regtime]]', '[[regtime]]', 0),
(20170728030000, 'DenormalizeMetastrings', '[[regtime]]', '[[regtime]]', 0),
(20170728040000, 'ChangeTableEngine', '[[regtime]]', '[[regtime]]', 0),
(20170728050000, 'ExpandTextColumnsToLongtext', '[[regtime]]', '[[regtime]]', 0),
(20170728060000, 'RemoveLegacyPasswordHashes', '[[regtime]]', '[[regtime]]', 0),
(20170728072548, 'CreateAccessCollectionsTable', '[[regtime]]', '[[regtime]]', 0),
(20170728073540, 'CreateAccessCollectionMembershipTable', '[[regtime]]', '[[regtime]]', 0),
(20170728073706, 'CreateAnnotationsTable', '[[regtime]]', '[[regtime]]', 0),
(20170728074504, 'CreateApiUsersTable', '[[regtime]]', '[[regtime]]', 0),
(20170728074600, 'CreateEntitiesTable', '[[regtime]]', '[[regtime]]', 0),
(20170728074645, 'CreateEntityRelationshipsTable', '[[regtime]]', '[[regtime]]', 0),
(20170728074729, 'CreateEntitySubtypesTable', '[[regtime]]', '[[regtime]]', 0),
(20170728074757, 'CreateGeoCacheTable', '[[regtime]]', '[[regtime]]', 0),
(20170728074828, 'CreateGroupsEntityTable', '[[regtime]]', '[[regtime]]', 0),
(20170728074857, 'CreateHmacCacheTable', '[[regtime]]', '[[regtime]]', 0),
(20170728074925, 'CreateMetadataTable', '[[regtime]]', '[[regtime]]', 0),
(20170728074959, 'CreateObjectsEntityTable', '[[regtime]]', '[[regtime]]', 0),
(20170728075027, 'CreatePrivateSettingsTable', '[[regtime]]', '[[regtime]]', 0),
(20170728075056, 'CreateQueueTable', '[[regtime]]', '[[regtime]]', 0),
(20170728075129, 'CreateRiverTable', '[[regtime]]', '[[regtime]]', 0),
(20170728075155, 'CreateSitesEntityTable', '[[regtime]]', '[[regtime]]', 0),
(20170728075232, 'CreateSystemLogTable', '[[regtime]]', '[[regtime]]', 0),
(20170728075306, 'CreateUsersApiSessionsTable', '[[regtime]]', '[[regtime]]', 0),
(20170728075337, 'CreateUsersEntityTable', '[[regtime]]', '[[regtime]]', 0),
(20170728075418, 'CreateUsersRememberMeCookiesTable', '[[regtime]]', '[[regtime]]', 0),
(20170728075454, 'CreateUsersSessionsTable', '[[regtime]]', '[[regtime]]', 0),
(20170728075716, 'CreateConfigTable', '[[regtime]]', '[[regtime]]', 0),
(20170808084728, 'DropGeocodeCache', '[[regtime]]', '[[regtime]]', 0),
(20171006111953, 'DropSitesEntityTable', '[[regtime]]', '[[regtime]]', 0),
(20171006131622, 'DropGroupsEntityTable', '[[regtime]]', '[[regtime]]', 0),
(20171009115032, 'DropObjectsEntityTable', '[[regtime]]', '[[regtime]]', 0),
(20171010095648, 'DropUsersEntityTable', '[[regtime]]', '[[regtime]]', 0),
(20171016113827, 'UpdateMetadataColumns', '[[regtime]]', '[[regtime]]', 0),
(20171021111005, 'AddSubtypeIndexToRiverTable', '[[regtime]]', '[[regtime]]', 0),
(20171021111059, 'DenormalizeEntitySubtypes', '[[regtime]]', '[[regtime]]', 0),
(20171021111132, 'AlignSubtypeColumns', '[[regtime]]', '[[regtime]]', 0),
(20171106100916, 'AddAclSubtype', '[[regtime]]', '[[regtime]]', 0),
(20180109135052, 'DropTypeSubtypeFromRiverTable', '[[regtime]]', '[[regtime]]', 0),
(20180609152817, 'CreateSiteSecret', '[[regtime]]', '[[regtime]]', 0),
(20181107091651, 'AddEntitiesSubtypeIndex', '[[regtime]]', '[[regtime]]', 0),
(20190125082345, 'EntitiesAddTypeSubtypeIndex', '[[regtime]]', '[[regtime]]', 0),
(20190606111641, 'EntitiesAddTypeSubtypeContainerAndOwnerIndexes', '[[regtime]]', '[[regtime]]', 0),
(20191015125417, 'SetRiverEnabledToYes', '[[regtime]]', '[[regtime]]', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]private_settings`
--

CREATE TABLE `[[dbprefix]]private_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `entity_guid` int(20) unsigned NOT NULL,
  `name` varchar(128) NOT NULL,
  `value` longtext NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `entity_guid` (`entity_guid`,`name`),
  KEY `name` (`name`),
  KEY `value` (`value`(50))
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=166 ;

--
-- Dumping data for table `[[dbprefix]]private_settings`
--

INSERT INTO `[[dbprefix]]private_settings` VALUES
(1, 2, 'elgg:internal:priority', '2'),
(2, 3, 'elgg:internal:priority', '3'),
(3, 4, 'elgg:internal:priority', '4'),
(4, 5, 'elgg:internal:priority', '5'),
(5, 6, 'elgg:internal:priority', '6'),
(6, 7, 'elgg:internal:priority', '7'),
(7, 8, 'elgg:internal:priority', '8'),
(8, 9, 'elgg:internal:priority', '9'),
(9, 10, 'elgg:internal:priority', '10'),
(10, 11, 'elgg:internal:priority', '11'),
(11, 12, 'elgg:internal:priority', '12'),
(12, 13, 'elgg:internal:priority', '13'),
(13, 14, 'elgg:internal:priority', '14'),
(14, 15, 'elgg:internal:priority', '15'),
(15, 16, 'elgg:internal:priority', '16'),
(16, 17, 'elgg:internal:priority', '17'),
(17, 18, 'elgg:internal:priority', '18'),
(18, 19, 'elgg:internal:priority', '19'),
(19, 20, 'elgg:internal:priority', '20'),
(20, 21, 'elgg:internal:priority', '21'),
(21, 22, 'elgg:internal:priority', '22'),
(22, 23, 'elgg:internal:priority', '23'),
(23, 24, 'elgg:internal:priority', '24'),
(24, 25, 'elgg:internal:priority', '25'),
(25, 26, 'elgg:internal:priority', '26'),
(26, 27, 'elgg:internal:priority', '27'),
(27, 28, 'elgg:internal:priority', '28'),
(28, 29, 'elgg:internal:priority', '29'),
(29, 30, 'elgg:internal:priority', '30'),
(30, 31, 'elgg:internal:priority', '31'),
(31, 32, 'elgg:internal:priority', '32'),
(32, 33, 'elgg:internal:priority', '33'),
(33, 34, 'elgg:internal:priority', '34'),
(34, 35, 'id', 'core:2018041801'),
(35, 35, 'class', 'Elgg\\Upgrades\\DeleteOldPlugins'),
(36, 35, 'title', 'core:upgrade:2018041801:title'),
(37, 35, 'description', 'core:upgrade:2018041801:description'),
(38, 35, 'offset', '0'),
(39, 35, 'is_completed', '1'),
(40, 36, 'id', 'core:2018041800'),
(41, 36, 'class', 'Elgg\\Upgrades\\ActivateNewPlugins'),
(42, 36, 'title', 'core:upgrade:2018041800:title'),
(43, 36, 'description', 'core:upgrade:2018041800:description'),
(44, 36, 'offset', '0'),
(45, 36, 'is_completed', '1'),
(46, 37, 'id', 'core:2017080900'),
(47, 37, 'class', 'Elgg\\Upgrades\\AlterDatabaseToMultiByteCharset'),
(48, 37, 'title', 'core:upgrade:2017080900:title'),
(49, 37, 'description', 'core:upgrade:2017080900:description'),
(50, 37, 'offset', '0'),
(51, 37, 'is_completed', '1'),
(52, 38, 'id', 'core:2017080950'),
(53, 38, 'class', 'Elgg\\Upgrades\\SetSecurityConfigDefaults'),
(54, 38, 'title', 'core:upgrade:2017080950:title'),
(55, 38, 'description', 'core:upgrade:2017080950:description'),
(56, 38, 'offset', '0'),
(57, 38, 'is_completed', '1'),
(58, 39, 'id', 'core:2017121200'),
(59, 39, 'class', 'Elgg\\Upgrades\\MigrateFriendsACL'),
(60, 39, 'title', 'core:upgrade:2017121200:title'),
(61, 39, 'description', 'core:upgrade:2017121200:description'),
(62, 39, 'offset', '0'),
(63, 39, 'is_completed', '1'),
(64, 40, 'id', 'core:2018061401'),
(65, 40, 'class', 'Elgg\\Upgrades\\MigrateCronLog'),
(66, 40, 'title', 'core:upgrade:2018061401:title'),
(67, 40, 'description', 'core:upgrade:2018061401:description'),
(68, 40, 'offset', '0'),
(69, 40, 'is_completed', '1'),
(70, 41, 'id', 'core:2019071901'),
(71, 41, 'class', 'Elgg\\Upgrades\\SecurityEmailChangeConfirmation'),
(72, 41, 'title', 'core:upgrade:2019071901:title'),
(73, 41, 'description', 'core:upgrade:2019071901:description'),
(74, 41, 'offset', '0'),
(75, 41, 'is_completed', '1'),
(76, 42, 'id', 'discussions:2017112800'),
(77, 42, 'class', '\\Elgg\\Discussions\\Upgrades\\MigrateDiscussionReply'),
(78, 42, 'title', 'discussions:upgrade:2017112800:title'),
(79, 42, 'description', 'discussions:upgrade:2017112800:description'),
(80, 42, 'offset', '0'),
(81, 42, 'is_completed', '1'),
(82, 43, 'id', 'discussions:2017112801'),
(83, 43, 'class', '\\Elgg\\Discussions\\Upgrades\\MigrateDiscussionReplyRiver'),
(84, 43, 'title', 'discussions:upgrade:2017112801:title'),
(85, 43, 'description', 'discussions:upgrade:2017112801:description'),
(86, 43, 'offset', '0'),
(87, 43, 'is_completed', '1'),
(88, 44, 'id', 'groups:2016101900'),
(89, 44, 'class', 'Elgg\\Groups\\Upgrades\\GroupIconTransfer'),
(90, 44, 'title', 'groups:upgrade:2016101900:title'),
(91, 44, 'description', 'groups:upgrade:2016101900:description'),
(92, 44, 'offset', '0'),
(93, 44, 'is_completed', '1'),
(94, 45, 'id', 'likes:2017120700'),
(95, 45, 'class', '\\Elgg\\Likes\\Upgrades\\PublicLikesAnnotations'),
(96, 45, 'title', 'likes:upgrade:2017120700:title'),
(97, 45, 'description', 'likes:upgrade:2017120700:description'),
(98, 45, 'offset', '0'),
(99, 45, 'is_completed', '1'),
(100, 46, 'id', 'pages:2017110700'),
(101, 46, 'class', '\\Elgg\\Pages\\Upgrades\\MigratePageTop'),
(102, 46, 'title', 'pages:upgrade:2017110700:title'),
(103, 46, 'description', 'pages:upgrade:2017110700:description'),
(104, 46, 'offset', '0'),
(105, 46, 'is_completed', '1'),
(106, 47, 'id', 'profile:2017040700'),
(107, 47, 'class', 'ElggPlugin\\Profile\\AnnotationMigration'),
(108, 47, 'title', 'profile:upgrade:2017040700:title'),
(109, 47, 'description', 'profile:upgrade:2017040700:description'),
(110, 47, 'offset', '0'),
(111, 47, 'is_completed', '1'),
(112, 48, 'id', 'uservalidationbyemail:2019090600'),
(113, 48, 'class', 'Elgg\\UserValidationByEmail\\Upgrades\\TrackValidationStatus'),
(114, 48, 'title', 'uservalidationbyemail:upgrade:2019090600:title'),
(115, 48, 'description', 'uservalidationbyemail:upgrade:2019090600:description'),
(116, 48, 'offset', '0'),
(117, 48, 'is_completed', '1'),
(118, 35, 'start_time', '[[timestamp]]'),
(119, 35, 'completed_time', '[[timestamp]]'),
(120, 36, 'start_time', '[[timestamp]]'),
(121, 36, 'completed_time', '[[timestamp]]'),
(122, 37, 'start_time', '[[timestamp]]'),
(123, 37, 'completed_time', '[[timestamp]]'),
(124, 38, 'start_time', '[[timestamp]]'),
(125, 38, 'completed_time', '[[timestamp]]'),
(126, 39, 'start_time', '[[timestamp]]'),
(127, 39, 'completed_time', '[[timestamp]]'),
(128, 40, 'start_time', '[[timestamp]]'),
(129, 40, 'completed_time', '[[timestamp]]'),
(130, 41, 'start_time', '[[timestamp]]'),
(131, 41, 'completed_time', '[[timestamp]]'),
(132, 42, 'start_time', '[[timestamp]]'),
(133, 42, 'completed_time', '[[timestamp]]'),
(134, 43, 'start_time', '[[timestamp]]'),
(135, 43, 'completed_time', '[[timestamp]]'),
(136, 44, 'start_time', '[[timestamp]]'),
(137, 44, 'completed_time', '[[timestamp]]'),
(138, 45, 'start_time', '[[timestamp]]'),
(139, 45, 'completed_time', '[[timestamp]]'),
(140, 46, 'start_time', '[[timestamp]]'),
(141, 46, 'completed_time', '[[timestamp]]'),
(142, 47, 'start_time', '[[timestamp]]'),
(143, 47, 'completed_time', '[[timestamp]]'),
(144, 48, 'start_time', '[[timestamp]]'),
(145, 48, 'completed_time', '[[timestamp]]'),
(146, 50, 'handler', 'control_panel'),
(147, 50, 'context', 'admin'),
(148, 50, 'column', '1'),
(149, 50, 'order', '0'),
(150, 51, 'handler', 'admin_welcome'),
(151, 51, 'context', 'admin'),
(152, 51, 'order', '10'),
(153, 51, 'column', '1'),
(154, 52, 'handler', 'online_users'),
(155, 52, 'context', 'admin'),
(156, 52, 'column', '2'),
(157, 52, 'order', '0'),
(158, 53, 'handler', 'new_users'),
(159, 53, 'context', 'admin'),
(160, 53, 'order', '10'),
(161, 53, 'column', '2'),
(162, 54, 'handler', 'content_stats'),
(163, 54, 'context', 'admin'),
(164, 54, 'order', '20'),
(165, 54, 'column', '2');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]queue`
--

CREATE TABLE `[[dbprefix]]queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8 NOT NULL,
  `data` mediumblob NOT NULL,
  `timestamp` int(11) NOT NULL,
  `worker` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `retrieve` (`timestamp`,`worker`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]queue`
--

INSERT INTO `[[dbprefix]]queue` VALUES
(1, 'notifications', 'C:48:"Elgg\\Notifications\\SubscriptionNotificationEvent":134:{O:8:"stdClass":4:{s:6:"action";s:10:"make_admin";s:9:"object_id";i:49;s:11:"object_type";s:4:"user";s:14:"object_subtype";s:4:"user";}}', [[timestamp]], NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]river`
--

CREATE TABLE `[[dbprefix]]river` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `action_type` varchar(32) NOT NULL,
  `view` text NOT NULL,
  `subject_guid` int(20) unsigned NOT NULL,
  `object_guid` int(20) unsigned NOT NULL,
  `target_guid` int(20) unsigned NOT NULL,
  `annotation_id` int(11) NOT NULL,
  `posted` int(11) NOT NULL,
  `enabled` enum('yes','no') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`id`),
  KEY `action_type` (`action_type`),
  KEY `subject_guid` (`subject_guid`),
  KEY `object_guid` (`object_guid`),
  KEY `target_guid` (`target_guid`),
  KEY `annotation_id` (`annotation_id`),
  KEY `posted` (`posted`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]system_log`
--

CREATE TABLE `[[dbprefix]]system_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_id` int(11) NOT NULL,
  `object_class` varchar(50) NOT NULL,
  `object_type` varchar(50) NOT NULL,
  `object_subtype` varchar(252) CHARACTER SET utf8 NOT NULL,
  `event` varchar(50) NOT NULL,
  `performed_by_guid` int(20) unsigned NOT NULL,
  `owner_guid` int(20) unsigned NOT NULL,
  `access_id` int(11) NOT NULL,
  `enabled` enum('yes','no') NOT NULL DEFAULT 'yes',
  `time_created` int(11) NOT NULL,
  `ip_address` varchar(46) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `object_id` (`object_id`),
  KEY `object_class` (`object_class`),
  KEY `object_type` (`object_type`),
  KEY `object_subtype` (`object_subtype`),
  KEY `event` (`event`),
  KEY `performed_by_guid` (`performed_by_guid`),
  KEY `access_id` (`access_id`),
  KEY `time_created` (`time_created`),
  KEY `river_key` (`object_type`,`object_subtype`,`event`(25))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users_apisessions`
--

CREATE TABLE `[[dbprefix]]users_apisessions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_guid` int(20) unsigned NOT NULL,
  `token` varchar(40) DEFAULT NULL,
  `expires` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_guid` (`user_guid`),
  KEY `token` (`token`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users_remember_me_cookies`
--

CREATE TABLE `[[dbprefix]]users_remember_me_cookies` (
  `code` varchar(32) NOT NULL,
  `guid` int(20) unsigned NOT NULL,
  `timestamp` int(11) unsigned NOT NULL,
  PRIMARY KEY (`code`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users_sessions`
--

CREATE TABLE `[[dbprefix]]users_sessions` (
  `session` varchar(255) CHARACTER SET utf8 NOT NULL,
  `ts` int(11) unsigned NOT NULL DEFAULT '0',
  `data` mediumblob,
  PRIMARY KEY (`session`),
  KEY `ts` (`ts`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `[[dbprefix]]users_sessions`
--


/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
