<?php

/**
 * form.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */



declare(strict_types=1);

return [
    // new user:
    'administration_currency'      => 'Primary currency',
    'bank_name'                    => 'Bankens navn',
    'bank_balance'                 => 'Saldo',
    'current_balance'              => 'Current balance',
    'savings_balance'              => 'Sparesaldo',
    'credit_card_limit'            => 'Kredittkortgrense',
    'automatch'                    => 'Finn automatisk',
    'skip'                         => 'Hopp over',
    'enabled'                      => 'Aktivert',
    'name'                         => 'Navn',
    'active'                       => 'Aktiv',
    'amount_min'                   => 'Minimumsbeløp',
    'amount_max'                   => 'Maksimumsbeløp',
    'match'                        => 'Treff på',
    'strict'                       => 'Streng modus',
    'repeat_freq'                  => 'Gjentas',
    'object_group'                 => 'Gruppe',
    'location'                     => 'Sted',
    'update_channel'               => 'Oppdater kanal',
    'currency_id'                  => 'Valuta',
    'transaction_currency_id'      => 'Valuta',
    'auto_budget_currency_id'      => 'Valuta',
    'external_ip'                  => 'Serverens eksterne IP',
    'attachments'                  => 'Vedlegg',
    'BIC'                          => 'BIC',
    'verify_password'              => 'Bekreft passordsikkerhet',
    'source_account'               => 'Kildekonto',
    'destination_account'          => 'Målkonto',
    'asset_destination_account'    => 'Destinasjonskonto',
    'include_net_worth'            => 'Inkluder i formue',
    'asset_source_account'         => 'Kildekonto',
    'journal_description'          => 'Beskrivelse',
    'note'                         => 'Notater',
    'currency'                     => 'Valuta',
    'account_id'                   => 'Aktivakonto',
    'budget_id'                    => 'Busjett',
    'bill_id'                      => 'Subscription',
    'opening_balance'              => 'Inngående balanse',
    'tag_mode'                      => 'Tag mode',
    'virtual_balance'              => 'Virtuell balanse',



    'targetamount'                 => 'Målbeløp',
    'target_amount'                => 'Target amount',
    'account_role'                 => 'Konto rolle',
    'opening_balance_date'         => 'Dato inngående saldo',
    'cc_type'                      => 'Betalingsplan for kredittkort',
    'cc_monthly_payment_date'      => 'Månedlig betalingsdato for kredittkort',
    'piggy_bank_id'                => 'Sparegris',
    'returnHere'                   => 'Gå tilbake hit',
    'returnHereExplanation'        => 'Gå tilbake hit etter lagring for å legge til på nytt.',
    'returnHereUpdateExplanation'  => 'Gå tilbake hit etter endring.',
    'description'                  => 'Beskrivelse',
    'expense_account'              => 'Utgiftskonto',
    'revenue_account'              => 'Inntektskonto',
    'decimal_places'               => 'Desimaler',
    'destination_amount'           => 'Beløp (destinasjon)',
    'new_email_address'            => 'Ny epostadresse',
    'verification'                 => 'Bekreftelse',
    'api_key'                      => 'API-nøkkel',
    'remember_me'                  => 'Husk meg',
    'liability_type_id'            => 'Gjeldstype',
    'liability_type'               => 'Gjeldstype',
    'interest'                     => 'Rente',
    'interest_period'              => 'Renteperiode',
    'extension_date'               => 'Dato for utsettelse',
    'type'                         => 'Type',
    'convert_Withdrawal'           => 'Konverter uttak',
    'convert_Deposit'              => 'Konverter innskudd',
    'convert_Transfer'             => 'Konverter overføring',
    'amount'                       => 'Beløp',
    'foreign_amount'               => 'Utenlandske beløp',
    'date'                         => 'Dato',
    'interest_date'                => 'Rentedato',
    'book_date'                    => 'Bokføringsdato',
    'process_date'                 => 'Prosesseringsdato',
    'category'                     => 'Kategori',
    'tags'                         => 'Tagger',
    'deletePermanently'            => 'Slett permanent',
    'cancel'                       => 'Avbryt',
    'targetdate'                   => 'Måldato',
    'target_date'                  => 'Target date',
    'startdate'                    => 'Startdato',
    'start_date'                   => 'Start date',
    'tag'                          => 'Tagg',

    // exchange rates
    'from_currency_to_currency'    => '{from} &rarr; {to}',
    'to_currency_from_currency'    => '{to} &rarr; {from}',
    'rate'                         => 'Rate',

    'under'                        => 'Under',
    'symbol'                       => 'Symbol',
    'code'                         => 'Kode',
    'iban'                         => 'IBAN',
    'account_number'               => 'Kontonummer',
    'creditCardNumber'             => 'Kredittkortnummer',
    'has_headers'                  => 'Overskrifter',
    'date_format'                  => 'Datoformat',
    'attachments[]'                => 'Vedlegg',
    'title'                        => 'Tittel',
    'notes'                        => 'Notater',
    'filename'                     => 'Filnavn',
    'mime'                         => 'Mime-type',
    'size'                         => 'Størrelse',
    'trigger'                      => 'Utløser',
    'stop_processing'              => 'Stopp prosessering',
    'end_date'                     => 'End date',
    'enddate'                      => 'Sluttdato',
    'move_rules_before_delete'     => 'Regelgruppe',
    'start'                        => 'Start område',
    'end'                          => 'Slutt område',
    'delete_account'               => 'Slett konto ":name"',
    'delete_webhook'               => 'Slett webhook ":title',
    'delete_bill'                  => 'Delete subscription ":name"',
    'delete_budget'                => 'Slett budsjett ":name"',
    'delete_category'              => 'Slett kategori ":name"',
    'delete_currency'              => 'Slett valuta ":name"',
    'delete_journal'               => 'Slett transaksjon med beskrivelse ":description"',
    'delete_attachment'            => 'Slett vedlegg ":name"',
    'delete_rule'                  => 'Slett regel ":title"',
    'delete_rule_group'            => 'Slett regelgruppe ":title"',
    'delete_link_type'             => 'Slett lenketype ":name"',
    'delete_user'                  => 'Slett bruker ":email"',
    'delete_recurring'             => 'Slett gjentakende transaksjon ":title"',
    'user_areYouSure'              => 'Hvis du sletter brukeren ":email", vil alt bli borte. Det er ikke mulig å angre eller gjenopprette brukeren. Hvis du sletter din egen bruker, vil du miste tilgangen til Firefly III.',
    'attachment_areYouSure'        => 'Er du sikker på at du vil slette vedlegget ved navn ":name"?',
    'account_areYouSure'           => 'Er du sikker på at du vil slette brukeren ved navn ":name"?',
    'account_areYouSure_js'        => 'Er du sikker på at du vil slette kontoen "{name}"?',
    'bill_areYouSure'              => 'Are you sure you want to delete the subscription named ":name"?',
    'rule_areYouSure'              => 'Er du sikker på at du vil slette regelen ved navn ":title"?',
    'object_group_areYouSure'      => 'Er du sikker på at du vil slette gruppen ved navn ":title"?',
    'ruleGroup_areYouSure'         => 'Er du sikker på at du vil slette regelgruppen ved navn ":title"?',
    'budget_areYouSure'            => 'Er du sikker på at du vil slette budsjettet ved navn ":name"?',
    'webhook_areYouSure'           => 'Er du sikker på at du vil slette webhooken ved navn ":title"?',
    'category_areYouSure'          => 'Er du sikker på at du vil slette kategorien ved navn ":name"?',
    'recurring_areYouSure'         => 'Er du sikker på at du vil slette gjentakende transaksjonen ved navn ":title"?',
    'currency_areYouSure'          => 'Er du sikker på at du vil slette valutaen ved navn ":name"?',
    'piggyBank_areYouSure'         => 'Er du sikker på at du vil slette sparegrisen ved navn ":name"?',
    'journal_areYouSure'           => 'Er du sikker på at du vil slette transaksjonen med beskrivelse ":description"?',
    'mass_journal_are_you_sure'    => 'Er du sikker på at du vil slette disse transaksjonene?',



    'tag_areYouSure'               => 'Er du sikker på at du vil slette taggen ":tag"?',
    'journal_link_areYouSure'      => 'Er du sikker på at du vil slette koblingen mellom <a href=":source_link">:source</a> og <a href=":destination_link">:destination</a>?',
    'linkType_areYouSure'          => 'Er du sikker på at du vil slette koblingstypen ":name" (":inward" / ":outward")?',
    'permDeleteWarning'            => 'Sletting av data fra Firefly III er permanent, og kan ikke angres.',
    'mass_make_selection'          => 'Du kan fortsatt forhindre at elementer slettes ved å fjerne avkrysningen.',
    'delete_all_permanently'       => 'Slett valgte elementer permanent',
    'update_all_journals'          => 'Oppdater disse transaksjonene',
    'also_delete_transactions'     => 'Den ene transaksjonen som er koblet til denne kontoen, vil også bli slettet. | Alle :count transaksjoner som er koblet til denne kontoen, slettes også.',
    'also_delete_transactions_js'  => 'Ingen transaksjoner|Den eneste transaksjonen som er knyttet til denne kontoen, vil også bli slettet| Alle {count} transaksjoner som er koblet til denne kontoen vil bli slettet.',
    'also_delete_connections'      => 'Den ene transaksjonen som er knyttet til denne koblingstypen, vil miste denne forbindelsen. | Alle :count transaksjoner knyttet til denne koblingstypen vil miste forbindelsen.',
    'also_delete_rules'            => 'Den ene regelen som er knyttet til denne regelgruppen, vil også bli slettet. | Alle de :count reglene som er knyttet til denne regelgruppen slettes også.',
    'also_delete_piggyBanks'       => 'Den ene sparegrisen som er koblet til denne kontoen, vil også bli slettet. | Alle de :count sparegrisene knyttet til denne kontoen slettes også.',
    'also_delete_piggyBanks_js'    => 'Finner ingen sparegriser|Den eneste sparegrisen som er knyttet til denne kontoen vil også bli slettet.|Alle {count} sparegriser som er koblet til denne kontoen vil også bli slettet.',
    'not_delete_piggy_banks'       => 'Sparegrisen som er knyttet til denne gruppen vil ikke bli slettet.| De :count sparegrisene som er koblet til denne gruppen vil ikke bli slettet.',
    'bill_keep_transactions'       => 'The only transaction connected to this subscription will not be deleted.|All :count transactions connected to this subscription will be spared deletion.',
    'budget_keep_transactions'     => 'Ingen transaksjoner knyttet til dette budsjettet blir slettet.|Ingen av de :count transaksjonene knyttet til dette budsjettet vil bli slettet.',
    'category_keep_transactions'   => 'Ingen transaksjoner knyttet til denne kategorien blir slettet.|Ingen av de :count transaksjonene knyttet til denne kategorien vil bli slettet.',
    'recurring_keep_transactions'  => 'Ingen transaksjoner knyttet til denne gjentakende transaksjonen blir slettet.|Ingen av de :count transaksjonene knyttet til denne gjentakende transaksjonen vil bli slettet.',
    'tag_keep_transactions'        => 'Ingen transaksjoner knyttet til denne tag blir slettet.|Ingen av de :count transaksjonene knyttet til denne tag vil bli slettet.',
    'check_for_updates'            => 'Se etter oppdateringer',
    'liability_direction'          => 'Gjeld inn/ut',
    'delete_object_group'          => 'Slett gruppe ":title"',
    'email'                        => 'Epostadresse',
    'password'                     => 'Passord',
    'password_confirmation'        => 'Passord (gjenta)',
    'blocked'                      => 'Er sperret?',
    'blocked_code'                 => 'Årsak til sperring',
    'login_name'                   => 'Logg inn',
    'is_owner'                     => 'Er admin?',
    'url'                          => 'Nettadresse',
    'bill_end_date'                => 'Sluttdato',

    // import
    'apply_rules'                  => 'Bruk regler',
    'artist'                       => 'Artist',
    'album'                        => 'Album',
    'song'                         => 'Sang',

    // admin
    'domain'                       => 'Domene',
    'single_user_mode'             => 'Deaktiver brukerregistrering',
    'is_demo_site'                 => 'Er demonettsted',

    // import
    'configuration_file'           => 'Konfigurasjonsfil',
    'csv_comma'                    => 'Et komma (,)',
    'csv_semicolon'                => 'Et semikolon (;)',
    'csv_tab'                      => 'En tabulator (usynlig)',
    'csv_delimiter'                => 'CSV-feltskilletegn',
    'client_id'                    => 'Klient-ID',
    'app_id'                       => 'App ID',
    'secret'                       => 'Secret',
    'public_key'                   => 'Offentlig nøkkel',
    'country_code'                 => 'Landskode',
    'provider_code'                => 'Bank eller dataleverandør',
    'fints_url'                    => 'FinTS API URL',
    'fints_port'                   => 'Port',
    'fints_bank_code'              => 'Bankkode',
    'fints_username'               => 'Brukernavn',
    'fints_password'               => 'PIN / Passord',
    'fints_account'                => 'FinTS konto',
    'local_account'                => 'Firefly III konto',



    'from_date'                    => 'Dato fra',
    'to_date'                      => 'Dato til',
    'due_date'                     => 'Forfallsdato',
    'payment_date'                 => 'Betalingsdato',
    'invoice_date'                 => 'Fakturadato',
    'internal_reference'           => 'Intern referanse',
    'inward'                       => 'Innvendig beskrivelse',
    'outward'                      => 'Utvendig beskrivelse',
    'rule_group_id'                => 'Regelgruppe',
    'transaction_description'      => 'Transaksjonsbeskrivelse',
    'first_date'                   => 'Første dato',
    'transaction_type'             => 'Transaksjonstype',
    'repeat_until'                 => 'Gjenta til',
    'recurring_description'        => 'Gjentakende transaksjonsbeskrivelse',
    'repetition_type'              => 'Type repetisjon',
    'foreign_currency_id'          => 'Utenlandsk valuta',
    'repetition_end'               => 'Repetisjon slutter',
    'repetitions'                  => 'Repetisjoner',
    'calendar'                     => 'Kalender',
    'weekend'                      => 'Helg',
    'client_secret'                => 'Client Secret',
    'withdrawal_destination_id'    => 'Målkonto',
    'deposit_source_id'            => 'Kildekonto',
    'expected_on'                  => 'Forventet den',
    'paid'                         => 'Betalt',
    'auto_budget_type'             => 'Auto-budsjett',
    'auto_budget_amount'           => 'Auto-budsjett beløp',
    'auto_budget_period'           => 'Auto-budsjett periode',
    'collected'                    => 'Innhentet',
    'submitted'                    => 'Innsendt',
    'key'                          => 'Nøkkel',
    'value'                        => 'Innhold i registeret',
    'webhook_delivery'             => 'Levering',
    'webhook_response'             => 'Respons',
    'webhook_trigger'              => 'Utløser',
    'pushover_app_token'           => 'Pushover app token',
    'pushover_user_token'          => 'Pushover user token',
    'ntfy_server'                  => 'Ntfy server',
    'ntfy_topic'                   => 'Ntfy topic',
    'ntfy_auth'                    => 'Ntfy authentication enabled',
    'ntfy_user'                    => 'Ntfy username',
    'ntfy_pass'                    => 'Ntfy password',
];
