<?php

/*
 * RefreshNotesTrait.php
 * Copyright (c) 2024 james@firefly-iii.org.
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see https://www.gnu.org/licenses/.
 */

declare(strict_types=1);

namespace FireflyIII\TransactionRules\Traits;

use FireflyIII\Models\Note;
use FireflyIII\Models\TransactionJournal;
use Illuminate\Support\Facades\Log;

trait RefreshNotesTrait
{
    final protected function refreshNotes(array $transaction): array
    {
        $transaction['notes'] = '';
        $dbNote               = Note::where('noteable_id', (int) $transaction['transaction_journal_id'])->where('noteable_type', TransactionJournal::class)->first(['notes.*']);
        if (null !== $dbNote) {
            $transaction['notes'] = $dbNote->text;
        }
        Log::debug(sprintf('Notes of journal #%d refreshed.', $transaction['transaction_journal_id']));

        return $transaction;
    }
}
