<?php
/*
 * Project name: Flatboard
 * Project URL: https://flatboard.org
 * Author: Frédéric Kaplon and contributors
 * All Flatboard code is released under the MIT license.
 */

$out['self'] = 'blog';

# ON AJOUTE TOUT CE DONT FLATBOARD A BESOIN
require_once __DIR__ . '/' . 'header.php';

# Extrait la première image d'un post
function catch_that_image($content) {
    $out = '';
    preg_match("/\[img\](.*?)\[\/img\]/is", $content, $img);
    $img = str_replace('./', HTML_BASEPATH . DS, $img);
    if ($img) {
        $out .= '<img class="card-img-top" src="' . $img[1] . '" alt="picture">';
    }
    return $out;
}

# Enlève l'image d'un post
function del_that_image($content) {
    return preg_replace("/\[img\](.*?)\[\/img\]/is", '', $content, 1);
}

# PARAMÈTRES
$cur = 'blog'; # Indicateur de page
$forumID = $config['blog_new']; # Votre forum ID pour lister les posts
$nb = $config['ItemByPage']; # Nombre de posts à lister (config par défaut)

# RÉCUPÉRATION DES DONNÉES
$forumEntry = flatDB::readEntry('forum', $forumID);
# Traitement des sujets épinglés
$pinned = $forumEntry['pinnedTopic'];
$pinnedTopic = array_diff($forumEntry['topic'], $pinned);
# Trie des sujets
arsort($pinned, SORT_NUMERIC);
$topics = array_merge($pinned, array_reverse($pinnedTopic));
#$topics = $forumEntry['topic'];

# PAGINATION
$total = Paginate::countPage($topics, $nb);
$p = Paginate::pid($total);

# S'IL Y A DES SUJETS, ON LES LISTE
if ($topics) {
    $out['subtitle'] = 'BLOG: ' . htmlspecialchars($forumEntry['name']);
    $out['sub_prefix'] = entryLink::manageForum($forumID);

    # Template blog.tpl.php
    require THEME_DIR . $config['theme'] . DS . 'blog.tpl.php';

# SINON ON AFFICHE UNE ERREUR
} else {
    $out['subtitle'] = 'ERROR';
    $out['sub_prefix'] = '';
    $out['content'] .= '<p>' . $lang['none'] . '</p>';
}

# ON RETRANSMET TOUT ÇA DANS UN TEMPLATE
require PATH_ROOT . DS . 'footer.php';

?>