<?php
/*
 * Project name: Flatboard
 * Project URL: https://flatboard.org
 * Author: Frédéric Kaplon and contributors
 * Translation: Michael & Alexander Liebrecht (Last update: 2025.02.08)
 * All Flatboard code is released under the MIT license.
 * See COPYRIGHT.txt and LICENSE.txt.
*/
# SetLocal
setlocale (LC_ALL, 'de_DE@euro', 'de_DE', 'de', 'ge');
# Définit le décalage horaire par défaut de toutes les fonctions date/heure
date_default_timezone_set("Europe/Berlin");
# Definit l'encodage interne
mb_internal_encoding("ISO-8859-1");

$lang = array(
'fr-FR'             => 'Fran&ccedil;ais',
'en-US'             => 'English',
'ru-RU'             => 'Russian',
'de-DE'             => 'Deutsch',
'it-IT'             => 'Italiano',
'es-ES'             => 'Español',
'zh-CN'             => 'Chinese',

'in'  => ' <i class="fa fa-clock-o"></i>',
/************* install.php ***************/
'php_version' => 'Auf dem Server muss die Version <b>PHP 5.2</b> oder h&ouml;her installiert sein, um <b>Flatboard</b> zu installieren!',
'flatBoard_installer' => 'Installationsroutine für FlatBoard Forum',
'welcome_installer' => 'Willkommen bei der Installation von Flatboard Forum',
'site_title' => 'Der Titel Deiner Webseite',
'site_slogan' => 'Untertitel bzw. Beschreibung der Webseite',
'your_admin_psw' => 'Das muss der Typ sein: user@mypassword',
'site_mail' => 'Gib Deine Admin-E-Mail-Adresse ein',
'install' => 'Installation l&auml;uft',
'installed_title' => '<i class="fa fa-bullhorn"></i> Fertig! Flatboard Forum wurde installiert',
'installed_msg' => 'Jetzt kannst Du Foren anlegen und Diskussionen mit der Welt f&uuml;hren! Hilfe notwendig? Gehe auf <a href="https://flatboard.org/view.php/plugin/page/p/docs">und lies die Doku (DOC)</a>.',

/************* config.php ***************/
'homepage' => 'Startseite',
'footer_text' => 'Footer-Text',
'announcement' => 'Meldung',
'announcement_desc' => 'Keine Eingabe erzeugt eine leere Meldungsanzeige. HTML-Tags sind erlaubt.',
'ItemByPage' => 'Anzahl der Posts je Seite',
'date_format' => 'Datumsformat',
'date_format_desc' => 'Format f&uuml;r  Ortszeit time/date => <a href="http://php.net/manual/en/function.date.php">PHP doc</a>.',
'date_format_placeholder' => 'Y/m/d H:i',
'default_date_format' => 'l jS F o, H:i:s',
'short_date_format' => 'kurzes Datumsformat',
'maintenance' => 'Wartungsarbeiten',
'maintenance_desc' => ' Forumseite ist wegen Wartungsarbeiten offline. Bitte komme sp&auml;ter nochmal wieder. :-)',
'ban_list' => 'Sperrliste',
'ban_ok'  => 'Diese IP-Addresse ist jetzt gesperrt. ',
'ban_fail' => 'Diese IP-Adresse ist schon gesperrt. ',
'dashboard' => 'Dashboard',
'add_worker' => 'Hinzuf&uuml;gen eines Benutzers',
'save' => 'Speichern',
'update' => 'Update ',
'theme' => 'CSS-Design',
'theme_desc' => '<a href="config.php/deletecache" class="btn btn-primary btn-sm"><i class="fa fa-trash" aria-hidden="true"></i> Cache löschen</a>',
'cache_clean' => 'Cache gel&ouml;scht',
'folder_deleted' => 'Verzeichnis erfolgreich gel&ouml;scht',
'folder_error' => 'Verzeichnis konnte nicht gel&ouml;scht werden (Error)',
'lang' => 'Sprache',
'editor' => 'Editor',
'bbcode' => 'BBcode',
'markdown' => 'Markdown',
'editor_desc' => 'BBcode oder markdown Format',
'style' => 'Farbschema ' .Util::Help('Auswahl der Farbe für die Navigationszeile.'),
'style_placeholder' => 'schwarz, #000000…',
'nb_page_scroll_infinite' => 'Anzahl der automatisch scrollenden Seiten',
'nb_page_scroll_desc' => 'Eingabe 1 unterbindet das automatische scrollen.',
'salt' => 'Sicherheitsschl&uuml;ssel',
'salt_desc' => 'Leere Zeile erzeugt einen neuen Sicherheitsschl&uuml;ssel',
'manage_tags' => 'Tags verwalten',
'tags' => 'Tags',
'tags_help' => 'Mit Tags k&ouml;nnen die Titel der Artikel hervorgehoben werden. Sie machen die Artikel attraktiver und dienen auch als Filter für die Suche.<br />Zum Anzeigen, bitte einen Tag in diese Liste eintragen. Im Formular für einen neuen Artikel wird die Tag-Auswahl angezeigt. ',
'tags_empty' => 'Tags-Liste ist leer!',
'replace' => 'Ersetzen',
'tags_result' => 'Ergebnis',
'blog' => 'Blog',
'blog_new' => 'W&auml;hle ein Forum, welches eine News in deinen Blog sendet.',
'disable_blog' => 'Deaktivieren des Blogs',
'post_summary' => 'Anzahl der W&ouml;rter f&uuml;r den Artikel-Teaser.',
'hidden_tag' => 'Diesen Tag verstecken',
'title_tag' => '[Mein Tag]',
'user' => 'Nutzer',
'username_check' => 'Benutzername zur &Uuml;berpr&uuml;fung',
'user_checked' => 'Benutzer &uuml;berpr&uuml;ft',
'back_to_site' => 'Zur&uuml;ck zur Seite',
'good-morning' => 'Guten Morgen',
'good-afternoon' => 'Guten Nachmittag',
'good-evening' => 'Guten Abend',
'good-night' => 'Gute Nacht',
'hello' => 'Hallo',
'note' => 'Notiz',

/************* dashboard ***************/
'pro_edition' => 'PRO - Danke f&uuml;r den Support von Flatboard',
'standard_edition' => 'Standard - <a class="btn btn-link" href="https://flatboard.org/download.php" onclick="window.open(this.href); return false;">Aktualisiere auf Flatboard PRO</a>',

/************* Msg System ***************/
'warning_installation_file' => 'Datei <b>install.php</b> ist weiterhin noch im Root-Verzeichnis vorhanden!<br />Aus Sicherheitsgründen sollte die Datei umgehend  <a class="badge badge-danger" href="config.php/delinstallfile" title="delete now?">gelöscht</a> werden.',
'new_version' => 'Neue Version ist verf&uuml;gbar',
'theme_not_found' => 'Haupt-Flatboard-Theme nicht gefunden. ',

/************* add.php ***************/
'topic_added' => 'Thema hinzugef&uuml;gt!',
'reply_added' => 'Antwort hinzugef&uuml;gt!',
'forum_added' => 'Forum hinzugef&uuml;gt!',
'write_post' => 'Schreibe einen Artikel',
'modo_added' => 'Neuer Benutzer hinzugef&uuml;gt!',
'trip' => 'Pseudo ' .Util::Help('Sie brauchen sich nicht zu "registrieren", geben Sie einfach jedes Mal denselben Namen und dasselbe Passwort Ihrer Wahl ein - nach folgender Art: Username@Passwort. Ihr Passwort wird verschl&uuml;sselt und aus Sicherheitsgr&uuml;nden mit einem Hash-Wert angezeigt!'),
'badge_color' => 'Farbe des Emblems',
'badge_color_desc' => 'Eingabe eines hexadezimalen Farbwertes.',
'font_icon' => 'Piktogramm-Kategorie',
'font_icon_placeholder' => 'FA-Verzeichnis',
'font_icon_desc' => 'Besuche die Webseite <a href="http://fontawesome.io/icons/">Font Awesome</a> um ein Piktogramm auszuwählen',
'email_sent' => 'E-Mail erfolgreich &uuml;bertragen',
'email_nosent' => 'E-Mail konnte nicht gesendet werden',
'report_desc' => 'Hinweis: Der Moderator wird auf die von dir gemeldeten Seiten aufmerksam gemacht.<br />Dieses Formular ist NUR für die Meldung von anstößigen Inhalten und sollte nicht als Mittel zur Kommunikation mit Moderatoren aus anderen Gr&uuml;nden verwendet werden.',
'your_email' => 'Deine E-Mail-Adresse',
'click_to_view_post' => 'Hier klicken, um sich den Artikel anzusehen',
'order' => 'Auftrag',
'flood_start' => 'Es m&uuml;ssen mindestens 60 Sekunden zwischen dem Schreiben von mehreren Artikeln vergehen. Warte bitte und versuche es %s Minuten später noch einmal.',
'private' => 'Privaten Zugriff auf die Webseite erm&ouml;glichen.',
'restrict_access' => 'Beschr&auml;nkt den Zugriff auf die Webseite auf das Forum-Team.',
'private_msg' => 'Entschuldigung, du hast keine Berechtigung, um diese Seite zu &ouml;ffnen.',
'unauthorized_access' => 'Nicht authorisierter Zugriff',
'no_tag' => 'Keine Tags',
'more_info' => 'Klicke hier für weitere Details',
'cancel' => 'Abbrechen',
'choose_pic' => 'W&auml;hle ein Bild',
'upload' => 'Upload',
'private_forum' => 'Private forum',
'private_forum_desc' => 'Forum nur f&uuml;r das Team der Webseite zug&auml;nglich.',
'the_specified_color_is_not_valid' => 'Fehler: Die angegebene Farbe ist ungültig.',

/************* delete.php ***************/
'topic_deleted' => 'Thema gel&ouml;scht!',
'reply_deleted' => 'Antwort gel&ouml;scht!',
'forum_deleted' => 'Forum gel&ouml;scht!',
'worker_deleted' => 'Benutzer gel&ouml;scht!',
'ip_not_banned' => 'Diese IP-Adresse war nicht gesperrt. ',
'ip_removed' => 'Diese IP-Adresse wurde entfernt.',

/************* edit.php ***************/
'topic_edited' => 'Thema wurde ge&auml;ndert!',
'reply_edited' => 'Antwort wurde ge&auml;ndert!',
'forum_edited' => 'Forum wurde ge&auml;ndert!',
'pinned_homepage' => 'Angepinnt auf der Homepage',
'pick_font' => 'W&auml;hle ein Piktogramm',
'useSpace' => true,
'home' => 'Startseite',
'thread_sug'  => 'Vorgeschlagene Themen',
'change_pwd'  => 'Mein Passwort &auml;ndern',
'topic' => 'Thema',
'newthread' => 'Starte neuen Thread',
'reply' => 'Antwort',
'replies' => 'Antworten',
'newreply' => 'Neue Antwort',
'quote_reply' => 'Antwort als Zitat',
'quote_by' => 'Zitiert von ',
'add_forum'   => 'Forum hinzuf&uuml;gen',
'plugin' => 'Plugin',
'config' => 'Konfiguration',
'logout' => 'Ausloggen',
'login' => 'Einloggen',
'redirect' => 'Gehe zur&uuml;ck zu',
'add' => 'Hinzuf&umml;gen',
'edit' => '&auml;ndern',
'delete' => 'L&ouml;schen',
'title' => 'Titel',
'content' => 'Inhalt',
'name' => 'Name',
'mail' => 'E-Mail',
'mail_desc' => 'nicht der &Ouml;ffentlichkeit zeigen',
'not_required' => '(nicht ben&ouml;tigt)',
'search' => 'Suchen',
'forum' => 'Forum',
'password' => 'Passwort',
'confirm_password' => 'Best&auml;tigung des Passworts',
'powered' => 'Erstellt mit <a href="https://flatboard.org" onclick="window.open(this.href); return false;">Flatboard' .(defined('FLATBOARD_PRO')?' Pro':''). '</a> and <i class="fa fa-heart"></i>.',
'feed' => 'Feed',
'none' => 'Bisher kein Eintrag',
'info' => 'Information',
'date' => 'Datum',
'activity' => 'Aktivit&auml;t',
'view' => 'Ansehen',
'count' => 'Artikel',
'new' => 'Neu',
'more' => 'Mehr',
'submit' => 'Absenden',
'admin' => 'Administrator',
'worker' => 'Benutzer',
'sort_forums' => 'Foren sortieren',
'yes' => 'Ja',
'no' => 'Nein',
'locked' => 'gesperrt',
'no_reply' => 'Keine Antwort m&ouml;glich',
'locked_discussion' => 'Artikel gesperrt.',
'report' => 'Meldung',
'day' => 'Tag',
'hour' => 'Stunde',
'minute' => 'Minute',
'second' => 'Sekunde',
'plural' => '/en',
'ago' => 'zuvor',
'errLen' => 'Zu kurz / zu lang',
'errBot' => 'Fehlerhafter CAPTCHA',
'errNb' => 'Das ist keine positive ganze Zahl',
'ErrContentFilter' => 'Sie haben mindestens ein zensiertes Wort eingef&uuml;gt, bitte seien Sie h&ouml;flich.',
'pinned' => 'Angepinnt',
'stickied_discussion' => 'schliesst den Artikel.',
'replied' => '<i class="fa fa-share-square"></i> geantwortet ',
'started' => '<i class="fa fa-bolt"></i> gestartet ',
'notFound' => 'Upsi! Diese Seite existiert nicht :(',
'errNotMatch' => 'Passwort stimmt nicht &uuml;berein',
'captcha' => 'Captcha',
'enter_code' => 'Sicherheitscode eingeben',
'math_result' => 'L&ouml;se diese simple Rechenaufgabe',
'math_captcha' => 'Willst du eine Rechenaufgabe verwenden?',
'r_captcha'   => 'Bild neu laden',
'quickNav' => 'Schnell-Navigation',
'invalid_token' => 'Fehlerhaftes Zeichen!',
'mail_available' => 'Funktion zum Versenden von E-Mails vorhanden',
'mail_not_available' => 'Funktion zum Versenden von E-Mails gest&ouml;rt',
'statistics' => 'Statistik',
'start' => '<div class="alert alert-primary" role="alert"><h6>Herzlichen Gl&uuml;ckwunsch! Flatboard ist jetzt korrekt installiert.</h6>Um zu beginnen, musst du ein Forum hinzuf&uuml;gen. <a href="add.php/forum" class="btn btn-primary btn-sm"><i class="fa fa-plus"></i></a></div>',
'no-forum' => 'Es gibt kein Forum zum Anzeigen.',

/************* view.php ***************/
'permalink' => 'Dauerhafter Link',
'solved' => 'gel&ouml;st',
'original_message' => 'Original Artikel',
'last_modified' => 'zuletzt geändert %s ',
'last_post' => 'Letzter Artikel',
'user_activity' => 'Aktivit&auml;t des Nutzers.',
'error' => 'Fehler',
'no_plugin' => 'Dieses Plugin existiert nicht ODER ist nicht aktiviert!',
'want_more' => 'Willst du mehr erfahren? <a href="index.php' . DS . 'forum">Rufe alle Kategorien auf</a> or <a href="' .HTML_BASEPATH. '">letzte Topics ansehen</a>.',
'close_del_content' => 'Wenn Sie dieses Fenster mit dieser Schaltfl&auml;che schließen, wird der Inhalt gel&ouml;scht.',
'reply_this_topic' => 'Nehmen Sie am Gespr&auml;ch teil',

/************* search.php ***************/
'search_term_found' => 'Suchbegriff gefunden.',
'search_desc' => 'Die Suche erfolgt mit: Autor, Titel, Tag und dem Inhalt vom Topic.',
'search_holder' => 'Autor, Titel, Tag oder Inhalt.',
'click_tag_search' => 'Klicke diesen Tag an, um ihn zur Suche hinzuzuf&uuml;gen.',

/************* Plugin ***************/
'state'        => 'Status An/Aus plugin',
'state_on'     => 'An',
'state_off'    => 'Aus',
'data_save'    => 'Daten gespeichert!',
'description'  => 'Beschreibung',
'author'       => 'Autor',
'check_all'    => 'Alles pr&uuml;fen',
'plugin_help'    => '<i class="fa fa-warning"></i> Plugin-Hilfe',
'manage_plugin'    => 'Plugins verwalten und konfigurieren',
'cantDisable'  => 'Dieses Plugin kann nicht deaktiviert werden.',
'click_to_active'=>'Plugin aktivieren.',
'click_to_disable'=>'Plugin deaktivieren.',

/************* auth.php ***************/
'password_changed' => 'Dein Passwort wurde erfolgreich ge&auml;ndert!',
'edit_password' => '&Auml;ndere dein Passwort',
'login_confirm' => 'Einloggen war erfolgreich.',
'logout_confirm' => 'Ausloggen war erfolgreich.',
'incorrect_password' => 'Falsches Passwort.',
'error_maxlogin' => 'Zu h&auml;ufige fehlerhafte Eingabe. Probiere es in % s Minuten nochmal.',
'already_logged' => 'Du bist bereits eingeloggt!',
'already_logged_msg' => 'Du bist bereits eingeloggt <b>%s</b>, du musst dich ausloggen, bevor du dich mit einem anderen Benutzernamen einloggen kannst.',
'bad_user_syntax' => 'Ihr Benutzername muss die folgende Syntax haben: <b>name@passwort</b>',
'previous_page' => 'zur vorherigen Seite.',

/************* services.php ***************/
'ban_user' => 'Diese IP-Adresse sperren',
'unban_user' => 'Diese IP-Adresse wieder zulassen',
'banned' => 'Du wurdest gesperrt!',
'your_banned' => 'Du wurdest dauerhaft für dieses Forum gesperrt. <br />Bitte mit dem Administrator Kontakt aufnehmen, um die Gr&uuml;nde zu erfahren.<br />Ein Grund für die Sperrung ist unsere Weigerung gegen Spam,<br />Deine IP-Adresse: ',
'has_banned' => ' wurde gesperrt!',
'ban' => 'IP-Adresse / IP-Adressenbereich'

);
?>