
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `freshrss1270`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]][[admin_username]]_category`
--

CREATE TABLE `[[dbprefix]][[admin_username]]_category` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `kind` smallint DEFAULT '0',
  `lastUpdate` bigint DEFAULT '0',
  `error` smallint DEFAULT '0',
  `attributes` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]][[admin_username]]_category`
--

INSERT INTO `[[dbprefix]][[admin_username]]_category` VALUES
(1, 'Uncategorized', 0, 0, 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]][[admin_username]]_entry`
--

CREATE TABLE `[[dbprefix]][[admin_username]]_entry` (
  `id` bigint NOT NULL,
  `guid` varchar(767) CHARACTER SET latin1 COLLATE latin1_bin NOT NULL,
  `title` varchar(8192) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author` varchar(1024) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content_bin` mediumblob,
  `link` varchar(16383) CHARACTER SET latin1 COLLATE latin1_bin NOT NULL,
  `date` bigint DEFAULT NULL,
  `lastSeen` bigint DEFAULT '0',
  `hash` binary(16) DEFAULT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `is_favorite` tinyint(1) NOT NULL DEFAULT '0',
  `id_feed` int DEFAULT NULL,
  `tags` varchar(2048) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attributes` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_feed` (`id_feed`,`guid`),
  KEY `is_favorite` (`is_favorite`),
  KEY `is_read` (`is_read`),
  KEY `entry_lastSeen_index` (`lastSeen`),
  KEY `entry_feed_read_index` (`id_feed`,`is_read`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]][[admin_username]]_entrytag`
--

CREATE TABLE `[[dbprefix]][[admin_username]]_entrytag` (
  `id_tag` int NOT NULL,
  `id_entry` bigint NOT NULL,
  PRIMARY KEY (`id_tag`,`id_entry`),
  KEY `id_entry` (`id_entry`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]][[admin_username]]_entrytmp`
--

CREATE TABLE `[[dbprefix]][[admin_username]]_entrytmp` (
  `id` bigint NOT NULL,
  `guid` varchar(767) CHARACTER SET latin1 COLLATE latin1_bin NOT NULL,
  `title` varchar(8192) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author` varchar(1024) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content_bin` mediumblob,
  `link` varchar(16383) CHARACTER SET latin1 COLLATE latin1_bin NOT NULL,
  `date` bigint DEFAULT NULL,
  `lastSeen` bigint DEFAULT '0',
  `hash` binary(16) DEFAULT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `is_favorite` tinyint(1) NOT NULL DEFAULT '0',
  `id_feed` int DEFAULT NULL,
  `tags` varchar(2048) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attributes` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_feed` (`id_feed`,`guid`),
  KEY `date` (`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]][[admin_username]]_feed`
--

CREATE TABLE `[[dbprefix]][[admin_username]]_feed` (
  `id` int NOT NULL AUTO_INCREMENT,
  `url` varchar(32768) CHARACTER SET latin1 COLLATE latin1_bin NOT NULL,
  `kind` smallint DEFAULT '0',
  `category` int DEFAULT '0',
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `website` text CHARACTER SET latin1 COLLATE latin1_bin,
  `description` text COLLATE utf8mb4_unicode_ci,
  `lastUpdate` bigint DEFAULT '0',
  `priority` tinyint NOT NULL DEFAULT '10',
  `pathEntries` varchar(4096) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `httpAuth` varchar(1024) CHARACTER SET latin1 COLLATE latin1_bin DEFAULT NULL,
  `error` tinyint(1) DEFAULT '0',
  `ttl` int NOT NULL DEFAULT '0',
  `attributes` text COLLATE utf8mb4_unicode_ci,
  `cache_nbEntries` int DEFAULT '0',
  `cache_nbUnreads` int DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `category` (`category`),
  KEY `name` (`name`),
  KEY `priority` (`priority`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]][[admin_username]]_feed`
--

INSERT INTO `[[dbprefix]][[admin_username]]_feed` VALUES
(1, 'https://github.com/FreshRSS/FreshRSS/releases.atom', 0, 1, 'FreshRSS releases', 'https://github.com/FreshRSS/FreshRSS/', 'FreshRSS releases @ GitHub', 0, 10, '', '', 0, 0, '[]', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]][[admin_username]]_tag`
--

CREATE TABLE `[[dbprefix]][[admin_username]]_tag` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attributes` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `[[dbprefix]][[admin_username]]_entry`
--
ALTER TABLE `[[dbprefix]][[admin_username]]_entry`
  ADD CONSTRAINT `[[dbprefix]][[admin_username]]_entry_ibfk_1` FOREIGN KEY (`id_feed`) REFERENCES `[[dbprefix]][[admin_username]]_feed` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]][[admin_username]]_entrytag`
--
ALTER TABLE `[[dbprefix]][[admin_username]]_entrytag`
  ADD CONSTRAINT `[[dbprefix]][[admin_username]]_entrytag_ibfk_1` FOREIGN KEY (`id_tag`) REFERENCES `[[dbprefix]][[admin_username]]_tag` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `[[dbprefix]][[admin_username]]_entrytag_ibfk_2` FOREIGN KEY (`id_entry`) REFERENCES `[[dbprefix]][[admin_username]]_entry` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]][[admin_username]]_entrytmp`
--
ALTER TABLE `[[dbprefix]][[admin_username]]_entrytmp`
  ADD CONSTRAINT `[[dbprefix]][[admin_username]]_entrytmp_ibfk_1` FOREIGN KEY (`id_feed`) REFERENCES `[[dbprefix]][[admin_username]]_feed` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `[[dbprefix]][[admin_username]]_feed`
--
ALTER TABLE `[[dbprefix]][[admin_username]]_feed`
  ADD CONSTRAINT `[[dbprefix]][[admin_username]]_feed_ibfk_1` FOREIGN KEY (`category`) REFERENCES `[[dbprefix]][[admin_username]]_category` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
