<?php
/************************************************************
 * InfiniteWP Admin panel									*
 * Copyright (c) 2012 Revmakx								*
 * www.revmakx.com											*
 *															*
 ************************************************************/

class manageClientsAdditionalDataFetch {

	public static function getAdditionalStatsProcessor($siteIDs, $params, $extras){
		$type = 'addtionalStats';
		$action = 'getAdditionalStats';
		$requestAction = 'get_additional_stats';
		$requestParams = array(
						   'requiredActions' => array(),
						   'siteIDs' => $siteIDs
					   	);
		setHook('getAdditionalStatsRequestParams', $requestParams);

		if(!empty($siteIDs)){
			$sites = getSitesData($siteIDs, '1', NULL);
		}
		else{
			$sites = getSitesData();
		}

		$historyAdditionalData[] = array('uniqueName' => 'addtionalGetStats', 'detailedAction' => 'get');

		$sendAfterAllLoad = isset($extras['sendAfterAllLoad']) ? $extras['sendAfterAllLoad'] : true;
		$exitOnComplete = isset($extras['exitOnComplete']) ? $extras['exitOnComplete'] : false;
		$doNotShowUser = isset($extras['doNotShowUser']) ? $extras['doNotShowUser'] : false;
		$directExecute = isset($extras['directExecute']) ? $extras['directExecute'] : false;

		$events = 1;
		if(empty($sites)) return;

		foreach($sites as $siteID => $siteData){
			
			$PRP = array();
			$PRP['requestAction'] 	= $requestAction;
			$PRP['requestParams'] 	= $requestParams;
			$PRP['siteData'] 		= $siteData;
			$PRP['type'] 			= $type;
			$PRP['action'] 			= $action;
			$PRP['events'] 			= $events;
			$PRP['historyAdditionalData'] 	= $historyAdditionalData;
			$PRP['doNotExecute'] 			= false;
			$PRP['directExecute'] 		= $directExecute;
			$PRP['sendAfterAllLoad'] 	= $sendAfterAllLoad;
			$PRP['exitOnComplete'] 		= $exitOnComplete;
			$PRP['doNotShowUser'] 		= $doNotShowUser;
			
			if(!empty($params['timeScheduled']))
			$PRP['timeScheduled'] = $params['timeScheduled']; //used for checkbackupask().
			
			if(!empty($params['status']))
			$PRP['status'] = $params['status']; //used for checkbackupask().
			
			prepareRequestAndAddHistory($PRP);
		}
	}

	public static function getAdditionalStatsResponseProcessor($historyID, $responseData){

		responseDirectErrorHandler($historyID, $responseData);
		$where = array(
			      		'query' =>  "historyID=':historyID'",
			      		'params' => array(
			               ':historyID'=>$historyID
           				)
        			);
		$siteID = DB::getField("?:history", "siteID", $where);
		$where = array(
			      		'query' =>  "siteID = ':siteID'",
			      		'params' => array(
			               ':siteID'=>$siteID
           				)
        			);		

		if(empty($siteID)){
					return false;	
		}

		if(empty($responseData['success'])){
			return false;
		}

		if(!empty($responseData['success']['error'])){
			$where = array(
			      		'query' =>  "historyID=':historyID'",
			      		'params' => array(
			               ':historyID'=>$historyID
           				)
        			);
			DB::update("?:history_additional_data", array('status' => 'error', 'errorMsg' => $responseData['success']['error'], 'error' => $responseData['success']['error_code']), $where);
			return false;
		}

		$where = array(
			      		'query' =>  "historyID=':historyID' AND uniqueName = ':uniqueName'",
			      		'params' => array(
			               ':historyID'=>$historyID,
			               ':uniqueName'=>'addtionalGetStats'
           				)
        			);
		DB::update("?:history_additional_data", array('status' => 'success'), $where);
		$hookData = array( "siteID" => $siteID , "response" => $responseData['success']);
		setHook('additionalStatsResponse', $hookData);

	}

	public static function checkAndRunAddtionalStats($siteID, $historyID = false, $skipShowUser = false, $sendAfterAllLoad = false){
		$disabled = getOption('disableAddtionalStat');
		if (!empty($disabled)) {
			return false;
		}
		$isAlreadyScheduled = self::addtionalStatsCheck($siteID, $historyID, $skipShowUser);
		if ($isAlreadyScheduled == false) {
			$allParams = array('action' => 'getAdditionalStats', 'args' => array('siteIDs' => array($siteID), 'extras' => array('doNotShowUser' => true, 'sendAfterAllLoad' => $sendAfterAllLoad, 'directExecute' => $sendAfterAllLoad)));
			
			panelRequestManager::handler($allParams);
		}
	}

	public static function addtionalStatsCheck($siteID, $historyID, $skipShowUser = false){
		if ($skipShowUser == false) {
			$where = array(
				      		'query' =>  "historyID=':historyID'",
				      		'params' => array(
				               ':historyID'=>$historyID
	           				)
	        			);
			$return = DB::getField("?:history", "showUser", $where);
			if ($return == 'Y') {
				return true;
			}
		}
		$where = array(
      		'query' =>  "siteID=':siteID' AND status IN('pending', 'scheduled', 'running', 'initiated') AND action = 'getAdditionalStats'",
      		'params' => array(
               ':siteID'=>$siteID
				)
		);

		$return = DB::getField("?:history", "historyID", $where);
		if (empty($return)) {
			return false;
		}

		return true;

	}

	public static function triggerAdditionalStats($actionID){
		$where = array(
			      		'query' =>  "actionID=':actionID' AND type = 'stats' AND action = 'getStats' AND status = 'completed'",
			      		'params' => array(
			               ':actionID'=>$actionID
           				)
        			);
		$actions = DB::getArray("?:history", "historyID, siteID", $where);
		if (empty($actions)) {
			return false;
		}
		$isActionSend = false;
		foreach ($actions as $key => $value) {
			$isAlreadyScheduled = self::addtionalStatsCheck($value['siteID'], $value['historyID'], true);
			if ($isAlreadyScheduled == false) {
				$isActionSend = true;
				self::getAdditionalStatsProcessor(array($value['siteID']), array(), array('doNotShowUser' => true, 'sendAfterAllLoad' => true));
			}
		}

		if ($isActionSend) {
			$actionID = Reg::get('currentRequest.actionID');
			$currentTime = time();
			$waitActions[$actionID] = array('timeInitiated' => $currentTime,
											'timeExpiresFromSession' => $currentTime + (20 * 60),
											'requiredData' => array('getAdditionalStatsV3'=>1, 'getSitesUpdatesV3' => 1)
											);
			$GLOBALS['globlaSendAction'] = $waitActions;
		}

		return $isActionSend;
	}
}

manageClients::addClass('manageClientsAdditionalDataFetch');