<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: integrity_check
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_integrity_check($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrCore');
    jrCore_page_banner("Integrity Check");

    // Form init
    $_tmp = array(
        'submit_value'  => 'run integrity check',
        'cancel'        => 'referrer',
        'submit_title'  => 'Run an Integrity Check?',
        'submit_prompt' => 'Please be patient - on a large system this could take a bit to complete depending on the options',
        'submit_modal'  => 'update',
        'modal_width'   => 600,
        'modal_height'  => 400,
        'modal_note'    => 'Please be patient while the Integrity Check runs'
    );
    jrCore_form_create($_tmp);

    // Validate Modules
    $_tmp = array(
        'name'     => 'validate_modules',
        'label'    => 'verify modules',
        'help'     => 'Check this box so the system will verify active modules and the structure of your database tables.',
        'type'     => 'checkbox',
        'value'    => 'on',
        'validate' => 'onoff'
    );
    jrCore_form_field_create($_tmp);

    // Validate Skins
    $_tmp = array(
        'name'     => 'validate_skins',
        'label'    => 'verify skins',
        'help'     => 'Check this box so the system will verify active skins and and skin config options.',
        'type'     => 'checkbox',
        'value'    => 'on',
        'validate' => 'onoff'
    );
    jrCore_form_field_create($_tmp);

    // Validate Database
    $_tmp = array(
        'name'     => 'validate_schema',
        'label'    => 'verify database',
        'help'     => 'Check this box so the system will verify the database table schema.',
        'type'     => 'checkbox',
        'value'    => 'on',
        'validate' => 'onoff'
    );
    jrCore_form_field_create($_tmp);

    // Validate Language Strings
    $_tmp = array(
        'name'     => 'validate_language',
        'label'    => 'verify languages',
        'help'     => 'Check this box so the system will verify module and skin language files.',
        'type'     => 'checkbox',
        'value'    => 'on',
        'validate' => 'onoff'
    );
    jrCore_form_field_create($_tmp);

    // Reset Caches
    $_tmp = array(
        'name'     => 'reset_caches',
        'label'    => 'reset caches',
        'help'     => 'Check this option to reset the Template and Database caches after running the Integrity Check',
        'type'     => 'checkbox',
        'value'    => 'off',
        'validate' => 'onoff'
    );
    jrCore_form_field_create($_tmp);

    jrCore_page_section_header('<strong>Warning:</strong> The following options should only be used if needed - see note in help');

    // Optimize Tables
    $_tmp = array(
        'name'     => 'optimize_tables',
        'label'    => 'optimize tables',
        'help'     => 'Check this option to run OPTIMIZE TABLE on each database table.  This is helpful for sites that have been running a long time where the table data file can become &quot;fragmented&quot; and make data access a little bit slower.<br><br><strong>WARNING:</strong> While OPTIMIZE TABLE is running on a table, access to that table will be locked - the operation could take several minutes for very large tables. This option is <b>not needed as part of a normal Integrity Check</b>.',
        'type'     => 'checkbox',
        'value'    => 'off',
        'validate' => 'onoff'
    );
    jrCore_form_field_create($_tmp);

    // Repair Tables
    $_tmp = array(
        'name'     => 'repair_tables',
        'label'    => 'repair tables',
        'sublabel' => '<a onclick="jrCore_toggle_config_option(\'#repair_tables\',\'#ff-row-repair_tables_module\')" style="user-select:none"><u>select individual modules</u></a>',
        'help'     => 'If you suspect that some of your Database tables are corrupt, check this box and REPAIR TABLE will be run on each of your database tables.<br><br><strong>WARNING:</strong> While a repair is running on a table, access to that table will be locked. The repair operation could take several minutes for very large tables. This option is <b>not needed as part of a normal Integrity Check</b>.',
        'type'     => 'checkbox',
        'value'    => 'off',
        'validate' => 'onoff'
    );
    jrCore_form_field_create($_tmp);

    // Repair individual modules
    $_tmp = array();
    foreach ($_mods as $mod_dir => $_inf) {
        if (is_file(APP_DIR . "/modules/{$mod_dir}/schema.php")) {
            $_tmp[$mod_dir] = $_inf['module_name'];
        }
    }
    natcasesort($_tmp);
    $_tmp = array(
        'name'     => 'repair_tables_module',
        'label'    => 'Modules to Repair',
        'sublabel' => 'select multiple',
        'help'     => 'Select the modules to run the table repair for',
        'type'     => 'select_multiple',
        'options'  => $_tmp,
        'value'    => '',
        'validate' => 'not_empty'
    );
    jrCore_form_field_create($_tmp);

    // Repair Modules
    $_tmp = array(
        'name'     => 'repair_modules',
        'label'    => 'repair modules',
        'sublabel' => '<a onclick="jrCore_toggle_config_option(\'#repair_modules\',\'#ff-row-repair_modules_module\')" style="user-select:none"><u>select individual modules</u></a>',
        'help'     => 'Some modules include additional checks to repair invalid database entries - check this option to run these additional options.<br><br><strong>WARNING:</strong> On large systems some of these checks may take a long time to run - please be patient.  This option is <b>not needed as part of a normal Integrity Check</b> and should only be run if there is a suspected data integrity issue.',
        'type'     => 'checkbox',
        'value'    => 'off',
        'validate' => 'onoff'
    );
    jrCore_form_field_create($_tmp);

    // Repair individual modules
    $_tmp = array();
    $_reg = jrCore_get_event_listeners('jrCore', 'repair_module');
    foreach ($_mods as $mod_dir => $_inf) {
        if (jrCore_is_datastore_module($mod_dir)) {
            $_tmp[$mod_dir] = $_inf['module_name'];
        }
        else {
            foreach ($_reg as $f) {
                if (strpos($f, $mod_dir) === 0) {
                    $_tmp[$mod_dir] = $_inf['module_name'];
                }
            }
        }
    }
    natcasesort($_tmp);
    $_tmp = array(
        'name'     => 'repair_modules_module',
        'label'    => 'Modules to Repair',
        'sublabel' => 'select multiple',
        'help'     => 'Select the modules to run the module repair for',
        'type'     => 'select_multiple',
        'options'  => $_tmp,
        'value'    => '',
        'validate' => 'not_empty'
    );
    jrCore_form_field_create($_tmp);

    $_css = array(
        '#ff-row-repair_tables_module { display: none }',
        '#ff-row-repair_modules_module { display: none }'
    );
    jrCore_create_page_element('css_embed', $_css);

    jrCore_page_display();
}
