<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: skin_menu
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_skin_menu($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrCore');

    $tbl = jrCore_db_table_name('jrCore', 'menu');
    $req = "SELECT * FROM {$tbl} ORDER BY menu_order ASC";
    $_rt = jrCore_db_query($req, 'NUMERIC');

    jrCore_page_banner('user menu entries');
    jrCore_set_form_notice('notice', 'Some entries may be controlled by Quota access and may (or may not) show depending on the User');
    jrCore_get_form_notice();

    $_lang = jrUser_load_lang_strings();

    $dat             = array();
    $dat[1]['title'] = '';
    $dat[1]['width'] = '2%;';
    $dat[2]['title'] = 'order';
    $dat[2]['width'] = '2%;';
    $dat[3]['title'] = 'label';
    $dat[3]['width'] = '30%;';
    $dat[4]['title'] = 'URL';
    $dat[4]['width'] = '25%;';
    $dat[5]['title'] = 'active';
    $dat[5]['width'] = '5%;';
    $dat[6]['title'] = 'groups';
    $dat[6]['width'] = '8%;';
    $dat[7]['title'] = 'modify';
    $dat[7]['width'] = '5%;';
    $dat[8]['title'] = 'action';
    $dat[8]['width'] = '5%;';
    jrCore_page_table_header($dat);

    if (isset($_rt) && is_array($_rt)) {

        // let's make sure these are sanely ordered
        $_od = array();
        $_sn = array();
        $ord = false;
        foreach ($_rt as $_v) {
            $_od["{$_v['menu_id']}"] = $_v['menu_order'];
            if (isset($_sn["{$_v['menu_order']}"])) {
                $ord = true;
            }
            $_sn["{$_v['menu_order']}"] = 1;
        }
        if ($ord) {
            asort($_od, SORT_NUMERIC);
            $req = "UPDATE {$tbl} SET menu_order = CASE menu_id\n";
            $num = 100;
            foreach ($_od as $mid => $mord) {
                $req .= "WHEN {$mid} THEN {$num}\n";
                $num++;
            }
            $req .= "ELSE menu_id END";
            jrCore_db_query($req);

            // Refresh
            $req = "SELECT * FROM {$tbl} ORDER BY menu_order ASC";
            $_rt = jrCore_db_query($req, 'NUMERIC');
        }
        unset($_od, $_sn, $ord);

        $pass = jrCore_get_option_image('pass');
        $fail = jrCore_get_option_image('fail');
        $top  = 0;
        $_qt  = jrProfile_get_quotas();
        foreach ($_rt as $k => $_v) {

            if ($_v['menu_module'] != 'CustomEntry' && !jrCore_module_is_active($_v['menu_module'])) {
                continue;
            }

            $dat = array();
            if (isset($_v['menu_module'])) {
                $dat[1]['title'] = jrCore_get_module_icon_html($_v['menu_module'], 32);
            }
            else {
                $dat[1]['title'] = jrCore_get_module_icon_html('default', 32);
            }
            if (isset($k) && $k > 0) {
                $dat[2]['title'] = jrCore_page_button("smu-{$k}", '&#8679;', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/skin_menu_move_save/id={$_v['menu_id']}/top={$top}')");
            }
            else {
                $dat[2]['title'] = '&nbsp;';
            }
            $top             = $_v['menu_id'];
            $dat[2]['class'] = 'center';
            if (isset($_lang["{$_v['menu_module']}"]["{$_v['menu_label']}"])) {
                $url             = jrCore_get_module_url($_v['menu_module']);
                $dat[3]['title'] = jrCore_page_button("sml-{$k}", $_lang["{$_v['menu_module']}"]["{$_v['menu_label']}"], "jrCore_window_location('{$_conf['jrCore_base_url']}/{$url}/admin/language?id={$_v['menu_label']}')");
            }
            else {
                $dat[3]['title'] = $_v['menu_label'];
            }
            $dat[3]['class'] = 'center';
            $dat[4]['title'] = $_v['menu_action'];
            $dat[4]['class'] = 'center';
            $dat[5]['title'] = (isset($_v['menu_active']) && $_v['menu_active'] === 'on') ? $pass : $fail;
            $dat[5]['class'] = 'center';
            if (strpos($_v['menu_groups'], ',')) {
                $_ot = array();
                foreach (explode(',', $_v['menu_groups']) as $grp) {
                    if (isset($grp) && is_numeric($grp) && isset($_qt[$grp])) {
                        $_ot[] = $_qt[$grp];
                    }
                    else {
                        $_ot[] = $grp;
                    }
                }
                $dat[6]['title'] = implode('<br>', $_ot);
            }
            else {
                $dat[6]['title'] = $_v['menu_groups'];
            }
            $dat[6]['class'] = 'center';
            $dat[7]['title'] = jrCore_page_button("smm-{$k}", 'modify', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/skin_menu_modify/id={$_v['menu_id']}')");

            // We can only delete entries that we have created
            if (isset($_v['menu_module']) && isset($_mods["{$_v['menu_module']}"])) {
                $dat[8]['title'] = jrCore_page_button("smd-{$k}", 'delete', 'disabled');
            }
            else {
                $dat[8]['title'] = jrCore_page_button("smd-{$k}", 'delete', "jrCore_confirm('Delete this menu entry?', '', function(){ jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/skin_menu_delete_save/id={$_v['menu_id']}')} )");
            }
            $dat[8]['class'] = 'center';
            jrCore_page_table_row($dat, null, $_v);
        }
    }
    else {
        $dat             = array();
        $dat[1]['title'] = 'There are no custom skin menu entries';
        $dat[1]['class'] = 'p20 center';
        jrCore_page_table_row($dat);
    }
    jrCore_page_table_footer();

    $_tmp = array(
        'submit_value' => 'create new entry',
        'cancel'       => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools"
    );
    jrCore_form_create($_tmp);

    // New Menu Entry
    $_tmp = array(
        'name'      => 'new_menu_label',
        'label'     => 'new menu label',
        'help'      => 'Enter the label you would like to appear on this new Menu Entry.',
        'type'      => 'text',
        'validate'  => 'printable',
        'required'  => true,
        'onkeydown' => "if (event && event.keyCode == 13) return false;"
    );
    jrCore_form_field_create($_tmp);
    jrCore_page_display();
}
