<?php
 /**
 * Jamroom Marketplace module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: release_system_update
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrMarket_release_system_update($_post, $_user, $_conf)
{
    jrUser_master_only();
    // Make sure this is a valid release system
    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_set_form_notice('error', 'Invalid system_id - please try again');
        jrCore_location('referrer');
    }
    $tbl = jrCore_db_table_name('jrMarket', 'system');
    $req = "SELECT * FROM {$tbl} WHERE system_id = '{$_post['id']}' LIMIT 1";
    $_rt = jrCore_db_query($req, 'SINGLE');
    if (!is_array($_rt)) {
        jrCore_set_form_notice('error', 'Invalid system_id - not found in DB - please try again');
        jrCore_form_result();
    }

    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrMarket');
    jrCore_page_banner("update marketplace");
    jrCore_set_form_notice('success', 'Your <b>Marketplace Email</b> and <b>Marketplace System ID</b> can be found by logging into<br>your <a href="' . $_rt['system_url'] . '/user/login" target="_blank" rel="noreferrer noopener"><u>' . $_rt['system_name'] . ' User Account</u></a> and viewing your <a href="' . $_rt['system_url'] . '/networklicense/licenses" target="_blank" rel="noreferrer noopener"><u>Licenses Section</u></a>.<br>If you do not have an account, <a href="' . $_rt['system_url'] . '/user/signup" target="_blank" rel="noreferrer noopener"><u>Click here to create a new account</u></a>.', false);
    jrCore_get_form_notice();

    if ($_post['id'] == 1) {
        if (empty($_rt['system_email'])) {
            jrCore_form_field_hilight('system_email');
        }
        if (empty($_rt['system_code'])) {
            jrCore_form_field_hilight('system_code');
        }
    }

    // Form init
    $_tmp = array(
        'submit_value' => 'save changes',
        'cancel'       => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/systems",
        'values'       => $_rt
    );
    jrCore_form_create($_tmp);

    // System ID
    $_tmp = array(
        'name'     => 'id',
        'type'     => 'hidden',
        'validate' => 'number_nz',
        'value'    => $_post['id']
    );
    jrCore_form_field_create($_tmp);

    // System Name
    $_tmp = array(
        'name'     => 'system_name',
        'label'    => 'Marketplace Name',
        'help'     => 'This is the unique Marketplace Name for this Marketplace system.',
        'type'     => 'text',
        'validate' => 'not_empty',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    // System URL
    $_tmp = array(
        'name'     => 'system_url',
        'label'    => 'Marketplace URL',
        'help'     => 'This is the Marketplace URL for this Marketplace system - it is where new modules and skins can be installed from.',
        'type'     => 'text',
        'validate' => 'url',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    // System Email
    $_tmp = array(
        'name'     => 'system_email',
        'label'    => 'Marketplace Email',
        'help'     => "This is the Email Address that is used on your account on this Marketplace: <strong>{$_rt['system_name']}</strong>",
        'type'     => 'text',
        'validate' => 'email',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    // System Code
    $_tmp = array(
        'name'     => 'system_code',
        'label'    => 'Marketplace System ID',
        'help'     => "This is the unique System ID that can be found in your &quot;Licenses&quot; section of your account on this Marketplace: <strong>{$_rt['system_name']}</strong>",
        'type'     => 'text',
        'validate' => 'md5',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    // System Active
    $_tmp = array(
        'name'     => 'system_active',
        'label'    => 'Active',
        'help'     => 'Check this option to mark this Release System as active - it will appear as a selection in the Marketplace browser',
        'type'     => 'checkbox',
        'validate' => 'onoff',
        'default'  => 'on',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    // System Default
    $_tmp = array(
        'name'     => 'system_default',
        'label'    => 'Default',
        'help'     => 'Check this option to mark this Release System as the default Marketplace - when loading the Marketplace Browser it will be the default Marketplace selected.',
        'type'     => 'checkbox',
        'validate' => 'onoff',
        'default'  => 'off',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    jrCore_page_display();
}
