#ifndef _LVE_TYPE_H_

#define _LVE_TYPE_H_

#include <unistd.h>
#include <stdint.h>
#include <stdbool.h>

enum liblve_enter_flags {
	LVE_NO_UBC	= 1 << 0,
	LVE_NO_NAMESPACE = 1 << 1,
	LVE_NO_MAXENTER	= 1 << 2,
	LVE_SILENCE	= 1 << 3,
	LVE_NO_KILLABLE = 1 << 4,
	LVE_NO_CPU	= 1 << 5,
	LVE_NO_FREEZER	= 1 << 6,
};

enum liblve_ve_flags {
	LVE_VE_DISABLE  = 1 << 0, /* disable to enter to that ve */
};

enum liblve_ve_fails {
	LVE_FAIL_MEM	= 1 << 0,   /**< memory limit reached */
	LVE_FAIL_MEM_PHY = 1 << 1,  /**< physical memory limit reached */
	LVE_FAIL_NPROC	= 1 << 2,   /**< number of processes limit reached */
};

enum liblve_global_params {
	LVEGP_SYMLINK_PROTECTION = 1,
	LVEGP_HARDLINK_PROTECTION,
	LVEGP_HANDLE_SYMLINK_OWNER,
	LVEGP_SYMLINK_OWNER_GID,
	LVEGP_SYMLINK_PROT_ALLOW_GID,
	LVEGP_HARDLINK_PROT_ALLOW_GID,
	LVEGP_GLOBAL_NONROOT,
	LVEGP_XFS_QUOTA_CAP_RES_BYPASS,
	LVEGP_PROC_CAN_SEE_OTHER_UID,
	LVEGP_PROC_SUPER_GID,

	LVEGP_PTRACE_ENABLED,
	LVEGP_PTRACE_SELF_ENABLED,

	LVEGP_GRACE_PERIOD = 125,
};

/**
 * Flag indicating that ls_cpu stores hi resolution limit, used only for
 * lve_setup_enter.
 */
#define LIBLVE_SETTINGS_LS_CPU_HIRES	(1<<31)
struct liblve_settings {
	int32_t		ls_cpu;  /** < cpu power aka rate */
	int32_t		ls_cpus; /** < number vcpus */
	int32_t		ls_io;   /** < io limit */
	int32_t		ls_enters; /** < enter limit */
	int32_t		ls_memory; /** < mem limit */
	int32_t		ls_cpu_weight;
	int32_t		ls_memory_phy; /** < phy mem limit */
	int32_t		ls_nproc; /* number processes */
	int32_t		ls_iops; /* number of iops */
};

struct liblve_info {
	struct liblve_settings li_set; /* if it's put on top we have binary
	                                  compatible with old versions */
	enum liblve_ve_flags   li_flags;
};

struct liblve_pid_info {
	uint32_t	id; /* lve id of the task */
	uint32_t	flags; /* flags task entered lve with */
	bool		leader; /* is lve leader */
};

struct liblve_net_port {
	uint16_t	port;	/* port, 0 - change a lve policy itself */
	bool		permit;	/* permit/forbid port binding */
};

struct liblve_net_limits {
	uint64_t in_lim;	/* input trafic limit */
	uint64_t out_lim;	/* output trafic limit */
};

enum liblve_freezer_ops {
	LVE_FREEZER_FREEZE,
	LVE_FREEZER_THAW,
};

struct liblve_freezer_control {
	uint16_t op;
};

enum lvp_set_type {
    LVP_SETUP_SELF,
    LVP_SETUP_DEFAULT,
};

typedef void *(*liblve_alloc)(size_t size);
typedef void (*liblve_free)(void *ptr);


enum jail_flags {
	JAIL_DROP_CAPS = 1 << 0,
	JAIL_NO_NEW_PRIVS = 1 << 1,
};

#endif
