<?php
/*
The script to handle moderation lists of the Watching Topics / Subscriptions feature. Available both to admins and regular users.
This file is part of miniBB. miniBB is free discussion forums/message board software, supplied with no warranties.
Check COPYING file for more details.
Copyright (C) 2021 Paul Puzyrev. www.minibb.com
Most recent update: 2023-02-28
*/

if (!defined('INCLUDED776')) die ('Fatal error.');

$checkUser=0;

if(isset($_POST['step'])) $step=$_POST['step']; elseif(isset($_GET['step'])) $step=$_GET['step']; else $step='';

//if( ($logged_admin==1 and !isset($_GET['user']) and !isset($_POST['user']) and !defined('ADMIN_PANEL')) or ($logged_admin==1 and defined('ADMIN_PANEL') and isset($mode) and $mode=='') ) $checkUser=-1;
if(($logged_admin==1 or $isMod==1) and $step=='top') $checkUser=-1;
elseif(($logged_admin==1 or $isMod==1) and isset($_GET['user'])) $checkUser=(int)$_GET['user']+0;
elseif(($logged_admin==1 or $isMod==1) and isset($_POST['user'])) $checkUser=(int)$_POST['user']+0;
elseif($user_id>0) $checkUser=$user_id;
else{
header($proto.' 410 Gone');
$metaRobots='NOINDEX,NOFOLLOW';
$errorMSG=$l_subsNotExist; $correctErr='';
$title.=$l_subsDenied;
echo load_header(); echo ParseTpl(makeUp('main_warning')); return;
}

if(($logged_admin==1 or $isMod==1) and $checkUser!=$user_id) $adminMode=TRUE; else $adminMode=FALSE;

//echo $checkUser;
//print_r($_POST);

if($checkUser>0){

/***/
function produceGeneric($err=''){

echo <<<out
<!doctype html>
<html>
<head>
<meta name="ROBOTS" content="NOINDEX,NOFOLLOW">
{$GLOBALS['l_meta']}
<title>.</title>
</head>
<script>
{$err}
</script>
</html>
out;

}

function produceJsError($errTxt, $errExtra='', $alert=TRUE){
if($alert) $err="alert('{$errTxt}');"; else $err='';
$err.=$errExtra;
produceGeneric($err);
}
/***/

if($step=='setup'){

if($row=db_simpleSelect(0, $Tt, 'forum_id, topic_title', 'topic_id', '=', $topic)) {

$forum=$row[0];
$topicTitle=$row[1];

if(!isset($clForums) OR !in_array($forum, $clForums) OR (isset($clForums) and in_array($forum, $clForums) and ( ($logged_admin==1 or $isMod==1) or (isset($clForumsUsers[$forum]) and in_array($user_id, $clForumsUsers[$forum]))))){

if($row=db_simpleSelect(0, $Ts, 'id', 'topic_id', '=', $topic, '', '', 'user_id', '=', $user_id)){
//Remove via Unsubscribe link
db_delete($Ts, 'topic_id', '=', $topic, 'user_id', '=', $checkUser);

$watchLinkTitle='';
if(isset($purgeEmailSettings) and $purgeEmailSettings==1) {
if(!isset($is_mobile) or !$is_mobile) $watchLinkTitle=$l_subsWatch;
else $watchLinkTitle="<img src=\"{$main_url}/img/mobi/icon_subscribe.png\" alt=\"\">";
}
elseif(isset($purgeEmailSettings) and $purgeEmailSettings==2) {
if(!isset($is_mobile) or !$is_mobile) $watchLinkTitle=$l_subsWatchEmail;
else $watchLinkTitle="<img src=\"{$main_url}/img/mobi/icon_subscribe.png\" alt=\"\">";
}

$watchingLink=genWatchAmounts(TRUE);

if(!isset($is_mobile) or !$is_mobile){
$errTxt=<<<out
parent.document.getElementById('watchlink').innerHTML='<a href="javascript:handleWatch({$topic});" class="mnblnk">{$watchLinkTitle}</a>';
parent.document.getElementById('watchCnt').innerHTML='{$watchingLink}';
out;
}
else{
$errTxt=<<<out
parent.document.getElementById('watchlink').innerHTML='<a href="javascript:handleWatch({$topic});"><img src="{$main_url}/img/mobi/icon_subscribe.png" alt="{$l_subscribe}" title="{$l_subscribe}" class="watchIcon"></a>';
parent.document.getElementById('watchCnt').innerHTML='{$watchingLink}';
out;
}
if($additionAlerts) $errTxt.="alert('{$l_subsUnsubscribed}');";
produceJsError('', $errTxt, FALSE);
exit;

}
else{
if($subscriptionsLimit==0 OR (isset($userTotalSubs) and $userTotalSubs<$subscriptionsLimit)){

$topic_id=$topic;
$active=1;
$email_code=substr(preg_replace("#[^0-9A-Za-z]+#", "A", md5(uniqid(rand()))),0,10);
$post_id=0;
insertArray(array('user_id', 'topic_id', 'email_code', 'post_id'), $Ts);

/*
$topicUrl='';

if(!isset($mod_rewrite) or !$mod_rewrite) {
$topicUrl="{$main_url}/{$indexphp}action=vthread&amp;forum={$forum}&amp;topic={$topic}";
}
else{
if($row=db_simpleSelect(0, $Tf, 'forum_name', 'forum_id', '=', $forum)){
$forumName=$row[0];
$topicUrl=addTopicURLPage(genTopicURL($main_url, $forum, $forumName, $topic, $topicTitle), PAGE1_OFFSET+1);
}
}
*/
/*
if($topicUrl=='') $topicUrl=$main_url;
header("{$rheader}{$topicUrl}");
exit;
*/
$watchingLink=genWatchAmounts(TRUE);

if(!isset($is_mobile) or !$is_mobile){
$errTxt=<<<out
parent.document.getElementById('watchlink').innerHTML='<a href="javascript:handleWatch({$topic});" class="mnblnk">{$l_unsubscribe}</a>';
parent.document.getElementById('watchCnt').innerHTML='{$watchingLink}';
out;
}
else {
$errTxt=<<<out
parent.document.getElementById('watchlink').innerHTML='<a href="javascript:handleWatch({$topic});"><img src="{$main_url}/img/mobi/icon_unsubscribe.png" alt="{$l_unsubscribe}" title="{$l_unsubscribe}" class="watchIcon"></a>';
parent.document.getElementById('watchCnt').innerHTML='{$watchingLink}';
out;
}
if($additionAlerts) $errTxt.="alert('{$l_subsSubscribed}');";
produceJsError('', $errTxt, FALSE);
exit;

}
else{
$errTxt=<<<out
parent.document.getElementById('watchlink').innerHTML=parent.oldWatchHTML;
alert('{$l_subsLimitReached}');
out;
produceJsError('', $errTxt, FALSE);
exit;
}

}
}
}
}

elseif($step=='delete'){

//print_r($_POST); exit;

if($csrfchk=='' or $csrfchk!=$_COOKIE[$cookiename.'_csrfchk']) die('Could not proceed: possible CSRF/XSRF attack!');

db_delete($Ts, 'user_id', '=', $checkUser);
$loc="{$main_url}/{$indexphp}action=subscriptions";
if($adminMode) $loc.="&user={$checkUser}";
header("{$rheader}{$loc}");
exit;

}

elseif($step=='singledelete'){

if(!isset($_POST['nojs']) and ($csrfchk=='' or $csrfchk!=$_COOKIE[$cookiename.'_csrfchk'])) die('Could not proceed: possible CSRF/XSRF attack!');

if($checkUser==$user_id or $adminMode){

foreach($_POST as $key=>$val){

if(substr($key, 0, 7)=='delsub_'){
$topic_id=(int)str_replace('delsub_', '', $key);
db_delete($Ts, 'topic_id', '=', $topic_id, 'user_id', '=', $checkUser);
}

}

}

//exit;
//echo $checkUser;
//print_r($_POST); exit;

$loc="{$main_url}/{$indexphp}action=subscriptions";
if($adminMode) $loc.="&user={$checkUser}";
if($page!=(PAGE1_OFFSET+1)) $loc.="&page={$page}";
header("{$rheader}{$loc}");
exit;

}

else{

if($row=db_simpleSelect(0, $Tf, 'forum_id, forum_name, forum_group, forum_icon, forum_desc, topics_count', '', '', '','forum_order')){
$forumsArray=array();
do {
$forumsArray[$row[0]]=array($row[1], $row[3], $row[4], $row[5]);
}
while($row=db_simpleSelect(1));
}

$profileLink1='';
$profileLink2='';

if($row=db_simpleSelect(0, $Tu, "{$dbUserSheme['username'][1]}", $dbUserId, '=', $checkUser)){
$subs_username=$row[0];
if($adminMode){
$profileLink1=((isset($is_mobile) and $is_mobile)?$brtag:'')."<a href=\"{$main_url}/{$indexphp}action=userinfo&amp;user={$checkUser}\" class=\"mnblnk\">";
$profileLink2='</a>';
}
}
else {
$subs_username='N/A';
}

if($adminMode) $addTitle=$subs_username.' &mdash; '; else $addTitle='';

$title=$addTitle.$l_subsTitle;
$tpl=makeUp('main_subscriptions');
if(!$adminMode) $tpl=preg_replace("#<!--admins_only-->(.+?)<!--/admins_only-->#is", '', $tpl);
else $tpl=str_replace(array('<!--admins_only-->', '<!--/admins_only-->'), '', $tpl);

if($row=db_simpleSelect(0, $Ts, 'count(*)', 'user_id', '=', $checkUser) and $row[0]>0){
$numRows=$row[0];
$urlp="{$main_url}/{$indexphp}action=subscriptions&amp;user={$checkUser}";
$pageNav=pageNav($page,$numRows,$urlp,$viewmaxtopic,FALSE,'Gen');
$makeLim=makeLim($page,$numRows,$viewmaxtopic);
}
else {
$pageNav='';
$makeLim='';
$numRows=0;
}

$limPage=pageChk($page,$numRows,$viewmaxtopic);
if($page>$limPage){
$redir="{$main_url}/{$indexphp}action=subscriptions";
if($adminMode) $redir.="&user={$checkUser}";
$redir.="&page={$limPage}";
header($proto.' 404 Not Found');
header("{$rheader}{$redir}");
exit;
}

if($sbz=db_simpleSelect(0, $Ts, 'count(*)', 'user_id', '=', $checkUser, '', '', 'active', '=', '0') and $sbz[0]>0){
$userCheckToSubs='<span style="color:red;font-weight:bold">'.$sbz[0].'</span>';
}
else $userCheckToSubs='0';

if($pageNav=='') {
$tpl=preg_replace("#<!--pageNav-->(.+?)<!--/pageNav-->#is", '', $tpl);
}

if($numRows>0 and $row=db_simpleSelect(0, $Ts, 'id, user_id, topic_id, active, post_id', 'user_id', '=', $checkUser, 'active asc, topic_id desc', $makeLim)){

$gotTopics=array();
$activeTopics=array();
$goPosts=array();
do{
$gotTopics[]=$row[2];
$activeTopics[$row[2]]=$row[3];
$goPosts[$row[2]]=(int)$row[4];
}
while($row=db_simpleSelect(1));

$xtr=getClForums($gotTopics,'where','','topic_id','or','=');

$bl=makeUp('main_subscriptions_cell');
$bl=str_replace('<a href="{$linkToTopic}"', '<a target="_blank" href="{$linkToTopic}"', $bl);

$subscriptions_content='';

$collectedTopics=array();

if($row=db_simpleSelect(0, $Tt, 'topic_id, topic_title, topic_poster, topic_poster_name, topic_time, topic_status, posts_count, sticky, topic_views, topic_last_post_id, topic_last_post_time, topic_last_poster, forum_id')){
do{
$collectedTopics[$row[0]]=array($row[0], $row[1], $row[2], $row[3], $row[4], $row[5], $row[6], $row[7], $row[8], $row[9], $row[10], $row[11], $row[12]);
}
while($row=db_simpleSelect(1));
}

foreach($gotTopics as $tId){

if(!isset($collectedTopics[$tId])){
db_delete($Ts, 'topic_id', '=', $tId, 'user_id', '=', $checkUser);
}

else{

$pageNavCell='';
$i=1;

$row=$collectedTopics[$tId];

if($i>0) $bg='tbCel1'; else $bg='tbCel2';

$topic=$row[0];
$topicTitle=$row[1];
$forum=$row[12];
$forumName=$forumsArray[$forum][0];
$numReplies=$row[6]; if($numReplies>=1) $numReplies-=1;
$topic_views=$row[8];
$lmurl1='';

//Link to latest post in topic
if(isset($themeDesc) and in_array($topic, $themeDesc)) $vvpn=TRUE; else $vvpn=FALSE;

if($goPosts[$topic]==0){
if($numReplies<$viewmaxreplys or $vvpn) $pagelm=PAGE1_OFFSET+1; else $pagelm=ceil(($numReplies+1)/$viewmaxreplys)+PAGE1_OFFSET;
$lm=$row[9];
}

else{

//$lmurl1="{$main_url}/msg.php?id={$goPosts[$topic]}";
$lmurl1="{$main_url}/msg.php?subid=".base64_encode($user_id.','.$topic.','.$goPosts[$topic]);

/*
else{
if(!$vvpn) $sg='<='; else $sg='>=';

if($row=db_simpleSelect(0, $Tp, 'count(*)', 'post_id', $sg, $goPosts[$topic], '', '', 'topic_id', '=', $topic)) $pt=$row[0]; else $pt=0;

if($pt<=$viewmaxreplys) $pagelm=PAGE1_OFFSET+1;
else $pagelm=ceil($pt/$viewmaxreplys)+PAGE1_OFFSET;

$lm=$goPosts[$topic];

}
*/
}

if(isset($mod_rewrite) and $mod_rewrite) {
$urlp=genTopicURL($main_url, $forum, $forumName, $topic, $topicTitle);
$linkToTopic=addTopicURLPage(genTopicURL($main_url, $forum, $forumName, $topic, $topicTitle), PAGE1_OFFSET+1);
$urlType='Topic';
if($lmurl1=='') $lmurl1=addTopicURLPage($urlp, $pagelm)."#msg{$lm}";
}
else {
$urlp="{$main_url}/{$indexphp}action=vthread&amp;forum=$forum&amp;topic=$topic";
$linkToTopic="{$main_url}/{$indexphp}action=vthread&amp;forum={$forum}&amp;topic={$topic}";
$urlType='Gen';
if($lmurl1=='') $lmurl1="{$main_url}/{$indexphp}action=vthread&amp;forum={$forum}&amp;topic={$topic}&amp;page={$pagelm}#msg{$lm}";
}



if(isset($activeTopics[$topic]) and $activeTopics[$topic]==0) $tpcIcon='active';
elseif ($row[7]==1 and $row[5]==1) $tpcIcon='stlock';
elseif ($row[7]==1) $tpcIcon='sticky';
elseif ($row[5]==1) $tpcIcon='locked';
elseif ($numReplies<=0) $tpcIcon='empty';
elseif ($numReplies>=$viewmaxreplys) $tpcIcon='hot';
else $tpcIcon='default';

$topicIcon="<img src=\"{$main_url}/img/topic_{$tpcIcon}.gif\" alt=\"{$topicTitle}\" title=\"{$topicTitle}\" class=\"forumIcon\">";

if(isset($themeDesc) and in_array($topic, $themeDesc)) $topic_reverse="<img src=\"{$main_url}/img/topic_reverse.gif\" class=\"authorIcon\" alt=\"\">&nbsp;"; else $topic_reverse='';

if($numReplies>$viewmaxreplys){
if(!(isset($is_mobile) and $is_mobile)){
$pageNavCell=pageNav(PAGE1_OFFSET+1,$numReplies+1,$urlp,$viewmaxreplys,TRUE,$urlType);
}
else{
if(!isset($l_mobilePages)) $l_mobilePages='Pages';
$totalPages=ceil($numReplies/$viewmaxreplys);
$pageNavCell='&nbsp;&nbsp;<span class="txtSm pages noWrap"><img src="'.$main_url.'/img/page.gif" alt="'.$l_mobilePages.'" title="'.$l_mobilePages.'">&nbsp;<b>'.$totalPages.'</b></span>';
}
}

$pageNavCell=str_replace('class="navCell mnblnk mnblnkn"', 'class="navCell mnblnk mnblnkn" target="_blank"', $pageNavCell);

$numRepliesClean=parseNumClean($numReplies);
$topic_viewsClean=parseNumClean($topic_views);

$numReplies=parseStatsNum($numReplies);
$topic_views=parseStatsNum($topic_views);

if ($row[3]=='') $row[3]=$l_anonymous; $topicAuthor=$row[3];
$whenPosted=convert_date($row[4]);

if(!isset($lastPosterIcon)) $lastPosterIcon="<img src=\"{$main_url}/img/s.png\" class=\"authorIcon\" alt=\"{$l_lastAuthor}\" title=\"{$l_lastAuthor}\">&nbsp;";

$lastPosterID=$row[9];

if($numReplies==0 and isset($activeTopics[$topic]) and $activeTopics[$topic]==0){
$LinkToLastPostInTopic='<a href="'.$lmurl1.'" class="mnblnk" target="_blank">'.$lastPostIcon.'</a>';
}
elseif($numReplies>0) {
$lastPoster=$lastPosterIcon.$row[11];
$lastPostDate=convert_date($row[10]);
$LinkToLastPostInTopic='<a href="'.$lmurl1.'" class="mnblnk" target="_blank">'.$lastPostIcon.'</a>';
}
else {
$lastPoster='&mdash;';
$lastPostDate='';
$LinkToLastPostInTopic='';
}

$subscriptions_content.=ParseTpl($bl);
$i=-$i;

}

}

$l_subsDeleteAll=str_replace('{USERNAME}', "&laquo;{$subs_username}&raquo;", $l_subsDeleteAll);

echo load_header(); echo ParseTpl($tpl); return;
}
else{
header($proto.' 404 Not Found');
$metaRobots='NOINDEX,NOFOLLOW';
$l_subsEmpty=str_replace('{USERNAME}', "&laquo;{$subs_username}&raquo;", $l_subsEmpty);
$errorMSG=$l_subsEmpty; if($logged_admin==1 or $isMod==1) $correctErr="<a href=\"{$main_url}/{$indexphp}action=subscriptions&amp;step=top\" class=\"mnblnk\">{$l_subsWatchingList} &mdash; {$l_subsTop100}</a>"; else $correctErr='';
$title.=': '.$l_subsDenied;
echo load_header(); echo ParseTpl(makeUp('main_warning')); return;
}

}//step not delete
}//true ID detected
else{
if(($logged_admin==1 or $isMod==1) and !defined('ADMIN_PANEL')){

$watching=array();
$watchingStats=array();

if($row=db_simpleSelect(0, $Ts, 'count(*) as cnt, user_id', '', '', '', 'cnt desc', 100, '', '', '', TRUE, 'user_id')){
do{
$watching[]=$row[1];
$watchingStats[$row[1]]=$row[0];
}
while($row=db_simpleSelect(1));
}

$xtr=getClForums($watching,'where','',$dbUserId,'or','=');

$collected=array();

if($row=db_simpleSelect(0, $Tu, "{$dbUserId}, {$dbUserSheme['username'][1]}")){
do{
$collected[$row[0]]=$row[1];
}
while($row=db_simpleSelect(1));
}

$tmpl=<<<out
<table class="tbTransparentmb">
<tr><td class="tbTransparent txtL">
<h1 class="headingTitle">{$l_subsWatchingList}{$brtag}{$l_subsTop100}</h1>
</td></tr>
<tr><td>&nbsp;</td></tr>
<tr><td class="tbTransparent txtL"><ul class="limbb">
out;

$a=1;

foreach($watching as $uid){
$tmpl.=<<<out
<li>{$a}. <a href="{$main_url}/{$indexphp}action=subscriptions&amp;user={$uid}" class="mnblnk" target="_blank">{$collected[$uid]}</a> [{$watchingStats[$uid]}]</li>
out;
$a++;
}

$tmpl.='</table>';

$title.=$l_subsWatchingList;

echo load_header(); 

echo $tmpl;
return;

}
}

?>