<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_behat', language 'da', version '5.0'.
 *
 * @package     tool_behat
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aim'] = 'Dette administrationsværktøj hjælper udviklere og testforfattere med at oprette .feature-filer, der beskriver Moodles funktionaliteter, og køre dem automatisk. Trindefinitioner, der er tilgængelige til brug i .feature-filer, er listet nedenfor.';
$string['allavailablesteps'] = 'Alle tilgængelige trindefinitioner';
$string['errorbehatcommand'] = 'Fejl ved kørsel af behat CLI-kommando. Prøv at køre "{$a} --help" manuelt fra CLI for at finde ud af mere om problemet.';
$string['errorcomposer'] = 'Composer-afhængighederne er ikke installeret.';
$string['errordataroot'] = '$CFG->behat_dataroot er ikke sat eller er ugyldig.';
$string['errorsetconfig'] = '$CFG->behat_dataroot, $CFG->behat_prefix og $CFG->behat_wwwroot skal indstilles i config.php.';
$string['erroruniqueconfig'] = '$CFG->behat_dataroot, $CFG->behat_prefix og $CFG->behat_wwwroot værdierne skal være forskellige fra $CFG->dataroot, $CFG->prefix, $CFG->wwwroot, $CFG->phpunit_dataroot og $CFG->phpunit_prefix værdierne.<br/>Eller, hvis $CFG->behat_prefix er den samme, skal $CFG->behat_dbname eller $CFG->behat_dbhost være forskellige fra $CFG->phpunit_dbname og $CFG->phpunit_dbhost samt fra $CFG->dbname og $CFG->dbhost.';
$string['fieldvalueargument'] = 'Feltværdiargumenter';
$string['fieldvalueargument_help'] = 'Dette argument skal udfyldes med en feltværdi. Der er mange felttyper, herunder simple som afkrydsningsfelter, valgfelter eller tekstområder, eller komplekse som datovalg. Se udviklingsdokumentationen <a href="https://moodledev.io/general/development/tools/behat" target="_blank">Acceptance_testing</a> for detaljer om forventede feltværdier.';
$string['giveninfo'] = 'Givet. Processer til at opsætte miljøet';
$string['infoheading'] = 'Info';
$string['installinfo'] = 'Læs {$a} for installations- og testudførelsesinformation';
$string['newstepsinfo'] = 'Læs {$a} for information om, hvordan man tilføjer nye step definitioner';
$string['newtestsinfo'] = 'Læs {$a} for information om, hvordan man skriver nye tests';
$string['nostepsdefinitions'] = 'Der er ingen stepdefinitioner, der matcher dette filter';
$string['pluginname'] = 'Acceptancetest';
$string['privacy:metadata'] = 'Acceptance testing-pluginet gemmer ikke nogen personlige data.';
$string['stepsdefinitionscomponent'] = 'Område';
$string['stepsdefinitionscontains'] = 'Indeholder';
$string['stepsdefinitionsfilters'] = 'Trindefinitioner';
$string['stepsdefinitionstype'] = 'Type';
$string['theninfo'] = 'Derefter. Kontroller for at sikre, at resultaterne er de forventede';
$string['unknownexceptioninfo'] = 'Der opstod et problem med Selenium eller din browser. Venligst sørg for, at du bruger den nyeste version af Selenium. Fejl:';
$string['viewsteps'] = 'Filter';
$string['warndirrootconfigfound'] = 'En konfigurationsfil blev fundet på {$a}. Denne fil opdateres ikke automatisk og kan blive forældet. Vi anbefaler at fjerne denne fil.';
$string['wheninfo'] = 'Hvornår. Handling der fremkalder en begivenhed';
$string['wrongbehatsetup'] = 'Something is wrong with the behat setup and so step definitions cannot be listed: <b>{$a->errormsg}</b><br/><br/>Please check:<ul>
<li>$CFG->behat_dataroot, $CFG->behat_prefix and $CFG->behat_wwwroot are set in config.php with different values from $CFG->dataroot, $CFG->prefix and $CFG->wwwroot.</li>
<li>You ran "{$a->behatinit}" from your Moodle root directory.</li>
<li>Dependencies are installed in vendor/ and {$a->behatcommand} file has execution permissions.</li></ul>';
