<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_certification', language 'da', version '5.0'.
 *
 * @package     tool_certification
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['certified'] = 'Certificeret';
$string['conditioncertificationcertifieddescriptionwithdate'] = 'Brugere, der er certificeret i certificeringen \'{$a->fullname}\'<br />Certificeringsdato er på eller efter \'{$a->conditiondate}\'';
$string['conditioncertificationcertifiedonrecert'] = 'Udfør altid handlinger ved alle gen-certificeringer';
$string['conditioncertificationcertifiedonrecert_help'] = 'Dette vil effektivt ændre betingelsen til <b>"Bruger er certificeret, og gen-certificeringsperioden er ikke åben"</b>. Dette vil sikre, at brugeren markeres som "ikke matchende", når gen-certificeringen åbner, og handlingerne udføres for dem igen ved programafslutning, selvom de fortsætter med at være certificeret hele tiden.';
$string['conditioncertificationcertifiedstatusonly'] = 'Udfør kun handlinger, når brugerens status ændres fra "ikke certificeret" til "certificeret"';
$string['conditioncertificationcertifiedstatusonly_help'] = 'I dette tilfælde kan handlingerne muligvis eller muligvis ikke udføres ved gen-certificering, afhængigt af om den tidligere certificering er udløbet eller ej. For at sikre, at handlinger <b>aldrig</b> udføres under gen-certificering, bør du overveje at indstille "Regelhandlingsgrænse" i regelindstillingerne.';
$string['conditioncertificationexpired'] = 'Certificering udløbet';
$string['conditioncertificationexpireddescription'] = 'Brugere, hvis certificering \'{$a}\' er udløbet';
$string['conditioncertificationexpireddescriptionwithdate'] = 'Brugere, hvis certificering \'{$a->fullname}\' er udløbet<br />Udløbsdato er på eller efter \'{$a->conditiondate}\'';
$string['conditioncertificationnotcertified'] = 'Certificering ikke certificeret';
$string['conditioncertificationnotcertifieddescription'] = 'Brugere, der ikke er certificeret i certificeringen \'{$a}\'';
$string['conditioncertificationoverdue'] = 'Certificering overskredet';
$string['conditioncertificationoverduedescription'] = 'Brugere, der er overskredet i certificeringen \'{$a}\'';
$string['conditioncertificationoverduedescriptionwithdate'] = 'Brugere, der er overskredet i certificeringen \'{$a->fullname}\'<br />Forfaldsdato er på eller efter \'{$a->conditiondate}\'';
$string['conditioncertificationsuspended'] = 'Certificering suspenderet';
$string['conditioncertificationsuspendeddescription'] = 'Brugere, der er suspenderet i certificeringen \'{$a}\'';
$string['conditioncertificationsuspendeddescriptionwithdate'] = 'Brugere, der er suspenderet i certificeringen \'{$a->fullname}\'<br />Suspensionsdato er på eller efter \'{$a->conditiondate}\'';
$string['conditionrecertificationgraceperiod'] = 'Recertificerings-graceperiode udløber';
$string['conditionrecertificationgraceperiodendsdescription'] = 'Brugere, hvis graceperiode udløber i certificeringen \'{$a->fullname}\'';
$string['conditionrecertificationgraceperiodendsdescriptionwithdate'] = 'Brugere, hvis graceperiode udløber i certificeringen \'{$a->fullname}\'<br />Recertificerings-graceperioden udløber på eller før \'{$a->conditiondate}\'';
$string['conditionrecertificationstarted'] = 'Recertificeringsperiode startet';
$string['conditionrecertificationstarteddescription'] = 'Brugere, der har startet en recertificeringsperiode i certificeringen \'{$a->fullname}\'';
$string['conditionrecertificationstarteddescriptionwithdate'] = 'Brugere, der har startet en recertificeringsperiode i certificeringen \'{$a->fullname}\'<br />Recertificering startet på eller efter \'{$a->conditiondate}\'';
$string['conditionuserallocated'] = 'Brugere tildelt til certificering';
$string['conditionuserallocateddescription'] = 'Brugere tildelt certificeringen \'{$a}\'';
$string['conditionuserallocateddescriptionwithdate'] = 'Brugere tildelt certificeringen \'{$a->fullname}\'<br />Tildelingsdato er på eller efter \'{$a->conditiondate}\'';
$string['conditionusernotallocated'] = 'Brugere ikke tildelt til certificering';
$string['conditionusernotallocateddescription'] = 'Brugere ikke tildelt certificeringen \'{$a}\'';
$string['confirmdeallocateusers'] = 'Denne handling vil fuldstændigt slette tildeling og tilknyttede data for alle de valgte brugere. Denne handling kan ikke fortrydes.';
$string['confirmdeallocateusersheader'] = 'Fjern tildeling af brugere';
$string['confirmdeletecertification'] = 'Er du sikker på, at du vil slette certificeringen \'{$a}\' og tilhørende data? Denne handling kan ikke fortrydes.';
$string['confirmdeleteuserallocation'] = 'Er du sikker på, at du vil slette tildelingen af bruger \'{$a}\' fuldstændigt samt tilknyttede data? Denne handling kan ikke fortrydes.';
$string['confirmduplicate'] = 'Der oprettes en kopi af certificeringskonfigurationen, og du vil kunne ændre programmet og andre egenskaber. Ingen brugertildelinger vil blive overført til kopien.';
$string['content'] = 'Indhold';
$string['criteriaall'] = 'Alle de valgte certificeringer er blevet certificeret';
$string['criteriaany'] = 'Mindst én af de valgte certificeringer er certificeret';
$string['criteriaany_help'] = 'Når en bruger allerede er blevet certificeret i en af certificeringerne, udløser certificering i den anden certificering ikke handlingerne igen.';
$string['criteriaeach'] = 'Hver gang en bruger er certificeret i en hvilken som helst af de valgte certificeringer';
$string['criteriaeach_help'] = 'Svarer til at oprette flere regler, én for hver af de valgte certificeringer';
$string['currentprogram'] = 'Nuværende program';
$string['currentprogram_help'] = 'Dette er det nuværende program, som denne bruger gennemgår';
$string['currentprogramprogress'] = 'Nuværende programfremskridt';
$string['currentprogramstatus'] = 'Nuværende programstatus';
$string['dateoverrided'] = 'Dato tilsidesat';
$string['dayssinceallocation'] = 'Dage siden tildeling';
$string['daystakingcertification'] = 'Dage under certificering';
$string['deallocateusers'] = 'Fjern tildeling af brugere';
$string['default'] = 'Standard';
$string['deleteallocation'] = 'Slet tildeling';
$string['deleteuserallocation'] = 'Slet brugertildeling';
$string['displaycertificationdate'] = 'Certificeringsdato';
$string['displaycertificationduedate'] = 'Certificeringsforfaldsdato';
$string['displaycertificationid'] = 'Internt certificerings-id brugt i URL\'er';
$string['displaycertificationname'] = 'Certificeringsnavn';
$string['displaycertificationprogramname'] = 'Startprogramnavn for denne certificering';
$string['displaycertificationreopen'] = 'Recertificerings startdato';
$string['displayexpirydate'] = 'Certificeringsudløbsdato';
$string['displayexpirydatetimestamp'] = 'Certificeringsudløbsdato tidsstempel';
$string['displaygraceperiodend'] = 'Grace periodes slutdato';
$string['displayrecertificationprogramname'] = 'Recertificeringsprogramnavn';
$string['dontchange'] = 'Ændr ikke';
$string['duedate'] = 'Forfaldsdato';
$string['duedate_help'] = 'Dato hvor certificeringen forfalder';
$string['duedateisonorafter'] = 'Forfaldsdato på eller efter';
$string['duplicate'] = 'Dupliker';
$string['dynamic'] = 'Dynamisk';
$string['dynamicrules'] = 'Dynamiske regler';
$string['dynamicrulesplugincheck'] = 'Visning af listen over dynamiske regler er umulig uden plugin\'et tool_dynamicrules';
$string['expired'] = 'Udløbet';
