<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'aiprovider_openai', language 'cs', version '5.0'.
 *
 * @package     aiprovider_openai
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:explain_text:endpoint'] = 'Koncový bod API';
$string['action:explain_text:model'] = 'AI model';
$string['action:explain_text:model_help'] = 'Model použitý k vysvětlení poskytnutého textu.';
$string['action:explain_text:systeminstruction'] = 'Systémová instrukce';
$string['action:explain_text:systeminstruction_help'] = 'Tato instrukce je odeslána do modelu AI spolu s výzvou uživatele. Úprava tohoto návodu se nedoporučuje, pokud to není nezbytně nutné.';
$string['action:generate_image:endpoint'] = 'Koncový bod API';
$string['action:generate_image:model'] = 'AI model';
$string['action:generate_image:model_desc'] = 'Model používaný ke generování obrázků z uživatelských výzev.';
$string['action:generate_image:model_help'] = 'Model používaný ke generování obrázků z uživatelských výzev.';
$string['action:generate_text:endpoint'] = 'Koncový bod API';
$string['action:generate_text:model'] = 'AI model';
$string['action:generate_text:model_desc'] = 'Model použitý ke generování textové odpovědi.';
$string['action:generate_text:model_help'] = 'Model použitý ke generování textové odpovědi.';
$string['action:generate_text:systeminstruction'] = 'Systémová instrukce';
$string['action:generate_text:systeminstruction_desc'] = 'Tato instrukce je odeslána do modelu AI spolu s výzvou uživatele. Úprava tohoto návodu se nedoporučuje, pokud to není nezbytně nutné.';
$string['action:generate_text:systeminstruction_help'] = 'Tato instrukce je odeslána do modelu AI spolu s výzvou uživatele. Úprava této instrukce  se nedoporučuje, pokud to není nezbytně nutné.';
$string['action:summarise_text:endpoint'] = 'Koncový bod API';
$string['action:summarise_text:model'] = 'AI model';
$string['action:summarise_text:model_desc'] = 'Model použitý ke shrnutí poskytnutého textu.';
$string['action:summarise_text:model_help'] = 'Model použitý ke shrnutí poskytnutého textu.';
$string['action:summarise_text:systeminstruction'] = 'Systémová instrukce';
$string['action:summarise_text:systeminstruction_desc'] = 'Tato instrukce je odeslána do modelu AI spolu s výzvou uživatele. Úprava tohoto návodu se nedoporučuje, pokud to není nezbytně nutné.';
$string['action:summarise_text:systeminstruction_help'] = 'Tato instrukce je odeslána do modelu AI spolu s výzvou uživatele. Úprava této instrukce  se nedoporučuje, pokud to není nezbytně nutné.';
$string['apikey'] = 'Klíč OpenAI API';
$string['apikey_desc'] = 'Získejte klíč ze svých <a href="https://platform.openai.com/account/api-keys">klíčů rozhraní OpenAI API</a>.';
$string['apikey_help'] = 'Získat klíč ze svých <a href="https://platform.openai.com/account/api-keys" target="_blank">klíčů rozhraní OpenAI API</a>.';
$string['custom_model_name'] = 'Vlastní název modelu';
$string['enableglobalratelimit'] = 'Nastavit limit sazby pro celý web';
$string['enableglobalratelimit_desc'] = 'Omezit počet požadavků, které může poskytovatel OpenAI API přijímat na celém webu každou hodinu.';
$string['enableuserratelimit'] = 'Nastavit limit uživatelské sazby';
$string['enableuserratelimit_desc'] = 'Omezit počet požadavků, které může každý uživatel zadávat poskytovateli OpenAI API každou hodinu.';
$string['extraparams'] = 'Extra parametry';
$string['extraparams_help'] = 'Zde lze konfigurovat další parametry. Podporujeme formát JSON. Například:
<pre>
{
      "temperature": 0,5,
       "max_tokens": 100
}
</pre>';
$string['globalratelimit'] = 'Maximální počet požadavků na celém webu';
$string['globalratelimit_desc'] = 'Počet povolených požadavků na celém webu za hodinu.';
$string['invalidjson'] = 'Neplatný řetězec JSON';
$string['orgid'] = 'ID organizace OpenAI';
$string['orgid_desc'] = 'Získat ID organizace OpenAI ze svého <a href="https://platform.openai.com/account/org-settings">účtu OpenAI</a>.';
$string['orgid_help'] = 'Získat ID organizace OpenAI ze svého <a href="https://platform.openai.com/account/org-settings" target="_blank">účtu OpenAI</a>.';
$string['pluginname'] = 'Poskytovatel OpenAI API';
$string['privacy:metadata'] = 'Zásuvný modul poskytovatele OpenAI API neukládá žádné osobní údaje.';
$string['privacy:metadata:aiprovider_openai:externalpurpose'] = 'Tyto informace jsou odeslány do API OpenAI, aby mohla být vygenerována odpověď. Nastavení vašeho účtu OpenAI může změnit způsob, jakým OpenAI ukládá a uchovává tato data. Pomocí tohoto zásuvného modulu nejsou explicitně odesílána žádná uživatelská data do OpenAI ani ukládána v Moodle LMS.';
$string['privacy:metadata:aiprovider_openai:model'] = 'Model použitý ke generování odpovědi.';
$string['privacy:metadata:aiprovider_openai:numberimages'] = 'Počet obrázků použitých v odpovědi při generování obrázků.';
$string['privacy:metadata:aiprovider_openai:prompttext'] = 'Uživatel zadal textovou výzvu použitou ke generování odpovědi.';
$string['privacy:metadata:aiprovider_openai:responseformat'] = 'Formát odpovědi. Při generování obrázků.';
$string['settings'] = 'Nastavení';
$string['settings_frequency_penalty'] = 'frequency_penalty';
$string['settings_frequency_penalty_help'] = 'Penalizuje nové tokeny na základě jejich četnosti opakování v textu. Čím vyšší penalizace, tím méně opakování ve vygenerovaném textu.';
$string['settings_help'] = 'Upravte nastavení níže, abyste přizpůsobili způsob odesílání požadavků do OpenAI.';
$string['settings_max_completion_tokens'] = 'max_completion_tokens';
$string['settings_max_completion_tokens_help'] = 'Maximální počet tokenů použitých ve vygenerovaném textu.';
$string['settings_max_tokens'] = 'max_tokens';
$string['settings_max_tokens_help'] = 'Maximální počet tokenů použitých ve vygenerovaném textu.';
$string['settings_presence_penalty'] = 'presence_penalty';
$string['settings_presence_penalty_help'] = 'Penalizace za přítomnost povzbuzuje model k používání nových slov tím, že zvyšuje pravděpodobnost výběru slov, která dříve nepoužíval. Vyšší hodnota činí generovaný text rozmanitější, zatímco nižší hodnota umožňuje více opakování.';
$string['settings_top_p'] = 'top_p';
$string['settings_top_p_help'] = 'top_p (vzorkování jádra) určuje, kolik možných slov je třeba vzít v úvahu. Vysoká hodnota (např. 0,9) znamená, že model se dívá na více slov, díky čemuž je generovaný text rozmanitější.';
$string['userratelimit'] = 'Maximální počet požadavků na uživatele';
$string['userratelimit_desc'] = 'Počet povolených požadavků za hodinu na uživatele.';
