<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'report_benchmark', language 'pl', version '5.0'.
 *
 * @package     report_benchmark
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['adminreport'] = 'Test wydajności systemu';
$string['benchfail'] = '<b>Uwaga!</b><br />Wydajność Twojej instalacji Moodle nie jest optymalna.';
$string['benchmark'] = 'Test wydajności';
$string['benchmark:view'] = 'Zobacz raport z testu';
$string['benchshare'] = 'Podziel się moim wynikiem na forum';
$string['benchsuccess'] = '<b>Gratulacje!</b><br />Wydaje się, że instalacja Moodle działa idealnie.';
$string['cloadmoreinfo'] = 'Załaduj plik konfiguracyjny „config.php”';
$string['cloadname'] = 'Czas ładowania Moodle';
$string['coursereadmoreinfo'] = 'Odczytaj kurs kilka razy, aby sprawdzić szybkość zapisu bazy danych';
$string['coursereadname'] = 'Wydajność odczytu kursu';
$string['coursewritemoreinfo'] = 'Zapisz kurs kilka razy, aby sprawdzić szybkość zapisu bazy danych';
$string['coursewritename'] = 'Wydajność zapisu kursu';
$string['description'] = 'Opis';
$string['duration'] = '{$a} s.';
$string['during'] = 'Czas (sekundy)';
$string['filereadmoreinfo'] = 'Odczytaj plik kilka razy, aby sprawdzić szybkość zapisu tymczasowego folderu Moodle';
$string['filereadname'] = 'Wydajność odczytu pliku';
$string['filewritemoreinfo'] = 'Zapisz plik kilka razy, aby sprawdzić szybkość zapisu tymczasowego folderu Moodle';
$string['filewritename'] = 'Wydajność zapisu pliku';
$string['info'] = 'Ten test wydajności powinien trwać mniej niż 1 minutę i zostanie przerwany po 2 minutach. Proszę czekać, aż pojawią się wyniki.';
$string['infoaverage'] = 'Zaleca się przeprowadzenie tego testu wydajności kilka razy, aby uzyskać wiarygodną średnią. Jeśli wydajność instalacji nie jest optymalna, znajdziesz zalecenia dotyczące jej poprawy w <a href="https://docs.moodle.org/en/Performance_recommendations" target="_blank">dokumentacji Moodle</a>.';
$string['infodisclaimer'] = 'Nie uruchamiaj tego testu na platformie produkcyjnej, ponieważ może to spowodować znaczne pogorszenie wydajności.';
$string['infodisclamer'] = 'Nie zaleca się uruchamiania tego testu na platformie produkcyjnej.';
$string['limit'] = 'Dopuszczalny limit';
$string['loginguestmoreinfo'] = 'Sprawdź czas ładowania strony logowania do konta gościa';
$string['loginguestname'] = 'Wydajność czasu logowania dla konta gościa';
$string['loginusermoreinfo'] = 'Sprawdź czas ładowania fałszywej strony logowania do konta użytkownika';
$string['loginusername'] = 'Wydajność czasu logowania dla fałszywego konta użytkownika';
$string['modulename'] = 'Test wydajności Moodle';
$string['modulenameplural'] = 'Testy wydajności Moodle';
$string['notificatiopagedownloadmoreinfo'] = 'Załaduj stronę powiadomień interfejsu administracyjnego kilka razy, aby sprawdzić szybkość serwera WWW';
$string['notificatiopagedownloadname'] = 'Czas ładowania strony powiadomień administracyjnych';
$string['over'] = 'Krytyczny limit';
$string['pluginname'] = 'Test wydajności Moodle';
$string['points'] = '{$a} punktów';
$string['privacy:no_data_reason'] = 'Wtyczka raportu testu wydajności nie przechowuje żadnych danych osobowych.';
$string['processormoreinfo'] = 'Wywołanie funkcji PHP z pętlą w celu sprawdzenia szybkości procesora';
$string['processorname'] = 'Prędkość przetwarzania procesora';
$string['querytype1moreinfo'] = 'Uruchom złożone zapytanie SQL, aby sprawdzić szybkość bazy danych';
$string['querytype1name'] = 'Wydajność bazy danych (#1)';
$string['querytype2moreinfo'] = 'Uruchom złożone zapytanie SQL, aby sprawdzić szybkość bazy danych';
$string['querytype2name'] = 'Wydajność bazy danych (#2)';
$string['redo'] = 'Rozpocznij test wydajności ponownie';
$string['score'] = 'Wynik';
$string['scoremsg'] = 'Wynik testu wydajności:';
$string['seconde'] = '{$a} s.';
$string['slowdatabaselabel'] = 'Baza danych wydaje się być zbyt wolna.';
$string['slowdatabasesolution'] = '<ul><li>Sprawdź <a href="https://mariadb.com/kb/en/library/mysqlcheck/" target="_blank">integralność bazy danych</a>.</li><li>Zoptymalizuj <a href="https://mariadb.com/kb/en/library/optimization-and-tuning/" target="_blank">bazę danych</a>.</li></ul>';
$string['slowharddrivelabel'] = 'Dysk wydaje się być zbyt wolny.';
$string['slowharddrivesolution'] = '<ul><li>Sprawdź stan dysku i/lub folderu tymczasowego.</li><li>Zmień dysk i/lub folder tymczasowy.</li></ul>';
$string['slowprocessorlabel'] = 'Procesor wydaje się być zbyt wolny.';
$string['slowprocessorsolution'] = '<ul><li>Sprawdź, czy konfiguracja sprzętu jest wystarczająca wydajna do uruchomienia Moodle.</li></ul>';
$string['slowserverlabel'] = 'Serwer WWW wydaje się być zbyt wolny.';
$string['slowserversolution'] = '<ul><li>Ustaw Apache w trybie <a href="https://httpd.apache.org/docs/2.4/en/mpm.html" target="_blank">wieloprocesorowym</a> lub przełącz się na <a href="https://nginx.org/" target="_blank">NGinx</a>.</li><li>Jeśli Moodle jest zainstalowany na Twoim komputerze, ostrożnie skonfiguruj oprogramowanie antywirusowe, aby nie sprawdzało instalacji Moodle.</li></ul>';
$string['slowweblabel'] = 'Strona logowania ładuje się zbyt wolno.';
$string['slowwebsolution'] = '<ul><li><a href="/admin/purgecaches.php" target="_blank">Wyczyść pamięć podręczną Moodle</a>.</li></ul>';
$string['start'] = 'Rozpocznij test wydajności';
$string['total'] = 'Całkowity czas';
