<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_catalogue', language 'it', version '5.0'.
 *
 * @package     tool_catalogue
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutthiscourse'] = 'Informazioni sul corso';
$string['aboutthisprogram'] = 'Informazioni sul programma';
$string['addrange'] = 'Aggiungi intervallo';
$string['all'] = 'Tutto';
$string['allavailablecourses'] = 'Tutti i corsi disponibili';
$string['allowhtmltags'] = 'Consenti tag HTML';
$string['aria:courseactions'] = 'Azioni del corso';
$string['cachedef_filters'] = 'Risultati e filtri della ricerca del catalogo formativo';
$string['catalogue'] = 'Catalogo';
$string['catalogue:config'] = 'Configurazione catalogo formativo';
$string['catalogueisdisabled'] = 'Il catalogo formativo è disabilitato';
$string['cataloguesettings'] = 'Impostazioni de I miei programmi e del catalogo dei corsi';
$string['categories'] = 'Categorie';
$string['categoriesdepthlimit'] = 'Numero massimo di livelli di categorie nidificate';
$string['categoriesdepthlimit_desc'] = 'Numero massimo di livelli di categorie nidificate nel selettore di categoria. I corsi situati ai livelli più profondi continueranno ad apparire nei risultati della ricerca.';
$string['categorieslimit'] = 'Numero massimo di categorie dello stesso livello';
$string['categorieslimit_desc'] = 'Numero massimo di categorie dello stesso livello nel selettore di categoria. Le categorie verranno visualizzate nello stesso ordine in cui sono definite nella pagina Gestione corso. Se sono presenti più categorie su un livello, le categorie non verranno visualizzate nel selettore ma tutti i corsi saranno visibili nei risultati della ricerca.';
$string['certifications'] = 'Certificazioni';
$string['certificationstatuscertified'] = 'La certificazione \'<strong>{$a->name}</strong>\' è completata';
$string['certificationstatuscertifiedwithdate'] = 'La certificazione \'<strong>{$a->name}</strong>\' è completata. Scadrà il \'<strong>{$a->date}</strong>\'';
$string['certificationstatusexpired'] = 'La certificazione \'<strong>{$a->name}</strong>\' è scaduta il expired on {$a->date}';
$string['certificationstatusopen'] = 'La certificazione \'<strong>{$a->name}</strong>\' non ha data limite';
$string['certificationstatusopenwithdate'] = 'Completare questo programma entro il \'<strong>{$a->date}</strong>\' per ottenere la certificazione \'<strong>{$a->name}</strong>\'';
$string['certificationstatusoverdue'] = 'La certificazione \'<strong>{$a->name}</strong>\'  doveva essere ottenuta entro il \'<strong>{$a->date}</strong>\'';
$string['clearall'] = 'Pulisci tutto';
$string['complete'] = 'Completato';
$string['completeatleast'] = 'Completare almeno {$a}';
$string['coursecoverhelp'] = 'Il corso fa parte del programma \'{$a}\'';
$string['coursecoverhelpmultiprogram'] = 'Il corso fa parte di alcuni programmi';
$string['coursecoverhelptext'] = '<ul><li>Questo è un corso che fa parte di un programma più ampio</li><li>Ulteriori corsi potrano essere visibili una volta completato questo corso.</li></ul>';
$string['coursedisplayduelimit'] = 'Visualizza i giorni rimanenti per i corsi';
$string['coursedisplayduelimit_desc'] = 'Numero di giorni a partire dai quali gli utenti visualizzeranno un piccolo promemoria (X giorni rimanenti) accanto al titolo del corso. Ad esempio, se impostato a 14, il promemoria sarà visibile nei 14 giorni che precedono la data di conclusione del corso. Nel caso di molte date di conclusione diverse, il sistema valuterà quale è la successiva più vicina. Impostare a 0 per disabilitare questa funzionalità.';
$string['coursefiles'] = 'File del corso';
$string['courseimage_help'] = 'L\'immagine del corso.';
$string['coursenotavailable'] = 'Corso non disponibile';
$string['courses'] = 'Corsi';
$string['coursesperpage_frontpage'] = 'Numero di corsi per pagina, pagina home';
$string['coursesperpage_frontpage_desc'] = 'Numero di corsi da visualizzare nella home page del sito quando "Elenco corsi" è incluso nell\'impostazione Elementi della home page del sito.';
$string['coursesperpage_main'] = 'Numero di corsi per pagina, pagina principale del catalogo';
$string['coursesperpage_main_desc'] = 'Numero di corsi da visualizzare nella pagina principale del catalogo prima che venga selezionata una categoria o venga fornita una query di ricerca e prima che vengano applicati eventuali filtri.';
$string['coursesperpage_search'] = 'Numero di corsi per pagina, risultati della ricerca';
$string['coursesperpage_search_desc'] = 'Numero di corsi da visualizzare nei risultati della ricerca dei corsi o quando viene selezionata la categoria.';
$string['dates'] = 'Date';
$string['daysleft'] = '{$a} giorni restanti';
$string['defaultsortorder'] = 'Ordinamento di default';
$string['deleterange'] = 'Elimina intervallo';
$string['display'] = 'Visualizzazione';
$string['displaycourseinfomodal'] = 'Visualizza informazioni sul corso in finestra modale';
$string['displayfieldlabel'] = 'Visualizza nome del campo';
$string['displayfields_desc'] = 'Selezionare tutti i campi che devono essere visualizzati come filtri e disporli nell\'ordine appropriato. Non tutti i tipi di campi personalizzati possono essere utilizzati nei filtri.<br>Le modifiche nella tabella precedente vengono salvate automaticamente.';
$string['displayfields_list'] = 'Campi da visualizzare nella vista \'elenco\' (dettagliata) del catalogo formativo';
$string['displayfields_tiles'] = 'Campi da visualizzare nella vista \'riquadri\' (compatta) del catalogo formativo';
$string['displayfieldscard_desc'] = 'Selezionare tutti i campi da visualizzare nella scheda del corso e disporli nell\'ordine appropriato.<br>Le modifiche nella tabella precedente vengono salvate automaticamente.';
$string['displayforeverybody'] = 'Visualizzabile da tutti';
$string['displayfornotadmin'] = 'Visualizzabile solo da utenti non amministratori';
$string['displayforstudentsandguests'] = 'Visualizzabile dagli ospiti e dagli studenti';
$string['displaynever'] = 'Non visualizzare';
$string['displayprogramcoverpage'] = 'Visualizza la pagina di copertina del programma';
$string['displaysummaryasis'] = 'Visualizza così com\'è';
$string['displaysummarynohtml'] = 'Visualizza senza HTML';
$string['displaysummarynone'] = 'Non visualizzare';
$string['displaywhenzeroprice'] = 'Visualizza se zero';
$string['displaywhenzeroprice_help'] = 'Come visualizzare il prezzo quando è disponibile un plugin di autoiscrizione senza pagamento.

Se lasciato vuoto, il campo prezzo non verrà visualizzato per i corsi gratuiti.';
$string['dontshowagain'] = 'Non visualizzare più';
$string['duedate'] = 'Ordina per data di conclusione';
$string['duedateinfo'] = 'Da fare entro 1 giorno';
$string['duedateinfodays'] = 'Da fare entro {$a} giorni';
$string['duedatex'] = '<strong>Data limite:</strong> {$a}';
$string['editfilterranges'] = 'Modifica intervalli filtro';
$string['editlabel'] = 'Modifica etichetta';
$string['enablelearningcatalogue'] = 'Abilita catalogo formativo';
$string['enablelearningcatalogue_desc'] = 'Abilitare l\'impostazione per consentire a tutti gli utenti l\'accesso al \'Catalogo\' nella navigazione principale. Il catalogo cosentirà di scoprire, filtrare e iscriversi facilmente ai corsi. Il catalogo Moodle Workplace sostituirà la pagina dei corsi standard per tutti gli utenti.
<br><br>Per ulteriori dettagli, fare riferimento alla <a href="{$a}">pagina della documentazione</a>.';
$string['enddate'] = 'Data di fine';
$string['enddatex'] = '<strong>Data di fine:</strong> {$a}';
$string['enrolmentplugin'] = 'Plugin di iscrizione';
$string['errornopermissionviewcoursecover'] = 'Non sei autorizzato a visualizzare la pagina di copertina del programma';
$string['errornopermissionviewprogram'] = 'Non sei autorizzato a visualizzare il programma';
$string['featuredcustomfield'] = 'Campo personalizzato in evidenza';
$string['featuredcustomfield_desc'] = 'Se il campo personalizzato selezionato è contrassegnato come \'selezionato\' in un corso, quel corso verrà visualizzato nella pagina principale del catalogo.';
$string['featuredlearning'] = 'Formazione in evidenza';
$string['featuredlearningdisabled'] = 'La sezione di formazione in evidenza è disattivata';
$string['featuredlearningsectionsummary'] = 'Descrizione della sezione in evidenza';
$string['featuredlearningsectionsummary_desc'] = 'Questo testo verrà visualizzato insieme ai corsi in evidenza nella sezione "In evidenza" nella pagina principale del catalogo.';
$string['featuredlearningsectiontitle'] = 'Titolo della sezione in evidenza';
$string['featuredlearningsectiontitle_default'] = 'In evidenza';
$string['featuredlearningsectiontitle_desc'] = 'Sostituisce il titolo della sezione \'In evidenza\' nel catalogo. Se lasciato vuoto, verrà visualizzato il titolo predefinito \'In evidenza\'.';
$string['fieldlabel'] = 'Nome del campo';
$string['fieldonlyvisibleincatalogue'] = 'Questo campo ha visibilità limitata nelle pagine delle informazioni sul corso e dell\'iscrizione, tuttavia può comunque essere reso disponibile nel catalogo formativo. Se abilitato qui, il campo sarà visibile a tutti.';
$string['filterfields'] = 'Campi da visualizzare nel filtro del catalogo formativo';
$string['formerror_maximumminimumempty'] = 'Fornire un valore minimo o massimo oppure abilitare \'Includi valori vuoti\'';
$string['formerror_minimumgreaterthanmaximum'] = 'Il valore minimo non può essere maggiore del valore massimo';
$string['formerror_rangeempty'] = 'Il filtro deve avere almeno un intervallo';
$string['free'] = 'Gratuito';
$string['headerdisplaysettings'] = 'Formato di visualizzazione';
$string['hiddenfromlearners'] = 'Nascosto  ai partecipanti';
$string['hidefieldname'] = 'Nascondi nome del campo';
$string['htmltagsall'] = 'Consenti tutti i tag HTML';
$string['htmltagsnone'] = 'Rimuovi tutti i tag HTML';
$string['htmltagssafe'] = 'Solo tag HTML sicuri';
$string['includeemptyvalues'] = 'Includi valori vuoti';
$string['incomplete'] = 'Non completato';
$string['information'] = 'Informazioni';
$string['iunderstand'] = 'Ho capito';
$string['lastaccess'] = 'Ordina per ultimo accesso';
$string['learningcataloguesettings'] = 'Impostazioni catalogo formativo';
$string['maximumvalue'] = 'Valore massimo';
$string['maximumvalue_help'] = 'Indicare il valore più alto diquesto intervallo oppure lasciare vuoto per non avere limiti.';
$string['minimumvalue'] = 'Valore minimo';
$string['minimumvalue_help'] = 'Indicare il valore più basso di questo intervallo oppure lasciare vuoto per non avere limiti.';
$string['moreinfo'] = 'Ulteriori informazioni';
$string['mycourses'] = 'La mia formazione';
$string['name'] = 'Ordina per nome';
$string['noresultsfor'] = 'Nessun risultato per \'{$a}\'';
$string['notavailableunless'] = 'Non disponibile finché non sarà disponibile \'{$a}\'';
$string['notavailableuntil'] = 'Non disponibile finché \'{$a}\' non sarà completato';
$string['notnow'] = 'Non adesso';
$string['notset'] = 'Non impostato';
$string['notspecified'] = 'Non specificato';
$string['numberequalorgreaterthan'] = 'Maggiore o uguale';
$string['numberequalorlessthan'] = 'Minore o uguale';
$string['numbergreaterthan'] = 'Maggiore di';
$string['numberlessthan'] = 'Minore di';
$string['overdue'] = 'In ritardo';
$string['overvalue'] = 'Superiore a {$a}';
$string['pagealastpage'] = 'Pagina {$a}, ultima pagina';
$string['pageamorepagesahead'] = 'Pagina {$a}, altre pagine avanti';
$string['pagination'] = 'Paginazione';
$string['pluginname'] = 'Catalogo della formazione';
$string['price'] = 'Prezzo dai plugin di iscrizione';
$string['price_currency'] = 'Valuta';
$string['price_currency_help'] = 'Inserire un codice valuta di 3 lettere. Assicurarsi che questo codice corrisponda al codice valuta utilizzato nei metodi di iscrizione disponibili per il corso.';
$string['price_enrolplugins'] = 'Plugin di iscrizione';
$string['price_enrolplugins_help'] = '<p>Seleziona i metodi di iscrizione da controllare tra quelli che consentono agli studenti di iscriversi autonomamente a un corso. Se esiste un\'istanza corrispondente con la valuta specificata, il prezzo verrà estratto automaticamente. Le istanze senza valuta (ad esempio, \'Iscrizione spontanea\') saranno considerate come se avessero prezzo \'0\'.</p>
<p>Se esistono più istanze di metodi che consentono agli studenti di iscriversi autonomamente a un corso, verrà visualizzato il prezzo più basso.</p>
<p>Nota: testare attentamente i plugin di iscrizione aggiuntivi prima di abilitarli, poiché potrebbero archiviare i dati in modo diverso, influenzando l\'estrazione del prezzo.</p>';
$string['privacy:metadata:preference:tool_catalogue_collapse_recently_accessed_courses'] = 'Stato di contrazione della sezione "Corsi acceduti di recente"';
$string['privacy:metadata:preference:tool_catalogue_hide_program_cover_help'] = 'Visualizzazione della pagina di copertina del programma';
$string['privacy:metadata:preference:tool_catalogue_my_courses_filter'] = 'Filtraggio di programmi/corsi per tutto/corsi/programmi/completati/non completati';
$string['privacy:metadata:preference:tool_catalogue_my_courses_sort'] = 'Tipo di ordinamento di programmi/corsi per nome/data limite/Ultimo accesso';
$string['privacy:metadata:showprogramcoverhelp'] = 'Visibilità della pagina di copertina del programma';
$string['privacy:request:preference:set'] = 'Valore dell\'impostazione \'{$a->name}\' impostata a \'{$a->value}\'';
$string['proceedtocourse'] = 'Vai al contenuto del corso';
$string['proceedtoprogram'] = 'Vai al contenuto del programma';
$string['program'] = 'Programma';
$string['programdisplayduelimit'] = 'Visualizza gironi rimanenti antecedenti la data limite del programma';
$string['programdisplayduelimit_desc'] = 'Numero di giorni a partire dai quali gli utenti visualizzeranno un piccolo promemoria (X giorni rimanenti) accanto al titolo del programma. Ad esempio, se impostato a 14, il promemoria sarà visibile nei 14 giorni che precedono la data limite del programma. Impostare a 0 per disabilitare questa funzionalità.';
$string['programempty'] = 'Il programma non contiene corsi';
$string['programhelptext'] = '<ul><li>I programmi possono contenere più corsi</li><li>Completare i corsi per completare il programma</li></ul>';
$string['programhelptitle'] = 'Che cos\'è un programma?';
$string['programimage_help'] = 'L\'immagine del programma.';
$string['programlink'] = 'Visualizza "{$a}" dettagli';
$string['programlinksingle'] = 'Visualizza dettagli del programma';
$string['programs'] = 'Programmi';
$string['programstructure'] = 'Struttura del programma';
$string['progress'] = '{$a}% completato';
$string['progresscompleted'] = '{$a->completed} su {$a->total} completati';
$string['rangename'] = 'Nome intervallo';
$string['rangename_help'] = 'Questo nome verrà visualizzato dagli utenti nel pannello filtro. Se lasciato vuoto, il nome dell\'intervallo verrà creato automaticamente a partire dal limite dell\'intervallo.';
$string['rangevalue'] = '{$a->min} - {$a->max}';
$string['recentlyaccessedcourses'] = 'Corsi acceduti di recente';
$string['reg_wpcatalogueashome'] = 'Il catalogo è abilitato e aggiunto alla home page del sito ({$a})';
$string['reg_wpcatalogueenabled'] = 'Il catalogo è abilitato ({$a})';
$string['reg_wpcataloguefeatured'] = 'Se la sezione dei corsi in evidenza nel catalogo è abilitata ({$a})';
$string['reg_wpcataloguehighlighted'] = 'Se l\'evidenziazione dei corsi in evidenza è abilitata ({$a})';
$string['reg_wpcataloguenumberofpricecustomfields'] = 'Numero di campi personalizzati con tipo di campo \'Prezzo dai plugin di iscrizione\' ({$a})';
$string['reg_wpcataloguepublic'] = 'Il catalogo è abilitato e disponibile per gli ospiti ({$a})';
$string['reindextaskname'] = 'Reindicizzazione regolare dei corsi del catalogo';
$string['resultsfor'] = '{$a->count} risultati per \'{$a->keywords}\'';
$string['safehtmltags'] = 'Tag HTML sicuri nei campi di riepilogo e di testo';
$string['safehtmltags_desc'] = 'Elenco dei tag HTML da preservare durante la visualizzazione del Riepilogo del corso o dei campi personalizzati del corso nel Catalogo didattico. Tutti gli altri tag verranno rimossi per garantire che i riepiloghi dei corsi non rompano il layout del catalogo.<br>Tieni presente che per i riepiloghi dei corsi i tag HTML potrebbero non funzionare bene insieme all\'impostazione \'Tronca\'.';
$string['searchfields'] = 'Campi per la ricerca di parole chiave';
$string['searchfields_desc'] = 'Selezionare tutti i campi del corso in cui cercare la parola chiave e disporli in ordine di priorità.<br>Le modifiche nella tabella precedente vengono salvate automaticamente.';
$string['searchmethod'] = 'Metodo di ricerca dei corsi';
$string['searchmethod_desc'] = 'Selezionare un metodo che verrà utilizzato per la ricerca dei corsi. Alcuni metodi possono richiedere una reindicizzazione regolare e/o una configurazione aggiuntiva.';
$string['searchmethod_extended'] = 'Ricerca estesa';
$string['searchmethod_simple'] = 'Ricerca semplice';
$string['searchplaceholder'] = 'Cerca corsi o programmi';
$string['selectenrolmentmethod'] = 'Seleziona un metodo di iscfizione';
$string['showcataloguecoursecategory'] = 'Visualizza categorie di corsi nelle schede dei corsi';
$string['showcataloguecoursecategory_desc'] = 'La categoria di corsi sarà visibile in ogni scheda del corso presenti nella "Dashboard", ne "I miei corsi" e in alcuni blocchi.';
$string['showcoursedates'] = 'Visualizza le date dei corsi nella finestra modale';
$string['showcoursedates_desc'] = 'Le date del corso saranno visibili nella finestra modale del corso e nella scheda delle informazioni sul corso.';
$string['showfeaturedsection'] = 'Visualizza la sezione in evidenza nel catalogo';
$string['showfeaturedsection_desc'] = 'Consente di visualizzare i corsi in evidenza in una sezione autonoma nella parte superiore della pagina principale del catalogo.';
$string['showfieldname'] = 'Visualizza nome del campo';
$string['showmore'] = 'Visualizza altri {$a}...';
$string['startdate'] = 'Data d\'inizio';
$string['startdatex'] = '<strong>Data di inizio:</strong> {$a}';
$string['todo'] = 'Da fare:';
$string['trainers'] = 'Trainer';
$string['truncatesummary'] = 'Troncamento del riepilogo del corso';
$string['truncatesummary_desc'] = 'Numero massimo di caratteri da visualizzare nel riepilogo del corso. Impostare a 0 per non troncare. È anche possibile  ridurre i caratteri mediante CSS.<br>Questa impostazione controlla il testo inviato dal server al browser. È anche possibile optare per troncare singoli campi direttamente nel browser utilizzando CSS personalizzati.';
$string['trydifferentskeyword'] = 'Provare a utilizzare parole chiave o configurazioni di filtro diverse';
$string['undervalue'] = 'Inferiore a {$a}';
$string['xcourses'] = '{$a} corsi';
