<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_certification', language 'id', version '5.0'.
 *
 * @package     tool_certification
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Tindakan';
$string['actions'] = 'Tindakan';
$string['active'] = 'Aktif';
$string['activecertifications'] = 'Sertifikasi aktif';
$string['afteractualcertcompletion'] = 'Setelah sertifikasi saat ini selesai';
$string['afteractualcertcompletionwithrelativedate'] = '{$a} setelah sertifikasi saat ini selesai';
$string['afterallocationdate'] = 'Setelah tanggal alokasi';
$string['afterallocationdatewithrelativedate'] = '{$a} setelah tanggal alokasi';
$string['aftercompletion'] = 'Setelah selesai';
$string['aftercompletionwithrelativedate'] = '{$a} setelah selesai';
$string['afterduedate'] = 'Setelah tanggal jatuh tempo';
$string['afterduedatewithrelativedate'] = '{$a} setelah tanggal jatuh tempo';
$string['afterlatest'] = 'Setelah penyelesaian atau kedaluwarsa saat ini';
$string['afterlatestwithrelativedate'] = '{$a} setelah penyelesaian atau kedaluwarsa saat ini';
$string['afterpreviouscertexpdate'] = 'Setelah tanggal kedaluwarsa sertifikasi sebelumnya';
$string['afterpreviouscertexpdatewithrelativedate'] = '{$a} setelah tanggal kedaluwarsa sertifikasi sebelumnya';
$string['afterstartdate'] = 'Setelah tanggal mulai';
$string['afterstartdatewithrelativedate'] = '{$a} setelah tanggal mulai';
$string['allocatetocertification'] = 'Alokasikan ke sertifikasi';
$string['allocatetocertifications'] = 'Alokasikan ke sertifikasi...';
$string['allocateusers'] = 'Alokasikan pengguna';
$string['allocateuserstocertification'] = 'Alokasikan pengguna ke sertifikasi...';
$string['allocationdate'] = 'Tanggal alokasi';
$string['allocationdateisonorafter'] = 'Tanggal alokasi pada atau setelah';
$string['allocationdefaultvalue'] = 'Sama seperti yang didefinisikan dalam sertifikasi (Bawaan)';
$string['allocationenddate'] = 'Tanggal akhir alokasi';
$string['allocationfor'] = 'Alokasi untuk \'{$a}\'';
$string['allocationsource'] = 'Sumber alokasi';
$string['allocationstartdate'] = 'Tanggal mulai alokasi';
$string['allocationwindowenddate'] = 'Tanggal akhir';
$string['allocationwindowenddate_help'] = 'Tanggal akhir untuk jendela alokasi';
$string['allocationwindowendedon'] = 'Jendela alokasi untuk sertifikasi ini berakhir pada {$a}.';
$string['allocationwindowstartdate'] = 'Tanggal mulai';
$string['allocationwindowstartdate_help'] = 'Tanggal mulai untuk jendela alokasi';
$string['allocationwindowstartson'] = 'Jendela alokasi untuk sertifikasi ini dimulai pada {$a}.';
$string['archive'] = 'Arsip';
$string['archived'] = 'Diarsip';
$string['archivedcertifications'] = 'Sertifikat yang diarsip';
$string['archivedconfirmation'] = 'Apakah Anda yakin ingin mengarsip sertifikasi \'{$a}\'? Sertifikasi yang diarsip tidak akan tersedia lagi bagi manajer atau peserta didik dan hanya dapat dilihat dalam laporan historis.';
$string['archivedon'] = 'Diarsipkan pada';
$string['autocreategroups'] = 'Tambahkan ke grup kursus';
$string['autocreategroups_help'] = 'Saat pengguna terdaftar dalam program kursus, mereka dapat secara otomatis ditambahkan ke grup yang sama. Jika "untuk sertifikasi ini" dipilih, grup terpisah untuk sertifikasi ini akan digunakan dan akan berbeda dari sertifikasi lain yang menggunakan program yang sama.';
$string['autocreategroupsasinprogram'] = 'Seperti yang didefinisikan dalam program';
$string['autocreategroupscertification'] = 'Buat grup untuk sertifikasi ini';
$string['becamecertified'] = 'Mendapatkan sertifikasi ({$a})';
$string['beforepreviouscertexpdate'] = 'sebelum tanggal kedaluwarsa sertifikasi sebelumnya';
$string['calendarduedate'] = 'Tanggal jatuh tempo sertifikasi {$a}';
$string['calendarexpirydate'] = 'Tanggal kedaluwarsa untuk sertifikasi {$a}';
$string['certification'] = 'Sertifikasi';
$string['certification:allocateuser'] = 'Izin untuk mengalokasikan pengguna';
$string['certification:configurecustomfields'] = 'Konfigurasikan bidang kustom sertifikasi';
$string['certification:edit'] = 'Izin untuk menyunting';
$string['certificationdates'] = 'Tanggal';
$string['certificationdates_help'] = 'Pilih tanggal yang berlaku untuk alokasi sertifikasi ini:

* **Sama seperti yang ditetapkan dalam sertifikasi:** Tanggal yang ditetapkan dalam sertifikasi akan digunakan.
* **Pilih tanggal:** Anda dapat memilih tanggal tertentu (mulai, jatuh tempo) untuk alokasi sertifikasi ini.';
$string['certificationfullname'] = 'Nama lengkap sertifikasi';
$string['certificationfullname_help'] = 'Nama lengkap sertifikasi';
$string['certificationidnumber'] = 'Nomor ID Sertifikasi';
$string['certificationidnumber_help'] = 'Nomor ID sertifikasi hanya digunakan saat mencocokkan sertifikasi dengan sistem eksternal dan tidak ditampilkan di mana pun di situs. Jika sertifikasi memiliki nama kode resmi, nama tersebut dapat dimasukkan, jika tidak, kolom tersebut dapat dibiarkan kosong.';
$string['certificationname'] = 'Nama sertifikasi';
$string['certificationnamewitheditlink'] = 'Nama sertifikasi dengan tautan untuk disunting';
$string['certificationprogress'] = 'Kemajuan sertifikasi';
$string['certificationprogressexport'] = 'kemajuan sertifikasi {$a}';
$string['certificationrules'] = 'Aturan sertifikasi';
$string['certifications'] = 'Sertifikasi';
$string['certificationscustomfield'] = 'Kolom kustom sertifikasi';
$string['certificationslink'] = '<a href="{$a->href}">{$a->count} sertifikasi</a>';
$string['certificationslink_plural'] = '<a href="{$a->href}">{$a->count} sertifikasi</a>';
$string['certificationstatus'] = 'Status sertifikasi';
$string['certificationstatus_help'] = 'Status sertifikasi saat ini';
$string['certificationtags'] = 'Tag sertifikasi';
$string['certificationtags_help'] = 'Tag untuk sertifikasi ini';
$string['certificationtenant'] = 'Penyewa sertifikasi';
$string['certificationuserlog'] = 'log aktivitas {$a}';
$string['certificationuserlogempty'] = 'Tidak ada log event untuk sertifikasi pengguna ini.';
$string['certificationuserlogfilename'] = 'Log aktivitas {$a->user} {$a->certification}';
$string['certified'] = 'Bersertifikat';
$string['certifiedandrevoked'] = 'Disertifikasi dan dicabut';
$string['certifiedby'] = 'Disertifikasi oleh';
$string['certifiedcertificationslink'] = '<a href="{$a->href}">{$a->count} sertifikasi bersertifikat</a>';
$string['certifieddate'] = 'Tanggal bersertifikat';
$string['certifieddateisonorafter'] = 'Tanggal sertifikasi pada atau setelah';
$string['certifiednotification'] = 'Pengguna telah berhasil disertifikasi';
$string['certifiedtype'] = 'Tipe bersertifikat';
$string['certify'] = 'Sertifikasi';
$string['certifycertifieddate'] = 'Tanggal tersertifikasi';
$string['certifycertifieddate_help'] = 'Pilih tanggal tersertifikasi untuk pengguna ini antara \'Sekarang\' (sertifikasi pengguna akan segera tersertifikasi), atau tanggal khusus di masa lalu.';
$string['certifyexpirydate'] = 'Tanggal kedaluwarsa';
$string['certifyexpirydate_help'] = 'Pilih tanggal kedaluwarsa untuk pengguna bersertifikat ini antara \'Bawaan\' (menampilkan konfigurasi sertifikasi saat ini), \'Tidak Pernah\' atau tanggal khusus.';
$string['certifyuser'] = 'Sertifikasi pengguna';
$string['completedtheprogram'] = 'Menyelesaikan program {$a}';
$string['conditioncertificationcertified'] = 'Sertifikasi bersertifikat';
$string['conditioncertificationcertifieddescription'] = 'Pengguna yang tersertifikasi dalam sertifikasi \'{$a->fullname}\'';
$string['conditioncertificationcertifieddescriptionall'] = 'Pengguna yang tersertifikasi dalam semua sertifikasi berikut: \'{$a->fullname}\'';
$string['conditioncertificationcertifieddescriptionallwithdate'] = 'Pengguna yang tersertifikasi dalam semua sertifikasi berikut: \'{$a->fullname}\'<br />
Tanggal sertifikasi pada atau setelah \'{$a->conditiondate}\'';
$string['conditioncertificationcertifieddescriptionany'] = 'Pengguna yang tersertifikasi setidaknya dalam salah satu sertifikasi berikut: \'{$a->fullname}\'';
$string['conditioncertificationcertifieddescriptionanywithdate'] = 'Pengguna yang tersertifikasi setidaknya dalam salah satu sertifikasi berikut: \'{$a->fullname}\'<br />
Tanggal sertifikasi pada atau setelah \'{$a->conditiondate}\'';
$string['conditioncertificationcertifieddescriptiononrecert'] = 'Eksekusikan untuk setiap sertifikasi ulang';
$string['conditioncertificationcertifieddescriptionstatusonly'] = 'Hanya eksekusikan pada perubahan status';
$string['conditioncertificationcertifieddescriptionwithdate'] = 'Pengguna yang tersertifikasi dalam sertifikasi \'{$a->fullname}\'<br />
Tanggal sertifikasi pada atau setelah \'{$a->conditiondate}\'';
$string['conditioncertificationcertifiedonrecert'] = 'Selalu lakukan tindakan pada semua sertifikasi ulang';
$string['conditioncertificationcertifiedonrecert_help'] = 'Ini akan secara efektif mengubah kondisi menjadi <b>"Pengguna tersertifikasi dan periode sertifikasi ulang belum dibuka"</b>. Ini akan memastikan bahwa pengguna ditandai sebagai "tidak cocok" saat sertifikasi ulang dibuka, dan tindakan akan dijalankan lagi untuk mereka setelah program selesai, meskipun mereka terus tersertifikasi sepanjang waktu.';
$string['conditioncertificationcertifiedstatusonly'] = 'Hanya eksekusikan tindakan ketika status pengguna berubah dari "tidak bersertifikat" menjadi "bersertifikat"';
$string['conditioncertificationcertifiedstatusonly_help'] = 'Dalam kasus ini, tindakan dapat atau tidak dapat dijalankan pada sertifikasi ulang, tergantung pada apakah sertifikasi sebelumnya telah kedaluwarsa atau belum. Untuk memastikan bahwa tindakan <b>tidak pernah</b> dijalankan selama sertifikasi ulang, pertimbangkan untuk menetapkan "Batas tindakan aturan" dalam pengaturan aturan.';
$string['conditioncertificationexpired'] = 'Sertifikasi telah kedaluwarsa';
$string['conditioncertificationexpireddescription'] = 'Pengguna yang sertifikasinya \'{$a}\' telah kedaluwarsa';
$string['conditioncertificationexpireddescriptionwithdate'] = 'Pengguna yang sertifikasinya \'{$a->fullname}\' telah kedaluwarsa <br />
Tanggal kedaluwarsa adalah pada atau setelah \'{$a->conditiondate}\'';
$string['conditioncertificationnotcertified'] = 'Sertifikasi belum disertifikasi';
$string['conditioncertificationnotcertifieddescription'] = 'Pengguna yang tidak tersertifikasi dalam sertifikasi \'{$a}\'';
$string['conditioncertificationoverdue'] = 'Sertifikasi terlambat';
$string['conditioncertificationoverduedescription'] = 'Pengguna yang terlambat dalam sertifikasi \'{$a}\'';
$string['conditioncertificationoverduedescriptionwithdate'] = 'Pengguna yang terlambat dalam sertifikasi \'{$a->fullname}\'<br />
Tanggal jatuh tempo adalah pada atau setelah \'{$a->conditiondate}\'';
$string['conditioncertificationsuspended'] = 'Sertifikasi ditangguhkan';
$string['conditioncertificationsuspendeddescription'] = 'Pengguna yang ditangguhkan dalam sertifikasi \'{$a}\'';
$string['conditioncertificationsuspendeddescriptionwithdate'] = 'Pengguna yang ditangguhkan dalam sertifikasi \'{$a->fullname}\'<br />
Tanggal penangguhan adalah pada atau setelah \'{$a->conditiondate}\'';
$string['conditionrecertificationgraceperiod'] = 'Masa tenggang sertifikasi ulang telah berakhir';
$string['conditionrecertificationgraceperiodendsdescription'] = 'Pengguna yang masa tenggangnya berakhir pada sertifikasi \'{$a->fullname}\'';
$string['conditionrecertificationgraceperiodendsdescriptionwithdate'] = 'Pengguna yang masa tenggangnya berakhir pada sertifikasi \'{$a->fullname}\'<br />
Masa tenggang sertifikasi ulang berakhir pada atau sebelum \'{$a->conditiondate}\'';
$string['conditionrecertificationstarted'] = 'Periode sertifikasi ulang dimulai';
$string['conditionrecertificationstarteddescription'] = 'Pengguna yang telah memulai periode sertifikasi ulang dalam sertifikasi \'{$a->fullname}\'';
$string['conditionrecertificationstarteddescriptionwithdate'] = 'Pengguna yang telah memulai periode sertifikasi ulang dalam sertifikasi \'{$a->fullname}\'<br />
Sertifikasi ulang dimulai pada atau setelah \'{$a->conditiondate}\'';
$string['conditionuserallocated'] = 'Pengguna yang dialokasikan untuk sertifikasi';
$string['conditionuserallocateddescription'] = 'Pengguna yang dialokasikan untuk sertifikasi \'{$a}\'';
$string['conditionuserallocateddescriptionwithdate'] = 'Pengguna yang dialokasikan untuk sertifikasi \'{$a->fullname}\'<br />
Tanggal alokasi adalah pada atau setelah \'{$a->conditiondate}\'';
$string['conditionusernotallocated'] = 'Pengguna tidak dialokasikan untuk sertifikasi';
$string['conditionusernotallocateddescription'] = 'Pengguna tidak dialokasikan untuk sertifikasi \'{$a}\'';
$string['confirmdeallocateusers'] = 'Tindakan ini akan menghapus alokasi dan data terkait untuk semua pengguna yang dipilih. Tindakan ini tidak dapat dibatalkan.';
$string['confirmdeallocateusersheader'] = 'De-alokasi pengguna';
$string['confirmdeletecertification'] = 'Apakah Anda yakin ingin menghapus sertifikasi \'{$a}\' dan data terkait? Tindakan ini tidak dapat dibatalkan.';
$string['confirmdeleteuserallocation'] = 'Apakah Anda yakin ingin menghapus alokasi pengguna \'{$a}\' dan data terkait secara menyeluruh? Tindakan ini tidak dapat dibatalkan.';
$string['confirmduplicate'] = 'Salinan konfigurasi sertifikasi akan dibuat dan Anda akan dapat mengubah program dan properti lainnya. Tidak ada alokasi pengguna yang akan dibawa ke salinan tersebut.';
$string['content'] = 'Konten';
$string['criteriaall'] = 'Semua sertifikasi yang dipilih telah disertifikasi';
$string['criteriaany'] = 'Setidaknya salah satu sertifikasi yang dipilih disertifikasi';
$string['criteriaany_help'] = 'Jika pengguna sudah tersertifikasi dalam salah satu sertifikasi, sertifikasi dalam sertifikasi kedua tidak akan memicu tindakan lagi';
$string['criteriaeach'] = 'Setiap kali pengguna disertifikasi dalam salah satu sertifikasi yang dipilih';
$string['criteriaeach_help'] = 'Setara dengan membuat beberapa aturan, satu untuk setiap sertifikasi yang dipilih';
$string['currentcertification'] = 'Sertifikasi saat ini';
$string['currentprogram'] = 'Program saat ini';
$string['currentprogram_help'] = 'Ini adalah program saat ini yang sedang diikuti pengguna ini';
$string['currentprogramprogress'] = 'Kemajuan program saat ini';
$string['currentprogramstatus'] = 'Status program saat ini';
$string['dateoverrided'] = 'Tanggal ditimpa';
$string['dayssinceallocation'] = 'Hari sejak alokasi';
$string['daystakingcertification'] = 'Hari mengambil sertifikasi';
$string['deallocateusers'] = 'De-alokasikan pengguna';
$string['default'] = 'Bawaan';
$string['deleteallocation'] = 'Hapus alokasi';
$string['deleteuserallocation'] = 'Hapus alokasi pengguna';
$string['displaycertificationdate'] = 'Tanggal sertifikasi';
$string['displaycertificationduedate'] = 'Tanggal jatuh tempo sertifikasi';
$string['displaycertificationid'] = 'ID sertifikasi internal yang digunakan di URL';
$string['displaycertificationname'] = 'Nama sertifikasi';
$string['displaycertificationprogramname'] = 'Nama program inisial untuk sertifikasi ini';
$string['displaycertificationreopen'] = 'Tanggal mulai sertifikasi ulang';
$string['displayexpirydate'] = 'Tanggal kedaluwarsa sertifikasi';
$string['displayexpirydatetimestamp'] = 'Stempel waktu tanggal kedaluwarsa sertifikasi';
$string['displaygraceperiodend'] = 'Tanggal berakhirnya masa tenggang';
$string['displayrecertificationprogramname'] = 'Nama program sertifikasi ulang';
$string['dontchange'] = 'Jangan berubah';
$string['duedate'] = 'Tanggal jatuh tempo';
$string['duedate_help'] = 'Tanggal jatuh tempo sertifikasi';
$string['duedateisonorafter'] = 'Tanggal jatuh tempo pada atau setelah';
$string['duplicate'] = 'Duplikat';
$string['dynamic'] = 'Dinamis';
$string['dynamicrules'] = 'Aturan dinamis';
$string['dynamicrulesplugincheck'] = 'Melihat daftar aturan dinamis tidak mungkin dilakukan tanpa pengaya tool_dynamicrules';
$string['dynamicrulewarningdeallocation'] = 'Pengguna hanya dapat dibatalkan alokasinya jika mereka dialokasikan oleh aturan dinamis lainnya, alokasi manual tidak akan terpengaruh.';
$string['editallocation'] = 'Sunting alokasi';
$string['editcertificationname'] = 'Sunting nama sertifikasi';
$string['editstatusanddates'] = 'Sunting status dan tanggal';
$string['editstatusanddatesbulk'] = 'Sunting status dan tanggal untuk beberapa pengguna';
$string['enddate'] = 'Tanggal akhir';
$string['entitycertification'] = 'Sertifikasi';
$string['entitycertificationusers'] = 'Alokasi dan penyelesaian pengguna sertifikasi';
$string['errorallocatinguserintorelatedprogram'] = 'Tidak dapat mengalokasikan pengguna ke program terkait';
$string['errorallocationsourcenotfound'] = 'Sumber alokasi tidak ditemukan';
$string['erroralreadycertified'] = 'Pengguna sudah tersertifikasi dalam sertifikasi ini dengan tanggal mulai ini.';
$string['errorcannotallocate'] = 'Tidak dapat mengalokasikan pengguna ke sertifikasi (alokasi sudah ada atau tidak diizinkan)';
$string['errorcantdeletecertification'] = 'Tidak dapat menghapus sertifikasi';
$string['errorcantdeletenotarchivedcertification'] = 'Tidak dapat menghapus sertifikasi yang tidak diarsip';
$string['errorcantmanageusers'] = 'Tidak dapat mengelola pengguna';
$string['errorcantrestorecertification'] = 'Tidak dapat memulihkan sertifikasi';
$string['errorcertificationdateinfuture'] = 'Tanggal sertifikasi harus berada di masa lalu.';
$string['errorcertificationsdontexist'] = 'Beberapa sertifikasi tidak ada';
$string['errorcouldnotallocate'] = 'Tidak dapat mengalokasikan pengguna \'{$a->originaluserfullname}\' ke sertifikasi \'{$a->certification}\'';
$string['errorevaluatinguserallocationstatus'] = 'Galat dalam mengevaluasi status alokasi pengguna';
$string['errorexpirydatepreviouscertifieddate'] = 'Tanggal kedaluwarsa tidak boleh sebelum tanggal yang disertifikasi';
$string['errorexpirydatepreviousduedate'] = 'Tanggal kedaluwarsa tidak boleh sebelum tanggal jatuh tempo';
$string['erroridnumberuniquetenant'] = 'Nomor ID ini sudah digunakan dalam sertifikasi lain';
$string['errorinvalidcertification'] = 'Sertifikasi tidak valid';
$string['errorinvaliddate'] = 'Tanggal tidak valid';
$string['errorinvalidpastduedate'] = 'Tanggal jatuh tempo tidak boleh sebelum tanggal mulai';
$string['errorinvalidpastexpirydate'] = 'Tanggal kedaluwarsa tidak boleh berada di masa lalu';
$string['errorinvalidpaststartdate'] = 'Tanggal mulai tidak boleh di masa lalu';
$string['errorinvalidtimecertified'] = 'Waktu yang disertifikasi tidak dapat dilakukan di masa mendatang.';
$string['errormissingassociatedprogram'] = 'Program terkait hilang';
$string['errormissingexpirydate'] = 'Tanggal kedaluwarsa hilang';
$string['errornopermissionallocateusers'] = 'Tidak ada izin untuk mengalokasikan pengguna ke sertifikasi';
$string['errornopermissioncertifyuser'] = 'Pengguna ini tidak dapat ditandai sebagai tersertifikasi karena mereka sudah ditandai sebagai tersertifikasi atau Anda tidak memiliki izin untuk melakukan tindakan ini';
$string['errornopermissionmanagecertifications'] = 'Tidak ada izin untuk mengelola sertifikasi';
$string['errornopermissionviewallocatedusers'] = 'Tidak ada izin untuk melihat pengguna yang dialokasikan dalam sertifikasi';
$string['errornopermissionviewreports'] = 'Tidak ada izin untuk melihat laporan';
$string['errornothingtoexportforcertifications'] = 'Tidak ada yang perlu diekspor untuk sertifikasi bersama: {$a}';
$string['errorrecertificationprogram'] = 'Program harus berbeda dari program inisial';
$string['errorreporttypedoesnotexist'] = 'Tipe laporan tidak ada';
$string['errorsameidnumber'] = 'Sertifikasi dengan nomor ID yang sama sudah ada';
$string['erroruseralreadyallocatedincertification'] = 'Pengguna sudah dialokasikan dalam sertifikasi';
$string['erroruseralreadyallocatedinprogram'] = 'Pengguna sudah dialokasikan dalam program';
$string['errorusernotinsametenant'] = 'Pengguna tidak berada di penyewa yang sama';
$string['eventcertificationcompleted'] = 'Sertifikasi selesai';
$string['eventcertificationcreated'] = 'Sertifikasi dibuat';
$string['eventcertificationdeleted'] = 'Sertifikasi dihapus';
$string['eventcertificationupdated'] = 'Sertifikasi diperbarui';
$string['eventrecertificationgraceperiodended'] = 'Masa tenggang sertifikasi ulang telah berakhir';
$string['eventrecertificationstarted'] = 'Sertifikasi ulang dimulai';
$string['eventuserallocated'] = 'Dialokasikan ke sertifikasi';
$string['eventuserdeallocated'] = 'Pengguna dide-alokasi';
$string['eventuserupdated'] = 'Alokasi pengguna diperbarui';
$string['expired'] = 'Kedaluwarsa';
$string['expiredcertificationslink'] = '<a href="{$a->href}">{$a->count} sertifikasi yang telah kedaluwarsa</a>';
$string['expireddateisonorafter'] = 'Tanggal kedaluwarsa pada atau setelah';
$string['expireson'] = 'berakhir pada {$a}';
$string['expirydate'] = 'Tanggal kedaluwarsa';
$string['expirydate_help'] = 'Tanggal kedaluwarsa untuk sertifikasi';
$string['export_content'] = 'Pengaturan';
$string['export_content_help'] = 'Sertifikasi, nama, deskripsi, tanggal, tag, dll.';
$string['export_dynamic_rules'] = 'Aturan dinamis';
$string['export_dynamic_rules_help'] = 'Semua konfigurasi aturan dinamis untuk sertifikasi ini';
$string['export_programs'] = 'Program terasosiasi';
$string['export_programs_help'] = 'Program, nama, deskripsi, tanggal, tag, dll.';
$string['export_user_allocations'] = 'Alokasi pengguna sertifikasi';
$string['export_user_allocations_help'] = 'Termasuk alokasi pengguna untuk sertifikasi ini. Salinan pengguna itu sendiri tidak akan disertakan.';
$string['exportcertificationsdescription'] = 'Sertifikasi dengan program, kursus, alokasi pengguna, dan aturan dinamis komponen terkait';
$string['exportonlyallocationspostfix'] = '(hanya alokasi pengguna)';
$string['fullcertificationreport'] = 'Laporan sertifikasi lengkap';
$string['futureallocation'] = 'Alokasi masa mendatang';
$string['gotocertification'] = 'Pergi ke sertifikasi';
$string['historicalcertificationcompletion'] = 'Penyelesaian historis pengguna sertifikasi';
$string['historicalstatus'] = 'Status historis';
$string['idnumber'] = 'Nomor ID';
$string['import_content'] = 'Pengaturan';
$string['import_content_help'] = 'Sertifikasi, nama, deskripsi, tanggal, tag, dll.';
$string['import_dynamic_rules'] = 'Aturan dinamis';
$string['import_dynamic_rules_help'] = 'Semua konfigurasi aturan dinamis untuk program ini.';
$string['import_programs'] = 'Program terasosiasi';
$string['import_programs_help'] = 'Program, nama, deskripsi, tanggal, tag, dll.';
$string['import_user_allocations'] = 'Alokasi pengguna sertifikasi';
$string['import_user_allocations_help'] = 'Termasuk alokasi pengguna untuk sertifikasi ini.';
$string['importcannotallocate'] = 'Tidak mungkin untuk mengalokasikan pengguna \'{$a->originaluserfullname}\' ke sertifikasi \'{$a->certification}\', alokasi sudah ada atau tidak diizinkan';
$string['importlogfailed'] = 'Tidak dapat mengimpor sertifikasi \'{$a->fullname}\'';
$string['importlogidnumberexists'] = 'Sertifikasi dengan nomor ID \'{$a->originalidnumber}\' sudah ada';
$string['importlogsuccess'] = 'Membuat sertifikasi baru \'<a href="{$a->url}">{$a->fullname}</a>\'';
$string['importlogsuccessuserallocations'] = 'Pengguna yang dialokasikan \'{$a->userfullname}\' ke dalam sertifikasi \'{$a->certification}\'';
$string['include_shared_entities'] = 'Sertakan entitas bersama';
$string['include_shared_entities_help'] = 'Dengan mengaktifkan opsi ini, berkas yang diekspor juga akan berisi:

* Semua sertifikasi bersama yang tersedia di penyewa saat ini
* Semua program bersama yang ditautkan ke sertifikasi yang dipilih
* Semua program kursus di luar kategori kursus penyewa saat ini';
$string['isrecertification'] = 'Apakah sertifikasi ulang';
$string['keepcertificationdefaults'] = 'Pertahankan sertifikasi bawaan';
$string['lastallocationdate'] = 'Tanggal alokasi terakhir: {$a}';
$string['lessthanaday'] = 'Kurang dari sehari';
$string['managedusersoverdue'] = 'Beberapa anggota tim memiliki sertifikasi yang terlambat.';
$string['manageprograms'] = 'Kelola program';
$string['manual'] = 'Manual';
$string['manuallycertifieduser'] = '{$a->target pengguna} yang disertifikasi secara manual ({$an->tanggal kedaluwarsa})';
$string['mappingerrorcertificationnotfound'] = 'Sertifikasi {$a} tidak ditemukan';
$string['mappingnoticenoidnumber'] = 'Sertifikasi ditemukan berdasarkan nama karena nomor ID kosong. Sebaiknya berikan nomor ID pada sertifikasi';
$string['markcertificationcompletednotice'] = 'Tandai sertifikasi sebagai selesai tanpa menunggu penyelesaian program';
$string['messageprovider:certificationcompleted'] = 'Sertifikasi selesai';
$string['messageprovider:certificationuserallocated'] = 'Pengguna dialokasikan untuk sertifikasi';
$string['messageprovider:certificationuserdeallocated'] = 'Pengguna dide-alokasikan dari sertifikasi';
$string['missingcertification'] = 'Sertifikasi hilang';
$string['missingfullname'] = 'Nama lengkap hilang';
$string['missingprogram'] = 'Program hilang';
$string['never'] = 'Tidak pernah';
$string['neverexpires'] = 'Tidak pernah kedaluwarsa';
$string['newcertification'] = 'Sertifikasi baru';
$string['newvaluefor'] = 'Nilai baru untuk';
$string['notavailable'] = 'Tidak tersedia';
$string['notificationcertification'] = 'Program ini merupakan bagian dari sertifikasi \'{$a->certificationname}\'.<br /><br />';
$string['notificationcertificationcompletedexpiry'] = '{$a->expirymessage}
Setelah {$a->reopendate} Anda akan dapat mengikuti kembali program \'{$a->recertificationprogram}\' untuk mempertahankan sertifikasi Anda.<br /><br />';
$string['notificationcertificationcompletedmanual'] = 'Hai {$a->userfullname},<br /><br />
Selamat atas perolehan sertifikasi di \'{$a->certificationname}\'!<br /><br />
{$a->expirymessage}
{$a->sitename}<br />
{$a->siteurl}';
$string['notificationcertificationcompletedprogram'] = 'Hai {$a->userfullname},<br /><br />
Selamat telah menyelesaikan program \'{$a->programname}\'. Anda kini telah tersertifikasi dalam \'{$a->certificationname}\'!<br /><br />
Anda dapat meninjau kembali kursus dalam program tersebut kapan saja. Program lengkap dapat ditemukan di halaman \'Kursus saya\'.<br /><br />
{$a->expirymessage}
{$a->sitename}<br />
{$a->siteurl}';
$string['notificationcertificationdue'] = 'Program ini merupakan bagian dari sertifikasi \'{$a->certificationname}\', yang jatuh tempo pada {$a->duedate}.<br /><br />';
$string['notificationcertificationuserallocated'] = 'Hai {$a->userfullname},<br /><br />
Selamat datang di program \'{$a->programname}\', yang dapat Anda temukan di halaman \'Kursus saya\'.<br /><br />
{$a->certmsg}<br /><br />
{$a->sitename}<br />
{$a->siteurl}';
$string['notificationcertificationuserdeallocated'] = 'Hai {$a->userfullname},<br /><br />
Program \'{$a->programname}\' kini telah ditutup dan tidak dapat diakses lagi.<br /><br />
{$a->sitename}<br />
{$a->siteurl}';
$string['notificationcertificationwillexpireon'] = 'Sertifikasi Anda akan kedaluwarsa pada {$a}.<br /><br />';
$string['notificationsubjectcertificationcompleted'] = 'Sertifikasi \'{$a}\' selesai';
$string['notificationsubjectcertificationcompletedmanual'] = 'Selamat - sertifikasi \'{$a}\'!';
$string['notificationsubjectcertificationuserallocated'] = 'Selamat datang di \'{$a}\'';
$string['notificationsubjectcertificationuserdeallocated'] = '\'{$a}\' ditutup';
$string['notset'] = 'Tidak diatur';
$string['nousersselected'] = 'Harap pilih setidaknya satu pengguna';
$string['now'] = 'Sekarang';
$string['ongoingcertificationslink'] = '<a href="{$a->href}">{$a->count} sertifikasi yang sedang berlangsung</a>';
$string['open'] = 'Buka';
$string['outcomeallocation'] = 'Alokasikan pengguna ke sertifikasi';
$string['outcomeallocationdescdate'] = 'Alokasikan pengguna ke sertifikasi {$a->certificationname}<br />
{$a->startdatestr}<br />
Dengan pengguna yang ditangguhkan: {$a->suspendedusers}';
$string['outcomeallocationdesckeepdate'] = 'Batalkan penangguhan dan biarkan tanggal mulai sertifikasi yang ada';
$string['outcomeallocationdesckeepstartdate'] = 'Pertahankan tanggal mulai sertifikasi bawaan';
$string['outcomeallocationdescription'] = 'Alokasikan pengguna ke sertifikasi {$a}<br />
Tetap gunakan tanggal mulai sertifikasi bawaan';
$string['outcomeallocationdescstartdate'] = 'Tanggal mulai sertifikasi: \'{$a->startdate}\'';
$string['outcomeallocationdescsuspendchangedate'] = 'Batalkan penangguhan dan ubah tanggal mulai sertifikasi';
$string['outcomeallocationdontmodify'] = 'Jangan mengubah alokasi';
$string['outcomeallocationsuspendedusers'] = 'Dengan pengguna yang ditangguhkan';
$string['outcomeallocationsuspendedusers_help'] = 'Tindakan yang harus dilakukan ketika pengguna sudah dialokasikan tetapi alokasinya ditangguhkan atau diakhiri';
$string['outcomeallocationunsuspend'] = 'Batalkan penangguhan, biarkan tanggal mulai sertifikasi yang ada';
$string['outcomeallocationunsuspendchangedate'] = 'Batalkan penangguhan, ubah tanggal mulai sertifikasi';
$string['outcomedeallocate'] = 'De-alokaskani pengguna dari sertifikasi';
$string['outcomedeallocatesuspend'] = 'Tangguhkan alokasi yang ada';
$string['outcomedeallocation'] = 'De-alokasi pengguna dari sertifikasi';
$string['outcomedeallocationdescription'] = 'De-alokasi pengguna dari sertifikasi {$a}';
$string['outcomedeallocationdescriptionsuspend'] = 'Tangguhkan alokasi pengguna yang ada dari sertifikasi \'{$a}\'';
$string['overdue'] = 'Terlambat';
$string['overduecertifications'] = 'Sertifikasi yang terlambat';
$string['overduecertificationslink'] = '<a href="{$a->href}">{$a->count} sertifikat yang terlambat</a>';
$string['overduex'] = '{$a} terlambat';
$string['pluginname'] = 'Sertifikasi';
$string['previewcertificationname'] = 'Pratinjau nama sertifikasi';
$string['previouscertexpirydate'] = 'Tanggal kedaluwarsa sertifikasi sebelumnya';
$string['privacy:metadata:certification_completions'] = 'Informasi tentang penyelesaian sertifikasi.';
$string['privacy:metadata:certification_completions:certificationid'] = 'Sertifikasi yang diselesaikan pengguna.';
$string['privacy:metadata:certification_completions:certifiedby'] = 'Pengguna yang membuat sertifikasi';
$string['privacy:metadata:certification_completions:expirydate'] = 'Tanggal kedaluwarsa penyelesaian sertifikasi ini.';
$string['privacy:metadata:certification_completions:revokedby'] = 'Pengguna yang mencabut sertifikasi';
$string['privacy:metadata:certification_completions:timecertified'] = 'Waktu pengguna menyelesaikan sertifikasi.';
$string['privacy:metadata:certification_completions:timecreated'] = 'Waktu rekaman penyelesaian dibuat.';
$string['privacy:metadata:certification_completions:timemodified'] = 'Waktu penyelesaian sertifikasi yang dimodifikasi.';
$string['privacy:metadata:certification_completions:userid'] = 'Pengguna yang menyelesaikan sertifikasi.';
$string['privacy:metadata:certification_users'] = 'Informasi tentang alokasi sertifikasi pengguna.';
$string['privacy:metadata:certification_users:certificationid'] = 'Sertifikasi yang dialokasikan.';
$string['privacy:metadata:certification_users:currentprogramid'] = 'Pengguna program saat ini dialokasikan';
$string['privacy:metadata:certification_users:isrecertification'] = 'Jika pengguna sedang dalam sertifikasi ulang';
$string['privacy:metadata:certification_users:status'] = 'Apakah pengguna telah ditangguhkan dari sertifikasi.';
$string['privacy:metadata:certification_users:timemodified'] = 'Waktu alokasi pengguna yang dimodifikasi.';
$string['privacy:metadata:certification_users:userid'] = 'Pengguna yang dialokasikan.';
$string['privacy:metadata:core_tag'] = 'Tag ditambahkan ke sertifikasi';
$string['program'] = 'Program';
$string['programchangewarning'] = 'Pengguna yang saat ini mengikuti program ini tidak akan dipindahkan secara otomatis. Hal ini dapat dilakukan secara manual per pengguna. Status pengguna yang telah menyelesaikan program, atau mereka yang ditandai secara manual sebagai tersertifikasi, tidak akan berubah, tetapi mereka tidak akan dipindahkan dari program lama dan tidak akan lagi melihatnya di halaman daftar kursus mereka.';
$string['programcourse'] = 'Kursus program';
$string['programuserallocation'] = 'Alokasi pengguna program';
$string['progress'] = '{$a} selesai';
$string['progressreport'] = 'Laporan kemajuan';
$string['recertdifferentprogram'] = 'Pilih program yang berbeda';
$string['recertdifferentprogram_help'] = 'Pilih \'Ya\' jika Anda ingin memilih program yang berbeda untuk sertifikasi ulang selain program yang ditetapkan sebagai program awal.';
$string['recertduedaterelative'] = 'Tanggal jatuh tempo';
$string['recertduedaterelative_help'] = 'Ini adalah tanggal saat sertifikasi ulang jatuh tempo';
$string['recertexpirydate'] = 'Tanggal kedaluwarsa';
$string['recertexpirydate_help'] = 'Ini adalah tanggal saat sertifikasi ulang akan kedaluwarsa bagi pengguna. <br /> Jika \'Setelah tanggal kedaluwarsa sertifikasi sebelumnya\' dipilih, maka pengaturan ini akan memungkinkan untuk selalu memiliki tanggal kedaluwarsa pada tanggal yang sama. Jika pengguna melewatkan sertifikasi ulang, tanggal akan disesuaikan.';
$string['recertexpirydatewarning'] = 'Sertifikasi inisial ditetapkan tidak akan pernah kedaluwarsa, sertifikasi ulang hanya dapat dilakukan bagi pengguna yang tanggal kedaluwarsanya ditetapkan secara individual.';
$string['recertgraceperiod'] = 'Masa tenggang';
$string['recertgraceperiod_help'] = 'Masa tenggang adalah periode waktu tambahan yang kami berikan kepada pengguna untuk menyelesaikan program dan mendapatkan sertifikasi setelah sertifikasi sebelumnya berakhir. Opsi ini hanya tersedia jika program sertifikasi ulang berbeda dari program awal.';
$string['recertgraceperiodends'] = 'Masa tenggang berakhir';
$string['recertification'] = 'Sertifikasi ulang';
$string['recertificationgraceperiodendsonorbefore'] = 'Periode tenggang sertifikasi ulang berakhir pada atau sebelum';
$string['recertificationprogram'] = 'Program sertifikasi ulang';
$string['recertificationprogram_help'] = 'Pilih program yang akan digunakan dalam sertifikasi ulang. Program ini harus berbeda dari program sertifikasi awal.';
$string['recertificationstartdate'] = 'Tanggal mulai sertifikasi ulang';
$string['recertificationstartedonorafter'] = 'Sertifikasi ulang dimulai pada atau setelah';
$string['recertstartdaterelative'] = 'Tanggal mulai';
$string['recertstartdaterelative_help'] = 'Ini adalah tanggal ketika program sertifikasi ulang akan mulai tersedia bagi pengguna.';
$string['recertstartdatewarning'] = 'Pada tanggal ini program sertifikasi ulang akan disetel ulang. Pastikan pengguna tidak terdaftar dalam program kursus di tempat lain, dialokasikan langsung ke program yang sama, atau dialokasikan melalui sertifikasi lain karena mereka dapat kehilangan kemajuan mereka.';
$string['reg_wpcertifications'] = 'Jumlah sertifikasi ({$a})';
$string['requirerecertification'] = 'Memerlukan sertifikasi ulang';
$string['requirerecertification_help'] = 'Pilih \'Ya\' untuk mengaktifkan sertifikasi ulang untuk sertifikasi ini.';
$string['resetadditionalcourses'] = 'Setel ulang kursus tambahan';
$string['resetadditionalcourses_help'] = 'Menyetel ulang kursus yang merupakan bagian dari program baru yang bukan bagian dari program lama';
$string['restore'] = 'Pulihkan';
$string['revokecertification'] = 'Cabut sertifikasi';
$string['revoked'] = 'Dicabut';
$string['revokedby'] = 'Dicabut oleh';
$string['revokednotification'] = 'Sertifikasi telah berhasil dicabut.';
$string['revokedon'] = 'Dicabut pada';
$string['revokedthisuser'] = 'Mencabut sertifikasi {$a}';
$string['revokewarning'] = 'Apakah Anda yakin ingin mencabut sertifikasi dari \'{$a}\'? Penghargaan yang mungkin diberikan setelah selesai tidak akan dicabut.';
$string['rolemanager'] = 'Manajer sertifikasi';
$string['rolemanagerdescription'] = 'Memungkinkan untuk membuat dan mengelola sertifikasi dalam penyewa saat ini dan mengalokasikan pengguna kepada mereka';
$string['schedule'] = 'Tanggal sertifikasi';
$string['selectactiveandarchivedcertifications'] = 'Pilih sertifikasi yang aktif dan diarsip';
$string['selectadifferentprogram'] = 'Pilih program lain';
$string['selectallactivecertifications'] = 'Pilih semua sertifikasi aktif';
$string['selectallcertificationsinthisfile'] = 'Pilih semua sertifikasi dalam berkas ini';
$string['selectatleastonecertification'] = 'Pilih setidaknya satu sertifikasi';
$string['selectcertificationcondition'] = 'Sertifikasi';
$string['selectcertificationcondition_help'] = 'Pilih sertifikasi di mana kondisi ini akan diterapkan';
$string['selectcertificationoutcome'] = 'Sertifikasi';
$string['selectcertificationoutcome_help'] = 'Pilih sertifikasi tempat tindakan ini akan diterapkan';
$string['selectcertificationstoallocate'] = 'Sertifikasi';
$string['selectcertificationstoallocate_help'] = 'Pilih sertifikasi tempat pengguna akan dialokasikan';
$string['selectdate'] = 'Pilih tanggal';
$string['selectmanually'] = 'Pilih secara manual...';
$string['selectprogram'] = 'Pilih program';
$string['selectprogram_help'] = 'Pilih program yang akan dikaitkan dengan sertifikasi ini';
$string['separatetenantsingroupswarning'] = 'Dalam kursus yang dibagikan antar penyewa, pengguna dari setiap penyewa akan ditambahkan ke grup terpisah.';
$string['startdate'] = 'Tanggal mulai';
$string['startdate_help'] = 'Tanggal dimulainya sertifikasi';
$string['status'] = 'Status';
$string['suspended'] = 'Ditangguhkan';
$string['suspendeddateisonorafter'] = 'Tanggal ditangguhkan pada atau setelahnya';
$string['system'] = 'Sistem';
$string['tagarea_tool_certification'] = 'Sertifikasi';
$string['tags'] = 'Tag';
$string['timecreated'] = 'Dibuat pada';
$string['timemodified'] = 'Terakhir diubah pada';
$string['timesuspended'] = 'Ditangguhkan pada';
$string['toomanycertificationstoshow'] = 'Terlalu banyak sertifikasi untuk ditampilkan';
$string['uponcompletion'] = 'Setelah selesai';
$string['userallocation'] = 'Alokasi pengguna';
$string['usercompletion'] = 'Penyelesaian pengguna';
$string['userduedate'] = 'Tanggal jatuh tempo';
$string['userduedate_help'] = 'Pilih tanggal jatuh tempo sertifikasi untuk pengguna ini.';
$string['usergotsuspended'] = 'Pengguna telah ditangguhkan';
$string['userlist'] = 'Pilih pengguna';
$string['userlist_help'] = 'Pilih pengguna untuk dialokasikan ke sertifikasi ini';
$string['users'] = 'Pengguna';
$string['usersallocatedsuccess'] = '{$a} pengguna berhasil dialokasikan';
$string['usersallocationnotavailable'] = 'Alokasi pengguna tidak tersedia';
$string['usersdeallocatedsuccess'] = 'Pengguna {$a} berhasil dide-alokasi';
$string['userseditedsuccess'] = 'Pengguna {$a} berhasil dimodifikasi';
$string['usersskipped'] = 'Pengguna {$a} dilewati karena opsi ini tidak tersedia bagi mereka';
$string['userstartdate'] = 'Tanggal mulai';
$string['userstartdate_help'] = 'Pilih tanggal saat pengguna ini dapat memulai sertifikasi. Tanggal ini hanya akan berlaku untuk pengguna ini.';
$string['userstatus'] = 'Status';
$string['userstatus_help'] = 'Status ditangguhkan akan menyembunyikan sertifikasi ini dari pengguna ini sedangkan status Bawaan akan menampilkannya.';
$string['viewcertificationuserlog'] = 'Log aktivitas sertifikasi';
