<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'competency', language 'sv', version '3.11'.
 *
 * @package     competency
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allchildrenarecomplete'] = 'Alla underliggande är slutförda';
$string['competencies'] = 'Kompetenser';
$string['competenciesarenotenabled'] = 'Kompetenser är ej aktiverade';
$string['competenciessettings'] = 'Kompetensinställningar';
$string['completeplanstask'] = 'Slutför studieplaner som förfaller';
$string['coursecompetencyoutcome_complete'] = 'Slutför kompetensen';
$string['coursecompetencyoutcome_evidence'] = 'Bifoga bevis';
$string['coursecompetencyoutcome_none'] = 'Gör inget';
$string['coursecompetencyoutcome_recommend'] = 'Skicka in för granskning';
$string['coursemodulecompetencyoutcome_complete'] = 'Slutför kompetensen';
$string['coursemodulecompetencyoutcome_evidence'] = 'Bifoga bevis';
$string['coursemodulecompetencyoutcome_none'] = 'Gör inget';
$string['coursemodulecompetencyoutcome_recommend'] = 'Skicka in för granskning';
$string['deletecompetencyratings'] = 'Ta bort kompetensbedömningarna';
$string['duplicateditemname'] = '{$a} (kopia)';
$string['enablecompetencies'] = 'Aktivera kompetenser';
$string['enablecompetencies_desc'] = 'Kompetenser tillåter att användare blir bedömda utifrån studieplaner.';
$string['errorcannotchangeapastduedate'] = 'Förfallodatum har passerats; den går inte att ändra.';
$string['errorcannotsetduedateinthepast'] = 'Förfallodatum kan inte anges tillbaka i tiden.';
$string['errorcannotsetduedatetoosoon'] = 'Förfallodatum är satt för tidigt.';
$string['errorcompetencyrule'] = 'Kurskompetensregel \'{$a}\' okänd';
$string['errorcoursecompetencyrule'] = 'Kurskompetensregel \'{$a}\' okänd';
$string['errorinvalidcourse'] = 'Ogiltig kurs.';
$string['errornocompetency'] = 'Hittar inte kompetensen \'{$a}\'';
$string['errorplanstatus'] = 'Status för studieplan \'{$a}\' okänd';
$string['errorscalealreadyused'] = 'Skalan kan ej ändras då den redan används.';
$string['errorscaleconfiguration'] = 'Skalan måste konfigureras genom val av standard- och färdighetsvärden.';
$string['errorusercomptencystatus'] = 'Status för användarkompetens \'{$a}\' okänd.';
$string['eventcompetencycreated'] = 'Kompetens skapad.';
$string['eventcompetencydeleted'] = 'Kompetens borttagen.';
$string['eventcompetencyframeworkcreated'] = 'Kompetensramverk skapat.';
$string['eventcompetencyframeworkdeleted'] = 'Kompetensramverk borttaget.';
$string['eventcompetencyframeworkupdated'] = 'Kompetensramverk uppdaterat.';
$string['eventcompetencyframeworkviewed'] = 'Kompetensramverk visat.';
$string['eventcompetencyupdated'] = 'Kompetens uppdaterad.';
$string['eventcompetencyviewed'] = 'Kompetens visad.';
$string['eventevidencecreated'] = 'Bevis skapat.';
$string['eventplanapproved'] = 'Studieplan godkänd.';
$string['eventplancompleted'] = 'Studieplan slutförd.';
$string['eventplancreated'] = 'Studieplan skapad.';
$string['eventplandeleted'] = 'Studieplan borttagen.';
$string['eventplanreopened'] = 'Studieplan återöppnad.';
$string['eventplanreviewrequestcancelled'] = 'Begäran om studieplansgranskning avbruten.';
$string['eventplanreviewrequested'] = 'Studieplansgranskning begärd.';
$string['eventplanreviewstarted'] = 'Studieplansgranskning påbörjad.';
$string['eventplanreviewstopped'] = 'Studieplansgranskning avbruten.';
$string['eventplanunapproved'] = 'Studieplan ej godkänd.';
$string['eventplanunlinked'] = 'Studieplan olänkad.';
$string['eventplanupdated'] = 'Studieplan uppdaterad.';
$string['eventplanviewed'] = 'Studieplan visad.';
$string['eventtemplatecreated'] = 'Studieplansmall skapad.';
$string['eventtemplatedeleted'] = 'Studieplansmall borttagen.';
$string['eventtemplateupdated'] = 'Studieplansmall uppdaterad.';
$string['eventtemplateviewed'] = 'Studieplansmall visad.';
$string['eventusercompetencyplanviewed'] = 'Användares kompetensplan visad.';
$string['eventusercompetencyrated'] = 'Användares kompetens bedömd.';
$string['eventusercompetencyratedincourse'] = 'Användares kompetens bedömd i kurs.';
$string['eventusercompetencyratedinplan'] = 'Användares kompetens bedömd i en studieplan.';
$string['eventusercompetencyreviewrequestcancelled'] = 'Granskningsbegäran av användares kompetens avbruten.';
$string['eventusercompetencyreviewrequested'] = 'Granskning av användares kompetens begärd.';
$string['eventusercompetencyreviewstarted'] = 'Granskning av användares kompetens påbörjad.';
$string['eventusercompetencyreviewstopped'] = 'Granskning av användares kompetens avbruten.';
$string['eventusercompetencyviewed'] = 'Användares kompetens visad.';
$string['eventusercompetencyviewedincourse'] = 'Användares kompetens visad i en kurs.';
$string['eventusercompetencyviewedinplan'] = 'Användares kompetens visad i en studieplan.';
$string['eventuserevidencecreated'] = 'Verifiering av tidigare lärande skapad.';
$string['eventuserevidencedeleted'] = 'Verifiering av tidigare lärande borttagen.';
$string['eventuserevidenceupdated'] = 'Verifiering av tidigare lärande uppdaterat.';
$string['evidence_competencyrule'] = 'Regeln för kompetensen uppfylldes.';
$string['evidence_coursecompleted'] = 'Kursen \'{$a}\' slutfördes.';
$string['evidence_coursemodulecompleted'] = 'Aktiviteten \'{$a}\' slutfördes.';
$string['evidence_courserestored'] = 'Bedömningen återställdes tillsammans med kursen \'{$a}\'.';
$string['evidence_evidenceofpriorlearninglinked'] = 'Verifieringen av tidigare lärande \'{$a}\' länkades.';
$string['evidence_evidenceofpriorlearningunlinked'] = 'Verifieringen av tidigare lärande \'{$a}\' avlänkades.';
$string['evidence_manualoverride'] = 'Kompetensbedömningen gjordes manuellt.';
$string['evidence_manualoverrideincourse'] = 'Kompetensbedömningen i kursen \'{$a}\' gjordes manuellt.';
$string['evidence_manualoverrideinplan'] = 'Kompetensbedömningen i studieplanen \'{$a}\' gjordes manuellt.';
$string['invalidevidencedesc'] = 'Felaktig beskrivning av bevis';
$string['invalidgrade'] = 'Ogiltigt betyg';
$string['invalidpersistenterror'] = 'Fel: {$a}';
$string['invalidplan'] = 'Ogiltig studieplan';
$string['invalidtaxonomy'] = 'Ogiltig taxonomi: {$a}';
$string['invalidurl'] = 'URL:en är felaktig. Säkerställ att den börjar med \'http://\' eller \'https://\'.';
$string['nouserplanswithcompetency'] = 'Inga studieplaner innehåller denna kompetens.';
$string['planstatusactive'] = 'Aktiv';
$string['planstatuscomplete'] = 'Slutförd';
$string['planstatusdraft'] = 'Utkast';
$string['planstatusinreview'] = 'Granskning pågår';
$string['planstatuswaitingforreview'] = 'Väntar på granskning';
$string['pointsrequiredaremet'] = 'Poängkraven har uppfyllts';
$string['privacy:evidence:action:complete'] = 'Slutför kompetens om ej bedömd';
$string['privacy:evidence:action:log'] = 'Logga aktivitet';
$string['privacy:evidence:action:override'] = 'Åsidosätt kompetensbedömning';
$string['privacy:metadata:competency'] = 'En förteckning över kompetenserna';
$string['privacy:metadata:competency_coursecomp'] = 'En förteckning över kompetenser länkade till en kurs';
$string['privacy:metadata:competency_coursecompsetting'] = 'En förteckning över kompetensinställningarna i en kurs';
$string['privacy:metadata:competency_evidence'] = 'En förteckning över beviset som påverkar ett kompetenstillstånd';
$string['privacy:metadata:competency_framework'] = 'En förteckning över kompetensramverken';
$string['privacy:metadata:competency_modulecomp'] = 'En förteckning över kompetenserna som är länkade till en modul';
$string['privacy:metadata:competency_plan'] = 'En förteckning över studieplanerna';
$string['privacy:metadata:competency_plancomp'] = 'En förteckning över kompetenserna i en studieplan';
$string['privacy:metadata:competency_relatedcomp'] = 'En förteckning över relationer mellan kompetenser';
$string['privacy:metadata:competency_template'] = 'En förteckning över studieplansmallarna';
$string['privacy:metadata:competency_templatecohort'] = 'En förteckning över de kohorter som är associerade med en studieplansmall';
$string['privacy:metadata:competency_templatecomp'] = 'En förteckning över kompetenserna i en studieplansmall';
$string['privacy:metadata:competency_usercomp'] = 'En förteckning över en användares kompetenstillstånd';
$string['privacy:metadata:competency_usercompcourse'] = 'En förteckning över en användares kompetenstillstånd i en kurs';
$string['privacy:metadata:competency_usercompplan'] = 'En förteckning över kompetensläget i en studieplan';
$string['privacy:metadata:competency_userevidence'] = 'En förteckning över bevis för tidigare lärande';
$string['privacy:metadata:competency_userevidencecomp'] = 'En förteckning över de kompetenser som är associerade med bevis på tidigare lärande';
$string['privacy:metadata:core_comments'] = 'Kommentarer gjorda för studieplaner och kompetenser';
$string['privacy:metadata:evidence:action'] = 'Åtgärdstyp för åtgärd som utfördes med beviset';
$string['privacy:metadata:evidence:actionuserid'] = 'Användaren som utförde åtgärden';
$string['privacy:metadata:evidence:desca'] = 'De valfria parametrarna för den översättningsbara bevisbeskrivningen';
$string['privacy:metadata:evidence:desccomponent'] = 'Komponenten för den översättningsbara bevisbeskrivningen';
$string['privacy:metadata:evidence:descidentifier'] = 'En identifierare för den översättningsbara bevisbeskrivningen';
$string['privacy:metadata:evidence:grade'] = 'Betyg associerat med beviset';
$string['privacy:metadata:evidence:note'] = 'En icke-översatt anteckning som bifogats till beviset';
$string['privacy:metadata:evidence:url'] = 'En URL associerad med beviset';
$string['privacy:metadata:plan:description'] = 'Studieplansbeskrivningen';
$string['privacy:metadata:plan:duedate'] = 'Studieplanens förfallodatum';
$string['privacy:metadata:plan:name'] = 'Studieplansnamnet';
$string['privacy:metadata:plan:reviewerid'] = 'ID för granskaren av studieplanen';
$string['privacy:metadata:plan:status'] = 'Status för studieplanen';
$string['privacy:metadata:plan:userid'] = 'Användar-ID för den användare vars studieplan detta är';
$string['privacy:metadata:timecreated'] = 'Tidpunkt då posten skapades';
$string['privacy:metadata:timemodified'] = 'Tidpunkt då posten ändrades';
$string['privacy:metadata:usercomp:grade'] = 'Det utdelade betyget för kompetensen';
$string['privacy:metadata:usercomp:proficiency'] = 'Huruvida färdighet uppnåtts';
$string['privacy:metadata:usercomp:reviewerid'] = 'ID för granskaren';
$string['privacy:metadata:usercomp:status'] = 'Kompetensens status';
$string['privacy:metadata:usercomp:userid'] = 'Användare-ID för användaren vars kompetens detta är';
$string['privacy:metadata:userevidence:description'] = 'Beskrivningen för beviset';
$string['privacy:metadata:userevidence:name'] = 'Namnet på beviset för tidigare lärande';
$string['privacy:metadata:userevidence:url'] = 'URL associerad med beviset';
$string['privacy:metadata:usermodified'] = 'Användaren som skapade eller ändrade posten';
$string['privacy:path:plans'] = 'Studieplaner';
$string['privacy:path:relatedtome'] = 'Relaterat till mig';
$string['privacy:path:userevidence'] = 'Bevis på tidigare lärande';
$string['pushcourseratingstouserplans'] = 'För över kursbedömningar till individuella studieplaner.';
$string['pushcourseratingstouserplans_desc'] = 'Standardvärde för kursens inställning att uppdatera individuella studieplaner när kurskompetenser bedöms.';
$string['syncplanscohorts'] = 'Synkronisera planer från kohorter med studieplansmallar.';
$string['taxonomy_behaviour'] = 'Beteende';
$string['taxonomy_competency'] = 'Kompetens';
$string['taxonomy_concept'] = 'Koncept';
$string['taxonomy_domain'] = 'Domän';
$string['taxonomy_indicator'] = 'Indikator';
$string['taxonomy_level'] = 'Nivå';
$string['taxonomy_outcome'] = 'Utfall';
$string['taxonomy_practice'] = 'Praktik';
$string['taxonomy_proficiency'] = 'Färdighet';
$string['taxonomy_skill'] = 'Skicklighet';
$string['taxonomy_value'] = 'Värde';
$string['usercommentedonacompetency'] = '{$a->fullname} kommenterade kompetensen "{$a->competency}":

{$a->comment}

Se: {$a->url}';
$string['usercommentedonacompetencyhtml'] = '<p>{$a->fullname} kommenterade kompetensen "{$a->competency}":</p>
<div>{$a->comment}</div>
<p>Se: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonacompetencysmall'] = '{$a->fullname} kommenterade kompetensen "{$a->competency}".';
$string['usercommentedonacompetencysubject'] = '{$a} kommenterade en kompetens.';
$string['usercommentedonaplan'] = '{$a->fullname} kommenterade studieplanen "{$a->plan}":

{$a->comment}

See: {$a->url}';
$string['usercommentedonaplanhtml'] = '<p>{$a->fullname} kommenterade studieplanen "{$a->plan}":</p>
<div>{$a->comment}</div>
<p>Se: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonaplansmall'] = '{$a->fullname} kommenterade studieplanen "{$a->plan}".';
$string['usercommentedonaplansubject'] = '{$a} kommenterade en studieplan.';
$string['usercompetencystatus_idle'] = 'Inaktiv';
$string['usercompetencystatus_inreview'] = 'Granskning pågår';
$string['usercompetencystatus_waitingforreview'] = 'Väntar på granskning';
$string['userplans'] = 'Studieplaner';
