<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'game', language 'sv', version '3.11'.
 *
 * @package     game
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allattempts'] = 'Visa alla försök';
$string['allstudents'] = 'Visa alla $a';
$string['and'] = 'och';
$string['attempt'] = 'Försök';
$string['attemptduration'] = 'Försökslängd';
$string['attemptfirst'] = 'Första försöket';
$string['attemptgamenow'] = 'Försök nu';
$string['attemptlast'] = 'Senaste försöket';
$string['attempts'] = 'Försök';
$string['attemptsonly'] = 'Visa endast studenter som försökt';
$string['bookquiz_cant_update_lastchaperid'] = 'Kan inte uppdatera tabell game_bookquiz med lastchapterid till %d';
$string['bookquiz_categories'] = 'Kategorier';
$string['bookquiz_chapters'] = 'Kapitel';
$string['bookquiz_empty'] = 'Denna bok är tom';
$string['bookquiz_error'] = 'bokquiz: %s';
$string['bookquiz_error_insert'] = 'game_bookquiz_continue: fel vid infogning i game_bookquiz';
$string['bookquiz_layout'] = 'Layout';
$string['bookquiz_layout0'] = 'Fråga överst i boken';
$string['bookquiz_layout1'] = 'Fråga i slutet av boken';
$string['bookquiz_not_select_book'] = 'Du har inte valt bok';
$string['bookquiz_numquestions'] = 'Frågor';
$string['bookquiz_options'] = 'Bokfrågealternativ';
$string['bookquiz_questions'] = 'Associera frågekategorier med bokkapitel';
$string['bottomtext'] = 'Text nederst på sidan';
$string['clearrepetitions'] = 'Töm statistik';
$string['col_highscores'] = 'Toppresultat';
$string['comment'] = 'Kommentar';
$string['common_problems'] = 'Vanliga problem';
$string['common_problems_allowspaces'] = 'Det förekommer ord innehållandes blanksteg men i spelet är dessa inte tillåtna.';
$string['common_problems_crossword_param1'] = '\'Maximalt antal kolumner/rader\' är för litet';
$string['common_problems_shortanswer_hangman'] = 'Det förekommer tecken i spelet som inte finns i språket spelet använder';
$string['completedon'] = 'Slutfört';
$string['completionpass'] = 'Kräv godkänt betyg';
$string['completionpass_help'] = 'Om aktiverad betraktas den här aktiviteten som fullständig när deltagaren får ett godkänt resultat (enligt vad som anges i avsnittet Betyg i Quizinställningarna) eller högre.';
$string['computerepetitions'] = 'Beräkna statistiken på nytt';
$string['confighangmanimagesets'] = 'Inställningar för hur många bilduppsättningar som används i spelet';
$string['confighidebookquiz'] = 'Ställer in om spelet "Bok med frågor" visas för lärare eller ej';
$string['confighidecross'] = 'Ställer in om spelet "Korsord" visas för lärare eller ej';
$string['confighidecryptex'] = 'Ställer in om spelet "Cryptex" visas för lärare eller ej';
$string['confighidehangman'] = 'Ställer in om spelet "Hänga gubbe" visas för lärare eller ej';
$string['confighidehiddenpicture'] = 'Ställer in om spelet "Dold bild" visas för lärare eller ej';
$string['confighidemillionaire'] = 'Ställer in om spelet "Vem vill bli miljonär?" visas för lärare eller ej';
$string['confighidesnakes'] = 'Ställer in om spelet "Ormar och stegar" visas för lärare eller ej';
$string['confighidesudoku'] = 'Ställer in om spelet "Sudoku" visas för lärare eller ej';
$string['continueattemptgame'] = 'Återuppta ett tidigare försök';
$string['convertfrom'] = '-';
$string['convertto'] = '-';
$string['cross_across'] = 'Tvärs över';
$string['cross_checkbutton'] = 'Markera';
$string['cross_correct'] = 'rätt bokstav';
$string['cross_corrects'] = 'rätta bokstäver';
$string['cross_disabletransformuppercase'] = 'Inaktiverar text-transformering: versaler i CSS';
$string['cross_down'] = 'Ner';
$string['cross_endofgamebutton'] = 'Avsluta korsord';
$string['cross_error'] = 'fel bokstav';
$string['cross_error_containsbadchars'] = 'Ordet innehåller ogiltiga tecken';
$string['cross_error_wordlength1'] = 'Det rätta ordet innehåller&nbsp';
$string['cross_error_wordlength2'] = 'bokstäver.';
$string['cross_errors'] = 'fel bokstäver';
$string['cross_found_many'] = 'Hittade';
$string['cross_found_one'] = 'Hittade';
$string['cross_layout'] = 'Layout';
$string['cross_layout0'] = 'Fraser under korsordet';
$string['cross_layout1'] = 'Fraser till höger om korsordet';
$string['cross_max_attempts'] = 'Maximalt antal försök';
$string['cross_maxcols'] = 'Maximalt antal kolumner/rader';
$string['cross_maxcomputetime'] = 'Maximal beräkningstid i sekunder';
$string['cross_maxwords'] = 'Maximalt antal ord';
$string['cross_minwords'] = 'Minsta antal ord';
$string['cross_options'] = 'Korsordsalternativ';
$string['cross_pleasewait'] = 'Korsordet laddas. Vänta...';
$string['cross_welcome'] = '<h3>Välkommen!</h3><p>Klicka på ett ord för att börja/fortsätta.</p>';
$string['cryptex_error'] = 'Fel i Cryptex-spelet: %s';
$string['cryptex_maxtries'] = 'Max försök';
$string['cryptex_options'] = 'Cryptexalternativ';
$string['deleteattemptcheck'] = 'Är du helt säker på att du vill ta bort dessa försök helt?';
$string['different_glossary_category'] = 'Den valda kategorin matchar inte vald ordlista';
$string['disablesummarize'] = 'Ingen sammanfattning';
$string['displayoptions'] = 'Visningsalternativ';
$string['downloadods'] = 'Ladda ned i ODS-format';
$string['eventgamecreated'] = 'Spel skapat';
$string['eventgamedeleted'] = 'Spel borttaget';
$string['eventgameplayed'] = 'Spel spelat';
$string['eventgamesupdated'] = 'Spel uppdaterat';
$string['eventgameviewed'] = 'Spel visat';
$string['export'] = 'Exportera';
$string['export_to_html'] = 'Exportera till HTML';
$string['export_to_javame'] = 'Exportera till Javame';
$string['feedback'] = 'Återkoppling';
$string['feedbacks'] = 'Meddelar rätt svar';
$string['finish'] = 'Slutet på spelet';
$string['game:addinstance'] = 'Nytt spel';
$string['game:attempt'] = 'Spela';
$string['game:deleteattempts'] = 'Ta bort försök';
$string['game:grade'] = 'Betygsätt spel manuellt';
$string['game:manage'] = 'Hantera';
$string['game:manageoverrides'] = 'Hantera spelåsidosättanden';
$string['game:preview'] = 'Förhandsgranska spel';
$string['game:reviewmyattempts'] = 'granskaminaförsök';
$string['game:view'] = 'visa';
$string['game:viewreports'] = 'visarapporter';
$string['game_bookquiz'] = 'Bok med frågor';
$string['game_cross'] = 'Korsord';
$string['game_cryptex'] = 'Cryptex';
$string['game_error'] = 'Fel i spel: %s';
$string['game_hangman'] = 'Hänga gubbe';
$string['game_hiddenpicture'] = 'Dold bild';
$string['game_millionaire'] = 'Vem vill bli miljonär?';
$string['game_snakes'] = 'Ormar och stegar';
$string['game_sudoku'] = 'Sudoku';
$string['gameclose'] = 'Avsluta spelet';
$string['gameclosed'] = 'Spelet avslutades {$a}';
$string['gamecloseson'] = 'Detta spel stänger {$a}';
$string['gamenotavailable'] = 'Detta spel är inte tillgängligt förrän {$a}';
$string['gamenotfound'] = 'Spelet <em>%s</em> kunde inte hittas';
$string['gameopen'] = 'Starta spelet';
$string['gameopenclose'] = 'Start- och slutdatum';
$string['gameopenclose_help'] = 'Elever kan bara påbörja sina försök efter starttiden och de måste slutföra dem innan sluttiden.';
$string['gameopenedon'] = 'Detta spel startade {$a}';
$string['glossary_only_approved'] = 'Endast ord som är godkända eller från lärarens ordlista';
$string['grade'] = 'Betyg';
$string['gradeaverage'] = 'Genomsnittligt betyg';
$string['gradehighest'] = 'Högsta betyg';
$string['grademethod'] = 'Betygsättningsmetod';
$string['hangman_allowspaces'] = 'Tillåt blanksteg i ord';
$string['hangman_allowsub'] = 'Tillåt symbolen - i ord';
$string['hangman_correct_phrase'] = 'Rätt fras är: &nbsp';
$string['hangman_correct_word'] = 'Rätt ord är: &nbsp';
$string['hangman_error'] = 'Fel i Hänga gubbe: %s';
$string['hangman_gradeinstance'] = 'Betyg i hela spelet';
$string['hangman_imageset'] = 'Välj bilderna till Hänga gubbe';
$string['hangman_language'] = 'Språk att använda för orden';
$string['hangman_letters'] = 'Bokstäver: &nbsp';
$string['hangman_loose'] = '<BIG><B>Spelet slut</B></BIG>';
$string['hangman_maximum_number_of_errors'] = 'Maximalt antal fel';
$string['hangman_maxtries'] = 'Antal ord per spel';
$string['hangman_options'] = 'Hänga gubbe-alternativ';
$string['hangman_restletters_many'] = 'Youtube har <b>{$a}</b> försök';
$string['hangman_restletters_one'] = 'Du har <b>ENDAST 1</b> försök';
$string['hangman_showcorrectanswer'] = 'Visa de rätta svaren i slutet';
$string['hangman_showfirst'] = 'Visa första bokstaven i Hänga gubbe';
$string['hangman_showlast'] = 'Visa sista bokstaven i Hänga gubbe';
$string['hangman_showquestion'] = 'Visa frågorna?';
$string['hangman_wrongnum'] = 'Fel: %d av %d';
$string['hangmanimagesets'] = 'Antal bilduppsättningar i Hänga gubbe';
$string['header_footer_options'] = 'Alternativ för Sidhuvud/Sidfot';
$string['helpbookquiz'] = 'Vid korrekt svar kan studenten gå till nästa kapitel.';
$string['helpcross'] = 'Det här spelet hämtar ord från antingen en <em>Ordlista</em> eller från kortsvarsfrågorna ur ett <em>Kunskapstest</em> och genererar ett slumpmässigt korsord. Läraren kan ställa in det maximala antalet kolumner/rader eller ord det innehåller. Studenten kan klicka på knappen "Kontrollera korsord" för att kontrollera om svaren är korrekta. Varje korsord är dynamiskt så de är olika för varje elev.';
$string['helpcryptex'] = 'Detta spel liknar Korsords-spelet men orden är gömda inuti en slumpmässig Cryptex-cylinder.';
$string['helphangman'] = 'Det här spelet hämtar ord från antingen en <em>Ordlista</em> eller från kortsvarsfrågorna ur ett <em>Kunskapstest</em> och genererar en Hänga gubbe-utmaning. Läraren kan ställa in det maximala antalet ord den innehåller, om första eller sista bokstaven ska visas eller om frågan eller svaret ska visas i slutet.';
$string['helphiddenpicture'] = 'Dolda bilden-spelet avslöjar en del av en bild för varje korrekt besvarad fråga. Varje nummer i den dolda bilden visar en fråga som korrekt besvarad, avslöjar en del av bilden.';
$string['helpmillionaire'] = 'En fråga visas för eleven som, om den besvaras korrekt, flyttas upp till nästa nivå i spelet tills användaren har slutfört frågorna. Om en fråga besvaras felaktigt är spelet över.';
$string['helpsnakes'] = 'En fråga visas för eleven. Om den besvaras korrekt visas en siffra på tärningarna. Därefter flyttas spelpjäsen upp det antal steg tärningarna visar.';
$string['helpsudoku'] = 'Detta spel visar ett Sudoku-pussel för eleverna med ett otillräckligt antal siffror för att det ska gå att lösa. För varje korrekt svar visas ytterligare ett tal i pusslet för att göra det lättare att lösa.';
$string['hiddenpicture_across'] = 'Horisontella celler';
$string['hiddenpicture_down'] = 'Celler ned';
$string['hiddenpicture_error'] = 'Fel i Dold bild-spelet: %s';
$string['hiddenpicture_height'] = 'Sätt bildens höjd till (i pixlar)';
$string['hiddenpicture_mainsubmit'] = 'Betygsätt huvudsvar';
$string['hiddenpicture_nocols'] = 'Måste ange antalet horisontella kolumner';
$string['hiddenpicture_nomainquestion'] = 'Det finns inga ord i ordlistan {$a->namn} som innehåller bifogade bilder';
$string['hiddenpicture_norows'] = 'Måste ange antalet vertikala kolumner';
$string['hiddenpicture_options'] = 'Dold bild-alternativ';
$string['hiddenpicture_pictureglossary'] = 'Ordlista för huvudsaklig fråga och bild';
$string['hiddenpicture_width'] = 'Sätt bildens bredd till (i pixlar)';
$string['hidebookquiz'] = 'Dölj "Bok med frågor"-spelet';
$string['hidecross'] = 'Dölj Korsords-spelet';
$string['hidecryptex'] = 'Dölj Cryptex-spelet';
$string['hidehangman'] = 'Dölj "Hänga gubbe"-spelet';
$string['hidehiddenpicture'] = 'Dölj "Dold bild"-spelet';
$string['hidemillionaire'] = 'Dölj "Vem vill bli miljonär?"-spelet';
$string['hidesnakes'] = 'Dölj "Ormar och stegar"-spelet';
$string['hidesudoku'] = 'Dölj Sudoku-spelet';
$string['highscore'] = 'Visa toppoäng (antal studenter)';
$string['html_hangman_new'] = 'Nytt';
$string['html_hascheckbutton'] = 'Har markera-knapp:';
$string['html_hasprintbutton'] = 'Har utskrifts-knapp:';
$string['html_snakes_check'] = 'Kontrollera';
$string['html_snakes_correct'] = 'Rätt!';
$string['html_snakes_no_selection'] = 'Måste välja något!';
$string['html_snakes_wrong'] = 'Ditt svar är fel. Bli kvar i sätet.';
$string['html_title'] = 'HTML-rubrik:';
$string['info'] = 'Information';
$string['introduction'] = 'Beskrivning';
$string['javame_createdby'] = 'Skapad av:';
$string['javame_description'] = 'Beskrivning:';
$string['javame_filename'] = 'Filnamn:';
$string['javame_icon'] = 'Ikon:';
$string['javame_maxpictureheight'] = 'Maximal bildhöjd:';
$string['javame_maxpicturewidth'] = 'Maximal bildbredd:';
$string['javame_name'] = 'Name:';
$string['javame_type'] = 'Typ:';
$string['javame_vendor'] = 'Leverantör:';
$string['javame_version'] = 'Version:';
$string['language_user_defined'] = 'Användardefinierat språk';
$string['letter'] = 'bokstav';
$string['letters'] = 'bokstäver';
$string['lettersall'] = 'ABCDEFGHIJKLMNOPQRSTUVWXYZÅÄÖ';
$string['millionaire_also_multichoice'] = 'Flera svar utan enskilt korrekt svar';
$string['millionaire_background'] = 'Bakgrundsfärg';
$string['millionaire_error'] = 'Fel i Vem vill bli miljonär?-spelet: %s';
$string['millionaire_helppeople'] = 'Fråga publiken';
$string['millionaire_info_people'] = 'Publiken svarar';
$string['millionaire_info_telephone'] = 'Jag tror det rätta svaret är &nbsp';
$string['millionaire_info_wrong_answer'] = 'Ditt svar är fel.<br>Rätt svar är:';
$string['millionaire_lettersall'] = '-';
$string['millionaire_must_select_questioncategory'] = 'Du måste välja en (1) frågekategori';
$string['millionaire_must_select_quiz'] = 'Du måste välja ett (1) test';
$string['millionaire_no_multichoice_questions'] = 'Det finns inga flervalsfrågor';
$string['millionaire_options'] = 'Alternativ för "Vem vill bli miljonär?"';
$string['millionaire_quit'] = 'Avsluta';
$string['millionaire_shuffle'] = 'Blanda frågorna';
$string['millionaire_sourcemodule_must_quiz_question'] = 'För det här spelet måste källan vara {$a} eller frågor och inte';
$string['millionaire_telephone'] = 'Fråga en vän';
$string['missingbook'] = 'Bok saknas';
$string['modulename'] = 'Spel';
$string['modulename_help'] = 'Denna modul innehåller 8 spel: <em>Hänga gubbe</em>, <em>Korsord</em>, <em>Cryptex</em>, <em>Vem vill bli miljonär?</em>, <em>Sudoku</em>, <em>Den dolda bilden</em>, <em>Ormar och stegar</em> samt <em>Bok med frågor</em>.';
$string['modulenameplural'] = 'Spel';
$string['must_select_glossary'] = 'Du måste välja ordlista';
$string['must_select_questioncategory'] = 'Du måste välja frågekategori';
$string['must_select_quiz'] = 'Du måste välja ett test';
$string['name'] = 'Namn';
$string['nextgame'] = 'Nytt spel';
$string['nextword'] = 'Nästa ord';
$string['no_questions'] = 'Det finns inga frågor';
$string['no_words'] = 'Det finns inga ord';
$string['noattempts'] = 'Inga försök har gjort av detta spel';
$string['noattemptsonly'] = 'Visa $a där inga försök gjorts';
$string['noglossaryentriesfound'] = 'Hittade inga ord från ordlistan';
$string['numattempts'] = '$a->studentnum $a->studentstring har gjort $a->attemptnum försök';
$string['only_teachers'] = 'Endast lärare kan se denna sida';
$string['outof'] = '{$a->grade} av maximalt {$a->maxgrade}';
$string['pagesize'] = 'Antal frågor per sida:';
$string['percent'] = 'Procent';
$string['pluginadministration'] = 'Hantera spel';
$string['pluginname'] = 'Spel';
$string['preview'] = 'Förhandsgranska';
$string['print'] = 'Skriv ut';
$string['privacy:metadata:game'] = 'Spelaktiviteter utnyttjar spelrapporter.';
$string['privacy:metadata:game_attempts'] = 'Detaljer för varje enskilt spelförsök.';
$string['privacy:metadata:game_attempts:attempt'] = 'Försöksnumret';
$string['privacy:metadata:game_attempts:bookquiz_lastchapter'] = 'Sista kapitlet i boken.';
$string['privacy:metadata:game_attempts:cross_createconnectors'] = 'Antalet kopplingar i korsordet.';
$string['privacy:metadata:game_attempts:cross_createfilleds'] = 'Antalet ifyllnader i korsordet.';
$string['privacy:metadata:game_attempts:cross_createlimit'] = 'Maximalt tillåten tid för att hitta det bästa korsordet';
$string['privacy:metadata:game_attempts:cross_createscore'] = 'Korsordsbetyget (hur bra korsordet är)';
$string['privacy:metadata:game_attempts:cross_createspaces'] = 'Antalet tomma rutor i korsordet';
$string['privacy:metadata:game_attempts:cross_createtries'] = 'Antalet försök som försökte göra det bästa korsordet';
$string['privacy:metadata:game_attempts:cross_triesplay'] = 'Antalet gånger användaren gjorde korsordet';
$string['privacy:metadata:game_attempts:cross_usedcols'] = 'Antal kolumner som inkluderar';
$string['privacy:metadata:game_attempts:cross_usedrows'] = 'Antal rader som inkluderar';
$string['privacy:metadata:game_attempts:cross_words'] = 'Antalet ord som inkluderar';
$string['privacy:metadata:game_attempts:cross_wordsall'] = 'Antalet ord som försökte inkludera';
$string['privacy:metadata:game_attempts:cryptex_letters'] = 'Antalet bokstäver som finns i cryptex (horisontella och vertikala)';
$string['privacy:metadata:game_attempts:hangman_allletters'] = 'Alla bokstäver';
$string['privacy:metadata:game_attempts:hangman_corrects'] = 'Antal korrekta bokstäver';
$string['privacy:metadata:game_attempts:hangman_finishedword'] = '1 om användaren avslutade Hänga gubbe-spelet';
$string['privacy:metadata:game_attempts:hangman_iscorrect'] = '1 om det är korrekt';
$string['privacy:metadata:game_attempts:hangman_letters'] = 'Bokstäver som användes';
$string['privacy:metadata:game_attempts:hangman_maxtries'] = 'Maximala antalet försök som tillåts för användaren';
$string['privacy:metadata:game_attempts:hangman_queryid'] = 'Länk till <code>game_queries</code>';
$string['privacy:metadata:game_attempts:hangman_try'] = 'Antalet gånger användaren försökte spela Hänga gubbe';
$string['privacy:metadata:game_attempts:hiddenpicture_corect'] = 'Antal rätta';
$string['privacy:metadata:game_attempts:hiddenpicture_found'] = '1 om användaren hittade det korrekta svaret';
$string['privacy:metadata:game_attempts:hiddenpicture_wrong'] = 'Antalet felaktiga';
$string['privacy:metadata:game_attempts:language'] = 'Språket som användes.';
$string['privacy:metadata:game_attempts:millionaire_level'] = 'Nivån';
$string['privacy:metadata:game_attempts:millionaire_queryid'] = 'Länk till <code>game_queries</code>';
$string['privacy:metadata:game_attempts:millionaire_state'] = 'Tillståndet';
$string['privacy:metadata:game_attempts:preview'] = 'Huruvida detta är en förhandsgranskning av spelet, eller ej.';
$string['privacy:metadata:game_attempts:score'] = 'Resultatet (i procent) för försöket.';
$string['privacy:metadata:game_attempts:snakes_dice'] = 'tärning';
$string['privacy:metadata:game_attempts:snakes_position'] = 'Position på brädet';
$string['privacy:metadata:game_attempts:snakes_queryid'] = 'queryid';
$string['privacy:metadata:game_attempts:snakes_snakesdatabaseid'] = 'Vilket bräde som används';
$string['privacy:metadata:game_attempts:sudoku_data'] = 'data';
$string['privacy:metadata:game_attempts:sudoku_guess'] = 'gissning';
$string['privacy:metadata:game_attempts:sudoku_level'] = 'nivå';
$string['privacy:metadata:game_attempts:sudoku_opened'] = 'öppnat';
$string['privacy:metadata:game_attempts:timefinish'] = 'Tidpunkt då försöket avslutades.';
$string['privacy:metadata:game_attempts:timelastattempt'] = 'Tidpunkt för senaste försök';
$string['privacy:metadata:game_attempts:timemodified'] = 'Tidpunkt då försöket uppdaterades.';
$string['privacy:metadata:game_attempts:timestart'] = 'Tidpunkt då försöket påbörjades.';
$string['privacy:metadata:game_grades'] = 'Detaljerad information om det övergripande betyget i detta spel.';
$string['privacy:metadata:game_grades:game'] = 'Spelet som betygsattes.';
$string['privacy:metadata:game_grades:score'] = 'Den övergripande resultatet (procent) för detta spel.';
$string['privacy:metadata:game_grades:timemodified'] = 'Tidpunkt då betyget ändrades.';
$string['privacy:metadata:game_grades:userid'] = 'Användaren som betygsattes.';
$string['privacy:metadata:game_queries'] = 'game_queries';
$string['privacy:metadata:game_queries:answerid'] = 'svarsid';
$string['privacy:metadata:game_queries:answertext'] = 'svarstext';
$string['privacy:metadata:game_queries:attachment'] = 'bilaga';
$string['privacy:metadata:game_queries:attemptid'] = 'försöksid';
$string['privacy:metadata:game_queries:correct'] = 'rätt';
$string['privacy:metadata:game_queries:glossaryentryid'] = 'ordlisteords-id';
$string['privacy:metadata:game_queries:horizontal'] = 'horisontell';
$string['privacy:metadata:game_queries:id'] = 'ID';
$string['privacy:metadata:game_queries:mycol'] = 'minkol';
$string['privacy:metadata:game_queries:myrow'] = 'minrad';
$string['privacy:metadata:game_queries:questionid'] = 'frågeid';
$string['privacy:metadata:game_queries:questiontext'] = 'frågetext';
$string['privacy:metadata:game_queries:score'] = 'resultat';
$string['privacy:metadata:game_queries:studentanswer'] = 'studentsvar';
$string['privacy:metadata:game_queries:timelastattempt'] = 'tidpunktsenasteförsök';
$string['privacy:metadata:game_queries:tries'] = 'försök';
$string['privacy:metadata:game_repetitions'] = 'game_repetitions';
$string['privacy:metadata:game_repetitions:gameid'] = 'spelid';
$string['privacy:metadata:game_repetitions:glossaryentryid'] = 'ordlisteord-id';
$string['privacy:metadata:game_repetitions:id'] = 'ID';
$string['privacy:metadata:game_repetitions:questionid'] = 'frågeid';
$string['privacy:metadata:game_repetitions:repetitions'] = 'upprepningar';
$string['privacy:metadata:game_repetitions:userid'] = 'användarid';
$string['reattemptgame'] = 'Försök igen';
$string['repetitions'] = 'Omförsök';
$string['reportoverview'] = 'Översikt';
$string['reset_game_all'] = 'Ta bort försök från alla spel';
$string['reset_game_deleted_course'] = 'Ta bort försök från borttagna kurser';
$string['results'] = 'Resultat';
$string['review'] = 'Granska';
$string['reviewofattempt'] = 'Granskning av försök {$a}';
$string['score'] = 'Poäng';
$string['selectall'] = 'Välj alla';
$string['selectnone'] = 'Avmarkera alla';
$string['showall'] = 'Visa alla';
$string['showanswers'] = 'Visa svar';
$string['showattempts'] = 'Visa försök';
$string['showdetailedmarks'] = 'Visa poängdetaljer';
$string['showsolution'] = 'lösning';
$string['snakes_background'] = 'Bakgrund';
$string['snakes_cols'] = 'Kolumner';
$string['snakes_data'] = 'Positioner för Ormar och Stegar';
$string['snakes_dice'] = 'Tärning, $a ögon.';
$string['snakes_error'] = 'Fel i Ormar och stegar-spelet: %s';
$string['snakes_file'] = 'Fil för bakgrund';
$string['snakes_footerx'] = 'Utrymme nere till vänster (i pixlar)';
$string['snakes_footery'] = 'Utrymme nere till höger (i pixlar)';
$string['snakes_headerx'] = 'Utrymme uppe till vänster (i pixlar)';
$string['snakes_headery'] = 'Utrymme uppe till höger (i pixlar)';
$string['snakes_layout0'] = 'Fråga ovanför bild';
$string['snakes_layout1'] = 'Fråga under bild';
$string['snakes_options'] = 'Alternativ för "Ormar och stegar"';
$string['snakes_player'] = 'Spelare, position: $a.';
$string['snakes_rows'] = 'Rader';
$string['sourcemodule'] = 'Frågekälla';
$string['sourcemodule_book'] = 'Välj bok';
$string['sourcemodule_glossary'] = 'Välj ordlista';
$string['sourcemodule_glossarycategory'] = 'Välj ordlistekategori';
$string['sourcemodule_include_subcategories'] = 'Inkludera underkategorier';
$string['sourcemodule_question'] = 'Frågor';
$string['sourcemodule_questioncategory'] = 'Välj frågekategori';
$string['sourcemodule_quiz'] = 'Välj test';
$string['startagain'] = 'Spela igen';
$string['startedon'] = 'Påbörjades';
$string['sudoku_create_count'] = 'Antal Sudokus som kommer att skapas';
$string['sudoku_create_start'] = 'Generera Sudokus';
$string['sudoku_creating'] = 'Skapar <b>{$a}</b> sudoku(s)';
$string['sudoku_error'] = 'Fel i Sudoku-spelet: %s';
$string['sudoku_finishattemptbutton'] = 'Avsluta spel';
$string['sudoku_guessnumber'] = 'Gissa det rätta talet';
$string['sudoku_maxquestions'] = 'Maximalt antal frågor';
$string['sudoku_noentriesfound'] = 'Hittade inga ord i ordlistan';
$string['sudoku_options'] = 'Sudoku-alternativ';
$string['sudoku_submit'] = 'Betygsätt svar';
$string['timecompleted'] = 'Slutfört';
$string['timefinish'] = 'Spelslut';
$string['timelastattempt'] = 'Senaste försök';
$string['timestart'] = 'Börja';
$string['timetaken'] = 'Tidsåtgång';
$string['toptext'] = 'Text överst på sidan';
$string['unfinished'] = 'öppet';
$string['userdefined'] = 'Användardefinierad';
$string['viewbook'] = 'Visa bok <b>{$a}</b>';
$string['viewglossary'] = 'Visa ordlista <b>{$a}</b>';
$string['viewquestions'] = 'Visa frågor';
$string['viewquiz'] = 'Visa test <b>{$a}</b>';
$string['win'] = 'Gratulerar!!!';
$string['withselected'] = 'Med valda';
$string['yourfinalgradeis'] = 'Slutbetyget för detta spel är {$a}.';
