<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'questionnaire', language 'sv', version '3.11'.
 *
 * @package     questionnaire
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Du har enkäter som ska besvaras.';
$string['additionalinfo'] = 'Beskrivning';
$string['additionalinfo_help'] = 'Ytterligare information om enkäten. Visas bara på enkätens första sida.';
$string['addnewquestion'] = 'Lägger till fråga av typen {$a}';
$string['addnewsection'] = 'Lägg till ny section';
$string['addquestion'] = 'Lägg till fråga...';
$string['addquestions'] = 'Lägg till frågor';
$string['addquestiontosection'] = 'Lägg till en fråga på sidan';
$string['addselqtype'] = 'Lägg till fråga av vald typ';
$string['alignment'] = 'Visa radioknapparna';
$string['alignment_help'] = 'Välj hur svarsalternativen ska visas: horisontellt eller vertikalt.';
$string['alignment_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['all'] = 'Alla';
$string['allnameddegrees'] = 'Ordskala';
$string['allnameddegrees_help'] = 'Använd ord/uttryck istället för siffror för att bedöma. Ange ett uttryck per rad med motsvarande siffra och ett likhetstecken framför, och med det högsta värdebegreppet sist. Exempel:<BR>
1=Dåligt<BR>
2=Ganska dåligt<BR>
3=Ganska bra<BR>
4=Bra<BR>';
$string['alreadyfilled'] = 'Du har redan besvarat den här enkäten {$a}. Tack!';
$string['andaveragevalues'] = 'och medelvärden';
$string['anonymous'] = 'Anonym';
$string['answer'] = 'Svar';
$string['answergiven'] = 'Detta svaret ska vara valt';
$string['answernotgiven'] = 'Detta svaret ska INTE vara valt';
$string['answerquestions'] = 'Besvara frågorna';
$string['answers'] = 'Svar';
$string['attempted'] = 'Enkäten skickades in.';
$string['attemptstillinprogress'] = 'Pågående. Sparades:';
$string['autonumbering'] = 'Fråge- och sidnumrering';
$string['autonumbering_help'] = 'Automatisk numrering av sidor och frågor. <BR>Det är vanligen inte lämpligt att använda automatisk numrering när svarsberoende frågor används. (Svarsberoende frågor = påföljande frågor som bara visas vid vissa specificerade svarsalternativ)';
$string['autonumberno'] = 'Numrera varken sidor eller frågor automatiskt';
$string['autonumberpages'] = 'Numrera sidor automatiskt';
$string['autonumberpagesandquestions'] = 'Numrera sidor och frågor automatiskt';
$string['autonumberquestions'] = 'Numrera frågor automatiskt';
$string['average'] = 'Medelvärde';
$string['averageposition'] = 'Medelpostion';
$string['averagerank'] = 'Medelranking';
$string['averagesrow'] = 'Medelvärde (där applicerbart)';
$string['bodytext'] = 'Meddelande';
$string['boxesnbexact'] = '<strong>{$a} svarsalternativ.</strong>';
$string['boxesnbmax'] = 'max {$a} svarsalternativ.';
$string['boxesnbmin'] = 'minst {$a} svarsalternativ.';
$string['boxesnbreq'] = '<strong>För den här frågan ska du ange</strong>&nbsp;';
$string['by'] = 'av';
$string['cannotviewpublicresponses'] = 'Du får inte se svar i denna samlande enkät';
$string['chart:hbar'] = 'Horisontella staplar';
$string['chart:type'] = 'Typ av diagram';
$string['chart:type_help'] = 'Välj typ av diagram för denna återkoppling';
$string['chart:vprogress'] = 'Liggande progressionsmätare';
$string['checkallradiobuttons'] = 'Markera <strong>{$a}</strong> alternativ!';
$string['checkboxes'] = 'Checkbox (flerval)';
$string['checkboxes_help'] = 'Ange ett alternativ per rad';
$string['checkboxes_link'] = 'mod/questionnaire/questions#Check_Boxes';
$string['checkbreaksadded'] = 'Nya sidbrytningar gjorda:';
$string['checkbreaksok'] = 'Alla sidbrytningar som behövs är klara';
$string['checkbreaksremoved'] = 'Tog bort {$a} extra sidbrytningar';
$string['checknotstarted'] = 'Välj de som inte påbörjat enkäten';
$string['checkstarted'] = 'Välj de som påbörjat enkäten';
$string['clicktoswitch'] = '(klicka för att ändra)';
$string['closed'] = 'Enkäten stängdes {$a}. Tack.';
$string['closedate'] = 'Stängs';
$string['closeson'] = 'Enkäten stängs den {$a}.';
$string['completionsubmit'] = 'Studenten måste skicka in enkäten för att aktiviteten ska vara fullföljd';
$string['condition'] = 'Villkor';
$string['confalts'] = '- ELLER - <br />Bekräftelsetext';
$string['configemailreporting'] = 'Tillåt rapporter via epost';
$string['confirmdelallresp'] = 'Är du säker på att du vill radera ALLA svar i denna enkät?';
$string['confirmdelchildren'] = 'Om du raderar den här frågan, kommer svarsberoendefrågor också att raderas.';
$string['confirmdelgroupresp'] = 'Är du säker på att du vill radera ALLA svar i {$a}?';
$string['confirmdelquestion'] = 'Är du säker på att du vill radera frågan i position {$a}?';
$string['confirmdelquestionresps'] = 'Detta kommer att radera även {$a} svar som redan getts på den frågan.';
$string['confirmdelresp'] = 'Är du säker på att du vill radera svaret från av&nbsp;{$a}&nbsp;?';
$string['confirmremovequestion'] = 'Vill du ta bort frågan "{$a->qname}" från sidan "{$a->sname}"?';
$string['confpage'] = 'Rubrik';
$string['confpage_help'] = 'Rubrik och text visas för respondenten efter inskickad enkät. <BR>Om <STRONG>Bekräftelselänk</STRONG> angivits skickas istället respondenten till den sidan.<BR>
Om inget angivits här visas istället en förinställd text, "Tack för dina svar".';
$string['confpagedesc'] = 'Rubrik och text visas för respondenten efter inskickad enkät. <BR>Om <STRONG>Bekräftelselänk</STRONG> angivits skickas istället respondenten till den sidan.<BR>
Om inget angivits här visas istället en förinställd text, "Tack för dina svar".';
$string['contentoptions'] = 'Alternativ för innehåll';
$string['couldnotcreatenewsurvey'] = 'Kunde inte skapa ny enkät!';
$string['couldnotdelresp'] = 'Kunde inte ta bort svar';
$string['createcontent_help'] = 'Du kan välja att skapa en helt ny enkät, använda en mall eller använda en publik enkät.';
$string['createcontent_link'] = 'mod/questionnaire/mod#Content_Options';
$string['createnew'] = 'Skapa ny';
$string['date'] = 'Datum';
$string['date_help'] = 'Formatet för hur datumet ska skrivas visas automatiskt för respondenten: dag/månad/år, exempelvis som för 14 mars 1945:&nbsp; <strong>14/3/1945</strong>';
$string['date_link'] = 'mod/questionnaire/questions#Date';
$string['dateformatting'] = 'Använd formatet år-månad-dag, exempelvis som för 14 mars 1945:&nbsp; <strong>1945-03-14</strong>. Du kan även klicka på kalendersymbolen för att välja ett datum där.';
$string['deleteallresponses'] = 'Radera ALLA svar';
$string['deletecurrentquestion'] = 'Radera fråga {$a}';
$string['deletedallgroupresp'] = 'Radera ALLA svar i gruppen {$a}';
$string['deletedallresp'] = 'Enkätens svar raderades';
$string['deletedisabled'] = 'Denna kan inte raderas';
$string['deletedresp'] = 'Ta bort svar';
$string['deleteresp'] = 'Ta bort detta svar';
$string['deletesection'] = 'Radera den här sidan';
$string['deletingresp'] = 'Tar bort svar';
$string['dependencies'] = 'Beroenden';
$string['dependquestion'] = 'Förgreningsfråga';
$string['dependquestion_help'] = 'Du kan ange en Förgreningsfråga och ett svarsalternativ för den frågan. Svarsberoendefrågan visas bara om respondenten har angivit det valda svarsalternativet i förgreningsfrågan.';
$string['dependquestion_link'] = 'mod/questionnaire/questions#Parent_Question';
$string['didnotrespondtoquestion'] = 'Besvarade inte fråga';
$string['directwarnings'] = 'Beroenden av den här frågan kommer att tas bort. Detta påverkar:';
$string['download'] = 'Ladda ned';
$string['downloadpdf'] = 'Ladda ned PDF';
$string['downloadtextformat'] = 'Ladda ned i textformat';
$string['downloadtextformat_help'] = 'Du kan spara ned alla svar till en CSV-fil, som kan importeras till Excel eller annat program för att bearbeta data.';
$string['downloadtextformat_link'] = 'mod/questionnaire/report#Download_in_text_format';
$string['downloadtypes'] = 'Typ av rapport';
$string['dropdown'] = 'Rullgardinsmeny (enval)';
$string['dropdown_help'] = 'Rullgardinsmeny kan ibland vara att föredra framför Radioknappar, för att spara plats på skärmen.';
$string['dropdown_link'] = 'mod/questionnaire/questions#Dropdown_Box';
$string['edit'] = 'Ändra';
$string['editingfeedback'] = 'Redigerar inställningar för återkoppling';
$string['editingquestionnaire'] = 'Ändra enkäts inställningar';
$string['editquestion'] = 'Redigerar fråga av typen {$a}';
$string['email'] = 'E-postadress';
$string['erroropening'] = 'Ett fel inträffade när enkäten skulle öppnas.';
$string['essaybox'] = 'Textfält (essä)';
$string['essaybox_help'] = 'Den här frågetypen visar ett vanligt textfält med ett angivet antal textrader.';
$string['event_all_responses_deleted'] = 'Alla svar raderades';
$string['event_all_responses_saved_as_text'] = 'Alla svar sparades som text';
$string['event_all_responses_viewed'] = 'Alla svars-rapporten visad';
$string['event_individual_responses_viewed'] = 'Individuell svarsrapport visad';
$string['event_previewed'] = 'Enkät förhandsgranskad';
$string['event_question_created'] = 'Fråga skapad';
$string['event_question_deleted'] = 'Frågan togs bort';
$string['event_response_deleted'] = 'Individuellt svar togs bort';
$string['event_resumed'] = 'Enkät återupptagen';
$string['event_saved'] = 'Svar sparades';
$string['event_submitted'] = 'Svar skickades';
$string['feedback'] = 'Återkoppling';
$string['feedback_help'] = 'Hjälp för återkoppling';
$string['feedback_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Messages';
$string['feedbackaddmorefeedbacks'] = 'Lägg till {no} återkopplingsfält';
$string['feedbackdefaultlabel'] = '[Ny sida]';
$string['feedbackeditsections'] = 'Save settings and edit Feedback Sections';
$string['feedbackglobal'] = 'Global Feedback';
$string['feedbacknextsection'] = 'Nästa sektion {$a}';
$string['feedbackoptions'] = 'Denna "återkoppling" baseras på en särskild typ av enkät för att göra personlighetstest och används inte för vanliga enkäter.';
$string['feedbackoptions_help'] = 'Återkopplingsalternativ finns om din enkät innehåller följande frågetyper och frågeinställningar: Radioknappar; rullgardinsmeny; Ja/Nej; eller Rangordna (normal eller osgood skala). Dessa frågor måste ställas in som obligatoriska, fältet Frågenamn får INTE vara tomt och svarsalternativen måste innehålla minst ett värde.';
$string['feedbackoptions_link'] = 'mod/questionnaire/personality_test';
$string['feedbacksections'] = '{$a} återkopplingssektioner';
$string['feedbacksectionsselect_help'] = 'Placera dina frågor i dessa avsnitt';
$string['feedbacksectionsselect_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Sections_2';
$string['feedbacksettingssaved'] = 'Inställningar för återkoppling sparades.';
$string['feedbacktype'] = 'Typ av återkoppling';
$string['field'] = 'Fråga {$a}';
$string['fieldlength'] = 'Storlek på textruta';
$string['fieldlength_help'] = 'För frågetypen **Fritext (kort)**, ange **Storlek på textruta** med siffervärde för antal tecken och **Max antal tecken**med siffervärde för hur lång texten får vara. Förinställning är 20 respektive 25.';
$string['finished'] = 'Du har besvarat all frågor i enkäten.';
$string['firstrespondent'] = 'Förste respondent';
$string['formateditor'] = 'HTML-redigerare';
$string['formatplain'] = 'Enkel text';
$string['grade'] = 'Poäng/betyg för svar';
$string['gradesdeleted'] = 'Enkätens poäng raderades';
$string['headingtext'] = 'Rubrik';
$string['horizontal'] = 'Horisontellt';
$string['includechoicecodes'] = 'Inkludera svarskoder';
$string['includechoicetext'] = 'Inkludera svarstexter';
$string['includeincomplete'] = 'Inkludera ofullständiga svar';
$string['includerankaverages'] = 'Ta med medelvärde för rankningsfrågor';
$string['incorrectquestionnaire'] = 'Enkäten är felaktig';
$string['invalidresponse'] = 'Ogiltigt svar angavs.';
$string['kindofratescale'] = 'Typ av graderingsskala';
$string['kindofratescale_help'] = '<STRONG>Vanlig</STRONG> = en skala med så många skalsteg som du angivit. <BR>
<STRONG>Vanlig skala med "Vet ej" som svarsalternativ</STRONG> = Ger ett alternativ om värdering inte är applicerbar för respondenten <BR>
<STRONG>Rangordna</STRONG> = en skala med så många skalsteg som du angivit, men inget av objekten kan graderas lika. Användbar om man vill att objekt ska rangordnas.
<BR>
<STRONG>Osgood</STRONG> = en värdering/gradering med andra värden än numeriska. Klicka på "Moodle.Docs för den här sidan" nedan för utförlig beskrivning.';
$string['kindofratescale_link'] = 'mod/questionnaire/questions#Type_of_rate_scale';
$string['lastrespondent'] = 'Siste respondent';
$string['length'] = 'Längd';
$string['managequestions'] = 'Administrera frågor';
$string['managequestions_help'] = 'Här kan du administrera frågor, frågeordning och dela in enkäten i flera sidor.';
$string['managequestions_link'] = 'mod/questionnaire/questions#Manage_questions';
$string['mandatory'] = 'Obligatoriskt - Alla dessa förutsättningar ska vara uppfyllda.';
$string['maxdigitsallowed'] = 'Max tillåtna antal tecken';
$string['maxdigitsallowed_help'] = 'Ange maximala antalet siffror som får användas i svaret. Notera att decimalpunkten också räknas!<BR>
Exempel:<BR>
Ett tal mellan 000.00 och 999.99 ska kunna anges.<BR>
Ange Max antal tillåtna siffror till 6, dvs fem siffror plus decimalpunkten.';
$string['maxdigitsallowed_link'] = 'mod/questionnaire/questions#Numeric';
$string['maxforcedresponses'] = 'Högsta tillåtna antal valda svarsalternativ';
$string['maxforcedresponses_help'] = 'Använd dessa parametrar för att tvinga respondenten att kryssa i minsta och högsta antal svarsalternativ. För att tvinga ett exakt antal kryssrutor för att kryssas, sätt båda till samma värde. <BR>Om bara ett minsta eller ett högsta antal önskas, lämna bara det andra värdet på 0. <BR>Om du ställer in minsta eller högsta antal till andra värden än standardvärdet 0, kommer ett varningsmeddelande att visas om respondenten inte uppfyller kravet. <BR>Du bör göra kraven om antal svarsalternativ tydliga för respondenten, antingen i de allmänna instruktionerna i din enkät eller i texten till frågor där detta används.';
$string['maxtextlength'] = 'Max antal tecken';
$string['messageprovider:message'] = 'Påminnelse om enkät';
$string['messageprovider:notification'] = 'Inlämning av enkät';
$string['minforcedresponses'] = 'Minsta tillåtna antal valda svarsalternativ';
$string['minforcedresponses_help'] = 'Använd dessa parametrar för att tvinga respondenten att kryssa i minsta och högsta antal svarsalternativ. För att tvinga ett exakt antal kryssrutor för att kryssas, sätt båda till samma värde. <BR>Om bara ett minsta eller ett högsta antal önskas, lämna bara det andra värdet på 0. <BR>Om du ställer in minsta eller högsta antal till andra värden än standardvärdet 0, kommer ett varningsmeddelande att visas om respondenten inte uppfyller kravet. <BR>Du bör göra kraven om antal svarsalternativ tydliga för respondenten, antingen i de allmänna instruktionerna i din enkät eller i texten till frågor där detta används.';
$string['missingname'] = 'Frågan {$a} kan inte användas i det här återkopplingsavsnittet då den saknar namn.';
$string['missingnameandrequired'] = 'Frågan {$a} kan inte användas i det här återkopplingsavsnittet då den saknar namn och är inte obligatorisk.';
$string['missingquestion'] = 'Vänligen besvara obligatorisk fråga: &nbsp;';
$string['missingquestions'] = 'Vänligen besvara obligatoriska frågor:&nbsp;';
$string['missingrequired'] = 'Frågan {$a} kan inte användas i det här återkopplingsavsnittet då den inte är obligatorisk.';
$string['modulename'] = 'Enkät';
$string['modulename_help'] = 'Enkätverktyget används för att med en rad olika frågetyper skapa enkäter i kursrummet. <BR>Enkäterna kan vara engångsenkäter, eller ställas in för att vara återkommande (exempelvis en gång i veckan). <BR>
Man kan även skapa delade enkätmallar som kan användas av alla lärare i MyMoodle.';
$string['modulename_link'] = 'mod/questionnaire/view';
$string['modulenameplural'] = 'Enkäter';
$string['movedisabled'] = 'Objektet kan inte flyttas';
$string['myresponses'] = 'Alla dina svar';
$string['myresponsetitle'] = 'Dina {$a} svar';
$string['myresults'] = 'Dina resultat';
$string['name'] = 'Rubrik';
$string['navigate'] = 'Tillåt svarsberoende frågor';
$string['navigate_help'] = 'Tillåt att Ja/Nej-frågor och radioknappar (envalsfrågor) har underliggande frågor beroende på hur respondenten svarar (svarsberoendefrågor)';
$string['navigate_link'] = 'mod/questionnaire/conditional_branching';
$string['navigatetosection'] = 'Gå till återkopplingssidan';
$string['next'] = 'Nästa';
$string['nextpage'] = 'Nästa sida';
$string['nlines'] = '{$a} rader';
$string['noanswer'] = 'Inget svar';
$string['noattempts'] = 'Ingen har påbörjat denna enkät';
$string['noduplicates'] = 'Rangordna - inga lika värden';
$string['noduplicateschoiceserror'] = 'Du måste ange minst två svarsalternativ för att använda "Rangordna" i Typ av graderingsskala!';
$string['non_respondents'] = 'Respondenter som ännu inte har skickat in svar på enkäten.';
$string['noneinuse'] = 'Enkäten innehåller inga frågor';
$string['nopublicsurveys'] = 'Det finns inga samlande enkäter gjorda. Samlande enkäter är avsedda för att koppla flera svarsformulär i olika kursrum till en gemensam enkät. Svaren visas bara i den gemensamma enkäten.';
$string['noresponsedata'] = 'Inga svar på den här frågan';
$string['noresponses'] = 'Inga svar';
$string['normal'] = 'Vanlig';
$string['not_started'] = 'Inte påbörjat';
$string['notanumber'] = '<strong>{$a}</strong> är inte ett accepterat format. Använd siffror, decimal ska anges med punkt-tecken.';
$string['notapplicable'] = 'Vet ej';
$string['notapplicablecolumn'] = 'Vanlig skala med "Vet ej" som svarsalternativ';
$string['notavail'] = 'Denna enkät är inte längre tillgänglig.';
$string['noteligible'] = 'Du har inte rätt behörighet för att fylla i denna enkät.';
$string['notemplatesurveys'] = 'Det finns inga delade enkätmallar';
$string['notificationfull'] = 'Inklusive de inskickade svaren';
$string['notifications'] = 'Sänd notifikationer om inskickade svar';
$string['notifications_help'] = 'Notifiera kursansvariga och lärare när en enkät besvarats.';
$string['notifications_link'] = 'mod/questionnaire/mod#Submission_Notifications';
$string['notificationsimple'] = 'Enbart notifikation';
$string['notopen'] = 'Denna enkät öppnas {$a}.';
$string['notrequired'] = 'Svar krävs inte';
$string['notset'] = 'ej inställd';
$string['nousersselected'] = 'Inga användare valda';
$string['numattemptsmade'] = '{$a} inskickade enkäter';
$string['numberfloat'] = 'Värdet du angav, <strong>{$a->number}</strong>, har rundats av till <strong>{$a->precision}</strong> decimaler.';
$string['numberofdecimaldigits'] = 'Antal visade decimalsiffror i rapporten';
$string['numberofdecimaldigits_help'] = 'Hur många decimaler som ska visas i rapporten.';
$string['numberofdecimaldigits_link'] = 'mod/questionnaire/questions#Numeric';
$string['numberscaleitems'] = 'Antal skalsteg';
$string['numberscaleitems_help'] = 'Antal skalsteg i graderingen (5 är förinställt)';
$string['numeric'] = 'Numerisk';
$string['numeric_help'] = 'Numerisk fråga med möjlighet till decimaler.';
$string['of'] = 'av';
$string['opendate'] = 'Öppnas';
$string['optional'] = 'Valbart - Minst en av dessa förutsättningar ska vara uppfylld.';
$string['optionalname'] = 'Frågenamn';
$string['optionalname_help'] = 'Frågenamnet används bara när du exporterar svaren till CSV/Excelformat, och när du administrerar enkäter och frågor, det visas inte för respondenterna.';
$string['optionalname_link'] = 'mod/questionnaire/questions#Question_Name';
$string['or'] = '- ELLER -';
$string['order_ascending'] = 'Stigande ordning';
$string['order_default'] = 'Visa i standardordning';
$string['order_descending'] = 'Fallande ordning';
$string['orderresponses'] = 'Sortera svar';
$string['orderresponses_help'] = 'När du visar alla svar kan du sortera efter antal svar (Medelvärdes-kolumnen) för följande fyra frågetyper: * Enval (radio buttons)  *Enval (rullgardinsmeny) *Checkbox (kryssrutor för flerval) *Gradering (inklusive Likertskala). När du går till "Visa alla svar" kommer som standard svaren i den ordning som de är i enkäten. Du kan välja att sortera dem i stigande eller fallande ordning.';
$string['orderresponses_link'] = 'mod/questionnaire/report#Order_Responses';
$string['otherempty'] = 'Om du markerar denna ruta måste du även skriva något i textfältet!';
$string['overviewnumresplog'] = 'svar';
$string['overviewnumresplog1'] = 'svar';
$string['overviewnumrespvw'] = 'svar';
$string['overviewnumrespvw1'] = 'svar';
$string['owner'] = 'Ägare';
$string['page'] = 'Sida';
$string['pageof'] = 'Sida {$a->page} av {$a->totpages}';
$string['parent'] = 'Förälder';
$string['participant'] = 'Deltagare';
$string['pleasecomplete'] = 'Var god fyll i detta alternativ';
$string['pluginadministration'] = 'Enkätadministration';
$string['pluginname'] = 'Enkät';
$string['possibleanswers'] = 'Alternativ';
$string['preview_label'] = 'Förhandsgranska';
$string['preview_questionnaire'] = 'Förhandsgranskning enkät';
$string['previewing'] = 'Förgranskar enkät';
$string['previous'] = 'Föregående';
$string['previouspage'] = 'Föregående sida';
$string['print'] = 'Skriv ut detta svar';
$string['printblank'] = 'Skriv ut en icke ifylld enkät';
$string['printblanktooltip'] = 'Öppnar en tom enkät för utskrift';
$string['printtooltip'] = 'Öppnar en enkät med nuvarande svar för utskrift';
$string['private'] = 'Kursenkät';
$string['public'] = 'Offentligt';
$string['publiccopy'] = 'Kopia:';
$string['publicoriginal'] = 'Original:';
$string['qtype'] = 'Typ';
$string['qtype_help'] = 'Välj om respondenten ska tillåtas svara en gång, dagligen, varje vecka eller ett obegränsat antal gånger (många).';
$string['qtypedaily'] = 'Svara dagligen';
$string['qtypemonthly'] = 'Svara varje månad';
$string['qtypeonce'] = 'Svara en gång';
$string['qtypeunlimited'] = 'Svara många gånger';
$string['qtypeweekly'] = 'Svara varje vecka';
$string['questionnaire:addinstance'] = 'Lägg till en ny enkät';
$string['questionnaire:copysurveys'] = 'Kopiera delade enkätmallar och kursenkäter';
$string['questionnaire:createpublic'] = 'Skapa publika enkäter';
$string['questionnaire:createtemplates'] = 'Skapa mallar för enkäter';
$string['questionnaire:deleteresponses'] = 'Radera svar';
$string['questionnaire:downloadresponses'] = 'Ladda ned som CSV-fil';
$string['questionnaire:editquestions'] = 'Skapa och redigera frågor till Questionnaire (enkät)';
$string['questionnaire:manage'] = 'Skapa och redigera enkäter';
$string['questionnaire:message'] = 'Skicka meddelande till respondenter som inte har besvarat enkäten';
$string['questionnaire:preview'] = 'Förhandsgranska enkäter';
$string['questionnaire:printblank'] = 'Skriv ut en icke ifylld enkät';
$string['questionnaire:readallresponseanytime'] = 'Se alla svar närsomhelst';
$string['questionnaire:readallresponses'] = 'Visa resultat av enkäten';
$string['questionnaire:readownresponses'] = 'Se dina egna svar';
$string['questionnaire:submissionnotification'] = 'Få notifikation om varje inskickad enkät.';
$string['questionnaire:submit'] = 'Fylla i och skicka in enkät';
$string['questionnaire:view'] = 'Se enkät';
$string['questionnaire:viewsingleresponse'] = 'Visa kompletta individuella svar';
$string['questionnaireadministration'] = 'Enkätadministration';
$string['questionnairecloses'] = 'Enkäten stänger';
$string['questionnaireopens'] = 'Enkäten öppnas';
$string['questionnairereport'] = 'Rapport över enkäter';
$string['questionnum'] = 'Fråga #';
$string['questions'] = 'Frågor';
$string['questionsinsection'] = 'Frågor i det här avsnittet:';
$string['questiontypes'] = 'Frågetyper';
$string['questiontypes_help'] = 'Ange vilken frågetyp som ska läggas till';
$string['questiontypes_link'] = 'mod/questionnaire/questions#Question_Types';
$string['radiobuttons'] = 'Radioknappar (enval)';
$string['radiobuttons_help'] = 'I den här frågetypen ska respondenten välja ett svarsalternativ. Skriv ett per rad.';
$string['radiobuttons_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['rank'] = 'Rangordna';
$string['ratescale'] = 'Gradering (skala)';
$string['ratescale_help'] = 'Ange vad som ska graderas, ett objekt per rad.';
$string['ratescale_link'] = 'mod/questionnaire/questions#Rate_.28scale_1..5.29';
$string['realm'] = 'Typ av enkät';
$string['realm_help'] = 'Det finns två enkättyper:<BR>
<STRONG>Kursenkät</STRONG> - enkäten tillhör kursrummet och kan kopieras inom kursrummet. <BR><STRONG>Delad enkätmall</STRONG> - en mall som alla som kan skapa en enkät i MyMoodle kan använda för att skapa egna enkäter, vilka i sin tur kan ändras och anpassas vidare.';
$string['realm_link'] = 'mod/questionnaire/qsettings#Questionnaire_Type';
$string['redirecturl'] = 'En webbadress respondenten dirigeras vidare till då enkäten skickats in.';
$string['remove'] = 'Radera';
$string['removeallquestionnaireattempts'] = 'Radera alla enkätens svar';
$string['removenotinuse'] = 'Denna enkät berodde av en Publik enkät som har raderats. Den kan inte längre användas och bör raderas.';
$string['required'] = 'Obligatoriskt svar';
$string['required_help'] = 'Om du väljer Ja, kan inte respondenten skicka in sina svar om frågan inte är besvarad.';
$string['required_link'] = 'mod/questionnaire/questions#Response_Required';
$string['reset'] = 'Återställ';
$string['respeligiblerepl'] = '(ersatt av rollöverskridande)';
$string['respondenteligibleall'] = 'alla';
$string['respondenteligiblestudents'] = 'enbart studenter';
$string['respondenteligibleteachers'] = 'enbart lärare';
$string['respondents'] = 'Respondenter';
$string['respondenttype'] = 'Öppen / Anonym';
$string['respondenttype_help'] = 'Lärare kan se varje respondents svar genom att välja "Namn". Du döljer vem som har svarat vad genom att välja "Anonym".
Om enkäten inte görs anonym ska respondenterna informeras om detta i enkätens beskrivning.';
$string['respondenttype_link'] = 'mod/questionnaire/mod#Respondent_Type';
$string['respondenttypeanonymous'] = 'Anonym';
$string['respondenttypefullname'] = 'Namn';
$string['response'] = 'Svar';
$string['responsefieldlines'] = 'Storlek på textruta';
$string['responseformat'] = 'Textformat';
$string['responseoptions'] = 'Alternativ för att besvara';
$string['responses'] = 'Svar';
$string['responseview'] = 'Studenter kan se ALLAS svar, även andra studenters';
$string['responseview_help'] = 'Här bestämmer du om och när studenterna ska kunna se hela resultatet av enkäten. Om studenter aldrig ska kunna se hur andra studenter har svarat ska du välja alternativet <strong>Aldrig</strong>. <BR>Studenterna kan alltid se sina egna svar.';
$string['responseview_link'] = 'mod/questionnaire/mod#Response_viewing';
$string['responseviewstudentsalways'] = 'Alltid';
$string['responseviewstudentsnever'] = 'Aldrig';
$string['responseviewstudentswhenanswered'] = 'Efter att enkäten har besvarats';
$string['responseviewstudentswhenclosed'] = 'Efter att enkäten har stängts';
$string['resume'] = 'Spara och fortsätt senare';
$string['resume_help'] = 'Den här inställningen låter studenterna spara sina svar, och återgå till enkäten senare för att komplettera den innan den skickas in.';
$string['resume_link'] = 'mod/questionnaire/mod#Save/Resume_answers';
$string['resumesurvey'] = 'Återuppta enkät';
$string['return'] = 'Återvänd';
$string['save'] = 'Spara';
$string['saveasnew'] = 'Spara som en ny fråga';
$string['savedbutnotsubmitted'] = 'Dina svar har sparats men ännu inte skickats in';
$string['savedprogress'] = 'Dina svar har sparats. Du kan närsomhelst komma tillbaka och fortsätta fylla i enkäten.';
$string['saveeditedquestion'] = 'Spara fråga {$a}';
$string['savesettings'] = 'Spara';
$string['search:activity'] = 'Enkät - information om aktivitet';
$string['search:question'] = 'Enkät - frågor';
$string['section'] = 'Beskrivning';
$string['sectionbreak'] = '----- Ny sida -----';
$string['sectionbreak_help'] = '----- Ny sida -----';
$string['sectiontext'] = 'Etikett (textblock, ej fråga)';
$string['sectiontext_help'] = 'Detta är ingen fråga, utan en kort text som visas för att introducera en serie frågor.';
$string['send'] = 'Skicka';
$string['send_message'] = 'Skicka meddelande till valda respondenter';
$string['send_message_to'] = 'Skicka meddelande till:';
$string['sendemail_help'] = 'Skickar en kopia av varje inskickad enkät till den angivna e-postadressen. Du kan ange flera adresser genom att separera dem med kommatecken. Lämna tom för att inte skicka kopior.';
$string['set'] = 'inställd';
$string['settings'] = 'Inställningar';
$string['settingssaved'] = 'Inställningar sparades';
$string['show_nonrespondents'] = 'Respondenter som inte har svarat';
$string['started'] = 'Påbörjat';
$string['strictdateformatting'] = 'Använd formatet år-månad-dag, exempelvis som för 14 mars 1945:&nbsp; <strong>1945-03-14</strong>. Du kan även klicka på kalendersymbolen för att välja ett datum där.';
$string['subject'] = 'Ämne';
$string['submissionnotificationhtmlanon'] = '<a href="{$a->submissionurl}">Ett nytt svar</a> på enkäten "{$a->name}" har skickats in <a href="{$a->submissionurl}">submission</a>.';
$string['submissionnotificationhtmluser'] = '<a href="{$a->submissionurl}">Ett nytt svar</a> på enkäten "{$a->name}" har skickats in <a href="{$a->submissionurl}">submission</a> av "<a href="{$a->profileurl}">{$a->username}</a>".';
$string['submissionnotificationsubject'] = 'Enkätsvar har skickats in';
$string['submissionnotificationtextanon'] = 'Ett nytt svar ({$a->submissionurl}) på enkäten "{$a->name}" har skickats in.';
$string['submissionnotificationtextuser'] = 'Ett nytt svar ({$a->submissionurl})på enkäten "{$a->name}" har skickats in av "{$a->username}" ({$a->profileurl}).';
$string['submitoptions'] = 'Alternativ vid inskickat svar';
$string['submitpreview'] = 'Skicka in förhandsgranskning';
$string['submitpreviewcorrect'] = 'Denna enkät skulle accepteras som korrekt genomförd.';
$string['submitsurvey'] = 'Skicka in dina svar';
$string['submitted'] = 'Inskickad:';
$string['subtitle'] = 'Underrubrik';
$string['subtitle_help'] = 'Underrubrik till enkäten, visas bara på första sidan under enkätens rubrik.';
$string['summary'] = 'Sammanställning';
$string['surveynotexists'] = 'Enkäten finns inte';
$string['surveyresponse'] = 'Svar från enkät';
$string['template'] = 'Delad enkätmall';
$string['templatenotviewable'] = '<FONT COLOR="red">Detta är en delad enkätmall och den kan inte visas så här då det inte finns något resultat i den. Använd "Förhandsgranska" i enkätens administrationsmeny. </FONT>';
$string['text'] = 'Frågetext';
$string['textbox'] = 'Fritext (kort)';
$string['textbox_help'] = 'För frågetypen **Fritext (kort)**, ange **Storlek på textruta** med antal tecken och **Max antal tecken** för hur lång texten får vara.';
$string['textdownloadoptions'] = 'Alternativ för textformat (CSV)';
$string['thank_head'] = 'Tack för dina svar.';
$string['thismonth'] = 'den här månaden';
$string['thisresponse'] = 'Detta svar';
$string['thisweek'] = 'den här veckan';
$string['thousands'] = 'Använd inga mellanslag, decimaler anges med punkt.';
$string['title'] = 'Rubrik';
$string['title_help'] = 'Rubriken på den här specifika enkäten, visas på varje sida i enkäten. Det finns även ett enkätnamn under inställningar, vilket visas som förinställning om ingen rubrik anges här.';
$string['today'] = 'idag';
$string['total'] = 'Totalt';
$string['totalresponses'] = 'Totalt antal svar på frågan';
$string['type'] = 'Frågetyp';
$string['undefinedquestiontype'] = 'Odefinierad frågetyp!';
$string['url'] = 'Bekräftelselänk';
$string['url_help'] = 'En webbadress respondenten dirigeras vidare till då enkäten skickats in.';
$string['useprivate'] = 'Kopiera befintlig enkät i kursen';
$string['usepublic'] = '<FONT COLOR="red"><STRONG>Använd INTE någon enkät från den här raden och nedåt som mall för din enkät!</STRONG></FONT>';
$string['usetemplate'] = 'Använd mall';
$string['vertical'] = 'Vertikalt';
$string['view'] = 'Visa';
$string['viewallresponses'] = 'Visa alla svar';
$string['viewallresponses_link'] = 'Viewing_Questionnaire_responses#Group_filtering';
$string['viewbyresponse'] = 'Lista på svar';
$string['viewindividualresponse'] = 'Individuella svar';
$string['viewindividualresponse_help'] = 'Klicka på respondentens namn i listan för att se dennes svar.';
$string['viewresponses'] = 'Alla svar ({$a})';
$string['viewyourresponses'] = 'Dina svar - visa {$a}';
$string['wronganswers'] = 'Det är något fel med dina svar (se nedan)';
$string['wrongdateformat'] = 'Det angivna datumet <strong>{$a}</strong> stämmer inte med formatet i exemplet.';
$string['wrongformat'] = 'Det är något problem med ditt svar på frågan:&nbsp;';
$string['wrongformats'] = 'Det är något problem med ditt svar på frågan:&nbsp;';
$string['yesno'] = 'Ja/Nej';
$string['yesno_help'] = 'Enkel ja- eller nejfråga';
$string['yourresponse'] = 'Dina svar';
$string['yourresponses'] = 'Dina svar';
