<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth', language 'sr_cr', version '3.11'.
 *
 * @package     auth
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actauthhdr'] = 'Доступни додаци за проверу идентитета';
$string['allowaccountssameemail'] = 'Дозволи налоге са истом електронском адресом';
$string['allowaccountssameemail_desc'] = 'Ако је омогућено, више од једног корисничког налога може имати исту електронску адресу. То може довести до безбедносних проблема или проблема са приватношћу, на пример, приликом слања е-поруке за потврду промене лозинке.';
$string['alternatelogin'] = 'Ако овде унесете URL адресу, онда ће она бити коришћенa као страница за пријављивљње на овај сајт. Страница треба да садржати образац који има својство акције подешено на <strong>\'{$a}\'</strong> и враћа поља <strong>username</strong> и <strong>password</strong>.<br />Будите опрезни да не бисте случајно унели погрешну URL адресу и тиме сами себи онемогућили приступ сајту.<br />Оставите ово подешавање празно да бисте користили подразумевану страницу за пријављивање.';
$string['alternateloginurl'] = 'Алтернативна URL адреса за пријаву на систем';
$string['auth_changepasswordhelp'] = 'Помоћ при промени лозинке';
$string['auth_changepasswordhelp_expl'] = 'Приказ помоћи за случај изгубљене лозинке корисницима који су изгубили своју {$a} лозинку. То ће бити приказано уместо <strong>URL адресе за промену лозинке</strong> или интерне промене Moodle лозинке, или пак уз њу.';
$string['auth_changepasswordurl'] = 'URL за промену лозинке';
$string['auth_changepasswordurl_expl'] = 'Наведите URL адресу која ће бити послата корисницима који изгубе своје {$a} лозинке. Подесите<strong>Користити стандардну страницу за промену лозинке</strong> на <strong>Не</strong>.';
$string['auth_changingemailaddress'] = 'Затражили сте да стару адресе е-поште  {$a->oldemail} промените у нову {$a->newemail}. Из  разлога безбедности, шаљемо вам е-поруку на нову адресу како би потврдили да она заиста припада вама. Ваша адреса е-поште биће ажурирана чим отворите URL која вам је послат у тој поруци.';
$string['auth_common_settings'] = 'Општа подешавања';
$string['auth_data_mapping'] = 'Мапирање података';
$string['auth_fieldlock'] = 'Закључавање вредности';
$string['auth_fieldlock_expl'] = '<p><b>Закључај вредност:</b> Ако је омогућено, спречиће Moodle кориснике и администраторе да директно уређују поље. Користите ову опцију ако одржавате ове податке у екстерном систему за проверу идентитета. </p>';
$string['auth_fieldlockfield'] = 'Закључај вредност ({$a})';
$string['auth_fieldlocks'] = 'Закључај корисничка поља';
$string['auth_fieldlocks_help'] = '<p>Можете закључати поља са корисничким подацима. То је корисно за сајтове на којима корисничке податке ручно одржавају администратори уређивањем корисничких записа у бази података или постављањем података коришћењем опције  \'Постављање корисника\'. Ако закључавате поља која су неопходна за рад Moodle система, проверите да ли сте, приликом креирања корисничких налога, попунили та поља одговарајућим подацима, јер се у супротном налози неће моћи користити.</p><p>Подесите вредност за закључавање на \'Откључано ако је празно\' да бисте избегли наведени проблем.</p>';
$string['auth_fieldmapping'] = 'Мапирање података ({$a})';
$string['auth_invalidnewemailkey'] = 'Грешка: ако покушавате да потврдите промену адресе е-поште, можда сте направили грешку при копирању URL адресе коју смо вам послали путем е-поште. Молимо, копирајте адресу и покушајте поново.';
$string['auth_multiplehosts'] = 'Одређивање више домаћина или адреса (нпр. host1.com;host2.com;host3.com) или (npr. xxx.xxx.xxx.xxx;xxx.xxx.xxx.xxx)';
$string['auth_notconfigured'] = 'Метод провере идентитета {$a} није конфигурисан.';
$string['auth_outofnewemailupdateattempts'] = 'Потрошили сте дозвољени број покушаја за промену адресе е-поште. Ваш захтев за промену је одбијен.';
$string['auth_passwordisexpired'] = 'Ваша лозинка је истекла. Промените је одмах.';
$string['auth_passwordwillexpire'] = 'Ваша лозинка истиче за {$a} дан/а.  Да ли желите да је промените сада?';
$string['auth_remove_delete'] = 'Потпуно брисање интерних података';
$string['auth_remove_keep'] = 'Задржавање интерних података';
$string['auth_remove_suspend'] = 'Суспендовање интерних података';
$string['auth_remove_user'] = 'Одредите шта радити са унутрашњим корисничким налогом за време масовне синхронизације када је корисник уклоњен од стране спољног извора. Само суспендовани корисници се аутоматски обнављају ако се поново појављују у спољном извору.';
$string['auth_remove_user_key'] = 'Уклоњен спољни корисник';
$string['auth_sync_script'] = 'Синхронизација корисничког налога';
$string['auth_sync_suspended'] = 'Када је ова опција омогућена, суспендовани атрибут ће бити коришћен за ажурирање статуса суспензије локалног корисничког налога.';
$string['auth_sync_suspended_key'] = 'Синхронизуј статус суспензије локалног корисника';
$string['auth_updatelocal'] = 'Ажурирање локалних података';
$string['auth_updatelocal_expl'] = '<p><b>Ажурирање локалних података:</b> Ако је омогућено, поље ће бити ажурирано (користи се екстерни auth) сваки пут када корисник приступи систему или дође до корисничке синхронизације. Поља за која је подешено локално ажурирање треба да буду закључана.</p>';
$string['auth_updatelocalfield'] = 'Ажурирај локална поља ({$a})';
$string['auth_updateremote'] = 'Ажурирање екстерних података';
$string['auth_updateremote_expl'] = '<p><b>Ажурирање екстерних података:</b> Ако је омогућено, екстерни auth ће бити ажуриран при ажурирању записа о корисницима. Поља би требала бити откључана да би се дозволиле промене.</p>';
$string['auth_updateremote_ldap'] = '<p><b>Напомене:</b> Ажурирање екстерних LDAP података захтева да подесите повезивање binddn и bindpw за bind-корисника са привилегијама кориговања свих корисничких записа. Ово тренутно не чува вишевредносне атрибуте и уклониће додатне вредности надоградње.</p>';
$string['auth_updateremotefield'] = 'Ажурирај екстерна поља ({$a})';
$string['auth_user_create'] = 'Омогућити креирање корисника';
$string['auth_user_creation'] = 'Нови (анонимни) корисници могу направити корисничке налоге на спољашњем извору за проверу идентитета и извршити потврду путем е-поште. Ако омогућите ову опцију, конфигуришите и специфичне опције модула које служе за креирање корисника.';
$string['auth_usernameexists'] = 'Одабрано корисничко име већ постоји. Молимо изаберите друго корисничко име.';
$string['auth_usernotexist'] = 'Није могуће ажурирати непостојећег корисника: {$a}';
$string['authenticationoptions'] = 'Опције за проверу идентитета';
$string['authinstructions'] = 'Оставите ово поље празно ако желите да се корисницима приказују подразумеване инструкције за пријаву на систем на насловној страни. Ако желите да им понудите неке посебне инструкције унесите их овде.';
$string['authloginviaemail'] = 'Дозволи пријаву путем е-поште';
$string['authloginviaemail_desc'] = 'Дозволи корисницима да за пријављивање на сајт користе и корисничко име и адресу е-поште (ако је јединствена).';
$string['auto_add_remote_users'] = 'Аутоматско додавање удаљених корисника';
$string['cannotmapfield'] = 'Поље "{$a->fieldname}" не може да буде мапирано зато што је његов скраћени назив "{$a->shortname}" предуг. Како бисте омогућили мапирање потребно је да редукујете скраћени назив поља профила на {$a->charlimit} знак(ов)а. <a href="{$a->link}">Уреди поља корисничког профила</a>';
$string['changepassword'] = 'URL за промену лозинке';
$string['changepasswordhelp'] = 'URL адреса странице на којој корисници могу да обнове изгубљену или заборављену лозинку, која ће им бити послата електронском поштом. Имајте на уму да ово подешавање неће имати ефекта уколико је URL адреса странице за промену заборављене лозинке постављена у заједничким подешавањима за проверу идентитета.';
$string['chooseauthmethod'] = 'Изаберите начин провере идентитета';
$string['chooseauthmethod_help'] = 'Ово подешавање одређује начин провере идентитета који се користи када се корисник пријављује на систем. Треба да одаберете само додатке за проверу идентитет који су укључени, у супротном корисници неће више моћи да се пријаве. Да бисте блокирали пријаву корисника, изаберите "Нема пријаве".';
$string['createpassword'] = 'Генериши лозинку и обавести корисника';
$string['createpasswordifneeded'] = 'Креирајте лозинку ако је то потребно и пошаљите је е-поштом';
$string['emailchangecancel'] = 'Откажи промену електронске адресе';
$string['emailchangepending'] = 'Промена на чекању. Отворите линк који Вам је послата на {$a->preference_newemail}.';
$string['emailnowexists'] = 'Адреса е-поште коју сте покушали да доделите Вашем профилу је већ додељенљ другом кориснику. Зато је Ваш захтев за промену електорнске адресе поништен, али можете покушати са другом адресом.';
$string['emailupdate'] = 'Ажурирање електронске адресе';
$string['emailupdatemessage'] = 'Поштовани/а {$a->fullname},

Тражили сте промену е-адресе за свој кориснички налог на сајту {$a->site}. Да бисте потврдили ову промену, идите на следећу веб адресу:

{$a->url}

{$a->supportemail}';
$string['emailupdatesuccess'] = 'Е-адреса корисника <em>{$a->fullname}</em> је успешно промењена у <em>{$a->email}</em>.';
$string['emailupdatetitle'] = 'Потврда ажурирања е-адресе на {$a->site}';
$string['errormaxconsecutiveidentchars'] = 'Максималан број узастопних истоветних знакова које лозинка мора да садржи: {$a}';
$string['errorminpassworddigits'] = 'Минималан број цифара који лозинка мора садржати је: {$a}.';
$string['errorminpasswordlength'] = 'Минималан број знакова које лозинка мора да садржи: {$a}.';
$string['errorminpasswordlower'] = 'Минималан број малих слова који лозинка мора садржати је: {$a}.';
$string['errorminpasswordnonalphanum'] = 'Минималан број специјалних знакова (као што су *, - или #) које лозинка мора да садржи: {$a}.';
$string['errorminpasswordupper'] = 'Минималан број великих слова који лозинка мора садржати је: {$a}.';
$string['errorpasswordreused'] = 'Ова лозинка је раније већ коришћена, и није дозвољена користити је поново';
$string['errorpasswordupdate'] = 'Грешка у ажурирању лозинке, лозинка није промењена.';
$string['eventuserloggedin'] = 'Корисник се пријавио';
$string['eventuserloggedinas'] = 'Корисник пријављен као други корисник';
$string['eventuserloginfailed'] = 'Пријава корисника није успела';
$string['forcechangepassword'] = 'Обавезна промена лозинке';
$string['forcechangepassword_help'] = 'Приморај кориснике да промене лозинку приликом њихове следеће пријаве на Moodle.';
$string['forcechangepasswordfirst_help'] = 'Приморај кориснике да промене лозинку приликом њихове прве пријаве на Moodle.';
$string['forgottenpassword'] = 'Уколико овде унесете URL адресу, она ће бити коришћена за страницу за обнављање изгубљене/заборављене лозинке, на овом сајту. Ово је намењено сајтовима на којима се лозинкама, у потпуности, управља изван Moodlea. Оставите ово поље празно да бисте користили уобичајени начин за обнављање лозинке.';
$string['forgottenpasswordurl'] = 'URL адреса за обнављање заборављене лозинке';
$string['getrecaptchaapi'] = 'Да би се користио reCAPTCHA морате набавити API кључ на сајту <a href=\'https://www.google.com/recaptcha/admin\'>https://www.google.com/recaptcha/admin</a>';
$string['guestloginbutton'] = 'Дугме за пријаву гостију';
$string['incorrectpleasetryagain'] = 'Неисправно. Молимо покушајте поново';
$string['infilefield'] = 'Поље захтевано у датотеци';
$string['informminpassworddigits'] = 'минималан број цифара: {$a}';
$string['informminpasswordlength'] = 'минималан број знакова: {$a}';
$string['informminpasswordlower'] = 'минималан број малих слова: {$a}';
$string['informminpasswordnonalphanum'] = 'минималан број специјалних знакова (као што су *, - или #) : {$a}';
$string['informminpasswordreuselimit'] = 'Лозинке се могу поново користити након {$a} промене/а';
$string['informminpasswordupper'] = 'минималан број великих слова: {$a}';
$string['informpasswordpolicy'] = 'Лозинка мора имати {$a}';
$string['instructions'] = 'Упутства';
$string['internal'] = 'Интерно';
$string['limitconcurrentlogins'] = 'Ограничи истовремене пријаве';
$string['limitconcurrentlogins_desc'] = 'Ако је ова опција омогућена, број истовремених пријава веб читача за сваког корисника биће ограничен. Најстарије сесије се прекидају након што се достигне ограничење. Имајте у виду да корисник може да изгуби све што није сачувао Ово подешавање није компатибилно са SSO (single sign on - једноструко пријављивање) додацима за проверу идентитета.';
$string['locked'] = 'Закључано';
$string['md5'] = 'MD5 хеш';
$string['nopasswordchange'] = 'Није могуће променити лозинку';
$string['nopasswordchangeforced'] = 'Нисте у могућности да наставите даље без промене лозинке, међутим не постоји страница за њену промену. Молимо контактирајте Moodle администратора.';
$string['noprofileedit'] = 'Није могуће уређивати профил';
$string['ntlmsso_attempting'] = 'Покушава се SSO (Single Sign On) преко NTLM...';
$string['ntlmsso_failed'] = 'Аутоматско пријављивање није успело, покушајте са обичном страницом за пријављивљње...';
$string['ntlmsso_isdisabled'] = 'NTLM SSO (јединствена пријава) није укључена.';
$string['passwordhandling'] = 'Управљење пољем лозинке';
$string['plaintext'] = 'Обичан текст';
$string['pluginnotenabled'] = 'Додатак за проверу идентитета \'{$a}\' није омогућен.';
$string['pluginnotinstalled'] = 'Додатак за проверу идентитета \'{$a}\' није инсталиран.';
$string['potentialidps'] = 'Пријавите се користећи свој налог на:';
$string['privacy:metadata:userpref:createpassword'] = 'Означава да треба генерисати лозинку за корисника';
$string['privacy:metadata:userpref:forcepasswordchange'] = 'Означава да ли корисник треба да промени лозинку приликом пријаве на систем';
$string['privacy:metadata:userpref:loginfailedcount'] = 'Број неуспешних покушаја приступу систему од стране корисника';
$string['privacy:metadata:userpref:loginfailedcountsincesuccess'] = 'Број неуспешних покушаја приступу систему од стране корисника од последње успешне пријаве';
$string['privacy:metadata:userpref:loginfailedlast'] = 'Датум кад је забележен последњи неуспешан покушај приступа систему';
$string['privacy:metadata:userpref:loginlockout'] = 'Означава да ли је налог корисника закључан због неуспешних покушаја приступа систему, као и датум кад је налог закључан';
$string['privacy:metadata:userpref:loginlockoutignored'] = 'Означава да корисников налог никад не треба да буде подвргнут закључавању';
$string['privacy:metadata:userpref:loginlockoutsecret'] = 'Када је налог закључан, ово је лозинка коју корисник мора искористити да га откључа';
$string['recaptcha'] = 'reCAPTCHA';
$string['recaptcha_help'] = 'CAPTCHA служи за спречавање злоупотреба од стране аутоматизованих програма. Пратите упутства да бисте потврдили да сте особа. То може бити клик на квадратно поље, унос знакова приказаних на слици у текстуално поље, или одабир слика са одређеним мотивом од више понуђених.

Ако нисте сигурни шта је приказано на сликама, можете да затражите нови CAPTCHA или да послушате звучни CAPTCHA.';
$string['recaptcha_link'] = 'auth/email';
$string['security_question'] = 'Безбедносно питање';
$string['selfregistration'] = 'Саморегистрација';
$string['selfregistration_help'] = 'Ако је изабран додатак за проверу идентитета, као што је самостална регистрација путем е-поште, онда ће ово омогућити потенцијалним корисницима да се сами региструју и креирају корисничке налоге. Ово за последицу има могућност да спамери креирају корисничке налоге како би користили форуме, блог чланке и слично за слање нежељених порука. Како бисте избегли овај ризик, самостална регистрација треба да буде онемогућена или ограничена помоћу подешавања <em>Дозвољени домени е-поште</em>.';
$string['settingmigrationmismatch'] = 'Приликом исправке подешавања назива додатка откривено је неслагање између назива. Додатак за проверу идентитета plugin \'{$a->plugin}\' имао је опцију \'{$a->setting}\' које је конфигурисана као \'{$a->legacy}\', под старим називом, и као \'{$a->current}\', под текућим, новим називом. Друга вредност је узета као исправна, али потребно је да то проверите и потврдите.';
$string['sha1'] = 'SHA-1 хеш код';
$string['showguestlogin'] = 'Можете сакрити или приказати дугме за пријаву гостију на страници за пријављивљње.';
$string['stdchangepassword'] = 'Користи стандардну страницу за промену лозинке';
$string['stdchangepassword_expl'] = 'Ако спољашњи систем за проверу идентитета дозвољава промену лозинке из Moodle система, укључите га. Ово подешавање заобилази \'URL за промену лозинке\'.';
$string['stdchangepassword_explldap'] = 'Напомена: Препоручује се да користите LDAP пре него SSL шифровање тунела (ldaps://) ако је LDAP сервер удаљен.';
$string['suspended'] = 'Суспендовани налог';
$string['suspended_help'] = 'Корисници којима је суспендован налог не могу да се пријаве на систем или да користе веб сервисе, нити им се шаљу поруке са система.';
$string['testsettings'] = 'Тестирање подешавања';
$string['testsettingsheading'] = 'Подешавања  теста за проверу  идентитета  - {$a}';
$string['unlocked'] = 'Откључано';
$string['unlockedifempty'] = 'Откључано ако је празно';
$string['update_never'] = 'Никад';
$string['update_oncreate'] = 'При креирању';
$string['update_onlogin'] = 'При сваком приступу систему';
$string['update_onupdate'] = 'При ажурирању';
$string['user_activatenotsupportusertype'] = 'auth: ldap user_activate() не подржава изабрани тип корисника: {$a}';
$string['user_disablenotsupportusertype'] = 'auth: ldap user_activate() не подржава изабрани тип корисника (...још)';
$string['username'] = 'Корисничко име';
$string['username_help'] = 'Имајте на уму да вам неки додаци за проверу идентитета неће дозволити да промените корисничко име.';
