<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'question', language 'sr_cr', version '3.11'.
 *
 * @package     question
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Акција';
$string['addanotherhint'] = 'Додај још један савет';
$string['addcategory'] = 'Додај категорију';
$string['addmorechoiceblanks'] = 'Додај празна поља за још {no} одговора';
$string['adminreport'] = 'Извештај о могућим проблемима у вашој бази података са питањима';
$string['advancedsearchoptions'] = 'Опције за претрагу';
$string['alltries'] = 'Сви покушаји';
$string['answer'] = 'Одговор';
$string['answers'] = 'Одговори';
$string['answersaved'] = 'Одговор је сачуван';
$string['attemptfinished'] = 'Покушај је завршен';
$string['attemptfinishedsubmitting'] = 'Предаја завршених покушаја: {$a}';
$string['attemptoptions'] = 'Опције покушаја';
$string['availableq'] = 'Доступно?';
$string['badbase'] = 'Лоша база пре **: {$} **';
$string['behaviour'] = 'Понашање';
$string['behaviourbeingused'] = 'понашање које се користи: {$a}';
$string['broken'] = 'Ово је "прекинут линк", показује на непостојећи фајл.';
$string['byandon'] = 'уредио/ла <em>{$a->user}</em> (<em>{$a->time}</em>)';
$string['cannotcopybackup'] = 'Није могуће копирати датотеку резервне копије';
$string['cannotcreate'] = 'Није могуће креирати нови унос у табели  question_attempts';
$string['cannotcreatepath'] = 'Није могуће креирати путању: {$a}';
$string['cannotdeletebehaviourinuse'] = 'Не можете да обришете понашање \'{$a}\'. Већ постоје покушаји решавања питања које користи ово понашање.';
$string['cannotdeletecate'] = 'Не можете да обришете ову категорију, пошто је у овом контексту то подразумевана категорија.';
$string['cannotdeleteneededbehaviour'] = 'Није могуће обрисати понашање питање \'{$a}\'. Постоје и друга инсталирана понашања која се ослањају на њега.';
$string['cannotdeleteqtypeinuse'] = 'Не можете да обришете тип питања \'{$a}\'. у банци питања постоје питања овог типа.';
$string['cannotdeleteqtypeneeded'] = 'Не можете да обришете тип питања \'{$a}\'. Постоје други типови питања који су повезани са овим типом.';
$string['cannotdeletetopcat'] = 'Врховне категорије не могу да се бришу.';
$string['cannotedittopcat'] = 'Врховне категорије не могу да се уређују.';
$string['cannotenable'] = 'Тип питања {$a} не може бити креиран директно.';
$string['cannotenablebehaviour'] = 'Понашање питања {$a} не може да се користи директно. Оно служи само за интерну употребу.';
$string['cannotfindcate'] = 'Није могуће пронаћи запис категорије';
$string['cannotfindquestionfile'] = 'Није могуће пронаћи датотеку са питањима у зип архиви';
$string['cannotgetdsfordependent'] = 'Није могуће преузети наведени скуп података за питање зависно од скупа података! (питање: {$a->id}, ставка скупа података: {$a->item})';
$string['cannotgetdsforquestion'] = 'Није могуће преузети наведени скуп података за рачунско питање! (питање: {$a})';
$string['cannothidequestion'] = 'Није било могуће сакрити питање';
$string['cannotimportformat'] = 'Нажалост, увоз овог формата још није имплементиран!';
$string['cannotinsertquestion'] = 'Није могуће убацити ново питање!';
$string['cannotinsertquestioncatecontext'] = 'Није могуће уметнути нову категорију питања {$a->cat} илегални contextid {$a->ctx}';
$string['cannotloadquestion'] = 'Није могуће учитати питање';
$string['cannotmovequestion'] = 'Не можете да користите овај скрипт за пребацивање питања која имају придружене датотеке из различитих подручја.';
$string['cannotopenforwriting'] = 'Није могуће отворити за уписивање: {$a}';
$string['cannotpreview'] = 'Не можете да прегледате ова питања!';
$string['cannotread'] = 'Не може се читати увозна датотека (или је празна)';
$string['cannotretrieveqcat'] = 'Није могуће повратити ову категорију питања';
$string['cannotunhidequestion'] = 'Није могуће повратити категорију питања.';
$string['cannotunzip'] = 'Није могуће распаковати архивирану зип датотеку';
$string['cannotwriteto'] = 'Није могуће уписати извезена питања у {$a}';
$string['categories'] = 'Категорије';
$string['category'] = 'Категорија';
$string['categorycurrent'] = 'Тренутна категорија';
$string['categorycurrentuse'] = 'Користи ову категорију';
$string['categorydoesnotexist'] = 'Ова категорија не постоји';
$string['categoryinfo'] = 'Информације о категорији';
$string['categorymove'] = 'Категорија \'{$a->name}\' садржи {$a->count} питања (нека од њих могу бити скривена или насумично изабрана питања која се и даље користе у тесту). Молимо изаберите другу категорију у коју ћете их преместити.';
$string['categorymoveto'] = 'Сними у категорију';
$string['categorynamecantbeblank'] = 'Морате да упишете назив категорије';
$string['categorynamewithcount'] = '{$a->name} ({$a->questioncount})';
$string['categorynamewithidnumber'] = '{$a->name} [{$a->idnumber}]';
$string['categorynamewithidnumberandcount'] = '{$a->name} [{$a->idnumber}] ({$a->questioncount})';
$string['changeoptions'] = 'Промени опције';
$string['changepublishstatuscat'] = '<a href="{$a->caturl}">Категорији "{$a->name}"</a> ће у оквиру курса "{$a->coursename}" бити промењен статус дељења из {$a->changefrom} у {$a->changeto}.';
$string['check'] = 'Провери';
$string['chooseqtypetoadd'] = 'Изабери тип питања за додавање';
$string['clearwrongparts'] = 'Обриши нетачне одговоре';
$string['clickflag'] = 'Обележи питање индикатором (заставицом)';
$string['clicktoflag'] = 'Обележи ово питање индикатором (заставицом)';
$string['clicktounflag'] = 'Уклони индикатор (заставицу)';
$string['clickunflag'] = 'Уклони индикатор(заставицу)';
$string['closepreview'] = 'Затвори преглед';
$string['combinedfeedback'] = 'Комбиноване повратне информације';
$string['comment'] = 'Коментар';
$string['commented'] = 'Коментарисао: {$}';
$string['commentormark'] = 'Коментаришите или измените оцену';
$string['comments'] = 'Коментари';
$string['commentx'] = 'Коментар: {$a}';
$string['complete'] = 'Завршено';
$string['contexterror'] = 'Не бисте смели да будете овде уколико нисте премсетили категорију у други контекст';
$string['copy'] = 'Копирај из {$a} и промени линкове.';
$string['correct'] = 'Тачно';
$string['correctfeedback'] = 'За сваки тачан одговор';
$string['correctfeedbackdefault'] = 'Ваш одговор је тачан.';
$string['created'] = 'Креирано';
$string['createdby'] = 'Креирао/ла';
$string['createdmodifiedheader'] = 'Креирано / последње сачувано';
$string['createnewquestion'] = 'Креирај ново питање';
$string['cwrqpfs'] = 'Насумична питања се бирају из поткатегорија.';
$string['cwrqpfsinfo'] = '<p>Током надоградње на Moodle 1.9 верзију категорије питања ће бити подељене у различите контексте. Неким питањима и категоријама питања на вашем сајту ће морати да буде промењен статус дељења. Ово је неопходно у ретким случајевима када је једно или више ‘насумичних’ питања у неком тесту подешено тако да се бирају из мешавине дељених и недељених категорија (као што је то случај на овом сајту). Ово се догађа када је подешено да се ‘насумично’ питање бира из поткатегорија, а при томе једна или више поткатегорија имају различит статус дељења у односу на надређену категорију, у којој је ‘насумично’ питање креирано.</p>
<p>Следећим категоријама питања, из којих надређене категорије бирају ‘насумична’ питања, статус дељења ће бити промењен у исти онај статус какав важи за категорију са ‘насумичним’ питањем приликом надоградње на верзију Moodle 1.9. Следећим катеријама ће статус дељења бити промењен. Питања на која ће ове измене утицати наставиће нормално да функционишу у свим постојећим тестовима све док их не уклоните из тих тестова.</p>';
$string['cwrqpfsnoprob'] = 'Ниједна категорија питања на вашем сајту није погођена проблемом \'Насумична питања се бирају из поткатегорија\'.';
$string['decimalplacesingrades'] = 'Децимална места у оценама';
$string['defaultfor'] = 'Подразумевано за {$a}';
$string['defaultinfofor'] = 'Подразумевана категорија за питања дељена у контексту \'{$a}\'.';
$string['defaultmark'] = 'Подразумевана оцена';
$string['defaultmarkmustbepositive'] = 'Подразумевана оцена мора бити позитивна.';
$string['deletecoursecategorywithquestions'] = 'Постоје питања у бази питања придруженој овој категорији курсева. Ако наставите, она ће бити обрисана. Можда бисте желели да их прво преместите, користећи интерфејс за базе питања.';
$string['deletequestioncheck'] = 'Да ли сте потпуно сигурни да желите да обришете \'{$a}\'?';
$string['deletequestionscheck'] = 'Да ли сте потпуно сигурни да желите да обришете следећа питања?<br /><br />{$a}';
$string['deletingbehaviour'] = 'Брисање понашања питања \'{$a}\'';
$string['deletingqtype'] = 'Брисање типа питања \'{$a}\'';
$string['didnotmatchanyanswer'] = '[Не поклапа се ни са једним одговором]';
$string['disabled'] = 'Онемогућено';
$string['displayoptions'] = 'Опције приказа';
$string['disterror'] = 'Дистрибуција {$a} је изазвала проблеме';
$string['donothing'] = 'Немојте копирати/премештати датотеке или мењати линкове.';
$string['editcategories'] = 'Уреди категорије';
$string['editcategories_help'] = 'Уместо да сва буду на једном великом списку, питања могу бити организована у категорије и поткатегорије.

Свака категорија има контекст који одређује где питања из ње могу да се користе:

* Контекст активности - питања су доступна само унутар одређене активности
* Контекст курса - питања су доступна  у свим активностима одређеног курса
* Контекст категорије курса - питања су доступна у свим активностима и курсевима одређене категорије курсева
* Контекст система - питања су доступна у свим курсевима и активностима на сајту

Категорије се користе и за насумично изабрана питања, будући да се она бирају из одређених категорија.';
$string['editcategories_link'] = 'question/category';
$string['editcategory'] = 'Уреди категорију';
$string['editingcategory'] = 'Уређивање категорије';
$string['editingquestion'] = 'Уређивање питања';
$string['editquestion'] = 'Уреди питање';
$string['editquestions'] = 'Уреди питања';
$string['editthiscategory'] = 'Уреди ову категорију';
$string['emptyxml'] = 'Непозната грешка - празна imsmanifest.xml датотека';
$string['enabled'] = 'Омогућено';
$string['erroraccessingcontext'] = 'Не може се приступити контексту';
$string['errordeletingquestionsfromcategory'] = 'Грешка при брисању питања из категорије {$a}.';
$string['errorduringpost'] = 'Дошло је до грешке у току накнадне обраде!';
$string['errorduringpre'] = 'Дошло је до грешке у току претходне обраде!';
$string['errorduringproc'] = 'Дошло је до грешке у току обраде!';
$string['errorduringregrade'] = 'Није могуће поново оценити питање {$a->qid}, прелазим на стање {$a->stateid}.';
$string['errorfilecannotbecopied'] = 'Грешка, не може да се копира датотека {$a}.';
$string['errorfilecannotbemoved'] = 'Грешка, не може да се премести датотека {$a}.';
$string['errorfileschanged'] = 'Грешка: датотеке повезане са питањима су измењене од момента када је образац био приказан.';
$string['erroritemappearsmorethanoncewithdifferentweight'] = 'Питање ({$a}) се појављује више него једном са различитим пондерима на различитим местима у тесту. Статистички извештај то тренутно не подржава те статистика за ово питање може бити непоуздана.';
$string['errormanualgradeoutofrange'] = 'Оцена {$a->grade} није између 0 и {$a->maxgrade} за питање {$a->name}. Резултат и коментар нису сачувани.';
$string['errormovingquestions'] = 'Грешка при премештању питања са id вредностима $а.';
$string['errorpostprocess'] = 'Дошло је до грешке у току накнадне обраде!';
$string['errorpreprocess'] = 'Дошло је до грешке у току претходне обраде!';
$string['errorprocess'] = 'Дошло је до грешке у току обраде!';
$string['errorprocessingresponses'] = 'Дошло је до грешке приликом обраде ваших одговора ({$a}). Кликните на дугме \'Настави\' да бисте се вратили на страницу на којој сте били и покушајте поново.';
$string['errorsavingcomment'] = 'Грешка приликом покушаја да се сачува коментар за питање {$a->name} у бази података.';
$string['errorsavingflags'] = 'Грешка приликом покушаја да се сачува статус индикатора.';
$string['errorupdatingattempt'] = 'Грешка приликом ажурирања покушаја {$a->id} у бази података.';
$string['eventquestioncategorycreated'] = 'Категорија питања креирана';
$string['eventquestioncategorydeleted'] = 'Категорија питања обрисана';
$string['eventquestioncategorymoved'] = 'Категорија питања премештена';
$string['eventquestioncategoryupdated'] = 'Категорија питања ажурирана';
$string['eventquestioncategoryviewed'] = 'Категорија питања приказана';
$string['eventquestioncreated'] = 'Питање креирано';
$string['eventquestiondeleted'] = 'Питање обрисано';
$string['eventquestionmoved'] = 'Питање премештено';
$string['eventquestionsexported'] = 'Питања извезена';
$string['eventquestionsimported'] = 'Питања увезена';
$string['eventquestionupdated'] = 'Питање ажурирано';
$string['eventquestionviewed'] = 'Питање приказано';
$string['export'] = 'Извоз';
$string['exportasxml'] = 'Извези као Moodle XML';
$string['exportcategory'] = 'Извези категорију';
$string['exportcategory_help'] = 'Ово подешавање одређује категорију из које ће бити преузета  извезена питања.

Одређени формати за увоз питања, као што су GIFT и Moodle XML, дозвољавају да у датотеку која се извози буду укључени и подаци о категорији и контексту, што овим форматима даје могућност (опционо) да, приликом увоза питања, поново креирају категорију и контекст. Ако је неопходно, треба означити одговарајуће поље за избор.';
$string['exporterror'] = 'Појавила се грешка у току експортовања!';
$string['exportfilename'] = 'тест';
$string['exportnameformat'] = '%d.%m.%Y.-%H.%M';
$string['exportonequestion'] = 'Преузмите ово питање у Moodle XML формату';
$string['exportquestions'] = 'Извези питања у датотеку';
$string['exportquestions_help'] = 'Ова функција омогућава извоз комплетне категорије питања (са свим њеним поткатегоријама) у текстуалну датотеку. Молимо вас, имајте на уму да, зависно од изабраног формата датотека, неки подаци о питањима и одређени типови питања не могу да буду извезени.';
$string['exportquestions_link'] = 'question/export';
$string['feedback'] = 'Повратне информације';
$string['filecantmovefrom'] = 'Датотеке са питањима не могу бити премештене зато што немате овлашћења да уклањате датотеке са места са којег покушавате да изместите питања.';
$string['filecantmoveto'] = 'Датотеке са питањима не могу бити премештене или копиране зато што немате овлашћења да додајете датотеке на место на које покушавате да преместите питања.';
$string['fileformat'] = 'Формат датотеке';
$string['filesareacourse'] = 'простор за датотеке курса';
$string['filesareasite'] = 'простор за датотеке сајта';
$string['filestomove'] = 'Премести / копирај датотеке у {$a}?';
$string['fillincorrect'] = 'Унеси тачне одговоре';
$string['filterbytags'] = 'Филтрирај према ознакама...';
$string['firsttry'] = 'Први покушај';
$string['flagged'] = 'Обележено';
$string['flagthisquestion'] = 'Обележи ово питање';
$string['formquestionnotinids'] = 'Образац садржи питање које није у questionids';
$string['fractionsnomax'] = 'Један од одговора би требао носити 100% резултата тако да је могуће добити максималан могући број бодова за ово питање.';
$string['generalfeedback'] = 'Опште повратне информације';
$string['generalfeedback_help'] = 'Опште повратне информације се приказује полазницима након што су завршили питање. За разлику од специфичних повратних информација, које зависе од типа питања и одговора који је полазник дао, исти текст општих повратних информација се приказује свим полазницима.

Опште повратне информације можете користити како бисте полазницима дали потпуно тачан одговор и, евентуално, линк ка детаљнијим информацијама које  могу да користе уколико нису разумели питања.';
$string['getcategoryfromfile'] = 'Преузми категорију из датотеке';
$string['getcontextfromfile'] = 'Преузми контекст из датотеке';
$string['hintn'] = 'Савет {no}';
$string['hintnoptions'] = 'Савет {no} опције';
$string['hinttext'] = 'Текст савета';
$string['howquestionsbehave'] = 'Како се понашају питања';
$string['howquestionsbehave_help'] = 'Полазници могу да ступају у бројне, различите интеракције са питaњима на тесту. На пример, можда ћете хтети да полазници унесу одговоре за сва питања и онда предају комплетан тест, пре него што буду оцењени или пре него што добију било какве повратне информације. Овај режим се зове \'Одложене повратне информације\'.

Алтернативно, можда ћете хтети да полазници предају сваки одговор засебно у току решавања теста како би одмах добили повратне информације, а ако их не добију да могу поново да покушају да дају нови одговор за нижу оцену. Овај режим се зове \'Интерактивно са вишеструким покушајима\'.

Ово су вероватно два најчешће коришћена режима понашања питања.';
$string['howquestionsbehave_link'] = 'question/behaviour';
$string['idnumber'] = 'ID број';
$string['idnumber_help'] = 'Ако се користи, ID број мора бити јединствен у свакој категорији питања. Он пружа још један начин за идентификацију питања који је понекад користан, али обично се може изоставити.';
$string['ignorebroken'] = 'Игнориши неисправне линкове';
$string['import'] = 'Увоз';
$string['importcategory'] = 'Увези категорију';
$string['importcategory_help'] = 'Ово подешавање одређује категорију у коју ће увезена питања бити смештена.

Одређени формати увоза, као што су GIFT и Moodle XML, могу да укључе у увозну датотеку и информације о категорији и контексту. Ако желите да користите те податке, уместо изабране категорије, потребно је да означите одговарајућа поља за избор. Ако категорије наведене у увозној датотеци не постоје, оне ће бити креиране.';
$string['importerror'] = 'Дошло је до грешке у току обраде увоза';
$string['importerrorquestion'] = 'Грешка приликом увоза питања';
$string['importfromcoursefiles'] = '... или изаберите датотеку курса за увоз';
$string['importfromupload'] = 'Изаберите датотеку за постављање';
$string['importingquestions'] = 'Увоз {$a} питања из датотеке';
$string['importparseerror'] = 'Пронађена је грешка/е у току парсирања датотеке која се увози. Да бисте увезли питања која су добра покушајте поново тако што ћете подешавање \'Заустави када се појави грешка\' подесити на \'Не\'';
$string['importquestions'] = 'Увези питања из датотеке';
$string['importquestions_help'] = 'Ова функција омогућава да питања у различитим форматима буду увезена путем текстуалне датотеке. Имајте у виду да датотека мора да користи UTF-8 кодни распоред.';
$string['importquestions_link'] = 'question/import';
$string['importwrongfileencoding'] = 'Датотека коју сте изабрали се не користи UTF-8 кодни распоред. {$a} датотека/е мора/ју користити UTF-8.';
$string['importwrongfiletype'] = 'Тип датотеке који сте изабрали ({$a->actualtype}) се не поклапа са типом који очекује овај формат увоза ({$a->expectedtype}).';
$string['impossiblechar'] = 'Откривен је немогући знак {$a} као знак за заграде';
$string['includesubcategories'] = 'Прикажи, такође, питања из поткатегорија';
$string['incorrect'] = 'Нетачно';
$string['incorrectfeedback'] = 'За сваки нетачан одговор';
$string['incorrectfeedbackdefault'] = 'Ваш одговор је нетачан.';
$string['information'] = 'Информација';
$string['invalidanswer'] = 'Непотпун одговор';
$string['invalidarg'] = 'Нису достављени исправни аргументи или је погрешна конфигурација сервера';
$string['invalidcategoryidforparent'] = 'Неисправан идентификатор надређене категорије!';
$string['invalidcategoryidtomove'] = 'Неисправан идентификатор категорије која се премeшта!';
$string['invalidconfirm'] = 'Израз за потврду је неисправан';
$string['invalidcontextinhasanyquestions'] = 'Неисправан контекст прослеђен у question_context_has_any_questions.';
$string['invalidgrade'] = 'Оцене се не поклапају са опцијама за оцењивање - питањe је прескочено';
$string['invalidpenalty'] = 'Неисправна казна';
$string['invalidwizardpage'] = 'Навеедена страница са "чаробњакoм" (<i>wizard page</i>) је неисправна или не постоји!';
$string['lastmodifiedby'] = 'Последњи пут изменио/ла';
$string['lasttry'] = 'Последњи покушај';
$string['linkedfiledoesntexist'] = 'Датотека {$a} до које води линк не постоји';
$string['makechildof'] = 'Направи потомка од \'{$a}\'';
$string['makecopy'] = 'Направи копију';
$string['maketoplevelitem'] = 'Помери на највиши ниво';
$string['manualgradeinvalidformat'] = 'То није валидан број.';
$string['manualgradeoutofrange'] = 'Ова оцена је изван важећег опсега';
$string['manuallygraded'] = 'Ручно оцењено {$a->mark} са коментаром: {$a->comment}';
$string['mark'] = 'Оцени';
$string['markedoutof'] = 'Максимална оцена';
$string['markedoutofmax'] = 'Максимална оцена {$a}';
$string['markoutofmax'] = 'Оцена {$a->mark} од {$a->max}';
$string['marks'] = 'Оцене';
$string['matchgrades'] = 'Упари оцене';
$string['matchgrades_help'] = 'Увезене оцене морају да се поклапају са фиксним списком  валидних оцена - 100, 90, 80, 75, 70, 66.666, 60, 50, 40, 33.333, 30, 25, 20, 16.666, 14.2857, 12.5, 11.111, 10, 5, 0 (такође и негативне вредности). Ако се не поклапају, постоје две
могућности:

* Грешка ако оцена није на списку - ако питање садржи било коју оцену која није на списку биће приказана грешка а то питање неће бити увезено
* Најближа оцена ако оцена није на списку - ако се оцена не поклапа ни са једном са списка, биће промењена у најприближнију вредност';
$string['matchgradeserror'] = 'Грешка ако оцена није наведена';
$string['matchgradesnearest'] = 'Најближа оцена ако оцена није наведена';
$string['missingcourseorcmid'] = 'Print_question захтева courseid или cmid.';
$string['missingcourseorcmidtolink'] = 'Get_question_edit_link захтева courseid или cmid.';
$string['missingimportantcode'] = 'Овом типу питања недостаје важан кôд: {$a}.';
$string['missingoption'] = 'Питању типа Уметнути одговори {$a} недостају опције';
$string['modified'] = 'Последња измена';
$string['move'] = 'Премести из {$a} и промени линкове.';
$string['movecategory'] = 'Премести категорију';
$string['movedquestionsandcategories'] = 'Премештена су питања и категорије питања са {$a->oldplace} на {$a->newplace}.';
$string['movelinksonly'] = 'Само промените дестинације линкова, немојте премештати нити копирати датотеке.';
$string['moveq'] = 'Премести питање(а)';
$string['moveqtoanothercontext'] = 'Премести питање у други контекст.';
$string['moveto'] = 'Премести у >>';
$string['movingcategory'] = 'Премештање категорије';
$string['movingcategoryandfiles'] = 'Да ли сте сигурни да желите да преместите категорију {$a->name} и све њој подређене категорије у контекст за "{$a->contextto}"?<br /> Постоји {$a->urlcount} датотека у вези са питањима у {$a->fromareaname}. Да ли желите да је(их) копирате или преместите у {$a->toareaname}?';
$string['movingcategorynofiles'] = 'Да ли сте сигурни да желите да преместите категорију "{$a->name}" и све подређене категорије у контекст за "{$a->contextto}"?';
$string['movingquestions'] = 'Премештање питања и свих датотека';
$string['movingquestionsandfiles'] = 'Да ли сте сигурни да желите да преместите питање(а) {$a->questions} у контекст за <strong>"{$a->tocontext}"</strong>?<br /> Постоји <strong>{$a->urlcount} датотека</strong> до које(којих) воде линкови из овог(ових) питања у {$a->fromareaname}. Да ли желите да је(их) копирате или преместите у {$a->toareaname}?';
$string['movingquestionsnofiles'] = 'Да ли сте сигурни да желите да преместите питање(а) {$a->questions} у контекст за <strong>"{$a->tocontext}"</strong>?<br /> <strong>Нема датотека</strong> повезаних са њим(а) у {$a->fromareaname}.';
$string['needtochoosecat'] = 'Морате одабрати категорију у коју желите да преместите ово питање или притиснути \'откажи\'.';
$string['nocate'] = 'Не постоји категорија {$a}!';
$string['nopermissionadd'] = 'Немате одобрење да додате питање овде.';
$string['nopermissionmove'] = 'Немате дозволе да премештате питања одавде. Морате сачувати питање у овој категорији или га сачувати као ново питање.';
$string['noprobs'] = 'Није нађен ни један проблем у вашој бази података са питањима.';
$string['noquestions'] = 'Није пронађено ниједно питање које би могло да се извезе. Проверите да ли сте за извоз изабрали категорију која садржи питања.';
$string['noquestionsinfile'] = 'Нема питања у датотеци одабраној за увоз';
$string['noresponse'] = '[Нема одговора]';
$string['notagfiltersapplied'] = 'Није примењен филтер по ознакама';
$string['notanswered'] = 'Није одговорено';
$string['notchanged'] = 'Није мењано од последњег покушаја';
$string['notenoughanswers'] = 'Овај тип питања захтева најмање {$} одговора';
$string['notenoughdatatoeditaquestion'] = 'Нису специфицирани ни идентификатор питања, ни идентификатор категорије са типом питања.';
$string['notenoughdatatomovequestions'] = 'Морате навецти идентификаторе питања која желите да преместите.';
$string['notflagged'] = 'Није означено';
$string['notgraded'] = 'Није оцењено';
$string['notshown'] = 'Није приказано';
$string['notyetanswered'] = 'Још није одговорено';
$string['notyourpreview'] = 'Овај преглед не припада вама';
$string['novirtualquestiontype'] = 'Не постоји виртуелни тип питања за питање типа {$a}';
$string['numqas'] = 'Број покушаја';
$string['numquestions'] = 'Број питања';
$string['numquestionsandhidden'] = '{$a->numquestions} (+{$a->numhidden} скривено)';
$string['options'] = 'Опције';
$string['page-question-category'] = 'Страница категорије питања';
$string['page-question-edit'] = 'Страница за уређивање питања';
$string['page-question-export'] = 'Страница за извоз питања';
$string['page-question-import'] = 'Страница за увоз питања';
$string['page-question-x'] = 'Било која страница питања';
$string['parent'] = 'Надређено';
$string['parentcategory'] = 'Надређена категорија';
$string['parentcategory_help'] = 'Надређена категорија је она у коју ће нова категорија бити смештена. "Топ" значи  да се та категорија не налази унутар било које друге категорије. Контексти категорије су приказани подебљаним словима. Мора да постоји бар једна категорија у сваком контексту.';
$string['parentcategory_link'] = 'question/category';
$string['parenthesisinproperclose'] = 'Заграде пре ** нису правилно затворене у {$a}*';
$string['parenthesisinproperstart'] = 'Zаграде пре ** нису правилно отворене у {$a}*';
$string['parsingquestions'] = 'Парсирање питања из увозне датотеке.';
$string['partiallycorrect'] = 'Делимично тачно';
$string['partiallycorrectfeedback'] = 'За сваки делимично тачан одговор';
$string['partiallycorrectfeedbackdefault'] = 'Ваш одговор је делимично тачан.';
$string['penaltyfactor'] = 'Казнени фактор';
$string['penaltyfactor_help'] = '<p>Можете одредити који део постигнутог резултата би треабло одузети за сваки погрешан одговор. Ово је релевантно само уколико је тест подешен тако да користи адаптивни мод који омогућава полазнику да понављано одговоре на исто питање. Казненини фактор морао би да буде број између 0 и 1. Казнени фактор који има вредност 1 значи да полазник мора да тачан одговор из првог пута да би уопште добио поен за питање. Казнени фактор 0 значи да полазник може да покушава онолико пута колико жели и увек ће добити максималан број поена.</p>';
$string['penaltyforeachincorrecttry'] = 'Казнени бодови за сваки нетачан покушај';
$string['penaltyforeachincorrecttry_help'] = 'Када у тесту употребљавате питања користећи режим \'Интерактивно са вишеструким покушајима\' или \'Адаптивни режим\', тако да полазник има на располагању већи број покушаја да тачно одговори на питање, онда ова опција контролише са колико бодова ће бити кажњен сваки нетачан покушај.

Казна представља део укупне оцене за питање. На пример ако питање носи три бода, а казна је 0.3333333, онда ће полазник освојити 3 бода уколико из првог покушаја тачно одговори, 2 ако тачно одговори из другог покушаја и 1 уколико је одговoрио тачно у трећем покушају.

За нека питања која се састоје из више делова ова логика бодовања примењује се одвојено на сваки део питања. Детаљи зависе од типа питања и могу бити компликовани, али принцип је да се полазницима дају бодове за знање које су показали, што је могуће праведније.';
$string['permissionedit'] = 'Уредите ово питање';
$string['permissionmove'] = 'Преместите ово питање';
$string['permissionsaveasnew'] = 'Сачувај ово питање као ново';
$string['permissionto'] = 'Имате дозволу да:';
$string['previewquestion'] = 'Прегледaj питање: {$a}';
$string['privacy:metadata:database:question'] = 'Детаљне информације о конкретном питању.';
$string['privacy:metadata:database:question:createdby'] = 'Особа која је креирала питање.';
$string['privacy:metadata:database:question:generalfeedback'] = 'Опште повратне информацације за ово питање.';
$string['privacy:metadata:database:question:modifiedby'] = 'Особа која је последње ажурирала питање.';
$string['privacy:metadata:database:question:name'] = 'Назив питања.';
$string['privacy:metadata:database:question:questiontext'] = 'Текст питања.';
$string['privacy:metadata:database:question:timecreated'] = 'Датум и време када је ово питање креирано.';
$string['privacy:metadata:database:question:timemodified'] = 'Датум и време када је ово питање ажурирано.';
$string['privacy:metadata:database:question_attempt_step_data'] = 'Кораци за покушај одговарања на питање могу имати додатне податке специфичне за тај корак. Подаци се чувају у табели step_data.';
$string['privacy:metadata:database:question_attempt_step_data:name'] = 'Назив ставке података.';
$string['privacy:metadata:database:question_attempt_step_data:value'] = 'Вредност ставке података.';
$string['privacy:metadata:database:question_attempt_steps'] = 'Сваки покушај одговора питања има неколико корака који указују на различите фазе од почетка преко завршетка до оцењивања. Ова табела чува информације за сваки од ових корака.';
$string['privacy:metadata:database:question_attempt_steps:fraction'] = 'Оцена која је додељена овом покушају одговора на питање скалирана је према вредности од 1.';
$string['privacy:metadata:database:question_attempt_steps:state'] = 'Статус овог покушаја одговора на питање на крају транзиције корака.';
$string['privacy:metadata:database:question_attempt_steps:timecreated'] = 'Датум и време када је ова транзиција корака започета.';
$string['privacy:metadata:database:question_attempt_steps:userid'] = 'Корисник који је извршио транзицију корака.';
$string['privacy:metadata:database:question_attempts'] = 'Информације о покушају давања одговора на одређено питање.';
$string['privacy:metadata:database:question_attempts:flagged'] = 'Назнака да је корисник означио ово питање унутар покушаја.';
$string['privacy:metadata:database:question_attempts:responsesummary'] = 'Резиме одговора на питање.';
$string['privacy:metadata:database:question_attempts:timemodified'] = 'Време када је ажуриран покушај одговора на питање.';
$string['privacy:metadata:link:qbehaviour'] = 'Подсистем Питање користи додатак Понашање питања.';
$string['privacy:metadata:link:qformat'] = 'Подсистем Питање користи додатак Формати за увоз/извоз питања у сврху увоза и извоза питања у различитим форматима.';
$string['privacy:metadata:link:qtype'] = 'Подсистем Питање је у интеракцији са додатком Тип питања који садржи различите типове питања.';
$string['published'] = 'објављено';
$string['qtypeveryshort'] = 'Т';
$string['questionaffected'] = '<a href="{$a->qurl}">Питање "{$a->name}" ({$a->qtype})</a> је у овој категорији питања али се користи и у <a href="{$a->qurl}">тесту "{$a->quizname}"</a> који припада другом курсу "{$a->coursename}".';
$string['questionbank'] = 'Банка питања';
$string['questionbehaviouradminsetting'] = 'Подешавања понашања питања';
$string['questionbehavioursdisabled'] = 'Понашања питања које желите да онемогућите';
$string['questionbehavioursdisabledexplained'] = 'Унесите списак понашања, одвојених зарезима, која не желите да се појављују у падајућем менију.';
$string['questionbehavioursorder'] = 'Редослед понашања питања';
$string['questionbehavioursorderexplained'] = 'Унесите списак понашања рaздвојена зарезима оним редоследом којим желите да се она појављују у падајућем менију.';
$string['questioncategory'] = 'Категорија питања';
$string['questioncatsfor'] = 'Категорије питања за \'{$a}\'';
$string['questiondoesnotexist'] = 'Ово питање не постоји';
$string['questionformtagheader'] = '{$a} ознака';
$string['questionidmismatch'] = 'Непоклапање идентификационих ознака питања';
$string['questionname'] = 'Назив питања';
$string['questionnamecopy'] = '{$a} (копија)';
$string['questionno'] = 'Питање {$a}';
$string['questionpreviewdefaults'] = 'Подразумевана подешавања за преглед питања';
$string['questionpreviewdefaults_desc'] = 'Ова подразумевана подешавања се користе када корисник први пут прегледа питање у банци питања. Када корисник прегледа питање његова подешавања ће бити сачувана као корисничка подешавања';
$string['questions'] = 'Питања';
$string['questionsaveerror'] = 'У току покушаја да се сачува питање  ({$a}) појавила се грешка';
$string['questionsinuse'] = '(* Питања обележена звездицом се користе негде, на пример у тест. Стога, ако наставите, ова питања неће бити заиста обрисана, већ ће само бити сакривена.)';
$string['questionsmovedto'] = 'Питање које се још увек користи је премештено у "{$a}" у оквиру надређене категорије.';
$string['questionsrescuedfrom'] = 'Питање сачувано из контекста {$a}.';
$string['questionsrescuedfrominfo'] = 'Ова питања (од којих нека могу бити скривена) сачувана су када је контекст {$a} био обрисан, зато што се још увек користе у неким тестовима или другим активностима.';
$string['questiontags'] = 'Ознаке питања';
$string['questiontext'] = 'Текст питања';
$string['questiontype'] = 'Тип питања';
$string['questionuse'] = 'Користи питање у овој активности';
$string['questionvariant'] = 'Варијанта питања';
$string['questionx'] = 'Питање {$a}';
$string['requiresgrading'] = 'Захтева оцењивање';
$string['responsehistory'] = 'Историја одговора';
$string['restart'] = 'Поново започни';
$string['restartwiththeseoptions'] = 'Поново започни с овим опцијама';
$string['restoremultipletopcats'] = 'Датотека са резервном копијом садржи више од једне врховне категорије питања за контекст {$a}.';
$string['reviewresponse'] = 'Прегледај одговоре';
$string['rightanswer'] = 'Тачан одговор';
$string['rightanswer_help'] = 'Аутоматски генерисани резиме тачног одговора. Ово има своја ограничења, па ћете можда пожелети да размотрите могућност да тачан одговор детаљније објасните у општим повратним информацијама за питање, а ову опцију искључите.';
$string['save'] = 'Сачувај';
$string['savechangesandcontinueediting'] = 'Сачувај промене и настави уређивање';
$string['saved'] = 'Сачувано: {$a}';
$string['saveflags'] = 'Сачувај стање индикатора (заставица)';
$string['selectacategory'] = 'Изабери категорију';
$string['selectaqtypefordescription'] = 'Изабери тип питања да би видео његов опис';
$string['selectcategoryabove'] = 'Изаберите категорију од горе наведених';
$string['selectquestionsforbulk'] = 'Изаберите питања за групне акције';
$string['settingsformultipletries'] = 'Вишеструки покушаји';
$string['shareincontext'] = 'Дели у контексту за {$a}';
$string['showhidden'] = 'Прикажи и стара питања';
$string['showmarkandmax'] = 'Прикажи оцену и максималну оцену';
$string['showmaxmarkonly'] = 'Прикажи само максималну оцену';
$string['shown'] = 'Приказано';
$string['shownumpartscorrect'] = 'Прикажи број тачних одговора';
$string['shownumpartscorrectwhenfinished'] = 'Прикажи број тачних одговора';
$string['showquestiontext'] = 'Прикажи текст питања на списку питања';
$string['specificfeedback'] = 'Специфичне повратне информације';
$string['specificfeedback_help'] = 'Повратне информација која зависи од одговора који је полазник дао';
$string['started'] = 'Започето';
$string['state'] = 'Стање';
$string['step'] = 'Корак';
$string['steps'] = 'Кораци';
$string['stoponerror'] = 'Заустави када се појави грешка';
$string['stoponerror_help'] = 'Ово подешавање одређује да ли се процес увоза зауставља када се открије грешка, што ће резултирати тиме да ниједно питање неће бити увезено, или се питања са грешком игноришу док се сва исправна питања увозе.';
$string['submissionoutofsequence'] = 'Приступ ван редоследа. Молимо вас, немојте да кликћете на дугме \'Назад\' када одговарате на питања са теста.';
$string['submissionoutofsequencefriendlymessage'] = 'Унели сте податке ван нормалног редоследа. То се може десити ако користите дугмад \'Назад\'  (Back) или \'Напред\' (Forward) у свом веб читачу. Молимо вас да их не користите током теста. Ово се, такође, може догодити ако кликнете на нешто док се страница учитава. Како бисте наставили кликните на <strong>Настави</strong>.';
$string['submit'] = 'Предај';
$string['submitandfinish'] = 'Предај и заврши';
$string['submitted'] = 'Предај: {$a}';
$string['tagarea_question'] = 'Питања';
$string['technicalinfo'] = 'Техничке информације';
$string['technicalinfo_help'] = 'Ове техничкe информацијe корисне су вероватно само програмерима који раде на развоју нових типова питања. Такође, оне могу бити од користи приликом покушаја да се дијагностикују проблеми са питањима.';
$string['technicalinfomaxfraction'] = 'Максимални удео: {$a}';
$string['technicalinfominfraction'] = 'Минимални удео: {$a}';
$string['technicalinfoquestionsummary'] = 'Резиме питања: {$a}';
$string['technicalinforesponsesummary'] = 'Резиме одговора: {$a}';
$string['technicalinforightsummary'] = 'Резиме тачног одговора: {$a}';
$string['technicalinfostate'] = 'Стање питања: {$a}';
$string['technicalinfovariant'] = 'Варијанта питања: {$a}';
$string['tofilecategory'] = 'Упиши категорију у датотеку';
$string['tofilecontext'] = 'Упиши контекст у датотеку';
$string['topfor'] = 'Врховна категорија за {$a}';
$string['uninstallbehaviour'] = 'Деинсталирај ово понашање питања';
$string['uninstallqtype'] = 'Деинсталирај овај тип питања';
$string['unknown'] = 'Непознато';
$string['unknownbehaviour'] = 'Непознато понашање: {$a}.';
$string['unknownorunhandledtype'] = 'Непознат или неподржан тип питања: {$a}';
$string['unknownquestion'] = 'Непознато питање: {$a}.';
$string['unknownquestioncatregory'] = 'Непозната категорија питања: {$a}.';
$string['unknownquestiontype'] = 'Непознат тип питања: {$a}.';
$string['unknowntolerance'] = 'Непозната тип одступања {$}';
$string['unpublished'] = 'необјављено';
$string['unusedcategorydeleted'] = 'Након брисања курса, ова категорија је, такође, обрисана, због тога што се питања из ове категорија не користе у тестовима других курсева.';
$string['updatedisplayoptions'] = 'Ажурирај опције приказа';
$string['upgradeproblemcategoryloop'] = 'Откривен је проблем при покушају ажурирања категорија питања. Постоји петља у стаблу категорија. Погођене су тиме категорије са id вредностима $а.';
$string['upgradeproblemcouldnotupdatecategory'] = 'Није могуће ажурирати категорију питања {$a->name} ({$a->id}).';
$string['upgradeproblemunknowncategory'] = 'Откривен је проблем при покушају ажурирања категорија питања. Категорија {$a->id} указује на надређену категорију {$a->parent}, која не постоји. Промењена је надређена категорија да би се решио проблем.';
$string['whethercorrect'] = 'Да ли је одговор тачан';
$string['whethercorrect_help'] = 'Ово покрива како текстуални опис типа \'Тачно\', \'Делимично тачно\' или \'Нетачно\',  тако и сваки бојом истакнут текст који носи исту информацију.';
$string['whichtries'] = 'Који покушај';
$string['withselected'] = 'Са изабранима';
$string['wrongprefix'] = 'Погрешно форматиран nameprefix {$a}';
$string['xoutofmax'] = '{$a->mark} од {$a->max}';
$string['yougotnright'] = 'Исправно сте изабрали {$a->num}.';
$string['youmustselectaqtype'] = 'Морате да изаберете тип питања.';
$string['yourfileshoulddownload'] = 'Ваша датотека за извоз - требало би да ускоро започне преузимање. У супротном, молимо <a href="{$a}">кликните овде</a>. Промењена је надређена категорија да би се решио проблем.';
