<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'h5pactivity', language 'pt', version '3.11'.
 *
 * @package     h5pactivity
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['all_attempts'] = 'Todas as tentativas do utilizador';
$string['answer_checked'] = 'Resposta verificada';
$string['answer_correct'] = 'A sua resposta está correta';
$string['answer_fail'] = 'Resposta incorreta';
$string['answer_incorrect'] = 'A sua resposta está incorreta';
$string['answer_pass'] = 'Resposta correta';
$string['answer_text'] = 'Texto da resposta';
$string['answer_unchecked'] = 'Resposta não verificada';
$string['answer_unknown'] = 'Resposta desconhecida';
$string['areapackage'] = 'Pacote H5P';
$string['attempt'] = 'Tentativa';
$string['attempt_answer'] = 'Resposta da tentativa';
$string['attempt_average'] = 'Média de tentativas pontuadas';
$string['attempt_completion_no'] = 'Esta tentativa não está como concluída';
$string['attempt_completion_yes'] = 'Esta tentativa está concluída';
$string['attempt_first'] = 'Primeira tentativa';
$string['attempt_highest'] = 'Tentativa com maior pontuação';
$string['attempt_last'] = 'Última tentativa';
$string['attempt_none'] = 'Nenhuma tentativa é usada para avaliação';
$string['attempt_number'] = 'Tentativa #{$a}';
$string['attempt_success_fail'] = 'Reprovado';
$string['attempt_success_pass'] = 'Aprovado';
$string['attempt_success_unknown'] = 'Não reportado';
$string['attempts'] = 'Tentativas';
$string['attempts_none'] = 'Não existem tentativas deste utilizador para mostrar.';
$string['attempts_report'] = 'Relatório das tentativas';
$string['choice'] = 'Escolha';
$string['completion'] = 'Conclusão';
$string['contentbank'] = 'Mais informações sobre o banco de conteúdos';
$string['contentbank_help'] = 'No banco de conteúdos, pode criar e armazenar conteúdo usando várias ferramentas, o que inclui um criador integrado de pacotes H5P.';
$string['correct_answer'] = 'Resposta correta';
$string['deleteallattempts'] = 'Apagar todas as tentativas de H5P';
$string['displaycopyright'] = 'Botão Direitos de autor';
$string['displayembed'] = 'Botão Incorporar';
$string['displayexport'] = 'Permitir descarregar';
$string['dnduploadh5pactivity'] = 'Adicionar uma atividade H5P';
$string['duration'] = 'Duração';
$string['enabletracking'] = 'Ativar monitorização da tentativa';
$string['false'] = 'Falso';
$string['grade_average_attempt'] = 'Nota média';
$string['grade_first_attempt'] = 'Primeira tentativa';
$string['grade_grademethod'] = 'Método de avaliação';
$string['grade_grademethod_help'] = 'Ao usar a avaliação por pontos, estão disponíveis os seguintes métodos para calcular a nota final:

* Nota mais alta de todas as tentativas
* Nota média de todas as tentativas
* Primeira tentativa (todas as outras tentativas são ignoradas)
* Última tentativa (todas as outras tentativas são ignoradas)
* Não usar tentativas para avaliação (desativar o cálculo da avaliação)';
$string['grade_highest_attempt'] = 'Nota mais alta';
$string['grade_last_attempt'] = 'Última tentativa';
$string['grade_manual'] = 'Não calcular a média';
$string['h5pactivity:addinstance'] = 'Adicionar novo H5P';
$string['h5pactivity:reviewattempts'] = 'Rever as tentativas de H5P';
$string['h5pactivity:submit'] = 'Submeter tentativas de H5P';
$string['h5pactivity:view'] = 'Ver H5P';
$string['h5pactivityfieldset'] = 'Configurações H5P';
$string['h5pactivityname'] = 'H5P';
$string['h5pactivitysettings'] = 'Configurações';
$string['h5pattempts'] = 'Opções das tentativas';
$string['h5pdisplay'] = 'Opções do H5P';
$string['maxscore'] = 'Pontuação máxima';
$string['modulename'] = 'H5P';
$string['modulename_help'] = 'H5P é a abreviatura de HTML5 Package (Pacote HTML5) - conteúdo interativo, tais como apresentações, vídeos e outros recursos multimédia, perguntas, testes, jogos e muito mais. A atividade do H5P permite que o H5P seja carregado e adicionado a uma disciplina.

Qualquer tentativa de responder a perguntas é avaliada automaticamente e a nota é registada na pauta.';
$string['modulename_link'] = 'mod/h5pactivity/view';
$string['modulenameplural'] = 'H5P';
$string['myattempts'] = 'Minhas tentativas';
$string['no_compatible_track'] = 'Essa interação ({$a}) não fornece informações de monitorização ou a monitorização fornecida não é compatível com a versão atual da atividade.';
$string['noparticipants'] = 'Nenhum participante para mostrar';
$string['opencontentbank'] = '<a href="{$a}" target="_blank">Aceder ao ficheiro H5P no banco de conteúdos</a> (abre numa nova janela).';
$string['outcome'] = 'Resultado da aprendizagem';
$string['package'] = 'Pacote H5P';
$string['package_help'] = 'O pacote é um ficheiro H5P que contém conteúdo H5P dinâmico.';
$string['page-mod-h5pactivity-x'] = 'Qualquer página do módulo H5P';
$string['pluginadministration'] = 'Administração do H5P';
$string['pluginname'] = 'H5P';
$string['previewmode'] = 'Este conteúdo está a ser exibido no modo de visualização. Nenhuma monitorização da tentativa será armazenada.';
$string['privacy:metadata:attempt'] = 'O número da tentativa';
$string['privacy:metadata:rawscore'] = 'A pontuação obtida';
$string['privacy:metadata:timecreated'] = 'Data e hora em que o elemento monitorizado foi criado';
$string['privacy:metadata:timemodified'] = 'A última vez que o elemento foi monitorizado';
$string['privacy:metadata:userid'] = 'O ID do utilizador que acedeu à atividade H5P';
$string['privacy:metadata:xapi_track'] = 'Informação da monitorização da tentativa';
$string['privacy:metadata:xapi_track_results'] = 'Informação da monitorização dos resultados da tentativa';
$string['report_viewed'] = 'Relatório visualizado';
$string['result_compound'] = 'Pontuação parcial combinada';
$string['result_fill-in'] = 'Preencher espaços';
$string['result_fill-in_gap'] = 'Espaço #{$a}';
$string['result_matching'] = 'Escolha correspondente';
$string['result_other'] = 'Tipo de interação desconhecido';
$string['result_sequencing_answer'] = 'Valor da posição';
$string['result_sequencing_choice'] = 'Posições';
$string['result_sequencing_position'] = '#{$a}';
$string['review_all_attempts'] = 'Ver todas as tentativas ({$a} submetidas)';
$string['review_mode'] = 'Rever tentativas';
$string['review_my_attempts'] = 'Ver as minhas tentativas';
$string['review_none'] = 'Os participantes não podem rever as suas tentativas';
$string['review_on_completion'] = 'Os participantes podem rever as suas tentativas';
$string['review_user_attempts'] = 'Ver tentativas do utilizador ({$a})';
$string['score'] = 'Pontuação';
$string['score_out_of'] = '{$a->rawscore} em {$a->maxscore}';
$string['search:activity'] = 'H5P - informação da atividade';
$string['startdate'] = 'Data/hora de início';
$string['statement_received'] = 'Declaração xAPI recebida';
$string['totalscore'] = 'Pontuação total';
$string['tracking_messages'] = 'Alguns H5P fornecem dados da monitorização das tentativas para relatórios avançados, como por exemplo, número de tentativas, respostas e notas. Nota: Alguns H5P não fornecem dados da monitorização das tentativas. Nesses casos, as configurações abaixo não terão efeito.';
$string['true'] = 'Verdadeiro';
$string['usecontentbank'] = 'Usar o <a href="{$a}" target="_blank">banco de conteúdos</a> para gerir os seus ficheiros H5P (abre numa nova janela)';
$string['view'] = 'Visualizar';
$string['view_report'] = 'Ver relatório';
