<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'reservation', language 'cs', version '3.11'.
 *
 * @package     reservation
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addparticipant'] = 'Přidat požadavek';
$string['after10min'] = 'Po 10 minutách od zahájení akce';
$string['after12h'] = 'Po 12 hodinách od zahájení akce';
$string['after1d'] = 'Po 1 dni od zahájení akce';
$string['after1h'] = 'Po 1 hodině od zahájení akce';
$string['after1w'] = 'Po 1 týdnu od zahájení akce';
$string['after2d'] = 'Po 2 dnech od zahájení akce';
$string['after2h'] = 'Po 2 hodinách od zahájení akce';
$string['after2w'] = 'Po 2 týdnech od zahájení akce';
$string['after30min'] = 'Po 30 minutách od zahájení akce';
$string['after3w'] = 'Po 3 týdnech od zahájení akce';
$string['after4h'] = 'Po 4 hodinách od zahájení akce';
$string['after4w'] = 'Po 4 týdnech od zahájení akce';
$string['after5min'] = 'Po 5 minutách od zahájení akce';
$string['after6h'] = 'Po 6 hodinách od zahájení akce';
$string['alreadybooked'] = 'Již máte zarezervováno';
$string['alreadyoverbooked'] = 'Již jste v pořadníku';
$string['atstart'] = 'Na zahájení akce';
$string['autohide'] = 'Seznam rezervací se automaticky skryje';
$string['availablerequests'] = 'Dostupná místa';
$string['badcourse'] = 'Kurz neexistuje';
$string['badparent'] = 'Tato rezervace byla propojena s jinou rezervací, která nyní není obnovena. Spojení bylo odstraněno. V případě potřeby je znovu připojte ručně';
$string['badsection'] = 'Sekce se v kurzu "{$a}" není';
$string['badteachers'] = 'Zadaný e-mail učitele ({$a}) nebyl nalezen';
$string['badteachersmail'] = 'Zadaný e-mail učitele ({$a}) je falešný';
$string['badtimeclose'] = 'čas uzavření je falešný';
$string['badtimeend'] = 'čas je falešný';
$string['badtimeopen'] = 'čas otevření je falešný';
$string['badtimestart'] = 'čas začátku je falešný';
$string['by'] = 'podle';
$string['bydate'] = 'Datum konání';
$string['byname'] = 'Jméno';
$string['bysection'] = 'Téma/týden';
$string['cancelledon'] = 'Zrušeno';
$string['cancellersmail'] = 'Vaše rezervace "{$a->rezervace}" byla zrušena.';
$string['cancellersmailhtml'] = 'Vaše rezervace <em>{$a->rezervace}</em> byla zrušena.';
$string['checkclashes'] = 'Zkontrolovat kolize míst a času';
$string['clashesfound'] = 'Nalezeny kolize v místě nebo času';
$string['clashesreport'] = 'Přehled kolizí';
$string['cleanview'] = 'Zobrazit pouze aktuální rezervované';
$string['close'] = 'zavřít';
$string['closed'] = 'Zavřeno';
$string['completionreserved'] = 'Student musí provést rezervaci pro dokončení aktivity';
$string['config'] = 'Nastavení rezervace';
$string['configautohide'] = 'Toto definuje, kdy musí být rezervace skryty ze seznamu rezervací (mod/reservation/index.php). To by mohlo být užitečné při použití s veřejnými seznamy, aby se zobrazil čistý seznam.';
$string['configcheckclashes'] = 'Povolit kontrolu kolizí míst a času v editaci rezervace';
$string['configconnectto'] = 'Definujte, kde modul vyhledá rezervace, ke kterým se má připojit';
$string['configdownload'] = 'Definuje to výchozí formát souboru ke stažení pro všechny seznamy požadavků a rezervací.';
$string['configevents'] = 'Toto nastavení definuje, které události budou vytvořeny pro každou rezervaci';
$string['configfields'] = 'Toto nastavení definuje, která pole se zobrazí v tabulce rezervací';
$string['configlocations'] = 'Spravovat výchozí místa rezervací na těchto stránkách';
$string['configmanualusers'] = 'Toto definuje, jaký seznam uživatelů se zobrazí v rozbalovací nabídce používané k ruční rezervaci uživatelů.';
$string['configmaxoverbook'] = 'Toto definuje maximální procento nadměrné rezervace u rezervací.';
$string['configmaxrequests'] = 'Definujte limit rozevírací nabídky na stránce úprav rezervace';
$string['configminduration'] = 'Označuje minimální trvání události rezervace. Používá se u nekonečných událostí ke kontrole dostupnosti místa a času';
$string['confignotifies'] = 'Toto nastavení určuje, která upozornění musí být odeslána';
$string['configoverbookstep'] = 'Toto definuje procentuální granularitu nadměrné rezervace. Menší krok, větší granularita';
$string['configpubliclists'] = 'Toto definuje, zda jsou seznamy rezervací veřejné (zobrazené bez přihlášení) nebo ne.';
$string['configsortby'] = 'Určuje způsob řazení rezervací';
$string['configsublimits'] = 'Na stránce úprav rezervace definujte počet řádků pravidel podlimitů';
$string['configupload'] = 'Vytvořit rezervace nahráním textového souboru';
$string['confirmdelete'] = 'Opravdu chcete smazat vybrané požadavky na rezervaci?';
$string['connectedto'] = 'Rezervace připojena k';
$string['connectto'] = 'Připojená rezervace od';
$string['crontask'] = 'Odesílejte e-maily s rezervacemi a žádostmi o hodnocení';
$string['description'] = 'Popis';
$string['downloadas'] = 'Výchozí formát pro stažení';
$string['duration10h'] = '10 hodin';
$string['duration10min'] = '10 minut';
$string['duration11h'] = '11 hodin';
$string['duration12h'] = '12 hodin';
$string['duration15min'] = '15 minut';
$string['duration20min'] = '20 minut';
$string['duration2h'] = '2 hodiny';
$string['duration30min'] = '30 minut';
$string['duration3h'] = '3 hodiny';
$string['duration45min'] = '45 minut';
$string['duration4h'] = '4 hodiny';
$string['duration5h'] = '5 hodin';
$string['duration5min'] = '5 minut';
$string['duration60min'] = '60 minut';
$string['duration6h'] = '6 hodin';
$string['duration7h'] = '7 hodin';
$string['duration8h'] = '8 hodin';
$string['duration90min'] = '90 minut';
$string['duration9h'] = '9 hodin';
$string['enablenote'] = 'Povolit uživateli poznámku';
$string['equal'] = 'rovná se';
$string['err_notimestart'] = 'Datum zahájení akce není nastaven';
$string['err_sublimitsgreater'] = 'Součet sublimitů je větší než maximální povolený požadavek';
$string['err_timeendlower'] = 'Datum ukončení akce předchází datum zahájení';
$string['err_timeopengreater'] = 'Datum zahájení rezervace je nastaveno po datu ukončení';
$string['eventevent'] = 'Vytvořit událost kurzu dle začátku a konce akce';
$string['eventreminder'] = '{$a} (rezervováno)';
$string['eventrequestadded'] = 'Přidána žádost o rezervaci';
$string['eventrequestcancelled'] = 'Žádost o rezervaci zrušena';
$string['eventrequestdeleted'] = 'Žádost o rezervaci odstraněna';
$string['events'] = 'Události kalendáře';
$string['eventsettings'] = 'Nastavení události';
$string['explainconfig'] = 'Správci zde mohou definovat globální nastavení modulu Rezervace';
$string['fields'] = 'Zobrazená pole';
$string['fullview'] = 'Zobrazit také odstraněné rezervace';
$string['gradedmail'] = '{$a->teacher} zveřejnil(a) zpětnou vazbu k vaší
rezervaci \'{$a->reservation}\'

Můžete ji vidět zde:

    {$a->url}';
$string['gradedmailhtml'] = '{$a->teacher} zveřejnil(a) zpětnou vazbu k vaší
rezervaci \'<i>{$a->reservation}</i>\'<br /><br />
Můžete ji vidět <a href=\\"{$a->url}\\">here</a>.';
$string['importreservations'] = 'Importovat rezervace';
$string['invalidreservationid'] = 'Neplatné ID rezervace';
$string['justbooked'] = 'Jste rezervováni jako: {$a}';
$string['justoverbooked'] = 'Máte nadměrnou rezervaci jako: {$a}';
$string['linenumber'] = '#';
$string['listafterclose'] = 'seznam žádostí o rezervaci po ukončení zápisu';
$string['listalways'] = 'seznam žádostí o rezervaci kdykoliv';
$string['location'] = 'Místo';
$string['locations'] = 'Správa míst';
$string['locationslist'] = 'Seznam míst';
$string['mail'] = 'Zápis na rezervaci \'{$a->reservation}\' byl ukončen.

Seznam rezervací si můžete stáhnout z:

    {$a->url}';
$string['mailhtml'] = 'Zápis na rezervaci <em>{$a->reservation}</em>byl ukončen.<br /><br />
Můžete si stáhnout seznam zápisů <a href="{$a->url}">zde</a>.';
$string['mailrequest'] = 'Rezervace "{$a->reservation}" byla uzavřena.

Rezervační číslo můžete získat na:

{$a->url}';
$string['mailrequesthtml'] = 'Rezervace <em>{$a->rezervace}</em> byla uzavřena.<br /><br /> Číslo rezervace získáte <a href="{$a->url}">zde</a>.';
$string['manage'] = 'Spravovat';
$string['manualusers'] = 'Manuální rezervu zobrazit uživatelům';
$string['maxoverbook'] = 'Maximální procento nadměrné rezervace';
$string['maxrequest'] = 'Max. počet rezervací';
$string['message'] = 'Zpráva účastníkům';
$string['minduration'] = 'Minimální doba trvání akce';
$string['modulename'] = 'Rezervace';
$string['modulename_help'] = '<p>Hlavním cílem této aktivity je naplánovat laboratorní cvičení a zkoušky, ale můžete si naplánovat vše, co chcete.</p><p>Učitel může definovat počet míst k dispozici pro událost, datum akce, datum otevření a uzavření rezervace .<br />Rezervace může mít známku nebo  škálu.<br />Studenti si mohou rezervovat a zrušit rezervaci místa a přidat poznámku o této rezervaci.</p><p>Po zahájení akce může učitel ohodnotit událost. Studenti budou informováni e-mailem.</p><p>Seznam rezervací lze stáhnout v různých formátech.</p>';
$string['modulenameplural'] = 'Rezervace';
$string['newlocation'] = 'Nové místo';
$string['noclashcheck'] = 'Není povolena kontrola kolizí míst a času. Prosím, kontaktujte administrátora stránek.';
$string['noclashes'] = 'Nebyly nalezeny žádné kolize míst a času.';
$string['nocourseswithnsections'] = 'Nebyl nalezen žádný kurz s {$a} sekcemi';
$string['nolimit'] = 'Žádný limit rezervace';
$string['nomorerequest'] = 'Byla vyčerpána kapacita této rezervace';
$string['none'] = 'žádné informace o objednávce rezervace';
$string['nooverbook'] = '';
$string['noparent'] = 'Žádný';
$string['noreservations'] = 'Žádná rezervace k zobrazení';
$string['note'] = 'Poznámka';
$string['noteachers'] = 'Žádní dostupní učitelé';
$string['notequal'] = 'nerovná se';
$string['noterequired'] = '';
$string['notgraded'] = 'Bez známky';
$string['notifies'] = 'Upozornění odeslána';
$string['notifycancellers'] = 'Upozornit rušitele, když provedou úspěšné zrušení rezervace';
$string['notifygrades'] = 'Upozornit studenty o hodnocení rezervace';
$string['notifyoverbookers'] = 'Upozornit studenty, kteří přerezervovali, když se stali pravidelnými rezervujícími';
$string['notifyreservers'] = 'Upozornit rezervující, když podají úspěšnou žádost o rezervaci';
$string['notifystudents'] = 'Upozornit studenty o uzavření rezervace';
$string['notifyteachers'] = 'Upozornit učitele na uzavření rezervace';
$string['notopened'] = 'Není otevřeno';
$string['notreserved'] = 'Není rezervováno';
$string['novalues'] = 'Pro toto pole nejsou k dispozici žádné hodnoty';
$string['number'] = 'Číslo rezervace';
$string['numberafterclose'] = 'jejich číslo požadavku na rezervaci po uzavření rezervace';
$string['numberalways'] = 'číslo jejich žádosti o rezervaci';
$string['optional'] = 'Volitelný';
$string['otherlocation'] = 'Zadat jiné umístění';
$string['overbook'] = 'Nadměrná rezervace';
$string['overbookonly'] = 'K dispozici pouze nadměrná rezervace míst';
$string['overbookstep'] = 'Krok nadměrné rezervace';
$string['overview'] = 'Přehled';
$string['parent'] = 'Propojit tuto rezervaci s';
$string['pluginadministration'] = 'Správa rezervací';
$string['pluginname'] = 'Rezervace';
$string['privacy:metadata:reservation_note'] = 'Uložit poznámku uživatele o požadavku na rezervaci';
$string['privacy:metadata:reservation_note:note'] = 'Poznámka uživatele k požadavku na rezervaci';
$string['privacy:metadata:reservation_request'] = 'Uložit uživatelská data požadavku na rezervaci';
$string['privacy:metadata:reservation_request:grade'] = 'Hodnocení žádosti o rezervaci uživatele';
$string['privacy:metadata:reservation_request:grader'] = 'ID hodnotitele';
$string['privacy:metadata:reservation_request:mailed'] = 'Stav zaslaného oznámení o hodnocení';
$string['privacy:metadata:reservation_request:reservationid'] = 'ID rezervace';
$string['privacy:metadata:reservation_request:timecancelled'] = 'Datum a čas zrušení žádosti';
$string['privacy:metadata:reservation_request:timecreated'] = 'Datum a čas vytvoření požadavku';
$string['privacy:metadata:reservation_request:timegraded'] = 'Datum a čas klasifikace požadavku';
$string['privacy:metadata:reservation_request:userid'] = 'ID uživatele';
$string['publiclists'] = 'Veřejný seznam rezervací';
$string['requestoverview'] = 'Přehled požadavků';
$string['requests'] = 'Požadavky';
$string['required'] = 'Vyžadováno';
$string['reservation:addinstance'] = 'Přidat novou rezervaci';
$string['reservation:downloadrequests'] = 'Lze stáhnout seznam požadavků';
$string['reservation:grade'] = 'Může přiřadit známku';
$string['reservation:manage'] = 'Může spravovat rezervaci';
$string['reservation:manualdelete'] = 'Může mazat požadavky ostatních uživatelů';
$string['reservation:manualreserve'] = 'Může odeslat požadavek pro ostatní uživatele';
$string['reservation:reserve'] = 'Může podávat vlastní žádosti';
$string['reservation:uploadreservations'] = 'Může nahrávat rezervace';
$string['reservation:view'] = 'Může zobrazit rezervaci';
$string['reservation:viewnote'] = 'Může zobrazit poznámku s požadavky';
$string['reservation:viewrequest'] = 'Může zobrazit seznam požadavků';
$string['reservation_listing'] = 'Nastavení stránky indexu';
$string['reservation_other'] = 'Další nastavení';
$string['reservation_settings'] = 'Úprava nastavení';
$string['reservation_view'] = 'Zobrazit nastavení stránky';
$string['reservationcancelled'] = 'Rezervace zrušena';
$string['reservationclosed'] = 'Rezervace uzavřena';
$string['reservationdenied'] = 'Rezervace není povolena';
$string['reservationevent'] = 'Vytvořit událost kurzu od otevřených do uzavřených dat (čas rezervace)';
$string['reservationnotopened'] = 'Rezervace dosud nebyla otevřena';
$string['reservations'] = 'Rezervace';
$string['reservationsettings'] = 'Nastavení rezervace';
$string['reserve'] = 'Rezervovat';
$string['reservecancel'] = 'Zrušit rezervaci';
$string['reserved'] = 'Rezervováno';
$string['reservedon'] = 'Rezervováno dne';
$string['reservedonconnected'] = 'Již jste rezervováni pro připojenou rezervaci: {$a}';
$string['reserversmail'] = 'Jste vyhrazeni pro \'{$a->reservation}\' rezervaci.';
$string['reserversmailhtml'] = 'Jste vyhrazeni pro <em>{$a->reservation}</em> rezervace.';
$string['resetreservation'] = 'Odeberte všechny rezervace';
$string['save'] = 'Uložit známku';
$string['search:activity'] = 'Rezervace - informace o činnosti';
$string['selectvalue'] = 'Vyberte jednu z dostupných hodnot';
$string['showrequest'] = 'Uživatelé mohou zobrazit seznam požadavků';
$string['showuserrequest'] = 'Uživatelé mohou prohlížet';
$string['sortby'] = 'Seznamy rezervací seřazené podle';
$string['status'] = 'Stav rezervace';
$string['sublimit'] = 'Částečný limit {$a}';
$string['sublimitrules'] = 'Pravidla pro částečný limity';
$string['sublimits'] = 'Částečný limit rezervace';
$string['timeclose'] = 'Ukončení zápisu';
$string['timeend'] = 'Ukončení akce';
$string['timeopen'] = 'Zahájení zápisu';
$string['timestart'] = 'Zahájení akce';
$string['tools'] = 'Nástroje rezervace';
$string['upload'] = 'Nahrání rezervace';
$string['upload_help'] = '<p>Rezervace lze nahrát prostřednictvím textového souboru. Formát souboru by měl být následující:</p><ul><li>Každý řádek souboru obsahuje jeden záznam</li><li>Každý záznam je řada dat oddělených čárkami (nebo jinými oddělovači) </li><li>První záznam obsahuje seznam názvů polí definujících formát zbytku souboru</li><li>Povinné názvy polí jsou sekce, název a časový začátek</li><li>Volitelné názvy polí jsou kurz , intro, teacher, timeend, grade, timeopen, timeclose, maxrequest</li><li>Pokud kurz není specifikován, musí být vybrán po náhledu</li></ul>';
$string['uploadreservations'] = 'Nahrát rezervace';
$string['uploadreservationspreview'] = 'Náhled nahrání rezervací';
$string['uploadreservationsresult'] = 'Výsledek nahrání rezervací';
$string['useralreadybooked'] = 'Uživatel již provedl zápis na rezervaci';
$string['userevent'] = 'Vytvořit uživatelskou událost od počátečního do koncového data při rezervaci uživatele v rezervaci';
$string['with'] = 's';
$string['withselected'] = 'S vybranými...';
$string['yourgrade'] = 'Vaše hodnocení této rezervace je: {$a->grade}/{$a->maxgrade}';
$string['yournote'] = 'Vaše poznámka:';
$string['yourscale'] = 'Vaše hodnocení této rezervace je: {$a}';
