<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'nl', version '3.11'.
 *
 * @package     editor_tinymce
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = 'Adres';
$string['advanced:anchor_delta_height'] = '';
$string['advanced:anchor_delta_width'] = '';
$string['advanced:anchor_desc'] = 'Anker invoegen/bewerken';
$string['advanced:backcolor_desc'] = 'Tekstmarkeringskleur';
$string['advanced:block'] = 'Opmaak';
$string['advanced:blockquote'] = 'Citaat';
$string['advanced:blockquote_desc'] = 'Citaat';
$string['advanced:bold_desc'] = 'Vet (Ctrl+B)';
$string['advanced:bullist_desc'] = 'Opsommingstekens invoege/verwijderen';
$string['advanced:charmap_delta_height'] = '';
$string['advanced:charmap_delta_width'] = '';
$string['advanced:charmap_desc'] = 'Symbool invoegen';
$string['advanced:cleanup_desc'] = 'Code opruimen';
$string['advanced:clipboard_msg'] = 'Kopiëren/knippen/plakken is niet beschikbaar in Mozilla en Firefox.
Wilt u meer informatie over deze beperking?';
$string['advanced:code'] = 'Code';
$string['advanced:code_desc'] = 'HTML bron bewerken';
$string['advanced:colorpicker_delta_height'] = '';
$string['advanced:colorpicker_delta_width'] = '';
$string['advanced:copy_desc'] = 'Kopiëren';
$string['advanced:custom1_desc'] = 'Uw eigen beschrijving hier';
$string['advanced:cut_desc'] = 'Knippen';
$string['advanced:dd'] = 'Definitiebeschrijving';
$string['advanced:div'] = 'DIV';
$string['advanced:dt'] = 'Definitieterm';
$string['advanced:font_size'] = 'Tekengrootte';
$string['advanced:fontdefault'] = 'Lettertype';
$string['advanced:forecolor_desc'] = 'Tekstkleur';
$string['advanced:h1'] = 'Kop 1';
$string['advanced:h2'] = 'Kop 2';
$string['advanced:h3'] = 'Kop 3';
$string['advanced:h4'] = 'Kop 4';
$string['advanced:h5'] = 'Kop 5';
$string['advanced:h6'] = 'Kop 6';
$string['advanced:help_desc'] = 'Help';
$string['advanced:help_shortcut'] = 'Klik op ALT-F10 voor de werkbalk. Klik op ALT-0 voor hulp';
$string['advanced:hr_desc'] = 'Horizontale lijn invoegen';
$string['advanced:image_delta_height'] = '';
$string['advanced:image_delta_width'] = '';
$string['advanced:image_desc'] = 'Afbeelding invoegen/bewerken';
$string['advanced:image_props_desc'] = 'Afbeeldingseigenschappen';
$string['advanced:indent_desc'] = 'Inspringing vergroten';
$string['advanced:italic_desc'] = 'Cursief (Ctrl+I)';
$string['advanced:justifycenter_desc'] = 'Centreren';
$string['advanced:justifyfull_desc'] = 'Uitvullen';
$string['advanced:justifyleft_desc'] = 'Links uitlijnen';
$string['advanced:justifyright_desc'] = 'Rechts uitlijnen';
$string['advanced:link_delta_height'] = '';
$string['advanced:link_delta_width'] = '';
$string['advanced:link_desc'] = 'Link invoegen/bewerken';
$string['advanced:more_colors'] = 'Meer kleuren...';
$string['advanced:newdocument'] = 'Weet u zeker dat u alle inhoud wilt wissen?';
$string['advanced:newdocument_desc'] = 'Nieuw document';
$string['advanced:numlist_desc'] = 'Nummering invoegen/verwijderen';
$string['advanced:outdent_desc'] = 'Inspringing verkleinen';
$string['advanced:paragraph'] = 'Alinea';
$string['advanced:paste_desc'] = 'Plakken';
$string['advanced:path'] = 'Pad';
$string['advanced:pre'] = 'Vaste opmaak';
$string['advanced:redo_desc'] = 'Herhalen (Ctrl+Y)';
$string['advanced:removeformat_desc'] = 'Opmaak verwijderen';
$string['advanced:rich_text_area'] = 'Zone voor teksteditor';
$string['advanced:samp'] = 'Codevoorbeeld';
$string['advanced:shortcuts_desc'] = 'Hulp  bij toegankelijkheid';
$string['advanced:striketrough_desc'] = 'Doorhalen';
$string['advanced:style_select'] = 'Stijlen';
$string['advanced:sub_desc'] = 'Subscript';
$string['advanced:sup_desc'] = 'Superscript';
$string['advanced:toolbar'] = 'Werkbalk';
$string['advanced:toolbar_focus'] = 'Spring naar werkbalk - Alt+Q, Spring naar editor - Alt-Z, Spring naar elementpad - Alt-X';
$string['advanced:underline_desc'] = 'Onderstrepen (Ctrl+U)';
$string['advanced:undo_desc'] = 'Ongedaan maken (Ctrl+Z)';
$string['advanced:unlink_desc'] = 'Link verwijderen';
$string['advanced:visualaid_desc'] = 'Hulplijnen weergeven/verbergen';
$string['advanced_dlg:'] = '';
$string['advanced_dlg:about_author'] = 'Auteur';
$string['advanced_dlg:about_general'] = 'Info';
$string['advanced_dlg:about_help'] = 'Help';
$string['advanced_dlg:about_license'] = 'Licentie';
$string['advanced_dlg:about_loaded'] = 'Geladen Invoegtoepassingen';
$string['advanced_dlg:about_plugin'] = 'Invoegtoepassing';
$string['advanced_dlg:about_plugins'] = 'Invoegtoepassingen';
$string['advanced_dlg:about_title'] = 'Over TinyMCE';
$string['advanced_dlg:about_version'] = 'Versie';
$string['advanced_dlg:accessibility_help'] = 'Hulp toegangkelijkheid';
$string['advanced_dlg:accessibility_usage_title'] = 'Algemeen gebruik';
$string['advanced_dlg:anchor_invalid'] = 'Geef een geldige ankernaam';
$string['advanced_dlg:anchor_name'] = 'Ankernaam';
$string['advanced_dlg:anchor_title'] = 'Anker invoegen/bewerken';
$string['advanced_dlg:charmap_title'] = 'Symbool selecteren';
$string['advanced_dlg:charmap_usage'] = 'Gebruik links- en rechtspijltjes om te navigeren.';
$string['advanced_dlg:code_title'] = 'HTML bron bewerken';
$string['advanced_dlg:code_wordwrap'] = 'Automatische terugloop';
$string['advanced_dlg:colorpicker_color'] = 'Kleur:';
$string['advanced_dlg:colorpicker_name'] = 'Naam:';
$string['advanced_dlg:colorpicker_named_tab'] = 'Benoemd';
$string['advanced_dlg:colorpicker_named_title'] = 'Benoemde kleuren';
$string['advanced_dlg:colorpicker_palette_tab'] = 'Palet';
$string['advanced_dlg:colorpicker_palette_title'] = 'Paletkleuren';
$string['advanced_dlg:colorpicker_picker_tab'] = 'Alle kleuren';
$string['advanced_dlg:colorpicker_picker_title'] = 'Alle kleuren';
$string['advanced_dlg:colorpicker_title'] = 'Kleuren';
$string['advanced_dlg:image_align'] = 'Uitlijning';
$string['advanced_dlg:image_align_baseline'] = 'Basislijn';
$string['advanced_dlg:image_align_bottom'] = 'Onder';
$string['advanced_dlg:image_align_left'] = 'Links';
$string['advanced_dlg:image_align_middle'] = 'Midden';
$string['advanced_dlg:image_align_right'] = 'Rechts';
$string['advanced_dlg:image_align_textbottom'] = 'Onderkant tekst';
$string['advanced_dlg:image_align_texttop'] = 'Bovenkant tekst';
$string['advanced_dlg:image_align_top'] = 'Boven';
$string['advanced_dlg:image_alt'] = 'Beschrijving';
$string['advanced_dlg:image_border'] = 'Rand';
$string['advanced_dlg:image_dimensions'] = 'Afmetingen';
$string['advanced_dlg:image_hspace'] = 'Horizontale ruimte';
$string['advanced_dlg:image_list'] = 'Lijst';
$string['advanced_dlg:image_src'] = 'Bestand/URL';
$string['advanced_dlg:image_title'] = 'Afbeelding invoegen/bewerken';
$string['advanced_dlg:image_vspace'] = 'Verticale ruimte';
$string['advanced_dlg:invalid_color_value'] = 'Ongeldige kleurwaarde';
$string['advanced_dlg:link_is_email'] = 'De ingevoerde URL lijkt op een e-mailadres. Wilt u de vereiste mailto: tekst voorvoegen?';
$string['advanced_dlg:link_is_external'] = 'De ingevoerde URL lijkt op een externe link. Wilt u de vereiste http:// tekst voorvoegen?';
$string['advanced_dlg:link_list'] = 'Link lijst';
$string['advanced_dlg:link_target'] = 'Doel';
$string['advanced_dlg:link_target_blank'] = 'Link in een nieuw venster openen';
$string['advanced_dlg:link_target_same'] = 'Link in hetzelfde venster openen';
$string['advanced_dlg:link_title'] = 'Link invoegen/bewerken';
$string['advanced_dlg:link_titlefield'] = 'Titel';
$string['advanced_dlg:link_url'] = 'URL';
$string['advhr:advhr_desc'] = 'Voeg horizontale lijn in';
$string['advhr:delta_height'] = '';
$string['advhr:delta_width'] = '';
$string['advhr_dlg:normal'] = 'Normaal';
$string['advhr_dlg:noshade'] = 'Geen schaduw';
$string['advhr_dlg:size'] = 'Hoogte';
$string['advhr_dlg:width'] = 'Breedte';
$string['advhr_dlg:widthunits'] = 'Eenheden';
$string['advimage:delta_height'] = '';
$string['advimage:delta_width'] = '';
$string['advimage:image_desc'] = 'Afbeelding invoegen/bewerken';
$string['advimage_dlg:align'] = 'Uitlijning';
$string['advimage_dlg:align_baseline'] = 'Basislijn';
$string['advimage_dlg:align_bottom'] = 'Onder';
$string['advimage_dlg:align_left'] = 'Links';
$string['advimage_dlg:align_middle'] = 'Midden';
$string['advimage_dlg:align_right'] = 'Rechts';
$string['advimage_dlg:align_textbottom'] = 'Onderkant tekst';
$string['advimage_dlg:align_texttop'] = 'Bovenkant tekst';
$string['advimage_dlg:align_top'] = 'Boven';
$string['advimage_dlg:alt'] = 'Beschrijving';
$string['advimage_dlg:alt_image'] = 'Alternatieve afbeeldingen';
$string['advimage_dlg:border'] = 'Rand';
$string['advimage_dlg:classes'] = 'Klasses';
$string['advimage_dlg:constrain_proportions'] = 'Verhouding behouden';
$string['advimage_dlg:dialog_title'] = 'Afbeelding invoegen/bewerken';
$string['advimage_dlg:dimensions'] = 'Afmetingen';
$string['advimage_dlg:example_img'] = 'Voorbeeldweergave';
$string['advimage_dlg:general'] = 'Algemeen';
$string['advimage_dlg:height'] = 'Hoogte';
$string['advimage_dlg:hspace'] = 'Horizontale ruimte';
$string['advimage_dlg:id'] = 'ID';
$string['advimage_dlg:image_list'] = 'Lijst';
$string['advimage_dlg:langcode'] = 'Taalcode';
$string['advimage_dlg:langdir'] = 'Taalrichting';
$string['advimage_dlg:list'] = 'Lijst';
$string['advimage_dlg:long_desc'] = 'Uitgebreide beschrijving';
$string['advimage_dlg:ltr'] = 'Van links naar rechts';
$string['advimage_dlg:map'] = 'Afbeeldingsplattegrond';
$string['advimage_dlg:misc'] = 'Diversen';
$string['advimage_dlg:missing_alt'] = 'Wilt u de afbeelding zonder beschrijving invoegen? De afbeelding wordt dan mogelijk niet opgemerkt door mensen met een visuele handicap, of welke zonder afbeeldingen browsen.';
$string['advimage_dlg:mouseout'] = 'Bij muis uit';
$string['advimage_dlg:mouseover'] = 'Bij muis over';
$string['advimage_dlg:preview'] = 'Voorbeeld';
$string['advimage_dlg:rtl'] = 'Van rechts naar links';
$string['advimage_dlg:src'] = 'Bestand/URL';
$string['advimage_dlg:style'] = 'Stijl';
$string['advimage_dlg:swap_image'] = 'Afbeelding wisselen';
$string['advimage_dlg:tab_advanced'] = 'Geavanceerd';
$string['advimage_dlg:tab_appearance'] = 'Weergave';
$string['advimage_dlg:tab_general'] = 'Algemeen';
$string['advimage_dlg:title'] = 'Titel';
$string['advimage_dlg:vspace'] = 'Verticale ruimte';
$string['advimage_dlg:width'] = 'Breedte';
$string['advlink:delta_height'] = '';
$string['advlink:delta_width'] = '';
$string['advlink:link_desc'] = 'Link invoegen/bewerken';
$string['advlink_dlg:accesskey'] = 'Toegangstoets';
$string['advlink_dlg:advanced_props'] = 'Geavanceerde eigenschappen';
$string['advlink_dlg:advanced_tab'] = 'Geavanceerd';
$string['advlink_dlg:anchor_names'] = 'Ankers';
$string['advlink_dlg:classes'] = 'Klassen';
$string['advlink_dlg:encoding'] = 'Taalcodering';
$string['advlink_dlg:event_props'] = 'Gebeurtenissen';
$string['advlink_dlg:events_tab'] = 'Gebeurtenissen';
$string['advlink_dlg:general_props'] = 'Algemene eigenschappen';
$string['advlink_dlg:general_tab'] = 'Algemeen';
$string['advlink_dlg:height'] = 'Hoogte';
$string['advlink_dlg:id'] = 'ID';
$string['advlink_dlg:is_email'] = 'De ingevoerde URL lijkt op een e-mailadres. Wil je het vereiste mailto: invoegen?';
$string['advlink_dlg:is_external'] = 'De ingevoerde URL lijkt op een externe link. Wil je het vereiste http:// invoegen?';
$string['advlink_dlg:langcode'] = 'Taalcode';
$string['advlink_dlg:langdir'] = 'Taalrichting';
$string['advlink_dlg:link_list'] = 'Lijst';
$string['advlink_dlg:list'] = 'Lijst';
$string['advlink_dlg:ltr'] = 'Van links naar rechts';
$string['advlink_dlg:mime'] = 'MIME type';
$string['advlink_dlg:popup'] = 'JavaScript pop-up';
$string['advlink_dlg:popup_dependent'] = 'Afhankelijk (Alleen Mozilla/Firefox)';
$string['advlink_dlg:popup_location'] = 'Lokatiebalk weergeven';
$string['advlink_dlg:popup_menubar'] = 'Menubalk weergeven';
$string['advlink_dlg:popup_name'] = 'Venstertitel';
$string['advlink_dlg:popup_opts'] = 'Opties';
$string['advlink_dlg:popup_position'] = 'Positie (X/Y)';
$string['advlink_dlg:popup_props'] = 'Pop-upeigenschappen';
$string['advlink_dlg:popup_resizable'] = 'Aanpasbaar venster';
$string['advlink_dlg:popup_return'] = '\'return false\' invoegen';
$string['advlink_dlg:popup_scrollbars'] = 'Scrollbalken weergeven';
$string['advlink_dlg:popup_size'] = 'Grootte';
$string['advlink_dlg:popup_statusbar'] = 'Statusbalk weergeven';
$string['advlink_dlg:popup_tab'] = 'Pop-up';
$string['advlink_dlg:popup_toolbar'] = 'Werkbalk weergeven';
$string['advlink_dlg:popup_url'] = 'Pop-up-URL';
$string['advlink_dlg:rel'] = 'Relatie van pagina tot doel';
$string['advlink_dlg:rev'] = 'Relatie van doel tot pagina';
$string['advlink_dlg:rtl'] = 'Van rechts naar links';
$string['advlink_dlg:style'] = 'Stijl';
$string['advlink_dlg:tabindex'] = 'Tabvolgorde';
$string['advlink_dlg:target'] = 'Doel';
$string['advlink_dlg:target_blank'] = 'In nieuw venster openen';
$string['advlink_dlg:target_langcode'] = 'Taal';
$string['advlink_dlg:target_name'] = 'Doel';
$string['advlink_dlg:target_parent'] = 'Open in bovenliggend venster / frame';
$string['advlink_dlg:target_same'] = 'Open in dit venster / frame';
$string['advlink_dlg:target_top'] = 'In bovenste frame openen (vervangt gehele pagina)';
$string['advlink_dlg:title'] = 'Link invoegen/bewerken';
$string['advlink_dlg:titlefield'] = 'Titel';
$string['advlink_dlg:url'] = 'URL';
$string['advlink_dlg:width'] = 'Breedte';
$string['advlist:circle'] = 'Cirkel';
$string['advlist:def'] = 'Standaard';
$string['advlist:disc'] = 'Schijf';
$string['advlist:lower_alpha'] = 'Alfa (klein)';
$string['advlist:lower_greek'] = 'Griekse letters (klein)';
$string['advlist:lower_roman'] = 'Romeinse letters (klein)';
$string['advlist:square'] = 'Vierkant';
$string['advlist:types'] = 'Types';
$string['advlist:upper_alpha'] = 'Alfa (groot)';
$string['advlist:upper_roman'] = 'Romeinse letters (groot)';
$string['aria:rich_text_area'] = 'Zone voor opgemaakte tekst';
$string['autosave:restore_content'] = 'Automatisch opgeslagen inhoud laden';
$string['autosave:unload_msg'] = 'De wijzigingen zullen verloren gaan als u nu deze pagina verlaat.';
$string['autosave:warning_message'] = 'Als u de opgeslagen inhoud laadt, verliest u de inhoud die zich momenteel in de editor bevindt.

Weet u zeker dat u de opgeslagen inhoud wilt laden?';
$string['availablebuttons'] = 'Beschikbare knoppen';
$string['colors:000000'] = 'Zwart';
$string['colors:000080'] = 'Marineblauw';
$string['colors:0000FF'] = 'Blauw';
$string['colors:003300'] = 'Donkergroen';
$string['colors:003366'] = 'Donkerultramarijn';
$string['colors:008000'] = 'Groen';
$string['colors:008080'] = 'Teal';
$string['colors:00CCFF'] = 'Hemelsblauw';
$string['colors:00FF00'] = 'Limoen';
$string['colors:00FFFF'] = 'Cyaan';
$string['colors:333300'] = 'Donkerolijfgroen';
$string['colors:333333'] = 'Donkergrijs';
$string['colors:333399'] = 'Indigo';
$string['colors:3366FF'] = 'Koningsblauw';
$string['colors:339966'] = 'Zeegroen';
$string['colors:33CCCC'] = 'Turkoois';
$string['colors:666699'] = 'Grijsblauw';
$string['colors:800000'] = 'Kastanjebruin';
$string['colors:800080'] = 'Paars';
$string['colors:808000'] = 'Olijfgroen';
$string['colors:808080'] = 'Grijs';
$string['colors:993300'] = 'Burntoranje';
$string['colors:993366'] = 'Bruin';
$string['colors:999999'] = 'Middengrijs';
$string['colors:99CC00'] = 'Geelgroen';
$string['colors:99CCFF'] = 'Lichthemelsblauw';
$string['colors:C0C0C0'] = 'Zilver';
$string['colors:CC99FF'] = 'Pruim';
$string['colors:CCFFCC'] = 'Lichtgrijs';
$string['colors:CCFFFF'] = 'Lichtcyaan';
$string['colors:FF0000'] = 'Rood';
$string['colors:FF00FF'] = 'Magenta';
$string['colors:FF6600'] = 'Oranje';
$string['colors:FF9900'] = 'Amber';
$string['colors:FF99CC'] = 'Roze';
$string['colors:FFCC00'] = 'Goud';
$string['colors:FFCC99'] = 'Perzik';
$string['colors:FFFF00'] = 'Geel';
$string['colors:FFFF99'] = 'Lichtgeel';
$string['colors:FFFFFF'] = 'Wit';
$string['common:apply'] = 'Toepassen';
$string['common:browse'] = 'Bladeren';
$string['common:cancel'] = 'Annuleren';
$string['common:class_name'] = 'Klasse';
$string['common:clipboard_msg'] = 'Kopiëren/knippen/plakken is niet beschikbaar in Mozilla en Firefox.
Wilt u meer informatie over deze beperking?';
$string['common:clipboard_no_support'] = 'Kopiëren/knippen/plakken wordt niet ondersteund door uw browser, gebruik hiervoor de sneltoetsen.';
$string['common:close'] = 'Sluiten';
$string['common:edit_confirm'] = 'Weet u zeker dat u tekst in WYSIWYG mode wilt bewerken in dit tekstveld?';
$string['common:insert'] = 'Invoegen';
$string['common:invalid_data'] = 'Fout: Er zijn ongeldige waardes ingevoerd, deze zijn rood gemarkeerd.';
$string['common:invalid_data_min'] = '{# Field} moet een getal groter dan {# min}';
$string['common:invalid_data_number'] = '{# Field} moet een getal zijn';
$string['common:invalid_data_size'] = '{# Field} moet een percentage zijn';
$string['common:more_colors'] = 'Meer kleuren...';
$string['common:not_set'] = '- Standaard -';
$string['common:popup_blocked'] = 'Je zult je pop-up-blocker tijdelijk moeten uitschakelen voor deze website om gebruik te kunnen maken van alle functies van deze teksteditor.';
$string['common:update'] = 'Bijwerken';
$string['common:value'] = '(waarde)';
$string['contextmenu:align'] = 'Uitlijning';
$string['contextmenu:center'] = 'Centreren';
$string['contextmenu:full'] = 'Uitvullen';
$string['contextmenu:left'] = 'Links';
$string['contextmenu:right'] = 'Rechts';
$string['customconfig'] = 'Aangepaste configuratie';
$string['customconfig_desc'] = 'Aangepaste geavanceerde TinyMCE-configuratei in JSON-formaat, bijvoorbeeld: {"option1" : "value2", "option2" : "value2"}. Alle opties die je hier plaatst, overschrijven de standaard- en pluginingstellingen.';
$string['customtoolbar'] = 'Editor werkbalk';
$string['customtoolbar_desc'] = 'Elke lijn bevat een lijst met komma gescheiden knopnamen, gebruik "wrap" als groepsscheiding. Lege regels worden genegeerd. Kijk op <a href="{$a}" target="_blank">{$a}</a> voor de lijst met standaard TinyMCE-knoppen.<br />De eerste rij wordt altijd getoond, terwijl de zichtbaarheid van de tweede en derde rij in- en uitgeschakeld kan worden.';
$string['directionality:ltr_desc'] = 'Van links naar rechts';
$string['directionality:rtl_desc'] = 'Van rechts naar links';
$string['emotions:delta_height'] = '';
$string['emotions:delta_width'] = '';
$string['emotions:emotions_desc'] = 'Emoties';
$string['emotions_dlg:cool'] = 'Stoer';
$string['emotions_dlg:cry'] = 'Huilen';
$string['emotions_dlg:desc'] = 'Emoties';
$string['emotions_dlg:embarassed'] = 'Schamen';
$string['emotions_dlg:foot_in_mouth'] = 'Verstomd';
$string['emotions_dlg:frown'] = 'Wenkbrauw ophalen';
$string['emotions_dlg:innocent'] = 'Onschuldig';
$string['emotions_dlg:kiss'] = 'Zoenen';
$string['emotions_dlg:laughing'] = 'Lachen';
$string['emotions_dlg:money_mouth'] = 'Hebberig';
$string['emotions_dlg:sealed'] = 'Afgesloten';
$string['emotions_dlg:smile'] = 'Lachen';
$string['emotions_dlg:surprised'] = 'Verrast';
$string['emotions_dlg:title'] = 'Emotie invoegen';
$string['emotions_dlg:tongue_out'] = 'Tong uitsteken';
$string['emotions_dlg:undecided'] = 'Onbeslist';
$string['emotions_dlg:usage'] = 'Gebruik links- en rechtspijltjes om te navigeren.';
$string['emotions_dlg:wink'] = 'Knipogen';
$string['emotions_dlg:yell'] = 'Roepen';
$string['fontselectlist'] = 'Beschikbare lettertypes';
$string['fullpage:delta_height'] = '';
$string['fullpage:delta_width'] = '';
$string['fullpage:desc'] = 'Documenteigenschappen';
$string['fullpage_dlg:active_color'] = 'Actieve kleur';
$string['fullpage_dlg:add'] = 'Nieuw element toevoegen';
$string['fullpage_dlg:add_base'] = 'Basiselement';
$string['fullpage_dlg:add_comment'] = 'Opmerkingknooppunt';
$string['fullpage_dlg:add_link'] = 'Linkelement';
$string['fullpage_dlg:add_meta'] = 'Meta-element';
$string['fullpage_dlg:add_script'] = 'Scriptelement';
$string['fullpage_dlg:add_style'] = 'Stijlelement';
$string['fullpage_dlg:add_title'] = 'Titelelement';
$string['fullpage_dlg:advanced_props'] = 'Geavanceerd';
$string['fullpage_dlg:advanced_tab'] = 'Geavanceerd';
$string['fullpage_dlg:appearance_bgprops'] = 'Achtergrondeigenschappen';
$string['fullpage_dlg:appearance_linkprops'] = 'Linkkleuren';
$string['fullpage_dlg:appearance_marginprops'] = 'Body-marge';
$string['fullpage_dlg:appearance_style'] = 'Stijlblad en stijleigenschappen';
$string['fullpage_dlg:appearance_tab'] = 'Weergave';
$string['fullpage_dlg:appearance_textprops'] = 'Teksteigenschappen';
$string['fullpage_dlg:author'] = 'Auteur';
$string['fullpage_dlg:base_element'] = 'Basiselement';
$string['fullpage_dlg:bgcolor'] = 'Achtergrondkleur';
$string['fullpage_dlg:bgimage'] = 'Achtergrondafbeelding';
$string['fullpage_dlg:bottom_margin'] = 'Ondermarge';
$string['fullpage_dlg:charset'] = 'Karakterset';
$string['fullpage_dlg:comment_element'] = 'Opmerking';
$string['fullpage_dlg:content'] = 'Inhoud';
$string['fullpage_dlg:copyright'] = 'Copyright';
$string['fullpage_dlg:defer'] = 'Uitstellen';
$string['fullpage_dlg:doctypes'] = 'Doctype';
$string['fullpage_dlg:encoding'] = 'Karaktercodering';
$string['fullpage_dlg:font_face'] = 'Lettertype';
$string['fullpage_dlg:font_size'] = 'Tekengrootte';
$string['fullpage_dlg:fontface'] = 'Lettertype';
$string['fullpage_dlg:fontsize'] = 'Tekengrootte';
$string['fullpage_dlg:general_props'] = 'Algemeen';
$string['fullpage_dlg:head_elements'] = 'Kopelementen';
$string['fullpage_dlg:hover_color'] = 'Hoverkleur';
$string['fullpage_dlg:href'] = 'HREF';
$string['fullpage_dlg:hreflang'] = 'HREF taal';
$string['fullpage_dlg:info'] = 'Informatie';
$string['fullpage_dlg:langcode'] = 'Taalcode';
$string['fullpage_dlg:langdir'] = 'Taalrichting';
$string['fullpage_dlg:langprops'] = 'Taal en codering';
$string['fullpage_dlg:language'] = 'Taal';
$string['fullpage_dlg:left_margin'] = 'Linkermarge';
$string['fullpage_dlg:link_color'] = 'Linkkleur';
$string['fullpage_dlg:link_element'] = 'Linkelement';
$string['fullpage_dlg:ltr'] = 'Van links naar rechts';
$string['fullpage_dlg:media'] = 'Media';
$string['fullpage_dlg:meta_description'] = 'Beschrijving';
$string['fullpage_dlg:meta_element'] = 'Meta-element';
$string['fullpage_dlg:meta_index_follow'] = 'Links indexeren en volgen';
$string['fullpage_dlg:meta_index_nofollow'] = 'Links indexeren maar niet volgen';
$string['fullpage_dlg:meta_keywords'] = 'Sleutelwoorden';
$string['fullpage_dlg:meta_noindex_follow'] = 'Links volgen maar niet indexeren';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'Links niet indexeren en niet volgen';
$string['fullpage_dlg:meta_props'] = 'Meta informatie';
$string['fullpage_dlg:meta_robots'] = 'Robots';
$string['fullpage_dlg:meta_tab'] = 'Algemeen';
$string['fullpage_dlg:meta_title'] = 'Titel';
$string['fullpage_dlg:movedown'] = 'Geselecteerde elementen omlaag verplaatsen';
$string['fullpage_dlg:moveup'] = 'Geselecteerde elementen omhoog verplaatsen';
$string['fullpage_dlg:name'] = 'Naam';
$string['fullpage_dlg:properties'] = 'Eigenschappen';
$string['fullpage_dlg:rel'] = 'Rel';
$string['fullpage_dlg:remove'] = 'Geselecteerde elementen verwijderen';
$string['fullpage_dlg:rev'] = 'Rev';
$string['fullpage_dlg:right_margin'] = 'Rechtermarge';
$string['fullpage_dlg:rtl'] = 'Van rechts naar links';
$string['fullpage_dlg:script_element'] = 'Scriptelement';
$string['fullpage_dlg:src'] = 'Bron';
$string['fullpage_dlg:style'] = 'Stijl';
$string['fullpage_dlg:style_element'] = 'Stijlelement';
$string['fullpage_dlg:stylesheet'] = 'Stijlblad';
$string['fullpage_dlg:target'] = 'Doel';
$string['fullpage_dlg:text_color'] = 'Tekstkleur';
$string['fullpage_dlg:textcolor'] = 'Kleur';
$string['fullpage_dlg:title'] = 'Documenteigenschappen';
$string['fullpage_dlg:title_element'] = 'Titelelement';
$string['fullpage_dlg:top_margin'] = 'Bovenmarge';
$string['fullpage_dlg:type'] = 'Type';
$string['fullpage_dlg:value'] = 'Waarde';
$string['fullpage_dlg:visited_color'] = 'Bezocht kleur';
$string['fullpage_dlg:xml_pi'] = 'XML toewijzing';
$string['fullscreen:desc'] = 'Schakel naar volledig scherm';
$string['iespell:download'] = 'ieSpell niet gevonden. Wilt u deze nu installeren?';
$string['iespell:iespell_desc'] = 'Spellingcontrole';
$string['insertdatetime:date_fmt'] = '%d-%m-%Y';
$string['insertdatetime:day_long'] = 'Zondag,Maandag,Dinsdag,Woensdag,Donderdag,Vrijdag,Zaterdag,Zondag';
$string['insertdatetime:day_short'] = 'zo,ma,di,wo,do,vr,za,zo';
$string['insertdatetime:insertdate_desc'] = 'Datum invoegen';
$string['insertdatetime:inserttime_desc'] = 'Tijd invoegen';
$string['insertdatetime:months_long'] = 'Januari,Februari,Maart,April,Mei,Juni,Juli,Augustus,September,Oktober,November,December';
$string['insertdatetime:months_short'] = 'Jan,Feb,Mar,Apr,Mei,Jun,Jul,Aug,Sep,Okt,Nov,Dec';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = 'Absoluut positioneren inschakelen';
$string['layer:backward_desc'] = 'Vorige laag';
$string['layer:content'] = 'Nieuwe laag...';
$string['layer:forward_desc'] = 'Volgende laag';
$string['layer:insertlayer_desc'] = 'Nieuwe laag invoegen';
$string['media:delta_height'] = '';
$string['media:delta_width'] = '';
$string['media:desc'] = 'Media invoegen/bewerken';
$string['media:edit'] = 'Media bewerken';
$string['media_dlg:advanced'] = 'Geavanceerd';
$string['media_dlg:align'] = 'Uitlijning';
$string['media_dlg:align_bottom'] = 'Onder';
$string['media_dlg:align_bottom_left'] = 'Linksonder';
$string['media_dlg:align_bottom_right'] = 'Rechtsonder';
$string['media_dlg:align_center'] = 'Centreren';
$string['media_dlg:align_left'] = 'Links';
$string['media_dlg:align_right'] = 'Rechts';
$string['media_dlg:align_top'] = 'Boven';
$string['media_dlg:align_top_left'] = 'Linksboven';
$string['media_dlg:align_top_right'] = 'Rechtsboven';
$string['media_dlg:altsource1'] = 'Alternatieve bron 1';
$string['media_dlg:altsource2'] = 'Alternatieve bron 2';
$string['media_dlg:audio'] = 'HTML5 audio';
$string['media_dlg:autogotourl'] = 'Automatisch naar URL';
$string['media_dlg:autohref'] = 'Auto HREF';
$string['media_dlg:autostart'] = 'Automatisch afspelen';
$string['media_dlg:balance'] = 'Balans';
$string['media_dlg:base'] = 'Basis';
$string['media_dlg:baseurl'] = 'BasisURL';
$string['media_dlg:bgcolor'] = 'Achtergrond';
$string['media_dlg:cache'] = 'Cache';
$string['media_dlg:captioningid'] = 'Ondertiteling ID';
$string['media_dlg:center'] = 'Centreren';
$string['media_dlg:class_name'] = 'Klasse';
$string['media_dlg:console'] = 'Console';
$string['media_dlg:constrain_proportions'] = 'Verhouding bewaren';
$string['media_dlg:controller'] = 'Controller';
$string['media_dlg:controls'] = 'Bediening';
$string['media_dlg:correction'] = 'Geen correctie';
$string['media_dlg:currentmarker'] = 'Huidige markering';
$string['media_dlg:currentposition'] = 'Huidige positie';
$string['media_dlg:defaultframe'] = 'Standaard frame';
$string['media_dlg:embedded_audio_options'] = 'Ingebedde audio-opties';
$string['media_dlg:embeddedaudio'] = 'Ingebedde audio';
$string['media_dlg:enabled'] = 'Ingeschakeld';
$string['media_dlg:enablejavascript'] = 'JavaScript Inschakelen';
$string['media_dlg:endtime'] = 'Eindtijd';
$string['media_dlg:file'] = 'Bestand/URL';
$string['media_dlg:flash'] = 'Flash';
$string['media_dlg:flash_options'] = 'Flash opties';
$string['media_dlg:flashvars'] = 'Flash variabelen';
$string['media_dlg:fullscreen'] = 'Volledig scherm';
$string['media_dlg:general'] = 'Algemeen';
$string['media_dlg:hidden'] = 'Verborgen';
$string['media_dlg:href'] = 'HREF';
$string['media_dlg:hspace'] = 'H-Ruimte';
$string['media_dlg:html5_audio_options'] = 'Audio-opties';
$string['media_dlg:html5_video_options'] = 'HTML5 video-opties';
$string['media_dlg:id'] = 'ID';
$string['media_dlg:iframe'] = 'Iframe';
$string['media_dlg:imagestatus'] = 'Afbeeldingstatus';
$string['media_dlg:invokeurls'] = 'URLs laden';
$string['media_dlg:kioskmode'] = 'Kioskmodus';
$string['media_dlg:list'] = 'Lijst';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = 'Herhalen';
$string['media_dlg:maintainaspect'] = 'Verhouding bewaren';
$string['media_dlg:menu'] = 'Menu Weergeven';
$string['media_dlg:mute'] = 'Geluid dempen';
$string['media_dlg:name'] = 'Naam';
$string['media_dlg:nojava'] = 'Geen java';
$string['media_dlg:numloop'] = 'Aantal herhalingen';
$string['media_dlg:play'] = 'Automatisch afspelen';
$string['media_dlg:playcount'] = 'Afspeelteller';
$string['media_dlg:playeveryframe'] = 'Elk frame afspelen';
$string['media_dlg:poster'] = 'Poster';
$string['media_dlg:prefetch'] = 'Voorladen';
$string['media_dlg:preload'] = 'Vooraf laden';
$string['media_dlg:preload_auto'] = 'Laat de browser van de gebruiker beslissen';
$string['media_dlg:preload_metadata'] = 'Video metadata vooraf laden';
$string['media_dlg:preload_none'] = 'Niet vooraf laden';
$string['media_dlg:preview'] = 'Voorbeeld';
$string['media_dlg:progress'] = 'Vordering';
$string['media_dlg:qt_options'] = 'QuickTime opties';
$string['media_dlg:qt_stream_warn'] = 'Gestreamde RTSP bronnen dienen op het tabblad geavanceerd bij QT bron te worden opgegeven.
Je moet ook een niet-gestreamde versie van het bronbestand geven.';
$string['media_dlg:qtsrc'] = 'QT bron';
$string['media_dlg:qtsrcchokespeed'] = 'Chokesnelheid';
$string['media_dlg:quality'] = 'Kwaliteit';
$string['media_dlg:quicktime'] = 'QuickTime';
$string['media_dlg:rate'] = 'Snelheid';
$string['media_dlg:realmedia'] = 'Real Media';
$string['media_dlg:rmp_options'] = 'Real Media-speler opties';
$string['media_dlg:salign'] = 'Schaaluitlijning';
$string['media_dlg:scale'] = 'Schaal';
$string['media_dlg:scriptcallbacks'] = 'Script callbacks';
$string['media_dlg:shockwave'] = 'Shockwave';
$string['media_dlg:shockwave_options'] = 'Shockwave opties';
$string['media_dlg:shuffle'] = 'Willekeurige volgorde';
$string['media_dlg:size'] = 'Afmetingen';
$string['media_dlg:sound'] = 'Geluid';
$string['media_dlg:source'] = 'Bron';
$string['media_dlg:starttime'] = 'Starttijd';
$string['media_dlg:stretchtofit'] = 'Passend maken';
$string['media_dlg:swstretchhalign'] = 'H-Schaal';
$string['media_dlg:swstretchstyle'] = 'Stijl vergroten';
$string['media_dlg:swstretchvalign'] = 'V-Schaal';
$string['media_dlg:target'] = 'Doel';
$string['media_dlg:targetcache'] = 'Doelcache';
$string['media_dlg:title'] = 'Media invoegen/bewerken';
$string['media_dlg:type'] = 'Type';
$string['media_dlg:uimode'] = 'UI Modus';
$string['media_dlg:video'] = 'HTML5 video';
$string['media_dlg:volume'] = 'Volume';
$string['media_dlg:vspace'] = 'V-Ruimte';
$string['media_dlg:windowlessvideo'] = 'Video zonder venster';
$string['media_dlg:windowsmedia'] = 'Windows Media';
$string['media_dlg:wmode'] = 'WMode';
$string['media_dlg:wmp_options'] = 'Windows Mediaspeler opties';
$string['nonbreaking:nonbreaking_desc'] = 'Open ruimte invoegen';
$string['pagebreak:desc'] = 'Pagina-einde voor afdrukken invoegen';
$string['paste:paste_text_desc'] = 'Als platte tekst plakken';
$string['paste:paste_word_desc'] = 'Vanuit Word plakken';
$string['paste:plaintext_mode'] = 'Plakken is nu in plattetekstmoduse. Klik nog een keer om terug te gaan naar normaal plakken. Nadat je iets geplakt hebt, zul je automatisch terug naar de normale plakmodus keren.';
$string['paste:plaintext_mode_stick'] = 'Plakken is nu in platte tekstmodus. Klik nogmaals om terug naar normale plakmodus te keren.';
$string['paste:selectall_desc'] = 'Alles selecteren';
$string['paste_dlg:text_linebreaks'] = 'Regelafbreking bewaren';
$string['paste_dlg:text_title'] = 'Gebruik Ctrl+v op je toetsenbord om tekst in het venster te plakken.';
$string['paste_dlg:word_title'] = 'Gebruik Ctrl+v op je toetsenbord om tekst in het venster te plakken.';
$string['pluginname'] = 'TinyMCE HTML-editor';
$string['preview:preview_desc'] = 'Voorbeeld';
$string['print:print_desc'] = 'Afdrukken';
$string['privacy:metadata'] = 'DeTinyMCE HTML-editor-plugin bewaart geen persoonlijke gegevens.';
$string['save:cancel_desc'] = 'Alle wijzigingen annuleren';
$string['save:save_desc'] = 'Opslaan';
$string['searchreplace:delta_height'] = '';
$string['searchreplace:delta_width'] = '';
$string['searchreplace:replace_desc'] = 'Zoeken/Vervangen';
$string['searchreplace:search_desc'] = 'Zoeken';
$string['searchreplace_dlg:allreplaced'] = 'Alle exemplaren van de zoekterm zijn vervangen.';
$string['searchreplace_dlg:direction'] = 'Richting';
$string['searchreplace_dlg:down'] = 'Omlaag';
$string['searchreplace_dlg:findnext'] = 'Zoeken';
$string['searchreplace_dlg:findwhat'] = 'Zoeken naar';
$string['searchreplace_dlg:mcase'] = 'Identieke hoofdletters/kleine letters';
$string['searchreplace_dlg:notfound'] = 'Het doorzoeken is voltooid. De zoekterm kon niet meer worden gevonden.';
$string['searchreplace_dlg:replace'] = 'Vervangen';
$string['searchreplace_dlg:replace_title'] = 'Zoeken/Vervangen';
$string['searchreplace_dlg:replaceall'] = 'Alles verv.';
$string['searchreplace_dlg:replacewith'] = 'Vervangen door';
$string['searchreplace_dlg:search_title'] = 'Zoeken';
$string['searchreplace_dlg:searchnext_desc'] = 'Opnieuw zoeken';
$string['searchreplace_dlg:up'] = 'Omhoog';
$string['settings'] = 'Algemene instellingen';
$string['simple:bold_desc'] = 'Vet (Ctrl+B)';
$string['simple:bullist_desc'] = 'Opsommingstekens invoegen/verwijderen';
$string['simple:cleanup_desc'] = 'Code opruimen';
$string['simple:italic_desc'] = 'Cursief (Ctrl+I)';
$string['simple:numlist_desc'] = 'Genummerde lijst invoegen/verwijderen';
$string['simple:redo_desc'] = 'Herhalen (Ctrl+Y)';
$string['simple:striketrough_desc'] = 'Doorhalen';
$string['simple:underline_desc'] = 'Onderstrepen (Ctrl+U)';
$string['simple:undo_desc'] = 'Ongedaan maken (Ctrl+Z)';
$string['spellchecker:desc'] = 'Spellingcontrole inschakelen/uitschakelen';
$string['spellchecker:ignore_word'] = 'Woord negeren';
$string['spellchecker:ignore_words'] = 'Alles negeren';
$string['spellchecker:langs'] = 'Talen';
$string['spellchecker:learn_word'] = 'Woord onthouden';
$string['spellchecker:menu'] = 'Instellingen spellingcontrole';
$string['spellchecker:no_mpell'] = 'Geen spelfouten gevonden.';
$string['spellchecker:no_sug'] = 'Geen suggesties';
$string['spellchecker:sug'] = 'Suggesties';
$string['spellchecker:wait'] = 'Een ogenblik geduld…';
$string['style:delta_height'] = '';
$string['style:delta_width'] = '';
$string['style:desc'] = 'CSS Stijl bewerken';
$string['style_dlg:apply'] = 'Toepassen';
$string['style_dlg:background'] = 'Achtergrond';
$string['style_dlg:background_attachment'] = 'Bijlage';
$string['style_dlg:background_color'] = 'Achtergrondkleur';
$string['style_dlg:background_hpos'] = 'Horizontale positie';
$string['style_dlg:background_image'] = 'Achtergrondafbeelding';
$string['style_dlg:background_repeat'] = 'Herhalen';
$string['style_dlg:background_tab'] = 'Achtergrond';
$string['style_dlg:background_vpos'] = 'Verticale positie';
$string['style_dlg:block'] = 'Blok';
$string['style_dlg:block_display'] = 'Weergave';
$string['style_dlg:block_letterspacing'] = 'Letterruimte';
$string['style_dlg:block_tab'] = 'Blok';
$string['style_dlg:block_text_align'] = 'Tekstuitlijning';
$string['style_dlg:block_text_indent'] = 'Inspringen';
$string['style_dlg:block_vertical_alignment'] = 'Verticale uitlijning';
$string['style_dlg:block_whitespace'] = 'Witruimte';
$string['style_dlg:block_wordspacing'] = 'Woordruimte';
$string['style_dlg:border'] = 'Rand';
$string['style_dlg:border_tab'] = 'Rand';
$string['style_dlg:bottom'] = 'Onder';
$string['style_dlg:box'] = 'Box';
$string['style_dlg:box_clear'] = 'Vrijhouden';
$string['style_dlg:box_float'] = 'Zweven';
$string['style_dlg:box_height'] = 'Hoogte';
$string['style_dlg:box_tab'] = 'Box';
$string['style_dlg:box_width'] = 'Breedte';
$string['style_dlg:bullet_image'] = 'Opsommingsteken';
$string['style_dlg:clip'] = 'Clip';
$string['style_dlg:color'] = 'Kleur';
$string['style_dlg:height'] = 'Hoogte';
$string['style_dlg:left'] = 'Links';
$string['style_dlg:list'] = 'Lijst';
$string['style_dlg:list_tab'] = 'Lijst';
$string['style_dlg:list_type'] = 'Type';
$string['style_dlg:margin'] = 'Marge';
$string['style_dlg:overflow'] = 'Overvloeien';
$string['style_dlg:padding'] = 'Opening';
$string['style_dlg:placement'] = 'Plaatsing';
$string['style_dlg:position'] = 'Positie';
$string['style_dlg:positioning_tab'] = 'Positionering';
$string['style_dlg:positioning_type'] = 'Type';
$string['style_dlg:right'] = 'Rechts';
$string['style_dlg:same'] = 'Alles hetzelfde';
$string['style_dlg:style'] = 'Stijl';
$string['style_dlg:text'] = 'Tekst';
$string['style_dlg:text_blink'] = 'Knipperen';
$string['style_dlg:text_case'] = 'Hoofdlettergebruik';
$string['style_dlg:text_color'] = 'Kleur';
$string['style_dlg:text_decoration'] = 'Decoratie';
$string['style_dlg:text_font'] = 'Lettertype';
$string['style_dlg:text_lineheight'] = 'Lijnhoogte';
$string['style_dlg:text_none'] = 'Niets';
$string['style_dlg:text_overline'] = 'Overhalen';
$string['style_dlg:text_props'] = 'Tekst';
$string['style_dlg:text_size'] = 'Tekengrootte';
$string['style_dlg:text_striketrough'] = 'Doorhalen';
$string['style_dlg:text_style'] = 'Stijl';
$string['style_dlg:text_tab'] = 'Tekst';
$string['style_dlg:text_underline'] = 'Onderlijnen';
$string['style_dlg:text_variant'] = 'Variant';
$string['style_dlg:text_weight'] = 'Gewicht';
$string['style_dlg:title'] = 'CSS Stijl bewerken';
$string['style_dlg:toggle_insert_span'] = 'Span invoegen bij selectie';
$string['style_dlg:top'] = 'Boven';
$string['style_dlg:visibility'] = 'Zichtbaarheid';
$string['style_dlg:width'] = 'Breedte';
$string['style_dlg:zindex'] = 'Z-index';
$string['subplugintype_tinymce'] = 'Plugin';
$string['subplugintype_tinymce_plural'] = 'Plugins';
$string['table:cell'] = 'Cel';
$string['table:cell_desc'] = 'Cel-eigenschappen';
$string['table:cellprops_delta_height'] = '';
$string['table:cellprops_delta_width'] = '';
$string['table:col'] = 'Kolom';
$string['table:col_after_desc'] = 'Kolom rechts invoegen';
$string['table:col_before_desc'] = 'Kolom links invoegen';
$string['table:copy_row_desc'] = 'Rij kopiëren';
$string['table:cut_row_desc'] = 'Rij knippen';
$string['table:del'] = 'Tabel verwijderen';
$string['table:delete_col_desc'] = 'Kolom verwijderen';
$string['table:delete_row_desc'] = 'Rij verwijderen';
$string['table:desc'] = 'Tabel invoegen/bewerken';
$string['table:merge_cells_delta_height'] = '';
$string['table:merge_cells_delta_width'] = '';
$string['table:merge_cells_desc'] = 'Cellen samenvoegen';
$string['table:paste_row_after_desc'] = 'Rij onder plakken';
$string['table:paste_row_before_desc'] = 'Rij boven plakken';
$string['table:props_desc'] = 'Tabeleigenschappen';
$string['table:row'] = 'Rij';
$string['table:row_after_desc'] = 'Rij onder invoegen';
$string['table:row_before_desc'] = 'Rij boven invoegen';
$string['table:row_desc'] = 'Rij-eigenschappen';
$string['table:rowprops_delta_height'] = '';
$string['table:rowprops_delta_width'] = '';
$string['table:split_cells_desc'] = 'Cellen splitsen';
$string['table:table_delta_height'] = '';
$string['table:table_delta_width'] = '';
$string['table_dlg:advanced_props'] = 'Geavanceerde eigenschappen';
$string['table_dlg:advanced_tab'] = 'Geavanceerd';
$string['table_dlg:align'] = 'Uitlijning';
$string['table_dlg:align_bottom'] = 'Onder';
$string['table_dlg:align_default'] = 'Standaard';
$string['table_dlg:align_left'] = 'Links';
$string['table_dlg:align_middle'] = 'Centreren';
$string['table_dlg:align_right'] = 'Rechts';
$string['table_dlg:align_top'] = 'Boven';
$string['table_dlg:bgcolor'] = 'Achtergrondkleur';
$string['table_dlg:bgimage'] = 'Achtergrondafbeelding';
$string['table_dlg:border'] = 'Rand';
$string['table_dlg:bordercolor'] = 'Randkleur';
$string['table_dlg:caption'] = 'Tabelbeschrijving';
$string['table_dlg:cell_all'] = 'Alle cellen in tabel bijwerken';
$string['table_dlg:cell_cell'] = 'Huidige cel bijwerken';
$string['table_dlg:cell_col'] = 'Alle cellen van een kolom aanpassen';
$string['table_dlg:cell_limit'] = 'U heeft het maximale aantal cellen van {$cells} overschreden.';
$string['table_dlg:cell_row'] = 'Alle cellen in rij bijwerken';
$string['table_dlg:cell_title'] = 'Celeigenschappen';
$string['table_dlg:cell_type'] = 'Celtype';
$string['table_dlg:cellpadding'] = 'Ruimte in cel';
$string['table_dlg:cellspacing'] = 'Ruimte rond cel';
$string['table_dlg:col_limit'] = 'U heeft het maximale aantal kolommen van {$cols} overschreden.';
$string['table_dlg:colgroup'] = 'Kolomgroep';
$string['table_dlg:cols'] = 'Kolommen';
$string['table_dlg:frame'] = 'Frame';
$string['table_dlg:frame_all'] = 'Alles';
$string['table_dlg:frame_cols'] = 'Kolommen';
$string['table_dlg:frame_groups'] = 'Groepen';
$string['table_dlg:frame_none'] = 'Geen';
$string['table_dlg:frame_rows'] = 'Rijen';
$string['table_dlg:general_props'] = 'Algemene eigenschappen';
$string['table_dlg:general_tab'] = 'Algemeen';
$string['table_dlg:height'] = 'Hoogte';
$string['table_dlg:id'] = 'ID';
$string['table_dlg:langcode'] = 'Taalcode';
$string['table_dlg:langdir'] = 'Taalrichting';
$string['table_dlg:ltr'] = 'Van links naar rechts';
$string['table_dlg:merge_cells_title'] = 'Cellen samenvoegen';
$string['table_dlg:mime'] = 'Doel MIME type';
$string['table_dlg:missing_scope'] = 'Weet je zeker dat je door wil gaan met het toewijzen van een kop zonder een bereik op te geven? Voor mensen met een handicap wordt het hierdoor moeilijk om de inhoud of de gegevens in de tabel te begrijpen.';
$string['table_dlg:row_all'] = 'Alle rijen bijwerken';
$string['table_dlg:row_even'] = 'Even rijen bijwerken';
$string['table_dlg:row_limit'] = 'U heeft hebt het maximale aantal rijen van {$rows} overschreden.';
$string['table_dlg:row_odd'] = 'Oneven rijen bijwerken';
$string['table_dlg:row_row'] = 'Huidige rij bijwerken';
$string['table_dlg:row_title'] = 'Rij-eigenschappen';
$string['table_dlg:rowgroup'] = 'Rijgroep';
$string['table_dlg:rows'] = 'Rijen';
$string['table_dlg:rowtype'] = 'Rijtype';
$string['table_dlg:rtl'] = 'Van rechts naar links';
$string['table_dlg:rules'] = 'Hulplijnen';
$string['table_dlg:rules_above'] = 'Boven';
$string['table_dlg:rules_below'] = 'Onder';
$string['table_dlg:rules_border'] = 'Rand';
$string['table_dlg:rules_box'] = 'Box';
$string['table_dlg:rules_hsides'] = 'Horizontale zijden';
$string['table_dlg:rules_lhs'] = 'Linkerzijkant';
$string['table_dlg:rules_rhs'] = 'Rechterzijkant';
$string['table_dlg:rules_void'] = 'Geen';
$string['table_dlg:rules_vsides'] = 'Verticale zijden';
$string['table_dlg:scope'] = 'Bereik';
$string['table_dlg:style'] = 'Stijl';
$string['table_dlg:summary'] = 'Samenvatting';
$string['table_dlg:tbody'] = 'Tabellichaam';
$string['table_dlg:td'] = 'Gegevens';
$string['table_dlg:tfoot'] = 'Tabelvoet';
$string['table_dlg:th'] = 'Kop';
$string['table_dlg:thead'] = 'Tabelkop';
$string['table_dlg:title'] = 'Tabel invoegen/bewerken';
$string['table_dlg:valign'] = 'Verticale uitlijning';
$string['table_dlg:width'] = 'Breedte';
$string['template:desc'] = 'Voorgedefinieerd sjabloon invoegen';
$string['template_dlg:cdate_format'] = '%d-%m-%Y %H:%M:%S';
$string['template_dlg:day_long'] = 'Zondag,Maandag,Dinsdag,Woensdag,Donderdag,Vrijdag,Zaterdag,Zondag';
$string['template_dlg:day_short'] = 'zo,ma,di,wo,do,vr,za,zo';
$string['template_dlg:desc'] = 'Voorgedefinieerd sjabloon invoegen';
$string['template_dlg:desc_label'] = 'Beschrijving';
$string['template_dlg:label'] = 'Sjabloon';
$string['template_dlg:mdate_format'] = '%d-%m-%Y %H:%M:%S';
$string['template_dlg:months_long'] = 'Januari,Februari,Maart,April,Mei,Juni,Juli,Augustus,September,Oktober,November,December';
$string['template_dlg:months_short'] = 'Jan,Feb,Mar,Apr,Mei,Jun,Jul,Aug,Sep,Okt,Nov,Dec';
$string['template_dlg:preview'] = 'Voorbeeld';
$string['template_dlg:select'] = 'Selecteer een sjabloon';
$string['template_dlg:title'] = 'Sjablonen';
$string['template_dlg:warning'] = 'Waarschuwing: het bijwerken van een sjabloon met een andere kan het verlies van informatie tot gevolg hebben.';
$string['visualblocks:desc'] = 'Toon/verberg blokelementen';
$string['visualchars:desc'] = 'Toon/verberg controletekens';
$string['wordcount:words'] = 'Woorden:';
$string['xhtmlxtras:abbr_delta_height'] = '';
$string['xhtmlxtras:abbr_delta_width'] = '';
$string['xhtmlxtras:abbr_desc'] = 'Afkorting';
$string['xhtmlxtras:acronym_delta_height'] = '';
$string['xhtmlxtras:acronym_delta_width'] = '';
$string['xhtmlxtras:acronym_desc'] = 'Synoniem';
$string['xhtmlxtras:attribs_delta_height'] = '';
$string['xhtmlxtras:attribs_delta_width'] = '';
$string['xhtmlxtras:attribs_desc'] = 'Attributen invoegen/bewerken';
$string['xhtmlxtras:cite_delta_height'] = '';
$string['xhtmlxtras:cite_delta_width'] = '';
$string['xhtmlxtras:cite_desc'] = 'Citaat';
$string['xhtmlxtras:del_delta_height'] = '';
$string['xhtmlxtras:del_delta_width'] = '';
$string['xhtmlxtras:del_desc'] = 'Verwijderd';
$string['xhtmlxtras:ins_delta_height'] = '';
$string['xhtmlxtras:ins_delta_width'] = '';
$string['xhtmlxtras:ins_desc'] = 'Ingevoegd';
$string['xhtmlxtras_dlg:attrib_tab'] = 'Attributen';
$string['xhtmlxtras_dlg:attribs_title'] = 'Attributen Invoegen/bewerken';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = 'Attributen';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'Gebeurtenissen';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'Toegangstoets';
$string['xhtmlxtras_dlg:attribute_label_cite'] = 'Citaat';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'Klasse';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = 'Datum/Tijd';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'ID';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = 'Taal';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'Tekstrichting';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'Stijl';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'Tabvolgorde';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'Titel';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = 'Van links naar rechts';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = 'Van rechts naar links';
$string['xhtmlxtras_dlg:events_tab'] = 'Gebeurtenissen';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'Elementattributen';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'Elementgebeurtenissen';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = 'Algemene instellingen';
$string['xhtmlxtras_dlg:general_tab'] = 'Algemeen';
$string['xhtmlxtras_dlg:insert_date'] = 'Huidige datum/tijd invoegen';
$string['xhtmlxtras_dlg:option_ltr'] = 'Van links naar rechts';
$string['xhtmlxtras_dlg:option_rtl'] = 'Van rechts naar links';
$string['xhtmlxtras_dlg:remove'] = 'Verwijderen';
$string['xhtmlxtras_dlg:title_abbr_element'] = 'Afkorting element';
$string['xhtmlxtras_dlg:title_acronym_element'] = 'Acroniem element';
$string['xhtmlxtras_dlg:title_cite_element'] = 'Citaatelement';
$string['xhtmlxtras_dlg:title_del_element'] = 'Verwijderselement';
$string['xhtmlxtras_dlg:title_ins_element'] = 'Invoegselement';
