<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'scheduler', language 'nl', version '3.11'.
 *
 * @package     scheduler
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Actie';
$string['actions'] = 'Acties';
$string['addappointment'] = 'Voeg nog een leerling toe';
$string['addcommands'] = 'Voeg een tijdslot toe';
$string['addondays'] = 'Voeg afspraak toe op';
$string['addsession'] = 'Voeg een reeks slots toe';
$string['addsingleslot'] = 'Voeg een enkel slot toe';
$string['addslot'] = 'Je kunt op elk moment extra afspraakmomenten toevoegen.';
$string['addstudenttogroup'] = 'Voeg deze leerling toe aan een afsprakengroep';
$string['allappointments'] = 'Alle afspraken';
$string['allononepage'] = 'Alle slots op een pagina';
$string['allowgroup'] = 'Exclusief tijdslot - klik om te wijzigen';
$string['alreadyappointed'] = 'Je kunt geen afspraak maken. Dit tijdslot is al vol geboekt.';
$string['appointagroup_help'] = 'Kies of je alleen een afspraak voor jezelf wilt maken of voor een hele groep.';
$string['appointfor'] = 'Afspraak maken voor';
$string['appointforgroup'] = 'Maak afspraak voor: {$a}';
$string['appointingstudent'] = 'Afspraak voor tijdslot';
$string['appointingstudentinnew'] = 'Afspraak voor nieuw tijdslot';
$string['appointment'] = 'Afspraak';
$string['appointmentmode'] = 'Instellen afspraken modus';
$string['appointmentmode_help'] = '<p>Je kunt hier enkele varianten kiezen voor het maken van afspraken. </p> <p><ul> <li><strong>"<emph>n</emph> afspraken in deze planner":</strong> De leerling kan slechts een vast aantal afspraken boeken in deze activiteit. Zelfs als de leraar ze als "gezien" markeert, mogen ze geen verdere vergaderingen meer boeken. De enige manier om een leerling de mogelijkheid te geven om opnieuw een afspraak te boeken, is door de oude "gezien" records te verwijderen.</li> <li><strong>"<emph>n</emph> afspraken tegelijk":</strong> De leerling kan een vast aantal afspraken boeken. Zodra de vergadering voorbij is en de leraar de leerling als "gezien" heeft gemarkeerd, kan de leerling verdere afspraken boeken. De leerling is echter op elk moment beperkt tot <emph>n</emph> "open" (onzichtbare) tijdslots. </li> </ul> </p>';
$string['appointmentno'] = 'Afspraak {$a}';
$string['appointmentnote'] = 'Notities voor afspraak (zichtbaar voor leerling)';
$string['appointments'] = 'Afspraken';
$string['appointmentsgrouped'] = 'Afspraken gegroepeerd per tijdslot';
$string['appointmentsummary'] = 'Afspraak op  {$a->startdate} van  {$a->starttime} tot {$a->endtime} met {$a->teacher}';
$string['appointsolo'] = 'alleen ik';
$string['appointsomeone'] = 'Toevoegen nieuwe afspraak';
$string['areaappointmentnote'] = 'Bestanden in notities van afspraak';
$string['areaslotnote'] = 'Bestanden in notities van slot';
$string['areateachernote'] = 'Bestanden in vertrouwelijke notities';
$string['attendable'] = 'Verwacht';
$string['attendablelbl'] = 'Totaal aantal kandidaten voor planning';
$string['attended'] = 'Aanwezig';
$string['attendedlbl'] = 'Aantal aanwezige leerlingen';
$string['attendedslots'] = 'Aanwezig op tijdslots';
$string['availableslots'] = 'Beschikbare tijdslots';
$string['availableslotsall'] = 'Alle tijdslots';
$string['availableslotsnotowned'] = 'Beschikbaar';
$string['availableslotsowned'] = 'Eigen';
$string['bookaslot'] = 'Boek een tijdslot';
$string['bookingdetails'] = 'Boekingsdetails';
$string['bookingformoptions'] = 'Boekingsformulier en door leerlingen verstrekte gegevens';
$string['bookinginstructions'] = 'Boekingsinstructies';
$string['bookinginstructions_help'] = 'Deze tekst wordt aan leerlingen getoond voordat ze een boeking maken. Het kan leerlingen bijvoorbeeld instrueren hoe ze het optionele berichtveld moeten invullen of welke bestanden ze moeten uploaden.';
$string['bookslot'] = 'Boek dit tijdslot';
$string['bookwithteacher'] = 'Leraar';
$string['bookwithteacher_help'] = 'Kies de leraar voor de afspraak';
$string['break'] = 'Pauze tussen tijdslots';
$string['breaknotnegative'] = 'De lengte van de pauze mag niet negatief zijn';
$string['canbook1appointment'] = 'Je kunt nog één afspraak boeken in deze planner.';
$string['canbooknappointments'] = 'Je kunt je inschrijven voor {$a} afspraken in deze planner.';
$string['canbooknofurtherappointments'] = 'Je kunt geen verdere afspraken boeken in deze planner.';
$string['canbooksingleappointment'] = 'Je kunt je voor één afspraak inschrijven in deze planner.';
$string['canbookunlimitedappointments'] = 'Je kunt onbeperkt inschrijven voor afspraken in deze planner.';
$string['cancelbooking'] = 'Annuleer boeking';
$string['chooseexisting'] = 'Kies bestaande';
$string['choosingslotstart'] = 'Kies een starttijd';
$string['choosingslotstart_help'] = 'Wijzig (of kies) de starttijd van de afspraak. Als deze afspraak botst met een aantal andere slots, wordt u gevraagd als dit slot alle tegenstrijdige afspraken vervangt. Merk op dat de nieuwe slotparameters overschrijft alle voorgaande instellingen.';
$string['comments'] = 'Opmerkingen';
$string['complete'] = 'Geboekt';
$string['confirmbooking'] = 'Bevestig booking';
$string['confirmdelete-all'] = 'Hiermee worden <b>alle</b> slots in deze planner verwijderd. Het verwijderen kan niet ongedaan worden gemaakt. Toch verder gaan?';
$string['confirmdelete-mine'] = 'Hiermee worden al je slots in deze planner verwijderd. Het verwijderen kan niet ongedaan worden gemaakt. Toch verder gaan?';
$string['confirmdelete-myunused'] = 'Hiermee worden al uw ongebruikte slots in deze planner verwijderd. Het verwijderen kan niet ongedaan worden gemaakt. Toch verder gaan?';
$string['confirmdelete-one'] = 'Verwijder tijdslot?';
$string['confirmdelete-selected'] = 'Hiermee worden de geselecteerde slots verwijderd. Het verwijderen kan niet ongedaan worden gemaakt. Toch verder gaan?';
$string['confirmdelete-unused'] = 'Hiermee worden alle ongebruikte slots in deze planner verwijderd. Het verwijderen kan niet ongedaan worden gemaakt. Toch verder gaan?';
$string['confirmrevoke'] = 'Alle afspraken in het huidige slot intrekken?';
$string['conflictingslots'] = 'Het slot op {$a} kan niet worden gemaakt vanwege conflicterende slots:';
$string['conflictlocal'] = '{$a->datetime} ({$a->duration} minuten) in deze planner';
$string['conflictremote'] = '{$a->datetime} ({$a->duration} minuten) in cursus {$a->courseshortname}, planner {$a->schedulername}';
$string['contentformat'] = 'Formaat';
$string['contentformat_help'] = '<p>Er zijn drie basiskeuzes voor het exportformaat, verschillen in hoe tijdslots met meerdere afspraken worden afgehandeld. <dl> <dt>Eén regel per tijdslot</dt>: <dd> Het uitvoerbestand bevat één regel voor elk tijdslot. Als een tijdslot meerdere bevat afspraken, dan wordt in plaats van de naam van de leerling, enz., een markering "(meerdere)" weergegeven. </dd> <dt>Eén regel per afspraak</dt>: <dd> Het uitvoerbestand zal voor elke afspraak één regel bevatten. Als een tijdslot meerdere bevat afspraken, dan zal het meerdere keren in de lijst verschijnen (met herhaalde gegevens). </dd> <dt>Afspraken gegroepeerd per tijdslot</dt>: <dd> Alle afspraken van één tijdslot zijn gegroepeerd, voorafgegaan door een kopregel die: geeft het betreffende slot aan. Dit werkt mogelijk niet goed met het CSV-uitvoerbestandsformaat, omdat het aantal kolommen niet constant is. </dd> </dl> Je kunt het effect van deze opties verkennen met de knop "Voorbeeld".</p>';
$string['copytomyself'] = 'Stuur een kopie naar mezelf';
$string['course'] = 'Cursus';
$string['createexport'] = 'Exportbestand maken';
$string['csvfieldseparator'] = 'Veldscheidingsteken voor CSV';
$string['csvformat'] = 'CSV';
$string['cumulatedduration'] = 'Opgetelde duur van afspraken';
$string['datatoinclude'] = 'Op te nemen gegevens';
$string['datatoinclude_help'] = 'Selecteer de velden die in de export moeten worden opgenomen. Elk van deze verschijnt in een kolom van het uitvoerbestand.';
$string['date'] = 'Datum';
$string['datelist'] = 'Overzicht';
$string['defaultslotduration'] = 'Standaard slotduur';
$string['defaultslotduration_help'] = 'De standaardlengte (in minuten) voor afspraakvensters die u instelt';
$string['deleteallslots'] = 'Alle tijdslots verwijderen';
$string['deleteallunusedslots'] = 'Ongebruikte tijdslots verwijderen';
$string['deletecommands'] = 'Verwijder tijdslots';
$string['deletedconflictingslots'] = 'Voor het tijdslot op {$a} zijn conflicterende tijdslots verwijderd:';
$string['deletemyslots'] = 'Verwijder al mijn tijdslots';
$string['deleteonsave'] = 'Verwijder deze afspraak (bij het opslaan van het formulier)';
$string['deleteselection'] = 'Verwijder geselecteerde tijdslots';
$string['deletetheseslots'] = 'Verwijder deze tijdslots';
$string['deleteunusedslots'] = 'Verwijder mijn niet gebruikte tijdslots';
$string['department'] = 'Van waar?';
$string['disengage'] = 'Verwijderd mijn afspraken';
$string['displayfrom'] = 'Toon tijdslot aan leerlingen vanaf';
$string['distributetoslot'] = 'Verspreid naar de hele groep';
$string['divide'] = 'Verdelen in tijdslots?';
$string['duration'] = 'Tijdsduur';
$string['durationrange'] = 'De tijd in een slot moet tussen de {$a->min} en {$a->max} minuten zijn.';
$string['editbooking'] = 'Boeking bewerken';
$string['email_applied_html'] = '<p>Er is een afspraak aangevraagd op {$a->date} om {$a->time},<br/>
door de leerlng <a href="{$a->attendee_url}">{$a->attendee}</a> voor de cursus:

<p>{$a->course_short}: <a href="{$a->course_url}">{$a->course}</a></p>

<p>met behulp van de planner genaamd "<em><a href="{$a->scheduler_url}">{$a->module}</a></em>" op de website: <a href="{$a->site_url}">{$a->site}</a>.</p>';
$string['email_applied_plain'] = 'Er is een afspraak aangevraagd op {$a->date} om {$a->time},
door de cursist {$a->attendee} voor de cursus:

{$a->course_short}: {$a-> course}

met behulp van de planner genaamd "{$a->module}" op de website: {$a->site}.';
$string['email_applied_subject'] = '{$a->course_short}: Nieuwe afspraak';
$string['email_cancelled_html'] = '<p>Je afspraak op <strong>{$a->date}</strong> om <strong>{$a->time}</strong>,<br/>
met de leerling <strong><a href ="{$a->attendee_url}">{$a->attendee}</a></strong> voor cursus :</p>

<p><strong>{$a->course_short} : <a href ="{$a->course_url}">{$a->course}</a></strong></p>

<p>in de planner met de titel "<em><a href="{$a->scheduler_url}">{$a->module}</a></em>" op de website: <strong><a href="{$a->site_url}">{$a->site}</a></strong></p>

<p><strong><span class="error">is geannuleerd of verplaatst</span></strong>.</p>';
$string['email_cancelled_plain'] = 'Je afspraak op {$a->date} om {$a->time},
met de leerling {$a->attendee} voor cursus:

{$a->course_short} : {$a->course}

in de planner getiteld "{$a->module}" op de website: {$a->site}

is geannuleerd of verplaatst.';
$string['email_cancelled_subject'] = '{$a->course_short}: Afspraak geannuleerd of verplaatst door een leerling';
$string['email_invite_html'] = '<p>Kies een tijdslot voor een afspraak op:</p> <p>{$a->scheduler_url}</p>';
$string['email_invite_subject'] = 'Uitnodiging: {$a->module}';
$string['email_invitereminder_html'] = '<p>Dit is slechts een herinnering dat u uw afspraak nog niet heeft gemaakt. Kies zo snel mogelijk een tijdslot op:</p><p>{$a->scheduler_url}</p>';
$string['email_invitereminder_subject'] = 'Herinnering: {$a->module}';
$string['email_reminder_html'] = '<p>Je hebt een aanstaande afspraak op <strong>{$a->date}</strong>
van <strong>{$a->time}</strong> tot <strong>{$a->endtime}</strong><br/>
met <strong><a href="{$a->attendant_url}">{$a->attendant}</a></strong>.</p>

<p>Locatie: <strong>{$a->location}</strong></p>';
$string['email_reminder_plain'] = 'Je hebt een afspraak
op {$a->date} van {$a->time} tot {$a->endtime}
met {$a->attendant}.

Locatie: {$a->location}';
$string['email_reminder_subject'] = '{$a->course_short}: Herinnering afspraak';
$string['email_teachercancelled_html'] = '<p>Uw afspraak op <strong>{$a->date}</strong> om <strong>{$a->time} </strong>,<br/>
met de {$a->staffrole} <strong><a href="{$a->attendant_url}">{$a->attendant}</a></strong> voor cursus:</p>

<p><strong>{$a-> course_short}: <a href="{$a->course_url}">{$a->course}</a></strong></p>

<p>in de planner "<em><a href= "{$a->scheduler_url}">{$a->module}</a></em>" op de website: <strong><a href="{$a->site_url}">{$a->site}</a></strong></p>

<p><strong><span class="error">is geannuleerd</span></strong>.Vraag een nieuw slot aan.</p>';
$string['email_teachercancelled_plain'] = 'Uw afspraak op {$a->date} om {$a->time},
met de {$a->staffrole} {$a->attendant} voor cursus:

{$a->course_short}: {$a->course}

in de planner genaamd "{$a->module}" op de website: {$a->site}

is geannuleerd. Vraag dan een nieuw slot aan.';
$string['email_teachercancelled_subject'] = '{$a->course_short}: Afspraak geannuleerd door de leraar';
$string['emailreminder'] = 'E-mail een herinnering';
$string['emailreminderondate'] = 'E-mail een herinnering op';
$string['end'] = 'Einde';
$string['enddate'] = 'Herhaal tijdslots tot';
$string['event_appointmentlistviewed'] = 'Afsprakenlijst planner bekeken';
$string['event_bookingadded'] = 'Plannerboeking toegevoegd';
$string['event_bookingformviewed'] = 'Planner boekingsformulier bekeken';
$string['event_bookingremoved'] = 'Plannerboeking verwijderd';
$string['event_slotadded'] = 'Planner-tijdslot toegevoegd';
$string['event_slotdeleted'] = 'Planner tijdslot verwijderd';
$string['everyone'] = 'Iedereen';
$string['excelformat'] = 'Excel';
$string['exclusive'] = 'Exclusief';
$string['exclusivity'] = 'Exclusiviteit';
$string['exclusivity_help'] = '<p>Je kunt een limiet instellen voor het aantal leerlingen die zich voor een bepaald slot kunnen aanmelden. </p>
<p>Het instellen van een limiet van 1 (standaard) betekent dat het tijdslot exclusief is voor één enkele leerling.</p>
<p>Het instellen van een limiet van bijvoorbeeld 3 betekent dat er maximaal drie leerlingen kunnen boeken in het tijdslot.</p>
<p>Als je dit uitgeschakelt, kan een willekeurig aantal leerlingen het tijdslot boeken; het zal nooit als "vol" worden beschouwd.</p>';
$string['exclusivityoverload'] = 'De ruimte heeft {$a} aangestelde leerlingen, meer dan toegestaan door deze instelling.';
$string['exclusivitypositive'] = 'Het aantal leerlingen per tijdslot moet 1 of meer zijn.';
$string['explaingeneralconfig'] = 'Deze opties kunnen alleen op siteniveau worden ingesteld en zijn van toepassing op alle planners van deze Moodle-installatie.';
$string['export'] = 'Exporteren';
$string['exporthdr'] = 'Sloten en afspraken exporteren';
$string['exporttimerange'] = 'Tijdsbestek';
$string['exporttimerangeall'] = 'Toekomstige en eerdere tijdslots';
$string['exporttimerangefuture'] = 'Alleen toekomstige slots';
$string['exporttimerangepast'] = 'Alleen eerdere slots';
$string['field-appointmentnote'] = 'Afspraaknotitie (aan leerling)';
$string['field-attended'] = 'Aanwezig';
$string['field-date'] = 'Datum';
$string['field-endtime'] = 'Eindtijd';
$string['field-filecount'] = 'Aantal geüploade bestanden';
$string['field-grade'] = 'Beoordeel';
$string['field-groupsmulti'] = 'Groepen (meerdere kolommen)';
$string['field-groupssingle'] = 'Groepen';
$string['field-groupssingle-label'] = 'Groepen (één kolom)';
$string['field-location'] = 'Locatie';
$string['field-maxstudents'] = 'Maximaal aantal leerlingen';
$string['field-slotnotes'] = 'Slotnotities';
$string['field-starttime'] = 'Starttijd';
$string['field-studentemail'] = 'E-mail leerling';
$string['field-studentfirstname'] = 'Voornaam leerling';
$string['field-studentfullname'] = 'Volledige naam leerling';
$string['field-studentidnumber'] = 'Leerlingen ID nummer';
$string['field-studentlastname'] = 'Achternaam leerling';
$string['field-studentnote'] = 'Bericht van leerling';
$string['field-studentusername'] = 'Gebruikersnaam leerling';
$string['field-teachernote'] = 'Vertrouwelijke nota (alleen leraar)';
$string['fileformat'] = 'Bestandsformaat';
$string['fileformat_help'] = 'De volgende bestandsindelingen zijn beschikbaar:
     <ul>
          <li>Comma Separated Value (CSV) tekstbestanden. Het veldscheidingsteken, standaard een komma, kan hieronder worden gekozen.
               CSV-bestanden kunnen worden geopend in de meeste spreadshet-toepassingen;</li>
          <li>Microsoft Excel-bestanden (Excel 2007-indeling);</li>
          <li>Open Document-spreadsheets (ODS);</li>
          <li>HTML-indeling - een webpagina die de uitvoertabel weergeeft,
                die kan worden afgedrukt met behulp van de afdrukfunctie van de browser;</li>
          <li>PDF-documenten. U kunt kiezen tussen liggende en staande oriëntatie.</li>
     </ul>';
$string['finalgrade'] = 'Eindcijfer';
$string['firstslotavailable'] = 'Het eerste slot is open op: {$a}';
$string['forbidgroup'] = 'Groepsslot - klik om te wijzigen';
$string['forcewhenoverlap'] = 'Forceer bij overlap';
$string['forcewhenoverlap_help'] = '<h3>Het maken van slots forceren wanneer slots elkaar overlappen</h3>
<p>Deze instelling bepaalt hoe nieuwe slots worden behandeld als ze overlappen met andere, reeds bestaande slots.</p>
<p>Als dit is ingeschakeld, wordt het overlappende bestaande slot ook worden verwijderd en het nieuwe slot gemaakt.</p>
<p>Indien uitgeschakeld, wordt het overlappende bestaande slot behouden en wordt er <em>niet</em> een nieuw slot gemaakt.</p>';
$string['forcewhenoverlap_link'] = 'mod/scheduler/conflict';
$string['forcourses'] = 'Kies leerlingen in cursussen';
$string['friday'] = 'Vrijdag';
$string['generalconfig'] = 'Algemene configuratie';
$string['grade'] = 'Cijfer';
$string['gradeingradebook'] = 'Cijfer in cijferlijst';
$string['gradingstrategy'] = 'Beoordelingsstrategie';
$string['gradingstrategy_help'] = 'In een planner waar leerlingen meerdere afspraken kunnen hebben, selecteer je hoe cijfers worden geaggregeerd.
    De cijferlijst kan ofwel <ul><li>het gemiddelde cijfer of</li><li>het maximale cijfer</li></ul> laten zien dat de leerling heeft behaald.';
$string['group'] = 'groep';
$string['groupbookings'] = 'Boeken in groepen';
$string['groupbookings_help'] = 'Laat leerlingen een tijdslot reserveren voor alle leden van hun groep.
(Merk op dat dit los staat van de instelling "groepsmodus", die de tijdslots regelt die een leerling kan zien.)';
$string['groupbreakdown'] = 'Per groepsgrootte';
$string['groupmodeyourgroups'] = 'Groepsmodus: {$a->groupmode}. Alleen leerlingen in {$a->grouplist} kunnen afspraken met je maken.';
$string['groupmodeyourgroupsempty'] = 'Groepsmodus: {$a->groupmode}. Je bent geen lid van een groep, dus leerlingen kunnen geen afspraken met jou maken.';
$string['groupscheduling'] = 'Groepsplanning inschakelen';
$string['groupscheduling_desc'] = 'Sta toe dat hele groepen tegelijk worden gepland.
(Naast de globale optie, moet de instelling "Boeken in groepen" zijn ingeschakeld in de betreffende planner-instantie.)';
$string['groupsession'] = 'Groepssessie';
$string['groupsize'] = 'Groepsgrootte';
$string['guardtime'] = 'Wachttijd';
$string['guardtime_help'] = 'Een wachttijd voorkomt dat leerlingen kort voor de afspraak hun boeking wijzigen.
<p>Als de wachttijd is ingeschakeld en bijvoorbeeld is ingesteld op 2 uur, kunnen leerlingen geen tijdvak boeken dat over minder dan 2 uur begint,
en kunnen ze een afspraak niet laten vallen als het start over minder dan 2 uur.</p>';
$string['guestscantdoanything'] = 'Gasten kunnen hier niets doen.';
$string['howtoaddstudents'] = 'Gebruik de rolinstelling voor de module om leerlingen toe te voegen aan een globale planner.<br/>Je kunt ook moduleroldefinities gebruiken om de deelnemers van jouw leerlingen te definiëren.';
$string['htmlformat'] = 'HTML';
$string['ignoreconflicts'] = 'Negeer planningsconflicten';
$string['ignoreconflicts_help'] = 'Als dit vakje is aangevinkt, wordt het tijdslot verplaatst naar de gewenste datum en tijd, ook als er tegelijkertijd andere tijdslots zijn. Dit kan leiden tot overlappende afspraken voor sommige leraren of leerlingen en moet daarom met zorg worden gebruikt.';
$string['ignoreconflicts_link'] = 'mod/scheduler/conflict';
$string['includeemptyslots'] = 'Lege slots opnemen';
$string['includeslotsfor'] = 'Inclusief slots voor';
$string['incourse'] = 'in cursus';
$string['introduction'] = 'Introductie';
$string['isnonexclusive'] = 'Niet-exclusief';
$string['landscape'] = 'Liggend';
$string['lengthbreakdown'] = 'Per tijdslotduur';
$string['limited'] = 'Beperkt (nog {$a} plaatsen vrij)';
$string['location'] = 'Locatie';
$string['location_help'] = 'Geef een locatie voor de afspraak op';
$string['markasseennow'] = 'Markeer als gezien';
$string['markseen'] = 'Markeer een afspraak met een leerling als "gezien" door in het selectievakje naast de naam van de leerling hierboven te klikken.';
$string['maxgrade'] = 'Neem het hoogste cijfer';
$string['maxstudentlistsize'] = 'Maximale lengte van de leerlingenlijst';
$string['maxstudentlistsize_desc'] = 'De maximale lengte van de leerlingenlijst met leerlingen die nog een afspraak moeten maken, zoals getoond in het venster voor leraren in de planner. Als er meer leerlingen dan dit aantal zijn, dan zal er geen lijst getoond worden.';
$string['maxstudentsperslot'] = 'Maximaal aantal leerlingen per tijdslot';
$string['maxstudentsperslot_desc'] = 'Groepslots / niet-exclusieve tijdslots kunnen maximaal dit aantal leerlingen bevatten. Merk op dat daar bovenop de instelling "onbeperkt" kan gekozen worden voor een tijdslot.';
$string['meangrade'] = 'Neem het gemiddelde cijfer';
$string['meetingwith'] = 'Afspraak met je';
$string['meetingwithplural'] = 'Afspraak met je';
$string['message'] = 'Bericht';
$string['messagebody'] = 'Berichtinhoud';
$string['messageprovider:bookingnotification'] = 'Melding wanneer een afspraak gemaakt of geannuleerd wordt';
$string['messageprovider:invitation'] = 'Uitnodiging om een tijdslot te boeken';
$string['messageprovider:reminder'] = 'Herinnering aan een komende afspraak';
$string['messagesent'] = 'Bericht verstuurd naar {$a} ontvangers';
$string['messagesubject'] = 'Onderwerp';
$string['minutes'] = 'minuten';
$string['minutesperslot'] = 'minuten per tijdslot';
$string['missingstudents'] = '{$a} leerlingen moeten nog een afspraak maken';
$string['missingstudentsmany'] = '{$a} leerlingen moeten nog een afspraak maken. Er wordt geen lijst getoond omdat het er nog te veel zijn.';
$string['mixindivgroup'] = 'Meng individuele en groepsafspraken';
$string['mixindivgroup_desc'] = 'Wanneer groepsafspraken ingeschakeld zijn ook individuele afspraken toestaan.';
$string['mode'] = 'Modus';
$string['modeappointments'] = 'afspraak(en)';
$string['modeintro'] = 'Leerlingen kunnen het volgende registreren:';
$string['modeoneatatime'] = 'op een tijdstip';
$string['modeoneonly'] = 'in deze planner';
$string['modulename'] = 'Planner';
$string['modulename_help'] = 'De Planner-activiteit helpt je met het inplannen van afspraken met je leerlingen.

Leraren geven tijdssloten op voor afspraken en leerlingen kunnen er dan een kiezen. Leraren kunnen op hun beurt bijhouden wat er tijdens de afspraak gebeurde - optioneel een cijfer - binnen de planner.

Groepsafspraken wordt ook ondersteund. Dit betekent dat elk tijdsslot meerdere leerlingen kan bevatten en het is mogelijk om afspraken te boeken voor hele groepen tegelijk.';
$string['modulename_link'] = 'mod/scheduler/view';
$string['modulenameplural'] = 'Planners';
$string['monday'] = 'Maandag';
$string['multiple'] = '(meerdere)';
$string['myappointments'] = 'Mijn afspraken';
$string['myself'] = 'Mezelf';
$string['name'] = 'Naam planner';
$string['needteachers'] = 'Er kunnen geen tijdslots toegevoegd worden als deze cursus geen leraren heeft';
$string['negativerange'] = 'Bereik is negatief. Dit is niet mogelijk.';
$string['never'] = 'Nooit';
$string['nfiles'] = '{$a} bestanden';
$string['noappointments'] = 'Geen afspraken';
$string['noexistingstudents'] = 'Geen leerlingen beschikbaar voor afspraken';
$string['nogroups'] = 'Geen groepen beschikbaar voor afspraken';
$string['noresults'] = 'Geen resultaten.';
$string['noschedulers'] = 'Er zijn geen planners';
$string['noslots'] = 'Er zijn geen tijdslots voor afspraken meer beschikbaar.';
$string['noslotsavailable'] = 'Er zijn geen tijdslots om afspraken te maken beschikbaar op dit moment.';
$string['noslotsopennow'] = 'Er zijn geen tijdslots open om afspraken te maken op dit moment.';
$string['nostudents'] = 'Er zijn geen leerlingen met afspraken';
$string['nostudenttobook'] = 'Er zijn geen leerlingen om afspraken mee te maken';
$string['note'] = 'Cijfer';
$string['noteacherforslot'] = 'Er zijn geen leraren voor de tijdslots';
$string['noteachershere'] = 'Er is geen leraar beschikbaar';
$string['notenoughplaces'] = 'Sorry, er zijn niet genoeg afspraken in dit tijdslot';
$string['notesrequired'] = 'Je moet tekst in dit veld zetten voor je een afspraak kunt boeken.';
$string['notifications'] = 'Meldingen';
$string['notifications_help'] = 'Wanneer deze optie is ingeschakeld, dan krijgen leerlingen en leraren meldingen wanneer er een afspraak geboekt of geannuleerd wordt.';
$string['notseen'] = 'Niet gezien';
$string['now'] = 'Nu';
$string['occurrences'] = 'Gebeurtenissen';
$string['odsformat'] = 'ODS';
$string['on'] = 'aan';
$string['onedaybefore'] = '1 dag voor de afspraak';
$string['onelineperappointment'] = 'Eén regel per afspraak';
$string['onelineperslot'] = 'Eén regel per tijdslot';
$string['oneslotadded'] = '1 tijdslot toegevoegd';
$string['oneslotdeleted'] = '1 tijdslot verwijderd';
$string['oneweekbefore'] = '1 week voor tijdslot';
$string['onthemorningofappointment'] = 'Op de ochtend van de afspraak';
$string['options'] = 'Opties';
$string['otherstudents'] = 'Andere deelnemers';
$string['outlineappointments'] = 'Aanwezig op {$a->attended} afspraken, nog {$a->upcoming} afspraken volgen.';
$string['outlinegrade'] = 'Cijfer: {$a}.';
$string['overall'] = 'Algemeen';
$string['overlappings'] = 'Sommige tijdslots overlappen';
$string['pageperteacher'] = 'Eén pagina voor elk {$a}';
$string['pagination'] = 'Paginering';
$string['pagination_help'] = 'Kies of de export een aparte pagina voor elke leraar moet hebben. in Excel en in ODS-bestandsopmaak komen deze pagina\'s overeen met werkbladen in het document.';
$string['pdfformat'] = 'PDF';
$string['pdforientation'] = 'PDF pagina-oriëntatie';
$string['pluginadministration'] = 'Beheer planner';
$string['pluginname'] = 'Planner';
$string['portrait'] = 'Rechtop';
$string['preview'] = 'Voorbeeld';
$string['previewlimited'] = '(Voorbeeld is beperkt tot {$a} rijen).';
$string['privacy:metadata:filepurpose'] = 'Bestand, gebruikt in notities voor het tijdslot of afspraak';
$string['privacy:metadata:scheduler_appointment'] = 'Staat voor de afspraak van een leerling in de planner';
$string['privacy:metadata:scheduler_appointment:appointmentnote'] = 'Notitie door de leraar (zichtbaar voor de leerling)';
$string['privacy:metadata:scheduler_appointment:appointmentnoteformat'] = 'Opmaak van de notitie van de leraar';
$string['privacy:metadata:scheduler_appointment:attended'] = 'Of de leerling op de afspraak was';
$string['privacy:metadata:scheduler_appointment:grade'] = 'Cijfer voor de afspraak';
$string['privacy:metadata:scheduler_appointment:studentid'] = 'Leerling die de afspraak maakte';
$string['privacy:metadata:scheduler_appointment:studentnote'] = 'Notitie door de leerling';
$string['privacy:metadata:scheduler_appointment:studentnoteformat'] = 'Opmaak van de notitie van de leerling';
$string['privacy:metadata:scheduler_appointment:teachernote'] = 'Notitie van de leraar (privaat)';
$string['privacy:metadata:scheduler_appointment:teachernoteformat'] = 'Opmaak van de private notitie van de leraar';
$string['privacy:metadata:scheduler_slots'] = 'Staat voor een tijdslot in de planner';
$string['privacy:metadata:scheduler_slots:appointmentlocation'] = 'Locatie van de afspraak';
$string['privacy:metadata:scheduler_slots:duration'] = 'Duur van het tijdslot in minuten';
$string['privacy:metadata:scheduler_slots:exclusivity'] = 'Maximaal aantal leerlingen in het tijdslot';
$string['privacy:metadata:scheduler_slots:notes'] = 'Notities over het tijdslot';
$string['privacy:metadata:scheduler_slots:notesformat'] = 'Opmaak van de notities';
$string['privacy:metadata:scheduler_slots:starttime'] = 'Starttijd van het tijdslot';
$string['privacy:metadata:scheduler_slots:teacherid'] = 'Leraar, geassocieerd met het tijdslot';
$string['purgeunusedslots'] = 'Ongebruikte tijdslots in het verleden verwijderen';
$string['recipients'] = 'Ontvangers';
$string['registeredlbl'] = 'Leerlingen met afspraak';
$string['reminder'] = 'Herinnering';
$string['requireupload'] = 'Bestand uploaden vereist';
$string['resetappointments'] = 'Verwijder afspraken en cijfers';
$string['resetslots'] = 'Verwijder tijdslots';
$string['return'] = 'Terug naar cursus';
$string['revealteachernotes'] = 'Toon lerarennotities in privacy-export';
$string['revealteachernotes_desc'] = 'Als deze optie is ingeschakeld, dan zullen vertrouwelijke notities van leraren (die normaal niet zichtbaar zijn voor leerlingen) getoond worden aan leerlingen wanneer ze een export van hun gegevens vragen via de privacy API. Je moet beslissen op basis van individueel gebruik van dit notitieveld of het al dan niet moet meegegeven worden met een gegevensexport voor leerlingen onder de GDPR.';
$string['revoke'] = 'Afspraak opzeggen';
$string['saturday'] = 'Zaterdag';
$string['save'] = 'Bewaar';
$string['savechoice'] = 'Bewaar mijn keuze';
$string['saveseen'] = 'Bewaar "gezien"';
$string['schedule'] = 'Rooster';
$string['scheduleappointment'] = 'Rooster een afspraak voor $a';
$string['schedulecancelled'] = '{$a}: je afspraak is geannuleerd of verplaatst';
$string['schedulegroups'] = 'Rooster per groep';
$string['scheduleinnew'] = 'Rooster in een nieuw tijdslot';
$string['scheduleinslot'] = 'Rooster in tijdslot';
$string['scheduler'] = 'Planner';
$string['scheduler:addinstance'] = 'Voeg een nieuwe planner toe';
$string['scheduler:appoint'] = 'Boek tijdslots';
$string['scheduler:attend'] = 'Leerlingen aanwezig';
$string['scheduler:canscheduletootherteachers'] = 'Rooster afspraken voor andere leraren';
$string['scheduler:canseeotherteachersbooking'] = 'Bekijk en blader door de afspraken van andere leraren';
$string['scheduler:disengage'] = 'Deze mogelijkheid is verouderd en doet niets meer';
$string['scheduler:editallattended'] = 'Markeer alle leerlingen in alle afspraken als aanwezig / niet aanwezig';
$string['scheduler:editallgrades'] = 'Bewerk cijfers in alle afspraken';
$string['scheduler:editallnotes'] = 'Bewerk afspraaknotities in alle afspraken';
$string['scheduler:manage'] = 'Beheer je tijdslots en afspraken';
$string['scheduler:manageallappointments'] = 'Beheer alle plannergegevens';
$string['scheduler:seeotherstudentsbooking'] = 'Kijk of andere leerlingen een tijdslot geboekt hebben';
$string['scheduler:seeotherstudentsresults'] = 'Kijk resultaten van leerling in een ander tijdslot';
$string['scheduler:seeoverviewoutsideactivity'] = 'Gebruik het overzichtsscherm om alle tijdslots buiten de huidige planner-activiteit te zien.';
$string['scheduler:viewfullslots'] = 'Tijdslots tonen, zelfs als ze al volledig geboekt zijn (in leerlingscherm)';
$string['scheduler:viewslots'] = 'Zie beschikbare tijdslots (in leerlingenscherm)';
$string['schedulestudents'] = 'Plan per leerling';
$string['scopemenu'] = 'Toon tijdslots in {$a}';
$string['scopemenuself'] = 'Toon mijn tijdslots in: {$a}';
$string['search:activity'] = 'Planner - activiteitsinformatie';
$string['seen'] = 'Gezien';
$string['selectedtoomany'] = 'Je hebt teveel tijdslots geselecteerd. Je kunt er niet meer dan {$a} selecteren.';
$string['sendinvitation'] = 'Stuur uitnodiging';
$string['sendmessage'] = 'Stuur bericht';
$string['sendreminder'] = 'Stuur herinnering';
$string['sendreminders'] = 'Stuur e-mail-herinneringen voor aankomende afspraken';
$string['sepcolon'] = 'Dubbele punt';
$string['sepcomma'] = 'Komma';
$string['sepsemicolon'] = 'Puntkomma';
$string['septab'] = 'Tab';
$string['showemailplain'] = 'Toon e-mailadressen in platte tekst';
$string['showemailplain_desc'] = 'Toon in het lerarenscherm van de planner de e-mailadressen van leerlingen die een afspraak nodig hebben in platte tekst, bijkomend aan de mailto:links.';
$string['showparticipants'] = 'Toon deelnemers';
$string['slot'] = 'Tijdslot';
$string['slot_is_just_in_use'] = 'Sorry, deze afspraak is net gekozen door een andere leerling! Probeer nog eens.';
$string['slotdatetime'] = '{$a->shortdatetime} voor {$a->duration} minuten';
$string['slotdatetimelabel'] = 'Datum en tijd';
$string['slotdatetimelong'] = '{$a->date}, {$a->starttime} &ndash; {$a->endtime}';
$string['slotdescription'] = '{$a->status} op {$a->startdate} van {$a->starttime} tot {$a->endtime} in {$a->location} met {$a->facilitator}.';
$string['slots'] = 'Tijdslots';
$string['slotsadded'] = '{$a} tijdslots toegevoegd';
$string['slotsdeleted'] = '{$a} zijn verwijderd';
$string['slottype'] = 'Tijdslottype';
$string['slotupdated'] = '1 tijdslot aangepast';
$string['slotwarning'] = '<strong>Waarschuwing:</strong> Het verplaatsen van dit tijdslot naar de geselecteerde tijd veroorzaakt een conflict met de tijdslot(s) van onderstaande lijst. Kies "negeer planningsconflicten" als je het tijdslot toch wil verplaantsen.';
$string['staffbreakdown'] = 'Per {$a}';
$string['staffrolename'] = 'Rol-naam van de leraar';
$string['staffrolename_help'] = 'Het label voor de rol waarmee leerlingen een afspraak maken. Dit moet niet noodzakelijk een "leraar" zijn.';
$string['start'] = 'Start';
$string['startpast'] = 'Je kunt geen leeg tijdslot starten in het verleden';
$string['statistics'] = 'Statistieken';
$string['student'] = 'Leerling';
$string['studentbreakdown'] = 'Per leerling';
$string['studentcomments'] = 'Bericht leerling';
$string['studentdetails'] = 'Details leerling';
$string['studentfiles'] = 'Geüploade bestanden';
$string['studentmultiselect'] = 'Elke leerling kan slechts één keer geselecteerd worden in dit tijdslot';
$string['studentnote'] = 'Bericht per leerling';
$string['studentprovided'] = 'Leerling: {$a}';
$string['students'] = 'Leerlingen';
$string['sunday'] = 'Zondag';
$string['tab-otherappointments'] = 'Alle afspraken van deze leerling';
$string['tab-otherstudents'] = 'Leerlingen in dit tijdslot';
$string['tab-thisappointment'] = 'Deze afspraak';
$string['teacher'] = 'Leraar';
$string['teachernote'] = 'Vertrouwelijke notities (enkel zichtbaar voor de leraar)';
$string['teachersmenu'] = 'Toon tijdslots voor: {$a}';
$string['thiscourse'] = 'deze cursus';
$string['thisscheduler'] = 'deze planner';
$string['thissite'] = 'de hele site';
$string['thursday'] = 'Donderdag';
$string['timefrom'] = 'Van:';
$string['timerange'] = 'Tijdspanne';
$string['timeto'] = 'Tot:';
$string['totalgrade'] = 'Totaalcijfer';
$string['tuesday'] = 'Dinsdag';
$string['unattended'] = 'Niet aanwezig';
$string['unlimited'] = 'Onbeperkt';
$string['unregisteredlbl'] = 'Leerlingen zonder afspraak';
$string['upcomingslots'] = 'Geplande tijdslots';
$string['updategrades'] = 'Update cijfers';
$string['updatesingleslot'] = 'Lege string';
$string['uploadmaxfiles'] = 'Maximum aantal geüploade bestanden';
$string['uploadmaxfiles_help'] = 'Het maximale aantal bestanden dat een leerling kan uploaden in het boekingsformulier. Een bestand uploaden is optioneel tenzij "Bestand upload vereist" is aangeduid. Indien dit op 0 staat zullen leerlingen geen upload-vak voor bestanden zien.';
$string['uploadmaxfilesglobal'] = 'Maximum aantal geüploade bestanden';
$string['uploadmaxfilesglobal_desc'] = 'Het maximale aantal bestanden dat een leerling kan uploaden in een boekingsformulier. Dit kan verder verminderd worden op het niveau van individuele planners';
$string['uploadmaxsize'] = 'Maximale bestandsgrootte';
$string['uploadmaxsize_help'] = 'Maximale bestandsgrootte voor geüploade bestanden van leerlingen. Deze limiet geldt per bestand.';
$string['uploadrequired'] = 'Je moet hier bestanden uploaden voor je het tijdslot kan boeken.';
$string['uploadstudentfiles'] = 'Uploaden bestanden';
$string['usebookingform'] = 'Gebruik een boekingsfomulier';
$string['usebookingform_help'] = 'Indien ingeschakeld ziet een leerling een apart boekingsscherm voor ze een tijdslot kunnen boeken. Het boekingsscherm kan vragen om gegevens in te geven, bestanden te uploaden of een captcha oplossen. Zie onderstaande opties.';
$string['usebookingform_link'] = 'mod/scheduler/bookingform';
$string['usecaptcha'] = 'Gebruikeen CAPTCHA voor nieuwe boekingen';
$string['usecaptcha_help'] = 'Indien ingeschakeld zullen leerlingen een CAPTCHA met beveiligingsvragen moeten oplossen voor ze een nieuwe afspraak kunnen boeken.
Gebruik deze instelling als je vermoedt dat leerlingen automatische programma\'s gebruiken om de beschikbare tijdslots te vullen.<p>Er zal geen captcha getoond worden als de leerling een bestaande boeking bewerkt.</p>';
$string['usenotes'] = 'Gebruik notities voor afspraken';
$string['usenotesboth'] = 'Beide types notities';
$string['usenotesnone'] = 'geen';
$string['usenotesstudent'] = 'Afsprakennotitie, zichtbaar voor leerling en leraar';
$string['usenotesteacher'] = 'Vertrouwelijke notitie, enkel zichtbaar voor leraren';
$string['usestudentnotes'] = 'Sta leerlingen toe een bericht in te geven';
$string['usestudentnotes_help'] = 'Indien ingeschakeld zal het boekingsscherm een tekstvak bevatten waarin leerlingen een bericht kunnen zetten. Gebruik de boekingsinstructies hierboven om leerlingen duidelijk te maken welke informatie ze moeten voorzien.';
$string['viewbooking'] = 'Zie details';
$string['wednesday'] = 'Woensdag';
$string['welcomebackstudent'] = 'Je kunt een bijkomend tijdslot boeken door te klikken op de onderstaande "Boek tijdslot"-knop.';
$string['welcomenewstudent'] = 'De tabel hieronder toont alle beschikbare tijdslots om een afspraak te kunnen maken. Maak je keuze door te klikken op "Boek dit tijdslot". Je kunt deze pagina opnieuw bezoeken als je later nog iets wil wijzigen.';
$string['welcomenewteacher'] = 'Klik op de knop onderaan om tijdslots voor afspraken toe te voegen';
$string['what'] = 'Wat?';
$string['whathappened'] = 'Wat is er gebeurd?';
$string['whatresulted'] = 'Welk resultaat?';
$string['when'] = 'Wanneer?';
$string['where'] = 'Waar?';
$string['who'] = 'Met wie?';
$string['whosthere'] = 'Wie is daar?';
$string['xdaysbefore'] = '{$a} dagen voor tijdslot';
$string['xweeksbefore'] = '{$a} weken voor tijdslot';
$string['yesallgroups'] = 'Ja, voor alle groepen';
$string['yesingrouping'] = 'Ja, in groepering {$a}';
$string['yesoptional'] = 'Ja, optioneel voor leerling';
$string['yesrequired'] = 'Ja, leerling moet een bericht ingeven';
$string['yourappointmentnote'] = 'Opmerking voor jou bestemd';
$string['yourslotnotes'] = 'Opmerkingen bij de afspraak';
$string['yourstudentnote'] = 'Jouw bericht';
$string['yourtotalgrade'] = 'Jouw totaalcijfer in deze activiteit is <strong>{$a}</strong>.';
