<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_ldap', language 'sr_lt', version '3.11'.
 *
 * @package     auth_ldap
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_ldap_ad_create_req'] = 'Nije moguće kreirati novi nalog u Aktivnom direktorijumu. Proverite da li su ispunjeni svi neophodni preduslovi (LDAP konekcija, vezni korisnik sa odgovarajućim pravima itd.)';
$string['auth_ldap_attrcreators'] = 'Spisak grupa ili koneksta čijim članovima je dozvonjeno da kreiraju atribute. Razdvojite višestruke grupe sa  \';\'. Obično nešto poput \'cn=teachers,ou=staff,o=myorg\'';
$string['auth_ldap_attrcreators_key'] = 'Kreatori atributa';
$string['auth_ldap_auth_user_create_key'] = 'Kreiraj korisnike eksterno';
$string['auth_ldap_bind_dn'] = 'Ako želite da koristite veznog korisnika za pretragu korisnika, odredite to ovde. Nešto nalik na \'cn=ldapuser,ou=public,o=org\'';
$string['auth_ldap_bind_dn_key'] = 'Jedinstveno prepoznatljivo ime';
$string['auth_ldap_bind_pw'] = 'Lozinka za veznog korisnika';
$string['auth_ldap_bind_pw_key'] = 'Lozinka';
$string['auth_ldap_bind_settings'] = 'Podešavanja vezivanje';
$string['auth_ldap_changepasswordurl_key'] = 'URL za promenu lozinke';
$string['auth_ldap_contexts'] = 'Spisak konteksta u kojima se nalaze korisnici. Razdvojite različite kontekste sa \';\'. Na primer: \'ou=users,o=org; ou=others,o=org\'';
$string['auth_ldap_contexts_key'] = 'Konteksti';
$string['auth_ldap_create_context'] = 'Ukoliko omogućite kreiranje korisnika pomoću potvrde putem e-pošte, navedite kontekst u kojem će korisnici biti kreirani. Ovaj kontekst treba da bude različit od drugih korisnika kako bi se sprečili sigurnosni problemi. Ne morate da dodajete ovaj kontekst ldap_context vraijabli. Moodle će tražiti korisnike iz ovog konteksta automatski.<br /><b>Napomena!</b> Morate da izmenite metod user_create() u datoteci auth/ldap/auth.php kako bi ovaj način kreiranje korisnika funckionisao.';
$string['auth_ldap_create_context_key'] = 'Kontekst za nove korisnike';
$string['auth_ldap_create_error'] = 'Greška prilikom kreiranja novog  korisnika u LDAP serveru.';
$string['auth_ldap_expiration_desc'] = 'Izaberite \'{$a->no}\' kako biste onemogućili proveru isteklih lozinki ili \'{$a->ldapserver}\' ako hoćete da vreme isteka lozinke bude pročitano direktno sa LDAP severa.';
$string['auth_ldap_expiration_key'] = 'Provera isteka lozinke';
$string['auth_ldap_expiration_warning_desc'] = 'Koliko dana pre isteka lozinke će biti izdato upozorenje o tome.';
$string['auth_ldap_expiration_warning_key'] = 'Upozorenje o isteku lozinke';
$string['auth_ldap_expireattr_desc'] = 'Opciono: Menja LDAP atribut koji čuva vreme isteka lozinke.';
$string['auth_ldap_expireattr_key'] = 'Atribut isteka lozinke';
$string['auth_ldap_graceattr_desc'] = 'Opciono: Nadjačava produžene prijave atribut';
$string['auth_ldap_gracelogin_key'] = 'Atribut produžene prijave';
$string['auth_ldap_gracelogins_desc'] = 'Omogućite LDAP podršku za prijavu na sajt nakon isteka lozinke. Nakon što lozinka istekne korisnik može pristupati sistemu sve dok je broj dozvoljenih prijava nakon isteka lozinke podešen na 0. Uključivanjem ovog podešavanja, ako je lozinka istekla, biće prikazana poruka o broju dozvoljenih prijava nakon isteka lozinke.';
$string['auth_ldap_gracelogins_key'] = 'Produžene prijave';
$string['auth_ldap_groupecreators'] = 'Spisak grupa ili konteksta čijim članovima je dozvonjeno kreiranje grupa. Razdvojite višestruke grupe sa \';\'. Obično, nešto poput \'cn=teachers,ou=staff,o=myorg\'';
$string['auth_ldap_groupecreators_key'] = 'Kreatori grupa';
$string['auth_ldap_host_url'] = 'Navedite LDAP server u obliku URL adrese, kao npr. ldap://ldap.myorg.com/ ili ldaps://ldap.myorg.com/. Razdvojite više servera sa znakom ; kako biste mogli da obezbedite automatsko prebacivanje na drugi server ukoliko bude problema sa aktivnim serverom.';
$string['auth_ldap_host_url_key'] = 'URL LDAP računara';
$string['auth_ldap_ldap_encoding'] = 'Kodni raspored koji koristi LDAP server, najverovatnije utf-8. Ako je izabran LDAP v2 Aktivni direktorijum koristi svoj konfigurisani kodni raspored, kao što je cp1252 ili cp1250.';
$string['auth_ldap_ldap_encoding_key'] = 'LDAP kodni raspored';
$string['auth_ldap_login_settings'] = 'Podešavanja za prijavljivanje na sistem';
$string['auth_ldap_memberattribute'] = 'Opciono: nadjačava atribut članstva korisnika, kada korisnici pripadaju grupi. Obično \'član\'.\'';
$string['auth_ldap_memberattribute_isdn'] = 'Opciono: Redefiniše rukovanje vrednostima atributa članova.';
$string['auth_ldap_memberattribute_isdn_key'] = 'Atributi člana koristi dn';
$string['auth_ldap_memberattribute_key'] = 'Atributi člana';
$string['auth_ldap_no_mbstring'] = 'Da biste kreirali korisnike u Aktivnom direktorijumu potrebna Vam je mbstring ekstenzija.';
$string['auth_ldap_noconnect'] = 'LDAP-modul nije moguće povezati sa  serverom: {$a}';
$string['auth_ldap_noconnect_all'] = 'LDAP-modul nije moguće povezati sa bilo kojim serverom: {$a}';
$string['auth_ldap_noextension'] = 'Izgleda da PHP LDAP modul nije prisutan. Proverite da li je ovaj modul instaliran i omogućen, ako želite da ga koristite kao dodatak za proveru identiteta.';
$string['auth_ldap_objectclass'] = 'Opciono: Određuje objectClass koja se koristi za imenovanje/pretragu korisnika u ldap_user_type. Obično nema potrebe da ovo menjate.';
$string['auth_ldap_objectclass_key'] = 'Klase objekata';
$string['auth_ldap_opt_deref'] = 'Određuju kako se upravlja alijasima u toku pretrage. Izaberite jednu od sledećih vrednosti:
"Ne" (LDAP_DEREF_NEVER) ili "Da" (LDAP_DEREF_ALWAYS)';
$string['auth_ldap_opt_deref_key'] = 'Dereferenciraj alijase';
$string['auth_ldap_passtype'] = 'Navedite format novr ili promenjene lozinke na LDAP serveru.';
$string['auth_ldap_passtype_key'] = 'Format lozinke';
$string['auth_ldap_passwdexpire_settings'] = 'LDAP podešavanja isteka lozinke';
$string['auth_ldap_preventpassindb'] = 'Izaberite Da kako bi sprečili da se lozinke pohranjuju u bazi podataka Moodlea.';
$string['auth_ldap_preventpassindb_key'] = 'Spreči keširanje lozinke';
$string['auth_ldap_rolecontext'] = '{$a->localname} kontekst';
$string['auth_ldap_rolecontext_help'] = 'LDAP kontekst za koji se koristi za <i>{$a->localname}</i> mapiranje. Više grupa razdvojite sa \';\'. Obično nešto poput "cn={$a->shortname},ou=first-ou-with-role-groups,o=myorg; cn={$a->shortname},ou=second-ou-with-role-groups,o=myorg".';
$string['auth_ldap_search_sub'] = 'Pretraži korisnike iz podkonteksta.';
$string['auth_ldap_search_sub_key'] = 'Pretraži podkontekst';
$string['auth_ldap_server_settings'] = 'Podešavanja LDAP servera';
$string['auth_ldap_suspended_attribute'] = 'Opciono: Kad je na raspolaganju ovaj atribut će se koristiti za aktiviranje/susprendovanje lokalno kreiranog korisničkog naloga.';
$string['auth_ldap_suspended_attribute_key'] = 'Suspendovan atribut';
$string['auth_ldap_unsupportedusertype'] = 'auth: ldap user_create() ne podržava izabrani tip korisnika: {$a}';
$string['auth_ldap_update_userinfo'] = 'Ažurirajte informacije korisnika (ime, prezime, adrese...) iz LDAP-a u Moodle. Specificirajte podešavanja za mapiranje podataka prema sopstvenim potrebama.';
$string['auth_ldap_user_attribute'] = 'Atribut koji se koristi za ime/pretragu korisnika. Uglavnom je \'cn\'.';
$string['auth_ldap_user_attribute_key'] = 'Atributi korisnika';
$string['auth_ldap_user_exists'] = 'LDAP korisničko ime već postoji.';
$string['auth_ldap_user_settings'] = 'Podešavanja za pretraživanje korisnika';
$string['auth_ldap_user_type'] = 'Izaberite kako se korisnici čuvaju u LDAP-u. Ovo podešavanje takođe određuje kako će funkcionisati istek lozinke, broj dozvoljenih prijava nakon isteka lozinke i kreiranje korisnika.';
$string['auth_ldap_user_type_key'] = 'Tip korisnika';
$string['auth_ldap_usertypeundefined'] = 'config.user_type nije definisan ili funkcija ldap_expirationtime2unix ne podržava izabrani tip!';
$string['auth_ldap_usertypeundefined2'] = 'config.user_type nije definisan ili funkcija ldap_unixi2expirationtime ne podržava izabrani tip!';
$string['auth_ldap_version'] = 'Verzija LDAP protokola koju koristi Vaš server';
$string['auth_ldap_version_key'] = 'Verzija';
$string['auth_ldapdescription'] = 'Ovaj metod služi za proveru identiteta od strane spoljašnjeg LDAP servera.
Ako su dodeljeno korisničko ime i lozinka ispravni, Moodle kreira novu instancu korisnika u svojoj bazi podataka.
Ovaj dodatak može da čita korisničke atribute sa LDAP-a i ispuni tražena polja u Moodleu. Prilikom narednih prijava na sistem proveravaće se samo korisničko ime i lozinka.';
$string['auth_ldapextrafields'] = 'Ova polja nisu obavezna. Možete izabrati da ispunite neka Moodle korisnička polja sa informacijama iz <b>LDAP polja</b> koja ovde odredite. <br />Ako polja ostavite prazna, onda se ništa neće prebaciti sa LDAP-a, tako da će biti korišćene podrazumevane Moodle vrednosti.<br />U svakom slučaju, korisnici mogu da uređuju ova polja nakon pristupa sistemu.';
$string['auth_ldapnotinstalled'] = 'Nije moguće koristiti LDAP proveru identiteta.PHP LDAP modul nije instaliran.';
$string['auth_ntlmsso'] = 'NTLM SSO';
$string['auth_ntlmsso_enabled'] = 'Postavite na Da za pokušaj jedne prijave sa NTLM domenom. <strong>Napomena:</strong> da bi ovo radilo, zahtevaju se dodatna podešavanja veb-servera, videti <a href="https://docs.moodle.org/en/NTLM_authentication">http://docs.moodle.org/en/NTLM_authentication</a>';
$string['auth_ntlmsso_enabled_key'] = 'Omogući';
$string['auth_ntlmsso_ie_fastpath'] = 'Postavite na \'Da\' kako biste omogućili NTLM SSO fast path (zaobilazi određene korake ako je Web čitač klijenta MS Internet Explorer).';
$string['auth_ntlmsso_ie_fastpath_attempt'] = 'Pokušati primenu NTLM-a sa svim čitačima';
$string['auth_ntlmsso_ie_fastpath_key'] = 'MS IE brza putanja?';
$string['auth_ntlmsso_ie_fastpath_yesattempt'] = 'Da, pokušaj primenu NTLM-a sa svim čitačima';
$string['auth_ntlmsso_ie_fastpath_yesform'] = 'Da, svi drugi čitači koriste standardnu formu za prijavu';
$string['auth_ntlmsso_maybeinvalidformat'] = 'Nije moguće izvući korisničko ime iz zaglavlja REMOTE_USER. Da li je konfigurisani format ispravan?';
$string['auth_ntlmsso_missing_username'] = 'Morate da navedete barem %username% u formatu udaljenog korisničkog imena';
$string['auth_ntlmsso_remoteuserformat'] = 'Ako ste kao \'Tip provere identiteta\' izabrali \'NTLM\', ovde možete da odredite format udaljenog korisničkog imena. Ako ovo ostavite prazno koristiće se podrazumevani  DOMAIN\\username format. Opciono, možete da koristite rezervisano polje <b>%domain%</b> kako biste odredili gde se pojavljuje naziv domena, i obavezno, rezervisano polje <b>%username%</b> kako biste odredili gde se pojavljuje korisničko ime. <br /><br />Neki od češće korišćenih formata su:
<tt>%domain%\\%username%</tt> (MS Windows default), <tt>%domain%/%username%</tt>, <tt>%domain%+%username%</tt> i, samo <tt>%username%</tt> (ako ne postoji deo sa sa domenom).';
$string['auth_ntlmsso_remoteuserformat_key'] = 'Format udaljenog korisničkog imena';
$string['auth_ntlmsso_subnet'] = 'Ukoliko je podešeno, biće pokušana SSO konekciju samo sa klijentima u ovoj podmreži. Format: xxx.xxx.xxx.xxx/bitmask. Više podmreža razdvojite \',\' (zarezom).';
$string['auth_ntlmsso_subnet_key'] = 'Podmreža';
$string['auth_ntlmsso_type'] = 'Metod provere identiteta konfigurisan na Web serveru za proveru identiteta korisnika (ako ste u dilemi, izaberite NTUM)';
$string['auth_ntlmsso_type_key'] = 'Tip provere identiteta';
$string['cannotmaprole'] = 'Uloga "{$a->rolename}" ne može da bude mapirana zato što je njen skraćeni naziv "{$a->shortname}" predug i/ili sadrži crtice. Kako biste omogućili da uloga bude mapirana skraćeni naziv uloge mora biti smanjen na maksimalno {$a->charlimit} znak(ov)a i sve crtice uklonjene. <a href="{$a->link}">Uredi ulogu</a>';
$string['connectingldap'] = 'Povezivanje sa LDAP serverom...';
$string['connectingldapsuccess'] = 'Povezivanje sa vašim LDAP serverom je uspelo';
$string['creatingtemptable'] = 'Kreiranje privremene tabele {$a}';
$string['diag_contextnotfound'] = 'Kontekst {$a} ne postoji ili ga vezno jedinstveno prepoznatljivo ime (DN) ne može pročitati.';
$string['diag_emptycontext'] = 'Pronađen je prazan kontekst.';
$string['diag_genericerror'] = 'LDAP greška {$a->code} prilikom čitanja {$a->subject}: {$a->message}.';
$string['diag_rolegroupnotfound'] = 'Grupa {$a->group} za ulogu {$a->localname} ne postoji ili ga vezno jedinstveno prepoznatljivo ime (DN) ne može pročitati.';
$string['diag_toooldversion'] = 'Malo je verovatno da moderni LDAP server koristi LDAPv2 protokol. Pogrešna podešavanja mogu da oštete vrednosti u korisničkim poljima. Proverite sa svojim LDAP administratorom.';
$string['didntfindexpiretime'] = 'Funkcija password_expire() nije pronašla vreme isteka';
$string['didntgetusersfromldap'] = 'Nije dobijen nijedan korisnik sa LDAP-a -- greška? -- izlaz';
$string['gotcountrecordsfromldap'] = 'Broj zapisa dobijen sa LDAP-a: {$}';
$string['ldapnotconfigured'] = 'URL adresa LDAP servera trenutno nije konfigursana';
$string['morethanoneuser'] = 'Pronađeno je više od jednog korisničkog zapisa na LDAP-u. Koristi se samo prvi.';
$string['needbcmath'] = 'Potrebna vam je BCMath ekstenzija kako biste koristili proveru isteka lozinke pomoću aktivnog direktorijuma (Active Directory)';
$string['needmbstring'] = 'Za promenu lozinke u аktivnom direktorijumu, potrebna Vam je mbstring ekstenzija';
$string['nodnforusername'] = 'Greška u user_update_password(). Nema DN za: {$a->username}';
$string['noemail'] = 'Pokušaj da vam se pošalje e-poruka nije uspeo!';
$string['notcalledfromserver'] = 'Ne bi trebalo da bude pozivano sa Web servera!';
$string['noupdatestobedone'] = 'Nema ažuriranja koje treba obaviti';
$string['nouserentriestoremove'] = 'Nema korisničkih naloga koje treba ukloniti';
$string['nouserentriestorevive'] = 'Nema korisničkih naloga koje treba ponovo aktivirati';
$string['nouserstobeadded'] = 'Nema korisnika za dodavanje';
$string['ntlmsso_attempting'] = 'Pokušava Single Sign On preko NTLM...';
$string['ntlmsso_failed'] = 'Automatsko prijavljivanje nije uspelo, pokušajte sa običnom stranicom za prijavljivljnje...';
$string['ntlmsso_isdisabled'] = 'NTLM SSO je onemogućen.';
$string['ntlmsso_unknowntype'] = 'Nepoznati ntlmsso tip!';
$string['pagedresultsnotsupp'] = 'LDAP stranični prikaz rezultata nije podržan (vašoj verziji PHP-a nedostaje podrška ili ste podesili Moodle da koristi verziju 2 LDAP protokola ili Moodle ne može da se poveže sa LDAP serverom kako bi video da li je stranični prikaz dostupan).';
$string['pagesize'] = 'Proverite da li je ova vrednost manja od ograničenja vašeg LDAP servera za broj rezultata pretrage po jednoj stranici (maksimalan broj rezultata koji može biti vraćen u jednom upitu)';
$string['pagesize_key'] = 'Veličina stranice';
$string['pluginname'] = 'LDAP server';
$string['pluginnotenabled'] = 'Dodatak nije omogućen!';
$string['privacy:metadata'] = 'Dodatak za proveru identiteta LDAP server ne čuva nikakve lične podatke.';
$string['renamingnotallowed'] = 'Promena imena korisnika nije dozvoljena na LDAP-u';
$string['rootdseerror'] = 'Greška pri slanju upita rootDSE za aktivni direktorijum';
$string['start_tls'] = 'Koristi regularni LDAP servis (port 389) sa TLS šifrovanjem';
$string['start_tls_key'] = 'Koristi TLS';
$string['syncroles'] = 'Sinhronizacija sistemskih uloga iz LDAP-a';
$string['synctask'] = 'Sinhronizacija LDAP korisnika';
$string['systemrolemapping'] = 'Mapiranje sistemskih uloga';
$string['updatepasserror'] = 'Greška u user_update_password(). Kôd greške: {$a->errno}; Tekst greške: {$a->errstring}';
$string['updatepasserrorexpire'] = 'Greška u user_update_password() prilikom čitanja vremena isteka lozinke. Kôd greške: {$a->errno}; Tekst greške: {$a->errstring}';
$string['updatepasserrorexpiregrace'] = 'Greška u user_update_password() prilikom promene isteka lozinka ističe i/ili produžene prijave. Kôd greške: {$a->errno}; Tekst greške: {$a->errstring}';
$string['updateremfail'] = 'Greška prilikon ažuriranja LDAP zapisa. Kôd greške: {$a->errno}; Tekst greške: {$a->errstring}<br/>Ključ ({$a->key}) - stara moodle vrednost: \'{$a->ouvalue}\' nova vrednost: \'{$a->nuvalue}\'';
$string['updateremfailamb'] = 'Nije uspelo ažuriranje LDAP-a sa dvosmislenim poljem {$a->key}; stara moodle vrednost: \'{$a->ouvalue}\', nova vrednost: \'{$a->nuvalue}\'';
$string['updateremfailfield'] = 'Nije uspelo ažuriranje LDAP-a sa nepostojećim poljem (\'{$a->ldapkey}\'). Ključ ({$a->key}) - stara Moodle vrednost: \'{$a->ouvalue}\' nova vrednost: \'{$a->nuvalue}\\';
$string['updateusernotfound'] = 'Nije bilo moguće pronaći korisnika prilokom ažuriranja spoljašnjeg izvora. Slede detaljnije informacije: search base: \'{$a->userdn}\'; search filter: \'(objectClass=*)\'; search attributes: {$a->attribs}';
$string['user_activatenotsupportusertype'] = 'auth: ldap user_activate() ne podržava izabrani tip korisnika: {$a}';
$string['user_disablenotsupportusertype'] = 'auth: ldap user_disable() ne podržava izabrani tip korisnika: {$a}';
$string['useracctctrlerror'] = 'Greška pri dobijanju userAccountControl za {$a}';
$string['userentriestoadd'] = 'Korisnički nalozi koji će biti dodati: {$a}';
$string['userentriestoremove'] = 'Korisnički nalozi koji će biti uklonjeni: {$a}';
$string['userentriestorevive'] = 'Korisnički nalozi koji će biti ponovo aktivirani: {$a}';
$string['userentriestoupdate'] = 'Korisnički nalozi koji će biti ažurirani: {$a}';
$string['usernotfound'] = 'Korisnik nije pronađen u LDAP-u.';
