<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'role', language 'sr_lt', version '3.11'.
 *
 * @package     role
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addinganewrole'] = 'Dodavanje nove uloge';
$string['addrole'] = 'Dodaj novu ulogu';
$string['advancedoverride'] = 'Napredno menjanje uloga';
$string['allow'] = 'Dozvoli';
$string['allowassign'] = 'Dozvoli dodeljivanje uloga';
$string['allowed'] = 'Dozvoljeno';
$string['allowoverride'] = 'Dozvoli menjanje uloga';
$string['allowroletoassign'] = 'Dozvoli korisniku sa ulogom {$a->fromrole} da dodeli ulogu {$a->targetrole}';
$string['allowroletooverride'] = 'Dozvoli korisniku sa ulogom {$a->fromrole} da menja ulogu {$a->targetrole}';
$string['allowroletoswitch'] = 'Dozvoli korisniku sa ulogom {$a->fromrole} da menja uloge u ulogu {$a->targetrole}';
$string['allowroletoview'] = 'Dozvoli korisnicima sa ulogom {$a->fromrole} da vide ulogu {$a->targetrole}';
$string['allowswitch'] = 'Dozvoli prelaske između uloga';
$string['allowview'] = 'Dozvoli ulozi da vidi';
$string['allsiteusers'] = 'Svi korisnici na sajtu';
$string['analytics:listinsights'] = 'Pregled uvida';
$string['analytics:listowninsights'] = 'Pregled sopstvenih uvida';
$string['analytics:managemodels'] = 'Upravljanje modelima';
$string['archetype'] = 'Arhetipska uloga';
$string['archetype_help'] = 'Arhetipska uloga određuje ovlašćenja koja uloga ima kada se resetuje na podrazumevane vrednosti. Ona, takođe, određuje eventualna nova ovlašćenja za ulogu prilikom nadogradnje sajta.';
$string['archetypecoursecreator'] = 'ARHETIP: Kreator kursa';
$string['archetypeeditingteacher'] = 'ARHETIP: Predavač (sa uređivačkim pravima)';
$string['archetypefrontpage'] = 'ARHETIP: Autorizovani korisnik na naslovnoj stranici';
$string['archetypeguest'] = 'ARHETIP: Gost';
$string['archetypemanager'] = 'ARHETIP: Menadžer';
$string['archetypestudent'] = 'ARHETIP: Polaznik';
$string['archetypeteacher'] = 'ARHETIP: Nastavnik (bez uređivačkih prava)';
$string['archetypeuser'] = 'ARHETIP: Autorizovani korisnik';
$string['assignanotherrole'] = 'Dodeli još jednu ulogu';
$string['assignedroles'] = 'Dodeljene uloge';
$string['assignerror'] = 'Greška prilikom dodeljivanja uloge {$a->role} korisniku {$a->user}.';
$string['assignglobalroles'] = 'Dodeli globalne uloge';
$string['assignmentcontext'] = 'Kontekst dodeljivanja uloga';
$string['assignmentoptions'] = 'Opcije dodeljivanja uloga';
$string['assignrole'] = 'Dodeli ulogu';
$string['assignrolenameincontext'] = 'Dodeli ulogu \'{$a->role}\' u {$a->context}';
$string['assignroles'] = 'Dodeli uloge';
$string['assignroles_help'] = 'Dodeljivanjem neke uloge korisniku u konkretnom kontekstu odobravate mu ovlašćenja koja ta uloga podrazumeva, i to za tekući kontekst i sve njemu podređene. Na primer, ako dodelite ulogu polaznika korisniku u okviru nekog kursa, on će tu ulogu imati ne samo na nivou kursa, već i na nivou svih blokova i aktivnosti u okviru tog kursa.';
$string['assignroles_link'] = 'admin/roles/assign';
$string['assignrolesin'] = 'Dodeli uloge u {$a}';
$string['assignrolesrelativetothisuser'] = 'Dodeli uloge u odnosu na ovog korisnika';
$string['backtoallroles'] = 'Povratak na listu svih uloga';
$string['backup:anonymise'] = 'Sakrij korisničke podatke prilikom kreiranja rezervne kopije podataka';
$string['backup:backupactivity'] = 'Rezervna kopija aktivnosti';
$string['backup:backupcourse'] = 'Rezervna kopija kurseva';
$string['backup:backupsection'] = 'Rezervna kopija sekcija';
$string['backup:backuptargetimport'] = 'Rezervna kopija za uvoz';
$string['backup:configure'] = 'Konfigurisanje opcija za kreiranje rezervne kopije';
$string['backup:downloadfile'] = 'Preuzimanje datoteka iz područja rezervnih kopija';
$string['backup:userinfo'] = 'Kreiraj rezervnu kopiju korisničkih podataka';
$string['badges:awardbadge'] = 'Dodeli bedž korisniku';
$string['badges:configurecriteria'] = 'Podešavanje /uređivanje kriterijume za dobijanje bedža';
$string['badges:configuredetails'] = 'Podešavanje /uređivanje informacija o bedžu';
$string['badges:configuremessages'] = 'Konfigurisanje poruka o bedževima';
$string['badges:createbadge'] = 'Kreiraj/kopiraj bedževe';
$string['badges:deletebadge'] = 'Obriši bedževe';
$string['badges:earnbadge'] = 'Zaradite bedž';
$string['badges:manageglobalsettings'] = 'Upravljanje globalnim podešavanjima za bedževe';
$string['badges:manageownbadges'] = 'Pregled i upravljanje svojim dobijenim bedževima';
$string['badges:revokebadge'] = 'Oduzmi bedž korisniku';
$string['badges:viewawarded'] = 'Pregled korisnika koji su zaradili određenu bedž bez mogućnosti  dodele bedža';
$string['badges:viewbadges'] = 'Pregled dostupnih bedževa bez mogućnosti da se zarade';
$string['badges:viewotherbadges'] = 'Pregled  javnih bedževa u profilima drugih korisnika';
$string['block:edit'] = 'Uredi podešavanja bloka';
$string['block:view'] = 'Pregled bloka';
$string['blog:create'] = 'Kreiranje novih blog unosa';
$string['blog:manageentries'] = 'Uređivanje i upravljanje unosima';
$string['blog:manageexternal'] = 'Uređivanje i upravljanje spoljnim blogovima';
$string['blog:search'] = 'Pretraži unose u blog';
$string['blog:view'] = 'Pregled članaka bloga';
$string['blog:viewdrafts'] = 'Pregled nacrta blog članaka';
$string['calendar:manageentries'] = 'Upravljanje proizvoljnim unosima u kalendar';
$string['calendar:managegroupentries'] = 'Upravljanje stavkama vezanim za grupe';
$string['calendar:manageownentries'] = 'Upravljanje sopstvenim unosima u kalendar';
$string['capabilities'] = 'Sposobnosti';
$string['capability'] = 'Sposobnost';
$string['category:create'] = 'Kreiranje kategorija';
$string['category:delete'] = 'Obriši kategorije';
$string['category:manage'] = 'Upravljanje kategorijama';
$string['category:update'] = 'Ažuriraj kategorije';
$string['category:viewcourselist'] = 'Prikaz kategorija i kurseva unutar nje';
$string['category:viewhiddencategories'] = 'Vidi skrivene kategorije';
$string['category:visibility'] = 'Vidi skrivene kategorije';
$string['checkglobalpermissions'] = 'Proveri globalna ovlašćenja';
$string['checkpermissions'] = 'Proveri ovlašćenja';
$string['checkpermissionsin'] = 'Proveri ovlašćenja u {$a}';
$string['checksystempermissionsfor'] = 'Proveri globalna ovlašćenja za {$a->fullname}';
$string['checkuserspermissionshere'] = 'Proveri globalna ovlašćenja za {$a->fullname} koje ima u ovom {$a->contextlevel}';
$string['chooseroletoassign'] = 'Molimo da izaberete ulogu za dodeljivanje';
$string['cohort:assign'] = 'Dodaj i ukloni članove kohorte';
$string['cohort:manage'] = 'Kreiraj, obriši i premesti kohorte';
$string['cohort:view'] = 'Pregled kohorti na nivou sajta';
$string['comment:delete'] = 'Obriši komentare';
$string['comment:post'] = 'Objavi komentare';
$string['comment:view'] = 'Pregled komentara';
$string['competency:competencygrade'] = 'Podesi rangiranje kompetencije';
$string['competency:competencymanage'] = 'Upravljanje okvirima kompetencija';
$string['competency:competencyview'] = 'Prikaži okvire kompetencija';
$string['competency:coursecompetencyconfigure'] = 'Konfigurisanje podešavanja kompetencija kursa';
$string['competency:coursecompetencygradable'] = 'Primanje ocena kompetencija';
$string['competency:coursecompetencymanage'] = 'Upravljanje kompetencija kursa';
$string['competency:coursecompetencyview'] = 'Pregled kompetencija kursa';
$string['competency:evidencedelete'] = 'Obriši dokaz';
$string['competency:plancomment'] = 'Komentar na plan učenja';
$string['competency:plancommentown'] = 'Komentar na sopstveni plan učenja';
$string['competency:planmanage'] = 'Upravljanje planovima učenja';
$string['competency:planmanagedraft'] = 'Upravljanje radnim verzijama planova učenja';
$string['competency:planmanageown'] = 'Upravljanje sopstvenim planovima učenja';
$string['competency:planmanageowndraft'] = 'Upravljanje sopstvenim radnim verzijama planova učenja';
$string['competency:planrequestreview'] = 'Zahtevaj recenziju plana učenja';
$string['competency:planrequestreviewown'] = 'Zahtevaj recenziju sopstvenog plana učenja';
$string['competency:planreview'] = 'Recenziraj plan učenja';
$string['competency:planview'] = 'Prikaži sve planove učenja';
$string['competency:planviewdraft'] = 'Prikaži sve planove učenja';
$string['competency:planviewown'] = 'Prikaži sopstvene planove učenja';
$string['competency:planviewowndraft'] = 'Prikaži sopstvene nacrte planove učenja';
$string['competency:templatemanage'] = 'Upravljanje šablonima planova učenja';
$string['competency:templateview'] = 'Prikaži šablone planova učenja';
$string['competency:usercompetencycomment'] = 'Коментар на корисничку компетенцију';
$string['competency:usercompetencycommentown'] = 'Komentar na sopstvenu korisničku kompetenciju';
$string['competency:usercompetencyrequestreview'] = 'Zahtevaj recenziju korisničke kompetencije';
$string['competency:usercompetencyrequestreviewown'] = 'Zahtevaj recenziju sopstvene korisničke kompetencije';
$string['competency:usercompetencyreview'] = 'Recenziraj korisničku kompetenciju';
$string['competency:usercompetencyview'] = 'Prikaži korisničku kompetenciju';
$string['competency:userevidencemanage'] = 'Upravljanje dokazima o prethodnom učenju';
$string['competency:userevidencemanageown'] = 'Upravljanje sopstvenim dokazima o prethodnom učenju';
$string['competency:userevidenceview'] = 'Prikaži dokaz o prethodnom učenju korisnika';
$string['confirmaddadmin'] = 'Da li stvarno želite da dodate korisnika <strong>{$a}</strong> kao novog administratora sajta?';
$string['confirmdeladmin'] = 'Da li stvarno želite da uklonite korisnika <strong>{$a}</strong> sa spiska administratora sajta?';
$string['confirmroleprevent'] = 'Da li stvarno želite da uklonite <strong>"{$a->role}"</strong> sa spiska dozvoljenih uloga za sposobnost "{$a->cap}" u kontekstu "{$a->context}"?';
$string['confirmroleunprohibit'] = 'Da li stvarno želite da uklonite <strong>"{$a->role}"</strong> sa spiska zabranjenih uloga za sposobnost "{$a->cap}" u kontekstu "{$a->context}"?';
$string['confirmunassign'] = 'Da li ste sigurni da želite da uklonite ovu ulogu ovom korisniku?';
$string['confirmunassignno'] = 'Otkaži';
$string['confirmunassigntitle'] = 'Potvrdi promenu uloge';
$string['confirmunassignyes'] = 'Ukloni';
$string['contentbank:access'] = 'Pristupi banci sadržaja';
$string['contentbank:deleteanycontent'] = 'Obriši sav sadržaj iz banke sadržaja';
$string['contentbank:deleteowncontent'] = 'Izbriši sadržaj iz sopstvene banke sadržaja';
$string['contentbank:downloadcontent'] = 'Preuzmi sadržaj iz banke sadržaja';
$string['contentbank:manageanycontent'] = 'Upravljanje bilo kojim sadržajem iz banke sadržaja';
$string['contentbank:manageowncontent'] = 'Upravljanje sadržajem iz sopstvene banke sadržaja';
$string['contentbank:upload'] = 'Postavi novi sadržaj u banku sadržaja';
$string['contentbank:useeditor'] = 'Kreiranje ili uređivanje sadržaja pomoću editora tipa sadržaja';
$string['contentbank:viewunlistedcontent'] = 'Pogledaj sadržaj iz banke sadržaja koji nije naveden';
$string['context'] = 'Kontekst';
$string['contextrolenotallowed'] = 'Uloga {$a} nije dozvoljena u ovom kontekstu.';
$string['course:activityvisibility'] = 'Sakrij/prikaži aktivnosti';
$string['course:bulkmessaging'] = 'Pošalji poruku većem broju ljudi';
$string['course:changecategory'] = 'Promeni kategoriju kursa';
$string['course:changefullname'] = 'Promeni pun naziv kursa';
$string['course:changeidnumber'] = 'Promeni identifikacioni broj kursa';
$string['course:changelockedcustomfields'] = 'Izmena zaključanih prilagođenih polja';
$string['course:changeshortname'] = 'Promeni skraćeni naziv kursa';
$string['course:changesummary'] = 'Promena rezimea kursa';
$string['course:configurecustomfields'] = 'Konfigurisanje prilagođena polja';
$string['course:configuredownloadcontent'] = 'Konfigurisanje preuzimanje sadržaja kursa';
$string['course:create'] = 'Kreiraj kurseve';
$string['course:creategroupconversations'] = 'Kreira grupnu prepisku';
$string['course:delete'] = 'Obriši kurseve';
$string['course:downloadcoursecontent'] = 'Preuzimanje sadržaja kursa';
$string['course:enrolconfig'] = 'Konfiguši instance upisa na kurseve';
$string['course:enrolreview'] = 'Pregled upisa na kurseve';
$string['course:ignoreavailabilityrestrictions'] = 'Ignoriši ograničenja dostupnosti';
$string['course:ignorefilesizelimits'] = 'Koristi datoteke veće od bilo kog ograničenja za veličinu datoteke';
$string['course:isincompletionreports'] = 'Biće prikazano u izveštajima o završetku';
$string['course:manageactivities'] = 'Upravljanje aktivnostima';
$string['course:managefiles'] = 'Upravljanje datotekama';
$string['course:managegrades'] = 'Upravljanje ocenama';
$string['course:managegroups'] = 'Upravljanje grupama';
$string['course:managescales'] = 'Upravljanje skalama za ocenjivanje';
$string['course:markcomplete'] = 'Označi da su korisnici završili kurs';
$string['course:movesections'] = 'Premesti sekcije';
$string['course:overridecompletion'] = 'Izmeni status završetka aktivnosti';
$string['course:recommendactivity'] = '
Preporučuje aktivnosti u biraču aktivnosti';
$string['course:renameroles'] = 'Preimenuj uloge';
$string['course:request'] = 'Zahtev za otvaranje novog kursa';
$string['course:reset'] = 'Ponovno postavljanje kursa';
$string['course:reviewotherusers'] = 'Pregleda druge korsnike';
$string['course:sectionvisibility'] = 'Kontrola vidljivosti sekcije';
$string['course:setcurrentsection'] = 'Postavljanje trenutno aktivne sekcije';
$string['course:setforcedlanguage'] = 'Obavezan jezik na kurs';
$string['course:tag'] = 'Promeni oznake kursa';
$string['course:togglecompletion'] = 'Ručno označite aktivnosti kao završene';
$string['course:update'] = 'Ažuriranje podešavanja kursa';
$string['course:useremail'] = 'Omogući/onemogući adresu e-pošte';
$string['course:view'] = 'Pregled kurseva bez učesnika';
$string['course:viewcoursegrades'] = 'Pregled ocena na kursevima';
$string['course:viewhiddenactivities'] = 'Pregled skrivenih aktivnosti';
$string['course:viewhiddencourses'] = 'Pregled skrivenih kurseva';
$string['course:viewhiddensections'] = 'Pregled skrivenih sekcija';
$string['course:viewhiddenuserfields'] = 'Pregled skrivenih korisničkih polja';
$string['course:viewparticipants'] = 'Pregled učesnika';
$string['course:viewscales'] = 'Pregled skala za ocenjivanje';
$string['course:viewsuspendedusers'] = 'Pregled suspendovanih korisnika';
$string['course:visibility'] = 'Skrivanje/prikazivanje kurseva';
$string['createrolebycopying'] = 'Kreiranje novih uloga preuzimanje od  {$a}';
$string['createthisrole'] = 'Kreiranje ovih uloga';
$string['currentcontext'] = 'Trenutni kontekst';
$string['currentrole'] = 'Trenutna uloga';
$string['customroledescription'] = 'Prilagođeni opis uloge';
$string['customroledescription_help'] = 'Ako je polje za prilagođeni opis uloge prazno, opisi standardnih uloga se automatski lokalizuju.';
$string['customrolename'] = 'Prilagođeni puni naziv uloge';
$string['customrolename_help'] = 'Ako je polje za prilagođeni naziv uloge prazno, nazivi standardnih uloga se automatski lokalizuju. Morate navesti pun naziv za sve prilagođene uloge.';
$string['defaultrole'] = 'Podrazumevana uloga';
$string['defaultx'] = 'Podrazumevano {$a}';
$string['defineroles'] = 'Definiši uloge';
$string['deletecourseoverrides'] = 'Obriši sve izmene uloga na kursu';
$string['deletelocalroles'] = 'Obriši sve lokalno dodeljene uloge';
$string['deleterolesure'] = '<p>Da li ste sigurni da želite da obrišete ulogu "{$a->name} ({$a->shortname})"?</p><p>Broj korisnika kojima je ova uloga trenutno dodeljena je: {$a->count}.</p>';
$string['deletexrole'] = 'Obriši {$a} ulogu';
$string['duplicaterole'] = 'Kopiraj ulogu';
$string['duplicaterolesure'] = '<p>Da li ste sigurni da želite da duplirate ulogu  "{$a->name} ({$a->shortname})"?</p>';
$string['editingrolex'] = 'Uređivanje uloge \'{$a}\'';
$string['editrole'] = 'Uredi ulogu';
$string['editxrole'] = 'Uredi {$a} ulogu';
$string['errorbadrolename'] = 'Pogrešan naziv uloge';
$string['errorbadroleshortname'] = 'Neispravan skraćeni naziv uloge';
$string['errorexistsrolename'] = 'Naziv uloge već postoji';
$string['errorexistsroleshortname'] = 'Naziv uloge već postoji';
$string['errorroleshortnametoolong'] = 'Skraćeni naziv ne sme biti duži od 100 znakova';
$string['eventcapabilityassigned'] = 'Dodeljena mogućnost';
$string['eventcapabilityunassigned'] = 'Ukinuta mogućnost';
$string['eventroleallowassignupdated'] = 'Dozvoli dodeljivanje uloge';
$string['eventroleallowoverrideupdated'] = 'Dozvoli prepisivanje uloge';
$string['eventroleallowswitchupdated'] = 'Dozvoli menjanje uloge';
$string['eventroleallowviewupdated'] = 'Dozvoli ulozi da vidi';
$string['eventroleassigned'] = 'Uloga dodeljena';
$string['eventrolecapabilitiesupdated'] = 'Sposobnosti uloge ažurirane';
$string['eventroledeleted'] = 'Uloga obrisana';
$string['eventroleunassigned'] = 'Uloga povučena';
$string['eventroleupdated'] = 'Ažurirana uloga';
$string['existingadmins'] = 'Trenutni adimistratori sajta';
$string['existingusers'] = '{$a} postojećih korisnika';
$string['explanation'] = 'Objašnjenje';
$string['export'] = 'Izvezi';
$string['extusers'] = 'Postojeći korisnici';
$string['extusersmatching'] = 'Postojeći korisnici koji odgovaraju \'{$a}\'';
$string['filter:manage'] = 'Upravljanje podešavanjima lokalnih filtera';
$string['frontpageuser'] = 'Autorizovani korisnik na naslovnoj stranici';
$string['frontpageuserdescription'] = 'Svi prijavljeni korisnici na naslovnoj stranici kursa';
$string['globalrole'] = 'Sistemska uloga';
$string['globalroleswarning'] = 'UPOZORENjE! Svaka uloga koju dodelite na ovoj stranici primenjivaće se na korisnike kojima je dodeljena na čitavom sajtu, uključujući i naslovnu stranicu i sve kurseve.';
$string['gotoassignroles'] = 'Idi na Dodeli uloge za ovaj kontekst {$a->contextlevel}';
$string['gotoassignsystemroles'] = 'Idi na Dodeli globalne uloge';
$string['grade:edit'] = 'Edituj ocene';
$string['grade:export'] = 'Izvoz ocena';
$string['grade:hide'] = 'Sakrij/otkrij ocene ili stavke';
$string['grade:import'] = 'Uvoz ocena';
$string['grade:lock'] = 'Zaključaj ocene ili stavke';
$string['grade:manage'] = 'Upravljanje stavkama za ocenjivanje';
$string['grade:managegradingforms'] = 'Upravljanje naprednim metodama ocenjivanja';
$string['grade:manageletters'] = 'Upravljanje slovnim ocenama';
$string['grade:manageoutcomes'] = 'Upravljanje ishodima ocena';
$string['grade:managesharedforms'] = 'Upravljanje šablonima obrazaca za napredno ocenjivanje';
$string['grade:override'] = 'Izmeni ocene';
$string['grade:sharegradingforms'] = 'Deljenje obrasca za napredno ocenjivanje kao šablona';
$string['grade:unlock'] = 'Otključavanje ocena ili stavki';
$string['grade:view'] = 'Pregled sopstvenih ocena';
$string['grade:viewall'] = 'Pregled ocena drugih korisnika';
$string['grade:viewhidden'] = 'Pregled sopstvenih sakrivenih ocena';
$string['h5p:deploy'] = 'Primeni H5P sadržaj';
$string['h5p:setdisplayoptions'] = 'Podesite opcije za prikaz H5P-a';
$string['h5p:updatelibraries'] = 'Upravljanje tipovima H5P sadržaja';
$string['highlightedcellsshowdefault'] = 'Ovlašćenja istaknuta u donjoj tabeli su podrazumevana ovlašćenja za arhetip uloge izabranu gore.';
$string['highlightedcellsshowinherit'] = 'Zasenčene ćelije u donjoj tabeli pokazuju dozvole koje će biti nasleđene. Osim sposobnosti, čija ovlašćenja zapravo želite da promenite, trebalo bi sve ostaviti podešeno na \'Nasleđeno\'.';
$string['inactiveformorethan'] = 'neaktivan više od {$a->timeperiod}';
$string['ingroup'] = 'u grupi "{$a->group}"';
$string['inherit'] = 'Nasleđivanje';
$string['invalidpresetfile'] = 'Nevalidna datoteka sa definicijom uloge';
$string['legacy:admin'] = 'NASLEĐENA ULOGA: Administrator';
$string['legacy:coursecreator'] = 'NASLEĐENA ULOGA: Kreator kursa';
$string['legacy:editingteacher'] = 'NASLEĐENA ULOGA: Predavač (sa uređivačkim pravima)';
$string['legacy:guest'] = 'NASLEĐENA ULOGA: Gost';
$string['legacy:student'] = 'NASLEĐENA ULOGA: Polaznik';
$string['legacy:teacher'] = 'NASLEĐENA ULOGA: Predavač (bez uređivačkih prava)';
$string['legacy:user'] = 'NASLEĐENA ULOGA: Autorizovani korisnik';
$string['legacytype'] = 'Tip nasleđene uloge';
$string['listallroles'] = 'Spisak svih uloga';
$string['localroles'] = 'Lokalno dodeljene uloge';
$string['mainadmin'] = 'Glavni administrator';
$string['mainadminset'] = 'Postavi glavnog administratora';
$string['manageadmins'] = 'Upravljanje administratorima sajta';
$string['manager'] = 'Menadžer';
$string['managerdescription'] = 'Menadžeri mogu da pristupe kursevima i da ih menjaju, ali obično ne učestvuju na njima.';
$string['manageroles'] = 'Upravljanje ulogama';
$string['maybeassignedin'] = 'Vrsta konteksta u kojem ova uloga može biti dodeljena';
$string['morethan'] = 'Više od {$a}';
$string['multipleroles'] = 'Višestruke uloge';
$string['my:configsyspages'] = 'Konfiguriši globalne šablone za stranice \'Kontrolni panel\'';
$string['my:manageblocks'] = 'Upravljanje blokovima na stranici \'Kontrolni panel\'';
$string['neededroles'] = 'Uloge sa ovlašćenjem';
$string['nocapabilitiesincontext'] = 'Nema sposobnosti raspoloživih u ovom kontekstu';
$string['noneinthisx'] = 'Niko za ovaj {$a}';
$string['noneinthisxmatching'] = 'Nijedan korisnik ne odgovara \'{$a->search}\' u ovom kontekstu {$a->contexttype}';
$string['norole'] = 'Bez uloge';
$string['noroleassignments'] = 'Ovaj korisnik nema dodeljenu nijednu ulogu bilo gde na ovom sajtu';
$string['noroles'] = 'Nema uloga';
$string['notabletoassignroleshere'] = 'Administrator nije omogućio dodeljivanje uloga u ovom kontekstu.';
$string['notabletooverrideroleshere'] = 'Niste u mogućnosti da ovde menjate ovlašćenja bilo koje uloge';
$string['notes:manage'] = 'Upravljanje beleškama';
$string['notes:view'] = 'Pregled beleški';
$string['notset'] = 'Nije postavljeno';
$string['novisibleroles'] = 'Nema uloga';
$string['overrideanotherrole'] = 'Izmeni drugu ulogu';
$string['overridecontext'] = 'Izmeni kontekst';
$string['overridepermissions'] = 'Izmeni ovlašćenja';
$string['overridepermissions_help'] = 'Izmena ovlašćenja omogućava da dozvolu odnosno zabranu ozabranih sposobnosti u određenom kontekstu';
$string['overridepermissions_link'] = 'admin/roles/override';
$string['overridepermissionsforrole'] = 'Izmeni ovlašćenja uloge \'{$a->role}\' u {$a->context}';
$string['overridepermissionsin'] = 'Izmeni ovlašćenja u {$a}';
$string['overrideroles'] = 'Izmeni uloge';
$string['overriderolesin'] = 'Izmeni uloge u {$a}';
$string['overrides'] = 'Izmene';
$string['overridesbycontext'] = 'Izmene (prema kontekstu)';
$string['payment:manageaccounts'] = 'Upravljanje nalozima';
$string['payment:viewpayments'] = 'Pregleda uplata';
$string['permission'] = 'Ovlašćenje';
$string['permission_help'] = 'Ovlašćenja predstavljaju podešavanja odgovarajućih sposobnosti. Postoje 4 opcije:

* Nije postavljeno
* Dozvoli - daje se dozvola za izvršavanje određene sposobnosti
* Spreči - Ovlašćenje se uklanja, čak i ako je dopušteno u širem kontekstu
* Zabrani - ovlašćenje se u potpunosti ukida i ne može se promeniti na bilo kom užem (specifičnijem) kontekstu';
$string['permissions'] = 'Ovlašćenja';
$string['permissionsforuser'] = 'Ovlašćenja za korisnika {$a}';
$string['permissionsincontext'] = 'Ovlašćenja u {$a}';
$string['portfolio:export'] = 'Izvezi u portfolio';
$string['potentialusers'] = '{$a} potencijalnih korisnika';
$string['potusers'] = 'Potencijalni korisnici';
$string['potusersmatching'] = 'Potencijalni korisncici koji odgovaraju \'{$a}\'';
$string['prevent'] = 'Spreči';
$string['privacy:metadata:preference:showadvanced'] = 'Upravlja prekidačem dugmeta za napredni režim.';
$string['privacy:metadata:role_assignments'] = 'Dodela uloga';
$string['privacy:metadata:role_assignments:component'] = 'Dodatak odgovoran za dodelu uloga, prazan kada su uloge ručno dodeljene.';
$string['privacy:metadata:role_assignments:itemid'] = 'ID oznaka instance upisa/provere identiteta odgovorne za ovu dodelu uloga';
$string['privacy:metadata:role_assignments:modifierid'] = 'ID oznaka korisnika koji je kreirao ili izmenio dodelu uloge';
$string['privacy:metadata:role_assignments:roleid'] = 'ID oznaka uloge';
$string['privacy:metadata:role_assignments:tableexplanation'] = 'Ova tabela čuva dodeljene uloge u svakom kontekstu.';
$string['privacy:metadata:role_assignments:timemodified'] = 'Datum kada je dodela uloga kreirana ili izmenjena.';
$string['privacy:metadata:role_assignments:userid'] = 'ID oznaka korisnika';
$string['privacy:metadata:role_capabilities'] = 'Sposobnosti uloga';
$string['privacy:metadata:role_capabilities:capability'] = 'Naziv sposobnosti.';
$string['privacy:metadata:role_capabilities:modifierid'] = 'ID oznaka korisnika koji kreirao ili izmenio sposobnost';
$string['privacy:metadata:role_capabilities:permission'] = 'Ovlašćenja za sposobnost: naslediti, dozvoliti, sprečiti ili zabraniti.';
$string['privacy:metadata:role_capabilities:roleid'] = 'ID oznaka uloge';
$string['privacy:metadata:role_capabilities:tableexplanation'] = 'Sposobnosti i izmene sposobnosti za određenu ulogu u određenom kontekstu';
$string['privacy:metadata:role_capabilities:timemodified'] = 'Datum kada je privilegija kreirana ili izmenjena.';
$string['privacy:metadata:role_cohortroles'] = 'Uloge na kohortu';
$string['prohibit'] = 'Zabrani';
$string['prohibitedroles'] = 'Zabranjeno';
$string['question:add'] = 'Dodavanje novih pitanja';
$string['question:config'] = 'Kofigurisanje tipova pitanja';
$string['question:editall'] = 'Uredi sva pitanja';
$string['question:editmine'] = 'Uredi svoja pitanja';
$string['question:flag'] = 'Obeleži (zastavicom) pitanja u toku davanja odgovora na njih';
$string['question:managecategory'] = 'Uredi kategorije pitanja';
$string['question:moveall'] = 'Premesti sva pitanja';
$string['question:movemine'] = 'Premesti svoja pitanja';
$string['question:tagall'] = 'Označite sva pitanja';
$string['question:tagmine'] = 'Označite svoja pitanja';
$string['question:useall'] = 'Koristi sva pitanja';
$string['question:usemine'] = 'Koristi svoja pitanja';
$string['question:viewall'] = 'Pregled svih pitanja';
$string['question:viewmine'] = 'Pregled sopstvenih pitanja';
$string['rating:rate'] = 'Dodaj ocene stavkama';
$string['rating:view'] = 'Pogledaj ukupnu ocenu koju si dobio/la';
$string['rating:viewall'] = 'Pregled svih neobrađenih ocena koje su dali pojedinci';
$string['rating:viewany'] = 'Pregled ukupnih ocena koje je bilo ko dobio';
$string['resetrole'] = 'Resetuj';
$string['resettingrole'] = 'Vraćanje uloge \'{$a}\' na podrazumevane vrednosti';
$string['restore:configure'] = 'Konfigurisanje opcija za restauraciju';
$string['restore:createuser'] = 'Kreiraj korisnike prilikom restauracije';
$string['restore:restoreactivity'] = 'Restauriraj aktivnosti';
$string['restore:restorecourse'] = 'Restauriraj kurseve';
$string['restore:restoresection'] = 'Restauriraj sekcije';
$string['restore:restoretargetimport'] = 'Restauriraj iz datoteka namenjenih uvozu';
$string['restore:rolldates'] = 'Dozvoljeno je promeniti konfiguraciju datuma aktivnosti prilikom restauracije';
$string['restore:uploadfile'] = 'Postavi datoteke u područje za rezervne kopije';
$string['restore:userinfo'] = 'Restauriraj korisničke podatke';
$string['restore:viewautomatedfilearea'] = 'Restauriraj kurseve iz automatski kreiranih rezervnih kopija';
$string['risks'] = 'Rizici';
$string['role:assign'] = 'Dodeljivanje uloga korisnicima';
$string['role:manage'] = 'Kreiranje i upravljanje ulogama';
$string['role:override'] = 'Izmeni ovlašćenja za druge';
$string['role:review'] = 'Pregledaj ovlašćenja drugih korisnika';
$string['role:safeoverride'] = 'Prepravi bezbedne dozvole za ostale';
$string['role:switchroles'] = 'Prebacivanje na druge uloge';
$string['roleallowheader'] = 'Dozvoli ulogu:';
$string['roleallowinfo'] = 'Izaberite ulogu koja će biti dodata spisku dozvoljenih uloga u kontekstu "{$a->context}", capability "{$a->cap}":';
$string['roleassignments'] = 'Dodeljivanje uloga';
$string['roledefinitions'] = 'Definicija uloga';
$string['rolefullname'] = 'Ime';
$string['roleincontext'] = '{$a->role} u {$a->context}';
$string['roleprohibitheader'] = 'Zabranjena uloga';
$string['roleprohibitinfo'] = 'Izaberite ulogu koja će biti dodata spisku zabranjenih uloga u kontekstu "{$a->context}", capability "{$a->cap}":';
$string['rolerepreset'] = 'Koristi predefinisanu ulogu';
$string['roleresetdefaults'] = 'Podrazumevane vrednosti';
$string['roleresetrole'] = 'Koristi ulogu ili arehetip';
$string['rolerisks'] = 'Rizici uloge';
$string['roles'] = 'Uloge';
$string['roles_help'] = 'Uloga predstavlja skup ovlašćenja definisanih na nivou čitavog sistema koje možete da dodelite određenim korisnicima u određenom kontekstu.';
$string['roles_link'] = 'roles';
$string['roleselect'] = 'Odaberi ulogu';
$string['rolesforuser'] = 'Uloge za korisnika {$a}';
$string['roleshortname'] = 'Skraćeni naziv';
$string['roleshortname_help'] = 'Skraćeni naziv uloge je bazični identifikator uloga za koji je dozvoljeno koristiti samo ASCII alfanumeričke znakove.';
$string['roletoassign'] = 'Uloga koja se dodeljuje';
$string['roletooverride'] = 'Uloga koja se menja';
$string['safeoverridenotice'] = 'Napomena: Mogućnosti sa više rizika su zaključane jer Vam je dopušteno da prepravljate jedino bezbedne mogućnosti ovlašćenja.';
$string['search:query'] = 'Izvrši pretragu na nivou sajta';
$string['selectanotheruser'] = 'Izaberi drugog korisnika';
$string['selectauser'] = 'Izaberi korisnika';
$string['selectrole'] = 'Izaberite ulogu';
$string['showallroles'] = 'Prikaz svih uloga';
$string['showthisuserspermissions'] = 'Prikaži ovlašćenja ovog korisnika';
$string['site:accessallgroups'] = 'Pristup svim grupama';
$string['site:approvecourse'] = 'Odobravanje kreiranja kursa';
$string['site:backup'] = 'Kreiranje rezervnih kopija kurseva';
$string['site:config'] = 'Promeni konfiguraciju sajta';
$string['site:configview'] = 'Prikaz hijerarhijske strukture administracije sajta (ali i ne svih stranica unutar nje)';
$string['site:deleteanymessage'] = 'Obriši postojeće poruke na sajtu';
$string['site:deleteownmessage'] = 'Obriši poruke koje je korisnik poslao/primio';
$string['site:doanything'] = 'Dozvoljeno da radi bilo šta';
$string['site:doclinks'] = 'Prikaz linkova ka dokumentima van sajta';
$string['site:forcelanguage'] = 'Izmena jezika kursa';
$string['site:import'] = 'Uvoz drugih kurseva u tekući kurs';
$string['site:maintenanceaccess'] = 'Pristup sajtu dok je u režimu održavanja';
$string['site:manageallmessaging'] = 'Dodaje, uklanja, blokira i deblokira kontakte za sve korisnike';
$string['site:manageblocks'] = 'Upravljanje blokovima na stranici';
$string['site:managecontextlocks'] = 'Upravljanje zamrzavanjem konteksta';
$string['site:messageanyuser'] = 'Zaobilazi parametre korisnika za privatnost za slanje poruka bilo kom korisniku';
$string['site:mnetloginfromremote'] = 'Prijavite se iz udaljene aplikacije putem MNeta';
$string['site:mnetlogintoremote'] = 'Idite do udaljene aplikacije putem MNeta';
$string['site:readallmessages'] = 'Pročitaj sve poruke na sajtu';
$string['site:restore'] = 'Restauriranje kurseva';
$string['site:senderrormessage'] = 'Slanje poruku korisniku podrške sa stranice o grešci';
$string['site:sendmessage'] = 'Pošalji poruku bilo kom korisniku';
$string['site:trustcontent'] = 'Poverenje u bezbednost predatog sadržaja';
$string['site:uploadusers'] = 'Postavi nove korisnike iz datoteke';
$string['site:viewanonymousevents'] = 'Pregled anonimnih događaja u izveštajima';
$string['site:viewfullnames'] = 'Uvek vidi puna imena korisnika';
$string['site:viewparticipants'] = 'Pregled učesnika';
$string['site:viewreports'] = 'Pregled izveštaja';
$string['site:viewuseridentity'] = 'Vidi potpun identitet korisnika na spiskovima';
$string['siteadministrators'] = 'Administratori sajta';
$string['tag:edit'] = 'Uređivanje postojećih oznaka';
$string['tag:editblocks'] = 'Uređivanje blokova na stranicama oznaka';
$string['tag:flag'] = 'Obeleži oznake kao neprimerene';
$string['tag:manage'] = 'Upravljanje svim oznakama';
$string['thisnewrole'] = 'Ova nova uloga';
$string['thisusersroles'] = 'Uloge dodeljene ovom korisniku';
$string['unassignarole'] = 'Nedodeljena uloga {$a}';
$string['unassignconfirm'] = 'Da li stvarno želite da uklonite ulogu "{$a->role}" korisniku "{$a->user}"?';
$string['unassignerror'] = 'Greška prilikom odzimanja uloge {$a->role} korisniku {$a->user}.';
$string['user:changeownpassword'] = 'Promeni sopstvenu lozinku';
$string['user:create'] = 'Kreiraj korisnike';
$string['user:delete'] = 'Obriši korisnike';
$string['user:editmessageprofile'] = 'Uredi korisnički profil za slanje poruka';
$string['user:editownmessageprofile'] = 'Uredi sopstveni profil za slanje poruka';
$string['user:editownprofile'] = 'Uredi svoj korisnički profil';
$string['user:editprofile'] = 'Uređivanje korisničkog profila';
$string['user:ignoreuserquota'] = 'Ignoriši ograničenje korisničke kvote';
$string['user:loginas'] = 'Prijavite se kao drugi korisnik';
$string['user:manageblocks'] = 'Upravljanje blokovima na korisničkim profilima drugih korisnika';
$string['user:manageownblocks'] = 'Upravljanje blokovima na sopstvenom javnom korisničkom profilu';
$string['user:manageownfiles'] = 'Upravljanje datotekama u sopstvenom prostoru za privatne datoteke';
$string['user:managesyspages'] = 'Konfiguriši podrazumevani izgled stranice za javne korisničke profile';
$string['user:readuserblogs'] = 'Pogledaj sve korisničke blogove';
$string['user:readuserposts'] = 'Vidi sve poruke korisnika na foumima';
$string['user:update'] = 'Ažuriraj korisničke profile';
$string['user:viewalldetails'] = 'Pregled svih podataka o korisniku';
$string['user:viewdetails'] = 'Pregled korisničkih profila';
$string['user:viewhiddendetails'] = 'Pregled skrivenih detalja o korisnicima';
$string['user:viewlastip'] = 'Vidi poslednju IP adresu korisnika';
$string['user:viewuseractivitiesreport'] = 'Vidi izveštaje o aktivnostima korisnika';
$string['user:viewusergrades'] = 'Pregled korisničkih ocena';
$string['usersfrom'] = 'Korisnik iz {$a}';
$string['usersfrommatching'] = 'Korisnici iz {$a->contextname} koji odgovaraju \'{$a->search}\'';
$string['usersinthisx'] = 'Korisnici u ovom {$a}';
$string['usersinthisxmatching'] = 'Korisnici u ovom {$a->contexttype} koji odgovaraju \'{$a->search}\'';
$string['userswithrole'] = 'Svi korisnici sa ulogom';
$string['userswiththisrole'] = 'Korisnici sa ulogom';
$string['useshowadvancedtochange'] = 'Upotrebi \'Prikaži napredno\' za promenu';
$string['viewingdefinitionofrolex'] = 'Pregled definicije uloge \'{$a}\'';
$string['viewrole'] = 'Pregled detalja o ulogama';
$string['webservice:createmobiletoken'] = 'Kreiraj token za pristup Web servisu putem mobilnih uređaja';
$string['webservice:createtoken'] = 'Kreiraj token za Web servis';
$string['webservice:managealltokens'] = 'Upravljanje svim tokenima korisničkih veb servisa';
$string['whydoesuserhavecap'] = 'Zašto {$a->fullname} ima sposobnost {$a->capability} u kontekstu {$a->context}?';
$string['whydoesusernothavecap'] = 'Zašto {$a->fullname} nema sposobnost {$a->capability} u kontekstu {$a->context}?';
$string['xroleassignments'] = 'Dodeljene uloge za {$a}';
$string['xuserswiththerole'] = 'Korisnici sa ulogom "{$a->role}"';
