<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'appointment', language 'el', version '3.11'.
 *
 * @package     appointment
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addingappointment'] = 'Προσθήκη ραντεβού...';
$string['addingappointments'] = 'Προσθήκη ραντεβού...';
$string['addingsession'] = 'Προσθήκη μιας νέας συνόδου στο {$a}';
$string['addmanageremailaddress'] = 'Προσθήκη διεύθυνσης ηλε.ταχυδρομείου διευθυντή';
$string['addmanageremailinstruction'] = 'Δεν έχετε προηγουμένως δώσει την διεύθυνση ηλε.ταχυδρομείου του διευθυντή σας. Παρακαλούμε, δώστε την παρακάτω για να εγγραφείτε για αυτή τη σύνοδο.';
$string['addnewfield'] = 'Προσθήκη ενός νέου προσαρμοσμένου πεδίου';
$string['addnewfieldlink'] = 'Δημιουργία ενός νέου προσαρμοσμένου πεδίου';
$string['addremoveattendees'] = 'Προσθήκη/διαγραφή παρόντων';
$string['addsession'] = 'Προσθήκη συνόδου';
$string['addstudent'] = 'Προσθήκη μαθητή';
$string['addtimeframe'] = 'Προσθήκη χρονικού πλαισίου';
$string['advanced'] = 'Προχωρημένα';
$string['alllocations'] = 'Όλες οι τοποθεσίες';
$string['allowcancellations'] = 'Επιτρέπονται ακυρώσεις';
$string['allowcancellations_help'] = 'Εάν επιλεγεί, οι παρόντες μιας συνόδου θα μπορούν να ακυρώνουν τις εγγραφές τους.';
$string['allowcancellationsdefault'] = 'Επιτρέπονται ακυρώσεις από προεπιλογή';
$string['allowcancellationsdefault_help'] = 'Εάν επιλεγεί, η προεπιλεγμένη ρύθμιση, κατά τη δημιουργία νέων συνόδων για αυτήν τη δραστηριότητα, θα είναι να επιτρέπονται ακυρώσεις εγγραφής';
$string['allowwaitlist'] = 'Να επιτρέπεται λίστα αναμονής';
$string['allsessionsin'] = 'Όλες οι σύνοδοι στο {$a}';
$string['alreadysignedup'] = 'Έχετε ήδη εγγραφεί για αυτή την δραστηριότητα ραντεβού.';
$string['answer'] = 'Σύνδεση';
$string['answercancel'] = 'Αποσύνδεση';
$string['appointment'] = 'Ραντεβού';
$string['appointment:addattendees'] = 'Προσθήκη παρόντων σε μια σύνοδο ραντεβού';
$string['appointment:addinstance'] = 'Προσθήκη στιγμιότυπου';
$string['appointment:configurecancellation'] = 'Επιτρέψτε ρυθμίσεις ακυρώσεων εγγραφών, στην προσθήκη/τροποποίηση μιας δραστηριότητας ραντεβού.';
$string['appointment:editsessions'] = 'Προσθήκη, τροποποίηση, αντιγραφή και διαγραφή συνόδων Ραντεβού';
$string['appointment:managecustomfields'] = 'Διαχείριση προσαρμοσμένων πεδίων για σύνοδο Ραντεβού.';
$string['appointment:overbook'] = 'Εγγραφείτε σε πλήρεις συνόδους που δεν έχουν ενεργοποιημένη λίστα αναμονής.';
$string['appointment:removeattendees'] = 'Αφαίρεση παρόντων από μια σύνοδο Ραντεβού';
$string['appointment:signup'] = 'Εγγραφή για μια σύνοδο';
$string['appointment:takeattendance'] = 'Δήλωση παρουσιών';
$string['appointment:view'] = 'Εμφάνιση δραστηριοτήτων και συνόδων ραντεβού';
$string['appointment:viewattendees'] = 'Εμφάνιση της λίστας παρόντων και των παρόντων';
$string['appointment:viewcancellations'] = 'Εμφάνιση ακυρώσεων';
$string['appointmentactivity'] = 'Δραστηριότητα ραντεβού';
$string['appointmentbooking'] = 'Κράτηση για ραντεβού';
$string['appointmentcustomfields'] = 'Προσαρμοσμένα πεδία ραντεβού';
$string['appointmentname'] = 'Όνομα ραντεβού';
$string['appointments'] = 'Ραντεβού';
$string['appointmentsession'] = 'Σύνοδος ραντεβού';
$string['appointmentsessions'] = 'Σύνοδοι ραντεβού';
$string['appointmentsettings'] = 'Ρυθμίσεις ραντεβού';
$string['approvalreqd'] = 'Απαιτείται έγκριση';
$string['approvalreqd_help'] = 'Όταν το «Απαιτείται έγκριση» είναι επιλεγμένο, ένας μαθητευόμενος θα χρειάζεται έγκριση από τον διευθυντή του για να του επιτραπεί να παρακολουθήσει μια σύνοδο Ραντεβού.';
$string['approve'] = 'Έγκριση';
$string['assessmentyour'] = 'Η αξιολόγησή σας';
$string['attendance'] = 'Παρουσίες';
$string['attendanceinstructions'] = 'Επιλογή χρηστών που παρακολούθησαν την σύνοδο:';
$string['attendedsession'] = 'Παρακολούθησε ενότητα.';
$string['attendees'] = 'Παρακολουθούντες';
$string['attendeestablesummary'] = 'Άνθρωποι που σχεδιάζουν να ή έχουν ήδη παρακολουθήσει αυτή την σύνοδο.';
$string['availableseats'] = '{$a} θέσεις διαθέσιμες';
$string['book'] = 'Κράτηση';
$string['booked'] = 'Έγινε κράτηση';
$string['bookedvscapacity'] = 'Κρατήσεις / Χωρητικότητα';
$string['bookingcancelled'] = 'Η κράτησή σας ακυρώθηκε.';
$string['bookingcompleted'] = 'Η κράτησή σας έχει ολοκληρωθεί.';
$string['bookingfull'] = 'Πλήρες';
$string['bookingopen'] = 'Άνοιγμα';
$string['break'] = 'Διάλλειμα';
$string['break_help'] = 'Αυτή η ρύθμιση καθορίζει τον χρόνο διακοπής μεταξύ των συνόδων. Η τιμή 0 σημαίνει ότι δεν απαιτείται διακοπή.';
$string['calendareventdescriptionbooking'] = 'Έχετε κράτηση για αυτή τη <a href="{$a}">Σύνοδο Ραντεβού</a>.';
$string['calendareventdescriptionsession'] = 'Δημιουργήσατε αυτή τη <a href="{$a}">Σύνοδο Ραντεβού</a>.';
$string['calendaroptions'] = 'Επιλογές ημερολογίου';
$string['cancel'] = 'Άκυρο';
$string['cancelbooking'] = 'Ακύρωση κράτησης';
$string['cancelbookingfor'] = 'Ακύρωση κράτησης για τον/την {$a}';
$string['cancellation'] = 'Ακύρωση';
$string['cancellationconfirm'] = 'Σίγουρα θέλετε να ακυρώσετε την κράτησή σας σε αυτή την σύνοδο;';
$string['cancellationinstrmngr'] = '# Ειδοποίηση για διευθυντή';
$string['cancellationinstrmngr_help'] = 'Όταν επιλεγεί **Αποστολή ειδοποίησης στον διευθυντή**, το κείμενο στο πεδίο **Ειδοποίηση για διευθυντή** αποστέλλεται στον διευθυντή του μαθητευόμενου, πληροφορώντας τον ότι μία κράτηση για μια σύνοδο Ραντεβού ακυρώθηκε.';
$string['cancellationmessage'] = 'Μήνυμα ακύρωσης';
$string['cancellationmessage_help'] = 'Αυτό το μήνυμα αποστέλλεται όποτε κάποιος χρήστης ακυρώνει την κράτησή του για μια σύνοδο.';
$string['cancellations'] = 'Ακυρώσεις';
$string['cancellationsent'] = 'Θα πρέπει να λάβετε αμέσως ένα μήνυμα ακύρωσης.';
$string['cancellationsentmgr'] = 'Εσείς και ο διευθυντής σας θα πρέπει να λάβετε αμέσως ένα μήνυμα ακύρωσης.';
$string['cancellationstablesummary'] = 'Λίστα ατόμων που ακύρωσαν τις εγγραφές τους σε σύνοδο.';
$string['cancelreason'] = 'Αιτία ακύρωσης';
$string['cannotapproveatcapacity'] = 'Δεν μπορείτε να εγκρίνετε άλλους παρόντες καθώς αυτή η σύνοδος είναι πλήρης.';
$string['cannotsignupsessioninprogress'] = 'Δεν μπορείτε να εγγραφείτε! Αυτή η σύνοδος είναι σε εξέλιξη.';
$string['cannotsignupsessionover'] = 'Δεν μπορείτε να εγγραφείτε! Αυτή η σύνοδος έχει τελειώσει.';
$string['capacity'] = 'Χωρητικότητα';
$string['changemanageremailaddress'] = 'Αλλαγή διεύθυνσης ηλε.ταχυδρομείου διευθυντή';
$string['changemanageremailinstruction'] = 'Παρακαλούμε, δώστε παρακάτω την διεύθυνση ηλε.ταχυδρομείου του διευθυντή σας.';
$string['clearall'] = 'Καθαρισμός όλων';
$string['closed'] = 'Έκλεισε';
$string['completionbooked'] = 'Ο μαθητής πρέπει να κλείσει ένα ραντεβού για να ολοκληρώσει αυτή τη δραστηριότητα';
$string['completiondetail:booked'] = 'Κλείσιμο ενός ραντεβού';
$string['confirm'] = 'Επιβεβαίωση';
$string['confirmation'] = 'Επιβεβαίωση';
$string['confirmationinstrmngr'] = '# Ειδοποίηση για διευθυντή';
$string['confirmationinstrmngr_help'] = 'Όταν επιλεγεί «Αποστολή ειδοποίησης στον διευθυντή», το κείμενο στο πεδίο «Ειδοποίηση για διευθυντή» αποστέλλεται σε έναν διευθυντή, πληροφορώντας τον ότι ένα μέλος του προσωπικού έχει εγγραφεί για μια σύνοδο Ραντεβού.';
$string['confirmationmessage'] = 'Μήνυμα επιβεβαίωσης';
$string['confirmationmessage_help'] = 'Αυτό το μήνυμα αποστέλλεται όποτε κάποιος χρήστης κάνει κράτηση για μια σύνοδο.';
$string['confirmationsent'] = 'Θα πρέπει να λάβετε αμέσως ένα μήνυμα ηλε.ταχυδρομείου επιβεβαίωσης.';
$string['confirmationsentmgr'] = 'Εσείς και ο διευθυντής σας θα πρέπει να λάβετε αμέσως ένα μήνυμα ηλε.ταχυδρομείου επιβεβαίωσης.';
$string['confirmcancelbooking'] = 'Επιβεβαίωση ακύρωσης';
$string['confirmmanageremailaddress'] = 'Επιβεβαίωση διεύθυνσης ηλε.ταχυδρομείου διευθυντή';
$string['confirmmanageremailaddressquestion'] = 'Είναι ακόμα η διεύθυνση <b>{$a}</b> η διεύθυνση ηλε.ταχυδρομείου του διευθυντή σας;';
$string['confirmmanageremailinstruction1'] = 'Δώσατε προηγούμενα την ακόλουθη ως διεύθυνση ηλε.ταχυδρομείου του διευθυντή σας:';
$string['confirmmanageremailinstruction2'] = 'Είναι ακόμη αυτή η διεύθυνση ηλε.ταχυδρομείου του διευθυντή σας;';
$string['continuetologin'] = 'Κάντε κλικ για να συνδεθείτε';
$string['copy'] = 'Αντίγραφο';
$string['cost'] = 'Κόστος';
$string['costheading'] = 'Κόστος συνόδου';
$string['courseresetsessions'] = 'Διαγραφή όλων των συνόδων';
$string['courseresetsignups'] = 'Διαγραφή όλων των εγγραφών σε συνόδους';
$string['crontask'] = 'Εργασίες συντήρησης του αρθρώματος Ραντεβού';
$string['currentstatus'] = 'Τρέχουσα κατάσταση';
$string['customfieldsheading'] = 'Προσαρμοσμένα πεδία συνόδου';
$string['customisednotifications'] = 'Προσαρμοσμένες ειδοποιήσεις';
$string['date'] = 'Ημερομηνία';
$string['dateadd'] = 'Προσθήκη μιας νέας ημερομηνίας';
$string['dateremove'] = 'Διαγραφή αυτής της ημερομηνίας';
$string['datesignedup'] = 'Ημερομηνία εγγραφής';
$string['datetext'] = 'Είστε εγγεγραμμένος για την ημερομηνία';
$string['decidelater'] = 'Απόφαση αργότερα';
$string['decline'] = 'Άρνηση';
$string['delete'] = 'Διαγραφή';
$string['deleteall'] = 'Διαγραφή όλων';
$string['deleteappointment'] = 'Διαγραφή ραντεβού';
$string['deleteappointmentconfirm'] = 'Σίγουρα θέλετε διαγραφή αυτού του ραντεβού και όλων των κρατήσεών του;';
$string['deletedate'] = 'Διαγραφή ημερομηνίας';
$string['deletesession'] = 'Διαγραφή συνόδου';
$string['deletetimeframe'] = 'Διαγραφή χρονικού πλαισίου';
$string['deletingsession'] = 'Διαγραφή συνόδου σε {$a}...';
$string['description'] = 'Κείμενο εισαγωγής';
$string['description_help'] = '**Περιγραφή** είναι η περιγραφή του μαθήματος που εμφανίζεται όταν ο μαθητευόμενος εγγράφεται σε μια σύνοδο Ραντεβού.

Η **Περιγραφή** επίσης εμφανίζεται και στο ημερολόγιο εκπαίδευσης/κατάρτισης.';
$string['details'] = 'Λεπτομέρειες';
$string['discountcode'] = 'Κωδικός έκπτωσης';
$string['discountcodelearner'] = 'Κωδικός έκπτωσης';
$string['discountcodelearner_help'] = 'Εάν γνωρίζετε τον κωδικό έκπτωσης εισαγάγετέ τον εδώ. Εάν αφήσετε αυτό το πεδίο κενό, θα χρεωθείτε με το κανονικό κόστος για αυτό το γεγονός';
$string['discountcost'] = 'Κόστος έκπτωσης';
$string['due'] = 'οφείλεται/έληξε';
$string['duplicate'] = 'Διπλότυπο';
$string['duplicateappointment'] = 'Διπλότυπο ραντεβού';
$string['duration'] = 'Διάρκεια';
$string['early'] = '{$a} νωρίς';
$string['edit'] = 'Τροποποίηση';
$string['editappointment'] = 'Τροποποίηση ραντεβού';
$string['editingappointment'] = 'Τροποποίηση ραντεβού...';
$string['editingsession'] = 'Τροποποίηση συνόδου σε {$a}...';
$string['editsession'] = 'Τροποποίηση συνόδου';
$string['email:instrmngr'] = 'Ειδοποίηση για τον διευθυντή';
$string['email:message'] = 'Μήνυμα';
$string['email:subject'] = 'Αντικείμενο';
$string['emailmanager'] = 'Αποστολή ειδοποίησης στον διευθυντή';
$string['emailmanagercancellation'] = '# Αποστολή ειδοποίησης στον διευθυντή';
$string['emailmanagercancellation_help'] = 'Όταν επιλεγεί «Αποστολή ειδοποίησης στον διευθυντή», ένα μήνυμα ηλε.ταχυδρομείου αποστέλλεται στον διευθυντή του μαθητευόμενου, πληροφορώντας τον ότι η κράτηση για την σύνοδο Ραντεβού ακυρώθηκε.';
$string['emailmanagerconfirmation'] = '# Αποστολή ειδοποίησης στον διευθυντή';
$string['emailmanagerconfirmation_help'] = 'Όταν επιλεγεί «Αποστολή ειδοποίησης στον διευθυντή», ένα μήνυμα ηλε.ταχυδρομείου επιβεβαίωσης αποστέλλεται στον διευθυντή του μαθητευόμενου, όταν ο μαθητευόμενος έχει εγγραφεί για μια σύνοδο Ραντεβού.';
$string['emailmanagerreminder'] = '# Αποστολή ειδοποίησης στον διευθυντή';
$string['emailmanagerreminder_help'] = 'Όταν επιλεγεί «Αποστολή ειδοποίησης στον διευθυντή», ένα μήνυμα ηλε.ταχυδρομείου υπενθύμισης θα σταλεί στον διευθυντή του μαθητευόμενου λίγες ημέρες πριν την ημερομηνία έναρξης της συνόδου Ραντεβού.';
$string['empty'] = 'Κενό';
$string['emptylocation'] = 'Η τοποθεσία ήταν κενή';
$string['enablewaitlist'] = 'Ενεργοποίηση λίστας αναμονής';
$string['endtime'] = 'Τέλος χρόνου';
$string['enrolled'] = 'εγγεγραμμένος';
$string['entitiyappointment'] = 'Ραντεβού';
$string['entitiysession'] = 'Σύνοδος';
$string['error:addalreadysignedupattendee'] = 'Ο/Η είναι ήδη εγγεγραμμένος για αυτή τη δραστηριότητα ραντεβού.';
$string['error:addattendee'] = 'Αδυναμία προσθήκης {$a} στην σύνοδο.';
$string['error:appointmentfailedupdatestatus'] = 'Το ραντεβού απέτυχε να ενημερώσει την κατάσταση του χρήστη';
$string['error:cancelbooking'] = 'Παρουσιάστηκε κάποιο πρόβλημα στην ακύρωση της κράτησής σας';
$string['error:cancellationsnotallowed'] = 'Δεν επιτρέπεται να ακυρώσετε αυτή την εγγραφή.';
$string['error:cannotconfigurecustomfields'] = 'Δεν σας επιτρέπεται η διαμόρφωση προσαρμοσμένων πεδίων.';
$string['error:cannotsendconfirmationmanager'] = 'Ένα μήνυμα επιβεβαίωσης στάλθηκε στην διεύθυνση ηλε.ταχυδρομείου σας, αλλά παρουσιάστηκε κάποιο πρόβλημα στην αποστολή του μηνύματος επιβεβαίωσης στην διεύθυνση ηλε.ταχυδρομείου του διευθυντή σας.';
$string['error:cannotsendconfirmationthirdparty'] = 'Ένα μήνυμα επιβεβαίωσης στάλθηκε στην διεύθυνση ηλε.ταχυδρομείου σας και στην διεύθυνση ηλε.ταχυδρομείου του διευθυντή σας, αλλά παρουσιάστηκε κάποιο πρόβλημα στην αποστολή του μηνύματος επιβεβαίωσης στην διεύθυνση ηλε.ταχυδρομείου του τρίτου μέρους.';
$string['error:cannotsendconfirmationuser'] = 'Παρουσιάστηκε κάποιο πρόβλημα στην αποστολή του μηνύματος επιβεβαίωσης στην διεύθυνση ηλε.ταχυδρομείου σας.';
$string['error:cannotsendconfirmationusermanager'] = 'Αποτυχία αποστολής ενός μηνύματος επιβεβαίωσης στην διεύθυνση ηλε.ταχυδρομείου σας και στην διεύθυνση ηλε.ταχυδρομείου του διευθυντή σας.';
$string['error:cannotsendrequestmanager'] = 'Παρουσιάστηκε κάποιο πρόβλημα κατά την αποστολή του μηνύματος με το αίτημα εγγραφής στην διεύθυνση ηλε.ταχυδρομείου του διευθυντή σας.';
$string['error:cannotsendrequestuser'] = 'Παρουσιάστηκε ένα πρόβλημα κατά την αποστολή του μηνύματος με το αίτημα εγγραφής στην διεύθυνση ηλε.ταχυδρομείου σας.';
$string['error:canttakeattendanceforunstartedsession'] = 'Δεν μπορούν να καταγραφούν οι παρόντες για μια σύνοδο που δεν έχει αρχίσει ακόμα.';
$string['error:couldnotaddfield'] = 'Αδυναμία προσθήκης προσαρμοσμένου πεδίου συνόδου.';
$string['error:couldnotaddsession'] = 'Αδυναμία προσθήκης συνόδου';
$string['error:couldnotaddtrainer'] = 'Αδυναμία αποθήκευσης εκπαιδευτή νέας συνόδου ραντεβού';
$string['error:couldnotcopysession'] = 'Αδυναμία αντιγραφής συνόδου';
$string['error:couldnotdeletefield'] = 'Αδυναμία διαγραφής προσαρμοσμένου πεδίου συνόδου';
$string['error:couldnotdeletesession'] = 'Αδυναμία διαγραφής συνόδου';
$string['error:couldnotdeletetrainer'] = 'Αδυναμία διαγραφής ενός εκπαιδευτή συνόδου ραντεβού';
$string['error:couldnotfindsession'] = 'Αδυναμία εύρεσης της νεοεισαχθείσας συνόδου';
$string['error:couldnotsavecustomfield'] = 'Αδυναμία αποθήκευσης προσαρμοσμένου πεδίου';
$string['error:couldnotupdateappointmentrecord'] = 'Αδυναμία ενημέρωσης της εγγραφής στην βάση δεδομένων για εγγραφή σε ραντεβού';
$string['error:couldnotupdatecalendar'] = 'Αδυναμία ενημέρωσης γεγονότος συνόδου στο ημερολόγιο.';
$string['error:couldnotupdatefield'] = 'Αδυναμία ενημέρωσης προσαρμοσμένου πεδίου συνόδου.';
$string['error:couldnotupdatemanageremail'] = 'Αδυναμία ενημέρωσης διεύθυνσης ηλε.ταχυδρομείου διευθυντή.';
$string['error:couldnotupdatesession'] = 'Αδυναμία ενημέρωσης συνόδου';
$string['error:coursemisconfigured'] = 'Το μάθημα έχει μη έγκυρες ρυθμίσεις';
$string['error:cronprefix'] = 'Σφάλμα: Ραντεβού cron:';
$string['error:emptylocation'] = 'Η τοποθεσία ήταν κενή.';
$string['error:emptymanageremail'] = 'Κενή διεύθυνση ηλε.ταχυδρομείου διευθυντή.';
$string['error:emptyvenue'] = 'Ο τόπος ήταν κενός.';
$string['error:enrolmentfailed'] = 'Αδυναμία εγγραφής {$a} στο μάθημα.';
$string['error:eventoccurred'] = 'Δεν μπορείτε να ακυρώσετε ένα γεγονός που έχει ήδη συμβεί.';
$string['error:fieldidincorrect'] = 'Το αναγνωριστικό πεδίου είναι λανθασμένο: {$a}';
$string['error:incorrectappointmentid'] = 'Το αναγνωριστικό ραντεβού ήταν λανθασμένο';
$string['error:incorrectcoursemodule'] = 'Το άρθρωμα μαθήματος είναι λανθασμένο';
$string['error:incorrectcoursemoduleid'] = 'Το αναγνωριστικό αρθρώματος μαθήματος είναι λανθασμένο';
$string['error:incorrectcoursemodulesession'] = 'Η σύνοδος ραντεβού αρθρώματος μαθήματος ήταν λανθασμένη';
$string['error:incorrectnotificationtype'] = 'Δόθηκε λανθασμένος τύπος ειδοποίησης';
$string['error:invaliduserid'] = 'Μη έγκυρο αναγνωριστικό χρήστη';
$string['error:manageremailaddressmissing'] = 'Αυτήν τη στιγμή δεν έχετε ανατεθεί σε κάποιον διαχειριστή του συστήματος. Παρακαλούμε, επικοινωνήστε με τον διαχειριστή του ιστότοπου.';
$string['error:mustspecifycoursemoduleappointment'] = 'Πρέπει να καθορίσετε ένα άρθρωμα μαθήματος ή ένα αναγνωριστικό ραντεβού';
$string['error:nomanageremail'] = 'Δεν δώσατε διεύθυνση ηλε.ταχυδρομείου για τον διευθυντή σας';
$string['error:nomanagersemailset'] = 'Δεν ορίστηκε καμία διεύθυνση ηλε.ταχυδρομείου διευθυντή';
$string['error:nopermissiontosignup'] = 'Δεν έχετε δικαίωμα να εγγραφείτε σε αυτήν τη σύνοδο Ραντεβού.';
$string['error:noticeidincorrect'] = 'Το αναγνωριστικό σημείωσης είναι λανθασμένο: {$a}';
$string['error:problemsigningup'] = 'Παρουσιάστηκε κάποιο πρόβλημα κατά την εγγραφή σας.';
$string['error:removeattendee'] = 'Αδυναμία διαγραφής {$a} από την σύνοδο.';
$string['error:sessionsplitexceeds'] = 'Ο χρόνος διαχωρισμού συνόδου υπερβαίνει την διάρκεια της συνόδου.';
$string['error:sessionstartafterend'] = 'Ο ώρα έναρξης συνόδου είναι μετά τη λήξη της.';
$string['error:shortnametaken'] = 'Υπάρχει ήδη προσαρμοσμένο πεδίο με αυτό το σύντομο όνομα.';
$string['error:unknownbuttonclicked'] = 'Καμία ενέργεια δεν έχει συσχετιστεί με το πλήκτρο που πατήθηκε';
$string['errorcannoteditsessions'] = 'Δεν έχετε δικαίωμα να τροποποιήσετε συνόδους';
$string['errorcannotmanagecustomfields'] = 'Δεν σας επιτρέπεται η διαχείριση προσαρμοσμένων πεδίων.';
$string['errorcannotviewappointment'] = 'Δεν έχετε δικαίωμα να δείτε αυτό το ραντεβού.';
$string['errorcannotviewattendees'] = 'Δεν έχετε δικαίωμα να δείτε τους παρόντες';
$string['errornosessionid'] = 'Δεν δόθηκε αναγνωριστικό συνόδου.';
$string['errornosstartdate'] = 'Δεν δόθηκε ημερομηνία έναρξης.';
$string['errornosstarttime'] = 'Δεν δόθηκε ώρα έναρξης.';
$string['eventaddsession'] = 'Η σύνοδος προστέθηκε';
$string['eventaddsessionfailed'] = 'Προσθήκη συνόδου (ΑΠΟΤΥΧΙΑ)';
$string['eventapproverequests'] = 'Αιτήματα έγκρισης συνόδου';
$string['eventattendancetaken'] = 'Οι παρουσίες συνόδου καταγράφηκαν';
$string['eventattendeesviewed'] = 'Οι παρουσίες συνόδου προβλήθηκαν';
$string['eventcancelbooking'] = 'Ακύρωση κράτησης συνόδου';
$string['eventcancelbookingfailed'] = 'Ακύρωση κράτησης συνόδου (ΑΠΟΤΥΧΙΑ)';
$string['eventcourseappointmentviewed'] = 'Τα στιγμιότυπα ραντεβού μαθήματος εμφανίστηκαν';
$string['eventcoursemoduleviewed'] = 'Το στιγμιότυπο αρθρώματος ραντεβού εμφανίστηκε';
$string['eventdeletesession'] = 'Η σύνοδος διαγράφηκε';
$string['eventdeletesessionfailed'] = 'Διαγραφή συνόδου (ΑΠΟΤΥΧΙΑ)';
$string['eventsignup'] = 'Εγγραφή στη σύνοδο';
$string['eventsignupfailed'] = 'Εγγραφή στη σύνοδο (ΑΠΟΤΥΧΙΑ)';
$string['eventtakeattendancefailed'] = 'Λήψη παρουσιών συνόδου (ΑΠΟΤΥΧΙΑ)';
$string['eventupdatemanageremailfailed'] = 'Ενημέρωση διεύθυνσης ηλε.ταχυδρομείου (ΑΠΟΤΥΧΙΑ)';
$string['eventupdatesession'] = 'Η σύνοδος ενημερώθηκε';
$string['eventupdatesessionfailed'] = 'Ενημέρωση συνόδου (ΑΠΟΤΥΧΙΑ)';
$string['excelformat'] = 'Excel';
$string['export'] = 'Εξαγωγή';
$string['exportattendance'] = 'Εξαγωγή παρουσιών';
$string['exporttofile'] = 'Εξαγωγή σε αρχείο';
$string['feedback'] = 'Ανατροφοδότηση';
$string['feedbackupdated'] = 'Η ανατροφοδότηση ενημερώθηκε για \\{$a} άτομα';
$string['field:multiselect'] = 'Πολλαπλή επιλογή';
$string['field:select'] = 'Μενού επιλογών';
$string['field:text'] = 'Κείμενο';
$string['fielddeleteconfirm'] = 'Διαγραφή του πεδίου «{$a}» και όλων των δεδομένων συνόδου που συσχετίζονται με αυτό;';
$string['floor'] = 'Όροφος';
$string['format'] = 'Μορφότυπος';
$string['full'] = 'Η ημερομηνία είναι πλήρως κατειλημμένη';
$string['fullfilter'] = 'Πλήρες';
$string['goback'] = 'Επιστροφή';
$string['guestsno'] = 'Λυπούμαστε! Οι επισκέπτες δεν επιτρέπεται να εγγραφούν σε συνόδους.';
$string['icalendarheading'] = 'Συνημμένα iCalendar';
$string['import'] = 'Εισαγωγή';
$string['info'] = 'Πληροφορίες';
$string['joinwaitlist'] = 'Ένταξη σε λίστα αναμονής';
$string['late'] = '\\{$a} αργά';
$string['location'] = 'Τοποθεσία';
$string['lookfor'] = 'Αναζήτηση';
$string['managecustomfields'] = 'Διαχείριση προσαρμοσμένων πεδίων';
$string['manageradded'] = 'Η διεύθυνση ηλε.ταχυδρομείου του διευθυντή σας έχει γίνει δεκτή.';
$string['managerchanged'] = 'Η διεύθυνση ηλε.ταχυδρομείου του διευθυντή σας έχει αλλάξει.';
$string['manageremail'] = 'Μήνυμα ηλε.ταχυδρομείου διευθυντή';
$string['manageremailaddress'] = 'Διεύθυνση ηλε.ταχυδρομείου διευθυντή';
$string['manageremailformat'] = 'Η διεύθυνση ηλε.ταχυδρομείου πρέπει να έχει μορφότυπο «{$a}» για να γίνει δεκτή.';
$string['manageremailheading'] = 'Διευθύνσεις ηλε.ταχυδρομείου διευθυντών';
$string['manageremailinstructionconfirm'] = 'Παρακαλούμε, επιβεβαιώστε ότι αυτή είναι η διεύθυνση ηλε.ταχυδρομείου του διευθυντή σας:';
$string['managername'] = 'Όνομα διευθυντή';
$string['managerupdated'] = 'Η διεύθυνση ηλε.ταχυδρομείου του διευθυντή σας ενημερώθηκε.';
$string['maximumpoints'] = 'Μέγιστος αριθμός πόντων';
$string['maximumsize'] = 'Μέγιστος αριθμός παρόντων';
$string['modulename'] = 'Κλείσιμο ραντεβού';
$string['modulename_link'] = 'Ραντεβού';
$string['modulenameplural'] = 'Ραντεβού';
$string['moreinfo'] = 'Περισσότερες πληροφορίες';
$string['multidate'] = '(πολλαπλών-ημερομηνιών)';
$string['multipleappointments'] = 'Πολλαπλά ραντεβού';
$string['newmanageremailaddress'] = 'Διεύθυνση ηλε.ταχυδρομείου διευθυντή';
$string['noactionableunapprovedrequests'] = 'Δεν υπάρχουν μη εγκεκριμένες αιτήσεις με δυνατότητα ενέργειας';
$string['noappointments'] = 'Δεν υπάρχει καμία δραστηριότητα ραντεβού';
$string['nocustomfields'] = '<p>Δεν έχει οριστεί κανένα προσαρμοσμένο πεδίο.</p>';
$string['none'] = 'κανένα';
$string['noremindersneedtobesent'] = 'Δεν χρειάζεται να αποσταλεί καμία υπενθύμιση.';
$string['normalcost'] = 'Κανονικό κόστος';
$string['nosignedupusers'] = 'Δεν έχει εγγραφεί κανένας χρήστης για αυτή τη σύνοδο.';
$string['note'] = 'Σημείωση';
$string['notificationboth'] = 'Ειδοποίηση με μήνυμα ηλε.ταχυδρομείου και ραντεβού iCalendar';
$string['notificationemail'] = 'Ειδοποίηση μόνο μέσω ηλε.ταχυδρομείου';
$string['notificationical'] = 'Μόνο ραντεβού iCalendar';
$string['notificationtype'] = 'Τύπος ειδοποίησης';
$string['notset'] = 'Μη ορισμένο';
$string['notsignedup'] = 'Δεν έχετε εγγραφεί για αυτή τη σύνοδο.';
$string['notsubmittedyet'] = 'Δεν αξιολογήθηκε ακόμα';
$string['odsformat'] = 'OpenDocument';
$string['onehour'] = '1 ώρα';
$string['oneminute'] = '1 λεπτό';
$string['options'] = 'Επιλογές';
$string['or'] = 'ή';
$string['order'] = 'Σειρά';
$string['partiallyfull'] = 'Μερικώς πλήρες';
$string['place'] = 'Δωμάτιο';
$string['placeholder:alldates'] = '[alldates]';
$string['placeholder:appointmentname'] = '[appointmentname]';
$string['placeholder:attendeeslink'] = '[attendeeslink]';
$string['placeholder:cost'] = '[cost]';
$string['placeholder:details'] = '[details]';
$string['placeholder:duration'] = '[duration]';
$string['placeholder:finishtime'] = '[finishtime]';
$string['placeholder:firstname'] = '[firstname]';
$string['placeholder:lastname'] = '[lastname]';
$string['placeholder:reminderperiod'] = '[reminderperiod]';
$string['placeholder:sessiondate'] = '[sessiondate]';
$string['placeholder:starttime'] = '[starttime]';
$string['pluginadministration'] = 'Διαχείριση ραντεβού';
$string['pluginname'] = 'Ραντεβού';
$string['points'] = 'Πόντοι';
$string['pointsplural'] = 'Πόντοι';
$string['potentialattendees'] = 'Πιθανοί παρόντες';
$string['printversionid'] = 'Έκδοση εκτύπωσης: χωρίς όνομα';
$string['printversionname'] = 'Έκδοση εκτύπωσης: με όνομα';
$string['privacy:metadata:appointment_signups'] = 'Εγγραφές χρηστών σε συνόδους ραντεβού';
$string['privacy:metadata:appointment_signups:discountcode'] = 'Ο κωδικός έκπτωσης που δόθηκε από τον χρήστη';
$string['privacy:metadata:appointment_signups:id'] = 'Το αναγνωριστικό της εγγραφής';
$string['privacy:metadata:appointment_signups:mailedreminder'] = 'Η ώρα τελευταίας αποστολής υπενθύμισης';
$string['privacy:metadata:appointment_signups:notificationtype'] = 'Πως θα ήθελε ο χρήστης να ειδοποιείται.';
$string['privacy:metadata:appointment_signups:sessionid'] = 'Το αναγνωριστικό συνόδου';
$string['privacy:metadata:appointment_signups_status'] = 'Η κατάσταση μιας εγγραφής χρήστη σε μια σύνοδο';
$string['privacy:metadata:appointment_signups_status:grade'] = 'Ο βαθμός που δίνεται για την παρακολούθηση μιας συνόδου';
$string['privacy:metadata:appointment_signups_status:note'] = 'Αποθηκεύει τον λόγο ακύρωσης μιας συνόδου';
$string['privacy:metadata:appointment_signups_status:signupid'] = 'Το αναγνωριστικό της εγγραφής';
$string['privacy:metadata:appointment_signups_status:statuscode'] = 'Η κατάσταση της εγγραφής, π.χ. ακυρώθηκε, απορρίφθηκε, παρακολουθήθηκε';
$string['privacy:metadata:appointment_signups_status:timecreated'] = 'Η ώρα δημιουργίας της εγγραφής.';
$string['privacy:metadata:roleid'] = 'Το αναγνωριστικό ρόλου του χρήστη.';
$string['privacy:metadata:userid'] = 'Το αναγνωριστικό του χρήστη που είχε πρόσβαση στη δραστηριότητα ραντεβού';
$string['really'] = 'Θέλετε σίγουρα να διαγραφούν όλα τα αποτελέσματα για αυτό το ραντεβού;';
$string['registeredon'] = 'Καταχωρήθηκε στις';
$string['registrations'] = 'Καταχωρήσεις';
$string['reminder'] = 'Υπενθύμιση';
$string['reminderinstrmngr'] = '# Ειδοποίηση για διευθυντή';
$string['reminderinstrmngr_help'] = 'Όταν επιλεγεί **Αποστολή ειδοποίησης στον διευθυντή**, το κείμενο στο πεδίο **Ειδοποίηση για διευθυντή** αποστέλλεται στον διευθυντή ενός μαθητευόμενου, πληροφορώντας τον ότι ο μαθητευόμενος έχει εγγραφεί για μια σύνοδο Ραντεβού.';
$string['remindermessage'] = 'Μήνυμα υπενθύμισης';
$string['reminderperiod'] = 'Ημέρες πριν για αποστολή μηνύματος';
$string['reminderperiod_help'] = 'Το μήνυμα υπενθύμισης θα αποστέλλεται τόσες ημέρες πριν την έναρξη της συνόδου.';
$string['requestmessage'] = 'Μήνυμα αιτήματος';
$string['requeststablesummary'] = 'Άτομα που ζητούν να παρακολουθήσουν αυτή τη σύνοδο.';
$string['room'] = 'Δωμάτιο';
$string['saveallfeedback'] = 'Αποθήκευση όλων των αποκρίσεων';
$string['saveattendance'] = 'Αποθήκευση παρουσιών';
$string['scheduledsession'] = 'Χρονοπρογραμματισμένη σύνοδος';
$string['scheduledsessions'] = 'Χρονοπρογραμματισμένες σύνοδοι';
$string['search:activity'] = 'Δραστηριότητες ραντεβού';
$string['seatsavailable'] = 'Διαθέσιμες θέσεις';
$string['seatsbooked'] = 'Κρατημένες θέσεις';
$string['seeattendees'] = 'Δείτε τους παρόντες';
$string['sentremindermanager'] = 'Αποστολή μηνύματος (ηλε.ταχυδρομείου) υπενθύμισης στον διευθυντή του χρήστη';
$string['sentreminderuser'] = 'Αποστολή μηνύματος (ηλε.ταχυδρομείου) υπενθύμισης στον χρήστη';
$string['sessionavailability'] = 'Διαθεσιμότητα συνόδου';
$string['sessiondate'] = 'Ημερομηνία συνόδου';
$string['sessiondatetime'] = 'Ημερομηνία/ώρα συνόδου';
$string['sessiondescription'] = 'Περιγραφή';
$string['sessionended'] = 'Η σύνοδος τελείωσε:';
$string['sessionfinished'] = 'Τελείωσε';
$string['sessionfinishtime'] = 'Χρόνος λήξης συνόδου';
$string['sessioninprogress'] = 'σύνοδος σε εξέλιξη';
$string['sessionisfull'] = 'Αυτή η σύνοδος είναι αυτή τη στιγμή πλήρης. Θα πρέπει να διαλέξετε μια άλλη ώρα ή να μιλήσετε στον εκπαιδευτή.';
$string['sessionrequiresmanagerapproval'] = 'Για να γίνει κράτηση σε αυτή τη σύνοδο, απαιτείται έγκριση διευθυντή.';
$string['sessionroles'] = 'Ρόλοι συνόδου';
$string['sessions'] = 'Σύνοδοι';
$string['sessionsdetailstablesummary'] = 'Πλήρης περιγραφή της τρέχουσας συνόδου.';
$string['sessionsoncoursepage'] = 'Σύνοδοι που εμφανίζονται στην σελίδα μαθήματος';
$string['sessionsoncoursepage_help'] = 'Αυτός είναι ο αριθμός συνόδων για κάθε δραστηριότητα ραντεβού που θα εμφανίζεται στην κύρια σελίδα του μαθήματος.';
$string['sessionstartdate'] = 'Ημερομηνία έναρξης συνόδου';
$string['sessionstartdateandtime'] = '{$a->startdate}, {$a->starttime} - {$a->endtime} (ζώνη ώρας: {$a->timezone})';
$string['sessionstartdateandtimewithouttimezone'] = '{$a->startdate}, {$a->starttime} - {$a->endtime}';
$string['sessionstartfinishdateandtime'] = '{$a->startdate} - {$a->enddate}, {$a->starttime} - {$a->endtime} (ζώνη ώρας: {$a->timezone})';
$string['sessionstartfinishdateandtimewithouttimezone'] = '{$a->startdate} - {$a->enddate}, {$a->starttime} - {$a->endtime}';
$string['sessionstarttime'] = 'Ώρα έναρξης συνόδου';
$string['sessionvenue'] = 'Τόπος συνόδου';
$string['setting:addchangemanageremail'] = 'Ρωτήστε τους χρήστες για την διεύθυνση ηλε.ταχυδρομείου του διευθυντή τους.';
$string['setting:addchangemanageremail_caption'] = 'Διεύθυνση ηλε.ταχυδρομείου διευθυντή:';
$string['setting:addchangemanageremaildefault'] = 'Ρωτήστε τους χρήστες για την διεύθυνση ηλε.ταχυδρομείου του διευθυντή τους.';
$string['setting:defaultcancellationinstrmngr'] = 'Προεπιλεγμένο μήνυμα ακύρωσης που αποστέλλεται στους διευθυντές.';
$string['setting:defaultcancellationinstrmngr_caption'] = 'Μήνυμα ακύρωσης (διευθυντές).';
$string['setting:defaultcancellationmessage'] = 'Προεπιλεγμένο μήνυμα ακύρωσης που αποστέλλεται στον χρήστη.';
$string['setting:defaultcancellationmessage_caption'] = 'Μήνυμα ακύρωσης';
$string['setting:defaultcancellationsubject'] = 'Προεπιλεγμένη γραμμή θέματος για μηνύματα (ηλε.ταχυδρομείου) ακύρωσης.';
$string['setting:defaultcancellationsubject_caption'] = 'Θέμα ακύρωσης';
$string['setting:defaultcancellationsubjectdefault'] = 'Ακύρωση κράτησης ραντεβού';
$string['setting:defaultconfirmationinstrmngr'] = 'Προεπιλεγμένο μήνυμα επιβεβαίωσης που αποστέλλεται στους διευθυντές.';
$string['setting:defaultconfirmationinstrmngr_caption'] = 'Μήνυμα επιβεβαίωσης (διευθυντές)';
$string['setting:defaultconfirmationmessage'] = 'Προεπιλεγμένο μήνυμα επιβεβαίωσης που αποστέλλεται στους χρήστες.';
$string['setting:defaultconfirmationmessage_caption'] = 'Μήνυμα επιβεβαίωσης';
$string['setting:defaultconfirmationsubject'] = 'Προεπιλεγμένη γραμμή θέματος για μηνύματα (ηλε.ταχυδρομείου) επιβεβαίωσης.';
$string['setting:defaultconfirmationsubject_caption'] = 'Θέμα επιβεβαίωσης';
$string['setting:defaultconfirmationsubjectdefault'] = 'Επιβεβαίωση κράτησης ραντεβού: [appointmentname], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultreminderinstrmngr'] = 'Προεπιλεγμένο μήνυμα υπενθύμισης που αποστέλλεται στους διευθυντές.';
$string['setting:defaultreminderinstrmngr_caption'] = 'Μήνυμα υπενθύμισης (διευθυντές)';
$string['setting:defaultremindermessage'] = 'Προεπιλεγμένο μήνυμα (ηλε.ταχυδρομείου) υπενθύμισης που αποστέλλεται στους χρήστες.';
$string['setting:defaultremindermessage_caption'] = 'Μήνυμα υπενθύμισης';
$string['setting:defaultremindersubject'] = 'Προεπιλεγμένη γραμμή θέματος για τα μηνύματα (ηλε.ταχυδρομείου) υπενθύμισης που αποστέλονται στους χρήστες.';
$string['setting:defaultremindersubject_caption'] = 'Θέμα υπενθύμισης';
$string['setting:defaultremindersubjectdefault'] = 'Υπενθύμιση κράτησης ραντεβού: [appointmentname], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultrequestsubjectdefault'] = 'Αίτημα κράτησης ραντεβού: [appointmentname], [starttime]-[finishtime]';
$string['setting:defaultvalue'] = 'Προεπιλεγμένη τιμή';
$string['setting:defaultwaitlistedmessage'] = 'Προεπιλεγμένη επιβεβαίωση ένταξης σε λίστα αναμονής για αποστολή προς χρήστες.';
$string['setting:defaultwaitlistedmessage_caption'] = 'Επιβεβαίωση ένταξης σε λίστα αναμονής';
$string['setting:defaultwaitlistedsubject'] = 'Προεπιλεγμένη γραμμή θέματος για μηνύματα ηλε.ταχυδρομείου λίστας αναμονής';
$string['setting:defaultwaitlistedsubject_caption'] = 'Θέμα (μηνύματος) λίστας αναμονής';
$string['setting:defaultwaitlistedsubjectdefault'] = 'Συμβουλή λίστας αναμονής για [appointmentname]';
$string['setting:disableicalcancel'] = 'Απενεργοποίηση μηνυμάτων ηλε.ταχυδρομείου με συνημμένο iCalendar.';
$string['setting:disableicalcancel_caption'] = 'Απενεργοποίηση ακυρώσεων iCalendar:';
$string['setting:fromaddress'] = 'Τι θα εμφανίζεται στο πεδίο Από των μηνυμάτων (ηλε.ταχυδρομείου) υπενθύμισης που αποστέλλονται από αυτό το άρθρωμα.';
$string['setting:fromaddress_caption'] = 'Διεύθυνση αποστολέα:';
$string['setting:fromaddressdefault'] = 'moodle@example.com';
$string['setting:hidecost'] = 'Απόκρυψη των πεδίων κόστους και κωδικού έκπτωσης.';
$string['setting:hidecost_caption'] = 'Απόκρυψη του κόστους και της έκπτωσης:';
$string['setting:hidediscount'] = 'Απόκρυψη μόνο του πεδίου κωδικού έκπτωσης.';
$string['setting:hidediscount_caption'] = 'Απόκρυψη έκπτωσης:';
$string['setting:isfilter'] = 'Εμφάνιση ως ένα φίλτρο';
$string['setting:manageraddressformat'] = 'Πρόθεμα το οποίο πρέπει να υπάρχει στην διεύθυνση ηλε.ταχυδρομείου του διευθυντή για να θεωρηθεί έγκυρη.';
$string['setting:manageraddressformat_caption'] = 'Απαιτούμενο πρόθεμα:';
$string['setting:manageraddressformatreadable'] = 'Σύντομη περιγραφή των περιορισμών στη διεύθυνση ηλε.ταχυδρομείου του διαχειριστή. Αυτή η ρύθμιση δεν έχει αποτέλεσμα εάν η προηγούμενη δεν έχει οριστεί.';
$string['setting:manageraddressformatreadable_caption'] = 'Παράδειγμα μορφότυπου:';
$string['setting:manageraddressformatreadabledefault'] = 'onoma.eponimo@etairia.gr';
$string['setting:oneemailperday'] = 'Αποστολή πολλαπλών επιβεβαιωτικών μηνυμάτων ηλε.ταχυδρομείου για γεγονότα πολλαπλών ημερών.';
$string['setting:oneemailperday_caption'] = 'Ένα μήνυμα ανά ημέρα:';
$string['setting:possiblevalues'] = 'Λίστα πιθανών τιμών';
$string['setting:sessionroles'] = 'Το σε ποιούς χρήστες ανατίθενται οι επιλεγμένοι ρόλοι σε ένα μάθημα, μπορεί να παρακολουθείται μέσω κάθε συνόδου ραντεβού';
$string['setting:sessionroles_caption'] = 'Ρόλοι συνόδου:';
$string['setting:showinsummary'] = 'Εμφάνιση στις εξαγωγές και τις λίστες';
$string['setting:type'] = 'Τύπος πεδίου';
$string['settings'] = 'Ρυθμίσεις';
$string['shortname'] = '# Σύντομο Όνομα';
$string['showbylocation'] = 'Εμφάνιση κατά τοποθεσία';
$string['showoncalendar'] = 'Ρυθμίσεις εμφάνισης ημερολογίου';
$string['sign-ups'] = 'Εγγραφές';
$string['signup'] = 'Εγγραφείτε';
$string['signupfor'] = 'Εγγραφείτε για {$a}';
$string['signupforsession'] = 'Εγγραφείτε για μια διαθέσιμη επερχόμενη σύνοδο';
$string['signupforthissession'] = 'Εγγραφείτε για αυτή τη σύνοδο ραντεβού';
$string['signups'] = 'Εγγραφές';
$string['split'] = 'Αυτόματος διαχωρισμός';
$string['status'] = 'Κατάσταση';
$string['status_approved'] = 'Εγκρίθηκε';
$string['status_booked'] = 'Σε κράτηση';
$string['status_declined'] = 'Απορρίφθηκε';
$string['status_fully_attended'] = 'Πλήρης παρακολούθηση';
$string['status_no_show'] = 'Απουσία';
$string['status_partially_attended'] = 'Μερική παρακολούθηση';
$string['status_requested'] = 'Ζητήθηκε';
$string['status_session_cancelled'] = 'Ακύρωση συνόδου';
$string['status_user_cancelled'] = 'Ακύρωση χρήστη';
$string['status_waitlisted'] = 'Σε λίστα αναμονής';
$string['submissions'] = 'Υποβολές';
$string['submit'] = 'Υποβολή';
$string['submitted'] = 'Υποβλήθηκε';
$string['summary'] = 'Περίληψη';
$string['suppressemail'] = 'Καταστολή ειδοποποίησης μέσω ηλε.ταχυδρομείου';
$string['suppressemail_help'] = 'Χρησιμοποιήστε αυτή την επιλογή αν θέλετε να προσθέσετε/αφαιρέσετε σιωπηλά χρήστες σε/από μια σύνοδο Ραντεβού. Όταν επιλεγεί αυτή η επιλογή, τότε η συνήθης επιβεβαίωση μέσω ηλε.ταχυδρομείου, δεν αποστέλεται στους επιλεγμένους χρήστες.';
$string['takeattendance'] = 'Δήλωση παρουσιών';
$string['thirdpartyemailaddress'] = 'Διεύθυνση/-σεις ηλε.ταχυδρομείου τρίτου-μέρους';
$string['thirdpartyemailaddress_help'] = '**Διεύθυνση/-σεις ηλε.ταχυδρομείου τρίτου-μέρους** είναι ένα προαιρετικό πεδίο που χρησιμοποιείται για τον καθορισμό της διεύθυνσης ηλε.ταχυδρομείου ενός τρίτου μέρους (όπως π.χ. ενός εξωτερικού εκπαιδευτή) ο οποίος στη συνέχεια θα λαμβάνει μηνύματα επιβεβαίωσης κάθε φορά που ένας χρήστης εγγράφεται για μια σύνοδο.
Αν εισαχθούν **Πολλαπλές διευθύνσεις ηλε.ταχυδρομείου**, πρέπει να διαχωρίζονται με κόμμα. Για παράδειγμα: giannis@paradeigma.gr,stamos@paradeigma.gr';
$string['thirdpartywaitlist'] = 'Ειδοποίηση τρίτου-μέρους για συνόδους με λίστα αναμονής';
$string['thirdpartywaitlist_help'] = 'Αν επιλεγεί **Ειδοποίηση τρίτου-μέρους για συνόδους με λίστα αναμονής**, τότε όταν ένας μαθητής εγγραφεί για μια σύνοδο με λίστα αναμονής, θα ειδοποιείται το τρίτο μέρος. Αν δεν επιλεγεί **Ειδοποίηση τρίτου-μέρους για συνόδους με λίστα αναμονής**, το/τα τρίτα μέρη θα ειδοποιούνται μόνο όταν ένας χρήστης εγγραφεί (ή ακυρώσει) για μια προγραμματισμένη σύνοδο.';
$string['time'] = 'Ώρα';
$string['timecancelled'] = 'Ώρα ακύρωσης';
$string['timedue'] = 'Προθεσμία λήξης καταχώρησης';
$string['timefinish'] = 'Ώρα λήξης';
$string['timefinish_help'] = 'Ώρα λήξης είναι η ώρα κατά την οποία λήγει η σύνοδος.';
$string['timeframes'] = 'Χρονικά πλαίσια';
$string['timerequested'] = 'Ώρα που ζητήθηκε';
$string['timesignedup'] = 'Ώρα που εγγράφηκε';
$string['timestart'] = 'Ώρα έναρξης';
$string['timestart_help'] = 'Ώρα έναρξης είναι η ώρα κατά την οποία η σύνοδος αρχίζει.';
$string['unapprovedrequests'] = 'Μη εγκεκριμένα αιτήματα';
$string['unknowndate'] = '(άγνωστη ημερομηνία)';
$string['unknowntime'] = '(άγνωστη ώρα)';
$string['updaterequests'] = 'Αιτήματα ενημέρωσης';
$string['upgradeprocessinggrades'] = 'Επεξεργασία βαθμών ραντεβού, αυτό μπορεί να διαρκέσει αρκετά αν υπάρχουν πολλές σύνοδοι...';
$string['usercalentry'] = 'Εμφάνιση καταχώρησης στο ημερολόγιο του χρήστη';
$string['usercancelledon'] = 'Ακύρωση χρήστη στις {$a}';
$string['userdeletedcancel'] = 'Ο χρήστης διαγράφηκε';
$string['usernotsignedup'] = 'Κατάσταση: μη εγγεγραμμένος';
$string['usersignedup'] = 'Κατάσταση: εγγεγραμμένος';
$string['usersignedupon'] = 'Ο χρήστης εγγράφηκε στις {$a}';
$string['validation:needatleastonedate'] = 'Πρέπει να δώσετε τουλάχιστον μία ημερομηνία ή να επισημάνετε τη σύνοδο ως σύνοδο με λίστα αναμονής.';
$string['venue'] = 'Τόπος';
$string['venue_help'] = '**Τόπος** είναι το κτήριο στο οποίο θα λάβει χώρα η σύνοδος.

Ο **Τόπος** εμφανίζεται στην σελίδα «Εγγραφή», την σελίδα «Εμφάνιση όλων των συνόδων» και σε όλες τις ειδοποιήσεις με μηνύματα ηλε.ταχυδρομείου.';
$string['viewallsessions'] = 'Εμφάνιση όλων των συνόδων';
$string['viewsubmissions'] = 'Εμφάνιση υποβολών';
$string['wait-list'] = 'Λίστα αναμονής';
$string['wait-listed'] = 'Σε λίστα αναμονής';
$string['waitlistedmessage'] = 'Μήνυμα για λίστα αναμονής';
$string['waitlistedmessage_help'] = 'Αυτό το μήνυμα αποστέλλεται κάθε φορά που οι χρήστες εγγράφονται σε μια σύνοδο με λίστα αναμονής.';
$string['waitliststatus'] = 'Έχετε μια θέση στη λίστα αναμονής της ακόλουθης συνόδου';
$string['xhours'] = '{$a} ώρες';
$string['xminutes'] = '{$a} λεπτά';
$string['youarebooked'] = 'Έχετε κράτηση για την επόμενη σύνοδο';
$string['youremailaddress'] = 'Η διεύθυνση ηλε.ταχυδρομείου σας';
