<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_moodlebox', language 'el', version '3.11'.
 *
 * @package     tool_moodlebox
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['badpowersupply'] = '<p><b>Προειδοποίηση: Εντοπίστηκε χαμηλή τάση!</b> Η τροφοδοσία του MoodleBox είναι ανεπαρκής, γεγονός που μπορεί να προκαλέσει διάφορα προβλήματα, για παράδειγμα περιορισμό του αριθμού των πελατών Wi-Fi ή ακόμη και μη αναμενόμενο κλείσιμο τη συσκευή.</p><p>Συνιστάται ανεπιφύλακτα να <b>αλλάζετε το τροφοδοτικό</b>, προτιμώντας το <a href="https://www.raspberrypi.org/products/raspberry-pi-universal-power-supply/" target="_blank">επίσημο τροφοδοτικό του Raspberry Foundation</a> και να χρησιμοποιήσετε ένα καλώδιο καλής ποιότητας για να το συνδέσετε με το MoodleBox.</p>';
$string['changepassworderror'] = 'Ο κωδικός πρόσβασης στο MoodleBox δεν άλλαξε. Οι κωδικοί πρόσβασης που δόθηκαν δεν ταιριάζουν.';
$string['changepasswordmessage'] = 'Ο κύριος κωδικός πρόσβασης του MoodleBox (λογαριασμός Unix) και του εξυπηρετητή βάσης δεδομένων άλλαξε με επιτυχία.<br /><br />Προειδοποίηση! Ο κωδικός πρόσβασης του προεπιλεγμένου χρήστη Moodle <b>δεν άλλαξε</b>. Για να τον αλλάξετε, παρακαλούμε, χρησιμοποιήστε τη σελίδα προτιμήσεων αυτού του χρήστη.';
$string['changewifisettings'] = 'Αλλαγή ρυθμίσεων Wi-Fi';
$string['configuration'] = 'Ρυθίσεις MoodleBox';
$string['cpufrequency'] = 'Συχνότητα CPU';
$string['cpuload'] = 'Φορτίο CPU';
$string['cputemperature'] = 'Θερμοκρασία CPU';
$string['dashboard'] = 'Ταμπλό MoodleBox';
$string['datetime'] = 'Ημερομηνία και ώρα';
$string['datetime_help'] = 'Εάν το MoodleBox δεν είναι συνδεδεμένο στο Διαδίκτυο, δεν θα έχει σωστή ώρα. Μπορεί να ρυθμιστεί χειροκίνητα χρησιμοποιώντας αυτήν τη ρύθμιση.';
$string['datetimemessage'] = 'Το ρολόι του MoodleBox ρυθμίστηκε. Για μεγαλύτερη ακρίβεια, συνιστάται η σύνδεση του MoodleBox σε δίκτυο συνδεδεμένο στο Διαδίκτυο μέσω καλωδίου ethernet.';
$string['datetimeset'] = 'Ορισμός ημερομηνίας και ώρας';
$string['datetimesetmessage'] = 'Το ρολόι του MoodleBox δεν έχει σωστή ώρα. Συνιστάται ιδιαίτερα να ορίσετε την τρέχουσα ημερομηνία και ώρα.';
$string['datetimesetting'] = 'Ημερομηνία και ώρα';
$string['defaultgateway'] = 'Προεπιλεγμένη πύλη';
$string['dhcpclientinfo'] = 'Διεύθυνση IP και όνομα πελάτη (πρόγραμμα)';
$string['dhcpclientnumber'] = 'αριθμός πελατών';
$string['dhcpclients'] = 'Πελάτες DHCP';
$string['documentation'] = 'Τεκμηρίωση MoodleBox';
$string['documentation_desc'] = '<p>Για ερωτήσεις υποστήριξης, περιηγηθείτε στην πλήρη <a href="https://moodlebox.net/en/help/" title="Τεκμηρίωση του MoodleBox" target="_blank">τεκμηρίωση του MoodleBox</a>.</p>';
$string['dynamicipaddress'] = 'Διεύθυνση IP (δυναμική)';
$string['ethernetdisconnected'] = 'Το Ethernet αποσυνδέθηκε';
$string['forum'] = 'Φόρουμ υποστήριξης MoodleBox';
$string['forum_desc'] = '<p>Αν δεν μπορείτε να βρείτε μια απάντηση στην ερώτησή σας στην <a href="https://moodlebox.net/en/help/" title="Τεκμηρίωση του MoodleBox" target="_blank">τεκμηρίωση του MoodleBox</a>, πραγματοποιήστε αναζήτηση στο <a href="https://discuss.moodlebox.net/" title="Φόρουμ MoodleBox" target="_blank">φόρουμ υποστήριξης MoodleBox< / a> για να δείτε αν η ερώτησή σας έχει ήδη απαντηθεί. Διαφορετικά, μπορείτε να ανοίξετε μια νέα συζήτηση.</p>';
$string['hidden'] = 'Σε απόκρυψη';
$string['ihavedonated'] = 'Έχω δωρίσει! 🎉';
$string['ihavedonated_desc'] = 'Επιλέξτε αυτό το πλαίσιο εάν <a href="https://moodlebox.net/en/donate/" title="Πραγματοποίηση δωρεάς" target="_blank"> έχετε κάνει δωρεά</a> στο έργο MoodleBox.<br />Αυτή η ρύθμιση δεν έχει καμία επίδραση. Σας επιτρέπει απλά να δείξετε την υπερηφάνειά σας για τη συνεισφορά σας στο <a href="https://moodlebox.net/en/" title="Ιστότοπος MoodleBox" target="_blank">έργο MoodleBox</a>. Πολλές ευχαριστίες!';
$string['infofileerror'] = 'Μη διαθέσιμες πληροφορίες';
$string['infoheading'] = 'Πληροφορίες υποστήριξης MoodleBox';
$string['information'] = 'Πληροφορίες';
$string['interfacename'] = 'Όνομα διεπαφής';
$string['ipaddress'] = 'Διεύθυνση IP';
$string['kernelversion'] = 'Έκδοση πυρήνα';
$string['missingconfigurationerror'] = 'Αυτή η ενότητα δεν είναι διαθέσιμη. Η εγκατάσταση του πρόσθετου δεν έχει ολοκληρωθεί, επομένως δεν είναι δυνατή η διαχείριση της ρύθμισης από το MoodleBox. Παρακαλούμε, διαβάστε την <a href="https://github.com/moodlebox/moodle-tool_moodlebox/blob/master/README.md" target="_blank">τεκμηρίωση εγκατάστασης</a> για να διορθώσετε αυτό το σφάλμα.';
$string['moodlebox:viewbuttonsinfooter'] = 'Εμφάνιση πλήκτρων επανεκκίνησης και τερματισμού στο υποσέλιδο';
$string['moodleboxsysteminfo'] = 'Πληροφορίες MoodleBox';
$string['moodleboxsysteminfo_help'] = 'Το ταμπλό πληροφοριών MoodleBox εμφανίζει αρκετά σημαντικά δεδομένα σχετικά με το MoodleBox. Αυτές οι πληροφορίες περιλαμβάνουν:

* Κρίσιμες λεπτομέρειες λειτουργίας MoodleBox, όπως υπόλοιπο χώρο δίσκου στην κάρτα SD και φορτίο επεξεργαστή, θερμοκρασία και συχνότητα
 * Τρέχουσες ρυθμίσεις δικτύου Wi-Fi που παρέχονται από το MoodleBox
 * Αριθμός, διεύθυνση IP και όνομα όλων των συσκευών που είναι συνδεδεμένες στο MoodleBox
 * Μοντέλο Raspberry Pi και έκδοση λειτουργικού συστήματος
 * Έκδοση MoodleBox και έκδοση πρόσθετου MoodleBox';
$string['networkinterface'] = 'Καλωδιακή διασύνδεση δικτύου';
$string['parameter'] = 'Παράμετρος';
$string['passwordprotected'] = 'Προστατευμένο με κωδικό πρόσβασης';
$string['passwordsetting'] = 'Κωδικός πρόσβασης MoodleBox';
$string['passwordsetting_help'] = 'Ο κύριος κωδικός πρόσβασης στο MoodleBox μπορεί να αλλάξει εδώ. __Δεν συνιστάται καθόλου να διατηρήσετε τον προεπιλεγμένο κωδικό πρόσβασης__.  __Πρέπει__ οπωσδήποτε να τον αλλάξετε ως ελάχιστο μέτρο ασφαλείας.';
$string['pijuicebatterychargelevel'] = 'Επίπεδο φόρτισης PiJuice';
$string['pijuicebatterystatus'] = 'Κατάσταση μπαταρίας PiJuice';
$string['pijuicebatterytemp'] = 'Θερμοκρασία μπαταρίας PiJuice';
$string['pijuiceinfo'] = 'Πληροφορίες κατάστασης PiJuice';
$string['pijuiceisfault'] = 'Σφάλμα PiJuice';
$string['pijuicestatuserror'] = 'Κατάσταση PiJuice';
$string['pluginname'] = 'MoodleBox';
$string['pluginversion'] = 'Έκδοση πρόσθετου MoodleBox';
$string['privacy:metadata'] = 'Το πρόσθετο MoodleBox εμφανίζει πληροφορίες από το Raspberry Pi και επιτρέπει ορισμένες αλλαγές στη διαμόρφωση, αλλά δεν επηρεάζει ούτε αποθηκεύει το ίδιο οποιαδήποτε προσωπικά δεδομένα.';
$string['projectinfo'] = '<p>Το <a href="https://moodlebox.net/en/" title="Ιστότοπος MoodleBox" target="_blank">έργο MoodleBox</a> είναι εθελοντικό, μη-κερδοσκοπικό και ανοιχτού κώδικα που πραγματοποιήθηκε από τον <a href="https://blog.martignoni.net/a-propos/" title="Nicolas Martignoni" target="_blank">Nicolas Martignoni</ a> στον ελεύθερο χρόνο του.</p><p>Σας ευχαριστούμε που χρησιμοποιείτε το MoodleBox. Μπορείτε να δείξετε την εκτίμησή σας και να υποστηρίξετε αυτό το έργο <a href="https://moodlebox.net/en/donate/" title="Πραγματοποιήστε μια δωρεά" target="_blank">κάνοντας μια δωρεά</a>❤. Η δωρεά σας θα βοηθήσει στη χρηματοδότηση του εξοπλισμού που απαιτείται για την ανάπτυξη του MoodleBox και την φιλοξενία της τεκμηρίωσής του.</p>';
$string['raspberryhardware'] = 'Μοντέλο Raspberry Pi';
$string['raspbianversion'] = 'Έκδοση Raspbian';
$string['resizepartition'] = 'Αλλαγή μεγέθους διαμέρισης κάρτας SD';
$string['resizepartition_help'] = 'Χρήση αυτού του πλήκτρου για αλλαγή μεγέθους διαμέρισης κάρτας SD.';
$string['resizepartitionmessage'] = 'Η διαμέριση της κάρτας SD έχει αλλάξει μέγεθος στο μέγιστό της μέγεθος. Το MoodleBox κάνει επανεκκίνηση τώρα. Θα είναι ξανά διαθέσιμο εντός σύνδεσης σε λίγο.';
$string['resizepartitionsetting'] = 'Αλλαγή μεγέθους διαμέρισης κάρτας SD';
$string['restart'] = 'Επανεκκίνηση MoodleBox';
$string['restartmessage'] = 'Το MoodleBox επανεκκινείται. Θα είναι πάλι εντός σύνδεσης σε λίγο.';
$string['restartstop'] = 'Επανεκκίνηση και τερματισμός';
$string['restartstop_help'] = 'Χρησιμοποιήστε αυτά τα πλήκτρα για επανεκκίνηση ή απενεργοποίηση του MoodleBox. Συνιστάται ιδιαίτερα να μην αποσυνδέετε το τροφοδοτικό για να κλείσετε το MoodleBox.';
$string['rpi1'] = 'Raspberry Pi 1';
$string['rpi2'] = 'Raspberry Pi 2B';
$string['rpi3aplus'] = 'Raspberry Pi 3A+';
$string['rpi3b'] = 'Raspberry Pi 3B';
$string['rpi3bplus'] = 'Raspberry Pi 3B+';
$string['rpi400'] = 'Raspberry Pi 400';
$string['rpi4eightgb'] = 'Raspberry Pi 4B (8 GB RAM)';
$string['rpi4fourgb'] = 'Raspberry Pi 4B (4 GB RAM)';
$string['rpi4onegb'] = 'Raspberry Pi 4B (1 GB RAM)';
$string['rpi4twogb'] = 'Raspberry Pi 4B (2 GB RAM)';
$string['rpiosversion'] = 'Έκδοση Raspberry Pi OS';
$string['rpizerow'] = 'Raspberry Pi Zero W';
$string['sdcardavailablespace'] = 'Ελεύθερος χώρος στην κάρτα SD';
$string['showbuttonsinfooter'] = 'Εμφάνιση πλήκτρων στο υποσέλιδο';
$string['showbuttonsinfooter_desc'] = 'Εάν ενεργοποιηθεί, τα πλήκτρα επανεκκίνησης και τερματισμού εμφανίζονται στο υποσέλιδο όλων των σελίδων του ιστότοπου όταν συνδέεστε ως διαχειριστής ή ως διευθυντής.';
$string['shutdown'] = 'Τερματισμός MoodleBox';
$string['shutdownmessage'] = 'Το MoodleBox απενεργοποιείται. Παρακαλούμε, περιμένετε λίγα δευτερόλεπτα πριν αποσυνδέσετε το τροφοδοτικό.';
$string['softwareversions'] = 'Εκδόσεις λογισμικού';
$string['staticipaddress'] = 'Διεύθυνση IP (στατική)';
$string['staticipaddress_help'] = 'Αυτή είναι η στατική διεύθυνση IP του σημείου πρόσβασης Wi-Fi MoodleBox. Καθορίζει επίσης το εύρος DHCP των διευθύνσεων IP που παρέχονται σε (συσκευές) πελάτες Wi-Fi. Πρέπει να είναι μια έγκυρη <strong>ιδιωτική</strong> διεύθυνση IP, π.χ. «10.10.1.1», «172.23.222.1» ή «192.168.222.1». Το τελευταίο τμήμα/αριθμός θα είναι αναγκαστικά το 1.';
$string['staticipaddressinvalid'] = 'Αυτή η διεύθυνση IP δεν είναι έγκυρη. Πρέπει να είναι έγκυρη <strong>ιδιωτική</strong> διεύθυνση IP, π.χ. «10.10.1.1», «172.23.222.1» ή «192.168.222.1».';
$string['systeminfo'] = 'Πληροφορίες συστήματος';
$string['undervoltagedetected'] = '<p><b>Προειδοποίηση: Εντοπίστηκε χαμηλή τάση!</b> Η τροφοδοσία του MoodleBox είναι ανεπαρκής, γεγονός που μπορεί να προκαλέσει διάφορα προβλήματα, για παράδειγμα περιορισμό του αριθμού των πελατών Wi-Fi ή ακόμη και μη αναμενόμενη απενεργοποίηση της συσκευής.</p><p>Συνιστάται ανεπιφύλακτα να <b>αλλάζετε το τροφοδοτικό</b>, προτιμώντας το <a href="https://www.raspberrypi.org/products/raspberry-pi-universal-power-supply/" target="_blank">επίσημο τροφοδοτικό του Raspberry Foundation</a> και να χρησιμοποιήσετε ένα καλώδιο καλής ποιότητας για να το συνδέσετε με το MoodleBox.</p>';
$string['undervoltageoccurred'] = '<p>Παρουσιάστηκε μια κατάσταση χαμηλής-τάσης από την τελευταία εκκίνηση του MoodleBox. Αυτό θα μπορούσε να δείχνει ότι η τροφοδοσία του MoodleBox είναι ανεπαρκής, γεγονός που μπορεί να προκαλέσει διάφορα προβλήματα, για παράδειγμα περιορισμό του αριθμού των πελατών Wi-Fi ή ακόμη και μη αναμενόμενη απενεργοποίηση της συσκευής.</p><p>Συνιστάται ανεπιφύλακτα να <b>αλλάξετε το τροφοδοτικό</b>, προτιμώντας το <a href="https://www.raspberrypi.org/products/raspberry-pi-universal-power-supply/" target="_blank"> επίσημο τροφοδοτικό του Raspberry Foundation</a> και να χρησιμοποιήσετε ένα καλής ποιότητας καλώδιο για να το συνδέσετε με το MoodleBox.</p>';
$string['unknownmodel'] = 'Άγνωστο μοντέλο Raspberry Pi';
$string['unsupportedhardware'] = 'Εντοπίστηκε μη υποστηριζόμενο υλικό διακομιστή! Αυτό το πρόσθετο λειτουργεί μόνο στο Raspberry Pi';
$string['uptime'] = 'Χρόνος λειτουργίας συστήματος';
$string['version'] = 'Έκδοση MoodleBox';
$string['visible'] = 'Ορατό';
$string['wifichannel'] = 'Κανάλι Wi-Fi';
$string['wifichannel_help'] = 'Δεν είναι απαραίτητο να αλλαχτεί το κανάλι εκπομπής Wi-Fi, εκτός αν η απόδοση είναι χαμηλή λόγω παρεμβολών.';
$string['wificountry'] = 'Ρυθμιστική χώρα Wi-Fi';
$string['wificountry_help'] = 'Για νομικούς λόγους, συνιστάται να ορίσετε τη χώρα σας ως ρυθμιστική χώρα Wi-Fi.';
$string['wifipassword'] = 'Κωδικός πρόσβασης Wi-Fi';
$string['wifipassword_help'] = 'Εάν έχετε επιλέξει ένα δίκτυο Wi-Fi με κωδικό πρόσβασης, για να αποτρέψετε τους εισβολείς από τη χρήση του δικτύου Wi-Fi MoodleBox, συνιστάται να αλλάξετε τον προεπιλεγμένο κωδικό πρόσβασης. Ο κωδικός πρόσβασης δικτύου Wi-Fi πρέπει να περιέχει μεταξύ 8 και 63 εκτυπώσιμους χαρακτήρες ASCII (κεφαλαία και πεζά γράμματα, ψηφία, σημεία στίξης και λίγα άλλα σύμβολα).';
$string['wifipasswordinvalid'] = 'Ο κωδικός πρόσβασης δικτύου Wi-Fi δεν είναι έγκυρος. Πρέπει να έχει μεταξύ 8 και 63 εκτυπώσιμους χαρακτήρες ASCII (κεφαλαία και πεζά γράμματα, ψηφία, σημεία στίξης και λίγα άλλα σύμβολα).';
$string['wifipasswordon'] = 'Προστασία δικτύου Wi-Fi';
$string['wifipasswordon_help'] = 'Εάν ενεργοποιηθεί, οι χρήστες πρέπει να πληκτρολογούν έναν κωδικό πρόσβασης για να συνδεθούν στο δίκτυο Wi-Fi του MoodleBox.';
$string['wifisettings'] = 'Ρυθμίσεις Wi-Fi';
$string['wifisettingserror'] = 'Οι ρυθμίσεις Wi-Fi δεν άλλαξαν. Ορισμένες ρυθμίσεις δεν είναι έγκυρες.';
$string['wifisettingsmessage'] = 'Οι ρυθμίσεις Wi-Fi έχουν αλλάξει. Μην ξεχάσετε να ανακοινώσετε στους μαθητές σας το νέο SSID και τον νέο κωδικό πρόσβασης.';
$string['wifissid'] = 'Όνομα δικτύου Wi-Fi';
$string['wifissid_help'] = 'Το όνομα (SSID) του δικτύου Wi-Fi του MoodleBox. Πρέπει να είναι μια συμβολοσειρά από 1 μέχρι 32 byte. Θυμηθείτε ότι μερικοί χαρακτήρες, όπως τα εμότζι, χρησιμοποιούν περισσότερα από 1 byte.';
$string['wifissidhidden'] = 'Απόκρυψη δικτύου Wi-Fi';
$string['wifissidhiddenstate'] = 'Ορατότητα SSID του Wi-Fi';
$string['wifissidhiddenstate_help'] = 'Εάν ενεργοποιηθεί, το SSID Wi-Fi θα αποκρύπτεται από χρήστες, οι οποίοι δεν θα γνωρίζουν ότι υπάρχει MoodleBox. Αυτό θα μειώσει σημαντικά τη χρηστικότητα της συσκευής, αλλά θα βελτιώσει ελαφρώς την ασφάλειά της.';
$string['wifissidinvalid'] = 'Το όνομα του παρεχόμενου δικτύου Wi-Fi (SSID) δεν είναι έγκυρο. Πρέπει να είναι μια συμβολοσειρά τουλάχιστον 1 byte και το πολύ 32 byte.';
